// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get code security configurations for an enterprise
    ///
    /// Lists all code security configurations available in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/get(code-security/get-configurations-for-enterprise)`.
    func codeSecurityGetConfigurationsForEnterprise(_ input: Operations.CodeSecurityGetConfigurationsForEnterprise.Input) async throws -> Operations.CodeSecurityGetConfigurationsForEnterprise.Output
    /// Create a code security configuration for an enterprise
    ///
    /// Creates a code security configuration in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)`.
    func codeSecurityCreateConfigurationForEnterprise(_ input: Operations.CodeSecurityCreateConfigurationForEnterprise.Input) async throws -> Operations.CodeSecurityCreateConfigurationForEnterprise.Output
    /// Get default code security configurations for an enterprise
    ///
    /// Lists the default code security configurations for an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/defaults`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/defaults/get(code-security/get-default-configurations-for-enterprise)`.
    func codeSecurityGetDefaultConfigurationsForEnterprise(_ input: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input) async throws -> Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Output
    /// Retrieve a code security configuration of an enterprise
    ///
    /// Gets a code security configuration available in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)`.
    func codeSecurityGetSingleConfigurationForEnterprise(_ input: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input) async throws -> Operations.CodeSecurityGetSingleConfigurationForEnterprise.Output
    /// Update a custom code security configuration for an enterprise
    ///
    /// Updates a code security configuration in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)`.
    func codeSecurityUpdateEnterpriseConfiguration(_ input: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input) async throws -> Operations.CodeSecurityUpdateEnterpriseConfiguration.Output
    /// Delete a code security configuration for an enterprise
    ///
    /// Deletes a code security configuration from an enterprise.
    /// Repositories attached to the configuration will retain their settings but will no longer be associated with
    /// the configuration.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)`.
    func codeSecurityDeleteConfigurationForEnterprise(_ input: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input) async throws -> Operations.CodeSecurityDeleteConfigurationForEnterprise.Output
    /// Attach an enterprise configuration to repositories
    ///
    /// Attaches an enterprise code security configuration to repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.
    ///
    /// If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)`.
    func codeSecurityAttachEnterpriseConfiguration(_ input: Operations.CodeSecurityAttachEnterpriseConfiguration.Input) async throws -> Operations.CodeSecurityAttachEnterpriseConfiguration.Output
    /// Set a code security configuration as a default for an enterprise
    ///
    /// Sets a code security configuration as a default to be applied to new repositories in your enterprise.
    ///
    /// This configuration will be applied by default to the matching repository type when created, but only for organizations within the enterprise that do not already have a default code security configuration set.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default-for-enterprise)`.
    func codeSecuritySetConfigurationAsDefaultForEnterprise(_ input: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input) async throws -> Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output
    /// Get repositories associated with an enterprise code security configuration
    ///
    /// Lists the repositories associated with an enterprise code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-enterprise-configuration)`.
    func codeSecurityGetRepositoriesForEnterpriseConfiguration(_ input: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input) async throws -> Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Output
    /// Get code security configurations for an organization
    ///
    /// Lists all code security configurations available in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/get(code-security/get-configurations-for-org)`.
    func codeSecurityGetConfigurationsForOrg(_ input: Operations.CodeSecurityGetConfigurationsForOrg.Input) async throws -> Operations.CodeSecurityGetConfigurationsForOrg.Output
    /// Create a code security configuration
    ///
    /// Creates a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/post(code-security/create-configuration)`.
    func codeSecurityCreateConfiguration(_ input: Operations.CodeSecurityCreateConfiguration.Input) async throws -> Operations.CodeSecurityCreateConfiguration.Output
    /// Get default code security configurations
    ///
    /// Lists the default code security configurations for an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/defaults`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)`.
    func codeSecurityGetDefaultConfigurations(_ input: Operations.CodeSecurityGetDefaultConfigurations.Input) async throws -> Operations.CodeSecurityGetDefaultConfigurations.Output
    /// Detach configurations from repositories
    ///
    /// Detach code security configuration(s) from a set of repositories.
    /// Repositories will retain their settings but will no longer be associated with the configuration.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/code-security/configurations/detach`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)`.
    func codeSecurityDetachConfiguration(_ input: Operations.CodeSecurityDetachConfiguration.Input) async throws -> Operations.CodeSecurityDetachConfiguration.Output
    /// Get a code security configuration
    ///
    /// Gets a code security configuration available in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)`.
    func codeSecurityGetConfiguration(_ input: Operations.CodeSecurityGetConfiguration.Input) async throws -> Operations.CodeSecurityGetConfiguration.Output
    /// Update a code security configuration
    ///
    /// Updates a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/patch(code-security/update-configuration)`.
    func codeSecurityUpdateConfiguration(_ input: Operations.CodeSecurityUpdateConfiguration.Input) async throws -> Operations.CodeSecurityUpdateConfiguration.Output
    /// Delete a code security configuration
    ///
    /// Deletes the desired code security configuration from an organization.
    /// Repositories attached to the configuration will retain their settings but will no longer be associated with
    /// the configuration.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)`.
    func codeSecurityDeleteConfiguration(_ input: Operations.CodeSecurityDeleteConfiguration.Input) async throws -> Operations.CodeSecurityDeleteConfiguration.Output
    /// Attach a configuration to repositories
    ///
    /// Attach a code security configuration to a set of repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.
    ///
    /// If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/code-security/configurations/{configuration_id}/attach`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-configuration)`.
    func codeSecurityAttachConfiguration(_ input: Operations.CodeSecurityAttachConfiguration.Input) async throws -> Operations.CodeSecurityAttachConfiguration.Output
    /// Set a code security configuration as a default for an organization
    ///
    /// Sets a code security configuration as a default to be applied to new repositories in your organization.
    ///
    /// This configuration will be applied to the matching repository type (all, none, public, private and internal) by default when they are created.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/code-security/configurations/{configuration_id}/defaults`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default)`.
    func codeSecuritySetConfigurationAsDefault(_ input: Operations.CodeSecuritySetConfigurationAsDefault.Input) async throws -> Operations.CodeSecuritySetConfigurationAsDefault.Output
    /// Get repositories associated with a code security configuration
    ///
    /// Lists the repositories associated with a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/{configuration_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-configuration)`.
    func codeSecurityGetRepositoriesForConfiguration(_ input: Operations.CodeSecurityGetRepositoriesForConfiguration.Input) async throws -> Operations.CodeSecurityGetRepositoriesForConfiguration.Output
    /// Get the code security configuration associated with a repository
    ///
    /// Get the code security configuration that manages a repository's code security settings.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-security-configuration`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)`.
    func codeSecurityGetConfigurationForRepository(_ input: Operations.CodeSecurityGetConfigurationForRepository.Input) async throws -> Operations.CodeSecurityGetConfigurationForRepository.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get code security configurations for an enterprise
    ///
    /// Lists all code security configurations available in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/get(code-security/get-configurations-for-enterprise)`.
    public func codeSecurityGetConfigurationsForEnterprise(
        path: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Path,
        query: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Query = .init(),
        headers: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetConfigurationsForEnterprise.Output {
        try await codeSecurityGetConfigurationsForEnterprise(Operations.CodeSecurityGetConfigurationsForEnterprise.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a code security configuration for an enterprise
    ///
    /// Creates a code security configuration in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)`.
    public func codeSecurityCreateConfigurationForEnterprise(
        path: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Path,
        headers: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Headers = .init(),
        body: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body
    ) async throws -> Operations.CodeSecurityCreateConfigurationForEnterprise.Output {
        try await codeSecurityCreateConfigurationForEnterprise(Operations.CodeSecurityCreateConfigurationForEnterprise.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get default code security configurations for an enterprise
    ///
    /// Lists the default code security configurations for an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/defaults`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/defaults/get(code-security/get-default-configurations-for-enterprise)`.
    public func codeSecurityGetDefaultConfigurationsForEnterprise(
        path: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input.Path,
        headers: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Output {
        try await codeSecurityGetDefaultConfigurationsForEnterprise(Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input(
            path: path,
            headers: headers
        ))
    }
    /// Retrieve a code security configuration of an enterprise
    ///
    /// Gets a code security configuration available in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)`.
    public func codeSecurityGetSingleConfigurationForEnterprise(
        path: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input.Path,
        headers: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetSingleConfigurationForEnterprise.Output {
        try await codeSecurityGetSingleConfigurationForEnterprise(Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a custom code security configuration for an enterprise
    ///
    /// Updates a code security configuration in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)`.
    public func codeSecurityUpdateEnterpriseConfiguration(
        path: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Path,
        headers: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Headers = .init(),
        body: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body
    ) async throws -> Operations.CodeSecurityUpdateEnterpriseConfiguration.Output {
        try await codeSecurityUpdateEnterpriseConfiguration(Operations.CodeSecurityUpdateEnterpriseConfiguration.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a code security configuration for an enterprise
    ///
    /// Deletes a code security configuration from an enterprise.
    /// Repositories attached to the configuration will retain their settings but will no longer be associated with
    /// the configuration.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)`.
    public func codeSecurityDeleteConfigurationForEnterprise(
        path: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input.Path,
        headers: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityDeleteConfigurationForEnterprise.Output {
        try await codeSecurityDeleteConfigurationForEnterprise(Operations.CodeSecurityDeleteConfigurationForEnterprise.Input(
            path: path,
            headers: headers
        ))
    }
    /// Attach an enterprise configuration to repositories
    ///
    /// Attaches an enterprise code security configuration to repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.
    ///
    /// If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)`.
    public func codeSecurityAttachEnterpriseConfiguration(
        path: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Path,
        headers: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Headers = .init(),
        body: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body
    ) async throws -> Operations.CodeSecurityAttachEnterpriseConfiguration.Output {
        try await codeSecurityAttachEnterpriseConfiguration(Operations.CodeSecurityAttachEnterpriseConfiguration.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set a code security configuration as a default for an enterprise
    ///
    /// Sets a code security configuration as a default to be applied to new repositories in your enterprise.
    ///
    /// This configuration will be applied by default to the matching repository type when created, but only for organizations within the enterprise that do not already have a default code security configuration set.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default-for-enterprise)`.
    public func codeSecuritySetConfigurationAsDefaultForEnterprise(
        path: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Path,
        headers: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Headers = .init(),
        body: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Body
    ) async throws -> Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output {
        try await codeSecuritySetConfigurationAsDefaultForEnterprise(Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get repositories associated with an enterprise code security configuration
    ///
    /// Lists the repositories associated with an enterprise code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-enterprise-configuration)`.
    public func codeSecurityGetRepositoriesForEnterpriseConfiguration(
        path: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Path,
        query: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Query = .init(),
        headers: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Output {
        try await codeSecurityGetRepositoriesForEnterpriseConfiguration(Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get code security configurations for an organization
    ///
    /// Lists all code security configurations available in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/get(code-security/get-configurations-for-org)`.
    public func codeSecurityGetConfigurationsForOrg(
        path: Operations.CodeSecurityGetConfigurationsForOrg.Input.Path,
        query: Operations.CodeSecurityGetConfigurationsForOrg.Input.Query = .init(),
        headers: Operations.CodeSecurityGetConfigurationsForOrg.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetConfigurationsForOrg.Output {
        try await codeSecurityGetConfigurationsForOrg(Operations.CodeSecurityGetConfigurationsForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a code security configuration
    ///
    /// Creates a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/post(code-security/create-configuration)`.
    public func codeSecurityCreateConfiguration(
        path: Operations.CodeSecurityCreateConfiguration.Input.Path,
        headers: Operations.CodeSecurityCreateConfiguration.Input.Headers = .init(),
        body: Operations.CodeSecurityCreateConfiguration.Input.Body
    ) async throws -> Operations.CodeSecurityCreateConfiguration.Output {
        try await codeSecurityCreateConfiguration(Operations.CodeSecurityCreateConfiguration.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get default code security configurations
    ///
    /// Lists the default code security configurations for an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/defaults`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)`.
    public func codeSecurityGetDefaultConfigurations(
        path: Operations.CodeSecurityGetDefaultConfigurations.Input.Path,
        headers: Operations.CodeSecurityGetDefaultConfigurations.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetDefaultConfigurations.Output {
        try await codeSecurityGetDefaultConfigurations(Operations.CodeSecurityGetDefaultConfigurations.Input(
            path: path,
            headers: headers
        ))
    }
    /// Detach configurations from repositories
    ///
    /// Detach code security configuration(s) from a set of repositories.
    /// Repositories will retain their settings but will no longer be associated with the configuration.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/code-security/configurations/detach`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)`.
    public func codeSecurityDetachConfiguration(
        path: Operations.CodeSecurityDetachConfiguration.Input.Path,
        headers: Operations.CodeSecurityDetachConfiguration.Input.Headers = .init(),
        body: Operations.CodeSecurityDetachConfiguration.Input.Body
    ) async throws -> Operations.CodeSecurityDetachConfiguration.Output {
        try await codeSecurityDetachConfiguration(Operations.CodeSecurityDetachConfiguration.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a code security configuration
    ///
    /// Gets a code security configuration available in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)`.
    public func codeSecurityGetConfiguration(
        path: Operations.CodeSecurityGetConfiguration.Input.Path,
        headers: Operations.CodeSecurityGetConfiguration.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetConfiguration.Output {
        try await codeSecurityGetConfiguration(Operations.CodeSecurityGetConfiguration.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a code security configuration
    ///
    /// Updates a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/patch(code-security/update-configuration)`.
    public func codeSecurityUpdateConfiguration(
        path: Operations.CodeSecurityUpdateConfiguration.Input.Path,
        headers: Operations.CodeSecurityUpdateConfiguration.Input.Headers = .init(),
        body: Operations.CodeSecurityUpdateConfiguration.Input.Body
    ) async throws -> Operations.CodeSecurityUpdateConfiguration.Output {
        try await codeSecurityUpdateConfiguration(Operations.CodeSecurityUpdateConfiguration.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a code security configuration
    ///
    /// Deletes the desired code security configuration from an organization.
    /// Repositories attached to the configuration will retain their settings but will no longer be associated with
    /// the configuration.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)`.
    public func codeSecurityDeleteConfiguration(
        path: Operations.CodeSecurityDeleteConfiguration.Input.Path,
        headers: Operations.CodeSecurityDeleteConfiguration.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityDeleteConfiguration.Output {
        try await codeSecurityDeleteConfiguration(Operations.CodeSecurityDeleteConfiguration.Input(
            path: path,
            headers: headers
        ))
    }
    /// Attach a configuration to repositories
    ///
    /// Attach a code security configuration to a set of repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.
    ///
    /// If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/code-security/configurations/{configuration_id}/attach`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-configuration)`.
    public func codeSecurityAttachConfiguration(
        path: Operations.CodeSecurityAttachConfiguration.Input.Path,
        headers: Operations.CodeSecurityAttachConfiguration.Input.Headers = .init(),
        body: Operations.CodeSecurityAttachConfiguration.Input.Body
    ) async throws -> Operations.CodeSecurityAttachConfiguration.Output {
        try await codeSecurityAttachConfiguration(Operations.CodeSecurityAttachConfiguration.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set a code security configuration as a default for an organization
    ///
    /// Sets a code security configuration as a default to be applied to new repositories in your organization.
    ///
    /// This configuration will be applied to the matching repository type (all, none, public, private and internal) by default when they are created.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/code-security/configurations/{configuration_id}/defaults`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default)`.
    public func codeSecuritySetConfigurationAsDefault(
        path: Operations.CodeSecuritySetConfigurationAsDefault.Input.Path,
        headers: Operations.CodeSecuritySetConfigurationAsDefault.Input.Headers = .init(),
        body: Operations.CodeSecuritySetConfigurationAsDefault.Input.Body
    ) async throws -> Operations.CodeSecuritySetConfigurationAsDefault.Output {
        try await codeSecuritySetConfigurationAsDefault(Operations.CodeSecuritySetConfigurationAsDefault.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get repositories associated with a code security configuration
    ///
    /// Lists the repositories associated with a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/{configuration_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-configuration)`.
    public func codeSecurityGetRepositoriesForConfiguration(
        path: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Path,
        query: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Query = .init(),
        headers: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetRepositoriesForConfiguration.Output {
        try await codeSecurityGetRepositoriesForConfiguration(Operations.CodeSecurityGetRepositoriesForConfiguration.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get the code security configuration associated with a repository
    ///
    /// Get the code security configuration that manages a repository's code security settings.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-security-configuration`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)`.
    public func codeSecurityGetConfigurationForRepository(
        path: Operations.CodeSecurityGetConfigurationForRepository.Input.Path,
        headers: Operations.CodeSecurityGetConfigurationForRepository.Input.Headers = .init()
    ) async throws -> Operations.CodeSecurityGetConfigurationForRepository.Output {
        try await codeSecurityGetConfigurationForRepository(Operations.CodeSecurityGetConfigurationForRepository.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// A code security configuration
        ///
        /// - Remark: Generated from `#/components/schemas/code-security-configuration`.
        public struct CodeSecurityConfiguration: Codable, Hashable, Sendable {
            /// The ID of the code security configuration
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/id`.
            public var id: Swift.Int?
            /// The name of the code security configuration. Must be unique within the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/name`.
            public var name: Swift.String?
            /// The type of the code security configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/target_type`.
            @frozen public enum TargetTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case global = "global"
                case organization = "organization"
                case enterprise = "enterprise"
            }
            /// The type of the code security configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/target_type`.
            public var targetType: Components.Schemas.CodeSecurityConfiguration.TargetTypePayload?
            /// A description of the code security configuration
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/description`.
            public var description: Swift.String?
            /// The enablement status of GitHub Advanced Security
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/advanced_security`.
            @frozen public enum AdvancedSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case codeSecurity = "code_security"
                case secretProtection = "secret_protection"
            }
            /// The enablement status of GitHub Advanced Security
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/advanced_security`.
            public var advancedSecurity: Components.Schemas.CodeSecurityConfiguration.AdvancedSecurityPayload?
            /// The enablement status of Dependency Graph
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph`.
            @frozen public enum DependencyGraphPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of Dependency Graph
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph`.
            public var dependencyGraph: Components.Schemas.CodeSecurityConfiguration.DependencyGraphPayload?
            /// The enablement status of Automatic dependency submission
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph_autosubmit_action`.
            @frozen public enum DependencyGraphAutosubmitActionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of Automatic dependency submission
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph_autosubmit_action`.
            public var dependencyGraphAutosubmitAction: Components.Schemas.CodeSecurityConfiguration.DependencyGraphAutosubmitActionPayload?
            /// Feature options for Automatic dependency submission
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph_autosubmit_action_options`.
            public struct DependencyGraphAutosubmitActionOptionsPayload: Codable, Hashable, Sendable {
                /// Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph_autosubmit_action_options/labeled_runners`.
                public var labeledRunners: Swift.Bool?
                /// Creates a new `DependencyGraphAutosubmitActionOptionsPayload`.
                ///
                /// - Parameters:
                ///   - labeledRunners: Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                public init(labeledRunners: Swift.Bool? = nil) {
                    self.labeledRunners = labeledRunners
                }
                public enum CodingKeys: String, CodingKey {
                    case labeledRunners = "labeled_runners"
                }
            }
            /// Feature options for Automatic dependency submission
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependency_graph_autosubmit_action_options`.
            public var dependencyGraphAutosubmitActionOptions: Components.Schemas.CodeSecurityConfiguration.DependencyGraphAutosubmitActionOptionsPayload?
            /// The enablement status of Dependabot alerts
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependabot_alerts`.
            @frozen public enum DependabotAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of Dependabot alerts
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependabot_alerts`.
            public var dependabotAlerts: Components.Schemas.CodeSecurityConfiguration.DependabotAlertsPayload?
            /// The enablement status of Dependabot security updates
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependabot_security_updates`.
            @frozen public enum DependabotSecurityUpdatesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of Dependabot security updates
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.CodeSecurityConfiguration.DependabotSecurityUpdatesPayload?
            /// Feature options for code scanning
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_options`.
            public struct CodeScanningOptionsPayload: Codable, Hashable, Sendable {
                /// Whether to allow repos which use advanced setup
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_options/allow_advanced`.
                public var allowAdvanced: Swift.Bool?
                /// Creates a new `CodeScanningOptionsPayload`.
                ///
                /// - Parameters:
                ///   - allowAdvanced: Whether to allow repos which use advanced setup
                public init(allowAdvanced: Swift.Bool? = nil) {
                    self.allowAdvanced = allowAdvanced
                }
                public enum CodingKeys: String, CodingKey {
                    case allowAdvanced = "allow_advanced"
                }
            }
            /// Feature options for code scanning
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_options`.
            public var codeScanningOptions: Components.Schemas.CodeSecurityConfiguration.CodeScanningOptionsPayload?
            /// The enablement status of code scanning default setup
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup`.
            @frozen public enum CodeScanningDefaultSetupPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of code scanning default setup
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup`.
            public var codeScanningDefaultSetup: Components.Schemas.CodeSecurityConfiguration.CodeScanningDefaultSetupPayload?
            /// Feature options for code scanning default setup
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup_options`.
            public struct CodeScanningDefaultSetupOptionsPayload: Codable, Hashable, Sendable {
                /// Whether to use labeled runners or standard GitHub runners.
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup_options/runner_type`.
                @frozen public enum RunnerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case standard = "standard"
                    case labeled = "labeled"
                    case notSet = "not_set"
                }
                /// Whether to use labeled runners or standard GitHub runners.
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup_options/runner_type`.
                public var runnerType: Components.Schemas.CodeSecurityConfiguration.CodeScanningDefaultSetupOptionsPayload.RunnerTypePayload?
                /// The label of the runner to use for code scanning when runner_type is 'labeled'.
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup_options/runner_label`.
                public var runnerLabel: Swift.String?
                /// Creates a new `CodeScanningDefaultSetupOptionsPayload`.
                ///
                /// - Parameters:
                ///   - runnerType: Whether to use labeled runners or standard GitHub runners.
                ///   - runnerLabel: The label of the runner to use for code scanning when runner_type is 'labeled'.
                public init(
                    runnerType: Components.Schemas.CodeSecurityConfiguration.CodeScanningDefaultSetupOptionsPayload.RunnerTypePayload? = nil,
                    runnerLabel: Swift.String? = nil
                ) {
                    self.runnerType = runnerType
                    self.runnerLabel = runnerLabel
                }
                public enum CodingKeys: String, CodingKey {
                    case runnerType = "runner_type"
                    case runnerLabel = "runner_label"
                }
            }
            /// Feature options for code scanning default setup
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_default_setup_options`.
            public var codeScanningDefaultSetupOptions: Components.Schemas.CodeSecurityConfiguration.CodeScanningDefaultSetupOptionsPayload?
            /// The enablement status of code scanning delegated alert dismissal
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_delegated_alert_dismissal`.
            @frozen public enum CodeScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of code scanning delegated alert dismissal
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/code_scanning_delegated_alert_dismissal`.
            public var codeScanningDelegatedAlertDismissal: Components.Schemas.CodeSecurityConfiguration.CodeScanningDelegatedAlertDismissalPayload?
            /// The enablement status of secret scanning
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning`.
            @frozen public enum SecretScanningPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of secret scanning
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning`.
            public var secretScanning: Components.Schemas.CodeSecurityConfiguration.SecretScanningPayload?
            /// The enablement status of secret scanning push protection
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_push_protection`.
            @frozen public enum SecretScanningPushProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of secret scanning push protection
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.CodeSecurityConfiguration.SecretScanningPushProtectionPayload?
            /// The enablement status of secret scanning delegated bypass
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass`.
            @frozen public enum SecretScanningDelegatedBypassPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of secret scanning delegated bypass
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass`.
            public var secretScanningDelegatedBypass: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassPayload?
            /// Feature options for secret scanning delegated bypass
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options`.
            public struct SecretScanningDelegatedBypassOptionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options/ReviewersPayload`.
                public struct ReviewersPayloadPayload: Codable, Hashable, Sendable {
                    /// The ID of the team or role selected as a bypass reviewer
                    ///
                    /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_id`.
                    public var reviewerId: Swift.Int
                    /// The type of the bypass reviewer
                    ///
                    /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_type`.
                    @frozen public enum ReviewerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case team = "TEAM"
                        case role = "ROLE"
                    }
                    /// The type of the bypass reviewer
                    ///
                    /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_type`.
                    public var reviewerType: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload.ReviewerTypePayload
                    /// Creates a new `ReviewersPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - reviewerId: The ID of the team or role selected as a bypass reviewer
                    ///   - reviewerType: The type of the bypass reviewer
                    public init(
                        reviewerId: Swift.Int,
                        reviewerType: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload.ReviewerTypePayload
                    ) {
                        self.reviewerId = reviewerId
                        self.reviewerType = reviewerType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case reviewerId = "reviewer_id"
                        case reviewerType = "reviewer_type"
                    }
                }
                /// The bypass reviewers for secret scanning delegated bypass
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options/reviewers`.
                public typealias ReviewersPayload = [Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload]
                /// The bypass reviewers for secret scanning delegated bypass
                ///
                /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options/reviewers`.
                public var reviewers: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayload?
                /// Creates a new `SecretScanningDelegatedBypassOptionsPayload`.
                ///
                /// - Parameters:
                ///   - reviewers: The bypass reviewers for secret scanning delegated bypass
                public init(reviewers: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayload? = nil) {
                    self.reviewers = reviewers
                }
                public enum CodingKeys: String, CodingKey {
                    case reviewers
                }
            }
            /// Feature options for secret scanning delegated bypass
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_bypass_options`.
            public var secretScanningDelegatedBypassOptions: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload?
            /// The enablement status of secret scanning validity checks
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_validity_checks`.
            @frozen public enum SecretScanningValidityChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of secret scanning validity checks
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_validity_checks`.
            public var secretScanningValidityChecks: Components.Schemas.CodeSecurityConfiguration.SecretScanningValidityChecksPayload?
            /// The enablement status of secret scanning non-provider patterns
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_non_provider_patterns`.
            @frozen public enum SecretScanningNonProviderPatternsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of secret scanning non-provider patterns
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.CodeSecurityConfiguration.SecretScanningNonProviderPatternsPayload?
            /// The enablement status of Copilot secret scanning
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_generic_secrets`.
            @frozen public enum SecretScanningGenericSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of Copilot secret scanning
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_generic_secrets`.
            public var secretScanningGenericSecrets: Components.Schemas.CodeSecurityConfiguration.SecretScanningGenericSecretsPayload?
            /// The enablement status of secret scanning delegated alert dismissal
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_alert_dismissal`.
            @frozen public enum SecretScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of secret scanning delegated alert dismissal
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/secret_scanning_delegated_alert_dismissal`.
            public var secretScanningDelegatedAlertDismissal: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedAlertDismissalPayload?
            /// The enablement status of private vulnerability reporting
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/private_vulnerability_reporting`.
            @frozen public enum PrivateVulnerabilityReportingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case notSet = "not_set"
            }
            /// The enablement status of private vulnerability reporting
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/private_vulnerability_reporting`.
            public var privateVulnerabilityReporting: Components.Schemas.CodeSecurityConfiguration.PrivateVulnerabilityReportingPayload?
            /// The enforcement status for a security configuration
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/enforcement`.
            @frozen public enum EnforcementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enforced = "enforced"
                case unenforced = "unenforced"
            }
            /// The enforcement status for a security configuration
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/enforcement`.
            public var enforcement: Components.Schemas.CodeSecurityConfiguration.EnforcementPayload?
            /// The URL of the configuration
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/url`.
            public var url: Swift.String?
            /// The URL of the configuration
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/html_url`.
            public var htmlUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/code-security-configuration/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Creates a new `CodeSecurityConfiguration`.
            ///
            /// - Parameters:
            ///   - id: The ID of the code security configuration
            ///   - name: The name of the code security configuration. Must be unique within the organization.
            ///   - targetType: The type of the code security configuration.
            ///   - description: A description of the code security configuration
            ///   - advancedSecurity: The enablement status of GitHub Advanced Security
            ///   - dependencyGraph: The enablement status of Dependency Graph
            ///   - dependencyGraphAutosubmitAction: The enablement status of Automatic dependency submission
            ///   - dependencyGraphAutosubmitActionOptions: Feature options for Automatic dependency submission
            ///   - dependabotAlerts: The enablement status of Dependabot alerts
            ///   - dependabotSecurityUpdates: The enablement status of Dependabot security updates
            ///   - codeScanningOptions: Feature options for code scanning
            ///   - codeScanningDefaultSetup: The enablement status of code scanning default setup
            ///   - codeScanningDefaultSetupOptions: Feature options for code scanning default setup
            ///   - codeScanningDelegatedAlertDismissal: The enablement status of code scanning delegated alert dismissal
            ///   - secretScanning: The enablement status of secret scanning
            ///   - secretScanningPushProtection: The enablement status of secret scanning push protection
            ///   - secretScanningDelegatedBypass: The enablement status of secret scanning delegated bypass
            ///   - secretScanningDelegatedBypassOptions: Feature options for secret scanning delegated bypass
            ///   - secretScanningValidityChecks: The enablement status of secret scanning validity checks
            ///   - secretScanningNonProviderPatterns: The enablement status of secret scanning non-provider patterns
            ///   - secretScanningGenericSecrets: The enablement status of Copilot secret scanning
            ///   - secretScanningDelegatedAlertDismissal: The enablement status of secret scanning delegated alert dismissal
            ///   - privateVulnerabilityReporting: The enablement status of private vulnerability reporting
            ///   - enforcement: The enforcement status for a security configuration
            ///   - url: The URL of the configuration
            ///   - htmlUrl: The URL of the configuration
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                id: Swift.Int? = nil,
                name: Swift.String? = nil,
                targetType: Components.Schemas.CodeSecurityConfiguration.TargetTypePayload? = nil,
                description: Swift.String? = nil,
                advancedSecurity: Components.Schemas.CodeSecurityConfiguration.AdvancedSecurityPayload? = nil,
                dependencyGraph: Components.Schemas.CodeSecurityConfiguration.DependencyGraphPayload? = nil,
                dependencyGraphAutosubmitAction: Components.Schemas.CodeSecurityConfiguration.DependencyGraphAutosubmitActionPayload? = nil,
                dependencyGraphAutosubmitActionOptions: Components.Schemas.CodeSecurityConfiguration.DependencyGraphAutosubmitActionOptionsPayload? = nil,
                dependabotAlerts: Components.Schemas.CodeSecurityConfiguration.DependabotAlertsPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.CodeSecurityConfiguration.DependabotSecurityUpdatesPayload? = nil,
                codeScanningOptions: Components.Schemas.CodeSecurityConfiguration.CodeScanningOptionsPayload? = nil,
                codeScanningDefaultSetup: Components.Schemas.CodeSecurityConfiguration.CodeScanningDefaultSetupPayload? = nil,
                codeScanningDefaultSetupOptions: Components.Schemas.CodeSecurityConfiguration.CodeScanningDefaultSetupOptionsPayload? = nil,
                codeScanningDelegatedAlertDismissal: Components.Schemas.CodeSecurityConfiguration.CodeScanningDelegatedAlertDismissalPayload? = nil,
                secretScanning: Components.Schemas.CodeSecurityConfiguration.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.CodeSecurityConfiguration.SecretScanningPushProtectionPayload? = nil,
                secretScanningDelegatedBypass: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassPayload? = nil,
                secretScanningDelegatedBypassOptions: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedBypassOptionsPayload? = nil,
                secretScanningValidityChecks: Components.Schemas.CodeSecurityConfiguration.SecretScanningValidityChecksPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.CodeSecurityConfiguration.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningGenericSecrets: Components.Schemas.CodeSecurityConfiguration.SecretScanningGenericSecretsPayload? = nil,
                secretScanningDelegatedAlertDismissal: Components.Schemas.CodeSecurityConfiguration.SecretScanningDelegatedAlertDismissalPayload? = nil,
                privateVulnerabilityReporting: Components.Schemas.CodeSecurityConfiguration.PrivateVulnerabilityReportingPayload? = nil,
                enforcement: Components.Schemas.CodeSecurityConfiguration.EnforcementPayload? = nil,
                url: Swift.String? = nil,
                htmlUrl: Swift.String? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.name = name
                self.targetType = targetType
                self.description = description
                self.advancedSecurity = advancedSecurity
                self.dependencyGraph = dependencyGraph
                self.dependencyGraphAutosubmitAction = dependencyGraphAutosubmitAction
                self.dependencyGraphAutosubmitActionOptions = dependencyGraphAutosubmitActionOptions
                self.dependabotAlerts = dependabotAlerts
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.codeScanningOptions = codeScanningOptions
                self.codeScanningDefaultSetup = codeScanningDefaultSetup
                self.codeScanningDefaultSetupOptions = codeScanningDefaultSetupOptions
                self.codeScanningDelegatedAlertDismissal = codeScanningDelegatedAlertDismissal
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningDelegatedBypass = secretScanningDelegatedBypass
                self.secretScanningDelegatedBypassOptions = secretScanningDelegatedBypassOptions
                self.secretScanningValidityChecks = secretScanningValidityChecks
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningGenericSecrets = secretScanningGenericSecrets
                self.secretScanningDelegatedAlertDismissal = secretScanningDelegatedAlertDismissal
                self.privateVulnerabilityReporting = privateVulnerabilityReporting
                self.enforcement = enforcement
                self.url = url
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case targetType = "target_type"
                case description
                case advancedSecurity = "advanced_security"
                case dependencyGraph = "dependency_graph"
                case dependencyGraphAutosubmitAction = "dependency_graph_autosubmit_action"
                case dependencyGraphAutosubmitActionOptions = "dependency_graph_autosubmit_action_options"
                case dependabotAlerts = "dependabot_alerts"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case codeScanningOptions = "code_scanning_options"
                case codeScanningDefaultSetup = "code_scanning_default_setup"
                case codeScanningDefaultSetupOptions = "code_scanning_default_setup_options"
                case codeScanningDelegatedAlertDismissal = "code_scanning_delegated_alert_dismissal"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningDelegatedBypass = "secret_scanning_delegated_bypass"
                case secretScanningDelegatedBypassOptions = "secret_scanning_delegated_bypass_options"
                case secretScanningValidityChecks = "secret_scanning_validity_checks"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningGenericSecrets = "secret_scanning_generic_secrets"
                case secretScanningDelegatedAlertDismissal = "secret_scanning_delegated_alert_dismissal"
                case privateVulnerabilityReporting = "private_vulnerability_reporting"
                case enforcement
                case url
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Security Configuration feature options for code scanning
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-options`.
        public struct CodeScanningOptions: Codable, Hashable, Sendable {
            /// Whether to allow repos which use advanced setup
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-options/allow_advanced`.
            public var allowAdvanced: Swift.Bool?
            /// Creates a new `CodeScanningOptions`.
            ///
            /// - Parameters:
            ///   - allowAdvanced: Whether to allow repos which use advanced setup
            public init(allowAdvanced: Swift.Bool? = nil) {
                self.allowAdvanced = allowAdvanced
            }
            public enum CodingKeys: String, CodingKey {
                case allowAdvanced = "allow_advanced"
            }
        }
        /// Feature options for code scanning default setup
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-options`.
        public struct CodeScanningDefaultSetupOptions: Codable, Hashable, Sendable {
            /// Whether to use labeled runners or standard GitHub runners.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-options/runner_type`.
            @frozen public enum RunnerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case standard = "standard"
                case labeled = "labeled"
                case notSet = "not_set"
            }
            /// Whether to use labeled runners or standard GitHub runners.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-options/runner_type`.
            public var runnerType: Components.Schemas.CodeScanningDefaultSetupOptions.RunnerTypePayload?
            /// The label of the runner to use for code scanning default setup when runner_type is 'labeled'.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-options/runner_label`.
            public var runnerLabel: Swift.String?
            /// Creates a new `CodeScanningDefaultSetupOptions`.
            ///
            /// - Parameters:
            ///   - runnerType: Whether to use labeled runners or standard GitHub runners.
            ///   - runnerLabel: The label of the runner to use for code scanning default setup when runner_type is 'labeled'.
            public init(
                runnerType: Components.Schemas.CodeScanningDefaultSetupOptions.RunnerTypePayload? = nil,
                runnerLabel: Swift.String? = nil
            ) {
                self.runnerType = runnerType
                self.runnerLabel = runnerLabel
            }
            public enum CodingKeys: String, CodingKey {
                case runnerType = "runner_type"
                case runnerLabel = "runner_label"
            }
        }
        /// - Remark: Generated from `#/components/schemas/CodeSecurityDefaultConfigurations`.
        public struct CodeSecurityDefaultConfigurationsPayload: Codable, Hashable, Sendable {
            /// The visibility of newly created repositories for which the code security configuration will be applied to by default
            ///
            /// - Remark: Generated from `#/components/schemas/CodeSecurityDefaultConfigurations/default_for_new_repos`.
            public var defaultForNewRepos: OpenAPIRuntime.OpenAPIValueContainer?
            /// - Remark: Generated from `#/components/schemas/CodeSecurityDefaultConfigurations/configuration`.
            public var configuration: Components.Schemas.CodeSecurityConfiguration?
            /// Creates a new `CodeSecurityDefaultConfigurationsPayload`.
            ///
            /// - Parameters:
            ///   - defaultForNewRepos: The visibility of newly created repositories for which the code security configuration will be applied to by default
            ///   - configuration:
            public init(
                defaultForNewRepos: OpenAPIRuntime.OpenAPIValueContainer? = nil,
                configuration: Components.Schemas.CodeSecurityConfiguration? = nil
            ) {
                self.defaultForNewRepos = defaultForNewRepos
                self.configuration = configuration
            }
            public enum CodingKeys: String, CodingKey {
                case defaultForNewRepos = "default_for_new_repos"
                case configuration
            }
        }
        /// A list of default code security configurations
        ///
        /// - Remark: Generated from `#/components/schemas/code-security-default-configurations`.
        public typealias CodeSecurityDefaultConfigurations = [Components.Schemas.CodeSecurityDefaultConfigurationsPayload]
        /// A GitHub repository.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-repository`.
        public struct SimpleRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/id`.
            public var id: Swift.Int64
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/private`.
            public var _private: Swift.Bool
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The repository description.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/description`.
            public var description: Swift.String?
            /// Whether the repository is a fork.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/fork`.
            public var fork: Swift.Bool
            /// The URL to get more information about the repository from the GitHub API.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/url`.
            public var url: Swift.String
            /// A template for the API URL to download the repository as an archive.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// A template for the API URL to list the available assignees for issues in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// A template for the API URL to get information about branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// A template for the API URL to get information about collaborators of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// A template for the API URL to get information about comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// A template for the API URL to get information about commits on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// A template for the API URL to compare two commits or refs.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/compare_url`.
            public var compareUrl: Swift.String
            /// A template for the API URL to get the contents of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// A template for the API URL to list the contributors to the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// The API URL to list the deployments of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// The API URL to list the downloads on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// The API URL to list the events of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/events_url`.
            public var eventsUrl: Swift.String
            /// The API URL to list the forks of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/forks_url`.
            public var forksUrl: Swift.String
            /// A template for the API URL to get information about Git commits of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// A template for the API URL to get information about Git refs of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// A template for the API URL to get information about Git tags of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// A template for the API URL to get information about issue comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// A template for the API URL to get information about issue events on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// A template for the API URL to get information about issues on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// A template for the API URL to get information about deploy keys on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/keys_url`.
            public var keysUrl: Swift.String
            /// A template for the API URL to get information about labels of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// The API URL to get information about the languages of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// The API URL to merge branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// A template for the API URL to get information about milestones of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// A template for the API URL to get information about notifications on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// A template for the API URL to get information about pull requests on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// A template for the API URL to get information about releases on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// The API URL to list the stargazers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// A template for the API URL to get information about statuses of a commit.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// The API URL to list the subscribers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// The API URL to subscribe to notifications for this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// The API URL to get information about tags on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// The API URL to list the teams on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/trees_url`.
            public var treesUrl: Swift.String
            /// The API URL to list the hooks on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// Creates a new `SimpleRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - owner:
            ///   - _private: Whether the repository is private.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - description: The repository description.
            ///   - fork: Whether the repository is a fork.
            ///   - url: The URL to get more information about the repository from the GitHub API.
            ///   - archiveUrl: A template for the API URL to download the repository as an archive.
            ///   - assigneesUrl: A template for the API URL to list the available assignees for issues in the repository.
            ///   - blobsUrl: A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///   - branchesUrl: A template for the API URL to get information about branches in the repository.
            ///   - collaboratorsUrl: A template for the API URL to get information about collaborators of the repository.
            ///   - commentsUrl: A template for the API URL to get information about comments on the repository.
            ///   - commitsUrl: A template for the API URL to get information about commits on the repository.
            ///   - compareUrl: A template for the API URL to compare two commits or refs.
            ///   - contentsUrl: A template for the API URL to get the contents of the repository.
            ///   - contributorsUrl: A template for the API URL to list the contributors to the repository.
            ///   - deploymentsUrl: The API URL to list the deployments of the repository.
            ///   - downloadsUrl: The API URL to list the downloads on the repository.
            ///   - eventsUrl: The API URL to list the events of the repository.
            ///   - forksUrl: The API URL to list the forks of the repository.
            ///   - gitCommitsUrl: A template for the API URL to get information about Git commits of the repository.
            ///   - gitRefsUrl: A template for the API URL to get information about Git refs of the repository.
            ///   - gitTagsUrl: A template for the API URL to get information about Git tags of the repository.
            ///   - issueCommentUrl: A template for the API URL to get information about issue comments on the repository.
            ///   - issueEventsUrl: A template for the API URL to get information about issue events on the repository.
            ///   - issuesUrl: A template for the API URL to get information about issues on the repository.
            ///   - keysUrl: A template for the API URL to get information about deploy keys on the repository.
            ///   - labelsUrl: A template for the API URL to get information about labels of the repository.
            ///   - languagesUrl: The API URL to get information about the languages of the repository.
            ///   - mergesUrl: The API URL to merge branches in the repository.
            ///   - milestonesUrl: A template for the API URL to get information about milestones of the repository.
            ///   - notificationsUrl: A template for the API URL to get information about notifications on the repository.
            ///   - pullsUrl: A template for the API URL to get information about pull requests on the repository.
            ///   - releasesUrl: A template for the API URL to get information about releases on the repository.
            ///   - stargazersUrl: The API URL to list the stargazers on the repository.
            ///   - statusesUrl: A template for the API URL to get information about statuses of a commit.
            ///   - subscribersUrl: The API URL to list the subscribers on the repository.
            ///   - subscriptionUrl: The API URL to subscribe to notifications for this repository.
            ///   - tagsUrl: The API URL to get information about tags on the repository.
            ///   - teamsUrl: The API URL to list the teams on the repository.
            ///   - treesUrl: A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///   - hooksUrl: The API URL to list the hooks on the repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                hooksUrl: Swift.String
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.hooksUrl = hooksUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case hooksUrl = "hooks_url"
            }
        }
        /// Repositories associated with a code security configuration and attachment status
        ///
        /// - Remark: Generated from `#/components/schemas/code-security-configuration-repositories`.
        public struct CodeSecurityConfigurationRepositories: Codable, Hashable, Sendable {
            /// The attachment status of the code security configuration on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration-repositories/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case attached = "attached"
                case attaching = "attaching"
                case detached = "detached"
                case removed = "removed"
                case enforced = "enforced"
                case failed = "failed"
                case updating = "updating"
                case removedByEnterprise = "removed_by_enterprise"
            }
            /// The attachment status of the code security configuration on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration-repositories/status`.
            public var status: Components.Schemas.CodeSecurityConfigurationRepositories.StatusPayload?
            /// - Remark: Generated from `#/components/schemas/code-security-configuration-repositories/repository`.
            public var repository: Components.Schemas.SimpleRepository?
            /// Creates a new `CodeSecurityConfigurationRepositories`.
            ///
            /// - Parameters:
            ///   - status: The attachment status of the code security configuration on the repository.
            ///   - repository:
            public init(
                status: Components.Schemas.CodeSecurityConfigurationRepositories.StatusPayload? = nil,
                repository: Components.Schemas.SimpleRepository? = nil
            ) {
                self.status = status
                self.repository = repository
            }
            public enum CodingKeys: String, CodingKey {
                case status
                case repository
            }
        }
        /// Code security configuration associated with a repository and attachment status
        ///
        /// - Remark: Generated from `#/components/schemas/code-security-configuration-for-repository`.
        public struct CodeSecurityConfigurationForRepository: Codable, Hashable, Sendable {
            /// The attachment status of the code security configuration on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration-for-repository/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case attached = "attached"
                case attaching = "attaching"
                case detached = "detached"
                case removed = "removed"
                case enforced = "enforced"
                case failed = "failed"
                case updating = "updating"
                case removedByEnterprise = "removed_by_enterprise"
            }
            /// The attachment status of the code security configuration on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-security-configuration-for-repository/status`.
            public var status: Components.Schemas.CodeSecurityConfigurationForRepository.StatusPayload?
            /// - Remark: Generated from `#/components/schemas/code-security-configuration-for-repository/configuration`.
            public var configuration: Components.Schemas.CodeSecurityConfiguration?
            /// Creates a new `CodeSecurityConfigurationForRepository`.
            ///
            /// - Parameters:
            ///   - status: The attachment status of the code security configuration on the repository.
            ///   - configuration:
            public init(
                status: Components.Schemas.CodeSecurityConfigurationForRepository.StatusPayload? = nil,
                configuration: Components.Schemas.CodeSecurityConfiguration? = nil
            ) {
                self.status = status
                self.configuration = configuration
            }
            public enum CodingKeys: String, CodingKey {
                case status
                case configuration
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The slug version of the enterprise name.
        ///
        /// - Remark: Generated from `#/components/parameters/enterprise`.
        public typealias Enterprise = Swift.String
        /// The unique identifier of the code security configuration.
        ///
        /// - Remark: Generated from `#/components/parameters/configuration-id`.
        public typealias ConfigurationId = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct Accepted: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/accepted/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/accepted/content/application\/json`.
                case json(OpenAPIRuntime.OpenAPIObjectContainer)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: OpenAPIRuntime.OpenAPIObjectContainer {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Accepted.Body
            /// Creates a new `Accepted`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Accepted.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
        public struct NoContent: Sendable, Hashable {
            /// Creates a new `NoContent`.
            public init() {}
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get code security configurations for an enterprise
    ///
    /// Lists all code security configurations available in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/get(code-security/get-configurations-for-enterprise)`.
    public enum CodeSecurityGetConfigurationsForEnterprise {
        public static let id: Swift.String = "code-security/get-configurations-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                public init(enterprise: Components.Parameters.Enterprise) {
                    self.enterprise = enterprise
                }
            }
            public var path: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Swift.Int? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                }
            }
            public var query: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Query
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfigurationsForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfigurationsForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Path,
                query: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Query = .init(),
                headers: Operations.CodeSecurityGetConfigurationsForEnterprise.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeSecurityConfiguration])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeSecurityConfiguration] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetConfigurationsForEnterprise.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetConfigurationsForEnterprise.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/get(code-security/get-configurations-for-enterprise)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetConfigurationsForEnterprise.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetConfigurationsForEnterprise.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/get(code-security/get-configurations-for-enterprise)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/get(code-security/get-configurations-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a code security configuration for an enterprise
    ///
    /// Creates a code security configuration in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)`.
    public enum CodeSecurityCreateConfigurationForEnterprise {
        public static let id: Swift.String = "code-security/create-configuration-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                public init(enterprise: Components.Parameters.Enterprise) {
                    self.enterprise = enterprise
                }
            }
            public var path: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityCreateConfigurationForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityCreateConfigurationForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Headers
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the code security configuration. Must be unique within the enterprise.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// A description of the code security configuration
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/description`.
                    public var description: Swift.String
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/advanced_security`.
                    @frozen public enum AdvancedSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case codeSecurity = "code_security"
                        case secretProtection = "secret_protection"
                    }
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/advanced_security`.
                    public var advancedSecurity: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.AdvancedSecurityPayload?
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_security`.
                    @frozen public enum CodeSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_security`.
                    public var codeSecurity: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeSecurityPayload?
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph`.
                    @frozen public enum DependencyGraphPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph`.
                    public var dependencyGraph: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphPayload?
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action`.
                    @frozen public enum DependencyGraphAutosubmitActionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action`.
                    public var dependencyGraphAutosubmitAction: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload?
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public struct DependencyGraphAutosubmitActionOptionsPayload: Codable, Hashable, Sendable {
                        /// Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        ///
                        /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action_options/labeled_runners`.
                        public var labeledRunners: Swift.Bool?
                        /// Creates a new `DependencyGraphAutosubmitActionOptionsPayload`.
                        ///
                        /// - Parameters:
                        ///   - labeledRunners: Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        public init(labeledRunners: Swift.Bool? = nil) {
                            self.labeledRunners = labeledRunners
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labeledRunners = "labeled_runners"
                        }
                    }
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public var dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload?
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependabot_alerts`.
                    @frozen public enum DependabotAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependabot_alerts`.
                    public var dependabotAlerts: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependabotAlertsPayload?
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependabot_security_updates`.
                    @frozen public enum DependabotSecurityUpdatesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/dependabot_security_updates`.
                    public var dependabotSecurityUpdates: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload?
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_scanning_options`.
                    public var codeScanningOptions: Components.Schemas.CodeScanningOptions?
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_scanning_default_setup`.
                    @frozen public enum CodeScanningDefaultSetupPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_scanning_default_setup`.
                    public var codeScanningDefaultSetup: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload?
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_scanning_default_setup_options`.
                    public var codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions?
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    @frozen public enum CodeScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    public var codeScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_protection`.
                    @frozen public enum SecretProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_protection`.
                    public var secretProtection: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretProtectionPayload?
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning`.
                    @frozen public enum SecretScanningPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning`.
                    public var secretScanning: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningPayload?
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_push_protection`.
                    @frozen public enum SecretScanningPushProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_push_protection`.
                    public var secretScanningPushProtection: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningPushProtectionPayload?
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_validity_checks`.
                    @frozen public enum SecretScanningValidityChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_validity_checks`.
                    public var secretScanningValidityChecks: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningValidityChecksPayload?
                    /// The enablement status of secret scanning non provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_non_provider_patterns`.
                    @frozen public enum SecretScanningNonProviderPatternsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning non provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_non_provider_patterns`.
                    public var secretScanningNonProviderPatterns: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload?
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_generic_secrets`.
                    @frozen public enum SecretScanningGenericSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_generic_secrets`.
                    public var secretScanningGenericSecrets: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload?
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    @frozen public enum SecretScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    public var secretScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/private_vulnerability_reporting`.
                    @frozen public enum PrivateVulnerabilityReportingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/private_vulnerability_reporting`.
                    public var privateVulnerabilityReporting: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload?
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/enforcement`.
                    @frozen public enum EnforcementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enforced = "enforced"
                        case unenforced = "unenforced"
                    }
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/json/enforcement`.
                    public var enforcement: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.EnforcementPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the code security configuration. Must be unique within the enterprise.
                    ///   - description: A description of the code security configuration
                    ///   - advancedSecurity: The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///   - codeSecurity: The enablement status of GitHub Code Security features.
                    ///   - dependencyGraph: The enablement status of Dependency Graph
                    ///   - dependencyGraphAutosubmitAction: The enablement status of Automatic dependency submission
                    ///   - dependencyGraphAutosubmitActionOptions: Feature options for Automatic dependency submission
                    ///   - dependabotAlerts: The enablement status of Dependabot alerts
                    ///   - dependabotSecurityUpdates: The enablement status of Dependabot security updates
                    ///   - codeScanningOptions:
                    ///   - codeScanningDefaultSetup: The enablement status of code scanning default setup
                    ///   - codeScanningDefaultSetupOptions:
                    ///   - codeScanningDelegatedAlertDismissal: The enablement status of code scanning delegated alert dismissal
                    ///   - secretProtection: The enablement status of GitHub Secret Protection features.
                    ///   - secretScanning: The enablement status of secret scanning
                    ///   - secretScanningPushProtection: The enablement status of secret scanning push protection
                    ///   - secretScanningValidityChecks: The enablement status of secret scanning validity checks
                    ///   - secretScanningNonProviderPatterns: The enablement status of secret scanning non provider patterns
                    ///   - secretScanningGenericSecrets: The enablement status of Copilot secret scanning
                    ///   - secretScanningDelegatedAlertDismissal: The enablement status of secret scanning delegated alert dismissal
                    ///   - privateVulnerabilityReporting: The enablement status of private vulnerability reporting
                    ///   - enforcement: The enforcement status for a security configuration
                    public init(
                        name: Swift.String,
                        description: Swift.String,
                        advancedSecurity: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.AdvancedSecurityPayload? = nil,
                        codeSecurity: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeSecurityPayload? = nil,
                        dependencyGraph: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphPayload? = nil,
                        dependencyGraphAutosubmitAction: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload? = nil,
                        dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload? = nil,
                        dependabotAlerts: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependabotAlertsPayload? = nil,
                        dependabotSecurityUpdates: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload? = nil,
                        codeScanningOptions: Components.Schemas.CodeScanningOptions? = nil,
                        codeScanningDefaultSetup: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload? = nil,
                        codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions? = nil,
                        codeScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload? = nil,
                        secretProtection: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretProtectionPayload? = nil,
                        secretScanning: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningPayload? = nil,
                        secretScanningPushProtection: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningPushProtectionPayload? = nil,
                        secretScanningValidityChecks: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningValidityChecksPayload? = nil,
                        secretScanningNonProviderPatterns: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload? = nil,
                        secretScanningGenericSecrets: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload? = nil,
                        secretScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload? = nil,
                        privateVulnerabilityReporting: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload? = nil,
                        enforcement: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.EnforcementPayload? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.advancedSecurity = advancedSecurity
                        self.codeSecurity = codeSecurity
                        self.dependencyGraph = dependencyGraph
                        self.dependencyGraphAutosubmitAction = dependencyGraphAutosubmitAction
                        self.dependencyGraphAutosubmitActionOptions = dependencyGraphAutosubmitActionOptions
                        self.dependabotAlerts = dependabotAlerts
                        self.dependabotSecurityUpdates = dependabotSecurityUpdates
                        self.codeScanningOptions = codeScanningOptions
                        self.codeScanningDefaultSetup = codeScanningDefaultSetup
                        self.codeScanningDefaultSetupOptions = codeScanningDefaultSetupOptions
                        self.codeScanningDelegatedAlertDismissal = codeScanningDelegatedAlertDismissal
                        self.secretProtection = secretProtection
                        self.secretScanning = secretScanning
                        self.secretScanningPushProtection = secretScanningPushProtection
                        self.secretScanningValidityChecks = secretScanningValidityChecks
                        self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                        self.secretScanningGenericSecrets = secretScanningGenericSecrets
                        self.secretScanningDelegatedAlertDismissal = secretScanningDelegatedAlertDismissal
                        self.privateVulnerabilityReporting = privateVulnerabilityReporting
                        self.enforcement = enforcement
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case advancedSecurity = "advanced_security"
                        case codeSecurity = "code_security"
                        case dependencyGraph = "dependency_graph"
                        case dependencyGraphAutosubmitAction = "dependency_graph_autosubmit_action"
                        case dependencyGraphAutosubmitActionOptions = "dependency_graph_autosubmit_action_options"
                        case dependabotAlerts = "dependabot_alerts"
                        case dependabotSecurityUpdates = "dependabot_security_updates"
                        case codeScanningOptions = "code_scanning_options"
                        case codeScanningDefaultSetup = "code_scanning_default_setup"
                        case codeScanningDefaultSetupOptions = "code_scanning_default_setup_options"
                        case codeScanningDelegatedAlertDismissal = "code_scanning_delegated_alert_dismissal"
                        case secretProtection = "secret_protection"
                        case secretScanning = "secret_scanning"
                        case secretScanningPushProtection = "secret_scanning_push_protection"
                        case secretScanningValidityChecks = "secret_scanning_validity_checks"
                        case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                        case secretScanningGenericSecrets = "secret_scanning_generic_secrets"
                        case secretScanningDelegatedAlertDismissal = "secret_scanning_delegated_alert_dismissal"
                        case privateVulnerabilityReporting = "private_vulnerability_reporting"
                        case enforcement
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.name = try container.decode(
                            Swift.String.self,
                            forKey: .name
                        )
                        self.description = try container.decode(
                            Swift.String.self,
                            forKey: .description
                        )
                        self.advancedSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.AdvancedSecurityPayload.self,
                            forKey: .advancedSecurity
                        )
                        self.codeSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeSecurityPayload.self,
                            forKey: .codeSecurity
                        )
                        self.dependencyGraph = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphPayload.self,
                            forKey: .dependencyGraph
                        )
                        self.dependencyGraphAutosubmitAction = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload.self,
                            forKey: .dependencyGraphAutosubmitAction
                        )
                        self.dependencyGraphAutosubmitActionOptions = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload.self,
                            forKey: .dependencyGraphAutosubmitActionOptions
                        )
                        self.dependabotAlerts = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependabotAlertsPayload.self,
                            forKey: .dependabotAlerts
                        )
                        self.dependabotSecurityUpdates = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload.self,
                            forKey: .dependabotSecurityUpdates
                        )
                        self.codeScanningOptions = try container.decodeIfPresent(
                            Components.Schemas.CodeScanningOptions.self,
                            forKey: .codeScanningOptions
                        )
                        self.codeScanningDefaultSetup = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload.self,
                            forKey: .codeScanningDefaultSetup
                        )
                        self.codeScanningDefaultSetupOptions = try container.decodeIfPresent(
                            Components.Schemas.CodeScanningDefaultSetupOptions.self,
                            forKey: .codeScanningDefaultSetupOptions
                        )
                        self.codeScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload.self,
                            forKey: .codeScanningDelegatedAlertDismissal
                        )
                        self.secretProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretProtectionPayload.self,
                            forKey: .secretProtection
                        )
                        self.secretScanning = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningPayload.self,
                            forKey: .secretScanning
                        )
                        self.secretScanningPushProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningPushProtectionPayload.self,
                            forKey: .secretScanningPushProtection
                        )
                        self.secretScanningValidityChecks = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningValidityChecksPayload.self,
                            forKey: .secretScanningValidityChecks
                        )
                        self.secretScanningNonProviderPatterns = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload.self,
                            forKey: .secretScanningNonProviderPatterns
                        )
                        self.secretScanningGenericSecrets = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload.self,
                            forKey: .secretScanningGenericSecrets
                        )
                        self.secretScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload.self,
                            forKey: .secretScanningDelegatedAlertDismissal
                        )
                        self.privateVulnerabilityReporting = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload.self,
                            forKey: .privateVulnerabilityReporting
                        )
                        self.enforcement = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload.EnforcementPayload.self,
                            forKey: .enforcement
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "name",
                            "description",
                            "advanced_security",
                            "code_security",
                            "dependency_graph",
                            "dependency_graph_autosubmit_action",
                            "dependency_graph_autosubmit_action_options",
                            "dependabot_alerts",
                            "dependabot_security_updates",
                            "code_scanning_options",
                            "code_scanning_default_setup",
                            "code_scanning_default_setup_options",
                            "code_scanning_delegated_alert_dismissal",
                            "secret_protection",
                            "secret_scanning",
                            "secret_scanning_push_protection",
                            "secret_scanning_validity_checks",
                            "secret_scanning_non_provider_patterns",
                            "secret_scanning_generic_secrets",
                            "secret_scanning_delegated_alert_dismissal",
                            "private_vulnerability_reporting",
                            "enforcement"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Path,
                headers: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Headers = .init(),
                body: Operations.CodeSecurityCreateConfigurationForEnterprise.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityCreateConfigurationForEnterprise.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityCreateConfigurationForEnterprise.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Successfully created code security configuration
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodeSecurityCreateConfigurationForEnterprise.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodeSecurityCreateConfigurationForEnterprise.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/post(code-security/create-configuration-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get default code security configurations for an enterprise
    ///
    /// Lists the default code security configurations for an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/defaults`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/defaults/get(code-security/get-default-configurations-for-enterprise)`.
    public enum CodeSecurityGetDefaultConfigurationsForEnterprise {
        public static let id: Swift.String = "code-security/get-default-configurations-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/defaults/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/defaults/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                public init(enterprise: Components.Parameters.Enterprise) {
                    self.enterprise = enterprise
                }
            }
            public var path: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/defaults/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input.Path,
                headers: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/defaults/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/defaults/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityDefaultConfigurations)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityDefaultConfigurations {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/defaults/get(code-security/get-default-configurations-for-enterprise)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetDefaultConfigurationsForEnterprise.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieve a code security configuration of an enterprise
    ///
    /// Gets a code security configuration available in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)`.
    public enum CodeSecurityGetSingleConfigurationForEnterprise {
        public static let id: Swift.String = "code-security/get-single-configuration-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/GET/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.enterprise = enterprise
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetSingleConfigurationForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetSingleConfigurationForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input.Path,
                headers: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetSingleConfigurationForEnterprise.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetSingleConfigurationForEnterprise.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/get(code-security/get-single-configuration-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a custom code security configuration for an enterprise
    ///
    /// Updates a code security configuration in an enterprise.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)`.
    public enum CodeSecurityUpdateEnterpriseConfiguration {
        public static let id: Swift.String = "code-security/update-enterprise-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.enterprise = enterprise
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityUpdateEnterpriseConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityUpdateEnterpriseConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Headers
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the code security configuration. Must be unique across the enterprise.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// A description of the code security configuration
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/advanced_security`.
                    @frozen public enum AdvancedSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case codeSecurity = "code_security"
                        case secretProtection = "secret_protection"
                    }
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/advanced_security`.
                    public var advancedSecurity: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload?
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_security`.
                    @frozen public enum CodeSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_security`.
                    public var codeSecurity: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeSecurityPayload?
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph`.
                    @frozen public enum DependencyGraphPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph`.
                    public var dependencyGraph: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphPayload?
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action`.
                    @frozen public enum DependencyGraphAutosubmitActionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action`.
                    public var dependencyGraphAutosubmitAction: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload?
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public struct DependencyGraphAutosubmitActionOptionsPayload: Codable, Hashable, Sendable {
                        /// Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        ///
                        /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action_options/labeled_runners`.
                        public var labeledRunners: Swift.Bool?
                        /// Creates a new `DependencyGraphAutosubmitActionOptionsPayload`.
                        ///
                        /// - Parameters:
                        ///   - labeledRunners: Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        public init(labeledRunners: Swift.Bool? = nil) {
                            self.labeledRunners = labeledRunners
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labeledRunners = "labeled_runners"
                        }
                    }
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public var dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload?
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_alerts`.
                    @frozen public enum DependabotAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_alerts`.
                    public var dependabotAlerts: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload?
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_security_updates`.
                    @frozen public enum DependabotSecurityUpdatesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_security_updates`.
                    public var dependabotSecurityUpdates: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload?
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_default_setup`.
                    @frozen public enum CodeScanningDefaultSetupPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_default_setup`.
                    public var codeScanningDefaultSetup: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload?
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_default_setup_options`.
                    public var codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions?
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    @frozen public enum CodeScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    public var codeScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_protection`.
                    @frozen public enum SecretProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_protection`.
                    public var secretProtection: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretProtectionPayload?
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning`.
                    @frozen public enum SecretScanningPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning`.
                    public var secretScanning: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningPayload?
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_push_protection`.
                    @frozen public enum SecretScanningPushProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_push_protection`.
                    public var secretScanningPushProtection: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload?
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_validity_checks`.
                    @frozen public enum SecretScanningValidityChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_validity_checks`.
                    public var secretScanningValidityChecks: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload?
                    /// The enablement status of secret scanning non-provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_non_provider_patterns`.
                    @frozen public enum SecretScanningNonProviderPatternsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning non-provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_non_provider_patterns`.
                    public var secretScanningNonProviderPatterns: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload?
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_generic_secrets`.
                    @frozen public enum SecretScanningGenericSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_generic_secrets`.
                    public var secretScanningGenericSecrets: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload?
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    @frozen public enum SecretScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    public var secretScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/private_vulnerability_reporting`.
                    @frozen public enum PrivateVulnerabilityReportingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/private_vulnerability_reporting`.
                    public var privateVulnerabilityReporting: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload?
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/enforcement`.
                    @frozen public enum EnforcementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enforced = "enforced"
                        case unenforced = "unenforced"
                    }
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/enforcement`.
                    public var enforcement: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.EnforcementPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the code security configuration. Must be unique across the enterprise.
                    ///   - description: A description of the code security configuration
                    ///   - advancedSecurity: The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///   - codeSecurity: The enablement status of GitHub Code Security features.
                    ///   - dependencyGraph: The enablement status of Dependency Graph
                    ///   - dependencyGraphAutosubmitAction: The enablement status of Automatic dependency submission
                    ///   - dependencyGraphAutosubmitActionOptions: Feature options for Automatic dependency submission
                    ///   - dependabotAlerts: The enablement status of Dependabot alerts
                    ///   - dependabotSecurityUpdates: The enablement status of Dependabot security updates
                    ///   - codeScanningDefaultSetup: The enablement status of code scanning default setup
                    ///   - codeScanningDefaultSetupOptions:
                    ///   - codeScanningDelegatedAlertDismissal: The enablement status of code scanning delegated alert dismissal
                    ///   - secretProtection: The enablement status of GitHub Secret Protection features.
                    ///   - secretScanning: The enablement status of secret scanning
                    ///   - secretScanningPushProtection: The enablement status of secret scanning push protection
                    ///   - secretScanningValidityChecks: The enablement status of secret scanning validity checks
                    ///   - secretScanningNonProviderPatterns: The enablement status of secret scanning non-provider patterns
                    ///   - secretScanningGenericSecrets: The enablement status of Copilot secret scanning
                    ///   - secretScanningDelegatedAlertDismissal: The enablement status of secret scanning delegated alert dismissal
                    ///   - privateVulnerabilityReporting: The enablement status of private vulnerability reporting
                    ///   - enforcement: The enforcement status for a security configuration
                    public init(
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        advancedSecurity: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload? = nil,
                        codeSecurity: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeSecurityPayload? = nil,
                        dependencyGraph: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphPayload? = nil,
                        dependencyGraphAutosubmitAction: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload? = nil,
                        dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload? = nil,
                        dependabotAlerts: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload? = nil,
                        dependabotSecurityUpdates: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload? = nil,
                        codeScanningDefaultSetup: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload? = nil,
                        codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions? = nil,
                        codeScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload? = nil,
                        secretProtection: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretProtectionPayload? = nil,
                        secretScanning: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningPayload? = nil,
                        secretScanningPushProtection: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload? = nil,
                        secretScanningValidityChecks: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload? = nil,
                        secretScanningNonProviderPatterns: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload? = nil,
                        secretScanningGenericSecrets: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload? = nil,
                        secretScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload? = nil,
                        privateVulnerabilityReporting: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload? = nil,
                        enforcement: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.EnforcementPayload? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.advancedSecurity = advancedSecurity
                        self.codeSecurity = codeSecurity
                        self.dependencyGraph = dependencyGraph
                        self.dependencyGraphAutosubmitAction = dependencyGraphAutosubmitAction
                        self.dependencyGraphAutosubmitActionOptions = dependencyGraphAutosubmitActionOptions
                        self.dependabotAlerts = dependabotAlerts
                        self.dependabotSecurityUpdates = dependabotSecurityUpdates
                        self.codeScanningDefaultSetup = codeScanningDefaultSetup
                        self.codeScanningDefaultSetupOptions = codeScanningDefaultSetupOptions
                        self.codeScanningDelegatedAlertDismissal = codeScanningDelegatedAlertDismissal
                        self.secretProtection = secretProtection
                        self.secretScanning = secretScanning
                        self.secretScanningPushProtection = secretScanningPushProtection
                        self.secretScanningValidityChecks = secretScanningValidityChecks
                        self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                        self.secretScanningGenericSecrets = secretScanningGenericSecrets
                        self.secretScanningDelegatedAlertDismissal = secretScanningDelegatedAlertDismissal
                        self.privateVulnerabilityReporting = privateVulnerabilityReporting
                        self.enforcement = enforcement
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case advancedSecurity = "advanced_security"
                        case codeSecurity = "code_security"
                        case dependencyGraph = "dependency_graph"
                        case dependencyGraphAutosubmitAction = "dependency_graph_autosubmit_action"
                        case dependencyGraphAutosubmitActionOptions = "dependency_graph_autosubmit_action_options"
                        case dependabotAlerts = "dependabot_alerts"
                        case dependabotSecurityUpdates = "dependabot_security_updates"
                        case codeScanningDefaultSetup = "code_scanning_default_setup"
                        case codeScanningDefaultSetupOptions = "code_scanning_default_setup_options"
                        case codeScanningDelegatedAlertDismissal = "code_scanning_delegated_alert_dismissal"
                        case secretProtection = "secret_protection"
                        case secretScanning = "secret_scanning"
                        case secretScanningPushProtection = "secret_scanning_push_protection"
                        case secretScanningValidityChecks = "secret_scanning_validity_checks"
                        case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                        case secretScanningGenericSecrets = "secret_scanning_generic_secrets"
                        case secretScanningDelegatedAlertDismissal = "secret_scanning_delegated_alert_dismissal"
                        case privateVulnerabilityReporting = "private_vulnerability_reporting"
                        case enforcement
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.name = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .name
                        )
                        self.description = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .description
                        )
                        self.advancedSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload.self,
                            forKey: .advancedSecurity
                        )
                        self.codeSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeSecurityPayload.self,
                            forKey: .codeSecurity
                        )
                        self.dependencyGraph = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphPayload.self,
                            forKey: .dependencyGraph
                        )
                        self.dependencyGraphAutosubmitAction = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload.self,
                            forKey: .dependencyGraphAutosubmitAction
                        )
                        self.dependencyGraphAutosubmitActionOptions = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload.self,
                            forKey: .dependencyGraphAutosubmitActionOptions
                        )
                        self.dependabotAlerts = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload.self,
                            forKey: .dependabotAlerts
                        )
                        self.dependabotSecurityUpdates = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload.self,
                            forKey: .dependabotSecurityUpdates
                        )
                        self.codeScanningDefaultSetup = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload.self,
                            forKey: .codeScanningDefaultSetup
                        )
                        self.codeScanningDefaultSetupOptions = try container.decodeIfPresent(
                            Components.Schemas.CodeScanningDefaultSetupOptions.self,
                            forKey: .codeScanningDefaultSetupOptions
                        )
                        self.codeScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload.self,
                            forKey: .codeScanningDelegatedAlertDismissal
                        )
                        self.secretProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretProtectionPayload.self,
                            forKey: .secretProtection
                        )
                        self.secretScanning = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningPayload.self,
                            forKey: .secretScanning
                        )
                        self.secretScanningPushProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload.self,
                            forKey: .secretScanningPushProtection
                        )
                        self.secretScanningValidityChecks = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload.self,
                            forKey: .secretScanningValidityChecks
                        )
                        self.secretScanningNonProviderPatterns = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload.self,
                            forKey: .secretScanningNonProviderPatterns
                        )
                        self.secretScanningGenericSecrets = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload.self,
                            forKey: .secretScanningGenericSecrets
                        )
                        self.secretScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload.self,
                            forKey: .secretScanningDelegatedAlertDismissal
                        )
                        self.privateVulnerabilityReporting = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload.self,
                            forKey: .privateVulnerabilityReporting
                        )
                        self.enforcement = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload.EnforcementPayload.self,
                            forKey: .enforcement
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "name",
                            "description",
                            "advanced_security",
                            "code_security",
                            "dependency_graph",
                            "dependency_graph_autosubmit_action",
                            "dependency_graph_autosubmit_action_options",
                            "dependabot_alerts",
                            "dependabot_security_updates",
                            "code_scanning_default_setup",
                            "code_scanning_default_setup_options",
                            "code_scanning_delegated_alert_dismissal",
                            "secret_protection",
                            "secret_scanning",
                            "secret_scanning_push_protection",
                            "secret_scanning_validity_checks",
                            "secret_scanning_non_provider_patterns",
                            "secret_scanning_generic_secrets",
                            "secret_scanning_delegated_alert_dismissal",
                            "private_vulnerability_reporting",
                            "enforcement"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Path,
                headers: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Headers = .init(),
                body: Operations.CodeSecurityUpdateEnterpriseConfiguration.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityUpdateEnterpriseConfiguration.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityUpdateEnterpriseConfiguration.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityUpdateEnterpriseConfiguration.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityUpdateEnterpriseConfiguration.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/patch(code-security/update-enterprise-configuration)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a code security configuration for an enterprise
    ///
    /// Deletes a code security configuration from an enterprise.
    /// Repositories attached to the configuration will retain their settings but will no longer be associated with
    /// the configuration.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)`.
    public enum CodeSecurityDeleteConfigurationForEnterprise {
        public static let id: Swift.String = "code-security/delete-configuration-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/DELETE/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/DELETE/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.enterprise = enterprise
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityDeleteConfigurationForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityDeleteConfigurationForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input.Path,
                headers: Operations.CodeSecurityDeleteConfigurationForEnterprise.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Components.Responses.NoContent)
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Components.Responses.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration-for-enterprise)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Attach an enterprise configuration to repositories
    ///
    /// Attaches an enterprise code security configuration to repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.
    ///
    /// If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)`.
    public enum CodeSecurityAttachEnterpriseConfiguration {
        public static let id: Swift.String = "code-security/attach-enterprise-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.enterprise = enterprise
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityAttachEnterpriseConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityAttachEnterpriseConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Headers
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The type of repositories to attach the configuration to.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json/scope`.
                    @frozen public enum ScopePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case allWithoutConfigurations = "all_without_configurations"
                    }
                    /// The type of repositories to attach the configuration to.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json/scope`.
                    public var scope: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body.JsonPayload.ScopePayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - scope: The type of repositories to attach the configuration to.
                    public init(scope: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body.JsonPayload.ScopePayload) {
                        self.scope = scope
                    }
                    public enum CodingKeys: String, CodingKey {
                        case scope
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.scope = try container.decode(
                            Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body.JsonPayload.ScopePayload.self,
                            forKey: .scope
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "scope"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/POST/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Path,
                headers: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Headers = .init(),
                body: Operations.CodeSecurityAttachEnterpriseConfiguration.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-enterprise-configuration)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set a code security configuration as a default for an enterprise
    ///
    /// Sets a code security configuration as a default to be applied to new repositories in your enterprise.
    ///
    /// This configuration will be applied by default to the matching repository type when created, but only for organizations within the enterprise that do not already have a default code security configuration set.
    ///
    /// The authenticated user must be an administrator for the enterprise to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default-for-enterprise)`.
    public enum CodeSecuritySetConfigurationAsDefaultForEnterprise {
        public static let id: Swift.String = "code-security/set-configuration-as-default-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.enterprise = enterprise
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Headers
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Specify which types of repository this security configuration should be applied to by default.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/json/default_for_new_repos`.
                    @frozen public enum DefaultForNewReposPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case none = "none"
                        case privateAndInternal = "private_and_internal"
                        case _public = "public"
                    }
                    /// Specify which types of repository this security configuration should be applied to by default.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/json/default_for_new_repos`.
                    public var defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Body.JsonPayload.DefaultForNewReposPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - defaultForNewRepos: Specify which types of repository this security configuration should be applied to by default.
                    public init(defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Body.JsonPayload.DefaultForNewReposPayload? = nil) {
                        self.defaultForNewRepos = defaultForNewRepos
                    }
                    public enum CodingKeys: String, CodingKey {
                        case defaultForNewRepos = "default_for_new_repos"
                    }
                }
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/content/application\/json`.
                case json(Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Path,
                headers: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Headers = .init(),
                body: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Specifies which types of repository this security configuration is applied to by default.
                        ///
                        /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json/default_for_new_repos`.
                        @frozen public enum DefaultForNewReposPayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case all = "all"
                            case none = "none"
                            case privateAndInternal = "private_and_internal"
                            case _public = "public"
                        }
                        /// Specifies which types of repository this security configuration is applied to by default.
                        ///
                        /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json/default_for_new_repos`.
                        public var defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok.Body.JsonPayload.DefaultForNewReposPayload?
                        /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json/configuration`.
                        public var configuration: Components.Schemas.CodeSecurityConfiguration?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - defaultForNewRepos: Specifies which types of repository this security configuration is applied to by default.
                        ///   - configuration:
                        public init(
                            defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok.Body.JsonPayload.DefaultForNewReposPayload? = nil,
                            configuration: Components.Schemas.CodeSecurityConfiguration? = nil
                        ) {
                            self.defaultForNewRepos = defaultForNewRepos
                            self.configuration = configuration
                        }
                        public enum CodingKeys: String, CodingKey {
                            case defaultForNewRepos = "default_for_new_repos"
                            case configuration
                        }
                    }
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/application\/json`.
                    case json(Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Default successfully changed.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default-for-enterprise)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecuritySetConfigurationAsDefaultForEnterprise.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default-for-enterprise)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get repositories associated with an enterprise code security configuration
    ///
    /// Lists the repositories associated with an enterprise code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-enterprise-configuration)`.
    public enum CodeSecurityGetRepositoriesForEnterpriseConfiguration {
        public static let id: Swift.String = "code-security/get-repositories-for-enterprise-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.enterprise = enterprise
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// A comma-separated list of statuses. If specified, only repositories with these attachment statuses will be returned.
                ///
                /// Can be: `all`, `attached`, `attaching`, `removed`, `enforced`, `failed`, `updating`, `removed_by_enterprise`
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/query/status`.
                public var status: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - status: A comma-separated list of statuses. If specified, only repositories with these attachment statuses will be returned.
                public init(
                    perPage: Swift.Int? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    status: Swift.String? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.status = status
                }
            }
            public var query: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Query
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Path,
                query: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Query = .init(),
                headers: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeSecurityConfigurationRepositories])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeSecurityConfigurationRepositories] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-enterprise-configuration)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetRepositoriesForEnterpriseConfiguration.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-enterprise-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-enterprise-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get code security configurations for an organization
    ///
    /// Lists all code security configurations available in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/get(code-security/get-configurations-for-org)`.
    public enum CodeSecurityGetConfigurationsForOrg {
        public static let id: Swift.String = "code-security/get-configurations-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodeSecurityGetConfigurationsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/query/target_type`.
                @frozen public enum TargetTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case global = "global"
                    case all = "all"
                }
                /// The target type of the code security configuration
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/query/target_type`.
                public var targetType: Operations.CodeSecurityGetConfigurationsForOrg.Input.Query.TargetTypePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - targetType: The target type of the code security configuration
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    targetType: Operations.CodeSecurityGetConfigurationsForOrg.Input.Query.TargetTypePayload? = nil,
                    perPage: Swift.Int? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil
                ) {
                    self.targetType = targetType
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                }
            }
            public var query: Operations.CodeSecurityGetConfigurationsForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfigurationsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfigurationsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetConfigurationsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetConfigurationsForOrg.Input.Path,
                query: Operations.CodeSecurityGetConfigurationsForOrg.Input.Query = .init(),
                headers: Operations.CodeSecurityGetConfigurationsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeSecurityConfiguration])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeSecurityConfiguration] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetConfigurationsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetConfigurationsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/get(code-security/get-configurations-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetConfigurationsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetConfigurationsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/get(code-security/get-configurations-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/get(code-security/get-configurations-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a code security configuration
    ///
    /// Creates a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/code-security/configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/post(code-security/create-configuration)`.
    public enum CodeSecurityCreateConfiguration {
        public static let id: Swift.String = "code-security/create-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodeSecurityCreateConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityCreateConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityCreateConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityCreateConfiguration.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the code security configuration. Must be unique within the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// A description of the code security configuration
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/description`.
                    public var description: Swift.String
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/advanced_security`.
                    @frozen public enum AdvancedSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case codeSecurity = "code_security"
                        case secretProtection = "secret_protection"
                    }
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/advanced_security`.
                    public var advancedSecurity: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload?
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_security`.
                    @frozen public enum CodeSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_security`.
                    public var codeSecurity: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeSecurityPayload?
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph`.
                    @frozen public enum DependencyGraphPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph`.
                    public var dependencyGraph: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphPayload?
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action`.
                    @frozen public enum DependencyGraphAutosubmitActionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action`.
                    public var dependencyGraphAutosubmitAction: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload?
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public struct DependencyGraphAutosubmitActionOptionsPayload: Codable, Hashable, Sendable {
                        /// Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action_options/labeled_runners`.
                        public var labeledRunners: Swift.Bool?
                        /// Creates a new `DependencyGraphAutosubmitActionOptionsPayload`.
                        ///
                        /// - Parameters:
                        ///   - labeledRunners: Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        public init(labeledRunners: Swift.Bool? = nil) {
                            self.labeledRunners = labeledRunners
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labeledRunners = "labeled_runners"
                        }
                    }
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public var dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload?
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependabot_alerts`.
                    @frozen public enum DependabotAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependabot_alerts`.
                    public var dependabotAlerts: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload?
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependabot_security_updates`.
                    @frozen public enum DependabotSecurityUpdatesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/dependabot_security_updates`.
                    public var dependabotSecurityUpdates: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload?
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_scanning_options`.
                    public var codeScanningOptions: Components.Schemas.CodeScanningOptions?
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_scanning_default_setup`.
                    @frozen public enum CodeScanningDefaultSetupPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_scanning_default_setup`.
                    public var codeScanningDefaultSetup: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload?
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_scanning_default_setup_options`.
                    public var codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions?
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    @frozen public enum CodeScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    public var codeScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_protection`.
                    @frozen public enum SecretProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_protection`.
                    public var secretProtection: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretProtectionPayload?
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning`.
                    @frozen public enum SecretScanningPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning`.
                    public var secretScanning: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningPayload?
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_push_protection`.
                    @frozen public enum SecretScanningPushProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_push_protection`.
                    public var secretScanningPushProtection: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload?
                    /// The enablement status of secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass`.
                    @frozen public enum SecretScanningDelegatedBypassPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass`.
                    public var secretScanningDelegatedBypass: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassPayload?
                    /// Feature options for secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options`.
                    public struct SecretScanningDelegatedBypassOptionsPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload`.
                        public struct ReviewersPayloadPayload: Codable, Hashable, Sendable {
                            /// The ID of the team or role selected as a bypass reviewer
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_id`.
                            public var reviewerId: Swift.Int
                            /// The type of the bypass reviewer
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_type`.
                            @frozen public enum ReviewerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                                case team = "TEAM"
                                case role = "ROLE"
                            }
                            /// The type of the bypass reviewer
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_type`.
                            public var reviewerType: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload.ReviewerTypePayload
                            /// Creates a new `ReviewersPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - reviewerId: The ID of the team or role selected as a bypass reviewer
                            ///   - reviewerType: The type of the bypass reviewer
                            public init(
                                reviewerId: Swift.Int,
                                reviewerType: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload.ReviewerTypePayload
                            ) {
                                self.reviewerId = reviewerId
                                self.reviewerType = reviewerType
                            }
                            public enum CodingKeys: String, CodingKey {
                                case reviewerId = "reviewer_id"
                                case reviewerType = "reviewer_type"
                            }
                        }
                        /// The bypass reviewers for secret scanning delegated bypass
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options/reviewers`.
                        public typealias ReviewersPayload = [Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload]
                        /// The bypass reviewers for secret scanning delegated bypass
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options/reviewers`.
                        public var reviewers: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayload?
                        /// Creates a new `SecretScanningDelegatedBypassOptionsPayload`.
                        ///
                        /// - Parameters:
                        ///   - reviewers: The bypass reviewers for secret scanning delegated bypass
                        public init(reviewers: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayload? = nil) {
                            self.reviewers = reviewers
                        }
                        public enum CodingKeys: String, CodingKey {
                            case reviewers
                        }
                    }
                    /// Feature options for secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_bypass_options`.
                    public var secretScanningDelegatedBypassOptions: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload?
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_validity_checks`.
                    @frozen public enum SecretScanningValidityChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_validity_checks`.
                    public var secretScanningValidityChecks: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload?
                    /// The enablement status of secret scanning non provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_non_provider_patterns`.
                    @frozen public enum SecretScanningNonProviderPatternsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning non provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_non_provider_patterns`.
                    public var secretScanningNonProviderPatterns: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload?
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_generic_secrets`.
                    @frozen public enum SecretScanningGenericSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_generic_secrets`.
                    public var secretScanningGenericSecrets: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload?
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    @frozen public enum SecretScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    public var secretScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/private_vulnerability_reporting`.
                    @frozen public enum PrivateVulnerabilityReportingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/private_vulnerability_reporting`.
                    public var privateVulnerabilityReporting: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload?
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/enforcement`.
                    @frozen public enum EnforcementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enforced = "enforced"
                        case unenforced = "unenforced"
                    }
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/json/enforcement`.
                    public var enforcement: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.EnforcementPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the code security configuration. Must be unique within the organization.
                    ///   - description: A description of the code security configuration
                    ///   - advancedSecurity: The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///   - codeSecurity: The enablement status of GitHub Code Security features.
                    ///   - dependencyGraph: The enablement status of Dependency Graph
                    ///   - dependencyGraphAutosubmitAction: The enablement status of Automatic dependency submission
                    ///   - dependencyGraphAutosubmitActionOptions: Feature options for Automatic dependency submission
                    ///   - dependabotAlerts: The enablement status of Dependabot alerts
                    ///   - dependabotSecurityUpdates: The enablement status of Dependabot security updates
                    ///   - codeScanningOptions:
                    ///   - codeScanningDefaultSetup: The enablement status of code scanning default setup
                    ///   - codeScanningDefaultSetupOptions:
                    ///   - codeScanningDelegatedAlertDismissal: The enablement status of code scanning delegated alert dismissal
                    ///   - secretProtection: The enablement status of GitHub Secret Protection features.
                    ///   - secretScanning: The enablement status of secret scanning
                    ///   - secretScanningPushProtection: The enablement status of secret scanning push protection
                    ///   - secretScanningDelegatedBypass: The enablement status of secret scanning delegated bypass
                    ///   - secretScanningDelegatedBypassOptions: Feature options for secret scanning delegated bypass
                    ///   - secretScanningValidityChecks: The enablement status of secret scanning validity checks
                    ///   - secretScanningNonProviderPatterns: The enablement status of secret scanning non provider patterns
                    ///   - secretScanningGenericSecrets: The enablement status of Copilot secret scanning
                    ///   - secretScanningDelegatedAlertDismissal: The enablement status of secret scanning delegated alert dismissal
                    ///   - privateVulnerabilityReporting: The enablement status of private vulnerability reporting
                    ///   - enforcement: The enforcement status for a security configuration
                    public init(
                        name: Swift.String,
                        description: Swift.String,
                        advancedSecurity: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload? = nil,
                        codeSecurity: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeSecurityPayload? = nil,
                        dependencyGraph: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphPayload? = nil,
                        dependencyGraphAutosubmitAction: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload? = nil,
                        dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload? = nil,
                        dependabotAlerts: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload? = nil,
                        dependabotSecurityUpdates: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload? = nil,
                        codeScanningOptions: Components.Schemas.CodeScanningOptions? = nil,
                        codeScanningDefaultSetup: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload? = nil,
                        codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions? = nil,
                        codeScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload? = nil,
                        secretProtection: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretProtectionPayload? = nil,
                        secretScanning: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningPayload? = nil,
                        secretScanningPushProtection: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload? = nil,
                        secretScanningDelegatedBypass: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassPayload? = nil,
                        secretScanningDelegatedBypassOptions: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload? = nil,
                        secretScanningValidityChecks: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload? = nil,
                        secretScanningNonProviderPatterns: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload? = nil,
                        secretScanningGenericSecrets: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload? = nil,
                        secretScanningDelegatedAlertDismissal: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload? = nil,
                        privateVulnerabilityReporting: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload? = nil,
                        enforcement: Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.EnforcementPayload? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.advancedSecurity = advancedSecurity
                        self.codeSecurity = codeSecurity
                        self.dependencyGraph = dependencyGraph
                        self.dependencyGraphAutosubmitAction = dependencyGraphAutosubmitAction
                        self.dependencyGraphAutosubmitActionOptions = dependencyGraphAutosubmitActionOptions
                        self.dependabotAlerts = dependabotAlerts
                        self.dependabotSecurityUpdates = dependabotSecurityUpdates
                        self.codeScanningOptions = codeScanningOptions
                        self.codeScanningDefaultSetup = codeScanningDefaultSetup
                        self.codeScanningDefaultSetupOptions = codeScanningDefaultSetupOptions
                        self.codeScanningDelegatedAlertDismissal = codeScanningDelegatedAlertDismissal
                        self.secretProtection = secretProtection
                        self.secretScanning = secretScanning
                        self.secretScanningPushProtection = secretScanningPushProtection
                        self.secretScanningDelegatedBypass = secretScanningDelegatedBypass
                        self.secretScanningDelegatedBypassOptions = secretScanningDelegatedBypassOptions
                        self.secretScanningValidityChecks = secretScanningValidityChecks
                        self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                        self.secretScanningGenericSecrets = secretScanningGenericSecrets
                        self.secretScanningDelegatedAlertDismissal = secretScanningDelegatedAlertDismissal
                        self.privateVulnerabilityReporting = privateVulnerabilityReporting
                        self.enforcement = enforcement
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case advancedSecurity = "advanced_security"
                        case codeSecurity = "code_security"
                        case dependencyGraph = "dependency_graph"
                        case dependencyGraphAutosubmitAction = "dependency_graph_autosubmit_action"
                        case dependencyGraphAutosubmitActionOptions = "dependency_graph_autosubmit_action_options"
                        case dependabotAlerts = "dependabot_alerts"
                        case dependabotSecurityUpdates = "dependabot_security_updates"
                        case codeScanningOptions = "code_scanning_options"
                        case codeScanningDefaultSetup = "code_scanning_default_setup"
                        case codeScanningDefaultSetupOptions = "code_scanning_default_setup_options"
                        case codeScanningDelegatedAlertDismissal = "code_scanning_delegated_alert_dismissal"
                        case secretProtection = "secret_protection"
                        case secretScanning = "secret_scanning"
                        case secretScanningPushProtection = "secret_scanning_push_protection"
                        case secretScanningDelegatedBypass = "secret_scanning_delegated_bypass"
                        case secretScanningDelegatedBypassOptions = "secret_scanning_delegated_bypass_options"
                        case secretScanningValidityChecks = "secret_scanning_validity_checks"
                        case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                        case secretScanningGenericSecrets = "secret_scanning_generic_secrets"
                        case secretScanningDelegatedAlertDismissal = "secret_scanning_delegated_alert_dismissal"
                        case privateVulnerabilityReporting = "private_vulnerability_reporting"
                        case enforcement
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.name = try container.decode(
                            Swift.String.self,
                            forKey: .name
                        )
                        self.description = try container.decode(
                            Swift.String.self,
                            forKey: .description
                        )
                        self.advancedSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload.self,
                            forKey: .advancedSecurity
                        )
                        self.codeSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeSecurityPayload.self,
                            forKey: .codeSecurity
                        )
                        self.dependencyGraph = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphPayload.self,
                            forKey: .dependencyGraph
                        )
                        self.dependencyGraphAutosubmitAction = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload.self,
                            forKey: .dependencyGraphAutosubmitAction
                        )
                        self.dependencyGraphAutosubmitActionOptions = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload.self,
                            forKey: .dependencyGraphAutosubmitActionOptions
                        )
                        self.dependabotAlerts = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload.self,
                            forKey: .dependabotAlerts
                        )
                        self.dependabotSecurityUpdates = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload.self,
                            forKey: .dependabotSecurityUpdates
                        )
                        self.codeScanningOptions = try container.decodeIfPresent(
                            Components.Schemas.CodeScanningOptions.self,
                            forKey: .codeScanningOptions
                        )
                        self.codeScanningDefaultSetup = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload.self,
                            forKey: .codeScanningDefaultSetup
                        )
                        self.codeScanningDefaultSetupOptions = try container.decodeIfPresent(
                            Components.Schemas.CodeScanningDefaultSetupOptions.self,
                            forKey: .codeScanningDefaultSetupOptions
                        )
                        self.codeScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload.self,
                            forKey: .codeScanningDelegatedAlertDismissal
                        )
                        self.secretProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretProtectionPayload.self,
                            forKey: .secretProtection
                        )
                        self.secretScanning = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningPayload.self,
                            forKey: .secretScanning
                        )
                        self.secretScanningPushProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload.self,
                            forKey: .secretScanningPushProtection
                        )
                        self.secretScanningDelegatedBypass = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassPayload.self,
                            forKey: .secretScanningDelegatedBypass
                        )
                        self.secretScanningDelegatedBypassOptions = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.self,
                            forKey: .secretScanningDelegatedBypassOptions
                        )
                        self.secretScanningValidityChecks = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload.self,
                            forKey: .secretScanningValidityChecks
                        )
                        self.secretScanningNonProviderPatterns = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload.self,
                            forKey: .secretScanningNonProviderPatterns
                        )
                        self.secretScanningGenericSecrets = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload.self,
                            forKey: .secretScanningGenericSecrets
                        )
                        self.secretScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload.self,
                            forKey: .secretScanningDelegatedAlertDismissal
                        )
                        self.privateVulnerabilityReporting = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload.self,
                            forKey: .privateVulnerabilityReporting
                        )
                        self.enforcement = try container.decodeIfPresent(
                            Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload.EnforcementPayload.self,
                            forKey: .enforcement
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "name",
                            "description",
                            "advanced_security",
                            "code_security",
                            "dependency_graph",
                            "dependency_graph_autosubmit_action",
                            "dependency_graph_autosubmit_action_options",
                            "dependabot_alerts",
                            "dependabot_security_updates",
                            "code_scanning_options",
                            "code_scanning_default_setup",
                            "code_scanning_default_setup_options",
                            "code_scanning_delegated_alert_dismissal",
                            "secret_protection",
                            "secret_scanning",
                            "secret_scanning_push_protection",
                            "secret_scanning_delegated_bypass",
                            "secret_scanning_delegated_bypass_options",
                            "secret_scanning_validity_checks",
                            "secret_scanning_non_provider_patterns",
                            "secret_scanning_generic_secrets",
                            "secret_scanning_delegated_alert_dismissal",
                            "private_vulnerability_reporting",
                            "enforcement"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityCreateConfiguration.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityCreateConfiguration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityCreateConfiguration.Input.Path,
                headers: Operations.CodeSecurityCreateConfiguration.Input.Headers = .init(),
                body: Operations.CodeSecurityCreateConfiguration.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityCreateConfiguration.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityCreateConfiguration.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Successfully created code security configuration
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/post(code-security/create-configuration)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodeSecurityCreateConfiguration.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodeSecurityCreateConfiguration.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get default code security configurations
    ///
    /// Lists the default code security configurations for an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/defaults`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)`.
    public enum CodeSecurityGetDefaultConfigurations {
        public static let id: Swift.String = "code-security/get-default-configurations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/defaults/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/defaults/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodeSecurityGetDefaultConfigurations.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/defaults/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetDefaultConfigurations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetDefaultConfigurations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetDefaultConfigurations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetDefaultConfigurations.Input.Path,
                headers: Operations.CodeSecurityGetDefaultConfigurations.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/defaults/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/defaults/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityDefaultConfigurations)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityDefaultConfigurations {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetDefaultConfigurations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetDefaultConfigurations.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetDefaultConfigurations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetDefaultConfigurations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/defaults/get(code-security/get-default-configurations)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Detach configurations from repositories
    ///
    /// Detach code security configuration(s) from a set of repositories.
    /// Repositories will retain their settings but will no longer be associated with the configuration.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/code-security/configurations/detach`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)`.
    public enum CodeSecurityDetachConfiguration {
        public static let id: Swift.String = "code-security/detach-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodeSecurityDetachConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityDetachConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityDetachConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityDetachConfiguration.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// An array of repository IDs to detach from configurations. Up to 250 IDs can be provided.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedRepositoryIds: An array of repository IDs to detach from configurations. Up to 250 IDs can be provided.
                    public init(selectedRepositoryIds: [Swift.Int]? = nil) {
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.selectedRepositoryIds = try container.decodeIfPresent(
                            [Swift.Int].self,
                            forKey: .selectedRepositoryIds
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "selected_repository_ids"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/detach/DELETE/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityDetachConfiguration.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityDetachConfiguration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityDetachConfiguration.Input.Path,
                headers: Operations.CodeSecurityDetachConfiguration.Input.Headers = .init(),
                body: Operations.CodeSecurityDetachConfiguration.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Components.Responses.NoContent)
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Components.Responses.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/detach/delete(code-security/detach-configuration)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get a code security configuration
    ///
    /// Gets a code security configuration available in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)`.
    public enum CodeSecurityGetConfiguration {
        public static let id: Swift.String = "code-security/get-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/GET/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    org: Components.Parameters.Org,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.org = org
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityGetConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetConfiguration.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetConfiguration.Input.Path,
                headers: Operations.CodeSecurityGetConfiguration.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetConfiguration.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetConfiguration.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetConfiguration.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetConfiguration.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/get(code-security/get-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a code security configuration
    ///
    /// Updates a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/patch(code-security/update-configuration)`.
    public enum CodeSecurityUpdateConfiguration {
        public static let id: Swift.String = "code-security/update-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    org: Components.Parameters.Org,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.org = org
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityUpdateConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityUpdateConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityUpdateConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityUpdateConfiguration.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the code security configuration. Must be unique within the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// A description of the code security configuration
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/advanced_security`.
                    @frozen public enum AdvancedSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case codeSecurity = "code_security"
                        case secretProtection = "secret_protection"
                    }
                    /// The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///
                    /// > [!WARNING]
                    /// > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features.
                    ///
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/advanced_security`.
                    public var advancedSecurity: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload?
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_security`.
                    @frozen public enum CodeSecurityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Code Security features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_security`.
                    public var codeSecurity: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeSecurityPayload?
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph`.
                    @frozen public enum DependencyGraphPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependency Graph
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph`.
                    public var dependencyGraph: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphPayload?
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action`.
                    @frozen public enum DependencyGraphAutosubmitActionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action`.
                    public var dependencyGraphAutosubmitAction: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload?
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public struct DependencyGraphAutosubmitActionOptionsPayload: Codable, Hashable, Sendable {
                        /// Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action_options/labeled_runners`.
                        public var labeledRunners: Swift.Bool?
                        /// Creates a new `DependencyGraphAutosubmitActionOptionsPayload`.
                        ///
                        /// - Parameters:
                        ///   - labeledRunners: Whether to use runners labeled with 'dependency-submission' or standard GitHub runners.
                        public init(labeledRunners: Swift.Bool? = nil) {
                            self.labeledRunners = labeledRunners
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labeledRunners = "labeled_runners"
                        }
                    }
                    /// Feature options for Automatic dependency submission
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependency_graph_autosubmit_action_options`.
                    public var dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload?
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_alerts`.
                    @frozen public enum DependabotAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot alerts
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_alerts`.
                    public var dependabotAlerts: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload?
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_security_updates`.
                    @frozen public enum DependabotSecurityUpdatesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Dependabot security updates
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/dependabot_security_updates`.
                    public var dependabotSecurityUpdates: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload?
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_default_setup`.
                    @frozen public enum CodeScanningDefaultSetupPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning default setup
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_default_setup`.
                    public var codeScanningDefaultSetup: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload?
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_default_setup_options`.
                    public var codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions?
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    @frozen public enum CodeScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of code scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/code_scanning_delegated_alert_dismissal`.
                    public var codeScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_protection`.
                    @frozen public enum SecretProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of GitHub Secret Protection features.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_protection`.
                    public var secretProtection: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretProtectionPayload?
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning`.
                    @frozen public enum SecretScanningPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning`.
                    public var secretScanning: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningPayload?
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_push_protection`.
                    @frozen public enum SecretScanningPushProtectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning push protection
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_push_protection`.
                    public var secretScanningPushProtection: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload?
                    /// The enablement status of secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass`.
                    @frozen public enum SecretScanningDelegatedBypassPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass`.
                    public var secretScanningDelegatedBypass: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassPayload?
                    /// Feature options for secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options`.
                    public struct SecretScanningDelegatedBypassOptionsPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload`.
                        public struct ReviewersPayloadPayload: Codable, Hashable, Sendable {
                            /// The ID of the team or role selected as a bypass reviewer
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_id`.
                            public var reviewerId: Swift.Int
                            /// The type of the bypass reviewer
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_type`.
                            @frozen public enum ReviewerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                                case team = "TEAM"
                                case role = "ROLE"
                            }
                            /// The type of the bypass reviewer
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options/ReviewersPayload/reviewer_type`.
                            public var reviewerType: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload.ReviewerTypePayload
                            /// Creates a new `ReviewersPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - reviewerId: The ID of the team or role selected as a bypass reviewer
                            ///   - reviewerType: The type of the bypass reviewer
                            public init(
                                reviewerId: Swift.Int,
                                reviewerType: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload.ReviewerTypePayload
                            ) {
                                self.reviewerId = reviewerId
                                self.reviewerType = reviewerType
                            }
                            public enum CodingKeys: String, CodingKey {
                                case reviewerId = "reviewer_id"
                                case reviewerType = "reviewer_type"
                            }
                        }
                        /// The bypass reviewers for secret scanning delegated bypass
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options/reviewers`.
                        public typealias ReviewersPayload = [Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayloadPayload]
                        /// The bypass reviewers for secret scanning delegated bypass
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options/reviewers`.
                        public var reviewers: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayload?
                        /// Creates a new `SecretScanningDelegatedBypassOptionsPayload`.
                        ///
                        /// - Parameters:
                        ///   - reviewers: The bypass reviewers for secret scanning delegated bypass
                        public init(reviewers: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.ReviewersPayload? = nil) {
                            self.reviewers = reviewers
                        }
                        public enum CodingKeys: String, CodingKey {
                            case reviewers
                        }
                    }
                    /// Feature options for secret scanning delegated bypass
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_bypass_options`.
                    public var secretScanningDelegatedBypassOptions: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload?
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_validity_checks`.
                    @frozen public enum SecretScanningValidityChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning validity checks
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_validity_checks`.
                    public var secretScanningValidityChecks: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload?
                    /// The enablement status of secret scanning non-provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_non_provider_patterns`.
                    @frozen public enum SecretScanningNonProviderPatternsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning non-provider patterns
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_non_provider_patterns`.
                    public var secretScanningNonProviderPatterns: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload?
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_generic_secrets`.
                    @frozen public enum SecretScanningGenericSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of Copilot secret scanning
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_generic_secrets`.
                    public var secretScanningGenericSecrets: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload?
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    @frozen public enum SecretScanningDelegatedAlertDismissalPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of secret scanning delegated alert dismissal
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/secret_scanning_delegated_alert_dismissal`.
                    public var secretScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload?
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/private_vulnerability_reporting`.
                    @frozen public enum PrivateVulnerabilityReportingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enabled = "enabled"
                        case disabled = "disabled"
                        case notSet = "not_set"
                    }
                    /// The enablement status of private vulnerability reporting
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/private_vulnerability_reporting`.
                    public var privateVulnerabilityReporting: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload?
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/enforcement`.
                    @frozen public enum EnforcementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case enforced = "enforced"
                        case unenforced = "unenforced"
                    }
                    /// The enforcement status for a security configuration
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/json/enforcement`.
                    public var enforcement: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.EnforcementPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the code security configuration. Must be unique within the organization.
                    ///   - description: A description of the code security configuration
                    ///   - advancedSecurity: The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.
                    ///   - codeSecurity: The enablement status of GitHub Code Security features.
                    ///   - dependencyGraph: The enablement status of Dependency Graph
                    ///   - dependencyGraphAutosubmitAction: The enablement status of Automatic dependency submission
                    ///   - dependencyGraphAutosubmitActionOptions: Feature options for Automatic dependency submission
                    ///   - dependabotAlerts: The enablement status of Dependabot alerts
                    ///   - dependabotSecurityUpdates: The enablement status of Dependabot security updates
                    ///   - codeScanningDefaultSetup: The enablement status of code scanning default setup
                    ///   - codeScanningDefaultSetupOptions:
                    ///   - codeScanningDelegatedAlertDismissal: The enablement status of code scanning delegated alert dismissal
                    ///   - secretProtection: The enablement status of GitHub Secret Protection features.
                    ///   - secretScanning: The enablement status of secret scanning
                    ///   - secretScanningPushProtection: The enablement status of secret scanning push protection
                    ///   - secretScanningDelegatedBypass: The enablement status of secret scanning delegated bypass
                    ///   - secretScanningDelegatedBypassOptions: Feature options for secret scanning delegated bypass
                    ///   - secretScanningValidityChecks: The enablement status of secret scanning validity checks
                    ///   - secretScanningNonProviderPatterns: The enablement status of secret scanning non-provider patterns
                    ///   - secretScanningGenericSecrets: The enablement status of Copilot secret scanning
                    ///   - secretScanningDelegatedAlertDismissal: The enablement status of secret scanning delegated alert dismissal
                    ///   - privateVulnerabilityReporting: The enablement status of private vulnerability reporting
                    ///   - enforcement: The enforcement status for a security configuration
                    public init(
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        advancedSecurity: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload? = nil,
                        codeSecurity: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeSecurityPayload? = nil,
                        dependencyGraph: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphPayload? = nil,
                        dependencyGraphAutosubmitAction: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload? = nil,
                        dependencyGraphAutosubmitActionOptions: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload? = nil,
                        dependabotAlerts: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload? = nil,
                        dependabotSecurityUpdates: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload? = nil,
                        codeScanningDefaultSetup: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload? = nil,
                        codeScanningDefaultSetupOptions: Components.Schemas.CodeScanningDefaultSetupOptions? = nil,
                        codeScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload? = nil,
                        secretProtection: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretProtectionPayload? = nil,
                        secretScanning: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningPayload? = nil,
                        secretScanningPushProtection: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload? = nil,
                        secretScanningDelegatedBypass: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassPayload? = nil,
                        secretScanningDelegatedBypassOptions: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload? = nil,
                        secretScanningValidityChecks: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload? = nil,
                        secretScanningNonProviderPatterns: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload? = nil,
                        secretScanningGenericSecrets: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload? = nil,
                        secretScanningDelegatedAlertDismissal: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload? = nil,
                        privateVulnerabilityReporting: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload? = nil,
                        enforcement: Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.EnforcementPayload? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.advancedSecurity = advancedSecurity
                        self.codeSecurity = codeSecurity
                        self.dependencyGraph = dependencyGraph
                        self.dependencyGraphAutosubmitAction = dependencyGraphAutosubmitAction
                        self.dependencyGraphAutosubmitActionOptions = dependencyGraphAutosubmitActionOptions
                        self.dependabotAlerts = dependabotAlerts
                        self.dependabotSecurityUpdates = dependabotSecurityUpdates
                        self.codeScanningDefaultSetup = codeScanningDefaultSetup
                        self.codeScanningDefaultSetupOptions = codeScanningDefaultSetupOptions
                        self.codeScanningDelegatedAlertDismissal = codeScanningDelegatedAlertDismissal
                        self.secretProtection = secretProtection
                        self.secretScanning = secretScanning
                        self.secretScanningPushProtection = secretScanningPushProtection
                        self.secretScanningDelegatedBypass = secretScanningDelegatedBypass
                        self.secretScanningDelegatedBypassOptions = secretScanningDelegatedBypassOptions
                        self.secretScanningValidityChecks = secretScanningValidityChecks
                        self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                        self.secretScanningGenericSecrets = secretScanningGenericSecrets
                        self.secretScanningDelegatedAlertDismissal = secretScanningDelegatedAlertDismissal
                        self.privateVulnerabilityReporting = privateVulnerabilityReporting
                        self.enforcement = enforcement
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case advancedSecurity = "advanced_security"
                        case codeSecurity = "code_security"
                        case dependencyGraph = "dependency_graph"
                        case dependencyGraphAutosubmitAction = "dependency_graph_autosubmit_action"
                        case dependencyGraphAutosubmitActionOptions = "dependency_graph_autosubmit_action_options"
                        case dependabotAlerts = "dependabot_alerts"
                        case dependabotSecurityUpdates = "dependabot_security_updates"
                        case codeScanningDefaultSetup = "code_scanning_default_setup"
                        case codeScanningDefaultSetupOptions = "code_scanning_default_setup_options"
                        case codeScanningDelegatedAlertDismissal = "code_scanning_delegated_alert_dismissal"
                        case secretProtection = "secret_protection"
                        case secretScanning = "secret_scanning"
                        case secretScanningPushProtection = "secret_scanning_push_protection"
                        case secretScanningDelegatedBypass = "secret_scanning_delegated_bypass"
                        case secretScanningDelegatedBypassOptions = "secret_scanning_delegated_bypass_options"
                        case secretScanningValidityChecks = "secret_scanning_validity_checks"
                        case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                        case secretScanningGenericSecrets = "secret_scanning_generic_secrets"
                        case secretScanningDelegatedAlertDismissal = "secret_scanning_delegated_alert_dismissal"
                        case privateVulnerabilityReporting = "private_vulnerability_reporting"
                        case enforcement
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.name = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .name
                        )
                        self.description = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .description
                        )
                        self.advancedSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.AdvancedSecurityPayload.self,
                            forKey: .advancedSecurity
                        )
                        self.codeSecurity = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeSecurityPayload.self,
                            forKey: .codeSecurity
                        )
                        self.dependencyGraph = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphPayload.self,
                            forKey: .dependencyGraph
                        )
                        self.dependencyGraphAutosubmitAction = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionPayload.self,
                            forKey: .dependencyGraphAutosubmitAction
                        )
                        self.dependencyGraphAutosubmitActionOptions = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependencyGraphAutosubmitActionOptionsPayload.self,
                            forKey: .dependencyGraphAutosubmitActionOptions
                        )
                        self.dependabotAlerts = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependabotAlertsPayload.self,
                            forKey: .dependabotAlerts
                        )
                        self.dependabotSecurityUpdates = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.DependabotSecurityUpdatesPayload.self,
                            forKey: .dependabotSecurityUpdates
                        )
                        self.codeScanningDefaultSetup = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeScanningDefaultSetupPayload.self,
                            forKey: .codeScanningDefaultSetup
                        )
                        self.codeScanningDefaultSetupOptions = try container.decodeIfPresent(
                            Components.Schemas.CodeScanningDefaultSetupOptions.self,
                            forKey: .codeScanningDefaultSetupOptions
                        )
                        self.codeScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.CodeScanningDelegatedAlertDismissalPayload.self,
                            forKey: .codeScanningDelegatedAlertDismissal
                        )
                        self.secretProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretProtectionPayload.self,
                            forKey: .secretProtection
                        )
                        self.secretScanning = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningPayload.self,
                            forKey: .secretScanning
                        )
                        self.secretScanningPushProtection = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningPushProtectionPayload.self,
                            forKey: .secretScanningPushProtection
                        )
                        self.secretScanningDelegatedBypass = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassPayload.self,
                            forKey: .secretScanningDelegatedBypass
                        )
                        self.secretScanningDelegatedBypassOptions = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedBypassOptionsPayload.self,
                            forKey: .secretScanningDelegatedBypassOptions
                        )
                        self.secretScanningValidityChecks = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningValidityChecksPayload.self,
                            forKey: .secretScanningValidityChecks
                        )
                        self.secretScanningNonProviderPatterns = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningNonProviderPatternsPayload.self,
                            forKey: .secretScanningNonProviderPatterns
                        )
                        self.secretScanningGenericSecrets = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningGenericSecretsPayload.self,
                            forKey: .secretScanningGenericSecrets
                        )
                        self.secretScanningDelegatedAlertDismissal = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.SecretScanningDelegatedAlertDismissalPayload.self,
                            forKey: .secretScanningDelegatedAlertDismissal
                        )
                        self.privateVulnerabilityReporting = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.PrivateVulnerabilityReportingPayload.self,
                            forKey: .privateVulnerabilityReporting
                        )
                        self.enforcement = try container.decodeIfPresent(
                            Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload.EnforcementPayload.self,
                            forKey: .enforcement
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "name",
                            "description",
                            "advanced_security",
                            "code_security",
                            "dependency_graph",
                            "dependency_graph_autosubmit_action",
                            "dependency_graph_autosubmit_action_options",
                            "dependabot_alerts",
                            "dependabot_security_updates",
                            "code_scanning_default_setup",
                            "code_scanning_default_setup_options",
                            "code_scanning_delegated_alert_dismissal",
                            "secret_protection",
                            "secret_scanning",
                            "secret_scanning_push_protection",
                            "secret_scanning_delegated_bypass",
                            "secret_scanning_delegated_bypass_options",
                            "secret_scanning_validity_checks",
                            "secret_scanning_non_provider_patterns",
                            "secret_scanning_generic_secrets",
                            "secret_scanning_delegated_alert_dismissal",
                            "private_vulnerability_reporting",
                            "enforcement"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityUpdateConfiguration.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityUpdateConfiguration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityUpdateConfiguration.Input.Path,
                headers: Operations.CodeSecurityUpdateConfiguration.Input.Headers = .init(),
                body: Operations.CodeSecurityUpdateConfiguration.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityUpdateConfiguration.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityUpdateConfiguration.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when a configuration is updated
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/patch(code-security/update-configuration)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityUpdateConfiguration.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityUpdateConfiguration.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when no new updates are made
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/patch(code-security/update-configuration)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodeSecurityUpdateConfiguration.Output.NoContent)
            /// Response when no new updates are made
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/patch(code-security/update-configuration)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodeSecurityUpdateConfiguration.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a code security configuration
    ///
    /// Deletes the desired code security configuration from an organization.
    /// Repositories attached to the configuration will retain their settings but will no longer be associated with
    /// the configuration.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/code-security/configurations/{configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)`.
    public enum CodeSecurityDeleteConfiguration {
        public static let id: Swift.String = "code-security/delete-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/DELETE/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    org: Components.Parameters.Org,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.org = org
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityDeleteConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityDeleteConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityDeleteConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityDeleteConfiguration.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityDeleteConfiguration.Input.Path,
                headers: Operations.CodeSecurityDeleteConfiguration.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Components.Responses.NoContent)
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Components.Responses.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/delete(code-security/delete-configuration)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Attach a configuration to repositories
    ///
    /// Attach a code security configuration to a set of repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.
    ///
    /// If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/code-security/configurations/{configuration_id}/attach`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-configuration)`.
    public enum CodeSecurityAttachConfiguration {
        public static let id: Swift.String = "code-security/attach-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    org: Components.Parameters.Org,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.org = org
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityAttachConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityAttachConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityAttachConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityAttachConfiguration.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The type of repositories to attach the configuration to. `selected` means the configuration will be attached to only the repositories specified by `selected_repository_ids`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json/scope`.
                    @frozen public enum ScopePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case allWithoutConfigurations = "all_without_configurations"
                        case _public = "public"
                        case privateOrInternal = "private_or_internal"
                        case selected = "selected"
                    }
                    /// The type of repositories to attach the configuration to. `selected` means the configuration will be attached to only the repositories specified by `selected_repository_ids`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json/scope`.
                    public var scope: Operations.CodeSecurityAttachConfiguration.Input.Body.JsonPayload.ScopePayload
                    /// An array of repository IDs to attach the configuration to. You can only provide a list of repository ids when the `scope` is set to `selected`.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - scope: The type of repositories to attach the configuration to. `selected` means the configuration will be attached to only the repositories specified by `selected_repository_ids`
                    ///   - selectedRepositoryIds: An array of repository IDs to attach the configuration to. You can only provide a list of repository ids when the `scope` is set to `selected`.
                    public init(
                        scope: Operations.CodeSecurityAttachConfiguration.Input.Body.JsonPayload.ScopePayload,
                        selectedRepositoryIds: [Swift.Int]? = nil
                    ) {
                        self.scope = scope
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case scope
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.scope = try container.decode(
                            Operations.CodeSecurityAttachConfiguration.Input.Body.JsonPayload.ScopePayload.self,
                            forKey: .scope
                        )
                        self.selectedRepositoryIds = try container.decodeIfPresent(
                            [Swift.Int].self,
                            forKey: .selectedRepositoryIds
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "scope",
                            "selected_repository_ids"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/attach/POST/requestBody/content/application\/json`.
                case json(Operations.CodeSecurityAttachConfiguration.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecurityAttachConfiguration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecurityAttachConfiguration.Input.Path,
                headers: Operations.CodeSecurityAttachConfiguration.Input.Headers = .init(),
                body: Operations.CodeSecurityAttachConfiguration.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/attach/post(code-security/attach-configuration)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set a code security configuration as a default for an organization
    ///
    /// Sets a code security configuration as a default to be applied to new repositories in your organization.
    ///
    /// This configuration will be applied to the matching repository type (all, none, public, private and internal) by default when they are created.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/code-security/configurations/{configuration_id}/defaults`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default)`.
    public enum CodeSecuritySetConfigurationAsDefault {
        public static let id: Swift.String = "code-security/set-configuration-as-default"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    org: Components.Parameters.Org,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.org = org
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecuritySetConfigurationAsDefault.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecuritySetConfigurationAsDefault.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecuritySetConfigurationAsDefault.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecuritySetConfigurationAsDefault.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Specify which types of repository this security configuration should be applied to by default.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/json/default_for_new_repos`.
                    @frozen public enum DefaultForNewReposPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case none = "none"
                        case privateAndInternal = "private_and_internal"
                        case _public = "public"
                    }
                    /// Specify which types of repository this security configuration should be applied to by default.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/json/default_for_new_repos`.
                    public var defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefault.Input.Body.JsonPayload.DefaultForNewReposPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - defaultForNewRepos: Specify which types of repository this security configuration should be applied to by default.
                    public init(defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefault.Input.Body.JsonPayload.DefaultForNewReposPayload? = nil) {
                        self.defaultForNewRepos = defaultForNewRepos
                    }
                    public enum CodingKeys: String, CodingKey {
                        case defaultForNewRepos = "default_for_new_repos"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/requestBody/content/application\/json`.
                case json(Operations.CodeSecuritySetConfigurationAsDefault.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeSecuritySetConfigurationAsDefault.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeSecuritySetConfigurationAsDefault.Input.Path,
                headers: Operations.CodeSecuritySetConfigurationAsDefault.Input.Headers = .init(),
                body: Operations.CodeSecuritySetConfigurationAsDefault.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Specifies which types of repository this security configuration is applied to by default.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json/default_for_new_repos`.
                        @frozen public enum DefaultForNewReposPayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case all = "all"
                            case none = "none"
                            case privateAndInternal = "private_and_internal"
                            case _public = "public"
                        }
                        /// Specifies which types of repository this security configuration is applied to by default.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json/default_for_new_repos`.
                        public var defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok.Body.JsonPayload.DefaultForNewReposPayload?
                        /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/json/configuration`.
                        public var configuration: Components.Schemas.CodeSecurityConfiguration?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - defaultForNewRepos: Specifies which types of repository this security configuration is applied to by default.
                        ///   - configuration:
                        public init(
                            defaultForNewRepos: Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok.Body.JsonPayload.DefaultForNewReposPayload? = nil,
                            configuration: Components.Schemas.CodeSecurityConfiguration? = nil
                        ) {
                            self.defaultForNewRepos = defaultForNewRepos
                            self.configuration = configuration
                        }
                        public enum CodingKeys: String, CodingKey {
                            case defaultForNewRepos = "default_for_new_repos"
                            case configuration
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/defaults/PUT/responses/200/content/application\/json`.
                    case json(Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Default successfully changed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecuritySetConfigurationAsDefault.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/defaults/put(code-security/set-configuration-as-default)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get repositories associated with a code security configuration
    ///
    /// Lists the repositories associated with a code security configuration in an organization.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-security/configurations/{configuration_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-configuration)`.
    public enum CodeSecurityGetRepositoriesForConfiguration {
        public static let id: Swift.String = "code-security/get-repositories-for-configuration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the code security configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/path/configuration_id`.
                public var configurationId: Components.Parameters.ConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - configurationId: The unique identifier of the code security configuration.
                public init(
                    org: Components.Parameters.Org,
                    configurationId: Components.Parameters.ConfigurationId
                ) {
                    self.org = org
                    self.configurationId = configurationId
                }
            }
            public var path: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// A comma-separated list of statuses. If specified, only repositories with these attachment statuses will be returned.
                ///
                /// Can be: `all`, `attached`, `attaching`, `detached`, `removed`, `enforced`, `failed`, `updating`, `removed_by_enterprise`
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/query/status`.
                public var status: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - status: A comma-separated list of statuses. If specified, only repositories with these attachment statuses will be returned.
                public init(
                    perPage: Swift.Int? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    status: Swift.String? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.status = status
                }
            }
            public var query: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetRepositoriesForConfiguration.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetRepositoriesForConfiguration.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Path,
                query: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Query = .init(),
                headers: Operations.CodeSecurityGetRepositoriesForConfiguration.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-security/configurations/{configuration_id}/repositories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeSecurityConfigurationRepositories])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeSecurityConfigurationRepositories] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetRepositoriesForConfiguration.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetRepositoriesForConfiguration.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-configuration)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetRepositoriesForConfiguration.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetRepositoriesForConfiguration.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-configuration)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-security/configurations/{configuration_id}/repositories/get(code-security/get-repositories-for-configuration)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get the code security configuration associated with a repository
    ///
    /// Get the code security configuration that manages a repository's code security settings.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-security-configuration`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)`.
    public enum CodeSecurityGetConfigurationForRepository {
        public static let id: Swift.String = "code-security/get-configuration-for-repository"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-security-configuration/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-security-configuration/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-security-configuration/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeSecurityGetConfigurationForRepository.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-security-configuration/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfigurationForRepository.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeSecurityGetConfigurationForRepository.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeSecurityGetConfigurationForRepository.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeSecurityGetConfigurationForRepository.Input.Path,
                headers: Operations.CodeSecurityGetConfigurationForRepository.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-security-configuration/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-security-configuration/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeSecurityConfigurationForRepository)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeSecurityConfigurationForRepository {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeSecurityGetConfigurationForRepository.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeSecurityGetConfigurationForRepository.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeSecurityGetConfigurationForRepository.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeSecurityGetConfigurationForRepository.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Components.Responses.NoContent)
            /// A header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Components.Responses.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-security-configuration/get(code-security/get-configuration-for-repository)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
