// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get billing usage report for an organization
    ///
    /// Gets a report of the total usage for an organization. To use this endpoint, you must be an administrator of an organization within an enterprise or an organization account.
    ///
    /// **Note:** This endpoint is only available to organizations with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform](https://docs.github.com/billing/using-the-new-billing-platform)."
    ///
    /// - Remark: HTTP `GET /organizations/{org}/settings/billing/usage`.
    /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)`.
    func billingGetGithubBillingUsageReportOrg(_ input: Operations.BillingGetGithubBillingUsageReportOrg.Input) async throws -> Operations.BillingGetGithubBillingUsageReportOrg.Output
    /// Get GitHub Actions billing for an organization
    ///
    /// Gets the summary of the free and paid GitHub Actions minutes used.
    ///
    /// Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/actions/get(billing/get-github-actions-billing-org)`.
    func billingGetGithubActionsBillingOrg(_ input: Operations.BillingGetGithubActionsBillingOrg.Input) async throws -> Operations.BillingGetGithubActionsBillingOrg.Output
    /// Get GitHub Packages billing for an organization
    ///
    /// Gets the free and paid storage used for GitHub Packages in gigabytes.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/packages`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/packages/get(billing/get-github-packages-billing-org)`.
    func billingGetGithubPackagesBillingOrg(_ input: Operations.BillingGetGithubPackagesBillingOrg.Input) async throws -> Operations.BillingGetGithubPackagesBillingOrg.Output
    /// Get shared storage billing for an organization
    ///
    /// Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/shared-storage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-org)`.
    func billingGetSharedStorageBillingOrg(_ input: Operations.BillingGetSharedStorageBillingOrg.Input) async throws -> Operations.BillingGetSharedStorageBillingOrg.Output
    /// Get GitHub Actions billing for a user
    ///
    /// Gets the summary of the free and paid GitHub Actions minutes used.
    ///
    /// Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/actions`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/actions/get(billing/get-github-actions-billing-user)`.
    func billingGetGithubActionsBillingUser(_ input: Operations.BillingGetGithubActionsBillingUser.Input) async throws -> Operations.BillingGetGithubActionsBillingUser.Output
    /// Get GitHub Packages billing for a user
    ///
    /// Gets the free and paid storage used for GitHub Packages in gigabytes.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/packages`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/packages/get(billing/get-github-packages-billing-user)`.
    func billingGetGithubPackagesBillingUser(_ input: Operations.BillingGetGithubPackagesBillingUser.Input) async throws -> Operations.BillingGetGithubPackagesBillingUser.Output
    /// Get shared storage billing for a user
    ///
    /// Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/shared-storage`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-user)`.
    func billingGetSharedStorageBillingUser(_ input: Operations.BillingGetSharedStorageBillingUser.Input) async throws -> Operations.BillingGetSharedStorageBillingUser.Output
    /// Get billing usage report for a user
    ///
    /// Gets a report of the total usage for a user.
    ///
    /// **Note:** This endpoint is only available to users with access to the enhanced billing platform.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/usage`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)`.
    func billingGetGithubBillingUsageReportUser(_ input: Operations.BillingGetGithubBillingUsageReportUser.Input) async throws -> Operations.BillingGetGithubBillingUsageReportUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get billing usage report for an organization
    ///
    /// Gets a report of the total usage for an organization. To use this endpoint, you must be an administrator of an organization within an enterprise or an organization account.
    ///
    /// **Note:** This endpoint is only available to organizations with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform](https://docs.github.com/billing/using-the-new-billing-platform)."
    ///
    /// - Remark: HTTP `GET /organizations/{org}/settings/billing/usage`.
    /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)`.
    public func billingGetGithubBillingUsageReportOrg(
        path: Operations.BillingGetGithubBillingUsageReportOrg.Input.Path,
        query: Operations.BillingGetGithubBillingUsageReportOrg.Input.Query = .init(),
        headers: Operations.BillingGetGithubBillingUsageReportOrg.Input.Headers = .init()
    ) async throws -> Operations.BillingGetGithubBillingUsageReportOrg.Output {
        try await billingGetGithubBillingUsageReportOrg(Operations.BillingGetGithubBillingUsageReportOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get GitHub Actions billing for an organization
    ///
    /// Gets the summary of the free and paid GitHub Actions minutes used.
    ///
    /// Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/actions/get(billing/get-github-actions-billing-org)`.
    public func billingGetGithubActionsBillingOrg(
        path: Operations.BillingGetGithubActionsBillingOrg.Input.Path,
        headers: Operations.BillingGetGithubActionsBillingOrg.Input.Headers = .init()
    ) async throws -> Operations.BillingGetGithubActionsBillingOrg.Output {
        try await billingGetGithubActionsBillingOrg(Operations.BillingGetGithubActionsBillingOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub Packages billing for an organization
    ///
    /// Gets the free and paid storage used for GitHub Packages in gigabytes.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/packages`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/packages/get(billing/get-github-packages-billing-org)`.
    public func billingGetGithubPackagesBillingOrg(
        path: Operations.BillingGetGithubPackagesBillingOrg.Input.Path,
        headers: Operations.BillingGetGithubPackagesBillingOrg.Input.Headers = .init()
    ) async throws -> Operations.BillingGetGithubPackagesBillingOrg.Output {
        try await billingGetGithubPackagesBillingOrg(Operations.BillingGetGithubPackagesBillingOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get shared storage billing for an organization
    ///
    /// Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/shared-storage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-org)`.
    public func billingGetSharedStorageBillingOrg(
        path: Operations.BillingGetSharedStorageBillingOrg.Input.Path,
        headers: Operations.BillingGetSharedStorageBillingOrg.Input.Headers = .init()
    ) async throws -> Operations.BillingGetSharedStorageBillingOrg.Output {
        try await billingGetSharedStorageBillingOrg(Operations.BillingGetSharedStorageBillingOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub Actions billing for a user
    ///
    /// Gets the summary of the free and paid GitHub Actions minutes used.
    ///
    /// Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/actions`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/actions/get(billing/get-github-actions-billing-user)`.
    public func billingGetGithubActionsBillingUser(
        path: Operations.BillingGetGithubActionsBillingUser.Input.Path,
        headers: Operations.BillingGetGithubActionsBillingUser.Input.Headers = .init()
    ) async throws -> Operations.BillingGetGithubActionsBillingUser.Output {
        try await billingGetGithubActionsBillingUser(Operations.BillingGetGithubActionsBillingUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub Packages billing for a user
    ///
    /// Gets the free and paid storage used for GitHub Packages in gigabytes.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/packages`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/packages/get(billing/get-github-packages-billing-user)`.
    public func billingGetGithubPackagesBillingUser(
        path: Operations.BillingGetGithubPackagesBillingUser.Input.Path,
        headers: Operations.BillingGetGithubPackagesBillingUser.Input.Headers = .init()
    ) async throws -> Operations.BillingGetGithubPackagesBillingUser.Output {
        try await billingGetGithubPackagesBillingUser(Operations.BillingGetGithubPackagesBillingUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get shared storage billing for a user
    ///
    /// Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/shared-storage`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-user)`.
    public func billingGetSharedStorageBillingUser(
        path: Operations.BillingGetSharedStorageBillingUser.Input.Path,
        headers: Operations.BillingGetSharedStorageBillingUser.Input.Headers = .init()
    ) async throws -> Operations.BillingGetSharedStorageBillingUser.Output {
        try await billingGetSharedStorageBillingUser(Operations.BillingGetSharedStorageBillingUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get billing usage report for a user
    ///
    /// Gets a report of the total usage for a user.
    ///
    /// **Note:** This endpoint is only available to users with access to the enhanced billing platform.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/usage`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)`.
    public func billingGetGithubBillingUsageReportUser(
        path: Operations.BillingGetGithubBillingUsageReportUser.Input.Path,
        query: Operations.BillingGetGithubBillingUsageReportUser.Input.Query = .init(),
        headers: Operations.BillingGetGithubBillingUsageReportUser.Input.Headers = .init()
    ) async throws -> Operations.BillingGetGithubBillingUsageReportUser.Output {
        try await billingGetGithubBillingUsageReportUser(Operations.BillingGetGithubBillingUsageReportUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// - Remark: Generated from `#/components/schemas/billing-usage-report`.
        public struct BillingUsageReport: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload`.
            public struct UsageItemsPayloadPayload: Codable, Hashable, Sendable {
                /// Date of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/date`.
                public var date: Swift.String
                /// Product name.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/product`.
                public var product: Swift.String
                /// SKU name.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/sku`.
                public var sku: Swift.String
                /// Quantity of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/quantity`.
                public var quantity: Swift.Int
                /// Unit type of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/unitType`.
                public var unitType: Swift.String
                /// Price per unit of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/pricePerUnit`.
                public var pricePerUnit: Swift.Double
                /// Gross amount of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/grossAmount`.
                public var grossAmount: Swift.Double
                /// Discount amount of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/discountAmount`.
                public var discountAmount: Swift.Double
                /// Net amount of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/netAmount`.
                public var netAmount: Swift.Double
                /// Name of the organization.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/organizationName`.
                public var organizationName: Swift.String
                /// Name of the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report/UsageItemsPayload/repositoryName`.
                public var repositoryName: Swift.String?
                /// Creates a new `UsageItemsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - date: Date of the usage line item.
                ///   - product: Product name.
                ///   - sku: SKU name.
                ///   - quantity: Quantity of the usage line item.
                ///   - unitType: Unit type of the usage line item.
                ///   - pricePerUnit: Price per unit of the usage line item.
                ///   - grossAmount: Gross amount of the usage line item.
                ///   - discountAmount: Discount amount of the usage line item.
                ///   - netAmount: Net amount of the usage line item.
                ///   - organizationName: Name of the organization.
                ///   - repositoryName: Name of the repository.
                public init(
                    date: Swift.String,
                    product: Swift.String,
                    sku: Swift.String,
                    quantity: Swift.Int,
                    unitType: Swift.String,
                    pricePerUnit: Swift.Double,
                    grossAmount: Swift.Double,
                    discountAmount: Swift.Double,
                    netAmount: Swift.Double,
                    organizationName: Swift.String,
                    repositoryName: Swift.String? = nil
                ) {
                    self.date = date
                    self.product = product
                    self.sku = sku
                    self.quantity = quantity
                    self.unitType = unitType
                    self.pricePerUnit = pricePerUnit
                    self.grossAmount = grossAmount
                    self.discountAmount = discountAmount
                    self.netAmount = netAmount
                    self.organizationName = organizationName
                    self.repositoryName = repositoryName
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case product
                    case sku
                    case quantity
                    case unitType
                    case pricePerUnit
                    case grossAmount
                    case discountAmount
                    case netAmount
                    case organizationName
                    case repositoryName
                }
            }
            /// - Remark: Generated from `#/components/schemas/billing-usage-report/usageItems`.
            public typealias UsageItemsPayload = [Components.Schemas.BillingUsageReport.UsageItemsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/billing-usage-report/usageItems`.
            public var usageItems: Components.Schemas.BillingUsageReport.UsageItemsPayload?
            /// Creates a new `BillingUsageReport`.
            ///
            /// - Parameters:
            ///   - usageItems:
            public init(usageItems: Components.Schemas.BillingUsageReport.UsageItemsPayload? = nil) {
                self.usageItems = usageItems
            }
            public enum CodingKeys: String, CodingKey {
                case usageItems
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-billing-usage`.
        public struct ActionsBillingUsage: Codable, Hashable, Sendable {
            /// The sum of the free and paid GitHub Actions minutes used.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-billing-usage/total_minutes_used`.
            public var totalMinutesUsed: Swift.Int
            /// The total paid GitHub Actions minutes used.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-billing-usage/total_paid_minutes_used`.
            public var totalPaidMinutesUsed: Swift.Int
            /// The amount of free GitHub Actions minutes available.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-billing-usage/included_minutes`.
            public var includedMinutes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown`.
            public struct MinutesUsedBreakdownPayload: Codable, Hashable, Sendable {
                /// Total minutes used on Ubuntu runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/UBUNTU`.
                public var ubuntu: Swift.Int?
                /// Total minutes used on macOS runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/MACOS`.
                public var macos: Swift.Int?
                /// Total minutes used on Windows runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/WINDOWS`.
                public var windows: Swift.Int?
                /// Total minutes used on Ubuntu 4 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/ubuntu_4_core`.
                public var ubuntu4Core: Swift.Int?
                /// Total minutes used on Ubuntu 8 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/ubuntu_8_core`.
                public var ubuntu8Core: Swift.Int?
                /// Total minutes used on Ubuntu 16 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/ubuntu_16_core`.
                public var ubuntu16Core: Swift.Int?
                /// Total minutes used on Ubuntu 32 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/ubuntu_32_core`.
                public var ubuntu32Core: Swift.Int?
                /// Total minutes used on Ubuntu 64 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/ubuntu_64_core`.
                public var ubuntu64Core: Swift.Int?
                /// Total minutes used on Windows 4 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/windows_4_core`.
                public var windows4Core: Swift.Int?
                /// Total minutes used on Windows 8 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/windows_8_core`.
                public var windows8Core: Swift.Int?
                /// Total minutes used on Windows 16 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/windows_16_core`.
                public var windows16Core: Swift.Int?
                /// Total minutes used on Windows 32 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/windows_32_core`.
                public var windows32Core: Swift.Int?
                /// Total minutes used on Windows 64 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/windows_64_core`.
                public var windows64Core: Swift.Int?
                /// Total minutes used on macOS 12 core runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/macos_12_core`.
                public var macos12Core: Swift.Int?
                /// Total minutes used on all runner machines.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown/total`.
                public var total: Swift.Int?
                /// Creates a new `MinutesUsedBreakdownPayload`.
                ///
                /// - Parameters:
                ///   - ubuntu: Total minutes used on Ubuntu runner machines.
                ///   - macos: Total minutes used on macOS runner machines.
                ///   - windows: Total minutes used on Windows runner machines.
                ///   - ubuntu4Core: Total minutes used on Ubuntu 4 core runner machines.
                ///   - ubuntu8Core: Total minutes used on Ubuntu 8 core runner machines.
                ///   - ubuntu16Core: Total minutes used on Ubuntu 16 core runner machines.
                ///   - ubuntu32Core: Total minutes used on Ubuntu 32 core runner machines.
                ///   - ubuntu64Core: Total minutes used on Ubuntu 64 core runner machines.
                ///   - windows4Core: Total minutes used on Windows 4 core runner machines.
                ///   - windows8Core: Total minutes used on Windows 8 core runner machines.
                ///   - windows16Core: Total minutes used on Windows 16 core runner machines.
                ///   - windows32Core: Total minutes used on Windows 32 core runner machines.
                ///   - windows64Core: Total minutes used on Windows 64 core runner machines.
                ///   - macos12Core: Total minutes used on macOS 12 core runner machines.
                ///   - total: Total minutes used on all runner machines.
                public init(
                    ubuntu: Swift.Int? = nil,
                    macos: Swift.Int? = nil,
                    windows: Swift.Int? = nil,
                    ubuntu4Core: Swift.Int? = nil,
                    ubuntu8Core: Swift.Int? = nil,
                    ubuntu16Core: Swift.Int? = nil,
                    ubuntu32Core: Swift.Int? = nil,
                    ubuntu64Core: Swift.Int? = nil,
                    windows4Core: Swift.Int? = nil,
                    windows8Core: Swift.Int? = nil,
                    windows16Core: Swift.Int? = nil,
                    windows32Core: Swift.Int? = nil,
                    windows64Core: Swift.Int? = nil,
                    macos12Core: Swift.Int? = nil,
                    total: Swift.Int? = nil
                ) {
                    self.ubuntu = ubuntu
                    self.macos = macos
                    self.windows = windows
                    self.ubuntu4Core = ubuntu4Core
                    self.ubuntu8Core = ubuntu8Core
                    self.ubuntu16Core = ubuntu16Core
                    self.ubuntu32Core = ubuntu32Core
                    self.ubuntu64Core = ubuntu64Core
                    self.windows4Core = windows4Core
                    self.windows8Core = windows8Core
                    self.windows16Core = windows16Core
                    self.windows32Core = windows32Core
                    self.windows64Core = windows64Core
                    self.macos12Core = macos12Core
                    self.total = total
                }
                public enum CodingKeys: String, CodingKey {
                    case ubuntu = "UBUNTU"
                    case macos = "MACOS"
                    case windows = "WINDOWS"
                    case ubuntu4Core = "ubuntu_4_core"
                    case ubuntu8Core = "ubuntu_8_core"
                    case ubuntu16Core = "ubuntu_16_core"
                    case ubuntu32Core = "ubuntu_32_core"
                    case ubuntu64Core = "ubuntu_64_core"
                    case windows4Core = "windows_4_core"
                    case windows8Core = "windows_8_core"
                    case windows16Core = "windows_16_core"
                    case windows32Core = "windows_32_core"
                    case windows64Core = "windows_64_core"
                    case macos12Core = "macos_12_core"
                    case total
                }
            }
            /// - Remark: Generated from `#/components/schemas/actions-billing-usage/minutes_used_breakdown`.
            public var minutesUsedBreakdown: Components.Schemas.ActionsBillingUsage.MinutesUsedBreakdownPayload
            /// Creates a new `ActionsBillingUsage`.
            ///
            /// - Parameters:
            ///   - totalMinutesUsed: The sum of the free and paid GitHub Actions minutes used.
            ///   - totalPaidMinutesUsed: The total paid GitHub Actions minutes used.
            ///   - includedMinutes: The amount of free GitHub Actions minutes available.
            ///   - minutesUsedBreakdown:
            public init(
                totalMinutesUsed: Swift.Int,
                totalPaidMinutesUsed: Swift.Int,
                includedMinutes: Swift.Int,
                minutesUsedBreakdown: Components.Schemas.ActionsBillingUsage.MinutesUsedBreakdownPayload
            ) {
                self.totalMinutesUsed = totalMinutesUsed
                self.totalPaidMinutesUsed = totalPaidMinutesUsed
                self.includedMinutes = includedMinutes
                self.minutesUsedBreakdown = minutesUsedBreakdown
            }
            public enum CodingKeys: String, CodingKey {
                case totalMinutesUsed = "total_minutes_used"
                case totalPaidMinutesUsed = "total_paid_minutes_used"
                case includedMinutes = "included_minutes"
                case minutesUsedBreakdown = "minutes_used_breakdown"
            }
        }
        /// - Remark: Generated from `#/components/schemas/packages-billing-usage`.
        public struct PackagesBillingUsage: Codable, Hashable, Sendable {
            /// Sum of the free and paid storage space (GB) for GitHuub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/packages-billing-usage/total_gigabytes_bandwidth_used`.
            public var totalGigabytesBandwidthUsed: Swift.Int
            /// Total paid storage space (GB) for GitHuub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/packages-billing-usage/total_paid_gigabytes_bandwidth_used`.
            public var totalPaidGigabytesBandwidthUsed: Swift.Int
            /// Free storage space (GB) for GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/packages-billing-usage/included_gigabytes_bandwidth`.
            public var includedGigabytesBandwidth: Swift.Int
            /// Creates a new `PackagesBillingUsage`.
            ///
            /// - Parameters:
            ///   - totalGigabytesBandwidthUsed: Sum of the free and paid storage space (GB) for GitHuub Packages.
            ///   - totalPaidGigabytesBandwidthUsed: Total paid storage space (GB) for GitHuub Packages.
            ///   - includedGigabytesBandwidth: Free storage space (GB) for GitHub Packages.
            public init(
                totalGigabytesBandwidthUsed: Swift.Int,
                totalPaidGigabytesBandwidthUsed: Swift.Int,
                includedGigabytesBandwidth: Swift.Int
            ) {
                self.totalGigabytesBandwidthUsed = totalGigabytesBandwidthUsed
                self.totalPaidGigabytesBandwidthUsed = totalPaidGigabytesBandwidthUsed
                self.includedGigabytesBandwidth = includedGigabytesBandwidth
            }
            public enum CodingKeys: String, CodingKey {
                case totalGigabytesBandwidthUsed = "total_gigabytes_bandwidth_used"
                case totalPaidGigabytesBandwidthUsed = "total_paid_gigabytes_bandwidth_used"
                case includedGigabytesBandwidth = "included_gigabytes_bandwidth"
            }
        }
        /// - Remark: Generated from `#/components/schemas/combined-billing-usage`.
        public struct CombinedBillingUsage: Codable, Hashable, Sendable {
            /// Numbers of days left in billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/combined-billing-usage/days_left_in_billing_cycle`.
            public var daysLeftInBillingCycle: Swift.Int
            /// Estimated storage space (GB) used in billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/combined-billing-usage/estimated_paid_storage_for_month`.
            public var estimatedPaidStorageForMonth: Swift.Int
            /// Estimated sum of free and paid storage space (GB) used in billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/combined-billing-usage/estimated_storage_for_month`.
            public var estimatedStorageForMonth: Swift.Int
            /// Creates a new `CombinedBillingUsage`.
            ///
            /// - Parameters:
            ///   - daysLeftInBillingCycle: Numbers of days left in billing cycle.
            ///   - estimatedPaidStorageForMonth: Estimated storage space (GB) used in billing cycle.
            ///   - estimatedStorageForMonth: Estimated sum of free and paid storage space (GB) used in billing cycle.
            public init(
                daysLeftInBillingCycle: Swift.Int,
                estimatedPaidStorageForMonth: Swift.Int,
                estimatedStorageForMonth: Swift.Int
            ) {
                self.daysLeftInBillingCycle = daysLeftInBillingCycle
                self.estimatedPaidStorageForMonth = estimatedPaidStorageForMonth
                self.estimatedStorageForMonth = estimatedStorageForMonth
            }
            public enum CodingKeys: String, CodingKey {
                case daysLeftInBillingCycle = "days_left_in_billing_cycle"
                case estimatedPaidStorageForMonth = "estimated_paid_storage_for_month"
                case estimatedStorageForMonth = "estimated_storage_for_month"
            }
        }
        /// - Remark: Generated from `#/components/schemas/billing-usage-report-user`.
        public struct BillingUsageReportUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload`.
            public struct UsageItemsPayloadPayload: Codable, Hashable, Sendable {
                /// Date of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/date`.
                public var date: Swift.String
                /// Product name.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/product`.
                public var product: Swift.String
                /// SKU name.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/sku`.
                public var sku: Swift.String
                /// Quantity of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/quantity`.
                public var quantity: Swift.Int
                /// Unit type of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/unitType`.
                public var unitType: Swift.String
                /// Price per unit of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/pricePerUnit`.
                public var pricePerUnit: Swift.Double
                /// Gross amount of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/grossAmount`.
                public var grossAmount: Swift.Double
                /// Discount amount of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/discountAmount`.
                public var discountAmount: Swift.Double
                /// Net amount of the usage line item.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/netAmount`.
                public var netAmount: Swift.Double
                /// Name of the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/UsageItemsPayload/repositoryName`.
                public var repositoryName: Swift.String?
                /// Creates a new `UsageItemsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - date: Date of the usage line item.
                ///   - product: Product name.
                ///   - sku: SKU name.
                ///   - quantity: Quantity of the usage line item.
                ///   - unitType: Unit type of the usage line item.
                ///   - pricePerUnit: Price per unit of the usage line item.
                ///   - grossAmount: Gross amount of the usage line item.
                ///   - discountAmount: Discount amount of the usage line item.
                ///   - netAmount: Net amount of the usage line item.
                ///   - repositoryName: Name of the repository.
                public init(
                    date: Swift.String,
                    product: Swift.String,
                    sku: Swift.String,
                    quantity: Swift.Int,
                    unitType: Swift.String,
                    pricePerUnit: Swift.Double,
                    grossAmount: Swift.Double,
                    discountAmount: Swift.Double,
                    netAmount: Swift.Double,
                    repositoryName: Swift.String? = nil
                ) {
                    self.date = date
                    self.product = product
                    self.sku = sku
                    self.quantity = quantity
                    self.unitType = unitType
                    self.pricePerUnit = pricePerUnit
                    self.grossAmount = grossAmount
                    self.discountAmount = discountAmount
                    self.netAmount = netAmount
                    self.repositoryName = repositoryName
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case product
                    case sku
                    case quantity
                    case unitType
                    case pricePerUnit
                    case grossAmount
                    case discountAmount
                    case netAmount
                    case repositoryName
                }
            }
            /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/usageItems`.
            public typealias UsageItemsPayload = [Components.Schemas.BillingUsageReportUser.UsageItemsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/billing-usage-report-user/usageItems`.
            public var usageItems: Components.Schemas.BillingUsageReportUser.UsageItemsPayload?
            /// Creates a new `BillingUsageReportUser`.
            ///
            /// - Parameters:
            ///   - usageItems:
            public init(usageItems: Components.Schemas.BillingUsageReportUser.UsageItemsPayload? = nil) {
                self.usageItems = usageItems
            }
            public enum CodingKeys: String, CodingKey {
                case usageItems
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// If specified, only return results for a single year. The value of `year` is an integer with four digits representing a year. For example, `2025`. Default value is the current year.
        ///
        /// - Remark: Generated from `#/components/parameters/billing-usage-report-year`.
        public typealias BillingUsageReportYear = Swift.Int
        /// If specified, only return results for a single month. The value of `month` is an integer between `1` and `12`. If no year is specified the default `year` is used.
        ///
        /// - Remark: Generated from `#/components/parameters/billing-usage-report-month`.
        public typealias BillingUsageReportMonth = Swift.Int
        /// If specified, only return results for a single day. The value of `day` is an integer between `1` and `31`. If no `year` or `month` is specified, the default `year` and `month` are used.
        ///
        /// - Remark: Generated from `#/components/parameters/billing-usage-report-day`.
        public typealias BillingUsageReportDay = Swift.Int
        /// If specified, only return results for a single hour. The value of `hour` is an integer between `0` and `23`. If no `year`, `month`, or `day` is specified, the default `year`, `month`, and `day` are used.
        ///
        /// - Remark: Generated from `#/components/parameters/billing-usage-report-hour`.
        public typealias BillingUsageReportHour = Swift.Int
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct InternalError: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/internal_error/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/internal_error/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.InternalError.Body
            /// Creates a new `InternalError`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.InternalError.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
        public struct BillingUsageReportOrg: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/billing_usage_report_org/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/billing_usage_report_org/content/application\/json`.
                case json(Components.Schemas.BillingUsageReport)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BillingUsageReport {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BillingUsageReportOrg.Body
            /// Creates a new `BillingUsageReportOrg`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BillingUsageReportOrg.Body) {
                self.body = body
            }
        }
        public struct BillingUsageReportUser: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/billing_usage_report_user/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/billing_usage_report_user/content/application\/json`.
                case json(Components.Schemas.BillingUsageReportUser)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BillingUsageReportUser {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BillingUsageReportUser.Body
            /// Creates a new `BillingUsageReportUser`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BillingUsageReportUser.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get billing usage report for an organization
    ///
    /// Gets a report of the total usage for an organization. To use this endpoint, you must be an administrator of an organization within an enterprise or an organization account.
    ///
    /// **Note:** This endpoint is only available to organizations with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform](https://docs.github.com/billing/using-the-new-billing-platform)."
    ///
    /// - Remark: HTTP `GET /organizations/{org}/settings/billing/usage`.
    /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)`.
    public enum BillingGetGithubBillingUsageReportOrg {
        public static let id: Swift.String = "billing/get-github-billing-usage-report-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.BillingGetGithubBillingUsageReportOrg.Input.Path
            /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/query`.
            public struct Query: Sendable, Hashable {
                /// If specified, only return results for a single year. The value of `year` is an integer with four digits representing a year. For example, `2025`. Default value is the current year.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/query/year`.
                public var year: Components.Parameters.BillingUsageReportYear?
                /// If specified, only return results for a single month. The value of `month` is an integer between `1` and `12`. If no year is specified the default `year` is used.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/query/month`.
                public var month: Components.Parameters.BillingUsageReportMonth?
                /// If specified, only return results for a single day. The value of `day` is an integer between `1` and `31`. If no `year` or `month` is specified, the default `year` and `month` are used.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/query/day`.
                public var day: Components.Parameters.BillingUsageReportDay?
                /// If specified, only return results for a single hour. The value of `hour` is an integer between `0` and `23`. If no `year`, `month`, or `day` is specified, the default `year`, `month`, and `day` are used.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/query/hour`.
                public var hour: Components.Parameters.BillingUsageReportHour?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - year: If specified, only return results for a single year. The value of `year` is an integer with four digits representing a year. For example, `2025`. Default value is the current year.
                ///   - month: If specified, only return results for a single month. The value of `month` is an integer between `1` and `12`. If no year is specified the default `year` is used.
                ///   - day: If specified, only return results for a single day. The value of `day` is an integer between `1` and `31`. If no `year` or `month` is specified, the default `year` and `month` are used.
                ///   - hour: If specified, only return results for a single hour. The value of `hour` is an integer between `0` and `23`. If no `year`, `month`, or `day` is specified, the default `year`, `month`, and `day` are used.
                public init(
                    year: Components.Parameters.BillingUsageReportYear? = nil,
                    month: Components.Parameters.BillingUsageReportMonth? = nil,
                    day: Components.Parameters.BillingUsageReportDay? = nil,
                    hour: Components.Parameters.BillingUsageReportHour? = nil
                ) {
                    self.year = year
                    self.month = month
                    self.day = day
                    self.hour = hour
                }
            }
            public var query: Operations.BillingGetGithubBillingUsageReportOrg.Input.Query
            /// - Remark: Generated from `#/paths/organizations/{org}/settings/billing/usage/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubBillingUsageReportOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubBillingUsageReportOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetGithubBillingUsageReportOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.BillingGetGithubBillingUsageReportOrg.Input.Path,
                query: Operations.BillingGetGithubBillingUsageReportOrg.Input.Query = .init(),
                headers: Operations.BillingGetGithubBillingUsageReportOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Billing usage report response for an organization
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Components.Responses.BillingUsageReportOrg)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Components.Responses.BillingUsageReportOrg {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/settings/billing/usage/get(billing/get-github-billing-usage-report-org)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get GitHub Actions billing for an organization
    ///
    /// Gets the summary of the free and paid GitHub Actions minutes used.
    ///
    /// Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/actions/get(billing/get-github-actions-billing-org)`.
    public enum BillingGetGithubActionsBillingOrg {
        public static let id: Swift.String = "billing/get-github-actions-billing-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/actions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/actions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.BillingGetGithubActionsBillingOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/actions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubActionsBillingOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubActionsBillingOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetGithubActionsBillingOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.BillingGetGithubActionsBillingOrg.Input.Path,
                headers: Operations.BillingGetGithubActionsBillingOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/actions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/actions/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsBillingUsage)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsBillingUsage {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.BillingGetGithubActionsBillingOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.BillingGetGithubActionsBillingOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/actions/get(billing/get-github-actions-billing-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.BillingGetGithubActionsBillingOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.BillingGetGithubActionsBillingOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub Packages billing for an organization
    ///
    /// Gets the free and paid storage used for GitHub Packages in gigabytes.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/packages`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/packages/get(billing/get-github-packages-billing-org)`.
    public enum BillingGetGithubPackagesBillingOrg {
        public static let id: Swift.String = "billing/get-github-packages-billing-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/packages/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/packages/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.BillingGetGithubPackagesBillingOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/packages/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubPackagesBillingOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubPackagesBillingOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetGithubPackagesBillingOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.BillingGetGithubPackagesBillingOrg.Input.Path,
                headers: Operations.BillingGetGithubPackagesBillingOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/packages/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/packages/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PackagesBillingUsage)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PackagesBillingUsage {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.BillingGetGithubPackagesBillingOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.BillingGetGithubPackagesBillingOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/packages/get(billing/get-github-packages-billing-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.BillingGetGithubPackagesBillingOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.BillingGetGithubPackagesBillingOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get shared storage billing for an organization
    ///
    /// Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/billing/shared-storage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-org)`.
    public enum BillingGetSharedStorageBillingOrg {
        public static let id: Swift.String = "billing/get-shared-storage-billing-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/shared-storage/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/shared-storage/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.BillingGetSharedStorageBillingOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/shared-storage/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetSharedStorageBillingOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetSharedStorageBillingOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetSharedStorageBillingOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.BillingGetSharedStorageBillingOrg.Input.Path,
                headers: Operations.BillingGetSharedStorageBillingOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/shared-storage/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/billing/shared-storage/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CombinedBillingUsage)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CombinedBillingUsage {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.BillingGetSharedStorageBillingOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.BillingGetSharedStorageBillingOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.BillingGetSharedStorageBillingOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.BillingGetSharedStorageBillingOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub Actions billing for a user
    ///
    /// Gets the summary of the free and paid GitHub Actions minutes used.
    ///
    /// Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/actions`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/actions/get(billing/get-github-actions-billing-user)`.
    public enum BillingGetGithubActionsBillingUser {
        public static let id: Swift.String = "billing/get-github-actions-billing-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/actions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/actions/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.BillingGetGithubActionsBillingUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/actions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubActionsBillingUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubActionsBillingUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetGithubActionsBillingUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.BillingGetGithubActionsBillingUser.Input.Path,
                headers: Operations.BillingGetGithubActionsBillingUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/actions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/settings/billing/actions/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsBillingUsage)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsBillingUsage {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.BillingGetGithubActionsBillingUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.BillingGetGithubActionsBillingUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/actions/get(billing/get-github-actions-billing-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.BillingGetGithubActionsBillingUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.BillingGetGithubActionsBillingUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub Packages billing for a user
    ///
    /// Gets the free and paid storage used for GitHub Packages in gigabytes.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/packages`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/packages/get(billing/get-github-packages-billing-user)`.
    public enum BillingGetGithubPackagesBillingUser {
        public static let id: Swift.String = "billing/get-github-packages-billing-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/packages/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/packages/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.BillingGetGithubPackagesBillingUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/packages/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubPackagesBillingUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubPackagesBillingUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetGithubPackagesBillingUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.BillingGetGithubPackagesBillingUser.Input.Path,
                headers: Operations.BillingGetGithubPackagesBillingUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/packages/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/settings/billing/packages/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PackagesBillingUsage)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PackagesBillingUsage {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.BillingGetGithubPackagesBillingUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.BillingGetGithubPackagesBillingUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/packages/get(billing/get-github-packages-billing-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.BillingGetGithubPackagesBillingUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.BillingGetGithubPackagesBillingUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get shared storage billing for a user
    ///
    /// Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
    ///
    /// Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/shared-storage`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-user)`.
    public enum BillingGetSharedStorageBillingUser {
        public static let id: Swift.String = "billing/get-shared-storage-billing-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/shared-storage/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/shared-storage/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.BillingGetSharedStorageBillingUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/shared-storage/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetSharedStorageBillingUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetSharedStorageBillingUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetSharedStorageBillingUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.BillingGetSharedStorageBillingUser.Input.Path,
                headers: Operations.BillingGetSharedStorageBillingUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/shared-storage/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/settings/billing/shared-storage/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CombinedBillingUsage)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CombinedBillingUsage {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.BillingGetSharedStorageBillingUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.BillingGetSharedStorageBillingUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/shared-storage/get(billing/get-shared-storage-billing-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.BillingGetSharedStorageBillingUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.BillingGetSharedStorageBillingUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get billing usage report for a user
    ///
    /// Gets a report of the total usage for a user.
    ///
    /// **Note:** This endpoint is only available to users with access to the enhanced billing platform.
    ///
    /// - Remark: HTTP `GET /users/{username}/settings/billing/usage`.
    /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)`.
    public enum BillingGetGithubBillingUsageReportUser {
        public static let id: Swift.String = "billing/get-github-billing-usage-report-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.BillingGetGithubBillingUsageReportUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/query`.
            public struct Query: Sendable, Hashable {
                /// If specified, only return results for a single year. The value of `year` is an integer with four digits representing a year. For example, `2025`. Default value is the current year.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/query/year`.
                public var year: Components.Parameters.BillingUsageReportYear?
                /// If specified, only return results for a single month. The value of `month` is an integer between `1` and `12`. If no year is specified the default `year` is used.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/query/month`.
                public var month: Components.Parameters.BillingUsageReportMonth?
                /// If specified, only return results for a single day. The value of `day` is an integer between `1` and `31`. If no `year` or `month` is specified, the default `year` and `month` are used.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/query/day`.
                public var day: Components.Parameters.BillingUsageReportDay?
                /// If specified, only return results for a single hour. The value of `hour` is an integer between `0` and `23`. If no `year`, `month`, or `day` is specified, the default `year`, `month`, and `day` are used.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/query/hour`.
                public var hour: Components.Parameters.BillingUsageReportHour?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - year: If specified, only return results for a single year. The value of `year` is an integer with four digits representing a year. For example, `2025`. Default value is the current year.
                ///   - month: If specified, only return results for a single month. The value of `month` is an integer between `1` and `12`. If no year is specified the default `year` is used.
                ///   - day: If specified, only return results for a single day. The value of `day` is an integer between `1` and `31`. If no `year` or `month` is specified, the default `year` and `month` are used.
                ///   - hour: If specified, only return results for a single hour. The value of `hour` is an integer between `0` and `23`. If no `year`, `month`, or `day` is specified, the default `year`, `month`, and `day` are used.
                public init(
                    year: Components.Parameters.BillingUsageReportYear? = nil,
                    month: Components.Parameters.BillingUsageReportMonth? = nil,
                    day: Components.Parameters.BillingUsageReportDay? = nil,
                    hour: Components.Parameters.BillingUsageReportHour? = nil
                ) {
                    self.year = year
                    self.month = month
                    self.day = day
                    self.hour = hour
                }
            }
            public var query: Operations.BillingGetGithubBillingUsageReportUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/settings/billing/usage/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubBillingUsageReportUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.BillingGetGithubBillingUsageReportUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.BillingGetGithubBillingUsageReportUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.BillingGetGithubBillingUsageReportUser.Input.Path,
                query: Operations.BillingGetGithubBillingUsageReportUser.Input.Query = .init(),
                headers: Operations.BillingGetGithubBillingUsageReportUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Response when getting a billing usage report
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Components.Responses.BillingUsageReportUser)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Components.Responses.BillingUsageReportUser {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//users/{username}/settings/billing/usage/get(billing/get-github-billing-usage-report-user)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
}
