// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get the authenticated app
    ///
    /// Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/apps/apps#list-installations-for-the-authenticated-app)" endpoint.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app`.
    /// - Remark: Generated from `#/paths//app/get(apps/get-authenticated)`.
    func appsGetAuthenticated(_ input: Operations.AppsGetAuthenticated.Input) async throws -> Operations.AppsGetAuthenticated.Output
    /// Create a GitHub App from a manifest
    ///
    /// Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
    ///
    /// - Remark: HTTP `POST /app-manifests/{code}/conversions`.
    /// - Remark: Generated from `#/paths//app-manifests/{code}/conversions/post(apps/create-from-manifest)`.
    func appsCreateFromManifest(_ input: Operations.AppsCreateFromManifest.Input) async throws -> Operations.AppsCreateFromManifest.Output
    /// Get a webhook configuration for an app
    ///
    /// Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/config`.
    /// - Remark: Generated from `#/paths//app/hook/config/get(apps/get-webhook-config-for-app)`.
    func appsGetWebhookConfigForApp(_ input: Operations.AppsGetWebhookConfigForApp.Input) async throws -> Operations.AppsGetWebhookConfigForApp.Output
    /// Update a webhook configuration for an app
    ///
    /// Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `PATCH /app/hook/config`.
    /// - Remark: Generated from `#/paths//app/hook/config/patch(apps/update-webhook-config-for-app)`.
    func appsUpdateWebhookConfigForApp(_ input: Operations.AppsUpdateWebhookConfigForApp.Input) async throws -> Operations.AppsUpdateWebhookConfigForApp.Output
    /// List deliveries for an app webhook
    ///
    /// Returns a list of webhook deliveries for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/deliveries`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/get(apps/list-webhook-deliveries)`.
    func appsListWebhookDeliveries(_ input: Operations.AppsListWebhookDeliveries.Input) async throws -> Operations.AppsListWebhookDeliveries.Output
    /// Get a delivery for an app webhook
    ///
    /// Returns a delivery for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/get(apps/get-webhook-delivery)`.
    func appsGetWebhookDelivery(_ input: Operations.AppsGetWebhookDelivery.Input) async throws -> Operations.AppsGetWebhookDelivery.Output
    /// Redeliver a delivery for an app webhook
    ///
    /// Redeliver a delivery for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `POST /app/hook/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/attempts/post(apps/redeliver-webhook-delivery)`.
    func appsRedeliverWebhookDelivery(_ input: Operations.AppsRedeliverWebhookDelivery.Input) async throws -> Operations.AppsRedeliverWebhookDelivery.Output
    /// List installation requests for the authenticated app
    ///
    /// Lists all the pending installation requests for the authenticated GitHub App.
    ///
    /// - Remark: HTTP `GET /app/installation-requests`.
    /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)`.
    func appsListInstallationRequestsForAuthenticatedApp(_ input: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input) async throws -> Operations.AppsListInstallationRequestsForAuthenticatedApp.Output
    /// List installations for the authenticated app
    ///
    /// The permissions the installation has are included under the `permissions` key.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/installations`.
    /// - Remark: Generated from `#/paths//app/installations/get(apps/list-installations)`.
    func appsListInstallations(_ input: Operations.AppsListInstallations.Input) async throws -> Operations.AppsListInstallations.Output
    /// Get an installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find an installation's information using the installation id.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/installations/{installation_id}`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/get(apps/get-installation)`.
    func appsGetInstallation(_ input: Operations.AppsGetInstallation.Input) async throws -> Operations.AppsGetInstallation.Output
    /// Delete an installation for the authenticated app
    ///
    /// Uninstalls a GitHub App on a user, organization, or enterprise account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/apps/apps#suspend-an-app-installation)" endpoint.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `DELETE /app/installations/{installation_id}`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/delete(apps/delete-installation)`.
    func appsDeleteInstallation(_ input: Operations.AppsDeleteInstallation.Input) async throws -> Operations.AppsDeleteInstallation.Output
    /// Create an installation access token for an app
    ///
    /// Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access.
    ///
    /// Optionally, you can use the `repositories` or `repository_ids` body parameters to specify individual repositories that the installation access token can access. If you don't use `repositories` or `repository_ids` to grant access to specific repositories, the installation access token will have access to all repositories that the installation was granted access to. The installation access token cannot be granted access to repositories that the installation was not granted access to. Up to 500 repositories can be listed in this manner.
    ///
    /// Optionally, use the `permissions` body parameter to specify the permissions that the installation access token should have. If `permissions` is not specified, the installation access token will have all of the permissions that were granted to the app. The installation access token cannot be granted permissions that the app was not granted.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `POST /app/installations/{installation_id}/access_tokens`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)`.
    func appsCreateInstallationAccessToken(_ input: Operations.AppsCreateInstallationAccessToken.Input) async throws -> Operations.AppsCreateInstallationAccessToken.Output
    /// Suspend an app installation
    ///
    /// Suspends a GitHub App on a user, organization, or enterprise account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `PUT /app/installations/{installation_id}/suspended`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/put(apps/suspend-installation)`.
    func appsSuspendInstallation(_ input: Operations.AppsSuspendInstallation.Input) async throws -> Operations.AppsSuspendInstallation.Output
    /// Unsuspend an app installation
    ///
    /// Removes a GitHub App installation suspension.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `DELETE /app/installations/{installation_id}/suspended`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/delete(apps/unsuspend-installation)`.
    func appsUnsuspendInstallation(_ input: Operations.AppsUnsuspendInstallation.Input) async throws -> Operations.AppsUnsuspendInstallation.Output
    /// Delete an app authorization
    ///
    /// OAuth and GitHub application owners can revoke a grant for their application and a specific user. You must provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
    /// Deleting an application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    ///
    /// - Remark: HTTP `DELETE /applications/{client_id}/grant`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/grant/delete(apps/delete-authorization)`.
    func appsDeleteAuthorization(_ input: Operations.AppsDeleteAuthorization.Input) async throws -> Operations.AppsDeleteAuthorization.Output
    /// Check a token
    ///
    /// OAuth applications and GitHub applications with OAuth authorizations can use this API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `POST /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/post(apps/check-token)`.
    func appsCheckToken(_ input: Operations.AppsCheckToken.Input) async throws -> Operations.AppsCheckToken.Output
    /// Reset a token
    ///
    /// OAuth applications and GitHub applications with OAuth authorizations can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `PATCH /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/patch(apps/reset-token)`.
    func appsResetToken(_ input: Operations.AppsResetToken.Input) async throws -> Operations.AppsResetToken.Output
    /// Delete an app token
    ///
    /// OAuth  or GitHub application owners can revoke a single token for an OAuth application or a GitHub application with an OAuth authorization.
    ///
    /// - Remark: HTTP `DELETE /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/delete(apps/delete-token)`.
    func appsDeleteToken(_ input: Operations.AppsDeleteToken.Input) async throws -> Operations.AppsDeleteToken.Output
    /// Create a scoped access token
    ///
    /// Use a non-scoped user access token to create a repository-scoped and/or permission-scoped user access token. You can specify
    /// which repositories the token can access and which permissions are granted to the
    /// token.
    ///
    /// Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `POST /applications/{client_id}/token/scoped`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)`.
    func appsScopeToken(_ input: Operations.AppsScopeToken.Input) async throws -> Operations.AppsScopeToken.Output
    /// Get an app
    ///
    /// > [!NOTE]
    /// > The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
    ///
    /// - Remark: HTTP `GET /apps/{app_slug}`.
    /// - Remark: Generated from `#/paths//apps/{app_slug}/get(apps/get-by-slug)`.
    func appsGetBySlug(_ input: Operations.AppsGetBySlug.Input) async throws -> Operations.AppsGetBySlug.Output
    /// List repositories accessible to the app installation
    ///
    /// List repositories that an app installation can access.
    ///
    /// - Remark: HTTP `GET /installation/repositories`.
    /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)`.
    func appsListReposAccessibleToInstallation(_ input: Operations.AppsListReposAccessibleToInstallation.Input) async throws -> Operations.AppsListReposAccessibleToInstallation.Output
    /// Revoke an installation access token
    ///
    /// Revokes the installation token you're using to authenticate as an installation and access this endpoint.
    ///
    /// Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/apps/apps#create-an-installation-access-token-for-an-app)" endpoint.
    ///
    /// - Remark: HTTP `DELETE /installation/token`.
    /// - Remark: Generated from `#/paths//installation/token/delete(apps/revoke-installation-access-token)`.
    func appsRevokeInstallationAccessToken(_ input: Operations.AppsRevokeInstallationAccessToken.Input) async throws -> Operations.AppsRevokeInstallationAccessToken.Output
    /// Get a subscription plan for an account
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/accounts/{account_id}`.
    /// - Remark: Generated from `#/paths//marketplace_listing/accounts/{account_id}/get(apps/get-subscription-plan-for-account)`.
    func appsGetSubscriptionPlanForAccount(_ input: Operations.AppsGetSubscriptionPlanForAccount.Input) async throws -> Operations.AppsGetSubscriptionPlanForAccount.Output
    /// List plans
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/plans`.
    /// - Remark: Generated from `#/paths//marketplace_listing/plans/get(apps/list-plans)`.
    func appsListPlans(_ input: Operations.AppsListPlans.Input) async throws -> Operations.AppsListPlans.Output
    /// List accounts for a plan
    ///
    /// Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/plans/{plan_id}/accounts`.
    /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)`.
    func appsListAccountsForPlan(_ input: Operations.AppsListAccountsForPlan.Input) async throws -> Operations.AppsListAccountsForPlan.Output
    /// Get a subscription plan for an account (stubbed)
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/accounts/{account_id}`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)`.
    func appsGetSubscriptionPlanForAccountStubbed(_ input: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input) async throws -> Operations.AppsGetSubscriptionPlanForAccountStubbed.Output
    /// List plans (stubbed)
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/plans`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/get(apps/list-plans-stubbed)`.
    func appsListPlansStubbed(_ input: Operations.AppsListPlansStubbed.Input) async throws -> Operations.AppsListPlansStubbed.Output
    /// List accounts for a plan (stubbed)
    ///
    /// Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/plans/{plan_id}/accounts`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan-stubbed)`.
    func appsListAccountsForPlanStubbed(_ input: Operations.AppsListAccountsForPlanStubbed.Input) async throws -> Operations.AppsListAccountsForPlanStubbed.Output
    /// Get an organization installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the organization's installation information.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installation`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installation/get(apps/get-org-installation)`.
    func appsGetOrgInstallation(_ input: Operations.AppsGetOrgInstallation.Input) async throws -> Operations.AppsGetOrgInstallation.Output
    /// Get a repository installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/installation`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/installation/get(apps/get-repo-installation)`.
    func appsGetRepoInstallation(_ input: Operations.AppsGetRepoInstallation.Input) async throws -> Operations.AppsGetRepoInstallation.Output
    /// List app installations accessible to the user access token
    ///
    /// Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// You can find the permissions for the installation under the `permissions` key.
    ///
    /// - Remark: HTTP `GET /user/installations`.
    /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)`.
    func appsListInstallationsForAuthenticatedUser(_ input: Operations.AppsListInstallationsForAuthenticatedUser.Input) async throws -> Operations.AppsListInstallationsForAuthenticatedUser.Output
    /// List repositories accessible to the user access token
    ///
    /// List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// The access the user has to each repository is included in the hash under the `permissions` key.
    ///
    /// - Remark: HTTP `GET /user/installations/{installation_id}/repositories`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)`.
    func appsListInstallationReposForAuthenticatedUser(_ input: Operations.AppsListInstallationReposForAuthenticatedUser.Input) async throws -> Operations.AppsListInstallationReposForAuthenticatedUser.Output
    /// Add a repository to an app installation
    ///
    /// Add a single repository to an installation. The authenticated user must have admin access to the repository.    
    ///
    /// This endpoint only works for PATs (classic) with the `repo` scope.
    ///
    /// - Remark: HTTP `PUT /user/installations/{installation_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)`.
    func appsAddRepoToInstallationForAuthenticatedUser(_ input: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input) async throws -> Operations.AppsAddRepoToInstallationForAuthenticatedUser.Output
    /// Remove a repository from an app installation
    ///
    /// Remove a single repository from an installation. The authenticated user must have admin access to the repository. The installation must have the `repository_selection` of `selected`. 
    ///
    /// This endpoint only works for PATs (classic) with the `repo` scope.
    ///
    /// - Remark: HTTP `DELETE /user/installations/{installation_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)`.
    func appsRemoveRepoFromInstallationForAuthenticatedUser(_ input: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input) async throws -> Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Output
    /// List subscriptions for the authenticated user
    ///
    /// Lists the active subscriptions for the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/marketplace_purchases`.
    /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)`.
    func appsListSubscriptionsForAuthenticatedUser(_ input: Operations.AppsListSubscriptionsForAuthenticatedUser.Input) async throws -> Operations.AppsListSubscriptionsForAuthenticatedUser.Output
    /// List subscriptions for the authenticated user (stubbed)
    ///
    /// Lists the active subscriptions for the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/marketplace_purchases/stubbed`.
    /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)`.
    func appsListSubscriptionsForAuthenticatedUserStubbed(_ input: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input) async throws -> Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output
    /// Get a user installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the user’s installation information.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/installation`.
    /// - Remark: Generated from `#/paths//users/{username}/installation/get(apps/get-user-installation)`.
    func appsGetUserInstallation(_ input: Operations.AppsGetUserInstallation.Input) async throws -> Operations.AppsGetUserInstallation.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get the authenticated app
    ///
    /// Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/apps/apps#list-installations-for-the-authenticated-app)" endpoint.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app`.
    /// - Remark: Generated from `#/paths//app/get(apps/get-authenticated)`.
    public func appsGetAuthenticated(headers: Operations.AppsGetAuthenticated.Input.Headers = .init()) async throws -> Operations.AppsGetAuthenticated.Output {
        try await appsGetAuthenticated(Operations.AppsGetAuthenticated.Input(headers: headers))
    }
    /// Create a GitHub App from a manifest
    ///
    /// Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
    ///
    /// - Remark: HTTP `POST /app-manifests/{code}/conversions`.
    /// - Remark: Generated from `#/paths//app-manifests/{code}/conversions/post(apps/create-from-manifest)`.
    public func appsCreateFromManifest(
        path: Operations.AppsCreateFromManifest.Input.Path,
        headers: Operations.AppsCreateFromManifest.Input.Headers = .init()
    ) async throws -> Operations.AppsCreateFromManifest.Output {
        try await appsCreateFromManifest(Operations.AppsCreateFromManifest.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a webhook configuration for an app
    ///
    /// Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/config`.
    /// - Remark: Generated from `#/paths//app/hook/config/get(apps/get-webhook-config-for-app)`.
    public func appsGetWebhookConfigForApp(headers: Operations.AppsGetWebhookConfigForApp.Input.Headers = .init()) async throws -> Operations.AppsGetWebhookConfigForApp.Output {
        try await appsGetWebhookConfigForApp(Operations.AppsGetWebhookConfigForApp.Input(headers: headers))
    }
    /// Update a webhook configuration for an app
    ///
    /// Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `PATCH /app/hook/config`.
    /// - Remark: Generated from `#/paths//app/hook/config/patch(apps/update-webhook-config-for-app)`.
    public func appsUpdateWebhookConfigForApp(
        headers: Operations.AppsUpdateWebhookConfigForApp.Input.Headers = .init(),
        body: Operations.AppsUpdateWebhookConfigForApp.Input.Body
    ) async throws -> Operations.AppsUpdateWebhookConfigForApp.Output {
        try await appsUpdateWebhookConfigForApp(Operations.AppsUpdateWebhookConfigForApp.Input(
            headers: headers,
            body: body
        ))
    }
    /// List deliveries for an app webhook
    ///
    /// Returns a list of webhook deliveries for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/deliveries`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/get(apps/list-webhook-deliveries)`.
    public func appsListWebhookDeliveries(
        query: Operations.AppsListWebhookDeliveries.Input.Query = .init(),
        headers: Operations.AppsListWebhookDeliveries.Input.Headers = .init()
    ) async throws -> Operations.AppsListWebhookDeliveries.Output {
        try await appsListWebhookDeliveries(Operations.AppsListWebhookDeliveries.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a delivery for an app webhook
    ///
    /// Returns a delivery for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/get(apps/get-webhook-delivery)`.
    public func appsGetWebhookDelivery(
        path: Operations.AppsGetWebhookDelivery.Input.Path,
        headers: Operations.AppsGetWebhookDelivery.Input.Headers = .init()
    ) async throws -> Operations.AppsGetWebhookDelivery.Output {
        try await appsGetWebhookDelivery(Operations.AppsGetWebhookDelivery.Input(
            path: path,
            headers: headers
        ))
    }
    /// Redeliver a delivery for an app webhook
    ///
    /// Redeliver a delivery for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `POST /app/hook/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/attempts/post(apps/redeliver-webhook-delivery)`.
    public func appsRedeliverWebhookDelivery(
        path: Operations.AppsRedeliverWebhookDelivery.Input.Path,
        headers: Operations.AppsRedeliverWebhookDelivery.Input.Headers = .init()
    ) async throws -> Operations.AppsRedeliverWebhookDelivery.Output {
        try await appsRedeliverWebhookDelivery(Operations.AppsRedeliverWebhookDelivery.Input(
            path: path,
            headers: headers
        ))
    }
    /// List installation requests for the authenticated app
    ///
    /// Lists all the pending installation requests for the authenticated GitHub App.
    ///
    /// - Remark: HTTP `GET /app/installation-requests`.
    /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)`.
    public func appsListInstallationRequestsForAuthenticatedApp(
        query: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input.Query = .init(),
        headers: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input.Headers = .init()
    ) async throws -> Operations.AppsListInstallationRequestsForAuthenticatedApp.Output {
        try await appsListInstallationRequestsForAuthenticatedApp(Operations.AppsListInstallationRequestsForAuthenticatedApp.Input(
            query: query,
            headers: headers
        ))
    }
    /// List installations for the authenticated app
    ///
    /// The permissions the installation has are included under the `permissions` key.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/installations`.
    /// - Remark: Generated from `#/paths//app/installations/get(apps/list-installations)`.
    public func appsListInstallations(
        query: Operations.AppsListInstallations.Input.Query = .init(),
        headers: Operations.AppsListInstallations.Input.Headers = .init()
    ) async throws -> Operations.AppsListInstallations.Output {
        try await appsListInstallations(Operations.AppsListInstallations.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get an installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find an installation's information using the installation id.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/installations/{installation_id}`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/get(apps/get-installation)`.
    public func appsGetInstallation(
        path: Operations.AppsGetInstallation.Input.Path,
        headers: Operations.AppsGetInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsGetInstallation.Output {
        try await appsGetInstallation(Operations.AppsGetInstallation.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete an installation for the authenticated app
    ///
    /// Uninstalls a GitHub App on a user, organization, or enterprise account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/apps/apps#suspend-an-app-installation)" endpoint.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `DELETE /app/installations/{installation_id}`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/delete(apps/delete-installation)`.
    public func appsDeleteInstallation(
        path: Operations.AppsDeleteInstallation.Input.Path,
        headers: Operations.AppsDeleteInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsDeleteInstallation.Output {
        try await appsDeleteInstallation(Operations.AppsDeleteInstallation.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create an installation access token for an app
    ///
    /// Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access.
    ///
    /// Optionally, you can use the `repositories` or `repository_ids` body parameters to specify individual repositories that the installation access token can access. If you don't use `repositories` or `repository_ids` to grant access to specific repositories, the installation access token will have access to all repositories that the installation was granted access to. The installation access token cannot be granted access to repositories that the installation was not granted access to. Up to 500 repositories can be listed in this manner.
    ///
    /// Optionally, use the `permissions` body parameter to specify the permissions that the installation access token should have. If `permissions` is not specified, the installation access token will have all of the permissions that were granted to the app. The installation access token cannot be granted permissions that the app was not granted.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `POST /app/installations/{installation_id}/access_tokens`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)`.
    public func appsCreateInstallationAccessToken(
        path: Operations.AppsCreateInstallationAccessToken.Input.Path,
        headers: Operations.AppsCreateInstallationAccessToken.Input.Headers = .init(),
        body: Operations.AppsCreateInstallationAccessToken.Input.Body? = nil
    ) async throws -> Operations.AppsCreateInstallationAccessToken.Output {
        try await appsCreateInstallationAccessToken(Operations.AppsCreateInstallationAccessToken.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Suspend an app installation
    ///
    /// Suspends a GitHub App on a user, organization, or enterprise account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `PUT /app/installations/{installation_id}/suspended`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/put(apps/suspend-installation)`.
    public func appsSuspendInstallation(
        path: Operations.AppsSuspendInstallation.Input.Path,
        headers: Operations.AppsSuspendInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsSuspendInstallation.Output {
        try await appsSuspendInstallation(Operations.AppsSuspendInstallation.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unsuspend an app installation
    ///
    /// Removes a GitHub App installation suspension.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `DELETE /app/installations/{installation_id}/suspended`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/delete(apps/unsuspend-installation)`.
    public func appsUnsuspendInstallation(
        path: Operations.AppsUnsuspendInstallation.Input.Path,
        headers: Operations.AppsUnsuspendInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsUnsuspendInstallation.Output {
        try await appsUnsuspendInstallation(Operations.AppsUnsuspendInstallation.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete an app authorization
    ///
    /// OAuth and GitHub application owners can revoke a grant for their application and a specific user. You must provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
    /// Deleting an application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    ///
    /// - Remark: HTTP `DELETE /applications/{client_id}/grant`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/grant/delete(apps/delete-authorization)`.
    public func appsDeleteAuthorization(
        path: Operations.AppsDeleteAuthorization.Input.Path,
        headers: Operations.AppsDeleteAuthorization.Input.Headers = .init(),
        body: Operations.AppsDeleteAuthorization.Input.Body
    ) async throws -> Operations.AppsDeleteAuthorization.Output {
        try await appsDeleteAuthorization(Operations.AppsDeleteAuthorization.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Check a token
    ///
    /// OAuth applications and GitHub applications with OAuth authorizations can use this API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `POST /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/post(apps/check-token)`.
    public func appsCheckToken(
        path: Operations.AppsCheckToken.Input.Path,
        headers: Operations.AppsCheckToken.Input.Headers = .init(),
        body: Operations.AppsCheckToken.Input.Body
    ) async throws -> Operations.AppsCheckToken.Output {
        try await appsCheckToken(Operations.AppsCheckToken.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Reset a token
    ///
    /// OAuth applications and GitHub applications with OAuth authorizations can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `PATCH /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/patch(apps/reset-token)`.
    public func appsResetToken(
        path: Operations.AppsResetToken.Input.Path,
        headers: Operations.AppsResetToken.Input.Headers = .init(),
        body: Operations.AppsResetToken.Input.Body
    ) async throws -> Operations.AppsResetToken.Output {
        try await appsResetToken(Operations.AppsResetToken.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an app token
    ///
    /// OAuth  or GitHub application owners can revoke a single token for an OAuth application or a GitHub application with an OAuth authorization.
    ///
    /// - Remark: HTTP `DELETE /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/delete(apps/delete-token)`.
    public func appsDeleteToken(
        path: Operations.AppsDeleteToken.Input.Path,
        headers: Operations.AppsDeleteToken.Input.Headers = .init(),
        body: Operations.AppsDeleteToken.Input.Body
    ) async throws -> Operations.AppsDeleteToken.Output {
        try await appsDeleteToken(Operations.AppsDeleteToken.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Create a scoped access token
    ///
    /// Use a non-scoped user access token to create a repository-scoped and/or permission-scoped user access token. You can specify
    /// which repositories the token can access and which permissions are granted to the
    /// token.
    ///
    /// Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `POST /applications/{client_id}/token/scoped`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)`.
    public func appsScopeToken(
        path: Operations.AppsScopeToken.Input.Path,
        headers: Operations.AppsScopeToken.Input.Headers = .init(),
        body: Operations.AppsScopeToken.Input.Body
    ) async throws -> Operations.AppsScopeToken.Output {
        try await appsScopeToken(Operations.AppsScopeToken.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get an app
    ///
    /// > [!NOTE]
    /// > The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
    ///
    /// - Remark: HTTP `GET /apps/{app_slug}`.
    /// - Remark: Generated from `#/paths//apps/{app_slug}/get(apps/get-by-slug)`.
    public func appsGetBySlug(
        path: Operations.AppsGetBySlug.Input.Path,
        headers: Operations.AppsGetBySlug.Input.Headers = .init()
    ) async throws -> Operations.AppsGetBySlug.Output {
        try await appsGetBySlug(Operations.AppsGetBySlug.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repositories accessible to the app installation
    ///
    /// List repositories that an app installation can access.
    ///
    /// - Remark: HTTP `GET /installation/repositories`.
    /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)`.
    public func appsListReposAccessibleToInstallation(
        query: Operations.AppsListReposAccessibleToInstallation.Input.Query = .init(),
        headers: Operations.AppsListReposAccessibleToInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsListReposAccessibleToInstallation.Output {
        try await appsListReposAccessibleToInstallation(Operations.AppsListReposAccessibleToInstallation.Input(
            query: query,
            headers: headers
        ))
    }
    /// Revoke an installation access token
    ///
    /// Revokes the installation token you're using to authenticate as an installation and access this endpoint.
    ///
    /// Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/apps/apps#create-an-installation-access-token-for-an-app)" endpoint.
    ///
    /// - Remark: HTTP `DELETE /installation/token`.
    /// - Remark: Generated from `#/paths//installation/token/delete(apps/revoke-installation-access-token)`.
    public func appsRevokeInstallationAccessToken() async throws -> Operations.AppsRevokeInstallationAccessToken.Output {
        try await appsRevokeInstallationAccessToken(Operations.AppsRevokeInstallationAccessToken.Input())
    }
    /// Get a subscription plan for an account
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/accounts/{account_id}`.
    /// - Remark: Generated from `#/paths//marketplace_listing/accounts/{account_id}/get(apps/get-subscription-plan-for-account)`.
    public func appsGetSubscriptionPlanForAccount(
        path: Operations.AppsGetSubscriptionPlanForAccount.Input.Path,
        headers: Operations.AppsGetSubscriptionPlanForAccount.Input.Headers = .init()
    ) async throws -> Operations.AppsGetSubscriptionPlanForAccount.Output {
        try await appsGetSubscriptionPlanForAccount(Operations.AppsGetSubscriptionPlanForAccount.Input(
            path: path,
            headers: headers
        ))
    }
    /// List plans
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/plans`.
    /// - Remark: Generated from `#/paths//marketplace_listing/plans/get(apps/list-plans)`.
    public func appsListPlans(
        query: Operations.AppsListPlans.Input.Query = .init(),
        headers: Operations.AppsListPlans.Input.Headers = .init()
    ) async throws -> Operations.AppsListPlans.Output {
        try await appsListPlans(Operations.AppsListPlans.Input(
            query: query,
            headers: headers
        ))
    }
    /// List accounts for a plan
    ///
    /// Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/plans/{plan_id}/accounts`.
    /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)`.
    public func appsListAccountsForPlan(
        path: Operations.AppsListAccountsForPlan.Input.Path,
        query: Operations.AppsListAccountsForPlan.Input.Query = .init(),
        headers: Operations.AppsListAccountsForPlan.Input.Headers = .init()
    ) async throws -> Operations.AppsListAccountsForPlan.Output {
        try await appsListAccountsForPlan(Operations.AppsListAccountsForPlan.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a subscription plan for an account (stubbed)
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/accounts/{account_id}`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)`.
    public func appsGetSubscriptionPlanForAccountStubbed(
        path: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input.Path,
        headers: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input.Headers = .init()
    ) async throws -> Operations.AppsGetSubscriptionPlanForAccountStubbed.Output {
        try await appsGetSubscriptionPlanForAccountStubbed(Operations.AppsGetSubscriptionPlanForAccountStubbed.Input(
            path: path,
            headers: headers
        ))
    }
    /// List plans (stubbed)
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/plans`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/get(apps/list-plans-stubbed)`.
    public func appsListPlansStubbed(
        query: Operations.AppsListPlansStubbed.Input.Query = .init(),
        headers: Operations.AppsListPlansStubbed.Input.Headers = .init()
    ) async throws -> Operations.AppsListPlansStubbed.Output {
        try await appsListPlansStubbed(Operations.AppsListPlansStubbed.Input(
            query: query,
            headers: headers
        ))
    }
    /// List accounts for a plan (stubbed)
    ///
    /// Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/plans/{plan_id}/accounts`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan-stubbed)`.
    public func appsListAccountsForPlanStubbed(
        path: Operations.AppsListAccountsForPlanStubbed.Input.Path,
        query: Operations.AppsListAccountsForPlanStubbed.Input.Query = .init(),
        headers: Operations.AppsListAccountsForPlanStubbed.Input.Headers = .init()
    ) async throws -> Operations.AppsListAccountsForPlanStubbed.Output {
        try await appsListAccountsForPlanStubbed(Operations.AppsListAccountsForPlanStubbed.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an organization installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the organization's installation information.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installation`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installation/get(apps/get-org-installation)`.
    public func appsGetOrgInstallation(
        path: Operations.AppsGetOrgInstallation.Input.Path,
        headers: Operations.AppsGetOrgInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsGetOrgInstallation.Output {
        try await appsGetOrgInstallation(Operations.AppsGetOrgInstallation.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a repository installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/installation`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/installation/get(apps/get-repo-installation)`.
    public func appsGetRepoInstallation(
        path: Operations.AppsGetRepoInstallation.Input.Path,
        headers: Operations.AppsGetRepoInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsGetRepoInstallation.Output {
        try await appsGetRepoInstallation(Operations.AppsGetRepoInstallation.Input(
            path: path,
            headers: headers
        ))
    }
    /// List app installations accessible to the user access token
    ///
    /// Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// You can find the permissions for the installation under the `permissions` key.
    ///
    /// - Remark: HTTP `GET /user/installations`.
    /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)`.
    public func appsListInstallationsForAuthenticatedUser(
        query: Operations.AppsListInstallationsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.AppsListInstallationsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.AppsListInstallationsForAuthenticatedUser.Output {
        try await appsListInstallationsForAuthenticatedUser(Operations.AppsListInstallationsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// List repositories accessible to the user access token
    ///
    /// List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// The access the user has to each repository is included in the hash under the `permissions` key.
    ///
    /// - Remark: HTTP `GET /user/installations/{installation_id}/repositories`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)`.
    public func appsListInstallationReposForAuthenticatedUser(
        path: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Path,
        query: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.AppsListInstallationReposForAuthenticatedUser.Output {
        try await appsListInstallationReposForAuthenticatedUser(Operations.AppsListInstallationReposForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Add a repository to an app installation
    ///
    /// Add a single repository to an installation. The authenticated user must have admin access to the repository.    
    ///
    /// This endpoint only works for PATs (classic) with the `repo` scope.
    ///
    /// - Remark: HTTP `PUT /user/installations/{installation_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)`.
    public func appsAddRepoToInstallationForAuthenticatedUser(
        path: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input.Path,
        headers: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.AppsAddRepoToInstallationForAuthenticatedUser.Output {
        try await appsAddRepoToInstallationForAuthenticatedUser(Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove a repository from an app installation
    ///
    /// Remove a single repository from an installation. The authenticated user must have admin access to the repository. The installation must have the `repository_selection` of `selected`. 
    ///
    /// This endpoint only works for PATs (classic) with the `repo` scope.
    ///
    /// - Remark: HTTP `DELETE /user/installations/{installation_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)`.
    public func appsRemoveRepoFromInstallationForAuthenticatedUser(
        path: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input.Path,
        headers: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Output {
        try await appsRemoveRepoFromInstallationForAuthenticatedUser(Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List subscriptions for the authenticated user
    ///
    /// Lists the active subscriptions for the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/marketplace_purchases`.
    /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)`.
    public func appsListSubscriptionsForAuthenticatedUser(
        query: Operations.AppsListSubscriptionsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.AppsListSubscriptionsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.AppsListSubscriptionsForAuthenticatedUser.Output {
        try await appsListSubscriptionsForAuthenticatedUser(Operations.AppsListSubscriptionsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// List subscriptions for the authenticated user (stubbed)
    ///
    /// Lists the active subscriptions for the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/marketplace_purchases/stubbed`.
    /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)`.
    public func appsListSubscriptionsForAuthenticatedUserStubbed(
        query: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input.Query = .init(),
        headers: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input.Headers = .init()
    ) async throws -> Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output {
        try await appsListSubscriptionsForAuthenticatedUserStubbed(Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a user installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the user’s installation information.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/installation`.
    /// - Remark: Generated from `#/paths//users/{username}/installation/get(apps/get-user-installation)`.
    public func appsGetUserInstallation(
        path: Operations.AppsGetUserInstallation.Input.Path,
        headers: Operations.AppsGetUserInstallation.Input.Headers = .init()
    ) async throws -> Operations.AppsGetUserInstallation.Output {
        try await appsGetUserInstallation(Operations.AppsGetUserInstallation.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/integration`.
        public struct Integration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/integration/owner`.
            public var owner: Components.Schemas.Integration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/permissions`.
            public var permissions: Components.Schemas.Integration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `Integration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.Integration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.Integration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// The URL to which the payloads will be delivered.
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-url`.
        public typealias WebhookConfigUrl = Swift.String
        /// The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-content-type`.
        public typealias WebhookConfigContentType = Swift.String
        /// If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-secret`.
        public typealias WebhookConfigSecret = Swift.String
        /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl`.
        @frozen public enum WebhookConfigInsecureSsl: Codable, Hashable, Sendable {
            /// Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
            ///
            /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl/case1`.
            case case1(Swift.String)
            /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl/case2`.
            case case2(Swift.Double)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case2(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try encoder.encodeToSingleValueContainer(value)
                case let .case2(value):
                    try encoder.encodeToSingleValueContainer(value)
                }
            }
        }
        /// Configuration object of the webhook
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config`.
        public struct WebhookConfig: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/webhook-config/url`.
            public var url: Components.Schemas.WebhookConfigUrl?
            /// - Remark: Generated from `#/components/schemas/webhook-config/content_type`.
            public var contentType: Components.Schemas.WebhookConfigContentType?
            /// - Remark: Generated from `#/components/schemas/webhook-config/secret`.
            public var secret: Components.Schemas.WebhookConfigSecret?
            /// - Remark: Generated from `#/components/schemas/webhook-config/insecure_ssl`.
            public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
            /// Creates a new `WebhookConfig`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - contentType:
            ///   - secret:
            ///   - insecureSsl:
            public init(
                url: Components.Schemas.WebhookConfigUrl? = nil,
                contentType: Components.Schemas.WebhookConfigContentType? = nil,
                secret: Components.Schemas.WebhookConfigSecret? = nil,
                insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil
            ) {
                self.url = url
                self.contentType = contentType
                self.secret = secret
                self.insecureSsl = insecureSsl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case contentType = "content_type"
                case secret
                case insecureSsl = "insecure_ssl"
            }
        }
        /// Delivery made by a webhook, without request and response information.
        ///
        /// - Remark: Generated from `#/components/schemas/hook-delivery-item`.
        public struct HookDeliveryItem: Codable, Hashable, Sendable {
            /// Unique identifier of the webhook delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/id`.
            public var id: Swift.Int64
            /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/guid`.
            public var guid: Swift.String
            /// Time when the webhook delivery occurred.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/delivered_at`.
            public var deliveredAt: Foundation.Date
            /// Whether the webhook delivery is a redelivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/redelivery`.
            public var redelivery: Swift.Bool
            /// Time spent delivering.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/duration`.
            public var duration: Swift.Double
            /// Describes the response returned after attempting the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/status`.
            public var status: Swift.String
            /// Status code received when delivery was made.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/status_code`.
            public var statusCode: Swift.Int
            /// The event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/event`.
            public var event: Swift.String
            /// The type of activity for the event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/action`.
            public var action: Swift.String?
            /// The id of the GitHub App installation associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/installation_id`.
            public var installationId: Swift.Int64?
            /// The id of the repository associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/repository_id`.
            public var repositoryId: Swift.Int64?
            /// Time when the webhook delivery was throttled.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/throttled_at`.
            public var throttledAt: Foundation.Date?
            /// Creates a new `HookDeliveryItem`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the webhook delivery.
            ///   - guid: Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///   - deliveredAt: Time when the webhook delivery occurred.
            ///   - redelivery: Whether the webhook delivery is a redelivery.
            ///   - duration: Time spent delivering.
            ///   - status: Describes the response returned after attempting the delivery.
            ///   - statusCode: Status code received when delivery was made.
            ///   - event: The event that triggered the delivery.
            ///   - action: The type of activity for the event that triggered the delivery.
            ///   - installationId: The id of the GitHub App installation associated with this event.
            ///   - repositoryId: The id of the repository associated with this event.
            ///   - throttledAt: Time when the webhook delivery was throttled.
            public init(
                id: Swift.Int64,
                guid: Swift.String,
                deliveredAt: Foundation.Date,
                redelivery: Swift.Bool,
                duration: Swift.Double,
                status: Swift.String,
                statusCode: Swift.Int,
                event: Swift.String,
                action: Swift.String? = nil,
                installationId: Swift.Int64? = nil,
                repositoryId: Swift.Int64? = nil,
                throttledAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.guid = guid
                self.deliveredAt = deliveredAt
                self.redelivery = redelivery
                self.duration = duration
                self.status = status
                self.statusCode = statusCode
                self.event = event
                self.action = action
                self.installationId = installationId
                self.repositoryId = repositoryId
                self.throttledAt = throttledAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case guid
                case deliveredAt = "delivered_at"
                case redelivery
                case duration
                case status
                case statusCode = "status_code"
                case event
                case action
                case installationId = "installation_id"
                case repositoryId = "repository_id"
                case throttledAt = "throttled_at"
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Delivery made by a webhook.
        ///
        /// - Remark: Generated from `#/components/schemas/hook-delivery`.
        public struct HookDelivery: Codable, Hashable, Sendable {
            /// Unique identifier of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/id`.
            public var id: Swift.Int
            /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/guid`.
            public var guid: Swift.String
            /// Time when the delivery was delivered.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/delivered_at`.
            public var deliveredAt: Foundation.Date
            /// Whether the delivery is a redelivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/redelivery`.
            public var redelivery: Swift.Bool
            /// Time spent delivering.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/duration`.
            public var duration: Swift.Double
            /// Description of the status of the attempted delivery
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/status`.
            public var status: Swift.String
            /// Status code received when delivery was made.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/status_code`.
            public var statusCode: Swift.Int
            /// The event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/event`.
            public var event: Swift.String
            /// The type of activity for the event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/action`.
            public var action: Swift.String?
            /// The id of the GitHub App installation associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/installation_id`.
            public var installationId: Swift.Int?
            /// The id of the repository associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/repository_id`.
            public var repositoryId: Swift.Int?
            /// Time when the webhook delivery was throttled.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/throttled_at`.
            public var throttledAt: Foundation.Date?
            /// The URL target of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/hook-delivery/request`.
            public struct RequestPayload: Codable, Hashable, Sendable {
                /// The request headers sent with the webhook delivery.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/headers`.
                public struct HeadersPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `HeadersPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The request headers sent with the webhook delivery.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/headers`.
                public var headers: Components.Schemas.HookDelivery.RequestPayload.HeadersPayload?
                /// The webhook payload.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/payload`.
                public struct PayloadPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `PayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The webhook payload.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/payload`.
                public var payload: Components.Schemas.HookDelivery.RequestPayload.PayloadPayload?
                /// Creates a new `RequestPayload`.
                ///
                /// - Parameters:
                ///   - headers: The request headers sent with the webhook delivery.
                ///   - payload: The webhook payload.
                public init(
                    headers: Components.Schemas.HookDelivery.RequestPayload.HeadersPayload? = nil,
                    payload: Components.Schemas.HookDelivery.RequestPayload.PayloadPayload? = nil
                ) {
                    self.headers = headers
                    self.payload = payload
                }
                public enum CodingKeys: String, CodingKey {
                    case headers
                    case payload
                }
            }
            /// - Remark: Generated from `#/components/schemas/hook-delivery/request`.
            public var request: Components.Schemas.HookDelivery.RequestPayload
            /// - Remark: Generated from `#/components/schemas/hook-delivery/response`.
            public struct ResponsePayload: Codable, Hashable, Sendable {
                /// The response headers received when the delivery was made.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/headers`.
                public struct HeadersPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `HeadersPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The response headers received when the delivery was made.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/headers`.
                public var headers: Components.Schemas.HookDelivery.ResponsePayload.HeadersPayload?
                /// The response payload received.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/payload`.
                public var payload: Swift.String?
                /// Creates a new `ResponsePayload`.
                ///
                /// - Parameters:
                ///   - headers: The response headers received when the delivery was made.
                ///   - payload: The response payload received.
                public init(
                    headers: Components.Schemas.HookDelivery.ResponsePayload.HeadersPayload? = nil,
                    payload: Swift.String? = nil
                ) {
                    self.headers = headers
                    self.payload = payload
                }
                public enum CodingKeys: String, CodingKey {
                    case headers
                    case payload
                }
            }
            /// - Remark: Generated from `#/components/schemas/hook-delivery/response`.
            public var response: Components.Schemas.HookDelivery.ResponsePayload
            /// Creates a new `HookDelivery`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the delivery.
            ///   - guid: Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///   - deliveredAt: Time when the delivery was delivered.
            ///   - redelivery: Whether the delivery is a redelivery.
            ///   - duration: Time spent delivering.
            ///   - status: Description of the status of the attempted delivery
            ///   - statusCode: Status code received when delivery was made.
            ///   - event: The event that triggered the delivery.
            ///   - action: The type of activity for the event that triggered the delivery.
            ///   - installationId: The id of the GitHub App installation associated with this event.
            ///   - repositoryId: The id of the repository associated with this event.
            ///   - throttledAt: Time when the webhook delivery was throttled.
            ///   - url: The URL target of the delivery.
            ///   - request:
            ///   - response:
            public init(
                id: Swift.Int,
                guid: Swift.String,
                deliveredAt: Foundation.Date,
                redelivery: Swift.Bool,
                duration: Swift.Double,
                status: Swift.String,
                statusCode: Swift.Int,
                event: Swift.String,
                action: Swift.String? = nil,
                installationId: Swift.Int? = nil,
                repositoryId: Swift.Int? = nil,
                throttledAt: Foundation.Date? = nil,
                url: Swift.String? = nil,
                request: Components.Schemas.HookDelivery.RequestPayload,
                response: Components.Schemas.HookDelivery.ResponsePayload
            ) {
                self.id = id
                self.guid = guid
                self.deliveredAt = deliveredAt
                self.redelivery = redelivery
                self.duration = duration
                self.status = status
                self.statusCode = statusCode
                self.event = event
                self.action = action
                self.installationId = installationId
                self.repositoryId = repositoryId
                self.throttledAt = throttledAt
                self.url = url
                self.request = request
                self.response = response
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case guid
                case deliveredAt = "delivered_at"
                case redelivery
                case duration
                case status
                case statusCode = "status_code"
                case event
                case action
                case installationId = "installation_id"
                case repositoryId = "repository_id"
                case throttledAt = "throttled_at"
                case url
                case request
                case response
            }
        }
        /// Request to install an integration on a target
        ///
        /// - Remark: Generated from `#/components/schemas/integration-installation-request`.
        public struct IntegrationInstallationRequest: Codable, Hashable, Sendable {
            /// Unique identifier of the request installation.
            ///
            /// - Remark: Generated from `#/components/schemas/integration-installation-request/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/integration-installation-request/node_id`.
            public var nodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration-installation-request/account`.
            public struct AccountPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration-installation-request/account/value1`.
                public var value1: Components.Schemas.SimpleUser?
                /// - Remark: Generated from `#/components/schemas/integration-installation-request/account/value2`.
                public var value2: Components.Schemas.Enterprise?
                /// Creates a new `AccountPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.SimpleUser? = nil,
                    value2: Components.Schemas.Enterprise? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self.value1 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value2 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            self.value1,
                            self.value2
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1?.encode(to: encoder)
                    try self.value2?.encode(to: encoder)
                }
            }
            /// - Remark: Generated from `#/components/schemas/integration-installation-request/account`.
            public var account: Components.Schemas.IntegrationInstallationRequest.AccountPayload
            /// - Remark: Generated from `#/components/schemas/integration-installation-request/requester`.
            public var requester: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/integration-installation-request/created_at`.
            public var createdAt: Foundation.Date
            /// Creates a new `IntegrationInstallationRequest`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the request installation.
            ///   - nodeId:
            ///   - account:
            ///   - requester:
            ///   - createdAt:
            public init(
                id: Swift.Int,
                nodeId: Swift.String? = nil,
                account: Components.Schemas.IntegrationInstallationRequest.AccountPayload,
                requester: Components.Schemas.SimpleUser,
                createdAt: Foundation.Date
            ) {
                self.id = id
                self.nodeId = nodeId
                self.account = account
                self.requester = requester
                self.createdAt = createdAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case account
                case requester
                case createdAt = "created_at"
            }
        }
        /// The permissions granted to the user access token.
        ///
        /// - Remark: Generated from `#/components/schemas/app-permissions`.
        public struct AppPermissions: Codable, Hashable, Sendable {
            /// The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/actions`.
            @frozen public enum ActionsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/actions`.
            public var actions: Components.Schemas.AppPermissions.ActionsPayload?
            /// The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/administration`.
            @frozen public enum AdministrationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/administration`.
            public var administration: Components.Schemas.AppPermissions.AdministrationPayload?
            /// The level of permission to grant the access token for checks on code.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/checks`.
            @frozen public enum ChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for checks on code.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/checks`.
            public var checks: Components.Schemas.AppPermissions.ChecksPayload?
            /// The level of permission to grant the access token to create, edit, delete, and list Codespaces.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/codespaces`.
            @frozen public enum CodespacesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to create, edit, delete, and list Codespaces.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/codespaces`.
            public var codespaces: Components.Schemas.AppPermissions.CodespacesPayload?
            /// The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/contents`.
            @frozen public enum ContentsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/contents`.
            public var contents: Components.Schemas.AppPermissions.ContentsPayload?
            /// The level of permission to grant the access token to manage Dependabot secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/dependabot_secrets`.
            @frozen public enum DependabotSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage Dependabot secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/dependabot_secrets`.
            public var dependabotSecrets: Components.Schemas.AppPermissions.DependabotSecretsPayload?
            /// The level of permission to grant the access token for deployments and deployment statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/deployments`.
            @frozen public enum DeploymentsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for deployments and deployment statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/deployments`.
            public var deployments: Components.Schemas.AppPermissions.DeploymentsPayload?
            /// The level of permission to grant the access token for managing repository environments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/environments`.
            @frozen public enum EnvironmentsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for managing repository environments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/environments`.
            public var environments: Components.Schemas.AppPermissions.EnvironmentsPayload?
            /// The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/issues`.
            @frozen public enum IssuesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/issues`.
            public var issues: Components.Schemas.AppPermissions.IssuesPayload?
            /// The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/metadata`.
            @frozen public enum MetadataPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/metadata`.
            public var metadata: Components.Schemas.AppPermissions.MetadataPayload?
            /// The level of permission to grant the access token for packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/packages`.
            @frozen public enum PackagesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/packages`.
            public var packages: Components.Schemas.AppPermissions.PackagesPayload?
            /// The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pages`.
            @frozen public enum PagesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pages`.
            public var pages: Components.Schemas.AppPermissions.PagesPayload?
            /// The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pull_requests`.
            @frozen public enum PullRequestsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pull_requests`.
            public var pullRequests: Components.Schemas.AppPermissions.PullRequestsPayload?
            /// The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_custom_properties`.
            @frozen public enum RepositoryCustomPropertiesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_custom_properties`.
            public var repositoryCustomProperties: Components.Schemas.AppPermissions.RepositoryCustomPropertiesPayload?
            /// The level of permission to grant the access token to manage the post-receive hooks for a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_hooks`.
            @frozen public enum RepositoryHooksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the post-receive hooks for a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_hooks`.
            public var repositoryHooks: Components.Schemas.AppPermissions.RepositoryHooksPayload?
            /// The level of permission to grant the access token to manage repository projects, columns, and cards.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_projects`.
            @frozen public enum RepositoryProjectsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
            }
            /// The level of permission to grant the access token to manage repository projects, columns, and cards.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_projects`.
            public var repositoryProjects: Components.Schemas.AppPermissions.RepositoryProjectsPayload?
            /// The level of permission to grant the access token to view and manage secret scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secret_scanning_alerts`.
            @frozen public enum SecretScanningAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage secret scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secret_scanning_alerts`.
            public var secretScanningAlerts: Components.Schemas.AppPermissions.SecretScanningAlertsPayload?
            /// The level of permission to grant the access token to manage repository secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secrets`.
            @frozen public enum SecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage repository secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secrets`.
            public var secrets: Components.Schemas.AppPermissions.SecretsPayload?
            /// The level of permission to grant the access token to view and manage security events like code scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/security_events`.
            @frozen public enum SecurityEventsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage security events like code scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/security_events`.
            public var securityEvents: Components.Schemas.AppPermissions.SecurityEventsPayload?
            /// The level of permission to grant the access token to manage just a single file.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/single_file`.
            @frozen public enum SingleFilePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage just a single file.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/single_file`.
            public var singleFile: Components.Schemas.AppPermissions.SingleFilePayload?
            /// The level of permission to grant the access token for commit statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/statuses`.
            @frozen public enum StatusesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for commit statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/statuses`.
            public var statuses: Components.Schemas.AppPermissions.StatusesPayload?
            /// The level of permission to grant the access token to manage Dependabot alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/vulnerability_alerts`.
            @frozen public enum VulnerabilityAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage Dependabot alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/vulnerability_alerts`.
            public var vulnerabilityAlerts: Components.Schemas.AppPermissions.VulnerabilityAlertsPayload?
            /// The level of permission to grant the access token to update GitHub Actions workflow files.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/workflows`.
            @frozen public enum WorkflowsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case write = "write"
            }
            /// The level of permission to grant the access token to update GitHub Actions workflow files.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/workflows`.
            public var workflows: Components.Schemas.AppPermissions.WorkflowsPayload?
            /// The level of permission to grant the access token for organization teams and members.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/members`.
            @frozen public enum MembersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for organization teams and members.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/members`.
            public var members: Components.Schemas.AppPermissions.MembersPayload?
            /// The level of permission to grant the access token to manage access to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_administration`.
            @frozen public enum OrganizationAdministrationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage access to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_administration`.
            public var organizationAdministration: Components.Schemas.AppPermissions.OrganizationAdministrationPayload?
            /// The level of permission to grant the access token for custom repository roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_roles`.
            @frozen public enum OrganizationCustomRolesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for custom repository roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_roles`.
            public var organizationCustomRoles: Components.Schemas.AppPermissions.OrganizationCustomRolesPayload?
            /// The level of permission to grant the access token for custom organization roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_org_roles`.
            @frozen public enum OrganizationCustomOrgRolesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for custom organization roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_org_roles`.
            public var organizationCustomOrgRoles: Components.Schemas.AppPermissions.OrganizationCustomOrgRolesPayload?
            /// The level of permission to grant the access token for custom property management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_properties`.
            @frozen public enum OrganizationCustomPropertiesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
            }
            /// The level of permission to grant the access token for custom property management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_properties`.
            public var organizationCustomProperties: Components.Schemas.AppPermissions.OrganizationCustomPropertiesPayload?
            /// The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_copilot_seat_management`.
            @frozen public enum OrganizationCopilotSeatManagementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case write = "write"
            }
            /// The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_copilot_seat_management`.
            public var organizationCopilotSeatManagement: Components.Schemas.AppPermissions.OrganizationCopilotSeatManagementPayload?
            /// The level of permission to grant the access token to view and manage announcement banners for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_announcement_banners`.
            @frozen public enum OrganizationAnnouncementBannersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage announcement banners for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_announcement_banners`.
            public var organizationAnnouncementBanners: Components.Schemas.AppPermissions.OrganizationAnnouncementBannersPayload?
            /// The level of permission to grant the access token to view events triggered by an activity in an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_events`.
            @frozen public enum OrganizationEventsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
            }
            /// The level of permission to grant the access token to view events triggered by an activity in an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_events`.
            public var organizationEvents: Components.Schemas.AppPermissions.OrganizationEventsPayload?
            /// The level of permission to grant the access token to manage the post-receive hooks for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_hooks`.
            @frozen public enum OrganizationHooksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the post-receive hooks for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_hooks`.
            public var organizationHooks: Components.Schemas.AppPermissions.OrganizationHooksPayload?
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_tokens`.
            @frozen public enum OrganizationPersonalAccessTokensPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_tokens`.
            public var organizationPersonalAccessTokens: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokensPayload?
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_token_requests`.
            @frozen public enum OrganizationPersonalAccessTokenRequestsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_token_requests`.
            public var organizationPersonalAccessTokenRequests: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokenRequestsPayload?
            /// The level of permission to grant the access token for viewing an organization's plan.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_plan`.
            @frozen public enum OrganizationPlanPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
            }
            /// The level of permission to grant the access token for viewing an organization's plan.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_plan`.
            public var organizationPlan: Components.Schemas.AppPermissions.OrganizationPlanPayload?
            /// The level of permission to grant the access token to manage organization projects and projects public preview (where available).
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_projects`.
            @frozen public enum OrganizationProjectsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
            }
            /// The level of permission to grant the access token to manage organization projects and projects public preview (where available).
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_projects`.
            public var organizationProjects: Components.Schemas.AppPermissions.OrganizationProjectsPayload?
            /// The level of permission to grant the access token for organization packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_packages`.
            @frozen public enum OrganizationPackagesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for organization packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_packages`.
            public var organizationPackages: Components.Schemas.AppPermissions.OrganizationPackagesPayload?
            /// The level of permission to grant the access token to manage organization secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_secrets`.
            @frozen public enum OrganizationSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage organization secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_secrets`.
            public var organizationSecrets: Components.Schemas.AppPermissions.OrganizationSecretsPayload?
            /// The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_self_hosted_runners`.
            @frozen public enum OrganizationSelfHostedRunnersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_self_hosted_runners`.
            public var organizationSelfHostedRunners: Components.Schemas.AppPermissions.OrganizationSelfHostedRunnersPayload?
            /// The level of permission to grant the access token to view and manage users blocked by the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_user_blocking`.
            @frozen public enum OrganizationUserBlockingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage users blocked by the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_user_blocking`.
            public var organizationUserBlocking: Components.Schemas.AppPermissions.OrganizationUserBlockingPayload?
            /// The level of permission to grant the access token to manage team discussions and related comments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/team_discussions`.
            @frozen public enum TeamDiscussionsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage team discussions and related comments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/team_discussions`.
            public var teamDiscussions: Components.Schemas.AppPermissions.TeamDiscussionsPayload?
            /// The level of permission to grant the access token to manage the email addresses belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/email_addresses`.
            @frozen public enum EmailAddressesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the email addresses belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/email_addresses`.
            public var emailAddresses: Components.Schemas.AppPermissions.EmailAddressesPayload?
            /// The level of permission to grant the access token to manage the followers belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/followers`.
            @frozen public enum FollowersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the followers belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/followers`.
            public var followers: Components.Schemas.AppPermissions.FollowersPayload?
            /// The level of permission to grant the access token to manage git SSH keys.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/git_ssh_keys`.
            @frozen public enum GitSshKeysPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage git SSH keys.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/git_ssh_keys`.
            public var gitSshKeys: Components.Schemas.AppPermissions.GitSshKeysPayload?
            /// The level of permission to grant the access token to view and manage GPG keys belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/gpg_keys`.
            @frozen public enum GpgKeysPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage GPG keys belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/gpg_keys`.
            public var gpgKeys: Components.Schemas.AppPermissions.GpgKeysPayload?
            /// The level of permission to grant the access token to view and manage interaction limits on a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/interaction_limits`.
            @frozen public enum InteractionLimitsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage interaction limits on a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/interaction_limits`.
            public var interactionLimits: Components.Schemas.AppPermissions.InteractionLimitsPayload?
            /// The level of permission to grant the access token to manage the profile settings belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/profile`.
            @frozen public enum ProfilePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the profile settings belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/profile`.
            public var profile: Components.Schemas.AppPermissions.ProfilePayload?
            /// The level of permission to grant the access token to list and manage repositories a user is starring.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/starring`.
            @frozen public enum StarringPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to list and manage repositories a user is starring.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/starring`.
            public var starring: Components.Schemas.AppPermissions.StarringPayload?
            /// Creates a new `AppPermissions`.
            ///
            /// - Parameters:
            ///   - actions: The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
            ///   - administration: The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
            ///   - checks: The level of permission to grant the access token for checks on code.
            ///   - codespaces: The level of permission to grant the access token to create, edit, delete, and list Codespaces.
            ///   - contents: The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
            ///   - dependabotSecrets: The level of permission to grant the access token to manage Dependabot secrets.
            ///   - deployments: The level of permission to grant the access token for deployments and deployment statuses.
            ///   - environments: The level of permission to grant the access token for managing repository environments.
            ///   - issues: The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
            ///   - metadata: The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
            ///   - packages: The level of permission to grant the access token for packages published to GitHub Packages.
            ///   - pages: The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
            ///   - pullRequests: The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
            ///   - repositoryCustomProperties: The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
            ///   - repositoryHooks: The level of permission to grant the access token to manage the post-receive hooks for a repository.
            ///   - repositoryProjects: The level of permission to grant the access token to manage repository projects, columns, and cards.
            ///   - secretScanningAlerts: The level of permission to grant the access token to view and manage secret scanning alerts.
            ///   - secrets: The level of permission to grant the access token to manage repository secrets.
            ///   - securityEvents: The level of permission to grant the access token to view and manage security events like code scanning alerts.
            ///   - singleFile: The level of permission to grant the access token to manage just a single file.
            ///   - statuses: The level of permission to grant the access token for commit statuses.
            ///   - vulnerabilityAlerts: The level of permission to grant the access token to manage Dependabot alerts.
            ///   - workflows: The level of permission to grant the access token to update GitHub Actions workflow files.
            ///   - members: The level of permission to grant the access token for organization teams and members.
            ///   - organizationAdministration: The level of permission to grant the access token to manage access to an organization.
            ///   - organizationCustomRoles: The level of permission to grant the access token for custom repository roles management.
            ///   - organizationCustomOrgRoles: The level of permission to grant the access token for custom organization roles management.
            ///   - organizationCustomProperties: The level of permission to grant the access token for custom property management.
            ///   - organizationCopilotSeatManagement: The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
            ///   - organizationAnnouncementBanners: The level of permission to grant the access token to view and manage announcement banners for an organization.
            ///   - organizationEvents: The level of permission to grant the access token to view events triggered by an activity in an organization.
            ///   - organizationHooks: The level of permission to grant the access token to manage the post-receive hooks for an organization.
            ///   - organizationPersonalAccessTokens: The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
            ///   - organizationPersonalAccessTokenRequests: The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
            ///   - organizationPlan: The level of permission to grant the access token for viewing an organization's plan.
            ///   - organizationProjects: The level of permission to grant the access token to manage organization projects and projects public preview (where available).
            ///   - organizationPackages: The level of permission to grant the access token for organization packages published to GitHub Packages.
            ///   - organizationSecrets: The level of permission to grant the access token to manage organization secrets.
            ///   - organizationSelfHostedRunners: The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
            ///   - organizationUserBlocking: The level of permission to grant the access token to view and manage users blocked by the organization.
            ///   - teamDiscussions: The level of permission to grant the access token to manage team discussions and related comments.
            ///   - emailAddresses: The level of permission to grant the access token to manage the email addresses belonging to a user.
            ///   - followers: The level of permission to grant the access token to manage the followers belonging to a user.
            ///   - gitSshKeys: The level of permission to grant the access token to manage git SSH keys.
            ///   - gpgKeys: The level of permission to grant the access token to view and manage GPG keys belonging to a user.
            ///   - interactionLimits: The level of permission to grant the access token to view and manage interaction limits on a repository.
            ///   - profile: The level of permission to grant the access token to manage the profile settings belonging to a user.
            ///   - starring: The level of permission to grant the access token to list and manage repositories a user is starring.
            public init(
                actions: Components.Schemas.AppPermissions.ActionsPayload? = nil,
                administration: Components.Schemas.AppPermissions.AdministrationPayload? = nil,
                checks: Components.Schemas.AppPermissions.ChecksPayload? = nil,
                codespaces: Components.Schemas.AppPermissions.CodespacesPayload? = nil,
                contents: Components.Schemas.AppPermissions.ContentsPayload? = nil,
                dependabotSecrets: Components.Schemas.AppPermissions.DependabotSecretsPayload? = nil,
                deployments: Components.Schemas.AppPermissions.DeploymentsPayload? = nil,
                environments: Components.Schemas.AppPermissions.EnvironmentsPayload? = nil,
                issues: Components.Schemas.AppPermissions.IssuesPayload? = nil,
                metadata: Components.Schemas.AppPermissions.MetadataPayload? = nil,
                packages: Components.Schemas.AppPermissions.PackagesPayload? = nil,
                pages: Components.Schemas.AppPermissions.PagesPayload? = nil,
                pullRequests: Components.Schemas.AppPermissions.PullRequestsPayload? = nil,
                repositoryCustomProperties: Components.Schemas.AppPermissions.RepositoryCustomPropertiesPayload? = nil,
                repositoryHooks: Components.Schemas.AppPermissions.RepositoryHooksPayload? = nil,
                repositoryProjects: Components.Schemas.AppPermissions.RepositoryProjectsPayload? = nil,
                secretScanningAlerts: Components.Schemas.AppPermissions.SecretScanningAlertsPayload? = nil,
                secrets: Components.Schemas.AppPermissions.SecretsPayload? = nil,
                securityEvents: Components.Schemas.AppPermissions.SecurityEventsPayload? = nil,
                singleFile: Components.Schemas.AppPermissions.SingleFilePayload? = nil,
                statuses: Components.Schemas.AppPermissions.StatusesPayload? = nil,
                vulnerabilityAlerts: Components.Schemas.AppPermissions.VulnerabilityAlertsPayload? = nil,
                workflows: Components.Schemas.AppPermissions.WorkflowsPayload? = nil,
                members: Components.Schemas.AppPermissions.MembersPayload? = nil,
                organizationAdministration: Components.Schemas.AppPermissions.OrganizationAdministrationPayload? = nil,
                organizationCustomRoles: Components.Schemas.AppPermissions.OrganizationCustomRolesPayload? = nil,
                organizationCustomOrgRoles: Components.Schemas.AppPermissions.OrganizationCustomOrgRolesPayload? = nil,
                organizationCustomProperties: Components.Schemas.AppPermissions.OrganizationCustomPropertiesPayload? = nil,
                organizationCopilotSeatManagement: Components.Schemas.AppPermissions.OrganizationCopilotSeatManagementPayload? = nil,
                organizationAnnouncementBanners: Components.Schemas.AppPermissions.OrganizationAnnouncementBannersPayload? = nil,
                organizationEvents: Components.Schemas.AppPermissions.OrganizationEventsPayload? = nil,
                organizationHooks: Components.Schemas.AppPermissions.OrganizationHooksPayload? = nil,
                organizationPersonalAccessTokens: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokensPayload? = nil,
                organizationPersonalAccessTokenRequests: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokenRequestsPayload? = nil,
                organizationPlan: Components.Schemas.AppPermissions.OrganizationPlanPayload? = nil,
                organizationProjects: Components.Schemas.AppPermissions.OrganizationProjectsPayload? = nil,
                organizationPackages: Components.Schemas.AppPermissions.OrganizationPackagesPayload? = nil,
                organizationSecrets: Components.Schemas.AppPermissions.OrganizationSecretsPayload? = nil,
                organizationSelfHostedRunners: Components.Schemas.AppPermissions.OrganizationSelfHostedRunnersPayload? = nil,
                organizationUserBlocking: Components.Schemas.AppPermissions.OrganizationUserBlockingPayload? = nil,
                teamDiscussions: Components.Schemas.AppPermissions.TeamDiscussionsPayload? = nil,
                emailAddresses: Components.Schemas.AppPermissions.EmailAddressesPayload? = nil,
                followers: Components.Schemas.AppPermissions.FollowersPayload? = nil,
                gitSshKeys: Components.Schemas.AppPermissions.GitSshKeysPayload? = nil,
                gpgKeys: Components.Schemas.AppPermissions.GpgKeysPayload? = nil,
                interactionLimits: Components.Schemas.AppPermissions.InteractionLimitsPayload? = nil,
                profile: Components.Schemas.AppPermissions.ProfilePayload? = nil,
                starring: Components.Schemas.AppPermissions.StarringPayload? = nil
            ) {
                self.actions = actions
                self.administration = administration
                self.checks = checks
                self.codespaces = codespaces
                self.contents = contents
                self.dependabotSecrets = dependabotSecrets
                self.deployments = deployments
                self.environments = environments
                self.issues = issues
                self.metadata = metadata
                self.packages = packages
                self.pages = pages
                self.pullRequests = pullRequests
                self.repositoryCustomProperties = repositoryCustomProperties
                self.repositoryHooks = repositoryHooks
                self.repositoryProjects = repositoryProjects
                self.secretScanningAlerts = secretScanningAlerts
                self.secrets = secrets
                self.securityEvents = securityEvents
                self.singleFile = singleFile
                self.statuses = statuses
                self.vulnerabilityAlerts = vulnerabilityAlerts
                self.workflows = workflows
                self.members = members
                self.organizationAdministration = organizationAdministration
                self.organizationCustomRoles = organizationCustomRoles
                self.organizationCustomOrgRoles = organizationCustomOrgRoles
                self.organizationCustomProperties = organizationCustomProperties
                self.organizationCopilotSeatManagement = organizationCopilotSeatManagement
                self.organizationAnnouncementBanners = organizationAnnouncementBanners
                self.organizationEvents = organizationEvents
                self.organizationHooks = organizationHooks
                self.organizationPersonalAccessTokens = organizationPersonalAccessTokens
                self.organizationPersonalAccessTokenRequests = organizationPersonalAccessTokenRequests
                self.organizationPlan = organizationPlan
                self.organizationProjects = organizationProjects
                self.organizationPackages = organizationPackages
                self.organizationSecrets = organizationSecrets
                self.organizationSelfHostedRunners = organizationSelfHostedRunners
                self.organizationUserBlocking = organizationUserBlocking
                self.teamDiscussions = teamDiscussions
                self.emailAddresses = emailAddresses
                self.followers = followers
                self.gitSshKeys = gitSshKeys
                self.gpgKeys = gpgKeys
                self.interactionLimits = interactionLimits
                self.profile = profile
                self.starring = starring
            }
            public enum CodingKeys: String, CodingKey {
                case actions
                case administration
                case checks
                case codespaces
                case contents
                case dependabotSecrets = "dependabot_secrets"
                case deployments
                case environments
                case issues
                case metadata
                case packages
                case pages
                case pullRequests = "pull_requests"
                case repositoryCustomProperties = "repository_custom_properties"
                case repositoryHooks = "repository_hooks"
                case repositoryProjects = "repository_projects"
                case secretScanningAlerts = "secret_scanning_alerts"
                case secrets
                case securityEvents = "security_events"
                case singleFile = "single_file"
                case statuses
                case vulnerabilityAlerts = "vulnerability_alerts"
                case workflows
                case members
                case organizationAdministration = "organization_administration"
                case organizationCustomRoles = "organization_custom_roles"
                case organizationCustomOrgRoles = "organization_custom_org_roles"
                case organizationCustomProperties = "organization_custom_properties"
                case organizationCopilotSeatManagement = "organization_copilot_seat_management"
                case organizationAnnouncementBanners = "organization_announcement_banners"
                case organizationEvents = "organization_events"
                case organizationHooks = "organization_hooks"
                case organizationPersonalAccessTokens = "organization_personal_access_tokens"
                case organizationPersonalAccessTokenRequests = "organization_personal_access_token_requests"
                case organizationPlan = "organization_plan"
                case organizationProjects = "organization_projects"
                case organizationPackages = "organization_packages"
                case organizationSecrets = "organization_secrets"
                case organizationSelfHostedRunners = "organization_self_hosted_runners"
                case organizationUserBlocking = "organization_user_blocking"
                case teamDiscussions = "team_discussions"
                case emailAddresses = "email_addresses"
                case followers
                case gitSshKeys = "git_ssh_keys"
                case gpgKeys = "gpg_keys"
                case interactionLimits = "interaction_limits"
                case profile
                case starring
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Installation
        ///
        /// - Remark: Generated from `#/components/schemas/installation`.
        public struct Installation: Codable, Hashable, Sendable {
            /// The ID of the installation.
            ///
            /// - Remark: Generated from `#/components/schemas/installation/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/installation/account`.
            public struct AccountPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/installation/account/value1`.
                public var value1: Components.Schemas.SimpleUser?
                /// - Remark: Generated from `#/components/schemas/installation/account/value2`.
                public var value2: Components.Schemas.Enterprise?
                /// Creates a new `AccountPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.SimpleUser? = nil,
                    value2: Components.Schemas.Enterprise? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self.value1 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value2 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            self.value1,
                            self.value2
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1?.encode(to: encoder)
                    try self.value2?.encode(to: encoder)
                }
            }
            /// - Remark: Generated from `#/components/schemas/installation/account`.
            public var account: Components.Schemas.Installation.AccountPayload?
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/installation/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case selected = "selected"
            }
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/installation/repository_selection`.
            public var repositorySelection: Components.Schemas.Installation.RepositorySelectionPayload
            /// - Remark: Generated from `#/components/schemas/installation/access_tokens_url`.
            public var accessTokensUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/app_id`.
            public var appId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/installation/client_id`.
            public var clientId: Swift.String?
            /// The ID of the user or organization this token is being scoped to.
            ///
            /// - Remark: Generated from `#/components/schemas/installation/target_id`.
            public var targetId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/installation/target_type`.
            public var targetType: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/permissions`.
            public var permissions: Components.Schemas.AppPermissions
            /// - Remark: Generated from `#/components/schemas/installation/events`.
            public var events: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/installation/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/installation/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/installation/single_file_name`.
            public var singleFileName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/installation/has_multiple_single_files`.
            public var hasMultipleSingleFiles: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/installation/single_file_paths`.
            public var singleFilePaths: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/installation/app_slug`.
            public var appSlug: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/suspended_by`.
            public var suspendedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/installation/suspended_at`.
            public var suspendedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/installation/contact_email`.
            public var contactEmail: Swift.String?
            /// Creates a new `Installation`.
            ///
            /// - Parameters:
            ///   - id: The ID of the installation.
            ///   - account:
            ///   - repositorySelection: Describe whether all repositories have been selected or there's a selection involved
            ///   - accessTokensUrl:
            ///   - repositoriesUrl:
            ///   - htmlUrl:
            ///   - appId:
            ///   - clientId:
            ///   - targetId: The ID of the user or organization this token is being scoped to.
            ///   - targetType:
            ///   - permissions:
            ///   - events:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - singleFileName:
            ///   - hasMultipleSingleFiles:
            ///   - singleFilePaths:
            ///   - appSlug:
            ///   - suspendedBy:
            ///   - suspendedAt:
            ///   - contactEmail:
            public init(
                id: Swift.Int,
                account: Components.Schemas.Installation.AccountPayload? = nil,
                repositorySelection: Components.Schemas.Installation.RepositorySelectionPayload,
                accessTokensUrl: Swift.String,
                repositoriesUrl: Swift.String,
                htmlUrl: Swift.String,
                appId: Swift.Int,
                clientId: Swift.String? = nil,
                targetId: Swift.Int,
                targetType: Swift.String,
                permissions: Components.Schemas.AppPermissions,
                events: [Swift.String],
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                singleFileName: Swift.String? = nil,
                hasMultipleSingleFiles: Swift.Bool? = nil,
                singleFilePaths: [Swift.String]? = nil,
                appSlug: Swift.String,
                suspendedBy: Components.Schemas.NullableSimpleUser? = nil,
                suspendedAt: Foundation.Date? = nil,
                contactEmail: Swift.String? = nil
            ) {
                self.id = id
                self.account = account
                self.repositorySelection = repositorySelection
                self.accessTokensUrl = accessTokensUrl
                self.repositoriesUrl = repositoriesUrl
                self.htmlUrl = htmlUrl
                self.appId = appId
                self.clientId = clientId
                self.targetId = targetId
                self.targetType = targetType
                self.permissions = permissions
                self.events = events
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.singleFileName = singleFileName
                self.hasMultipleSingleFiles = hasMultipleSingleFiles
                self.singleFilePaths = singleFilePaths
                self.appSlug = appSlug
                self.suspendedBy = suspendedBy
                self.suspendedAt = suspendedAt
                self.contactEmail = contactEmail
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case account
                case repositorySelection = "repository_selection"
                case accessTokensUrl = "access_tokens_url"
                case repositoriesUrl = "repositories_url"
                case htmlUrl = "html_url"
                case appId = "app_id"
                case clientId = "client_id"
                case targetId = "target_id"
                case targetType = "target_type"
                case permissions
                case events
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case singleFileName = "single_file_name"
                case hasMultipleSingleFiles = "has_multiple_single_files"
                case singleFilePaths = "single_file_paths"
                case appSlug = "app_slug"
                case suspendedBy = "suspended_by"
                case suspendedAt = "suspended_at"
                case contactEmail = "contact_email"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Authentication token for a GitHub App installed on a user or org.
        ///
        /// - Remark: Generated from `#/components/schemas/installation-token`.
        public struct InstallationToken: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/installation-token/token`.
            public var token: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation-token/expires_at`.
            public var expiresAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation-token/permissions`.
            public var permissions: Components.Schemas.AppPermissions?
            /// - Remark: Generated from `#/components/schemas/installation-token/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case selected = "selected"
            }
            /// - Remark: Generated from `#/components/schemas/installation-token/repository_selection`.
            public var repositorySelection: Components.Schemas.InstallationToken.RepositorySelectionPayload?
            /// - Remark: Generated from `#/components/schemas/installation-token/repositories`.
            public var repositories: [Components.Schemas.Repository]?
            /// - Remark: Generated from `#/components/schemas/installation-token/single_file`.
            public var singleFile: Swift.String?
            /// - Remark: Generated from `#/components/schemas/installation-token/has_multiple_single_files`.
            public var hasMultipleSingleFiles: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/installation-token/single_file_paths`.
            public var singleFilePaths: [Swift.String]?
            /// Creates a new `InstallationToken`.
            ///
            /// - Parameters:
            ///   - token:
            ///   - expiresAt:
            ///   - permissions:
            ///   - repositorySelection:
            ///   - repositories:
            ///   - singleFile:
            ///   - hasMultipleSingleFiles:
            ///   - singleFilePaths:
            public init(
                token: Swift.String,
                expiresAt: Swift.String,
                permissions: Components.Schemas.AppPermissions? = nil,
                repositorySelection: Components.Schemas.InstallationToken.RepositorySelectionPayload? = nil,
                repositories: [Components.Schemas.Repository]? = nil,
                singleFile: Swift.String? = nil,
                hasMultipleSingleFiles: Swift.Bool? = nil,
                singleFilePaths: [Swift.String]? = nil
            ) {
                self.token = token
                self.expiresAt = expiresAt
                self.permissions = permissions
                self.repositorySelection = repositorySelection
                self.repositories = repositories
                self.singleFile = singleFile
                self.hasMultipleSingleFiles = hasMultipleSingleFiles
                self.singleFilePaths = singleFilePaths
            }
            public enum CodingKeys: String, CodingKey {
                case token
                case expiresAt = "expires_at"
                case permissions
                case repositorySelection = "repository_selection"
                case repositories
                case singleFile = "single_file"
                case hasMultipleSingleFiles = "has_multiple_single_files"
                case singleFilePaths = "single_file_paths"
            }
        }
        /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation`.
        public struct NullableScopedInstallation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/permissions`.
            public var permissions: Components.Schemas.AppPermissions
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case selected = "selected"
            }
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/repository_selection`.
            public var repositorySelection: Components.Schemas.NullableScopedInstallation.RepositorySelectionPayload
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/single_file_name`.
            public var singleFileName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/has_multiple_single_files`.
            public var hasMultipleSingleFiles: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/single_file_paths`.
            public var singleFilePaths: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-scoped-installation/account`.
            public var account: Components.Schemas.SimpleUser
            /// Creates a new `NullableScopedInstallation`.
            ///
            /// - Parameters:
            ///   - permissions:
            ///   - repositorySelection: Describe whether all repositories have been selected or there's a selection involved
            ///   - singleFileName:
            ///   - hasMultipleSingleFiles:
            ///   - singleFilePaths:
            ///   - repositoriesUrl:
            ///   - account:
            public init(
                permissions: Components.Schemas.AppPermissions,
                repositorySelection: Components.Schemas.NullableScopedInstallation.RepositorySelectionPayload,
                singleFileName: Swift.String? = nil,
                hasMultipleSingleFiles: Swift.Bool? = nil,
                singleFilePaths: [Swift.String]? = nil,
                repositoriesUrl: Swift.String,
                account: Components.Schemas.SimpleUser
            ) {
                self.permissions = permissions
                self.repositorySelection = repositorySelection
                self.singleFileName = singleFileName
                self.hasMultipleSingleFiles = hasMultipleSingleFiles
                self.singleFilePaths = singleFilePaths
                self.repositoriesUrl = repositoriesUrl
                self.account = account
            }
            public enum CodingKeys: String, CodingKey {
                case permissions
                case repositorySelection = "repository_selection"
                case singleFileName = "single_file_name"
                case hasMultipleSingleFiles = "has_multiple_single_files"
                case singleFilePaths = "single_file_paths"
                case repositoriesUrl = "repositories_url"
                case account
            }
        }
        /// The authorization for an OAuth app, GitHub App, or a Personal Access Token.
        ///
        /// - Remark: Generated from `#/components/schemas/authorization`.
        public struct Authorization: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/authorization/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/authorization/url`.
            public var url: Swift.String
            /// A list of scopes that this authorization is in.
            ///
            /// - Remark: Generated from `#/components/schemas/authorization/scopes`.
            public var scopes: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/authorization/token`.
            public var token: Swift.String
            /// - Remark: Generated from `#/components/schemas/authorization/token_last_eight`.
            public var tokenLastEight: Swift.String?
            /// - Remark: Generated from `#/components/schemas/authorization/hashed_token`.
            public var hashedToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/authorization/app`.
            public struct AppPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/authorization/app/client_id`.
                public var clientId: Swift.String
                /// - Remark: Generated from `#/components/schemas/authorization/app/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/authorization/app/url`.
                public var url: Swift.String
                /// Creates a new `AppPayload`.
                ///
                /// - Parameters:
                ///   - clientId:
                ///   - name:
                ///   - url:
                public init(
                    clientId: Swift.String,
                    name: Swift.String,
                    url: Swift.String
                ) {
                    self.clientId = clientId
                    self.name = name
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case clientId = "client_id"
                    case name
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/authorization/app`.
            public var app: Components.Schemas.Authorization.AppPayload
            /// - Remark: Generated from `#/components/schemas/authorization/note`.
            public var note: Swift.String?
            /// - Remark: Generated from `#/components/schemas/authorization/note_url`.
            public var noteUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/authorization/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/authorization/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/authorization/fingerprint`.
            public var fingerprint: Swift.String?
            /// - Remark: Generated from `#/components/schemas/authorization/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/authorization/installation`.
            public var installation: Components.Schemas.NullableScopedInstallation?
            /// - Remark: Generated from `#/components/schemas/authorization/expires_at`.
            public var expiresAt: Foundation.Date?
            /// Creates a new `Authorization`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - url:
            ///   - scopes: A list of scopes that this authorization is in.
            ///   - token:
            ///   - tokenLastEight:
            ///   - hashedToken:
            ///   - app:
            ///   - note:
            ///   - noteUrl:
            ///   - updatedAt:
            ///   - createdAt:
            ///   - fingerprint:
            ///   - user:
            ///   - installation:
            ///   - expiresAt:
            public init(
                id: Swift.Int64,
                url: Swift.String,
                scopes: [Swift.String]? = nil,
                token: Swift.String,
                tokenLastEight: Swift.String? = nil,
                hashedToken: Swift.String? = nil,
                app: Components.Schemas.Authorization.AppPayload,
                note: Swift.String? = nil,
                noteUrl: Swift.String? = nil,
                updatedAt: Foundation.Date,
                createdAt: Foundation.Date,
                fingerprint: Swift.String? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                installation: Components.Schemas.NullableScopedInstallation? = nil,
                expiresAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.url = url
                self.scopes = scopes
                self.token = token
                self.tokenLastEight = tokenLastEight
                self.hashedToken = hashedToken
                self.app = app
                self.note = note
                self.noteUrl = noteUrl
                self.updatedAt = updatedAt
                self.createdAt = createdAt
                self.fingerprint = fingerprint
                self.user = user
                self.installation = installation
                self.expiresAt = expiresAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case url
                case scopes
                case token
                case tokenLastEight = "token_last_eight"
                case hashedToken = "hashed_token"
                case app
                case note
                case noteUrl = "note_url"
                case updatedAt = "updated_at"
                case createdAt = "created_at"
                case fingerprint
                case user
                case installation
                case expiresAt = "expires_at"
            }
        }
        /// Marketplace Listing Plan
        ///
        /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan`.
        public struct MarketplaceListingPlan: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/accounts_url`.
            public var accountsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/description`.
            public var description: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/monthly_price_in_cents`.
            public var monthlyPriceInCents: Swift.Int
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/yearly_price_in_cents`.
            public var yearlyPriceInCents: Swift.Int
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/price_model`.
            @frozen public enum PriceModelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case free = "FREE"
                case flatRate = "FLAT_RATE"
                case perUnit = "PER_UNIT"
            }
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/price_model`.
            public var priceModel: Components.Schemas.MarketplaceListingPlan.PriceModelPayload
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/has_free_trial`.
            public var hasFreeTrial: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/unit_name`.
            public var unitName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-listing-plan/bullets`.
            public var bullets: [Swift.String]
            /// Creates a new `MarketplaceListingPlan`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - accountsUrl:
            ///   - id:
            ///   - number:
            ///   - name:
            ///   - description:
            ///   - monthlyPriceInCents:
            ///   - yearlyPriceInCents:
            ///   - priceModel:
            ///   - hasFreeTrial:
            ///   - unitName:
            ///   - state:
            ///   - bullets:
            public init(
                url: Swift.String,
                accountsUrl: Swift.String,
                id: Swift.Int,
                number: Swift.Int,
                name: Swift.String,
                description: Swift.String,
                monthlyPriceInCents: Swift.Int,
                yearlyPriceInCents: Swift.Int,
                priceModel: Components.Schemas.MarketplaceListingPlan.PriceModelPayload,
                hasFreeTrial: Swift.Bool,
                unitName: Swift.String? = nil,
                state: Swift.String,
                bullets: [Swift.String]
            ) {
                self.url = url
                self.accountsUrl = accountsUrl
                self.id = id
                self.number = number
                self.name = name
                self.description = description
                self.monthlyPriceInCents = monthlyPriceInCents
                self.yearlyPriceInCents = yearlyPriceInCents
                self.priceModel = priceModel
                self.hasFreeTrial = hasFreeTrial
                self.unitName = unitName
                self.state = state
                self.bullets = bullets
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case accountsUrl = "accounts_url"
                case id
                case number
                case name
                case description
                case monthlyPriceInCents = "monthly_price_in_cents"
                case yearlyPriceInCents = "yearly_price_in_cents"
                case priceModel = "price_model"
                case hasFreeTrial = "has_free_trial"
                case unitName = "unit_name"
                case state
                case bullets
            }
        }
        /// Marketplace Purchase
        ///
        /// - Remark: Generated from `#/components/schemas/marketplace-purchase`.
        public struct MarketplacePurchase: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/organization_billing_email`.
            public var organizationBillingEmail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change`.
            public struct MarketplacePendingChangePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change/is_installed`.
                public var isInstalled: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change/effective_date`.
                public var effectiveDate: Swift.String?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change/unit_count`.
                public var unitCount: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change/plan`.
                public var plan: Components.Schemas.MarketplaceListingPlan?
                /// Creates a new `MarketplacePendingChangePayload`.
                ///
                /// - Parameters:
                ///   - isInstalled:
                ///   - effectiveDate:
                ///   - unitCount:
                ///   - id:
                ///   - plan:
                public init(
                    isInstalled: Swift.Bool? = nil,
                    effectiveDate: Swift.String? = nil,
                    unitCount: Swift.Int? = nil,
                    id: Swift.Int? = nil,
                    plan: Components.Schemas.MarketplaceListingPlan? = nil
                ) {
                    self.isInstalled = isInstalled
                    self.effectiveDate = effectiveDate
                    self.unitCount = unitCount
                    self.id = id
                    self.plan = plan
                }
                public enum CodingKeys: String, CodingKey {
                    case isInstalled = "is_installed"
                    case effectiveDate = "effective_date"
                    case unitCount = "unit_count"
                    case id
                    case plan
                }
            }
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_pending_change`.
            public var marketplacePendingChange: Components.Schemas.MarketplacePurchase.MarketplacePendingChangePayload?
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase`.
            public struct MarketplacePurchasePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/billing_cycle`.
                public var billingCycle: Swift.String?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/next_billing_date`.
                public var nextBillingDate: Swift.String?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/is_installed`.
                public var isInstalled: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/unit_count`.
                public var unitCount: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/on_free_trial`.
                public var onFreeTrial: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/free_trial_ends_on`.
                public var freeTrialEndsOn: Swift.String?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/updated_at`.
                public var updatedAt: Swift.String?
                /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase/plan`.
                public var plan: Components.Schemas.MarketplaceListingPlan?
                /// Creates a new `MarketplacePurchasePayload`.
                ///
                /// - Parameters:
                ///   - billingCycle:
                ///   - nextBillingDate:
                ///   - isInstalled:
                ///   - unitCount:
                ///   - onFreeTrial:
                ///   - freeTrialEndsOn:
                ///   - updatedAt:
                ///   - plan:
                public init(
                    billingCycle: Swift.String? = nil,
                    nextBillingDate: Swift.String? = nil,
                    isInstalled: Swift.Bool? = nil,
                    unitCount: Swift.Int? = nil,
                    onFreeTrial: Swift.Bool? = nil,
                    freeTrialEndsOn: Swift.String? = nil,
                    updatedAt: Swift.String? = nil,
                    plan: Components.Schemas.MarketplaceListingPlan? = nil
                ) {
                    self.billingCycle = billingCycle
                    self.nextBillingDate = nextBillingDate
                    self.isInstalled = isInstalled
                    self.unitCount = unitCount
                    self.onFreeTrial = onFreeTrial
                    self.freeTrialEndsOn = freeTrialEndsOn
                    self.updatedAt = updatedAt
                    self.plan = plan
                }
                public enum CodingKeys: String, CodingKey {
                    case billingCycle = "billing_cycle"
                    case nextBillingDate = "next_billing_date"
                    case isInstalled = "is_installed"
                    case unitCount = "unit_count"
                    case onFreeTrial = "on_free_trial"
                    case freeTrialEndsOn = "free_trial_ends_on"
                    case updatedAt = "updated_at"
                    case plan
                }
            }
            /// - Remark: Generated from `#/components/schemas/marketplace-purchase/marketplace_purchase`.
            public var marketplacePurchase: Components.Schemas.MarketplacePurchase.MarketplacePurchasePayload
            /// Creates a new `MarketplacePurchase`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - _type:
            ///   - id:
            ///   - login:
            ///   - organizationBillingEmail:
            ///   - email:
            ///   - marketplacePendingChange:
            ///   - marketplacePurchase:
            public init(
                url: Swift.String,
                _type: Swift.String,
                id: Swift.Int,
                login: Swift.String,
                organizationBillingEmail: Swift.String? = nil,
                email: Swift.String? = nil,
                marketplacePendingChange: Components.Schemas.MarketplacePurchase.MarketplacePendingChangePayload? = nil,
                marketplacePurchase: Components.Schemas.MarketplacePurchase.MarketplacePurchasePayload
            ) {
                self.url = url
                self._type = _type
                self.id = id
                self.login = login
                self.organizationBillingEmail = organizationBillingEmail
                self.email = email
                self.marketplacePendingChange = marketplacePendingChange
                self.marketplacePurchase = marketplacePurchase
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case _type = "type"
                case id
                case login
                case organizationBillingEmail = "organization_billing_email"
                case email
                case marketplacePendingChange = "marketplace_pending_change"
                case marketplacePurchase = "marketplace_purchase"
            }
        }
        /// - Remark: Generated from `#/components/schemas/marketplace-account`.
        public struct MarketplaceAccount: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/marketplace-account/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-account/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/marketplace-account/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-account/node_id`.
            public var nodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/marketplace-account/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/marketplace-account/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/marketplace-account/organization_billing_email`.
            public var organizationBillingEmail: Swift.String?
            /// Creates a new `MarketplaceAccount`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id:
            ///   - _type:
            ///   - nodeId:
            ///   - login:
            ///   - email:
            ///   - organizationBillingEmail:
            public init(
                url: Swift.String,
                id: Swift.Int,
                _type: Swift.String,
                nodeId: Swift.String? = nil,
                login: Swift.String,
                email: Swift.String? = nil,
                organizationBillingEmail: Swift.String? = nil
            ) {
                self.url = url
                self.id = id
                self._type = _type
                self.nodeId = nodeId
                self.login = login
                self.email = email
                self.organizationBillingEmail = organizationBillingEmail
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case _type = "type"
                case nodeId = "node_id"
                case login
                case email
                case organizationBillingEmail = "organization_billing_email"
            }
        }
        /// User Marketplace Purchase
        ///
        /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase`.
        public struct UserMarketplacePurchase: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/billing_cycle`.
            public var billingCycle: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/next_billing_date`.
            public var nextBillingDate: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/unit_count`.
            public var unitCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/on_free_trial`.
            public var onFreeTrial: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/free_trial_ends_on`.
            public var freeTrialEndsOn: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/account`.
            public var account: Components.Schemas.MarketplaceAccount
            /// - Remark: Generated from `#/components/schemas/user-marketplace-purchase/plan`.
            public var plan: Components.Schemas.MarketplaceListingPlan
            /// Creates a new `UserMarketplacePurchase`.
            ///
            /// - Parameters:
            ///   - billingCycle:
            ///   - nextBillingDate:
            ///   - unitCount:
            ///   - onFreeTrial:
            ///   - freeTrialEndsOn:
            ///   - updatedAt:
            ///   - account:
            ///   - plan:
            public init(
                billingCycle: Swift.String,
                nextBillingDate: Foundation.Date? = nil,
                unitCount: Swift.Int? = nil,
                onFreeTrial: Swift.Bool,
                freeTrialEndsOn: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                account: Components.Schemas.MarketplaceAccount,
                plan: Components.Schemas.MarketplaceListingPlan
            ) {
                self.billingCycle = billingCycle
                self.nextBillingDate = nextBillingDate
                self.unitCount = unitCount
                self.onFreeTrial = onFreeTrial
                self.freeTrialEndsOn = freeTrialEndsOn
                self.updatedAt = updatedAt
                self.account = account
                self.plan = plan
            }
            public enum CodingKeys: String, CodingKey {
                case billingCycle = "billing_cycle"
                case nextBillingDate = "next_billing_date"
                case unitCount = "unit_count"
                case onFreeTrial = "on_free_trial"
                case freeTrialEndsOn = "free_trial_ends_on"
                case updatedAt = "updated_at"
                case account
                case plan
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
        ///
        /// - Remark: Generated from `#/components/parameters/cursor`.
        public typealias Cursor = Swift.String
        /// - Remark: Generated from `#/components/parameters/delivery-id`.
        public typealias DeliveryId = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/since`.
        public typealias Since = Foundation.Date
        /// The unique identifier of the installation.
        ///
        /// - Remark: Generated from `#/components/parameters/installation-id`.
        public typealias InstallationId = Swift.Int
        /// The client ID of the GitHub app.
        ///
        /// - Remark: Generated from `#/components/parameters/client-id`.
        public typealias ClientId = Swift.String
        /// - Remark: Generated from `#/components/parameters/app-slug`.
        public typealias AppSlug = Swift.String
        /// account_id parameter
        ///
        /// - Remark: Generated from `#/components/parameters/account-id`.
        public typealias AccountId = Swift.Int
        /// The unique identifier of the plan.
        ///
        /// - Remark: Generated from `#/components/parameters/plan-id`.
        public typealias PlanId = Swift.Int
        /// The property to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/sort`.
        @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
            case created = "created"
            case updated = "updated"
        }
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The unique identifier of the repository.
        ///
        /// - Remark: Generated from `#/components/parameters/repository-id`.
        public typealias RepositoryId = Swift.Int
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Accepted: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/accepted/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/accepted/content/application\/json`.
                case json(OpenAPIRuntime.OpenAPIObjectContainer)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: OpenAPIRuntime.OpenAPIObjectContainer {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Accepted.Body
            /// Creates a new `Accepted`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Accepted.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct MovedPermanently: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/moved_permanently/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/moved_permanently/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.MovedPermanently.Body
            /// Creates a new `MovedPermanently`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.MovedPermanently.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get the authenticated app
    ///
    /// Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/apps/apps#list-installations-for-the-authenticated-app)" endpoint.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app`.
    /// - Remark: Generated from `#/paths//app/get(apps/get-authenticated)`.
    public enum AppsGetAuthenticated {
        public static let id: Swift.String = "apps/get-authenticated"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetAuthenticated.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetAuthenticated.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetAuthenticated.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.AppsGetAuthenticated.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Integration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Integration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetAuthenticated.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetAuthenticated.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/get(apps/get-authenticated)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetAuthenticated.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetAuthenticated.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a GitHub App from a manifest
    ///
    /// Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
    ///
    /// - Remark: HTTP `POST /app-manifests/{code}/conversions`.
    /// - Remark: Generated from `#/paths//app-manifests/{code}/conversions/post(apps/create-from-manifest)`.
    public enum AppsCreateFromManifest {
        public static let id: Swift.String = "apps/create-from-manifest"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/path/code`.
                public var code: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - code:
                public init(code: Swift.String) {
                    self.code = code
                }
            }
            public var path: Operations.AppsCreateFromManifest.Input.Path
            /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsCreateFromManifest.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsCreateFromManifest.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsCreateFromManifest.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsCreateFromManifest.Input.Path,
                headers: Operations.AppsCreateFromManifest.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value1`.
                        public var value1: Components.Schemas.Integration
                        /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value2`.
                        public struct Value2Payload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value2/client_id`.
                            public var clientId: Swift.String
                            /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value2/client_secret`.
                            public var clientSecret: Swift.String
                            /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value2/webhook_secret`.
                            public var webhookSecret: Swift.String?
                            /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value2/pem`.
                            public var pem: Swift.String
                            /// A container of undocumented properties.
                            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                            /// Creates a new `Value2Payload`.
                            ///
                            /// - Parameters:
                            ///   - clientId:
                            ///   - clientSecret:
                            ///   - webhookSecret:
                            ///   - pem:
                            ///   - additionalProperties: A container of undocumented properties.
                            public init(
                                clientId: Swift.String,
                                clientSecret: Swift.String,
                                webhookSecret: Swift.String? = nil,
                                pem: Swift.String,
                                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
                            ) {
                                self.clientId = clientId
                                self.clientSecret = clientSecret
                                self.webhookSecret = webhookSecret
                                self.pem = pem
                                self.additionalProperties = additionalProperties
                            }
                            public enum CodingKeys: String, CodingKey {
                                case clientId = "client_id"
                                case clientSecret = "client_secret"
                                case webhookSecret = "webhook_secret"
                                case pem
                            }
                            public init(from decoder: any Decoder) throws {
                                let container = try decoder.container(keyedBy: CodingKeys.self)
                                self.clientId = try container.decode(
                                    Swift.String.self,
                                    forKey: .clientId
                                )
                                self.clientSecret = try container.decode(
                                    Swift.String.self,
                                    forKey: .clientSecret
                                )
                                self.webhookSecret = try container.decodeIfPresent(
                                    Swift.String.self,
                                    forKey: .webhookSecret
                                )
                                self.pem = try container.decode(
                                    Swift.String.self,
                                    forKey: .pem
                                )
                                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                                    "client_id",
                                    "client_secret",
                                    "webhook_secret",
                                    "pem"
                                ])
                            }
                            public func encode(to encoder: any Encoder) throws {
                                var container = encoder.container(keyedBy: CodingKeys.self)
                                try container.encode(
                                    self.clientId,
                                    forKey: .clientId
                                )
                                try container.encode(
                                    self.clientSecret,
                                    forKey: .clientSecret
                                )
                                try container.encodeIfPresent(
                                    self.webhookSecret,
                                    forKey: .webhookSecret
                                )
                                try container.encode(
                                    self.pem,
                                    forKey: .pem
                                )
                                try encoder.encodeAdditionalProperties(additionalProperties)
                            }
                        }
                        /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/json/value2`.
                        public var value2: Operations.AppsCreateFromManifest.Output.Created.Body.JsonPayload.Value2Payload
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: Components.Schemas.Integration,
                            value2: Operations.AppsCreateFromManifest.Output.Created.Body.JsonPayload.Value2Payload
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            self.value1 = try .init(from: decoder)
                            self.value2 = try .init(from: decoder)
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try self.value1.encode(to: encoder)
                            try self.value2.encode(to: encoder)
                        }
                    }
                    /// - Remark: Generated from `#/paths/app-manifests/{code}/conversions/POST/responses/201/content/application\/json`.
                    case json(Operations.AppsCreateFromManifest.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.AppsCreateFromManifest.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsCreateFromManifest.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsCreateFromManifest.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app-manifests/{code}/conversions/post(apps/create-from-manifest)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.AppsCreateFromManifest.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.AppsCreateFromManifest.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//app-manifests/{code}/conversions/post(apps/create-from-manifest)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//app-manifests/{code}/conversions/post(apps/create-from-manifest)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a webhook configuration for an app
    ///
    /// Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/config`.
    /// - Remark: Generated from `#/paths//app/hook/config/get(apps/get-webhook-config-for-app)`.
    public enum AppsGetWebhookConfigForApp {
        public static let id: Swift.String = "apps/get-webhook-config-for-app"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/hook/config/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetWebhookConfigForApp.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetWebhookConfigForApp.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetWebhookConfigForApp.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.AppsGetWebhookConfigForApp.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/config/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/hook/config/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.WebhookConfig)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.WebhookConfig {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetWebhookConfigForApp.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetWebhookConfigForApp.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/hook/config/get(apps/get-webhook-config-for-app)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetWebhookConfigForApp.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetWebhookConfigForApp.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a webhook configuration for an app
    ///
    /// Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `PATCH /app/hook/config`.
    /// - Remark: Generated from `#/paths//app/hook/config/patch(apps/update-webhook-config-for-app)`.
    public enum AppsUpdateWebhookConfigForApp {
        public static let id: Swift.String = "apps/update-webhook-config-for-app"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/hook/config/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsUpdateWebhookConfigForApp.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsUpdateWebhookConfigForApp.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsUpdateWebhookConfigForApp.Input.Headers
            /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody/json/url`.
                    public var url: Components.Schemas.WebhookConfigUrl?
                    /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody/json/content_type`.
                    public var contentType: Components.Schemas.WebhookConfigContentType?
                    /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody/json/secret`.
                    public var secret: Components.Schemas.WebhookConfigSecret?
                    /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody/json/insecure_ssl`.
                    public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - url:
                    ///   - contentType:
                    ///   - secret:
                    ///   - insecureSsl:
                    public init(
                        url: Components.Schemas.WebhookConfigUrl? = nil,
                        contentType: Components.Schemas.WebhookConfigContentType? = nil,
                        secret: Components.Schemas.WebhookConfigSecret? = nil,
                        insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil
                    ) {
                        self.url = url
                        self.contentType = contentType
                        self.secret = secret
                        self.insecureSsl = insecureSsl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case url
                        case contentType = "content_type"
                        case secret
                        case insecureSsl = "insecure_ssl"
                    }
                }
                /// - Remark: Generated from `#/paths/app/hook/config/PATCH/requestBody/content/application\/json`.
                case json(Operations.AppsUpdateWebhookConfigForApp.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsUpdateWebhookConfigForApp.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.AppsUpdateWebhookConfigForApp.Input.Headers = .init(),
                body: Operations.AppsUpdateWebhookConfigForApp.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/config/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/hook/config/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.WebhookConfig)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.WebhookConfig {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsUpdateWebhookConfigForApp.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsUpdateWebhookConfigForApp.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/hook/config/patch(apps/update-webhook-config-for-app)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsUpdateWebhookConfigForApp.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsUpdateWebhookConfigForApp.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List deliveries for an app webhook
    ///
    /// Returns a list of webhook deliveries for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/deliveries`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/get(apps/list-webhook-deliveries)`.
    public enum AppsListWebhookDeliveries {
        public static let id: Swift.String = "apps/list-webhook-deliveries"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/hook/deliveries/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/app/hook/deliveries/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
                ///
                /// - Remark: Generated from `#/paths/app/hook/deliveries/GET/query/cursor`.
                public var cursor: Components.Parameters.Cursor?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - cursor: Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    cursor: Components.Parameters.Cursor? = nil
                ) {
                    self.perPage = perPage
                    self.cursor = cursor
                }
            }
            public var query: Operations.AppsListWebhookDeliveries.Input.Query
            /// - Remark: Generated from `#/paths/app/hook/deliveries/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListWebhookDeliveries.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListWebhookDeliveries.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListWebhookDeliveries.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListWebhookDeliveries.Input.Query = .init(),
                headers: Operations.AppsListWebhookDeliveries.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/deliveries/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/hook/deliveries/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.HookDeliveryItem])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.HookDeliveryItem] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListWebhookDeliveries.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsListWebhookDeliveries.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/get(apps/list-webhook-deliveries)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListWebhookDeliveries.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListWebhookDeliveries.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/get(apps/list-webhook-deliveries)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/get(apps/list-webhook-deliveries)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get a delivery for an app webhook
    ///
    /// Returns a delivery for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/hook/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/get(apps/get-webhook-delivery)`.
    public enum AppsGetWebhookDelivery {
        public static let id: Swift.String = "apps/get-webhook-delivery"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/GET/path/delivery_id`.
                public var deliveryId: Components.Parameters.DeliveryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - deliveryId:
                public init(deliveryId: Components.Parameters.DeliveryId) {
                    self.deliveryId = deliveryId
                }
            }
            public var path: Operations.AppsGetWebhookDelivery.Input.Path
            /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetWebhookDelivery.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetWebhookDelivery.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetWebhookDelivery.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetWebhookDelivery.Input.Path,
                headers: Operations.AppsGetWebhookDelivery.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.HookDelivery)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.HookDelivery {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetWebhookDelivery.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetWebhookDelivery.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/get(apps/get-webhook-delivery)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetWebhookDelivery.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetWebhookDelivery.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/get(apps/get-webhook-delivery)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/get(apps/get-webhook-delivery)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Redeliver a delivery for an app webhook
    ///
    /// Redeliver a delivery for the webhook configured for a GitHub App.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `POST /app/hook/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/attempts/post(apps/redeliver-webhook-delivery)`.
    public enum AppsRedeliverWebhookDelivery {
        public static let id: Swift.String = "apps/redeliver-webhook-delivery"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/attempts/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/attempts/POST/path/delivery_id`.
                public var deliveryId: Components.Parameters.DeliveryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - deliveryId:
                public init(deliveryId: Components.Parameters.DeliveryId) {
                    self.deliveryId = deliveryId
                }
            }
            public var path: Operations.AppsRedeliverWebhookDelivery.Input.Path
            /// - Remark: Generated from `#/paths/app/hook/deliveries/{delivery_id}/attempts/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsRedeliverWebhookDelivery.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsRedeliverWebhookDelivery.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsRedeliverWebhookDelivery.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsRedeliverWebhookDelivery.Input.Path,
                headers: Operations.AppsRedeliverWebhookDelivery.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/attempts/post(apps/redeliver-webhook-delivery)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/attempts/post(apps/redeliver-webhook-delivery)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//app/hook/deliveries/{delivery_id}/attempts/post(apps/redeliver-webhook-delivery)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List installation requests for the authenticated app
    ///
    /// Lists all the pending installation requests for the authenticated GitHub App.
    ///
    /// - Remark: HTTP `GET /app/installation-requests`.
    /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)`.
    public enum AppsListInstallationRequestsForAuthenticatedApp {
        public static let id: Swift.String = "apps/list-installation-requests-for-authenticated-app"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installation-requests/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/app/installation-requests/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/app/installation-requests/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input.Query
            /// - Remark: Generated from `#/paths/app/installation-requests/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallationRequestsForAuthenticatedApp.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallationRequestsForAuthenticatedApp.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input.Query = .init(),
                headers: Operations.AppsListInstallationRequestsForAuthenticatedApp.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/installation-requests/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/installation-requests/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.IntegrationInstallationRequest])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.IntegrationInstallationRequest] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListInstallationRequestsForAuthenticatedApp.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsListInstallationRequestsForAuthenticatedApp.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// List of integration installation requests
            ///
            /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListInstallationRequestsForAuthenticatedApp.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListInstallationRequestsForAuthenticatedApp.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//app/installation-requests/get(apps/list-installation-requests-for-authenticated-app)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List installations for the authenticated app
    ///
    /// The permissions the installation has are included under the `permissions` key.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/installations`.
    /// - Remark: Generated from `#/paths//app/installations/get(apps/list-installations)`.
    public enum AppsListInstallations {
        public static let id: Swift.String = "apps/list-installations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/app/installations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/app/installations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/app/installations/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// - Remark: Generated from `#/paths/app/installations/GET/query/outdated`.
                public var outdated: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - outdated:
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    since: Components.Parameters.Since? = nil,
                    outdated: Swift.String? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                    self.since = since
                    self.outdated = outdated
                }
            }
            public var query: Operations.AppsListInstallations.Input.Query
            /// - Remark: Generated from `#/paths/app/installations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListInstallations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListInstallations.Input.Query = .init(),
                headers: Operations.AppsListInstallations.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/installations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/installations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListInstallations.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/app/installations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/installations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Installation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Installation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListInstallations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListInstallations.Output.Ok.Headers = .init(),
                    body: Operations.AppsListInstallations.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// The permissions the installation has are included under the `permissions` key.
            ///
            /// - Remark: Generated from `#/paths//app/installations/get(apps/list-installations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListInstallations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListInstallations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find an installation's information using the installation id.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /app/installations/{installation_id}`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/get(apps/get-installation)`.
    public enum AppsGetInstallation {
        public static let id: Swift.String = "apps/get-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/GET/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                public init(installationId: Components.Parameters.InstallationId) {
                    self.installationId = installationId
                }
            }
            public var path: Operations.AppsGetInstallation.Input.Path
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetInstallation.Input.Path,
                headers: Operations.AppsGetInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/installations/{installation_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Installation)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Installation {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetInstallation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetInstallation.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/get(apps/get-installation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetInstallation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetInstallation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/get(apps/get-installation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an installation for the authenticated app
    ///
    /// Uninstalls a GitHub App on a user, organization, or enterprise account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/apps/apps#suspend-an-app-installation)" endpoint.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `DELETE /app/installations/{installation_id}`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/delete(apps/delete-installation)`.
    public enum AppsDeleteInstallation {
        public static let id: Swift.String = "apps/delete-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/DELETE/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                public init(installationId: Components.Parameters.InstallationId) {
                    self.installationId = installationId
                }
            }
            public var path: Operations.AppsDeleteInstallation.Input.Path
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsDeleteInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsDeleteInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsDeleteInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsDeleteInstallation.Input.Path,
                headers: Operations.AppsDeleteInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/delete(apps/delete-installation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsDeleteInstallation.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/delete(apps/delete-installation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsDeleteInstallation.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/delete(apps/delete-installation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an installation access token for an app
    ///
    /// Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access.
    ///
    /// Optionally, you can use the `repositories` or `repository_ids` body parameters to specify individual repositories that the installation access token can access. If you don't use `repositories` or `repository_ids` to grant access to specific repositories, the installation access token will have access to all repositories that the installation was granted access to. The installation access token cannot be granted access to repositories that the installation was not granted access to. Up to 500 repositories can be listed in this manner.
    ///
    /// Optionally, use the `permissions` body parameter to specify the permissions that the installation access token should have. If `permissions` is not specified, the installation access token will have all of the permissions that were granted to the app. The installation access token cannot be granted permissions that the app was not granted.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `POST /app/installations/{installation_id}/access_tokens`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)`.
    public enum AppsCreateInstallationAccessToken {
        public static let id: Swift.String = "apps/create-installation-access-token"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                public init(installationId: Components.Parameters.InstallationId) {
                    self.installationId = installationId
                }
            }
            public var path: Operations.AppsCreateInstallationAccessToken.Input.Path
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsCreateInstallationAccessToken.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsCreateInstallationAccessToken.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsCreateInstallationAccessToken.Input.Headers
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// List of repository names that the token should have access to
                    ///
                    /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/requestBody/json/repositories`.
                    public var repositories: [Swift.String]?
                    /// List of repository IDs that the token should have access to
                    ///
                    /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/requestBody/json/repository_ids`.
                    public var repositoryIds: [Swift.Int]?
                    /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/requestBody/json/permissions`.
                    public var permissions: Components.Schemas.AppPermissions?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - repositories: List of repository names that the token should have access to
                    ///   - repositoryIds: List of repository IDs that the token should have access to
                    ///   - permissions:
                    public init(
                        repositories: [Swift.String]? = nil,
                        repositoryIds: [Swift.Int]? = nil,
                        permissions: Components.Schemas.AppPermissions? = nil
                    ) {
                        self.repositories = repositories
                        self.repositoryIds = repositoryIds
                        self.permissions = permissions
                    }
                    public enum CodingKeys: String, CodingKey {
                        case repositories
                        case repositoryIds = "repository_ids"
                        case permissions
                    }
                }
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/requestBody/content/application\/json`.
                case json(Operations.AppsCreateInstallationAccessToken.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsCreateInstallationAccessToken.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.AppsCreateInstallationAccessToken.Input.Path,
                headers: Operations.AppsCreateInstallationAccessToken.Input.Headers = .init(),
                body: Operations.AppsCreateInstallationAccessToken.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/app/installations/{installation_id}/access_tokens/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.InstallationToken)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.InstallationToken {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsCreateInstallationAccessToken.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsCreateInstallationAccessToken.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.AppsCreateInstallationAccessToken.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.AppsCreateInstallationAccessToken.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/access_tokens/post(apps/create-installation-access-token)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Suspend an app installation
    ///
    /// Suspends a GitHub App on a user, organization, or enterprise account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `PUT /app/installations/{installation_id}/suspended`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/put(apps/suspend-installation)`.
    public enum AppsSuspendInstallation {
        public static let id: Swift.String = "apps/suspend-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/suspended/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/suspended/PUT/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                public init(installationId: Components.Parameters.InstallationId) {
                    self.installationId = installationId
                }
            }
            public var path: Operations.AppsSuspendInstallation.Input.Path
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/suspended/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsSuspendInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsSuspendInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsSuspendInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsSuspendInstallation.Input.Path,
                headers: Operations.AppsSuspendInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/put(apps/suspend-installation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsSuspendInstallation.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/put(apps/suspend-installation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsSuspendInstallation.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/put(apps/suspend-installation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unsuspend an app installation
    ///
    /// Removes a GitHub App installation suspension.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `DELETE /app/installations/{installation_id}/suspended`.
    /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/delete(apps/unsuspend-installation)`.
    public enum AppsUnsuspendInstallation {
        public static let id: Swift.String = "apps/unsuspend-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/suspended/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/app/installations/{installation_id}/suspended/DELETE/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                public init(installationId: Components.Parameters.InstallationId) {
                    self.installationId = installationId
                }
            }
            public var path: Operations.AppsUnsuspendInstallation.Input.Path
            /// - Remark: Generated from `#/paths/app/installations/{installation_id}/suspended/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsUnsuspendInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsUnsuspendInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsUnsuspendInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsUnsuspendInstallation.Input.Path,
                headers: Operations.AppsUnsuspendInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/delete(apps/unsuspend-installation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsUnsuspendInstallation.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/delete(apps/unsuspend-installation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsUnsuspendInstallation.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//app/installations/{installation_id}/suspended/delete(apps/unsuspend-installation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an app authorization
    ///
    /// OAuth and GitHub application owners can revoke a grant for their application and a specific user. You must provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
    /// Deleting an application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    ///
    /// - Remark: HTTP `DELETE /applications/{client_id}/grant`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/grant/delete(apps/delete-authorization)`.
    public enum AppsDeleteAuthorization {
        public static let id: Swift.String = "apps/delete-authorization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The client ID of the GitHub app.
                ///
                /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/path/client_id`.
                public var clientId: Components.Parameters.ClientId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - clientId: The client ID of the GitHub app.
                public init(clientId: Components.Parameters.ClientId) {
                    self.clientId = clientId
                }
            }
            public var path: Operations.AppsDeleteAuthorization.Input.Path
            /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsDeleteAuthorization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsDeleteAuthorization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsDeleteAuthorization.Input.Headers
            /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The OAuth access token used to authenticate to the GitHub API.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/requestBody/json/access_token`.
                    public var accessToken: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accessToken: The OAuth access token used to authenticate to the GitHub API.
                    public init(accessToken: Swift.String) {
                        self.accessToken = accessToken
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accessToken = "access_token"
                    }
                }
                /// - Remark: Generated from `#/paths/applications/{client_id}/grant/DELETE/requestBody/content/application\/json`.
                case json(Operations.AppsDeleteAuthorization.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsDeleteAuthorization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.AppsDeleteAuthorization.Input.Path,
                headers: Operations.AppsDeleteAuthorization.Input.Headers = .init(),
                body: Operations.AppsDeleteAuthorization.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/grant/delete(apps/delete-authorization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsDeleteAuthorization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/grant/delete(apps/delete-authorization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsDeleteAuthorization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/grant/delete(apps/delete-authorization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check a token
    ///
    /// OAuth applications and GitHub applications with OAuth authorizations can use this API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `POST /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/post(apps/check-token)`.
    public enum AppsCheckToken {
        public static let id: Swift.String = "apps/check-token"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The client ID of the GitHub app.
                ///
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/path/client_id`.
                public var clientId: Components.Parameters.ClientId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - clientId: The client ID of the GitHub app.
                public init(clientId: Components.Parameters.ClientId) {
                    self.clientId = clientId
                }
            }
            public var path: Operations.AppsCheckToken.Input.Path
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsCheckToken.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsCheckToken.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsCheckToken.Input.Headers
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The access_token of the OAuth or GitHub application.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/requestBody/json/access_token`.
                    public var accessToken: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accessToken: The access_token of the OAuth or GitHub application.
                    public init(accessToken: Swift.String) {
                        self.accessToken = accessToken
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accessToken = "access_token"
                    }
                }
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/requestBody/content/application\/json`.
                case json(Operations.AppsCheckToken.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsCheckToken.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.AppsCheckToken.Input.Path,
                headers: Operations.AppsCheckToken.Input.Headers = .init(),
                body: Operations.AppsCheckToken.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Authorization)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Authorization {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsCheckToken.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsCheckToken.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/post(apps/check-token)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsCheckToken.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsCheckToken.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/post(apps/check-token)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/post(apps/check-token)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Reset a token
    ///
    /// OAuth applications and GitHub applications with OAuth authorizations can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `PATCH /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/patch(apps/reset-token)`.
    public enum AppsResetToken {
        public static let id: Swift.String = "apps/reset-token"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The client ID of the GitHub app.
                ///
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/path/client_id`.
                public var clientId: Components.Parameters.ClientId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - clientId: The client ID of the GitHub app.
                public init(clientId: Components.Parameters.ClientId) {
                    self.clientId = clientId
                }
            }
            public var path: Operations.AppsResetToken.Input.Path
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsResetToken.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsResetToken.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsResetToken.Input.Headers
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The access_token of the OAuth or GitHub application.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/requestBody/json/access_token`.
                    public var accessToken: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accessToken: The access_token of the OAuth or GitHub application.
                    public init(accessToken: Swift.String) {
                        self.accessToken = accessToken
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accessToken = "access_token"
                    }
                }
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/requestBody/content/application\/json`.
                case json(Operations.AppsResetToken.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsResetToken.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.AppsResetToken.Input.Path,
                headers: Operations.AppsResetToken.Input.Headers = .init(),
                body: Operations.AppsResetToken.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Authorization)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Authorization {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsResetToken.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsResetToken.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/patch(apps/reset-token)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsResetToken.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsResetToken.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/patch(apps/reset-token)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an app token
    ///
    /// OAuth  or GitHub application owners can revoke a single token for an OAuth application or a GitHub application with an OAuth authorization.
    ///
    /// - Remark: HTTP `DELETE /applications/{client_id}/token`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/delete(apps/delete-token)`.
    public enum AppsDeleteToken {
        public static let id: Swift.String = "apps/delete-token"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The client ID of the GitHub app.
                ///
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/path/client_id`.
                public var clientId: Components.Parameters.ClientId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - clientId: The client ID of the GitHub app.
                public init(clientId: Components.Parameters.ClientId) {
                    self.clientId = clientId
                }
            }
            public var path: Operations.AppsDeleteToken.Input.Path
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsDeleteToken.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsDeleteToken.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsDeleteToken.Input.Headers
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The OAuth access token used to authenticate to the GitHub API.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/requestBody/json/access_token`.
                    public var accessToken: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accessToken: The OAuth access token used to authenticate to the GitHub API.
                    public init(accessToken: Swift.String) {
                        self.accessToken = accessToken
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accessToken = "access_token"
                    }
                }
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/DELETE/requestBody/content/application\/json`.
                case json(Operations.AppsDeleteToken.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsDeleteToken.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.AppsDeleteToken.Input.Path,
                headers: Operations.AppsDeleteToken.Input.Headers = .init(),
                body: Operations.AppsDeleteToken.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/delete(apps/delete-token)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsDeleteToken.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/delete(apps/delete-token)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsDeleteToken.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/delete(apps/delete-token)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a scoped access token
    ///
    /// Use a non-scoped user access token to create a repository-scoped and/or permission-scoped user access token. You can specify
    /// which repositories the token can access and which permissions are granted to the
    /// token.
    ///
    /// Invalid tokens will return `404 NOT FOUND`.
    ///
    /// - Remark: HTTP `POST /applications/{client_id}/token/scoped`.
    /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)`.
    public enum AppsScopeToken {
        public static let id: Swift.String = "apps/scope-token"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The client ID of the GitHub app.
                ///
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/path/client_id`.
                public var clientId: Components.Parameters.ClientId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - clientId: The client ID of the GitHub app.
                public init(clientId: Components.Parameters.ClientId) {
                    self.clientId = clientId
                }
            }
            public var path: Operations.AppsScopeToken.Input.Path
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsScopeToken.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsScopeToken.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsScopeToken.Input.Headers
            /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The access token used to authenticate to the GitHub API.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json/access_token`.
                    public var accessToken: Swift.String
                    /// The name of the user or organization to scope the user access token to. **Required** unless `target_id` is specified.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json/target`.
                    public var target: Swift.String?
                    /// The ID of the user or organization to scope the user access token to. **Required** unless `target` is specified.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json/target_id`.
                    public var targetId: Swift.Int?
                    /// The list of repository names to scope the user access token to. `repositories` may not be specified if `repository_ids` is specified.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json/repositories`.
                    public var repositories: [Swift.String]?
                    /// The list of repository IDs to scope the user access token to. `repository_ids` may not be specified if `repositories` is specified.
                    ///
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json/repository_ids`.
                    public var repositoryIds: [Swift.Int]?
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/json/permissions`.
                    public var permissions: Components.Schemas.AppPermissions?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accessToken: The access token used to authenticate to the GitHub API.
                    ///   - target: The name of the user or organization to scope the user access token to. **Required** unless `target_id` is specified.
                    ///   - targetId: The ID of the user or organization to scope the user access token to. **Required** unless `target` is specified.
                    ///   - repositories: The list of repository names to scope the user access token to. `repositories` may not be specified if `repository_ids` is specified.
                    ///   - repositoryIds: The list of repository IDs to scope the user access token to. `repository_ids` may not be specified if `repositories` is specified.
                    ///   - permissions:
                    public init(
                        accessToken: Swift.String,
                        target: Swift.String? = nil,
                        targetId: Swift.Int? = nil,
                        repositories: [Swift.String]? = nil,
                        repositoryIds: [Swift.Int]? = nil,
                        permissions: Components.Schemas.AppPermissions? = nil
                    ) {
                        self.accessToken = accessToken
                        self.target = target
                        self.targetId = targetId
                        self.repositories = repositories
                        self.repositoryIds = repositoryIds
                        self.permissions = permissions
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accessToken = "access_token"
                        case target
                        case targetId = "target_id"
                        case repositories
                        case repositoryIds = "repository_ids"
                        case permissions
                    }
                }
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/requestBody/content/application\/json`.
                case json(Operations.AppsScopeToken.Input.Body.JsonPayload)
            }
            public var body: Operations.AppsScopeToken.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.AppsScopeToken.Input.Path,
                headers: Operations.AppsScopeToken.Input.Headers = .init(),
                body: Operations.AppsScopeToken.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/applications/{client_id}/token/scoped/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Authorization)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Authorization {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsScopeToken.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsScopeToken.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsScopeToken.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsScopeToken.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//applications/{client_id}/token/scoped/post(apps/scope-token)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an app
    ///
    /// > [!NOTE]
    /// > The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
    ///
    /// - Remark: HTTP `GET /apps/{app_slug}`.
    /// - Remark: Generated from `#/paths//apps/{app_slug}/get(apps/get-by-slug)`.
    public enum AppsGetBySlug {
        public static let id: Swift.String = "apps/get-by-slug"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/apps/{app_slug}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/apps/{app_slug}/GET/path/app_slug`.
                public var appSlug: Components.Parameters.AppSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - appSlug:
                public init(appSlug: Components.Parameters.AppSlug) {
                    self.appSlug = appSlug
                }
            }
            public var path: Operations.AppsGetBySlug.Input.Path
            /// - Remark: Generated from `#/paths/apps/{app_slug}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetBySlug.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetBySlug.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetBySlug.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetBySlug.Input.Path,
                headers: Operations.AppsGetBySlug.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/apps/{app_slug}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/apps/{app_slug}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Integration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Integration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetBySlug.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetBySlug.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//apps/{app_slug}/get(apps/get-by-slug)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetBySlug.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetBySlug.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//apps/{app_slug}/get(apps/get-by-slug)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//apps/{app_slug}/get(apps/get-by-slug)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories accessible to the app installation
    ///
    /// List repositories that an app installation can access.
    ///
    /// - Remark: HTTP `GET /installation/repositories`.
    /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)`.
    public enum AppsListReposAccessibleToInstallation {
        public static let id: Swift.String = "apps/list-repos-accessible-to-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/installation/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/installation/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/installation/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListReposAccessibleToInstallation.Input.Query
            /// - Remark: Generated from `#/paths/installation/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListReposAccessibleToInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListReposAccessibleToInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListReposAccessibleToInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListReposAccessibleToInstallation.Input.Query = .init(),
                headers: Operations.AppsListReposAccessibleToInstallation.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListReposAccessibleToInstallation.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.Repository]
                        /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/content/json/repository_selection`.
                        public var repositorySelection: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositories:
                        ///   - repositorySelection:
                        public init(
                            totalCount: Swift.Int,
                            repositories: [Components.Schemas.Repository],
                            repositorySelection: Swift.String? = nil
                        ) {
                            self.totalCount = totalCount
                            self.repositories = repositories
                            self.repositorySelection = repositorySelection
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositories
                            case repositorySelection = "repository_selection"
                        }
                    }
                    /// - Remark: Generated from `#/paths/installation/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.AppsListReposAccessibleToInstallation.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.AppsListReposAccessibleToInstallation.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListReposAccessibleToInstallation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListReposAccessibleToInstallation.Output.Ok.Headers = .init(),
                    body: Operations.AppsListReposAccessibleToInstallation.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListReposAccessibleToInstallation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListReposAccessibleToInstallation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//installation/repositories/get(apps/list-repos-accessible-to-installation)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Revoke an installation access token
    ///
    /// Revokes the installation token you're using to authenticate as an installation and access this endpoint.
    ///
    /// Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/apps/apps#create-an-installation-access-token-for-an-app)" endpoint.
    ///
    /// - Remark: HTTP `DELETE /installation/token`.
    /// - Remark: Generated from `#/paths//installation/token/delete(apps/revoke-installation-access-token)`.
    public enum AppsRevokeInstallationAccessToken {
        public static let id: Swift.String = "apps/revoke-installation-access-token"
        public struct Input: Sendable, Hashable {
            /// Creates a new `Input`.
            public init() {}
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//installation/token/delete(apps/revoke-installation-access-token)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsRevokeInstallationAccessToken.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//installation/token/delete(apps/revoke-installation-access-token)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsRevokeInstallationAccessToken.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get a subscription plan for an account
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/accounts/{account_id}`.
    /// - Remark: Generated from `#/paths//marketplace_listing/accounts/{account_id}/get(apps/get-subscription-plan-for-account)`.
    public enum AppsGetSubscriptionPlanForAccount {
        public static let id: Swift.String = "apps/get-subscription-plan-for-account"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// account_id parameter
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/path/account_id`.
                public var accountId: Components.Parameters.AccountId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - accountId: account_id parameter
                public init(accountId: Components.Parameters.AccountId) {
                    self.accountId = accountId
                }
            }
            public var path: Operations.AppsGetSubscriptionPlanForAccount.Input.Path
            /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetSubscriptionPlanForAccount.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetSubscriptionPlanForAccount.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetSubscriptionPlanForAccount.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetSubscriptionPlanForAccount.Input.Path,
                headers: Operations.AppsGetSubscriptionPlanForAccount.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.MarketplacePurchase)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.MarketplacePurchase {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetSubscriptionPlanForAccount.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetSubscriptionPlanForAccount.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/accounts/{account_id}/get(apps/get-subscription-plan-for-account)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetSubscriptionPlanForAccount.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetSubscriptionPlanForAccount.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/accounts/{account_id}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetSubscriptionPlanForAccount.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetSubscriptionPlanForAccount.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// Not Found when the account has not purchased the listing
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/accounts/{account_id}/get(apps/get-subscription-plan-for-account)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.AppsGetSubscriptionPlanForAccount.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.AppsGetSubscriptionPlanForAccount.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/accounts/{account_id}/get(apps/get-subscription-plan-for-account)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List plans
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/plans`.
    /// - Remark: Generated from `#/paths//marketplace_listing/plans/get(apps/list-plans)`.
    public enum AppsListPlans {
        public static let id: Swift.String = "apps/list-plans"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListPlans.Input.Query
            /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListPlans.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListPlans.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListPlans.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListPlans.Input.Query = .init(),
                headers: Operations.AppsListPlans.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListPlans.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/plans/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MarketplaceListingPlan])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MarketplaceListingPlan] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListPlans.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListPlans.Output.Ok.Headers = .init(),
                    body: Operations.AppsListPlans.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/get(apps/list-plans)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListPlans.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListPlans.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/get(apps/list-plans)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/get(apps/list-plans)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List accounts for a plan
    ///
    /// Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/plans/{plan_id}/accounts`.
    /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)`.
    public enum AppsListAccountsForPlan {
        public static let id: Swift.String = "apps/list-accounts-for-plan"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the plan.
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/path/plan_id`.
                public var planId: Components.Parameters.PlanId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - planId: The unique identifier of the plan.
                public init(planId: Components.Parameters.PlanId) {
                    self.planId = planId
                }
            }
            public var path: Operations.AppsListAccountsForPlan.Input.Path
            /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/sort`.
                @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/query/sort`.
                public var sort: Components.Parameters.Sort?
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// To return the oldest accounts first, set to `asc`. Ignored without the `sort` parameter.
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/query/direction`.
                public var direction: Operations.AppsListAccountsForPlan.Input.Query.DirectionPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort: The property to sort the results by.
                ///   - direction: To return the oldest accounts first, set to `asc`. Ignored without the `sort` parameter.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Components.Parameters.Sort? = nil,
                    direction: Operations.AppsListAccountsForPlan.Input.Query.DirectionPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListAccountsForPlan.Input.Query
            /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListAccountsForPlan.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListAccountsForPlan.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListAccountsForPlan.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.AppsListAccountsForPlan.Input.Path,
                query: Operations.AppsListAccountsForPlan.Input.Query = .init(),
                headers: Operations.AppsListAccountsForPlan.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListAccountsForPlan.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/plans/{plan_id}/accounts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MarketplacePurchase])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MarketplacePurchase] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListAccountsForPlan.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListAccountsForPlan.Output.Ok.Headers = .init(),
                    body: Operations.AppsListAccountsForPlan.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListAccountsForPlan.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListAccountsForPlan.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a subscription plan for an account (stubbed)
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/accounts/{account_id}`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)`.
    public enum AppsGetSubscriptionPlanForAccountStubbed {
        public static let id: Swift.String = "apps/get-subscription-plan-for-account-stubbed"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/accounts/{account_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// account_id parameter
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/accounts/{account_id}/GET/path/account_id`.
                public var accountId: Components.Parameters.AccountId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - accountId: account_id parameter
                public init(accountId: Components.Parameters.AccountId) {
                    self.accountId = accountId
                }
            }
            public var path: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input.Path
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/accounts/{account_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetSubscriptionPlanForAccountStubbed.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetSubscriptionPlanForAccountStubbed.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input.Path,
                headers: Operations.AppsGetSubscriptionPlanForAccountStubbed.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/accounts/{account_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/accounts/{account_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.MarketplacePurchase)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.MarketplacePurchase {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetSubscriptionPlanForAccountStubbed.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetSubscriptionPlanForAccountStubbed.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetSubscriptionPlanForAccountStubbed.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetSubscriptionPlanForAccountStubbed.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found when the account has not purchased the listing
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.AppsGetSubscriptionPlanForAccountStubbed.Output.NotFound)
            /// Not Found when the account has not purchased the listing
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.AppsGetSubscriptionPlanForAccountStubbed.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/accounts/{account_id}/get(apps/get-subscription-plan-for-account-stubbed)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List plans (stubbed)
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/plans`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/get(apps/list-plans-stubbed)`.
    public enum AppsListPlansStubbed {
        public static let id: Swift.String = "apps/list-plans-stubbed"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListPlansStubbed.Input.Query
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListPlansStubbed.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListPlansStubbed.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListPlansStubbed.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListPlansStubbed.Input.Query = .init(),
                headers: Operations.AppsListPlansStubbed.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListPlansStubbed.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MarketplaceListingPlan])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MarketplaceListingPlan] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListPlansStubbed.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListPlansStubbed.Output.Ok.Headers = .init(),
                    body: Operations.AppsListPlansStubbed.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/get(apps/list-plans-stubbed)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListPlansStubbed.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListPlansStubbed.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/get(apps/list-plans-stubbed)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List accounts for a plan (stubbed)
    ///
    /// Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    ///
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth apps must use [basic authentication](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) with their client ID and client secret to access this endpoint.
    ///
    /// - Remark: HTTP `GET /marketplace_listing/stubbed/plans/{plan_id}/accounts`.
    /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan-stubbed)`.
    public enum AppsListAccountsForPlanStubbed {
        public static let id: Swift.String = "apps/list-accounts-for-plan-stubbed"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the plan.
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/path/plan_id`.
                public var planId: Components.Parameters.PlanId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - planId: The unique identifier of the plan.
                public init(planId: Components.Parameters.PlanId) {
                    self.planId = planId
                }
            }
            public var path: Operations.AppsListAccountsForPlanStubbed.Input.Path
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/sort`.
                @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/query/sort`.
                public var sort: Components.Parameters.Sort?
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// To return the oldest accounts first, set to `asc`. Ignored without the `sort` parameter.
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/query/direction`.
                public var direction: Operations.AppsListAccountsForPlanStubbed.Input.Query.DirectionPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort: The property to sort the results by.
                ///   - direction: To return the oldest accounts first, set to `asc`. Ignored without the `sort` parameter.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Components.Parameters.Sort? = nil,
                    direction: Operations.AppsListAccountsForPlanStubbed.Input.Query.DirectionPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListAccountsForPlanStubbed.Input.Query
            /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListAccountsForPlanStubbed.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListAccountsForPlanStubbed.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListAccountsForPlanStubbed.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.AppsListAccountsForPlanStubbed.Input.Path,
                query: Operations.AppsListAccountsForPlanStubbed.Input.Query = .init(),
                headers: Operations.AppsListAccountsForPlanStubbed.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListAccountsForPlanStubbed.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/marketplace_listing/stubbed/plans/{plan_id}/accounts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MarketplacePurchase])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MarketplacePurchase] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListAccountsForPlanStubbed.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListAccountsForPlanStubbed.Output.Ok.Headers = .init(),
                    body: Operations.AppsListAccountsForPlanStubbed.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan-stubbed)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListAccountsForPlanStubbed.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListAccountsForPlanStubbed.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//marketplace_listing/stubbed/plans/{plan_id}/accounts/get(apps/list-accounts-for-plan-stubbed)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the organization's installation information.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installation`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installation/get(apps/get-org-installation)`.
    public enum AppsGetOrgInstallation {
        public static let id: Swift.String = "apps/get-org-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/installation/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/installation/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.AppsGetOrgInstallation.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/installation/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetOrgInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetOrgInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetOrgInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetOrgInstallation.Input.Path,
                headers: Operations.AppsGetOrgInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/installation/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/installation/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Installation)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Installation {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetOrgInstallation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetOrgInstallation.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/installation/get(apps/get-org-installation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetOrgInstallation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetOrgInstallation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/installation`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/installation/get(apps/get-repo-installation)`.
    public enum AppsGetRepoInstallation {
        public static let id: Swift.String = "apps/get-repo-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/installation/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/installation/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/installation/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.AppsGetRepoInstallation.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/installation/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetRepoInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetRepoInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetRepoInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetRepoInstallation.Input.Path,
                headers: Operations.AppsGetRepoInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/installation/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/installation/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Installation)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Installation {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetRepoInstallation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetRepoInstallation.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/installation/get(apps/get-repo-installation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetRepoInstallation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetRepoInstallation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/installation/get(apps/get-repo-installation)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/installation/get(apps/get-repo-installation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List app installations accessible to the user access token
    ///
    /// Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// You can find the permissions for the installation under the `permissions` key.
    ///
    /// - Remark: HTTP `GET /user/installations`.
    /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)`.
    public enum AppsListInstallationsForAuthenticatedUser {
        public static let id: Swift.String = "apps/list-installations-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/installations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/installations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/installations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListInstallationsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/installations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallationsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallationsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListInstallationsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListInstallationsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.AppsListInstallationsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/content/json/installations`.
                        public var installations: [Components.Schemas.Installation]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - installations:
                        public init(
                            totalCount: Swift.Int,
                            installations: [Components.Schemas.Installation]
                        ) {
                            self.totalCount = totalCount
                            self.installations = installations
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case installations
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/installations/GET/responses/200/content/application\/json`.
                    case json(Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// You can find the permissions for the installation under the `permissions` key.
            ///
            /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListInstallationsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/installations/get(apps/list-installations-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories accessible to the user access token
    ///
    /// List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// The access the user has to each repository is included in the hash under the `permissions` key.
    ///
    /// - Remark: HTTP `GET /user/installations/{installation_id}/repositories`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)`.
    public enum AppsListInstallationReposForAuthenticatedUser {
        public static let id: Swift.String = "apps/list-installation-repos-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                public init(installationId: Components.Parameters.InstallationId) {
                    self.installationId = installationId
                }
            }
            public var path: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallationReposForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListInstallationReposForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Path,
                query: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.AppsListInstallationReposForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/content/json/repository_selection`.
                        public var repositorySelection: Swift.String?
                        /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.Repository]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositorySelection:
                        ///   - repositories:
                        public init(
                            totalCount: Swift.Int,
                            repositorySelection: Swift.String? = nil,
                            repositories: [Components.Schemas.Repository]
                        ) {
                            self.totalCount = totalCount
                            self.repositorySelection = repositorySelection
                            self.repositories = repositories
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositorySelection = "repository_selection"
                            case repositories
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// The access the user has to each repository is included in the hash under the `permissions` key.
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListInstallationReposForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/get(apps/list-installation-repos-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add a repository to an app installation
    ///
    /// Add a single repository to an installation. The authenticated user must have admin access to the repository.    
    ///
    /// This endpoint only works for PATs (classic) with the `repo` scope.
    ///
    /// - Remark: HTTP `PUT /user/installations/{installation_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)`.
    public enum AppsAddRepoToInstallationForAuthenticatedUser {
        public static let id: Swift.String = "apps/add-repo-to-installation-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/PUT/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// The unique identifier of the repository.
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/PUT/path/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                ///   - repositoryId: The unique identifier of the repository.
                public init(
                    installationId: Components.Parameters.InstallationId,
                    repositoryId: Components.Parameters.RepositoryId
                ) {
                    self.installationId = installationId
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsAddRepoToInstallationForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsAddRepoToInstallationForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input.Path,
                headers: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsAddRepoToInstallationForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsAddRepoToInstallationForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/put(apps/add-repo-to-installation-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a repository from an app installation
    ///
    /// Remove a single repository from an installation. The authenticated user must have admin access to the repository. The installation must have the `repository_selection` of `selected`. 
    ///
    /// This endpoint only works for PATs (classic) with the `repo` scope.
    ///
    /// - Remark: HTTP `DELETE /user/installations/{installation_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)`.
    public enum AppsRemoveRepoFromInstallationForAuthenticatedUser {
        public static let id: Swift.String = "apps/remove-repo-from-installation-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the installation.
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/DELETE/path/installation_id`.
                public var installationId: Components.Parameters.InstallationId
                /// The unique identifier of the repository.
                ///
                /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/DELETE/path/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - installationId: The unique identifier of the installation.
                ///   - repositoryId: The unique identifier of the repository.
                public init(
                    installationId: Components.Parameters.InstallationId,
                    repositoryId: Components.Parameters.RepositoryId
                ) {
                    self.installationId = installationId
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/installations/{installation_id}/repositories/{repository_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input.Path,
                headers: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Returned when the application is installed on `all` repositories in the organization, or if this request would remove the last repository that the application has access to in the organization.
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Output.UnprocessableContent)
            /// Returned when the application is installed on `all` repositories in the organization, or if this request would remove the last repository that the application has access to in the organization.
            ///
            /// - Remark: Generated from `#/paths//user/installations/{installation_id}/repositories/{repository_id}/delete(apps/remove-repo-from-installation-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.AppsRemoveRepoFromInstallationForAuthenticatedUser.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List subscriptions for the authenticated user
    ///
    /// Lists the active subscriptions for the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/marketplace_purchases`.
    /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)`.
    public enum AppsListSubscriptionsForAuthenticatedUser {
        public static let id: Swift.String = "apps/list-subscriptions-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListSubscriptionsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListSubscriptionsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListSubscriptionsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListSubscriptionsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListSubscriptionsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.AppsListSubscriptionsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListSubscriptionsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/marketplace_purchases/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.UserMarketplacePurchase])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.UserMarketplacePurchase] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListSubscriptionsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListSubscriptionsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.AppsListSubscriptionsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListSubscriptionsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListSubscriptionsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/get(apps/list-subscriptions-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List subscriptions for the authenticated user (stubbed)
    ///
    /// Lists the active subscriptions for the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/marketplace_purchases/stubbed`.
    /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)`.
    public enum AppsListSubscriptionsForAuthenticatedUserStubbed {
        public static let id: Swift.String = "apps/list-subscriptions-for-authenticated-user-stubbed"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input.Query
            /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input.Query = .init(),
                headers: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/marketplace_purchases/stubbed/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.UserMarketplacePurchase])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.UserMarketplacePurchase] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output.Ok.Headers = .init(),
                    body: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsListSubscriptionsForAuthenticatedUserStubbed.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/marketplace_purchases/stubbed/get(apps/list-subscriptions-for-authenticated-user-stubbed)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a user installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the user’s installation information.
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/installation`.
    /// - Remark: Generated from `#/paths//users/{username}/installation/get(apps/get-user-installation)`.
    public enum AppsGetUserInstallation {
        public static let id: Swift.String = "apps/get-user-installation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/installation/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/installation/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.AppsGetUserInstallation.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/installation/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetUserInstallation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.AppsGetUserInstallation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.AppsGetUserInstallation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.AppsGetUserInstallation.Input.Path,
                headers: Operations.AppsGetUserInstallation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/installation/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/installation/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Installation)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Installation {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.AppsGetUserInstallation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.AppsGetUserInstallation.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/installation/get(apps/get-user-installation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.AppsGetUserInstallation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.AppsGetUserInstallation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
