// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get GitHub Actions cache usage for an organization
    ///
    /// Gets the total GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage/get(actions/get-actions-cache-usage-for-org)`.
    func actionsGetActionsCacheUsageForOrg(_ input: Operations.ActionsGetActionsCacheUsageForOrg.Input) async throws -> Operations.ActionsGetActionsCacheUsageForOrg.Output
    /// List repositories with GitHub Actions cache usage for an organization
    ///
    /// Lists repositories and their GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage-by-repository`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage-by-repository/get(actions/get-actions-cache-usage-by-repo-for-org)`.
    func actionsGetActionsCacheUsageByRepoForOrg(_ input: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input) async throws -> Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output
    /// List GitHub-hosted runners for an organization
    ///
    /// Lists all GitHub-hosted runners configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runner:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/get(actions/list-hosted-runners-for-org)`.
    func actionsListHostedRunnersForOrg(_ input: Operations.ActionsListHostedRunnersForOrg.Input) async throws -> Operations.ActionsListHostedRunnersForOrg.Output
    /// Create a GitHub-hosted runner for an organization
    ///
    /// Creates a GitHub-hosted runner for an organization.
    /// OAuth tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/post(actions/create-hosted-runner-for-org)`.
    func actionsCreateHostedRunnerForOrg(_ input: Operations.ActionsCreateHostedRunnerForOrg.Input) async throws -> Operations.ActionsCreateHostedRunnerForOrg.Output
    /// Get GitHub-owned images for GitHub-hosted runners in an organization
    ///
    /// Get the list of GitHub-owned images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/github-owned`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/github-owned/get(actions/get-hosted-runners-github-owned-images-for-org)`.
    func actionsGetHostedRunnersGithubOwnedImagesForOrg(_ input: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output
    /// Get partner images for GitHub-hosted runners in an organization
    ///
    /// Get the list of partner images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/partner`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/partner/get(actions/get-hosted-runners-partner-images-for-org)`.
    func actionsGetHostedRunnersPartnerImagesForOrg(_ input: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output
    /// Get limits on GitHub-hosted runners for an organization
    ///
    /// Get the GitHub-hosted runners limits for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/limits/get(actions/get-hosted-runners-limits-for-org)`.
    func actionsGetHostedRunnersLimitsForOrg(_ input: Operations.ActionsGetHostedRunnersLimitsForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersLimitsForOrg.Output
    /// Get GitHub-hosted runners machine specs for an organization
    ///
    /// Get the list of machine specs available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/machine-sizes`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/machine-sizes/get(actions/get-hosted-runners-machine-specs-for-org)`.
    func actionsGetHostedRunnersMachineSpecsForOrg(_ input: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output
    /// Get platforms for GitHub-hosted runners in an organization
    ///
    /// Get the list of platforms available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/platforms`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/platforms/get(actions/get-hosted-runners-platforms-for-org)`.
    func actionsGetHostedRunnersPlatformsForOrg(_ input: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersPlatformsForOrg.Output
    /// Get a GitHub-hosted runner for an organization
    ///
    /// Gets a GitHub-hosted runner configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/get(actions/get-hosted-runner-for-org)`.
    func actionsGetHostedRunnerForOrg(_ input: Operations.ActionsGetHostedRunnerForOrg.Input) async throws -> Operations.ActionsGetHostedRunnerForOrg.Output
    /// Update a GitHub-hosted runner for an organization
    ///
    /// Updates a GitHub-hosted runner for an organization.
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/patch(actions/update-hosted-runner-for-org)`.
    func actionsUpdateHostedRunnerForOrg(_ input: Operations.ActionsUpdateHostedRunnerForOrg.Input) async throws -> Operations.ActionsUpdateHostedRunnerForOrg.Output
    /// Delete a GitHub-hosted runner for an organization
    ///
    /// Deletes a GitHub-hosted runner for an organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/delete(actions/delete-hosted-runner-for-org)`.
    func actionsDeleteHostedRunnerForOrg(_ input: Operations.ActionsDeleteHostedRunnerForOrg.Input) async throws -> Operations.ActionsDeleteHostedRunnerForOrg.Output
    /// Get GitHub Actions permissions for an organization
    ///
    /// Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/get(actions/get-github-actions-permissions-organization)`.
    func actionsGetGithubActionsPermissionsOrganization(_ input: Operations.ActionsGetGithubActionsPermissionsOrganization.Input) async throws -> Operations.ActionsGetGithubActionsPermissionsOrganization.Output
    /// Set GitHub Actions permissions for an organization
    ///
    /// Sets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/put(actions/set-github-actions-permissions-organization)`.
    func actionsSetGithubActionsPermissionsOrganization(_ input: Operations.ActionsSetGithubActionsPermissionsOrganization.Input) async throws -> Operations.ActionsSetGithubActionsPermissionsOrganization.Output
    /// Get artifact and log retention settings for an organization
    ///
    /// Gets artifact and log retention settings for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-organization)`.
    func actionsGetArtifactAndLogRetentionSettingsOrganization(_ input: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input) async throws -> Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Output
    /// Set artifact and log retention settings for an organization
    ///
    /// Sets artifact and log retention settings for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)`.
    func actionsSetArtifactAndLogRetentionSettingsOrganization(_ input: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input) async throws -> Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Output
    /// Get fork PR contributor approval permissions for an organization
    ///
    /// Gets the fork PR contributor approval policy for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-organization)`.
    func actionsGetForkPrContributorApprovalPermissionsOrganization(_ input: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input) async throws -> Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Output
    /// Set fork PR contributor approval permissions for an organization
    ///
    /// Sets the fork PR contributor approval policy for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)`.
    func actionsSetForkPrContributorApprovalPermissionsOrganization(_ input: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input) async throws -> Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Output
    /// Get private repo fork PR workflow settings for an organization
    ///
    /// Gets the settings for whether workflows from fork pull requests can run on private repositories in an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-organization)`.
    func actionsGetPrivateRepoForkPrWorkflowsSettingsOrganization(_ input: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input) async throws -> Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Output
    /// Set private repo fork PR workflow settings for an organization
    ///
    /// Sets the settings for whether workflows from fork pull requests can run on private repositories in an organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)`.
    func actionsSetPrivateRepoForkPrWorkflowsSettingsOrganization(_ input: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input) async throws -> Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output
    /// List selected repositories enabled for GitHub Actions in an organization
    ///
    /// Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/get(actions/list-selected-repositories-enabled-github-actions-organization)`.
    func actionsListSelectedRepositoriesEnabledGithubActionsOrganization(_ input: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input) async throws -> Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output
    /// Set selected repositories enabled for GitHub Actions in an organization
    ///
    /// Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/put(actions/set-selected-repositories-enabled-github-actions-organization)`.
    func actionsSetSelectedRepositoriesEnabledGithubActionsOrganization(_ input: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input) async throws -> Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Output
    /// Enable a selected repository for GitHub Actions in an organization
    ///
    /// Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/put(actions/enable-selected-repository-github-actions-organization)`.
    func actionsEnableSelectedRepositoryGithubActionsOrganization(_ input: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Input) async throws -> Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Output
    /// Disable a selected repository for GitHub Actions in an organization
    ///
    /// Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/delete(actions/disable-selected-repository-github-actions-organization)`.
    func actionsDisableSelectedRepositoryGithubActionsOrganization(_ input: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Input) async throws -> Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Output
    /// Get allowed actions and reusable workflows for an organization
    ///
    /// Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/get(actions/get-allowed-actions-organization)`.
    func actionsGetAllowedActionsOrganization(_ input: Operations.ActionsGetAllowedActionsOrganization.Input) async throws -> Operations.ActionsGetAllowedActionsOrganization.Output
    /// Set allowed actions and reusable workflows for an organization
    ///
    /// Sets the actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/put(actions/set-allowed-actions-organization)`.
    func actionsSetAllowedActionsOrganization(_ input: Operations.ActionsSetAllowedActionsOrganization.Input) async throws -> Operations.ActionsSetAllowedActionsOrganization.Output
    /// Get self-hosted runners settings for an organization
    ///
    /// Gets the settings for self-hosted runners for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/self-hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/get(actions/get-self-hosted-runners-permissions-organization)`.
    func actionsGetSelfHostedRunnersPermissionsOrganization(_ input: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input) async throws -> Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Output
    /// Set self-hosted runners settings for an organization
    ///
    /// Sets the settings for self-hosted runners for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)`.
    func actionsSetSelfHostedRunnersPermissionsOrganization(_ input: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input) async throws -> Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Output
    /// List repositories allowed to use self-hosted runners in an organization
    ///
    /// Lists repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/self-hosted-runners/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/get(actions/list-selected-repositories-self-hosted-runners-organization)`.
    func actionsListSelectedRepositoriesSelfHostedRunnersOrganization(_ input: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input) async throws -> Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output
    /// Set repositories allowed to use self-hosted runners in an organization
    ///
    /// Sets repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)`.
    func actionsSetSelectedRepositoriesSelfHostedRunnersOrganization(_ input: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input) async throws -> Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Output
    /// Add a repository to the list of repositories allowed to use self-hosted runners in an organization
    ///
    /// Adds a repository to the list of repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)`.
    func actionsEnableSelectedRepositorySelfHostedRunnersOrganization(_ input: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input) async throws -> Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Output
    /// Remove a repository from the list of repositories allowed to use self-hosted runners in an organization
    ///
    /// Removes a repository from the list of repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)`.
    func actionsDisableSelectedRepositorySelfHostedRunnersOrganization(_ input: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input) async throws -> Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Output
    /// Get default workflow permissions for an organization
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
    /// as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-organization)`.
    func actionsGetGithubActionsDefaultWorkflowPermissionsOrganization(_ input: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input) async throws -> Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output
    /// Set default workflow permissions for an organization
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
    /// can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-organization)`.
    func actionsSetGithubActionsDefaultWorkflowPermissionsOrganization(_ input: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input) async throws -> Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Output
    /// List self-hosted runner groups for an organization
    ///
    /// Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/get(actions/list-self-hosted-runner-groups-for-org)`.
    func actionsListSelfHostedRunnerGroupsForOrg(_ input: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input) async throws -> Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output
    /// Create a self-hosted runner group for an organization
    ///
    /// Creates a new self-hosted runner group for an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/post(actions/create-self-hosted-runner-group-for-org)`.
    func actionsCreateSelfHostedRunnerGroupForOrg(_ input: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Input) async throws -> Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Output
    /// Get a self-hosted runner group for an organization
    ///
    /// Gets a specific self-hosted runner group for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/get(actions/get-self-hosted-runner-group-for-org)`.
    func actionsGetSelfHostedRunnerGroupForOrg(_ input: Operations.ActionsGetSelfHostedRunnerGroupForOrg.Input) async throws -> Operations.ActionsGetSelfHostedRunnerGroupForOrg.Output
    /// Update a self-hosted runner group for an organization
    ///
    /// Updates the `name` and `visibility` of a self-hosted runner group in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/patch(actions/update-self-hosted-runner-group-for-org)`.
    func actionsUpdateSelfHostedRunnerGroupForOrg(_ input: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Input) async throws -> Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Output
    /// Delete a self-hosted runner group from an organization
    ///
    /// Deletes a self-hosted runner group for an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/delete(actions/delete-self-hosted-runner-group-from-org)`.
    func actionsDeleteSelfHostedRunnerGroupFromOrg(_ input: Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Input) async throws -> Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Output
    /// List GitHub-hosted runners in a group for an organization
    ///
    /// Lists the GitHub-hosted runners in an organization group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners/get(actions/list-github-hosted-runners-in-group-for-org)`.
    func actionsListGithubHostedRunnersInGroupForOrg(_ input: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Input) async throws -> Operations.ActionsListGithubHostedRunnersInGroupForOrg.Output
    /// List repository access to a self-hosted runner group in an organization
    ///
    /// Lists the repositories with access to a self-hosted runner group configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/get(actions/list-repo-access-to-self-hosted-runner-group-in-org)`.
    func actionsListRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Output
    /// Set repository access for a self-hosted runner group in an organization
    ///
    /// Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/put(actions/set-repo-access-to-self-hosted-runner-group-in-org)`.
    func actionsSetRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Output
    /// Add repository access to a self-hosted runner group in an organization
    ///
    /// Adds a repository to the list of repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}/put(actions/add-repo-access-to-self-hosted-runner-group-in-org)`.
    func actionsAddRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Output
    /// Remove repository access to a self-hosted runner group in an organization
    ///
    /// Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}/delete(actions/remove-repo-access-to-self-hosted-runner-group-in-org)`.
    func actionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Output
    /// List self-hosted runners in a group for an organization
    ///
    /// Lists self-hosted runners that are in a specific organization group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/get(actions/list-self-hosted-runners-in-group-for-org)`.
    func actionsListSelfHostedRunnersInGroupForOrg(_ input: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Input) async throws -> Operations.ActionsListSelfHostedRunnersInGroupForOrg.Output
    /// Set self-hosted runners in a group for an organization
    ///
    /// Replaces the list of self-hosted runners that are part of an organization runner group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/put(actions/set-self-hosted-runners-in-group-for-org)`.
    func actionsSetSelfHostedRunnersInGroupForOrg(_ input: Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Input) async throws -> Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Output
    /// Add a self-hosted runner to a group for an organization
    ///
    /// Adds a self-hosted runner to a runner group configured in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}/put(actions/add-self-hosted-runner-to-group-for-org)`.
    func actionsAddSelfHostedRunnerToGroupForOrg(_ input: Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Input) async throws -> Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Output
    /// Remove a self-hosted runner from a group for an organization
    ///
    /// Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}/delete(actions/remove-self-hosted-runner-from-group-for-org)`.
    func actionsRemoveSelfHostedRunnerFromGroupForOrg(_ input: Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Input) async throws -> Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Output
    /// List self-hosted runners for an organization
    ///
    /// Lists all self-hosted runners configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/get(actions/list-self-hosted-runners-for-org)`.
    func actionsListSelfHostedRunnersForOrg(_ input: Operations.ActionsListSelfHostedRunnersForOrg.Input) async throws -> Operations.ActionsListSelfHostedRunnersForOrg.Output
    /// List runner applications for an organization
    ///
    /// Lists binaries for the runner application that you can download and run.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.  If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/downloads`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/downloads/get(actions/list-runner-applications-for-org)`.
    func actionsListRunnerApplicationsForOrg(_ input: Operations.ActionsListRunnerApplicationsForOrg.Input) async throws -> Operations.ActionsListRunnerApplicationsForOrg.Output
    /// Create configuration for a just-in-time runner for an organization
    ///
    /// Generates a configuration that can be passed to the runner application at startup.
    ///
    /// The authenticated user must have admin access to the organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/generate-jitconfig`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/generate-jitconfig/post(actions/generate-runner-jitconfig-for-org)`.
    func actionsGenerateRunnerJitconfigForOrg(_ input: Operations.ActionsGenerateRunnerJitconfigForOrg.Input) async throws -> Operations.ActionsGenerateRunnerJitconfigForOrg.Output
    /// Create a registration token for an organization
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
    ///
    /// ```
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/registration-token`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/registration-token/post(actions/create-registration-token-for-org)`.
    func actionsCreateRegistrationTokenForOrg(_ input: Operations.ActionsCreateRegistrationTokenForOrg.Input) async throws -> Operations.ActionsCreateRegistrationTokenForOrg.Output
    /// Create a remove token for an organization
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
    ///
    /// ```
    /// ./config.sh remove --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/remove-token`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/remove-token/post(actions/create-remove-token-for-org)`.
    func actionsCreateRemoveTokenForOrg(_ input: Operations.ActionsCreateRemoveTokenForOrg.Input) async throws -> Operations.ActionsCreateRemoveTokenForOrg.Output
    /// Get a self-hosted runner for an organization
    ///
    /// Gets a specific self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/get(actions/get-self-hosted-runner-for-org)`.
    func actionsGetSelfHostedRunnerForOrg(_ input: Operations.ActionsGetSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsGetSelfHostedRunnerForOrg.Output
    /// Delete a self-hosted runner from an organization
    ///
    /// Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/delete(actions/delete-self-hosted-runner-from-org)`.
    func actionsDeleteSelfHostedRunnerFromOrg(_ input: Operations.ActionsDeleteSelfHostedRunnerFromOrg.Input) async throws -> Operations.ActionsDeleteSelfHostedRunnerFromOrg.Output
    /// List labels for a self-hosted runner for an organization
    ///
    /// Lists all labels for a self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/get(actions/list-labels-for-self-hosted-runner-for-org)`.
    func actionsListLabelsForSelfHostedRunnerForOrg(_ input: Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Output
    /// Add custom labels to a self-hosted runner for an organization
    ///
    /// Adds custom labels to a self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/post(actions/add-custom-labels-to-self-hosted-runner-for-org)`.
    func actionsAddCustomLabelsToSelfHostedRunnerForOrg(_ input: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Output
    /// Set custom labels for a self-hosted runner for an organization
    ///
    /// Remove all previous custom labels and set the new custom labels for a specific
    /// self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/put(actions/set-custom-labels-for-self-hosted-runner-for-org)`.
    func actionsSetCustomLabelsForSelfHostedRunnerForOrg(_ input: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Output
    /// Remove all custom labels from a self-hosted runner for an organization
    ///
    /// Remove all custom labels from a self-hosted runner configured in an
    /// organization. Returns the remaining read-only labels from the runner.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/delete(actions/remove-all-custom-labels-from-self-hosted-runner-for-org)`.
    func actionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg(_ input: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Output
    /// Remove a custom label from a self-hosted runner for an organization
    ///
    /// Remove a custom label from a self-hosted runner configured
    /// in an organization. Returns the remaining labels from the runner.
    ///
    /// This endpoint returns a `404 Not Found` status if the custom label is not
    /// present on the runner.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}/labels/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/{name}/delete(actions/remove-custom-label-from-self-hosted-runner-for-org)`.
    func actionsRemoveCustomLabelFromSelfHostedRunnerForOrg(_ input: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Output
    /// List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their
    /// encrypted values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/get(actions/list-org-secrets)`.
    func actionsListOrgSecrets(_ input: Operations.ActionsListOrgSecrets.Input) async throws -> Operations.ActionsListOrgSecrets.Output
    /// Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/public-key/get(actions/get-org-public-key)`.
    func actionsGetOrgPublicKey(_ input: Operations.ActionsGetOrgPublicKey.Input) async throws -> Operations.ActionsGetOrgPublicKey.Output
    /// Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read secrets
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/get(actions/get-org-secret)`.
    func actionsGetOrgSecret(_ input: Operations.ActionsGetOrgSecret.Input) async throws -> Operations.ActionsGetOrgSecret.Output
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/put(actions/create-or-update-org-secret)`.
    func actionsCreateOrUpdateOrgSecret(_ input: Operations.ActionsCreateOrUpdateOrgSecret.Input) async throws -> Operations.ActionsCreateOrUpdateOrgSecret.Output
    /// Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/delete(actions/delete-org-secret)`.
    func actionsDeleteOrgSecret(_ input: Operations.ActionsDeleteOrgSecret.Input) async throws -> Operations.ActionsDeleteOrgSecret.Output
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/get(actions/list-selected-repos-for-org-secret)`.
    func actionsListSelectedReposForOrgSecret(_ input: Operations.ActionsListSelectedReposForOrgSecret.Input) async throws -> Operations.ActionsListSelectedReposForOrgSecret.Output
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/put(actions/set-selected-repos-for-org-secret)`.
    func actionsSetSelectedReposForOrgSecret(_ input: Operations.ActionsSetSelectedReposForOrgSecret.Input) async throws -> Operations.ActionsSetSelectedReposForOrgSecret.Output
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for
    /// repository access is set to `selected`. For more information about setting the visibility, see [Create or
    /// update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}/put(actions/add-selected-repo-to-org-secret)`.
    func actionsAddSelectedRepoToOrgSecret(_ input: Operations.ActionsAddSelectedRepoToOrgSecret.Input) async throws -> Operations.ActionsAddSelectedRepoToOrgSecret.Output
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}/delete(actions/remove-selected-repo-from-org-secret)`.
    func actionsRemoveSelectedRepoFromOrgSecret(_ input: Operations.ActionsRemoveSelectedRepoFromOrgSecret.Input) async throws -> Operations.ActionsRemoveSelectedRepoFromOrgSecret.Output
    /// List organization variables
    ///
    /// Lists all organization variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/get(actions/list-org-variables)`.
    func actionsListOrgVariables(_ input: Operations.ActionsListOrgVariables.Input) async throws -> Operations.ActionsListOrgVariables.Output
    /// Create an organization variable
    ///
    /// Creates an organization variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/variables`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/post(actions/create-org-variable)`.
    func actionsCreateOrgVariable(_ input: Operations.ActionsCreateOrgVariable.Input) async throws -> Operations.ActionsCreateOrgVariable.Output
    /// Get an organization variable
    ///
    /// Gets a specific variable in an organization.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/get(actions/get-org-variable)`.
    func actionsGetOrgVariable(_ input: Operations.ActionsGetOrgVariable.Input) async throws -> Operations.ActionsGetOrgVariable.Output
    /// Update an organization variable
    ///
    /// Updates an organization variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/patch(actions/update-org-variable)`.
    func actionsUpdateOrgVariable(_ input: Operations.ActionsUpdateOrgVariable.Input) async throws -> Operations.ActionsUpdateOrgVariable.Output
    /// Delete an organization variable
    ///
    /// Deletes an organization variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/delete(actions/delete-org-variable)`.
    func actionsDeleteOrgVariable(_ input: Operations.ActionsDeleteOrgVariable.Input) async throws -> Operations.ActionsDeleteOrgVariable.Output
    /// List selected repositories for an organization variable
    ///
    /// Lists all repositories that can access an organization variable
    /// that is available to selected repositories.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables/{name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/get(actions/list-selected-repos-for-org-variable)`.
    func actionsListSelectedReposForOrgVariable(_ input: Operations.ActionsListSelectedReposForOrgVariable.Input) async throws -> Operations.ActionsListSelectedReposForOrgVariable.Output
    /// Set selected repositories for an organization variable
    ///
    /// Replaces all repositories for an organization variable that is available
    /// to selected repositories. Organization variables that are available to selected
    /// repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/variables/{name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/put(actions/set-selected-repos-for-org-variable)`.
    func actionsSetSelectedReposForOrgVariable(_ input: Operations.ActionsSetSelectedReposForOrgVariable.Input) async throws -> Operations.ActionsSetSelectedReposForOrgVariable.Output
    /// Add selected repository to an organization variable
    ///
    /// Adds a repository to an organization variable that is available to selected repositories.
    /// Organization variables that are available to selected repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/variables/{name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/{repository_id}/put(actions/add-selected-repo-to-org-variable)`.
    func actionsAddSelectedRepoToOrgVariable(_ input: Operations.ActionsAddSelectedRepoToOrgVariable.Input) async throws -> Operations.ActionsAddSelectedRepoToOrgVariable.Output
    /// Remove selected repository from an organization variable
    ///
    /// Removes a repository from an organization variable that is
    /// available to selected repositories. Organization variables that are available to
    /// selected repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/variables/{name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/{repository_id}/delete(actions/remove-selected-repo-from-org-variable)`.
    func actionsRemoveSelectedRepoFromOrgVariable(_ input: Operations.ActionsRemoveSelectedRepoFromOrgVariable.Input) async throws -> Operations.ActionsRemoveSelectedRepoFromOrgVariable.Output
    /// List artifacts for a repository
    ///
    /// Lists all artifacts for a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/get(actions/list-artifacts-for-repo)`.
    func actionsListArtifactsForRepo(_ input: Operations.ActionsListArtifactsForRepo.Input) async throws -> Operations.ActionsListArtifactsForRepo.Output
    /// Get an artifact
    ///
    /// Gets a specific artifact for a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/get(actions/get-artifact)`.
    func actionsGetArtifact(_ input: Operations.ActionsGetArtifact.Input) async throws -> Operations.ActionsGetArtifact.Output
    /// Delete an artifact
    ///
    /// Deletes an artifact for a workflow run.
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/artifacts/{artifact_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/delete(actions/delete-artifact)`.
    func actionsDeleteArtifact(_ input: Operations.ActionsDeleteArtifact.Input) async throws -> Operations.ActionsDeleteArtifact.Output
    /// Download an artifact
    ///
    /// Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
    /// the response header to find the URL for the download. The `:archive_format` must be `zip`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}/get(actions/download-artifact)`.
    func actionsDownloadArtifact(_ input: Operations.ActionsDownloadArtifact.Input) async throws -> Operations.ActionsDownloadArtifact.Output
    /// Get GitHub Actions cache usage for a repository
    ///
    /// Gets GitHub Actions cache usage for a repository.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/cache/usage/get(actions/get-actions-cache-usage)`.
    func actionsGetActionsCacheUsage(_ input: Operations.ActionsGetActionsCacheUsage.Input) async throws -> Operations.ActionsGetActionsCacheUsage.Output
    /// List GitHub Actions caches for a repository
    ///
    /// Lists the GitHub Actions caches for a repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/caches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/get(actions/get-actions-cache-list)`.
    func actionsGetActionsCacheList(_ input: Operations.ActionsGetActionsCacheList.Input) async throws -> Operations.ActionsGetActionsCacheList.Output
    /// Delete GitHub Actions caches for a repository (using a cache key)
    ///
    /// Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/caches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/delete(actions/delete-actions-cache-by-key)`.
    func actionsDeleteActionsCacheByKey(_ input: Operations.ActionsDeleteActionsCacheByKey.Input) async throws -> Operations.ActionsDeleteActionsCacheByKey.Output
    /// Delete a GitHub Actions cache for a repository (using a cache ID)
    ///
    /// Deletes a GitHub Actions cache for a repository, using a cache ID.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/caches/{cache_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/{cache_id}/delete(actions/delete-actions-cache-by-id)`.
    func actionsDeleteActionsCacheById(_ input: Operations.ActionsDeleteActionsCacheById.Input) async throws -> Operations.ActionsDeleteActionsCacheById.Output
    /// Get a job for a workflow run
    ///
    /// Gets a specific job in a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/jobs/{job_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/get(actions/get-job-for-workflow-run)`.
    func actionsGetJobForWorkflowRun(_ input: Operations.ActionsGetJobForWorkflowRun.Input) async throws -> Operations.ActionsGetJobForWorkflowRun.Output
    /// Download job logs for a workflow run
    ///
    /// Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
    /// for `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/jobs/{job_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/logs/get(actions/download-job-logs-for-workflow-run)`.
    func actionsDownloadJobLogsForWorkflowRun(_ input: Operations.ActionsDownloadJobLogsForWorkflowRun.Input) async throws -> Operations.ActionsDownloadJobLogsForWorkflowRun.Output
    /// Re-run a job from a workflow run
    ///
    /// Re-run a job and its dependent jobs in a workflow run.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/jobs/{job_id}/rerun`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/rerun/post(actions/re-run-job-for-workflow-run)`.
    func actionsReRunJobForWorkflowRun(_ input: Operations.ActionsReRunJobForWorkflowRun.Input) async throws -> Operations.ActionsReRunJobForWorkflowRun.Output
    /// Get the customization template for an OIDC subject claim for a repository
    ///
    /// Gets the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/oidc/customization/sub/get(actions/get-custom-oidc-sub-claim-for-repo)`.
    func actionsGetCustomOidcSubClaimForRepo(_ input: Operations.ActionsGetCustomOidcSubClaimForRepo.Input) async throws -> Operations.ActionsGetCustomOidcSubClaimForRepo.Output
    /// Set the customization template for an OIDC subject claim for a repository
    ///
    /// Sets the customization template and `opt-in` or `opt-out` flag for an OpenID Connect (OIDC) subject claim for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/oidc/customization/sub/put(actions/set-custom-oidc-sub-claim-for-repo)`.
    func actionsSetCustomOidcSubClaimForRepo(_ input: Operations.ActionsSetCustomOidcSubClaimForRepo.Input) async throws -> Operations.ActionsSetCustomOidcSubClaimForRepo.Output
    /// List repository organization secrets
    ///
    /// Lists all organization secrets shared with a repository without revealing their encrypted
    /// values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/organization-secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/organization-secrets/get(actions/list-repo-organization-secrets)`.
    func actionsListRepoOrganizationSecrets(_ input: Operations.ActionsListRepoOrganizationSecrets.Input) async throws -> Operations.ActionsListRepoOrganizationSecrets.Output
    /// List repository organization variables
    ///
    /// Lists all organization variables shared with a repository.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/organization-variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/organization-variables/get(actions/list-repo-organization-variables)`.
    func actionsListRepoOrganizationVariables(_ input: Operations.ActionsListRepoOrganizationVariables.Input) async throws -> Operations.ActionsListRepoOrganizationVariables.Output
    /// Get GitHub Actions permissions for a repository
    ///
    /// Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions and reusable workflows allowed to run in the repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/get(actions/get-github-actions-permissions-repository)`.
    func actionsGetGithubActionsPermissionsRepository(_ input: Operations.ActionsGetGithubActionsPermissionsRepository.Input) async throws -> Operations.ActionsGetGithubActionsPermissionsRepository.Output
    /// Set GitHub Actions permissions for a repository
    ///
    /// Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions and reusable workflows in the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/put(actions/set-github-actions-permissions-repository)`.
    func actionsSetGithubActionsPermissionsRepository(_ input: Operations.ActionsSetGithubActionsPermissionsRepository.Input) async throws -> Operations.ActionsSetGithubActionsPermissionsRepository.Output
    /// Get the level of access for workflows outside of the repository
    ///
    /// Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
    /// This endpoint only applies to private repositories.
    /// For more information, see "[Allowing access to components in a private repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/access`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/access/get(actions/get-workflow-access-to-repository)`.
    func actionsGetWorkflowAccessToRepository(_ input: Operations.ActionsGetWorkflowAccessToRepository.Input) async throws -> Operations.ActionsGetWorkflowAccessToRepository.Output
    /// Set the level of access for workflows outside of the repository
    ///
    /// Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
    /// This endpoint only applies to private repositories.
    /// For more information, see "[Allowing access to components in a private repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/access`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/access/put(actions/set-workflow-access-to-repository)`.
    func actionsSetWorkflowAccessToRepository(_ input: Operations.ActionsSetWorkflowAccessToRepository.Input) async throws -> Operations.ActionsSetWorkflowAccessToRepository.Output
    /// Get artifact and log retention settings for a repository
    ///
    /// Gets artifact and log retention settings for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-repository)`.
    func actionsGetArtifactAndLogRetentionSettingsRepository(_ input: Operations.ActionsGetArtifactAndLogRetentionSettingsRepository.Input) async throws -> Operations.ActionsGetArtifactAndLogRetentionSettingsRepository.Output
    /// Set artifact and log retention settings for a repository
    ///
    /// Sets artifact and log retention settings for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-repository)`.
    func actionsSetArtifactAndLogRetentionSettingsRepository(_ input: Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Input) async throws -> Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Output
    /// Get fork PR contributor approval permissions for a repository
    ///
    /// Gets the fork PR contributor approval policy for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-repository)`.
    func actionsGetForkPrContributorApprovalPermissionsRepository(_ input: Operations.ActionsGetForkPrContributorApprovalPermissionsRepository.Input) async throws -> Operations.ActionsGetForkPrContributorApprovalPermissionsRepository.Output
    /// Set fork PR contributor approval permissions for a repository
    ///
    /// Sets the fork PR contributor approval policy for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-repository)`.
    func actionsSetForkPrContributorApprovalPermissionsRepository(_ input: Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Input) async throws -> Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Output
    /// Get private repo fork PR workflow settings for a repository
    ///
    /// Gets the settings for whether workflows from fork pull requests can run on a private repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-repository)`.
    func actionsGetPrivateRepoForkPrWorkflowsSettingsRepository(_ input: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsRepository.Input) async throws -> Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsRepository.Output
    /// Set private repo fork PR workflow settings for a repository
    ///
    /// Sets the settings for whether workflows from fork pull requests can run on a private repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-repository)`.
    func actionsSetPrivateRepoForkPrWorkflowsSettingsRepository(_ input: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Input) async throws -> Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Output
    /// Get allowed actions and reusable workflows for a repository
    ///
    /// Gets the settings for selected actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/selected-actions/get(actions/get-allowed-actions-repository)`.
    func actionsGetAllowedActionsRepository(_ input: Operations.ActionsGetAllowedActionsRepository.Input) async throws -> Operations.ActionsGetAllowedActionsRepository.Output
    /// Set allowed actions and reusable workflows for a repository
    ///
    /// Sets the actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/selected-actions/put(actions/set-allowed-actions-repository)`.
    func actionsSetAllowedActionsRepository(_ input: Operations.ActionsSetAllowedActionsRepository.Input) async throws -> Operations.ActionsSetAllowedActionsRepository.Output
    /// Get default workflow permissions for a repository
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
    /// as well as if GitHub Actions can submit approving pull request reviews.
    /// For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-repository)`.
    func actionsGetGithubActionsDefaultWorkflowPermissionsRepository(_ input: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Input) async throws -> Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Output
    /// Set default workflow permissions for a repository
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
    /// can submit approving pull request reviews.
    /// For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-repository)`.
    func actionsSetGithubActionsDefaultWorkflowPermissionsRepository(_ input: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Input) async throws -> Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Output
    /// List self-hosted runners for a repository
    ///
    /// Lists all self-hosted runners configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/get(actions/list-self-hosted-runners-for-repo)`.
    func actionsListSelfHostedRunnersForRepo(_ input: Operations.ActionsListSelfHostedRunnersForRepo.Input) async throws -> Operations.ActionsListSelfHostedRunnersForRepo.Output
    /// List runner applications for a repository
    ///
    /// Lists binaries for the runner application that you can download and run.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/downloads`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/downloads/get(actions/list-runner-applications-for-repo)`.
    func actionsListRunnerApplicationsForRepo(_ input: Operations.ActionsListRunnerApplicationsForRepo.Input) async throws -> Operations.ActionsListRunnerApplicationsForRepo.Output
    /// Create configuration for a just-in-time runner for a repository
    ///
    /// Generates a configuration that can be passed to the runner application at startup.
    ///
    /// The authenticated user must have admin access to the repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/generate-jitconfig`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/generate-jitconfig/post(actions/generate-runner-jitconfig-for-repo)`.
    func actionsGenerateRunnerJitconfigForRepo(_ input: Operations.ActionsGenerateRunnerJitconfigForRepo.Input) async throws -> Operations.ActionsGenerateRunnerJitconfigForRepo.Output
    /// Create a registration token for a repository
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
    ///
    /// ```
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/registration-token`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/registration-token/post(actions/create-registration-token-for-repo)`.
    func actionsCreateRegistrationTokenForRepo(_ input: Operations.ActionsCreateRegistrationTokenForRepo.Input) async throws -> Operations.ActionsCreateRegistrationTokenForRepo.Output
    /// Create a remove token for a repository
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an repository. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
    ///
    /// ```
    /// ./config.sh remove --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/remove-token`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/remove-token/post(actions/create-remove-token-for-repo)`.
    func actionsCreateRemoveTokenForRepo(_ input: Operations.ActionsCreateRemoveTokenForRepo.Input) async throws -> Operations.ActionsCreateRemoveTokenForRepo.Output
    /// Get a self-hosted runner for a repository
    ///
    /// Gets a specific self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/get(actions/get-self-hosted-runner-for-repo)`.
    func actionsGetSelfHostedRunnerForRepo(_ input: Operations.ActionsGetSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsGetSelfHostedRunnerForRepo.Output
    /// Delete a self-hosted runner from a repository
    ///
    /// Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/delete(actions/delete-self-hosted-runner-from-repo)`.
    func actionsDeleteSelfHostedRunnerFromRepo(_ input: Operations.ActionsDeleteSelfHostedRunnerFromRepo.Input) async throws -> Operations.ActionsDeleteSelfHostedRunnerFromRepo.Output
    /// List labels for a self-hosted runner for a repository
    ///
    /// Lists all labels for a self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/get(actions/list-labels-for-self-hosted-runner-for-repo)`.
    func actionsListLabelsForSelfHostedRunnerForRepo(_ input: Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Output
    /// Add custom labels to a self-hosted runner for a repository
    ///
    /// Adds custom labels to a self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/post(actions/add-custom-labels-to-self-hosted-runner-for-repo)`.
    func actionsAddCustomLabelsToSelfHostedRunnerForRepo(_ input: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Output
    /// Set custom labels for a self-hosted runner for a repository
    ///
    /// Remove all previous custom labels and set the new custom labels for a specific
    /// self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/put(actions/set-custom-labels-for-self-hosted-runner-for-repo)`.
    func actionsSetCustomLabelsForSelfHostedRunnerForRepo(_ input: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Output
    /// Remove all custom labels from a self-hosted runner for a repository
    ///
    /// Remove all custom labels from a self-hosted runner configured in a
    /// repository. Returns the remaining read-only labels from the runner.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/delete(actions/remove-all-custom-labels-from-self-hosted-runner-for-repo)`.
    func actionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo(_ input: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Output
    /// Remove a custom label from a self-hosted runner for a repository
    ///
    /// Remove a custom label from a self-hosted runner configured
    /// in a repository. Returns the remaining labels from the runner.
    ///
    /// This endpoint returns a `404 Not Found` status if the custom label is not
    /// present on the runner.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}/delete(actions/remove-custom-label-from-self-hosted-runner-for-repo)`.
    func actionsRemoveCustomLabelFromSelfHostedRunnerForRepo(_ input: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Output
    /// List workflow runs for a repository
    ///
    /// Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/get(actions/list-workflow-runs-for-repo)`.
    func actionsListWorkflowRunsForRepo(_ input: Operations.ActionsListWorkflowRunsForRepo.Input) async throws -> Operations.ActionsListWorkflowRunsForRepo.Output
    /// Get a workflow run
    ///
    /// Gets a specific workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/get(actions/get-workflow-run)`.
    func actionsGetWorkflowRun(_ input: Operations.ActionsGetWorkflowRun.Input) async throws -> Operations.ActionsGetWorkflowRun.Output
    /// Delete a workflow run
    ///
    /// Deletes a specific workflow run.
    ///
    /// Anyone with write access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/delete(actions/delete-workflow-run)`.
    func actionsDeleteWorkflowRun(_ input: Operations.ActionsDeleteWorkflowRun.Input) async throws -> Operations.ActionsDeleteWorkflowRun.Output
    /// Get the review history for a workflow run
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/approvals`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/approvals/get(actions/get-reviews-for-run)`.
    func actionsGetReviewsForRun(_ input: Operations.ActionsGetReviewsForRun.Input) async throws -> Operations.ActionsGetReviewsForRun.Output
    /// Approve a workflow run for a fork pull request
    ///
    /// Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/approve`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/approve/post(actions/approve-workflow-run)`.
    func actionsApproveWorkflowRun(_ input: Operations.ActionsApproveWorkflowRun.Input) async throws -> Operations.ActionsApproveWorkflowRun.Output
    /// List workflow run artifacts
    ///
    /// Lists artifacts for a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/artifacts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/artifacts/get(actions/list-workflow-run-artifacts)`.
    func actionsListWorkflowRunArtifacts(_ input: Operations.ActionsListWorkflowRunArtifacts.Input) async throws -> Operations.ActionsListWorkflowRunArtifacts.Output
    /// Get a workflow run attempt
    ///
    /// Gets a specific workflow run attempt.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/get(actions/get-workflow-run-attempt)`.
    func actionsGetWorkflowRunAttempt(_ input: Operations.ActionsGetWorkflowRunAttempt.Input) async throws -> Operations.ActionsGetWorkflowRunAttempt.Output
    /// List jobs for a workflow run attempt
    ///
    /// Lists jobs for a specific workflow run attempt. You can use parameters to narrow the list of results. For more information
    /// about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint  with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs/get(actions/list-jobs-for-workflow-run-attempt)`.
    func actionsListJobsForWorkflowRunAttempt(_ input: Operations.ActionsListJobsForWorkflowRunAttempt.Input) async throws -> Operations.ActionsListJobsForWorkflowRunAttempt.Output
    /// Download workflow run attempt logs
    ///
    /// Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
    /// 1 minute. Look for `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs/get(actions/download-workflow-run-attempt-logs)`.
    func actionsDownloadWorkflowRunAttemptLogs(_ input: Operations.ActionsDownloadWorkflowRunAttemptLogs.Input) async throws -> Operations.ActionsDownloadWorkflowRunAttemptLogs.Output
    /// Cancel a workflow run
    ///
    /// Cancels a workflow run using its `id`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/cancel/post(actions/cancel-workflow-run)`.
    func actionsCancelWorkflowRun(_ input: Operations.ActionsCancelWorkflowRun.Input) async throws -> Operations.ActionsCancelWorkflowRun.Output
    /// Review custom deployment protection rules for a workflow run
    ///
    /// Approve or reject custom deployment protection rules provided by a GitHub App for a workflow run. For more information, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// > [!NOTE]
    /// > GitHub Apps can only review their own custom deployment protection rules. To approve or reject pending deployments that are waiting for review from a specific person or team, see [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`](/rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule/post(actions/review-custom-gates-for-run)`.
    func actionsReviewCustomGatesForRun(_ input: Operations.ActionsReviewCustomGatesForRun.Input) async throws -> Operations.ActionsReviewCustomGatesForRun.Output
    /// Force cancel a workflow run
    ///
    /// Cancels a workflow run and bypasses conditions that would otherwise cause a workflow execution to continue, such as an `always()` condition on a job.
    /// You should only use this endpoint to cancel a workflow run when the workflow run is not responding to [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`](/rest/actions/workflow-runs#cancel-a-workflow-run).
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel/post(actions/force-cancel-workflow-run)`.
    func actionsForceCancelWorkflowRun(_ input: Operations.ActionsForceCancelWorkflowRun.Input) async throws -> Operations.ActionsForceCancelWorkflowRun.Output
    /// List jobs for a workflow run
    ///
    /// Lists jobs for a workflow run. You can use parameters to narrow the list of results. For more information
    /// about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/jobs/get(actions/list-jobs-for-workflow-run)`.
    func actionsListJobsForWorkflowRun(_ input: Operations.ActionsListJobsForWorkflowRun.Input) async throws -> Operations.ActionsListJobsForWorkflowRun.Output
    /// Download workflow run logs
    ///
    /// Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
    /// `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/logs/get(actions/download-workflow-run-logs)`.
    func actionsDownloadWorkflowRunLogs(_ input: Operations.ActionsDownloadWorkflowRunLogs.Input) async throws -> Operations.ActionsDownloadWorkflowRunLogs.Output
    /// Delete workflow run logs
    ///
    /// Deletes all logs for a workflow run.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runs/{run_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/logs/delete(actions/delete-workflow-run-logs)`.
    func actionsDeleteWorkflowRunLogs(_ input: Operations.ActionsDeleteWorkflowRunLogs.Input) async throws -> Operations.ActionsDeleteWorkflowRunLogs.Output
    /// Get pending deployments for a workflow run
    ///
    /// Get all deployment environments for a workflow run that are waiting for protection rules to pass.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments/get(actions/get-pending-deployments-for-run)`.
    func actionsGetPendingDeploymentsForRun(_ input: Operations.ActionsGetPendingDeploymentsForRun.Input) async throws -> Operations.ActionsGetPendingDeploymentsForRun.Output
    /// Review pending deployments for a workflow run
    ///
    /// Approve or reject pending deployments that are waiting on approval by a required reviewer.
    ///
    /// Required reviewers with read access to the repository contents and deployments can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments/post(actions/review-pending-deployments-for-run)`.
    func actionsReviewPendingDeploymentsForRun(_ input: Operations.ActionsReviewPendingDeploymentsForRun.Input) async throws -> Operations.ActionsReviewPendingDeploymentsForRun.Output
    /// Re-run a workflow
    ///
    /// Re-runs your workflow run using its `id`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/rerun/post(actions/re-run-workflow)`.
    func actionsReRunWorkflow(_ input: Operations.ActionsReRunWorkflow.Input) async throws -> Operations.ActionsReRunWorkflow.Output
    /// Re-run failed jobs from a workflow run
    ///
    /// Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs/post(actions/re-run-workflow-failed-jobs)`.
    func actionsReRunWorkflowFailedJobs(_ input: Operations.ActionsReRunWorkflowFailedJobs.Input) async throws -> Operations.ActionsReRunWorkflowFailedJobs.Output
    /// Get workflow run usage
    ///
    /// > [!WARNING]  
    /// > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.
    ///
    /// Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/timing`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/timing/get(actions/get-workflow-run-usage)`.
    func actionsGetWorkflowRunUsage(_ input: Operations.ActionsGetWorkflowRunUsage.Input) async throws -> Operations.ActionsGetWorkflowRunUsage.Output
    /// List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/get(actions/list-repo-secrets)`.
    func actionsListRepoSecrets(_ input: Operations.ActionsListRepoSecrets.Input) async throws -> Operations.ActionsListRepoSecrets.Output
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/public-key/get(actions/get-repo-public-key)`.
    func actionsGetRepoPublicKey(_ input: Operations.ActionsGetRepoPublicKey.Input) async throws -> Operations.ActionsGetRepoPublicKey.Output
    /// Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value.
    ///
    /// The authenticated user must have collaborator access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/get(actions/get-repo-secret)`.
    func actionsGetRepoSecret(_ input: Operations.ActionsGetRepoSecret.Input) async throws -> Operations.ActionsGetRepoSecret.Output
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/put(actions/create-or-update-repo-secret)`.
    func actionsCreateOrUpdateRepoSecret(_ input: Operations.ActionsCreateOrUpdateRepoSecret.Input) async throws -> Operations.ActionsCreateOrUpdateRepoSecret.Output
    /// Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/delete(actions/delete-repo-secret)`.
    func actionsDeleteRepoSecret(_ input: Operations.ActionsDeleteRepoSecret.Input) async throws -> Operations.ActionsDeleteRepoSecret.Output
    /// List repository variables
    ///
    /// Lists all repository variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/get(actions/list-repo-variables)`.
    func actionsListRepoVariables(_ input: Operations.ActionsListRepoVariables.Input) async throws -> Operations.ActionsListRepoVariables.Output
    /// Create a repository variable
    ///
    /// Creates a repository variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/post(actions/create-repo-variable)`.
    func actionsCreateRepoVariable(_ input: Operations.ActionsCreateRepoVariable.Input) async throws -> Operations.ActionsCreateRepoVariable.Output
    /// Get a repository variable
    ///
    /// Gets a specific variable in a repository.
    ///
    /// The authenticated user must have collaborator access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/get(actions/get-repo-variable)`.
    func actionsGetRepoVariable(_ input: Operations.ActionsGetRepoVariable.Input) async throws -> Operations.ActionsGetRepoVariable.Output
    /// Update a repository variable
    ///
    /// Updates a repository variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/patch(actions/update-repo-variable)`.
    func actionsUpdateRepoVariable(_ input: Operations.ActionsUpdateRepoVariable.Input) async throws -> Operations.ActionsUpdateRepoVariable.Output
    /// Delete a repository variable
    ///
    /// Deletes a repository variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/delete(actions/delete-repo-variable)`.
    func actionsDeleteRepoVariable(_ input: Operations.ActionsDeleteRepoVariable.Input) async throws -> Operations.ActionsDeleteRepoVariable.Output
    /// List repository workflows
    ///
    /// Lists the workflows in a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/get(actions/list-repo-workflows)`.
    func actionsListRepoWorkflows(_ input: Operations.ActionsListRepoWorkflows.Input) async throws -> Operations.ActionsListRepoWorkflows.Output
    /// Get a workflow
    ///
    /// Gets a specific workflow. You can replace `workflow_id` with the workflow
    /// file name. For example, you could use `main.yaml`.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/get(actions/get-workflow)`.
    func actionsGetWorkflow(_ input: Operations.ActionsGetWorkflow.Input) async throws -> Operations.ActionsGetWorkflow.Output
    /// Disable a workflow
    ///
    /// Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable/put(actions/disable-workflow)`.
    func actionsDisableWorkflow(_ input: Operations.ActionsDisableWorkflow.Input) async throws -> Operations.ActionsDisableWorkflow.Output
    /// Create a workflow dispatch event
    ///
    /// You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches/post(actions/create-workflow-dispatch)`.
    func actionsCreateWorkflowDispatch(_ input: Operations.ActionsCreateWorkflowDispatch.Input) async throws -> Operations.ActionsCreateWorkflowDispatch.Output
    /// Enable a workflow
    ///
    /// Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable/put(actions/enable-workflow)`.
    func actionsEnableWorkflow(_ input: Operations.ActionsEnableWorkflow.Input) async throws -> Operations.ActionsEnableWorkflow.Output
    /// List workflow runs for a workflow
    ///
    /// List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs/get(actions/list-workflow-runs)`.
    func actionsListWorkflowRuns(_ input: Operations.ActionsListWorkflowRuns.Input) async throws -> Operations.ActionsListWorkflowRuns.Output
    /// Get workflow usage
    ///
    /// > [!WARNING]  
    /// > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.
    ///
    /// Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing/get(actions/get-workflow-usage)`.
    func actionsGetWorkflowUsage(_ input: Operations.ActionsGetWorkflowUsage.Input) async throws -> Operations.ActionsGetWorkflowUsage.Output
    /// List environment secrets
    ///
    /// Lists all secrets available in an environment without revealing their
    /// encrypted values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/get(actions/list-environment-secrets)`.
    func actionsListEnvironmentSecrets(_ input: Operations.ActionsListEnvironmentSecrets.Input) async throws -> Operations.ActionsListEnvironmentSecrets.Output
    /// Get an environment public key
    ///
    /// Get the public key for an environment, which you need to encrypt environment
    /// secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key/get(actions/get-environment-public-key)`.
    func actionsGetEnvironmentPublicKey(_ input: Operations.ActionsGetEnvironmentPublicKey.Input) async throws -> Operations.ActionsGetEnvironmentPublicKey.Output
    /// Get an environment secret
    ///
    /// Gets a single environment secret without revealing its encrypted value.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/get(actions/get-environment-secret)`.
    func actionsGetEnvironmentSecret(_ input: Operations.ActionsGetEnvironmentSecret.Input) async throws -> Operations.ActionsGetEnvironmentSecret.Output
    /// Create or update an environment secret
    ///
    /// Creates or updates an environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/put(actions/create-or-update-environment-secret)`.
    func actionsCreateOrUpdateEnvironmentSecret(_ input: Operations.ActionsCreateOrUpdateEnvironmentSecret.Input) async throws -> Operations.ActionsCreateOrUpdateEnvironmentSecret.Output
    /// Delete an environment secret
    ///
    /// Deletes a secret in an environment using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/delete(actions/delete-environment-secret)`.
    func actionsDeleteEnvironmentSecret(_ input: Operations.ActionsDeleteEnvironmentSecret.Input) async throws -> Operations.ActionsDeleteEnvironmentSecret.Output
    /// List environment variables
    ///
    /// Lists all environment variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/get(actions/list-environment-variables)`.
    func actionsListEnvironmentVariables(_ input: Operations.ActionsListEnvironmentVariables.Input) async throws -> Operations.ActionsListEnvironmentVariables.Output
    /// Create an environment variable
    ///
    /// Create an environment variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/post(actions/create-environment-variable)`.
    func actionsCreateEnvironmentVariable(_ input: Operations.ActionsCreateEnvironmentVariable.Input) async throws -> Operations.ActionsCreateEnvironmentVariable.Output
    /// Get an environment variable
    ///
    /// Gets a specific variable in an environment.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/get(actions/get-environment-variable)`.
    func actionsGetEnvironmentVariable(_ input: Operations.ActionsGetEnvironmentVariable.Input) async throws -> Operations.ActionsGetEnvironmentVariable.Output
    /// Update an environment variable
    ///
    /// Updates an environment variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/patch(actions/update-environment-variable)`.
    func actionsUpdateEnvironmentVariable(_ input: Operations.ActionsUpdateEnvironmentVariable.Input) async throws -> Operations.ActionsUpdateEnvironmentVariable.Output
    /// Delete an environment variable
    ///
    /// Deletes an environment variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/delete(actions/delete-environment-variable)`.
    func actionsDeleteEnvironmentVariable(_ input: Operations.ActionsDeleteEnvironmentVariable.Input) async throws -> Operations.ActionsDeleteEnvironmentVariable.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get GitHub Actions cache usage for an organization
    ///
    /// Gets the total GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage/get(actions/get-actions-cache-usage-for-org)`.
    public func actionsGetActionsCacheUsageForOrg(
        path: Operations.ActionsGetActionsCacheUsageForOrg.Input.Path,
        headers: Operations.ActionsGetActionsCacheUsageForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetActionsCacheUsageForOrg.Output {
        try await actionsGetActionsCacheUsageForOrg(Operations.ActionsGetActionsCacheUsageForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repositories with GitHub Actions cache usage for an organization
    ///
    /// Lists repositories and their GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage-by-repository`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage-by-repository/get(actions/get-actions-cache-usage-by-repo-for-org)`.
    public func actionsGetActionsCacheUsageByRepoForOrg(
        path: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Path,
        query: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Query = .init(),
        headers: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output {
        try await actionsGetActionsCacheUsageByRepoForOrg(Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List GitHub-hosted runners for an organization
    ///
    /// Lists all GitHub-hosted runners configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runner:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/get(actions/list-hosted-runners-for-org)`.
    public func actionsListHostedRunnersForOrg(
        path: Operations.ActionsListHostedRunnersForOrg.Input.Path,
        query: Operations.ActionsListHostedRunnersForOrg.Input.Query = .init(),
        headers: Operations.ActionsListHostedRunnersForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListHostedRunnersForOrg.Output {
        try await actionsListHostedRunnersForOrg(Operations.ActionsListHostedRunnersForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a GitHub-hosted runner for an organization
    ///
    /// Creates a GitHub-hosted runner for an organization.
    /// OAuth tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/post(actions/create-hosted-runner-for-org)`.
    public func actionsCreateHostedRunnerForOrg(
        path: Operations.ActionsCreateHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsCreateHostedRunnerForOrg.Input.Headers = .init(),
        body: Operations.ActionsCreateHostedRunnerForOrg.Input.Body
    ) async throws -> Operations.ActionsCreateHostedRunnerForOrg.Output {
        try await actionsCreateHostedRunnerForOrg(Operations.ActionsCreateHostedRunnerForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get GitHub-owned images for GitHub-hosted runners in an organization
    ///
    /// Get the list of GitHub-owned images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/github-owned`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/github-owned/get(actions/get-hosted-runners-github-owned-images-for-org)`.
    public func actionsGetHostedRunnersGithubOwnedImagesForOrg(
        path: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input.Path,
        headers: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output {
        try await actionsGetHostedRunnersGithubOwnedImagesForOrg(Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get partner images for GitHub-hosted runners in an organization
    ///
    /// Get the list of partner images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/partner`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/partner/get(actions/get-hosted-runners-partner-images-for-org)`.
    public func actionsGetHostedRunnersPartnerImagesForOrg(
        path: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input.Path,
        headers: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output {
        try await actionsGetHostedRunnersPartnerImagesForOrg(Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get limits on GitHub-hosted runners for an organization
    ///
    /// Get the GitHub-hosted runners limits for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/limits/get(actions/get-hosted-runners-limits-for-org)`.
    public func actionsGetHostedRunnersLimitsForOrg(
        path: Operations.ActionsGetHostedRunnersLimitsForOrg.Input.Path,
        headers: Operations.ActionsGetHostedRunnersLimitsForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetHostedRunnersLimitsForOrg.Output {
        try await actionsGetHostedRunnersLimitsForOrg(Operations.ActionsGetHostedRunnersLimitsForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub-hosted runners machine specs for an organization
    ///
    /// Get the list of machine specs available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/machine-sizes`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/machine-sizes/get(actions/get-hosted-runners-machine-specs-for-org)`.
    public func actionsGetHostedRunnersMachineSpecsForOrg(
        path: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input.Path,
        headers: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output {
        try await actionsGetHostedRunnersMachineSpecsForOrg(Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get platforms for GitHub-hosted runners in an organization
    ///
    /// Get the list of platforms available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/platforms`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/platforms/get(actions/get-hosted-runners-platforms-for-org)`.
    public func actionsGetHostedRunnersPlatformsForOrg(
        path: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input.Path,
        headers: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetHostedRunnersPlatformsForOrg.Output {
        try await actionsGetHostedRunnersPlatformsForOrg(Operations.ActionsGetHostedRunnersPlatformsForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a GitHub-hosted runner for an organization
    ///
    /// Gets a GitHub-hosted runner configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/get(actions/get-hosted-runner-for-org)`.
    public func actionsGetHostedRunnerForOrg(
        path: Operations.ActionsGetHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsGetHostedRunnerForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetHostedRunnerForOrg.Output {
        try await actionsGetHostedRunnerForOrg(Operations.ActionsGetHostedRunnerForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a GitHub-hosted runner for an organization
    ///
    /// Updates a GitHub-hosted runner for an organization.
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/patch(actions/update-hosted-runner-for-org)`.
    public func actionsUpdateHostedRunnerForOrg(
        path: Operations.ActionsUpdateHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsUpdateHostedRunnerForOrg.Input.Headers = .init(),
        body: Operations.ActionsUpdateHostedRunnerForOrg.Input.Body
    ) async throws -> Operations.ActionsUpdateHostedRunnerForOrg.Output {
        try await actionsUpdateHostedRunnerForOrg(Operations.ActionsUpdateHostedRunnerForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a GitHub-hosted runner for an organization
    ///
    /// Deletes a GitHub-hosted runner for an organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/delete(actions/delete-hosted-runner-for-org)`.
    public func actionsDeleteHostedRunnerForOrg(
        path: Operations.ActionsDeleteHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsDeleteHostedRunnerForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsDeleteHostedRunnerForOrg.Output {
        try await actionsDeleteHostedRunnerForOrg(Operations.ActionsDeleteHostedRunnerForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub Actions permissions for an organization
    ///
    /// Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/get(actions/get-github-actions-permissions-organization)`.
    public func actionsGetGithubActionsPermissionsOrganization(
        path: Operations.ActionsGetGithubActionsPermissionsOrganization.Input.Path,
        headers: Operations.ActionsGetGithubActionsPermissionsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetGithubActionsPermissionsOrganization.Output {
        try await actionsGetGithubActionsPermissionsOrganization(Operations.ActionsGetGithubActionsPermissionsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set GitHub Actions permissions for an organization
    ///
    /// Sets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/put(actions/set-github-actions-permissions-organization)`.
    public func actionsSetGithubActionsPermissionsOrganization(
        path: Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Path,
        body: Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Body
    ) async throws -> Operations.ActionsSetGithubActionsPermissionsOrganization.Output {
        try await actionsSetGithubActionsPermissionsOrganization(Operations.ActionsSetGithubActionsPermissionsOrganization.Input(
            path: path,
            body: body
        ))
    }
    /// Get artifact and log retention settings for an organization
    ///
    /// Gets artifact and log retention settings for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-organization)`.
    public func actionsGetArtifactAndLogRetentionSettingsOrganization(
        path: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input.Path,
        headers: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Output {
        try await actionsGetArtifactAndLogRetentionSettingsOrganization(Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set artifact and log retention settings for an organization
    ///
    /// Sets artifact and log retention settings for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)`.
    public func actionsSetArtifactAndLogRetentionSettingsOrganization(
        path: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Path,
        headers: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Headers = .init(),
        body: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Body
    ) async throws -> Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Output {
        try await actionsSetArtifactAndLogRetentionSettingsOrganization(Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get fork PR contributor approval permissions for an organization
    ///
    /// Gets the fork PR contributor approval policy for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-organization)`.
    public func actionsGetForkPrContributorApprovalPermissionsOrganization(
        path: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input.Path,
        headers: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Output {
        try await actionsGetForkPrContributorApprovalPermissionsOrganization(Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set fork PR contributor approval permissions for an organization
    ///
    /// Sets the fork PR contributor approval policy for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)`.
    public func actionsSetForkPrContributorApprovalPermissionsOrganization(
        path: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Path,
        headers: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Headers = .init(),
        body: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Body
    ) async throws -> Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Output {
        try await actionsSetForkPrContributorApprovalPermissionsOrganization(Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get private repo fork PR workflow settings for an organization
    ///
    /// Gets the settings for whether workflows from fork pull requests can run on private repositories in an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-organization)`.
    public func actionsGetPrivateRepoForkPrWorkflowsSettingsOrganization(
        path: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Path,
        headers: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Output {
        try await actionsGetPrivateRepoForkPrWorkflowsSettingsOrganization(Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set private repo fork PR workflow settings for an organization
    ///
    /// Sets the settings for whether workflows from fork pull requests can run on private repositories in an organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)`.
    public func actionsSetPrivateRepoForkPrWorkflowsSettingsOrganization(
        path: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Path,
        headers: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Headers = .init(),
        body: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Body
    ) async throws -> Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output {
        try await actionsSetPrivateRepoForkPrWorkflowsSettingsOrganization(Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List selected repositories enabled for GitHub Actions in an organization
    ///
    /// Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/get(actions/list-selected-repositories-enabled-github-actions-organization)`.
    public func actionsListSelectedRepositoriesEnabledGithubActionsOrganization(
        path: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Path,
        query: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Query = .init(),
        headers: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output {
        try await actionsListSelectedRepositoriesEnabledGithubActionsOrganization(Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set selected repositories enabled for GitHub Actions in an organization
    ///
    /// Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/put(actions/set-selected-repositories-enabled-github-actions-organization)`.
    public func actionsSetSelectedRepositoriesEnabledGithubActionsOrganization(
        path: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Path,
        body: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Body
    ) async throws -> Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Output {
        try await actionsSetSelectedRepositoriesEnabledGithubActionsOrganization(Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input(
            path: path,
            body: body
        ))
    }
    /// Enable a selected repository for GitHub Actions in an organization
    ///
    /// Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/put(actions/enable-selected-repository-github-actions-organization)`.
    public func actionsEnableSelectedRepositoryGithubActionsOrganization(path: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Input.Path) async throws -> Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Output {
        try await actionsEnableSelectedRepositoryGithubActionsOrganization(Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Input(path: path))
    }
    /// Disable a selected repository for GitHub Actions in an organization
    ///
    /// Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/delete(actions/disable-selected-repository-github-actions-organization)`.
    public func actionsDisableSelectedRepositoryGithubActionsOrganization(path: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Input.Path) async throws -> Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Output {
        try await actionsDisableSelectedRepositoryGithubActionsOrganization(Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Input(path: path))
    }
    /// Get allowed actions and reusable workflows for an organization
    ///
    /// Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/get(actions/get-allowed-actions-organization)`.
    public func actionsGetAllowedActionsOrganization(
        path: Operations.ActionsGetAllowedActionsOrganization.Input.Path,
        headers: Operations.ActionsGetAllowedActionsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetAllowedActionsOrganization.Output {
        try await actionsGetAllowedActionsOrganization(Operations.ActionsGetAllowedActionsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set allowed actions and reusable workflows for an organization
    ///
    /// Sets the actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/put(actions/set-allowed-actions-organization)`.
    public func actionsSetAllowedActionsOrganization(
        path: Operations.ActionsSetAllowedActionsOrganization.Input.Path,
        body: Operations.ActionsSetAllowedActionsOrganization.Input.Body? = nil
    ) async throws -> Operations.ActionsSetAllowedActionsOrganization.Output {
        try await actionsSetAllowedActionsOrganization(Operations.ActionsSetAllowedActionsOrganization.Input(
            path: path,
            body: body
        ))
    }
    /// Get self-hosted runners settings for an organization
    ///
    /// Gets the settings for self-hosted runners for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/self-hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/get(actions/get-self-hosted-runners-permissions-organization)`.
    public func actionsGetSelfHostedRunnersPermissionsOrganization(
        path: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input.Path,
        headers: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Output {
        try await actionsGetSelfHostedRunnersPermissionsOrganization(Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set self-hosted runners settings for an organization
    ///
    /// Sets the settings for self-hosted runners for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)`.
    public func actionsSetSelfHostedRunnersPermissionsOrganization(
        path: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Path,
        headers: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Headers = .init(),
        body: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Body
    ) async throws -> Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Output {
        try await actionsSetSelfHostedRunnersPermissionsOrganization(Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repositories allowed to use self-hosted runners in an organization
    ///
    /// Lists repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/self-hosted-runners/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/get(actions/list-selected-repositories-self-hosted-runners-organization)`.
    public func actionsListSelectedRepositoriesSelfHostedRunnersOrganization(
        path: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Path,
        query: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Query = .init(),
        headers: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output {
        try await actionsListSelectedRepositoriesSelfHostedRunnersOrganization(Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set repositories allowed to use self-hosted runners in an organization
    ///
    /// Sets repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)`.
    public func actionsSetSelectedRepositoriesSelfHostedRunnersOrganization(
        path: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Path,
        headers: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Headers = .init(),
        body: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Body
    ) async throws -> Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Output {
        try await actionsSetSelectedRepositoriesSelfHostedRunnersOrganization(Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Add a repository to the list of repositories allowed to use self-hosted runners in an organization
    ///
    /// Adds a repository to the list of repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)`.
    public func actionsEnableSelectedRepositorySelfHostedRunnersOrganization(
        path: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input.Path,
        headers: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Output {
        try await actionsEnableSelectedRepositorySelfHostedRunnersOrganization(Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove a repository from the list of repositories allowed to use self-hosted runners in an organization
    ///
    /// Removes a repository from the list of repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)`.
    public func actionsDisableSelectedRepositorySelfHostedRunnersOrganization(
        path: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input.Path,
        headers: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Output {
        try await actionsDisableSelectedRepositorySelfHostedRunnersOrganization(Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get default workflow permissions for an organization
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
    /// as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-organization)`.
    public func actionsGetGithubActionsDefaultWorkflowPermissionsOrganization(
        path: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Path,
        headers: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output {
        try await actionsGetGithubActionsDefaultWorkflowPermissionsOrganization(Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set default workflow permissions for an organization
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
    /// can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-organization)`.
    public func actionsSetGithubActionsDefaultWorkflowPermissionsOrganization(
        path: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Path,
        body: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Body? = nil
    ) async throws -> Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Output {
        try await actionsSetGithubActionsDefaultWorkflowPermissionsOrganization(Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input(
            path: path,
            body: body
        ))
    }
    /// List self-hosted runner groups for an organization
    ///
    /// Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/get(actions/list-self-hosted-runner-groups-for-org)`.
    public func actionsListSelfHostedRunnerGroupsForOrg(
        path: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Path,
        query: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Query = .init(),
        headers: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output {
        try await actionsListSelfHostedRunnerGroupsForOrg(Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a self-hosted runner group for an organization
    ///
    /// Creates a new self-hosted runner group for an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/post(actions/create-self-hosted-runner-group-for-org)`.
    public func actionsCreateSelfHostedRunnerGroupForOrg(
        path: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Input.Path,
        headers: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Input.Headers = .init(),
        body: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Input.Body
    ) async throws -> Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Output {
        try await actionsCreateSelfHostedRunnerGroupForOrg(Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a self-hosted runner group for an organization
    ///
    /// Gets a specific self-hosted runner group for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/get(actions/get-self-hosted-runner-group-for-org)`.
    public func actionsGetSelfHostedRunnerGroupForOrg(
        path: Operations.ActionsGetSelfHostedRunnerGroupForOrg.Input.Path,
        headers: Operations.ActionsGetSelfHostedRunnerGroupForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetSelfHostedRunnerGroupForOrg.Output {
        try await actionsGetSelfHostedRunnerGroupForOrg(Operations.ActionsGetSelfHostedRunnerGroupForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a self-hosted runner group for an organization
    ///
    /// Updates the `name` and `visibility` of a self-hosted runner group in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/patch(actions/update-self-hosted-runner-group-for-org)`.
    public func actionsUpdateSelfHostedRunnerGroupForOrg(
        path: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Input.Path,
        headers: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Input.Headers = .init(),
        body: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Input.Body
    ) async throws -> Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Output {
        try await actionsUpdateSelfHostedRunnerGroupForOrg(Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a self-hosted runner group from an organization
    ///
    /// Deletes a self-hosted runner group for an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/delete(actions/delete-self-hosted-runner-group-from-org)`.
    public func actionsDeleteSelfHostedRunnerGroupFromOrg(path: Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Input.Path) async throws -> Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Output {
        try await actionsDeleteSelfHostedRunnerGroupFromOrg(Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Input(path: path))
    }
    /// List GitHub-hosted runners in a group for an organization
    ///
    /// Lists the GitHub-hosted runners in an organization group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners/get(actions/list-github-hosted-runners-in-group-for-org)`.
    public func actionsListGithubHostedRunnersInGroupForOrg(
        path: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Input.Path,
        query: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Input.Query = .init(),
        headers: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListGithubHostedRunnersInGroupForOrg.Output {
        try await actionsListGithubHostedRunnersInGroupForOrg(Operations.ActionsListGithubHostedRunnersInGroupForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository access to a self-hosted runner group in an organization
    ///
    /// Lists the repositories with access to a self-hosted runner group configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/get(actions/list-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsListRepoAccessToSelfHostedRunnerGroupInOrg(
        path: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Input.Path,
        query: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Input.Query = .init(),
        headers: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await actionsListRepoAccessToSelfHostedRunnerGroupInOrg(Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set repository access for a self-hosted runner group in an organization
    ///
    /// Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/put(actions/set-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsSetRepoAccessToSelfHostedRunnerGroupInOrg(
        path: Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Input.Path,
        body: Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Input.Body
    ) async throws -> Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await actionsSetRepoAccessToSelfHostedRunnerGroupInOrg(Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Input(
            path: path,
            body: body
        ))
    }
    /// Add repository access to a self-hosted runner group in an organization
    ///
    /// Adds a repository to the list of repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}/put(actions/add-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsAddRepoAccessToSelfHostedRunnerGroupInOrg(path: Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Input.Path) async throws -> Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await actionsAddRepoAccessToSelfHostedRunnerGroupInOrg(Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Input(path: path))
    }
    /// Remove repository access to a self-hosted runner group in an organization
    ///
    /// Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}/delete(actions/remove-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg(path: Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Input.Path) async throws -> Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await actionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg(Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Input(path: path))
    }
    /// List self-hosted runners in a group for an organization
    ///
    /// Lists self-hosted runners that are in a specific organization group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/get(actions/list-self-hosted-runners-in-group-for-org)`.
    public func actionsListSelfHostedRunnersInGroupForOrg(
        path: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Input.Path,
        query: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Input.Query = .init(),
        headers: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelfHostedRunnersInGroupForOrg.Output {
        try await actionsListSelfHostedRunnersInGroupForOrg(Operations.ActionsListSelfHostedRunnersInGroupForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set self-hosted runners in a group for an organization
    ///
    /// Replaces the list of self-hosted runners that are part of an organization runner group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/put(actions/set-self-hosted-runners-in-group-for-org)`.
    public func actionsSetSelfHostedRunnersInGroupForOrg(
        path: Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Input.Path,
        body: Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Input.Body
    ) async throws -> Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Output {
        try await actionsSetSelfHostedRunnersInGroupForOrg(Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Input(
            path: path,
            body: body
        ))
    }
    /// Add a self-hosted runner to a group for an organization
    ///
    /// Adds a self-hosted runner to a runner group configured in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}/put(actions/add-self-hosted-runner-to-group-for-org)`.
    public func actionsAddSelfHostedRunnerToGroupForOrg(path: Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Input.Path) async throws -> Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Output {
        try await actionsAddSelfHostedRunnerToGroupForOrg(Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Input(path: path))
    }
    /// Remove a self-hosted runner from a group for an organization
    ///
    /// Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}/delete(actions/remove-self-hosted-runner-from-group-for-org)`.
    public func actionsRemoveSelfHostedRunnerFromGroupForOrg(path: Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Input.Path) async throws -> Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Output {
        try await actionsRemoveSelfHostedRunnerFromGroupForOrg(Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Input(path: path))
    }
    /// List self-hosted runners for an organization
    ///
    /// Lists all self-hosted runners configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/get(actions/list-self-hosted-runners-for-org)`.
    public func actionsListSelfHostedRunnersForOrg(
        path: Operations.ActionsListSelfHostedRunnersForOrg.Input.Path,
        query: Operations.ActionsListSelfHostedRunnersForOrg.Input.Query = .init(),
        headers: Operations.ActionsListSelfHostedRunnersForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelfHostedRunnersForOrg.Output {
        try await actionsListSelfHostedRunnersForOrg(Operations.ActionsListSelfHostedRunnersForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List runner applications for an organization
    ///
    /// Lists binaries for the runner application that you can download and run.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.  If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/downloads`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/downloads/get(actions/list-runner-applications-for-org)`.
    public func actionsListRunnerApplicationsForOrg(
        path: Operations.ActionsListRunnerApplicationsForOrg.Input.Path,
        headers: Operations.ActionsListRunnerApplicationsForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRunnerApplicationsForOrg.Output {
        try await actionsListRunnerApplicationsForOrg(Operations.ActionsListRunnerApplicationsForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create configuration for a just-in-time runner for an organization
    ///
    /// Generates a configuration that can be passed to the runner application at startup.
    ///
    /// The authenticated user must have admin access to the organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/generate-jitconfig`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/generate-jitconfig/post(actions/generate-runner-jitconfig-for-org)`.
    public func actionsGenerateRunnerJitconfigForOrg(
        path: Operations.ActionsGenerateRunnerJitconfigForOrg.Input.Path,
        headers: Operations.ActionsGenerateRunnerJitconfigForOrg.Input.Headers = .init(),
        body: Operations.ActionsGenerateRunnerJitconfigForOrg.Input.Body
    ) async throws -> Operations.ActionsGenerateRunnerJitconfigForOrg.Output {
        try await actionsGenerateRunnerJitconfigForOrg(Operations.ActionsGenerateRunnerJitconfigForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Create a registration token for an organization
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
    ///
    /// ```
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/registration-token`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/registration-token/post(actions/create-registration-token-for-org)`.
    public func actionsCreateRegistrationTokenForOrg(
        path: Operations.ActionsCreateRegistrationTokenForOrg.Input.Path,
        headers: Operations.ActionsCreateRegistrationTokenForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsCreateRegistrationTokenForOrg.Output {
        try await actionsCreateRegistrationTokenForOrg(Operations.ActionsCreateRegistrationTokenForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a remove token for an organization
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
    ///
    /// ```
    /// ./config.sh remove --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/remove-token`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/remove-token/post(actions/create-remove-token-for-org)`.
    public func actionsCreateRemoveTokenForOrg(
        path: Operations.ActionsCreateRemoveTokenForOrg.Input.Path,
        headers: Operations.ActionsCreateRemoveTokenForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsCreateRemoveTokenForOrg.Output {
        try await actionsCreateRemoveTokenForOrg(Operations.ActionsCreateRemoveTokenForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a self-hosted runner for an organization
    ///
    /// Gets a specific self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/get(actions/get-self-hosted-runner-for-org)`.
    public func actionsGetSelfHostedRunnerForOrg(
        path: Operations.ActionsGetSelfHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsGetSelfHostedRunnerForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetSelfHostedRunnerForOrg.Output {
        try await actionsGetSelfHostedRunnerForOrg(Operations.ActionsGetSelfHostedRunnerForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a self-hosted runner from an organization
    ///
    /// Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/delete(actions/delete-self-hosted-runner-from-org)`.
    public func actionsDeleteSelfHostedRunnerFromOrg(
        path: Operations.ActionsDeleteSelfHostedRunnerFromOrg.Input.Path,
        headers: Operations.ActionsDeleteSelfHostedRunnerFromOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsDeleteSelfHostedRunnerFromOrg.Output {
        try await actionsDeleteSelfHostedRunnerFromOrg(Operations.ActionsDeleteSelfHostedRunnerFromOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// List labels for a self-hosted runner for an organization
    ///
    /// Lists all labels for a self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/get(actions/list-labels-for-self-hosted-runner-for-org)`.
    public func actionsListLabelsForSelfHostedRunnerForOrg(
        path: Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Output {
        try await actionsListLabelsForSelfHostedRunnerForOrg(Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add custom labels to a self-hosted runner for an organization
    ///
    /// Adds custom labels to a self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/post(actions/add-custom-labels-to-self-hosted-runner-for-org)`.
    public func actionsAddCustomLabelsToSelfHostedRunnerForOrg(
        path: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Input.Headers = .init(),
        body: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Input.Body
    ) async throws -> Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Output {
        try await actionsAddCustomLabelsToSelfHostedRunnerForOrg(Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set custom labels for a self-hosted runner for an organization
    ///
    /// Remove all previous custom labels and set the new custom labels for a specific
    /// self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/put(actions/set-custom-labels-for-self-hosted-runner-for-org)`.
    public func actionsSetCustomLabelsForSelfHostedRunnerForOrg(
        path: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Input.Headers = .init(),
        body: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Input.Body
    ) async throws -> Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Output {
        try await actionsSetCustomLabelsForSelfHostedRunnerForOrg(Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove all custom labels from a self-hosted runner for an organization
    ///
    /// Remove all custom labels from a self-hosted runner configured in an
    /// organization. Returns the remaining read-only labels from the runner.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/delete(actions/remove-all-custom-labels-from-self-hosted-runner-for-org)`.
    public func actionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg(
        path: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Output {
        try await actionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg(Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove a custom label from a self-hosted runner for an organization
    ///
    /// Remove a custom label from a self-hosted runner configured
    /// in an organization. Returns the remaining labels from the runner.
    ///
    /// This endpoint returns a `404 Not Found` status if the custom label is not
    /// present on the runner.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}/labels/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/{name}/delete(actions/remove-custom-label-from-self-hosted-runner-for-org)`.
    public func actionsRemoveCustomLabelFromSelfHostedRunnerForOrg(
        path: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Input.Path,
        headers: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Input.Headers = .init()
    ) async throws -> Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Output {
        try await actionsRemoveCustomLabelFromSelfHostedRunnerForOrg(Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their
    /// encrypted values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/get(actions/list-org-secrets)`.
    public func actionsListOrgSecrets(
        path: Operations.ActionsListOrgSecrets.Input.Path,
        query: Operations.ActionsListOrgSecrets.Input.Query = .init(),
        headers: Operations.ActionsListOrgSecrets.Input.Headers = .init()
    ) async throws -> Operations.ActionsListOrgSecrets.Output {
        try await actionsListOrgSecrets(Operations.ActionsListOrgSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/public-key/get(actions/get-org-public-key)`.
    public func actionsGetOrgPublicKey(
        path: Operations.ActionsGetOrgPublicKey.Input.Path,
        headers: Operations.ActionsGetOrgPublicKey.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetOrgPublicKey.Output {
        try await actionsGetOrgPublicKey(Operations.ActionsGetOrgPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read secrets
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/get(actions/get-org-secret)`.
    public func actionsGetOrgSecret(
        path: Operations.ActionsGetOrgSecret.Input.Path,
        headers: Operations.ActionsGetOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetOrgSecret.Output {
        try await actionsGetOrgSecret(Operations.ActionsGetOrgSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/put(actions/create-or-update-org-secret)`.
    public func actionsCreateOrUpdateOrgSecret(
        path: Operations.ActionsCreateOrUpdateOrgSecret.Input.Path,
        headers: Operations.ActionsCreateOrUpdateOrgSecret.Input.Headers = .init(),
        body: Operations.ActionsCreateOrUpdateOrgSecret.Input.Body
    ) async throws -> Operations.ActionsCreateOrUpdateOrgSecret.Output {
        try await actionsCreateOrUpdateOrgSecret(Operations.ActionsCreateOrUpdateOrgSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/delete(actions/delete-org-secret)`.
    public func actionsDeleteOrgSecret(path: Operations.ActionsDeleteOrgSecret.Input.Path) async throws -> Operations.ActionsDeleteOrgSecret.Output {
        try await actionsDeleteOrgSecret(Operations.ActionsDeleteOrgSecret.Input(path: path))
    }
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/get(actions/list-selected-repos-for-org-secret)`.
    public func actionsListSelectedReposForOrgSecret(
        path: Operations.ActionsListSelectedReposForOrgSecret.Input.Path,
        query: Operations.ActionsListSelectedReposForOrgSecret.Input.Query = .init(),
        headers: Operations.ActionsListSelectedReposForOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelectedReposForOrgSecret.Output {
        try await actionsListSelectedReposForOrgSecret(Operations.ActionsListSelectedReposForOrgSecret.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/put(actions/set-selected-repos-for-org-secret)`.
    public func actionsSetSelectedReposForOrgSecret(
        path: Operations.ActionsSetSelectedReposForOrgSecret.Input.Path,
        body: Operations.ActionsSetSelectedReposForOrgSecret.Input.Body
    ) async throws -> Operations.ActionsSetSelectedReposForOrgSecret.Output {
        try await actionsSetSelectedReposForOrgSecret(Operations.ActionsSetSelectedReposForOrgSecret.Input(
            path: path,
            body: body
        ))
    }
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for
    /// repository access is set to `selected`. For more information about setting the visibility, see [Create or
    /// update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}/put(actions/add-selected-repo-to-org-secret)`.
    public func actionsAddSelectedRepoToOrgSecret(path: Operations.ActionsAddSelectedRepoToOrgSecret.Input.Path) async throws -> Operations.ActionsAddSelectedRepoToOrgSecret.Output {
        try await actionsAddSelectedRepoToOrgSecret(Operations.ActionsAddSelectedRepoToOrgSecret.Input(path: path))
    }
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}/delete(actions/remove-selected-repo-from-org-secret)`.
    public func actionsRemoveSelectedRepoFromOrgSecret(path: Operations.ActionsRemoveSelectedRepoFromOrgSecret.Input.Path) async throws -> Operations.ActionsRemoveSelectedRepoFromOrgSecret.Output {
        try await actionsRemoveSelectedRepoFromOrgSecret(Operations.ActionsRemoveSelectedRepoFromOrgSecret.Input(path: path))
    }
    /// List organization variables
    ///
    /// Lists all organization variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/get(actions/list-org-variables)`.
    public func actionsListOrgVariables(
        path: Operations.ActionsListOrgVariables.Input.Path,
        query: Operations.ActionsListOrgVariables.Input.Query = .init(),
        headers: Operations.ActionsListOrgVariables.Input.Headers = .init()
    ) async throws -> Operations.ActionsListOrgVariables.Output {
        try await actionsListOrgVariables(Operations.ActionsListOrgVariables.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization variable
    ///
    /// Creates an organization variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/variables`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/post(actions/create-org-variable)`.
    public func actionsCreateOrgVariable(
        path: Operations.ActionsCreateOrgVariable.Input.Path,
        headers: Operations.ActionsCreateOrgVariable.Input.Headers = .init(),
        body: Operations.ActionsCreateOrgVariable.Input.Body
    ) async throws -> Operations.ActionsCreateOrgVariable.Output {
        try await actionsCreateOrgVariable(Operations.ActionsCreateOrgVariable.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get an organization variable
    ///
    /// Gets a specific variable in an organization.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/get(actions/get-org-variable)`.
    public func actionsGetOrgVariable(
        path: Operations.ActionsGetOrgVariable.Input.Path,
        headers: Operations.ActionsGetOrgVariable.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetOrgVariable.Output {
        try await actionsGetOrgVariable(Operations.ActionsGetOrgVariable.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an organization variable
    ///
    /// Updates an organization variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/patch(actions/update-org-variable)`.
    public func actionsUpdateOrgVariable(
        path: Operations.ActionsUpdateOrgVariable.Input.Path,
        body: Operations.ActionsUpdateOrgVariable.Input.Body
    ) async throws -> Operations.ActionsUpdateOrgVariable.Output {
        try await actionsUpdateOrgVariable(Operations.ActionsUpdateOrgVariable.Input(
            path: path,
            body: body
        ))
    }
    /// Delete an organization variable
    ///
    /// Deletes an organization variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/delete(actions/delete-org-variable)`.
    public func actionsDeleteOrgVariable(path: Operations.ActionsDeleteOrgVariable.Input.Path) async throws -> Operations.ActionsDeleteOrgVariable.Output {
        try await actionsDeleteOrgVariable(Operations.ActionsDeleteOrgVariable.Input(path: path))
    }
    /// List selected repositories for an organization variable
    ///
    /// Lists all repositories that can access an organization variable
    /// that is available to selected repositories.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables/{name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/get(actions/list-selected-repos-for-org-variable)`.
    public func actionsListSelectedReposForOrgVariable(
        path: Operations.ActionsListSelectedReposForOrgVariable.Input.Path,
        query: Operations.ActionsListSelectedReposForOrgVariable.Input.Query = .init(),
        headers: Operations.ActionsListSelectedReposForOrgVariable.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelectedReposForOrgVariable.Output {
        try await actionsListSelectedReposForOrgVariable(Operations.ActionsListSelectedReposForOrgVariable.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set selected repositories for an organization variable
    ///
    /// Replaces all repositories for an organization variable that is available
    /// to selected repositories. Organization variables that are available to selected
    /// repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/variables/{name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/put(actions/set-selected-repos-for-org-variable)`.
    public func actionsSetSelectedReposForOrgVariable(
        path: Operations.ActionsSetSelectedReposForOrgVariable.Input.Path,
        body: Operations.ActionsSetSelectedReposForOrgVariable.Input.Body
    ) async throws -> Operations.ActionsSetSelectedReposForOrgVariable.Output {
        try await actionsSetSelectedReposForOrgVariable(Operations.ActionsSetSelectedReposForOrgVariable.Input(
            path: path,
            body: body
        ))
    }
    /// Add selected repository to an organization variable
    ///
    /// Adds a repository to an organization variable that is available to selected repositories.
    /// Organization variables that are available to selected repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/variables/{name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/{repository_id}/put(actions/add-selected-repo-to-org-variable)`.
    public func actionsAddSelectedRepoToOrgVariable(path: Operations.ActionsAddSelectedRepoToOrgVariable.Input.Path) async throws -> Operations.ActionsAddSelectedRepoToOrgVariable.Output {
        try await actionsAddSelectedRepoToOrgVariable(Operations.ActionsAddSelectedRepoToOrgVariable.Input(path: path))
    }
    /// Remove selected repository from an organization variable
    ///
    /// Removes a repository from an organization variable that is
    /// available to selected repositories. Organization variables that are available to
    /// selected repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/variables/{name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/{repository_id}/delete(actions/remove-selected-repo-from-org-variable)`.
    public func actionsRemoveSelectedRepoFromOrgVariable(path: Operations.ActionsRemoveSelectedRepoFromOrgVariable.Input.Path) async throws -> Operations.ActionsRemoveSelectedRepoFromOrgVariable.Output {
        try await actionsRemoveSelectedRepoFromOrgVariable(Operations.ActionsRemoveSelectedRepoFromOrgVariable.Input(path: path))
    }
    /// List artifacts for a repository
    ///
    /// Lists all artifacts for a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/get(actions/list-artifacts-for-repo)`.
    public func actionsListArtifactsForRepo(
        path: Operations.ActionsListArtifactsForRepo.Input.Path,
        query: Operations.ActionsListArtifactsForRepo.Input.Query = .init(),
        headers: Operations.ActionsListArtifactsForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsListArtifactsForRepo.Output {
        try await actionsListArtifactsForRepo(Operations.ActionsListArtifactsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an artifact
    ///
    /// Gets a specific artifact for a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/get(actions/get-artifact)`.
    public func actionsGetArtifact(
        path: Operations.ActionsGetArtifact.Input.Path,
        headers: Operations.ActionsGetArtifact.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetArtifact.Output {
        try await actionsGetArtifact(Operations.ActionsGetArtifact.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete an artifact
    ///
    /// Deletes an artifact for a workflow run.
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/artifacts/{artifact_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/delete(actions/delete-artifact)`.
    public func actionsDeleteArtifact(path: Operations.ActionsDeleteArtifact.Input.Path) async throws -> Operations.ActionsDeleteArtifact.Output {
        try await actionsDeleteArtifact(Operations.ActionsDeleteArtifact.Input(path: path))
    }
    /// Download an artifact
    ///
    /// Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
    /// the response header to find the URL for the download. The `:archive_format` must be `zip`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}/get(actions/download-artifact)`.
    public func actionsDownloadArtifact(
        path: Operations.ActionsDownloadArtifact.Input.Path,
        headers: Operations.ActionsDownloadArtifact.Input.Headers = .init()
    ) async throws -> Operations.ActionsDownloadArtifact.Output {
        try await actionsDownloadArtifact(Operations.ActionsDownloadArtifact.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub Actions cache usage for a repository
    ///
    /// Gets GitHub Actions cache usage for a repository.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/cache/usage/get(actions/get-actions-cache-usage)`.
    public func actionsGetActionsCacheUsage(
        path: Operations.ActionsGetActionsCacheUsage.Input.Path,
        headers: Operations.ActionsGetActionsCacheUsage.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetActionsCacheUsage.Output {
        try await actionsGetActionsCacheUsage(Operations.ActionsGetActionsCacheUsage.Input(
            path: path,
            headers: headers
        ))
    }
    /// List GitHub Actions caches for a repository
    ///
    /// Lists the GitHub Actions caches for a repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/caches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/get(actions/get-actions-cache-list)`.
    public func actionsGetActionsCacheList(
        path: Operations.ActionsGetActionsCacheList.Input.Path,
        query: Operations.ActionsGetActionsCacheList.Input.Query = .init(),
        headers: Operations.ActionsGetActionsCacheList.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetActionsCacheList.Output {
        try await actionsGetActionsCacheList(Operations.ActionsGetActionsCacheList.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Delete GitHub Actions caches for a repository (using a cache key)
    ///
    /// Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/caches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/delete(actions/delete-actions-cache-by-key)`.
    public func actionsDeleteActionsCacheByKey(
        path: Operations.ActionsDeleteActionsCacheByKey.Input.Path,
        query: Operations.ActionsDeleteActionsCacheByKey.Input.Query,
        headers: Operations.ActionsDeleteActionsCacheByKey.Input.Headers = .init()
    ) async throws -> Operations.ActionsDeleteActionsCacheByKey.Output {
        try await actionsDeleteActionsCacheByKey(Operations.ActionsDeleteActionsCacheByKey.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Delete a GitHub Actions cache for a repository (using a cache ID)
    ///
    /// Deletes a GitHub Actions cache for a repository, using a cache ID.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/caches/{cache_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/{cache_id}/delete(actions/delete-actions-cache-by-id)`.
    public func actionsDeleteActionsCacheById(path: Operations.ActionsDeleteActionsCacheById.Input.Path) async throws -> Operations.ActionsDeleteActionsCacheById.Output {
        try await actionsDeleteActionsCacheById(Operations.ActionsDeleteActionsCacheById.Input(path: path))
    }
    /// Get a job for a workflow run
    ///
    /// Gets a specific job in a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/jobs/{job_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/get(actions/get-job-for-workflow-run)`.
    public func actionsGetJobForWorkflowRun(
        path: Operations.ActionsGetJobForWorkflowRun.Input.Path,
        headers: Operations.ActionsGetJobForWorkflowRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetJobForWorkflowRun.Output {
        try await actionsGetJobForWorkflowRun(Operations.ActionsGetJobForWorkflowRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// Download job logs for a workflow run
    ///
    /// Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
    /// for `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/jobs/{job_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/logs/get(actions/download-job-logs-for-workflow-run)`.
    public func actionsDownloadJobLogsForWorkflowRun(path: Operations.ActionsDownloadJobLogsForWorkflowRun.Input.Path) async throws -> Operations.ActionsDownloadJobLogsForWorkflowRun.Output {
        try await actionsDownloadJobLogsForWorkflowRun(Operations.ActionsDownloadJobLogsForWorkflowRun.Input(path: path))
    }
    /// Re-run a job from a workflow run
    ///
    /// Re-run a job and its dependent jobs in a workflow run.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/jobs/{job_id}/rerun`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/rerun/post(actions/re-run-job-for-workflow-run)`.
    public func actionsReRunJobForWorkflowRun(
        path: Operations.ActionsReRunJobForWorkflowRun.Input.Path,
        headers: Operations.ActionsReRunJobForWorkflowRun.Input.Headers = .init(),
        body: Operations.ActionsReRunJobForWorkflowRun.Input.Body? = nil
    ) async throws -> Operations.ActionsReRunJobForWorkflowRun.Output {
        try await actionsReRunJobForWorkflowRun(Operations.ActionsReRunJobForWorkflowRun.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get the customization template for an OIDC subject claim for a repository
    ///
    /// Gets the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/oidc/customization/sub/get(actions/get-custom-oidc-sub-claim-for-repo)`.
    public func actionsGetCustomOidcSubClaimForRepo(
        path: Operations.ActionsGetCustomOidcSubClaimForRepo.Input.Path,
        headers: Operations.ActionsGetCustomOidcSubClaimForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetCustomOidcSubClaimForRepo.Output {
        try await actionsGetCustomOidcSubClaimForRepo(Operations.ActionsGetCustomOidcSubClaimForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set the customization template for an OIDC subject claim for a repository
    ///
    /// Sets the customization template and `opt-in` or `opt-out` flag for an OpenID Connect (OIDC) subject claim for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/oidc/customization/sub/put(actions/set-custom-oidc-sub-claim-for-repo)`.
    public func actionsSetCustomOidcSubClaimForRepo(
        path: Operations.ActionsSetCustomOidcSubClaimForRepo.Input.Path,
        headers: Operations.ActionsSetCustomOidcSubClaimForRepo.Input.Headers = .init(),
        body: Operations.ActionsSetCustomOidcSubClaimForRepo.Input.Body
    ) async throws -> Operations.ActionsSetCustomOidcSubClaimForRepo.Output {
        try await actionsSetCustomOidcSubClaimForRepo(Operations.ActionsSetCustomOidcSubClaimForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository organization secrets
    ///
    /// Lists all organization secrets shared with a repository without revealing their encrypted
    /// values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/organization-secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/organization-secrets/get(actions/list-repo-organization-secrets)`.
    public func actionsListRepoOrganizationSecrets(
        path: Operations.ActionsListRepoOrganizationSecrets.Input.Path,
        query: Operations.ActionsListRepoOrganizationSecrets.Input.Query = .init(),
        headers: Operations.ActionsListRepoOrganizationSecrets.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRepoOrganizationSecrets.Output {
        try await actionsListRepoOrganizationSecrets(Operations.ActionsListRepoOrganizationSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository organization variables
    ///
    /// Lists all organization variables shared with a repository.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/organization-variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/organization-variables/get(actions/list-repo-organization-variables)`.
    public func actionsListRepoOrganizationVariables(
        path: Operations.ActionsListRepoOrganizationVariables.Input.Path,
        query: Operations.ActionsListRepoOrganizationVariables.Input.Query = .init(),
        headers: Operations.ActionsListRepoOrganizationVariables.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRepoOrganizationVariables.Output {
        try await actionsListRepoOrganizationVariables(Operations.ActionsListRepoOrganizationVariables.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get GitHub Actions permissions for a repository
    ///
    /// Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions and reusable workflows allowed to run in the repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/get(actions/get-github-actions-permissions-repository)`.
    public func actionsGetGithubActionsPermissionsRepository(
        path: Operations.ActionsGetGithubActionsPermissionsRepository.Input.Path,
        headers: Operations.ActionsGetGithubActionsPermissionsRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetGithubActionsPermissionsRepository.Output {
        try await actionsGetGithubActionsPermissionsRepository(Operations.ActionsGetGithubActionsPermissionsRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set GitHub Actions permissions for a repository
    ///
    /// Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions and reusable workflows in the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/put(actions/set-github-actions-permissions-repository)`.
    public func actionsSetGithubActionsPermissionsRepository(
        path: Operations.ActionsSetGithubActionsPermissionsRepository.Input.Path,
        body: Operations.ActionsSetGithubActionsPermissionsRepository.Input.Body
    ) async throws -> Operations.ActionsSetGithubActionsPermissionsRepository.Output {
        try await actionsSetGithubActionsPermissionsRepository(Operations.ActionsSetGithubActionsPermissionsRepository.Input(
            path: path,
            body: body
        ))
    }
    /// Get the level of access for workflows outside of the repository
    ///
    /// Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
    /// This endpoint only applies to private repositories.
    /// For more information, see "[Allowing access to components in a private repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/access`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/access/get(actions/get-workflow-access-to-repository)`.
    public func actionsGetWorkflowAccessToRepository(
        path: Operations.ActionsGetWorkflowAccessToRepository.Input.Path,
        headers: Operations.ActionsGetWorkflowAccessToRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetWorkflowAccessToRepository.Output {
        try await actionsGetWorkflowAccessToRepository(Operations.ActionsGetWorkflowAccessToRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set the level of access for workflows outside of the repository
    ///
    /// Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
    /// This endpoint only applies to private repositories.
    /// For more information, see "[Allowing access to components in a private repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/access`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/access/put(actions/set-workflow-access-to-repository)`.
    public func actionsSetWorkflowAccessToRepository(
        path: Operations.ActionsSetWorkflowAccessToRepository.Input.Path,
        body: Operations.ActionsSetWorkflowAccessToRepository.Input.Body
    ) async throws -> Operations.ActionsSetWorkflowAccessToRepository.Output {
        try await actionsSetWorkflowAccessToRepository(Operations.ActionsSetWorkflowAccessToRepository.Input(
            path: path,
            body: body
        ))
    }
    /// Get artifact and log retention settings for a repository
    ///
    /// Gets artifact and log retention settings for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-repository)`.
    public func actionsGetArtifactAndLogRetentionSettingsRepository(
        path: Operations.ActionsGetArtifactAndLogRetentionSettingsRepository.Input.Path,
        headers: Operations.ActionsGetArtifactAndLogRetentionSettingsRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetArtifactAndLogRetentionSettingsRepository.Output {
        try await actionsGetArtifactAndLogRetentionSettingsRepository(Operations.ActionsGetArtifactAndLogRetentionSettingsRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set artifact and log retention settings for a repository
    ///
    /// Sets artifact and log retention settings for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-repository)`.
    public func actionsSetArtifactAndLogRetentionSettingsRepository(
        path: Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Input.Path,
        headers: Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Input.Headers = .init(),
        body: Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Input.Body
    ) async throws -> Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Output {
        try await actionsSetArtifactAndLogRetentionSettingsRepository(Operations.ActionsSetArtifactAndLogRetentionSettingsRepository.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get fork PR contributor approval permissions for a repository
    ///
    /// Gets the fork PR contributor approval policy for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-repository)`.
    public func actionsGetForkPrContributorApprovalPermissionsRepository(
        path: Operations.ActionsGetForkPrContributorApprovalPermissionsRepository.Input.Path,
        headers: Operations.ActionsGetForkPrContributorApprovalPermissionsRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetForkPrContributorApprovalPermissionsRepository.Output {
        try await actionsGetForkPrContributorApprovalPermissionsRepository(Operations.ActionsGetForkPrContributorApprovalPermissionsRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set fork PR contributor approval permissions for a repository
    ///
    /// Sets the fork PR contributor approval policy for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-repository)`.
    public func actionsSetForkPrContributorApprovalPermissionsRepository(
        path: Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Input.Path,
        headers: Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Input.Headers = .init(),
        body: Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Input.Body
    ) async throws -> Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Output {
        try await actionsSetForkPrContributorApprovalPermissionsRepository(Operations.ActionsSetForkPrContributorApprovalPermissionsRepository.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get private repo fork PR workflow settings for a repository
    ///
    /// Gets the settings for whether workflows from fork pull requests can run on a private repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-repository)`.
    public func actionsGetPrivateRepoForkPrWorkflowsSettingsRepository(
        path: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsRepository.Input.Path,
        headers: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsRepository.Output {
        try await actionsGetPrivateRepoForkPrWorkflowsSettingsRepository(Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set private repo fork PR workflow settings for a repository
    ///
    /// Sets the settings for whether workflows from fork pull requests can run on a private repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-repository)`.
    public func actionsSetPrivateRepoForkPrWorkflowsSettingsRepository(
        path: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Input.Path,
        headers: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Input.Headers = .init(),
        body: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Input.Body
    ) async throws -> Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Output {
        try await actionsSetPrivateRepoForkPrWorkflowsSettingsRepository(Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsRepository.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get allowed actions and reusable workflows for a repository
    ///
    /// Gets the settings for selected actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/selected-actions/get(actions/get-allowed-actions-repository)`.
    public func actionsGetAllowedActionsRepository(
        path: Operations.ActionsGetAllowedActionsRepository.Input.Path,
        headers: Operations.ActionsGetAllowedActionsRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetAllowedActionsRepository.Output {
        try await actionsGetAllowedActionsRepository(Operations.ActionsGetAllowedActionsRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set allowed actions and reusable workflows for a repository
    ///
    /// Sets the actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/selected-actions/put(actions/set-allowed-actions-repository)`.
    public func actionsSetAllowedActionsRepository(
        path: Operations.ActionsSetAllowedActionsRepository.Input.Path,
        body: Operations.ActionsSetAllowedActionsRepository.Input.Body? = nil
    ) async throws -> Operations.ActionsSetAllowedActionsRepository.Output {
        try await actionsSetAllowedActionsRepository(Operations.ActionsSetAllowedActionsRepository.Input(
            path: path,
            body: body
        ))
    }
    /// Get default workflow permissions for a repository
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
    /// as well as if GitHub Actions can submit approving pull request reviews.
    /// For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-repository)`.
    public func actionsGetGithubActionsDefaultWorkflowPermissionsRepository(
        path: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Input.Path,
        headers: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Output {
        try await actionsGetGithubActionsDefaultWorkflowPermissionsRepository(Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set default workflow permissions for a repository
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
    /// can submit approving pull request reviews.
    /// For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-repository)`.
    public func actionsSetGithubActionsDefaultWorkflowPermissionsRepository(
        path: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Input.Path,
        body: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Input.Body
    ) async throws -> Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Output {
        try await actionsSetGithubActionsDefaultWorkflowPermissionsRepository(Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Input(
            path: path,
            body: body
        ))
    }
    /// List self-hosted runners for a repository
    ///
    /// Lists all self-hosted runners configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/get(actions/list-self-hosted-runners-for-repo)`.
    public func actionsListSelfHostedRunnersForRepo(
        path: Operations.ActionsListSelfHostedRunnersForRepo.Input.Path,
        query: Operations.ActionsListSelfHostedRunnersForRepo.Input.Query = .init(),
        headers: Operations.ActionsListSelfHostedRunnersForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsListSelfHostedRunnersForRepo.Output {
        try await actionsListSelfHostedRunnersForRepo(Operations.ActionsListSelfHostedRunnersForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List runner applications for a repository
    ///
    /// Lists binaries for the runner application that you can download and run.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/downloads`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/downloads/get(actions/list-runner-applications-for-repo)`.
    public func actionsListRunnerApplicationsForRepo(
        path: Operations.ActionsListRunnerApplicationsForRepo.Input.Path,
        headers: Operations.ActionsListRunnerApplicationsForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRunnerApplicationsForRepo.Output {
        try await actionsListRunnerApplicationsForRepo(Operations.ActionsListRunnerApplicationsForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create configuration for a just-in-time runner for a repository
    ///
    /// Generates a configuration that can be passed to the runner application at startup.
    ///
    /// The authenticated user must have admin access to the repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/generate-jitconfig`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/generate-jitconfig/post(actions/generate-runner-jitconfig-for-repo)`.
    public func actionsGenerateRunnerJitconfigForRepo(
        path: Operations.ActionsGenerateRunnerJitconfigForRepo.Input.Path,
        headers: Operations.ActionsGenerateRunnerJitconfigForRepo.Input.Headers = .init(),
        body: Operations.ActionsGenerateRunnerJitconfigForRepo.Input.Body
    ) async throws -> Operations.ActionsGenerateRunnerJitconfigForRepo.Output {
        try await actionsGenerateRunnerJitconfigForRepo(Operations.ActionsGenerateRunnerJitconfigForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Create a registration token for a repository
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
    ///
    /// ```
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/registration-token`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/registration-token/post(actions/create-registration-token-for-repo)`.
    public func actionsCreateRegistrationTokenForRepo(
        path: Operations.ActionsCreateRegistrationTokenForRepo.Input.Path,
        headers: Operations.ActionsCreateRegistrationTokenForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsCreateRegistrationTokenForRepo.Output {
        try await actionsCreateRegistrationTokenForRepo(Operations.ActionsCreateRegistrationTokenForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a remove token for a repository
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an repository. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
    ///
    /// ```
    /// ./config.sh remove --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/remove-token`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/remove-token/post(actions/create-remove-token-for-repo)`.
    public func actionsCreateRemoveTokenForRepo(
        path: Operations.ActionsCreateRemoveTokenForRepo.Input.Path,
        headers: Operations.ActionsCreateRemoveTokenForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsCreateRemoveTokenForRepo.Output {
        try await actionsCreateRemoveTokenForRepo(Operations.ActionsCreateRemoveTokenForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a self-hosted runner for a repository
    ///
    /// Gets a specific self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/get(actions/get-self-hosted-runner-for-repo)`.
    public func actionsGetSelfHostedRunnerForRepo(
        path: Operations.ActionsGetSelfHostedRunnerForRepo.Input.Path,
        headers: Operations.ActionsGetSelfHostedRunnerForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetSelfHostedRunnerForRepo.Output {
        try await actionsGetSelfHostedRunnerForRepo(Operations.ActionsGetSelfHostedRunnerForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a self-hosted runner from a repository
    ///
    /// Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/delete(actions/delete-self-hosted-runner-from-repo)`.
    public func actionsDeleteSelfHostedRunnerFromRepo(
        path: Operations.ActionsDeleteSelfHostedRunnerFromRepo.Input.Path,
        headers: Operations.ActionsDeleteSelfHostedRunnerFromRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsDeleteSelfHostedRunnerFromRepo.Output {
        try await actionsDeleteSelfHostedRunnerFromRepo(Operations.ActionsDeleteSelfHostedRunnerFromRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// List labels for a self-hosted runner for a repository
    ///
    /// Lists all labels for a self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/get(actions/list-labels-for-self-hosted-runner-for-repo)`.
    public func actionsListLabelsForSelfHostedRunnerForRepo(
        path: Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Input.Path,
        headers: Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Output {
        try await actionsListLabelsForSelfHostedRunnerForRepo(Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add custom labels to a self-hosted runner for a repository
    ///
    /// Adds custom labels to a self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/post(actions/add-custom-labels-to-self-hosted-runner-for-repo)`.
    public func actionsAddCustomLabelsToSelfHostedRunnerForRepo(
        path: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Input.Path,
        headers: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Input.Headers = .init(),
        body: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Input.Body
    ) async throws -> Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Output {
        try await actionsAddCustomLabelsToSelfHostedRunnerForRepo(Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set custom labels for a self-hosted runner for a repository
    ///
    /// Remove all previous custom labels and set the new custom labels for a specific
    /// self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/put(actions/set-custom-labels-for-self-hosted-runner-for-repo)`.
    public func actionsSetCustomLabelsForSelfHostedRunnerForRepo(
        path: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Input.Path,
        headers: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Input.Headers = .init(),
        body: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Input.Body
    ) async throws -> Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Output {
        try await actionsSetCustomLabelsForSelfHostedRunnerForRepo(Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove all custom labels from a self-hosted runner for a repository
    ///
    /// Remove all custom labels from a self-hosted runner configured in a
    /// repository. Returns the remaining read-only labels from the runner.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/delete(actions/remove-all-custom-labels-from-self-hosted-runner-for-repo)`.
    public func actionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo(
        path: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Input.Path,
        headers: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Output {
        try await actionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo(Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove a custom label from a self-hosted runner for a repository
    ///
    /// Remove a custom label from a self-hosted runner configured
    /// in a repository. Returns the remaining labels from the runner.
    ///
    /// This endpoint returns a `404 Not Found` status if the custom label is not
    /// present on the runner.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}/delete(actions/remove-custom-label-from-self-hosted-runner-for-repo)`.
    public func actionsRemoveCustomLabelFromSelfHostedRunnerForRepo(
        path: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Input.Path,
        headers: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Output {
        try await actionsRemoveCustomLabelFromSelfHostedRunnerForRepo(Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// List workflow runs for a repository
    ///
    /// Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/get(actions/list-workflow-runs-for-repo)`.
    public func actionsListWorkflowRunsForRepo(
        path: Operations.ActionsListWorkflowRunsForRepo.Input.Path,
        query: Operations.ActionsListWorkflowRunsForRepo.Input.Query = .init(),
        headers: Operations.ActionsListWorkflowRunsForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActionsListWorkflowRunsForRepo.Output {
        try await actionsListWorkflowRunsForRepo(Operations.ActionsListWorkflowRunsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a workflow run
    ///
    /// Gets a specific workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/get(actions/get-workflow-run)`.
    public func actionsGetWorkflowRun(
        path: Operations.ActionsGetWorkflowRun.Input.Path,
        query: Operations.ActionsGetWorkflowRun.Input.Query = .init(),
        headers: Operations.ActionsGetWorkflowRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetWorkflowRun.Output {
        try await actionsGetWorkflowRun(Operations.ActionsGetWorkflowRun.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Delete a workflow run
    ///
    /// Deletes a specific workflow run.
    ///
    /// Anyone with write access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/delete(actions/delete-workflow-run)`.
    public func actionsDeleteWorkflowRun(path: Operations.ActionsDeleteWorkflowRun.Input.Path) async throws -> Operations.ActionsDeleteWorkflowRun.Output {
        try await actionsDeleteWorkflowRun(Operations.ActionsDeleteWorkflowRun.Input(path: path))
    }
    /// Get the review history for a workflow run
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/approvals`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/approvals/get(actions/get-reviews-for-run)`.
    public func actionsGetReviewsForRun(
        path: Operations.ActionsGetReviewsForRun.Input.Path,
        headers: Operations.ActionsGetReviewsForRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetReviewsForRun.Output {
        try await actionsGetReviewsForRun(Operations.ActionsGetReviewsForRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// Approve a workflow run for a fork pull request
    ///
    /// Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/approve`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/approve/post(actions/approve-workflow-run)`.
    public func actionsApproveWorkflowRun(
        path: Operations.ActionsApproveWorkflowRun.Input.Path,
        headers: Operations.ActionsApproveWorkflowRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsApproveWorkflowRun.Output {
        try await actionsApproveWorkflowRun(Operations.ActionsApproveWorkflowRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// List workflow run artifacts
    ///
    /// Lists artifacts for a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/artifacts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/artifacts/get(actions/list-workflow-run-artifacts)`.
    public func actionsListWorkflowRunArtifacts(
        path: Operations.ActionsListWorkflowRunArtifacts.Input.Path,
        query: Operations.ActionsListWorkflowRunArtifacts.Input.Query = .init(),
        headers: Operations.ActionsListWorkflowRunArtifacts.Input.Headers = .init()
    ) async throws -> Operations.ActionsListWorkflowRunArtifacts.Output {
        try await actionsListWorkflowRunArtifacts(Operations.ActionsListWorkflowRunArtifacts.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a workflow run attempt
    ///
    /// Gets a specific workflow run attempt.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/get(actions/get-workflow-run-attempt)`.
    public func actionsGetWorkflowRunAttempt(
        path: Operations.ActionsGetWorkflowRunAttempt.Input.Path,
        query: Operations.ActionsGetWorkflowRunAttempt.Input.Query = .init(),
        headers: Operations.ActionsGetWorkflowRunAttempt.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetWorkflowRunAttempt.Output {
        try await actionsGetWorkflowRunAttempt(Operations.ActionsGetWorkflowRunAttempt.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List jobs for a workflow run attempt
    ///
    /// Lists jobs for a specific workflow run attempt. You can use parameters to narrow the list of results. For more information
    /// about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint  with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs/get(actions/list-jobs-for-workflow-run-attempt)`.
    public func actionsListJobsForWorkflowRunAttempt(
        path: Operations.ActionsListJobsForWorkflowRunAttempt.Input.Path,
        query: Operations.ActionsListJobsForWorkflowRunAttempt.Input.Query = .init(),
        headers: Operations.ActionsListJobsForWorkflowRunAttempt.Input.Headers = .init()
    ) async throws -> Operations.ActionsListJobsForWorkflowRunAttempt.Output {
        try await actionsListJobsForWorkflowRunAttempt(Operations.ActionsListJobsForWorkflowRunAttempt.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Download workflow run attempt logs
    ///
    /// Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
    /// 1 minute. Look for `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs/get(actions/download-workflow-run-attempt-logs)`.
    public func actionsDownloadWorkflowRunAttemptLogs(path: Operations.ActionsDownloadWorkflowRunAttemptLogs.Input.Path) async throws -> Operations.ActionsDownloadWorkflowRunAttemptLogs.Output {
        try await actionsDownloadWorkflowRunAttemptLogs(Operations.ActionsDownloadWorkflowRunAttemptLogs.Input(path: path))
    }
    /// Cancel a workflow run
    ///
    /// Cancels a workflow run using its `id`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/cancel/post(actions/cancel-workflow-run)`.
    public func actionsCancelWorkflowRun(
        path: Operations.ActionsCancelWorkflowRun.Input.Path,
        headers: Operations.ActionsCancelWorkflowRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsCancelWorkflowRun.Output {
        try await actionsCancelWorkflowRun(Operations.ActionsCancelWorkflowRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// Review custom deployment protection rules for a workflow run
    ///
    /// Approve or reject custom deployment protection rules provided by a GitHub App for a workflow run. For more information, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// > [!NOTE]
    /// > GitHub Apps can only review their own custom deployment protection rules. To approve or reject pending deployments that are waiting for review from a specific person or team, see [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`](/rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule/post(actions/review-custom-gates-for-run)`.
    public func actionsReviewCustomGatesForRun(
        path: Operations.ActionsReviewCustomGatesForRun.Input.Path,
        body: Operations.ActionsReviewCustomGatesForRun.Input.Body
    ) async throws -> Operations.ActionsReviewCustomGatesForRun.Output {
        try await actionsReviewCustomGatesForRun(Operations.ActionsReviewCustomGatesForRun.Input(
            path: path,
            body: body
        ))
    }
    /// Force cancel a workflow run
    ///
    /// Cancels a workflow run and bypasses conditions that would otherwise cause a workflow execution to continue, such as an `always()` condition on a job.
    /// You should only use this endpoint to cancel a workflow run when the workflow run is not responding to [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`](/rest/actions/workflow-runs#cancel-a-workflow-run).
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel/post(actions/force-cancel-workflow-run)`.
    public func actionsForceCancelWorkflowRun(
        path: Operations.ActionsForceCancelWorkflowRun.Input.Path,
        headers: Operations.ActionsForceCancelWorkflowRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsForceCancelWorkflowRun.Output {
        try await actionsForceCancelWorkflowRun(Operations.ActionsForceCancelWorkflowRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// List jobs for a workflow run
    ///
    /// Lists jobs for a workflow run. You can use parameters to narrow the list of results. For more information
    /// about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/jobs/get(actions/list-jobs-for-workflow-run)`.
    public func actionsListJobsForWorkflowRun(
        path: Operations.ActionsListJobsForWorkflowRun.Input.Path,
        query: Operations.ActionsListJobsForWorkflowRun.Input.Query = .init(),
        headers: Operations.ActionsListJobsForWorkflowRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsListJobsForWorkflowRun.Output {
        try await actionsListJobsForWorkflowRun(Operations.ActionsListJobsForWorkflowRun.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Download workflow run logs
    ///
    /// Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
    /// `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/logs/get(actions/download-workflow-run-logs)`.
    public func actionsDownloadWorkflowRunLogs(path: Operations.ActionsDownloadWorkflowRunLogs.Input.Path) async throws -> Operations.ActionsDownloadWorkflowRunLogs.Output {
        try await actionsDownloadWorkflowRunLogs(Operations.ActionsDownloadWorkflowRunLogs.Input(path: path))
    }
    /// Delete workflow run logs
    ///
    /// Deletes all logs for a workflow run.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runs/{run_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/logs/delete(actions/delete-workflow-run-logs)`.
    public func actionsDeleteWorkflowRunLogs(
        path: Operations.ActionsDeleteWorkflowRunLogs.Input.Path,
        headers: Operations.ActionsDeleteWorkflowRunLogs.Input.Headers = .init()
    ) async throws -> Operations.ActionsDeleteWorkflowRunLogs.Output {
        try await actionsDeleteWorkflowRunLogs(Operations.ActionsDeleteWorkflowRunLogs.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get pending deployments for a workflow run
    ///
    /// Get all deployment environments for a workflow run that are waiting for protection rules to pass.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments/get(actions/get-pending-deployments-for-run)`.
    public func actionsGetPendingDeploymentsForRun(
        path: Operations.ActionsGetPendingDeploymentsForRun.Input.Path,
        headers: Operations.ActionsGetPendingDeploymentsForRun.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetPendingDeploymentsForRun.Output {
        try await actionsGetPendingDeploymentsForRun(Operations.ActionsGetPendingDeploymentsForRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// Review pending deployments for a workflow run
    ///
    /// Approve or reject pending deployments that are waiting on approval by a required reviewer.
    ///
    /// Required reviewers with read access to the repository contents and deployments can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments/post(actions/review-pending-deployments-for-run)`.
    public func actionsReviewPendingDeploymentsForRun(
        path: Operations.ActionsReviewPendingDeploymentsForRun.Input.Path,
        headers: Operations.ActionsReviewPendingDeploymentsForRun.Input.Headers = .init(),
        body: Operations.ActionsReviewPendingDeploymentsForRun.Input.Body
    ) async throws -> Operations.ActionsReviewPendingDeploymentsForRun.Output {
        try await actionsReviewPendingDeploymentsForRun(Operations.ActionsReviewPendingDeploymentsForRun.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Re-run a workflow
    ///
    /// Re-runs your workflow run using its `id`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/rerun/post(actions/re-run-workflow)`.
    public func actionsReRunWorkflow(
        path: Operations.ActionsReRunWorkflow.Input.Path,
        headers: Operations.ActionsReRunWorkflow.Input.Headers = .init(),
        body: Operations.ActionsReRunWorkflow.Input.Body? = nil
    ) async throws -> Operations.ActionsReRunWorkflow.Output {
        try await actionsReRunWorkflow(Operations.ActionsReRunWorkflow.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Re-run failed jobs from a workflow run
    ///
    /// Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs/post(actions/re-run-workflow-failed-jobs)`.
    public func actionsReRunWorkflowFailedJobs(
        path: Operations.ActionsReRunWorkflowFailedJobs.Input.Path,
        headers: Operations.ActionsReRunWorkflowFailedJobs.Input.Headers = .init(),
        body: Operations.ActionsReRunWorkflowFailedJobs.Input.Body? = nil
    ) async throws -> Operations.ActionsReRunWorkflowFailedJobs.Output {
        try await actionsReRunWorkflowFailedJobs(Operations.ActionsReRunWorkflowFailedJobs.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get workflow run usage
    ///
    /// > [!WARNING]  
    /// > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.
    ///
    /// Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/timing`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/timing/get(actions/get-workflow-run-usage)`.
    public func actionsGetWorkflowRunUsage(
        path: Operations.ActionsGetWorkflowRunUsage.Input.Path,
        headers: Operations.ActionsGetWorkflowRunUsage.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetWorkflowRunUsage.Output {
        try await actionsGetWorkflowRunUsage(Operations.ActionsGetWorkflowRunUsage.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/get(actions/list-repo-secrets)`.
    public func actionsListRepoSecrets(
        path: Operations.ActionsListRepoSecrets.Input.Path,
        query: Operations.ActionsListRepoSecrets.Input.Query = .init(),
        headers: Operations.ActionsListRepoSecrets.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRepoSecrets.Output {
        try await actionsListRepoSecrets(Operations.ActionsListRepoSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/public-key/get(actions/get-repo-public-key)`.
    public func actionsGetRepoPublicKey(
        path: Operations.ActionsGetRepoPublicKey.Input.Path,
        headers: Operations.ActionsGetRepoPublicKey.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetRepoPublicKey.Output {
        try await actionsGetRepoPublicKey(Operations.ActionsGetRepoPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value.
    ///
    /// The authenticated user must have collaborator access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/get(actions/get-repo-secret)`.
    public func actionsGetRepoSecret(
        path: Operations.ActionsGetRepoSecret.Input.Path,
        headers: Operations.ActionsGetRepoSecret.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetRepoSecret.Output {
        try await actionsGetRepoSecret(Operations.ActionsGetRepoSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/put(actions/create-or-update-repo-secret)`.
    public func actionsCreateOrUpdateRepoSecret(
        path: Operations.ActionsCreateOrUpdateRepoSecret.Input.Path,
        headers: Operations.ActionsCreateOrUpdateRepoSecret.Input.Headers = .init(),
        body: Operations.ActionsCreateOrUpdateRepoSecret.Input.Body
    ) async throws -> Operations.ActionsCreateOrUpdateRepoSecret.Output {
        try await actionsCreateOrUpdateRepoSecret(Operations.ActionsCreateOrUpdateRepoSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/delete(actions/delete-repo-secret)`.
    public func actionsDeleteRepoSecret(path: Operations.ActionsDeleteRepoSecret.Input.Path) async throws -> Operations.ActionsDeleteRepoSecret.Output {
        try await actionsDeleteRepoSecret(Operations.ActionsDeleteRepoSecret.Input(path: path))
    }
    /// List repository variables
    ///
    /// Lists all repository variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/get(actions/list-repo-variables)`.
    public func actionsListRepoVariables(
        path: Operations.ActionsListRepoVariables.Input.Path,
        query: Operations.ActionsListRepoVariables.Input.Query = .init(),
        headers: Operations.ActionsListRepoVariables.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRepoVariables.Output {
        try await actionsListRepoVariables(Operations.ActionsListRepoVariables.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a repository variable
    ///
    /// Creates a repository variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/post(actions/create-repo-variable)`.
    public func actionsCreateRepoVariable(
        path: Operations.ActionsCreateRepoVariable.Input.Path,
        headers: Operations.ActionsCreateRepoVariable.Input.Headers = .init(),
        body: Operations.ActionsCreateRepoVariable.Input.Body
    ) async throws -> Operations.ActionsCreateRepoVariable.Output {
        try await actionsCreateRepoVariable(Operations.ActionsCreateRepoVariable.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a repository variable
    ///
    /// Gets a specific variable in a repository.
    ///
    /// The authenticated user must have collaborator access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/get(actions/get-repo-variable)`.
    public func actionsGetRepoVariable(
        path: Operations.ActionsGetRepoVariable.Input.Path,
        headers: Operations.ActionsGetRepoVariable.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetRepoVariable.Output {
        try await actionsGetRepoVariable(Operations.ActionsGetRepoVariable.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a repository variable
    ///
    /// Updates a repository variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/patch(actions/update-repo-variable)`.
    public func actionsUpdateRepoVariable(
        path: Operations.ActionsUpdateRepoVariable.Input.Path,
        body: Operations.ActionsUpdateRepoVariable.Input.Body
    ) async throws -> Operations.ActionsUpdateRepoVariable.Output {
        try await actionsUpdateRepoVariable(Operations.ActionsUpdateRepoVariable.Input(
            path: path,
            body: body
        ))
    }
    /// Delete a repository variable
    ///
    /// Deletes a repository variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/delete(actions/delete-repo-variable)`.
    public func actionsDeleteRepoVariable(path: Operations.ActionsDeleteRepoVariable.Input.Path) async throws -> Operations.ActionsDeleteRepoVariable.Output {
        try await actionsDeleteRepoVariable(Operations.ActionsDeleteRepoVariable.Input(path: path))
    }
    /// List repository workflows
    ///
    /// Lists the workflows in a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/get(actions/list-repo-workflows)`.
    public func actionsListRepoWorkflows(
        path: Operations.ActionsListRepoWorkflows.Input.Path,
        query: Operations.ActionsListRepoWorkflows.Input.Query = .init(),
        headers: Operations.ActionsListRepoWorkflows.Input.Headers = .init()
    ) async throws -> Operations.ActionsListRepoWorkflows.Output {
        try await actionsListRepoWorkflows(Operations.ActionsListRepoWorkflows.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a workflow
    ///
    /// Gets a specific workflow. You can replace `workflow_id` with the workflow
    /// file name. For example, you could use `main.yaml`.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/get(actions/get-workflow)`.
    public func actionsGetWorkflow(
        path: Operations.ActionsGetWorkflow.Input.Path,
        headers: Operations.ActionsGetWorkflow.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetWorkflow.Output {
        try await actionsGetWorkflow(Operations.ActionsGetWorkflow.Input(
            path: path,
            headers: headers
        ))
    }
    /// Disable a workflow
    ///
    /// Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable/put(actions/disable-workflow)`.
    public func actionsDisableWorkflow(path: Operations.ActionsDisableWorkflow.Input.Path) async throws -> Operations.ActionsDisableWorkflow.Output {
        try await actionsDisableWorkflow(Operations.ActionsDisableWorkflow.Input(path: path))
    }
    /// Create a workflow dispatch event
    ///
    /// You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches/post(actions/create-workflow-dispatch)`.
    public func actionsCreateWorkflowDispatch(
        path: Operations.ActionsCreateWorkflowDispatch.Input.Path,
        body: Operations.ActionsCreateWorkflowDispatch.Input.Body
    ) async throws -> Operations.ActionsCreateWorkflowDispatch.Output {
        try await actionsCreateWorkflowDispatch(Operations.ActionsCreateWorkflowDispatch.Input(
            path: path,
            body: body
        ))
    }
    /// Enable a workflow
    ///
    /// Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable/put(actions/enable-workflow)`.
    public func actionsEnableWorkflow(path: Operations.ActionsEnableWorkflow.Input.Path) async throws -> Operations.ActionsEnableWorkflow.Output {
        try await actionsEnableWorkflow(Operations.ActionsEnableWorkflow.Input(path: path))
    }
    /// List workflow runs for a workflow
    ///
    /// List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs/get(actions/list-workflow-runs)`.
    public func actionsListWorkflowRuns(
        path: Operations.ActionsListWorkflowRuns.Input.Path,
        query: Operations.ActionsListWorkflowRuns.Input.Query = .init(),
        headers: Operations.ActionsListWorkflowRuns.Input.Headers = .init()
    ) async throws -> Operations.ActionsListWorkflowRuns.Output {
        try await actionsListWorkflowRuns(Operations.ActionsListWorkflowRuns.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get workflow usage
    ///
    /// > [!WARNING]  
    /// > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.
    ///
    /// Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing/get(actions/get-workflow-usage)`.
    public func actionsGetWorkflowUsage(
        path: Operations.ActionsGetWorkflowUsage.Input.Path,
        headers: Operations.ActionsGetWorkflowUsage.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetWorkflowUsage.Output {
        try await actionsGetWorkflowUsage(Operations.ActionsGetWorkflowUsage.Input(
            path: path,
            headers: headers
        ))
    }
    /// List environment secrets
    ///
    /// Lists all secrets available in an environment without revealing their
    /// encrypted values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/get(actions/list-environment-secrets)`.
    public func actionsListEnvironmentSecrets(
        path: Operations.ActionsListEnvironmentSecrets.Input.Path,
        query: Operations.ActionsListEnvironmentSecrets.Input.Query = .init(),
        headers: Operations.ActionsListEnvironmentSecrets.Input.Headers = .init()
    ) async throws -> Operations.ActionsListEnvironmentSecrets.Output {
        try await actionsListEnvironmentSecrets(Operations.ActionsListEnvironmentSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an environment public key
    ///
    /// Get the public key for an environment, which you need to encrypt environment
    /// secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key/get(actions/get-environment-public-key)`.
    public func actionsGetEnvironmentPublicKey(
        path: Operations.ActionsGetEnvironmentPublicKey.Input.Path,
        headers: Operations.ActionsGetEnvironmentPublicKey.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetEnvironmentPublicKey.Output {
        try await actionsGetEnvironmentPublicKey(Operations.ActionsGetEnvironmentPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get an environment secret
    ///
    /// Gets a single environment secret without revealing its encrypted value.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/get(actions/get-environment-secret)`.
    public func actionsGetEnvironmentSecret(
        path: Operations.ActionsGetEnvironmentSecret.Input.Path,
        headers: Operations.ActionsGetEnvironmentSecret.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetEnvironmentSecret.Output {
        try await actionsGetEnvironmentSecret(Operations.ActionsGetEnvironmentSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update an environment secret
    ///
    /// Creates or updates an environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/put(actions/create-or-update-environment-secret)`.
    public func actionsCreateOrUpdateEnvironmentSecret(
        path: Operations.ActionsCreateOrUpdateEnvironmentSecret.Input.Path,
        headers: Operations.ActionsCreateOrUpdateEnvironmentSecret.Input.Headers = .init(),
        body: Operations.ActionsCreateOrUpdateEnvironmentSecret.Input.Body
    ) async throws -> Operations.ActionsCreateOrUpdateEnvironmentSecret.Output {
        try await actionsCreateOrUpdateEnvironmentSecret(Operations.ActionsCreateOrUpdateEnvironmentSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an environment secret
    ///
    /// Deletes a secret in an environment using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/delete(actions/delete-environment-secret)`.
    public func actionsDeleteEnvironmentSecret(path: Operations.ActionsDeleteEnvironmentSecret.Input.Path) async throws -> Operations.ActionsDeleteEnvironmentSecret.Output {
        try await actionsDeleteEnvironmentSecret(Operations.ActionsDeleteEnvironmentSecret.Input(path: path))
    }
    /// List environment variables
    ///
    /// Lists all environment variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/get(actions/list-environment-variables)`.
    public func actionsListEnvironmentVariables(
        path: Operations.ActionsListEnvironmentVariables.Input.Path,
        query: Operations.ActionsListEnvironmentVariables.Input.Query = .init(),
        headers: Operations.ActionsListEnvironmentVariables.Input.Headers = .init()
    ) async throws -> Operations.ActionsListEnvironmentVariables.Output {
        try await actionsListEnvironmentVariables(Operations.ActionsListEnvironmentVariables.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an environment variable
    ///
    /// Create an environment variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/post(actions/create-environment-variable)`.
    public func actionsCreateEnvironmentVariable(
        path: Operations.ActionsCreateEnvironmentVariable.Input.Path,
        headers: Operations.ActionsCreateEnvironmentVariable.Input.Headers = .init(),
        body: Operations.ActionsCreateEnvironmentVariable.Input.Body
    ) async throws -> Operations.ActionsCreateEnvironmentVariable.Output {
        try await actionsCreateEnvironmentVariable(Operations.ActionsCreateEnvironmentVariable.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get an environment variable
    ///
    /// Gets a specific variable in an environment.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/get(actions/get-environment-variable)`.
    public func actionsGetEnvironmentVariable(
        path: Operations.ActionsGetEnvironmentVariable.Input.Path,
        headers: Operations.ActionsGetEnvironmentVariable.Input.Headers = .init()
    ) async throws -> Operations.ActionsGetEnvironmentVariable.Output {
        try await actionsGetEnvironmentVariable(Operations.ActionsGetEnvironmentVariable.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an environment variable
    ///
    /// Updates an environment variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/patch(actions/update-environment-variable)`.
    public func actionsUpdateEnvironmentVariable(
        path: Operations.ActionsUpdateEnvironmentVariable.Input.Path,
        body: Operations.ActionsUpdateEnvironmentVariable.Input.Body
    ) async throws -> Operations.ActionsUpdateEnvironmentVariable.Output {
        try await actionsUpdateEnvironmentVariable(Operations.ActionsUpdateEnvironmentVariable.Input(
            path: path,
            body: body
        ))
    }
    /// Delete an environment variable
    ///
    /// Deletes an environment variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/delete(actions/delete-environment-variable)`.
    public func actionsDeleteEnvironmentVariable(path: Operations.ActionsDeleteEnvironmentVariable.Input.Path) async throws -> Operations.ActionsDeleteEnvironmentVariable.Output {
        try await actionsDeleteEnvironmentVariable(Operations.ActionsDeleteEnvironmentVariable.Input(path: path))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-integration`.
        public struct NullableIntegration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            public var owner: Components.Schemas.NullableIntegration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public var permissions: Components.Schemas.NullableIntegration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `NullableIntegration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.NullableIntegration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.NullableIntegration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-cache-usage-org-enterprise`.
        public struct ActionsCacheUsageOrgEnterprise: Codable, Hashable, Sendable {
            /// The count of active caches across all repositories of an enterprise or an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-usage-org-enterprise/total_active_caches_count`.
            public var totalActiveCachesCount: Swift.Int
            /// The total size in bytes of all active cache items across all repositories of an enterprise or an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-usage-org-enterprise/total_active_caches_size_in_bytes`.
            public var totalActiveCachesSizeInBytes: Swift.Int
            /// Creates a new `ActionsCacheUsageOrgEnterprise`.
            ///
            /// - Parameters:
            ///   - totalActiveCachesCount: The count of active caches across all repositories of an enterprise or an organization.
            ///   - totalActiveCachesSizeInBytes: The total size in bytes of all active cache items across all repositories of an enterprise or an organization.
            public init(
                totalActiveCachesCount: Swift.Int,
                totalActiveCachesSizeInBytes: Swift.Int
            ) {
                self.totalActiveCachesCount = totalActiveCachesCount
                self.totalActiveCachesSizeInBytes = totalActiveCachesSizeInBytes
            }
            public enum CodingKeys: String, CodingKey {
                case totalActiveCachesCount = "total_active_caches_count"
                case totalActiveCachesSizeInBytes = "total_active_caches_size_in_bytes"
            }
        }
        /// GitHub Actions Cache Usage by repository.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-cache-usage-by-repository`.
        public struct ActionsCacheUsageByRepository: Codable, Hashable, Sendable {
            /// The repository owner and name for the cache usage being shown.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-usage-by-repository/full_name`.
            public var fullName: Swift.String
            /// The sum of the size in bytes of all the active cache items in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-usage-by-repository/active_caches_size_in_bytes`.
            public var activeCachesSizeInBytes: Swift.Int
            /// The number of active caches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-usage-by-repository/active_caches_count`.
            public var activeCachesCount: Swift.Int
            /// Creates a new `ActionsCacheUsageByRepository`.
            ///
            /// - Parameters:
            ///   - fullName: The repository owner and name for the cache usage being shown.
            ///   - activeCachesSizeInBytes: The sum of the size in bytes of all the active cache items in the repository.
            ///   - activeCachesCount: The number of active caches in the repository.
            public init(
                fullName: Swift.String,
                activeCachesSizeInBytes: Swift.Int,
                activeCachesCount: Swift.Int
            ) {
                self.fullName = fullName
                self.activeCachesSizeInBytes = activeCachesSizeInBytes
                self.activeCachesCount = activeCachesCount
            }
            public enum CodingKeys: String, CodingKey {
                case fullName = "full_name"
                case activeCachesSizeInBytes = "active_caches_size_in_bytes"
                case activeCachesCount = "active_caches_count"
            }
        }
        /// Provides details of a hosted runner image
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-actions-hosted-runner-pool-image`.
        public struct NullableActionsHostedRunnerPoolImage: Codable, Hashable, Sendable {
            /// The ID of the image. Use this ID for the `image` parameter when creating a new larger runner.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-actions-hosted-runner-pool-image/id`.
            public var id: Swift.String
            /// Image size in GB.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-actions-hosted-runner-pool-image/size_gb`.
            public var sizeGb: Swift.Int
            /// Display name for this image.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-actions-hosted-runner-pool-image/display_name`.
            public var displayName: Swift.String
            /// The image provider.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-actions-hosted-runner-pool-image/source`.
            @frozen public enum SourcePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case github = "github"
                case partner = "partner"
                case custom = "custom"
            }
            /// The image provider.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-actions-hosted-runner-pool-image/source`.
            public var source: Components.Schemas.NullableActionsHostedRunnerPoolImage.SourcePayload
            /// Creates a new `NullableActionsHostedRunnerPoolImage`.
            ///
            /// - Parameters:
            ///   - id: The ID of the image. Use this ID for the `image` parameter when creating a new larger runner.
            ///   - sizeGb: Image size in GB.
            ///   - displayName: Display name for this image.
            ///   - source: The image provider.
            public init(
                id: Swift.String,
                sizeGb: Swift.Int,
                displayName: Swift.String,
                source: Components.Schemas.NullableActionsHostedRunnerPoolImage.SourcePayload
            ) {
                self.id = id
                self.sizeGb = sizeGb
                self.displayName = displayName
                self.source = source
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case sizeGb = "size_gb"
                case displayName = "display_name"
                case source
            }
        }
        /// Provides details of a particular machine spec.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-machine-spec`.
        public struct ActionsHostedRunnerMachineSpec: Codable, Hashable, Sendable {
            /// The ID used for the `size` parameter when creating a new runner.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-machine-spec/id`.
            public var id: Swift.String
            /// The number of cores.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-machine-spec/cpu_cores`.
            public var cpuCores: Swift.Int
            /// The available RAM for the machine spec.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-machine-spec/memory_gb`.
            public var memoryGb: Swift.Int
            /// The available SSD storage for the machine spec.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-machine-spec/storage_gb`.
            public var storageGb: Swift.Int
            /// Creates a new `ActionsHostedRunnerMachineSpec`.
            ///
            /// - Parameters:
            ///   - id: The ID used for the `size` parameter when creating a new runner.
            ///   - cpuCores: The number of cores.
            ///   - memoryGb: The available RAM for the machine spec.
            ///   - storageGb: The available SSD storage for the machine spec.
            public init(
                id: Swift.String,
                cpuCores: Swift.Int,
                memoryGb: Swift.Int,
                storageGb: Swift.Int
            ) {
                self.id = id
                self.cpuCores = cpuCores
                self.memoryGb = memoryGb
                self.storageGb = storageGb
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case cpuCores = "cpu_cores"
                case memoryGb = "memory_gb"
                case storageGb = "storage_gb"
            }
        }
        /// Provides details of Public IP for a GitHub-hosted larger runners
        ///
        /// - Remark: Generated from `#/components/schemas/public-ip`.
        public struct PublicIp: Codable, Hashable, Sendable {
            /// Whether public IP is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/public-ip/enabled`.
            public var enabled: Swift.Bool?
            /// The prefix for the public IP.
            ///
            /// - Remark: Generated from `#/components/schemas/public-ip/prefix`.
            public var prefix: Swift.String?
            /// The length of the IP prefix.
            ///
            /// - Remark: Generated from `#/components/schemas/public-ip/length`.
            public var length: Swift.Int?
            /// Creates a new `PublicIp`.
            ///
            /// - Parameters:
            ///   - enabled: Whether public IP is enabled.
            ///   - prefix: The prefix for the public IP.
            ///   - length: The length of the IP prefix.
            public init(
                enabled: Swift.Bool? = nil,
                prefix: Swift.String? = nil,
                length: Swift.Int? = nil
            ) {
                self.enabled = enabled
                self.prefix = prefix
                self.length = length
            }
            public enum CodingKeys: String, CodingKey {
                case enabled
                case prefix
                case length
            }
        }
        /// A Github-hosted hosted runner.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-hosted-runner`.
        public struct ActionsHostedRunner: Codable, Hashable, Sendable {
            /// The unique identifier of the hosted runner.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/id`.
            public var id: Swift.Int
            /// The name of the hosted runner.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/name`.
            public var name: Swift.String
            /// The unique identifier of the group that the hosted runner belongs to.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/runner_group_id`.
            public var runnerGroupId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/image_details`.
            public var imageDetails: Components.Schemas.NullableActionsHostedRunnerPoolImage?
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/machine_size_details`.
            public var machineSizeDetails: Components.Schemas.ActionsHostedRunnerMachineSpec
            /// The status of the runner.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case ready = "Ready"
                case provisioning = "Provisioning"
                case shutdown = "Shutdown"
                case deleting = "Deleting"
                case stuck = "Stuck"
            }
            /// The status of the runner.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/status`.
            public var status: Components.Schemas.ActionsHostedRunner.StatusPayload
            /// The operating system of the image.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/platform`.
            public var platform: Swift.String
            /// The maximum amount of hosted runners. Runners will not scale automatically above this number. Use this setting to limit your cost.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/maximum_runners`.
            public var maximumRunners: Swift.Int?
            /// Whether public IP is enabled for the hosted runners.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/public_ip_enabled`.
            public var publicIpEnabled: Swift.Bool
            /// The public IP ranges when public IP is enabled for the hosted runners.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/public_ips`.
            public var publicIps: [Components.Schemas.PublicIp]?
            /// The time at which the runner was last used, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner/last_active_on`.
            public var lastActiveOn: Foundation.Date?
            /// Creates a new `ActionsHostedRunner`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the hosted runner.
            ///   - name: The name of the hosted runner.
            ///   - runnerGroupId: The unique identifier of the group that the hosted runner belongs to.
            ///   - imageDetails:
            ///   - machineSizeDetails:
            ///   - status: The status of the runner.
            ///   - platform: The operating system of the image.
            ///   - maximumRunners: The maximum amount of hosted runners. Runners will not scale automatically above this number. Use this setting to limit your cost.
            ///   - publicIpEnabled: Whether public IP is enabled for the hosted runners.
            ///   - publicIps: The public IP ranges when public IP is enabled for the hosted runners.
            ///   - lastActiveOn: The time at which the runner was last used, in ISO 8601 format.
            public init(
                id: Swift.Int,
                name: Swift.String,
                runnerGroupId: Swift.Int? = nil,
                imageDetails: Components.Schemas.NullableActionsHostedRunnerPoolImage? = nil,
                machineSizeDetails: Components.Schemas.ActionsHostedRunnerMachineSpec,
                status: Components.Schemas.ActionsHostedRunner.StatusPayload,
                platform: Swift.String,
                maximumRunners: Swift.Int? = nil,
                publicIpEnabled: Swift.Bool,
                publicIps: [Components.Schemas.PublicIp]? = nil,
                lastActiveOn: Foundation.Date? = nil
            ) {
                self.id = id
                self.name = name
                self.runnerGroupId = runnerGroupId
                self.imageDetails = imageDetails
                self.machineSizeDetails = machineSizeDetails
                self.status = status
                self.platform = platform
                self.maximumRunners = maximumRunners
                self.publicIpEnabled = publicIpEnabled
                self.publicIps = publicIps
                self.lastActiveOn = lastActiveOn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case runnerGroupId = "runner_group_id"
                case imageDetails = "image_details"
                case machineSizeDetails = "machine_size_details"
                case status
                case platform
                case maximumRunners = "maximum_runners"
                case publicIpEnabled = "public_ip_enabled"
                case publicIps = "public_ips"
                case lastActiveOn = "last_active_on"
            }
        }
        /// Provides details of a hosted runner image
        ///
        /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image`.
        public struct ActionsHostedRunnerCuratedImage: Codable, Hashable, Sendable {
            /// The ID of the image. Use this ID for the `image` parameter when creating a new larger runner.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image/id`.
            public var id: Swift.String
            /// The operating system of the image.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image/platform`.
            public var platform: Swift.String
            /// Image size in GB.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image/size_gb`.
            public var sizeGb: Swift.Int
            /// Display name for this image.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image/display_name`.
            public var displayName: Swift.String
            /// The image provider.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image/source`.
            @frozen public enum SourcePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case github = "github"
                case partner = "partner"
                case custom = "custom"
            }
            /// The image provider.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-curated-image/source`.
            public var source: Components.Schemas.ActionsHostedRunnerCuratedImage.SourcePayload
            /// Creates a new `ActionsHostedRunnerCuratedImage`.
            ///
            /// - Parameters:
            ///   - id: The ID of the image. Use this ID for the `image` parameter when creating a new larger runner.
            ///   - platform: The operating system of the image.
            ///   - sizeGb: Image size in GB.
            ///   - displayName: Display name for this image.
            ///   - source: The image provider.
            public init(
                id: Swift.String,
                platform: Swift.String,
                sizeGb: Swift.Int,
                displayName: Swift.String,
                source: Components.Schemas.ActionsHostedRunnerCuratedImage.SourcePayload
            ) {
                self.id = id
                self.platform = platform
                self.sizeGb = sizeGb
                self.displayName = displayName
                self.source = source
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case platform
                case sizeGb = "size_gb"
                case displayName = "display_name"
                case source
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-limits`.
        public struct ActionsHostedRunnerLimits: Codable, Hashable, Sendable {
            /// Provides details of static public IP limits for GitHub-hosted Hosted Runners
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-limits/public_ips`.
            public struct PublicIpsPayload: Codable, Hashable, Sendable {
                /// The maximum number of static public IP addresses that can be used for Hosted Runners.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-limits/public_ips/maximum`.
                public var maximum: Swift.Int
                /// The current number of static public IP addresses in use by Hosted Runners.
                ///
                /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-limits/public_ips/current_usage`.
                public var currentUsage: Swift.Int
                /// Creates a new `PublicIpsPayload`.
                ///
                /// - Parameters:
                ///   - maximum: The maximum number of static public IP addresses that can be used for Hosted Runners.
                ///   - currentUsage: The current number of static public IP addresses in use by Hosted Runners.
                public init(
                    maximum: Swift.Int,
                    currentUsage: Swift.Int
                ) {
                    self.maximum = maximum
                    self.currentUsage = currentUsage
                }
                public enum CodingKeys: String, CodingKey {
                    case maximum
                    case currentUsage = "current_usage"
                }
            }
            /// Provides details of static public IP limits for GitHub-hosted Hosted Runners
            ///
            /// - Remark: Generated from `#/components/schemas/actions-hosted-runner-limits/public_ips`.
            public var publicIps: Components.Schemas.ActionsHostedRunnerLimits.PublicIpsPayload
            /// Creates a new `ActionsHostedRunnerLimits`.
            ///
            /// - Parameters:
            ///   - publicIps: Provides details of static public IP limits for GitHub-hosted Hosted Runners
            public init(publicIps: Components.Schemas.ActionsHostedRunnerLimits.PublicIpsPayload) {
                self.publicIps = publicIps
            }
            public enum CodingKeys: String, CodingKey {
                case publicIps = "public_ips"
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// The policy that controls the repositories in the organization that are allowed to run GitHub Actions.
        ///
        /// - Remark: Generated from `#/components/schemas/enabled-repositories`.
        @frozen public enum EnabledRepositories: String, Codable, Hashable, Sendable, CaseIterable {
            case all = "all"
            case none = "none"
            case selected = "selected"
        }
        /// The permissions policy that controls the actions and reusable workflows that are allowed to run.
        ///
        /// - Remark: Generated from `#/components/schemas/allowed-actions`.
        @frozen public enum AllowedActions: String, Codable, Hashable, Sendable, CaseIterable {
            case all = "all"
            case localOnly = "local_only"
            case selected = "selected"
        }
        /// The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.
        ///
        /// - Remark: Generated from `#/components/schemas/selected-actions-url`.
        public typealias SelectedActionsUrl = Swift.String
        /// Whether actions must be pinned to a full-length commit SHA.
        ///
        /// - Remark: Generated from `#/components/schemas/sha-pinning-required`.
        public typealias ShaPinningRequired = Swift.Bool
        /// - Remark: Generated from `#/components/schemas/actions-organization-permissions`.
        public struct ActionsOrganizationPermissions: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/actions-organization-permissions/enabled_repositories`.
            public var enabledRepositories: Components.Schemas.EnabledRepositories
            /// The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-organization-permissions/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/actions-organization-permissions/allowed_actions`.
            public var allowedActions: Components.Schemas.AllowedActions?
            /// - Remark: Generated from `#/components/schemas/actions-organization-permissions/selected_actions_url`.
            public var selectedActionsUrl: Components.Schemas.SelectedActionsUrl?
            /// - Remark: Generated from `#/components/schemas/actions-organization-permissions/sha_pinning_required`.
            public var shaPinningRequired: Components.Schemas.ShaPinningRequired?
            /// Creates a new `ActionsOrganizationPermissions`.
            ///
            /// - Parameters:
            ///   - enabledRepositories:
            ///   - selectedRepositoriesUrl: The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.
            ///   - allowedActions:
            ///   - selectedActionsUrl:
            ///   - shaPinningRequired:
            public init(
                enabledRepositories: Components.Schemas.EnabledRepositories,
                selectedRepositoriesUrl: Swift.String? = nil,
                allowedActions: Components.Schemas.AllowedActions? = nil,
                selectedActionsUrl: Components.Schemas.SelectedActionsUrl? = nil,
                shaPinningRequired: Components.Schemas.ShaPinningRequired? = nil
            ) {
                self.enabledRepositories = enabledRepositories
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
                self.allowedActions = allowedActions
                self.selectedActionsUrl = selectedActionsUrl
                self.shaPinningRequired = shaPinningRequired
            }
            public enum CodingKeys: String, CodingKey {
                case enabledRepositories = "enabled_repositories"
                case selectedRepositoriesUrl = "selected_repositories_url"
                case allowedActions = "allowed_actions"
                case selectedActionsUrl = "selected_actions_url"
                case shaPinningRequired = "sha_pinning_required"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-artifact-and-log-retention-response`.
        public struct ActionsArtifactAndLogRetentionResponse: Codable, Hashable, Sendable {
            /// The number of days artifacts and logs are retained
            ///
            /// - Remark: Generated from `#/components/schemas/actions-artifact-and-log-retention-response/days`.
            public var days: Swift.Int
            /// The maximum number of days that can be configured
            ///
            /// - Remark: Generated from `#/components/schemas/actions-artifact-and-log-retention-response/maximum_allowed_days`.
            public var maximumAllowedDays: Swift.Int
            /// Creates a new `ActionsArtifactAndLogRetentionResponse`.
            ///
            /// - Parameters:
            ///   - days: The number of days artifacts and logs are retained
            ///   - maximumAllowedDays: The maximum number of days that can be configured
            public init(
                days: Swift.Int,
                maximumAllowedDays: Swift.Int
            ) {
                self.days = days
                self.maximumAllowedDays = maximumAllowedDays
            }
            public enum CodingKeys: String, CodingKey {
                case days
                case maximumAllowedDays = "maximum_allowed_days"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-artifact-and-log-retention`.
        public struct ActionsArtifactAndLogRetention: Codable, Hashable, Sendable {
            /// The number of days to retain artifacts and logs
            ///
            /// - Remark: Generated from `#/components/schemas/actions-artifact-and-log-retention/days`.
            public var days: Swift.Int
            /// Creates a new `ActionsArtifactAndLogRetention`.
            ///
            /// - Parameters:
            ///   - days: The number of days to retain artifacts and logs
            public init(days: Swift.Int) {
                self.days = days
            }
            public enum CodingKeys: String, CodingKey {
                case days
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-fork-pr-contributor-approval`.
        public struct ActionsForkPrContributorApproval: Codable, Hashable, Sendable {
            /// The policy that controls when fork PR workflows require approval from a maintainer.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-contributor-approval/approval_policy`.
            @frozen public enum ApprovalPolicyPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case firstTimeContributorsNewToGithub = "first_time_contributors_new_to_github"
                case firstTimeContributors = "first_time_contributors"
                case allExternalContributors = "all_external_contributors"
            }
            /// The policy that controls when fork PR workflows require approval from a maintainer.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-contributor-approval/approval_policy`.
            public var approvalPolicy: Components.Schemas.ActionsForkPrContributorApproval.ApprovalPolicyPayload
            /// Creates a new `ActionsForkPrContributorApproval`.
            ///
            /// - Parameters:
            ///   - approvalPolicy: The policy that controls when fork PR workflows require approval from a maintainer.
            public init(approvalPolicy: Components.Schemas.ActionsForkPrContributorApproval.ApprovalPolicyPayload) {
                self.approvalPolicy = approvalPolicy
            }
            public enum CodingKeys: String, CodingKey {
                case approvalPolicy = "approval_policy"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos`.
        public struct ActionsForkPrWorkflowsPrivateRepos: Codable, Hashable, Sendable {
            /// Whether workflows triggered by pull requests from forks are allowed to run on private repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos/run_workflows_from_fork_pull_requests`.
            public var runWorkflowsFromForkPullRequests: Swift.Bool
            /// Whether GitHub Actions can create pull requests or submit approving pull request reviews from a workflow triggered by a fork pull request.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos/send_write_tokens_to_workflows`.
            public var sendWriteTokensToWorkflows: Swift.Bool
            /// Whether to make secrets and variables available to workflows triggered by pull requests from forks.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos/send_secrets_and_variables`.
            public var sendSecretsAndVariables: Swift.Bool
            /// Whether workflows triggered by pull requests from forks require approval from a repository administrator to run.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos/require_approval_for_fork_pr_workflows`.
            public var requireApprovalForForkPrWorkflows: Swift.Bool
            /// Creates a new `ActionsForkPrWorkflowsPrivateRepos`.
            ///
            /// - Parameters:
            ///   - runWorkflowsFromForkPullRequests: Whether workflows triggered by pull requests from forks are allowed to run on private repositories.
            ///   - sendWriteTokensToWorkflows: Whether GitHub Actions can create pull requests or submit approving pull request reviews from a workflow triggered by a fork pull request.
            ///   - sendSecretsAndVariables: Whether to make secrets and variables available to workflows triggered by pull requests from forks.
            ///   - requireApprovalForForkPrWorkflows: Whether workflows triggered by pull requests from forks require approval from a repository administrator to run.
            public init(
                runWorkflowsFromForkPullRequests: Swift.Bool,
                sendWriteTokensToWorkflows: Swift.Bool,
                sendSecretsAndVariables: Swift.Bool,
                requireApprovalForForkPrWorkflows: Swift.Bool
            ) {
                self.runWorkflowsFromForkPullRequests = runWorkflowsFromForkPullRequests
                self.sendWriteTokensToWorkflows = sendWriteTokensToWorkflows
                self.sendSecretsAndVariables = sendSecretsAndVariables
                self.requireApprovalForForkPrWorkflows = requireApprovalForForkPrWorkflows
            }
            public enum CodingKeys: String, CodingKey {
                case runWorkflowsFromForkPullRequests = "run_workflows_from_fork_pull_requests"
                case sendWriteTokensToWorkflows = "send_write_tokens_to_workflows"
                case sendSecretsAndVariables = "send_secrets_and_variables"
                case requireApprovalForForkPrWorkflows = "require_approval_for_fork_pr_workflows"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos-request`.
        public struct ActionsForkPrWorkflowsPrivateReposRequest: Codable, Hashable, Sendable {
            /// Whether workflows triggered by pull requests from forks are allowed to run on private repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos-request/run_workflows_from_fork_pull_requests`.
            public var runWorkflowsFromForkPullRequests: Swift.Bool
            /// Whether GitHub Actions can create pull requests or submit approving pull request reviews from a workflow triggered by a fork pull request.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos-request/send_write_tokens_to_workflows`.
            public var sendWriteTokensToWorkflows: Swift.Bool?
            /// Whether to make secrets and variables available to workflows triggered by pull requests from forks.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos-request/send_secrets_and_variables`.
            public var sendSecretsAndVariables: Swift.Bool?
            /// Whether workflows triggered by pull requests from forks require approval from a repository administrator to run.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-fork-pr-workflows-private-repos-request/require_approval_for_fork_pr_workflows`.
            public var requireApprovalForForkPrWorkflows: Swift.Bool?
            /// Creates a new `ActionsForkPrWorkflowsPrivateReposRequest`.
            ///
            /// - Parameters:
            ///   - runWorkflowsFromForkPullRequests: Whether workflows triggered by pull requests from forks are allowed to run on private repositories.
            ///   - sendWriteTokensToWorkflows: Whether GitHub Actions can create pull requests or submit approving pull request reviews from a workflow triggered by a fork pull request.
            ///   - sendSecretsAndVariables: Whether to make secrets and variables available to workflows triggered by pull requests from forks.
            ///   - requireApprovalForForkPrWorkflows: Whether workflows triggered by pull requests from forks require approval from a repository administrator to run.
            public init(
                runWorkflowsFromForkPullRequests: Swift.Bool,
                sendWriteTokensToWorkflows: Swift.Bool? = nil,
                sendSecretsAndVariables: Swift.Bool? = nil,
                requireApprovalForForkPrWorkflows: Swift.Bool? = nil
            ) {
                self.runWorkflowsFromForkPullRequests = runWorkflowsFromForkPullRequests
                self.sendWriteTokensToWorkflows = sendWriteTokensToWorkflows
                self.sendSecretsAndVariables = sendSecretsAndVariables
                self.requireApprovalForForkPrWorkflows = requireApprovalForForkPrWorkflows
            }
            public enum CodingKeys: String, CodingKey {
                case runWorkflowsFromForkPullRequests = "run_workflows_from_fork_pull_requests"
                case sendWriteTokensToWorkflows = "send_write_tokens_to_workflows"
                case sendSecretsAndVariables = "send_secrets_and_variables"
                case requireApprovalForForkPrWorkflows = "require_approval_for_fork_pr_workflows"
            }
        }
        /// - Remark: Generated from `#/components/schemas/selected-actions`.
        public struct SelectedActions: Codable, Hashable, Sendable {
            /// Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.
            ///
            /// - Remark: Generated from `#/components/schemas/selected-actions/github_owned_allowed`.
            public var githubOwnedAllowed: Swift.Bool?
            /// Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.
            ///
            /// - Remark: Generated from `#/components/schemas/selected-actions/verified_allowed`.
            public var verifiedAllowed: Swift.Bool?
            /// Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`.
            ///
            /// > [!NOTE]
            /// > The `patterns_allowed` setting only applies to public repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/selected-actions/patterns_allowed`.
            public var patternsAllowed: [Swift.String]?
            /// Creates a new `SelectedActions`.
            ///
            /// - Parameters:
            ///   - githubOwnedAllowed: Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.
            ///   - verifiedAllowed: Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.
            ///   - patternsAllowed: Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`.
            public init(
                githubOwnedAllowed: Swift.Bool? = nil,
                verifiedAllowed: Swift.Bool? = nil,
                patternsAllowed: [Swift.String]? = nil
            ) {
                self.githubOwnedAllowed = githubOwnedAllowed
                self.verifiedAllowed = verifiedAllowed
                self.patternsAllowed = patternsAllowed
            }
            public enum CodingKeys: String, CodingKey {
                case githubOwnedAllowed = "github_owned_allowed"
                case verifiedAllowed = "verified_allowed"
                case patternsAllowed = "patterns_allowed"
            }
        }
        /// - Remark: Generated from `#/components/schemas/self-hosted-runners-settings`.
        public struct SelfHostedRunnersSettings: Codable, Hashable, Sendable {
            /// The policy that controls whether self-hosted runners can be used by repositories in the organization
            ///
            /// - Remark: Generated from `#/components/schemas/self-hosted-runners-settings/enabled_repositories`.
            @frozen public enum EnabledRepositoriesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case selected = "selected"
                case none = "none"
            }
            /// The policy that controls whether self-hosted runners can be used by repositories in the organization
            ///
            /// - Remark: Generated from `#/components/schemas/self-hosted-runners-settings/enabled_repositories`.
            public var enabledRepositories: Components.Schemas.SelfHostedRunnersSettings.EnabledRepositoriesPayload
            /// The URL to the endpoint for managing selected repositories for self-hosted runners in the organization
            ///
            /// - Remark: Generated from `#/components/schemas/self-hosted-runners-settings/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// Creates a new `SelfHostedRunnersSettings`.
            ///
            /// - Parameters:
            ///   - enabledRepositories: The policy that controls whether self-hosted runners can be used by repositories in the organization
            ///   - selectedRepositoriesUrl: The URL to the endpoint for managing selected repositories for self-hosted runners in the organization
            public init(
                enabledRepositories: Components.Schemas.SelfHostedRunnersSettings.EnabledRepositoriesPayload,
                selectedRepositoriesUrl: Swift.String? = nil
            ) {
                self.enabledRepositories = enabledRepositories
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
            }
            public enum CodingKeys: String, CodingKey {
                case enabledRepositories = "enabled_repositories"
                case selectedRepositoriesUrl = "selected_repositories_url"
            }
        }
        /// The default workflow permissions granted to the GITHUB_TOKEN when running workflows.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-default-workflow-permissions`.
        @frozen public enum ActionsDefaultWorkflowPermissions: String, Codable, Hashable, Sendable, CaseIterable {
            case read = "read"
            case write = "write"
        }
        /// Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-can-approve-pull-request-reviews`.
        public typealias ActionsCanApprovePullRequestReviews = Swift.Bool
        /// - Remark: Generated from `#/components/schemas/actions-get-default-workflow-permissions`.
        public struct ActionsGetDefaultWorkflowPermissions: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/actions-get-default-workflow-permissions/default_workflow_permissions`.
            public var defaultWorkflowPermissions: Components.Schemas.ActionsDefaultWorkflowPermissions
            /// - Remark: Generated from `#/components/schemas/actions-get-default-workflow-permissions/can_approve_pull_request_reviews`.
            public var canApprovePullRequestReviews: Components.Schemas.ActionsCanApprovePullRequestReviews
            /// Creates a new `ActionsGetDefaultWorkflowPermissions`.
            ///
            /// - Parameters:
            ///   - defaultWorkflowPermissions:
            ///   - canApprovePullRequestReviews:
            public init(
                defaultWorkflowPermissions: Components.Schemas.ActionsDefaultWorkflowPermissions,
                canApprovePullRequestReviews: Components.Schemas.ActionsCanApprovePullRequestReviews
            ) {
                self.defaultWorkflowPermissions = defaultWorkflowPermissions
                self.canApprovePullRequestReviews = canApprovePullRequestReviews
            }
            public enum CodingKeys: String, CodingKey {
                case defaultWorkflowPermissions = "default_workflow_permissions"
                case canApprovePullRequestReviews = "can_approve_pull_request_reviews"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-set-default-workflow-permissions`.
        public struct ActionsSetDefaultWorkflowPermissions: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/actions-set-default-workflow-permissions/default_workflow_permissions`.
            public var defaultWorkflowPermissions: Components.Schemas.ActionsDefaultWorkflowPermissions?
            /// - Remark: Generated from `#/components/schemas/actions-set-default-workflow-permissions/can_approve_pull_request_reviews`.
            public var canApprovePullRequestReviews: Components.Schemas.ActionsCanApprovePullRequestReviews?
            /// Creates a new `ActionsSetDefaultWorkflowPermissions`.
            ///
            /// - Parameters:
            ///   - defaultWorkflowPermissions:
            ///   - canApprovePullRequestReviews:
            public init(
                defaultWorkflowPermissions: Components.Schemas.ActionsDefaultWorkflowPermissions? = nil,
                canApprovePullRequestReviews: Components.Schemas.ActionsCanApprovePullRequestReviews? = nil
            ) {
                self.defaultWorkflowPermissions = defaultWorkflowPermissions
                self.canApprovePullRequestReviews = canApprovePullRequestReviews
            }
            public enum CodingKeys: String, CodingKey {
                case defaultWorkflowPermissions = "default_workflow_permissions"
                case canApprovePullRequestReviews = "can_approve_pull_request_reviews"
            }
        }
        /// - Remark: Generated from `#/components/schemas/runner-groups-org`.
        public struct RunnerGroupsOrg: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/id`.
            public var id: Swift.Double
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/visibility`.
            public var visibility: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/default`.
            public var _default: Swift.Bool
            /// Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`
            ///
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/runners_url`.
            public var runnersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/hosted_runners_url`.
            public var hostedRunnersUrl: Swift.String?
            /// The identifier of a hosted compute network configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/network_configuration_id`.
            public var networkConfigurationId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/inherited`.
            public var inherited: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/inherited_allows_public_repositories`.
            public var inheritedAllowsPublicRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/allows_public_repositories`.
            public var allowsPublicRepositories: Swift.Bool
            /// If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/workflow_restrictions_read_only`.
            public var workflowRestrictionsReadOnly: Swift.Bool?
            /// If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/restricted_to_workflows`.
            public var restrictedToWorkflows: Swift.Bool?
            /// List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-groups-org/selected_workflows`.
            public var selectedWorkflows: [Swift.String]?
            /// Creates a new `RunnerGroupsOrg`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - name:
            ///   - visibility:
            ///   - _default:
            ///   - selectedRepositoriesUrl: Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`
            ///   - runnersUrl:
            ///   - hostedRunnersUrl:
            ///   - networkConfigurationId: The identifier of a hosted compute network configuration.
            ///   - inherited:
            ///   - inheritedAllowsPublicRepositories:
            ///   - allowsPublicRepositories:
            ///   - workflowRestrictionsReadOnly: If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.
            ///   - restrictedToWorkflows: If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.
            ///   - selectedWorkflows: List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.
            public init(
                id: Swift.Double,
                name: Swift.String,
                visibility: Swift.String,
                _default: Swift.Bool,
                selectedRepositoriesUrl: Swift.String? = nil,
                runnersUrl: Swift.String,
                hostedRunnersUrl: Swift.String? = nil,
                networkConfigurationId: Swift.String? = nil,
                inherited: Swift.Bool,
                inheritedAllowsPublicRepositories: Swift.Bool? = nil,
                allowsPublicRepositories: Swift.Bool,
                workflowRestrictionsReadOnly: Swift.Bool? = nil,
                restrictedToWorkflows: Swift.Bool? = nil,
                selectedWorkflows: [Swift.String]? = nil
            ) {
                self.id = id
                self.name = name
                self.visibility = visibility
                self._default = _default
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
                self.runnersUrl = runnersUrl
                self.hostedRunnersUrl = hostedRunnersUrl
                self.networkConfigurationId = networkConfigurationId
                self.inherited = inherited
                self.inheritedAllowsPublicRepositories = inheritedAllowsPublicRepositories
                self.allowsPublicRepositories = allowsPublicRepositories
                self.workflowRestrictionsReadOnly = workflowRestrictionsReadOnly
                self.restrictedToWorkflows = restrictedToWorkflows
                self.selectedWorkflows = selectedWorkflows
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case visibility
                case _default = "default"
                case selectedRepositoriesUrl = "selected_repositories_url"
                case runnersUrl = "runners_url"
                case hostedRunnersUrl = "hosted_runners_url"
                case networkConfigurationId = "network_configuration_id"
                case inherited
                case inheritedAllowsPublicRepositories = "inherited_allows_public_repositories"
                case allowsPublicRepositories = "allows_public_repositories"
                case workflowRestrictionsReadOnly = "workflow_restrictions_read_only"
                case restrictedToWorkflows = "restricted_to_workflows"
                case selectedWorkflows = "selected_workflows"
            }
        }
        /// A label for a self hosted runner
        ///
        /// - Remark: Generated from `#/components/schemas/runner-label`.
        public struct RunnerLabel: Codable, Hashable, Sendable {
            /// Unique identifier of the label.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-label/id`.
            public var id: Swift.Int?
            /// Name of the label.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-label/name`.
            public var name: Swift.String
            /// The type of label. Read-only labels are applied automatically when the runner is configured.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-label/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case readOnly = "read-only"
                case custom = "custom"
            }
            /// The type of label. Read-only labels are applied automatically when the runner is configured.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-label/type`.
            public var _type: Components.Schemas.RunnerLabel._TypePayload?
            /// Creates a new `RunnerLabel`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the label.
            ///   - name: Name of the label.
            ///   - _type: The type of label. Read-only labels are applied automatically when the runner is configured.
            public init(
                id: Swift.Int? = nil,
                name: Swift.String,
                _type: Components.Schemas.RunnerLabel._TypePayload? = nil
            ) {
                self.id = id
                self.name = name
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case _type = "type"
            }
        }
        /// A self hosted runner
        ///
        /// - Remark: Generated from `#/components/schemas/runner`.
        public struct Runner: Codable, Hashable, Sendable {
            /// The ID of the runner.
            ///
            /// - Remark: Generated from `#/components/schemas/runner/id`.
            public var id: Swift.Int
            /// The ID of the runner group.
            ///
            /// - Remark: Generated from `#/components/schemas/runner/runner_group_id`.
            public var runnerGroupId: Swift.Int?
            /// The name of the runner.
            ///
            /// - Remark: Generated from `#/components/schemas/runner/name`.
            public var name: Swift.String
            /// The Operating System of the runner.
            ///
            /// - Remark: Generated from `#/components/schemas/runner/os`.
            public var os: Swift.String
            /// The status of the runner.
            ///
            /// - Remark: Generated from `#/components/schemas/runner/status`.
            public var status: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner/busy`.
            public var busy: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/runner/labels`.
            public var labels: [Components.Schemas.RunnerLabel]
            /// - Remark: Generated from `#/components/schemas/runner/ephemeral`.
            public var ephemeral: Swift.Bool?
            /// Creates a new `Runner`.
            ///
            /// - Parameters:
            ///   - id: The ID of the runner.
            ///   - runnerGroupId: The ID of the runner group.
            ///   - name: The name of the runner.
            ///   - os: The Operating System of the runner.
            ///   - status: The status of the runner.
            ///   - busy:
            ///   - labels:
            ///   - ephemeral:
            public init(
                id: Swift.Int,
                runnerGroupId: Swift.Int? = nil,
                name: Swift.String,
                os: Swift.String,
                status: Swift.String,
                busy: Swift.Bool,
                labels: [Components.Schemas.RunnerLabel],
                ephemeral: Swift.Bool? = nil
            ) {
                self.id = id
                self.runnerGroupId = runnerGroupId
                self.name = name
                self.os = os
                self.status = status
                self.busy = busy
                self.labels = labels
                self.ephemeral = ephemeral
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case runnerGroupId = "runner_group_id"
                case name
                case os
                case status
                case busy
                case labels
                case ephemeral
            }
        }
        /// Runner Application
        ///
        /// - Remark: Generated from `#/components/schemas/runner-application`.
        public struct RunnerApplication: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/runner-application/os`.
            public var os: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner-application/architecture`.
            public var architecture: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner-application/download_url`.
            public var downloadUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/runner-application/filename`.
            public var filename: Swift.String
            /// A short lived bearer token used to download the runner, if needed.
            ///
            /// - Remark: Generated from `#/components/schemas/runner-application/temp_download_token`.
            public var tempDownloadToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/runner-application/sha256_checksum`.
            public var sha256Checksum: Swift.String?
            /// Creates a new `RunnerApplication`.
            ///
            /// - Parameters:
            ///   - os:
            ///   - architecture:
            ///   - downloadUrl:
            ///   - filename:
            ///   - tempDownloadToken: A short lived bearer token used to download the runner, if needed.
            ///   - sha256Checksum:
            public init(
                os: Swift.String,
                architecture: Swift.String,
                downloadUrl: Swift.String,
                filename: Swift.String,
                tempDownloadToken: Swift.String? = nil,
                sha256Checksum: Swift.String? = nil
            ) {
                self.os = os
                self.architecture = architecture
                self.downloadUrl = downloadUrl
                self.filename = filename
                self.tempDownloadToken = tempDownloadToken
                self.sha256Checksum = sha256Checksum
            }
            public enum CodingKeys: String, CodingKey {
                case os
                case architecture
                case downloadUrl = "download_url"
                case filename
                case tempDownloadToken = "temp_download_token"
                case sha256Checksum = "sha256_checksum"
            }
        }
        /// Authentication Token
        ///
        /// - Remark: Generated from `#/components/schemas/authentication-token`.
        public struct AuthenticationToken: Codable, Hashable, Sendable {
            /// The token used for authentication
            ///
            /// - Remark: Generated from `#/components/schemas/authentication-token/token`.
            public var token: Swift.String
            /// The time this token expires
            ///
            /// - Remark: Generated from `#/components/schemas/authentication-token/expires_at`.
            public var expiresAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/authentication-token/permissions`.
            public var permissions: OpenAPIRuntime.OpenAPIObjectContainer?
            /// The repositories this token has access to
            ///
            /// - Remark: Generated from `#/components/schemas/authentication-token/repositories`.
            public var repositories: [Components.Schemas.Repository]?
            /// - Remark: Generated from `#/components/schemas/authentication-token/single_file`.
            public var singleFile: Swift.String?
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/authentication-token/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case selected = "selected"
            }
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/authentication-token/repository_selection`.
            public var repositorySelection: Components.Schemas.AuthenticationToken.RepositorySelectionPayload?
            /// Creates a new `AuthenticationToken`.
            ///
            /// - Parameters:
            ///   - token: The token used for authentication
            ///   - expiresAt: The time this token expires
            ///   - permissions:
            ///   - repositories: The repositories this token has access to
            ///   - singleFile:
            ///   - repositorySelection: Describe whether all repositories have been selected or there's a selection involved
            public init(
                token: Swift.String,
                expiresAt: Foundation.Date,
                permissions: OpenAPIRuntime.OpenAPIObjectContainer? = nil,
                repositories: [Components.Schemas.Repository]? = nil,
                singleFile: Swift.String? = nil,
                repositorySelection: Components.Schemas.AuthenticationToken.RepositorySelectionPayload? = nil
            ) {
                self.token = token
                self.expiresAt = expiresAt
                self.permissions = permissions
                self.repositories = repositories
                self.singleFile = singleFile
                self.repositorySelection = repositorySelection
            }
            public enum CodingKeys: String, CodingKey {
                case token
                case expiresAt = "expires_at"
                case permissions
                case repositories
                case singleFile = "single_file"
                case repositorySelection = "repository_selection"
            }
        }
        /// Secrets for GitHub Actions for an organization.
        ///
        /// - Remark: Generated from `#/components/schemas/organization-actions-secret`.
        public struct OrganizationActionsSecret: Codable, Hashable, Sendable {
            /// The name of the secret.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-secret/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-actions-secret/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/organization-actions-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// Visibility of a secret
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-secret/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// Visibility of a secret
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-secret/visibility`.
            public var visibility: Components.Schemas.OrganizationActionsSecret.VisibilityPayload
            /// - Remark: Generated from `#/components/schemas/organization-actions-secret/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// Creates a new `OrganizationActionsSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - visibility: Visibility of a secret
            ///   - selectedRepositoriesUrl:
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                visibility: Components.Schemas.OrganizationActionsSecret.VisibilityPayload,
                selectedRepositoriesUrl: Swift.String? = nil
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.visibility = visibility
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case visibility
                case selectedRepositoriesUrl = "selected_repositories_url"
            }
        }
        /// The public key used for setting Actions Secrets.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-public-key`.
        public struct ActionsPublicKey: Codable, Hashable, Sendable {
            /// The identifier for the key.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-public-key/key_id`.
            public var keyId: Swift.String
            /// The Base64 encoded public key.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-public-key/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/actions-public-key/id`.
            public var id: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/actions-public-key/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/actions-public-key/title`.
            public var title: Swift.String?
            /// - Remark: Generated from `#/components/schemas/actions-public-key/created_at`.
            public var createdAt: Swift.String?
            /// Creates a new `ActionsPublicKey`.
            ///
            /// - Parameters:
            ///   - keyId: The identifier for the key.
            ///   - key: The Base64 encoded public key.
            ///   - id:
            ///   - url:
            ///   - title:
            ///   - createdAt:
            public init(
                keyId: Swift.String,
                key: Swift.String,
                id: Swift.Int? = nil,
                url: Swift.String? = nil,
                title: Swift.String? = nil,
                createdAt: Swift.String? = nil
            ) {
                self.keyId = keyId
                self.key = key
                self.id = id
                self.url = url
                self.title = title
                self.createdAt = createdAt
            }
            public enum CodingKeys: String, CodingKey {
                case keyId = "key_id"
                case key
                case id
                case url
                case title
                case createdAt = "created_at"
            }
        }
        /// Organization variable for GitHub Actions.
        ///
        /// - Remark: Generated from `#/components/schemas/organization-actions-variable`.
        public struct OrganizationActionsVariable: Codable, Hashable, Sendable {
            /// The name of the variable.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/name`.
            public var name: Swift.String
            /// The value of the variable.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/value`.
            public var value: Swift.String
            /// The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/updated_at`.
            public var updatedAt: Foundation.Date
            /// Visibility of a variable
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// Visibility of a variable
            ///
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/visibility`.
            public var visibility: Components.Schemas.OrganizationActionsVariable.VisibilityPayload
            /// - Remark: Generated from `#/components/schemas/organization-actions-variable/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// Creates a new `OrganizationActionsVariable`.
            ///
            /// - Parameters:
            ///   - name: The name of the variable.
            ///   - value: The value of the variable.
            ///   - createdAt: The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - visibility: Visibility of a variable
            ///   - selectedRepositoriesUrl:
            public init(
                name: Swift.String,
                value: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                visibility: Components.Schemas.OrganizationActionsVariable.VisibilityPayload,
                selectedRepositoriesUrl: Swift.String? = nil
            ) {
                self.name = name
                self.value = value
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.visibility = visibility
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case value
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case visibility
                case selectedRepositoriesUrl = "selected_repositories_url"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// An artifact
        ///
        /// - Remark: Generated from `#/components/schemas/artifact`.
        public struct Artifact: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/artifact/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/artifact/node_id`.
            public var nodeId: Swift.String
            /// The name of the artifact.
            ///
            /// - Remark: Generated from `#/components/schemas/artifact/name`.
            public var name: Swift.String
            /// The size in bytes of the artifact.
            ///
            /// - Remark: Generated from `#/components/schemas/artifact/size_in_bytes`.
            public var sizeInBytes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/artifact/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/artifact/archive_download_url`.
            public var archiveDownloadUrl: Swift.String
            /// Whether or not the artifact has expired.
            ///
            /// - Remark: Generated from `#/components/schemas/artifact/expired`.
            public var expired: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/artifact/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/artifact/expires_at`.
            public var expiresAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/artifact/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The SHA256 digest of the artifact. This field will only be populated on artifacts uploaded with upload-artifact v4 or newer. For older versions, this field will be null.
            ///
            /// - Remark: Generated from `#/components/schemas/artifact/digest`.
            public var digest: Swift.String?
            /// - Remark: Generated from `#/components/schemas/artifact/workflow_run`.
            public struct WorkflowRunPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/artifact/workflow_run/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/artifact/workflow_run/repository_id`.
                public var repositoryId: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/artifact/workflow_run/head_repository_id`.
                public var headRepositoryId: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/artifact/workflow_run/head_branch`.
                public var headBranch: Swift.String?
                /// - Remark: Generated from `#/components/schemas/artifact/workflow_run/head_sha`.
                public var headSha: Swift.String?
                /// Creates a new `WorkflowRunPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - repositoryId:
                ///   - headRepositoryId:
                ///   - headBranch:
                ///   - headSha:
                public init(
                    id: Swift.Int? = nil,
                    repositoryId: Swift.Int? = nil,
                    headRepositoryId: Swift.Int? = nil,
                    headBranch: Swift.String? = nil,
                    headSha: Swift.String? = nil
                ) {
                    self.id = id
                    self.repositoryId = repositoryId
                    self.headRepositoryId = headRepositoryId
                    self.headBranch = headBranch
                    self.headSha = headSha
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case repositoryId = "repository_id"
                    case headRepositoryId = "head_repository_id"
                    case headBranch = "head_branch"
                    case headSha = "head_sha"
                }
            }
            /// - Remark: Generated from `#/components/schemas/artifact/workflow_run`.
            public var workflowRun: Components.Schemas.Artifact.WorkflowRunPayload?
            /// Creates a new `Artifact`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name: The name of the artifact.
            ///   - sizeInBytes: The size in bytes of the artifact.
            ///   - url:
            ///   - archiveDownloadUrl:
            ///   - expired: Whether or not the artifact has expired.
            ///   - createdAt:
            ///   - expiresAt:
            ///   - updatedAt:
            ///   - digest: The SHA256 digest of the artifact. This field will only be populated on artifacts uploaded with upload-artifact v4 or newer. For older versions, this field will be null.
            ///   - workflowRun:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                sizeInBytes: Swift.Int,
                url: Swift.String,
                archiveDownloadUrl: Swift.String,
                expired: Swift.Bool,
                createdAt: Foundation.Date? = nil,
                expiresAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                digest: Swift.String? = nil,
                workflowRun: Components.Schemas.Artifact.WorkflowRunPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.sizeInBytes = sizeInBytes
                self.url = url
                self.archiveDownloadUrl = archiveDownloadUrl
                self.expired = expired
                self.createdAt = createdAt
                self.expiresAt = expiresAt
                self.updatedAt = updatedAt
                self.digest = digest
                self.workflowRun = workflowRun
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case sizeInBytes = "size_in_bytes"
                case url
                case archiveDownloadUrl = "archive_download_url"
                case expired
                case createdAt = "created_at"
                case expiresAt = "expires_at"
                case updatedAt = "updated_at"
                case digest
                case workflowRun = "workflow_run"
            }
        }
        /// Repository actions caches
        ///
        /// - Remark: Generated from `#/components/schemas/actions-cache-list`.
        public struct ActionsCacheList: Codable, Hashable, Sendable {
            /// Total number of caches
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-list/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload`.
            public struct ActionsCachesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/ref`.
                public var ref: Swift.String?
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/version`.
                public var version: Swift.String?
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/last_accessed_at`.
                public var lastAccessedAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/created_at`.
                public var createdAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/actions-cache-list/ActionsCachesPayload/size_in_bytes`.
                public var sizeInBytes: Swift.Int?
                /// Creates a new `ActionsCachesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - ref:
                ///   - key:
                ///   - version:
                ///   - lastAccessedAt:
                ///   - createdAt:
                ///   - sizeInBytes:
                public init(
                    id: Swift.Int? = nil,
                    ref: Swift.String? = nil,
                    key: Swift.String? = nil,
                    version: Swift.String? = nil,
                    lastAccessedAt: Foundation.Date? = nil,
                    createdAt: Foundation.Date? = nil,
                    sizeInBytes: Swift.Int? = nil
                ) {
                    self.id = id
                    self.ref = ref
                    self.key = key
                    self.version = version
                    self.lastAccessedAt = lastAccessedAt
                    self.createdAt = createdAt
                    self.sizeInBytes = sizeInBytes
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case ref
                    case key
                    case version
                    case lastAccessedAt = "last_accessed_at"
                    case createdAt = "created_at"
                    case sizeInBytes = "size_in_bytes"
                }
            }
            /// Array of caches
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-list/actions_caches`.
            public typealias ActionsCachesPayload = [Components.Schemas.ActionsCacheList.ActionsCachesPayloadPayload]
            /// Array of caches
            ///
            /// - Remark: Generated from `#/components/schemas/actions-cache-list/actions_caches`.
            public var actionsCaches: Components.Schemas.ActionsCacheList.ActionsCachesPayload
            /// Creates a new `ActionsCacheList`.
            ///
            /// - Parameters:
            ///   - totalCount: Total number of caches
            ///   - actionsCaches: Array of caches
            public init(
                totalCount: Swift.Int,
                actionsCaches: Components.Schemas.ActionsCacheList.ActionsCachesPayload
            ) {
                self.totalCount = totalCount
                self.actionsCaches = actionsCaches
            }
            public enum CodingKeys: String, CodingKey {
                case totalCount = "total_count"
                case actionsCaches = "actions_caches"
            }
        }
        /// Information of a job execution in a workflow run
        ///
        /// - Remark: Generated from `#/components/schemas/job`.
        public struct Job: Codable, Hashable, Sendable {
            /// The id of the job.
            ///
            /// - Remark: Generated from `#/components/schemas/job/id`.
            public var id: Swift.Int
            /// The id of the associated workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/job/run_id`.
            public var runId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/job/run_url`.
            public var runUrl: Swift.String
            /// Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
            ///
            /// - Remark: Generated from `#/components/schemas/job/run_attempt`.
            public var runAttempt: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/job/node_id`.
            public var nodeId: Swift.String
            /// The SHA of the commit that is being run.
            ///
            /// - Remark: Generated from `#/components/schemas/job/head_sha`.
            public var headSha: Swift.String
            /// - Remark: Generated from `#/components/schemas/job/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/job/html_url`.
            public var htmlUrl: Swift.String?
            /// The phase of the lifecycle that the job is currently in.
            ///
            /// - Remark: Generated from `#/components/schemas/job/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case queued = "queued"
                case inProgress = "in_progress"
                case completed = "completed"
                case waiting = "waiting"
                case requested = "requested"
                case pending = "pending"
            }
            /// The phase of the lifecycle that the job is currently in.
            ///
            /// - Remark: Generated from `#/components/schemas/job/status`.
            public var status: Components.Schemas.Job.StatusPayload
            /// The outcome of the job.
            ///
            /// - Remark: Generated from `#/components/schemas/job/conclusion`.
            @frozen public enum ConclusionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case success = "success"
                case failure = "failure"
                case neutral = "neutral"
                case cancelled = "cancelled"
                case skipped = "skipped"
                case timedOut = "timed_out"
                case actionRequired = "action_required"
            }
            /// The outcome of the job.
            ///
            /// - Remark: Generated from `#/components/schemas/job/conclusion`.
            public var conclusion: Components.Schemas.Job.ConclusionPayload?
            /// The time that the job created, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/job/created_at`.
            public var createdAt: Foundation.Date
            /// The time that the job started, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/job/started_at`.
            public var startedAt: Foundation.Date
            /// The time that the job finished, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/job/completed_at`.
            public var completedAt: Foundation.Date?
            /// The name of the job.
            ///
            /// - Remark: Generated from `#/components/schemas/job/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/job/StepsPayload`.
            public struct StepsPayloadPayload: Codable, Hashable, Sendable {
                /// The phase of the lifecycle that the job is currently in.
                ///
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case queued = "queued"
                    case inProgress = "in_progress"
                    case completed = "completed"
                }
                /// The phase of the lifecycle that the job is currently in.
                ///
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/status`.
                public var status: Components.Schemas.Job.StepsPayloadPayload.StatusPayload
                /// The outcome of the job.
                ///
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/conclusion`.
                public var conclusion: Swift.String?
                /// The name of the job.
                ///
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/number`.
                public var number: Swift.Int
                /// The time that the step started, in ISO 8601 format.
                ///
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/started_at`.
                public var startedAt: Foundation.Date?
                /// The time that the job finished, in ISO 8601 format.
                ///
                /// - Remark: Generated from `#/components/schemas/job/StepsPayload/completed_at`.
                public var completedAt: Foundation.Date?
                /// Creates a new `StepsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - status: The phase of the lifecycle that the job is currently in.
                ///   - conclusion: The outcome of the job.
                ///   - name: The name of the job.
                ///   - number:
                ///   - startedAt: The time that the step started, in ISO 8601 format.
                ///   - completedAt: The time that the job finished, in ISO 8601 format.
                public init(
                    status: Components.Schemas.Job.StepsPayloadPayload.StatusPayload,
                    conclusion: Swift.String? = nil,
                    name: Swift.String,
                    number: Swift.Int,
                    startedAt: Foundation.Date? = nil,
                    completedAt: Foundation.Date? = nil
                ) {
                    self.status = status
                    self.conclusion = conclusion
                    self.name = name
                    self.number = number
                    self.startedAt = startedAt
                    self.completedAt = completedAt
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                    case conclusion
                    case name
                    case number
                    case startedAt = "started_at"
                    case completedAt = "completed_at"
                }
            }
            /// Steps in this job.
            ///
            /// - Remark: Generated from `#/components/schemas/job/steps`.
            public typealias StepsPayload = [Components.Schemas.Job.StepsPayloadPayload]
            /// Steps in this job.
            ///
            /// - Remark: Generated from `#/components/schemas/job/steps`.
            public var steps: Components.Schemas.Job.StepsPayload?
            /// - Remark: Generated from `#/components/schemas/job/check_run_url`.
            public var checkRunUrl: Swift.String
            /// Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.
            ///
            /// - Remark: Generated from `#/components/schemas/job/labels`.
            public var labels: [Swift.String]
            /// The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///
            /// - Remark: Generated from `#/components/schemas/job/runner_id`.
            public var runnerId: Swift.Int?
            /// The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///
            /// - Remark: Generated from `#/components/schemas/job/runner_name`.
            public var runnerName: Swift.String?
            /// The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///
            /// - Remark: Generated from `#/components/schemas/job/runner_group_id`.
            public var runnerGroupId: Swift.Int?
            /// The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///
            /// - Remark: Generated from `#/components/schemas/job/runner_group_name`.
            public var runnerGroupName: Swift.String?
            /// The name of the workflow.
            ///
            /// - Remark: Generated from `#/components/schemas/job/workflow_name`.
            public var workflowName: Swift.String?
            /// The name of the current branch.
            ///
            /// - Remark: Generated from `#/components/schemas/job/head_branch`.
            public var headBranch: Swift.String?
            /// Creates a new `Job`.
            ///
            /// - Parameters:
            ///   - id: The id of the job.
            ///   - runId: The id of the associated workflow run.
            ///   - runUrl:
            ///   - runAttempt: Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
            ///   - nodeId:
            ///   - headSha: The SHA of the commit that is being run.
            ///   - url:
            ///   - htmlUrl:
            ///   - status: The phase of the lifecycle that the job is currently in.
            ///   - conclusion: The outcome of the job.
            ///   - createdAt: The time that the job created, in ISO 8601 format.
            ///   - startedAt: The time that the job started, in ISO 8601 format.
            ///   - completedAt: The time that the job finished, in ISO 8601 format.
            ///   - name: The name of the job.
            ///   - steps: Steps in this job.
            ///   - checkRunUrl:
            ///   - labels: Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.
            ///   - runnerId: The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///   - runnerName: The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///   - runnerGroupId: The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///   - runnerGroupName: The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
            ///   - workflowName: The name of the workflow.
            ///   - headBranch: The name of the current branch.
            public init(
                id: Swift.Int,
                runId: Swift.Int,
                runUrl: Swift.String,
                runAttempt: Swift.Int? = nil,
                nodeId: Swift.String,
                headSha: Swift.String,
                url: Swift.String,
                htmlUrl: Swift.String? = nil,
                status: Components.Schemas.Job.StatusPayload,
                conclusion: Components.Schemas.Job.ConclusionPayload? = nil,
                createdAt: Foundation.Date,
                startedAt: Foundation.Date,
                completedAt: Foundation.Date? = nil,
                name: Swift.String,
                steps: Components.Schemas.Job.StepsPayload? = nil,
                checkRunUrl: Swift.String,
                labels: [Swift.String],
                runnerId: Swift.Int? = nil,
                runnerName: Swift.String? = nil,
                runnerGroupId: Swift.Int? = nil,
                runnerGroupName: Swift.String? = nil,
                workflowName: Swift.String? = nil,
                headBranch: Swift.String? = nil
            ) {
                self.id = id
                self.runId = runId
                self.runUrl = runUrl
                self.runAttempt = runAttempt
                self.nodeId = nodeId
                self.headSha = headSha
                self.url = url
                self.htmlUrl = htmlUrl
                self.status = status
                self.conclusion = conclusion
                self.createdAt = createdAt
                self.startedAt = startedAt
                self.completedAt = completedAt
                self.name = name
                self.steps = steps
                self.checkRunUrl = checkRunUrl
                self.labels = labels
                self.runnerId = runnerId
                self.runnerName = runnerName
                self.runnerGroupId = runnerGroupId
                self.runnerGroupName = runnerGroupName
                self.workflowName = workflowName
                self.headBranch = headBranch
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case runId = "run_id"
                case runUrl = "run_url"
                case runAttempt = "run_attempt"
                case nodeId = "node_id"
                case headSha = "head_sha"
                case url
                case htmlUrl = "html_url"
                case status
                case conclusion
                case createdAt = "created_at"
                case startedAt = "started_at"
                case completedAt = "completed_at"
                case name
                case steps
                case checkRunUrl = "check_run_url"
                case labels
                case runnerId = "runner_id"
                case runnerName = "runner_name"
                case runnerGroupId = "runner_group_id"
                case runnerGroupName = "runner_group_name"
                case workflowName = "workflow_name"
                case headBranch = "head_branch"
            }
        }
        /// Actions OIDC subject customization for a repository
        ///
        /// - Remark: Generated from `#/components/schemas/oidc-custom-sub-repo`.
        public struct OidcCustomSubRepo: Codable, Hashable, Sendable {
            /// Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored.
            ///
            /// - Remark: Generated from `#/components/schemas/oidc-custom-sub-repo/use_default`.
            public var useDefault: Swift.Bool
            /// Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.
            ///
            /// - Remark: Generated from `#/components/schemas/oidc-custom-sub-repo/include_claim_keys`.
            public var includeClaimKeys: [Swift.String]?
            /// Creates a new `OidcCustomSubRepo`.
            ///
            /// - Parameters:
            ///   - useDefault: Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored.
            ///   - includeClaimKeys: Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.
            public init(
                useDefault: Swift.Bool,
                includeClaimKeys: [Swift.String]? = nil
            ) {
                self.useDefault = useDefault
                self.includeClaimKeys = includeClaimKeys
            }
            public enum CodingKeys: String, CodingKey {
                case useDefault = "use_default"
                case includeClaimKeys = "include_claim_keys"
            }
        }
        /// Set secrets for GitHub Actions.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-secret`.
        public struct ActionsSecret: Codable, Hashable, Sendable {
            /// The name of the secret.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-secret/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/actions-secret/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/actions-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `ActionsSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret.
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-variable`.
        public struct ActionsVariable: Codable, Hashable, Sendable {
            /// The name of the variable.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-variable/name`.
            public var name: Swift.String
            /// The value of the variable.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-variable/value`.
            public var value: Swift.String
            /// The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-variable/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-variable/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `ActionsVariable`.
            ///
            /// - Parameters:
            ///   - name: The name of the variable.
            ///   - value: The value of the variable.
            ///   - createdAt: The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            public init(
                name: Swift.String,
                value: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.name = name
                self.value = value
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case value
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Whether GitHub Actions is enabled on the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/actions-enabled`.
        public typealias ActionsEnabled = Swift.Bool
        /// - Remark: Generated from `#/components/schemas/actions-repository-permissions`.
        public struct ActionsRepositoryPermissions: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/actions-repository-permissions/enabled`.
            public var enabled: Components.Schemas.ActionsEnabled
            /// - Remark: Generated from `#/components/schemas/actions-repository-permissions/allowed_actions`.
            public var allowedActions: Components.Schemas.AllowedActions?
            /// - Remark: Generated from `#/components/schemas/actions-repository-permissions/selected_actions_url`.
            public var selectedActionsUrl: Components.Schemas.SelectedActionsUrl?
            /// - Remark: Generated from `#/components/schemas/actions-repository-permissions/sha_pinning_required`.
            public var shaPinningRequired: Components.Schemas.ShaPinningRequired?
            /// Creates a new `ActionsRepositoryPermissions`.
            ///
            /// - Parameters:
            ///   - enabled:
            ///   - allowedActions:
            ///   - selectedActionsUrl:
            ///   - shaPinningRequired:
            public init(
                enabled: Components.Schemas.ActionsEnabled,
                allowedActions: Components.Schemas.AllowedActions? = nil,
                selectedActionsUrl: Components.Schemas.SelectedActionsUrl? = nil,
                shaPinningRequired: Components.Schemas.ShaPinningRequired? = nil
            ) {
                self.enabled = enabled
                self.allowedActions = allowedActions
                self.selectedActionsUrl = selectedActionsUrl
                self.shaPinningRequired = shaPinningRequired
            }
            public enum CodingKeys: String, CodingKey {
                case enabled
                case allowedActions = "allowed_actions"
                case selectedActionsUrl = "selected_actions_url"
                case shaPinningRequired = "sha_pinning_required"
            }
        }
        /// - Remark: Generated from `#/components/schemas/actions-workflow-access-to-repository`.
        public struct ActionsWorkflowAccessToRepository: Codable, Hashable, Sendable {
            /// Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
            /// repository.
            ///
            /// `none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repositories only. `organization` level access allows sharing across the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-workflow-access-to-repository/access_level`.
            @frozen public enum AccessLevelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case user = "user"
                case organization = "organization"
            }
            /// Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
            /// repository.
            ///
            /// `none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repositories only. `organization` level access allows sharing across the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/actions-workflow-access-to-repository/access_level`.
            public var accessLevel: Components.Schemas.ActionsWorkflowAccessToRepository.AccessLevelPayload
            /// Creates a new `ActionsWorkflowAccessToRepository`.
            ///
            /// - Parameters:
            ///   - accessLevel: Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
            public init(accessLevel: Components.Schemas.ActionsWorkflowAccessToRepository.AccessLevelPayload) {
                self.accessLevel = accessLevel
            }
            public enum CodingKeys: String, CodingKey {
                case accessLevel = "access_level"
            }
        }
        /// A workflow referenced/reused by the initial caller workflow
        ///
        /// - Remark: Generated from `#/components/schemas/referenced-workflow`.
        public struct ReferencedWorkflow: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/referenced-workflow/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/referenced-workflow/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/referenced-workflow/ref`.
            public var ref: Swift.String?
            /// Creates a new `ReferencedWorkflow`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - sha:
            ///   - ref:
            public init(
                path: Swift.String,
                sha: Swift.String,
                ref: Swift.String? = nil
            ) {
                self.path = path
                self.sha = sha
                self.ref = ref
            }
            public enum CodingKeys: String, CodingKey {
                case path
                case sha
                case ref
            }
        }
        /// - Remark: Generated from `#/components/schemas/pull-request-minimal`.
        public struct PullRequestMinimal: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head`.
            public struct HeadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo`.
                public struct RepoPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo/id`.
                    public var id: Swift.Int64
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo/url`.
                    public var url: Swift.String
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo/name`.
                    public var name: Swift.String
                    /// Creates a new `RepoPayload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - url:
                    ///   - name:
                    public init(
                        id: Swift.Int64,
                        url: Swift.String,
                        name: Swift.String
                    ) {
                        self.id = id
                        self.url = url
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case url
                        case name
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo`.
                public var repo: Components.Schemas.PullRequestMinimal.HeadPayload.RepoPayload
                /// Creates a new `HeadPayload`.
                ///
                /// - Parameters:
                ///   - ref:
                ///   - sha:
                ///   - repo:
                public init(
                    ref: Swift.String,
                    sha: Swift.String,
                    repo: Components.Schemas.PullRequestMinimal.HeadPayload.RepoPayload
                ) {
                    self.ref = ref
                    self.sha = sha
                    self.repo = repo
                }
                public enum CodingKeys: String, CodingKey {
                    case ref
                    case sha
                    case repo
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head`.
            public var head: Components.Schemas.PullRequestMinimal.HeadPayload
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base`.
            public struct BasePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo`.
                public struct RepoPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo/id`.
                    public var id: Swift.Int64
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo/url`.
                    public var url: Swift.String
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo/name`.
                    public var name: Swift.String
                    /// Creates a new `RepoPayload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - url:
                    ///   - name:
                    public init(
                        id: Swift.Int64,
                        url: Swift.String,
                        name: Swift.String
                    ) {
                        self.id = id
                        self.url = url
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case url
                        case name
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo`.
                public var repo: Components.Schemas.PullRequestMinimal.BasePayload.RepoPayload
                /// Creates a new `BasePayload`.
                ///
                /// - Parameters:
                ///   - ref:
                ///   - sha:
                ///   - repo:
                public init(
                    ref: Swift.String,
                    sha: Swift.String,
                    repo: Components.Schemas.PullRequestMinimal.BasePayload.RepoPayload
                ) {
                    self.ref = ref
                    self.sha = sha
                    self.repo = repo
                }
                public enum CodingKeys: String, CodingKey {
                    case ref
                    case sha
                    case repo
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base`.
            public var base: Components.Schemas.PullRequestMinimal.BasePayload
            /// Creates a new `PullRequestMinimal`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - number:
            ///   - url:
            ///   - head:
            ///   - base:
            public init(
                id: Swift.Int64,
                number: Swift.Int,
                url: Swift.String,
                head: Components.Schemas.PullRequestMinimal.HeadPayload,
                base: Components.Schemas.PullRequestMinimal.BasePayload
            ) {
                self.id = id
                self.number = number
                self.url = url
                self.head = head
                self.base = base
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case number
                case url
                case head
                case base
            }
        }
        /// A commit.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-commit`.
        public struct NullableSimpleCommit: Codable, Hashable, Sendable {
            /// SHA for the commit
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/id`.
            public var id: Swift.String
            /// SHA for the commit's tree
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/tree_id`.
            public var treeId: Swift.String
            /// Message describing the purpose of the commit
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/message`.
            public var message: Swift.String
            /// Timestamp of the commit
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/timestamp`.
            public var timestamp: Foundation.Date
            /// Information about the Git author
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/author`.
            public struct AuthorPayload: Codable, Hashable, Sendable {
                /// Name of the commit's author
                ///
                /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/author/name`.
                public var name: Swift.String
                /// Git email address of the commit's author
                ///
                /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/author/email`.
                public var email: Swift.String
                /// Creates a new `AuthorPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the commit's author
                ///   - email: Git email address of the commit's author
                public init(
                    name: Swift.String,
                    email: Swift.String
                ) {
                    self.name = name
                    self.email = email
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case email
                }
            }
            /// Information about the Git author
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/author`.
            public var author: Components.Schemas.NullableSimpleCommit.AuthorPayload?
            /// Information about the Git committer
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/committer`.
            public struct CommitterPayload: Codable, Hashable, Sendable {
                /// Name of the commit's committer
                ///
                /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/committer/name`.
                public var name: Swift.String
                /// Git email address of the commit's committer
                ///
                /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/committer/email`.
                public var email: Swift.String
                /// Creates a new `CommitterPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the commit's committer
                ///   - email: Git email address of the commit's committer
                public init(
                    name: Swift.String,
                    email: Swift.String
                ) {
                    self.name = name
                    self.email = email
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case email
                }
            }
            /// Information about the Git committer
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-commit/committer`.
            public var committer: Components.Schemas.NullableSimpleCommit.CommitterPayload?
            /// Creates a new `NullableSimpleCommit`.
            ///
            /// - Parameters:
            ///   - id: SHA for the commit
            ///   - treeId: SHA for the commit's tree
            ///   - message: Message describing the purpose of the commit
            ///   - timestamp: Timestamp of the commit
            ///   - author: Information about the Git author
            ///   - committer: Information about the Git committer
            public init(
                id: Swift.String,
                treeId: Swift.String,
                message: Swift.String,
                timestamp: Foundation.Date,
                author: Components.Schemas.NullableSimpleCommit.AuthorPayload? = nil,
                committer: Components.Schemas.NullableSimpleCommit.CommitterPayload? = nil
            ) {
                self.id = id
                self.treeId = treeId
                self.message = message
                self.timestamp = timestamp
                self.author = author
                self.committer = committer
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case treeId = "tree_id"
                case message
                case timestamp
                case author
                case committer
            }
        }
        /// An invocation of a workflow
        ///
        /// - Remark: Generated from `#/components/schemas/workflow-run`.
        public struct WorkflowRun: Codable, Hashable, Sendable {
            /// The ID of the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/id`.
            public var id: Swift.Int
            /// The name of the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/workflow-run/node_id`.
            public var nodeId: Swift.String
            /// The ID of the associated check suite.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/check_suite_id`.
            public var checkSuiteId: Swift.Int?
            /// The node ID of the associated check suite.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/check_suite_node_id`.
            public var checkSuiteNodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/workflow-run/head_branch`.
            public var headBranch: Swift.String?
            /// The SHA of the head commit that points to the version of the workflow being run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/head_sha`.
            public var headSha: Swift.String
            /// The full path of the workflow
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/path`.
            public var path: Swift.String
            /// The auto incrementing run number for the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/run_number`.
            public var runNumber: Swift.Int
            /// Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/run_attempt`.
            public var runAttempt: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/workflow-run/referenced_workflows`.
            public var referencedWorkflows: [Components.Schemas.ReferencedWorkflow]?
            /// - Remark: Generated from `#/components/schemas/workflow-run/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow-run/status`.
            public var status: Swift.String?
            /// - Remark: Generated from `#/components/schemas/workflow-run/conclusion`.
            public var conclusion: Swift.String?
            /// The ID of the parent workflow.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/workflow_id`.
            public var workflowId: Swift.Int
            /// The URL to the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow-run/html_url`.
            public var htmlUrl: Swift.String
            /// Pull requests that are open with a `head_sha` or `head_branch` that matches the workflow run. The returned pull requests do not necessarily indicate pull requests that triggered the run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/pull_requests`.
            public var pullRequests: [Components.Schemas.PullRequestMinimal]?
            /// - Remark: Generated from `#/components/schemas/workflow-run/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/workflow-run/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/workflow-run/actor`.
            public var actor: Components.Schemas.SimpleUser?
            /// - Remark: Generated from `#/components/schemas/workflow-run/triggering_actor`.
            public var triggeringActor: Components.Schemas.SimpleUser?
            /// The start time of the latest run. Resets on re-run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/run_started_at`.
            public var runStartedAt: Foundation.Date?
            /// The URL to the jobs for the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/jobs_url`.
            public var jobsUrl: Swift.String
            /// The URL to download the logs for the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/logs_url`.
            public var logsUrl: Swift.String
            /// The URL to the associated check suite.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/check_suite_url`.
            public var checkSuiteUrl: Swift.String
            /// The URL to the artifacts for the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/artifacts_url`.
            public var artifactsUrl: Swift.String
            /// The URL to cancel the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/cancel_url`.
            public var cancelUrl: Swift.String
            /// The URL to rerun the workflow run.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/rerun_url`.
            public var rerunUrl: Swift.String
            /// The URL to the previous attempted run of this workflow, if one exists.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/previous_attempt_url`.
            public var previousAttemptUrl: Swift.String?
            /// The URL to the workflow.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/workflow_url`.
            public var workflowUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow-run/head_commit`.
            public var headCommit: Components.Schemas.NullableSimpleCommit?
            /// - Remark: Generated from `#/components/schemas/workflow-run/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/workflow-run/head_repository`.
            public var headRepository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/workflow-run/head_repository_id`.
            public var headRepositoryId: Swift.Int?
            /// The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow.
            ///
            /// - Remark: Generated from `#/components/schemas/workflow-run/display_title`.
            public var displayTitle: Swift.String
            /// Creates a new `WorkflowRun`.
            ///
            /// - Parameters:
            ///   - id: The ID of the workflow run.
            ///   - name: The name of the workflow run.
            ///   - nodeId:
            ///   - checkSuiteId: The ID of the associated check suite.
            ///   - checkSuiteNodeId: The node ID of the associated check suite.
            ///   - headBranch:
            ///   - headSha: The SHA of the head commit that points to the version of the workflow being run.
            ///   - path: The full path of the workflow
            ///   - runNumber: The auto incrementing run number for the workflow run.
            ///   - runAttempt: Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.
            ///   - referencedWorkflows:
            ///   - event:
            ///   - status:
            ///   - conclusion:
            ///   - workflowId: The ID of the parent workflow.
            ///   - url: The URL to the workflow run.
            ///   - htmlUrl:
            ///   - pullRequests: Pull requests that are open with a `head_sha` or `head_branch` that matches the workflow run. The returned pull requests do not necessarily indicate pull requests that triggered the run.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - actor:
            ///   - triggeringActor:
            ///   - runStartedAt: The start time of the latest run. Resets on re-run.
            ///   - jobsUrl: The URL to the jobs for the workflow run.
            ///   - logsUrl: The URL to download the logs for the workflow run.
            ///   - checkSuiteUrl: The URL to the associated check suite.
            ///   - artifactsUrl: The URL to the artifacts for the workflow run.
            ///   - cancelUrl: The URL to cancel the workflow run.
            ///   - rerunUrl: The URL to rerun the workflow run.
            ///   - previousAttemptUrl: The URL to the previous attempted run of this workflow, if one exists.
            ///   - workflowUrl: The URL to the workflow.
            ///   - headCommit:
            ///   - repository:
            ///   - headRepository:
            ///   - headRepositoryId:
            ///   - displayTitle: The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow.
            public init(
                id: Swift.Int,
                name: Swift.String? = nil,
                nodeId: Swift.String,
                checkSuiteId: Swift.Int? = nil,
                checkSuiteNodeId: Swift.String? = nil,
                headBranch: Swift.String? = nil,
                headSha: Swift.String,
                path: Swift.String,
                runNumber: Swift.Int,
                runAttempt: Swift.Int? = nil,
                referencedWorkflows: [Components.Schemas.ReferencedWorkflow]? = nil,
                event: Swift.String,
                status: Swift.String? = nil,
                conclusion: Swift.String? = nil,
                workflowId: Swift.Int,
                url: Swift.String,
                htmlUrl: Swift.String,
                pullRequests: [Components.Schemas.PullRequestMinimal]? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                actor: Components.Schemas.SimpleUser? = nil,
                triggeringActor: Components.Schemas.SimpleUser? = nil,
                runStartedAt: Foundation.Date? = nil,
                jobsUrl: Swift.String,
                logsUrl: Swift.String,
                checkSuiteUrl: Swift.String,
                artifactsUrl: Swift.String,
                cancelUrl: Swift.String,
                rerunUrl: Swift.String,
                previousAttemptUrl: Swift.String? = nil,
                workflowUrl: Swift.String,
                headCommit: Components.Schemas.NullableSimpleCommit? = nil,
                repository: Components.Schemas.MinimalRepository,
                headRepository: Components.Schemas.MinimalRepository,
                headRepositoryId: Swift.Int? = nil,
                displayTitle: Swift.String
            ) {
                self.id = id
                self.name = name
                self.nodeId = nodeId
                self.checkSuiteId = checkSuiteId
                self.checkSuiteNodeId = checkSuiteNodeId
                self.headBranch = headBranch
                self.headSha = headSha
                self.path = path
                self.runNumber = runNumber
                self.runAttempt = runAttempt
                self.referencedWorkflows = referencedWorkflows
                self.event = event
                self.status = status
                self.conclusion = conclusion
                self.workflowId = workflowId
                self.url = url
                self.htmlUrl = htmlUrl
                self.pullRequests = pullRequests
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.actor = actor
                self.triggeringActor = triggeringActor
                self.runStartedAt = runStartedAt
                self.jobsUrl = jobsUrl
                self.logsUrl = logsUrl
                self.checkSuiteUrl = checkSuiteUrl
                self.artifactsUrl = artifactsUrl
                self.cancelUrl = cancelUrl
                self.rerunUrl = rerunUrl
                self.previousAttemptUrl = previousAttemptUrl
                self.workflowUrl = workflowUrl
                self.headCommit = headCommit
                self.repository = repository
                self.headRepository = headRepository
                self.headRepositoryId = headRepositoryId
                self.displayTitle = displayTitle
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case nodeId = "node_id"
                case checkSuiteId = "check_suite_id"
                case checkSuiteNodeId = "check_suite_node_id"
                case headBranch = "head_branch"
                case headSha = "head_sha"
                case path
                case runNumber = "run_number"
                case runAttempt = "run_attempt"
                case referencedWorkflows = "referenced_workflows"
                case event
                case status
                case conclusion
                case workflowId = "workflow_id"
                case url
                case htmlUrl = "html_url"
                case pullRequests = "pull_requests"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case actor
                case triggeringActor = "triggering_actor"
                case runStartedAt = "run_started_at"
                case jobsUrl = "jobs_url"
                case logsUrl = "logs_url"
                case checkSuiteUrl = "check_suite_url"
                case artifactsUrl = "artifacts_url"
                case cancelUrl = "cancel_url"
                case rerunUrl = "rerun_url"
                case previousAttemptUrl = "previous_attempt_url"
                case workflowUrl = "workflow_url"
                case headCommit = "head_commit"
                case repository
                case headRepository = "head_repository"
                case headRepositoryId = "head_repository_id"
                case displayTitle = "display_title"
            }
        }
        /// An entry in the reviews log for environment deployments
        ///
        /// - Remark: Generated from `#/components/schemas/environment-approvals`.
        public struct EnvironmentApprovals: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload`.
            public struct EnvironmentsPayloadPayload: Codable, Hashable, Sendable {
                /// The id of the environment.
                ///
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/node_id`.
                public var nodeId: Swift.String?
                /// The name of the environment.
                ///
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// The time that the environment was created, in ISO 8601 format.
                ///
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/created_at`.
                public var createdAt: Foundation.Date?
                /// The time that the environment was last updated, in ISO 8601 format.
                ///
                /// - Remark: Generated from `#/components/schemas/environment-approvals/EnvironmentsPayload/updated_at`.
                public var updatedAt: Foundation.Date?
                /// Creates a new `EnvironmentsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id: The id of the environment.
                ///   - nodeId:
                ///   - name: The name of the environment.
                ///   - url:
                ///   - htmlUrl:
                ///   - createdAt: The time that the environment was created, in ISO 8601 format.
                ///   - updatedAt: The time that the environment was last updated, in ISO 8601 format.
                public init(
                    id: Swift.Int? = nil,
                    nodeId: Swift.String? = nil,
                    name: Swift.String? = nil,
                    url: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    createdAt: Foundation.Date? = nil,
                    updatedAt: Foundation.Date? = nil
                ) {
                    self.id = id
                    self.nodeId = nodeId
                    self.name = name
                    self.url = url
                    self.htmlUrl = htmlUrl
                    self.createdAt = createdAt
                    self.updatedAt = updatedAt
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case nodeId = "node_id"
                    case name
                    case url
                    case htmlUrl = "html_url"
                    case createdAt = "created_at"
                    case updatedAt = "updated_at"
                }
            }
            /// The list of environments that were approved or rejected
            ///
            /// - Remark: Generated from `#/components/schemas/environment-approvals/environments`.
            public typealias EnvironmentsPayload = [Components.Schemas.EnvironmentApprovals.EnvironmentsPayloadPayload]
            /// The list of environments that were approved or rejected
            ///
            /// - Remark: Generated from `#/components/schemas/environment-approvals/environments`.
            public var environments: Components.Schemas.EnvironmentApprovals.EnvironmentsPayload
            /// Whether deployment to the environment(s) was approved or rejected or pending (with comments)
            ///
            /// - Remark: Generated from `#/components/schemas/environment-approvals/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case approved = "approved"
                case rejected = "rejected"
                case pending = "pending"
            }
            /// Whether deployment to the environment(s) was approved or rejected or pending (with comments)
            ///
            /// - Remark: Generated from `#/components/schemas/environment-approvals/state`.
            public var state: Components.Schemas.EnvironmentApprovals.StatePayload
            /// - Remark: Generated from `#/components/schemas/environment-approvals/user`.
            public var user: Components.Schemas.SimpleUser
            /// The comment submitted with the deployment review
            ///
            /// - Remark: Generated from `#/components/schemas/environment-approvals/comment`.
            public var comment: Swift.String
            /// Creates a new `EnvironmentApprovals`.
            ///
            /// - Parameters:
            ///   - environments: The list of environments that were approved or rejected
            ///   - state: Whether deployment to the environment(s) was approved or rejected or pending (with comments)
            ///   - user:
            ///   - comment: The comment submitted with the deployment review
            public init(
                environments: Components.Schemas.EnvironmentApprovals.EnvironmentsPayload,
                state: Components.Schemas.EnvironmentApprovals.StatePayload,
                user: Components.Schemas.SimpleUser,
                comment: Swift.String
            ) {
                self.environments = environments
                self.state = state
                self.user = user
                self.comment = comment
            }
            public enum CodingKeys: String, CodingKey {
                case environments
                case state
                case user
                case comment
            }
        }
        /// - Remark: Generated from `#/components/schemas/review-custom-gates-comment-required`.
        public struct ReviewCustomGatesCommentRequired: Codable, Hashable, Sendable {
            /// The name of the environment to approve or reject.
            ///
            /// - Remark: Generated from `#/components/schemas/review-custom-gates-comment-required/environment_name`.
            public var environmentName: Swift.String
            /// Comment associated with the pending deployment protection rule. **Required when state is not provided.**
            ///
            /// - Remark: Generated from `#/components/schemas/review-custom-gates-comment-required/comment`.
            public var comment: Swift.String
            /// Creates a new `ReviewCustomGatesCommentRequired`.
            ///
            /// - Parameters:
            ///   - environmentName: The name of the environment to approve or reject.
            ///   - comment: Comment associated with the pending deployment protection rule. **Required when state is not provided.**
            public init(
                environmentName: Swift.String,
                comment: Swift.String
            ) {
                self.environmentName = environmentName
                self.comment = comment
            }
            public enum CodingKeys: String, CodingKey {
                case environmentName = "environment_name"
                case comment
            }
        }
        /// - Remark: Generated from `#/components/schemas/review-custom-gates-state-required`.
        public struct ReviewCustomGatesStateRequired: Codable, Hashable, Sendable {
            /// The name of the environment to approve or reject.
            ///
            /// - Remark: Generated from `#/components/schemas/review-custom-gates-state-required/environment_name`.
            public var environmentName: Swift.String
            /// Whether to approve or reject deployment to the specified environments.
            ///
            /// - Remark: Generated from `#/components/schemas/review-custom-gates-state-required/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case approved = "approved"
                case rejected = "rejected"
            }
            /// Whether to approve or reject deployment to the specified environments.
            ///
            /// - Remark: Generated from `#/components/schemas/review-custom-gates-state-required/state`.
            public var state: Components.Schemas.ReviewCustomGatesStateRequired.StatePayload
            /// Optional comment to include with the review.
            ///
            /// - Remark: Generated from `#/components/schemas/review-custom-gates-state-required/comment`.
            public var comment: Swift.String?
            /// Creates a new `ReviewCustomGatesStateRequired`.
            ///
            /// - Parameters:
            ///   - environmentName: The name of the environment to approve or reject.
            ///   - state: Whether to approve or reject deployment to the specified environments.
            ///   - comment: Optional comment to include with the review.
            public init(
                environmentName: Swift.String,
                state: Components.Schemas.ReviewCustomGatesStateRequired.StatePayload,
                comment: Swift.String? = nil
            ) {
                self.environmentName = environmentName
                self.state = state
                self.comment = comment
            }
            public enum CodingKeys: String, CodingKey {
                case environmentName = "environment_name"
                case state
                case comment
            }
        }
        /// The type of reviewer.
        ///
        /// - Remark: Generated from `#/components/schemas/deployment-reviewer-type`.
        @frozen public enum DeploymentReviewerType: String, Codable, Hashable, Sendable, CaseIterable {
            case user = "User"
            case team = "Team"
        }
        /// Details of a deployment that is waiting for protection rules to pass
        ///
        /// - Remark: Generated from `#/components/schemas/pending-deployment`.
        public struct PendingDeployment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pending-deployment/environment`.
            public struct EnvironmentPayload: Codable, Hashable, Sendable {
                /// The id of the environment.
                ///
                /// - Remark: Generated from `#/components/schemas/pending-deployment/environment/id`.
                public var id: Swift.Int64?
                /// - Remark: Generated from `#/components/schemas/pending-deployment/environment/node_id`.
                public var nodeId: Swift.String?
                /// The name of the environment.
                ///
                /// - Remark: Generated from `#/components/schemas/pending-deployment/environment/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/pending-deployment/environment/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/pending-deployment/environment/html_url`.
                public var htmlUrl: Swift.String?
                /// Creates a new `EnvironmentPayload`.
                ///
                /// - Parameters:
                ///   - id: The id of the environment.
                ///   - nodeId:
                ///   - name: The name of the environment.
                ///   - url:
                ///   - htmlUrl:
                public init(
                    id: Swift.Int64? = nil,
                    nodeId: Swift.String? = nil,
                    name: Swift.String? = nil,
                    url: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil
                ) {
                    self.id = id
                    self.nodeId = nodeId
                    self.name = name
                    self.url = url
                    self.htmlUrl = htmlUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case nodeId = "node_id"
                    case name
                    case url
                    case htmlUrl = "html_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pending-deployment/environment`.
            public var environment: Components.Schemas.PendingDeployment.EnvironmentPayload
            /// The set duration of the wait timer
            ///
            /// - Remark: Generated from `#/components/schemas/pending-deployment/wait_timer`.
            public var waitTimer: Swift.Int
            /// The time that the wait timer began.
            ///
            /// - Remark: Generated from `#/components/schemas/pending-deployment/wait_timer_started_at`.
            public var waitTimerStartedAt: Foundation.Date?
            /// Whether the currently authenticated user can approve the deployment
            ///
            /// - Remark: Generated from `#/components/schemas/pending-deployment/current_user_can_approve`.
            public var currentUserCanApprove: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/pending-deployment/ReviewersPayload`.
            public struct ReviewersPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pending-deployment/ReviewersPayload/type`.
                public var _type: Components.Schemas.DeploymentReviewerType?
                /// - Remark: Generated from `#/components/schemas/pending-deployment/ReviewersPayload/reviewer`.
                public struct ReviewerPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pending-deployment/ReviewersPayload/reviewer/value1`.
                    public var value1: Components.Schemas.SimpleUser?
                    /// - Remark: Generated from `#/components/schemas/pending-deployment/ReviewersPayload/reviewer/value2`.
                    public var value2: Components.Schemas.Team?
                    /// Creates a new `ReviewerPayload`.
                    ///
                    /// - Parameters:
                    ///   - value1:
                    ///   - value2:
                    public init(
                        value1: Components.Schemas.SimpleUser? = nil,
                        value2: Components.Schemas.Team? = nil
                    ) {
                        self.value1 = value1
                        self.value2 = value2
                    }
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self.value1 = try .init(from: decoder)
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self.value2 = try .init(from: decoder)
                        } catch {
                            errors.append(error)
                        }
                        try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                            [
                                self.value1,
                                self.value2
                            ],
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try self.value1?.encode(to: encoder)
                        try self.value2?.encode(to: encoder)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pending-deployment/ReviewersPayload/reviewer`.
                public var reviewer: Components.Schemas.PendingDeployment.ReviewersPayloadPayload.ReviewerPayload?
                /// Creates a new `ReviewersPayloadPayload`.
                ///
                /// - Parameters:
                ///   - _type:
                ///   - reviewer:
                public init(
                    _type: Components.Schemas.DeploymentReviewerType? = nil,
                    reviewer: Components.Schemas.PendingDeployment.ReviewersPayloadPayload.ReviewerPayload? = nil
                ) {
                    self._type = _type
                    self.reviewer = reviewer
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case reviewer
                }
            }
            /// The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
            ///
            /// - Remark: Generated from `#/components/schemas/pending-deployment/reviewers`.
            public typealias ReviewersPayload = [Components.Schemas.PendingDeployment.ReviewersPayloadPayload]
            /// The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
            ///
            /// - Remark: Generated from `#/components/schemas/pending-deployment/reviewers`.
            public var reviewers: Components.Schemas.PendingDeployment.ReviewersPayload
            /// Creates a new `PendingDeployment`.
            ///
            /// - Parameters:
            ///   - environment:
            ///   - waitTimer: The set duration of the wait timer
            ///   - waitTimerStartedAt: The time that the wait timer began.
            ///   - currentUserCanApprove: Whether the currently authenticated user can approve the deployment
            ///   - reviewers: The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
            public init(
                environment: Components.Schemas.PendingDeployment.EnvironmentPayload,
                waitTimer: Swift.Int,
                waitTimerStartedAt: Foundation.Date? = nil,
                currentUserCanApprove: Swift.Bool,
                reviewers: Components.Schemas.PendingDeployment.ReviewersPayload
            ) {
                self.environment = environment
                self.waitTimer = waitTimer
                self.waitTimerStartedAt = waitTimerStartedAt
                self.currentUserCanApprove = currentUserCanApprove
                self.reviewers = reviewers
            }
            public enum CodingKeys: String, CodingKey {
                case environment
                case waitTimer = "wait_timer"
                case waitTimerStartedAt = "wait_timer_started_at"
                case currentUserCanApprove = "current_user_can_approve"
                case reviewers
            }
        }
        /// A request for a specific ref(branch,sha,tag) to be deployed
        ///
        /// - Remark: Generated from `#/components/schemas/deployment`.
        public struct Deployment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/deployment/url`.
            public var url: Swift.String
            /// Unique identifier of the deployment
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/deployment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/sha`.
            public var sha: Swift.String
            /// The ref to deploy. This can be a branch, tag, or sha.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/ref`.
            public var ref: Swift.String
            /// Parameter to specify a task to execute
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/task`.
            public var task: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/payload`.
            @frozen public enum PayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/deployment/payload/case1`.
                public struct Case1Payload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `Case1Payload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/deployment/payload/case1`.
                case case1(Components.Schemas.Deployment.PayloadPayload.Case1Payload)
                /// - Remark: Generated from `#/components/schemas/deployment/payload/case2`.
                case case2(Swift.String)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try value.encode(to: encoder)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/deployment/payload`.
            public var payload: Components.Schemas.Deployment.PayloadPayload
            /// - Remark: Generated from `#/components/schemas/deployment/original_environment`.
            public var originalEnvironment: Swift.String?
            /// Name for the target deployment environment.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/environment`.
            public var environment: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/deployment/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/deployment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/deployment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/deployment/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/repository_url`.
            public var repositoryUrl: Swift.String
            /// Specifies if the given environment is will no longer exist at some point in the future. Default: false.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/transient_environment`.
            public var transientEnvironment: Swift.Bool?
            /// Specifies if the given environment is one that end-users directly interact with. Default: false.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/production_environment`.
            public var productionEnvironment: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/deployment/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// Creates a new `Deployment`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id: Unique identifier of the deployment
            ///   - nodeId:
            ///   - sha:
            ///   - ref: The ref to deploy. This can be a branch, tag, or sha.
            ///   - task: Parameter to specify a task to execute
            ///   - payload:
            ///   - originalEnvironment:
            ///   - environment: Name for the target deployment environment.
            ///   - description:
            ///   - creator:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - statusesUrl:
            ///   - repositoryUrl:
            ///   - transientEnvironment: Specifies if the given environment is will no longer exist at some point in the future. Default: false.
            ///   - productionEnvironment: Specifies if the given environment is one that end-users directly interact with. Default: false.
            ///   - performedViaGithubApp:
            public init(
                url: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                sha: Swift.String,
                ref: Swift.String,
                task: Swift.String,
                payload: Components.Schemas.Deployment.PayloadPayload,
                originalEnvironment: Swift.String? = nil,
                environment: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                statusesUrl: Swift.String,
                repositoryUrl: Swift.String,
                transientEnvironment: Swift.Bool? = nil,
                productionEnvironment: Swift.Bool? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil
            ) {
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.sha = sha
                self.ref = ref
                self.task = task
                self.payload = payload
                self.originalEnvironment = originalEnvironment
                self.environment = environment
                self.description = description
                self.creator = creator
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.statusesUrl = statusesUrl
                self.repositoryUrl = repositoryUrl
                self.transientEnvironment = transientEnvironment
                self.productionEnvironment = productionEnvironment
                self.performedViaGithubApp = performedViaGithubApp
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case nodeId = "node_id"
                case sha
                case ref
                case task
                case payload
                case originalEnvironment = "original_environment"
                case environment
                case description
                case creator
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case statusesUrl = "statuses_url"
                case repositoryUrl = "repository_url"
                case transientEnvironment = "transient_environment"
                case productionEnvironment = "production_environment"
                case performedViaGithubApp = "performed_via_github_app"
            }
        }
        /// Workflow Run Usage
        ///
        /// - Remark: Generated from `#/components/schemas/workflow-run-usage`.
        public struct WorkflowRunUsage: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable`.
            public struct BillablePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU`.
                public struct UbuntuPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/total_ms`.
                    public var totalMs: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/jobs`.
                    public var jobs: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/JobRunsPayload`.
                    public struct JobRunsPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/JobRunsPayload/job_id`.
                        public var jobId: Swift.Int
                        /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/JobRunsPayload/duration_ms`.
                        public var durationMs: Swift.Int
                        /// Creates a new `JobRunsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - jobId:
                        ///   - durationMs:
                        public init(
                            jobId: Swift.Int,
                            durationMs: Swift.Int
                        ) {
                            self.jobId = jobId
                            self.durationMs = durationMs
                        }
                        public enum CodingKeys: String, CodingKey {
                            case jobId = "job_id"
                            case durationMs = "duration_ms"
                        }
                    }
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/job_runs`.
                    public typealias JobRunsPayload = [Components.Schemas.WorkflowRunUsage.BillablePayload.UbuntuPayload.JobRunsPayloadPayload]
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU/job_runs`.
                    public var jobRuns: Components.Schemas.WorkflowRunUsage.BillablePayload.UbuntuPayload.JobRunsPayload?
                    /// Creates a new `UbuntuPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalMs:
                    ///   - jobs:
                    ///   - jobRuns:
                    public init(
                        totalMs: Swift.Int,
                        jobs: Swift.Int,
                        jobRuns: Components.Schemas.WorkflowRunUsage.BillablePayload.UbuntuPayload.JobRunsPayload? = nil
                    ) {
                        self.totalMs = totalMs
                        self.jobs = jobs
                        self.jobRuns = jobRuns
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalMs = "total_ms"
                        case jobs
                        case jobRuns = "job_runs"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/UBUNTU`.
                public var ubuntu: Components.Schemas.WorkflowRunUsage.BillablePayload.UbuntuPayload?
                /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS`.
                public struct MacosPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/total_ms`.
                    public var totalMs: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/jobs`.
                    public var jobs: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/JobRunsPayload`.
                    public struct JobRunsPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/JobRunsPayload/job_id`.
                        public var jobId: Swift.Int
                        /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/JobRunsPayload/duration_ms`.
                        public var durationMs: Swift.Int
                        /// Creates a new `JobRunsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - jobId:
                        ///   - durationMs:
                        public init(
                            jobId: Swift.Int,
                            durationMs: Swift.Int
                        ) {
                            self.jobId = jobId
                            self.durationMs = durationMs
                        }
                        public enum CodingKeys: String, CodingKey {
                            case jobId = "job_id"
                            case durationMs = "duration_ms"
                        }
                    }
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/job_runs`.
                    public typealias JobRunsPayload = [Components.Schemas.WorkflowRunUsage.BillablePayload.MacosPayload.JobRunsPayloadPayload]
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS/job_runs`.
                    public var jobRuns: Components.Schemas.WorkflowRunUsage.BillablePayload.MacosPayload.JobRunsPayload?
                    /// Creates a new `MacosPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalMs:
                    ///   - jobs:
                    ///   - jobRuns:
                    public init(
                        totalMs: Swift.Int,
                        jobs: Swift.Int,
                        jobRuns: Components.Schemas.WorkflowRunUsage.BillablePayload.MacosPayload.JobRunsPayload? = nil
                    ) {
                        self.totalMs = totalMs
                        self.jobs = jobs
                        self.jobRuns = jobRuns
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalMs = "total_ms"
                        case jobs
                        case jobRuns = "job_runs"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/MACOS`.
                public var macos: Components.Schemas.WorkflowRunUsage.BillablePayload.MacosPayload?
                /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS`.
                public struct WindowsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/total_ms`.
                    public var totalMs: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/jobs`.
                    public var jobs: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/JobRunsPayload`.
                    public struct JobRunsPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/JobRunsPayload/job_id`.
                        public var jobId: Swift.Int
                        /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/JobRunsPayload/duration_ms`.
                        public var durationMs: Swift.Int
                        /// Creates a new `JobRunsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - jobId:
                        ///   - durationMs:
                        public init(
                            jobId: Swift.Int,
                            durationMs: Swift.Int
                        ) {
                            self.jobId = jobId
                            self.durationMs = durationMs
                        }
                        public enum CodingKeys: String, CodingKey {
                            case jobId = "job_id"
                            case durationMs = "duration_ms"
                        }
                    }
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/job_runs`.
                    public typealias JobRunsPayload = [Components.Schemas.WorkflowRunUsage.BillablePayload.WindowsPayload.JobRunsPayloadPayload]
                    /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS/job_runs`.
                    public var jobRuns: Components.Schemas.WorkflowRunUsage.BillablePayload.WindowsPayload.JobRunsPayload?
                    /// Creates a new `WindowsPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalMs:
                    ///   - jobs:
                    ///   - jobRuns:
                    public init(
                        totalMs: Swift.Int,
                        jobs: Swift.Int,
                        jobRuns: Components.Schemas.WorkflowRunUsage.BillablePayload.WindowsPayload.JobRunsPayload? = nil
                    ) {
                        self.totalMs = totalMs
                        self.jobs = jobs
                        self.jobRuns = jobRuns
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalMs = "total_ms"
                        case jobs
                        case jobRuns = "job_runs"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable/WINDOWS`.
                public var windows: Components.Schemas.WorkflowRunUsage.BillablePayload.WindowsPayload?
                /// Creates a new `BillablePayload`.
                ///
                /// - Parameters:
                ///   - ubuntu:
                ///   - macos:
                ///   - windows:
                public init(
                    ubuntu: Components.Schemas.WorkflowRunUsage.BillablePayload.UbuntuPayload? = nil,
                    macos: Components.Schemas.WorkflowRunUsage.BillablePayload.MacosPayload? = nil,
                    windows: Components.Schemas.WorkflowRunUsage.BillablePayload.WindowsPayload? = nil
                ) {
                    self.ubuntu = ubuntu
                    self.macos = macos
                    self.windows = windows
                }
                public enum CodingKeys: String, CodingKey {
                    case ubuntu = "UBUNTU"
                    case macos = "MACOS"
                    case windows = "WINDOWS"
                }
            }
            /// - Remark: Generated from `#/components/schemas/workflow-run-usage/billable`.
            public var billable: Components.Schemas.WorkflowRunUsage.BillablePayload
            /// - Remark: Generated from `#/components/schemas/workflow-run-usage/run_duration_ms`.
            public var runDurationMs: Swift.Int?
            /// Creates a new `WorkflowRunUsage`.
            ///
            /// - Parameters:
            ///   - billable:
            ///   - runDurationMs:
            public init(
                billable: Components.Schemas.WorkflowRunUsage.BillablePayload,
                runDurationMs: Swift.Int? = nil
            ) {
                self.billable = billable
                self.runDurationMs = runDurationMs
            }
            public enum CodingKeys: String, CodingKey {
                case billable
                case runDurationMs = "run_duration_ms"
            }
        }
        /// A GitHub Actions workflow
        ///
        /// - Remark: Generated from `#/components/schemas/workflow`.
        public struct Workflow: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/workflow/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/workflow/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case active = "active"
                case deleted = "deleted"
                case disabledFork = "disabled_fork"
                case disabledInactivity = "disabled_inactivity"
                case disabledManually = "disabled_manually"
            }
            /// - Remark: Generated from `#/components/schemas/workflow/state`.
            public var state: Components.Schemas.Workflow.StatePayload
            /// - Remark: Generated from `#/components/schemas/workflow/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/workflow/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/workflow/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow/badge_url`.
            public var badgeUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/workflow/deleted_at`.
            public var deletedAt: Foundation.Date?
            /// Creates a new `Workflow`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - path:
            ///   - state:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - url:
            ///   - htmlUrl:
            ///   - badgeUrl:
            ///   - deletedAt:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                path: Swift.String,
                state: Components.Schemas.Workflow.StatePayload,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                url: Swift.String,
                htmlUrl: Swift.String,
                badgeUrl: Swift.String,
                deletedAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.path = path
                self.state = state
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.htmlUrl = htmlUrl
                self.badgeUrl = badgeUrl
                self.deletedAt = deletedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case path
                case state
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case htmlUrl = "html_url"
                case badgeUrl = "badge_url"
                case deletedAt = "deleted_at"
            }
        }
        /// Workflow Usage
        ///
        /// - Remark: Generated from `#/components/schemas/workflow-usage`.
        public struct WorkflowUsage: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/workflow-usage/billable`.
            public struct BillablePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/UBUNTU`.
                public struct UbuntuPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/UBUNTU/total_ms`.
                    public var totalMs: Swift.Int?
                    /// Creates a new `UbuntuPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalMs:
                    public init(totalMs: Swift.Int? = nil) {
                        self.totalMs = totalMs
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalMs = "total_ms"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/UBUNTU`.
                public var ubuntu: Components.Schemas.WorkflowUsage.BillablePayload.UbuntuPayload?
                /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/MACOS`.
                public struct MacosPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/MACOS/total_ms`.
                    public var totalMs: Swift.Int?
                    /// Creates a new `MacosPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalMs:
                    public init(totalMs: Swift.Int? = nil) {
                        self.totalMs = totalMs
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalMs = "total_ms"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/MACOS`.
                public var macos: Components.Schemas.WorkflowUsage.BillablePayload.MacosPayload?
                /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/WINDOWS`.
                public struct WindowsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/WINDOWS/total_ms`.
                    public var totalMs: Swift.Int?
                    /// Creates a new `WindowsPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalMs:
                    public init(totalMs: Swift.Int? = nil) {
                        self.totalMs = totalMs
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalMs = "total_ms"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/workflow-usage/billable/WINDOWS`.
                public var windows: Components.Schemas.WorkflowUsage.BillablePayload.WindowsPayload?
                /// Creates a new `BillablePayload`.
                ///
                /// - Parameters:
                ///   - ubuntu:
                ///   - macos:
                ///   - windows:
                public init(
                    ubuntu: Components.Schemas.WorkflowUsage.BillablePayload.UbuntuPayload? = nil,
                    macos: Components.Schemas.WorkflowUsage.BillablePayload.MacosPayload? = nil,
                    windows: Components.Schemas.WorkflowUsage.BillablePayload.WindowsPayload? = nil
                ) {
                    self.ubuntu = ubuntu
                    self.macos = macos
                    self.windows = windows
                }
                public enum CodingKeys: String, CodingKey {
                    case ubuntu = "UBUNTU"
                    case macos = "MACOS"
                    case windows = "WINDOWS"
                }
            }
            /// - Remark: Generated from `#/components/schemas/workflow-usage/billable`.
            public var billable: Components.Schemas.WorkflowUsage.BillablePayload
            /// Creates a new `WorkflowUsage`.
            ///
            /// - Parameters:
            ///   - billable:
            public init(billable: Components.Schemas.WorkflowUsage.BillablePayload) {
                self.billable = billable
            }
            public enum CodingKeys: String, CodingKey {
                case billable
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// Unique identifier of the GitHub-hosted runner.
        ///
        /// - Remark: Generated from `#/components/parameters/hosted-runner-id`.
        public typealias HostedRunnerId = Swift.Int
        /// The unique identifier of the repository.
        ///
        /// - Remark: Generated from `#/components/parameters/repository-id`.
        public typealias RepositoryId = Swift.Int
        /// Only return runner groups that are allowed to be used by this repository.
        ///
        /// - Remark: Generated from `#/components/parameters/visible-to-repository`.
        public typealias VisibleToRepository = Swift.String
        /// Unique identifier of the self-hosted runner group.
        ///
        /// - Remark: Generated from `#/components/parameters/runner-group-id`.
        public typealias RunnerGroupId = Swift.Int
        /// Unique identifier of the self-hosted runner.
        ///
        /// - Remark: Generated from `#/components/parameters/runner-id`.
        public typealias RunnerId = Swift.Int
        /// The name of a self-hosted runner's custom label.
        ///
        /// - Remark: Generated from `#/components/parameters/runner-label-name`.
        public typealias RunnerLabelName = Swift.String
        /// The name of the secret.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-name`.
        public typealias SecretName = Swift.String
        /// The number of results per page (max 30). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/variables-per-page`.
        public typealias VariablesPerPage = Swift.Int
        /// The name of the variable.
        ///
        /// - Remark: Generated from `#/components/parameters/variable-name`.
        public typealias VariableName = Swift.String
        /// The name field of an artifact. When specified, only artifacts with this name will be returned.
        ///
        /// - Remark: Generated from `#/components/parameters/artifact-name`.
        public typealias ArtifactName = Swift.String
        /// The unique identifier of the artifact.
        ///
        /// - Remark: Generated from `#/components/parameters/artifact-id`.
        public typealias ArtifactId = Swift.Int
        /// The full Git reference for narrowing down the cache. The `ref` for a branch should be formatted as `refs/heads/<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
        ///
        /// - Remark: Generated from `#/components/parameters/actions-cache-git-ref-full`.
        public typealias ActionsCacheGitRefFull = Swift.String
        /// An explicit key or prefix for identifying the cache
        ///
        /// - Remark: Generated from `#/components/parameters/actions-cache-key`.
        public typealias ActionsCacheKey = Swift.String
        /// The property to sort the results by. `created_at` means when the cache was created. `last_accessed_at` means when the cache was last accessed. `size_in_bytes` is the size of the cache in bytes.
        ///
        /// - Remark: Generated from `#/components/parameters/actions-cache-list-sort`.
        @frozen public enum ActionsCacheListSort: String, Codable, Hashable, Sendable, CaseIterable {
            case createdAt = "created_at"
            case lastAccessedAt = "last_accessed_at"
            case sizeInBytes = "size_in_bytes"
        }
        /// A key for identifying the cache.
        ///
        /// - Remark: Generated from `#/components/parameters/actions-cache-key-required`.
        public typealias ActionsCacheKeyRequired = Swift.String
        /// The unique identifier of the GitHub Actions cache.
        ///
        /// - Remark: Generated from `#/components/parameters/cache-id`.
        public typealias CacheId = Swift.Int
        /// The unique identifier of the job.
        ///
        /// - Remark: Generated from `#/components/parameters/job-id`.
        public typealias JobId = Swift.Int
        /// Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
        ///
        /// - Remark: Generated from `#/components/parameters/actor`.
        public typealias Actor = Swift.String
        /// Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
        ///
        /// - Remark: Generated from `#/components/parameters/workflow-run-branch`.
        public typealias WorkflowRunBranch = Swift.String
        /// Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://docs.github.com/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)."
        ///
        /// - Remark: Generated from `#/components/parameters/event`.
        public typealias Event = Swift.String
        /// Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub Actions can set a status of `waiting`, `pending`, or `requested`.
        ///
        /// - Remark: Generated from `#/components/parameters/workflow-run-status`.
        @frozen public enum WorkflowRunStatus: String, Codable, Hashable, Sendable, CaseIterable {
            case completed = "completed"
            case actionRequired = "action_required"
            case cancelled = "cancelled"
            case failure = "failure"
            case neutral = "neutral"
            case skipped = "skipped"
            case stale = "stale"
            case success = "success"
            case timedOut = "timed_out"
            case inProgress = "in_progress"
            case queued = "queued"
            case requested = "requested"
            case waiting = "waiting"
            case pending = "pending"
        }
        /// Returns workflow runs created within the given date-time range. For more information on the syntax, see "[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates)."
        ///
        /// - Remark: Generated from `#/components/parameters/created`.
        public typealias Created = Foundation.Date
        /// If `true` pull requests are omitted from the response (empty array).
        ///
        /// - Remark: Generated from `#/components/parameters/exclude-pull-requests`.
        public typealias ExcludePullRequests = Swift.Bool
        /// Returns workflow runs with the `check_suite_id` that you specify.
        ///
        /// - Remark: Generated from `#/components/parameters/workflow-run-check-suite-id`.
        public typealias WorkflowRunCheckSuiteId = Swift.Int
        /// Only returns workflow runs that are associated with the specified `head_sha`.
        ///
        /// - Remark: Generated from `#/components/parameters/workflow-run-head-sha`.
        public typealias WorkflowRunHeadSha = Swift.String
        /// The unique identifier of the workflow run.
        ///
        /// - Remark: Generated from `#/components/parameters/run-id`.
        public typealias RunId = Swift.Int
        /// The attempt number of the workflow run.
        ///
        /// - Remark: Generated from `#/components/parameters/attempt-number`.
        public typealias AttemptNumber = Swift.Int
        /// The ID of the workflow. You can also pass the workflow file name as a string.
        ///
        /// - Remark: Generated from `#/components/parameters/workflow-id`.
        @frozen public enum WorkflowId: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/parameters/workflow-id/case1`.
            case case1(Swift.Int)
            /// - Remark: Generated from `#/components/parameters/workflow-id/case2`.
            case case2(Swift.String)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case2(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try encoder.encodeToSingleValueContainer(value)
                case let .case2(value):
                    try encoder.encodeToSingleValueContainer(value)
                }
            }
        }
        /// The name of the environment. The name must be URL encoded. For example, any slashes in the name must be replaced with `%2F`.
        ///
        /// - Remark: Generated from `#/components/parameters/environment-name`.
        public typealias EnvironmentName = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct InternalError: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/internal_error/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/internal_error/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.InternalError.Body
            /// Creates a new `InternalError`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.InternalError.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
        public struct ActionsRunnerJitconfig: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/actions_runner_jitconfig/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/actions_runner_jitconfig/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/actions_runner_jitconfig/content/json/runner`.
                    public var runner: Components.Schemas.Runner
                    /// The base64 encoded runner configuration.
                    ///
                    /// - Remark: Generated from `#/components/responses/actions_runner_jitconfig/content/json/encoded_jit_config`.
                    public var encodedJitConfig: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - runner:
                    ///   - encodedJitConfig: The base64 encoded runner configuration.
                    public init(
                        runner: Components.Schemas.Runner,
                        encodedJitConfig: Swift.String
                    ) {
                        self.runner = runner
                        self.encodedJitConfig = encodedJitConfig
                    }
                    public enum CodingKeys: String, CodingKey {
                        case runner
                        case encodedJitConfig = "encoded_jit_config"
                    }
                }
                /// - Remark: Generated from `#/components/responses/actions_runner_jitconfig/content/application\/json`.
                case json(Components.Responses.ActionsRunnerJitconfig.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ActionsRunnerJitconfig.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ActionsRunnerJitconfig.Body
            /// Creates a new `ActionsRunnerJitconfig`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ActionsRunnerJitconfig.Body) {
                self.body = body
            }
        }
        public struct ActionsRunnerLabels: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/actions_runner_labels/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/actions_runner_labels/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/actions_runner_labels/content/json/total_count`.
                    public var totalCount: Swift.Int
                    /// - Remark: Generated from `#/components/responses/actions_runner_labels/content/json/labels`.
                    public var labels: [Components.Schemas.RunnerLabel]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalCount:
                    ///   - labels:
                    public init(
                        totalCount: Swift.Int,
                        labels: [Components.Schemas.RunnerLabel]
                    ) {
                        self.totalCount = totalCount
                        self.labels = labels
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalCount = "total_count"
                        case labels
                    }
                }
                /// - Remark: Generated from `#/components/responses/actions_runner_labels/content/application\/json`.
                case json(Components.Responses.ActionsRunnerLabels.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ActionsRunnerLabels.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ActionsRunnerLabels.Body
            /// Creates a new `ActionsRunnerLabels`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ActionsRunnerLabels.Body) {
                self.body = body
            }
        }
        public struct ActionsRunnerLabelsReadonly: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/actions_runner_labels_readonly/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/actions_runner_labels_readonly/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/actions_runner_labels_readonly/content/json/total_count`.
                    public var totalCount: Swift.Int
                    /// - Remark: Generated from `#/components/responses/actions_runner_labels_readonly/content/json/labels`.
                    public var labels: [Components.Schemas.RunnerLabel]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - totalCount:
                    ///   - labels:
                    public init(
                        totalCount: Swift.Int,
                        labels: [Components.Schemas.RunnerLabel]
                    ) {
                        self.totalCount = totalCount
                        self.labels = labels
                    }
                    public enum CodingKeys: String, CodingKey {
                        case totalCount = "total_count"
                        case labels
                    }
                }
                /// - Remark: Generated from `#/components/responses/actions_runner_labels_readonly/content/application\/json`.
                case json(Components.Responses.ActionsRunnerLabelsReadonly.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ActionsRunnerLabelsReadonly.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ActionsRunnerLabelsReadonly.Body
            /// Creates a new `ActionsRunnerLabelsReadonly`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ActionsRunnerLabelsReadonly.Body) {
                self.body = body
            }
        }
        public struct Gone: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/gone/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/gone/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Gone.Body
            /// Creates a new `Gone`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Gone.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
        /// - Remark: Generated from `#/components/headers/location`.
        public typealias Location = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get GitHub Actions cache usage for an organization
    ///
    /// Gets the total GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage/get(actions/get-actions-cache-usage-for-org)`.
    public enum ActionsGetActionsCacheUsageForOrg {
        public static let id: Swift.String = "actions/get-actions-cache-usage-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetActionsCacheUsageForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetActionsCacheUsageForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetActionsCacheUsageForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetActionsCacheUsageForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetActionsCacheUsageForOrg.Input.Path,
                headers: Operations.ActionsGetActionsCacheUsageForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsCacheUsageOrgEnterprise)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsCacheUsageOrgEnterprise {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok.Headers = .init(),
                    body: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage/get(actions/get-actions-cache-usage-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories with GitHub Actions cache usage for an organization
    ///
    /// Lists repositories and their GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage-by-repository`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage-by-repository/get(actions/get-actions-cache-usage-by-repo-for-org)`.
    public enum ActionsGetActionsCacheUsageByRepoForOrg {
        public static let id: Swift.String = "actions/get-actions-cache-usage-by-repo-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetActionsCacheUsageByRepoForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetActionsCacheUsageByRepoForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Path,
                query: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Query = .init(),
                headers: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/content/json/repository_cache_usages`.
                        public var repositoryCacheUsages: [Components.Schemas.ActionsCacheUsageByRepository]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositoryCacheUsages:
                        public init(
                            totalCount: Swift.Int,
                            repositoryCacheUsages: [Components.Schemas.ActionsCacheUsageByRepository]
                        ) {
                            self.totalCount = totalCount
                            self.repositoryCacheUsages = repositoryCacheUsages
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositoryCacheUsages = "repository_cache_usages"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/cache/usage-by-repository/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Headers = .init(),
                    body: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage-by-repository/get(actions/get-actions-cache-usage-by-repo-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List GitHub-hosted runners for an organization
    ///
    /// Lists all GitHub-hosted runners configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runner:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/get(actions/list-hosted-runners-for-org)`.
    public enum ActionsListHostedRunnersForOrg {
        public static let id: Swift.String = "actions/list-hosted-runners-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsListHostedRunnersForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActionsListHostedRunnersForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListHostedRunnersForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListHostedRunnersForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsListHostedRunnersForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActionsListHostedRunnersForOrg.Input.Path,
                query: Operations.ActionsListHostedRunnersForOrg.Input.Query = .init(),
                headers: Operations.ActionsListHostedRunnersForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/content/json/runners`.
                        public var runners: [Components.Schemas.ActionsHostedRunner]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - runners:
                        public init(
                            totalCount: Swift.Int,
                            runners: [Components.Schemas.ActionsHostedRunner]
                        ) {
                            self.totalCount = totalCount
                            self.runners = runners
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case runners
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsListHostedRunnersForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Headers = .init(),
                    body: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/get(actions/list-hosted-runners-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsListHostedRunnersForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsListHostedRunnersForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a GitHub-hosted runner for an organization
    ///
    /// Creates a GitHub-hosted runner for an organization.
    /// OAuth tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/post(actions/create-hosted-runner-for-org)`.
    public enum ActionsCreateHostedRunnerForOrg {
        public static let id: Swift.String = "actions/create-hosted-runner-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsCreateHostedRunnerForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsCreateHostedRunnerForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsCreateHostedRunnerForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsCreateHostedRunnerForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the runner. Must be between 1 and 64 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The image of runner. To list all available images, use `GET /actions/hosted-runners/images/github-owned` or `GET /actions/hosted-runners/images/partner`.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/image`.
                    public struct ImagePayload: Codable, Hashable, Sendable {
                        /// The unique identifier of the runner image.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/image/id`.
                        public var id: Swift.String?
                        /// The source of the runner image.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/image/source`.
                        @frozen public enum SourcePayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case github = "github"
                            case partner = "partner"
                            case custom = "custom"
                        }
                        /// The source of the runner image.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/image/source`.
                        public var source: Operations.ActionsCreateHostedRunnerForOrg.Input.Body.JsonPayload.ImagePayload.SourcePayload?
                        /// Creates a new `ImagePayload`.
                        ///
                        /// - Parameters:
                        ///   - id: The unique identifier of the runner image.
                        ///   - source: The source of the runner image.
                        public init(
                            id: Swift.String? = nil,
                            source: Operations.ActionsCreateHostedRunnerForOrg.Input.Body.JsonPayload.ImagePayload.SourcePayload? = nil
                        ) {
                            self.id = id
                            self.source = source
                        }
                        public enum CodingKeys: String, CodingKey {
                            case id
                            case source
                        }
                    }
                    /// The image of runner. To list all available images, use `GET /actions/hosted-runners/images/github-owned` or `GET /actions/hosted-runners/images/partner`.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/image`.
                    public var image: Operations.ActionsCreateHostedRunnerForOrg.Input.Body.JsonPayload.ImagePayload
                    /// The machine size of the runner. To list available sizes, use `GET actions/hosted-runners/machine-sizes`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/size`.
                    public var size: Swift.String
                    /// The existing runner group to add this runner to.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/runner_group_id`.
                    public var runnerGroupId: Swift.Int
                    /// The maximum amount of runners to scale up to. Runners will not auto-scale above this number. Use this setting to limit your cost.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/maximum_runners`.
                    public var maximumRunners: Swift.Int?
                    /// Whether this runner should be created with a static public IP. Note limit on account. To list limits on account, use `GET actions/hosted-runners/limits`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/json/enable_static_ip`.
                    public var enableStaticIp: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the runner. Must be between 1 and 64 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///   - image: The image of runner. To list all available images, use `GET /actions/hosted-runners/images/github-owned` or `GET /actions/hosted-runners/images/partner`.
                    ///   - size: The machine size of the runner. To list available sizes, use `GET actions/hosted-runners/machine-sizes`
                    ///   - runnerGroupId: The existing runner group to add this runner to.
                    ///   - maximumRunners: The maximum amount of runners to scale up to. Runners will not auto-scale above this number. Use this setting to limit your cost.
                    ///   - enableStaticIp: Whether this runner should be created with a static public IP. Note limit on account. To list limits on account, use `GET actions/hosted-runners/limits`
                    public init(
                        name: Swift.String,
                        image: Operations.ActionsCreateHostedRunnerForOrg.Input.Body.JsonPayload.ImagePayload,
                        size: Swift.String,
                        runnerGroupId: Swift.Int,
                        maximumRunners: Swift.Int? = nil,
                        enableStaticIp: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self.image = image
                        self.size = size
                        self.runnerGroupId = runnerGroupId
                        self.maximumRunners = maximumRunners
                        self.enableStaticIp = enableStaticIp
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case image
                        case size
                        case runnerGroupId = "runner_group_id"
                        case maximumRunners = "maximum_runners"
                        case enableStaticIp = "enable_static_ip"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/requestBody/content/application\/json`.
                case json(Operations.ActionsCreateHostedRunnerForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.ActionsCreateHostedRunnerForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsCreateHostedRunnerForOrg.Input.Path,
                headers: Operations.ActionsCreateHostedRunnerForOrg.Input.Headers = .init(),
                body: Operations.ActionsCreateHostedRunnerForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.ActionsHostedRunner)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsHostedRunner {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsCreateHostedRunnerForOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsCreateHostedRunnerForOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/post(actions/create-hosted-runner-for-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ActionsCreateHostedRunnerForOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ActionsCreateHostedRunnerForOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub-owned images for GitHub-hosted runners in an organization
    ///
    /// Get the list of GitHub-owned images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/github-owned`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/github-owned/get(actions/get-hosted-runners-github-owned-images-for-org)`.
    public enum ActionsGetHostedRunnersGithubOwnedImagesForOrg {
        public static let id: Swift.String = "actions/get-hosted-runners-github-owned-images-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input.Path,
                headers: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/responses/200/content/json/images`.
                        public var images: [Components.Schemas.ActionsHostedRunnerCuratedImage]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - images:
                        public init(
                            totalCount: Swift.Int,
                            images: [Components.Schemas.ActionsHostedRunnerCuratedImage]
                        ) {
                            self.totalCount = totalCount
                            self.images = images
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case images
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/github-owned/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/github-owned/get(actions/get-hosted-runners-github-owned-images-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get partner images for GitHub-hosted runners in an organization
    ///
    /// Get the list of partner images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/partner`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/partner/get(actions/get-hosted-runners-partner-images-for-org)`.
    public enum ActionsGetHostedRunnersPartnerImagesForOrg {
        public static let id: Swift.String = "actions/get-hosted-runners-partner-images-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersPartnerImagesForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersPartnerImagesForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input.Path,
                headers: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/responses/200/content/json/images`.
                        public var images: [Components.Schemas.ActionsHostedRunnerCuratedImage]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - images:
                        public init(
                            totalCount: Swift.Int,
                            images: [Components.Schemas.ActionsHostedRunnerCuratedImage]
                        ) {
                            self.totalCount = totalCount
                            self.images = images
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case images
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/images/partner/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/partner/get(actions/get-hosted-runners-partner-images-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get limits on GitHub-hosted runners for an organization
    ///
    /// Get the GitHub-hosted runners limits for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/limits/get(actions/get-hosted-runners-limits-for-org)`.
    public enum ActionsGetHostedRunnersLimitsForOrg {
        public static let id: Swift.String = "actions/get-hosted-runners-limits-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/limits/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/limits/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetHostedRunnersLimitsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/limits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersLimitsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersLimitsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetHostedRunnersLimitsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetHostedRunnersLimitsForOrg.Input.Path,
                headers: Operations.ActionsGetHostedRunnersLimitsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/limits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/limits/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsHostedRunnerLimits)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsHostedRunnerLimits {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetHostedRunnersLimitsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetHostedRunnersLimitsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/limits/get(actions/get-hosted-runners-limits-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetHostedRunnersLimitsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetHostedRunnersLimitsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub-hosted runners machine specs for an organization
    ///
    /// Get the list of machine specs available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/machine-sizes`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/machine-sizes/get(actions/get-hosted-runners-machine-specs-for-org)`.
    public enum ActionsGetHostedRunnersMachineSpecsForOrg {
        public static let id: Swift.String = "actions/get-hosted-runners-machine-specs-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersMachineSpecsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersMachineSpecsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input.Path,
                headers: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/responses/200/content/json/machine_specs`.
                        public var machineSpecs: [Components.Schemas.ActionsHostedRunnerMachineSpec]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - machineSpecs:
                        public init(
                            totalCount: Swift.Int,
                            machineSpecs: [Components.Schemas.ActionsHostedRunnerMachineSpec]
                        ) {
                            self.totalCount = totalCount
                            self.machineSpecs = machineSpecs
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case machineSpecs = "machine_specs"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/machine-sizes/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/machine-sizes/get(actions/get-hosted-runners-machine-specs-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get platforms for GitHub-hosted runners in an organization
    ///
    /// Get the list of platforms available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/platforms`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/platforms/get(actions/get-hosted-runners-platforms-for-org)`.
    public enum ActionsGetHostedRunnersPlatformsForOrg {
        public static let id: Swift.String = "actions/get-hosted-runners-platforms-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersPlatformsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnersPlatformsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input.Path,
                headers: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/responses/200/content/json/platforms`.
                        public var platforms: [Swift.String]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - platforms:
                        public init(
                            totalCount: Swift.Int,
                            platforms: [Swift.String]
                        ) {
                            self.totalCount = totalCount
                            self.platforms = platforms
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case platforms
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/platforms/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/platforms/get(actions/get-hosted-runners-platforms-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a GitHub-hosted runner for an organization
    ///
    /// Gets a GitHub-hosted runner configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/get(actions/get-hosted-runner-for-org)`.
    public enum ActionsGetHostedRunnerForOrg {
        public static let id: Swift.String = "actions/get-hosted-runner-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the GitHub-hosted runner.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/path/hosted_runner_id`.
                public var hostedRunnerId: Components.Parameters.HostedRunnerId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hostedRunnerId: Unique identifier of the GitHub-hosted runner.
                public init(
                    org: Components.Parameters.Org,
                    hostedRunnerId: Components.Parameters.HostedRunnerId
                ) {
                    self.org = org
                    self.hostedRunnerId = hostedRunnerId
                }
            }
            public var path: Operations.ActionsGetHostedRunnerForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnerForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetHostedRunnerForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetHostedRunnerForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetHostedRunnerForOrg.Input.Path,
                headers: Operations.ActionsGetHostedRunnerForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActionsGetHostedRunnerForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsHostedRunner)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsHostedRunner {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetHostedRunnerForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActionsGetHostedRunnerForOrg.Output.Ok.Headers = .init(),
                    body: Operations.ActionsGetHostedRunnerForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/get(actions/get-hosted-runner-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetHostedRunnerForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetHostedRunnerForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a GitHub-hosted runner for an organization
    ///
    /// Updates a GitHub-hosted runner for an organization.
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/patch(actions/update-hosted-runner-for-org)`.
    public enum ActionsUpdateHostedRunnerForOrg {
        public static let id: Swift.String = "actions/update-hosted-runner-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the GitHub-hosted runner.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/path/hosted_runner_id`.
                public var hostedRunnerId: Components.Parameters.HostedRunnerId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hostedRunnerId: Unique identifier of the GitHub-hosted runner.
                public init(
                    org: Components.Parameters.Org,
                    hostedRunnerId: Components.Parameters.HostedRunnerId
                ) {
                    self.org = org
                    self.hostedRunnerId = hostedRunnerId
                }
            }
            public var path: Operations.ActionsUpdateHostedRunnerForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsUpdateHostedRunnerForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsUpdateHostedRunnerForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsUpdateHostedRunnerForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the runner. Must be between 1 and 64 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// The existing runner group to add this runner to.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody/json/runner_group_id`.
                    public var runnerGroupId: Swift.Int?
                    /// The maximum amount of runners to scale up to. Runners will not auto-scale above this number. Use this setting to limit your cost.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody/json/maximum_runners`.
                    public var maximumRunners: Swift.Int?
                    /// Whether this runner should be updated with a static public IP. Note limit on account. To list limits on account, use `GET actions/hosted-runners/limits`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody/json/enable_static_ip`.
                    public var enableStaticIp: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the runner. Must be between 1 and 64 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///   - runnerGroupId: The existing runner group to add this runner to.
                    ///   - maximumRunners: The maximum amount of runners to scale up to. Runners will not auto-scale above this number. Use this setting to limit your cost.
                    ///   - enableStaticIp: Whether this runner should be updated with a static public IP. Note limit on account. To list limits on account, use `GET actions/hosted-runners/limits`
                    public init(
                        name: Swift.String? = nil,
                        runnerGroupId: Swift.Int? = nil,
                        maximumRunners: Swift.Int? = nil,
                        enableStaticIp: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self.runnerGroupId = runnerGroupId
                        self.maximumRunners = maximumRunners
                        self.enableStaticIp = enableStaticIp
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case runnerGroupId = "runner_group_id"
                        case maximumRunners = "maximum_runners"
                        case enableStaticIp = "enable_static_ip"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ActionsUpdateHostedRunnerForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.ActionsUpdateHostedRunnerForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsUpdateHostedRunnerForOrg.Input.Path,
                headers: Operations.ActionsUpdateHostedRunnerForOrg.Input.Headers = .init(),
                body: Operations.ActionsUpdateHostedRunnerForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsHostedRunner)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsHostedRunner {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsUpdateHostedRunnerForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsUpdateHostedRunnerForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/patch(actions/update-hosted-runner-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsUpdateHostedRunnerForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsUpdateHostedRunnerForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a GitHub-hosted runner for an organization
    ///
    /// Deletes a GitHub-hosted runner for an organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/delete(actions/delete-hosted-runner-for-org)`.
    public enum ActionsDeleteHostedRunnerForOrg {
        public static let id: Swift.String = "actions/delete-hosted-runner-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the GitHub-hosted runner.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/DELETE/path/hosted_runner_id`.
                public var hostedRunnerId: Components.Parameters.HostedRunnerId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hostedRunnerId: Unique identifier of the GitHub-hosted runner.
                public init(
                    org: Components.Parameters.Org,
                    hostedRunnerId: Components.Parameters.HostedRunnerId
                ) {
                    self.org = org
                    self.hostedRunnerId = hostedRunnerId
                }
            }
            public var path: Operations.ActionsDeleteHostedRunnerForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsDeleteHostedRunnerForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsDeleteHostedRunnerForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsDeleteHostedRunnerForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsDeleteHostedRunnerForOrg.Input.Path,
                headers: Operations.ActionsDeleteHostedRunnerForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/DELETE/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/hosted-runners/{hosted_runner_id}/DELETE/responses/202/content/application\/json`.
                    case json(Components.Schemas.ActionsHostedRunner)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsHostedRunner {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsDeleteHostedRunnerForOrg.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsDeleteHostedRunnerForOrg.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/delete(actions/delete-hosted-runner-for-org)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.ActionsDeleteHostedRunnerForOrg.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.ActionsDeleteHostedRunnerForOrg.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub Actions permissions for an organization
    ///
    /// Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/get(actions/get-github-actions-permissions-organization)`.
    public enum ActionsGetGithubActionsPermissionsOrganization {
        public static let id: Swift.String = "actions/get-github-actions-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetGithubActionsPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetGithubActionsPermissionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetGithubActionsPermissionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetGithubActionsPermissionsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetGithubActionsPermissionsOrganization.Input.Path,
                headers: Operations.ActionsGetGithubActionsPermissionsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsOrganizationPermissions)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsOrganizationPermissions {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetGithubActionsPermissionsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetGithubActionsPermissionsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/get(actions/get-github-actions-permissions-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetGithubActionsPermissionsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetGithubActionsPermissionsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set GitHub Actions permissions for an organization
    ///
    /// Sets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/put(actions/set-github-actions-permissions-organization)`.
    public enum ActionsSetGithubActionsPermissionsOrganization {
        public static let id: Swift.String = "actions/set-github-actions-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/requestBody/json/enabled_repositories`.
                    public var enabledRepositories: Components.Schemas.EnabledRepositories
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/requestBody/json/allowed_actions`.
                    public var allowedActions: Components.Schemas.AllowedActions?
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/requestBody/json/sha_pinning_required`.
                    public var shaPinningRequired: Components.Schemas.ShaPinningRequired?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - enabledRepositories:
                    ///   - allowedActions:
                    ///   - shaPinningRequired:
                    public init(
                        enabledRepositories: Components.Schemas.EnabledRepositories,
                        allowedActions: Components.Schemas.AllowedActions? = nil,
                        shaPinningRequired: Components.Schemas.ShaPinningRequired? = nil
                    ) {
                        self.enabledRepositories = enabledRepositories
                        self.allowedActions = allowedActions
                        self.shaPinningRequired = shaPinningRequired
                    }
                    public enum CodingKeys: String, CodingKey {
                        case enabledRepositories = "enabled_repositories"
                        case allowedActions = "allowed_actions"
                        case shaPinningRequired = "sha_pinning_required"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/PUT/requestBody/content/application\/json`.
                case json(Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Body.JsonPayload)
            }
            public var body: Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - body:
            public init(
                path: Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Path,
                body: Operations.ActionsSetGithubActionsPermissionsOrganization.Input.Body
            ) {
                self.path = path
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/put(actions/set-github-actions-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetGithubActionsPermissionsOrganization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/put(actions/set-github-actions-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetGithubActionsPermissionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get artifact and log retention settings for an organization
    ///
    /// Gets artifact and log retention settings for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-organization)`.
    public enum ActionsGetArtifactAndLogRetentionSettingsOrganization {
        public static let id: Swift.String = "actions/get-artifact-and-log-retention-settings-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input.Path,
                headers: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsArtifactAndLogRetentionResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsArtifactAndLogRetentionResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetArtifactAndLogRetentionSettingsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/get(actions/get-artifact-and-log-retention-settings-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set artifact and log retention settings for an organization
    ///
    /// Sets artifact and log retention settings for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/artifact-and-log-retention`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)`.
    public enum ActionsSetArtifactAndLogRetentionSettingsOrganization {
        public static let id: Swift.String = "actions/set-artifact-and-log-retention-settings-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/artifact-and-log-retention/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.ActionsArtifactAndLogRetention)
            }
            public var body: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Path,
                headers: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Headers = .init(),
                body: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Output.NoContent)
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetArtifactAndLogRetentionSettingsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/artifact-and-log-retention/put(actions/set-artifact-and-log-retention-settings-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get fork PR contributor approval permissions for an organization
    ///
    /// Gets the fork PR contributor approval policy for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-organization)`.
    public enum ActionsGetForkPrContributorApprovalPermissionsOrganization {
        public static let id: Swift.String = "actions/get-fork-pr-contributor-approval-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input.Path,
                headers: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsForkPrContributorApproval)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsForkPrContributorApproval {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetForkPrContributorApprovalPermissionsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/get(actions/get-fork-pr-contributor-approval-permissions-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set fork PR contributor approval permissions for an organization
    ///
    /// Sets the fork PR contributor approval policy for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/fork-pr-contributor-approval`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)`.
    public enum ActionsSetForkPrContributorApprovalPermissionsOrganization {
        public static let id: Swift.String = "actions/set-fork-pr-contributor-approval-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-contributor-approval/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.ActionsForkPrContributorApproval)
            }
            public var body: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Path,
                headers: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Headers = .init(),
                body: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetForkPrContributorApprovalPermissionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-contributor-approval/put(actions/set-fork-pr-contributor-approval-permissions-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get private repo fork PR workflow settings for an organization
    ///
    /// Gets the settings for whether workflows from fork pull requests can run on private repositories in an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-organization)`.
    public enum ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization {
        public static let id: Swift.String = "actions/get-private-repo-fork-pr-workflows-settings-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Path,
                headers: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsForkPrWorkflowsPrivateRepos)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsForkPrWorkflowsPrivateRepos {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/get(actions/get-private-repo-fork-pr-workflows-settings-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set private repo fork PR workflow settings for an organization
    ///
    /// Sets the settings for whether workflows from fork pull requests can run on private repositories in an organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)`.
    public enum ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization {
        public static let id: Swift.String = "actions/set-private-repo-fork-pr-workflows-settings-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.ActionsForkPrWorkflowsPrivateReposRequest)
            }
            public var body: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Path,
                headers: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Headers = .init(),
                body: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Empty response for successful settings update
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.NoContent)
            /// Empty response for successful settings update
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/PUT/responses/403/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden - Fork PR workflow settings for private repositories are managed by the enterprise owner
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ActionsSetPrivateRepoForkPrWorkflowsSettingsOrganization.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/fork-pr-workflows-private-repos/put(actions/set-private-repo-fork-pr-workflows-settings-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List selected repositories enabled for GitHub Actions in an organization
    ///
    /// Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/get(actions/list-selected-repositories-enabled-github-actions-organization)`.
    public enum ActionsListSelectedRepositoriesEnabledGithubActionsOrganization {
        public static let id: Swift.String = "actions/list-selected-repositories-enabled-github-actions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Path,
                query: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Query = .init(),
                headers: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Double
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.Repository]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositories:
                        public init(
                            totalCount: Swift.Double,
                            repositories: [Components.Schemas.Repository]
                        ) {
                            self.totalCount = totalCount
                            self.repositories = repositories
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositories
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/get(actions/list-selected-repositories-enabled-github-actions-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set selected repositories enabled for GitHub Actions in an organization
    ///
    /// Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/put(actions/set-selected-repositories-enabled-github-actions-organization)`.
    public enum ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization {
        public static let id: Swift.String = "actions/set-selected-repositories-enabled-github-actions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// List of repository IDs to enable for GitHub Actions.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedRepositoryIds: List of repository IDs to enable for GitHub Actions.
                    public init(selectedRepositoryIds: [Swift.Int]) {
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/PUT/requestBody/content/application\/json`.
                case json(Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Body.JsonPayload)
            }
            public var body: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - body:
            public init(
                path: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Path,
                body: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input.Body
            ) {
                self.path = path
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/put(actions/set-selected-repositories-enabled-github-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/put(actions/set-selected-repositories-enabled-github-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Enable a selected repository for GitHub Actions in an organization
    ///
    /// Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/put(actions/enable-selected-repository-github-actions-organization)`.
    public enum ActionsEnableSelectedRepositoryGithubActionsOrganization {
        public static let id: Swift.String = "actions/enable-selected-repository-github-actions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/{repository_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/{repository_id}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the repository.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/{repository_id}/PUT/path/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - repositoryId: The unique identifier of the repository.
                public init(
                    org: Components.Parameters.Org,
                    repositoryId: Components.Parameters.RepositoryId
                ) {
                    self.org = org
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/put(actions/enable-selected-repository-github-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/put(actions/enable-selected-repository-github-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Disable a selected repository for GitHub Actions in an organization
    ///
    /// Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/delete(actions/disable-selected-repository-github-actions-organization)`.
    public enum ActionsDisableSelectedRepositoryGithubActionsOrganization {
        public static let id: Swift.String = "actions/disable-selected-repository-github-actions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/{repository_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/{repository_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the repository.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/repositories/{repository_id}/DELETE/path/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - repositoryId: The unique identifier of the repository.
                public init(
                    org: Components.Parameters.Org,
                    repositoryId: Components.Parameters.RepositoryId
                ) {
                    self.org = org
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/delete(actions/disable-selected-repository-github-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/delete(actions/disable-selected-repository-github-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get allowed actions and reusable workflows for an organization
    ///
    /// Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/get(actions/get-allowed-actions-organization)`.
    public enum ActionsGetAllowedActionsOrganization {
        public static let id: Swift.String = "actions/get-allowed-actions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetAllowedActionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetAllowedActionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetAllowedActionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetAllowedActionsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetAllowedActionsOrganization.Input.Path,
                headers: Operations.ActionsGetAllowedActionsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SelectedActions)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SelectedActions {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetAllowedActionsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetAllowedActionsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/get(actions/get-allowed-actions-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetAllowedActionsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetAllowedActionsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set allowed actions and reusable workflows for an organization
    ///
    /// Sets the actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/put(actions/set-allowed-actions-organization)`.
    public enum ActionsSetAllowedActionsOrganization {
        public static let id: Swift.String = "actions/set-allowed-actions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetAllowedActionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/selected-actions/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.SelectedActions)
            }
            public var body: Operations.ActionsSetAllowedActionsOrganization.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - body:
            public init(
                path: Operations.ActionsSetAllowedActionsOrganization.Input.Path,
                body: Operations.ActionsSetAllowedActionsOrganization.Input.Body? = nil
            ) {
                self.path = path
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/put(actions/set-allowed-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetAllowedActionsOrganization.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/put(actions/set-allowed-actions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetAllowedActionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get self-hosted runners settings for an organization
    ///
    /// Gets the settings for self-hosted runners for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/self-hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/get(actions/get-self-hosted-runners-permissions-organization)`.
    public enum ActionsGetSelfHostedRunnersPermissionsOrganization {
        public static let id: Swift.String = "actions/get-self-hosted-runners-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input.Path,
                headers: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SelfHostedRunnersSettings)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SelfHostedRunnersSettings {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/get(actions/get-self-hosted-runners-permissions-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetSelfHostedRunnersPermissionsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/get(actions/get-self-hosted-runners-permissions-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/get(actions/get-self-hosted-runners-permissions-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set self-hosted runners settings for an organization
    ///
    /// Sets the settings for self-hosted runners for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)`.
    public enum ActionsSetSelfHostedRunnersPermissionsOrganization {
        public static let id: Swift.String = "actions/set-self-hosted-runners-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The policy that controls whether self-hosted runners can be used in the organization
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/requestBody/json/enabled_repositories`.
                    @frozen public enum EnabledRepositoriesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case selected = "selected"
                        case none = "none"
                    }
                    /// The policy that controls whether self-hosted runners can be used in the organization
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/requestBody/json/enabled_repositories`.
                    public var enabledRepositories: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Body.JsonPayload.EnabledRepositoriesPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - enabledRepositories: The policy that controls whether self-hosted runners can be used in the organization
                    public init(enabledRepositories: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Body.JsonPayload.EnabledRepositoriesPayload) {
                        self.enabledRepositories = enabledRepositories
                    }
                    public enum CodingKeys: String, CodingKey {
                        case enabledRepositories = "enabled_repositories"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/PUT/requestBody/content/application\/json`.
                case json(Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Body.JsonPayload)
            }
            public var body: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Path,
                headers: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Headers = .init(),
                body: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Output.NoContent)
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetSelfHostedRunnersPermissionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/put(actions/set-self-hosted-runners-permissions-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories allowed to use self-hosted runners in an organization
    ///
    /// Lists repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/self-hosted-runners/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/get(actions/list-selected-repositories-self-hosted-runners-organization)`.
    public enum ActionsListSelectedRepositoriesSelfHostedRunnersOrganization {
        public static let id: Swift.String = "actions/list-selected-repositories-self-hosted-runners-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Path,
                query: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Query = .init(),
                headers: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int?
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.Repository]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositories:
                        public init(
                            totalCount: Swift.Int? = nil,
                            repositories: [Components.Schemas.Repository]? = nil
                        ) {
                            self.totalCount = totalCount
                            self.repositories = repositories
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositories
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/get(actions/list-selected-repositories-self-hosted-runners-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsListSelectedRepositoriesSelfHostedRunnersOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/get(actions/list-selected-repositories-self-hosted-runners-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/get(actions/list-selected-repositories-self-hosted-runners-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set repositories allowed to use self-hosted runners in an organization
    ///
    /// Sets repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)`.
    public enum ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization {
        public static let id: Swift.String = "actions/set-selected-repositories-self-hosted-runners-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// IDs of repositories that can use repository-level self-hosted runners
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedRepositoryIds: IDs of repositories that can use repository-level self-hosted runners
                    public init(selectedRepositoryIds: [Swift.Int]) {
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/PUT/requestBody/content/application\/json`.
                case json(Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Body.JsonPayload)
            }
            public var body: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Path,
                headers: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Headers = .init(),
                body: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Output.NoContent)
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetSelectedRepositoriesSelfHostedRunnersOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/put(actions/set-selected-repositories-self-hosted-runners-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add a repository to the list of repositories allowed to use self-hosted runners in an organization
    ///
    /// Adds a repository to the list of repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)`.
    public enum ActionsEnableSelectedRepositorySelfHostedRunnersOrganization {
        public static let id: Swift.String = "actions/enable-selected-repository-self-hosted-runners-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the repository.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/PUT/path/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - repositoryId: The unique identifier of the repository.
                public init(
                    org: Components.Parameters.Org,
                    repositoryId: Components.Parameters.RepositoryId
                ) {
                    self.org = org
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input.Path,
                headers: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Output.NoContent)
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsEnableSelectedRepositorySelfHostedRunnersOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/put(actions/enable-selected-repository-self-hosted-runners-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a repository from the list of repositories allowed to use self-hosted runners in an organization
    ///
    /// Removes a repository from the list of repositories that are allowed to use self-hosted runners in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)`.
    public enum ActionsDisableSelectedRepositorySelfHostedRunnersOrganization {
        public static let id: Swift.String = "actions/disable-selected-repository-self-hosted-runners-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the repository.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/DELETE/path/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - repositoryId: The unique identifier of the repository.
                public init(
                    org: Components.Parameters.Org,
                    repositoryId: Components.Parameters.RepositoryId
                ) {
                    self.org = org
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input.Path,
                headers: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Output.NoContent)
            /// No content
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsDisableSelectedRepositorySelfHostedRunnersOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}/delete(actions/disable-selected-repository-self-hosted-runners-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get default workflow permissions for an organization
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
    /// as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-organization)`.
    public enum ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization {
        public static let id: Swift.String = "actions/get-github-actions-default-workflow-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Path,
                headers: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ActionsGetDefaultWorkflowPermissions)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ActionsGetDefaultWorkflowPermissions {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set default workflow permissions for an organization
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
    /// can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-organization)`.
    public enum ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization {
        public static let id: Swift.String = "actions/set-github-actions-default-workflow-permissions-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/permissions/workflow/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.ActionsSetDefaultWorkflowPermissions)
            }
            public var body: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - body:
            public init(
                path: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Path,
                body: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input.Body? = nil
            ) {
                self.path = path
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Success response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Output.NoContent)
            /// Success response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-organization)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List self-hosted runner groups for an organization
    ///
    /// Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/get(actions/list-self-hosted-runner-groups-for-org)`.
    public enum ActionsListSelfHostedRunnerGroupsForOrg {
        public static let id: Swift.String = "actions/list-self-hosted-runner-groups-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Only return runner groups that are allowed to be used by this repository.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/query/visible_to_repository`.
                public var visibleToRepository: Components.Parameters.VisibleToRepository?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - visibleToRepository: Only return runner groups that are allowed to be used by this repository.
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    visibleToRepository: Components.Parameters.VisibleToRepository? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                    self.visibleToRepository = visibleToRepository
                }
            }
            public var query: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListSelfHostedRunnerGroupsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActionsListSelfHostedRunnerGroupsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Path,
                query: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Query = .init(),
                headers: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Double
                        /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/responses/200/content/json/runner_groups`.
                        public var runnerGroups: [Components.Schemas.RunnerGroupsOrg]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - runnerGroups:
                        public init(
                            totalCount: Swift.Double,
                            runnerGroups: [Components.Schemas.RunnerGroupsOrg]
                        ) {
                            self.totalCount = totalCount
                            self.runnerGroups = runnerGroups
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case runnerGroups = "runner_groups"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/runner-groups/GET/responses/200/content/application\/json`.
                    case json(Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActionsLi