// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Search code
    ///
    /// Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
    ///
    /// `q=addClass+in:file+language:js+repo:jquery/jquery`
    ///
    /// This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
    ///
    /// Considerations for code search:
    ///
    /// Due to the complexity of searching code, there are a few restrictions on how searches are performed:
    ///
    /// *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
    /// *   Only files smaller than 384 KB are searchable.
    /// *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
    /// language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
    ///
    /// This endpoint requires you to authenticate and limits you to 10 requests per minute.
    ///
    /// - Remark: HTTP `GET /search/code`.
    /// - Remark: Generated from `#/paths//search/code/get(search/code)`.
    func searchCode(_ input: Operations.SearchCode.Input) async throws -> Operations.SearchCode.Output
    /// Search commits
    ///
    /// Find commits via various criteria on the default branch (usually `main`). This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
    /// metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
    ///
    /// `q=repo:octocat/Spoon-Knife+css`
    ///
    /// - Remark: HTTP `GET /search/commits`.
    /// - Remark: Generated from `#/paths//search/commits/get(search/commits)`.
    func searchCommits(_ input: Operations.SearchCommits.Input) async throws -> Operations.SearchCommits.Output
    /// Search issues and pull requests
    ///
    /// > [!WARNING]
    /// > **Notice:** Search for issues and pull requests will be overridden by advanced search on September 4, 2025.
    /// > You can read more about this change on [the GitHub blog](https://github.blog/changelog/2025-03-06-github-issues-projects-api-support-for-issues-advanced-search-and-more/).
    ///
    /// - Remark: HTTP `GET /search/issues`.
    /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)`.
    @available(*, deprecated)
    func searchIssuesAndPullRequests(_ input: Operations.SearchIssuesAndPullRequests.Input) async throws -> Operations.SearchIssuesAndPullRequests.Output
    /// Search labels
    ///
    /// Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
    ///
    /// `q=bug+defect+enhancement&repository_id=64778136`
    ///
    /// The labels that best match the query appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/labels`.
    /// - Remark: Generated from `#/paths//search/labels/get(search/labels)`.
    func searchLabels(_ input: Operations.SearchLabels.Input) async throws -> Operations.SearchLabels.Output
    /// Search repositories
    ///
    /// Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
    ///
    /// `q=tetris+language:assembly&sort=stars&order=desc`
    ///
    /// This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/repositories`.
    /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)`.
    func searchRepos(_ input: Operations.SearchRepos.Input) async throws -> Operations.SearchRepos.Output
    /// Search topics
    ///
    /// Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
    ///
    /// When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
    ///
    /// `q=ruby+is:featured`
    ///
    /// This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/topics`.
    /// - Remark: Generated from `#/paths//search/topics/get(search/topics)`.
    func searchTopics(_ input: Operations.SearchTopics.Input) async throws -> Operations.SearchTopics.Output
    /// Search users
    ///
    /// Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you're looking for a list of popular users, you might try this query:
    ///
    /// `q=tom+repos:%3E42+followers:%3E1000`
    ///
    /// This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
    ///
    /// This endpoint does not accept authentication and will only include publicly visible users. As an alternative, you can use the GraphQL API. The GraphQL API requires authentication and will return private users, including Enterprise Managed Users (EMUs), that you are authorized to view. For more information, see "[GraphQL Queries](https://docs.github.com/graphql/reference/queries#search)."
    ///
    /// - Remark: HTTP `GET /search/users`.
    /// - Remark: Generated from `#/paths//search/users/get(search/users)`.
    func searchUsers(_ input: Operations.SearchUsers.Input) async throws -> Operations.SearchUsers.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Search code
    ///
    /// Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
    ///
    /// `q=addClass+in:file+language:js+repo:jquery/jquery`
    ///
    /// This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
    ///
    /// Considerations for code search:
    ///
    /// Due to the complexity of searching code, there are a few restrictions on how searches are performed:
    ///
    /// *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
    /// *   Only files smaller than 384 KB are searchable.
    /// *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
    /// language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
    ///
    /// This endpoint requires you to authenticate and limits you to 10 requests per minute.
    ///
    /// - Remark: HTTP `GET /search/code`.
    /// - Remark: Generated from `#/paths//search/code/get(search/code)`.
    public func searchCode(
        query: Operations.SearchCode.Input.Query,
        headers: Operations.SearchCode.Input.Headers = .init()
    ) async throws -> Operations.SearchCode.Output {
        try await searchCode(Operations.SearchCode.Input(
            query: query,
            headers: headers
        ))
    }
    /// Search commits
    ///
    /// Find commits via various criteria on the default branch (usually `main`). This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
    /// metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
    ///
    /// `q=repo:octocat/Spoon-Knife+css`
    ///
    /// - Remark: HTTP `GET /search/commits`.
    /// - Remark: Generated from `#/paths//search/commits/get(search/commits)`.
    public func searchCommits(
        query: Operations.SearchCommits.Input.Query,
        headers: Operations.SearchCommits.Input.Headers = .init()
    ) async throws -> Operations.SearchCommits.Output {
        try await searchCommits(Operations.SearchCommits.Input(
            query: query,
            headers: headers
        ))
    }
    /// Search issues and pull requests
    ///
    /// > [!WARNING]
    /// > **Notice:** Search for issues and pull requests will be overridden by advanced search on September 4, 2025.
    /// > You can read more about this change on [the GitHub blog](https://github.blog/changelog/2025-03-06-github-issues-projects-api-support-for-issues-advanced-search-and-more/).
    ///
    /// - Remark: HTTP `GET /search/issues`.
    /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)`.
    @available(*, deprecated)
    public func searchIssuesAndPullRequests(
        query: Operations.SearchIssuesAndPullRequests.Input.Query,
        headers: Operations.SearchIssuesAndPullRequests.Input.Headers = .init()
    ) async throws -> Operations.SearchIssuesAndPullRequests.Output {
        try await searchIssuesAndPullRequests(Operations.SearchIssuesAndPullRequests.Input(
            query: query,
            headers: headers
        ))
    }
    /// Search labels
    ///
    /// Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
    ///
    /// `q=bug+defect+enhancement&repository_id=64778136`
    ///
    /// The labels that best match the query appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/labels`.
    /// - Remark: Generated from `#/paths//search/labels/get(search/labels)`.
    public func searchLabels(
        query: Operations.SearchLabels.Input.Query,
        headers: Operations.SearchLabels.Input.Headers = .init()
    ) async throws -> Operations.SearchLabels.Output {
        try await searchLabels(Operations.SearchLabels.Input(
            query: query,
            headers: headers
        ))
    }
    /// Search repositories
    ///
    /// Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
    ///
    /// `q=tetris+language:assembly&sort=stars&order=desc`
    ///
    /// This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/repositories`.
    /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)`.
    public func searchRepos(
        query: Operations.SearchRepos.Input.Query,
        headers: Operations.SearchRepos.Input.Headers = .init()
    ) async throws -> Operations.SearchRepos.Output {
        try await searchRepos(Operations.SearchRepos.Input(
            query: query,
            headers: headers
        ))
    }
    /// Search topics
    ///
    /// Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
    ///
    /// When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
    ///
    /// `q=ruby+is:featured`
    ///
    /// This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/topics`.
    /// - Remark: Generated from `#/paths//search/topics/get(search/topics)`.
    public func searchTopics(
        query: Operations.SearchTopics.Input.Query,
        headers: Operations.SearchTopics.Input.Headers = .init()
    ) async throws -> Operations.SearchTopics.Output {
        try await searchTopics(Operations.SearchTopics.Input(
            query: query,
            headers: headers
        ))
    }
    /// Search users
    ///
    /// Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you're looking for a list of popular users, you might try this query:
    ///
    /// `q=tom+repos:%3E42+followers:%3E1000`
    ///
    /// This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
    ///
    /// This endpoint does not accept authentication and will only include publicly visible users. As an alternative, you can use the GraphQL API. The GraphQL API requires authentication and will return private users, including Enterprise Managed Users (EMUs), that you are authorized to view. For more information, see "[GraphQL Queries](https://docs.github.com/graphql/reference/queries#search)."
    ///
    /// - Remark: HTTP `GET /search/users`.
    /// - Remark: Generated from `#/paths//search/users/get(search/users)`.
    public func searchUsers(
        query: Operations.SearchUsers.Input.Query,
        headers: Operations.SearchUsers.Input.Headers = .init()
    ) async throws -> Operations.SearchUsers.Output {
        try await searchUsers(Operations.SearchUsers.Input(
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// A collection of related issues and pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-milestone`.
        public struct NullableMilestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/node_id`.
            public var nodeId: Swift.String
            /// The number of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/number`.
            public var number: Swift.Int
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            public var state: Components.Schemas.NullableMilestone.StatePayload
            /// The title of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_issues`.
            public var closedIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/due_on`.
            public var dueOn: Foundation.Date?
            /// Creates a new `NullableMilestone`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - htmlUrl:
            ///   - labelsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number: The number of the milestone.
            ///   - state: The state of the milestone.
            ///   - title: The title of the milestone.
            ///   - description:
            ///   - creator:
            ///   - openIssues:
            ///   - closedIssues:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - dueOn:
            public init(
                url: Swift.String,
                htmlUrl: Swift.String,
                labelsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.NullableMilestone.StatePayload,
                title: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                openIssues: Swift.Int,
                closedIssues: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                dueOn: Foundation.Date? = nil
            ) {
                self.url = url
                self.htmlUrl = htmlUrl
                self.labelsUrl = labelsUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.state = state
                self.title = title
                self.description = description
                self.creator = creator
                self.openIssues = openIssues
                self.closedIssues = closedIssues
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.dueOn = dueOn
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case htmlUrl = "html_url"
                case labelsUrl = "labels_url"
                case id
                case nodeId = "node_id"
                case number
                case state
                case title
                case description
                case creator
                case openIssues = "open_issues"
                case closedIssues = "closed_issues"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case dueOn = "due_on"
            }
        }
        /// The type of issue.
        ///
        /// - Remark: Generated from `#/components/schemas/issue-type`.
        public struct IssueType: Codable, Hashable, Sendable {
            /// The unique identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/id`.
            public var id: Swift.Int
            /// The node identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/node_id`.
            public var nodeId: Swift.String
            /// The name of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/name`.
            public var name: Swift.String
            /// The description of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/description`.
            public var description: Swift.String?
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            @frozen public enum ColorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case gray = "gray"
                case blue = "blue"
                case green = "green"
                case yellow = "yellow"
                case orange = "orange"
                case red = "red"
                case pink = "pink"
                case purple = "purple"
            }
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            public var color: Components.Schemas.IssueType.ColorPayload?
            /// The time the issue type created.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/created_at`.
            public var createdAt: Foundation.Date?
            /// The time the issue type last updated.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The enabled state of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/is_enabled`.
            public var isEnabled: Swift.Bool?
            /// Creates a new `IssueType`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the issue type.
            ///   - nodeId: The node identifier of the issue type.
            ///   - name: The name of the issue type.
            ///   - description: The description of the issue type.
            ///   - color: The color of the issue type.
            ///   - createdAt: The time the issue type created.
            ///   - updatedAt: The time the issue type last updated.
            ///   - isEnabled: The enabled state of the issue type.
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                color: Components.Schemas.IssueType.ColorPayload? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                isEnabled: Swift.Bool? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.description = description
                self.color = color
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.isEnabled = isEnabled
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case description
                case color
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case isEnabled = "is_enabled"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-integration`.
        public struct NullableIntegration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            public var owner: Components.Schemas.NullableIntegration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public var permissions: Components.Schemas.NullableIntegration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `NullableIntegration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.NullableIntegration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.NullableIntegration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// How the author is associated with the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/author-association`.
        @frozen public enum AuthorAssociation: String, Codable, Hashable, Sendable, CaseIterable {
            case collaborator = "COLLABORATOR"
            case contributor = "CONTRIBUTOR"
            case firstTimer = "FIRST_TIMER"
            case firstTimeContributor = "FIRST_TIME_CONTRIBUTOR"
            case mannequin = "MANNEQUIN"
            case member = "MEMBER"
            case none = "NONE"
            case owner = "OWNER"
        }
        /// - Remark: Generated from `#/components/schemas/reaction-rollup`.
        public struct ReactionRollup: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/+1`.
            public var _plus_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/-1`.
            public var _hyphen_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/laugh`.
            public var laugh: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/confused`.
            public var confused: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/heart`.
            public var heart: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/hooray`.
            public var hooray: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/eyes`.
            public var eyes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/rocket`.
            public var rocket: Swift.Int
            /// Creates a new `ReactionRollup`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - totalCount:
            ///   - _plus_1:
            ///   - _hyphen_1:
            ///   - laugh:
            ///   - confused:
            ///   - heart:
            ///   - hooray:
            ///   - eyes:
            ///   - rocket:
            public init(
                url: Swift.String,
                totalCount: Swift.Int,
                _plus_1: Swift.Int,
                _hyphen_1: Swift.Int,
                laugh: Swift.Int,
                confused: Swift.Int,
                heart: Swift.Int,
                hooray: Swift.Int,
                eyes: Swift.Int,
                rocket: Swift.Int
            ) {
                self.url = url
                self.totalCount = totalCount
                self._plus_1 = _plus_1
                self._hyphen_1 = _hyphen_1
                self.laugh = laugh
                self.confused = confused
                self.heart = heart
                self.hooray = hooray
                self.eyes = eyes
                self.rocket = rocket
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case totalCount = "total_count"
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh
                case confused
                case heart
                case hooray
                case eyes
                case rocket
            }
        }
        /// - Remark: Generated from `#/components/schemas/sub-issues-summary`.
        public struct SubIssuesSummary: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/total`.
            public var total: Swift.Int
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/completed`.
            public var completed: Swift.Int
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/percent_completed`.
            public var percentCompleted: Swift.Int
            /// Creates a new `SubIssuesSummary`.
            ///
            /// - Parameters:
            ///   - total:
            ///   - completed:
            ///   - percentCompleted:
            public init(
                total: Swift.Int,
                completed: Swift.Int,
                percentCompleted: Swift.Int
            ) {
                self.total = total
                self.completed = completed
                self.percentCompleted = percentCompleted
            }
            public enum CodingKeys: String, CodingKey {
                case total
                case completed
                case percentCompleted = "percent_completed"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// Metaproperties for Git author/committer information.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-git-user`.
        public struct NullableGitUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/date`.
            public var date: Swift.String?
            /// Creates a new `NullableGitUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - date:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                date: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.date = date
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case date
            }
        }
        /// - Remark: Generated from `#/components/schemas/verification`.
        public struct Verification: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/verification/verified`.
            public var verified: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/verification/reason`.
            public var reason: Swift.String
            /// - Remark: Generated from `#/components/schemas/verification/payload`.
            public var payload: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/signature`.
            public var signature: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/verified_at`.
            public var verifiedAt: Swift.String?
            /// Creates a new `Verification`.
            ///
            /// - Parameters:
            ///   - verified:
            ///   - reason:
            ///   - payload:
            ///   - signature:
            ///   - verifiedAt:
            public init(
                verified: Swift.Bool,
                reason: Swift.String,
                payload: Swift.String? = nil,
                signature: Swift.String? = nil,
                verifiedAt: Swift.String? = nil
            ) {
                self.verified = verified
                self.reason = reason
                self.payload = payload
                self.signature = signature
                self.verifiedAt = verifiedAt
            }
            public enum CodingKeys: String, CodingKey {
                case verified
                case reason
                case payload
                case signature
                case verifiedAt = "verified_at"
            }
        }
        /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches`.
        public struct SearchResultTextMatchesPayload: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/object_url`.
            public var objectUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/object_type`.
            public var objectType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/property`.
            public var property: Swift.String?
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/fragment`.
            public var fragment: Swift.String?
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/MatchesPayload`.
            public struct MatchesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/MatchesPayload/text`.
                public var text: Swift.String?
                /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/MatchesPayload/indices`.
                public var indices: [Swift.Int]?
                /// Creates a new `MatchesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - text:
                ///   - indices:
                public init(
                    text: Swift.String? = nil,
                    indices: [Swift.Int]? = nil
                ) {
                    self.text = text
                    self.indices = indices
                }
                public enum CodingKeys: String, CodingKey {
                    case text
                    case indices
                }
            }
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/matches`.
            public typealias MatchesPayload = [Components.Schemas.SearchResultTextMatchesPayload.MatchesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/SearchResultTextMatches/matches`.
            public var matches: Components.Schemas.SearchResultTextMatchesPayload.MatchesPayload?
            /// Creates a new `SearchResultTextMatchesPayload`.
            ///
            /// - Parameters:
            ///   - objectUrl:
            ///   - objectType:
            ///   - property:
            ///   - fragment:
            ///   - matches:
            public init(
                objectUrl: Swift.String? = nil,
                objectType: Swift.String? = nil,
                property: Swift.String? = nil,
                fragment: Swift.String? = nil,
                matches: Components.Schemas.SearchResultTextMatchesPayload.MatchesPayload? = nil
            ) {
                self.objectUrl = objectUrl
                self.objectType = objectType
                self.property = property
                self.fragment = fragment
                self.matches = matches
            }
            public enum CodingKeys: String, CodingKey {
                case objectUrl = "object_url"
                case objectType = "object_type"
                case property
                case fragment
                case matches
            }
        }
        /// - Remark: Generated from `#/components/schemas/search-result-text-matches`.
        public typealias SearchResultTextMatches = [Components.Schemas.SearchResultTextMatchesPayload]
        /// Code Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/code-search-result-item`.
        public struct CodeSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/file_size`.
            public var fileSize: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/last_modified_at`.
            public var lastModifiedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/line_numbers`.
            public var lineNumbers: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/code-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// Creates a new `CodeSearchResultItem`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - path:
            ///   - sha:
            ///   - url:
            ///   - gitUrl:
            ///   - htmlUrl:
            ///   - repository:
            ///   - score:
            ///   - fileSize:
            ///   - language:
            ///   - lastModifiedAt:
            ///   - lineNumbers:
            ///   - textMatches:
            public init(
                name: Swift.String,
                path: Swift.String,
                sha: Swift.String,
                url: Swift.String,
                gitUrl: Swift.String,
                htmlUrl: Swift.String,
                repository: Components.Schemas.MinimalRepository,
                score: Swift.Double,
                fileSize: Swift.Int? = nil,
                language: Swift.String? = nil,
                lastModifiedAt: Foundation.Date? = nil,
                lineNumbers: [Swift.String]? = nil,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil
            ) {
                self.name = name
                self.path = path
                self.sha = sha
                self.url = url
                self.gitUrl = gitUrl
                self.htmlUrl = htmlUrl
                self.repository = repository
                self.score = score
                self.fileSize = fileSize
                self.language = language
                self.lastModifiedAt = lastModifiedAt
                self.lineNumbers = lineNumbers
                self.textMatches = textMatches
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case path
                case sha
                case url
                case gitUrl = "git_url"
                case htmlUrl = "html_url"
                case repository
                case score
                case fileSize = "file_size"
                case language
                case lastModifiedAt = "last_modified_at"
                case lineNumbers = "line_numbers"
                case textMatches = "text_matches"
            }
        }
        /// Commit Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/commit-search-result-item`.
        public struct CommitSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit`.
            public struct CommitPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/author`.
                public struct AuthorPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/author/name`.
                    public var name: Swift.String
                    /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/author/email`.
                    public var email: Swift.String
                    /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/author/date`.
                    public var date: Foundation.Date
                    /// Creates a new `AuthorPayload`.
                    ///
                    /// - Parameters:
                    ///   - name:
                    ///   - email:
                    ///   - date:
                    public init(
                        name: Swift.String,
                        email: Swift.String,
                        date: Foundation.Date
                    ) {
                        self.name = name
                        self.email = email
                        self.date = date
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case email
                        case date
                    }
                }
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/author`.
                public var author: Components.Schemas.CommitSearchResultItem.CommitPayload.AuthorPayload
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/committer`.
                public var committer: Components.Schemas.NullableGitUser?
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/comment_count`.
                public var commentCount: Swift.Int
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/message`.
                public var message: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/tree`.
                public struct TreePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/tree/sha`.
                    public var sha: Swift.String
                    /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/tree/url`.
                    public var url: Swift.String
                    /// Creates a new `TreePayload`.
                    ///
                    /// - Parameters:
                    ///   - sha:
                    ///   - url:
                    public init(
                        sha: Swift.String,
                        url: Swift.String
                    ) {
                        self.sha = sha
                        self.url = url
                    }
                    public enum CodingKeys: String, CodingKey {
                        case sha
                        case url
                    }
                }
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/tree`.
                public var tree: Components.Schemas.CommitSearchResultItem.CommitPayload.TreePayload
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit/verification`.
                public var verification: Components.Schemas.Verification?
                /// Creates a new `CommitPayload`.
                ///
                /// - Parameters:
                ///   - author:
                ///   - committer:
                ///   - commentCount:
                ///   - message:
                ///   - tree:
                ///   - url:
                ///   - verification:
                public init(
                    author: Components.Schemas.CommitSearchResultItem.CommitPayload.AuthorPayload,
                    committer: Components.Schemas.NullableGitUser? = nil,
                    commentCount: Swift.Int,
                    message: Swift.String,
                    tree: Components.Schemas.CommitSearchResultItem.CommitPayload.TreePayload,
                    url: Swift.String,
                    verification: Components.Schemas.Verification? = nil
                ) {
                    self.author = author
                    self.committer = committer
                    self.commentCount = commentCount
                    self.message = message
                    self.tree = tree
                    self.url = url
                    self.verification = verification
                }
                public enum CodingKeys: String, CodingKey {
                    case author
                    case committer
                    case commentCount = "comment_count"
                    case message
                    case tree
                    case url
                    case verification
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/commit`.
            public var commit: Components.Schemas.CommitSearchResultItem.CommitPayload
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/author`.
            public var author: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/committer`.
            public var committer: Components.Schemas.NullableGitUser?
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/ParentsPayload`.
            public struct ParentsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/ParentsPayload/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/ParentsPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/commit-search-result-item/ParentsPayload/sha`.
                public var sha: Swift.String?
                /// Creates a new `ParentsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - htmlUrl:
                ///   - sha:
                public init(
                    url: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    sha: Swift.String? = nil
                ) {
                    self.url = url
                    self.htmlUrl = htmlUrl
                    self.sha = sha
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case htmlUrl = "html_url"
                    case sha
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/parents`.
            public typealias ParentsPayload = [Components.Schemas.CommitSearchResultItem.ParentsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/parents`.
            public var parents: Components.Schemas.CommitSearchResultItem.ParentsPayload
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// Creates a new `CommitSearchResultItem`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - sha:
            ///   - htmlUrl:
            ///   - commentsUrl:
            ///   - commit:
            ///   - author:
            ///   - committer:
            ///   - parents:
            ///   - repository:
            ///   - score:
            ///   - nodeId:
            ///   - textMatches:
            public init(
                url: Swift.String,
                sha: Swift.String,
                htmlUrl: Swift.String,
                commentsUrl: Swift.String,
                commit: Components.Schemas.CommitSearchResultItem.CommitPayload,
                author: Components.Schemas.NullableSimpleUser? = nil,
                committer: Components.Schemas.NullableGitUser? = nil,
                parents: Components.Schemas.CommitSearchResultItem.ParentsPayload,
                repository: Components.Schemas.MinimalRepository,
                score: Swift.Double,
                nodeId: Swift.String,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil
            ) {
                self.url = url
                self.sha = sha
                self.htmlUrl = htmlUrl
                self.commentsUrl = commentsUrl
                self.commit = commit
                self.author = author
                self.committer = committer
                self.parents = parents
                self.repository = repository
                self.score = score
                self.nodeId = nodeId
                self.textMatches = textMatches
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case sha
                case htmlUrl = "html_url"
                case commentsUrl = "comments_url"
                case commit
                case author
                case committer
                case parents
                case repository
                case score
                case nodeId = "node_id"
                case textMatches = "text_matches"
            }
        }
        /// Issue Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/issue-search-result-item`.
        public struct IssueSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/repository_url`.
            public var repositoryUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/locked`.
            public var locked: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/active_lock_reason`.
            public var activeLockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload`.
            public struct LabelsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/id`.
                public var id: Swift.Int64?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/node_id`.
                public var nodeId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/color`.
                public var color: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/default`.
                public var _default: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/LabelsPayload/description`.
                public var description: Swift.String?
                /// Creates a new `LabelsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - nodeId:
                ///   - url:
                ///   - name:
                ///   - color:
                ///   - _default:
                ///   - description:
                public init(
                    id: Swift.Int64? = nil,
                    nodeId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    name: Swift.String? = nil,
                    color: Swift.String? = nil,
                    _default: Swift.Bool? = nil,
                    description: Swift.String? = nil
                ) {
                    self.id = id
                    self.nodeId = nodeId
                    self.url = url
                    self.name = name
                    self.color = color
                    self._default = _default
                    self.description = description
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case nodeId = "node_id"
                    case url
                    case name
                    case color
                    case _default = "default"
                    case description
                }
            }
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/labels`.
            public typealias LabelsPayload = [Components.Schemas.IssueSearchResultItem.LabelsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/labels`.
            public var labels: Components.Schemas.IssueSearchResultItem.LabelsPayload
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/sub_issues_summary`.
            public var subIssuesSummary: Components.Schemas.SubIssuesSummary?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/state_reason`.
            public var stateReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/milestone`.
            public var milestone: Components.Schemas.NullableMilestone?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/comments`.
            public var comments: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request`.
            public struct PullRequestPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request/merged_at`.
                public var mergedAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request/diff_url`.
                public var diffUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request/patch_url`.
                public var patchUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request/url`.
                public var url: Swift.String?
                /// Creates a new `PullRequestPayload`.
                ///
                /// - Parameters:
                ///   - mergedAt:
                ///   - diffUrl:
                ///   - htmlUrl:
                ///   - patchUrl:
                ///   - url:
                public init(
                    mergedAt: Foundation.Date? = nil,
                    diffUrl: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    patchUrl: Swift.String? = nil,
                    url: Swift.String? = nil
                ) {
                    self.mergedAt = mergedAt
                    self.diffUrl = diffUrl
                    self.htmlUrl = htmlUrl
                    self.patchUrl = patchUrl
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case mergedAt = "merged_at"
                    case diffUrl = "diff_url"
                    case htmlUrl = "html_url"
                    case patchUrl = "patch_url"
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/pull_request`.
            public var pullRequest: Components.Schemas.IssueSearchResultItem.PullRequestPayload?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/draft`.
            public var draft: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/repository`.
            public var repository: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/timeline_url`.
            public var timelineUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/type`.
            public var _type: Components.Schemas.IssueType?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/issue-search-result-item/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `IssueSearchResultItem`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - repositoryUrl:
            ///   - labelsUrl:
            ///   - commentsUrl:
            ///   - eventsUrl:
            ///   - htmlUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number:
            ///   - title:
            ///   - locked:
            ///   - activeLockReason:
            ///   - assignees:
            ///   - user:
            ///   - labels:
            ///   - subIssuesSummary:
            ///   - state:
            ///   - stateReason:
            ///   - assignee:
            ///   - milestone:
            ///   - comments:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - textMatches:
            ///   - pullRequest:
            ///   - body:
            ///   - score:
            ///   - authorAssociation:
            ///   - draft:
            ///   - repository:
            ///   - bodyHtml:
            ///   - bodyText:
            ///   - timelineUrl:
            ///   - _type:
            ///   - performedViaGithubApp:
            ///   - reactions:
            public init(
                url: Swift.String,
                repositoryUrl: Swift.String,
                labelsUrl: Swift.String,
                commentsUrl: Swift.String,
                eventsUrl: Swift.String,
                htmlUrl: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                number: Swift.Int,
                title: Swift.String,
                locked: Swift.Bool,
                activeLockReason: Swift.String? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                labels: Components.Schemas.IssueSearchResultItem.LabelsPayload,
                subIssuesSummary: Components.Schemas.SubIssuesSummary? = nil,
                state: Swift.String,
                stateReason: Swift.String? = nil,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                milestone: Components.Schemas.NullableMilestone? = nil,
                comments: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil,
                pullRequest: Components.Schemas.IssueSearchResultItem.PullRequestPayload? = nil,
                body: Swift.String? = nil,
                score: Swift.Double,
                authorAssociation: Components.Schemas.AuthorAssociation,
                draft: Swift.Bool? = nil,
                repository: Components.Schemas.Repository? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                timelineUrl: Swift.String? = nil,
                _type: Components.Schemas.IssueType? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.url = url
                self.repositoryUrl = repositoryUrl
                self.labelsUrl = labelsUrl
                self.commentsUrl = commentsUrl
                self.eventsUrl = eventsUrl
                self.htmlUrl = htmlUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.title = title
                self.locked = locked
                self.activeLockReason = activeLockReason
                self.assignees = assignees
                self.user = user
                self.labels = labels
                self.subIssuesSummary = subIssuesSummary
                self.state = state
                self.stateReason = stateReason
                self.assignee = assignee
                self.milestone = milestone
                self.comments = comments
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.textMatches = textMatches
                self.pullRequest = pullRequest
                self.body = body
                self.score = score
                self.authorAssociation = authorAssociation
                self.draft = draft
                self.repository = repository
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
                self.timelineUrl = timelineUrl
                self._type = _type
                self.performedViaGithubApp = performedViaGithubApp
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case repositoryUrl = "repository_url"
                case labelsUrl = "labels_url"
                case commentsUrl = "comments_url"
                case eventsUrl = "events_url"
                case htmlUrl = "html_url"
                case id
                case nodeId = "node_id"
                case number
                case title
                case locked
                case activeLockReason = "active_lock_reason"
                case assignees
                case user
                case labels
                case subIssuesSummary = "sub_issues_summary"
                case state
                case stateReason = "state_reason"
                case assignee
                case milestone
                case comments
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case textMatches = "text_matches"
                case pullRequest = "pull_request"
                case body
                case score
                case authorAssociation = "author_association"
                case draft
                case repository
                case bodyHtml = "body_html"
                case bodyText = "body_text"
                case timelineUrl = "timeline_url"
                case _type = "type"
                case performedViaGithubApp = "performed_via_github_app"
                case reactions
            }
        }
        /// Label Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/label-search-result-item`.
        public struct LabelSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/color`.
            public var color: Swift.String
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/default`.
            public var _default: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/label-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// Creates a new `LabelSearchResultItem`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - name:
            ///   - color:
            ///   - _default:
            ///   - description:
            ///   - score:
            ///   - textMatches:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                name: Swift.String,
                color: Swift.String,
                _default: Swift.Bool,
                description: Swift.String? = nil,
                score: Swift.Double,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.name = name
                self.color = color
                self._default = _default
                self.description = description
                self.score = score
                self.textMatches = textMatches
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case name
                case color
                case _default = "default"
                case description
                case score
                case textMatches = "text_matches"
            }
        }
        /// Repo Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/repo-search-result-item`.
        public struct RepoSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/owner`.
            public var owner: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/pushed_at`.
            public var pushedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/size`.
            public var size: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/watchers_count`.
            public var watchersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/has_issues`.
            public var hasIssues: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/has_projects`.
            public var hasProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/has_pages`.
            public var hasPages: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/has_downloads`.
            public var hasDownloads: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions/pull`.
                public var pull: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/permissions`.
            public var permissions: Components.Schemas.RepoSearchResultItem.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repo-search-result-item/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// Creates a new `RepoSearchResultItem`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - pushedAt:
            ///   - homepage:
            ///   - size:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - language:
            ///   - forksCount:
            ///   - openIssuesCount:
            ///   - masterBranch:
            ///   - defaultBranch:
            ///   - score:
            ///   - forksUrl:
            ///   - keysUrl:
            ///   - collaboratorsUrl:
            ///   - teamsUrl:
            ///   - hooksUrl:
            ///   - issueEventsUrl:
            ///   - eventsUrl:
            ///   - assigneesUrl:
            ///   - branchesUrl:
            ///   - tagsUrl:
            ///   - blobsUrl:
            ///   - gitTagsUrl:
            ///   - gitRefsUrl:
            ///   - treesUrl:
            ///   - statusesUrl:
            ///   - languagesUrl:
            ///   - stargazersUrl:
            ///   - contributorsUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - commitsUrl:
            ///   - gitCommitsUrl:
            ///   - commentsUrl:
            ///   - issueCommentUrl:
            ///   - contentsUrl:
            ///   - compareUrl:
            ///   - mergesUrl:
            ///   - archiveUrl:
            ///   - downloadsUrl:
            ///   - issuesUrl:
            ///   - pullsUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - labelsUrl:
            ///   - releasesUrl:
            ///   - deploymentsUrl:
            ///   - gitUrl:
            ///   - sshUrl:
            ///   - cloneUrl:
            ///   - svnUrl:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - topics:
            ///   - mirrorUrl:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasPages:
            ///   - hasWiki:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - license:
            ///   - permissions:
            ///   - textMatches:
            ///   - tempCloneToken:
            ///   - allowMergeCommit:
            ///   - allowSquashMerge:
            ///   - allowRebaseMerge:
            ///   - allowAutoMerge:
            ///   - deleteBranchOnMerge:
            ///   - allowForking:
            ///   - isTemplate:
            ///   - webCommitSignoffRequired:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.NullableSimpleUser? = nil,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                pushedAt: Foundation.Date,
                homepage: Swift.String? = nil,
                size: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                openIssuesCount: Swift.Int,
                masterBranch: Swift.String? = nil,
                defaultBranch: Swift.String,
                score: Swift.Double,
                forksUrl: Swift.String,
                keysUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                teamsUrl: Swift.String,
                hooksUrl: Swift.String,
                issueEventsUrl: Swift.String,
                eventsUrl: Swift.String,
                assigneesUrl: Swift.String,
                branchesUrl: Swift.String,
                tagsUrl: Swift.String,
                blobsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                treesUrl: Swift.String,
                statusesUrl: Swift.String,
                languagesUrl: Swift.String,
                stargazersUrl: Swift.String,
                contributorsUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                commitsUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                commentsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                contentsUrl: Swift.String,
                compareUrl: Swift.String,
                mergesUrl: Swift.String,
                archiveUrl: Swift.String,
                downloadsUrl: Swift.String,
                issuesUrl: Swift.String,
                pullsUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                labelsUrl: Swift.String,
                releasesUrl: Swift.String,
                deploymentsUrl: Swift.String,
                gitUrl: Swift.String,
                sshUrl: Swift.String,
                cloneUrl: Swift.String,
                svnUrl: Swift.String,
                forks: Swift.Int,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                topics: [Swift.String]? = nil,
                mirrorUrl: Swift.String? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasPages: Swift.Bool,
                hasWiki: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                permissions: Components.Schemas.RepoSearchResultItem.PermissionsPayload? = nil,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil,
                tempCloneToken: Swift.String? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                isTemplate: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.pushedAt = pushedAt
                self.homepage = homepage
                self.size = size
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.language = language
                self.forksCount = forksCount
                self.openIssuesCount = openIssuesCount
                self.masterBranch = masterBranch
                self.defaultBranch = defaultBranch
                self.score = score
                self.forksUrl = forksUrl
                self.keysUrl = keysUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.teamsUrl = teamsUrl
                self.hooksUrl = hooksUrl
                self.issueEventsUrl = issueEventsUrl
                self.eventsUrl = eventsUrl
                self.assigneesUrl = assigneesUrl
                self.branchesUrl = branchesUrl
                self.tagsUrl = tagsUrl
                self.blobsUrl = blobsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitRefsUrl = gitRefsUrl
                self.treesUrl = treesUrl
                self.statusesUrl = statusesUrl
                self.languagesUrl = languagesUrl
                self.stargazersUrl = stargazersUrl
                self.contributorsUrl = contributorsUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.commitsUrl = commitsUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.commentsUrl = commentsUrl
                self.issueCommentUrl = issueCommentUrl
                self.contentsUrl = contentsUrl
                self.compareUrl = compareUrl
                self.mergesUrl = mergesUrl
                self.archiveUrl = archiveUrl
                self.downloadsUrl = downloadsUrl
                self.issuesUrl = issuesUrl
                self.pullsUrl = pullsUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.labelsUrl = labelsUrl
                self.releasesUrl = releasesUrl
                self.deploymentsUrl = deploymentsUrl
                self.gitUrl = gitUrl
                self.sshUrl = sshUrl
                self.cloneUrl = cloneUrl
                self.svnUrl = svnUrl
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.topics = topics
                self.mirrorUrl = mirrorUrl
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasPages = hasPages
                self.hasWiki = hasWiki
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.license = license
                self.permissions = permissions
                self.textMatches = textMatches
                self.tempCloneToken = tempCloneToken
                self.allowMergeCommit = allowMergeCommit
                self.allowSquashMerge = allowSquashMerge
                self.allowRebaseMerge = allowRebaseMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowForking = allowForking
                self.isTemplate = isTemplate
                self.webCommitSignoffRequired = webCommitSignoffRequired
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case pushedAt = "pushed_at"
                case homepage
                case size
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case language
                case forksCount = "forks_count"
                case openIssuesCount = "open_issues_count"
                case masterBranch = "master_branch"
                case defaultBranch = "default_branch"
                case score
                case forksUrl = "forks_url"
                case keysUrl = "keys_url"
                case collaboratorsUrl = "collaborators_url"
                case teamsUrl = "teams_url"
                case hooksUrl = "hooks_url"
                case issueEventsUrl = "issue_events_url"
                case eventsUrl = "events_url"
                case assigneesUrl = "assignees_url"
                case branchesUrl = "branches_url"
                case tagsUrl = "tags_url"
                case blobsUrl = "blobs_url"
                case gitTagsUrl = "git_tags_url"
                case gitRefsUrl = "git_refs_url"
                case treesUrl = "trees_url"
                case statusesUrl = "statuses_url"
                case languagesUrl = "languages_url"
                case stargazersUrl = "stargazers_url"
                case contributorsUrl = "contributors_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case commitsUrl = "commits_url"
                case gitCommitsUrl = "git_commits_url"
                case commentsUrl = "comments_url"
                case issueCommentUrl = "issue_comment_url"
                case contentsUrl = "contents_url"
                case compareUrl = "compare_url"
                case mergesUrl = "merges_url"
                case archiveUrl = "archive_url"
                case downloadsUrl = "downloads_url"
                case issuesUrl = "issues_url"
                case pullsUrl = "pulls_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case labelsUrl = "labels_url"
                case releasesUrl = "releases_url"
                case deploymentsUrl = "deployments_url"
                case gitUrl = "git_url"
                case sshUrl = "ssh_url"
                case cloneUrl = "clone_url"
                case svnUrl = "svn_url"
                case forks
                case openIssues = "open_issues"
                case watchers
                case topics
                case mirrorUrl = "mirror_url"
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasPages = "has_pages"
                case hasWiki = "has_wiki"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case license
                case permissions
                case textMatches = "text_matches"
                case tempCloneToken = "temp_clone_token"
                case allowMergeCommit = "allow_merge_commit"
                case allowSquashMerge = "allow_squash_merge"
                case allowRebaseMerge = "allow_rebase_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowForking = "allow_forking"
                case isTemplate = "is_template"
                case webCommitSignoffRequired = "web_commit_signoff_required"
            }
        }
        /// Topic Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/topic-search-result-item`.
        public struct TopicSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/display_name`.
            public var displayName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/short_description`.
            public var shortDescription: Swift.String?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/created_by`.
            public var createdBy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/released`.
            public var released: Swift.String?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/featured`.
            public var featured: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/curated`.
            public var curated: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/repository_count`.
            public var repositoryCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/logo_url`.
            public var logoUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload`.
            public struct RelatedPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload/topic_relation`.
                public struct TopicRelationPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload/topic_relation/id`.
                    public var id: Swift.Int?
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload/topic_relation/name`.
                    public var name: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload/topic_relation/topic_id`.
                    public var topicId: Swift.Int?
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload/topic_relation/relation_type`.
                    public var relationType: Swift.String?
                    /// Creates a new `TopicRelationPayload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - name:
                    ///   - topicId:
                    ///   - relationType:
                    public init(
                        id: Swift.Int? = nil,
                        name: Swift.String? = nil,
                        topicId: Swift.Int? = nil,
                        relationType: Swift.String? = nil
                    ) {
                        self.id = id
                        self.name = name
                        self.topicId = topicId
                        self.relationType = relationType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case name
                        case topicId = "topic_id"
                        case relationType = "relation_type"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/topic-search-result-item/RelatedPayload/topic_relation`.
                public var topicRelation: Components.Schemas.TopicSearchResultItem.RelatedPayloadPayload.TopicRelationPayload?
                /// Creates a new `RelatedPayloadPayload`.
                ///
                /// - Parameters:
                ///   - topicRelation:
                public init(topicRelation: Components.Schemas.TopicSearchResultItem.RelatedPayloadPayload.TopicRelationPayload? = nil) {
                    self.topicRelation = topicRelation
                }
                public enum CodingKeys: String, CodingKey {
                    case topicRelation = "topic_relation"
                }
            }
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/related`.
            public typealias RelatedPayload = [Components.Schemas.TopicSearchResultItem.RelatedPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/related`.
            public var related: Components.Schemas.TopicSearchResultItem.RelatedPayload?
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload`.
            public struct AliasesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload/topic_relation`.
                public struct TopicRelationPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload/topic_relation/id`.
                    public var id: Swift.Int?
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload/topic_relation/name`.
                    public var name: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload/topic_relation/topic_id`.
                    public var topicId: Swift.Int?
                    /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload/topic_relation/relation_type`.
                    public var relationType: Swift.String?
                    /// Creates a new `TopicRelationPayload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - name:
                    ///   - topicId:
                    ///   - relationType:
                    public init(
                        id: Swift.Int? = nil,
                        name: Swift.String? = nil,
                        topicId: Swift.Int? = nil,
                        relationType: Swift.String? = nil
                    ) {
                        self.id = id
                        self.name = name
                        self.topicId = topicId
                        self.relationType = relationType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case name
                        case topicId = "topic_id"
                        case relationType = "relation_type"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/topic-search-result-item/AliasesPayload/topic_relation`.
                public var topicRelation: Components.Schemas.TopicSearchResultItem.AliasesPayloadPayload.TopicRelationPayload?
                /// Creates a new `AliasesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - topicRelation:
                public init(topicRelation: Components.Schemas.TopicSearchResultItem.AliasesPayloadPayload.TopicRelationPayload? = nil) {
                    self.topicRelation = topicRelation
                }
                public enum CodingKeys: String, CodingKey {
                    case topicRelation = "topic_relation"
                }
            }
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/aliases`.
            public typealias AliasesPayload = [Components.Schemas.TopicSearchResultItem.AliasesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/topic-search-result-item/aliases`.
            public var aliases: Components.Schemas.TopicSearchResultItem.AliasesPayload?
            /// Creates a new `TopicSearchResultItem`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - displayName:
            ///   - shortDescription:
            ///   - description:
            ///   - createdBy:
            ///   - released:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - featured:
            ///   - curated:
            ///   - score:
            ///   - repositoryCount:
            ///   - logoUrl:
            ///   - textMatches:
            ///   - related:
            ///   - aliases:
            public init(
                name: Swift.String,
                displayName: Swift.String? = nil,
                shortDescription: Swift.String? = nil,
                description: Swift.String? = nil,
                createdBy: Swift.String? = nil,
                released: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                featured: Swift.Bool,
                curated: Swift.Bool,
                score: Swift.Double,
                repositoryCount: Swift.Int? = nil,
                logoUrl: Swift.String? = nil,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil,
                related: Components.Schemas.TopicSearchResultItem.RelatedPayload? = nil,
                aliases: Components.Schemas.TopicSearchResultItem.AliasesPayload? = nil
            ) {
                self.name = name
                self.displayName = displayName
                self.shortDescription = shortDescription
                self.description = description
                self.createdBy = createdBy
                self.released = released
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.featured = featured
                self.curated = curated
                self.score = score
                self.repositoryCount = repositoryCount
                self.logoUrl = logoUrl
                self.textMatches = textMatches
                self.related = related
                self.aliases = aliases
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case displayName = "display_name"
                case shortDescription = "short_description"
                case description
                case createdBy = "created_by"
                case released
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case featured
                case curated
                case score
                case repositoryCount = "repository_count"
                case logoUrl = "logo_url"
                case textMatches = "text_matches"
                case related
                case aliases
            }
        }
        /// User Search Result Item
        ///
        /// - Remark: Generated from `#/components/schemas/user-search-result-item`.
        public struct UserSearchResultItem: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/score`.
            public var score: Swift.Double
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/public_repos`.
            public var publicRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/public_gists`.
            public var publicGists: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/followers`.
            public var followers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/following`.
            public var following: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/bio`.
            public var bio: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/location`.
            public var location: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/hireable`.
            public var hireable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/text_matches`.
            public var textMatches: Components.Schemas.SearchResultTextMatches?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/blog`.
            public var blog: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/company`.
            public var company: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/suspended_at`.
            public var suspendedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/user-search-result-item/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `UserSearchResultItem`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - score:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - eventsUrl:
            ///   - publicRepos:
            ///   - publicGists:
            ///   - followers:
            ///   - following:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - name:
            ///   - bio:
            ///   - email:
            ///   - location:
            ///   - siteAdmin:
            ///   - hireable:
            ///   - textMatches:
            ///   - blog:
            ///   - company:
            ///   - suspendedAt:
            ///   - userViewType:
            public init(
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                score: Swift.Double,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                eventsUrl: Swift.String,
                publicRepos: Swift.Int? = nil,
                publicGists: Swift.Int? = nil,
                followers: Swift.Int? = nil,
                following: Swift.Int? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                name: Swift.String? = nil,
                bio: Swift.String? = nil,
                email: Swift.String? = nil,
                location: Swift.String? = nil,
                siteAdmin: Swift.Bool,
                hireable: Swift.Bool? = nil,
                textMatches: Components.Schemas.SearchResultTextMatches? = nil,
                blog: Swift.String? = nil,
                company: Swift.String? = nil,
                suspendedAt: Foundation.Date? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.score = score
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.eventsUrl = eventsUrl
                self.publicRepos = publicRepos
                self.publicGists = publicGists
                self.followers = followers
                self.following = following
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.name = name
                self.bio = bio
                self.email = email
                self.location = location
                self.siteAdmin = siteAdmin
                self.hireable = hireable
                self.textMatches = textMatches
                self.blog = blog
                self.company = company
                self.suspendedAt = suspendedAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case score
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case eventsUrl = "events_url"
                case publicRepos = "public_repos"
                case publicGists = "public_gists"
                case followers
                case following
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case name
                case bio
                case email
                case location
                case siteAdmin = "site_admin"
                case hireable
                case textMatches = "text_matches"
                case blog
                case company
                case suspendedAt = "suspended_at"
                case userViewType = "user_view_type"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
        ///
        /// - Remark: Generated from `#/components/parameters/order`.
        @frozen public enum Order: String, Codable, Hashable, Sendable, CaseIterable {
            case desc = "desc"
            case asc = "asc"
        }
        /// Set to `true` to use advanced search.
        /// Example: `http://api.github.com/search/issues?q={query}&advanced_search=true`
        ///
        /// - Remark: Generated from `#/components/parameters/issues-advanced-search`.
        public typealias IssuesAdvancedSearch = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Search code
    ///
    /// Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
    ///
    /// `q=addClass+in:file+language:js+repo:jquery/jquery`
    ///
    /// This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
    ///
    /// Considerations for code search:
    ///
    /// Due to the complexity of searching code, there are a few restrictions on how searches are performed:
    ///
    /// *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
    /// *   Only files smaller than 384 KB are searchable.
    /// *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
    /// language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
    ///
    /// This endpoint requires you to authenticate and limits you to 10 requests per minute.
    ///
    /// - Remark: HTTP `GET /search/code`.
    /// - Remark: Generated from `#/paths//search/code/get(search/code)`.
    public enum SearchCode {
        public static let id: Swift.String = "search/code"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/code/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching code](https://docs.github.com/search-github/searching-on-github/searching-code)" for a detailed list of qualifiers.
                ///
                /// - Remark: Generated from `#/paths/search/code/GET/query/q`.
                public var q: Swift.String
                /// - Remark: Generated from `#/paths/search/code/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case indexed = "indexed"
                }
                /// **This field is closing down.** Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///
                /// - Remark: Generated from `#/paths/search/code/GET/query/sort`.
                @available(*, deprecated)
                public var sort: Operations.SearchCode.Input.Query.SortPayload?
                /// - Remark: Generated from `#/paths/search/code/GET/query/order`.
                @frozen public enum OrderPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case desc = "desc"
                    case asc = "asc"
                }
                /// **This field is closing down.** Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`. 
                ///
                /// - Remark: Generated from `#/paths/search/code/GET/query/order`.
                @available(*, deprecated)
                public var order: Operations.SearchCode.Input.Query.OrderPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/code/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/code/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - q: The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching code](https://docs.github.com/search-github/searching-on-github/searching-code)" for a detailed list of qualifiers.
                ///   - sort: **This field is closing down.** Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///   - order: **This field is closing down.** Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`. 
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    q: Swift.String,
                    sort: Operations.SearchCode.Input.Query.SortPayload? = nil,
                    order: Operations.SearchCode.Input.Query.OrderPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.q = q
                    self.sort = sort
                    self.order = order
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.SearchCode.Input.Query
            /// - Remark: Generated from `#/paths/search/code/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchCode.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchCode.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchCode.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchCode.Input.Query,
                headers: Operations.SearchCode.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/code/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/code/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/code/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/code/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/code/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.CodeSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.CodeSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/code/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchCode.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchCode.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchCode.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchCode.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/code/get(search/code)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchCode.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchCode.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/code/get(search/code)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/code/get(search/code)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//search/code/get(search/code)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//search/code/get(search/code)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//search/code/get(search/code)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Search commits
    ///
    /// Find commits via various criteria on the default branch (usually `main`). This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
    /// metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
    ///
    /// `q=repo:octocat/Spoon-Knife+css`
    ///
    /// - Remark: HTTP `GET /search/commits`.
    /// - Remark: Generated from `#/paths//search/commits/get(search/commits)`.
    public enum SearchCommits {
        public static let id: Swift.String = "search/commits"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/commits/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching commits](https://docs.github.com/search-github/searching-on-github/searching-commits)" for a detailed list of qualifiers.
                ///
                /// - Remark: Generated from `#/paths/search/commits/GET/query/q`.
                public var q: Swift.String
                /// - Remark: Generated from `#/paths/search/commits/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case authorDate = "author-date"
                    case committerDate = "committer-date"
                }
                /// Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///
                /// - Remark: Generated from `#/paths/search/commits/GET/query/sort`.
                public var sort: Operations.SearchCommits.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/order`.
                @frozen public enum Order: String, Codable, Hashable, Sendable, CaseIterable {
                    case desc = "desc"
                    case asc = "asc"
                }
                /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///
                /// - Remark: Generated from `#/paths/search/commits/GET/query/order`.
                public var order: Components.Parameters.Order?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/commits/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/commits/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - q: The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching commits](https://docs.github.com/search-github/searching-on-github/searching-commits)" for a detailed list of qualifiers.
                ///   - sort: Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///   - order: Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    q: Swift.String,
                    sort: Operations.SearchCommits.Input.Query.SortPayload? = nil,
                    order: Components.Parameters.Order? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.q = q
                    self.sort = sort
                    self.order = order
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.SearchCommits.Input.Query
            /// - Remark: Generated from `#/paths/search/commits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchCommits.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchCommits.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchCommits.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchCommits.Input.Query,
                headers: Operations.SearchCommits.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/commits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/commits/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/commits/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/commits/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/commits/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.CommitSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.CommitSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/commits/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchCommits.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchCommits.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchCommits.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchCommits.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/commits/get(search/commits)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchCommits.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchCommits.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/commits/get(search/commits)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/commits/get(search/commits)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Search issues and pull requests
    ///
    /// > [!WARNING]
    /// > **Notice:** Search for issues and pull requests will be overridden by advanced search on September 4, 2025.
    /// > You can read more about this change on [the GitHub blog](https://github.blog/changelog/2025-03-06-github-issues-projects-api-support-for-issues-advanced-search-and-more/).
    ///
    /// - Remark: HTTP `GET /search/issues`.
    /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)`.
    public enum SearchIssuesAndPullRequests {
        public static let id: Swift.String = "search/issues-and-pull-requests"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/issues/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching issues and pull requests](https://docs.github.com/search-github/searching-on-github/searching-issues-and-pull-requests)" for a detailed list of qualifiers.
                ///
                /// - Remark: Generated from `#/paths/search/issues/GET/query/q`.
                public var q: Swift.String
                /// - Remark: Generated from `#/paths/search/issues/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case comments = "comments"
                    case reactions = "reactions"
                    case reactionsThumbsUp = "reactions-+1"
                    case reactionsThumbsDown = "reactions--1"
                    case reactionsSmile = "reactions-smile"
                    case reactionsThinkingFace = "reactions-thinking_face"
                    case reactionsHeart = "reactions-heart"
                    case reactionsTada = "reactions-tada"
                    case interactions = "interactions"
                    case created = "created"
                    case updated = "updated"
                }
                /// Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///
                /// - Remark: Generated from `#/paths/search/issues/GET/query/sort`.
                public var sort: Operations.SearchIssuesAndPullRequests.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/order`.
                @frozen public enum Order: String, Codable, Hashable, Sendable, CaseIterable {
                    case desc = "desc"
                    case asc = "asc"
                }
                /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///
                /// - Remark: Generated from `#/paths/search/issues/GET/query/order`.
                public var order: Components.Parameters.Order?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/issues/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/issues/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Set to `true` to use advanced search.
                /// Example: `http://api.github.com/search/issues?q={query}&advanced_search=true`
                ///
                /// - Remark: Generated from `#/paths/search/issues/GET/query/advanced_search`.
                public var advancedSearch: Components.Parameters.IssuesAdvancedSearch?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - q: The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching issues and pull requests](https://docs.github.com/search-github/searching-on-github/searching-issues-and-pull-requests)" for a detailed list of qualifiers.
                ///   - sort: Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///   - order: Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - advancedSearch: Set to `true` to use advanced search.
                public init(
                    q: Swift.String,
                    sort: Operations.SearchIssuesAndPullRequests.Input.Query.SortPayload? = nil,
                    order: Components.Parameters.Order? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    advancedSearch: Components.Parameters.IssuesAdvancedSearch? = nil
                ) {
                    self.q = q
                    self.sort = sort
                    self.order = order
                    self.perPage = perPage
                    self.page = page
                    self.advancedSearch = advancedSearch
                }
            }
            public var query: Operations.SearchIssuesAndPullRequests.Input.Query
            /// - Remark: Generated from `#/paths/search/issues/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchIssuesAndPullRequests.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchIssuesAndPullRequests.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchIssuesAndPullRequests.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchIssuesAndPullRequests.Input.Query,
                headers: Operations.SearchIssuesAndPullRequests.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/issues/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/issues/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/issues/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/issues/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/issues/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.IssueSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.IssueSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/issues/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchIssuesAndPullRequests.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchIssuesAndPullRequests.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchIssuesAndPullRequests.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchIssuesAndPullRequests.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchIssuesAndPullRequests.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchIssuesAndPullRequests.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//search/issues/get(search/issues-and-pull-requests)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Search labels
    ///
    /// Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
    ///
    /// `q=bug+defect+enhancement&repository_id=64778136`
    ///
    /// The labels that best match the query appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/labels`.
    /// - Remark: Generated from `#/paths//search/labels/get(search/labels)`.
    public enum SearchLabels {
        public static let id: Swift.String = "search/labels"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/labels/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The id of the repository.
                ///
                /// - Remark: Generated from `#/paths/search/labels/GET/query/repository_id`.
                public var repositoryId: Swift.Int
                /// The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query).
                ///
                /// - Remark: Generated from `#/paths/search/labels/GET/query/q`.
                public var q: Swift.String
                /// - Remark: Generated from `#/paths/search/labels/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///
                /// - Remark: Generated from `#/paths/search/labels/GET/query/sort`.
                public var sort: Operations.SearchLabels.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/order`.
                @frozen public enum Order: String, Codable, Hashable, Sendable, CaseIterable {
                    case desc = "desc"
                    case asc = "asc"
                }
                /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///
                /// - Remark: Generated from `#/paths/search/labels/GET/query/order`.
                public var order: Components.Parameters.Order?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/labels/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/labels/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - repositoryId: The id of the repository.
                ///   - q: The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query).
                ///   - sort: Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///   - order: Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    repositoryId: Swift.Int,
                    q: Swift.String,
                    sort: Operations.SearchLabels.Input.Query.SortPayload? = nil,
                    order: Components.Parameters.Order? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.repositoryId = repositoryId
                    self.q = q
                    self.sort = sort
                    self.order = order
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.SearchLabels.Input.Query
            /// - Remark: Generated from `#/paths/search/labels/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchLabels.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchLabels.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchLabels.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchLabels.Input.Query,
                headers: Operations.SearchLabels.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/labels/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/labels/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/labels/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/labels/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/labels/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.LabelSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.LabelSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/labels/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchLabels.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchLabels.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchLabels.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchLabels.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/labels/get(search/labels)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchLabels.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchLabels.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/labels/get(search/labels)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/labels/get(search/labels)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//search/labels/get(search/labels)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//search/labels/get(search/labels)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//search/labels/get(search/labels)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Search repositories
    ///
    /// Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
    ///
    /// `q=tetris+language:assembly&sort=stars&order=desc`
    ///
    /// This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/repositories`.
    /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)`.
    public enum SearchRepos {
        public static let id: Swift.String = "search/repos"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching for repositories](https://docs.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
                ///
                /// - Remark: Generated from `#/paths/search/repositories/GET/query/q`.
                public var q: Swift.String
                /// - Remark: Generated from `#/paths/search/repositories/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case stars = "stars"
                    case forks = "forks"
                    case helpWantedIssues = "help-wanted-issues"
                    case updated = "updated"
                }
                /// Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///
                /// - Remark: Generated from `#/paths/search/repositories/GET/query/sort`.
                public var sort: Operations.SearchRepos.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/order`.
                @frozen public enum Order: String, Codable, Hashable, Sendable, CaseIterable {
                    case desc = "desc"
                    case asc = "asc"
                }
                /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///
                /// - Remark: Generated from `#/paths/search/repositories/GET/query/order`.
                public var order: Components.Parameters.Order?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - q: The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching for repositories](https://docs.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
                ///   - sort: Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///   - order: Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    q: Swift.String,
                    sort: Operations.SearchRepos.Input.Query.SortPayload? = nil,
                    order: Components.Parameters.Order? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.q = q
                    self.sort = sort
                    self.order = order
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.SearchRepos.Input.Query
            /// - Remark: Generated from `#/paths/search/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchRepos.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchRepos.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchRepos.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchRepos.Input.Query,
                headers: Operations.SearchRepos.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/repositories/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/repositories/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.RepoSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.RepoSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchRepos.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchRepos.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchRepos.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchRepos.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchRepos.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchRepos.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/repositories/get(search/repos)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Search topics
    ///
    /// Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
    ///
    /// When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
    ///
    /// `q=ruby+is:featured`
    ///
    /// This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
    ///
    /// - Remark: HTTP `GET /search/topics`.
    /// - Remark: Generated from `#/paths//search/topics/get(search/topics)`.
    public enum SearchTopics {
        public static let id: Swift.String = "search/topics"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/topics/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query).
                ///
                /// - Remark: Generated from `#/paths/search/topics/GET/query/q`.
                public var q: Swift.String
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/topics/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/topics/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - q: The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query).
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    q: Swift.String,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.q = q
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.SearchTopics.Input.Query
            /// - Remark: Generated from `#/paths/search/topics/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchTopics.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchTopics.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchTopics.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchTopics.Input.Query,
                headers: Operations.SearchTopics.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/topics/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/topics/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/topics/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/topics/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/topics/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.TopicSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.TopicSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/topics/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchTopics.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchTopics.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchTopics.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchTopics.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/topics/get(search/topics)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchTopics.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchTopics.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/topics/get(search/topics)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/topics/get(search/topics)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Search users
    ///
    /// Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).
    ///
    /// When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).
    ///
    /// For example, if you're looking for a list of popular users, you might try this query:
    ///
    /// `q=tom+repos:%3E42+followers:%3E1000`
    ///
    /// This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
    ///
    /// This endpoint does not accept authentication and will only include publicly visible users. As an alternative, you can use the GraphQL API. The GraphQL API requires authentication and will return private users, including Enterprise Managed Users (EMUs), that you are authorized to view. For more information, see "[GraphQL Queries](https://docs.github.com/graphql/reference/queries#search)."
    ///
    /// - Remark: HTTP `GET /search/users`.
    /// - Remark: Generated from `#/paths//search/users/get(search/users)`.
    public enum SearchUsers {
        public static let id: Swift.String = "search/users"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/search/users/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching users](https://docs.github.com/search-github/searching-on-github/searching-users)" for a detailed list of qualifiers.
                ///
                /// - Remark: Generated from `#/paths/search/users/GET/query/q`.
                public var q: Swift.String
                /// - Remark: Generated from `#/paths/search/users/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case followers = "followers"
                    case repositories = "repositories"
                    case joined = "joined"
                }
                /// Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///
                /// - Remark: Generated from `#/paths/search/users/GET/query/sort`.
                public var sort: Operations.SearchUsers.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/order`.
                @frozen public enum Order: String, Codable, Hashable, Sendable, CaseIterable {
                    case desc = "desc"
                    case asc = "asc"
                }
                /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///
                /// - Remark: Generated from `#/paths/search/users/GET/query/order`.
                public var order: Components.Parameters.Order?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/users/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/search/users/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - q: The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as the web interface for GitHub. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/search/search#constructing-a-search-query). See "[Searching users](https://docs.github.com/search-github/searching-on-github/searching-users)" for a detailed list of qualifiers.
                ///   - sort: Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://docs.github.com/rest/search/search#ranking-search-results)
                ///   - order: Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    q: Swift.String,
                    sort: Operations.SearchUsers.Input.Query.SortPayload? = nil,
                    order: Components.Parameters.Order? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.q = q
                    self.sort = sort
                    self.order = order
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.SearchUsers.Input.Query
            /// - Remark: Generated from `#/paths/search/users/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchUsers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SearchUsers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SearchUsers.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SearchUsers.Input.Query,
                headers: Operations.SearchUsers.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/search/users/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/search/users/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/search/users/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/search/users/GET/responses/200/content/json/incomplete_results`.
                        public var incompleteResults: Swift.Bool
                        /// - Remark: Generated from `#/paths/search/users/GET/responses/200/content/json/items`.
                        public var items: [Components.Schemas.UserSearchResultItem]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - incompleteResults:
                        ///   - items:
                        public init(
                            totalCount: Swift.Int,
                            incompleteResults: Swift.Bool,
                            items: [Components.Schemas.UserSearchResultItem]
                        ) {
                            self.totalCount = totalCount
                            self.incompleteResults = incompleteResults
                            self.items = items
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case incompleteResults = "incomplete_results"
                            case items
                        }
                    }
                    /// - Remark: Generated from `#/paths/search/users/GET/responses/200/content/application\/json`.
                    case json(Operations.SearchUsers.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SearchUsers.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SearchUsers.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SearchUsers.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//search/users/get(search/users)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SearchUsers.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SearchUsers.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/users/get(search/users)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//search/users/get(search/users)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//search/users/get(search/users)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//search/users/get(search/users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
