// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List organization projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects/list-for-org)`.
    @available(*, deprecated)
    func projectsListForOrg(_ input: Operations.ProjectsListForOrg.Input) async throws -> Operations.ProjectsListForOrg.Output
    /// Create an organization project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)`.
    @available(*, deprecated)
    func projectsCreateForOrg(_ input: Operations.ProjectsCreateForOrg.Input) async throws -> Operations.ProjectsCreateForOrg.Output
    /// Get a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)`.
    @available(*, deprecated)
    func projectsGetCard(_ input: Operations.ProjectsGetCard.Input) async throws -> Operations.ProjectsGetCard.Output
    /// Update an existing project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)`.
    @available(*, deprecated)
    func projectsUpdateCard(_ input: Operations.ProjectsUpdateCard.Input) async throws -> Operations.ProjectsUpdateCard.Output
    /// Delete a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)`.
    @available(*, deprecated)
    func projectsDeleteCard(_ input: Operations.ProjectsDeleteCard.Input) async throws -> Operations.ProjectsDeleteCard.Output
    /// Move a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/cards/{card_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)`.
    @available(*, deprecated)
    func projectsMoveCard(_ input: Operations.ProjectsMoveCard.Input) async throws -> Operations.ProjectsMoveCard.Output
    /// Get a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)`.
    @available(*, deprecated)
    func projectsGetColumn(_ input: Operations.ProjectsGetColumn.Input) async throws -> Operations.ProjectsGetColumn.Output
    /// Update an existing project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)`.
    @available(*, deprecated)
    func projectsUpdateColumn(_ input: Operations.ProjectsUpdateColumn.Input) async throws -> Operations.ProjectsUpdateColumn.Output
    /// Delete a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)`.
    @available(*, deprecated)
    func projectsDeleteColumn(_ input: Operations.ProjectsDeleteColumn.Input) async throws -> Operations.ProjectsDeleteColumn.Output
    /// List project cards
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}/cards`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)`.
    @available(*, deprecated)
    func projectsListCards(_ input: Operations.ProjectsListCards.Input) async throws -> Operations.ProjectsListCards.Output
    /// Create a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/cards`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)`.
    @available(*, deprecated)
    func projectsCreateCard(_ input: Operations.ProjectsCreateCard.Input) async throws -> Operations.ProjectsCreateCard.Output
    /// Move a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)`.
    @available(*, deprecated)
    func projectsMoveColumn(_ input: Operations.ProjectsMoveColumn.Input) async throws -> Operations.ProjectsMoveColumn.Output
    /// Get a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)`.
    @available(*, deprecated)
    func projectsGet(_ input: Operations.ProjectsGet.Input) async throws -> Operations.ProjectsGet.Output
    /// Update a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)`.
    @available(*, deprecated)
    func projectsUpdate(_ input: Operations.ProjectsUpdate.Input) async throws -> Operations.ProjectsUpdate.Output
    /// Delete a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)`.
    @available(*, deprecated)
    func projectsDelete(_ input: Operations.ProjectsDelete.Input) async throws -> Operations.ProjectsDelete.Output
    /// List project collaborators
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)`.
    @available(*, deprecated)
    func projectsListCollaborators(_ input: Operations.ProjectsListCollaborators.Input) async throws -> Operations.ProjectsListCollaborators.Output
    /// Add project collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)`.
    @available(*, deprecated)
    func projectsAddCollaborator(_ input: Operations.ProjectsAddCollaborator.Input) async throws -> Operations.ProjectsAddCollaborator.Output
    /// Remove user as a collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)`.
    @available(*, deprecated)
    func projectsRemoveCollaborator(_ input: Operations.ProjectsRemoveCollaborator.Input) async throws -> Operations.ProjectsRemoveCollaborator.Output
    /// Get project permission for a user
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)`.
    @available(*, deprecated)
    func projectsGetPermissionForUser(_ input: Operations.ProjectsGetPermissionForUser.Input) async throws -> Operations.ProjectsGetPermissionForUser.Output
    /// List project columns
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)`.
    @available(*, deprecated)
    func projectsListColumns(_ input: Operations.ProjectsListColumns.Input) async throws -> Operations.ProjectsListColumns.Output
    /// Create a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)`.
    @available(*, deprecated)
    func projectsCreateColumn(_ input: Operations.ProjectsCreateColumn.Input) async throws -> Operations.ProjectsCreateColumn.Output
    /// List repository projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)`.
    @available(*, deprecated)
    func projectsListForRepo(_ input: Operations.ProjectsListForRepo.Input) async throws -> Operations.ProjectsListForRepo.Output
    /// Create a repository project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)`.
    @available(*, deprecated)
    func projectsCreateForRepo(_ input: Operations.ProjectsCreateForRepo.Input) async throws -> Operations.ProjectsCreateForRepo.Output
    /// Create a user project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /user/projects`.
    /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)`.
    @available(*, deprecated)
    func projectsCreateForAuthenticatedUser(_ input: Operations.ProjectsCreateForAuthenticatedUser.Input) async throws -> Operations.ProjectsCreateForAuthenticatedUser.Output
    /// List user projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /users/{username}/projects`.
    /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects/list-for-user)`.
    @available(*, deprecated)
    func projectsListForUser(_ input: Operations.ProjectsListForUser.Input) async throws -> Operations.ProjectsListForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List organization projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects/list-for-org)`.
    @available(*, deprecated)
    public func projectsListForOrg(
        path: Operations.ProjectsListForOrg.Input.Path,
        query: Operations.ProjectsListForOrg.Input.Query = .init(),
        headers: Operations.ProjectsListForOrg.Input.Headers = .init()
    ) async throws -> Operations.ProjectsListForOrg.Output {
        try await projectsListForOrg(Operations.ProjectsListForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)`.
    @available(*, deprecated)
    public func projectsCreateForOrg(
        path: Operations.ProjectsCreateForOrg.Input.Path,
        headers: Operations.ProjectsCreateForOrg.Input.Headers = .init(),
        body: Operations.ProjectsCreateForOrg.Input.Body
    ) async throws -> Operations.ProjectsCreateForOrg.Output {
        try await projectsCreateForOrg(Operations.ProjectsCreateForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)`.
    @available(*, deprecated)
    public func projectsGetCard(
        path: Operations.ProjectsGetCard.Input.Path,
        headers: Operations.ProjectsGetCard.Input.Headers = .init()
    ) async throws -> Operations.ProjectsGetCard.Output {
        try await projectsGetCard(Operations.ProjectsGetCard.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an existing project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)`.
    @available(*, deprecated)
    public func projectsUpdateCard(
        path: Operations.ProjectsUpdateCard.Input.Path,
        headers: Operations.ProjectsUpdateCard.Input.Headers = .init(),
        body: Operations.ProjectsUpdateCard.Input.Body? = nil
    ) async throws -> Operations.ProjectsUpdateCard.Output {
        try await projectsUpdateCard(Operations.ProjectsUpdateCard.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)`.
    @available(*, deprecated)
    public func projectsDeleteCard(
        path: Operations.ProjectsDeleteCard.Input.Path,
        headers: Operations.ProjectsDeleteCard.Input.Headers = .init()
    ) async throws -> Operations.ProjectsDeleteCard.Output {
        try await projectsDeleteCard(Operations.ProjectsDeleteCard.Input(
            path: path,
            headers: headers
        ))
    }
    /// Move a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/cards/{card_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)`.
    @available(*, deprecated)
    public func projectsMoveCard(
        path: Operations.ProjectsMoveCard.Input.Path,
        headers: Operations.ProjectsMoveCard.Input.Headers = .init(),
        body: Operations.ProjectsMoveCard.Input.Body
    ) async throws -> Operations.ProjectsMoveCard.Output {
        try await projectsMoveCard(Operations.ProjectsMoveCard.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)`.
    @available(*, deprecated)
    public func projectsGetColumn(
        path: Operations.ProjectsGetColumn.Input.Path,
        headers: Operations.ProjectsGetColumn.Input.Headers = .init()
    ) async throws -> Operations.ProjectsGetColumn.Output {
        try await projectsGetColumn(Operations.ProjectsGetColumn.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an existing project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)`.
    @available(*, deprecated)
    public func projectsUpdateColumn(
        path: Operations.ProjectsUpdateColumn.Input.Path,
        headers: Operations.ProjectsUpdateColumn.Input.Headers = .init(),
        body: Operations.ProjectsUpdateColumn.Input.Body
    ) async throws -> Operations.ProjectsUpdateColumn.Output {
        try await projectsUpdateColumn(Operations.ProjectsUpdateColumn.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)`.
    @available(*, deprecated)
    public func projectsDeleteColumn(
        path: Operations.ProjectsDeleteColumn.Input.Path,
        headers: Operations.ProjectsDeleteColumn.Input.Headers = .init()
    ) async throws -> Operations.ProjectsDeleteColumn.Output {
        try await projectsDeleteColumn(Operations.ProjectsDeleteColumn.Input(
            path: path,
            headers: headers
        ))
    }
    /// List project cards
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}/cards`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)`.
    @available(*, deprecated)
    public func projectsListCards(
        path: Operations.ProjectsListCards.Input.Path,
        query: Operations.ProjectsListCards.Input.Query = .init(),
        headers: Operations.ProjectsListCards.Input.Headers = .init()
    ) async throws -> Operations.ProjectsListCards.Output {
        try await projectsListCards(Operations.ProjectsListCards.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/cards`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)`.
    @available(*, deprecated)
    public func projectsCreateCard(
        path: Operations.ProjectsCreateCard.Input.Path,
        headers: Operations.ProjectsCreateCard.Input.Headers = .init(),
        body: Operations.ProjectsCreateCard.Input.Body
    ) async throws -> Operations.ProjectsCreateCard.Output {
        try await projectsCreateCard(Operations.ProjectsCreateCard.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Move a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)`.
    @available(*, deprecated)
    public func projectsMoveColumn(
        path: Operations.ProjectsMoveColumn.Input.Path,
        headers: Operations.ProjectsMoveColumn.Input.Headers = .init(),
        body: Operations.ProjectsMoveColumn.Input.Body
    ) async throws -> Operations.ProjectsMoveColumn.Output {
        try await projectsMoveColumn(Operations.ProjectsMoveColumn.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)`.
    @available(*, deprecated)
    public func projectsGet(
        path: Operations.ProjectsGet.Input.Path,
        headers: Operations.ProjectsGet.Input.Headers = .init()
    ) async throws -> Operations.ProjectsGet.Output {
        try await projectsGet(Operations.ProjectsGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)`.
    @available(*, deprecated)
    public func projectsUpdate(
        path: Operations.ProjectsUpdate.Input.Path,
        headers: Operations.ProjectsUpdate.Input.Headers = .init(),
        body: Operations.ProjectsUpdate.Input.Body? = nil
    ) async throws -> Operations.ProjectsUpdate.Output {
        try await projectsUpdate(Operations.ProjectsUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)`.
    @available(*, deprecated)
    public func projectsDelete(
        path: Operations.ProjectsDelete.Input.Path,
        headers: Operations.ProjectsDelete.Input.Headers = .init()
    ) async throws -> Operations.ProjectsDelete.Output {
        try await projectsDelete(Operations.ProjectsDelete.Input(
            path: path,
            headers: headers
        ))
    }
    /// List project collaborators
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)`.
    @available(*, deprecated)
    public func projectsListCollaborators(
        path: Operations.ProjectsListCollaborators.Input.Path,
        query: Operations.ProjectsListCollaborators.Input.Query = .init(),
        headers: Operations.ProjectsListCollaborators.Input.Headers = .init()
    ) async throws -> Operations.ProjectsListCollaborators.Output {
        try await projectsListCollaborators(Operations.ProjectsListCollaborators.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Add project collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)`.
    @available(*, deprecated)
    public func projectsAddCollaborator(
        path: Operations.ProjectsAddCollaborator.Input.Path,
        headers: Operations.ProjectsAddCollaborator.Input.Headers = .init(),
        body: Operations.ProjectsAddCollaborator.Input.Body? = nil
    ) async throws -> Operations.ProjectsAddCollaborator.Output {
        try await projectsAddCollaborator(Operations.ProjectsAddCollaborator.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove user as a collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)`.
    @available(*, deprecated)
    public func projectsRemoveCollaborator(
        path: Operations.ProjectsRemoveCollaborator.Input.Path,
        headers: Operations.ProjectsRemoveCollaborator.Input.Headers = .init()
    ) async throws -> Operations.ProjectsRemoveCollaborator.Output {
        try await projectsRemoveCollaborator(Operations.ProjectsRemoveCollaborator.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get project permission for a user
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)`.
    @available(*, deprecated)
    public func projectsGetPermissionForUser(
        path: Operations.ProjectsGetPermissionForUser.Input.Path,
        headers: Operations.ProjectsGetPermissionForUser.Input.Headers = .init()
    ) async throws -> Operations.ProjectsGetPermissionForUser.Output {
        try await projectsGetPermissionForUser(Operations.ProjectsGetPermissionForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List project columns
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)`.
    @available(*, deprecated)
    public func projectsListColumns(
        path: Operations.ProjectsListColumns.Input.Path,
        query: Operations.ProjectsListColumns.Input.Query = .init(),
        headers: Operations.ProjectsListColumns.Input.Headers = .init()
    ) async throws -> Operations.ProjectsListColumns.Output {
        try await projectsListColumns(Operations.ProjectsListColumns.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)`.
    @available(*, deprecated)
    public func projectsCreateColumn(
        path: Operations.ProjectsCreateColumn.Input.Path,
        headers: Operations.ProjectsCreateColumn.Input.Headers = .init(),
        body: Operations.ProjectsCreateColumn.Input.Body
    ) async throws -> Operations.ProjectsCreateColumn.Output {
        try await projectsCreateColumn(Operations.ProjectsCreateColumn.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)`.
    @available(*, deprecated)
    public func projectsListForRepo(
        path: Operations.ProjectsListForRepo.Input.Path,
        query: Operations.ProjectsListForRepo.Input.Query = .init(),
        headers: Operations.ProjectsListForRepo.Input.Headers = .init()
    ) async throws -> Operations.ProjectsListForRepo.Output {
        try await projectsListForRepo(Operations.ProjectsListForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a repository project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)`.
    @available(*, deprecated)
    public func projectsCreateForRepo(
        path: Operations.ProjectsCreateForRepo.Input.Path,
        headers: Operations.ProjectsCreateForRepo.Input.Headers = .init(),
        body: Operations.ProjectsCreateForRepo.Input.Body
    ) async throws -> Operations.ProjectsCreateForRepo.Output {
        try await projectsCreateForRepo(Operations.ProjectsCreateForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Create a user project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /user/projects`.
    /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)`.
    @available(*, deprecated)
    public func projectsCreateForAuthenticatedUser(
        headers: Operations.ProjectsCreateForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.ProjectsCreateForAuthenticatedUser.Input.Body
    ) async throws -> Operations.ProjectsCreateForAuthenticatedUser.Output {
        try await projectsCreateForAuthenticatedUser(Operations.ProjectsCreateForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List user projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /users/{username}/projects`.
    /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects/list-for-user)`.
    @available(*, deprecated)
    public func projectsListForUser(
        path: Operations.ProjectsListForUser.Input.Path,
        query: Operations.ProjectsListForUser.Input.Query = .init(),
        headers: Operations.ProjectsListForUser.Input.Headers = .init()
    ) async throws -> Operations.ProjectsListForUser.Output {
        try await projectsListForUser(Operations.ProjectsListForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Projects are a way to organize columns and cards of work.
        ///
        /// - Remark: Generated from `#/components/schemas/project`.
        public struct Project: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project/owner_url`.
            public var ownerUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/columns_url`.
            public var columnsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/project/node_id`.
            public var nodeId: Swift.String
            /// Name of the project
            ///
            /// - Remark: Generated from `#/components/schemas/project/name`.
            public var name: Swift.String
            /// Body of the project
            ///
            /// - Remark: Generated from `#/components/schemas/project/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/project/number`.
            public var number: Swift.Int
            /// State of the project; either 'open' or 'closed'
            ///
            /// - Remark: Generated from `#/components/schemas/project/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/project/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/project/updated_at`.
            public var updatedAt: Foundation.Date
            /// The baseline permission that all organization members have on this project. Only present if owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/project/organization_permission`.
            @frozen public enum OrganizationPermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
                case none = "none"
            }
            /// The baseline permission that all organization members have on this project. Only present if owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/project/organization_permission`.
            public var organizationPermission: Components.Schemas.Project.OrganizationPermissionPayload?
            /// Whether or not this project can be seen by everyone. Only present if owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/project/private`.
            public var _private: Swift.Bool?
            /// Creates a new `Project`.
            ///
            /// - Parameters:
            ///   - ownerUrl:
            ///   - url:
            ///   - htmlUrl:
            ///   - columnsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - name: Name of the project
            ///   - body: Body of the project
            ///   - number:
            ///   - state: State of the project; either 'open' or 'closed'
            ///   - creator:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - organizationPermission: The baseline permission that all organization members have on this project. Only present if owner is an organization.
            ///   - _private: Whether or not this project can be seen by everyone. Only present if owner is an organization.
            public init(
                ownerUrl: Swift.String,
                url: Swift.String,
                htmlUrl: Swift.String,
                columnsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                body: Swift.String? = nil,
                number: Swift.Int,
                state: Swift.String,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                organizationPermission: Components.Schemas.Project.OrganizationPermissionPayload? = nil,
                _private: Swift.Bool? = nil
            ) {
                self.ownerUrl = ownerUrl
                self.url = url
                self.htmlUrl = htmlUrl
                self.columnsUrl = columnsUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.body = body
                self.number = number
                self.state = state
                self.creator = creator
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.organizationPermission = organizationPermission
                self._private = _private
            }
            public enum CodingKeys: String, CodingKey {
                case ownerUrl = "owner_url"
                case url
                case htmlUrl = "html_url"
                case columnsUrl = "columns_url"
                case id
                case nodeId = "node_id"
                case name
                case body
                case number
                case state
                case creator
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case organizationPermission = "organization_permission"
                case _private = "private"
            }
        }
        /// Project cards represent a scope of work.
        ///
        /// - Remark: Generated from `#/components/schemas/project-card`.
        public struct ProjectCard: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project-card/url`.
            public var url: Swift.String
            /// The project card's ID
            ///
            /// - Remark: Generated from `#/components/schemas/project-card/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/project-card/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-card/note`.
            public var note: Swift.String?
            /// - Remark: Generated from `#/components/schemas/project-card/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/project-card/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/project-card/updated_at`.
            public var updatedAt: Foundation.Date
            /// Whether or not the card is archived
            ///
            /// - Remark: Generated from `#/components/schemas/project-card/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/project-card/column_name`.
            public var columnName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/project-card/project_id`.
            public var projectId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/project-card/column_url`.
            public var columnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-card/content_url`.
            public var contentUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/project-card/project_url`.
            public var projectUrl: Swift.String
            /// Creates a new `ProjectCard`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id: The project card's ID
            ///   - nodeId:
            ///   - note:
            ///   - creator:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - archived: Whether or not the card is archived
            ///   - columnName:
            ///   - projectId:
            ///   - columnUrl:
            ///   - contentUrl:
            ///   - projectUrl:
            public init(
                url: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                note: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                archived: Swift.Bool? = nil,
                columnName: Swift.String? = nil,
                projectId: Swift.String? = nil,
                columnUrl: Swift.String,
                contentUrl: Swift.String? = nil,
                projectUrl: Swift.String
            ) {
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.note = note
                self.creator = creator
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.archived = archived
                self.columnName = columnName
                self.projectId = projectId
                self.columnUrl = columnUrl
                self.contentUrl = contentUrl
                self.projectUrl = projectUrl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case nodeId = "node_id"
                case note
                case creator
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case archived
                case columnName = "column_name"
                case projectId = "project_id"
                case columnUrl = "column_url"
                case contentUrl = "content_url"
                case projectUrl = "project_url"
            }
        }
        /// Project columns contain cards of work.
        ///
        /// - Remark: Generated from `#/components/schemas/project-column`.
        public struct ProjectColumn: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project-column/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-column/project_url`.
            public var projectUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-column/cards_url`.
            public var cardsUrl: Swift.String
            /// The unique identifier of the project column
            ///
            /// - Remark: Generated from `#/components/schemas/project-column/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/project-column/node_id`.
            public var nodeId: Swift.String
            /// Name of the project column
            ///
            /// - Remark: Generated from `#/components/schemas/project-column/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-column/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/project-column/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `ProjectColumn`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - projectUrl:
            ///   - cardsUrl:
            ///   - id: The unique identifier of the project column
            ///   - nodeId:
            ///   - name: Name of the project column
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                url: Swift.String,
                projectUrl: Swift.String,
                cardsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.url = url
                self.projectUrl = projectUrl
                self.cardsUrl = cardsUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case projectUrl = "project_url"
                case cardsUrl = "cards_url"
                case id
                case nodeId = "node_id"
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Project Collaborator Permission
        ///
        /// - Remark: Generated from `#/components/schemas/project-collaborator-permission`.
        public struct ProjectCollaboratorPermission: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project-collaborator-permission/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-collaborator-permission/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// Creates a new `ProjectCollaboratorPermission`.
            ///
            /// - Parameters:
            ///   - permission:
            ///   - user:
            public init(
                permission: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil
            ) {
                self.permission = permission
                self.user = user
            }
            public enum CodingKeys: String, CodingKey {
                case permission
                case user
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The unique identifier of the project.
        ///
        /// - Remark: Generated from `#/components/parameters/project-id`.
        public typealias ProjectId = Swift.Int
        /// The unique identifier of the card.
        ///
        /// - Remark: Generated from `#/components/parameters/card-id`.
        public typealias CardId = Swift.Int
        /// The unique identifier of the column.
        ///
        /// - Remark: Generated from `#/components/parameters/column-id`.
        public typealias ColumnId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct Gone: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/gone/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/gone/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Gone.Body
            /// Creates a new `Gone`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Gone.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List organization projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects/list-for-org)`.
    public enum ProjectsListForOrg {
        public static let id: Swift.String = "projects/list-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ProjectsListForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the projects to return.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/state`.
                public var state: Operations.ProjectsListForOrg.Input.Query.StatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Indicates the state of the projects to return.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.ProjectsListForOrg.Input.Query.StatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsListForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsListForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsListForOrg.Input.Path,
                query: Operations.ProjectsListForOrg.Input.Query = .init(),
                headers: Operations.ProjectsListForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsListForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Project])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Project] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsListForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsListForOrg.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsListForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects/list-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsListForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsListForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects/list-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an organization project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)`.
    public enum ProjectsCreateForOrg {
        public static let id: Swift.String = "projects/create-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ProjectsCreateForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsCreateForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the project.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The description of the project.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the project.
                    ///   - body: The description of the project.
                    public init(
                        name: Swift.String,
                        body: Swift.String? = nil
                    ) {
                        self.name = name
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsCreateForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsCreateForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsCreateForOrg.Input.Path,
                headers: Operations.ProjectsCreateForOrg.Input.Headers = .init(),
                body: Operations.ProjectsCreateForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateForOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateForOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsCreateForOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsCreateForOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects/create-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)`.
    public enum ProjectsGetCard {
        public static let id: Swift.String = "projects/get-card"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the card.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/GET/path/card_id`.
                public var cardId: Components.Parameters.CardId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - cardId: The unique identifier of the card.
                public init(cardId: Components.Parameters.CardId) {
                    self.cardId = cardId
                }
            }
            public var path: Operations.ProjectsGetCard.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGetCard.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGetCard.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsGetCard.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsGetCard.Input.Path,
                headers: Operations.ProjectsGetCard.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectCard)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectCard {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsGetCard.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsGetCard.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsGetCard.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsGetCard.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/get(projects/get-card)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an existing project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)`.
    public enum ProjectsUpdateCard {
        public static let id: Swift.String = "projects/update-card"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the card.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/path/card_id`.
                public var cardId: Components.Parameters.CardId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - cardId: The unique identifier of the card.
                public init(cardId: Components.Parameters.CardId) {
                    self.cardId = cardId
                }
            }
            public var path: Operations.ProjectsUpdateCard.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsUpdateCard.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsUpdateCard.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsUpdateCard.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The project card's note
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/requestBody/json/note`.
                    public var note: Swift.String?
                    /// Whether or not the card is archived
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/requestBody/json/archived`.
                    public var archived: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - note: The project card's note
                    ///   - archived: Whether or not the card is archived
                    public init(
                        note: Swift.String? = nil,
                        archived: Swift.Bool? = nil
                    ) {
                        self.note = note
                        self.archived = archived
                    }
                    public enum CodingKeys: String, CodingKey {
                        case note
                        case archived
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ProjectsUpdateCard.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsUpdateCard.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsUpdateCard.Input.Path,
                headers: Operations.ProjectsUpdateCard.Input.Headers = .init(),
                body: Operations.ProjectsUpdateCard.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectCard)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectCard {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsUpdateCard.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsUpdateCard.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsUpdateCard.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsUpdateCard.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/patch(projects/update-card)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/cards/{card_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)`.
    public enum ProjectsDeleteCard {
        public static let id: Swift.String = "projects/delete-card"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the card.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/path/card_id`.
                public var cardId: Components.Parameters.CardId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - cardId: The unique identifier of the card.
                public init(cardId: Components.Parameters.CardId) {
                    self.cardId = cardId
                }
            }
            public var path: Operations.ProjectsDeleteCard.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsDeleteCard.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsDeleteCard.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsDeleteCard.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsDeleteCard.Input.Path,
                headers: Operations.ProjectsDeleteCard.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsDeleteCard.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsDeleteCard.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/responses/403/content/json/errors`.
                        public var errors: [Swift.String]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: [Swift.String]? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/DELETE/responses/403/content/application\/json`.
                    case json(Operations.ProjectsDeleteCard.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsDeleteCard.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsDeleteCard.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsDeleteCard.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ProjectsDeleteCard.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ProjectsDeleteCard.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/delete(projects/delete-card)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Move a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/cards/{card_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)`.
    public enum ProjectsMoveCard {
        public static let id: Swift.String = "projects/move-card"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the card.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/path/card_id`.
                public var cardId: Components.Parameters.CardId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - cardId: The unique identifier of the card.
                public init(cardId: Components.Parameters.CardId) {
                    self.cardId = cardId
                }
            }
            public var path: Operations.ProjectsMoveCard.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsMoveCard.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsMoveCard.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsMoveCard.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The position of the card in a column. Can be one of: `top`, `bottom`, or `after:<card_id>` to place after the specified card.
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/requestBody/json/position`.
                    public var position: Swift.String
                    /// The unique identifier of the column the card should be moved to
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/requestBody/json/column_id`.
                    public var columnId: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - position: The position of the card in a column. Can be one of: `top`, `bottom`, or `after:<card_id>` to place after the specified card.
                    ///   - columnId: The unique identifier of the column the card should be moved to
                    public init(
                        position: Swift.String,
                        columnId: Swift.Int? = nil
                    ) {
                        self.position = position
                        self.columnId = columnId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case position
                        case columnId = "column_id"
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsMoveCard.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsMoveCard.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsMoveCard.Input.Path,
                headers: Operations.ProjectsMoveCard.Input.Headers = .init(),
                body: Operations.ProjectsMoveCard.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Creates a new `JsonPayload`.
                        public init() {}
                        public init(from decoder: any Decoder) throws {
                            try decoder.ensureNoAdditionalProperties(knownKeys: [])
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/201/content/application\/json`.
                    case json(Operations.ProjectsMoveCard.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsMoveCard.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsMoveCard.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsMoveCard.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsMoveCard.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsMoveCard.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/ErrorsPayload`.
                        public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/ErrorsPayload/code`.
                            public var code: Swift.String?
                            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/ErrorsPayload/message`.
                            public var message: Swift.String?
                            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/ErrorsPayload/resource`.
                            public var resource: Swift.String?
                            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/ErrorsPayload/field`.
                            public var field: Swift.String?
                            /// Creates a new `ErrorsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - code:
                            ///   - message:
                            ///   - resource:
                            ///   - field:
                            public init(
                                code: Swift.String? = nil,
                                message: Swift.String? = nil,
                                resource: Swift.String? = nil,
                                field: Swift.String? = nil
                            ) {
                                self.code = code
                                self.message = message
                                self.resource = resource
                                self.field = field
                            }
                            public enum CodingKeys: String, CodingKey {
                                case code
                                case message
                                case resource
                                case field
                            }
                        }
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/errors`.
                        public typealias ErrorsPayload = [Operations.ProjectsMoveCard.Output.Forbidden.Body.JsonPayload.ErrorsPayloadPayload]
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/json/errors`.
                        public var errors: Operations.ProjectsMoveCard.Output.Forbidden.Body.JsonPayload.ErrorsPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: Operations.ProjectsMoveCard.Output.Forbidden.Body.JsonPayload.ErrorsPayload? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/403/content/application\/json`.
                    case json(Operations.ProjectsMoveCard.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsMoveCard.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsMoveCard.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsMoveCard.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ProjectsMoveCard.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ProjectsMoveCard.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            public struct ServiceUnavailable: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/code`.
                        public var code: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/ErrorsPayload`.
                        public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/ErrorsPayload/code`.
                            public var code: Swift.String?
                            /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/ErrorsPayload/message`.
                            public var message: Swift.String?
                            /// Creates a new `ErrorsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - code:
                            ///   - message:
                            public init(
                                code: Swift.String? = nil,
                                message: Swift.String? = nil
                            ) {
                                self.code = code
                                self.message = message
                            }
                            public enum CodingKeys: String, CodingKey {
                                case code
                                case message
                            }
                        }
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/errors`.
                        public typealias ErrorsPayload = [Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body.JsonPayload.ErrorsPayloadPayload]
                        /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/json/errors`.
                        public var errors: Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body.JsonPayload.ErrorsPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - code:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            code: Swift.String? = nil,
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body.JsonPayload.ErrorsPayload? = nil
                        ) {
                            self.code = code
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case code
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/cards/{card_id}/moves/POST/responses/503/content/application\/json`.
                    case json(Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body
                /// Creates a new `ServiceUnavailable`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsMoveCard.Output.ServiceUnavailable.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Operations.ProjectsMoveCard.Output.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Operations.ProjectsMoveCard.Output.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/columns/cards/{card_id}/moves/post(projects/move-card)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)`.
    public enum ProjectsGetColumn {
        public static let id: Swift.String = "projects/get-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsGetColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGetColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGetColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsGetColumn.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsGetColumn.Input.Path,
                headers: Operations.ProjectsGetColumn.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectColumn)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectColumn {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsGetColumn.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsGetColumn.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsGetColumn.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsGetColumn.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects/get-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an existing project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)`.
    public enum ProjectsUpdateColumn {
        public static let id: Swift.String = "projects/update-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsUpdateColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsUpdateColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsUpdateColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsUpdateColumn.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project column
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project column
                    public init(name: Swift.String) {
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ProjectsUpdateColumn.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsUpdateColumn.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsUpdateColumn.Input.Path,
                headers: Operations.ProjectsUpdateColumn.Input.Headers = .init(),
                body: Operations.ProjectsUpdateColumn.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectColumn)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectColumn {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsUpdateColumn.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsUpdateColumn.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsUpdateColumn.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsUpdateColumn.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects/update-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)`.
    public enum ProjectsDeleteColumn {
        public static let id: Swift.String = "projects/delete-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/DELETE/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsDeleteColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsDeleteColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsDeleteColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsDeleteColumn.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsDeleteColumn.Input.Path,
                headers: Operations.ProjectsDeleteColumn.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsDeleteColumn.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsDeleteColumn.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects/delete-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List project cards
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}/cards`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)`.
    public enum ProjectsListCards {
        public static let id: Swift.String = "projects/list-cards"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsListCards.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/query/archived_state`.
                @frozen public enum ArchivedStatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case all = "all"
                    case archived = "archived"
                    case notArchived = "not_archived"
                }
                /// Filters the project cards that are returned by the card's state.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/query/archived_state`.
                public var archivedState: Operations.ProjectsListCards.Input.Query.ArchivedStatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - archivedState: Filters the project cards that are returned by the card's state.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    archivedState: Operations.ProjectsListCards.Input.Query.ArchivedStatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.archivedState = archivedState
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsListCards.Input.Query
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListCards.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListCards.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsListCards.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsListCards.Input.Path,
                query: Operations.ProjectsListCards.Input.Query = .init(),
                headers: Operations.ProjectsListCards.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsListCards.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.ProjectCard])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.ProjectCard] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsListCards.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsListCards.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsListCards.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsListCards.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsListCards.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/get(projects/list-cards)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a project card
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/cards`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)`.
    public enum ProjectsCreateCard {
        public static let id: Swift.String = "projects/create-card"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsCreateCard.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateCard.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateCard.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsCreateCard.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// The project card's note
                        ///
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case1/note`.
                        public var note: Swift.String?
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - note: The project card's note
                        public init(note: Swift.String? = nil) {
                            self.note = note
                        }
                        public enum CodingKeys: String, CodingKey {
                            case note
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case1`.
                    case case1(Operations.ProjectsCreateCard.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case2`.
                    public struct Case2Payload: Codable, Hashable, Sendable {
                        /// The unique identifier of the content associated with the card
                        ///
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case2/content_id`.
                        public var contentId: Swift.Int
                        /// The piece of content associated with the card
                        ///
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case2/content_type`.
                        public var contentType: Swift.String
                        /// Creates a new `Case2Payload`.
                        ///
                        /// - Parameters:
                        ///   - contentId: The unique identifier of the content associated with the card
                        ///   - contentType: The piece of content associated with the card
                        public init(
                            contentId: Swift.Int,
                            contentType: Swift.String
                        ) {
                            self.contentId = contentId
                            self.contentType = contentType
                        }
                        public enum CodingKeys: String, CodingKey {
                            case contentId = "content_id"
                            case contentType = "content_type"
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/json/case2`.
                    case case2(Operations.ProjectsCreateCard.Input.Body.JsonPayload.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsCreateCard.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsCreateCard.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsCreateCard.Input.Path,
                headers: Operations.ProjectsCreateCard.Input.Headers = .init(),
                body: Operations.ProjectsCreateCard.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.ProjectCard)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectCard {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateCard.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateCard.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsCreateCard.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsCreateCard.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/422/content/json`.
                    @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/422/content/json/case1`.
                        case ValidationError(Components.Schemas.ValidationError)
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/422/content/json/case2`.
                        case ValidationErrorSimple(Components.Schemas.ValidationErrorSimple)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .ValidationError(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .ValidationErrorSimple(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .ValidationError(value):
                                try value.encode(to: encoder)
                            case let .ValidationErrorSimple(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/422/content/application\/json`.
                    case json(Operations.ProjectsCreateCard.Output.UnprocessableContent.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsCreateCard.Output.UnprocessableContent.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateCard.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateCard.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Validation failed
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.ProjectsCreateCard.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.ProjectsCreateCard.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            public struct ServiceUnavailable: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/code`.
                        public var code: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/ErrorsPayload`.
                        public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/ErrorsPayload/code`.
                            public var code: Swift.String?
                            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/ErrorsPayload/message`.
                            public var message: Swift.String?
                            /// Creates a new `ErrorsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - code:
                            ///   - message:
                            public init(
                                code: Swift.String? = nil,
                                message: Swift.String? = nil
                            ) {
                                self.code = code
                                self.message = message
                            }
                            public enum CodingKeys: String, CodingKey {
                                case code
                                case message
                            }
                        }
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/errors`.
                        public typealias ErrorsPayload = [Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body.JsonPayload.ErrorsPayloadPayload]
                        /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/json/errors`.
                        public var errors: Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body.JsonPayload.ErrorsPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - code:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            code: Swift.String? = nil,
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body.JsonPayload.ErrorsPayload? = nil
                        ) {
                            self.code = code
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case code
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/cards/POST/responses/503/content/application\/json`.
                    case json(Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body
                /// Creates a new `ServiceUnavailable`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateCard.Output.ServiceUnavailable.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/cards/post(projects/create-card)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Operations.ProjectsCreateCard.Output.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Operations.ProjectsCreateCard.Output.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Move a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)`.
    public enum ProjectsMoveColumn {
        public static let id: Swift.String = "projects/move-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsMoveColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsMoveColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsMoveColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsMoveColumn.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The position of the column in a project. Can be one of: `first`, `last`, or `after:<column_id>` to place after the specified column.
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody/json/position`.
                    public var position: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - position: The position of the column in a project. Can be one of: `first`, `last`, or `after:<column_id>` to place after the specified column.
                    public init(position: Swift.String) {
                        self.position = position
                    }
                    public enum CodingKeys: String, CodingKey {
                        case position
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsMoveColumn.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsMoveColumn.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsMoveColumn.Input.Path,
                headers: Operations.ProjectsMoveColumn.Input.Headers = .init(),
                body: Operations.ProjectsMoveColumn.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Creates a new `JsonPayload`.
                        public init() {}
                        public init(from decoder: any Decoder) throws {
                            try decoder.ensureNoAdditionalProperties(knownKeys: [])
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/responses/201/content/application\/json`.
                    case json(Operations.ProjectsMoveColumn.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsMoveColumn.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsMoveColumn.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsMoveColumn.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsMoveColumn.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsMoveColumn.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects/move-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)`.
    public enum ProjectsGet {
        public static let id: Swift.String = "projects/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsGet.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsGet.Input.Path,
                headers: Operations.ProjectsGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects/get)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)`.
    public enum ProjectsUpdate {
        public static let id: Swift.String = "projects/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsUpdate.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// Body of the project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/body`.
                    public var body: Swift.String?
                    /// State of the project; either 'open' or 'closed'
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/state`.
                    public var state: Swift.String?
                    /// The baseline permission that all organization members have on this project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/organization_permission`.
                    @frozen public enum OrganizationPermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                        case none = "none"
                    }
                    /// The baseline permission that all organization members have on this project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/organization_permission`.
                    public var organizationPermission: Operations.ProjectsUpdate.Input.Body.JsonPayload.OrganizationPermissionPayload?
                    /// Whether or not this project can be seen by everyone.
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/private`.
                    public var _private: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project
                    ///   - body: Body of the project
                    ///   - state: State of the project; either 'open' or 'closed'
                    ///   - organizationPermission: The baseline permission that all organization members have on this project
                    ///   - _private: Whether or not this project can be seen by everyone.
                    public init(
                        name: Swift.String? = nil,
                        body: Swift.String? = nil,
                        state: Swift.String? = nil,
                        organizationPermission: Operations.ProjectsUpdate.Input.Body.JsonPayload.OrganizationPermissionPayload? = nil,
                        _private: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self.body = body
                        self.state = state
                        self.organizationPermission = organizationPermission
                        self._private = _private
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                        case state
                        case organizationPermission = "organization_permission"
                        case _private = "private"
                    }
                }
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ProjectsUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsUpdate.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsUpdate.Input.Path,
                headers: Operations.ProjectsUpdate.Input.Headers = .init(),
                body: Operations.ProjectsUpdate.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if the authenticated user does not have access to the project
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.ProjectsUpdate.Output.NotFound)
            /// Not Found if the authenticated user does not have access to the project
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.ProjectsUpdate.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json/errors`.
                        public var errors: [Swift.String]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: [Swift.String]? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/application\/json`.
                    case json(Operations.ProjectsUpdate.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsUpdate.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsUpdate.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsUpdate.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ProjectsUpdate.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ProjectsUpdate.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects/update)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)`.
    public enum ProjectsDelete {
        public static let id: Swift.String = "projects/delete"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsDelete.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsDelete.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsDelete.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsDelete.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsDelete.Input.Path,
                headers: Operations.ProjectsDelete.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Delete Success
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsDelete.Output.NoContent)
            /// Delete Success
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsDelete.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json/errors`.
                        public var errors: [Swift.String]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: [Swift.String]? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/application\/json`.
                    case json(Operations.ProjectsDelete.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsDelete.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsDelete.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsDelete.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ProjectsDelete.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ProjectsDelete.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects/delete)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List project collaborators
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)`.
    public enum ProjectsListCollaborators {
        public static let id: Swift.String = "projects/list-collaborators"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsListCollaborators.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/affiliation`.
                @frozen public enum AffiliationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case outside = "outside"
                    case direct = "direct"
                    case all = "all"
                }
                /// Filters the collaborators by their affiliation. `outside` means outside collaborators of a project that are not a member of the project's organization. `direct` means collaborators with permissions to a project, regardless of organization membership status. `all` means all collaborators the authenticated user can see.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/affiliation`.
                public var affiliation: Operations.ProjectsListCollaborators.Input.Query.AffiliationPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - affiliation: Filters the collaborators by their affiliation. `outside` means outside collaborators of a project that are not a member of the project's organization. `direct` means collaborators with permissions to a project, regardless of organization membership status. `all` means all collaborators the authenticated user can see.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    affiliation: Operations.ProjectsListCollaborators.Input.Query.AffiliationPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.affiliation = affiliation
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsListCollaborators.Input.Query
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListCollaborators.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListCollaborators.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsListCollaborators.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsListCollaborators.Input.Path,
                query: Operations.ProjectsListCollaborators.Input.Query = .init(),
                headers: Operations.ProjectsListCollaborators.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsListCollaborators.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsListCollaborators.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsListCollaborators.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsListCollaborators.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsListCollaborators.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsListCollaborators.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects/list-collaborators)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add project collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)`.
    public enum ProjectsAddCollaborator {
        public static let id: Swift.String = "projects/add-collaborator"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                ///   - username: The handle for the GitHub user account.
                public init(
                    projectId: Components.Parameters.ProjectId,
                    username: Components.Parameters.Username
                ) {
                    self.projectId = projectId
                    self.username = username
                }
            }
            public var path: Operations.ProjectsAddCollaborator.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsAddCollaborator.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsAddCollaborator.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsAddCollaborator.Input.Headers
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The permission to grant the collaborator.
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                    }
                    /// The permission to grant the collaborator.
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/json/permission`.
                    public var permission: Operations.ProjectsAddCollaborator.Input.Body.JsonPayload.PermissionPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - permission: The permission to grant the collaborator.
                    public init(permission: Operations.ProjectsAddCollaborator.Input.Body.JsonPayload.PermissionPayload? = nil) {
                        self.permission = permission
                    }
                    public enum CodingKeys: String, CodingKey {
                        case permission
                    }
                }
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/content/application\/json`.
                case json(Operations.ProjectsAddCollaborator.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsAddCollaborator.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsAddCollaborator.Input.Path,
                headers: Operations.ProjectsAddCollaborator.Input.Headers = .init(),
                body: Operations.ProjectsAddCollaborator.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsAddCollaborator.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsAddCollaborator.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects/add-collaborator)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove user as a collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)`.
    public enum ProjectsRemoveCollaborator {
        public static let id: Swift.String = "projects/remove-collaborator"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                ///   - username: The handle for the GitHub user account.
                public init(
                    projectId: Components.Parameters.ProjectId,
                    username: Components.Parameters.Username
                ) {
                    self.projectId = projectId
                    self.username = username
                }
            }
            public var path: Operations.ProjectsRemoveCollaborator.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsRemoveCollaborator.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsRemoveCollaborator.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsRemoveCollaborator.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsRemoveCollaborator.Input.Path,
                headers: Operations.ProjectsRemoveCollaborator.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsRemoveCollaborator.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsRemoveCollaborator.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects/remove-collaborator)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get project permission for a user
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)`.
    public enum ProjectsGetPermissionForUser {
        public static let id: Swift.String = "projects/get-permission-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                ///   - username: The handle for the GitHub user account.
                public init(
                    projectId: Components.Parameters.ProjectId,
                    username: Components.Parameters.Username
                ) {
                    self.projectId = projectId
                    self.username = username
                }
            }
            public var path: Operations.ProjectsGetPermissionForUser.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGetPermissionForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsGetPermissionForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsGetPermissionForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsGetPermissionForUser.Input.Path,
                headers: Operations.ProjectsGetPermissionForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectCollaboratorPermission)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectCollaboratorPermission {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsGetPermissionForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsGetPermissionForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsGetPermissionForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsGetPermissionForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects/get-permission-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List project columns
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)`.
    public enum ProjectsListColumns {
        public static let id: Swift.String = "projects/list-columns"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsListColumns.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsListColumns.Input.Query
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListColumns.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListColumns.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsListColumns.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsListColumns.Input.Path,
                query: Operations.ProjectsListColumns.Input.Query = .init(),
                headers: Operations.ProjectsListColumns.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsListColumns.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.ProjectColumn])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.ProjectColumn] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsListColumns.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsListColumns.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsListColumns.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsListColumns.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsListColumns.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects/list-columns)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)`.
    public enum ProjectsCreateColumn {
        public static let id: Swift.String = "projects/create-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsCreateColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsCreateColumn.Input.Headers
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project column
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project column
                    public init(name: Swift.String) {
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                    }
                }
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsCreateColumn.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsCreateColumn.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsCreateColumn.Input.Path,
                headers: Operations.ProjectsCreateColumn.Input.Headers = .init(),
                body: Operations.ProjectsCreateColumn.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.ProjectColumn)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectColumn {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateColumn.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateColumn.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsCreateColumn.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsCreateColumn.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects/create-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)`.
    public enum ProjectsListForRepo {
        public static let id: Swift.String = "projects/list-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ProjectsListForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the projects to return.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/state`.
                public var state: Operations.ProjectsListForRepo.Input.Query.StatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Indicates the state of the projects to return.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.ProjectsListForRepo.Input.Query.StatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsListForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsListForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsListForRepo.Input.Path,
                query: Operations.ProjectsListForRepo.Input.Query = .init(),
                headers: Operations.ProjectsListForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsListForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Project])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Project] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsListForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsListForRepo.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsListForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsListForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsListForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects/list-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a repository project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)`.
    public enum ProjectsCreateForRepo {
        public static let id: Swift.String = "projects/create-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ProjectsCreateForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsCreateForRepo.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the project.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The description of the project.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the project.
                    ///   - body: The description of the project.
                    public init(
                        name: Swift.String,
                        body: Swift.String? = nil
                    ) {
                        self.name = name
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsCreateForRepo.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsCreateForRepo.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsCreateForRepo.Input.Path,
                headers: Operations.ProjectsCreateForRepo.Input.Headers = .init(),
                body: Operations.ProjectsCreateForRepo.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateForRepo.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateForRepo.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsCreateForRepo.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsCreateForRepo.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects/create-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a user project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /user/projects`.
    /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)`.
    public enum ProjectsCreateForAuthenticatedUser {
        public static let id: Swift.String = "projects/create-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/projects/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsCreateForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsCreateForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/projects/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project
                    ///
                    /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// Body of the project
                    ///
                    /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project
                    ///   - body: Body of the project
                    public init(
                        name: Swift.String,
                        body: Swift.String? = nil
                    ) {
                        self.name = name
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsCreateForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsCreateForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.ProjectsCreateForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.ProjectsCreateForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/projects/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/projects/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsCreateForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsCreateForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsCreateForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsCreateForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects/create-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List user projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /users/{username}/projects`.
    /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects/list-for-user)`.
    public enum ProjectsListForUser {
        public static let id: Swift.String = "projects/list-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ProjectsListForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the projects to return.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/state`.
                public var state: Operations.ProjectsListForUser.Input.Query.StatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Indicates the state of the projects to return.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.ProjectsListForUser.Input.Query.StatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsListForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsListForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsListForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsListForUser.Input.Path,
                query: Operations.ProjectsListForUser.Input.Query = .init(),
                headers: Operations.ProjectsListForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsListForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Project])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Project] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsListForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsListForUser.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsListForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects/list-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsListForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsListForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects/list-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
