// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List private registries for an organization
    ///
    ///
    /// Lists all private registry configurations available at the organization-level without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/get(private-registries/list-org-private-registries)`.
    func privateRegistriesListOrgPrivateRegistries(_ input: Operations.PrivateRegistriesListOrgPrivateRegistries.Input) async throws -> Operations.PrivateRegistriesListOrgPrivateRegistries.Output
    /// Create a private registry for an organization
    ///
    ///
    /// Creates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/private-registries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/post(private-registries/create-org-private-registry)`.
    func privateRegistriesCreateOrgPrivateRegistry(_ input: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input) async throws -> Operations.PrivateRegistriesCreateOrgPrivateRegistry.Output
    /// Get private registries public key for an organization
    ///
    ///
    /// Gets the org public key, which is needed to encrypt private registry secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/public-key/get(private-registries/get-org-public-key)`.
    func privateRegistriesGetOrgPublicKey(_ input: Operations.PrivateRegistriesGetOrgPublicKey.Input) async throws -> Operations.PrivateRegistriesGetOrgPublicKey.Output
    /// Get a private registry for an organization
    ///
    ///
    /// Get the configuration of a single private registry defined for an organization, omitting its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/get(private-registries/get-org-private-registry)`.
    func privateRegistriesGetOrgPrivateRegistry(_ input: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input) async throws -> Operations.PrivateRegistriesGetOrgPrivateRegistry.Output
    /// Update a private registry for an organization
    ///
    ///
    /// Updates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)`.
    func privateRegistriesUpdateOrgPrivateRegistry(_ input: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input) async throws -> Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Output
    /// Delete a private registry for an organization
    ///
    ///
    /// Delete a private registry configuration at the organization-level.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)`.
    func privateRegistriesDeleteOrgPrivateRegistry(_ input: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input) async throws -> Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List private registries for an organization
    ///
    ///
    /// Lists all private registry configurations available at the organization-level without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/get(private-registries/list-org-private-registries)`.
    public func privateRegistriesListOrgPrivateRegistries(
        path: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Path,
        query: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Query = .init(),
        headers: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Headers = .init()
    ) async throws -> Operations.PrivateRegistriesListOrgPrivateRegistries.Output {
        try await privateRegistriesListOrgPrivateRegistries(Operations.PrivateRegistriesListOrgPrivateRegistries.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a private registry for an organization
    ///
    ///
    /// Creates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/private-registries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/post(private-registries/create-org-private-registry)`.
    public func privateRegistriesCreateOrgPrivateRegistry(
        path: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Path,
        headers: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Headers = .init(),
        body: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body
    ) async throws -> Operations.PrivateRegistriesCreateOrgPrivateRegistry.Output {
        try await privateRegistriesCreateOrgPrivateRegistry(Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get private registries public key for an organization
    ///
    ///
    /// Gets the org public key, which is needed to encrypt private registry secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/public-key/get(private-registries/get-org-public-key)`.
    public func privateRegistriesGetOrgPublicKey(
        path: Operations.PrivateRegistriesGetOrgPublicKey.Input.Path,
        headers: Operations.PrivateRegistriesGetOrgPublicKey.Input.Headers = .init()
    ) async throws -> Operations.PrivateRegistriesGetOrgPublicKey.Output {
        try await privateRegistriesGetOrgPublicKey(Operations.PrivateRegistriesGetOrgPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a private registry for an organization
    ///
    ///
    /// Get the configuration of a single private registry defined for an organization, omitting its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/get(private-registries/get-org-private-registry)`.
    public func privateRegistriesGetOrgPrivateRegistry(
        path: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input.Path,
        headers: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input.Headers = .init()
    ) async throws -> Operations.PrivateRegistriesGetOrgPrivateRegistry.Output {
        try await privateRegistriesGetOrgPrivateRegistry(Operations.PrivateRegistriesGetOrgPrivateRegistry.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a private registry for an organization
    ///
    ///
    /// Updates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)`.
    public func privateRegistriesUpdateOrgPrivateRegistry(
        path: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Path,
        headers: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Headers = .init(),
        body: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body
    ) async throws -> Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Output {
        try await privateRegistriesUpdateOrgPrivateRegistry(Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a private registry for an organization
    ///
    ///
    /// Delete a private registry configuration at the organization-level.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)`.
    public func privateRegistriesDeleteOrgPrivateRegistry(
        path: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input.Path,
        headers: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input.Headers = .init()
    ) async throws -> Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Output {
        try await privateRegistriesDeleteOrgPrivateRegistry(Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Private registry configuration for an organization
        ///
        /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration`.
        public struct OrgPrivateRegistryConfiguration: Codable, Hashable, Sendable {
            /// The name of the private registry configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/name`.
            public var name: Swift.String
            /// The registry type.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/registry_type`.
            @frozen public enum RegistryTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case mavenRepository = "maven_repository"
                case nugetFeed = "nuget_feed"
                case goproxyServer = "goproxy_server"
                case npmRegistry = "npm_registry"
                case rubygemsServer = "rubygems_server"
                case cargoRegistry = "cargo_registry"
                case composerRepository = "composer_repository"
                case dockerRegistry = "docker_registry"
                case gitSource = "git_source"
                case helmRegistry = "helm_registry"
                case hexOrganization = "hex_organization"
                case hexRepository = "hex_repository"
                case pubRepository = "pub_repository"
                case pythonIndex = "python_index"
                case terraformRegistry = "terraform_registry"
            }
            /// The registry type.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/registry_type`.
            public var registryType: Components.Schemas.OrgPrivateRegistryConfiguration.RegistryTypePayload
            /// The username to use when authenticating with the private registry.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/username`.
            public var username: Swift.String?
            /// Which type of organization repositories have access to the private registry.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// Which type of organization repositories have access to the private registry.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/visibility`.
            public var visibility: Components.Schemas.OrgPrivateRegistryConfiguration.VisibilityPayload
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `OrgPrivateRegistryConfiguration`.
            ///
            /// - Parameters:
            ///   - name: The name of the private registry configuration.
            ///   - registryType: The registry type.
            ///   - username: The username to use when authenticating with the private registry.
            ///   - visibility: Which type of organization repositories have access to the private registry.
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                name: Swift.String,
                registryType: Components.Schemas.OrgPrivateRegistryConfiguration.RegistryTypePayload,
                username: Swift.String? = nil,
                visibility: Components.Schemas.OrgPrivateRegistryConfiguration.VisibilityPayload,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.name = name
                self.registryType = registryType
                self.username = username
                self.visibility = visibility
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case registryType = "registry_type"
                case username
                case visibility
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Private registry configuration for an organization
        ///
        /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories`.
        public struct OrgPrivateRegistryConfigurationWithSelectedRepositories: Codable, Hashable, Sendable {
            /// The name of the private registry configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/name`.
            public var name: Swift.String
            /// The registry type.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/registry_type`.
            @frozen public enum RegistryTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case mavenRepository = "maven_repository"
                case nugetFeed = "nuget_feed"
                case goproxyServer = "goproxy_server"
                case npmRegistry = "npm_registry"
                case rubygemsServer = "rubygems_server"
                case cargoRegistry = "cargo_registry"
                case composerRepository = "composer_repository"
                case dockerRegistry = "docker_registry"
                case gitSource = "git_source"
                case helmRegistry = "helm_registry"
                case hexOrganization = "hex_organization"
                case hexRepository = "hex_repository"
                case pubRepository = "pub_repository"
                case pythonIndex = "python_index"
                case terraformRegistry = "terraform_registry"
            }
            /// The registry type.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/registry_type`.
            public var registryType: Components.Schemas.OrgPrivateRegistryConfigurationWithSelectedRepositories.RegistryTypePayload
            /// The username to use when authenticating with the private registry.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/username`.
            public var username: Swift.String?
            /// Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/visibility`.
            public var visibility: Components.Schemas.OrgPrivateRegistryConfigurationWithSelectedRepositories.VisibilityPayload
            /// An array of repository IDs that can access the organization private registry when `visibility` is set to `selected`.
            ///
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/selected_repository_ids`.
            public var selectedRepositoryIds: [Swift.Int]?
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/org-private-registry-configuration-with-selected-repositories/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `OrgPrivateRegistryConfigurationWithSelectedRepositories`.
            ///
            /// - Parameters:
            ///   - name: The name of the private registry configuration.
            ///   - registryType: The registry type.
            ///   - username: The username to use when authenticating with the private registry.
            ///   - visibility: Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
            ///   - selectedRepositoryIds: An array of repository IDs that can access the organization private registry when `visibility` is set to `selected`.
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                name: Swift.String,
                registryType: Components.Schemas.OrgPrivateRegistryConfigurationWithSelectedRepositories.RegistryTypePayload,
                username: Swift.String? = nil,
                visibility: Components.Schemas.OrgPrivateRegistryConfigurationWithSelectedRepositories.VisibilityPayload,
                selectedRepositoryIds: [Swift.Int]? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.name = name
                self.registryType = registryType
                self.username = username
                self.visibility = visibility
                self.selectedRepositoryIds = selectedRepositoryIds
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case registryType = "registry_type"
                case username
                case visibility
                case selectedRepositoryIds = "selected_repository_ids"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The name of the secret.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-name`.
        public typealias SecretName = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List private registries for an organization
    ///
    ///
    /// Lists all private registry configurations available at the organization-level without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/get(private-registries/list-org-private-registries)`.
    public enum PrivateRegistriesListOrgPrivateRegistries {
        public static let id: Swift.String = "private-registries/list-org-private-registries"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesListOrgPrivateRegistries.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesListOrgPrivateRegistries.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Path,
                query: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Query = .init(),
                headers: Operations.PrivateRegistriesListOrgPrivateRegistries.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/content/json/configurations`.
                        public var configurations: [Components.Schemas.OrgPrivateRegistryConfiguration]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - configurations:
                        public init(
                            totalCount: Swift.Int,
                            configurations: [Components.Schemas.OrgPrivateRegistryConfiguration]
                        ) {
                            self.totalCount = totalCount
                            self.configurations = configurations
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case configurations
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/GET/responses/200/content/application\/json`.
                    case json(Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok.Headers = .init(),
                    body: Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/get(private-registries/list-org-private-registries)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PrivateRegistriesListOrgPrivateRegistries.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/get(private-registries/list-org-private-registries)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/get(private-registries/list-org-private-registries)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Create a private registry for an organization
    ///
    ///
    /// Creates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/private-registries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/post(private-registries/create-org-private-registry)`.
    public enum PrivateRegistriesCreateOrgPrivateRegistry {
        public static let id: Swift.String = "private-registries/create-org-private-registry"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesCreateOrgPrivateRegistry.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesCreateOrgPrivateRegistry.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The registry type.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/registry_type`.
                    @frozen public enum RegistryTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case mavenRepository = "maven_repository"
                        case nugetFeed = "nuget_feed"
                        case goproxyServer = "goproxy_server"
                        case npmRegistry = "npm_registry"
                        case rubygemsServer = "rubygems_server"
                        case cargoRegistry = "cargo_registry"
                        case composerRepository = "composer_repository"
                        case dockerRegistry = "docker_registry"
                        case gitSource = "git_source"
                        case helmRegistry = "helm_registry"
                        case hexOrganization = "hex_organization"
                        case hexRepository = "hex_repository"
                        case pubRepository = "pub_repository"
                        case pythonIndex = "python_index"
                        case terraformRegistry = "terraform_registry"
                    }
                    /// The registry type.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/registry_type`.
                    public var registryType: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body.JsonPayload.RegistryTypePayload
                    /// The URL of the private registry.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/url`.
                    public var url: Swift.String
                    /// The username to use when authenticating with the private registry. This field should be omitted if the private registry does not require a username for authentication.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/username`.
                    public var username: Swift.String?
                    /// The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get private registries public key for an organization](https://docs.github.com/rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String
                    /// The ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/key_id`.
                    public var keyId: Swift.String
                    /// Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/visibility`.
                    @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case _private = "private"
                        case selected = "selected"
                    }
                    /// Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/visibility`.
                    public var visibility: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body.JsonPayload.VisibilityPayload
                    /// An array of repository IDs that can access the organization private registry. You can only provide a list of repository IDs when `visibility` is set to `selected`. You can manage the list of selected repositories using the [Update a private registry for an organization](https://docs.github.com/rest/private-registries/organization-configurations#update-a-private-registry-for-an-organization) endpoint. This field should be omitted if `visibility` is set to `all` or `private`.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - registryType: The registry type.
                    ///   - url: The URL of the private registry.
                    ///   - username: The username to use when authenticating with the private registry. This field should be omitted if the private registry does not require a username for authentication.
                    ///   - encryptedValue: The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get private registries public key for an organization](https://docs.github.com/rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization) endpoint.
                    ///   - keyId: The ID of the key you used to encrypt the secret.
                    ///   - visibility: Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
                    ///   - selectedRepositoryIds: An array of repository IDs that can access the organization private registry. You can only provide a list of repository IDs when `visibility` is set to `selected`. You can manage the list of selected repositories using the [Update a private registry for an organization](https://docs.github.com/rest/private-registries/organization-configurations#update-a-private-registry-for-an-organization) endpoint. This field should be omitted if `visibility` is set to `all` or `private`.
                    public init(
                        registryType: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body.JsonPayload.RegistryTypePayload,
                        url: Swift.String,
                        username: Swift.String? = nil,
                        encryptedValue: Swift.String,
                        keyId: Swift.String,
                        visibility: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body.JsonPayload.VisibilityPayload,
                        selectedRepositoryIds: [Swift.Int]? = nil
                    ) {
                        self.registryType = registryType
                        self.url = url
                        self.username = username
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                        self.visibility = visibility
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case registryType = "registry_type"
                        case url
                        case username
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                        case visibility
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/requestBody/content/application\/json`.
                case json(Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body.JsonPayload)
            }
            public var body: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Path,
                headers: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Headers = .init(),
                body: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.OrgPrivateRegistryConfigurationWithSelectedRepositories)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrgPrivateRegistryConfigurationWithSelectedRepositories {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Output.Created.Body) {
                    self.body = body
                }
            }
            /// The organization private registry configuration
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/post(private-registries/create-org-private-registry)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.PrivateRegistriesCreateOrgPrivateRegistry.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.PrivateRegistriesCreateOrgPrivateRegistry.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/post(private-registries/create-org-private-registry)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/post(private-registries/create-org-private-registry)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get private registries public key for an organization
    ///
    ///
    /// Gets the org public key, which is needed to encrypt private registry secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/public-key/get(private-registries/get-org-public-key)`.
    public enum PrivateRegistriesGetOrgPublicKey {
        public static let id: Swift.String = "private-registries/get-org-public-key"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.PrivateRegistriesGetOrgPublicKey.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesGetOrgPublicKey.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesGetOrgPublicKey.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PrivateRegistriesGetOrgPublicKey.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PrivateRegistriesGetOrgPublicKey.Input.Path,
                headers: Operations.PrivateRegistriesGetOrgPublicKey.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// The identifier for the key.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/content/json/key_id`.
                        public var keyId: Swift.String
                        /// The Base64 encoded public key.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/content/json/key`.
                        public var key: Swift.String
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - keyId: The identifier for the key.
                        ///   - key: The Base64 encoded public key.
                        public init(
                            keyId: Swift.String,
                            key: Swift.String
                        ) {
                            self.keyId = keyId
                            self.key = key
                        }
                        public enum CodingKeys: String, CodingKey {
                            case keyId = "key_id"
                            case key
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/public-key/GET/responses/200/content/application\/json`.
                    case json(Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok.Headers = .init(),
                    body: Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/public-key/get(private-registries/get-org-public-key)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PrivateRegistriesGetOrgPublicKey.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/public-key/get(private-registries/get-org-public-key)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a private registry for an organization
    ///
    ///
    /// Get the configuration of a single private registry defined for an organization, omitting its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/get(private-registries/get-org-private-registry)`.
    public enum PrivateRegistriesGetOrgPrivateRegistry {
        public static let id: Swift.String = "private-registries/get-org-private-registry"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesGetOrgPrivateRegistry.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesGetOrgPrivateRegistry.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input.Path,
                headers: Operations.PrivateRegistriesGetOrgPrivateRegistry.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.OrgPrivateRegistryConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrgPrivateRegistryConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PrivateRegistriesGetOrgPrivateRegistry.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PrivateRegistriesGetOrgPrivateRegistry.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// The specified private registry configuration for the organization
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/get(private-registries/get-org-private-registry)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PrivateRegistriesGetOrgPrivateRegistry.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PrivateRegistriesGetOrgPrivateRegistry.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/get(private-registries/get-org-private-registry)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a private registry for an organization
    ///
    ///
    /// Updates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)`.
    public enum PrivateRegistriesUpdateOrgPrivateRegistry {
        public static let id: Swift.String = "private-registries/update-org-private-registry"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesUpdateOrgPrivateRegistry.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesUpdateOrgPrivateRegistry.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The registry type.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/registry_type`.
                    @frozen public enum RegistryTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case mavenRepository = "maven_repository"
                        case nugetFeed = "nuget_feed"
                        case goproxyServer = "goproxy_server"
                        case npmRegistry = "npm_registry"
                        case rubygemsServer = "rubygems_server"
                        case cargoRegistry = "cargo_registry"
                        case composerRepository = "composer_repository"
                        case dockerRegistry = "docker_registry"
                        case gitSource = "git_source"
                        case helmRegistry = "helm_registry"
                        case hexOrganization = "hex_organization"
                        case hexRepository = "hex_repository"
                        case pubRepository = "pub_repository"
                        case pythonIndex = "python_index"
                        case terraformRegistry = "terraform_registry"
                    }
                    /// The registry type.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/registry_type`.
                    public var registryType: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body.JsonPayload.RegistryTypePayload?
                    /// The URL of the private registry.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/url`.
                    public var url: Swift.String?
                    /// The username to use when authenticating with the private registry. This field should be omitted if the private registry does not require a username for authentication.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/username`.
                    public var username: Swift.String?
                    /// The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get private registries public key for an organization](https://docs.github.com/rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String?
                    /// The ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/key_id`.
                    public var keyId: Swift.String?
                    /// Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/visibility`.
                    @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case _private = "private"
                        case selected = "selected"
                    }
                    /// Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/visibility`.
                    public var visibility: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body.JsonPayload.VisibilityPayload?
                    /// An array of repository IDs that can access the organization private registry. You can only provide a list of repository IDs when `visibility` is set to `selected`. This field should be omitted if `visibility` is set to `all` or `private`.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - registryType: The registry type.
                    ///   - url: The URL of the private registry.
                    ///   - username: The username to use when authenticating with the private registry. This field should be omitted if the private registry does not require a username for authentication.
                    ///   - encryptedValue: The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get private registries public key for an organization](https://docs.github.com/rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization) endpoint.
                    ///   - keyId: The ID of the key you used to encrypt the secret.
                    ///   - visibility: Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry.
                    ///   - selectedRepositoryIds: An array of repository IDs that can access the organization private registry. You can only provide a list of repository IDs when `visibility` is set to `selected`. This field should be omitted if `visibility` is set to `all` or `private`.
                    public init(
                        registryType: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body.JsonPayload.RegistryTypePayload? = nil,
                        url: Swift.String? = nil,
                        username: Swift.String? = nil,
                        encryptedValue: Swift.String? = nil,
                        keyId: Swift.String? = nil,
                        visibility: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body.JsonPayload.VisibilityPayload? = nil,
                        selectedRepositoryIds: [Swift.Int]? = nil
                    ) {
                        self.registryType = registryType
                        self.url = url
                        self.username = username
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                        self.visibility = visibility
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case registryType = "registry_type"
                        case url
                        case username
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                        case visibility
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/PATCH/requestBody/content/application\/json`.
                case json(Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body.JsonPayload)
            }
            public var body: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Path,
                headers: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Headers = .init(),
                body: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PrivateRegistriesUpdateOrgPrivateRegistry.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/patch(private-registries/update-org-private-registry)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a private registry for an organization
    ///
    ///
    /// Delete a private registry configuration at the organization-level.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/private-registries/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)`.
    public enum PrivateRegistriesDeleteOrgPrivateRegistry {
        public static let id: Swift.String = "private-registries/delete-org-private-registry"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/private-registries/{secret_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesDeleteOrgPrivateRegistry.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PrivateRegistriesDeleteOrgPrivateRegistry.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input.Path,
                headers: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PrivateRegistriesDeleteOrgPrivateRegistry.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/private-registries/{secret_name}/delete(private-registries/delete-org-private-registry)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
}
