// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get list of conflicting packages during Docker migration for organization
    ///
    /// Lists all packages that are in a specific organization, are readable by the requesting user, and that encountered a conflict during a Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/docker/conflicts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-organization)`.
    func packagesListDockerMigrationConflictingPackagesForOrganization(_ input: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input) async throws -> Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Output
    /// List packages for an organization
    ///
    /// Lists packages in an organization readable by the user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)`.
    func packagesListPackagesForOrganization(_ input: Operations.PackagesListPackagesForOrganization.Input) async throws -> Operations.PackagesListPackagesForOrganization.Output
    /// Get a package for an organization
    ///
    /// Gets a specific package in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/get(packages/get-package-for-organization)`.
    func packagesGetPackageForOrganization(_ input: Operations.PackagesGetPackageForOrganization.Input) async throws -> Operations.PackagesGetPackageForOrganization.Output
    /// Delete a package for an organization
    ///
    /// Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)`.
    func packagesDeletePackageForOrg(_ input: Operations.PackagesDeletePackageForOrg.Input) async throws -> Operations.PackagesDeletePackageForOrg.Output
    /// Restore a package for an organization
    ///
    /// Restores an entire package in an organization.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)`.
    func packagesRestorePackageForOrg(_ input: Operations.PackagesRestorePackageForOrg.Input) async throws -> Operations.PackagesRestorePackageForOrg.Output
    /// List package versions for a package owned by an organization
    ///
    /// Lists package versions for a package owned by an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)`.
    func packagesGetAllPackageVersionsForPackageOwnedByOrg(_ input: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input) async throws -> Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Output
    /// Get a package version for an organization
    ///
    /// Gets a specific package version in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-organization)`.
    func packagesGetPackageVersionForOrganization(_ input: Operations.PackagesGetPackageVersionForOrganization.Input) async throws -> Operations.PackagesGetPackageVersionForOrganization.Output
    /// Delete package version for an organization
    ///
    /// Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)`.
    func packagesDeletePackageVersionForOrg(_ input: Operations.PackagesDeletePackageVersionForOrg.Input) async throws -> Operations.PackagesDeletePackageVersionForOrg.Output
    /// Restore package version for an organization
    ///
    /// Restores a specific package version in an organization.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)`.
    func packagesRestorePackageVersionForOrg(_ input: Operations.PackagesRestorePackageVersionForOrg.Input) async throws -> Operations.PackagesRestorePackageVersionForOrg.Output
    /// Get list of conflicting packages during Docker migration for authenticated-user
    ///
    /// Lists all packages that are owned by the authenticated user within the user's namespace, and that encountered a conflict during a Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/docker/conflicts`.
    /// - Remark: Generated from `#/paths//user/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-authenticated-user)`.
    func packagesListDockerMigrationConflictingPackagesForAuthenticatedUser(_ input: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Input) async throws -> Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Output
    /// List packages for the authenticated user's namespace
    ///
    /// Lists packages owned by the authenticated user within the user's namespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages`.
    /// - Remark: Generated from `#/paths//user/packages/get(packages/list-packages-for-authenticated-user)`.
    func packagesListPackagesForAuthenticatedUser(_ input: Operations.PackagesListPackagesForAuthenticatedUser.Input) async throws -> Operations.PackagesListPackagesForAuthenticatedUser.Output
    /// Get a package for the authenticated user
    ///
    /// Gets a specific package for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/get(packages/get-package-for-authenticated-user)`.
    func packagesGetPackageForAuthenticatedUser(_ input: Operations.PackagesGetPackageForAuthenticatedUser.Input) async throws -> Operations.PackagesGetPackageForAuthenticatedUser.Output
    /// Delete a package for the authenticated user
    ///
    /// Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /user/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)`.
    func packagesDeletePackageForAuthenticatedUser(_ input: Operations.PackagesDeletePackageForAuthenticatedUser.Input) async throws -> Operations.PackagesDeletePackageForAuthenticatedUser.Output
    /// Restore a package for the authenticated user
    ///
    /// Restores a package owned by the authenticated user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /user/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)`.
    func packagesRestorePackageForAuthenticatedUser(_ input: Operations.PackagesRestorePackageForAuthenticatedUser.Input) async throws -> Operations.PackagesRestorePackageForAuthenticatedUser.Output
    /// List package versions for a package owned by the authenticated user
    ///
    /// Lists package versions for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)`.
    func packagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser(_ input: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input) async throws -> Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Output
    /// Get a package version for the authenticated user
    ///
    /// Gets a specific package version for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-authenticated-user)`.
    func packagesGetPackageVersionForAuthenticatedUser(_ input: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input) async throws -> Operations.PackagesGetPackageVersionForAuthenticatedUser.Output
    /// Delete a package version for the authenticated user
    ///
    /// Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /user/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)`.
    func packagesDeletePackageVersionForAuthenticatedUser(_ input: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input) async throws -> Operations.PackagesDeletePackageVersionForAuthenticatedUser.Output
    /// Restore a package version for the authenticated user
    ///
    /// Restores a package version owned by the authenticated user.
    ///
    /// You can restore a deleted package version under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)`.
    func packagesRestorePackageVersionForAuthenticatedUser(_ input: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input) async throws -> Operations.PackagesRestorePackageVersionForAuthenticatedUser.Output
    /// Get list of conflicting packages during Docker migration for user
    ///
    /// Lists all packages that are in a specific user's namespace, that the requesting user has access to, and that encountered a conflict during Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/docker/conflicts`.
    /// - Remark: Generated from `#/paths//users/{username}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-user)`.
    func packagesListDockerMigrationConflictingPackagesForUser(_ input: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input) async throws -> Operations.PackagesListDockerMigrationConflictingPackagesForUser.Output
    /// List packages for a user
    ///
    /// Lists all packages in a user's namespace for which the requesting user has access.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)`.
    func packagesListPackagesForUser(_ input: Operations.PackagesListPackagesForUser.Input) async throws -> Operations.PackagesListPackagesForUser.Output
    /// Get a package for a user
    ///
    /// Gets a specific package metadata for a public package owned by a user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/get(packages/get-package-for-user)`.
    func packagesGetPackageForUser(_ input: Operations.PackagesGetPackageForUser.Input) async throws -> Operations.PackagesGetPackageForUser.Output
    /// Delete a package for a user
    ///
    /// Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /users/{username}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)`.
    func packagesDeletePackageForUser(_ input: Operations.PackagesDeletePackageForUser.Input) async throws -> Operations.PackagesDeletePackageForUser.Output
    /// Restore a package for a user
    ///
    /// Restores an entire package for a user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /users/{username}/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)`.
    func packagesRestorePackageForUser(_ input: Operations.PackagesRestorePackageForUser.Input) async throws -> Operations.PackagesRestorePackageForUser.Output
    /// List package versions for a package owned by a user
    ///
    /// Lists package versions for a public package owned by a specified user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)`.
    func packagesGetAllPackageVersionsForPackageOwnedByUser(_ input: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input) async throws -> Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Output
    /// Get a package version for a user
    ///
    /// Gets a specific package version for a public package owned by a specified user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-user)`.
    func packagesGetPackageVersionForUser(_ input: Operations.PackagesGetPackageVersionForUser.Input) async throws -> Operations.PackagesGetPackageVersionForUser.Output
    /// Delete package version for a user
    ///
    /// Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)`.
    func packagesDeletePackageVersionForUser(_ input: Operations.PackagesDeletePackageVersionForUser.Input) async throws -> Operations.PackagesDeletePackageVersionForUser.Output
    /// Restore package version for a user
    ///
    /// Restores a specific package version for a user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)`.
    func packagesRestorePackageVersionForUser(_ input: Operations.PackagesRestorePackageVersionForUser.Input) async throws -> Operations.PackagesRestorePackageVersionForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get list of conflicting packages during Docker migration for organization
    ///
    /// Lists all packages that are in a specific organization, are readable by the requesting user, and that encountered a conflict during a Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/docker/conflicts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-organization)`.
    public func packagesListDockerMigrationConflictingPackagesForOrganization(
        path: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input.Path,
        headers: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input.Headers = .init()
    ) async throws -> Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Output {
        try await packagesListDockerMigrationConflictingPackagesForOrganization(Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// List packages for an organization
    ///
    /// Lists packages in an organization readable by the user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)`.
    public func packagesListPackagesForOrganization(
        path: Operations.PackagesListPackagesForOrganization.Input.Path,
        query: Operations.PackagesListPackagesForOrganization.Input.Query,
        headers: Operations.PackagesListPackagesForOrganization.Input.Headers = .init()
    ) async throws -> Operations.PackagesListPackagesForOrganization.Output {
        try await packagesListPackagesForOrganization(Operations.PackagesListPackagesForOrganization.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a package for an organization
    ///
    /// Gets a specific package in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/get(packages/get-package-for-organization)`.
    public func packagesGetPackageForOrganization(
        path: Operations.PackagesGetPackageForOrganization.Input.Path,
        headers: Operations.PackagesGetPackageForOrganization.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetPackageForOrganization.Output {
        try await packagesGetPackageForOrganization(Operations.PackagesGetPackageForOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a package for an organization
    ///
    /// Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)`.
    public func packagesDeletePackageForOrg(
        path: Operations.PackagesDeletePackageForOrg.Input.Path,
        headers: Operations.PackagesDeletePackageForOrg.Input.Headers = .init()
    ) async throws -> Operations.PackagesDeletePackageForOrg.Output {
        try await packagesDeletePackageForOrg(Operations.PackagesDeletePackageForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Restore a package for an organization
    ///
    /// Restores an entire package in an organization.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)`.
    public func packagesRestorePackageForOrg(
        path: Operations.PackagesRestorePackageForOrg.Input.Path,
        query: Operations.PackagesRestorePackageForOrg.Input.Query = .init(),
        headers: Operations.PackagesRestorePackageForOrg.Input.Headers = .init()
    ) async throws -> Operations.PackagesRestorePackageForOrg.Output {
        try await packagesRestorePackageForOrg(Operations.PackagesRestorePackageForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List package versions for a package owned by an organization
    ///
    /// Lists package versions for a package owned by an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)`.
    public func packagesGetAllPackageVersionsForPackageOwnedByOrg(
        path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Path,
        query: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Query = .init(),
        headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Output {
        try await packagesGetAllPackageVersionsForPackageOwnedByOrg(Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a package version for an organization
    ///
    /// Gets a specific package version in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-organization)`.
    public func packagesGetPackageVersionForOrganization(
        path: Operations.PackagesGetPackageVersionForOrganization.Input.Path,
        headers: Operations.PackagesGetPackageVersionForOrganization.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetPackageVersionForOrganization.Output {
        try await packagesGetPackageVersionForOrganization(Operations.PackagesGetPackageVersionForOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete package version for an organization
    ///
    /// Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)`.
    public func packagesDeletePackageVersionForOrg(
        path: Operations.PackagesDeletePackageVersionForOrg.Input.Path,
        headers: Operations.PackagesDeletePackageVersionForOrg.Input.Headers = .init()
    ) async throws -> Operations.PackagesDeletePackageVersionForOrg.Output {
        try await packagesDeletePackageVersionForOrg(Operations.PackagesDeletePackageVersionForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Restore package version for an organization
    ///
    /// Restores a specific package version in an organization.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)`.
    public func packagesRestorePackageVersionForOrg(
        path: Operations.PackagesRestorePackageVersionForOrg.Input.Path,
        headers: Operations.PackagesRestorePackageVersionForOrg.Input.Headers = .init()
    ) async throws -> Operations.PackagesRestorePackageVersionForOrg.Output {
        try await packagesRestorePackageVersionForOrg(Operations.PackagesRestorePackageVersionForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get list of conflicting packages during Docker migration for authenticated-user
    ///
    /// Lists all packages that are owned by the authenticated user within the user's namespace, and that encountered a conflict during a Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/docker/conflicts`.
    /// - Remark: Generated from `#/paths//user/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-authenticated-user)`.
    public func packagesListDockerMigrationConflictingPackagesForAuthenticatedUser(headers: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Input.Headers = .init()) async throws -> Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Output {
        try await packagesListDockerMigrationConflictingPackagesForAuthenticatedUser(Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Input(headers: headers))
    }
    /// List packages for the authenticated user's namespace
    ///
    /// Lists packages owned by the authenticated user within the user's namespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages`.
    /// - Remark: Generated from `#/paths//user/packages/get(packages/list-packages-for-authenticated-user)`.
    public func packagesListPackagesForAuthenticatedUser(
        query: Operations.PackagesListPackagesForAuthenticatedUser.Input.Query,
        headers: Operations.PackagesListPackagesForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesListPackagesForAuthenticatedUser.Output {
        try await packagesListPackagesForAuthenticatedUser(Operations.PackagesListPackagesForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a package for the authenticated user
    ///
    /// Gets a specific package for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/get(packages/get-package-for-authenticated-user)`.
    public func packagesGetPackageForAuthenticatedUser(
        path: Operations.PackagesGetPackageForAuthenticatedUser.Input.Path,
        headers: Operations.PackagesGetPackageForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetPackageForAuthenticatedUser.Output {
        try await packagesGetPackageForAuthenticatedUser(Operations.PackagesGetPackageForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a package for the authenticated user
    ///
    /// Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /user/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)`.
    public func packagesDeletePackageForAuthenticatedUser(
        path: Operations.PackagesDeletePackageForAuthenticatedUser.Input.Path,
        headers: Operations.PackagesDeletePackageForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesDeletePackageForAuthenticatedUser.Output {
        try await packagesDeletePackageForAuthenticatedUser(Operations.PackagesDeletePackageForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Restore a package for the authenticated user
    ///
    /// Restores a package owned by the authenticated user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /user/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)`.
    public func packagesRestorePackageForAuthenticatedUser(
        path: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Path,
        query: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesRestorePackageForAuthenticatedUser.Output {
        try await packagesRestorePackageForAuthenticatedUser(Operations.PackagesRestorePackageForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List package versions for a package owned by the authenticated user
    ///
    /// Lists package versions for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)`.
    public func packagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser(
        path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Path,
        query: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Query = .init(),
        headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Output {
        try await packagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser(Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a package version for the authenticated user
    ///
    /// Gets a specific package version for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-authenticated-user)`.
    public func packagesGetPackageVersionForAuthenticatedUser(
        path: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input.Path,
        headers: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetPackageVersionForAuthenticatedUser.Output {
        try await packagesGetPackageVersionForAuthenticatedUser(Operations.PackagesGetPackageVersionForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a package version for the authenticated user
    ///
    /// Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /user/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)`.
    public func packagesDeletePackageVersionForAuthenticatedUser(
        path: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input.Path,
        headers: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesDeletePackageVersionForAuthenticatedUser.Output {
        try await packagesDeletePackageVersionForAuthenticatedUser(Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Restore a package version for the authenticated user
    ///
    /// Restores a package version owned by the authenticated user.
    ///
    /// You can restore a deleted package version under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)`.
    public func packagesRestorePackageVersionForAuthenticatedUser(
        path: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input.Path,
        headers: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesRestorePackageVersionForAuthenticatedUser.Output {
        try await packagesRestorePackageVersionForAuthenticatedUser(Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get list of conflicting packages during Docker migration for user
    ///
    /// Lists all packages that are in a specific user's namespace, that the requesting user has access to, and that encountered a conflict during Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/docker/conflicts`.
    /// - Remark: Generated from `#/paths//users/{username}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-user)`.
    public func packagesListDockerMigrationConflictingPackagesForUser(
        path: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input.Path,
        headers: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesListDockerMigrationConflictingPackagesForUser.Output {
        try await packagesListDockerMigrationConflictingPackagesForUser(Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List packages for a user
    ///
    /// Lists all packages in a user's namespace for which the requesting user has access.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)`.
    public func packagesListPackagesForUser(
        path: Operations.PackagesListPackagesForUser.Input.Path,
        query: Operations.PackagesListPackagesForUser.Input.Query,
        headers: Operations.PackagesListPackagesForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesListPackagesForUser.Output {
        try await packagesListPackagesForUser(Operations.PackagesListPackagesForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a package for a user
    ///
    /// Gets a specific package metadata for a public package owned by a user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/get(packages/get-package-for-user)`.
    public func packagesGetPackageForUser(
        path: Operations.PackagesGetPackageForUser.Input.Path,
        headers: Operations.PackagesGetPackageForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetPackageForUser.Output {
        try await packagesGetPackageForUser(Operations.PackagesGetPackageForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a package for a user
    ///
    /// Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /users/{username}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)`.
    public func packagesDeletePackageForUser(
        path: Operations.PackagesDeletePackageForUser.Input.Path,
        headers: Operations.PackagesDeletePackageForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesDeletePackageForUser.Output {
        try await packagesDeletePackageForUser(Operations.PackagesDeletePackageForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Restore a package for a user
    ///
    /// Restores an entire package for a user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /users/{username}/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)`.
    public func packagesRestorePackageForUser(
        path: Operations.PackagesRestorePackageForUser.Input.Path,
        query: Operations.PackagesRestorePackageForUser.Input.Query = .init(),
        headers: Operations.PackagesRestorePackageForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesRestorePackageForUser.Output {
        try await packagesRestorePackageForUser(Operations.PackagesRestorePackageForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List package versions for a package owned by a user
    ///
    /// Lists package versions for a public package owned by a specified user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)`.
    public func packagesGetAllPackageVersionsForPackageOwnedByUser(
        path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input.Path,
        headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Output {
        try await packagesGetAllPackageVersionsForPackageOwnedByUser(Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a package version for a user
    ///
    /// Gets a specific package version for a public package owned by a specified user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-user)`.
    public func packagesGetPackageVersionForUser(
        path: Operations.PackagesGetPackageVersionForUser.Input.Path,
        headers: Operations.PackagesGetPackageVersionForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesGetPackageVersionForUser.Output {
        try await packagesGetPackageVersionForUser(Operations.PackagesGetPackageVersionForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete package version for a user
    ///
    /// Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)`.
    public func packagesDeletePackageVersionForUser(
        path: Operations.PackagesDeletePackageVersionForUser.Input.Path,
        headers: Operations.PackagesDeletePackageVersionForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesDeletePackageVersionForUser.Output {
        try await packagesDeletePackageVersionForUser(Operations.PackagesDeletePackageVersionForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Restore package version for a user
    ///
    /// Restores a specific package version for a user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)`.
    public func packagesRestorePackageVersionForUser(
        path: Operations.PackagesRestorePackageVersionForUser.Input.Path,
        headers: Operations.PackagesRestorePackageVersionForUser.Input.Headers = .init()
    ) async throws -> Operations.PackagesRestorePackageVersionForUser.Output {
        try await packagesRestorePackageVersionForUser(Operations.PackagesRestorePackageVersionForUser.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository`.
        public struct NullableMinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/permissions`.
            public var permissions: Components.Schemas.NullableMinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/license`.
            public var license: Components.Schemas.NullableMinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.NullableMinimalRepository.CustomPropertiesPayload?
            /// Creates a new `NullableMinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.NullableMinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.NullableMinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.NullableMinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// A software package
        ///
        /// - Remark: Generated from `#/components/schemas/package`.
        public struct Package: Codable, Hashable, Sendable {
            /// Unique identifier of the package.
            ///
            /// - Remark: Generated from `#/components/schemas/package/id`.
            public var id: Swift.Int
            /// The name of the package.
            ///
            /// - Remark: Generated from `#/components/schemas/package/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/package/package_type`.
            @frozen public enum PackageTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case npm = "npm"
                case maven = "maven"
                case rubygems = "rubygems"
                case docker = "docker"
                case nuget = "nuget"
                case container = "container"
            }
            /// - Remark: Generated from `#/components/schemas/package/package_type`.
            public var packageType: Components.Schemas.Package.PackageTypePayload
            /// - Remark: Generated from `#/components/schemas/package/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/package/html_url`.
            public var htmlUrl: Swift.String
            /// The number of versions of the package.
            ///
            /// - Remark: Generated from `#/components/schemas/package/version_count`.
            public var versionCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/package/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case _private = "private"
                case _public = "public"
            }
            /// - Remark: Generated from `#/components/schemas/package/visibility`.
            public var visibility: Components.Schemas.Package.VisibilityPayload
            /// - Remark: Generated from `#/components/schemas/package/owner`.
            public var owner: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/package/repository`.
            public var repository: Components.Schemas.NullableMinimalRepository?
            /// - Remark: Generated from `#/components/schemas/package/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/package/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `Package`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the package.
            ///   - name: The name of the package.
            ///   - packageType:
            ///   - url:
            ///   - htmlUrl:
            ///   - versionCount: The number of versions of the package.
            ///   - visibility:
            ///   - owner:
            ///   - repository:
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                id: Swift.Int,
                name: Swift.String,
                packageType: Components.Schemas.Package.PackageTypePayload,
                url: Swift.String,
                htmlUrl: Swift.String,
                versionCount: Swift.Int,
                visibility: Components.Schemas.Package.VisibilityPayload,
                owner: Components.Schemas.NullableSimpleUser? = nil,
                repository: Components.Schemas.NullableMinimalRepository? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.id = id
                self.name = name
                self.packageType = packageType
                self.url = url
                self.htmlUrl = htmlUrl
                self.versionCount = versionCount
                self.visibility = visibility
                self.owner = owner
                self.repository = repository
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case packageType = "package_type"
                case url
                case htmlUrl = "html_url"
                case versionCount = "version_count"
                case visibility
                case owner
                case repository
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// A version of a software package
        ///
        /// - Remark: Generated from `#/components/schemas/package-version`.
        public struct PackageVersion: Codable, Hashable, Sendable {
            /// Unique identifier of the package version.
            ///
            /// - Remark: Generated from `#/components/schemas/package-version/id`.
            public var id: Swift.Int
            /// The name of the package version.
            ///
            /// - Remark: Generated from `#/components/schemas/package-version/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/package-version/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/package-version/package_html_url`.
            public var packageHtmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/package-version/html_url`.
            public var htmlUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/package-version/license`.
            public var license: Swift.String?
            /// - Remark: Generated from `#/components/schemas/package-version/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/package-version/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/package-version/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/package-version/deleted_at`.
            public var deletedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/package-version/metadata`.
            public struct MetadataPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/package-version/metadata/package_type`.
                @frozen public enum PackageTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// - Remark: Generated from `#/components/schemas/package-version/metadata/package_type`.
                public var packageType: Components.Schemas.PackageVersion.MetadataPayload.PackageTypePayload
                /// - Remark: Generated from `#/components/schemas/package-version/metadata/container`.
                public struct ContainerPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/package-version/metadata/container/tags`.
                    public var tags: [Swift.String]
                    /// Creates a new `ContainerPayload`.
                    ///
                    /// - Parameters:
                    ///   - tags:
                    public init(tags: [Swift.String]) {
                        self.tags = tags
                    }
                    public enum CodingKeys: String, CodingKey {
                        case tags
                    }
                }
                /// - Remark: Generated from `#/components/schemas/package-version/metadata/container`.
                public var container: Components.Schemas.PackageVersion.MetadataPayload.ContainerPayload?
                /// - Remark: Generated from `#/components/schemas/package-version/metadata/docker`.
                public struct DockerPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/package-version/metadata/docker/tag`.
                    public var tag: [Swift.String]?
                    /// Creates a new `DockerPayload`.
                    ///
                    /// - Parameters:
                    ///   - tag:
                    public init(tag: [Swift.String]? = nil) {
                        self.tag = tag
                    }
                    public enum CodingKeys: String, CodingKey {
                        case tag
                    }
                }
                /// - Remark: Generated from `#/components/schemas/package-version/metadata/docker`.
                public var docker: Components.Schemas.PackageVersion.MetadataPayload.DockerPayload?
                /// Creates a new `MetadataPayload`.
                ///
                /// - Parameters:
                ///   - packageType:
                ///   - container:
                ///   - docker:
                public init(
                    packageType: Components.Schemas.PackageVersion.MetadataPayload.PackageTypePayload,
                    container: Components.Schemas.PackageVersion.MetadataPayload.ContainerPayload? = nil,
                    docker: Components.Schemas.PackageVersion.MetadataPayload.DockerPayload? = nil
                ) {
                    self.packageType = packageType
                    self.container = container
                    self.docker = docker
                }
                public enum CodingKeys: String, CodingKey {
                    case packageType = "package_type"
                    case container
                    case docker
                }
            }
            /// - Remark: Generated from `#/components/schemas/package-version/metadata`.
            public var metadata: Components.Schemas.PackageVersion.MetadataPayload?
            /// Creates a new `PackageVersion`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the package version.
            ///   - name: The name of the package version.
            ///   - url:
            ///   - packageHtmlUrl:
            ///   - htmlUrl:
            ///   - license:
            ///   - description:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - deletedAt:
            ///   - metadata:
            public init(
                id: Swift.Int,
                name: Swift.String,
                url: Swift.String,
                packageHtmlUrl: Swift.String,
                htmlUrl: Swift.String? = nil,
                license: Swift.String? = nil,
                description: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                deletedAt: Foundation.Date? = nil,
                metadata: Components.Schemas.PackageVersion.MetadataPayload? = nil
            ) {
                self.id = id
                self.name = name
                self.url = url
                self.packageHtmlUrl = packageHtmlUrl
                self.htmlUrl = htmlUrl
                self.license = license
                self.description = description
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.deletedAt = deletedAt
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case url
                case packageHtmlUrl = "package_html_url"
                case htmlUrl = "html_url"
                case license
                case description
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case deletedAt = "deleted_at"
                case metadata
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
        ///
        /// The `internal` visibility is only supported for GitHub Packages registries that allow for granular permissions. For other ecosystems `internal` is synonymous with `private`.
        /// For the list of GitHub Packages registries that support granular permissions, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
        ///
        /// - Remark: Generated from `#/components/parameters/package-visibility`.
        @frozen public enum PackageVisibility: String, Codable, Hashable, Sendable, CaseIterable {
            case _public = "public"
            case _private = "private"
            case _internal = "internal"
        }
        /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
        ///
        /// - Remark: Generated from `#/components/parameters/package-type`.
        @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
            case npm = "npm"
            case maven = "maven"
            case rubygems = "rubygems"
            case docker = "docker"
            case nuget = "nuget"
            case container = "container"
        }
        /// The name of the package.
        ///
        /// - Remark: Generated from `#/components/parameters/package-name`.
        public typealias PackageName = Swift.String
        /// Unique identifier of the package version.
        ///
        /// - Remark: Generated from `#/components/parameters/package-version-id`.
        public typealias PackageVersionId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct PackageEsListError: Sendable, Hashable {
            /// Creates a new `PackageEsListError`.
            public init() {}
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get list of conflicting packages during Docker migration for organization
    ///
    /// Lists all packages that are in a specific organization, are readable by the requesting user, and that encountered a conflict during a Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/docker/conflicts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-organization)`.
    public enum PackagesListDockerMigrationConflictingPackagesForOrganization {
        public static let id: Swift.String = "packages/list-docker-migration-conflicting-packages-for-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/docker/conflicts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/docker/conflicts/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/docker/conflicts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input.Path,
                headers: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/docker/conflicts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/docker/conflicts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Package])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Package] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesListDockerMigrationConflictingPackagesForOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-organization)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List packages for an organization
    ///
    /// Lists packages in an organization readable by the user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)`.
    public enum PackagesListPackagesForOrganization {
        public static let id: Swift.String = "packages/list-packages-for-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.PackagesListPackagesForOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/query/package_type`.
                @frozen public enum PackageTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/query/package_type`.
                public var packageType: Operations.PackagesListPackagesForOrganization.Input.Query.PackageTypePayload
                /// - Remark: Generated from `#/components/parameters/package-visibility`.
                @frozen public enum PackageVisibility: String, Codable, Hashable, Sendable, CaseIterable {
                    case _public = "public"
                    case _private = "private"
                    case _internal = "internal"
                }
                /// The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
                ///
                /// The `internal` visibility is only supported for GitHub Packages registries that allow for granular permissions. For other ecosystems `internal` is synonymous with `private`.
                /// For the list of GitHub Packages registries that support granular permissions, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/query/visibility`.
                public var visibility: Components.Parameters.PackageVisibility?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/query/page`.
                public var page: Swift.Int?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - visibility: The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    packageType: Operations.PackagesListPackagesForOrganization.Input.Query.PackageTypePayload,
                    visibility: Components.Parameters.PackageVisibility? = nil,
                    page: Swift.Int? = nil,
                    perPage: Swift.Int? = nil
                ) {
                    self.packageType = packageType
                    self.visibility = visibility
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.PackagesListPackagesForOrganization.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListPackagesForOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListPackagesForOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesListPackagesForOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesListPackagesForOrganization.Input.Path,
                query: Operations.PackagesListPackagesForOrganization.Input.Query,
                headers: Operations.PackagesListPackagesForOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/packages/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Package])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Package] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesListPackagesForOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesListPackagesForOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesListPackagesForOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesListPackagesForOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// The value of `per_page` multiplied by `page` cannot be greater than 10000.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.PackageEsListError)
            /// The value of `per_page` multiplied by `page` cannot be greater than 10000.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/get(packages/list-packages-for-organization)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.PackageEsListError {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a package for an organization
    ///
    /// Gets a specific package in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/get(packages/get-package-for-organization)`.
    public enum PackagesGetPackageForOrganization {
        public static let id: Swift.String = "packages/get-package-for-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                }
            }
            public var path: Operations.PackagesGetPackageForOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageForOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageForOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetPackageForOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetPackageForOrganization.Input.Path,
                headers: Operations.PackagesGetPackageForOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Package)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Package {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetPackageForOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetPackageForOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/get(packages/get-package-for-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetPackageForOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetPackageForOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a package for an organization
    ///
    /// Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)`.
    public enum PackagesDeletePackageForOrg {
        public static let id: Swift.String = "packages/delete-package-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/DELETE/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/DELETE/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                }
            }
            public var path: Operations.PackagesDeletePackageForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesDeletePackageForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesDeletePackageForOrg.Input.Path,
                headers: Operations.PackagesDeletePackageForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesDeletePackageForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesDeletePackageForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Restore a package for an organization
    ///
    /// Restores an entire package in an organization.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)`.
    public enum PackagesRestorePackageForOrg {
        public static let id: Swift.String = "packages/restore-package-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                }
            }
            public var path: Operations.PackagesRestorePackageForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/query`.
            public struct Query: Sendable, Hashable {
                /// package token
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/query/token`.
                public var token: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - token: package token
                public init(token: Swift.String? = nil) {
                    self.token = token
                }
            }
            public var query: Operations.PackagesRestorePackageForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/restore/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesRestorePackageForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesRestorePackageForOrg.Input.Path,
                query: Operations.PackagesRestorePackageForOrg.Input.Query = .init(),
                headers: Operations.PackagesRestorePackageForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesRestorePackageForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesRestorePackageForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List package versions for a package owned by an organization
    ///
    /// Lists package versions for a package owned by an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)`.
    public enum PackagesGetAllPackageVersionsForPackageOwnedByOrg {
        public static let id: Swift.String = "packages/get-all-package-versions-for-package-owned-by-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                }
            }
            public var path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case active = "active"
                    case deleted = "deleted"
                }
                /// The state of the package, either active or deleted.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/query/state`.
                public var state: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Query.StatePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - state: The state of the package, either active or deleted.
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    state: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Query.StatePayload? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                    self.state = state
                }
            }
            public var query: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Path,
                query: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Query = .init(),
                headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PackageVersion])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PackageVersion] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetAllPackageVersionsForPackageOwnedByOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a package version for an organization
    ///
    /// Gets a specific package version in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-organization)`.
    public enum PackagesGetPackageVersionForOrganization {
        public static let id: Swift.String = "packages/get-package-version-for-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesGetPackageVersionForOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageVersionForOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageVersionForOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetPackageVersionForOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetPackageVersionForOrganization.Input.Path,
                headers: Operations.PackagesGetPackageVersionForOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PackageVersion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PackageVersion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetPackageVersionForOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetPackageVersionForOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetPackageVersionForOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetPackageVersionForOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete package version for an organization
    ///
    /// Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)`.
    public enum PackagesDeletePackageVersionForOrg {
        public static let id: Swift.String = "packages/delete-package-version-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesDeletePackageVersionForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageVersionForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageVersionForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesDeletePackageVersionForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesDeletePackageVersionForOrg.Input.Path,
                headers: Operations.PackagesDeletePackageVersionForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesDeletePackageVersionForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesDeletePackageVersionForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Restore package version for an organization
    ///
    /// Restores a specific package version in an organization.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)`.
    public enum PackagesRestorePackageVersionForOrg {
        public static let id: Swift.String = "packages/restore-package-version-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - org: The organization name. The name is not case sensitive.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    org: Components.Parameters.Org,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.org = org
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesRestorePackageVersionForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageVersionForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageVersionForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesRestorePackageVersionForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesRestorePackageVersionForOrg.Input.Path,
                headers: Operations.PackagesRestorePackageVersionForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesRestorePackageVersionForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesRestorePackageVersionForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get list of conflicting packages during Docker migration for authenticated-user
    ///
    /// Lists all packages that are owned by the authenticated user within the user's namespace, and that encountered a conflict during a Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/docker/conflicts`.
    /// - Remark: Generated from `#/paths//user/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-authenticated-user)`.
    public enum PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser {
        public static let id: Swift.String = "packages/list-docker-migration-conflicting-packages-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/docker/conflicts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/docker/conflicts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/docker/conflicts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Package])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Package] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesListDockerMigrationConflictingPackagesForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List packages for the authenticated user's namespace
    ///
    /// Lists packages owned by the authenticated user within the user's namespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages`.
    /// - Remark: Generated from `#/paths//user/packages/get(packages/list-packages-for-authenticated-user)`.
    public enum PackagesListPackagesForAuthenticatedUser {
        public static let id: Swift.String = "packages/list-packages-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/packages/GET/query/package_type`.
                @frozen public enum PackageTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/GET/query/package_type`.
                public var packageType: Operations.PackagesListPackagesForAuthenticatedUser.Input.Query.PackageTypePayload
                /// - Remark: Generated from `#/components/parameters/package-visibility`.
                @frozen public enum PackageVisibility: String, Codable, Hashable, Sendable, CaseIterable {
                    case _public = "public"
                    case _private = "private"
                    case _internal = "internal"
                }
                /// The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
                ///
                /// The `internal` visibility is only supported for GitHub Packages registries that allow for granular permissions. For other ecosystems `internal` is synonymous with `private`.
                /// For the list of GitHub Packages registries that support granular permissions, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
                ///
                /// - Remark: Generated from `#/paths/user/packages/GET/query/visibility`.
                public var visibility: Components.Parameters.PackageVisibility?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/packages/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/packages/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - visibility: The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    packageType: Operations.PackagesListPackagesForAuthenticatedUser.Input.Query.PackageTypePayload,
                    visibility: Components.Parameters.PackageVisibility? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.packageType = packageType
                    self.visibility = visibility
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.PackagesListPackagesForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/packages/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListPackagesForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListPackagesForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesListPackagesForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.PackagesListPackagesForAuthenticatedUser.Input.Query,
                headers: Operations.PackagesListPackagesForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/packages/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/packages/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Package])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Package] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesListPackagesForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesListPackagesForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/get(packages/list-packages-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesListPackagesForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesListPackagesForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// The value of `per_page` multiplied by `page` cannot be greater than 10000.
            ///
            /// - Remark: Generated from `#/paths//user/packages/get(packages/list-packages-for-authenticated-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.PackageEsListError)
            /// The value of `per_page` multiplied by `page` cannot be greater than 10000.
            ///
            /// - Remark: Generated from `#/paths//user/packages/get(packages/list-packages-for-authenticated-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.PackageEsListError {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a package for the authenticated user
    ///
    /// Gets a specific package for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/get(packages/get-package-for-authenticated-user)`.
    public enum PackagesGetPackageForAuthenticatedUser {
        public static let id: Swift.String = "packages/get-package-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                }
            }
            public var path: Operations.PackagesGetPackageForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetPackageForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetPackageForAuthenticatedUser.Input.Path,
                headers: Operations.PackagesGetPackageForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Package)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Package {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetPackageForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetPackageForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/get(packages/get-package-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetPackageForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetPackageForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a package for the authenticated user
    ///
    /// Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /user/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)`.
    public enum PackagesDeletePackageForAuthenticatedUser {
        public static let id: Swift.String = "packages/delete-package-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/DELETE/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/DELETE/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                }
            }
            public var path: Operations.PackagesDeletePackageForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesDeletePackageForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesDeletePackageForAuthenticatedUser.Input.Path,
                headers: Operations.PackagesDeletePackageForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesDeletePackageForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesDeletePackageForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/delete(packages/delete-package-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Restore a package for the authenticated user
    ///
    /// Restores a package owned by the authenticated user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /user/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)`.
    public enum PackagesRestorePackageForAuthenticatedUser {
        public static let id: Swift.String = "packages/restore-package-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/restore/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/restore/POST/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/restore/POST/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                }
            }
            public var path: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/restore/POST/query`.
            public struct Query: Sendable, Hashable {
                /// package token
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/restore/POST/query/token`.
                public var token: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - token: package token
                public init(token: Swift.String? = nil) {
                    self.token = token
                }
            }
            public var query: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/restore/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Path,
                query: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.PackagesRestorePackageForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesRestorePackageForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesRestorePackageForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List package versions for a package owned by the authenticated user
    ///
    /// Lists package versions for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)`.
    public enum PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser {
        public static let id: Swift.String = "packages/get-all-package-versions-for-package-owned-by-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                }
            }
            public var path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case active = "active"
                    case deleted = "deleted"
                }
                /// The state of the package, either active or deleted.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/query/state`.
                public var state: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Query.StatePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - state: The state of the package, either active or deleted.
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    state: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Query.StatePayload? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                    self.state = state
                }
            }
            public var query: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Path,
                query: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Query = .init(),
                headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PackageVersion])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PackageVersion] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a package version for the authenticated user
    ///
    /// Gets a specific package version for a package owned by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /user/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-authenticated-user)`.
    public enum PackagesGetPackageVersionForAuthenticatedUser {
        public static let id: Swift.String = "packages/get-package-version-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageVersionForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageVersionForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input.Path,
                headers: Operations.PackagesGetPackageVersionForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PackageVersion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PackageVersion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetPackageVersionForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetPackageVersionForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetPackageVersionForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetPackageVersionForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a package version for the authenticated user
    ///
    /// Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// The authenticated user must have admin permissions in the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /user/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)`.
    public enum PackagesDeletePackageVersionForAuthenticatedUser {
        public static let id: Swift.String = "packages/delete-package-version-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageVersionForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageVersionForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input.Path,
                headers: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesDeletePackageVersionForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesDeletePackageVersionForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Restore a package version for the authenticated user
    ///
    /// Restores a package version owned by the authenticated user.
    ///
    /// You can restore a deleted package version under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)`.
    public enum PackagesRestorePackageVersionForAuthenticatedUser {
        public static let id: Swift.String = "packages/restore-package-version-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageVersionForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageVersionForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input.Path,
                headers: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesRestorePackageVersionForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesRestorePackageVersionForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get list of conflicting packages during Docker migration for user
    ///
    /// Lists all packages that are in a specific user's namespace, that the requesting user has access to, and that encountered a conflict during Docker migration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/docker/conflicts`.
    /// - Remark: Generated from `#/paths//users/{username}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-user)`.
    public enum PackagesListDockerMigrationConflictingPackagesForUser {
        public static let id: Swift.String = "packages/list-docker-migration-conflicting-packages-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/docker/conflicts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/docker/conflicts/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/docker/conflicts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListDockerMigrationConflictingPackagesForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListDockerMigrationConflictingPackagesForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input.Path,
                headers: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/docker/conflicts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/docker/conflicts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Package])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Package] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesListDockerMigrationConflictingPackagesForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesListDockerMigrationConflictingPackagesForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/docker/conflicts/get(packages/list-docker-migration-conflicting-packages-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List packages for a user
    ///
    /// Lists all packages in a user's namespace for which the requesting user has access.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)`.
    public enum PackagesListPackagesForUser {
        public static let id: Swift.String = "packages/list-packages-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.PackagesListPackagesForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/query/package_type`.
                @frozen public enum PackageTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/query/package_type`.
                public var packageType: Operations.PackagesListPackagesForUser.Input.Query.PackageTypePayload
                /// - Remark: Generated from `#/components/parameters/package-visibility`.
                @frozen public enum PackageVisibility: String, Codable, Hashable, Sendable, CaseIterable {
                    case _public = "public"
                    case _private = "private"
                    case _internal = "internal"
                }
                /// The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
                ///
                /// The `internal` visibility is only supported for GitHub Packages registries that allow for granular permissions. For other ecosystems `internal` is synonymous with `private`.
                /// For the list of GitHub Packages registries that support granular permissions, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/query/visibility`.
                public var visibility: Components.Parameters.PackageVisibility?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - visibility: The selected visibility of the packages.  This parameter is optional and only filters an existing result set.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    packageType: Operations.PackagesListPackagesForUser.Input.Query.PackageTypePayload,
                    visibility: Components.Parameters.PackageVisibility? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.packageType = packageType
                    self.visibility = visibility
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.PackagesListPackagesForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/packages/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListPackagesForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesListPackagesForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesListPackagesForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesListPackagesForUser.Input.Path,
                query: Operations.PackagesListPackagesForUser.Input.Query,
                headers: Operations.PackagesListPackagesForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/packages/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/packages/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Package])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Package] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesListPackagesForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesListPackagesForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesListPackagesForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesListPackagesForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// The value of `per_page` multiplied by `page` cannot be greater than 10000.
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.PackageEsListError)
            /// The value of `per_page` multiplied by `page` cannot be greater than 10000.
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/get(packages/list-packages-for-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.PackageEsListError {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a package for a user
    ///
    /// Gets a specific package metadata for a public package owned by a user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/get(packages/get-package-for-user)`.
    public enum PackagesGetPackageForUser {
        public static let id: Swift.String = "packages/get-package-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - username: The handle for the GitHub user account.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    username: Components.Parameters.Username
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.username = username
                }
            }
            public var path: Operations.PackagesGetPackageForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetPackageForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetPackageForUser.Input.Path,
                headers: Operations.PackagesGetPackageForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Package)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Package {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetPackageForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetPackageForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/get(packages/get-package-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetPackageForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetPackageForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a package for a user
    ///
    /// Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /users/{username}/packages/{package_type}/{package_name}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)`.
    public enum PackagesDeletePackageForUser {
        public static let id: Swift.String = "packages/delete-package-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/DELETE/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/DELETE/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - username: The handle for the GitHub user account.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    username: Components.Parameters.Username
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.username = username
                }
            }
            public var path: Operations.PackagesDeletePackageForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesDeletePackageForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesDeletePackageForUser.Input.Path,
                headers: Operations.PackagesDeletePackageForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesDeletePackageForUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesDeletePackageForUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/delete(packages/delete-package-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Restore a package for a user
    ///
    /// Restores an entire package for a user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /users/{username}/packages/{package_type}/{package_name}/restore`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)`.
    public enum PackagesRestorePackageForUser {
        public static let id: Swift.String = "packages/restore-package-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - username: The handle for the GitHub user account.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    username: Components.Parameters.Username
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.username = username
                }
            }
            public var path: Operations.PackagesRestorePackageForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/query`.
            public struct Query: Sendable, Hashable {
                /// package token
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/query/token`.
                public var token: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - token: package token
                public init(token: Swift.String? = nil) {
                    self.token = token
                }
            }
            public var query: Operations.PackagesRestorePackageForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/restore/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesRestorePackageForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PackagesRestorePackageForUser.Input.Path,
                query: Operations.PackagesRestorePackageForUser.Input.Query = .init(),
                headers: Operations.PackagesRestorePackageForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesRestorePackageForUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesRestorePackageForUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/restore/post(packages/restore-package-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List package versions for a package owned by a user
    ///
    /// Lists package versions for a public package owned by a specified user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}/versions`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)`.
    public enum PackagesGetAllPackageVersionsForPackageOwnedByUser {
        public static let id: Swift.String = "packages/get-all-package-versions-for-package-owned-by-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - username: The handle for the GitHub user account.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    username: Components.Parameters.Username
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.username = username
                }
            }
            public var path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input.Path,
                headers: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PackageVersion])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PackageVersion] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetAllPackageVersionsForPackageOwnedByUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/get(packages/get-all-package-versions-for-package-owned-by-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a package version for a user
    ///
    /// Gets a specific package version for a public package owned by a specified user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `GET /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-user)`.
    public enum PackagesGetPackageVersionForUser {
        public static let id: Swift.String = "packages/get-package-version-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - packageVersionId: Unique identifier of the package version.
                ///   - username: The handle for the GitHub user account.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    packageVersionId: Components.Parameters.PackageVersionId,
                    username: Components.Parameters.Username
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.packageVersionId = packageVersionId
                    self.username = username
                }
            }
            public var path: Operations.PackagesGetPackageVersionForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageVersionForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesGetPackageVersionForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesGetPackageVersionForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesGetPackageVersionForUser.Input.Path,
                headers: Operations.PackagesGetPackageVersionForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PackageVersion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PackageVersion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PackagesGetPackageVersionForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PackagesGetPackageVersionForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/get(packages/get-package-version-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PackagesGetPackageVersionForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PackagesGetPackageVersionForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete package version for a user
    ///
    /// Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `DELETE /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)`.
    public enum PackagesDeletePackageVersionForUser {
        public static let id: Swift.String = "packages/delete-package-version-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - username: The handle for the GitHub user account.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    username: Components.Parameters.Username,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.username = username
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesDeletePackageVersionForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageVersionForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesDeletePackageVersionForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesDeletePackageVersionForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesDeletePackageVersionForUser.Input.Path,
                headers: Operations.PackagesDeletePackageVersionForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesDeletePackageVersionForUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesDeletePackageVersionForUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/delete(packages/delete-package-version-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Restore package version for a user
    ///
    /// Restores a specific package version for a user.
    ///
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    ///
    /// If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
    ///
    /// - Remark: HTTP `POST /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore`.
    /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)`.
    public enum PackagesRestorePackageVersionForUser {
        public static let id: Swift.String = "packages/restore-package-version-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/package-type`.
                @frozen public enum PackageType: String, Codable, Hashable, Sendable, CaseIterable {
                    case npm = "npm"
                    case maven = "maven"
                    case rubygems = "rubygems"
                    case docker = "docker"
                    case nuget = "nuget"
                    case container = "container"
                }
                /// The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_type`.
                public var packageType: Components.Parameters.PackageType
                /// The name of the package.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_name`.
                public var packageName: Components.Parameters.PackageName
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/username`.
                public var username: Components.Parameters.Username
                /// Unique identifier of the package version.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/path/package_version_id`.
                public var packageVersionId: Components.Parameters.PackageVersionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - packageType: The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
                ///   - packageName: The name of the package.
                ///   - username: The handle for the GitHub user account.
                ///   - packageVersionId: Unique identifier of the package version.
                public init(
                    packageType: Components.Parameters.PackageType,
                    packageName: Components.Parameters.PackageName,
                    username: Components.Parameters.Username,
                    packageVersionId: Components.Parameters.PackageVersionId
                ) {
                    self.packageType = packageType
                    self.packageName = packageName
                    self.username = username
                    self.packageVersionId = packageVersionId
                }
            }
            public var path: Operations.PackagesRestorePackageVersionForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageVersionForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PackagesRestorePackageVersionForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PackagesRestorePackageVersionForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PackagesRestorePackageVersionForUser.Input.Path,
                headers: Operations.PackagesRestorePackageVersionForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PackagesRestorePackageVersionForUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PackagesRestorePackageVersionForUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore/post(packages/restore-package-version-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
