// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List organizations
    ///
    /// Lists all organizations, in the order that they were created.
    ///
    /// > [!NOTE]
    /// > Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.
    ///
    /// - Remark: HTTP `GET /organizations`.
    /// - Remark: Generated from `#/paths//organizations/get(orgs/list)`.
    func orgsList(_ input: Operations.OrgsList.Input) async throws -> Operations.OrgsList.Output
    /// Get an organization
    ///
    /// Gets information about an organization.
    ///
    /// When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, outside collaborators, guest collaborators, repository collaborators, or everyone with access to any repository within the organization to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
    ///
    /// To see the full details about an organization, the authenticated user must be an organization owner.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.
    ///
    /// To see information about an organization's GitHub plan, GitHub Apps need the `Organization plan` permission.
    ///
    /// - Remark: HTTP `GET /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/get(orgs/get)`.
    func orgsGet(_ input: Operations.OrgsGet.Input) async throws -> Operations.OrgsGet.Output
    /// Update an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Code security product enablement for new repositories through the organization API is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization) to set defaults instead. For more information on setting a default security configuration, see the [changelog](https://github.blog/changelog/2024-07-09-sunsetting-security-settings-defaults-parameters-in-the-organizations-rest-api/).
    ///
    /// Updates the organization's profile and member privileges.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)`.
    func orgsUpdate(_ input: Operations.OrgsUpdate.Input) async throws -> Operations.OrgsUpdate.Output
    /// Delete an organization
    ///
    /// Deletes an organization and all its repositories.
    ///
    /// The organization login will be unavailable for 90 days after deletion.
    ///
    /// Please review the Terms of Service regarding account deletion before using this endpoint:
    ///
    /// https://docs.github.com/site-policy/github-terms/github-terms-of-service
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)`.
    func orgsDelete(_ input: Operations.OrgsDelete.Input) async throws -> Operations.OrgsDelete.Output
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/bulk-list/post(orgs/list-attestations-bulk)`.
    func orgsListAttestationsBulk(_ input: Operations.OrgsListAttestationsBulk.Input) async throws -> Operations.OrgsListAttestationsBulk.Output
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)`.
    func orgsDeleteAttestationsBulk(_ input: Operations.OrgsDeleteAttestationsBulk.Input) async throws -> Operations.OrgsDeleteAttestationsBulk.Output
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)`.
    func orgsDeleteAttestationsBySubjectDigest(_ input: Operations.OrgsDeleteAttestationsBySubjectDigest.Input) async throws -> Operations.OrgsDeleteAttestationsBySubjectDigest.Output
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by an org.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)`.
    func orgsDeleteAttestationsById(_ input: Operations.OrgsDeleteAttestationsById.Input) async throws -> Operations.OrgsDeleteAttestationsById.Output
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{subject_digest}/get(orgs/list-attestations)`.
    func orgsListAttestations(_ input: Operations.OrgsListAttestations.Input) async throws -> Operations.OrgsListAttestations.Output
    /// List users blocked by an organization
    ///
    /// List the users blocked by an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/get(orgs/list-blocked-users)`.
    func orgsListBlockedUsers(_ input: Operations.OrgsListBlockedUsers.Input) async throws -> Operations.OrgsListBlockedUsers.Output
    /// Check if a user is blocked by an organization
    ///
    /// Returns a 204 if the given user is blocked by the given organization. Returns a 404 if the organization is not blocking the user, or if the user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)`.
    func orgsCheckBlockedUser(_ input: Operations.OrgsCheckBlockedUser.Input) async throws -> Operations.OrgsCheckBlockedUser.Output
    /// Block a user from an organization
    ///
    /// Blocks the given user on behalf of the specified organization and returns a 204. If the organization cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)`.
    func orgsBlockUser(_ input: Operations.OrgsBlockUser.Input) async throws -> Operations.OrgsBlockUser.Output
    /// Unblock a user from an organization
    ///
    /// Unblocks the given user on behalf of the specified organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/delete(orgs/unblock-user)`.
    func orgsUnblockUser(_ input: Operations.OrgsUnblockUser.Input) async throws -> Operations.OrgsUnblockUser.Output
    /// List failed organization invitations
    ///
    /// The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/failed_invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/failed_invitations/get(orgs/list-failed-invitations)`.
    func orgsListFailedInvitations(_ input: Operations.OrgsListFailedInvitations.Input) async throws -> Operations.OrgsListFailedInvitations.Output
    /// List organization webhooks
    ///
    /// List webhooks for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/get(orgs/list-webhooks)`.
    func orgsListWebhooks(_ input: Operations.OrgsListWebhooks.Input) async throws -> Operations.OrgsListWebhooks.Output
    /// Create an organization webhook
    ///
    /// Create a hook that posts payloads in JSON format.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
    /// edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)`.
    func orgsCreateWebhook(_ input: Operations.OrgsCreateWebhook.Input) async throws -> Operations.OrgsCreateWebhook.Output
    /// Get an organization webhook
    ///
    /// Returns a webhook configured in an organization. To get only the webhook
    /// `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/get(orgs/get-webhook)`.
    func orgsGetWebhook(_ input: Operations.OrgsGetWebhook.Input) async throws -> Operations.OrgsGetWebhook.Output
    /// Update an organization webhook
    ///
    /// Updates a webhook configured in an organization. When you update a webhook,
    /// the `secret` will be overwritten. If you previously had a `secret` set, you must
    /// provide the same `secret` or set a new `secret` or the secret will be removed. If
    /// you are only updating individual webhook `config` properties, use "[Update a webhook
    /// configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)`.
    func orgsUpdateWebhook(_ input: Operations.OrgsUpdateWebhook.Input) async throws -> Operations.OrgsUpdateWebhook.Output
    /// Delete an organization webhook
    ///
    /// Delete a webhook for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)`.
    func orgsDeleteWebhook(_ input: Operations.OrgsDeleteWebhook.Input) async throws -> Operations.OrgsDeleteWebhook.Output
    /// Get a webhook configuration for an organization
    ///
    /// Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/get(orgs/get-webhook-config-for-org)`.
    func orgsGetWebhookConfigForOrg(_ input: Operations.OrgsGetWebhookConfigForOrg.Input) async throws -> Operations.OrgsGetWebhookConfigForOrg.Output
    /// Update a webhook configuration for an organization
    ///
    /// Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/patch(orgs/update-webhook-config-for-org)`.
    func orgsUpdateWebhookConfigForOrg(_ input: Operations.OrgsUpdateWebhookConfigForOrg.Input) async throws -> Operations.OrgsUpdateWebhookConfigForOrg.Output
    /// List deliveries for an organization webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)`.
    func orgsListWebhookDeliveries(_ input: Operations.OrgsListWebhookDeliveries.Input) async throws -> Operations.OrgsListWebhookDeliveries.Output
    /// Get a webhook delivery for an organization webhook
    ///
    /// Returns a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)`.
    func orgsGetWebhookDelivery(_ input: Operations.OrgsGetWebhookDelivery.Input) async throws -> Operations.OrgsGetWebhookDelivery.Output
    /// Redeliver a delivery for an organization webhook
    ///
    /// Redeliver a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)`.
    func orgsRedeliverWebhookDelivery(_ input: Operations.OrgsRedeliverWebhookDelivery.Input) async throws -> Operations.OrgsRedeliverWebhookDelivery.Output
    /// Ping an organization webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event)
    /// to be sent to the hook.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/pings`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)`.
    func orgsPingWebhook(_ input: Operations.OrgsPingWebhook.Input) async throws -> Operations.OrgsPingWebhook.Output
    /// Get route stats by actor
    ///
    /// Get API request count statistics for an actor broken down by route within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/get(api-insights/get-route-stats-by-actor)`.
    func apiInsightsGetRouteStatsByActor(_ input: Operations.ApiInsightsGetRouteStatsByActor.Input) async throws -> Operations.ApiInsightsGetRouteStatsByActor.Output
    /// Get subject stats
    ///
    /// Get API request statistics for all subjects within an organization within a specified time frame. Subjects can be users or GitHub Apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/subject-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/subject-stats/get(api-insights/get-subject-stats)`.
    func apiInsightsGetSubjectStats(_ input: Operations.ApiInsightsGetSubjectStats.Input) async throws -> Operations.ApiInsightsGetSubjectStats.Output
    /// Get summary stats
    ///
    /// Get overall statistics of API requests made within an organization by all users and apps within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/get(api-insights/get-summary-stats)`.
    func apiInsightsGetSummaryStats(_ input: Operations.ApiInsightsGetSummaryStats.Input) async throws -> Operations.ApiInsightsGetSummaryStats.Output
    /// Get summary stats by user
    ///
    /// Get overall statistics of API requests within the organization for a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/users/{user_id}/get(api-insights/get-summary-stats-by-user)`.
    func apiInsightsGetSummaryStatsByUser(_ input: Operations.ApiInsightsGetSummaryStatsByUser.Input) async throws -> Operations.ApiInsightsGetSummaryStatsByUser.Output
    /// Get summary stats by actor
    ///
    /// Get overall statistics of API requests within the organization made by a specific actor. Actors can be GitHub App installations, OAuth apps or other tokens on behalf of a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/get(api-insights/get-summary-stats-by-actor)`.
    func apiInsightsGetSummaryStatsByActor(_ input: Operations.ApiInsightsGetSummaryStatsByActor.Input) async throws -> Operations.ApiInsightsGetSummaryStatsByActor.Output
    /// Get time stats
    ///
    /// Get the number of API requests and rate-limited requests made within an organization over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/get(api-insights/get-time-stats)`.
    func apiInsightsGetTimeStats(_ input: Operations.ApiInsightsGetTimeStats.Input) async throws -> Operations.ApiInsightsGetTimeStats.Output
    /// Get time stats by user
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific user over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/users/{user_id}/get(api-insights/get-time-stats-by-user)`.
    func apiInsightsGetTimeStatsByUser(_ input: Operations.ApiInsightsGetTimeStatsByUser.Input) async throws -> Operations.ApiInsightsGetTimeStatsByUser.Output
    /// Get time stats by actor
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific actor within a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/get(api-insights/get-time-stats-by-actor)`.
    func apiInsightsGetTimeStatsByActor(_ input: Operations.ApiInsightsGetTimeStatsByActor.Input) async throws -> Operations.ApiInsightsGetTimeStatsByActor.Output
    /// Get user stats
    ///
    /// Get API usage statistics within an organization for a user broken down by the type of access.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/user-stats/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/user-stats/{user_id}/get(api-insights/get-user-stats)`.
    func apiInsightsGetUserStats(_ input: Operations.ApiInsightsGetUserStats.Input) async throws -> Operations.ApiInsightsGetUserStats.Output
    /// List app installations for an organization
    ///
    /// Lists all GitHub Apps in an organization. The installation count includes
    /// all GitHub Apps installed on repositories in the organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installations/get(orgs/list-app-installations)`.
    func orgsListAppInstallations(_ input: Operations.OrgsListAppInstallations.Input) async throws -> Operations.OrgsListAppInstallations.Output
    /// List pending organization invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization
    /// Invitation role and will be one of the following values: `direct_member`, `admin`,
    /// `billing_manager`, or `hiring_manager`. If the invitee is not a GitHub
    /// member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/get(orgs/list-pending-invitations)`.
    func orgsListPendingInvitations(_ input: Operations.OrgsListPendingInvitations.Input) async throws -> Operations.OrgsListPendingInvitations.Output
    /// Create an organization invitation
    ///
    /// Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)`.
    func orgsCreateInvitation(_ input: Operations.OrgsCreateInvitation.Input) async throws -> Operations.OrgsCreateInvitation.Output
    /// Cancel an organization invitation
    ///
    /// Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)`.
    func orgsCancelInvitation(_ input: Operations.OrgsCancelInvitation.Input) async throws -> Operations.OrgsCancelInvitation.Output
    /// List organization invitation teams
    ///
    /// List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations/{invitation_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/teams/get(orgs/list-invitation-teams)`.
    func orgsListInvitationTeams(_ input: Operations.OrgsListInvitationTeams.Input) async throws -> Operations.OrgsListInvitationTeams.Output
    /// List issue types for an organization
    ///
    /// Lists all issue types for an organization. OAuth app tokens and personal access tokens (classic) need the read:org scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/get(orgs/list-issue-types)`.
    func orgsListIssueTypes(_ input: Operations.OrgsListIssueTypes.Input) async throws -> Operations.OrgsListIssueTypes.Output
    /// Create issue type for an organization
    ///
    /// Create a new issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)`.
    func orgsCreateIssueType(_ input: Operations.OrgsCreateIssueType.Input) async throws -> Operations.OrgsCreateIssueType.Output
    /// Update issue type for an organization
    ///
    /// Updates an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)`.
    func orgsUpdateIssueType(_ input: Operations.OrgsUpdateIssueType.Input) async throws -> Operations.OrgsUpdateIssueType.Output
    /// Delete issue type for an organization
    ///
    /// Deletes an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)`.
    func orgsDeleteIssueType(_ input: Operations.OrgsDeleteIssueType.Input) async throws -> Operations.OrgsDeleteIssueType.Output
    /// List organization members
    ///
    /// List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/get(orgs/list-members)`.
    func orgsListMembers(_ input: Operations.OrgsListMembers.Input) async throws -> Operations.OrgsListMembers.Output
    /// Check organization membership for a user
    ///
    /// Check if a user is, publicly or privately, a member of the organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/get(orgs/check-membership-for-user)`.
    func orgsCheckMembershipForUser(_ input: Operations.OrgsCheckMembershipForUser.Input) async throws -> Operations.OrgsCheckMembershipForUser.Output
    /// Remove an organization member
    ///
    /// Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
    ///
    /// > [!NOTE]
    /// > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/delete(orgs/remove-member)`.
    func orgsRemoveMember(_ input: Operations.OrgsRemoveMember.Input) async throws -> Operations.OrgsRemoveMember.Output
    /// Get organization membership for a user
    ///
    /// In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/get(orgs/get-membership-for-user)`.
    func orgsGetMembershipForUser(_ input: Operations.OrgsGetMembershipForUser.Input) async throws -> Operations.OrgsGetMembershipForUser.Output
    /// Set organization membership for a user
    ///
    /// Only authenticated organization owners can add a member to the organization or update the member's role.
    ///
    /// *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
    ///     
    /// *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
    ///
    /// **Rate limits**
    ///
    /// To prevent abuse, organization owners are limited to creating 50 organization invitations for an organization within a 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/put(orgs/set-membership-for-user)`.
    func orgsSetMembershipForUser(_ input: Operations.OrgsSetMembershipForUser.Input) async throws -> Operations.OrgsSetMembershipForUser.Output
    /// Remove organization membership for a user
    ///
    /// In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
    ///
    /// If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
    ///
    /// > [!NOTE]
    /// > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/delete(orgs/remove-membership-for-user)`.
    func orgsRemoveMembershipForUser(_ input: Operations.OrgsRemoveMembershipForUser.Input) async throws -> Operations.OrgsRemoveMembershipForUser.Output
    /// Get all organization roles for an organization
    ///
    /// Lists the organization roles available in this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/get(orgs/list-org-roles)`.
    func orgsListOrgRoles(_ input: Operations.OrgsListOrgRoles.Input) async throws -> Operations.OrgsListOrgRoles.Output
    /// Remove all organization roles for a team
    ///
    /// Removes all assigned organization roles from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/delete(orgs/revoke-all-org-roles-team)`.
    func orgsRevokeAllOrgRolesTeam(_ input: Operations.OrgsRevokeAllOrgRolesTeam.Input) async throws -> Operations.OrgsRevokeAllOrgRolesTeam.Output
    /// Assign an organization role to a team
    ///
    /// Assigns an organization role to a team in an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/{role_id}/put(orgs/assign-team-to-org-role)`.
    func orgsAssignTeamToOrgRole(_ input: Operations.OrgsAssignTeamToOrgRole.Input) async throws -> Operations.OrgsAssignTeamToOrgRole.Output
    /// Remove an organization role from a team
    ///
    /// Removes an organization role from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/{role_id}/delete(orgs/revoke-org-role-team)`.
    func orgsRevokeOrgRoleTeam(_ input: Operations.OrgsRevokeOrgRoleTeam.Input) async throws -> Operations.OrgsRevokeOrgRoleTeam.Output
    /// Remove all organization roles for a user
    ///
    /// Revokes all assigned organization roles from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/users/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/delete(orgs/revoke-all-org-roles-user)`.
    func orgsRevokeAllOrgRolesUser(_ input: Operations.OrgsRevokeAllOrgRolesUser.Input) async throws -> Operations.OrgsRevokeAllOrgRolesUser.Output
    /// Assign an organization role to a user
    ///
    /// Assigns an organization role to a member of an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/organization-roles/users/{username}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/{role_id}/put(orgs/assign-user-to-org-role)`.
    func orgsAssignUserToOrgRole(_ input: Operations.OrgsAssignUserToOrgRole.Input) async throws -> Operations.OrgsAssignUserToOrgRole.Output
    /// Remove an organization role from a user
    ///
    /// Remove an organization role from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/users/{username}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/{role_id}/delete(orgs/revoke-org-role-user)`.
    func orgsRevokeOrgRoleUser(_ input: Operations.OrgsRevokeOrgRoleUser.Input) async throws -> Operations.OrgsRevokeOrgRoleUser.Output
    /// Get an organization role
    ///
    /// Gets an organization role that is available to this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/get(orgs/get-org-role)`.
    func orgsGetOrgRole(_ input: Operations.OrgsGetOrgRole.Input) async throws -> Operations.OrgsGetOrgRole.Output
    /// List teams that are assigned to an organization role
    ///
    /// Lists the teams that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, you must be an administrator for the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/teams/get(orgs/list-org-role-teams)`.
    func orgsListOrgRoleTeams(_ input: Operations.OrgsListOrgRoleTeams.Input) async throws -> Operations.OrgsListOrgRoleTeams.Output
    /// List users that are assigned to an organization role
    ///
    /// Lists organization members that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, you must be an administrator for the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}/users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/users/get(orgs/list-org-role-users)`.
    func orgsListOrgRoleUsers(_ input: Operations.OrgsListOrgRoleUsers.Input) async throws -> Operations.OrgsListOrgRoleUsers.Output
    /// List outside collaborators for an organization
    ///
    /// List all users who are outside collaborators of an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/outside_collaborators`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/get(orgs/list-outside-collaborators)`.
    func orgsListOutsideCollaborators(_ input: Operations.OrgsListOutsideCollaborators.Input) async throws -> Operations.OrgsListOutsideCollaborators.Output
    /// Convert an organization member to outside collaborator
    ///
    /// When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/outside_collaborators/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/{username}/put(orgs/convert-member-to-outside-collaborator)`.
    func orgsConvertMemberToOutsideCollaborator(_ input: Operations.OrgsConvertMemberToOutsideCollaborator.Input) async throws -> Operations.OrgsConvertMemberToOutsideCollaborator.Output
    /// Remove outside collaborator from an organization
    ///
    /// Removing a user from this list will remove them from all the organization's repositories.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/outside_collaborators/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/{username}/delete(orgs/remove-outside-collaborator)`.
    func orgsRemoveOutsideCollaborator(_ input: Operations.OrgsRemoveOutsideCollaborator.Input) async throws -> Operations.OrgsRemoveOutsideCollaborator.Output
    /// List requests to access organization resources with fine-grained personal access tokens
    ///
    /// Lists requests from organization members to access organization resources with a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-token-requests`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/get(orgs/list-pat-grant-requests)`.
    func orgsListPatGrantRequests(_ input: Operations.OrgsListPatGrantRequests.Input) async throws -> Operations.OrgsListPatGrantRequests.Output
    /// Review requests to access organization resources with fine-grained personal access tokens
    ///
    /// Approves or denies multiple pending requests to access organization resources via a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-token-requests`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/post(orgs/review-pat-grant-requests-in-bulk)`.
    func orgsReviewPatGrantRequestsInBulk(_ input: Operations.OrgsReviewPatGrantRequestsInBulk.Input) async throws -> Operations.OrgsReviewPatGrantRequestsInBulk.Output
    /// Review a request to access organization resources with a fine-grained personal access token
    ///
    /// Approves or denies a pending request to access organization resources via a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-token-requests/{pat_request_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/{pat_request_id}/post(orgs/review-pat-grant-request)`.
    func orgsReviewPatGrantRequest(_ input: Operations.OrgsReviewPatGrantRequest.Input) async throws -> Operations.OrgsReviewPatGrantRequest.Output
    /// List repositories requested to be accessed by a fine-grained personal access token
    ///
    /// Lists the repositories a fine-grained personal access token request is requesting access to.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories/get(orgs/list-pat-grant-request-repositories)`.
    func orgsListPatGrantRequestRepositories(_ input: Operations.OrgsListPatGrantRequestRepositories.Input) async throws -> Operations.OrgsListPatGrantRequestRepositories.Output
    /// List fine-grained personal access tokens with access to organization resources
    ///
    /// Lists approved fine-grained personal access tokens owned by organization members that can access organization resources.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-tokens`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/get(orgs/list-pat-grants)`.
    func orgsListPatGrants(_ input: Operations.OrgsListPatGrants.Input) async throws -> Operations.OrgsListPatGrants.Output
    /// Update the access to organization resources via fine-grained personal access tokens
    ///
    /// Updates the access organization members have to organization resources via fine-grained personal access tokens. Limited to revoking a token's existing access.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-tokens`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/post(orgs/update-pat-accesses)`.
    func orgsUpdatePatAccesses(_ input: Operations.OrgsUpdatePatAccesses.Input) async throws -> Operations.OrgsUpdatePatAccesses.Output
    /// Update the access a fine-grained personal access token has to organization resources
    ///
    /// Updates the access an organization member has to organization resources via a fine-grained personal access token. Limited to revoking the token's existing access. Limited to revoking a token's existing access.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-tokens/{pat_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/{pat_id}/post(orgs/update-pat-access)`.
    func orgsUpdatePatAccess(_ input: Operations.OrgsUpdatePatAccess.Input) async throws -> Operations.OrgsUpdatePatAccess.Output
    /// List repositories a fine-grained personal access token has access to
    ///
    /// Lists the repositories a fine-grained personal access token has access to.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-tokens/{pat_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/{pat_id}/repositories/get(orgs/list-pat-grant-repositories)`.
    func orgsListPatGrantRepositories(_ input: Operations.OrgsListPatGrantRepositories.Input) async throws -> Operations.OrgsListPatGrantRepositories.Output
    /// Get all custom properties for an organization
    ///
    /// Gets all custom properties defined for an organization.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/schema`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/get(orgs/get-all-custom-properties)`.
    func orgsGetAllCustomProperties(_ input: Operations.OrgsGetAllCustomProperties.Input) async throws -> Operations.OrgsGetAllCustomProperties.Output
    /// Create or update custom properties for an organization
    ///
    /// Creates new or updates existing custom properties defined for an organization in a batch.
    ///
    /// If the property already exists, the existing property will be replaced with the new values.
    /// Missing optional values will fall back to default values, previous values will be overwritten.
    /// E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/properties/schema`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/patch(orgs/create-or-update-custom-properties)`.
    func orgsCreateOrUpdateCustomProperties(_ input: Operations.OrgsCreateOrUpdateCustomProperties.Input) async throws -> Operations.OrgsCreateOrUpdateCustomProperties.Output
    /// Get a custom property for an organization
    ///
    /// Gets a custom property that is defined for an organization.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/get(orgs/get-custom-property)`.
    func orgsGetCustomProperty(_ input: Operations.OrgsGetCustomProperty.Input) async throws -> Operations.OrgsGetCustomProperty.Output
    /// Create or update a custom property for an organization
    ///
    /// Creates a new or updates an existing custom property that is defined for an organization.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/put(orgs/create-or-update-custom-property)`.
    func orgsCreateOrUpdateCustomProperty(_ input: Operations.OrgsCreateOrUpdateCustomProperty.Input) async throws -> Operations.OrgsCreateOrUpdateCustomProperty.Output
    /// Remove a custom property for an organization
    ///
    /// Removes a custom property that is defined for an organization.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/delete(orgs/remove-custom-property)`.
    func orgsRemoveCustomProperty(_ input: Operations.OrgsRemoveCustomProperty.Input) async throws -> Operations.OrgsRemoveCustomProperty.Output
    /// List custom property values for organization repositories
    ///
    /// Lists organization repositories with all of their custom property values.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/values`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/values/get(orgs/list-custom-properties-values-for-repos)`.
    func orgsListCustomPropertiesValuesForRepos(_ input: Operations.OrgsListCustomPropertiesValuesForRepos.Input) async throws -> Operations.OrgsListCustomPropertiesValuesForRepos.Output
    /// Create or update custom property values for organization repositories
    ///
    /// Create new or update existing custom property values for repositories in a batch that belong to an organization.
    /// Each target repository will have its custom property values updated to match the values provided in the request.
    ///
    /// A maximum of 30 repositories can be updated in a single request.
    ///
    /// Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_values_editor` in the organization.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/properties/values`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/values/patch(orgs/create-or-update-custom-properties-values-for-repos)`.
    func orgsCreateOrUpdateCustomPropertiesValuesForRepos(_ input: Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Input) async throws -> Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Output
    /// List public organization members
    ///
    /// Members of an organization can choose to have their membership publicized or not.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/public_members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/get(orgs/list-public-members)`.
    func orgsListPublicMembers(_ input: Operations.OrgsListPublicMembers.Input) async throws -> Operations.OrgsListPublicMembers.Output
    /// Check public organization membership for a user
    ///
    /// Check if the provided user is a public member of the organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/get(orgs/check-public-membership-for-user)`.
    func orgsCheckPublicMembershipForUser(_ input: Operations.OrgsCheckPublicMembershipForUser.Input) async throws -> Operations.OrgsCheckPublicMembershipForUser.Output
    /// Set public organization membership for the authenticated user
    ///
    /// The user can publicize their own membership. (A user cannot publicize the membership for another user.)
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/put(orgs/set-public-membership-for-authenticated-user)`.
    func orgsSetPublicMembershipForAuthenticatedUser(_ input: Operations.OrgsSetPublicMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsSetPublicMembershipForAuthenticatedUser.Output
    /// Remove public organization membership for the authenticated user
    ///
    /// Removes the public membership for the authenticated user from the specified organization, unless public visibility is enforced by default.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/delete(orgs/remove-public-membership-for-authenticated-user)`.
    func orgsRemovePublicMembershipForAuthenticatedUser(_ input: Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Output
    /// Get organization ruleset history
    ///
    /// Get the history of an organization ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}/history`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/history/get(orgs/get-org-ruleset-history)`.
    func orgsGetOrgRulesetHistory(_ input: Operations.OrgsGetOrgRulesetHistory.Input) async throws -> Operations.OrgsGetOrgRulesetHistory.Output
    /// Get organization ruleset version
    ///
    /// Get a version of an organization ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}/history/{version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/history/{version_id}/get(orgs/get-org-ruleset-version)`.
    func orgsGetOrgRulesetVersion(_ input: Operations.OrgsGetOrgRulesetVersion.Input) async throws -> Operations.OrgsGetOrgRulesetVersion.Output
    /// List security manager teams
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/security-managers`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/get(orgs/list-security-manager-teams)`.
    @available(*, deprecated)
    func orgsListSecurityManagerTeams(_ input: Operations.OrgsListSecurityManagerTeams.Input) async throws -> Operations.OrgsListSecurityManagerTeams.Output
    /// Add a security manager team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/security-managers/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/teams/{team_slug}/put(orgs/add-security-manager-team)`.
    @available(*, deprecated)
    func orgsAddSecurityManagerTeam(_ input: Operations.OrgsAddSecurityManagerTeam.Input) async throws -> Operations.OrgsAddSecurityManagerTeam.Output
    /// Remove a security manager team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/security-managers/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/teams/{team_slug}/delete(orgs/remove-security-manager-team)`.
    @available(*, deprecated)
    func orgsRemoveSecurityManagerTeam(_ input: Operations.OrgsRemoveSecurityManagerTeam.Input) async throws -> Operations.OrgsRemoveSecurityManagerTeam.Output
    /// Enable or disable a security feature for an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** The ability to enable or disable a security feature for all eligible repositories in an organization is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-07-22-deprecation-of-api-endpoint-to-enable-or-disable-a-security-feature-for-an-organization/).
    ///
    /// Enables or disables the specified security feature for all eligible repositories in an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// The authenticated user must be an organization owner or be member of a team with the security manager role to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org`, `write:org`, or `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/{security_product}/{enablement}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/{security_product}/{enablement}/post(orgs/enable-or-disable-security-product-on-all-org-repos)`.
    @available(*, deprecated)
    func orgsEnableOrDisableSecurityProductOnAllOrgRepos(_ input: Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Input) async throws -> Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Output
    /// List organization memberships for the authenticated user
    ///
    /// Lists all of the authenticated user's organization memberships.
    ///
    /// - Remark: HTTP `GET /user/memberships/orgs`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/get(orgs/list-memberships-for-authenticated-user)`.
    func orgsListMembershipsForAuthenticatedUser(_ input: Operations.OrgsListMembershipsForAuthenticatedUser.Input) async throws -> Operations.OrgsListMembershipsForAuthenticatedUser.Output
    /// Get an organization membership for the authenticated user
    ///
    /// If the authenticated user is an active or pending member of the organization, this endpoint will return the user's membership. If the authenticated user is not affiliated with the organization, a `404` is returned. This endpoint will return a `403` if the request is made by a GitHub App that is blocked by the organization.
    ///
    /// - Remark: HTTP `GET /user/memberships/orgs/{org}`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/{org}/get(orgs/get-membership-for-authenticated-user)`.
    func orgsGetMembershipForAuthenticatedUser(_ input: Operations.OrgsGetMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsGetMembershipForAuthenticatedUser.Output
    /// Update an organization membership for the authenticated user
    ///
    /// Converts the authenticated user to an active member of the organization, if that user has a pending invitation from the organization.
    ///
    /// - Remark: HTTP `PATCH /user/memberships/orgs/{org}`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/{org}/patch(orgs/update-membership-for-authenticated-user)`.
    func orgsUpdateMembershipForAuthenticatedUser(_ input: Operations.OrgsUpdateMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsUpdateMembershipForAuthenticatedUser.Output
    /// List organizations for the authenticated user
    ///
    /// List organizations for the authenticated user.
    ///
    /// For OAuth app tokens and personal access tokens (classic), this endpoint only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope for OAuth app tokens and personal access tokens (classic). Requests with insufficient scope will receive a `403 Forbidden` response.
    ///
    /// > [!NOTE]
    /// > Requests using a fine-grained access token will receive a `200 Success` response with an empty list.
    ///
    /// - Remark: HTTP `GET /user/orgs`.
    /// - Remark: Generated from `#/paths//user/orgs/get(orgs/list-for-authenticated-user)`.
    func orgsListForAuthenticatedUser(_ input: Operations.OrgsListForAuthenticatedUser.Input) async throws -> Operations.OrgsListForAuthenticatedUser.Output
    /// List organizations for a user
    ///
    /// List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
    ///
    /// This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user) API instead.
    ///
    /// - Remark: HTTP `GET /users/{username}/orgs`.
    /// - Remark: Generated from `#/paths//users/{username}/orgs/get(orgs/list-for-user)`.
    func orgsListForUser(_ input: Operations.OrgsListForUser.Input) async throws -> Operations.OrgsListForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List organizations
    ///
    /// Lists all organizations, in the order that they were created.
    ///
    /// > [!NOTE]
    /// > Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.
    ///
    /// - Remark: HTTP `GET /organizations`.
    /// - Remark: Generated from `#/paths//organizations/get(orgs/list)`.
    public func orgsList(
        query: Operations.OrgsList.Input.Query = .init(),
        headers: Operations.OrgsList.Input.Headers = .init()
    ) async throws -> Operations.OrgsList.Output {
        try await orgsList(Operations.OrgsList.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get an organization
    ///
    /// Gets information about an organization.
    ///
    /// When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, outside collaborators, guest collaborators, repository collaborators, or everyone with access to any repository within the organization to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
    ///
    /// To see the full details about an organization, the authenticated user must be an organization owner.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.
    ///
    /// To see information about an organization's GitHub plan, GitHub Apps need the `Organization plan` permission.
    ///
    /// - Remark: HTTP `GET /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/get(orgs/get)`.
    public func orgsGet(
        path: Operations.OrgsGet.Input.Path,
        headers: Operations.OrgsGet.Input.Headers = .init()
    ) async throws -> Operations.OrgsGet.Output {
        try await orgsGet(Operations.OrgsGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Code security product enablement for new repositories through the organization API is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization) to set defaults instead. For more information on setting a default security configuration, see the [changelog](https://github.blog/changelog/2024-07-09-sunsetting-security-settings-defaults-parameters-in-the-organizations-rest-api/).
    ///
    /// Updates the organization's profile and member privileges.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)`.
    public func orgsUpdate(
        path: Operations.OrgsUpdate.Input.Path,
        headers: Operations.OrgsUpdate.Input.Headers = .init(),
        body: Operations.OrgsUpdate.Input.Body? = nil
    ) async throws -> Operations.OrgsUpdate.Output {
        try await orgsUpdate(Operations.OrgsUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an organization
    ///
    /// Deletes an organization and all its repositories.
    ///
    /// The organization login will be unavailable for 90 days after deletion.
    ///
    /// Please review the Terms of Service regarding account deletion before using this endpoint:
    ///
    /// https://docs.github.com/site-policy/github-terms/github-terms-of-service
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)`.
    public func orgsDelete(
        path: Operations.OrgsDelete.Input.Path,
        headers: Operations.OrgsDelete.Input.Headers = .init()
    ) async throws -> Operations.OrgsDelete.Output {
        try await orgsDelete(Operations.OrgsDelete.Input(
            path: path,
            headers: headers
        ))
    }
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/bulk-list/post(orgs/list-attestations-bulk)`.
    public func orgsListAttestationsBulk(
        path: Operations.OrgsListAttestationsBulk.Input.Path,
        query: Operations.OrgsListAttestationsBulk.Input.Query = .init(),
        headers: Operations.OrgsListAttestationsBulk.Input.Headers = .init(),
        body: Operations.OrgsListAttestationsBulk.Input.Body
    ) async throws -> Operations.OrgsListAttestationsBulk.Output {
        try await orgsListAttestationsBulk(Operations.OrgsListAttestationsBulk.Input(
            path: path,
            query: query,
            headers: headers,
            body: body
        ))
    }
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)`.
    public func orgsDeleteAttestationsBulk(
        path: Operations.OrgsDeleteAttestationsBulk.Input.Path,
        headers: Operations.OrgsDeleteAttestationsBulk.Input.Headers = .init(),
        body: Operations.OrgsDeleteAttestationsBulk.Input.Body
    ) async throws -> Operations.OrgsDeleteAttestationsBulk.Output {
        try await orgsDeleteAttestationsBulk(Operations.OrgsDeleteAttestationsBulk.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)`.
    public func orgsDeleteAttestationsBySubjectDigest(
        path: Operations.OrgsDeleteAttestationsBySubjectDigest.Input.Path,
        headers: Operations.OrgsDeleteAttestationsBySubjectDigest.Input.Headers = .init()
    ) async throws -> Operations.OrgsDeleteAttestationsBySubjectDigest.Output {
        try await orgsDeleteAttestationsBySubjectDigest(Operations.OrgsDeleteAttestationsBySubjectDigest.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by an org.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)`.
    public func orgsDeleteAttestationsById(
        path: Operations.OrgsDeleteAttestationsById.Input.Path,
        headers: Operations.OrgsDeleteAttestationsById.Input.Headers = .init()
    ) async throws -> Operations.OrgsDeleteAttestationsById.Output {
        try await orgsDeleteAttestationsById(Operations.OrgsDeleteAttestationsById.Input(
            path: path,
            headers: headers
        ))
    }
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{subject_digest}/get(orgs/list-attestations)`.
    public func orgsListAttestations(
        path: Operations.OrgsListAttestations.Input.Path,
        query: Operations.OrgsListAttestations.Input.Query = .init(),
        headers: Operations.OrgsListAttestations.Input.Headers = .init()
    ) async throws -> Operations.OrgsListAttestations.Output {
        try await orgsListAttestations(Operations.OrgsListAttestations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List users blocked by an organization
    ///
    /// List the users blocked by an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/get(orgs/list-blocked-users)`.
    public func orgsListBlockedUsers(
        path: Operations.OrgsListBlockedUsers.Input.Path,
        query: Operations.OrgsListBlockedUsers.Input.Query = .init(),
        headers: Operations.OrgsListBlockedUsers.Input.Headers = .init()
    ) async throws -> Operations.OrgsListBlockedUsers.Output {
        try await orgsListBlockedUsers(Operations.OrgsListBlockedUsers.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check if a user is blocked by an organization
    ///
    /// Returns a 204 if the given user is blocked by the given organization. Returns a 404 if the organization is not blocking the user, or if the user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)`.
    public func orgsCheckBlockedUser(
        path: Operations.OrgsCheckBlockedUser.Input.Path,
        headers: Operations.OrgsCheckBlockedUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsCheckBlockedUser.Output {
        try await orgsCheckBlockedUser(Operations.OrgsCheckBlockedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Block a user from an organization
    ///
    /// Blocks the given user on behalf of the specified organization and returns a 204. If the organization cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)`.
    public func orgsBlockUser(
        path: Operations.OrgsBlockUser.Input.Path,
        headers: Operations.OrgsBlockUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsBlockUser.Output {
        try await orgsBlockUser(Operations.OrgsBlockUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unblock a user from an organization
    ///
    /// Unblocks the given user on behalf of the specified organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/delete(orgs/unblock-user)`.
    public func orgsUnblockUser(path: Operations.OrgsUnblockUser.Input.Path) async throws -> Operations.OrgsUnblockUser.Output {
        try await orgsUnblockUser(Operations.OrgsUnblockUser.Input(path: path))
    }
    /// List failed organization invitations
    ///
    /// The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/failed_invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/failed_invitations/get(orgs/list-failed-invitations)`.
    public func orgsListFailedInvitations(
        path: Operations.OrgsListFailedInvitations.Input.Path,
        query: Operations.OrgsListFailedInvitations.Input.Query = .init(),
        headers: Operations.OrgsListFailedInvitations.Input.Headers = .init()
    ) async throws -> Operations.OrgsListFailedInvitations.Output {
        try await orgsListFailedInvitations(Operations.OrgsListFailedInvitations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List organization webhooks
    ///
    /// List webhooks for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/get(orgs/list-webhooks)`.
    public func orgsListWebhooks(
        path: Operations.OrgsListWebhooks.Input.Path,
        query: Operations.OrgsListWebhooks.Input.Query = .init(),
        headers: Operations.OrgsListWebhooks.Input.Headers = .init()
    ) async throws -> Operations.OrgsListWebhooks.Output {
        try await orgsListWebhooks(Operations.OrgsListWebhooks.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization webhook
    ///
    /// Create a hook that posts payloads in JSON format.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
    /// edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)`.
    public func orgsCreateWebhook(
        path: Operations.OrgsCreateWebhook.Input.Path,
        headers: Operations.OrgsCreateWebhook.Input.Headers = .init(),
        body: Operations.OrgsCreateWebhook.Input.Body
    ) async throws -> Operations.OrgsCreateWebhook.Output {
        try await orgsCreateWebhook(Operations.OrgsCreateWebhook.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get an organization webhook
    ///
    /// Returns a webhook configured in an organization. To get only the webhook
    /// `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/get(orgs/get-webhook)`.
    public func orgsGetWebhook(
        path: Operations.OrgsGetWebhook.Input.Path,
        headers: Operations.OrgsGetWebhook.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetWebhook.Output {
        try await orgsGetWebhook(Operations.OrgsGetWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an organization webhook
    ///
    /// Updates a webhook configured in an organization. When you update a webhook,
    /// the `secret` will be overwritten. If you previously had a `secret` set, you must
    /// provide the same `secret` or set a new `secret` or the secret will be removed. If
    /// you are only updating individual webhook `config` properties, use "[Update a webhook
    /// configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)`.
    public func orgsUpdateWebhook(
        path: Operations.OrgsUpdateWebhook.Input.Path,
        headers: Operations.OrgsUpdateWebhook.Input.Headers = .init(),
        body: Operations.OrgsUpdateWebhook.Input.Body? = nil
    ) async throws -> Operations.OrgsUpdateWebhook.Output {
        try await orgsUpdateWebhook(Operations.OrgsUpdateWebhook.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an organization webhook
    ///
    /// Delete a webhook for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)`.
    public func orgsDeleteWebhook(
        path: Operations.OrgsDeleteWebhook.Input.Path,
        headers: Operations.OrgsDeleteWebhook.Input.Headers = .init()
    ) async throws -> Operations.OrgsDeleteWebhook.Output {
        try await orgsDeleteWebhook(Operations.OrgsDeleteWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a webhook configuration for an organization
    ///
    /// Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/get(orgs/get-webhook-config-for-org)`.
    public func orgsGetWebhookConfigForOrg(
        path: Operations.OrgsGetWebhookConfigForOrg.Input.Path,
        headers: Operations.OrgsGetWebhookConfigForOrg.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetWebhookConfigForOrg.Output {
        try await orgsGetWebhookConfigForOrg(Operations.OrgsGetWebhookConfigForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a webhook configuration for an organization
    ///
    /// Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/patch(orgs/update-webhook-config-for-org)`.
    public func orgsUpdateWebhookConfigForOrg(
        path: Operations.OrgsUpdateWebhookConfigForOrg.Input.Path,
        headers: Operations.OrgsUpdateWebhookConfigForOrg.Input.Headers = .init(),
        body: Operations.OrgsUpdateWebhookConfigForOrg.Input.Body? = nil
    ) async throws -> Operations.OrgsUpdateWebhookConfigForOrg.Output {
        try await orgsUpdateWebhookConfigForOrg(Operations.OrgsUpdateWebhookConfigForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List deliveries for an organization webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)`.
    public func orgsListWebhookDeliveries(
        path: Operations.OrgsListWebhookDeliveries.Input.Path,
        query: Operations.OrgsListWebhookDeliveries.Input.Query = .init(),
        headers: Operations.OrgsListWebhookDeliveries.Input.Headers = .init()
    ) async throws -> Operations.OrgsListWebhookDeliveries.Output {
        try await orgsListWebhookDeliveries(Operations.OrgsListWebhookDeliveries.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a webhook delivery for an organization webhook
    ///
    /// Returns a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)`.
    public func orgsGetWebhookDelivery(
        path: Operations.OrgsGetWebhookDelivery.Input.Path,
        headers: Operations.OrgsGetWebhookDelivery.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetWebhookDelivery.Output {
        try await orgsGetWebhookDelivery(Operations.OrgsGetWebhookDelivery.Input(
            path: path,
            headers: headers
        ))
    }
    /// Redeliver a delivery for an organization webhook
    ///
    /// Redeliver a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)`.
    public func orgsRedeliverWebhookDelivery(
        path: Operations.OrgsRedeliverWebhookDelivery.Input.Path,
        headers: Operations.OrgsRedeliverWebhookDelivery.Input.Headers = .init()
    ) async throws -> Operations.OrgsRedeliverWebhookDelivery.Output {
        try await orgsRedeliverWebhookDelivery(Operations.OrgsRedeliverWebhookDelivery.Input(
            path: path,
            headers: headers
        ))
    }
    /// Ping an organization webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event)
    /// to be sent to the hook.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/pings`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)`.
    public func orgsPingWebhook(
        path: Operations.OrgsPingWebhook.Input.Path,
        headers: Operations.OrgsPingWebhook.Input.Headers = .init()
    ) async throws -> Operations.OrgsPingWebhook.Output {
        try await orgsPingWebhook(Operations.OrgsPingWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get route stats by actor
    ///
    /// Get API request count statistics for an actor broken down by route within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/get(api-insights/get-route-stats-by-actor)`.
    public func apiInsightsGetRouteStatsByActor(
        path: Operations.ApiInsightsGetRouteStatsByActor.Input.Path,
        query: Operations.ApiInsightsGetRouteStatsByActor.Input.Query,
        headers: Operations.ApiInsightsGetRouteStatsByActor.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetRouteStatsByActor.Output {
        try await apiInsightsGetRouteStatsByActor(Operations.ApiInsightsGetRouteStatsByActor.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get subject stats
    ///
    /// Get API request statistics for all subjects within an organization within a specified time frame. Subjects can be users or GitHub Apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/subject-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/subject-stats/get(api-insights/get-subject-stats)`.
    public func apiInsightsGetSubjectStats(
        path: Operations.ApiInsightsGetSubjectStats.Input.Path,
        query: Operations.ApiInsightsGetSubjectStats.Input.Query,
        headers: Operations.ApiInsightsGetSubjectStats.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetSubjectStats.Output {
        try await apiInsightsGetSubjectStats(Operations.ApiInsightsGetSubjectStats.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get summary stats
    ///
    /// Get overall statistics of API requests made within an organization by all users and apps within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/get(api-insights/get-summary-stats)`.
    public func apiInsightsGetSummaryStats(
        path: Operations.ApiInsightsGetSummaryStats.Input.Path,
        query: Operations.ApiInsightsGetSummaryStats.Input.Query,
        headers: Operations.ApiInsightsGetSummaryStats.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetSummaryStats.Output {
        try await apiInsightsGetSummaryStats(Operations.ApiInsightsGetSummaryStats.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get summary stats by user
    ///
    /// Get overall statistics of API requests within the organization for a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/users/{user_id}/get(api-insights/get-summary-stats-by-user)`.
    public func apiInsightsGetSummaryStatsByUser(
        path: Operations.ApiInsightsGetSummaryStatsByUser.Input.Path,
        query: Operations.ApiInsightsGetSummaryStatsByUser.Input.Query,
        headers: Operations.ApiInsightsGetSummaryStatsByUser.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetSummaryStatsByUser.Output {
        try await apiInsightsGetSummaryStatsByUser(Operations.ApiInsightsGetSummaryStatsByUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get summary stats by actor
    ///
    /// Get overall statistics of API requests within the organization made by a specific actor. Actors can be GitHub App installations, OAuth apps or other tokens on behalf of a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/get(api-insights/get-summary-stats-by-actor)`.
    public func apiInsightsGetSummaryStatsByActor(
        path: Operations.ApiInsightsGetSummaryStatsByActor.Input.Path,
        query: Operations.ApiInsightsGetSummaryStatsByActor.Input.Query,
        headers: Operations.ApiInsightsGetSummaryStatsByActor.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetSummaryStatsByActor.Output {
        try await apiInsightsGetSummaryStatsByActor(Operations.ApiInsightsGetSummaryStatsByActor.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get time stats
    ///
    /// Get the number of API requests and rate-limited requests made within an organization over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/get(api-insights/get-time-stats)`.
    public func apiInsightsGetTimeStats(
        path: Operations.ApiInsightsGetTimeStats.Input.Path,
        query: Operations.ApiInsightsGetTimeStats.Input.Query,
        headers: Operations.ApiInsightsGetTimeStats.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetTimeStats.Output {
        try await apiInsightsGetTimeStats(Operations.ApiInsightsGetTimeStats.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get time stats by user
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific user over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/users/{user_id}/get(api-insights/get-time-stats-by-user)`.
    public func apiInsightsGetTimeStatsByUser(
        path: Operations.ApiInsightsGetTimeStatsByUser.Input.Path,
        query: Operations.ApiInsightsGetTimeStatsByUser.Input.Query,
        headers: Operations.ApiInsightsGetTimeStatsByUser.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetTimeStatsByUser.Output {
        try await apiInsightsGetTimeStatsByUser(Operations.ApiInsightsGetTimeStatsByUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get time stats by actor
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific actor within a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/get(api-insights/get-time-stats-by-actor)`.
    public func apiInsightsGetTimeStatsByActor(
        path: Operations.ApiInsightsGetTimeStatsByActor.Input.Path,
        query: Operations.ApiInsightsGetTimeStatsByActor.Input.Query,
        headers: Operations.ApiInsightsGetTimeStatsByActor.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetTimeStatsByActor.Output {
        try await apiInsightsGetTimeStatsByActor(Operations.ApiInsightsGetTimeStatsByActor.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get user stats
    ///
    /// Get API usage statistics within an organization for a user broken down by the type of access.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/user-stats/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/user-stats/{user_id}/get(api-insights/get-user-stats)`.
    public func apiInsightsGetUserStats(
        path: Operations.ApiInsightsGetUserStats.Input.Path,
        query: Operations.ApiInsightsGetUserStats.Input.Query,
        headers: Operations.ApiInsightsGetUserStats.Input.Headers = .init()
    ) async throws -> Operations.ApiInsightsGetUserStats.Output {
        try await apiInsightsGetUserStats(Operations.ApiInsightsGetUserStats.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List app installations for an organization
    ///
    /// Lists all GitHub Apps in an organization. The installation count includes
    /// all GitHub Apps installed on repositories in the organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installations/get(orgs/list-app-installations)`.
    public func orgsListAppInstallations(
        path: Operations.OrgsListAppInstallations.Input.Path,
        query: Operations.OrgsListAppInstallations.Input.Query = .init(),
        headers: Operations.OrgsListAppInstallations.Input.Headers = .init()
    ) async throws -> Operations.OrgsListAppInstallations.Output {
        try await orgsListAppInstallations(Operations.OrgsListAppInstallations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List pending organization invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization
    /// Invitation role and will be one of the following values: `direct_member`, `admin`,
    /// `billing_manager`, or `hiring_manager`. If the invitee is not a GitHub
    /// member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/get(orgs/list-pending-invitations)`.
    public func orgsListPendingInvitations(
        path: Operations.OrgsListPendingInvitations.Input.Path,
        query: Operations.OrgsListPendingInvitations.Input.Query = .init(),
        headers: Operations.OrgsListPendingInvitations.Input.Headers = .init()
    ) async throws -> Operations.OrgsListPendingInvitations.Output {
        try await orgsListPendingInvitations(Operations.OrgsListPendingInvitations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization invitation
    ///
    /// Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)`.
    public func orgsCreateInvitation(
        path: Operations.OrgsCreateInvitation.Input.Path,
        headers: Operations.OrgsCreateInvitation.Input.Headers = .init(),
        body: Operations.OrgsCreateInvitation.Input.Body? = nil
    ) async throws -> Operations.OrgsCreateInvitation.Output {
        try await orgsCreateInvitation(Operations.OrgsCreateInvitation.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Cancel an organization invitation
    ///
    /// Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)`.
    public func orgsCancelInvitation(
        path: Operations.OrgsCancelInvitation.Input.Path,
        headers: Operations.OrgsCancelInvitation.Input.Headers = .init()
    ) async throws -> Operations.OrgsCancelInvitation.Output {
        try await orgsCancelInvitation(Operations.OrgsCancelInvitation.Input(
            path: path,
            headers: headers
        ))
    }
    /// List organization invitation teams
    ///
    /// List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations/{invitation_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/teams/get(orgs/list-invitation-teams)`.
    public func orgsListInvitationTeams(
        path: Operations.OrgsListInvitationTeams.Input.Path,
        query: Operations.OrgsListInvitationTeams.Input.Query = .init(),
        headers: Operations.OrgsListInvitationTeams.Input.Headers = .init()
    ) async throws -> Operations.OrgsListInvitationTeams.Output {
        try await orgsListInvitationTeams(Operations.OrgsListInvitationTeams.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List issue types for an organization
    ///
    /// Lists all issue types for an organization. OAuth app tokens and personal access tokens (classic) need the read:org scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/get(orgs/list-issue-types)`.
    public func orgsListIssueTypes(
        path: Operations.OrgsListIssueTypes.Input.Path,
        headers: Operations.OrgsListIssueTypes.Input.Headers = .init()
    ) async throws -> Operations.OrgsListIssueTypes.Output {
        try await orgsListIssueTypes(Operations.OrgsListIssueTypes.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create issue type for an organization
    ///
    /// Create a new issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)`.
    public func orgsCreateIssueType(
        path: Operations.OrgsCreateIssueType.Input.Path,
        headers: Operations.OrgsCreateIssueType.Input.Headers = .init(),
        body: Operations.OrgsCreateIssueType.Input.Body
    ) async throws -> Operations.OrgsCreateIssueType.Output {
        try await orgsCreateIssueType(Operations.OrgsCreateIssueType.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Update issue type for an organization
    ///
    /// Updates an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)`.
    public func orgsUpdateIssueType(
        path: Operations.OrgsUpdateIssueType.Input.Path,
        headers: Operations.OrgsUpdateIssueType.Input.Headers = .init(),
        body: Operations.OrgsUpdateIssueType.Input.Body
    ) async throws -> Operations.OrgsUpdateIssueType.Output {
        try await orgsUpdateIssueType(Operations.OrgsUpdateIssueType.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete issue type for an organization
    ///
    /// Deletes an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)`.
    public func orgsDeleteIssueType(
        path: Operations.OrgsDeleteIssueType.Input.Path,
        headers: Operations.OrgsDeleteIssueType.Input.Headers = .init()
    ) async throws -> Operations.OrgsDeleteIssueType.Output {
        try await orgsDeleteIssueType(Operations.OrgsDeleteIssueType.Input(
            path: path,
            headers: headers
        ))
    }
    /// List organization members
    ///
    /// List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/get(orgs/list-members)`.
    public func orgsListMembers(
        path: Operations.OrgsListMembers.Input.Path,
        query: Operations.OrgsListMembers.Input.Query = .init(),
        headers: Operations.OrgsListMembers.Input.Headers = .init()
    ) async throws -> Operations.OrgsListMembers.Output {
        try await orgsListMembers(Operations.OrgsListMembers.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check organization membership for a user
    ///
    /// Check if a user is, publicly or privately, a member of the organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/get(orgs/check-membership-for-user)`.
    public func orgsCheckMembershipForUser(path: Operations.OrgsCheckMembershipForUser.Input.Path) async throws -> Operations.OrgsCheckMembershipForUser.Output {
        try await orgsCheckMembershipForUser(Operations.OrgsCheckMembershipForUser.Input(path: path))
    }
    /// Remove an organization member
    ///
    /// Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
    ///
    /// > [!NOTE]
    /// > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/delete(orgs/remove-member)`.
    public func orgsRemoveMember(
        path: Operations.OrgsRemoveMember.Input.Path,
        headers: Operations.OrgsRemoveMember.Input.Headers = .init()
    ) async throws -> Operations.OrgsRemoveMember.Output {
        try await orgsRemoveMember(Operations.OrgsRemoveMember.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get organization membership for a user
    ///
    /// In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/get(orgs/get-membership-for-user)`.
    public func orgsGetMembershipForUser(
        path: Operations.OrgsGetMembershipForUser.Input.Path,
        headers: Operations.OrgsGetMembershipForUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetMembershipForUser.Output {
        try await orgsGetMembershipForUser(Operations.OrgsGetMembershipForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set organization membership for a user
    ///
    /// Only authenticated organization owners can add a member to the organization or update the member's role.
    ///
    /// *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
    ///     
    /// *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
    ///
    /// **Rate limits**
    ///
    /// To prevent abuse, organization owners are limited to creating 50 organization invitations for an organization within a 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/put(orgs/set-membership-for-user)`.
    public func orgsSetMembershipForUser(
        path: Operations.OrgsSetMembershipForUser.Input.Path,
        headers: Operations.OrgsSetMembershipForUser.Input.Headers = .init(),
        body: Operations.OrgsSetMembershipForUser.Input.Body? = nil
    ) async throws -> Operations.OrgsSetMembershipForUser.Output {
        try await orgsSetMembershipForUser(Operations.OrgsSetMembershipForUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove organization membership for a user
    ///
    /// In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
    ///
    /// If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
    ///
    /// > [!NOTE]
    /// > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/delete(orgs/remove-membership-for-user)`.
    public func orgsRemoveMembershipForUser(
        path: Operations.OrgsRemoveMembershipForUser.Input.Path,
        headers: Operations.OrgsRemoveMembershipForUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsRemoveMembershipForUser.Output {
        try await orgsRemoveMembershipForUser(Operations.OrgsRemoveMembershipForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get all organization roles for an organization
    ///
    /// Lists the organization roles available in this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/get(orgs/list-org-roles)`.
    public func orgsListOrgRoles(
        path: Operations.OrgsListOrgRoles.Input.Path,
        headers: Operations.OrgsListOrgRoles.Input.Headers = .init()
    ) async throws -> Operations.OrgsListOrgRoles.Output {
        try await orgsListOrgRoles(Operations.OrgsListOrgRoles.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove all organization roles for a team
    ///
    /// Removes all assigned organization roles from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/delete(orgs/revoke-all-org-roles-team)`.
    public func orgsRevokeAllOrgRolesTeam(path: Operations.OrgsRevokeAllOrgRolesTeam.Input.Path) async throws -> Operations.OrgsRevokeAllOrgRolesTeam.Output {
        try await orgsRevokeAllOrgRolesTeam(Operations.OrgsRevokeAllOrgRolesTeam.Input(path: path))
    }
    /// Assign an organization role to a team
    ///
    /// Assigns an organization role to a team in an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/{role_id}/put(orgs/assign-team-to-org-role)`.
    public func orgsAssignTeamToOrgRole(path: Operations.OrgsAssignTeamToOrgRole.Input.Path) async throws -> Operations.OrgsAssignTeamToOrgRole.Output {
        try await orgsAssignTeamToOrgRole(Operations.OrgsAssignTeamToOrgRole.Input(path: path))
    }
    /// Remove an organization role from a team
    ///
    /// Removes an organization role from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/{role_id}/delete(orgs/revoke-org-role-team)`.
    public func orgsRevokeOrgRoleTeam(path: Operations.OrgsRevokeOrgRoleTeam.Input.Path) async throws -> Operations.OrgsRevokeOrgRoleTeam.Output {
        try await orgsRevokeOrgRoleTeam(Operations.OrgsRevokeOrgRoleTeam.Input(path: path))
    }
    /// Remove all organization roles for a user
    ///
    /// Revokes all assigned organization roles from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/users/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/delete(orgs/revoke-all-org-roles-user)`.
    public func orgsRevokeAllOrgRolesUser(path: Operations.OrgsRevokeAllOrgRolesUser.Input.Path) async throws -> Operations.OrgsRevokeAllOrgRolesUser.Output {
        try await orgsRevokeAllOrgRolesUser(Operations.OrgsRevokeAllOrgRolesUser.Input(path: path))
    }
    /// Assign an organization role to a user
    ///
    /// Assigns an organization role to a member of an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/organization-roles/users/{username}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/{role_id}/put(orgs/assign-user-to-org-role)`.
    public func orgsAssignUserToOrgRole(path: Operations.OrgsAssignUserToOrgRole.Input.Path) async throws -> Operations.OrgsAssignUserToOrgRole.Output {
        try await orgsAssignUserToOrgRole(Operations.OrgsAssignUserToOrgRole.Input(path: path))
    }
    /// Remove an organization role from a user
    ///
    /// Remove an organization role from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/users/{username}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/{role_id}/delete(orgs/revoke-org-role-user)`.
    public func orgsRevokeOrgRoleUser(path: Operations.OrgsRevokeOrgRoleUser.Input.Path) async throws -> Operations.OrgsRevokeOrgRoleUser.Output {
        try await orgsRevokeOrgRoleUser(Operations.OrgsRevokeOrgRoleUser.Input(path: path))
    }
    /// Get an organization role
    ///
    /// Gets an organization role that is available to this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/get(orgs/get-org-role)`.
    public func orgsGetOrgRole(
        path: Operations.OrgsGetOrgRole.Input.Path,
        headers: Operations.OrgsGetOrgRole.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetOrgRole.Output {
        try await orgsGetOrgRole(Operations.OrgsGetOrgRole.Input(
            path: path,
            headers: headers
        ))
    }
    /// List teams that are assigned to an organization role
    ///
    /// Lists the teams that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, you must be an administrator for the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/teams/get(orgs/list-org-role-teams)`.
    public func orgsListOrgRoleTeams(
        path: Operations.OrgsListOrgRoleTeams.Input.Path,
        query: Operations.OrgsListOrgRoleTeams.Input.Query = .init(),
        headers: Operations.OrgsListOrgRoleTeams.Input.Headers = .init()
    ) async throws -> Operations.OrgsListOrgRoleTeams.Output {
        try await orgsListOrgRoleTeams(Operations.OrgsListOrgRoleTeams.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List users that are assigned to an organization role
    ///
    /// Lists organization members that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, you must be an administrator for the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}/users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/users/get(orgs/list-org-role-users)`.
    public func orgsListOrgRoleUsers(
        path: Operations.OrgsListOrgRoleUsers.Input.Path,
        query: Operations.OrgsListOrgRoleUsers.Input.Query = .init(),
        headers: Operations.OrgsListOrgRoleUsers.Input.Headers = .init()
    ) async throws -> Operations.OrgsListOrgRoleUsers.Output {
        try await orgsListOrgRoleUsers(Operations.OrgsListOrgRoleUsers.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List outside collaborators for an organization
    ///
    /// List all users who are outside collaborators of an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/outside_collaborators`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/get(orgs/list-outside-collaborators)`.
    public func orgsListOutsideCollaborators(
        path: Operations.OrgsListOutsideCollaborators.Input.Path,
        query: Operations.OrgsListOutsideCollaborators.Input.Query = .init(),
        headers: Operations.OrgsListOutsideCollaborators.Input.Headers = .init()
    ) async throws -> Operations.OrgsListOutsideCollaborators.Output {
        try await orgsListOutsideCollaborators(Operations.OrgsListOutsideCollaborators.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Convert an organization member to outside collaborator
    ///
    /// When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/outside_collaborators/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/{username}/put(orgs/convert-member-to-outside-collaborator)`.
    public func orgsConvertMemberToOutsideCollaborator(
        path: Operations.OrgsConvertMemberToOutsideCollaborator.Input.Path,
        headers: Operations.OrgsConvertMemberToOutsideCollaborator.Input.Headers = .init(),
        body: Operations.OrgsConvertMemberToOutsideCollaborator.Input.Body? = nil
    ) async throws -> Operations.OrgsConvertMemberToOutsideCollaborator.Output {
        try await orgsConvertMemberToOutsideCollaborator(Operations.OrgsConvertMemberToOutsideCollaborator.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove outside collaborator from an organization
    ///
    /// Removing a user from this list will remove them from all the organization's repositories.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/outside_collaborators/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/{username}/delete(orgs/remove-outside-collaborator)`.
    public func orgsRemoveOutsideCollaborator(
        path: Operations.OrgsRemoveOutsideCollaborator.Input.Path,
        headers: Operations.OrgsRemoveOutsideCollaborator.Input.Headers = .init()
    ) async throws -> Operations.OrgsRemoveOutsideCollaborator.Output {
        try await orgsRemoveOutsideCollaborator(Operations.OrgsRemoveOutsideCollaborator.Input(
            path: path,
            headers: headers
        ))
    }
    /// List requests to access organization resources with fine-grained personal access tokens
    ///
    /// Lists requests from organization members to access organization resources with a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-token-requests`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/get(orgs/list-pat-grant-requests)`.
    public func orgsListPatGrantRequests(
        path: Operations.OrgsListPatGrantRequests.Input.Path,
        query: Operations.OrgsListPatGrantRequests.Input.Query = .init(),
        headers: Operations.OrgsListPatGrantRequests.Input.Headers = .init()
    ) async throws -> Operations.OrgsListPatGrantRequests.Output {
        try await orgsListPatGrantRequests(Operations.OrgsListPatGrantRequests.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Review requests to access organization resources with fine-grained personal access tokens
    ///
    /// Approves or denies multiple pending requests to access organization resources via a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-token-requests`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/post(orgs/review-pat-grant-requests-in-bulk)`.
    public func orgsReviewPatGrantRequestsInBulk(
        path: Operations.OrgsReviewPatGrantRequestsInBulk.Input.Path,
        headers: Operations.OrgsReviewPatGrantRequestsInBulk.Input.Headers = .init(),
        body: Operations.OrgsReviewPatGrantRequestsInBulk.Input.Body
    ) async throws -> Operations.OrgsReviewPatGrantRequestsInBulk.Output {
        try await orgsReviewPatGrantRequestsInBulk(Operations.OrgsReviewPatGrantRequestsInBulk.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Review a request to access organization resources with a fine-grained personal access token
    ///
    /// Approves or denies a pending request to access organization resources via a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-token-requests/{pat_request_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/{pat_request_id}/post(orgs/review-pat-grant-request)`.
    public func orgsReviewPatGrantRequest(
        path: Operations.OrgsReviewPatGrantRequest.Input.Path,
        headers: Operations.OrgsReviewPatGrantRequest.Input.Headers = .init(),
        body: Operations.OrgsReviewPatGrantRequest.Input.Body
    ) async throws -> Operations.OrgsReviewPatGrantRequest.Output {
        try await orgsReviewPatGrantRequest(Operations.OrgsReviewPatGrantRequest.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repositories requested to be accessed by a fine-grained personal access token
    ///
    /// Lists the repositories a fine-grained personal access token request is requesting access to.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories/get(orgs/list-pat-grant-request-repositories)`.
    public func orgsListPatGrantRequestRepositories(
        path: Operations.OrgsListPatGrantRequestRepositories.Input.Path,
        query: Operations.OrgsListPatGrantRequestRepositories.Input.Query = .init(),
        headers: Operations.OrgsListPatGrantRequestRepositories.Input.Headers = .init()
    ) async throws -> Operations.OrgsListPatGrantRequestRepositories.Output {
        try await orgsListPatGrantRequestRepositories(Operations.OrgsListPatGrantRequestRepositories.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List fine-grained personal access tokens with access to organization resources
    ///
    /// Lists approved fine-grained personal access tokens owned by organization members that can access organization resources.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-tokens`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/get(orgs/list-pat-grants)`.
    public func orgsListPatGrants(
        path: Operations.OrgsListPatGrants.Input.Path,
        query: Operations.OrgsListPatGrants.Input.Query = .init(),
        headers: Operations.OrgsListPatGrants.Input.Headers = .init()
    ) async throws -> Operations.OrgsListPatGrants.Output {
        try await orgsListPatGrants(Operations.OrgsListPatGrants.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Update the access to organization resources via fine-grained personal access tokens
    ///
    /// Updates the access organization members have to organization resources via fine-grained personal access tokens. Limited to revoking a token's existing access.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-tokens`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/post(orgs/update-pat-accesses)`.
    public func orgsUpdatePatAccesses(
        path: Operations.OrgsUpdatePatAccesses.Input.Path,
        headers: Operations.OrgsUpdatePatAccesses.Input.Headers = .init(),
        body: Operations.OrgsUpdatePatAccesses.Input.Body
    ) async throws -> Operations.OrgsUpdatePatAccesses.Output {
        try await orgsUpdatePatAccesses(Operations.OrgsUpdatePatAccesses.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Update the access a fine-grained personal access token has to organization resources
    ///
    /// Updates the access an organization member has to organization resources via a fine-grained personal access token. Limited to revoking the token's existing access. Limited to revoking a token's existing access.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-tokens/{pat_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/{pat_id}/post(orgs/update-pat-access)`.
    public func orgsUpdatePatAccess(
        path: Operations.OrgsUpdatePatAccess.Input.Path,
        headers: Operations.OrgsUpdatePatAccess.Input.Headers = .init(),
        body: Operations.OrgsUpdatePatAccess.Input.Body
    ) async throws -> Operations.OrgsUpdatePatAccess.Output {
        try await orgsUpdatePatAccess(Operations.OrgsUpdatePatAccess.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repositories a fine-grained personal access token has access to
    ///
    /// Lists the repositories a fine-grained personal access token has access to.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-tokens/{pat_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/{pat_id}/repositories/get(orgs/list-pat-grant-repositories)`.
    public func orgsListPatGrantRepositories(
        path: Operations.OrgsListPatGrantRepositories.Input.Path,
        query: Operations.OrgsListPatGrantRepositories.Input.Query = .init(),
        headers: Operations.OrgsListPatGrantRepositories.Input.Headers = .init()
    ) async throws -> Operations.OrgsListPatGrantRepositories.Output {
        try await orgsListPatGrantRepositories(Operations.OrgsListPatGrantRepositories.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get all custom properties for an organization
    ///
    /// Gets all custom properties defined for an organization.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/schema`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/get(orgs/get-all-custom-properties)`.
    public func orgsGetAllCustomProperties(
        path: Operations.OrgsGetAllCustomProperties.Input.Path,
        headers: Operations.OrgsGetAllCustomProperties.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetAllCustomProperties.Output {
        try await orgsGetAllCustomProperties(Operations.OrgsGetAllCustomProperties.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update custom properties for an organization
    ///
    /// Creates new or updates existing custom properties defined for an organization in a batch.
    ///
    /// If the property already exists, the existing property will be replaced with the new values.
    /// Missing optional values will fall back to default values, previous values will be overwritten.
    /// E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/properties/schema`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/patch(orgs/create-or-update-custom-properties)`.
    public func orgsCreateOrUpdateCustomProperties(
        path: Operations.OrgsCreateOrUpdateCustomProperties.Input.Path,
        headers: Operations.OrgsCreateOrUpdateCustomProperties.Input.Headers = .init(),
        body: Operations.OrgsCreateOrUpdateCustomProperties.Input.Body
    ) async throws -> Operations.OrgsCreateOrUpdateCustomProperties.Output {
        try await orgsCreateOrUpdateCustomProperties(Operations.OrgsCreateOrUpdateCustomProperties.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a custom property for an organization
    ///
    /// Gets a custom property that is defined for an organization.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/get(orgs/get-custom-property)`.
    public func orgsGetCustomProperty(
        path: Operations.OrgsGetCustomProperty.Input.Path,
        headers: Operations.OrgsGetCustomProperty.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetCustomProperty.Output {
        try await orgsGetCustomProperty(Operations.OrgsGetCustomProperty.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update a custom property for an organization
    ///
    /// Creates a new or updates an existing custom property that is defined for an organization.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/put(orgs/create-or-update-custom-property)`.
    public func orgsCreateOrUpdateCustomProperty(
        path: Operations.OrgsCreateOrUpdateCustomProperty.Input.Path,
        headers: Operations.OrgsCreateOrUpdateCustomProperty.Input.Headers = .init(),
        body: Operations.OrgsCreateOrUpdateCustomProperty.Input.Body
    ) async throws -> Operations.OrgsCreateOrUpdateCustomProperty.Output {
        try await orgsCreateOrUpdateCustomProperty(Operations.OrgsCreateOrUpdateCustomProperty.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove a custom property for an organization
    ///
    /// Removes a custom property that is defined for an organization.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/delete(orgs/remove-custom-property)`.
    public func orgsRemoveCustomProperty(
        path: Operations.OrgsRemoveCustomProperty.Input.Path,
        headers: Operations.OrgsRemoveCustomProperty.Input.Headers = .init()
    ) async throws -> Operations.OrgsRemoveCustomProperty.Output {
        try await orgsRemoveCustomProperty(Operations.OrgsRemoveCustomProperty.Input(
            path: path,
            headers: headers
        ))
    }
    /// List custom property values for organization repositories
    ///
    /// Lists organization repositories with all of their custom property values.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/values`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/values/get(orgs/list-custom-properties-values-for-repos)`.
    public func orgsListCustomPropertiesValuesForRepos(
        path: Operations.OrgsListCustomPropertiesValuesForRepos.Input.Path,
        query: Operations.OrgsListCustomPropertiesValuesForRepos.Input.Query = .init(),
        headers: Operations.OrgsListCustomPropertiesValuesForRepos.Input.Headers = .init()
    ) async throws -> Operations.OrgsListCustomPropertiesValuesForRepos.Output {
        try await orgsListCustomPropertiesValuesForRepos(Operations.OrgsListCustomPropertiesValuesForRepos.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create or update custom property values for organization repositories
    ///
    /// Create new or update existing custom property values for repositories in a batch that belong to an organization.
    /// Each target repository will have its custom property values updated to match the values provided in the request.
    ///
    /// A maximum of 30 repositories can be updated in a single request.
    ///
    /// Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_values_editor` in the organization.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/properties/values`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/values/patch(orgs/create-or-update-custom-properties-values-for-repos)`.
    public func orgsCreateOrUpdateCustomPropertiesValuesForRepos(
        path: Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Input.Path,
        headers: Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Input.Headers = .init(),
        body: Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Input.Body
    ) async throws -> Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Output {
        try await orgsCreateOrUpdateCustomPropertiesValuesForRepos(Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List public organization members
    ///
    /// Members of an organization can choose to have their membership publicized or not.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/public_members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/get(orgs/list-public-members)`.
    public func orgsListPublicMembers(
        path: Operations.OrgsListPublicMembers.Input.Path,
        query: Operations.OrgsListPublicMembers.Input.Query = .init(),
        headers: Operations.OrgsListPublicMembers.Input.Headers = .init()
    ) async throws -> Operations.OrgsListPublicMembers.Output {
        try await orgsListPublicMembers(Operations.OrgsListPublicMembers.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check public organization membership for a user
    ///
    /// Check if the provided user is a public member of the organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/get(orgs/check-public-membership-for-user)`.
    public func orgsCheckPublicMembershipForUser(path: Operations.OrgsCheckPublicMembershipForUser.Input.Path) async throws -> Operations.OrgsCheckPublicMembershipForUser.Output {
        try await orgsCheckPublicMembershipForUser(Operations.OrgsCheckPublicMembershipForUser.Input(path: path))
    }
    /// Set public organization membership for the authenticated user
    ///
    /// The user can publicize their own membership. (A user cannot publicize the membership for another user.)
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/put(orgs/set-public-membership-for-authenticated-user)`.
    public func orgsSetPublicMembershipForAuthenticatedUser(
        path: Operations.OrgsSetPublicMembershipForAuthenticatedUser.Input.Path,
        headers: Operations.OrgsSetPublicMembershipForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsSetPublicMembershipForAuthenticatedUser.Output {
        try await orgsSetPublicMembershipForAuthenticatedUser(Operations.OrgsSetPublicMembershipForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove public organization membership for the authenticated user
    ///
    /// Removes the public membership for the authenticated user from the specified organization, unless public visibility is enforced by default.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/delete(orgs/remove-public-membership-for-authenticated-user)`.
    public func orgsRemovePublicMembershipForAuthenticatedUser(path: Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Input.Path) async throws -> Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Output {
        try await orgsRemovePublicMembershipForAuthenticatedUser(Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Input(path: path))
    }
    /// Get organization ruleset history
    ///
    /// Get the history of an organization ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}/history`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/history/get(orgs/get-org-ruleset-history)`.
    public func orgsGetOrgRulesetHistory(
        path: Operations.OrgsGetOrgRulesetHistory.Input.Path,
        query: Operations.OrgsGetOrgRulesetHistory.Input.Query = .init(),
        headers: Operations.OrgsGetOrgRulesetHistory.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetOrgRulesetHistory.Output {
        try await orgsGetOrgRulesetHistory(Operations.OrgsGetOrgRulesetHistory.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get organization ruleset version
    ///
    /// Get a version of an organization ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}/history/{version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/history/{version_id}/get(orgs/get-org-ruleset-version)`.
    public func orgsGetOrgRulesetVersion(
        path: Operations.OrgsGetOrgRulesetVersion.Input.Path,
        headers: Operations.OrgsGetOrgRulesetVersion.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetOrgRulesetVersion.Output {
        try await orgsGetOrgRulesetVersion(Operations.OrgsGetOrgRulesetVersion.Input(
            path: path,
            headers: headers
        ))
    }
    /// List security manager teams
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/security-managers`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/get(orgs/list-security-manager-teams)`.
    @available(*, deprecated)
    public func orgsListSecurityManagerTeams(
        path: Operations.OrgsListSecurityManagerTeams.Input.Path,
        headers: Operations.OrgsListSecurityManagerTeams.Input.Headers = .init()
    ) async throws -> Operations.OrgsListSecurityManagerTeams.Output {
        try await orgsListSecurityManagerTeams(Operations.OrgsListSecurityManagerTeams.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add a security manager team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/security-managers/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/teams/{team_slug}/put(orgs/add-security-manager-team)`.
    @available(*, deprecated)
    public func orgsAddSecurityManagerTeam(path: Operations.OrgsAddSecurityManagerTeam.Input.Path) async throws -> Operations.OrgsAddSecurityManagerTeam.Output {
        try await orgsAddSecurityManagerTeam(Operations.OrgsAddSecurityManagerTeam.Input(path: path))
    }
    /// Remove a security manager team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/security-managers/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/teams/{team_slug}/delete(orgs/remove-security-manager-team)`.
    @available(*, deprecated)
    public func orgsRemoveSecurityManagerTeam(path: Operations.OrgsRemoveSecurityManagerTeam.Input.Path) async throws -> Operations.OrgsRemoveSecurityManagerTeam.Output {
        try await orgsRemoveSecurityManagerTeam(Operations.OrgsRemoveSecurityManagerTeam.Input(path: path))
    }
    /// Enable or disable a security feature for an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** The ability to enable or disable a security feature for all eligible repositories in an organization is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-07-22-deprecation-of-api-endpoint-to-enable-or-disable-a-security-feature-for-an-organization/).
    ///
    /// Enables or disables the specified security feature for all eligible repositories in an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// The authenticated user must be an organization owner or be member of a team with the security manager role to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org`, `write:org`, or `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/{security_product}/{enablement}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/{security_product}/{enablement}/post(orgs/enable-or-disable-security-product-on-all-org-repos)`.
    @available(*, deprecated)
    public func orgsEnableOrDisableSecurityProductOnAllOrgRepos(
        path: Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Input.Path,
        body: Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Input.Body? = nil
    ) async throws -> Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Output {
        try await orgsEnableOrDisableSecurityProductOnAllOrgRepos(Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Input(
            path: path,
            body: body
        ))
    }
    /// List organization memberships for the authenticated user
    ///
    /// Lists all of the authenticated user's organization memberships.
    ///
    /// - Remark: HTTP `GET /user/memberships/orgs`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/get(orgs/list-memberships-for-authenticated-user)`.
    public func orgsListMembershipsForAuthenticatedUser(
        query: Operations.OrgsListMembershipsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.OrgsListMembershipsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsListMembershipsForAuthenticatedUser.Output {
        try await orgsListMembershipsForAuthenticatedUser(Operations.OrgsListMembershipsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get an organization membership for the authenticated user
    ///
    /// If the authenticated user is an active or pending member of the organization, this endpoint will return the user's membership. If the authenticated user is not affiliated with the organization, a `404` is returned. This endpoint will return a `403` if the request is made by a GitHub App that is blocked by the organization.
    ///
    /// - Remark: HTTP `GET /user/memberships/orgs/{org}`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/{org}/get(orgs/get-membership-for-authenticated-user)`.
    public func orgsGetMembershipForAuthenticatedUser(
        path: Operations.OrgsGetMembershipForAuthenticatedUser.Input.Path,
        headers: Operations.OrgsGetMembershipForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsGetMembershipForAuthenticatedUser.Output {
        try await orgsGetMembershipForAuthenticatedUser(Operations.OrgsGetMembershipForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an organization membership for the authenticated user
    ///
    /// Converts the authenticated user to an active member of the organization, if that user has a pending invitation from the organization.
    ///
    /// - Remark: HTTP `PATCH /user/memberships/orgs/{org}`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/{org}/patch(orgs/update-membership-for-authenticated-user)`.
    public func orgsUpdateMembershipForAuthenticatedUser(
        path: Operations.OrgsUpdateMembershipForAuthenticatedUser.Input.Path,
        headers: Operations.OrgsUpdateMembershipForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.OrgsUpdateMembershipForAuthenticatedUser.Input.Body
    ) async throws -> Operations.OrgsUpdateMembershipForAuthenticatedUser.Output {
        try await orgsUpdateMembershipForAuthenticatedUser(Operations.OrgsUpdateMembershipForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List organizations for the authenticated user
    ///
    /// List organizations for the authenticated user.
    ///
    /// For OAuth app tokens and personal access tokens (classic), this endpoint only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope for OAuth app tokens and personal access tokens (classic). Requests with insufficient scope will receive a `403 Forbidden` response.
    ///
    /// > [!NOTE]
    /// > Requests using a fine-grained access token will receive a `200 Success` response with an empty list.
    ///
    /// - Remark: HTTP `GET /user/orgs`.
    /// - Remark: Generated from `#/paths//user/orgs/get(orgs/list-for-authenticated-user)`.
    public func orgsListForAuthenticatedUser(
        query: Operations.OrgsListForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.OrgsListForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsListForAuthenticatedUser.Output {
        try await orgsListForAuthenticatedUser(Operations.OrgsListForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// List organizations for a user
    ///
    /// List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
    ///
    /// This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user) API instead.
    ///
    /// - Remark: HTTP `GET /users/{username}/orgs`.
    /// - Remark: Generated from `#/paths//users/{username}/orgs/get(orgs/list-for-user)`.
    public func orgsListForUser(
        path: Operations.OrgsListForUser.Input.Path,
        query: Operations.OrgsListForUser.Input.Query = .init(),
        headers: Operations.OrgsListForUser.Input.Headers = .init()
    ) async throws -> Operations.OrgsListForUser.Output {
        try await orgsListForUser(Operations.OrgsListForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// The URL to which the payloads will be delivered.
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-url`.
        public typealias WebhookConfigUrl = Swift.String
        /// The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-content-type`.
        public typealias WebhookConfigContentType = Swift.String
        /// If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-secret`.
        public typealias WebhookConfigSecret = Swift.String
        /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl`.
        @frozen public enum WebhookConfigInsecureSsl: Codable, Hashable, Sendable {
            /// Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
            ///
            /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl/case1`.
            case case1(Swift.String)
            /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl/case2`.
            case case2(Swift.Double)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case2(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try encoder.encodeToSingleValueContainer(value)
                case let .case2(value):
                    try encoder.encodeToSingleValueContainer(value)
                }
            }
        }
        /// Configuration object of the webhook
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config`.
        public struct WebhookConfig: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/webhook-config/url`.
            public var url: Components.Schemas.WebhookConfigUrl?
            /// - Remark: Generated from `#/components/schemas/webhook-config/content_type`.
            public var contentType: Components.Schemas.WebhookConfigContentType?
            /// - Remark: Generated from `#/components/schemas/webhook-config/secret`.
            public var secret: Components.Schemas.WebhookConfigSecret?
            /// - Remark: Generated from `#/components/schemas/webhook-config/insecure_ssl`.
            public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
            /// Creates a new `WebhookConfig`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - contentType:
            ///   - secret:
            ///   - insecureSsl:
            public init(
                url: Components.Schemas.WebhookConfigUrl? = nil,
                contentType: Components.Schemas.WebhookConfigContentType? = nil,
                secret: Components.Schemas.WebhookConfigSecret? = nil,
                insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil
            ) {
                self.url = url
                self.contentType = contentType
                self.secret = secret
                self.insecureSsl = insecureSsl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case contentType = "content_type"
                case secret
                case insecureSsl = "insecure_ssl"
            }
        }
        /// Delivery made by a webhook, without request and response information.
        ///
        /// - Remark: Generated from `#/components/schemas/hook-delivery-item`.
        public struct HookDeliveryItem: Codable, Hashable, Sendable {
            /// Unique identifier of the webhook delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/id`.
            public var id: Swift.Int64
            /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/guid`.
            public var guid: Swift.String
            /// Time when the webhook delivery occurred.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/delivered_at`.
            public var deliveredAt: Foundation.Date
            /// Whether the webhook delivery is a redelivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/redelivery`.
            public var redelivery: Swift.Bool
            /// Time spent delivering.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/duration`.
            public var duration: Swift.Double
            /// Describes the response returned after attempting the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/status`.
            public var status: Swift.String
            /// Status code received when delivery was made.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/status_code`.
            public var statusCode: Swift.Int
            /// The event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/event`.
            public var event: Swift.String
            /// The type of activity for the event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/action`.
            public var action: Swift.String?
            /// The id of the GitHub App installation associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/installation_id`.
            public var installationId: Swift.Int64?
            /// The id of the repository associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/repository_id`.
            public var repositoryId: Swift.Int64?
            /// Time when the webhook delivery was throttled.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/throttled_at`.
            public var throttledAt: Foundation.Date?
            /// Creates a new `HookDeliveryItem`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the webhook delivery.
            ///   - guid: Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///   - deliveredAt: Time when the webhook delivery occurred.
            ///   - redelivery: Whether the webhook delivery is a redelivery.
            ///   - duration: Time spent delivering.
            ///   - status: Describes the response returned after attempting the delivery.
            ///   - statusCode: Status code received when delivery was made.
            ///   - event: The event that triggered the delivery.
            ///   - action: The type of activity for the event that triggered the delivery.
            ///   - installationId: The id of the GitHub App installation associated with this event.
            ///   - repositoryId: The id of the repository associated with this event.
            ///   - throttledAt: Time when the webhook delivery was throttled.
            public init(
                id: Swift.Int64,
                guid: Swift.String,
                deliveredAt: Foundation.Date,
                redelivery: Swift.Bool,
                duration: Swift.Double,
                status: Swift.String,
                statusCode: Swift.Int,
                event: Swift.String,
                action: Swift.String? = nil,
                installationId: Swift.Int64? = nil,
                repositoryId: Swift.Int64? = nil,
                throttledAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.guid = guid
                self.deliveredAt = deliveredAt
                self.redelivery = redelivery
                self.duration = duration
                self.status = status
                self.statusCode = statusCode
                self.event = event
                self.action = action
                self.installationId = installationId
                self.repositoryId = repositoryId
                self.throttledAt = throttledAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case guid
                case deliveredAt = "delivered_at"
                case redelivery
                case duration
                case status
                case statusCode = "status_code"
                case event
                case action
                case installationId = "installation_id"
                case repositoryId = "repository_id"
                case throttledAt = "throttled_at"
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Delivery made by a webhook.
        ///
        /// - Remark: Generated from `#/components/schemas/hook-delivery`.
        public struct HookDelivery: Codable, Hashable, Sendable {
            /// Unique identifier of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/id`.
            public var id: Swift.Int
            /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/guid`.
            public var guid: Swift.String
            /// Time when the delivery was delivered.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/delivered_at`.
            public var deliveredAt: Foundation.Date
            /// Whether the delivery is a redelivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/redelivery`.
            public var redelivery: Swift.Bool
            /// Time spent delivering.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/duration`.
            public var duration: Swift.Double
            /// Description of the status of the attempted delivery
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/status`.
            public var status: Swift.String
            /// Status code received when delivery was made.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/status_code`.
            public var statusCode: Swift.Int
            /// The event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/event`.
            public var event: Swift.String
            /// The type of activity for the event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/action`.
            public var action: Swift.String?
            /// The id of the GitHub App installation associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/installation_id`.
            public var installationId: Swift.Int?
            /// The id of the repository associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/repository_id`.
            public var repositoryId: Swift.Int?
            /// Time when the webhook delivery was throttled.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/throttled_at`.
            public var throttledAt: Foundation.Date?
            /// The URL target of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/hook-delivery/request`.
            public struct RequestPayload: Codable, Hashable, Sendable {
                /// The request headers sent with the webhook delivery.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/headers`.
                public struct HeadersPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `HeadersPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The request headers sent with the webhook delivery.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/headers`.
                public var headers: Components.Schemas.HookDelivery.RequestPayload.HeadersPayload?
                /// The webhook payload.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/payload`.
                public struct PayloadPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `PayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The webhook payload.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/payload`.
                public var payload: Components.Schemas.HookDelivery.RequestPayload.PayloadPayload?
                /// Creates a new `RequestPayload`.
                ///
                /// - Parameters:
                ///   - headers: The request headers sent with the webhook delivery.
                ///   - payload: The webhook payload.
                public init(
                    headers: Components.Schemas.HookDelivery.RequestPayload.HeadersPayload? = nil,
                    payload: Components.Schemas.HookDelivery.RequestPayload.PayloadPayload? = nil
                ) {
                    self.headers = headers
                    self.payload = payload
                }
                public enum CodingKeys: String, CodingKey {
                    case headers
                    case payload
                }
            }
            /// - Remark: Generated from `#/components/schemas/hook-delivery/request`.
            public var request: Components.Schemas.HookDelivery.RequestPayload
            /// - Remark: Generated from `#/components/schemas/hook-delivery/response`.
            public struct ResponsePayload: Codable, Hashable, Sendable {
                /// The response headers received when the delivery was made.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/headers`.
                public struct HeadersPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `HeadersPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The response headers received when the delivery was made.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/headers`.
                public var headers: Components.Schemas.HookDelivery.ResponsePayload.HeadersPayload?
                /// The response payload received.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/payload`.
                public var payload: Swift.String?
                /// Creates a new `ResponsePayload`.
                ///
                /// - Parameters:
                ///   - headers: The response headers received when the delivery was made.
                ///   - payload: The response payload received.
                public init(
                    headers: Components.Schemas.HookDelivery.ResponsePayload.HeadersPayload? = nil,
                    payload: Swift.String? = nil
                ) {
                    self.headers = headers
                    self.payload = payload
                }
                public enum CodingKeys: String, CodingKey {
                    case headers
                    case payload
                }
            }
            /// - Remark: Generated from `#/components/schemas/hook-delivery/response`.
            public var response: Components.Schemas.HookDelivery.ResponsePayload
            /// Creates a new `HookDelivery`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the delivery.
            ///   - guid: Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///   - deliveredAt: Time when the delivery was delivered.
            ///   - redelivery: Whether the delivery is a redelivery.
            ///   - duration: Time spent delivering.
            ///   - status: Description of the status of the attempted delivery
            ///   - statusCode: Status code received when delivery was made.
            ///   - event: The event that triggered the delivery.
            ///   - action: The type of activity for the event that triggered the delivery.
            ///   - installationId: The id of the GitHub App installation associated with this event.
            ///   - repositoryId: The id of the repository associated with this event.
            ///   - throttledAt: Time when the webhook delivery was throttled.
            ///   - url: The URL target of the delivery.
            ///   - request:
            ///   - response:
            public init(
                id: Swift.Int,
                guid: Swift.String,
                deliveredAt: Foundation.Date,
                redelivery: Swift.Bool,
                duration: Swift.Double,
                status: Swift.String,
                statusCode: Swift.Int,
                event: Swift.String,
                action: Swift.String? = nil,
                installationId: Swift.Int? = nil,
                repositoryId: Swift.Int? = nil,
                throttledAt: Foundation.Date? = nil,
                url: Swift.String? = nil,
                request: Components.Schemas.HookDelivery.RequestPayload,
                response: Components.Schemas.HookDelivery.ResponsePayload
            ) {
                self.id = id
                self.guid = guid
                self.deliveredAt = deliveredAt
                self.redelivery = redelivery
                self.duration = duration
                self.status = status
                self.statusCode = statusCode
                self.event = event
                self.action = action
                self.installationId = installationId
                self.repositoryId = repositoryId
                self.throttledAt = throttledAt
                self.url = url
                self.request = request
                self.response = response
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case guid
                case deliveredAt = "delivered_at"
                case redelivery
                case duration
                case status
                case statusCode = "status_code"
                case event
                case action
                case installationId = "installation_id"
                case repositoryId = "repository_id"
                case throttledAt = "throttled_at"
                case url
                case request
                case response
            }
        }
        /// The permissions granted to the user access token.
        ///
        /// - Remark: Generated from `#/components/schemas/app-permissions`.
        public struct AppPermissions: Codable, Hashable, Sendable {
            /// The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/actions`.
            @frozen public enum ActionsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/actions`.
            public var actions: Components.Schemas.AppPermissions.ActionsPayload?
            /// The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/administration`.
            @frozen public enum AdministrationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/administration`.
            public var administration: Components.Schemas.AppPermissions.AdministrationPayload?
            /// The level of permission to grant the access token for checks on code.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/checks`.
            @frozen public enum ChecksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for checks on code.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/checks`.
            public var checks: Components.Schemas.AppPermissions.ChecksPayload?
            /// The level of permission to grant the access token to create, edit, delete, and list Codespaces.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/codespaces`.
            @frozen public enum CodespacesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to create, edit, delete, and list Codespaces.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/codespaces`.
            public var codespaces: Components.Schemas.AppPermissions.CodespacesPayload?
            /// The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/contents`.
            @frozen public enum ContentsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/contents`.
            public var contents: Components.Schemas.AppPermissions.ContentsPayload?
            /// The level of permission to grant the access token to manage Dependabot secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/dependabot_secrets`.
            @frozen public enum DependabotSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage Dependabot secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/dependabot_secrets`.
            public var dependabotSecrets: Components.Schemas.AppPermissions.DependabotSecretsPayload?
            /// The level of permission to grant the access token for deployments and deployment statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/deployments`.
            @frozen public enum DeploymentsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for deployments and deployment statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/deployments`.
            public var deployments: Components.Schemas.AppPermissions.DeploymentsPayload?
            /// The level of permission to grant the access token for managing repository environments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/environments`.
            @frozen public enum EnvironmentsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for managing repository environments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/environments`.
            public var environments: Components.Schemas.AppPermissions.EnvironmentsPayload?
            /// The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/issues`.
            @frozen public enum IssuesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/issues`.
            public var issues: Components.Schemas.AppPermissions.IssuesPayload?
            /// The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/metadata`.
            @frozen public enum MetadataPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/metadata`.
            public var metadata: Components.Schemas.AppPermissions.MetadataPayload?
            /// The level of permission to grant the access token for packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/packages`.
            @frozen public enum PackagesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/packages`.
            public var packages: Components.Schemas.AppPermissions.PackagesPayload?
            /// The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pages`.
            @frozen public enum PagesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pages`.
            public var pages: Components.Schemas.AppPermissions.PagesPayload?
            /// The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pull_requests`.
            @frozen public enum PullRequestsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/pull_requests`.
            public var pullRequests: Components.Schemas.AppPermissions.PullRequestsPayload?
            /// The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_custom_properties`.
            @frozen public enum RepositoryCustomPropertiesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_custom_properties`.
            public var repositoryCustomProperties: Components.Schemas.AppPermissions.RepositoryCustomPropertiesPayload?
            /// The level of permission to grant the access token to manage the post-receive hooks for a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_hooks`.
            @frozen public enum RepositoryHooksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the post-receive hooks for a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_hooks`.
            public var repositoryHooks: Components.Schemas.AppPermissions.RepositoryHooksPayload?
            /// The level of permission to grant the access token to manage repository projects, columns, and cards.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_projects`.
            @frozen public enum RepositoryProjectsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
            }
            /// The level of permission to grant the access token to manage repository projects, columns, and cards.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/repository_projects`.
            public var repositoryProjects: Components.Schemas.AppPermissions.RepositoryProjectsPayload?
            /// The level of permission to grant the access token to view and manage secret scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secret_scanning_alerts`.
            @frozen public enum SecretScanningAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage secret scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secret_scanning_alerts`.
            public var secretScanningAlerts: Components.Schemas.AppPermissions.SecretScanningAlertsPayload?
            /// The level of permission to grant the access token to manage repository secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secrets`.
            @frozen public enum SecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage repository secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/secrets`.
            public var secrets: Components.Schemas.AppPermissions.SecretsPayload?
            /// The level of permission to grant the access token to view and manage security events like code scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/security_events`.
            @frozen public enum SecurityEventsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage security events like code scanning alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/security_events`.
            public var securityEvents: Components.Schemas.AppPermissions.SecurityEventsPayload?
            /// The level of permission to grant the access token to manage just a single file.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/single_file`.
            @frozen public enum SingleFilePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage just a single file.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/single_file`.
            public var singleFile: Components.Schemas.AppPermissions.SingleFilePayload?
            /// The level of permission to grant the access token for commit statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/statuses`.
            @frozen public enum StatusesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for commit statuses.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/statuses`.
            public var statuses: Components.Schemas.AppPermissions.StatusesPayload?
            /// The level of permission to grant the access token to manage Dependabot alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/vulnerability_alerts`.
            @frozen public enum VulnerabilityAlertsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage Dependabot alerts.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/vulnerability_alerts`.
            public var vulnerabilityAlerts: Components.Schemas.AppPermissions.VulnerabilityAlertsPayload?
            /// The level of permission to grant the access token to update GitHub Actions workflow files.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/workflows`.
            @frozen public enum WorkflowsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case write = "write"
            }
            /// The level of permission to grant the access token to update GitHub Actions workflow files.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/workflows`.
            public var workflows: Components.Schemas.AppPermissions.WorkflowsPayload?
            /// The level of permission to grant the access token for organization teams and members.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/members`.
            @frozen public enum MembersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for organization teams and members.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/members`.
            public var members: Components.Schemas.AppPermissions.MembersPayload?
            /// The level of permission to grant the access token to manage access to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_administration`.
            @frozen public enum OrganizationAdministrationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage access to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_administration`.
            public var organizationAdministration: Components.Schemas.AppPermissions.OrganizationAdministrationPayload?
            /// The level of permission to grant the access token for custom repository roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_roles`.
            @frozen public enum OrganizationCustomRolesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for custom repository roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_roles`.
            public var organizationCustomRoles: Components.Schemas.AppPermissions.OrganizationCustomRolesPayload?
            /// The level of permission to grant the access token for custom organization roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_org_roles`.
            @frozen public enum OrganizationCustomOrgRolesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for custom organization roles management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_org_roles`.
            public var organizationCustomOrgRoles: Components.Schemas.AppPermissions.OrganizationCustomOrgRolesPayload?
            /// The level of permission to grant the access token for custom property management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_properties`.
            @frozen public enum OrganizationCustomPropertiesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
            }
            /// The level of permission to grant the access token for custom property management.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_custom_properties`.
            public var organizationCustomProperties: Components.Schemas.AppPermissions.OrganizationCustomPropertiesPayload?
            /// The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_copilot_seat_management`.
            @frozen public enum OrganizationCopilotSeatManagementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case write = "write"
            }
            /// The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_copilot_seat_management`.
            public var organizationCopilotSeatManagement: Components.Schemas.AppPermissions.OrganizationCopilotSeatManagementPayload?
            /// The level of permission to grant the access token to view and manage announcement banners for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_announcement_banners`.
            @frozen public enum OrganizationAnnouncementBannersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage announcement banners for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_announcement_banners`.
            public var organizationAnnouncementBanners: Components.Schemas.AppPermissions.OrganizationAnnouncementBannersPayload?
            /// The level of permission to grant the access token to view events triggered by an activity in an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_events`.
            @frozen public enum OrganizationEventsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
            }
            /// The level of permission to grant the access token to view events triggered by an activity in an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_events`.
            public var organizationEvents: Components.Schemas.AppPermissions.OrganizationEventsPayload?
            /// The level of permission to grant the access token to manage the post-receive hooks for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_hooks`.
            @frozen public enum OrganizationHooksPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the post-receive hooks for an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_hooks`.
            public var organizationHooks: Components.Schemas.AppPermissions.OrganizationHooksPayload?
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_tokens`.
            @frozen public enum OrganizationPersonalAccessTokensPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_tokens`.
            public var organizationPersonalAccessTokens: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokensPayload?
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_token_requests`.
            @frozen public enum OrganizationPersonalAccessTokenRequestsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_personal_access_token_requests`.
            public var organizationPersonalAccessTokenRequests: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokenRequestsPayload?
            /// The level of permission to grant the access token for viewing an organization's plan.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_plan`.
            @frozen public enum OrganizationPlanPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
            }
            /// The level of permission to grant the access token for viewing an organization's plan.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_plan`.
            public var organizationPlan: Components.Schemas.AppPermissions.OrganizationPlanPayload?
            /// The level of permission to grant the access token to manage organization projects and projects public preview (where available).
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_projects`.
            @frozen public enum OrganizationProjectsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
            }
            /// The level of permission to grant the access token to manage organization projects and projects public preview (where available).
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_projects`.
            public var organizationProjects: Components.Schemas.AppPermissions.OrganizationProjectsPayload?
            /// The level of permission to grant the access token for organization packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_packages`.
            @frozen public enum OrganizationPackagesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token for organization packages published to GitHub Packages.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_packages`.
            public var organizationPackages: Components.Schemas.AppPermissions.OrganizationPackagesPayload?
            /// The level of permission to grant the access token to manage organization secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_secrets`.
            @frozen public enum OrganizationSecretsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage organization secrets.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_secrets`.
            public var organizationSecrets: Components.Schemas.AppPermissions.OrganizationSecretsPayload?
            /// The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_self_hosted_runners`.
            @frozen public enum OrganizationSelfHostedRunnersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_self_hosted_runners`.
            public var organizationSelfHostedRunners: Components.Schemas.AppPermissions.OrganizationSelfHostedRunnersPayload?
            /// The level of permission to grant the access token to view and manage users blocked by the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_user_blocking`.
            @frozen public enum OrganizationUserBlockingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage users blocked by the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/organization_user_blocking`.
            public var organizationUserBlocking: Components.Schemas.AppPermissions.OrganizationUserBlockingPayload?
            /// The level of permission to grant the access token to manage team discussions and related comments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/team_discussions`.
            @frozen public enum TeamDiscussionsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage team discussions and related comments.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/team_discussions`.
            public var teamDiscussions: Components.Schemas.AppPermissions.TeamDiscussionsPayload?
            /// The level of permission to grant the access token to manage the email addresses belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/email_addresses`.
            @frozen public enum EmailAddressesPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the email addresses belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/email_addresses`.
            public var emailAddresses: Components.Schemas.AppPermissions.EmailAddressesPayload?
            /// The level of permission to grant the access token to manage the followers belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/followers`.
            @frozen public enum FollowersPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the followers belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/followers`.
            public var followers: Components.Schemas.AppPermissions.FollowersPayload?
            /// The level of permission to grant the access token to manage git SSH keys.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/git_ssh_keys`.
            @frozen public enum GitSshKeysPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to manage git SSH keys.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/git_ssh_keys`.
            public var gitSshKeys: Components.Schemas.AppPermissions.GitSshKeysPayload?
            /// The level of permission to grant the access token to view and manage GPG keys belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/gpg_keys`.
            @frozen public enum GpgKeysPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage GPG keys belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/gpg_keys`.
            public var gpgKeys: Components.Schemas.AppPermissions.GpgKeysPayload?
            /// The level of permission to grant the access token to view and manage interaction limits on a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/interaction_limits`.
            @frozen public enum InteractionLimitsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to view and manage interaction limits on a repository.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/interaction_limits`.
            public var interactionLimits: Components.Schemas.AppPermissions.InteractionLimitsPayload?
            /// The level of permission to grant the access token to manage the profile settings belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/profile`.
            @frozen public enum ProfilePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case write = "write"
            }
            /// The level of permission to grant the access token to manage the profile settings belonging to a user.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/profile`.
            public var profile: Components.Schemas.AppPermissions.ProfilePayload?
            /// The level of permission to grant the access token to list and manage repositories a user is starring.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/starring`.
            @frozen public enum StarringPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
            }
            /// The level of permission to grant the access token to list and manage repositories a user is starring.
            ///
            /// - Remark: Generated from `#/components/schemas/app-permissions/starring`.
            public var starring: Components.Schemas.AppPermissions.StarringPayload?
            /// Creates a new `AppPermissions`.
            ///
            /// - Parameters:
            ///   - actions: The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
            ///   - administration: The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
            ///   - checks: The level of permission to grant the access token for checks on code.
            ///   - codespaces: The level of permission to grant the access token to create, edit, delete, and list Codespaces.
            ///   - contents: The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
            ///   - dependabotSecrets: The level of permission to grant the access token to manage Dependabot secrets.
            ///   - deployments: The level of permission to grant the access token for deployments and deployment statuses.
            ///   - environments: The level of permission to grant the access token for managing repository environments.
            ///   - issues: The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
            ///   - metadata: The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
            ///   - packages: The level of permission to grant the access token for packages published to GitHub Packages.
            ///   - pages: The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
            ///   - pullRequests: The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
            ///   - repositoryCustomProperties: The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
            ///   - repositoryHooks: The level of permission to grant the access token to manage the post-receive hooks for a repository.
            ///   - repositoryProjects: The level of permission to grant the access token to manage repository projects, columns, and cards.
            ///   - secretScanningAlerts: The level of permission to grant the access token to view and manage secret scanning alerts.
            ///   - secrets: The level of permission to grant the access token to manage repository secrets.
            ///   - securityEvents: The level of permission to grant the access token to view and manage security events like code scanning alerts.
            ///   - singleFile: The level of permission to grant the access token to manage just a single file.
            ///   - statuses: The level of permission to grant the access token for commit statuses.
            ///   - vulnerabilityAlerts: The level of permission to grant the access token to manage Dependabot alerts.
            ///   - workflows: The level of permission to grant the access token to update GitHub Actions workflow files.
            ///   - members: The level of permission to grant the access token for organization teams and members.
            ///   - organizationAdministration: The level of permission to grant the access token to manage access to an organization.
            ///   - organizationCustomRoles: The level of permission to grant the access token for custom repository roles management.
            ///   - organizationCustomOrgRoles: The level of permission to grant the access token for custom organization roles management.
            ///   - organizationCustomProperties: The level of permission to grant the access token for custom property management.
            ///   - organizationCopilotSeatManagement: The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
            ///   - organizationAnnouncementBanners: The level of permission to grant the access token to view and manage announcement banners for an organization.
            ///   - organizationEvents: The level of permission to grant the access token to view events triggered by an activity in an organization.
            ///   - organizationHooks: The level of permission to grant the access token to manage the post-receive hooks for an organization.
            ///   - organizationPersonalAccessTokens: The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
            ///   - organizationPersonalAccessTokenRequests: The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
            ///   - organizationPlan: The level of permission to grant the access token for viewing an organization's plan.
            ///   - organizationProjects: The level of permission to grant the access token to manage organization projects and projects public preview (where available).
            ///   - organizationPackages: The level of permission to grant the access token for organization packages published to GitHub Packages.
            ///   - organizationSecrets: The level of permission to grant the access token to manage organization secrets.
            ///   - organizationSelfHostedRunners: The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
            ///   - organizationUserBlocking: The level of permission to grant the access token to view and manage users blocked by the organization.
            ///   - teamDiscussions: The level of permission to grant the access token to manage team discussions and related comments.
            ///   - emailAddresses: The level of permission to grant the access token to manage the email addresses belonging to a user.
            ///   - followers: The level of permission to grant the access token to manage the followers belonging to a user.
            ///   - gitSshKeys: The level of permission to grant the access token to manage git SSH keys.
            ///   - gpgKeys: The level of permission to grant the access token to view and manage GPG keys belonging to a user.
            ///   - interactionLimits: The level of permission to grant the access token to view and manage interaction limits on a repository.
            ///   - profile: The level of permission to grant the access token to manage the profile settings belonging to a user.
            ///   - starring: The level of permission to grant the access token to list and manage repositories a user is starring.
            public init(
                actions: Components.Schemas.AppPermissions.ActionsPayload? = nil,
                administration: Components.Schemas.AppPermissions.AdministrationPayload? = nil,
                checks: Components.Schemas.AppPermissions.ChecksPayload? = nil,
                codespaces: Components.Schemas.AppPermissions.CodespacesPayload? = nil,
                contents: Components.Schemas.AppPermissions.ContentsPayload? = nil,
                dependabotSecrets: Components.Schemas.AppPermissions.DependabotSecretsPayload? = nil,
                deployments: Components.Schemas.AppPermissions.DeploymentsPayload? = nil,
                environments: Components.Schemas.AppPermissions.EnvironmentsPayload? = nil,
                issues: Components.Schemas.AppPermissions.IssuesPayload? = nil,
                metadata: Components.Schemas.AppPermissions.MetadataPayload? = nil,
                packages: Components.Schemas.AppPermissions.PackagesPayload? = nil,
                pages: Components.Schemas.AppPermissions.PagesPayload? = nil,
                pullRequests: Components.Schemas.AppPermissions.PullRequestsPayload? = nil,
                repositoryCustomProperties: Components.Schemas.AppPermissions.RepositoryCustomPropertiesPayload? = nil,
                repositoryHooks: Components.Schemas.AppPermissions.RepositoryHooksPayload? = nil,
                repositoryProjects: Components.Schemas.AppPermissions.RepositoryProjectsPayload? = nil,
                secretScanningAlerts: Components.Schemas.AppPermissions.SecretScanningAlertsPayload? = nil,
                secrets: Components.Schemas.AppPermissions.SecretsPayload? = nil,
                securityEvents: Components.Schemas.AppPermissions.SecurityEventsPayload? = nil,
                singleFile: Components.Schemas.AppPermissions.SingleFilePayload? = nil,
                statuses: Components.Schemas.AppPermissions.StatusesPayload? = nil,
                vulnerabilityAlerts: Components.Schemas.AppPermissions.VulnerabilityAlertsPayload? = nil,
                workflows: Components.Schemas.AppPermissions.WorkflowsPayload? = nil,
                members: Components.Schemas.AppPermissions.MembersPayload? = nil,
                organizationAdministration: Components.Schemas.AppPermissions.OrganizationAdministrationPayload? = nil,
                organizationCustomRoles: Components.Schemas.AppPermissions.OrganizationCustomRolesPayload? = nil,
                organizationCustomOrgRoles: Components.Schemas.AppPermissions.OrganizationCustomOrgRolesPayload? = nil,
                organizationCustomProperties: Components.Schemas.AppPermissions.OrganizationCustomPropertiesPayload? = nil,
                organizationCopilotSeatManagement: Components.Schemas.AppPermissions.OrganizationCopilotSeatManagementPayload? = nil,
                organizationAnnouncementBanners: Components.Schemas.AppPermissions.OrganizationAnnouncementBannersPayload? = nil,
                organizationEvents: Components.Schemas.AppPermissions.OrganizationEventsPayload? = nil,
                organizationHooks: Components.Schemas.AppPermissions.OrganizationHooksPayload? = nil,
                organizationPersonalAccessTokens: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokensPayload? = nil,
                organizationPersonalAccessTokenRequests: Components.Schemas.AppPermissions.OrganizationPersonalAccessTokenRequestsPayload? = nil,
                organizationPlan: Components.Schemas.AppPermissions.OrganizationPlanPayload? = nil,
                organizationProjects: Components.Schemas.AppPermissions.OrganizationProjectsPayload? = nil,
                organizationPackages: Components.Schemas.AppPermissions.OrganizationPackagesPayload? = nil,
                organizationSecrets: Components.Schemas.AppPermissions.OrganizationSecretsPayload? = nil,
                organizationSelfHostedRunners: Components.Schemas.AppPermissions.OrganizationSelfHostedRunnersPayload? = nil,
                organizationUserBlocking: Components.Schemas.AppPermissions.OrganizationUserBlockingPayload? = nil,
                teamDiscussions: Components.Schemas.AppPermissions.TeamDiscussionsPayload? = nil,
                emailAddresses: Components.Schemas.AppPermissions.EmailAddressesPayload? = nil,
                followers: Components.Schemas.AppPermissions.FollowersPayload? = nil,
                gitSshKeys: Components.Schemas.AppPermissions.GitSshKeysPayload? = nil,
                gpgKeys: Components.Schemas.AppPermissions.GpgKeysPayload? = nil,
                interactionLimits: Components.Schemas.AppPermissions.InteractionLimitsPayload? = nil,
                profile: Components.Schemas.AppPermissions.ProfilePayload? = nil,
                starring: Components.Schemas.AppPermissions.StarringPayload? = nil
            ) {
                self.actions = actions
                self.administration = administration
                self.checks = checks
                self.codespaces = codespaces
                self.contents = contents
                self.dependabotSecrets = dependabotSecrets
                self.deployments = deployments
                self.environments = environments
                self.issues = issues
                self.metadata = metadata
                self.packages = packages
                self.pages = pages
                self.pullRequests = pullRequests
                self.repositoryCustomProperties = repositoryCustomProperties
                self.repositoryHooks = repositoryHooks
                self.repositoryProjects = repositoryProjects
                self.secretScanningAlerts = secretScanningAlerts
                self.secrets = secrets
                self.securityEvents = securityEvents
                self.singleFile = singleFile
                self.statuses = statuses
                self.vulnerabilityAlerts = vulnerabilityAlerts
                self.workflows = workflows
                self.members = members
                self.organizationAdministration = organizationAdministration
                self.organizationCustomRoles = organizationCustomRoles
                self.organizationCustomOrgRoles = organizationCustomOrgRoles
                self.organizationCustomProperties = organizationCustomProperties
                self.organizationCopilotSeatManagement = organizationCopilotSeatManagement
                self.organizationAnnouncementBanners = organizationAnnouncementBanners
                self.organizationEvents = organizationEvents
                self.organizationHooks = organizationHooks
                self.organizationPersonalAccessTokens = organizationPersonalAccessTokens
                self.organizationPersonalAccessTokenRequests = organizationPersonalAccessTokenRequests
                self.organizationPlan = organizationPlan
                self.organizationProjects = organizationProjects
                self.organizationPackages = organizationPackages
                self.organizationSecrets = organizationSecrets
                self.organizationSelfHostedRunners = organizationSelfHostedRunners
                self.organizationUserBlocking = organizationUserBlocking
                self.teamDiscussions = teamDiscussions
                self.emailAddresses = emailAddresses
                self.followers = followers
                self.gitSshKeys = gitSshKeys
                self.gpgKeys = gpgKeys
                self.interactionLimits = interactionLimits
                self.profile = profile
                self.starring = starring
            }
            public enum CodingKeys: String, CodingKey {
                case actions
                case administration
                case checks
                case codespaces
                case contents
                case dependabotSecrets = "dependabot_secrets"
                case deployments
                case environments
                case issues
                case metadata
                case packages
                case pages
                case pullRequests = "pull_requests"
                case repositoryCustomProperties = "repository_custom_properties"
                case repositoryHooks = "repository_hooks"
                case repositoryProjects = "repository_projects"
                case secretScanningAlerts = "secret_scanning_alerts"
                case secrets
                case securityEvents = "security_events"
                case singleFile = "single_file"
                case statuses
                case vulnerabilityAlerts = "vulnerability_alerts"
                case workflows
                case members
                case organizationAdministration = "organization_administration"
                case organizationCustomRoles = "organization_custom_roles"
                case organizationCustomOrgRoles = "organization_custom_org_roles"
                case organizationCustomProperties = "organization_custom_properties"
                case organizationCopilotSeatManagement = "organization_copilot_seat_management"
                case organizationAnnouncementBanners = "organization_announcement_banners"
                case organizationEvents = "organization_events"
                case organizationHooks = "organization_hooks"
                case organizationPersonalAccessTokens = "organization_personal_access_tokens"
                case organizationPersonalAccessTokenRequests = "organization_personal_access_token_requests"
                case organizationPlan = "organization_plan"
                case organizationProjects = "organization_projects"
                case organizationPackages = "organization_packages"
                case organizationSecrets = "organization_secrets"
                case organizationSelfHostedRunners = "organization_self_hosted_runners"
                case organizationUserBlocking = "organization_user_blocking"
                case teamDiscussions = "team_discussions"
                case emailAddresses = "email_addresses"
                case followers
                case gitSshKeys = "git_ssh_keys"
                case gpgKeys = "gpg_keys"
                case interactionLimits = "interaction_limits"
                case profile
                case starring
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Installation
        ///
        /// - Remark: Generated from `#/components/schemas/installation`.
        public struct Installation: Codable, Hashable, Sendable {
            /// The ID of the installation.
            ///
            /// - Remark: Generated from `#/components/schemas/installation/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/installation/account`.
            public struct AccountPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/installation/account/value1`.
                public var value1: Components.Schemas.SimpleUser?
                /// - Remark: Generated from `#/components/schemas/installation/account/value2`.
                public var value2: Components.Schemas.Enterprise?
                /// Creates a new `AccountPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.SimpleUser? = nil,
                    value2: Components.Schemas.Enterprise? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self.value1 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value2 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            self.value1,
                            self.value2
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1?.encode(to: encoder)
                    try self.value2?.encode(to: encoder)
                }
            }
            /// - Remark: Generated from `#/components/schemas/installation/account`.
            public var account: Components.Schemas.Installation.AccountPayload?
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/installation/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case selected = "selected"
            }
            /// Describe whether all repositories have been selected or there's a selection involved
            ///
            /// - Remark: Generated from `#/components/schemas/installation/repository_selection`.
            public var repositorySelection: Components.Schemas.Installation.RepositorySelectionPayload
            /// - Remark: Generated from `#/components/schemas/installation/access_tokens_url`.
            public var accessTokensUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/app_id`.
            public var appId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/installation/client_id`.
            public var clientId: Swift.String?
            /// The ID of the user or organization this token is being scoped to.
            ///
            /// - Remark: Generated from `#/components/schemas/installation/target_id`.
            public var targetId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/installation/target_type`.
            public var targetType: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/permissions`.
            public var permissions: Components.Schemas.AppPermissions
            /// - Remark: Generated from `#/components/schemas/installation/events`.
            public var events: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/installation/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/installation/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/installation/single_file_name`.
            public var singleFileName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/installation/has_multiple_single_files`.
            public var hasMultipleSingleFiles: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/installation/single_file_paths`.
            public var singleFilePaths: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/installation/app_slug`.
            public var appSlug: Swift.String
            /// - Remark: Generated from `#/components/schemas/installation/suspended_by`.
            public var suspendedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/installation/suspended_at`.
            public var suspendedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/installation/contact_email`.
            public var contactEmail: Swift.String?
            /// Creates a new `Installation`.
            ///
            /// - Parameters:
            ///   - id: The ID of the installation.
            ///   - account:
            ///   - repositorySelection: Describe whether all repositories have been selected or there's a selection involved
            ///   - accessTokensUrl:
            ///   - repositoriesUrl:
            ///   - htmlUrl:
            ///   - appId:
            ///   - clientId:
            ///   - targetId: The ID of the user or organization this token is being scoped to.
            ///   - targetType:
            ///   - permissions:
            ///   - events:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - singleFileName:
            ///   - hasMultipleSingleFiles:
            ///   - singleFilePaths:
            ///   - appSlug:
            ///   - suspendedBy:
            ///   - suspendedAt:
            ///   - contactEmail:
            public init(
                id: Swift.Int,
                account: Components.Schemas.Installation.AccountPayload? = nil,
                repositorySelection: Components.Schemas.Installation.RepositorySelectionPayload,
                accessTokensUrl: Swift.String,
                repositoriesUrl: Swift.String,
                htmlUrl: Swift.String,
                appId: Swift.Int,
                clientId: Swift.String? = nil,
                targetId: Swift.Int,
                targetType: Swift.String,
                permissions: Components.Schemas.AppPermissions,
                events: [Swift.String],
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                singleFileName: Swift.String? = nil,
                hasMultipleSingleFiles: Swift.Bool? = nil,
                singleFilePaths: [Swift.String]? = nil,
                appSlug: Swift.String,
                suspendedBy: Components.Schemas.NullableSimpleUser? = nil,
                suspendedAt: Foundation.Date? = nil,
                contactEmail: Swift.String? = nil
            ) {
                self.id = id
                self.account = account
                self.repositorySelection = repositorySelection
                self.accessTokensUrl = accessTokensUrl
                self.repositoriesUrl = repositoriesUrl
                self.htmlUrl = htmlUrl
                self.appId = appId
                self.clientId = clientId
                self.targetId = targetId
                self.targetType = targetType
                self.permissions = permissions
                self.events = events
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.singleFileName = singleFileName
                self.hasMultipleSingleFiles = hasMultipleSingleFiles
                self.singleFilePaths = singleFilePaths
                self.appSlug = appSlug
                self.suspendedBy = suspendedBy
                self.suspendedAt = suspendedAt
                self.contactEmail = contactEmail
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case account
                case repositorySelection = "repository_selection"
                case accessTokensUrl = "access_tokens_url"
                case repositoriesUrl = "repositories_url"
                case htmlUrl = "html_url"
                case appId = "app_id"
                case clientId = "client_id"
                case targetId = "target_id"
                case targetType = "target_type"
                case permissions
                case events
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case singleFileName = "single_file_name"
                case hasMultipleSingleFiles = "has_multiple_single_files"
                case singleFilePaths = "single_file_paths"
                case appSlug = "app_slug"
                case suspendedBy = "suspended_by"
                case suspendedAt = "suspended_at"
                case contactEmail = "contact_email"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// The type of issue.
        ///
        /// - Remark: Generated from `#/components/schemas/issue-type`.
        public struct IssueType: Codable, Hashable, Sendable {
            /// The unique identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/id`.
            public var id: Swift.Int
            /// The node identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/node_id`.
            public var nodeId: Swift.String
            /// The name of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/name`.
            public var name: Swift.String
            /// The description of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/description`.
            public var description: Swift.String?
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            @frozen public enum ColorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case gray = "gray"
                case blue = "blue"
                case green = "green"
                case yellow = "yellow"
                case orange = "orange"
                case red = "red"
                case pink = "pink"
                case purple = "purple"
            }
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            public var color: Components.Schemas.IssueType.ColorPayload?
            /// The time the issue type created.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/created_at`.
            public var createdAt: Foundation.Date?
            /// The time the issue type last updated.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The enabled state of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/is_enabled`.
            public var isEnabled: Swift.Bool?
            /// Creates a new `IssueType`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the issue type.
            ///   - nodeId: The node identifier of the issue type.
            ///   - name: The name of the issue type.
            ///   - description: The description of the issue type.
            ///   - color: The color of the issue type.
            ///   - createdAt: The time the issue type created.
            ///   - updatedAt: The time the issue type last updated.
            ///   - isEnabled: The enabled state of the issue type.
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                color: Components.Schemas.IssueType.ColorPayload? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                isEnabled: Swift.Bool? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.description = description
                self.color = color
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.isEnabled = isEnabled
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case description
                case color
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case isEnabled = "is_enabled"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// A GitHub organization.
        ///
        /// - Remark: Generated from `#/components/schemas/organization-simple`.
        public struct OrganizationSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/organization-simple/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/public_members_url`.
            public var publicMembersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-simple/description`.
            public var description: Swift.String?
            /// Creates a new `OrganizationSimple`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - hooksUrl:
            ///   - issuesUrl:
            ///   - membersUrl:
            ///   - publicMembersUrl:
            ///   - avatarUrl:
            ///   - description:
            public init(
                login: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                hooksUrl: Swift.String,
                issuesUrl: Swift.String,
                membersUrl: Swift.String,
                publicMembersUrl: Swift.String,
                avatarUrl: Swift.String,
                description: Swift.String? = nil
            ) {
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.hooksUrl = hooksUrl
                self.issuesUrl = issuesUrl
                self.membersUrl = membersUrl
                self.publicMembersUrl = publicMembersUrl
                self.avatarUrl = avatarUrl
                self.description = description
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case nodeId = "node_id"
                case url
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case hooksUrl = "hooks_url"
                case issuesUrl = "issues_url"
                case membersUrl = "members_url"
                case publicMembersUrl = "public_members_url"
                case avatarUrl = "avatar_url"
                case description
            }
        }
        /// Organization Full
        ///
        /// - Remark: Generated from `#/components/schemas/organization-full`.
        public struct OrganizationFull: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/organization-full/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-full/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/public_members_url`.
            public var publicMembersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/company`.
            public var company: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/blog`.
            public var blog: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/location`.
            public var location: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/twitter_username`.
            public var twitterUsername: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/is_verified`.
            public var isVerified: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/has_organization_projects`.
            public var hasOrganizationProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/organization-full/has_repository_projects`.
            public var hasRepositoryProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/organization-full/public_repos`.
            public var publicRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-full/public_gists`.
            public var publicGists: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-full/followers`.
            public var followers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-full/following`.
            public var following: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-full/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-full/total_private_repos`.
            public var totalPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/organization-full/owned_private_repos`.
            public var ownedPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/organization-full/private_gists`.
            public var privateGists: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/organization-full/disk_usage`.
            public var diskUsage: Swift.Int?
            /// The number of collaborators on private repositories.
            ///
            /// This field may be null if the number of private repositories is over 50,000.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/collaborators`.
            public var collaborators: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/organization-full/billing_email`.
            public var billingEmail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/plan`.
            public struct PlanPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/organization-full/plan/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/organization-full/plan/space`.
                public var space: Swift.Int
                /// - Remark: Generated from `#/components/schemas/organization-full/plan/private_repos`.
                public var privateRepos: Swift.Int
                /// - Remark: Generated from `#/components/schemas/organization-full/plan/filled_seats`.
                public var filledSeats: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/organization-full/plan/seats`.
                public var seats: Swift.Int?
                /// Creates a new `PlanPayload`.
                ///
                /// - Parameters:
                ///   - name:
                ///   - space:
                ///   - privateRepos:
                ///   - filledSeats:
                ///   - seats:
                public init(
                    name: Swift.String,
                    space: Swift.Int,
                    privateRepos: Swift.Int,
                    filledSeats: Swift.Int? = nil,
                    seats: Swift.Int? = nil
                ) {
                    self.name = name
                    self.space = space
                    self.privateRepos = privateRepos
                    self.filledSeats = filledSeats
                    self.seats = seats
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case space
                    case privateRepos = "private_repos"
                    case filledSeats = "filled_seats"
                    case seats
                }
            }
            /// - Remark: Generated from `#/components/schemas/organization-full/plan`.
            public var plan: Components.Schemas.OrganizationFull.PlanPayload?
            /// - Remark: Generated from `#/components/schemas/organization-full/default_repository_permission`.
            public var defaultRepositoryPermission: Swift.String?
            /// The default branch for repositories created in this organization.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/default_repository_branch`.
            public var defaultRepositoryBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_repositories`.
            public var membersCanCreateRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/two_factor_requirement_enabled`.
            public var twoFactorRequirementEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_allowed_repository_creation_type`.
            public var membersAllowedRepositoryCreationType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_public_repositories`.
            public var membersCanCreatePublicRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_private_repositories`.
            public var membersCanCreatePrivateRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_internal_repositories`.
            public var membersCanCreateInternalRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_pages`.
            public var membersCanCreatePages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_public_pages`.
            public var membersCanCreatePublicPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_private_pages`.
            public var membersCanCreatePrivatePages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_delete_repositories`.
            public var membersCanDeleteRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_change_repo_visibility`.
            public var membersCanChangeRepoVisibility: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_invite_outside_collaborators`.
            public var membersCanInviteOutsideCollaborators: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_delete_issues`.
            public var membersCanDeleteIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/display_commenter_full_name_setting_enabled`.
            public var displayCommenterFullNameSettingEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/readers_can_create_discussions`.
            public var readersCanCreateDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_create_teams`.
            public var membersCanCreateTeams: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_view_dependency_insights`.
            public var membersCanViewDependencyInsights: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/members_can_fork_private_repositories`.
            public var membersCanForkPrivateRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-full/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///
            /// Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.
            ///
            /// This field is only visible to organization owners or members of a team with the security manager role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/advanced_security_enabled_for_new_repositories`.
            @available(*, deprecated)
            public var advancedSecurityEnabledForNewRepositories: Swift.Bool?
            /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///
            /// Whether Dependabot alerts are automatically enabled for new repositories and repositories transferred to this organization.
            ///
            /// This field is only visible to organization owners or members of a team with the security manager role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/dependabot_alerts_enabled_for_new_repositories`.
            @available(*, deprecated)
            public var dependabotAlertsEnabledForNewRepositories: Swift.Bool?
            /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///
            /// Whether Dependabot security updates are automatically enabled for new repositories and repositories transferred to this organization.
            ///
            /// This field is only visible to organization owners or members of a team with the security manager role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/dependabot_security_updates_enabled_for_new_repositories`.
            @available(*, deprecated)
            public var dependabotSecurityUpdatesEnabledForNewRepositories: Swift.Bool?
            /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///
            /// Whether dependency graph is automatically enabled for new repositories and repositories transferred to this organization.
            ///
            /// This field is only visible to organization owners or members of a team with the security manager role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/dependency_graph_enabled_for_new_repositories`.
            @available(*, deprecated)
            public var dependencyGraphEnabledForNewRepositories: Swift.Bool?
            /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///
            /// Whether secret scanning is automatically enabled for new repositories and repositories transferred to this organization.
            ///
            /// This field is only visible to organization owners or members of a team with the security manager role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/secret_scanning_enabled_for_new_repositories`.
            @available(*, deprecated)
            public var secretScanningEnabledForNewRepositories: Swift.Bool?
            /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///
            /// Whether secret scanning push protection is automatically enabled for new repositories and repositories transferred to this organization.
            ///
            /// This field is only visible to organization owners or members of a team with the security manager role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/secret_scanning_push_protection_enabled_for_new_repositories`.
            @available(*, deprecated)
            public var secretScanningPushProtectionEnabledForNewRepositories: Swift.Bool?
            /// Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/secret_scanning_push_protection_custom_link_enabled`.
            public var secretScanningPushProtectionCustomLinkEnabled: Swift.Bool?
            /// An optional URL string to display to contributors who are blocked from pushing a secret.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/secret_scanning_push_protection_custom_link`.
            public var secretScanningPushProtectionCustomLink: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-full/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/organization-full/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/organization-full/archived_at`.
            public var archivedAt: Foundation.Date?
            /// Controls whether or not deploy keys may be added and used for repositories in the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-full/deploy_keys_enabled_for_repositories`.
            public var deployKeysEnabledForRepositories: Swift.Bool?
            /// Creates a new `OrganizationFull`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - hooksUrl:
            ///   - issuesUrl:
            ///   - membersUrl:
            ///   - publicMembersUrl:
            ///   - avatarUrl:
            ///   - description:
            ///   - name:
            ///   - company:
            ///   - blog:
            ///   - location:
            ///   - email:
            ///   - twitterUsername:
            ///   - isVerified:
            ///   - hasOrganizationProjects:
            ///   - hasRepositoryProjects:
            ///   - publicRepos:
            ///   - publicGists:
            ///   - followers:
            ///   - following:
            ///   - htmlUrl:
            ///   - _type:
            ///   - totalPrivateRepos:
            ///   - ownedPrivateRepos:
            ///   - privateGists:
            ///   - diskUsage:
            ///   - collaborators: The number of collaborators on private repositories.
            ///   - billingEmail:
            ///   - plan:
            ///   - defaultRepositoryPermission:
            ///   - defaultRepositoryBranch: The default branch for repositories created in this organization.
            ///   - membersCanCreateRepositories:
            ///   - twoFactorRequirementEnabled:
            ///   - membersAllowedRepositoryCreationType:
            ///   - membersCanCreatePublicRepositories:
            ///   - membersCanCreatePrivateRepositories:
            ///   - membersCanCreateInternalRepositories:
            ///   - membersCanCreatePages:
            ///   - membersCanCreatePublicPages:
            ///   - membersCanCreatePrivatePages:
            ///   - membersCanDeleteRepositories:
            ///   - membersCanChangeRepoVisibility:
            ///   - membersCanInviteOutsideCollaborators:
            ///   - membersCanDeleteIssues:
            ///   - displayCommenterFullNameSettingEnabled:
            ///   - readersCanCreateDiscussions:
            ///   - membersCanCreateTeams:
            ///   - membersCanViewDependencyInsights:
            ///   - membersCanForkPrivateRepositories:
            ///   - webCommitSignoffRequired:
            ///   - advancedSecurityEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///   - dependabotAlertsEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///   - dependabotSecurityUpdatesEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///   - dependencyGraphEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///   - secretScanningEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///   - secretScanningPushProtectionEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
            ///   - secretScanningPushProtectionCustomLinkEnabled: Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.
            ///   - secretScanningPushProtectionCustomLink: An optional URL string to display to contributors who are blocked from pushing a secret.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - archivedAt:
            ///   - deployKeysEnabledForRepositories: Controls whether or not deploy keys may be added and used for repositories in the organization.
            public init(
                login: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                hooksUrl: Swift.String,
                issuesUrl: Swift.String,
                membersUrl: Swift.String,
                publicMembersUrl: Swift.String,
                avatarUrl: Swift.String,
                description: Swift.String? = nil,
                name: Swift.String? = nil,
                company: Swift.String? = nil,
                blog: Swift.String? = nil,
                location: Swift.String? = nil,
                email: Swift.String? = nil,
                twitterUsername: Swift.String? = nil,
                isVerified: Swift.Bool? = nil,
                hasOrganizationProjects: Swift.Bool,
                hasRepositoryProjects: Swift.Bool,
                publicRepos: Swift.Int,
                publicGists: Swift.Int,
                followers: Swift.Int,
                following: Swift.Int,
                htmlUrl: Swift.String,
                _type: Swift.String,
                totalPrivateRepos: Swift.Int? = nil,
                ownedPrivateRepos: Swift.Int? = nil,
                privateGists: Swift.Int? = nil,
                diskUsage: Swift.Int? = nil,
                collaborators: Swift.Int? = nil,
                billingEmail: Swift.String? = nil,
                plan: Components.Schemas.OrganizationFull.PlanPayload? = nil,
                defaultRepositoryPermission: Swift.String? = nil,
                defaultRepositoryBranch: Swift.String? = nil,
                membersCanCreateRepositories: Swift.Bool? = nil,
                twoFactorRequirementEnabled: Swift.Bool? = nil,
                membersAllowedRepositoryCreationType: Swift.String? = nil,
                membersCanCreatePublicRepositories: Swift.Bool? = nil,
                membersCanCreatePrivateRepositories: Swift.Bool? = nil,
                membersCanCreateInternalRepositories: Swift.Bool? = nil,
                membersCanCreatePages: Swift.Bool? = nil,
                membersCanCreatePublicPages: Swift.Bool? = nil,
                membersCanCreatePrivatePages: Swift.Bool? = nil,
                membersCanDeleteRepositories: Swift.Bool? = nil,
                membersCanChangeRepoVisibility: Swift.Bool? = nil,
                membersCanInviteOutsideCollaborators: Swift.Bool? = nil,
                membersCanDeleteIssues: Swift.Bool? = nil,
                displayCommenterFullNameSettingEnabled: Swift.Bool? = nil,
                readersCanCreateDiscussions: Swift.Bool? = nil,
                membersCanCreateTeams: Swift.Bool? = nil,
                membersCanViewDependencyInsights: Swift.Bool? = nil,
                membersCanForkPrivateRepositories: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                advancedSecurityEnabledForNewRepositories: Swift.Bool? = nil,
                dependabotAlertsEnabledForNewRepositories: Swift.Bool? = nil,
                dependabotSecurityUpdatesEnabledForNewRepositories: Swift.Bool? = nil,
                dependencyGraphEnabledForNewRepositories: Swift.Bool? = nil,
                secretScanningEnabledForNewRepositories: Swift.Bool? = nil,
                secretScanningPushProtectionEnabledForNewRepositories: Swift.Bool? = nil,
                secretScanningPushProtectionCustomLinkEnabled: Swift.Bool? = nil,
                secretScanningPushProtectionCustomLink: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                archivedAt: Foundation.Date? = nil,
                deployKeysEnabledForRepositories: Swift.Bool? = nil
            ) {
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.hooksUrl = hooksUrl
                self.issuesUrl = issuesUrl
                self.membersUrl = membersUrl
                self.publicMembersUrl = publicMembersUrl
                self.avatarUrl = avatarUrl
                self.description = description
                self.name = name
                self.company = company
                self.blog = blog
                self.location = location
                self.email = email
                self.twitterUsername = twitterUsername
                self.isVerified = isVerified
                self.hasOrganizationProjects = hasOrganizationProjects
                self.hasRepositoryProjects = hasRepositoryProjects
                self.publicRepos = publicRepos
                self.publicGists = publicGists
                self.followers = followers
                self.following = following
                self.htmlUrl = htmlUrl
                self._type = _type
                self.totalPrivateRepos = totalPrivateRepos
                self.ownedPrivateRepos = ownedPrivateRepos
                self.privateGists = privateGists
                self.diskUsage = diskUsage
                self.collaborators = collaborators
                self.billingEmail = billingEmail
                self.plan = plan
                self.defaultRepositoryPermission = defaultRepositoryPermission
                self.defaultRepositoryBranch = defaultRepositoryBranch
                self.membersCanCreateRepositories = membersCanCreateRepositories
                self.twoFactorRequirementEnabled = twoFactorRequirementEnabled
                self.membersAllowedRepositoryCreationType = membersAllowedRepositoryCreationType
                self.membersCanCreatePublicRepositories = membersCanCreatePublicRepositories
                self.membersCanCreatePrivateRepositories = membersCanCreatePrivateRepositories
                self.membersCanCreateInternalRepositories = membersCanCreateInternalRepositories
                self.membersCanCreatePages = membersCanCreatePages
                self.membersCanCreatePublicPages = membersCanCreatePublicPages
                self.membersCanCreatePrivatePages = membersCanCreatePrivatePages
                self.membersCanDeleteRepositories = membersCanDeleteRepositories
                self.membersCanChangeRepoVisibility = membersCanChangeRepoVisibility
                self.membersCanInviteOutsideCollaborators = membersCanInviteOutsideCollaborators
                self.membersCanDeleteIssues = membersCanDeleteIssues
                self.displayCommenterFullNameSettingEnabled = displayCommenterFullNameSettingEnabled
                self.readersCanCreateDiscussions = readersCanCreateDiscussions
                self.membersCanCreateTeams = membersCanCreateTeams
                self.membersCanViewDependencyInsights = membersCanViewDependencyInsights
                self.membersCanForkPrivateRepositories = membersCanForkPrivateRepositories
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.advancedSecurityEnabledForNewRepositories = advancedSecurityEnabledForNewRepositories
                self.dependabotAlertsEnabledForNewRepositories = dependabotAlertsEnabledForNewRepositories
                self.dependabotSecurityUpdatesEnabledForNewRepositories = dependabotSecurityUpdatesEnabledForNewRepositories
                self.dependencyGraphEnabledForNewRepositories = dependencyGraphEnabledForNewRepositories
                self.secretScanningEnabledForNewRepositories = secretScanningEnabledForNewRepositories
                self.secretScanningPushProtectionEnabledForNewRepositories = secretScanningPushProtectionEnabledForNewRepositories
                self.secretScanningPushProtectionCustomLinkEnabled = secretScanningPushProtectionCustomLinkEnabled
                self.secretScanningPushProtectionCustomLink = secretScanningPushProtectionCustomLink
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.archivedAt = archivedAt
                self.deployKeysEnabledForRepositories = deployKeysEnabledForRepositories
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case nodeId = "node_id"
                case url
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case hooksUrl = "hooks_url"
                case issuesUrl = "issues_url"
                case membersUrl = "members_url"
                case publicMembersUrl = "public_members_url"
                case avatarUrl = "avatar_url"
                case description
                case name
                case company
                case blog
                case location
                case email
                case twitterUsername = "twitter_username"
                case isVerified = "is_verified"
                case hasOrganizationProjects = "has_organization_projects"
                case hasRepositoryProjects = "has_repository_projects"
                case publicRepos = "public_repos"
                case publicGists = "public_gists"
                case followers
                case following
                case htmlUrl = "html_url"
                case _type = "type"
                case totalPrivateRepos = "total_private_repos"
                case ownedPrivateRepos = "owned_private_repos"
                case privateGists = "private_gists"
                case diskUsage = "disk_usage"
                case collaborators
                case billingEmail = "billing_email"
                case plan
                case defaultRepositoryPermission = "default_repository_permission"
                case defaultRepositoryBranch = "default_repository_branch"
                case membersCanCreateRepositories = "members_can_create_repositories"
                case twoFactorRequirementEnabled = "two_factor_requirement_enabled"
                case membersAllowedRepositoryCreationType = "members_allowed_repository_creation_type"
                case membersCanCreatePublicRepositories = "members_can_create_public_repositories"
                case membersCanCreatePrivateRepositories = "members_can_create_private_repositories"
                case membersCanCreateInternalRepositories = "members_can_create_internal_repositories"
                case membersCanCreatePages = "members_can_create_pages"
                case membersCanCreatePublicPages = "members_can_create_public_pages"
                case membersCanCreatePrivatePages = "members_can_create_private_pages"
                case membersCanDeleteRepositories = "members_can_delete_repositories"
                case membersCanChangeRepoVisibility = "members_can_change_repo_visibility"
                case membersCanInviteOutsideCollaborators = "members_can_invite_outside_collaborators"
                case membersCanDeleteIssues = "members_can_delete_issues"
                case displayCommenterFullNameSettingEnabled = "display_commenter_full_name_setting_enabled"
                case readersCanCreateDiscussions = "readers_can_create_discussions"
                case membersCanCreateTeams = "members_can_create_teams"
                case membersCanViewDependencyInsights = "members_can_view_dependency_insights"
                case membersCanForkPrivateRepositories = "members_can_fork_private_repositories"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case advancedSecurityEnabledForNewRepositories = "advanced_security_enabled_for_new_repositories"
                case dependabotAlertsEnabledForNewRepositories = "dependabot_alerts_enabled_for_new_repositories"
                case dependabotSecurityUpdatesEnabledForNewRepositories = "dependabot_security_updates_enabled_for_new_repositories"
                case dependencyGraphEnabledForNewRepositories = "dependency_graph_enabled_for_new_repositories"
                case secretScanningEnabledForNewRepositories = "secret_scanning_enabled_for_new_repositories"
                case secretScanningPushProtectionEnabledForNewRepositories = "secret_scanning_push_protection_enabled_for_new_repositories"
                case secretScanningPushProtectionCustomLinkEnabled = "secret_scanning_push_protection_custom_link_enabled"
                case secretScanningPushProtectionCustomLink = "secret_scanning_push_protection_custom_link"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case archivedAt = "archived_at"
                case deployKeysEnabledForRepositories = "deploy_keys_enabled_for_repositories"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// Organization Invitation
        ///
        /// - Remark: Generated from `#/components/schemas/organization-invitation`.
        public struct OrganizationInvitation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/organization-invitation/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/organization-invitation/login`.
            public var login: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/role`.
            public var role: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/failed_at`.
            public var failedAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/failed_reason`.
            public var failedReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/inviter`.
            public var inviter: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/organization-invitation/team_count`.
            public var teamCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-invitation/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/invitation_teams_url`.
            public var invitationTeamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/invitation_source`.
            public var invitationSource: Swift.String?
            /// Creates a new `OrganizationInvitation`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - login:
            ///   - email:
            ///   - role:
            ///   - createdAt:
            ///   - failedAt:
            ///   - failedReason:
            ///   - inviter:
            ///   - teamCount:
            ///   - nodeId:
            ///   - invitationTeamsUrl:
            ///   - invitationSource:
            public init(
                id: Swift.Int64,
                login: Swift.String? = nil,
                email: Swift.String? = nil,
                role: Swift.String,
                createdAt: Swift.String,
                failedAt: Swift.String? = nil,
                failedReason: Swift.String? = nil,
                inviter: Components.Schemas.SimpleUser,
                teamCount: Swift.Int,
                nodeId: Swift.String,
                invitationTeamsUrl: Swift.String,
                invitationSource: Swift.String? = nil
            ) {
                self.id = id
                self.login = login
                self.email = email
                self.role = role
                self.createdAt = createdAt
                self.failedAt = failedAt
                self.failedReason = failedReason
                self.inviter = inviter
                self.teamCount = teamCount
                self.nodeId = nodeId
                self.invitationTeamsUrl = invitationTeamsUrl
                self.invitationSource = invitationSource
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case login
                case email
                case role
                case createdAt = "created_at"
                case failedAt = "failed_at"
                case failedReason = "failed_reason"
                case inviter
                case teamCount = "team_count"
                case nodeId = "node_id"
                case invitationTeamsUrl = "invitation_teams_url"
                case invitationSource = "invitation_source"
            }
        }
        /// Org Hook
        ///
        /// - Remark: Generated from `#/components/schemas/org-hook`.
        public struct OrgHook: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/org-hook/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/org-hook/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/org-hook/ping_url`.
            public var pingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/org-hook/deliveries_url`.
            public var deliveriesUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/org-hook/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/org-hook/events`.
            public var events: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/org-hook/active`.
            public var active: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/org-hook/config`.
            public struct ConfigPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/org-hook/config/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/org-hook/config/insecure_ssl`.
                public var insecureSsl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/org-hook/config/content_type`.
                public var contentType: Swift.String?
                /// - Remark: Generated from `#/components/schemas/org-hook/config/secret`.
                public var secret: Swift.String?
                /// Creates a new `ConfigPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - insecureSsl:
                ///   - contentType:
                ///   - secret:
                public init(
                    url: Swift.String? = nil,
                    insecureSsl: Swift.String? = nil,
                    contentType: Swift.String? = nil,
                    secret: Swift.String? = nil
                ) {
                    self.url = url
                    self.insecureSsl = insecureSsl
                    self.contentType = contentType
                    self.secret = secret
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case insecureSsl = "insecure_ssl"
                    case contentType = "content_type"
                    case secret
                }
            }
            /// - Remark: Generated from `#/components/schemas/org-hook/config`.
            public var config: Components.Schemas.OrgHook.ConfigPayload
            /// - Remark: Generated from `#/components/schemas/org-hook/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/org-hook/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/org-hook/type`.
            public var _type: Swift.String
            /// Creates a new `OrgHook`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - url:
            ///   - pingUrl:
            ///   - deliveriesUrl:
            ///   - name:
            ///   - events:
            ///   - active:
            ///   - config:
            ///   - updatedAt:
            ///   - createdAt:
            ///   - _type:
            public init(
                id: Swift.Int,
                url: Swift.String,
                pingUrl: Swift.String,
                deliveriesUrl: Swift.String? = nil,
                name: Swift.String,
                events: [Swift.String],
                active: Swift.Bool,
                config: Components.Schemas.OrgHook.ConfigPayload,
                updatedAt: Foundation.Date,
                createdAt: Foundation.Date,
                _type: Swift.String
            ) {
                self.id = id
                self.url = url
                self.pingUrl = pingUrl
                self.deliveriesUrl = deliveriesUrl
                self.name = name
                self.events = events
                self.active = active
                self.config = config
                self.updatedAt = updatedAt
                self.createdAt = createdAt
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case url
                case pingUrl = "ping_url"
                case deliveriesUrl = "deliveries_url"
                case name
                case events
                case active
                case config
                case updatedAt = "updated_at"
                case createdAt = "created_at"
                case _type = "type"
            }
        }
        /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats`.
        public struct ApiInsightsRouteStatsPayload: Codable, Hashable, Sendable {
            /// The HTTP method
            ///
            /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats/http_method`.
            public var httpMethod: Swift.String?
            /// The API path's route template
            ///
            /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats/api_route`.
            public var apiRoute: Swift.String?
            /// The total number of requests within the queried time period
            ///
            /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats/total_request_count`.
            public var totalRequestCount: Swift.Int64?
            /// The total number of requests that were rate limited within the queried time period
            ///
            /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats/rate_limited_request_count`.
            public var rateLimitedRequestCount: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats/last_rate_limited_timestamp`.
            public var lastRateLimitedTimestamp: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsRouteStats/last_request_timestamp`.
            public var lastRequestTimestamp: Swift.String?
            /// Creates a new `ApiInsightsRouteStatsPayload`.
            ///
            /// - Parameters:
            ///   - httpMethod: The HTTP method
            ///   - apiRoute: The API path's route template
            ///   - totalRequestCount: The total number of requests within the queried time period
            ///   - rateLimitedRequestCount: The total number of requests that were rate limited within the queried time period
            ///   - lastRateLimitedTimestamp:
            ///   - lastRequestTimestamp:
            public init(
                httpMethod: Swift.String? = nil,
                apiRoute: Swift.String? = nil,
                totalRequestCount: Swift.Int64? = nil,
                rateLimitedRequestCount: Swift.Int64? = nil,
                lastRateLimitedTimestamp: Swift.String? = nil,
                lastRequestTimestamp: Swift.String? = nil
            ) {
                self.httpMethod = httpMethod
                self.apiRoute = apiRoute
                self.totalRequestCount = totalRequestCount
                self.rateLimitedRequestCount = rateLimitedRequestCount
                self.lastRateLimitedTimestamp = lastRateLimitedTimestamp
                self.lastRequestTimestamp = lastRequestTimestamp
            }
            public enum CodingKeys: String, CodingKey {
                case httpMethod = "http_method"
                case apiRoute = "api_route"
                case totalRequestCount = "total_request_count"
                case rateLimitedRequestCount = "rate_limited_request_count"
                case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
                case lastRequestTimestamp = "last_request_timestamp"
            }
        }
        /// API Insights usage route stats for an actor
        ///
        /// - Remark: Generated from `#/components/schemas/api-insights-route-stats`.
        public typealias ApiInsightsRouteStats = [Components.Schemas.ApiInsightsRouteStatsPayload]
        /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats`.
        public struct ApiInsightsSubjectStatsPayload: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/subject_type`.
            public var subjectType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/subject_name`.
            public var subjectName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/subject_id`.
            public var subjectId: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/total_request_count`.
            public var totalRequestCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/rate_limited_request_count`.
            public var rateLimitedRequestCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/last_rate_limited_timestamp`.
            public var lastRateLimitedTimestamp: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsSubjectStats/last_request_timestamp`.
            public var lastRequestTimestamp: Swift.String?
            /// Creates a new `ApiInsightsSubjectStatsPayload`.
            ///
            /// - Parameters:
            ///   - subjectType:
            ///   - subjectName:
            ///   - subjectId:
            ///   - totalRequestCount:
            ///   - rateLimitedRequestCount:
            ///   - lastRateLimitedTimestamp:
            ///   - lastRequestTimestamp:
            public init(
                subjectType: Swift.String? = nil,
                subjectName: Swift.String? = nil,
                subjectId: Swift.Int64? = nil,
                totalRequestCount: Swift.Int? = nil,
                rateLimitedRequestCount: Swift.Int? = nil,
                lastRateLimitedTimestamp: Swift.String? = nil,
                lastRequestTimestamp: Swift.String? = nil
            ) {
                self.subjectType = subjectType
                self.subjectName = subjectName
                self.subjectId = subjectId
                self.totalRequestCount = totalRequestCount
                self.rateLimitedRequestCount = rateLimitedRequestCount
                self.lastRateLimitedTimestamp = lastRateLimitedTimestamp
                self.lastRequestTimestamp = lastRequestTimestamp
            }
            public enum CodingKeys: String, CodingKey {
                case subjectType = "subject_type"
                case subjectName = "subject_name"
                case subjectId = "subject_id"
                case totalRequestCount = "total_request_count"
                case rateLimitedRequestCount = "rate_limited_request_count"
                case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
                case lastRequestTimestamp = "last_request_timestamp"
            }
        }
        /// API Insights usage subject stats for an organization
        ///
        /// - Remark: Generated from `#/components/schemas/api-insights-subject-stats`.
        public typealias ApiInsightsSubjectStats = [Components.Schemas.ApiInsightsSubjectStatsPayload]
        /// API Insights usage summary stats for an organization
        ///
        /// - Remark: Generated from `#/components/schemas/api-insights-summary-stats`.
        public struct ApiInsightsSummaryStats: Codable, Hashable, Sendable {
            /// The total number of requests within the queried time period
            ///
            /// - Remark: Generated from `#/components/schemas/api-insights-summary-stats/total_request_count`.
            public var totalRequestCount: Swift.Int64?
            /// The total number of requests that were rate limited within the queried time period
            ///
            /// - Remark: Generated from `#/components/schemas/api-insights-summary-stats/rate_limited_request_count`.
            public var rateLimitedRequestCount: Swift.Int64?
            /// Creates a new `ApiInsightsSummaryStats`.
            ///
            /// - Parameters:
            ///   - totalRequestCount: The total number of requests within the queried time period
            ///   - rateLimitedRequestCount: The total number of requests that were rate limited within the queried time period
            public init(
                totalRequestCount: Swift.Int64? = nil,
                rateLimitedRequestCount: Swift.Int64? = nil
            ) {
                self.totalRequestCount = totalRequestCount
                self.rateLimitedRequestCount = rateLimitedRequestCount
            }
            public enum CodingKeys: String, CodingKey {
                case totalRequestCount = "total_request_count"
                case rateLimitedRequestCount = "rate_limited_request_count"
            }
        }
        /// - Remark: Generated from `#/components/schemas/ApiInsightsTimeStats`.
        public struct ApiInsightsTimeStatsPayload: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ApiInsightsTimeStats/timestamp`.
            public var timestamp: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsTimeStats/total_request_count`.
            public var totalRequestCount: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsTimeStats/rate_limited_request_count`.
            public var rateLimitedRequestCount: Swift.Int64?
            /// Creates a new `ApiInsightsTimeStatsPayload`.
            ///
            /// - Parameters:
            ///   - timestamp:
            ///   - totalRequestCount:
            ///   - rateLimitedRequestCount:
            public init(
                timestamp: Swift.String? = nil,
                totalRequestCount: Swift.Int64? = nil,
                rateLimitedRequestCount: Swift.Int64? = nil
            ) {
                self.timestamp = timestamp
                self.totalRequestCount = totalRequestCount
                self.rateLimitedRequestCount = rateLimitedRequestCount
            }
            public enum CodingKeys: String, CodingKey {
                case timestamp
                case totalRequestCount = "total_request_count"
                case rateLimitedRequestCount = "rate_limited_request_count"
            }
        }
        /// API Insights usage time stats for an organization
        ///
        /// - Remark: Generated from `#/components/schemas/api-insights-time-stats`.
        public typealias ApiInsightsTimeStats = [Components.Schemas.ApiInsightsTimeStatsPayload]
        /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats`.
        public struct ApiInsightsUserStatsPayload: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/actor_type`.
            public var actorType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/actor_name`.
            public var actorName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/actor_id`.
            public var actorId: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/integration_id`.
            public var integrationId: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/oauth_application_id`.
            public var oauthApplicationId: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/total_request_count`.
            public var totalRequestCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/rate_limited_request_count`.
            public var rateLimitedRequestCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/last_rate_limited_timestamp`.
            public var lastRateLimitedTimestamp: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ApiInsightsUserStats/last_request_timestamp`.
            public var lastRequestTimestamp: Swift.String?
            /// Creates a new `ApiInsightsUserStatsPayload`.
            ///
            /// - Parameters:
            ///   - actorType:
            ///   - actorName:
            ///   - actorId:
            ///   - integrationId:
            ///   - oauthApplicationId:
            ///   - totalRequestCount:
            ///   - rateLimitedRequestCount:
            ///   - lastRateLimitedTimestamp:
            ///   - lastRequestTimestamp:
            public init(
                actorType: Swift.String? = nil,
                actorName: Swift.String? = nil,
                actorId: Swift.Int64? = nil,
                integrationId: Swift.Int64? = nil,
                oauthApplicationId: Swift.Int64? = nil,
                totalRequestCount: Swift.Int? = nil,
                rateLimitedRequestCount: Swift.Int? = nil,
                lastRateLimitedTimestamp: Swift.String? = nil,
                lastRequestTimestamp: Swift.String? = nil
            ) {
                self.actorType = actorType
                self.actorName = actorName
                self.actorId = actorId
                self.integrationId = integrationId
                self.oauthApplicationId = oauthApplicationId
                self.totalRequestCount = totalRequestCount
                self.rateLimitedRequestCount = rateLimitedRequestCount
                self.lastRateLimitedTimestamp = lastRateLimitedTimestamp
                self.lastRequestTimestamp = lastRequestTimestamp
            }
            public enum CodingKeys: String, CodingKey {
                case actorType = "actor_type"
                case actorName = "actor_name"
                case actorId = "actor_id"
                case integrationId = "integration_id"
                case oauthApplicationId = "oauth_application_id"
                case totalRequestCount = "total_request_count"
                case rateLimitedRequestCount = "rate_limited_request_count"
                case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
                case lastRequestTimestamp = "last_request_timestamp"
            }
        }
        /// API Insights usage stats for a user
        ///
        /// - Remark: Generated from `#/components/schemas/api-insights-user-stats`.
        public typealias ApiInsightsUserStats = [Components.Schemas.ApiInsightsUserStatsPayload]
        /// - Remark: Generated from `#/components/schemas/organization-create-issue-type`.
        public struct OrganizationCreateIssueType: Codable, Hashable, Sendable {
            /// Name of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-create-issue-type/name`.
            public var name: Swift.String
            /// Whether or not the issue type is enabled at the organization level.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-create-issue-type/is_enabled`.
            public var isEnabled: Swift.Bool
            /// Description of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-create-issue-type/description`.
            public var description: Swift.String?
            /// Color for the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-create-issue-type/color`.
            @frozen public enum ColorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case gray = "gray"
                case blue = "blue"
                case green = "green"
                case yellow = "yellow"
                case orange = "orange"
                case red = "red"
                case pink = "pink"
                case purple = "purple"
            }
            /// Color for the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-create-issue-type/color`.
            public var color: Components.Schemas.OrganizationCreateIssueType.ColorPayload?
            /// Creates a new `OrganizationCreateIssueType`.
            ///
            /// - Parameters:
            ///   - name: Name of the issue type.
            ///   - isEnabled: Whether or not the issue type is enabled at the organization level.
            ///   - description: Description of the issue type.
            ///   - color: Color for the issue type.
            public init(
                name: Swift.String,
                isEnabled: Swift.Bool,
                description: Swift.String? = nil,
                color: Components.Schemas.OrganizationCreateIssueType.ColorPayload? = nil
            ) {
                self.name = name
                self.isEnabled = isEnabled
                self.description = description
                self.color = color
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case isEnabled = "is_enabled"
                case description
                case color
            }
        }
        /// - Remark: Generated from `#/components/schemas/organization-update-issue-type`.
        public struct OrganizationUpdateIssueType: Codable, Hashable, Sendable {
            /// Name of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-update-issue-type/name`.
            public var name: Swift.String
            /// Whether or not the issue type is enabled at the organization level.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-update-issue-type/is_enabled`.
            public var isEnabled: Swift.Bool
            /// Description of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-update-issue-type/description`.
            public var description: Swift.String?
            /// Color for the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-update-issue-type/color`.
            @frozen public enum ColorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case gray = "gray"
                case blue = "blue"
                case green = "green"
                case yellow = "yellow"
                case orange = "orange"
                case red = "red"
                case pink = "pink"
                case purple = "purple"
            }
            /// Color for the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-update-issue-type/color`.
            public var color: Components.Schemas.OrganizationUpdateIssueType.ColorPayload?
            /// Creates a new `OrganizationUpdateIssueType`.
            ///
            /// - Parameters:
            ///   - name: Name of the issue type.
            ///   - isEnabled: Whether or not the issue type is enabled at the organization level.
            ///   - description: Description of the issue type.
            ///   - color: Color for the issue type.
            public init(
                name: Swift.String,
                isEnabled: Swift.Bool,
                description: Swift.String? = nil,
                color: Components.Schemas.OrganizationUpdateIssueType.ColorPayload? = nil
            ) {
                self.name = name
                self.isEnabled = isEnabled
                self.description = description
                self.color = color
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case isEnabled = "is_enabled"
                case description
                case color
            }
        }
        /// Org Membership
        ///
        /// - Remark: Generated from `#/components/schemas/org-membership`.
        public struct OrgMembership: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/org-membership/url`.
            public var url: Swift.String
            /// The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
            ///
            /// - Remark: Generated from `#/components/schemas/org-membership/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case active = "active"
                case pending = "pending"
            }
            /// The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
            ///
            /// - Remark: Generated from `#/components/schemas/org-membership/state`.
            public var state: Components.Schemas.OrgMembership.StatePayload
            /// The user's membership type in the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/org-membership/role`.
            @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case admin = "admin"
                case member = "member"
                case billingManager = "billing_manager"
            }
            /// The user's membership type in the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/org-membership/role`.
            public var role: Components.Schemas.OrgMembership.RolePayload
            /// Whether the user has direct membership in the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/org-membership/direct_membership`.
            public var directMembership: Swift.Bool?
            /// The slugs of the enterprise teams providing the user with indirect membership in the organization.
            /// A limit of 100 enterprise team slugs is returned.
            ///
            /// - Remark: Generated from `#/components/schemas/org-membership/enterprise_teams_providing_indirect_membership`.
            public var enterpriseTeamsProvidingIndirectMembership: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/org-membership/organization_url`.
            public var organizationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/org-membership/organization`.
            public var organization: Components.Schemas.OrganizationSimple
            /// - Remark: Generated from `#/components/schemas/org-membership/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/org-membership/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/org-membership/permissions/can_create_repository`.
                public var canCreateRepository: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - canCreateRepository:
                public init(canCreateRepository: Swift.Bool) {
                    self.canCreateRepository = canCreateRepository
                }
                public enum CodingKeys: String, CodingKey {
                    case canCreateRepository = "can_create_repository"
                }
            }
            /// - Remark: Generated from `#/components/schemas/org-membership/permissions`.
            public var permissions: Components.Schemas.OrgMembership.PermissionsPayload?
            /// Creates a new `OrgMembership`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - state: The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
            ///   - role: The user's membership type in the organization.
            ///   - directMembership: Whether the user has direct membership in the organization.
            ///   - enterpriseTeamsProvidingIndirectMembership: The slugs of the enterprise teams providing the user with indirect membership in the organization.
            ///   - organizationUrl:
            ///   - organization:
            ///   - user:
            ///   - permissions:
            public init(
                url: Swift.String,
                state: Components.Schemas.OrgMembership.StatePayload,
                role: Components.Schemas.OrgMembership.RolePayload,
                directMembership: Swift.Bool? = nil,
                enterpriseTeamsProvidingIndirectMembership: [Swift.String]? = nil,
                organizationUrl: Swift.String,
                organization: Components.Schemas.OrganizationSimple,
                user: Components.Schemas.NullableSimpleUser? = nil,
                permissions: Components.Schemas.OrgMembership.PermissionsPayload? = nil
            ) {
                self.url = url
                self.state = state
                self.role = role
                self.directMembership = directMembership
                self.enterpriseTeamsProvidingIndirectMembership = enterpriseTeamsProvidingIndirectMembership
                self.organizationUrl = organizationUrl
                self.organization = organization
                self.user = user
                self.permissions = permissions
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case state
                case role
                case directMembership = "direct_membership"
                case enterpriseTeamsProvidingIndirectMembership = "enterprise_teams_providing_indirect_membership"
                case organizationUrl = "organization_url"
                case organization
                case user
                case permissions
            }
        }
        /// Organization roles
        ///
        /// - Remark: Generated from `#/components/schemas/organization-role`.
        public struct OrganizationRole: Codable, Hashable, Sendable {
            /// The unique identifier of the role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/id`.
            public var id: Swift.Int64
            /// The name of the role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/name`.
            public var name: Swift.String
            /// A short description about who this role is for or what permissions it grants.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/description`.
            public var description: Swift.String?
            /// The system role from which this role inherits permissions.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/base_role`.
            @frozen public enum BaseRolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case triage = "triage"
                case write = "write"
                case maintain = "maintain"
                case admin = "admin"
            }
            /// The system role from which this role inherits permissions.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/base_role`.
            public var baseRole: Components.Schemas.OrganizationRole.BaseRolePayload?
            /// Source answers the question, "where did this role come from?"
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/source`.
            @frozen public enum SourcePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case organization = "Organization"
                case enterprise = "Enterprise"
                case predefined = "Predefined"
            }
            /// Source answers the question, "where did this role come from?"
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/source`.
            public var source: Components.Schemas.OrganizationRole.SourcePayload?
            /// A list of permissions included in this role.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/permissions`.
            public var permissions: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/organization-role/organization`.
            public var organization: Components.Schemas.NullableSimpleUser?
            /// The date and time the role was created.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time the role was last updated.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-role/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `OrganizationRole`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the role.
            ///   - name: The name of the role.
            ///   - description: A short description about who this role is for or what permissions it grants.
            ///   - baseRole: The system role from which this role inherits permissions.
            ///   - source: Source answers the question, "where did this role come from?"
            ///   - permissions: A list of permissions included in this role.
            ///   - organization:
            ///   - createdAt: The date and time the role was created.
            ///   - updatedAt: The date and time the role was last updated.
            public init(
                id: Swift.Int64,
                name: Swift.String,
                description: Swift.String? = nil,
                baseRole: Components.Schemas.OrganizationRole.BaseRolePayload? = nil,
                source: Components.Schemas.OrganizationRole.SourcePayload? = nil,
                permissions: [Swift.String],
                organization: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.id = id
                self.name = name
                self.description = description
                self.baseRole = baseRole
                self.source = source
                self.permissions = permissions
                self.organization = organization
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case description
                case baseRole = "base_role"
                case source
                case permissions
                case organization
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// The Relationship a Team has with a role.
        ///
        /// - Remark: Generated from `#/components/schemas/team-role-assignment`.
        public struct TeamRoleAssignment: Codable, Hashable, Sendable {
            /// Determines if the team has a direct, indirect, or mixed relationship to a role
            ///
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/assignment`.
            @frozen public enum AssignmentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case direct = "direct"
                case indirect = "indirect"
                case mixed = "mixed"
            }
            /// Determines if the team has a direct, indirect, or mixed relationship to a role
            ///
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/assignment`.
            public var assignment: Components.Schemas.TeamRoleAssignment.AssignmentPayload?
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/permissions`.
            public var permissions: Components.Schemas.TeamRoleAssignment.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-role-assignment/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `TeamRoleAssignment`.
            ///
            /// - Parameters:
            ///   - assignment: Determines if the team has a direct, indirect, or mixed relationship to a role
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                assignment: Components.Schemas.TeamRoleAssignment.AssignmentPayload? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.TeamRoleAssignment.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.assignment = assignment
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case assignment
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team-simple`.
        public struct TeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `TeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// The Relationship a User has with a role.
        ///
        /// - Remark: Generated from `#/components/schemas/user-role-assignment`.
        public struct UserRoleAssignment: Codable, Hashable, Sendable {
            /// Determines if the user has a direct, indirect, or mixed relationship to a role
            ///
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/assignment`.
            @frozen public enum AssignmentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case direct = "direct"
                case indirect = "indirect"
                case mixed = "mixed"
            }
            /// Determines if the user has a direct, indirect, or mixed relationship to a role
            ///
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/assignment`.
            public var assignment: Components.Schemas.UserRoleAssignment.AssignmentPayload?
            /// Team the user has gotten the role through
            ///
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/inherited_from`.
            public var inheritedFrom: [Components.Schemas.TeamSimple]?
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/user-role-assignment/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `UserRoleAssignment`.
            ///
            /// - Parameters:
            ///   - assignment: Determines if the user has a direct, indirect, or mixed relationship to a role
            ///   - inheritedFrom: Team the user has gotten the role through
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                assignment: Components.Schemas.UserRoleAssignment.AssignmentPayload? = nil,
                inheritedFrom: [Components.Schemas.TeamSimple]? = nil,
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.assignment = assignment
                self.inheritedFrom = inheritedFrom
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case assignment
                case inheritedFrom = "inherited_from"
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Minimal representation of an organization programmatic access grant request for enumerations
        ///
        /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request`.
        public struct OrganizationProgrammaticAccessGrantRequest: Codable, Hashable, Sendable {
            /// Unique identifier of the request for access via fine-grained personal access token. The `pat_request_id` used to review PAT requests.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/id`.
            public var id: Swift.Int
            /// Reason for requesting access.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/reason`.
            public var reason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Type of repository selection requested.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case all = "all"
                case subset = "subset"
            }
            /// Type of repository selection requested.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/repository_selection`.
            public var repositorySelection: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.RepositorySelectionPayload
            /// URL to the list of repositories requested to be accessed via fine-grained personal access token. Should only be followed when `repository_selection` is `subset`.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// Permissions requested, categorized by type of permission.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions/organization`.
                public struct OrganizationPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Swift.String]
                    /// Creates a new `OrganizationPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Swift.String] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions/organization`.
                public var organization: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload.OrganizationPayload?
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions/repository`.
                public struct RepositoryPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Swift.String]
                    /// Creates a new `RepositoryPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Swift.String] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions/repository`.
                public var repository: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload.RepositoryPayload?
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions/other`.
                public struct OtherPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Swift.String]
                    /// Creates a new `OtherPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Swift.String] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions/other`.
                public var other: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload.OtherPayload?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - organization:
                ///   - repository:
                ///   - other:
                public init(
                    organization: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload.OrganizationPayload? = nil,
                    repository: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload.RepositoryPayload? = nil,
                    other: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload.OtherPayload? = nil
                ) {
                    self.organization = organization
                    self.repository = repository
                    self.other = other
                }
                public enum CodingKeys: String, CodingKey {
                    case organization
                    case repository
                    case other
                }
            }
            /// Permissions requested, categorized by type of permission.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/permissions`.
            public var permissions: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload
            /// Date and time when the request for access was created.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/created_at`.
            public var createdAt: Swift.String
            /// Unique identifier of the user's token. This field can also be found in audit log events and the organization's settings for their PAT grants.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/token_id`.
            public var tokenId: Swift.Int
            /// The name given to the user's token. This field can also be found in an organization's settings page for Active Tokens.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/token_name`.
            public var tokenName: Swift.String
            /// Whether the associated fine-grained personal access token has expired.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/token_expired`.
            public var tokenExpired: Swift.Bool
            /// Date and time when the associated fine-grained personal access token expires.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/token_expires_at`.
            public var tokenExpiresAt: Swift.String?
            /// Date and time when the associated fine-grained personal access token was last used for authentication.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant-request/token_last_used_at`.
            public var tokenLastUsedAt: Swift.String?
            /// Creates a new `OrganizationProgrammaticAccessGrantRequest`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the request for access via fine-grained personal access token. The `pat_request_id` used to review PAT requests.
            ///   - reason: Reason for requesting access.
            ///   - owner:
            ///   - repositorySelection: Type of repository selection requested.
            ///   - repositoriesUrl: URL to the list of repositories requested to be accessed via fine-grained personal access token. Should only be followed when `repository_selection` is `subset`.
            ///   - permissions: Permissions requested, categorized by type of permission.
            ///   - createdAt: Date and time when the request for access was created.
            ///   - tokenId: Unique identifier of the user's token. This field can also be found in audit log events and the organization's settings for their PAT grants.
            ///   - tokenName: The name given to the user's token. This field can also be found in an organization's settings page for Active Tokens.
            ///   - tokenExpired: Whether the associated fine-grained personal access token has expired.
            ///   - tokenExpiresAt: Date and time when the associated fine-grained personal access token expires.
            ///   - tokenLastUsedAt: Date and time when the associated fine-grained personal access token was last used for authentication.
            public init(
                id: Swift.Int,
                reason: Swift.String? = nil,
                owner: Components.Schemas.SimpleUser,
                repositorySelection: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.RepositorySelectionPayload,
                repositoriesUrl: Swift.String,
                permissions: Components.Schemas.OrganizationProgrammaticAccessGrantRequest.PermissionsPayload,
                createdAt: Swift.String,
                tokenId: Swift.Int,
                tokenName: Swift.String,
                tokenExpired: Swift.Bool,
                tokenExpiresAt: Swift.String? = nil,
                tokenLastUsedAt: Swift.String? = nil
            ) {
                self.id = id
                self.reason = reason
                self.owner = owner
                self.repositorySelection = repositorySelection
                self.repositoriesUrl = repositoriesUrl
                self.permissions = permissions
                self.createdAt = createdAt
                self.tokenId = tokenId
                self.tokenName = tokenName
                self.tokenExpired = tokenExpired
                self.tokenExpiresAt = tokenExpiresAt
                self.tokenLastUsedAt = tokenLastUsedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case reason
                case owner
                case repositorySelection = "repository_selection"
                case repositoriesUrl = "repositories_url"
                case permissions
                case createdAt = "created_at"
                case tokenId = "token_id"
                case tokenName = "token_name"
                case tokenExpired = "token_expired"
                case tokenExpiresAt = "token_expires_at"
                case tokenLastUsedAt = "token_last_used_at"
            }
        }
        /// Minimal representation of an organization programmatic access grant for enumerations
        ///
        /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant`.
        public struct OrganizationProgrammaticAccessGrant: Codable, Hashable, Sendable {
            /// Unique identifier of the fine-grained personal access token grant. The `pat_id` used to get details about an approved fine-grained personal access token.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Type of repository selection requested.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/repository_selection`.
            @frozen public enum RepositorySelectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case all = "all"
                case subset = "subset"
            }
            /// Type of repository selection requested.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/repository_selection`.
            public var repositorySelection: Components.Schemas.OrganizationProgrammaticAccessGrant.RepositorySelectionPayload
            /// URL to the list of repositories the fine-grained personal access token can access. Only follow when `repository_selection` is `subset`.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// Permissions requested, categorized by type of permission.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions/organization`.
                public struct OrganizationPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Swift.String]
                    /// Creates a new `OrganizationPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Swift.String] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions/organization`.
                public var organization: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload.OrganizationPayload?
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions/repository`.
                public struct RepositoryPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Swift.String]
                    /// Creates a new `RepositoryPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Swift.String] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions/repository`.
                public var repository: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload.RepositoryPayload?
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions/other`.
                public struct OtherPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Swift.String]
                    /// Creates a new `OtherPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Swift.String] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions/other`.
                public var other: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload.OtherPayload?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - organization:
                ///   - repository:
                ///   - other:
                public init(
                    organization: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload.OrganizationPayload? = nil,
                    repository: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload.RepositoryPayload? = nil,
                    other: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload.OtherPayload? = nil
                ) {
                    self.organization = organization
                    self.repository = repository
                    self.other = other
                }
                public enum CodingKeys: String, CodingKey {
                    case organization
                    case repository
                    case other
                }
            }
            /// Permissions requested, categorized by type of permission.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/permissions`.
            public var permissions: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload
            /// Date and time when the fine-grained personal access token was approved to access the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/access_granted_at`.
            public var accessGrantedAt: Swift.String
            /// Unique identifier of the user's token. This field can also be found in audit log events and the organization's settings for their PAT grants.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/token_id`.
            public var tokenId: Swift.Int
            /// The name given to the user's token. This field can also be found in an organization's settings page for Active Tokens.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/token_name`.
            public var tokenName: Swift.String
            /// Whether the associated fine-grained personal access token has expired.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/token_expired`.
            public var tokenExpired: Swift.Bool
            /// Date and time when the associated fine-grained personal access token expires.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/token_expires_at`.
            public var tokenExpiresAt: Swift.String?
            /// Date and time when the associated fine-grained personal access token was last used for authentication.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-programmatic-access-grant/token_last_used_at`.
            public var tokenLastUsedAt: Swift.String?
            /// Creates a new `OrganizationProgrammaticAccessGrant`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the fine-grained personal access token grant. The `pat_id` used to get details about an approved fine-grained personal access token.
            ///   - owner:
            ///   - repositorySelection: Type of repository selection requested.
            ///   - repositoriesUrl: URL to the list of repositories the fine-grained personal access token can access. Only follow when `repository_selection` is `subset`.
            ///   - permissions: Permissions requested, categorized by type of permission.
            ///   - accessGrantedAt: Date and time when the fine-grained personal access token was approved to access the organization.
            ///   - tokenId: Unique identifier of the user's token. This field can also be found in audit log events and the organization's settings for their PAT grants.
            ///   - tokenName: The name given to the user's token. This field can also be found in an organization's settings page for Active Tokens.
            ///   - tokenExpired: Whether the associated fine-grained personal access token has expired.
            ///   - tokenExpiresAt: Date and time when the associated fine-grained personal access token expires.
            ///   - tokenLastUsedAt: Date and time when the associated fine-grained personal access token was last used for authentication.
            public init(
                id: Swift.Int,
                owner: Components.Schemas.SimpleUser,
                repositorySelection: Components.Schemas.OrganizationProgrammaticAccessGrant.RepositorySelectionPayload,
                repositoriesUrl: Swift.String,
                permissions: Components.Schemas.OrganizationProgrammaticAccessGrant.PermissionsPayload,
                accessGrantedAt: Swift.String,
                tokenId: Swift.Int,
                tokenName: Swift.String,
                tokenExpired: Swift.Bool,
                tokenExpiresAt: Swift.String? = nil,
                tokenLastUsedAt: Swift.String? = nil
            ) {
                self.id = id
                self.owner = owner
                self.repositorySelection = repositorySelection
                self.repositoriesUrl = repositoriesUrl
                self.permissions = permissions
                self.accessGrantedAt = accessGrantedAt
                self.tokenId = tokenId
                self.tokenName = tokenName
                self.tokenExpired = tokenExpired
                self.tokenExpiresAt = tokenExpiresAt
                self.tokenLastUsedAt = tokenLastUsedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case owner
                case repositorySelection = "repository_selection"
                case repositoriesUrl = "repositories_url"
                case permissions
                case accessGrantedAt = "access_granted_at"
                case tokenId = "token_id"
                case tokenName = "token_name"
                case tokenExpired = "token_expired"
                case tokenExpiresAt = "token_expires_at"
                case tokenLastUsedAt = "token_last_used_at"
            }
        }
        /// Custom property defined on an organization
        ///
        /// - Remark: Generated from `#/components/schemas/custom-property`.
        public struct CustomProperty: Codable, Hashable, Sendable {
            /// The name of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/property_name`.
            public var propertyName: Swift.String
            /// The URL that can be used to fetch, update, or delete info about this property via the API.
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/url`.
            public var url: Swift.String?
            /// The source type of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/source_type`.
            @frozen public enum SourceTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case organization = "organization"
                case enterprise = "enterprise"
            }
            /// The source type of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/source_type`.
            public var sourceType: Components.Schemas.CustomProperty.SourceTypePayload?
            /// The type of the value for the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/value_type`.
            @frozen public enum ValueTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case string = "string"
                case singleSelect = "single_select"
                case multiSelect = "multi_select"
                case trueFalse = "true_false"
            }
            /// The type of the value for the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/value_type`.
            public var valueType: Components.Schemas.CustomProperty.ValueTypePayload
            /// Whether the property is required.
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/required`.
            public var required: Swift.Bool?
            /// Default value of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/default_value`.
            @frozen public enum DefaultValuePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/custom-property/default_value/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/custom-property/default_value/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// Default value of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/default_value`.
            public var defaultValue: Components.Schemas.CustomProperty.DefaultValuePayload?
            /// Short description of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/description`.
            public var description: Swift.String?
            /// An ordered list of the allowed values of the property.
            /// The property can have up to 200 allowed values.
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/allowed_values`.
            public var allowedValues: [Swift.String]?
            /// Who can edit the values of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/values_editable_by`.
            @frozen public enum ValuesEditableByPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case orgActors = "org_actors"
                case orgAndRepoActors = "org_and_repo_actors"
            }
            /// Who can edit the values of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property/values_editable_by`.
            public var valuesEditableBy: Components.Schemas.CustomProperty.ValuesEditableByPayload?
            /// Creates a new `CustomProperty`.
            ///
            /// - Parameters:
            ///   - propertyName: The name of the property
            ///   - url: The URL that can be used to fetch, update, or delete info about this property via the API.
            ///   - sourceType: The source type of the property
            ///   - valueType: The type of the value for the property
            ///   - required: Whether the property is required.
            ///   - defaultValue: Default value of the property
            ///   - description: Short description of the property
            ///   - allowedValues: An ordered list of the allowed values of the property.
            ///   - valuesEditableBy: Who can edit the values of the property
            public init(
                propertyName: Swift.String,
                url: Swift.String? = nil,
                sourceType: Components.Schemas.CustomProperty.SourceTypePayload? = nil,
                valueType: Components.Schemas.CustomProperty.ValueTypePayload,
                required: Swift.Bool? = nil,
                defaultValue: Components.Schemas.CustomProperty.DefaultValuePayload? = nil,
                description: Swift.String? = nil,
                allowedValues: [Swift.String]? = nil,
                valuesEditableBy: Components.Schemas.CustomProperty.ValuesEditableByPayload? = nil
            ) {
                self.propertyName = propertyName
                self.url = url
                self.sourceType = sourceType
                self.valueType = valueType
                self.required = required
                self.defaultValue = defaultValue
                self.description = description
                self.allowedValues = allowedValues
                self.valuesEditableBy = valuesEditableBy
            }
            public enum CodingKeys: String, CodingKey {
                case propertyName = "property_name"
                case url
                case sourceType = "source_type"
                case valueType = "value_type"
                case required
                case defaultValue = "default_value"
                case description
                case allowedValues = "allowed_values"
                case valuesEditableBy = "values_editable_by"
            }
        }
        /// Custom property set payload
        ///
        /// - Remark: Generated from `#/components/schemas/custom-property-set-payload`.
        public struct CustomPropertySetPayload: Codable, Hashable, Sendable {
            /// The type of the value for the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/value_type`.
            @frozen public enum ValueTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case string = "string"
                case singleSelect = "single_select"
                case multiSelect = "multi_select"
                case trueFalse = "true_false"
            }
            /// The type of the value for the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/value_type`.
            public var valueType: Components.Schemas.CustomPropertySetPayload.ValueTypePayload
            /// Whether the property is required.
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/required`.
            public var required: Swift.Bool?
            /// Default value of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/default_value`.
            @frozen public enum DefaultValuePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/default_value/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/default_value/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// Default value of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/default_value`.
            public var defaultValue: Components.Schemas.CustomPropertySetPayload.DefaultValuePayload?
            /// Short description of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/description`.
            public var description: Swift.String?
            /// An ordered list of the allowed values of the property.
            /// The property can have up to 200 allowed values.
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/allowed_values`.
            public var allowedValues: [Swift.String]?
            /// Who can edit the values of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/values_editable_by`.
            @frozen public enum ValuesEditableByPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case orgActors = "org_actors"
                case orgAndRepoActors = "org_and_repo_actors"
            }
            /// Who can edit the values of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-set-payload/values_editable_by`.
            public var valuesEditableBy: Components.Schemas.CustomPropertySetPayload.ValuesEditableByPayload?
            /// Creates a new `CustomPropertySetPayload`.
            ///
            /// - Parameters:
            ///   - valueType: The type of the value for the property
            ///   - required: Whether the property is required.
            ///   - defaultValue: Default value of the property
            ///   - description: Short description of the property
            ///   - allowedValues: An ordered list of the allowed values of the property.
            ///   - valuesEditableBy: Who can edit the values of the property
            public init(
                valueType: Components.Schemas.CustomPropertySetPayload.ValueTypePayload,
                required: Swift.Bool? = nil,
                defaultValue: Components.Schemas.CustomPropertySetPayload.DefaultValuePayload? = nil,
                description: Swift.String? = nil,
                allowedValues: [Swift.String]? = nil,
                valuesEditableBy: Components.Schemas.CustomPropertySetPayload.ValuesEditableByPayload? = nil
            ) {
                self.valueType = valueType
                self.required = required
                self.defaultValue = defaultValue
                self.description = description
                self.allowedValues = allowedValues
                self.valuesEditableBy = valuesEditableBy
            }
            public enum CodingKeys: String, CodingKey {
                case valueType = "value_type"
                case required
                case defaultValue = "default_value"
                case description
                case allowedValues = "allowed_values"
                case valuesEditableBy = "values_editable_by"
            }
        }
        /// Custom property name and associated value
        ///
        /// - Remark: Generated from `#/components/schemas/custom-property-value`.
        public struct CustomPropertyValue: Codable, Hashable, Sendable {
            /// The name of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-value/property_name`.
            public var propertyName: Swift.String
            /// The value assigned to the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-value/value`.
            @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/custom-property-value/value/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/custom-property-value/value/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// The value assigned to the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-value/value`.
            public var value: Components.Schemas.CustomPropertyValue.ValuePayload?
            /// Creates a new `CustomPropertyValue`.
            ///
            /// - Parameters:
            ///   - propertyName: The name of the property
            ///   - value: The value assigned to the property
            public init(
                propertyName: Swift.String,
                value: Components.Schemas.CustomPropertyValue.ValuePayload? = nil
            ) {
                self.propertyName = propertyName
                self.value = value
            }
            public enum CodingKeys: String, CodingKey {
                case propertyName = "property_name"
                case value
            }
        }
        /// List of custom property values for a repository
        ///
        /// - Remark: Generated from `#/components/schemas/org-repo-custom-property-values`.
        public struct OrgRepoCustomPropertyValues: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/org-repo-custom-property-values/repository_id`.
            public var repositoryId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/org-repo-custom-property-values/repository_name`.
            public var repositoryName: Swift.String
            /// - Remark: Generated from `#/components/schemas/org-repo-custom-property-values/repository_full_name`.
            public var repositoryFullName: Swift.String
            /// List of custom property names and associated values
            ///
            /// - Remark: Generated from `#/components/schemas/org-repo-custom-property-values/properties`.
            public var properties: [Components.Schemas.CustomPropertyValue]
            /// Creates a new `OrgRepoCustomPropertyValues`.
            ///
            /// - Parameters:
            ///   - repositoryId:
            ///   - repositoryName:
            ///   - repositoryFullName:
            ///   - properties: List of custom property names and associated values
            public init(
                repositoryId: Swift.Int,
                repositoryName: Swift.String,
                repositoryFullName: Swift.String,
                properties: [Components.Schemas.CustomPropertyValue]
            ) {
                self.repositoryId = repositoryId
                self.repositoryName = repositoryName
                self.repositoryFullName = repositoryFullName
                self.properties = properties
            }
            public enum CodingKeys: String, CodingKey {
                case repositoryId = "repository_id"
                case repositoryName = "repository_name"
                case repositoryFullName = "repository_full_name"
                case properties
            }
        }
        /// The historical version of a ruleset
        ///
        /// - Remark: Generated from `#/components/schemas/ruleset-version`.
        public struct RulesetVersion: Codable, Hashable, Sendable {
            /// The ID of the previous version of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/ruleset-version/version_id`.
            public var versionId: Swift.Int
            /// The actor who updated the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/ruleset-version/actor`.
            public struct ActorPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/ruleset-version/actor/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/ruleset-version/actor/type`.
                public var _type: Swift.String?
                /// Creates a new `ActorPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - _type:
                public init(
                    id: Swift.Int? = nil,
                    _type: Swift.String? = nil
                ) {
                    self.id = id
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case _type = "type"
                }
            }
            /// The actor who updated the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/ruleset-version/actor`.
            public var actor: Components.Schemas.RulesetVersion.ActorPayload
            /// - Remark: Generated from `#/components/schemas/ruleset-version/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `RulesetVersion`.
            ///
            /// - Parameters:
            ///   - versionId: The ID of the previous version of the ruleset
            ///   - actor: The actor who updated the ruleset
            ///   - updatedAt:
            public init(
                versionId: Swift.Int,
                actor: Components.Schemas.RulesetVersion.ActorPayload,
                updatedAt: Foundation.Date
            ) {
                self.versionId = versionId
                self.actor = actor
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case versionId = "version_id"
                case actor
                case updatedAt = "updated_at"
            }
        }
        /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state`.
        public struct RulesetVersionWithState: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value1`.
            public var value1: Components.Schemas.RulesetVersion
            /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value2`.
            public struct Value2Payload: Codable, Hashable, Sendable {
                /// The state of the ruleset version
                ///
                /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value2/state`.
                public var state: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `Value2Payload`.
                ///
                /// - Parameters:
                ///   - state: The state of the ruleset version
                public init(state: OpenAPIRuntime.OpenAPIObjectContainer) {
                    self.state = state
                }
                public enum CodingKeys: String, CodingKey {
                    case state
                }
            }
            /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value2`.
            public var value2: Components.Schemas.RulesetVersionWithState.Value2Payload
            /// Creates a new `RulesetVersionWithState`.
            ///
            /// - Parameters:
            ///   - value1:
            ///   - value2:
            public init(
                value1: Components.Schemas.RulesetVersion,
                value2: Components.Schemas.RulesetVersionWithState.Value2Payload
            ) {
                self.value1 = value1
                self.value2 = value2
            }
            public init(from decoder: any Decoder) throws {
                self.value1 = try .init(from: decoder)
                self.value2 = try .init(from: decoder)
            }
            public func encode(to encoder: any Encoder) throws {
                try self.value1.encode(to: encoder)
                try self.value2.encode(to: encoder)
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
        ///
        /// - Remark: Generated from `#/components/parameters/cursor`.
        public typealias Cursor = Swift.String
        /// - Remark: Generated from `#/components/parameters/delivery-id`.
        public typealias DeliveryId = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// An organization ID. Only return organizations with an ID greater than this ID.
        ///
        /// - Remark: Generated from `#/components/parameters/since-org`.
        public typealias SinceOrg = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
        ///
        /// - Remark: Generated from `#/components/parameters/hook-id`.
        public typealias HookId = Swift.Int
        /// The type of the actor
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-actor-type`.
        @frozen public enum ApiInsightsActorType: String, Codable, Hashable, Sendable, CaseIterable {
            case installation = "installation"
            case classicPat = "classic_pat"
            case fineGrainedPat = "fine_grained_pat"
            case oauthApp = "oauth_app"
            case githubAppUserToServer = "github_app_user_to_server"
        }
        /// The ID of the actor
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-actor-id`.
        public typealias ApiInsightsActorId = Swift.Int
        /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-min-timestamp`.
        public typealias ApiInsightsMinTimestamp = Swift.String
        /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-max-timestamp`.
        public typealias ApiInsightsMaxTimestamp = Swift.String
        /// - Remark: Generated from `#/components/parameters/ApiInsightsRouteStatsSort`.
        @frozen public enum ApiInsightsRouteStatsSortPayload: String, Codable, Hashable, Sendable, CaseIterable {
            case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
            case lastRequestTimestamp = "last_request_timestamp"
            case rateLimitedRequestCount = "rate_limited_request_count"
            case httpMethod = "http_method"
            case apiRoute = "api_route"
            case totalRequestCount = "total_request_count"
        }
        /// The property to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-route-stats-sort`.
        public typealias ApiInsightsRouteStatsSort = [Components.Parameters.ApiInsightsRouteStatsSortPayload]
        /// Providing a substring will filter results where the API route contains the substring. This is a case-insensitive search.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-api-route-substring`.
        public typealias ApiInsightsApiRouteSubstring = Swift.String
        /// - Remark: Generated from `#/components/parameters/ApiInsightsSort`.
        @frozen public enum ApiInsightsSortPayload: String, Codable, Hashable, Sendable, CaseIterable {
            case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
            case lastRequestTimestamp = "last_request_timestamp"
            case rateLimitedRequestCount = "rate_limited_request_count"
            case subjectName = "subject_name"
            case totalRequestCount = "total_request_count"
        }
        /// The property to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-sort`.
        public typealias ApiInsightsSort = [Components.Parameters.ApiInsightsSortPayload]
        /// Providing a substring will filter results where the subject name contains the substring. This is a case-insensitive search.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-subject-name-substring`.
        public typealias ApiInsightsSubjectNameSubstring = Swift.String
        /// The ID of the user to query for stats
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-user-id`.
        public typealias ApiInsightsUserId = Swift.String
        /// The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-timestamp-increment`.
        public typealias ApiInsightsTimestampIncrement = Swift.String
        /// Providing a substring will filter results where the actor name contains the substring. This is a case-insensitive search.
        ///
        /// - Remark: Generated from `#/components/parameters/api-insights-actor-name-substring`.
        public typealias ApiInsightsActorNameSubstring = Swift.String
        /// The unique identifier of the invitation.
        ///
        /// - Remark: Generated from `#/components/parameters/invitation-id`.
        public typealias InvitationId = Swift.Int
        /// The unique identifier of the issue type.
        ///
        /// - Remark: Generated from `#/components/parameters/issue-type-id`.
        public typealias IssueTypeId = Swift.Int
        /// The slug of the team name.
        ///
        /// - Remark: Generated from `#/components/parameters/team-slug`.
        public typealias TeamSlug = Swift.String
        /// The unique identifier of the role.
        ///
        /// - Remark: Generated from `#/components/parameters/role-id`.
        public typealias RoleId = Swift.Int
        /// The property by which to sort the results.
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-sort`.
        @frozen public enum PersonalAccessTokenSort: String, Codable, Hashable, Sendable, CaseIterable {
            case createdAt = "created_at"
        }
        /// A list of owner usernames to use to filter the results.
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-owner`.
        public typealias PersonalAccessTokenOwner = [Swift.String]
        /// The name of the repository to use to filter the results.
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-repository`.
        public typealias PersonalAccessTokenRepository = Swift.String
        /// The permission to use to filter the results.
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-permission`.
        public typealias PersonalAccessTokenPermission = Swift.String
        /// Only show fine-grained personal access tokens used before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-before`.
        public typealias PersonalAccessTokenBefore = Foundation.Date
        /// Only show fine-grained personal access tokens used after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-after`.
        public typealias PersonalAccessTokenAfter = Foundation.Date
        /// The ID of the token
        ///
        /// - Remark: Generated from `#/components/parameters/personal-access-token-token-id`.
        public typealias PersonalAccessTokenTokenId = [Swift.String]
        /// The unique identifier of the fine-grained personal access token.
        ///
        /// - Remark: Generated from `#/components/parameters/fine-grained-personal-access-token-id`.
        public typealias FineGrainedPersonalAccessTokenId = Swift.Int
        /// The custom property name
        ///
        /// - Remark: Generated from `#/components/parameters/custom-property-name`.
        public typealias CustomPropertyName = Swift.String
        /// The security feature to enable or disable.
        ///
        /// - Remark: Generated from `#/components/parameters/security-product`.
        @frozen public enum SecurityProduct: String, Codable, Hashable, Sendable, CaseIterable {
            case dependencyGraph = "dependency_graph"
            case dependabotAlerts = "dependabot_alerts"
            case dependabotSecurityUpdates = "dependabot_security_updates"
            case advancedSecurity = "advanced_security"
            case codeScanningDefaultSetup = "code_scanning_default_setup"
            case secretScanning = "secret_scanning"
            case secretScanningPushProtection = "secret_scanning_push_protection"
        }
        /// The action to take.
        ///
        /// `enable_all` means to enable the specified security feature for all repositories in the organization.
        /// `disable_all` means to disable the specified security feature for all repositories in the organization.
        ///
        /// - Remark: Generated from `#/components/parameters/org-security-product-enablement`.
        @frozen public enum OrgSecurityProductEnablement: String, Codable, Hashable, Sendable, CaseIterable {
            case enableAll = "enable_all"
            case disableAll = "disable_all"
        }
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Accepted: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/accepted/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/accepted/content/application\/json`.
                case json(OpenAPIRuntime.OpenAPIObjectContainer)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: OpenAPIRuntime.OpenAPIObjectContainer {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Accepted.Body
            /// Creates a new `Accepted`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Accepted.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct InternalError: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/internal_error/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/internal_error/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.InternalError.Body
            /// Creates a new `InternalError`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.InternalError.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
        public struct NoContent: Sendable, Hashable {
            /// Creates a new `NoContent`.
            public init() {}
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List organizations
    ///
    /// Lists all organizations, in the order that they were created.
    ///
    /// > [!NOTE]
    /// > Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.
    ///
    /// - Remark: HTTP `GET /organizations`.
    /// - Remark: Generated from `#/paths//organizations/get(orgs/list)`.
    public enum OrgsList {
        public static let id: Swift.String = "orgs/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/organizations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// An organization ID. Only return organizations with an ID greater than this ID.
                ///
                /// - Remark: Generated from `#/paths/organizations/GET/query/since`.
                public var since: Components.Parameters.SinceOrg?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/organizations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: An organization ID. Only return organizations with an ID greater than this ID.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.SinceOrg? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                }
            }
            public var query: Operations.OrgsList.Input.Query
            /// - Remark: Generated from `#/paths/organizations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.OrgsList.Input.Query = .init(),
                headers: Operations.OrgsList.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/organizations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/organizations/GET/responses/200/headers/Link`.
                    public var link: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Swift.String? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/organizations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/organizations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationSimple])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationSimple] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsList.Output.Ok.Headers = .init(),
                    body: Operations.OrgsList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//organizations/get(orgs/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//organizations/get(orgs/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//organizations/get(orgs/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization
    ///
    /// Gets information about an organization.
    ///
    /// When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, outside collaborators, guest collaborators, repository collaborators, or everyone with access to any repository within the organization to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
    ///
    /// To see the full details about an organization, the authenticated user must be an organization owner.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.
    ///
    /// To see information about an organization's GitHub plan, GitHub Apps need the `Organization plan` permission.
    ///
    /// - Remark: HTTP `GET /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/get(orgs/get)`.
    public enum OrgsGet {
        public static let id: Swift.String = "orgs/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsGet.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsGet.Input.Path,
                headers: Operations.OrgsGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.OrganizationFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrganizationFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/get(orgs/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/get(orgs/get)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Code security product enablement for new repositories through the organization API is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization) to set defaults instead. For more information on setting a default security configuration, see the [changelog](https://github.blog/changelog/2024-07-09-sunsetting-security-settings-defaults-parameters-in-the-organizations-rest-api/).
    ///
    /// Updates the organization's profile and member privileges.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)`.
    public enum OrgsUpdate {
        public static let id: Swift.String = "orgs/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsUpdate.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Billing email address. This address is not publicized.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/billing_email`.
                    public var billingEmail: Swift.String?
                    /// The company name.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/company`.
                    public var company: Swift.String?
                    /// The publicly visible email address.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/email`.
                    public var email: Swift.String?
                    /// The Twitter username of the company.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/twitter_username`.
                    public var twitterUsername: Swift.String?
                    /// The location.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/location`.
                    public var location: Swift.String?
                    /// The shorthand name of the company.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// The description of the company. The maximum size is 160 characters.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// Whether an organization can use organization projects.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/has_organization_projects`.
                    public var hasOrganizationProjects: Swift.Bool?
                    /// Whether repositories that belong to the organization can use repository projects.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/has_repository_projects`.
                    public var hasRepositoryProjects: Swift.Bool?
                    /// Default permission level members have for organization repositories.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/default_repository_permission`.
                    @frozen public enum DefaultRepositoryPermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                        case none = "none"
                    }
                    /// Default permission level members have for organization repositories.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/default_repository_permission`.
                    public var defaultRepositoryPermission: Operations.OrgsUpdate.Input.Body.JsonPayload.DefaultRepositoryPermissionPayload?
                    /// Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_repositories`.
                    public var membersCanCreateRepositories: Swift.Bool?
                    /// Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_internal_repositories`.
                    public var membersCanCreateInternalRepositories: Swift.Bool?
                    /// Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_private_repositories`.
                    public var membersCanCreatePrivateRepositories: Swift.Bool?
                    /// Whether organization members can create public repositories, which are visible to anyone. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_public_repositories`.
                    public var membersCanCreatePublicRepositories: Swift.Bool?
                    /// Specifies which types of repositories non-admin organization members can create. `private` is only available to repositories that are part of an organization on GitHub Enterprise Cloud. 
                    /// **Note:** This parameter is closing down and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_allowed_repository_creation_type`.
                    @frozen public enum MembersAllowedRepositoryCreationTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case _private = "private"
                        case none = "none"
                    }
                    /// Specifies which types of repositories non-admin organization members can create. `private` is only available to repositories that are part of an organization on GitHub Enterprise Cloud. 
                    /// **Note:** This parameter is closing down and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_allowed_repository_creation_type`.
                    public var membersAllowedRepositoryCreationType: Operations.OrgsUpdate.Input.Body.JsonPayload.MembersAllowedRepositoryCreationTypePayload?
                    /// Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_pages`.
                    public var membersCanCreatePages: Swift.Bool?
                    /// Whether organization members can create public GitHub Pages sites. Existing published sites will not be impacted.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_public_pages`.
                    public var membersCanCreatePublicPages: Swift.Bool?
                    /// Whether organization members can create private GitHub Pages sites. Existing published sites will not be impacted.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_create_private_pages`.
                    public var membersCanCreatePrivatePages: Swift.Bool?
                    /// Whether organization members can fork private organization repositories.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/members_can_fork_private_repositories`.
                    public var membersCanForkPrivateRepositories: Swift.Bool?
                    /// Whether contributors to organization repositories are required to sign off on commits they make through GitHub's web interface.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/web_commit_signoff_required`.
                    public var webCommitSignoffRequired: Swift.Bool?
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/blog`.
                    public var blog: Swift.String?
                    /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///
                    /// Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to this organization.
                    ///
                    /// To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
                    ///
                    /// You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/advanced_security_enabled_for_new_repositories`.
                    @available(*, deprecated)
                    public var advancedSecurityEnabledForNewRepositories: Swift.Bool?
                    /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///
                    /// Whether Dependabot alerts are automatically enabled for new repositories and repositories transferred to this organization.
                    ///
                    /// To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
                    ///
                    /// You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/dependabot_alerts_enabled_for_new_repositories`.
                    @available(*, deprecated)
                    public var dependabotAlertsEnabledForNewRepositories: Swift.Bool?
                    /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///
                    /// Whether Dependabot security updates are automatically enabled for new repositories and repositories transferred to this organization.
                    ///
                    /// To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
                    ///
                    /// You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/dependabot_security_updates_enabled_for_new_repositories`.
                    @available(*, deprecated)
                    public var dependabotSecurityUpdatesEnabledForNewRepositories: Swift.Bool?
                    /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///
                    /// Whether dependency graph is automatically enabled for new repositories and repositories transferred to this organization.
                    ///
                    /// To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
                    ///
                    /// You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/dependency_graph_enabled_for_new_repositories`.
                    @available(*, deprecated)
                    public var dependencyGraphEnabledForNewRepositories: Swift.Bool?
                    /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///
                    /// Whether secret scanning is automatically enabled for new repositories and repositories transferred to this organization.
                    ///
                    /// To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
                    ///
                    /// You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/secret_scanning_enabled_for_new_repositories`.
                    @available(*, deprecated)
                    public var secretScanningEnabledForNewRepositories: Swift.Bool?
                    /// **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///
                    /// Whether secret scanning push protection is automatically enabled for new repositories and repositories transferred to this organization.
                    ///
                    /// To use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
                    ///
                    /// You can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/secret_scanning_push_protection_enabled_for_new_repositories`.
                    @available(*, deprecated)
                    public var secretScanningPushProtectionEnabledForNewRepositories: Swift.Bool?
                    /// Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/secret_scanning_push_protection_custom_link_enabled`.
                    public var secretScanningPushProtectionCustomLinkEnabled: Swift.Bool?
                    /// If `secret_scanning_push_protection_custom_link_enabled` is true, the URL that will be displayed to contributors who are blocked from pushing a secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/secret_scanning_push_protection_custom_link`.
                    public var secretScanningPushProtectionCustomLink: Swift.String?
                    /// Controls whether or not deploy keys may be added and used for repositories in the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/json/deploy_keys_enabled_for_repositories`.
                    public var deployKeysEnabledForRepositories: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - billingEmail: Billing email address. This address is not publicized.
                    ///   - company: The company name.
                    ///   - email: The publicly visible email address.
                    ///   - twitterUsername: The Twitter username of the company.
                    ///   - location: The location.
                    ///   - name: The shorthand name of the company.
                    ///   - description: The description of the company. The maximum size is 160 characters.
                    ///   - hasOrganizationProjects: Whether an organization can use organization projects.
                    ///   - hasRepositoryProjects: Whether repositories that belong to the organization can use repository projects.
                    ///   - defaultRepositoryPermission: Default permission level members have for organization repositories.
                    ///   - membersCanCreateRepositories: Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
                    ///   - membersCanCreateInternalRepositories: Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
                    ///   - membersCanCreatePrivateRepositories: Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
                    ///   - membersCanCreatePublicRepositories: Whether organization members can create public repositories, which are visible to anyone. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
                    ///   - membersAllowedRepositoryCreationType: Specifies which types of repositories non-admin organization members can create. `private` is only available to repositories that are part of an organization on GitHub Enterprise Cloud. 
                    ///   - membersCanCreatePages: Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted.
                    ///   - membersCanCreatePublicPages: Whether organization members can create public GitHub Pages sites. Existing published sites will not be impacted.
                    ///   - membersCanCreatePrivatePages: Whether organization members can create private GitHub Pages sites. Existing published sites will not be impacted.
                    ///   - membersCanForkPrivateRepositories: Whether organization members can fork private organization repositories.
                    ///   - webCommitSignoffRequired: Whether contributors to organization repositories are required to sign off on commits they make through GitHub's web interface.
                    ///   - blog:
                    ///   - advancedSecurityEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///   - dependabotAlertsEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///   - dependabotSecurityUpdatesEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///   - dependencyGraphEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///   - secretScanningEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///   - secretScanningPushProtectionEnabledForNewRepositories: **Endpoint closing down notice.** Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead.
                    ///   - secretScanningPushProtectionCustomLinkEnabled: Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.
                    ///   - secretScanningPushProtectionCustomLink: If `secret_scanning_push_protection_custom_link_enabled` is true, the URL that will be displayed to contributors who are blocked from pushing a secret.
                    ///   - deployKeysEnabledForRepositories: Controls whether or not deploy keys may be added and used for repositories in the organization.
                    public init(
                        billingEmail: Swift.String? = nil,
                        company: Swift.String? = nil,
                        email: Swift.String? = nil,
                        twitterUsername: Swift.String? = nil,
                        location: Swift.String? = nil,
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        hasOrganizationProjects: Swift.Bool? = nil,
                        hasRepositoryProjects: Swift.Bool? = nil,
                        defaultRepositoryPermission: Operations.OrgsUpdate.Input.Body.JsonPayload.DefaultRepositoryPermissionPayload? = nil,
                        membersCanCreateRepositories: Swift.Bool? = nil,
                        membersCanCreateInternalRepositories: Swift.Bool? = nil,
                        membersCanCreatePrivateRepositories: Swift.Bool? = nil,
                        membersCanCreatePublicRepositories: Swift.Bool? = nil,
                        membersAllowedRepositoryCreationType: Operations.OrgsUpdate.Input.Body.JsonPayload.MembersAllowedRepositoryCreationTypePayload? = nil,
                        membersCanCreatePages: Swift.Bool? = nil,
                        membersCanCreatePublicPages: Swift.Bool? = nil,
                        membersCanCreatePrivatePages: Swift.Bool? = nil,
                        membersCanForkPrivateRepositories: Swift.Bool? = nil,
                        webCommitSignoffRequired: Swift.Bool? = nil,
                        blog: Swift.String? = nil,
                        advancedSecurityEnabledForNewRepositories: Swift.Bool? = nil,
                        dependabotAlertsEnabledForNewRepositories: Swift.Bool? = nil,
                        dependabotSecurityUpdatesEnabledForNewRepositories: Swift.Bool? = nil,
                        dependencyGraphEnabledForNewRepositories: Swift.Bool? = nil,
                        secretScanningEnabledForNewRepositories: Swift.Bool? = nil,
                        secretScanningPushProtectionEnabledForNewRepositories: Swift.Bool? = nil,
                        secretScanningPushProtectionCustomLinkEnabled: Swift.Bool? = nil,
                        secretScanningPushProtectionCustomLink: Swift.String? = nil,
                        deployKeysEnabledForRepositories: Swift.Bool? = nil
                    ) {
                        self.billingEmail = billingEmail
                        self.company = company
                        self.email = email
                        self.twitterUsername = twitterUsername
                        self.location = location
                        self.name = name
                        self.description = description
                        self.hasOrganizationProjects = hasOrganizationProjects
                        self.hasRepositoryProjects = hasRepositoryProjects
                        self.defaultRepositoryPermission = defaultRepositoryPermission
                        self.membersCanCreateRepositories = membersCanCreateRepositories
                        self.membersCanCreateInternalRepositories = membersCanCreateInternalRepositories
                        self.membersCanCreatePrivateRepositories = membersCanCreatePrivateRepositories
                        self.membersCanCreatePublicRepositories = membersCanCreatePublicRepositories
                        self.membersAllowedRepositoryCreationType = membersAllowedRepositoryCreationType
                        self.membersCanCreatePages = membersCanCreatePages
                        self.membersCanCreatePublicPages = membersCanCreatePublicPages
                        self.membersCanCreatePrivatePages = membersCanCreatePrivatePages
                        self.membersCanForkPrivateRepositories = membersCanForkPrivateRepositories
                        self.webCommitSignoffRequired = webCommitSignoffRequired
                        self.blog = blog
                        self.advancedSecurityEnabledForNewRepositories = advancedSecurityEnabledForNewRepositories
                        self.dependabotAlertsEnabledForNewRepositories = dependabotAlertsEnabledForNewRepositories
                        self.dependabotSecurityUpdatesEnabledForNewRepositories = dependabotSecurityUpdatesEnabledForNewRepositories
                        self.dependencyGraphEnabledForNewRepositories = dependencyGraphEnabledForNewRepositories
                        self.secretScanningEnabledForNewRepositories = secretScanningEnabledForNewRepositories
                        self.secretScanningPushProtectionEnabledForNewRepositories = secretScanningPushProtectionEnabledForNewRepositories
                        self.secretScanningPushProtectionCustomLinkEnabled = secretScanningPushProtectionCustomLinkEnabled
                        self.secretScanningPushProtectionCustomLink = secretScanningPushProtectionCustomLink
                        self.deployKeysEnabledForRepositories = deployKeysEnabledForRepositories
                    }
                    public enum CodingKeys: String, CodingKey {
                        case billingEmail = "billing_email"
                        case company
                        case email
                        case twitterUsername = "twitter_username"
                        case location
                        case name
                        case description
                        case hasOrganizationProjects = "has_organization_projects"
                        case hasRepositoryProjects = "has_repository_projects"
                        case defaultRepositoryPermission = "default_repository_permission"
                        case membersCanCreateRepositories = "members_can_create_repositories"
                        case membersCanCreateInternalRepositories = "members_can_create_internal_repositories"
                        case membersCanCreatePrivateRepositories = "members_can_create_private_repositories"
                        case membersCanCreatePublicRepositories = "members_can_create_public_repositories"
                        case membersAllowedRepositoryCreationType = "members_allowed_repository_creation_type"
                        case membersCanCreatePages = "members_can_create_pages"
                        case membersCanCreatePublicPages = "members_can_create_public_pages"
                        case membersCanCreatePrivatePages = "members_can_create_private_pages"
                        case membersCanForkPrivateRepositories = "members_can_fork_private_repositories"
                        case webCommitSignoffRequired = "web_commit_signoff_required"
                        case blog
                        case advancedSecurityEnabledForNewRepositories = "advanced_security_enabled_for_new_repositories"
                        case dependabotAlertsEnabledForNewRepositories = "dependabot_alerts_enabled_for_new_repositories"
                        case dependabotSecurityUpdatesEnabledForNewRepositories = "dependabot_security_updates_enabled_for_new_repositories"
                        case dependencyGraphEnabledForNewRepositories = "dependency_graph_enabled_for_new_repositories"
                        case secretScanningEnabledForNewRepositories = "secret_scanning_enabled_for_new_repositories"
                        case secretScanningPushProtectionEnabledForNewRepositories = "secret_scanning_push_protection_enabled_for_new_repositories"
                        case secretScanningPushProtectionCustomLinkEnabled = "secret_scanning_push_protection_custom_link_enabled"
                        case secretScanningPushProtectionCustomLink = "secret_scanning_push_protection_custom_link"
                        case deployKeysEnabledForRepositories = "deploy_keys_enabled_for_repositories"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/requestBody/content/application\/json`.
                case json(Operations.OrgsUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsUpdate.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsUpdate.Input.Path,
                headers: Operations.OrgsUpdate.Input.Headers = .init(),
                body: Operations.OrgsUpdate.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.OrganizationFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrganizationFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/422/content/json`.
                    @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/422/content/json/case1`.
                        case ValidationError(Components.Schemas.ValidationError)
                        /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/422/content/json/case2`.
                        case ValidationErrorSimple(Components.Schemas.ValidationErrorSimple)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .ValidationError(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .ValidationErrorSimple(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .ValidationError(value):
                                try value.encode(to: encoder)
                            case let .ValidationErrorSimple(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/PATCH/responses/422/content/application\/json`.
                    case json(Operations.OrgsUpdate.Output.UnprocessableContent.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.OrgsUpdate.Output.UnprocessableContent.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsUpdate.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsUpdate.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Validation failed
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.OrgsUpdate.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.OrgsUpdate.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an organization
    ///
    /// Deletes an organization and all its repositories.
    ///
    /// The organization login will be unavailable for 90 days after deletion.
    ///
    /// Please review the Terms of Service regarding account deletion before using this endpoint:
    ///
    /// https://docs.github.com/site-policy/github-terms/github-terms-of-service
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)`.
    public enum OrgsDelete {
        public static let id: Swift.String = "orgs/delete"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsDelete.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDelete.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDelete.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsDelete.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsDelete.Input.Path,
                headers: Operations.OrgsDelete.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/bulk-list/post(orgs/list-attestations-bulk)`.
    public enum OrgsListAttestationsBulk {
        public static let id: Swift.String = "orgs/list-attestations-bulk"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListAttestationsBulk.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                }
            }
            public var query: Operations.OrgsListAttestationsBulk.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListAttestationsBulk.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListAttestationsBulk.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListAttestationsBulk.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// List of subject digests to fetch attestations for.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/requestBody/json/subject_digests`.
                    public var subjectDigests: [Swift.String]
                    /// Optional filter for fetching attestations with a given predicate type.
                    /// This option accepts `provenance`, `sbom`, or freeform text for custom predicate types.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/requestBody/json/predicate_type`.
                    public var predicateType: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - subjectDigests: List of subject digests to fetch attestations for.
                    ///   - predicateType: Optional filter for fetching attestations with a given predicate type.
                    public init(
                        subjectDigests: [Swift.String],
                        predicateType: Swift.String? = nil
                    ) {
                        self.subjectDigests = subjectDigests
                        self.predicateType = predicateType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case subjectDigests = "subject_digests"
                        case predicateType = "predicate_type"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/requestBody/content/application\/json`.
                case json(Operations.OrgsListAttestationsBulk.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsListAttestationsBulk.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsListAttestationsBulk.Input.Path,
                query: Operations.OrgsListAttestationsBulk.Input.Query = .init(),
                headers: Operations.OrgsListAttestationsBulk.Input.Headers = .init(),
                body: Operations.OrgsListAttestationsBulk.Input.Body
            ) {
                self.path = path
                self.query = query
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Mapping of subject digest to bundles.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests`.
                        public struct AttestationsSubjectDigestsPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload`.
                            public struct AdditionalPropertiesPayloadPayload: Codable, Hashable, Sendable {
                                /// The bundle of the attestation.
                                ///
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle`.
                                public struct BundlePayload: Codable, Hashable, Sendable {
                                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/mediaType`.
                                    public var mediaType: Swift.String?
                                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/verificationMaterial`.
                                    public struct VerificationMaterialPayload: Codable, Hashable, Sendable {
                                        /// A container of undocumented properties.
                                        public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                        /// Creates a new `VerificationMaterialPayload`.
                                        ///
                                        /// - Parameters:
                                        ///   - additionalProperties: A container of undocumented properties.
                                        public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                            self.additionalProperties = additionalProperties
                                        }
                                        public init(from decoder: any Decoder) throws {
                                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                        }
                                        public func encode(to encoder: any Encoder) throws {
                                            try encoder.encodeAdditionalProperties(additionalProperties)
                                        }
                                    }
                                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/verificationMaterial`.
                                    public var verificationMaterial: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.VerificationMaterialPayload?
                                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/dsseEnvelope`.
                                    public struct DsseEnvelopePayload: Codable, Hashable, Sendable {
                                        /// A container of undocumented properties.
                                        public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                        /// Creates a new `DsseEnvelopePayload`.
                                        ///
                                        /// - Parameters:
                                        ///   - additionalProperties: A container of undocumented properties.
                                        public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                            self.additionalProperties = additionalProperties
                                        }
                                        public init(from decoder: any Decoder) throws {
                                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                        }
                                        public func encode(to encoder: any Encoder) throws {
                                            try encoder.encodeAdditionalProperties(additionalProperties)
                                        }
                                    }
                                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/dsseEnvelope`.
                                    public var dsseEnvelope: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.DsseEnvelopePayload?
                                    /// Creates a new `BundlePayload`.
                                    ///
                                    /// - Parameters:
                                    ///   - mediaType:
                                    ///   - verificationMaterial:
                                    ///   - dsseEnvelope:
                                    public init(
                                        mediaType: Swift.String? = nil,
                                        verificationMaterial: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.VerificationMaterialPayload? = nil,
                                        dsseEnvelope: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.DsseEnvelopePayload? = nil
                                    ) {
                                        self.mediaType = mediaType
                                        self.verificationMaterial = verificationMaterial
                                        self.dsseEnvelope = dsseEnvelope
                                    }
                                    public enum CodingKeys: String, CodingKey {
                                        case mediaType
                                        case verificationMaterial
                                        case dsseEnvelope
                                    }
                                }
                                /// The bundle of the attestation.
                                ///
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle`.
                                public var bundle: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload?
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/repository_id`.
                                public var repositoryId: Swift.Int?
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle_url`.
                                public var bundleUrl: Swift.String?
                                /// Creates a new `AdditionalPropertiesPayloadPayload`.
                                ///
                                /// - Parameters:
                                ///   - bundle: The bundle of the attestation.
                                ///   - repositoryId:
                                ///   - bundleUrl:
                                public init(
                                    bundle: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload? = nil,
                                    repositoryId: Swift.Int? = nil,
                                    bundleUrl: Swift.String? = nil
                                ) {
                                    self.bundle = bundle
                                    self.repositoryId = repositoryId
                                    self.bundleUrl = bundleUrl
                                }
                                public enum CodingKeys: String, CodingKey {
                                    case bundle
                                    case repositoryId = "repository_id"
                                    case bundleUrl = "bundle_url"
                                }
                            }
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/additionalProperties`.
                            public typealias AdditionalPropertiesPayload = [Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload]
                            /// A container of undocumented properties.
                            public var additionalProperties: [String: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayload?]
                            /// Creates a new `AttestationsSubjectDigestsPayload`.
                            ///
                            /// - Parameters:
                            ///   - additionalProperties: A container of undocumented properties.
                            public init(additionalProperties: [String: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayload?] = .init()) {
                                self.additionalProperties = additionalProperties
                            }
                            public init(from decoder: any Decoder) throws {
                                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                            }
                            public func encode(to encoder: any Encoder) throws {
                                try encoder.encodeAdditionalProperties(additionalProperties)
                            }
                        }
                        /// Mapping of subject digest to bundles.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests`.
                        public var attestationsSubjectDigests: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload?
                        /// Information about the current page.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/page_info`.
                        public struct PageInfoPayload: Codable, Hashable, Sendable {
                            /// Indicates whether there is a next page.
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/page_info/has_next`.
                            public var hasNext: Swift.Bool?
                            /// Indicates whether there is a previous page.
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/page_info/has_previous`.
                            public var hasPrevious: Swift.Bool?
                            /// The cursor to the next page.
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/page_info/next`.
                            public var next: Swift.String?
                            /// The cursor to the previous page.
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/page_info/previous`.
                            public var previous: Swift.String?
                            /// Creates a new `PageInfoPayload`.
                            ///
                            /// - Parameters:
                            ///   - hasNext: Indicates whether there is a next page.
                            ///   - hasPrevious: Indicates whether there is a previous page.
                            ///   - next: The cursor to the next page.
                            ///   - previous: The cursor to the previous page.
                            public init(
                                hasNext: Swift.Bool? = nil,
                                hasPrevious: Swift.Bool? = nil,
                                next: Swift.String? = nil,
                                previous: Swift.String? = nil
                            ) {
                                self.hasNext = hasNext
                                self.hasPrevious = hasPrevious
                                self.next = next
                                self.previous = previous
                            }
                            public enum CodingKeys: String, CodingKey {
                                case hasNext = "has_next"
                                case hasPrevious = "has_previous"
                                case next
                                case previous
                            }
                        }
                        /// Information about the current page.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/json/page_info`.
                        public var pageInfo: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.PageInfoPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - attestationsSubjectDigests: Mapping of subject digest to bundles.
                        ///   - pageInfo: Information about the current page.
                        public init(
                            attestationsSubjectDigests: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload? = nil,
                            pageInfo: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.PageInfoPayload? = nil
                        ) {
                            self.attestationsSubjectDigests = attestationsSubjectDigests
                            self.pageInfo = pageInfo
                        }
                        public enum CodingKeys: String, CodingKey {
                            case attestationsSubjectDigests = "attestations_subject_digests"
                            case pageInfo = "page_info"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/bulk-list/POST/responses/200/content/application\/json`.
                    case json(Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListAttestationsBulk.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsListAttestationsBulk.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/bulk-list/post(orgs/list-attestations-bulk)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListAttestationsBulk.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListAttestationsBulk.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)`.
    public enum OrgsDeleteAttestationsBulk {
        public static let id: Swift.String = "orgs/delete-attestations-bulk"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsDeleteAttestationsBulk.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteAttestationsBulk.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteAttestationsBulk.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsDeleteAttestationsBulk.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// The request body must include either `subject_digests` or `attestation_ids`, but not both.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// List of subject digests associated with the artifact attestations to delete.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json/case1/subject_digests`.
                        public var subjectDigests: [Swift.String]
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - subjectDigests: List of subject digests associated with the artifact attestations to delete.
                        public init(subjectDigests: [Swift.String]) {
                            self.subjectDigests = subjectDigests
                        }
                        public enum CodingKeys: String, CodingKey {
                            case subjectDigests = "subject_digests"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json/case1`.
                    case case1(Operations.OrgsDeleteAttestationsBulk.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json/case2`.
                    public struct Case2Payload: Codable, Hashable, Sendable {
                        /// List of unique IDs associated with the artifact attestations to delete.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json/case2/attestation_ids`.
                        public var attestationIds: [Swift.Int]
                        /// Creates a new `Case2Payload`.
                        ///
                        /// - Parameters:
                        ///   - attestationIds: List of unique IDs associated with the artifact attestations to delete.
                        public init(attestationIds: [Swift.Int]) {
                            self.attestationIds = attestationIds
                        }
                        public enum CodingKeys: String, CodingKey {
                            case attestationIds = "attestation_ids"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/json/case2`.
                    case case2(Operations.OrgsDeleteAttestationsBulk.Input.Body.JsonPayload.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/delete-request/POST/requestBody/content/application\/json`.
                case json(Operations.OrgsDeleteAttestationsBulk.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsDeleteAttestationsBulk.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsDeleteAttestationsBulk.Input.Path,
                headers: Operations.OrgsDeleteAttestationsBulk.Input.Headers = .init(),
                body: Operations.OrgsDeleteAttestationsBulk.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// Creates a new `Ok`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsDeleteAttestationsBulk.Output.Ok)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            public static var ok: Self {
                .ok(.init())
            }
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsDeleteAttestationsBulk.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)`.
    public enum OrgsDeleteAttestationsBySubjectDigest {
        public static let id: Swift.String = "orgs/delete-attestations-by-subject-digest"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/digest/{subject_digest}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/digest/{subject_digest}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Subject Digest
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/digest/{subject_digest}/DELETE/path/subject_digest`.
                public var subjectDigest: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - subjectDigest: Subject Digest
                public init(
                    org: Components.Parameters.Org,
                    subjectDigest: Swift.String
                ) {
                    self.org = org
                    self.subjectDigest = subjectDigest
                }
            }
            public var path: Operations.OrgsDeleteAttestationsBySubjectDigest.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/digest/{subject_digest}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteAttestationsBySubjectDigest.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteAttestationsBySubjectDigest.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsDeleteAttestationsBySubjectDigest.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsDeleteAttestationsBySubjectDigest.Input.Path,
                headers: Operations.OrgsDeleteAttestationsBySubjectDigest.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// Creates a new `Ok`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsDeleteAttestationsBySubjectDigest.Output.Ok)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            public static var ok: Self {
                .ok(.init())
            }
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsDeleteAttestationsBySubjectDigest.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsDeleteAttestationsBySubjectDigest.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsDeleteAttestationsBySubjectDigest.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by an org.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)`.
    public enum OrgsDeleteAttestationsById {
        public static let id: Swift.String = "orgs/delete-attestations-by-id"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{attestation_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{attestation_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Attestation ID
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{attestation_id}/DELETE/path/attestation_id`.
                public var attestationId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - attestationId: Attestation ID
                public init(
                    org: Components.Parameters.Org,
                    attestationId: Swift.Int
                ) {
                    self.org = org
                    self.attestationId = attestationId
                }
            }
            public var path: Operations.OrgsDeleteAttestationsById.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{attestation_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteAttestationsById.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteAttestationsById.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsDeleteAttestationsById.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsDeleteAttestationsById.Input.Path,
                headers: Operations.OrgsDeleteAttestationsById.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// Creates a new `Ok`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsDeleteAttestationsById.Output.Ok)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            public static var ok: Self {
                .ok(.init())
            }
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsDeleteAttestationsById.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsDeleteAttestationsById.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsDeleteAttestationsById.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{subject_digest}/get(orgs/list-attestations)`.
    public enum OrgsListAttestations {
        public static let id: Swift.String = "orgs/list-attestations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The parameter should be set to the attestation's subject's SHA256 digest, in the form `sha256:HEX_DIGEST`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/path/subject_digest`.
                public var subjectDigest: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - subjectDigest: The parameter should be set to the attestation's subject's SHA256 digest, in the form `sha256:HEX_DIGEST`.
                public init(
                    org: Components.Parameters.Org,
                    subjectDigest: Swift.String
                ) {
                    self.org = org
                    self.subjectDigest = subjectDigest
                }
            }
            public var path: Operations.OrgsListAttestations.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// Optional filter for fetching attestations with a given predicate type.
                /// This option accepts `provenance`, `sbom`, or freeform text for custom predicate types.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/query/predicate_type`.
                public var predicateType: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - predicateType: Optional filter for fetching attestations with a given predicate type.
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    predicateType: Swift.String? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.predicateType = predicateType
                }
            }
            public var query: Operations.OrgsListAttestations.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListAttestations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListAttestations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListAttestations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListAttestations.Input.Path,
                query: Operations.OrgsListAttestations.Input.Query = .init(),
                headers: Operations.OrgsListAttestations.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload`.
                        public struct AttestationsPayloadPayload: Codable, Hashable, Sendable {
                            /// The attestation's Sigstore Bundle.
                            /// Refer to the [Sigstore Bundle Specification](https://github.com/sigstore/protobuf-specs/blob/main/protos/sigstore_bundle.proto) for more information.
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle`.
                            public struct BundlePayload: Codable, Hashable, Sendable {
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/mediaType`.
                                public var mediaType: Swift.String?
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/verificationMaterial`.
                                public struct VerificationMaterialPayload: Codable, Hashable, Sendable {
                                    /// A container of undocumented properties.
                                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                    /// Creates a new `VerificationMaterialPayload`.
                                    ///
                                    /// - Parameters:
                                    ///   - additionalProperties: A container of undocumented properties.
                                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                        self.additionalProperties = additionalProperties
                                    }
                                    public init(from decoder: any Decoder) throws {
                                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                    }
                                    public func encode(to encoder: any Encoder) throws {
                                        try encoder.encodeAdditionalProperties(additionalProperties)
                                    }
                                }
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/verificationMaterial`.
                                public var verificationMaterial: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.VerificationMaterialPayload?
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/dsseEnvelope`.
                                public struct DsseEnvelopePayload: Codable, Hashable, Sendable {
                                    /// A container of undocumented properties.
                                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                    /// Creates a new `DsseEnvelopePayload`.
                                    ///
                                    /// - Parameters:
                                    ///   - additionalProperties: A container of undocumented properties.
                                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                        self.additionalProperties = additionalProperties
                                    }
                                    public init(from decoder: any Decoder) throws {
                                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                    }
                                    public func encode(to encoder: any Encoder) throws {
                                        try encoder.encodeAdditionalProperties(additionalProperties)
                                    }
                                }
                                /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/dsseEnvelope`.
                                public var dsseEnvelope: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.DsseEnvelopePayload?
                                /// Creates a new `BundlePayload`.
                                ///
                                /// - Parameters:
                                ///   - mediaType:
                                ///   - verificationMaterial:
                                ///   - dsseEnvelope:
                                public init(
                                    mediaType: Swift.String? = nil,
                                    verificationMaterial: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.VerificationMaterialPayload? = nil,
                                    dsseEnvelope: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.DsseEnvelopePayload? = nil
                                ) {
                                    self.mediaType = mediaType
                                    self.verificationMaterial = verificationMaterial
                                    self.dsseEnvelope = dsseEnvelope
                                }
                                public enum CodingKeys: String, CodingKey {
                                    case mediaType
                                    case verificationMaterial
                                    case dsseEnvelope
                                }
                            }
                            /// The attestation's Sigstore Bundle.
                            /// Refer to the [Sigstore Bundle Specification](https://github.com/sigstore/protobuf-specs/blob/main/protos/sigstore_bundle.proto) for more information.
                            ///
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle`.
                            public var bundle: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload?
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/repository_id`.
                            public var repositoryId: Swift.Int?
                            /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle_url`.
                            public var bundleUrl: Swift.String?
                            /// Creates a new `AttestationsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - bundle: The attestation's Sigstore Bundle.
                            ///   - repositoryId:
                            ///   - bundleUrl:
                            public init(
                                bundle: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload? = nil,
                                repositoryId: Swift.Int? = nil,
                                bundleUrl: Swift.String? = nil
                            ) {
                                self.bundle = bundle
                                self.repositoryId = repositoryId
                                self.bundleUrl = bundleUrl
                            }
                            public enum CodingKeys: String, CodingKey {
                                case bundle
                                case repositoryId = "repository_id"
                                case bundleUrl = "bundle_url"
                            }
                        }
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/attestations`.
                        public typealias AttestationsPayload = [Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload]
                        /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/json/attestations`.
                        public var attestations: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - attestations:
                        public init(attestations: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayload? = nil) {
                            self.attestations = attestations
                        }
                        public enum CodingKeys: String, CodingKey {
                            case attestations
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/attestations/{subject_digest}/GET/responses/200/content/application\/json`.
                    case json(Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListAttestations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsListAttestations.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{subject_digest}/get(orgs/list-attestations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListAttestations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListAttestations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List users blocked by an organization
    ///
    /// List the users blocked by an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/get(orgs/list-blocked-users)`.
    public enum OrgsListBlockedUsers {
        public static let id: Swift.String = "orgs/list-blocked-users"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListBlockedUsers.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.OrgsListBlockedUsers.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListBlockedUsers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListBlockedUsers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListBlockedUsers.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListBlockedUsers.Input.Path,
                query: Operations.OrgsListBlockedUsers.Input.Query = .init(),
                headers: Operations.OrgsListBlockedUsers.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/blocks/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListBlockedUsers.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsListBlockedUsers.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/get(orgs/list-blocked-users)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListBlockedUsers.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListBlockedUsers.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a user is blocked by an organization
    ///
    /// Returns a 204 if the given user is blocked by the given organization. Returns a 404 if the organization is not blocking the user, or if the user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)`.
    public enum OrgsCheckBlockedUser {
        public static let id: Swift.String = "orgs/check-blocked-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.username = username
                }
            }
            public var path: Operations.OrgsCheckBlockedUser.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCheckBlockedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCheckBlockedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsCheckBlockedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsCheckBlockedUser.Input.Path,
                headers: Operations.OrgsCheckBlockedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// If the user is blocked
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsCheckBlockedUser.Output.NoContent)
            /// If the user is blocked
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsCheckBlockedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsCheckBlockedUser.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsCheckBlockedUser.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// If the user is not blocked
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.OrgsCheckBlockedUser.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.OrgsCheckBlockedUser.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Block a user from an organization
    ///
    /// Blocks the given user on behalf of the specified organization and returns a 204. If the organization cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)`.
    public enum OrgsBlockUser {
        public static let id: Swift.String = "orgs/block-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.username = username
                }
            }
            public var path: Operations.OrgsBlockUser.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsBlockUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsBlockUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsBlockUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsBlockUser.Input.Path,
                headers: Operations.OrgsBlockUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsBlockUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsBlockUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unblock a user from an organization
    ///
    /// Unblocks the given user on behalf of the specified organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/delete(orgs/unblock-user)`.
    public enum OrgsUnblockUser {
        public static let id: Swift.String = "orgs/unblock-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/blocks/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.username = username
                }
            }
            public var path: Operations.OrgsUnblockUser.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.OrgsUnblockUser.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/delete(orgs/unblock-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsUnblockUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/delete(orgs/unblock-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsUnblockUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List failed organization invitations
    ///
    /// The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/failed_invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/failed_invitations/get(orgs/list-failed-invitations)`.
    public enum OrgsListFailedInvitations {
        public static let id: Swift.String = "orgs/list-failed-invitations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListFailedInvitations.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.OrgsListFailedInvitations.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListFailedInvitations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListFailedInvitations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListFailedInvitations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListFailedInvitations.Input.Path,
                query: Operations.OrgsListFailedInvitations.Input.Query = .init(),
                headers: Operations.OrgsListFailedInvitations.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsListFailedInvitations.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/failed_invitations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationInvitation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationInvitation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListFailedInvitations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsListFailedInvitations.Output.Ok.Headers = .init(),
                    body: Operations.OrgsListFailedInvitations.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/failed_invitations/get(orgs/list-failed-invitations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListFailedInvitations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListFailedInvitations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/failed_invitations/get(orgs/list-failed-invitations)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization webhooks
    ///
    /// List webhooks for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/get(orgs/list-webhooks)`.
    public enum OrgsListWebhooks {
        public static let id: Swift.String = "orgs/list-webhooks"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListWebhooks.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.OrgsListWebhooks.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListWebhooks.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListWebhooks.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListWebhooks.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListWebhooks.Input.Path,
                query: Operations.OrgsListWebhooks.Input.Query = .init(),
                headers: Operations.OrgsListWebhooks.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsListWebhooks.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrgHook])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrgHook] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListWebhooks.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsListWebhooks.Output.Ok.Headers = .init(),
                    body: Operations.OrgsListWebhooks.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/get(orgs/list-webhooks)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListWebhooks.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListWebhooks.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/get(orgs/list-webhooks)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an organization webhook
    ///
    /// Create a hook that posts payloads in JSON format.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
    /// edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)`.
    public enum OrgsCreateWebhook {
        public static let id: Swift.String = "orgs/create-webhook"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsCreateWebhook.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCreateWebhook.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCreateWebhook.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsCreateWebhook.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Must be passed as "web".
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// Key/value pairs to provide settings for this webhook.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config`.
                    public struct ConfigPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config/url`.
                        public var url: Components.Schemas.WebhookConfigUrl
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config/content_type`.
                        public var contentType: Components.Schemas.WebhookConfigContentType?
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config/secret`.
                        public var secret: Components.Schemas.WebhookConfigSecret?
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config/insecure_ssl`.
                        public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config/username`.
                        public var username: Swift.String?
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config/password`.
                        public var password: Swift.String?
                        /// Creates a new `ConfigPayload`.
                        ///
                        /// - Parameters:
                        ///   - url:
                        ///   - contentType:
                        ///   - secret:
                        ///   - insecureSsl:
                        ///   - username:
                        ///   - password:
                        public init(
                            url: Components.Schemas.WebhookConfigUrl,
                            contentType: Components.Schemas.WebhookConfigContentType? = nil,
                            secret: Components.Schemas.WebhookConfigSecret? = nil,
                            insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil,
                            username: Swift.String? = nil,
                            password: Swift.String? = nil
                        ) {
                            self.url = url
                            self.contentType = contentType
                            self.secret = secret
                            self.insecureSsl = insecureSsl
                            self.username = username
                            self.password = password
                        }
                        public enum CodingKeys: String, CodingKey {
                            case url
                            case contentType = "content_type"
                            case secret
                            case insecureSsl = "insecure_ssl"
                            case username
                            case password
                        }
                    }
                    /// Key/value pairs to provide settings for this webhook.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/config`.
                    public var config: Operations.OrgsCreateWebhook.Input.Body.JsonPayload.ConfigPayload
                    /// Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. Set to `["*"]` to receive all possible events.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/events`.
                    public var events: [Swift.String]?
                    /// Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/json/active`.
                    public var active: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Must be passed as "web".
                    ///   - config: Key/value pairs to provide settings for this webhook.
                    ///   - events: Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. Set to `["*"]` to receive all possible events.
                    ///   - active: Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
                    public init(
                        name: Swift.String,
                        config: Operations.OrgsCreateWebhook.Input.Body.JsonPayload.ConfigPayload,
                        events: [Swift.String]? = nil,
                        active: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self.config = config
                        self.events = events
                        self.active = active
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case config
                        case events
                        case active
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/requestBody/content/application\/json`.
                case json(Operations.OrgsCreateWebhook.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsCreateWebhook.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsCreateWebhook.Input.Path,
                headers: Operations.OrgsCreateWebhook.Input.Headers = .init(),
                body: Operations.OrgsCreateWebhook.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsCreateWebhook.Output.Created.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.OrgHook)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrgHook {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsCreateWebhook.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsCreateWebhook.Output.Created.Headers = .init(),
                    body: Operations.OrgsCreateWebhook.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.OrgsCreateWebhook.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.OrgsCreateWebhook.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization webhook
    ///
    /// Returns a webhook configured in an organization. To get only the webhook
    /// `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/get(orgs/get-webhook)`.
    public enum OrgsGetWebhook {
        public static let id: Swift.String = "orgs/get-webhook"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/GET/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsGetWebhook.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGetWebhook.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGetWebhook.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsGetWebhook.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsGetWebhook.Input.Path,
                headers: Operations.OrgsGetWebhook.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.OrgHook)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrgHook {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsGetWebhook.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsGetWebhook.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/get(orgs/get-webhook)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsGetWebhook.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsGetWebhook.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/get(orgs/get-webhook)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an organization webhook
    ///
    /// Updates a webhook configured in an organization. When you update a webhook,
    /// the `secret` will be overwritten. If you previously had a `secret` set, you must
    /// provide the same `secret` or set a new `secret` or the secret will be removed. If
    /// you are only updating individual webhook `config` properties, use "[Update a webhook
    /// configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)`.
    public enum OrgsUpdateWebhook {
        public static let id: Swift.String = "orgs/update-webhook"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsUpdateWebhook.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdateWebhook.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdateWebhook.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsUpdateWebhook.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Key/value pairs to provide settings for this webhook.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/config`.
                    public struct ConfigPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/config/url`.
                        public var url: Components.Schemas.WebhookConfigUrl
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/config/content_type`.
                        public var contentType: Components.Schemas.WebhookConfigContentType?
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/config/secret`.
                        public var secret: Components.Schemas.WebhookConfigSecret?
                        /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/config/insecure_ssl`.
                        public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
                        /// Creates a new `ConfigPayload`.
                        ///
                        /// - Parameters:
                        ///   - url:
                        ///   - contentType:
                        ///   - secret:
                        ///   - insecureSsl:
                        public init(
                            url: Components.Schemas.WebhookConfigUrl,
                            contentType: Components.Schemas.WebhookConfigContentType? = nil,
                            secret: Components.Schemas.WebhookConfigSecret? = nil,
                            insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil
                        ) {
                            self.url = url
                            self.contentType = contentType
                            self.secret = secret
                            self.insecureSsl = insecureSsl
                        }
                        public enum CodingKeys: String, CodingKey {
                            case url
                            case contentType = "content_type"
                            case secret
                            case insecureSsl = "insecure_ssl"
                        }
                    }
                    /// Key/value pairs to provide settings for this webhook.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/config`.
                    public var config: Operations.OrgsUpdateWebhook.Input.Body.JsonPayload.ConfigPayload?
                    /// Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/events`.
                    public var events: [Swift.String]?
                    /// Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/active`.
                    public var active: Swift.Bool?
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - config: Key/value pairs to provide settings for this webhook.
                    ///   - events: Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
                    ///   - active: Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
                    ///   - name:
                    public init(
                        config: Operations.OrgsUpdateWebhook.Input.Body.JsonPayload.ConfigPayload? = nil,
                        events: [Swift.String]? = nil,
                        active: Swift.Bool? = nil,
                        name: Swift.String? = nil
                    ) {
                        self.config = config
                        self.events = events
                        self.active = active
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case config
                        case events
                        case active
                        case name
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.OrgsUpdateWebhook.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsUpdateWebhook.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsUpdateWebhook.Input.Path,
                headers: Operations.OrgsUpdateWebhook.Input.Headers = .init(),
                body: Operations.OrgsUpdateWebhook.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.OrgHook)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrgHook {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsUpdateWebhook.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsUpdateWebhook.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsUpdateWebhook.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsUpdateWebhook.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an organization webhook
    ///
    /// Delete a webhook for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)`.
    public enum OrgsDeleteWebhook {
        public static let id: Swift.String = "orgs/delete-webhook"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/DELETE/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsDeleteWebhook.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteWebhook.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteWebhook.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsDeleteWebhook.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsDeleteWebhook.Input.Path,
                headers: Operations.OrgsDeleteWebhook.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsDeleteWebhook.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsDeleteWebhook.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a webhook configuration for an organization
    ///
    /// Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/get(orgs/get-webhook-config-for-org)`.
    public enum OrgsGetWebhookConfigForOrg {
        public static let id: Swift.String = "orgs/get-webhook-config-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/GET/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsGetWebhookConfigForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGetWebhookConfigForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGetWebhookConfigForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsGetWebhookConfigForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsGetWebhookConfigForOrg.Input.Path,
                headers: Operations.OrgsGetWebhookConfigForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.WebhookConfig)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.WebhookConfig {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsGetWebhookConfigForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsGetWebhookConfigForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/get(orgs/get-webhook-config-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsGetWebhookConfigForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsGetWebhookConfigForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a webhook configuration for an organization
    ///
    /// Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/patch(orgs/update-webhook-config-for-org)`.
    public enum OrgsUpdateWebhookConfigForOrg {
        public static let id: Swift.String = "orgs/update-webhook-config-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsUpdateWebhookConfigForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdateWebhookConfigForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdateWebhookConfigForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsUpdateWebhookConfigForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody/json/url`.
                    public var url: Components.Schemas.WebhookConfigUrl?
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody/json/content_type`.
                    public var contentType: Components.Schemas.WebhookConfigContentType?
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody/json/secret`.
                    public var secret: Components.Schemas.WebhookConfigSecret?
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody/json/insecure_ssl`.
                    public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - url:
                    ///   - contentType:
                    ///   - secret:
                    ///   - insecureSsl:
                    public init(
                        url: Components.Schemas.WebhookConfigUrl? = nil,
                        contentType: Components.Schemas.WebhookConfigContentType? = nil,
                        secret: Components.Schemas.WebhookConfigSecret? = nil,
                        insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil
                    ) {
                        self.url = url
                        self.contentType = contentType
                        self.secret = secret
                        self.insecureSsl = insecureSsl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case url
                        case contentType = "content_type"
                        case secret
                        case insecureSsl = "insecure_ssl"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/requestBody/content/application\/json`.
                case json(Operations.OrgsUpdateWebhookConfigForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsUpdateWebhookConfigForOrg.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsUpdateWebhookConfigForOrg.Input.Path,
                headers: Operations.OrgsUpdateWebhookConfigForOrg.Input.Headers = .init(),
                body: Operations.OrgsUpdateWebhookConfigForOrg.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/config/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.WebhookConfig)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.WebhookConfig {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsUpdateWebhookConfigForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsUpdateWebhookConfigForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/patch(orgs/update-webhook-config-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsUpdateWebhookConfigForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsUpdateWebhookConfigForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List deliveries for an organization webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)`.
    public enum OrgsListWebhookDeliveries {
        public static let id: Swift.String = "orgs/list-webhook-deliveries"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsListWebhookDeliveries.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/query/cursor`.
                public var cursor: Components.Parameters.Cursor?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - cursor: Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    cursor: Components.Parameters.Cursor? = nil
                ) {
                    self.perPage = perPage
                    self.cursor = cursor
                }
            }
            public var query: Operations.OrgsListWebhookDeliveries.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListWebhookDeliveries.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListWebhookDeliveries.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListWebhookDeliveries.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListWebhookDeliveries.Input.Path,
                query: Operations.OrgsListWebhookDeliveries.Input.Query = .init(),
                headers: Operations.OrgsListWebhookDeliveries.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.HookDeliveryItem])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.HookDeliveryItem] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListWebhookDeliveries.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsListWebhookDeliveries.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListWebhookDeliveries.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListWebhookDeliveries.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get a webhook delivery for an organization webhook
    ///
    /// Returns a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)`.
    public enum OrgsGetWebhookDelivery {
        public static let id: Swift.String = "orgs/get-webhook-delivery"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/path/delivery_id`.
                public var deliveryId: Components.Parameters.DeliveryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///   - deliveryId:
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId,
                    deliveryId: Components.Parameters.DeliveryId
                ) {
                    self.org = org
                    self.hookId = hookId
                    self.deliveryId = deliveryId
                }
            }
            public var path: Operations.OrgsGetWebhookDelivery.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGetWebhookDelivery.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsGetWebhookDelivery.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsGetWebhookDelivery.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsGetWebhookDelivery.Input.Path,
                headers: Operations.OrgsGetWebhookDelivery.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.HookDelivery)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.HookDelivery {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsGetWebhookDelivery.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsGetWebhookDelivery.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsGetWebhookDelivery.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsGetWebhookDelivery.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Redeliver a delivery for an organization webhook
    ///
    /// Redeliver a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)`.
    public enum OrgsRedeliverWebhookDelivery {
        public static let id: Swift.String = "orgs/redeliver-webhook-delivery"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/POST/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/POST/path/delivery_id`.
                public var deliveryId: Components.Parameters.DeliveryId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///   - deliveryId:
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId,
                    deliveryId: Components.Parameters.DeliveryId
                ) {
                    self.org = org
                    self.hookId = hookId
                    self.deliveryId = deliveryId
                }
            }
            public var path: Operations.OrgsRedeliverWebhookDelivery.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsRedeliverWebhookDelivery.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsRedeliverWebhookDelivery.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsRedeliverWebhookDelivery.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsRedeliverWebhookDelivery.Input.Path,
                headers: Operations.OrgsRedeliverWebhookDelivery.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Ping an organization webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event)
    /// to be sent to the hook.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/pings`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)`.
    public enum OrgsPingWebhook {
        public static let id: Swift.String = "orgs/ping-webhook"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/pings/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/pings/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/pings/POST/path/hook_id`.
                public var hookId: Components.Parameters.HookId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - hookId: The unique identifier of the hook. You can find this value in the `X-GitHub-Hook-ID` header of a webhook delivery.
                public init(
                    org: Components.Parameters.Org,
                    hookId: Components.Parameters.HookId
                ) {
                    self.org = org
                    self.hookId = hookId
                }
            }
            public var path: Operations.OrgsPingWebhook.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/hooks/{hook_id}/pings/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsPingWebhook.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsPingWebhook.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsPingWebhook.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsPingWebhook.Input.Path,
                headers: Operations.OrgsPingWebhook.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsPingWebhook.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsPingWebhook.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get route stats by actor
    ///
    /// Get API request count statistics for an actor broken down by route within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/get(api-insights/get-route-stats-by-actor)`.
    public enum ApiInsightsGetRouteStatsByActor {
        public static let id: Swift.String = "api-insights/get-route-stats-by-actor"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// - Remark: Generated from `#/components/parameters/api-insights-actor-type`.
                @frozen public enum ApiInsightsActorType: String, Codable, Hashable, Sendable, CaseIterable {
                    case installation = "installation"
                    case classicPat = "classic_pat"
                    case fineGrainedPat = "fine_grained_pat"
                    case oauthApp = "oauth_app"
                    case githubAppUserToServer = "github_app_user_to_server"
                }
                /// The type of the actor
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/path/actor_type`.
                public var actorType: Components.Parameters.ApiInsightsActorType
                /// The ID of the actor
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/path/actor_id`.
                public var actorId: Components.Parameters.ApiInsightsActorId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - actorType: The type of the actor
                ///   - actorId: The ID of the actor
                public init(
                    org: Components.Parameters.Org,
                    actorType: Components.Parameters.ApiInsightsActorType,
                    actorId: Components.Parameters.ApiInsightsActorId
                ) {
                    self.org = org
                    self.actorType = actorType
                    self.actorId = actorId
                }
            }
            public var path: Operations.ApiInsightsGetRouteStatsByActor.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// - Remark: Generated from `#/components/parameters/ApiInsightsRouteStatsSort`.
                @frozen public enum ApiInsightsRouteStatsSortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
                    case lastRequestTimestamp = "last_request_timestamp"
                    case rateLimitedRequestCount = "rate_limited_request_count"
                    case httpMethod = "http_method"
                    case apiRoute = "api_route"
                    case totalRequestCount = "total_request_count"
                }
                /// - Remark: Generated from `#/components/parameters/api-insights-route-stats-sort`.
                public typealias ApiInsightsRouteStatsSort = [Components.Parameters.ApiInsightsRouteStatsSortPayload]
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/sort`.
                public var sort: Components.Parameters.ApiInsightsRouteStatsSort?
                /// Providing a substring will filter results where the API route contains the substring. This is a case-insensitive search.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/query/api_route_substring`.
                public var apiRouteSubstring: Components.Parameters.ApiInsightsApiRouteSubstring?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - direction: The direction to sort the results by.
                ///   - sort: The property to sort the results by.
                ///   - apiRouteSubstring: Providing a substring will filter results where the API route contains the substring. This is a case-insensitive search.
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    sort: Components.Parameters.ApiInsightsRouteStatsSort? = nil,
                    apiRouteSubstring: Components.Parameters.ApiInsightsApiRouteSubstring? = nil
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                    self.page = page
                    self.perPage = perPage
                    self.direction = direction
                    self.sort = sort
                    self.apiRouteSubstring = apiRouteSubstring
                }
            }
            public var query: Operations.ApiInsightsGetRouteStatsByActor.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetRouteStatsByActor.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetRouteStatsByActor.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetRouteStatsByActor.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetRouteStatsByActor.Input.Path,
                query: Operations.ApiInsightsGetRouteStatsByActor.Input.Query,
                headers: Operations.ApiInsightsGetRouteStatsByActor.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsRouteStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsRouteStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetRouteStatsByActor.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetRouteStatsByActor.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/get(api-insights/get-route-stats-by-actor)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetRouteStatsByActor.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetRouteStatsByActor.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get subject stats
    ///
    /// Get API request statistics for all subjects within an organization within a specified time frame. Subjects can be users or GitHub Apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/subject-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/subject-stats/get(api-insights/get-subject-stats)`.
    public enum ApiInsightsGetSubjectStats {
        public static let id: Swift.String = "api-insights/get-subject-stats"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ApiInsightsGetSubjectStats.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// - Remark: Generated from `#/components/parameters/ApiInsightsSort`.
                @frozen public enum ApiInsightsSortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
                    case lastRequestTimestamp = "last_request_timestamp"
                    case rateLimitedRequestCount = "rate_limited_request_count"
                    case subjectName = "subject_name"
                    case totalRequestCount = "total_request_count"
                }
                /// - Remark: Generated from `#/components/parameters/api-insights-sort`.
                public typealias ApiInsightsSort = [Components.Parameters.ApiInsightsSortPayload]
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/sort`.
                public var sort: Components.Parameters.ApiInsightsSort?
                /// Providing a substring will filter results where the subject name contains the substring. This is a case-insensitive search.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/query/subject_name_substring`.
                public var subjectNameSubstring: Components.Parameters.ApiInsightsSubjectNameSubstring?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - direction: The direction to sort the results by.
                ///   - sort: The property to sort the results by.
                ///   - subjectNameSubstring: Providing a substring will filter results where the subject name contains the substring. This is a case-insensitive search.
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    sort: Components.Parameters.ApiInsightsSort? = nil,
                    subjectNameSubstring: Components.Parameters.ApiInsightsSubjectNameSubstring? = nil
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                    self.page = page
                    self.perPage = perPage
                    self.direction = direction
                    self.sort = sort
                    self.subjectNameSubstring = subjectNameSubstring
                }
            }
            public var query: Operations.ApiInsightsGetSubjectStats.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSubjectStats.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSubjectStats.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetSubjectStats.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetSubjectStats.Input.Path,
                query: Operations.ApiInsightsGetSubjectStats.Input.Query,
                headers: Operations.ApiInsightsGetSubjectStats.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/subject-stats/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsSubjectStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsSubjectStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetSubjectStats.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetSubjectStats.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/subject-stats/get(api-insights/get-subject-stats)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetSubjectStats.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetSubjectStats.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get summary stats
    ///
    /// Get overall statistics of API requests made within an organization by all users and apps within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/get(api-insights/get-summary-stats)`.
    public enum ApiInsightsGetSummaryStats {
        public static let id: Swift.String = "api-insights/get-summary-stats"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ApiInsightsGetSummaryStats.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                }
            }
            public var query: Operations.ApiInsightsGetSummaryStats.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSummaryStats.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSummaryStats.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetSummaryStats.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetSummaryStats.Input.Path,
                query: Operations.ApiInsightsGetSummaryStats.Input.Query,
                headers: Operations.ApiInsightsGetSummaryStats.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsSummaryStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsSummaryStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetSummaryStats.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetSummaryStats.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/get(api-insights/get-summary-stats)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetSummaryStats.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetSummaryStats.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get summary stats by user
    ///
    /// Get overall statistics of API requests within the organization for a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/users/{user_id}/get(api-insights/get-summary-stats-by-user)`.
    public enum ApiInsightsGetSummaryStatsByUser {
        public static let id: Swift.String = "api-insights/get-summary-stats-by-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The ID of the user to query for stats
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/path/user_id`.
                public var userId: Components.Parameters.ApiInsightsUserId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - userId: The ID of the user to query for stats
                public init(
                    org: Components.Parameters.Org,
                    userId: Components.Parameters.ApiInsightsUserId
                ) {
                    self.org = org
                    self.userId = userId
                }
            }
            public var path: Operations.ApiInsightsGetSummaryStatsByUser.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                }
            }
            public var query: Operations.ApiInsightsGetSummaryStatsByUser.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSummaryStatsByUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSummaryStatsByUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetSummaryStatsByUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetSummaryStatsByUser.Input.Path,
                query: Operations.ApiInsightsGetSummaryStatsByUser.Input.Query,
                headers: Operations.ApiInsightsGetSummaryStatsByUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/users/{user_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsSummaryStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsSummaryStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetSummaryStatsByUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetSummaryStatsByUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/users/{user_id}/get(api-insights/get-summary-stats-by-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetSummaryStatsByUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetSummaryStatsByUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get summary stats by actor
    ///
    /// Get overall statistics of API requests within the organization made by a specific actor. Actors can be GitHub App installations, OAuth apps or other tokens on behalf of a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/get(api-insights/get-summary-stats-by-actor)`.
    public enum ApiInsightsGetSummaryStatsByActor {
        public static let id: Swift.String = "api-insights/get-summary-stats-by-actor"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// - Remark: Generated from `#/components/parameters/api-insights-actor-type`.
                @frozen public enum ApiInsightsActorType: String, Codable, Hashable, Sendable, CaseIterable {
                    case installation = "installation"
                    case classicPat = "classic_pat"
                    case fineGrainedPat = "fine_grained_pat"
                    case oauthApp = "oauth_app"
                    case githubAppUserToServer = "github_app_user_to_server"
                }
                /// The type of the actor
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/path/actor_type`.
                public var actorType: Components.Parameters.ApiInsightsActorType
                /// The ID of the actor
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/path/actor_id`.
                public var actorId: Components.Parameters.ApiInsightsActorId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - actorType: The type of the actor
                ///   - actorId: The ID of the actor
                public init(
                    org: Components.Parameters.Org,
                    actorType: Components.Parameters.ApiInsightsActorType,
                    actorId: Components.Parameters.ApiInsightsActorId
                ) {
                    self.org = org
                    self.actorType = actorType
                    self.actorId = actorId
                }
            }
            public var path: Operations.ApiInsightsGetSummaryStatsByActor.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                }
            }
            public var query: Operations.ApiInsightsGetSummaryStatsByActor.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSummaryStatsByActor.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetSummaryStatsByActor.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetSummaryStatsByActor.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetSummaryStatsByActor.Input.Path,
                query: Operations.ApiInsightsGetSummaryStatsByActor.Input.Query,
                headers: Operations.ApiInsightsGetSummaryStatsByActor.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsSummaryStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsSummaryStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetSummaryStatsByActor.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetSummaryStatsByActor.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/get(api-insights/get-summary-stats-by-actor)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetSummaryStatsByActor.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetSummaryStatsByActor.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get time stats
    ///
    /// Get the number of API requests and rate-limited requests made within an organization over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/get(api-insights/get-time-stats)`.
    public enum ApiInsightsGetTimeStats {
        public static let id: Swift.String = "api-insights/get-time-stats"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ApiInsightsGetTimeStats.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/query/timestamp_increment`.
                public var timestampIncrement: Components.Parameters.ApiInsightsTimestampIncrement
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - timestampIncrement: The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil,
                    timestampIncrement: Components.Parameters.ApiInsightsTimestampIncrement
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                    self.timestampIncrement = timestampIncrement
                }
            }
            public var query: Operations.ApiInsightsGetTimeStats.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetTimeStats.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetTimeStats.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetTimeStats.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetTimeStats.Input.Path,
                query: Operations.ApiInsightsGetTimeStats.Input.Query,
                headers: Operations.ApiInsightsGetTimeStats.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsTimeStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsTimeStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetTimeStats.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetTimeStats.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/get(api-insights/get-time-stats)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetTimeStats.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetTimeStats.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get time stats by user
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific user over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/users/{user_id}/get(api-insights/get-time-stats-by-user)`.
    public enum ApiInsightsGetTimeStatsByUser {
        public static let id: Swift.String = "api-insights/get-time-stats-by-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The ID of the user to query for stats
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/path/user_id`.
                public var userId: Components.Parameters.ApiInsightsUserId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - userId: The ID of the user to query for stats
                public init(
                    org: Components.Parameters.Org,
                    userId: Components.Parameters.ApiInsightsUserId
                ) {
                    self.org = org
                    self.userId = userId
                }
            }
            public var path: Operations.ApiInsightsGetTimeStatsByUser.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/query/timestamp_increment`.
                public var timestampIncrement: Components.Parameters.ApiInsightsTimestampIncrement
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - timestampIncrement: The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil,
                    timestampIncrement: Components.Parameters.ApiInsightsTimestampIncrement
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                    self.timestampIncrement = timestampIncrement
                }
            }
            public var query: Operations.ApiInsightsGetTimeStatsByUser.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetTimeStatsByUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetTimeStatsByUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetTimeStatsByUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetTimeStatsByUser.Input.Path,
                query: Operations.ApiInsightsGetTimeStatsByUser.Input.Query,
                headers: Operations.ApiInsightsGetTimeStatsByUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/users/{user_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsTimeStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsTimeStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetTimeStatsByUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetTimeStatsByUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/users/{user_id}/get(api-insights/get-time-stats-by-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetTimeStatsByUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetTimeStatsByUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get time stats by actor
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific actor within a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/get(api-insights/get-time-stats-by-actor)`.
    public enum ApiInsightsGetTimeStatsByActor {
        public static let id: Swift.String = "api-insights/get-time-stats-by-actor"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// - Remark: Generated from `#/components/parameters/api-insights-actor-type`.
                @frozen public enum ApiInsightsActorType: String, Codable, Hashable, Sendable, CaseIterable {
                    case installation = "installation"
                    case classicPat = "classic_pat"
                    case fineGrainedPat = "fine_grained_pat"
                    case oauthApp = "oauth_app"
                    case githubAppUserToServer = "github_app_user_to_server"
                }
                /// The type of the actor
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/path/actor_type`.
                public var actorType: Components.Parameters.ApiInsightsActorType
                /// The ID of the actor
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/path/actor_id`.
                public var actorId: Components.Parameters.ApiInsightsActorId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - actorType: The type of the actor
                ///   - actorId: The ID of the actor
                public init(
                    org: Components.Parameters.Org,
                    actorType: Components.Parameters.ApiInsightsActorType,
                    actorId: Components.Parameters.ApiInsightsActorId
                ) {
                    self.org = org
                    self.actorType = actorType
                    self.actorId = actorId
                }
            }
            public var path: Operations.ApiInsightsGetTimeStatsByActor.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/query/timestamp_increment`.
                public var timestampIncrement: Components.Parameters.ApiInsightsTimestampIncrement
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - timestampIncrement: The increment of time used to breakdown the query results (5m, 10m, 1h, etc.)
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil,
                    timestampIncrement: Components.Parameters.ApiInsightsTimestampIncrement
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                    self.timestampIncrement = timestampIncrement
                }
            }
            public var query: Operations.ApiInsightsGetTimeStatsByActor.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetTimeStatsByActor.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetTimeStatsByActor.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetTimeStatsByActor.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetTimeStatsByActor.Input.Path,
                query: Operations.ApiInsightsGetTimeStatsByActor.Input.Query,
                headers: Operations.ApiInsightsGetTimeStatsByActor.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsTimeStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsTimeStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetTimeStatsByActor.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetTimeStatsByActor.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/get(api-insights/get-time-stats-by-actor)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetTimeStatsByActor.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetTimeStatsByActor.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get user stats
    ///
    /// Get API usage statistics within an organization for a user broken down by the type of access.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/user-stats/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/user-stats/{user_id}/get(api-insights/get-user-stats)`.
    public enum ApiInsightsGetUserStats {
        public static let id: Swift.String = "api-insights/get-user-stats"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The ID of the user to query for stats
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/path/user_id`.
                public var userId: Components.Parameters.ApiInsightsUserId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - userId: The ID of the user to query for stats
                public init(
                    org: Components.Parameters.Org,
                    userId: Components.Parameters.ApiInsightsUserId
                ) {
                    self.org = org
                    self.userId = userId
                }
            }
            public var path: Operations.ApiInsightsGetUserStats.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/min_timestamp`.
                public var minTimestamp: Components.Parameters.ApiInsightsMinTimestamp
                /// The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/max_timestamp`.
                public var maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// - Remark: Generated from `#/components/parameters/ApiInsightsSort`.
                @frozen public enum ApiInsightsSortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case lastRateLimitedTimestamp = "last_rate_limited_timestamp"
                    case lastRequestTimestamp = "last_request_timestamp"
                    case rateLimitedRequestCount = "rate_limited_request_count"
                    case subjectName = "subject_name"
                    case totalRequestCount = "total_request_count"
                }
                /// - Remark: Generated from `#/components/parameters/api-insights-sort`.
                public typealias ApiInsightsSort = [Components.Parameters.ApiInsightsSortPayload]
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/sort`.
                public var sort: Components.Parameters.ApiInsightsSort?
                /// Providing a substring will filter results where the actor name contains the substring. This is a case-insensitive search.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/query/actor_name_substring`.
                public var actorNameSubstring: Components.Parameters.ApiInsightsActorNameSubstring?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - minTimestamp: The minimum timestamp to query for stats. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - maxTimestamp: The maximum timestamp to query for stats. Defaults to the time 30 days ago. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - direction: The direction to sort the results by.
                ///   - sort: The property to sort the results by.
                ///   - actorNameSubstring: Providing a substring will filter results where the actor name contains the substring. This is a case-insensitive search.
                public init(
                    minTimestamp: Components.Parameters.ApiInsightsMinTimestamp,
                    maxTimestamp: Components.Parameters.ApiInsightsMaxTimestamp? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    sort: Components.Parameters.ApiInsightsSort? = nil,
                    actorNameSubstring: Components.Parameters.ApiInsightsActorNameSubstring? = nil
                ) {
                    self.minTimestamp = minTimestamp
                    self.maxTimestamp = maxTimestamp
                    self.page = page
                    self.perPage = perPage
                    self.direction = direction
                    self.sort = sort
                    self.actorNameSubstring = actorNameSubstring
                }
            }
            public var query: Operations.ApiInsightsGetUserStats.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetUserStats.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ApiInsightsGetUserStats.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ApiInsightsGetUserStats.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ApiInsightsGetUserStats.Input.Path,
                query: Operations.ApiInsightsGetUserStats.Input.Query,
                headers: Operations.ApiInsightsGetUserStats.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/insights/api/user-stats/{user_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiInsightsUserStats)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiInsightsUserStats {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ApiInsightsGetUserStats.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ApiInsightsGetUserStats.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/user-stats/{user_id}/get(api-insights/get-user-stats)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ApiInsightsGetUserStats.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ApiInsightsGetUserStats.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List app installations for an organization
    ///
    /// Lists all GitHub Apps in an organization. The installation count includes
    /// all GitHub Apps installed on repositories in the organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installations/get(orgs/list-app-installations)`.
    public enum OrgsListAppInstallations {
        public static let id: Swift.String = "orgs/list-app-installations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListAppInstallations.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.OrgsListAppInstallations.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListAppInstallations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListAppInstallations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListAppInstallations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListAppInstallations.Input.Path,
                query: Operations.OrgsListAppInstallations.Input.Query = .init(),
                headers: Operations.OrgsListAppInstallations.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsListAppInstallations.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/content/json/installations`.
                        public var installations: [Components.Schemas.Installation]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - installations:
                        public init(
                            totalCount: Swift.Int,
                            installations: [Components.Schemas.Installation]
                        ) {
                            self.totalCount = totalCount
                            self.installations = installations
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case installations
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/installations/GET/responses/200/content/application\/json`.
                    case json(Operations.OrgsListAppInstallations.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.OrgsListAppInstallations.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListAppInstallations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsListAppInstallations.Output.Ok.Headers = .init(),
                    body: Operations.OrgsListAppInstallations.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/installations/get(orgs/list-app-installations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListAppInstallations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListAppInstallations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List pending organization invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization
    /// Invitation role and will be one of the following values: `direct_member`, `admin`,
    /// `billing_manager`, or `hiring_manager`. If the invitee is not a GitHub
    /// member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/get(orgs/list-pending-invitations)`.
    public enum OrgsListPendingInvitations {
        public static let id: Swift.String = "orgs/list-pending-invitations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListPendingInvitations.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query/role`.
                @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case all = "all"
                    case admin = "admin"
                    case directMember = "direct_member"
                    case billingManager = "billing_manager"
                    case hiringManager = "hiring_manager"
                }
                /// Filter invitations by their member role.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query/role`.
                public var role: Operations.OrgsListPendingInvitations.Input.Query.RolePayload?
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query/invitation_source`.
                @frozen public enum InvitationSourcePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case all = "all"
                    case member = "member"
                    case scim = "scim"
                }
                /// Filter invitations by their invitation source.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/query/invitation_source`.
                public var invitationSource: Operations.OrgsListPendingInvitations.Input.Query.InvitationSourcePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - role: Filter invitations by their member role.
                ///   - invitationSource: Filter invitations by their invitation source.
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    role: Operations.OrgsListPendingInvitations.Input.Query.RolePayload? = nil,
                    invitationSource: Operations.OrgsListPendingInvitations.Input.Query.InvitationSourcePayload? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                    self.role = role
                    self.invitationSource = invitationSource
                }
            }
            public var query: Operations.OrgsListPendingInvitations.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListPendingInvitations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListPendingInvitations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListPendingInvitations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListPendingInvitations.Input.Path,
                query: Operations.OrgsListPendingInvitations.Input.Query = .init(),
                headers: Operations.OrgsListPendingInvitations.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsListPendingInvitations.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationInvitation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationInvitation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListPendingInvitations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsListPendingInvitations.Output.Ok.Headers = .init(),
                    body: Operations.OrgsListPendingInvitations.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/get(orgs/list-pending-invitations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListPendingInvitations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListPendingInvitations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/get(orgs/list-pending-invitations)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an organization invitation
    ///
    /// Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)`.
    public enum OrgsCreateInvitation {
        public static let id: Swift.String = "orgs/create-invitation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsCreateInvitation.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCreateInvitation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCreateInvitation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsCreateInvitation.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/json/invitee_id`.
                    public var inviteeId: Swift.Int?
                    /// **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/json/email`.
                    public var email: Swift.String?
                    /// The role for the new member. 
                    ///  * `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.  
                    ///  * `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.  
                    ///  * `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization. 
                    ///  * `reinstate` - The previous role assigned to the invitee before they were removed from your organization. Can be one of the roles listed above. Only works if the invitee was previously part of your organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/json/role`.
                    @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case admin = "admin"
                        case directMember = "direct_member"
                        case billingManager = "billing_manager"
                        case reinstate = "reinstate"
                    }
                    /// The role for the new member. 
                    ///  * `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.  
                    ///  * `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.  
                    ///  * `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization. 
                    ///  * `reinstate` - The previous role assigned to the invitee before they were removed from your organization. Can be one of the roles listed above. Only works if the invitee was previously part of your organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/json/role`.
                    public var role: Operations.OrgsCreateInvitation.Input.Body.JsonPayload.RolePayload?
                    /// Specify IDs for the teams you want to invite new members to.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/json/team_ids`.
                    public var teamIds: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - inviteeId: **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
                    ///   - email: **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
                    ///   - role: The role for the new member. 
                    ///   - teamIds: Specify IDs for the teams you want to invite new members to.
                    public init(
                        inviteeId: Swift.Int? = nil,
                        email: Swift.String? = nil,
                        role: Operations.OrgsCreateInvitation.Input.Body.JsonPayload.RolePayload? = nil,
                        teamIds: [Swift.Int]? = nil
                    ) {
                        self.inviteeId = inviteeId
                        self.email = email
                        self.role = role
                        self.teamIds = teamIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case inviteeId = "invitee_id"
                        case email
                        case role
                        case teamIds = "team_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/requestBody/content/application\/json`.
                case json(Operations.OrgsCreateInvitation.Input.Body.JsonPayload)
            }
            public var body: Operations.OrgsCreateInvitation.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsCreateInvitation.Input.Path,
                headers: Operations.OrgsCreateInvitation.Input.Headers = .init(),
                body: Operations.OrgsCreateInvitation.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.OrganizationInvitation)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrganizationInvitation {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsCreateInvitation.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsCreateInvitation.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.OrgsCreateInvitation.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.OrgsCreateInvitation.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Cancel an organization invitation
    ///
    /// Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)`.
    public enum OrgsCancelInvitation {
        public static let id: Swift.String = "orgs/cancel-invitation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the invitation.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/DELETE/path/invitation_id`.
                public var invitationId: Components.Parameters.InvitationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - invitationId: The unique identifier of the invitation.
                public init(
                    org: Components.Parameters.Org,
                    invitationId: Components.Parameters.InvitationId
                ) {
                    self.org = org
                    self.invitationId = invitationId
                }
            }
            public var path: Operations.OrgsCancelInvitation.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCancelInvitation.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCancelInvitation.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsCancelInvitation.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsCancelInvitation.Input.Path,
                headers: Operations.OrgsCancelInvitation.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsCancelInvitation.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsCancelInvitation.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization invitation teams
    ///
    /// List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations/{invitation_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/teams/get(orgs/list-invitation-teams)`.
    public enum OrgsListInvitationTeams {
        public static let id: Swift.String = "orgs/list-invitation-teams"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the invitation.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/path/invitation_id`.
                public var invitationId: Components.Parameters.InvitationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - invitationId: The unique identifier of the invitation.
                public init(
                    org: Components.Parameters.Org,
                    invitationId: Components.Parameters.InvitationId
                ) {
                    self.org = org
                    self.invitationId = invitationId
                }
            }
            public var path: Operations.OrgsListInvitationTeams.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.OrgsListInvitationTeams.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListInvitationTeams.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListInvitationTeams.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListInvitationTeams.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.OrgsListInvitationTeams.Input.Path,
                query: Operations.OrgsListInvitationTeams.Input.Query = .init(),
                headers: Operations.OrgsListInvitationTeams.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.OrgsListInvitationTeams.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/invitations/{invitation_id}/teams/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Team])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Team] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListInvitationTeams.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.OrgsListInvitationTeams.Output.Ok.Headers = .init(),
                    body: Operations.OrgsListInvitationTeams.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/teams/get(orgs/list-invitation-teams)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListInvitationTeams.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListInvitationTeams.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/teams/get(orgs/list-invitation-teams)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List issue types for an organization
    ///
    /// Lists all issue types for an organization. OAuth app tokens and personal access tokens (classic) need the read:org scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/get(orgs/list-issue-types)`.
    public enum OrgsListIssueTypes {
        public static let id: Swift.String = "orgs/list-issue-types"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsListIssueTypes.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListIssueTypes.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsListIssueTypes.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsListIssueTypes.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsListIssueTypes.Input.Path,
                headers: Operations.OrgsListIssueTypes.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.IssueType])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.IssueType] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsListIssueTypes.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsListIssueTypes.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/get(orgs/list-issue-types)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsListIssueTypes.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsListIssueTypes.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/get(orgs/list-issue-types)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create issue type for an organization
    ///
    /// Create a new issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)`.
    public enum OrgsCreateIssueType {
        public static let id: Swift.String = "orgs/create-issue-type"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OrgsCreateIssueType.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCreateIssueType.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsCreateIssueType.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsCreateIssueType.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.OrganizationCreateIssueType)
            }
            public var body: Operations.OrgsCreateIssueType.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsCreateIssueType.Input.Path,
                headers: Operations.OrgsCreateIssueType.Input.Headers = .init(),
                body: Operations.OrgsCreateIssueType.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.IssueType)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.IssueType {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsCreateIssueType.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsCreateIssueType.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsCreateIssueType.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsCreateIssueType.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update issue type for an organization
    ///
    /// Updates an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)`.
    public enum OrgsUpdateIssueType {
        public static let id: Swift.String = "orgs/update-issue-type"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the issue type.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/path/issue_type_id`.
                public var issueTypeId: Components.Parameters.IssueTypeId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - issueTypeId: The unique identifier of the issue type.
                public init(
                    org: Components.Parameters.Org,
                    issueTypeId: Components.Parameters.IssueTypeId
                ) {
                    self.org = org
                    self.issueTypeId = issueTypeId
                }
            }
            public var path: Operations.OrgsUpdateIssueType.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdateIssueType.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsUpdateIssueType.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsUpdateIssueType.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.OrganizationUpdateIssueType)
            }
            public var body: Operations.OrgsUpdateIssueType.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OrgsUpdateIssueType.Input.Path,
                headers: Operations.OrgsUpdateIssueType.Input.Headers = .init(),
                body: Operations.OrgsUpdateIssueType.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.IssueType)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.IssueType {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OrgsUpdateIssueType.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OrgsUpdateIssueType.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OrgsUpdateIssueType.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OrgsUpdateIssueType.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete issue type for an organization
    ///
    /// Deletes an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)`.
    public enum OrgsDeleteIssueType {
        public static let id: Swift.String = "orgs/delete-issue-type"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the issue type.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/DELETE/path/issue_type_id`.
                public var issueTypeId: Components.Parameters.IssueTypeId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - issueTypeId: The unique identifier of the issue type.
                public init(
                    org: Components.Parameters.Org,
                    issueTypeId: Components.Parameters.IssueTypeId
                ) {
                    self.org = org
                    self.issueTypeId = issueTypeId
                }
            }
            public var path: Operations.OrgsDeleteIssueType.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/issue-types/{issue_type_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteIssueType.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OrgsDeleteIssueType.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OrgsDeleteIssueType.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OrgsDeleteIssueType.Input.Path,
                headers: Operations.OrgsDeleteIssueType.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.OrgsDeleteIssueType.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.OrgsDeleteIssueType.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization members
    ///
    /// List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/get(orgs/list-members)`.
    public enum OrgsListMembers {
        public static let id: Swift.String = "orgs/list-members"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/members/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
        