// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// GitHub's v3 REST API.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// List organizations
    ///
    /// Lists all organizations, in the order that they were created.
    ///
    /// > [!NOTE]
    /// > Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.
    ///
    /// - Remark: HTTP `GET /organizations`.
    /// - Remark: Generated from `#/paths//organizations/get(orgs/list)`.
    public func orgsList(_ input: Operations.OrgsList.Input) async throws -> Operations.OrgsList.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsList.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/organizations",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "since",
                    value: input.query.since
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsList.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Swift.String.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsList.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationSimple].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 304:
                    return .notModified(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization
    ///
    /// Gets information about an organization.
    ///
    /// When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, outside collaborators, guest collaborators, repository collaborators, or everyone with access to any repository within the organization to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
    ///
    /// To see the full details about an organization, the authenticated user must be an organization owner.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.
    ///
    /// To see information about an organization's GitHub plan, GitHub Apps need the `Organization plan` permission.
    ///
    /// - Remark: HTTP `GET /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/get(orgs/get)`.
    public func orgsGet(_ input: Operations.OrgsGet.Input) async throws -> Operations.OrgsGet.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGet.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGet.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrganizationFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Code security product enablement for new repositories through the organization API is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization) to set defaults instead. For more information on setting a default security configuration, see the [changelog](https://github.blog/changelog/2024-07-09-sunsetting-security-settings-defaults-parameters-in-the-organizations-rest-api/).
    ///
    /// Updates the organization's profile and member privileges.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/patch(orgs/update)`.
    public func orgsUpdate(_ input: Operations.OrgsUpdate.Input) async throws -> Operations.OrgsUpdate.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdate.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsUpdate.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrganizationFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsUpdate.Output.UnprocessableContent.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsUpdate.Output.UnprocessableContent.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 409:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Conflict.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .conflict(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an organization
    ///
    /// Deletes an organization and all its repositories.
    ///
    /// The organization login will be unavailable for 90 days after deletion.
    ///
    /// Please review the Terms of Service regarding account deletion before using this endpoint:
    ///
    /// https://docs.github.com/site-policy/github-terms/github-terms-of-service
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/delete(orgs/delete)`.
    public func orgsDelete(_ input: Operations.OrgsDelete.Input) async throws -> Operations.OrgsDelete.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsDelete.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            OpenAPIRuntime.OpenAPIObjectContainer.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/bulk-list/post(orgs/list-attestations-bulk)`.
    public func orgsListAttestationsBulk(_ input: Operations.OrgsListAttestationsBulk.Input) async throws -> Operations.OrgsListAttestationsBulk.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListAttestationsBulk.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/attestations/bulk-list",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListAttestationsBulk.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsListAttestationsBulk.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/delete-request/post(orgs/delete-attestations-bulk)`.
    public func orgsDeleteAttestationsBulk(_ input: Operations.OrgsDeleteAttestationsBulk.Input) async throws -> Operations.OrgsDeleteAttestationsBulk.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsDeleteAttestationsBulk.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/attestations/delete-request",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    return .ok(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/digest/{subject_digest}/delete(orgs/delete-attestations-by-subject-digest)`.
    public func orgsDeleteAttestationsBySubjectDigest(_ input: Operations.OrgsDeleteAttestationsBySubjectDigest.Input) async throws -> Operations.OrgsDeleteAttestationsBySubjectDigest.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsDeleteAttestationsBySubjectDigest.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/attestations/digest/{}",
                    parameters: [
                        input.path.org,
                        input.path.subjectDigest
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    return .ok(.init())
                case 204:
                    return .noContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by an org.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{attestation_id}/delete(orgs/delete-attestations-by-id)`.
    public func orgsDeleteAttestationsById(_ input: Operations.OrgsDeleteAttestationsById.Input) async throws -> Operations.OrgsDeleteAttestationsById.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsDeleteAttestationsById.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/attestations/{}",
                    parameters: [
                        input.path.org,
                        input.path.attestationId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    return .ok(.init())
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by an organization.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/attestations/{subject_digest}/get(orgs/list-attestations)`.
    public func orgsListAttestations(_ input: Operations.OrgsListAttestations.Input) async throws -> Operations.OrgsListAttestations.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListAttestations.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/attestations/{}",
                    parameters: [
                        input.path.org,
                        input.path.subjectDigest
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "predicate_type",
                    value: input.query.predicateType
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListAttestations.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsListAttestations.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List users blocked by an organization
    ///
    /// List the users blocked by an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/get(orgs/list-blocked-users)`.
    public func orgsListBlockedUsers(_ input: Operations.OrgsListBlockedUsers.Input) async throws -> Operations.OrgsListBlockedUsers.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListBlockedUsers.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/blocks",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListBlockedUsers.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check if a user is blocked by an organization
    ///
    /// Returns a 204 if the given user is blocked by the given organization. Returns a 404 if the organization is not blocking the user, or if the user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/get(orgs/check-blocked-user)`.
    public func orgsCheckBlockedUser(_ input: Operations.OrgsCheckBlockedUser.Input) async throws -> Operations.OrgsCheckBlockedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCheckBlockedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/blocks/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsCheckBlockedUser.Output.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Block a user from an organization
    ///
    /// Blocks the given user on behalf of the specified organization and returns a 204. If the organization cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/put(orgs/block-user)`.
    public func orgsBlockUser(_ input: Operations.OrgsBlockUser.Input) async throws -> Operations.OrgsBlockUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsBlockUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/blocks/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Unblock a user from an organization
    ///
    /// Unblocks the given user on behalf of the specified organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/blocks/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/blocks/{username}/delete(orgs/unblock-user)`.
    public func orgsUnblockUser(_ input: Operations.OrgsUnblockUser.Input) async throws -> Operations.OrgsUnblockUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUnblockUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/blocks/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List failed organization invitations
    ///
    /// The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/failed_invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/failed_invitations/get(orgs/list-failed-invitations)`.
    public func orgsListFailedInvitations(_ input: Operations.OrgsListFailedInvitations.Input) async throws -> Operations.OrgsListFailedInvitations.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListFailedInvitations.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/failed_invitations",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListFailedInvitations.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListFailedInvitations.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationInvitation].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organization webhooks
    ///
    /// List webhooks for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/get(orgs/list-webhooks)`.
    public func orgsListWebhooks(_ input: Operations.OrgsListWebhooks.Input) async throws -> Operations.OrgsListWebhooks.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListWebhooks.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListWebhooks.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListWebhooks.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrgHook].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create an organization webhook
    ///
    /// Create a hook that posts payloads in JSON format.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
    /// edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/post(orgs/create-webhook)`.
    public func orgsCreateWebhook(_ input: Operations.OrgsCreateWebhook.Input) async throws -> Operations.OrgsCreateWebhook.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCreateWebhook.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let headers: Operations.OrgsCreateWebhook.Output.Created.Headers = .init(location: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Location",
                        as: Swift.String.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsCreateWebhook.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgHook.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(
                        headers: headers,
                        body: body
                    ))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization webhook
    ///
    /// Returns a webhook configured in an organization. To get only the webhook
    /// `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/get(orgs/get-webhook)`.
    public func orgsGetWebhook(_ input: Operations.OrgsGetWebhook.Input) async throws -> Operations.OrgsGetWebhook.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetWebhook.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetWebhook.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgHook.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update an organization webhook
    ///
    /// Updates a webhook configured in an organization. When you update a webhook,
    /// the `secret` will be overwritten. If you previously had a `secret` set, you must
    /// provide the same `secret` or set a new `secret` or the secret will be removed. If
    /// you are only updating individual webhook `config` properties, use "[Update a webhook
    /// configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/patch(orgs/update-webhook)`.
    public func orgsUpdateWebhook(_ input: Operations.OrgsUpdateWebhook.Input) async throws -> Operations.OrgsUpdateWebhook.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdateWebhook.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsUpdateWebhook.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgHook.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an organization webhook
    ///
    /// Delete a webhook for an organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/delete(orgs/delete-webhook)`.
    public func orgsDeleteWebhook(_ input: Operations.OrgsDeleteWebhook.Input) async throws -> Operations.OrgsDeleteWebhook.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsDeleteWebhook.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a webhook configuration for an organization
    ///
    /// Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/get(orgs/get-webhook-config-for-org)`.
    public func orgsGetWebhookConfigForOrg(_ input: Operations.OrgsGetWebhookConfigForOrg.Input) async throws -> Operations.OrgsGetWebhookConfigForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetWebhookConfigForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}/config",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetWebhookConfigForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.WebhookConfig.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a webhook configuration for an organization
    ///
    /// Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/config/patch(orgs/update-webhook-config-for-org)`.
    public func orgsUpdateWebhookConfigForOrg(_ input: Operations.OrgsUpdateWebhookConfigForOrg.Input) async throws -> Operations.OrgsUpdateWebhookConfigForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdateWebhookConfigForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}/config",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsUpdateWebhookConfigForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.WebhookConfig.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List deliveries for an organization webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/get(orgs/list-webhook-deliveries)`.
    public func orgsListWebhookDeliveries(_ input: Operations.OrgsListWebhookDeliveries.Input) async throws -> Operations.OrgsListWebhookDeliveries.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListWebhookDeliveries.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}/deliveries",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "cursor",
                    value: input.query.cursor
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListWebhookDeliveries.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.HookDeliveryItem].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 400:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.BadRequest.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json",
                            "application/scim+json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    case "application/scim+json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ScimError.self,
                            from: responseBody,
                            transforming: { value in
                                .applicationScimJson(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .badRequest(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a webhook delivery for an organization webhook
    ///
    /// Returns a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/get(orgs/get-webhook-delivery)`.
    public func orgsGetWebhookDelivery(_ input: Operations.OrgsGetWebhookDelivery.Input) async throws -> Operations.OrgsGetWebhookDelivery.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetWebhookDelivery.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}/deliveries/{}",
                    parameters: [
                        input.path.org,
                        input.path.hookId,
                        input.path.deliveryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetWebhookDelivery.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.HookDelivery.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 400:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.BadRequest.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json",
                            "application/scim+json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    case "application/scim+json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ScimError.self,
                            from: responseBody,
                            transforming: { value in
                                .applicationScimJson(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .badRequest(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Redeliver a delivery for an organization webhook
    ///
    /// Redeliver a delivery for a webhook configured in an organization.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(orgs/redeliver-webhook-delivery)`.
    public func orgsRedeliverWebhookDelivery(_ input: Operations.OrgsRedeliverWebhookDelivery.Input) async throws -> Operations.OrgsRedeliverWebhookDelivery.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRedeliverWebhookDelivery.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}/deliveries/{}/attempts",
                    parameters: [
                        input.path.org,
                        input.path.hookId,
                        input.path.deliveryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            OpenAPIRuntime.OpenAPIObjectContainer.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                case 400:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.BadRequest.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json",
                            "application/scim+json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    case "application/scim+json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ScimError.self,
                            from: responseBody,
                            transforming: { value in
                                .applicationScimJson(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .badRequest(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Ping an organization webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event)
    /// to be sent to the hook.
    ///
    /// You must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
    /// webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/hooks/{hook_id}/pings`.
    /// - Remark: Generated from `#/paths//orgs/{org}/hooks/{hook_id}/pings/post(orgs/ping-webhook)`.
    public func orgsPingWebhook(_ input: Operations.OrgsPingWebhook.Input) async throws -> Operations.OrgsPingWebhook.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsPingWebhook.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/hooks/{}/pings",
                    parameters: [
                        input.path.org,
                        input.path.hookId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get route stats by actor
    ///
    /// Get API request count statistics for an actor broken down by route within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}/get(api-insights/get-route-stats-by-actor)`.
    public func apiInsightsGetRouteStatsByActor(_ input: Operations.ApiInsightsGetRouteStatsByActor.Input) async throws -> Operations.ApiInsightsGetRouteStatsByActor.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetRouteStatsByActor.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/route-stats/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.actorType,
                        input.path.actorId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "sort",
                    value: input.query.sort
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "api_route_substring",
                    value: input.query.apiRouteSubstring
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetRouteStatsByActor.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsRouteStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get subject stats
    ///
    /// Get API request statistics for all subjects within an organization within a specified time frame. Subjects can be users or GitHub Apps.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/subject-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/subject-stats/get(api-insights/get-subject-stats)`.
    public func apiInsightsGetSubjectStats(_ input: Operations.ApiInsightsGetSubjectStats.Input) async throws -> Operations.ApiInsightsGetSubjectStats.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetSubjectStats.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/subject-stats",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "sort",
                    value: input.query.sort
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "subject_name_substring",
                    value: input.query.subjectNameSubstring
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetSubjectStats.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsSubjectStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get summary stats
    ///
    /// Get overall statistics of API requests made within an organization by all users and apps within a specified time frame.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/get(api-insights/get-summary-stats)`.
    public func apiInsightsGetSummaryStats(_ input: Operations.ApiInsightsGetSummaryStats.Input) async throws -> Operations.ApiInsightsGetSummaryStats.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetSummaryStats.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/summary-stats",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetSummaryStats.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsSummaryStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get summary stats by user
    ///
    /// Get overall statistics of API requests within the organization for a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/users/{user_id}/get(api-insights/get-summary-stats-by-user)`.
    public func apiInsightsGetSummaryStatsByUser(_ input: Operations.ApiInsightsGetSummaryStatsByUser.Input) async throws -> Operations.ApiInsightsGetSummaryStatsByUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetSummaryStatsByUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/summary-stats/users/{}",
                    parameters: [
                        input.path.org,
                        input.path.userId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetSummaryStatsByUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsSummaryStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get summary stats by actor
    ///
    /// Get overall statistics of API requests within the organization made by a specific actor. Actors can be GitHub App installations, OAuth apps or other tokens on behalf of a user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}/get(api-insights/get-summary-stats-by-actor)`.
    public func apiInsightsGetSummaryStatsByActor(_ input: Operations.ApiInsightsGetSummaryStatsByActor.Input) async throws -> Operations.ApiInsightsGetSummaryStatsByActor.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetSummaryStatsByActor.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/summary-stats/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.actorType,
                        input.path.actorId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetSummaryStatsByActor.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsSummaryStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get time stats
    ///
    /// Get the number of API requests and rate-limited requests made within an organization over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/get(api-insights/get-time-stats)`.
    public func apiInsightsGetTimeStats(_ input: Operations.ApiInsightsGetTimeStats.Input) async throws -> Operations.ApiInsightsGetTimeStats.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetTimeStats.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/time-stats",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "timestamp_increment",
                    value: input.query.timestampIncrement
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetTimeStats.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsTimeStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get time stats by user
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific user over a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/users/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/users/{user_id}/get(api-insights/get-time-stats-by-user)`.
    public func apiInsightsGetTimeStatsByUser(_ input: Operations.ApiInsightsGetTimeStatsByUser.Input) async throws -> Operations.ApiInsightsGetTimeStatsByUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetTimeStatsByUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/time-stats/users/{}",
                    parameters: [
                        input.path.org,
                        input.path.userId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "timestamp_increment",
                    value: input.query.timestampIncrement
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetTimeStatsByUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsTimeStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get time stats by actor
    ///
    /// Get the number of API requests and rate-limited requests made within an organization by a specific actor within a specified time period.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}/get(api-insights/get-time-stats-by-actor)`.
    public func apiInsightsGetTimeStatsByActor(_ input: Operations.ApiInsightsGetTimeStatsByActor.Input) async throws -> Operations.ApiInsightsGetTimeStatsByActor.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetTimeStatsByActor.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/time-stats/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.actorType,
                        input.path.actorId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "timestamp_increment",
                    value: input.query.timestampIncrement
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetTimeStatsByActor.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsTimeStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get user stats
    ///
    /// Get API usage statistics within an organization for a user broken down by the type of access.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/insights/api/user-stats/{user_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/insights/api/user-stats/{user_id}/get(api-insights/get-user-stats)`.
    public func apiInsightsGetUserStats(_ input: Operations.ApiInsightsGetUserStats.Input) async throws -> Operations.ApiInsightsGetUserStats.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ApiInsightsGetUserStats.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/insights/api/user-stats/{}",
                    parameters: [
                        input.path.org,
                        input.path.userId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "min_timestamp",
                    value: input.query.minTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "max_timestamp",
                    value: input.query.maxTimestamp
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "sort",
                    value: input.query.sort
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "actor_name_substring",
                    value: input.query.actorNameSubstring
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ApiInsightsGetUserStats.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ApiInsightsUserStats.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List app installations for an organization
    ///
    /// Lists all GitHub Apps in an organization. The installation count includes
    /// all GitHub Apps installed on repositories in the organization.
    ///
    /// The authenticated user must be an organization owner to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/installations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/installations/get(orgs/list-app-installations)`.
    public func orgsListAppInstallations(_ input: Operations.OrgsListAppInstallations.Input) async throws -> Operations.OrgsListAppInstallations.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListAppInstallations.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/installations",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListAppInstallations.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListAppInstallations.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsListAppInstallations.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List pending organization invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization
    /// Invitation role and will be one of the following values: `direct_member`, `admin`,
    /// `billing_manager`, or `hiring_manager`. If the invitee is not a GitHub
    /// member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/get(orgs/list-pending-invitations)`.
    public func orgsListPendingInvitations(_ input: Operations.OrgsListPendingInvitations.Input) async throws -> Operations.OrgsListPendingInvitations.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListPendingInvitations.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/invitations",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "role",
                    value: input.query.role
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "invitation_source",
                    value: input.query.invitationSource
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListPendingInvitations.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListPendingInvitations.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationInvitation].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create an organization invitation
    ///
    /// Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /orgs/{org}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/post(orgs/create-invitation)`.
    public func orgsCreateInvitation(_ input: Operations.OrgsCreateInvitation.Input) async throws -> Operations.OrgsCreateInvitation.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCreateInvitation.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/invitations",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsCreateInvitation.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrganizationInvitation.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Cancel an organization invitation
    ///
    /// Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/delete(orgs/cancel-invitation)`.
    public func orgsCancelInvitation(_ input: Operations.OrgsCancelInvitation.Input) async throws -> Operations.OrgsCancelInvitation.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCancelInvitation.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/invitations/{}",
                    parameters: [
                        input.path.org,
                        input.path.invitationId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organization invitation teams
    ///
    /// List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/invitations/{invitation_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/invitations/{invitation_id}/teams/get(orgs/list-invitation-teams)`.
    public func orgsListInvitationTeams(_ input: Operations.OrgsListInvitationTeams.Input) async throws -> Operations.OrgsListInvitationTeams.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListInvitationTeams.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/invitations/{}/teams",
                    parameters: [
                        input.path.org,
                        input.path.invitationId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListInvitationTeams.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListInvitationTeams.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Team].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List issue types for an organization
    ///
    /// Lists all issue types for an organization. OAuth app tokens and personal access tokens (classic) need the read:org scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/get(orgs/list-issue-types)`.
    public func orgsListIssueTypes(_ input: Operations.OrgsListIssueTypes.Input) async throws -> Operations.OrgsListIssueTypes.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListIssueTypes.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/issue-types",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListIssueTypes.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.IssueType].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create issue type for an organization
    ///
    /// Create a new issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/issue-types`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/post(orgs/create-issue-type)`.
    public func orgsCreateIssueType(_ input: Operations.OrgsCreateIssueType.Input) async throws -> Operations.OrgsCreateIssueType.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCreateIssueType.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/issue-types",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsCreateIssueType.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.IssueType.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update issue type for an organization
    ///
    /// Updates an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/put(orgs/update-issue-type)`.
    public func orgsUpdateIssueType(_ input: Operations.OrgsUpdateIssueType.Input) async throws -> Operations.OrgsUpdateIssueType.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdateIssueType.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/issue-types/{}",
                    parameters: [
                        input.path.org,
                        input.path.issueTypeId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsUpdateIssueType.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.IssueType.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete issue type for an organization
    ///
    /// Deletes an issue type for an organization.
    ///
    /// You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).
    ///
    /// To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
    /// personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/issue-types/{issue_type_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issue-types/{issue_type_id}/delete(orgs/delete-issue-type)`.
    public func orgsDeleteIssueType(_ input: Operations.OrgsDeleteIssueType.Input) async throws -> Operations.OrgsDeleteIssueType.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsDeleteIssueType.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/issue-types/{}",
                    parameters: [
                        input.path.org,
                        input.path.issueTypeId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organization members
    ///
    /// List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/get(orgs/list-members)`.
    public func orgsListMembers(_ input: Operations.OrgsListMembers.Input) async throws -> Operations.OrgsListMembers.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListMembers.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/members",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "filter",
                    value: input.query.filter
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "role",
                    value: input.query.role
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListMembers.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListMembers.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check organization membership for a user
    ///
    /// Check if a user is, publicly or privately, a member of the organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/get(orgs/check-membership-for-user)`.
    public func orgsCheckMembershipForUser(_ input: Operations.OrgsCheckMembershipForUser.Input) async throws -> Operations.OrgsCheckMembershipForUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCheckMembershipForUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/members/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 302:
                    let headers: Operations.OrgsCheckMembershipForUser.Output.Found.Headers = .init(location: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Location",
                        as: Swift.String.self
                    ))
                    return .found(.init(headers: headers))
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove an organization member
    ///
    /// Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
    ///
    /// > [!NOTE]
    /// > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/delete(orgs/remove-member)`.
    public func orgsRemoveMember(_ input: Operations.OrgsRemoveMember.Input) async throws -> Operations.OrgsRemoveMember.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRemoveMember.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/members/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get organization membership for a user
    ///
    /// In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/get(orgs/get-membership-for-user)`.
    public func orgsGetMembershipForUser(_ input: Operations.OrgsGetMembershipForUser.Input) async throws -> Operations.OrgsGetMembershipForUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetMembershipForUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/memberships/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetMembershipForUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set organization membership for a user
    ///
    /// Only authenticated organization owners can add a member to the organization or update the member's role.
    ///
    /// *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
    ///     
    /// *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
    ///
    /// **Rate limits**
    ///
    /// To prevent abuse, organization owners are limited to creating 50 organization invitations for an organization within a 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/put(orgs/set-membership-for-user)`.
    public func orgsSetMembershipForUser(_ input: Operations.OrgsSetMembershipForUser.Input) async throws -> Operations.OrgsSetMembershipForUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsSetMembershipForUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/memberships/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsSetMembershipForUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove organization membership for a user
    ///
    /// In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
    ///
    /// If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
    ///
    /// > [!NOTE]
    /// > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/memberships/{username}/delete(orgs/remove-membership-for-user)`.
    public func orgsRemoveMembershipForUser(_ input: Operations.OrgsRemoveMembershipForUser.Input) async throws -> Operations.OrgsRemoveMembershipForUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRemoveMembershipForUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/memberships/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get all organization roles for an organization
    ///
    /// Lists the organization roles available in this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/get(orgs/list-org-roles)`.
    public func orgsListOrgRoles(_ input: Operations.OrgsListOrgRoles.Input) async throws -> Operations.OrgsListOrgRoles.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListOrgRoles.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListOrgRoles.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsListOrgRoles.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove all organization roles for a team
    ///
    /// Removes all assigned organization roles from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/delete(orgs/revoke-all-org-roles-team)`.
    public func orgsRevokeAllOrgRolesTeam(_ input: Operations.OrgsRevokeAllOrgRolesTeam.Input) async throws -> Operations.OrgsRevokeAllOrgRolesTeam.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRevokeAllOrgRolesTeam.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/teams/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Assign an organization role to a team
    ///
    /// Assigns an organization role to a team in an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/{role_id}/put(orgs/assign-team-to-org-role)`.
    public func orgsAssignTeamToOrgRole(_ input: Operations.OrgsAssignTeamToOrgRole.Input) async throws -> Operations.OrgsAssignTeamToOrgRole.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsAssignTeamToOrgRole.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/teams/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                case 422:
                    return .unprocessableContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove an organization role from a team
    ///
    /// Removes an organization role from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/teams/{team_slug}/{role_id}/delete(orgs/revoke-org-role-team)`.
    public func orgsRevokeOrgRoleTeam(_ input: Operations.OrgsRevokeOrgRoleTeam.Input) async throws -> Operations.OrgsRevokeOrgRoleTeam.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRevokeOrgRoleTeam.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/teams/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove all organization roles for a user
    ///
    /// Revokes all assigned organization roles from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/users/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/delete(orgs/revoke-all-org-roles-user)`.
    public func orgsRevokeAllOrgRolesUser(_ input: Operations.OrgsRevokeAllOrgRolesUser.Input) async throws -> Operations.OrgsRevokeAllOrgRolesUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRevokeAllOrgRolesUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/users/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Assign an organization role to a user
    ///
    /// Assigns an organization role to a member of an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/organization-roles/users/{username}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/{role_id}/put(orgs/assign-user-to-org-role)`.
    public func orgsAssignUserToOrgRole(_ input: Operations.OrgsAssignUserToOrgRole.Input) async throws -> Operations.OrgsAssignUserToOrgRole.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsAssignUserToOrgRole.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/users/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.username,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                case 422:
                    return .unprocessableContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove an organization role from a user
    ///
    /// Remove an organization role from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// The authenticated user must be an administrator for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/organization-roles/users/{username}/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/users/{username}/{role_id}/delete(orgs/revoke-org-role-user)`.
    public func orgsRevokeOrgRoleUser(_ input: Operations.OrgsRevokeOrgRoleUser.Input) async throws -> Operations.OrgsRevokeOrgRoleUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRevokeOrgRoleUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/users/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.username,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization role
    ///
    /// Gets an organization role that is available to this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/get(orgs/get-org-role)`.
    public func orgsGetOrgRole(_ input: Operations.OrgsGetOrgRole.Input) async throws -> Operations.OrgsGetOrgRole.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetOrgRole.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/{}",
                    parameters: [
                        input.path.org,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetOrgRole.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrganizationRole.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List teams that are assigned to an organization role
    ///
    /// Lists the teams that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, you must be an administrator for the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/teams/get(orgs/list-org-role-teams)`.
    public func orgsListOrgRoleTeams(_ input: Operations.OrgsListOrgRoleTeams.Input) async throws -> Operations.OrgsListOrgRoleTeams.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListOrgRoleTeams.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/{}/teams",
                    parameters: [
                        input.path.org,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListOrgRoleTeams.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListOrgRoleTeams.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamRoleAssignment].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    return .notFound(.init())
                case 422:
                    return .unprocessableContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List users that are assigned to an organization role
    ///
    /// Lists organization members that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."
    ///
    /// To use this endpoint, you must be an administrator for the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/organization-roles/{role_id}/users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/organization-roles/{role_id}/users/get(orgs/list-org-role-users)`.
    public func orgsListOrgRoleUsers(_ input: Operations.OrgsListOrgRoleUsers.Input) async throws -> Operations.OrgsListOrgRoleUsers.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListOrgRoleUsers.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/organization-roles/{}/users",
                    parameters: [
                        input.path.org,
                        input.path.roleId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListOrgRoleUsers.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListOrgRoleUsers.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.UserRoleAssignment].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    return .notFound(.init())
                case 422:
                    return .unprocessableContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List outside collaborators for an organization
    ///
    /// List all users who are outside collaborators of an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/outside_collaborators`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/get(orgs/list-outside-collaborators)`.
    public func orgsListOutsideCollaborators(_ input: Operations.OrgsListOutsideCollaborators.Input) async throws -> Operations.OrgsListOutsideCollaborators.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListOutsideCollaborators.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/outside_collaborators",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "filter",
                    value: input.query.filter
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListOutsideCollaborators.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListOutsideCollaborators.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Convert an organization member to outside collaborator
    ///
    /// When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/outside_collaborators/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/{username}/put(orgs/convert-member-to-outside-collaborator)`.
    public func orgsConvertMemberToOutsideCollaborator(_ input: Operations.OrgsConvertMemberToOutsideCollaborator.Input) async throws -> Operations.OrgsConvertMemberToOutsideCollaborator.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsConvertMemberToOutsideCollaborator.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/outside_collaborators/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsConvertMemberToOutsideCollaborator.Output.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsConvertMemberToOutsideCollaborator.Output.Accepted.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                case 204:
                    return .noContent(.init())
                case 403:
                    return .forbidden(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove outside collaborator from an organization
    ///
    /// Removing a user from this list will remove them from all the organization's repositories.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/outside_collaborators/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/outside_collaborators/{username}/delete(orgs/remove-outside-collaborator)`.
    public func orgsRemoveOutsideCollaborator(_ input: Operations.OrgsRemoveOutsideCollaborator.Input) async throws -> Operations.OrgsRemoveOutsideCollaborator.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRemoveOutsideCollaborator.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/outside_collaborators/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsRemoveOutsideCollaborator.Output.UnprocessableContent.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.OrgsRemoveOutsideCollaborator.Output.UnprocessableContent.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List requests to access organization resources with fine-grained personal access tokens
    ///
    /// Lists requests from organization members to access organization resources with a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-token-requests`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/get(orgs/list-pat-grant-requests)`.
    public func orgsListPatGrantRequests(_ input: Operations.OrgsListPatGrantRequests.Input) async throws -> Operations.OrgsListPatGrantRequests.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListPatGrantRequests.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-token-requests",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "sort",
                    value: input.query.sort
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "owner",
                    value: input.query.owner
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "repository",
                    value: input.query.repository
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "permission",
                    value: input.query.permission
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "last_used_before",
                    value: input.query.lastUsedBefore
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "last_used_after",
                    value: input.query.lastUsedAfter
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "token_id",
                    value: input.query.tokenId
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 200:
                    let headers: Operations.OrgsListPatGrantRequests.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListPatGrantRequests.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationProgrammaticAccessGrantRequest].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Review requests to access organization resources with fine-grained personal access tokens
    ///
    /// Approves or denies multiple pending requests to access organization resources via a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-token-requests`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/post(orgs/review-pat-grant-requests-in-bulk)`.
    public func orgsReviewPatGrantRequestsInBulk(_ input: Operations.OrgsReviewPatGrantRequestsInBulk.Input) async throws -> Operations.OrgsReviewPatGrantRequestsInBulk.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsReviewPatGrantRequestsInBulk.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-token-requests",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            OpenAPIRuntime.OpenAPIObjectContainer.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Review a request to access organization resources with a fine-grained personal access token
    ///
    /// Approves or denies a pending request to access organization resources via a fine-grained personal access token.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-token-requests/{pat_request_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/{pat_request_id}/post(orgs/review-pat-grant-request)`.
    public func orgsReviewPatGrantRequest(_ input: Operations.OrgsReviewPatGrantRequest.Input) async throws -> Operations.OrgsReviewPatGrantRequest.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsReviewPatGrantRequest.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-token-requests/{}",
                    parameters: [
                        input.path.org,
                        input.path.patRequestId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repositories requested to be accessed by a fine-grained personal access token
    ///
    /// Lists the repositories a fine-grained personal access token request is requesting access to.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories/get(orgs/list-pat-grant-request-repositories)`.
    public func orgsListPatGrantRequestRepositories(_ input: Operations.OrgsListPatGrantRequestRepositories.Input) async throws -> Operations.OrgsListPatGrantRequestRepositories.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListPatGrantRequestRepositories.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-token-requests/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.patRequestId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 200:
                    let headers: Operations.OrgsListPatGrantRequestRepositories.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListPatGrantRequestRepositories.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.MinimalRepository].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List fine-grained personal access tokens with access to organization resources
    ///
    /// Lists approved fine-grained personal access tokens owned by organization members that can access organization resources.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-tokens`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/get(orgs/list-pat-grants)`.
    public func orgsListPatGrants(_ input: Operations.OrgsListPatGrants.Input) async throws -> Operations.OrgsListPatGrants.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListPatGrants.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-tokens",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "sort",
                    value: input.query.sort
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "owner",
                    value: input.query.owner
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "repository",
                    value: input.query.repository
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "permission",
                    value: input.query.permission
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "last_used_before",
                    value: input.query.lastUsedBefore
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "last_used_after",
                    value: input.query.lastUsedAfter
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "token_id",
                    value: input.query.tokenId
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 200:
                    let headers: Operations.OrgsListPatGrants.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListPatGrants.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationProgrammaticAccessGrant].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update the access to organization resources via fine-grained personal access tokens
    ///
    /// Updates the access organization members have to organization resources via fine-grained personal access tokens. Limited to revoking a token's existing access.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-tokens`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/post(orgs/update-pat-accesses)`.
    public func orgsUpdatePatAccesses(_ input: Operations.OrgsUpdatePatAccesses.Input) async throws -> Operations.OrgsUpdatePatAccesses.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdatePatAccesses.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-tokens",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            OpenAPIRuntime.OpenAPIObjectContainer.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update the access a fine-grained personal access token has to organization resources
    ///
    /// Updates the access an organization member has to organization resources via a fine-grained personal access token. Limited to revoking the token's existing access. Limited to revoking a token's existing access.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/personal-access-tokens/{pat_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/{pat_id}/post(orgs/update-pat-access)`.
    public func orgsUpdatePatAccess(_ input: Operations.OrgsUpdatePatAccess.Input) async throws -> Operations.OrgsUpdatePatAccess.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdatePatAccess.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-tokens/{}",
                    parameters: [
                        input.path.org,
                        input.path.patId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repositories a fine-grained personal access token has access to
    ///
    /// Lists the repositories a fine-grained personal access token has access to.
    ///
    /// Only GitHub Apps can use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/personal-access-tokens/{pat_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/personal-access-tokens/{pat_id}/repositories/get(orgs/list-pat-grant-repositories)`.
    public func orgsListPatGrantRepositories(_ input: Operations.OrgsListPatGrantRepositories.Input) async throws -> Operations.OrgsListPatGrantRepositories.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListPatGrantRepositories.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/personal-access-tokens/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.patId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 200:
                    let headers: Operations.OrgsListPatGrantRepositories.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListPatGrantRepositories.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.MinimalRepository].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get all custom properties for an organization
    ///
    /// Gets all custom properties defined for an organization.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/schema`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/get(orgs/get-all-custom-properties)`.
    public func orgsGetAllCustomProperties(_ input: Operations.OrgsGetAllCustomProperties.Input) async throws -> Operations.OrgsGetAllCustomProperties.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetAllCustomProperties.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/schema",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetAllCustomProperties.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.CustomProperty].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create or update custom properties for an organization
    ///
    /// Creates new or updates existing custom properties defined for an organization in a batch.
    ///
    /// If the property already exists, the existing property will be replaced with the new values.
    /// Missing optional values will fall back to default values, previous values will be overwritten.
    /// E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/properties/schema`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/patch(orgs/create-or-update-custom-properties)`.
    public func orgsCreateOrUpdateCustomProperties(_ input: Operations.OrgsCreateOrUpdateCustomProperties.Input) async throws -> Operations.OrgsCreateOrUpdateCustomProperties.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCreateOrUpdateCustomProperties.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/schema",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsCreateOrUpdateCustomProperties.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.CustomProperty].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a custom property for an organization
    ///
    /// Gets a custom property that is defined for an organization.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/get(orgs/get-custom-property)`.
    public func orgsGetCustomProperty(_ input: Operations.OrgsGetCustomProperty.Input) async throws -> Operations.OrgsGetCustomProperty.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetCustomProperty.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/schema/{}",
                    parameters: [
                        input.path.org,
                        input.path.customPropertyName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetCustomProperty.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CustomProperty.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create or update a custom property for an organization
    ///
    /// Creates a new or updates an existing custom property that is defined for an organization.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    /// - An administrator for the organization.
    /// - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/put(orgs/create-or-update-custom-property)`.
    public func orgsCreateOrUpdateCustomProperty(_ input: Operations.OrgsCreateOrUpdateCustomProperty.Input) async throws -> Operations.OrgsCreateOrUpdateCustomProperty.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCreateOrUpdateCustomProperty.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/schema/{}",
                    parameters: [
                        input.path.org,
                        input.path.customPropertyName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsCreateOrUpdateCustomProperty.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CustomProperty.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a custom property for an organization
    ///
    /// Removes a custom property that is defined for an organization.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/properties/schema/{custom_property_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/schema/{custom_property_name}/delete(orgs/remove-custom-property)`.
    public func orgsRemoveCustomProperty(_ input: Operations.OrgsRemoveCustomProperty.Input) async throws -> Operations.OrgsRemoveCustomProperty.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRemoveCustomProperty.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/schema/{}",
                    parameters: [
                        input.path.org,
                        input.path.customPropertyName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List custom property values for organization repositories
    ///
    /// Lists organization repositories with all of their custom property values.
    /// Organization members can read these properties.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/properties/values`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/values/get(orgs/list-custom-properties-values-for-repos)`.
    public func orgsListCustomPropertiesValuesForRepos(_ input: Operations.OrgsListCustomPropertiesValuesForRepos.Input) async throws -> Operations.OrgsListCustomPropertiesValuesForRepos.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListCustomPropertiesValuesForRepos.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/values",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "repository_query",
                    value: input.query.repositoryQuery
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListCustomPropertiesValuesForRepos.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListCustomPropertiesValuesForRepos.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrgRepoCustomPropertyValues].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create or update custom property values for organization repositories
    ///
    /// Create new or update existing custom property values for repositories in a batch that belong to an organization.
    /// Each target repository will have its custom property values updated to match the values provided in the request.
    ///
    /// A maximum of 30 repositories can be updated in a single request.
    ///
    /// Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.
    ///
    /// To use this endpoint, the authenticated user must be one of:
    ///   - An administrator for the organization.
    ///   - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_values_editor` in the organization.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/properties/values`.
    /// - Remark: Generated from `#/paths//orgs/{org}/properties/values/patch(orgs/create-or-update-custom-properties-values-for-repos)`.
    public func orgsCreateOrUpdateCustomPropertiesValuesForRepos(_ input: Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Input) async throws -> Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCreateOrUpdateCustomPropertiesValuesForRepos.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/properties/values",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List public organization members
    ///
    /// Members of an organization can choose to have their membership publicized or not.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/public_members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/get(orgs/list-public-members)`.
    public func orgsListPublicMembers(_ input: Operations.OrgsListPublicMembers.Input) async throws -> Operations.OrgsListPublicMembers.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListPublicMembers.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/public_members",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListPublicMembers.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListPublicMembers.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check public organization membership for a user
    ///
    /// Check if the provided user is a public member of the organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/get(orgs/check-public-membership-for-user)`.
    public func orgsCheckPublicMembershipForUser(_ input: Operations.OrgsCheckPublicMembershipForUser.Input) async throws -> Operations.OrgsCheckPublicMembershipForUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsCheckPublicMembershipForUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/public_members/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set public organization membership for the authenticated user
    ///
    /// The user can publicize their own membership. (A user cannot publicize the membership for another user.)
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/put(orgs/set-public-membership-for-authenticated-user)`.
    public func orgsSetPublicMembershipForAuthenticatedUser(_ input: Operations.OrgsSetPublicMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsSetPublicMembershipForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsSetPublicMembershipForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/public_members/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove public organization membership for the authenticated user
    ///
    /// Removes the public membership for the authenticated user from the specified organization, unless public visibility is enforced by default.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/public_members/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/public_members/{username}/delete(orgs/remove-public-membership-for-authenticated-user)`.
    public func orgsRemovePublicMembershipForAuthenticatedUser(_ input: Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsRemovePublicMembershipForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRemovePublicMembershipForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/public_members/{}",
                    parameters: [
                        input.path.org,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get organization ruleset history
    ///
    /// Get the history of an organization ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}/history`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/history/get(orgs/get-org-ruleset-history)`.
    public func orgsGetOrgRulesetHistory(_ input: Operations.OrgsGetOrgRulesetHistory.Input) async throws -> Operations.OrgsGetOrgRulesetHistory.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetOrgRulesetHistory.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/rulesets/{}/history",
                    parameters: [
                        input.path.org,
                        input.path.rulesetId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetOrgRulesetHistory.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.RulesetVersion].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get organization ruleset version
    ///
    /// Get a version of an organization ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}/history/{version_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/history/{version_id}/get(orgs/get-org-ruleset-version)`.
    public func orgsGetOrgRulesetVersion(_ input: Operations.OrgsGetOrgRulesetVersion.Input) async throws -> Operations.OrgsGetOrgRulesetVersion.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetOrgRulesetVersion.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/rulesets/{}/history/{}",
                    parameters: [
                        input.path.org,
                        input.path.rulesetId,
                        input.path.versionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetOrgRulesetVersion.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RulesetVersionWithState.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List security manager teams
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/security-managers`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/get(orgs/list-security-manager-teams)`.
    @available(*, deprecated)
    public func orgsListSecurityManagerTeams(_ input: Operations.OrgsListSecurityManagerTeams.Input) async throws -> Operations.OrgsListSecurityManagerTeams.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListSecurityManagerTeams.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/security-managers",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListSecurityManagerTeams.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamSimple].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add a security manager team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/security-managers/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/teams/{team_slug}/put(orgs/add-security-manager-team)`.
    @available(*, deprecated)
    public func orgsAddSecurityManagerTeam(_ input: Operations.OrgsAddSecurityManagerTeam.Input) async throws -> Operations.OrgsAddSecurityManagerTeam.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsAddSecurityManagerTeam.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/security-managers/teams/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a security manager team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/security-managers/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-managers/teams/{team_slug}/delete(orgs/remove-security-manager-team)`.
    @available(*, deprecated)
    public func orgsRemoveSecurityManagerTeam(_ input: Operations.OrgsRemoveSecurityManagerTeam.Input) async throws -> Operations.OrgsRemoveSecurityManagerTeam.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsRemoveSecurityManagerTeam.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/security-managers/teams/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Enable or disable a security feature for an organization
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** The ability to enable or disable a security feature for all eligible repositories in an organization is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-07-22-deprecation-of-api-endpoint-to-enable-or-disable-a-security-feature-for-an-organization/).
    ///
    /// Enables or disables the specified security feature for all eligible repositories in an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// The authenticated user must be an organization owner or be member of a team with the security manager role to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org`, `write:org`, or `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/{security_product}/{enablement}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/{security_product}/{enablement}/post(orgs/enable-or-disable-security-product-on-all-org-repos)`.
    @available(*, deprecated)
    public func orgsEnableOrDisableSecurityProductOnAllOrgRepos(_ input: Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Input) async throws -> Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsEnableOrDisableSecurityProductOnAllOrgRepos.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.securityProduct,
                        input.path.enablement
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    return .unprocessableContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organization memberships for the authenticated user
    ///
    /// Lists all of the authenticated user's organization memberships.
    ///
    /// - Remark: HTTP `GET /user/memberships/orgs`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/get(orgs/list-memberships-for-authenticated-user)`.
    public func orgsListMembershipsForAuthenticatedUser(_ input: Operations.OrgsListMembershipsForAuthenticatedUser.Input) async throws -> Operations.OrgsListMembershipsForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListMembershipsForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/user/memberships/orgs",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "state",
                    value: input.query.state
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListMembershipsForAuthenticatedUser.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListMembershipsForAuthenticatedUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrgMembership].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 304:
                    return .notModified(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 401:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.RequiresAuthentication.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unauthorized(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization membership for the authenticated user
    ///
    /// If the authenticated user is an active or pending member of the organization, this endpoint will return the user's membership. If the authenticated user is not affiliated with the organization, a `404` is returned. This endpoint will return a `403` if the request is made by a GitHub App that is blocked by the organization.
    ///
    /// - Remark: HTTP `GET /user/memberships/orgs/{org}`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/{org}/get(orgs/get-membership-for-authenticated-user)`.
    public func orgsGetMembershipForAuthenticatedUser(_ input: Operations.OrgsGetMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsGetMembershipForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsGetMembershipForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/user/memberships/orgs/{}",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsGetMembershipForAuthenticatedUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update an organization membership for the authenticated user
    ///
    /// Converts the authenticated user to an active member of the organization, if that user has a pending invitation from the organization.
    ///
    /// - Remark: HTTP `PATCH /user/memberships/orgs/{org}`.
    /// - Remark: Generated from `#/paths//user/memberships/orgs/{org}/patch(orgs/update-membership-for-authenticated-user)`.
    public func orgsUpdateMembershipForAuthenticatedUser(_ input: Operations.OrgsUpdateMembershipForAuthenticatedUser.Input) async throws -> Operations.OrgsUpdateMembershipForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsUpdateMembershipForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/user/memberships/orgs/{}",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsUpdateMembershipForAuthenticatedUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrgMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organizations for the authenticated user
    ///
    /// List organizations for the authenticated user.
    ///
    /// For OAuth app tokens and personal access tokens (classic), this endpoint only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope for OAuth app tokens and personal access tokens (classic). Requests with insufficient scope will receive a `403 Forbidden` response.
    ///
    /// > [!NOTE]
    /// > Requests using a fine-grained access token will receive a `200 Success` response with an empty list.
    ///
    /// - Remark: HTTP `GET /user/orgs`.
    /// - Remark: Generated from `#/paths//user/orgs/get(orgs/list-for-authenticated-user)`.
    public func orgsListForAuthenticatedUser(_ input: Operations.OrgsListForAuthenticatedUser.Input) async throws -> Operations.OrgsListForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/user/orgs",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListForAuthenticatedUser.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListForAuthenticatedUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationSimple].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 304:
                    return .notModified(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 401:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.RequiresAuthentication.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unauthorized(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organizations for a user
    ///
    /// List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
    ///
    /// This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user) API instead.
    ///
    /// - Remark: HTTP `GET /users/{username}/orgs`.
    /// - Remark: Generated from `#/paths//users/{username}/orgs/get(orgs/list-for-user)`.
    public func orgsListForUser(_ input: Operations.OrgsListForUser.Input) async throws -> Operations.OrgsListForUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.OrgsListForUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/users/{}/orgs",
                    parameters: [
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.OrgsListForUser.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.OrgsListForUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationSimple].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
