// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List issues assigned to the authenticated user
    ///
    /// List issues assigned to the authenticated user across all visible repositories including owned repositories, member
    /// repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
    /// necessarily assigned to you.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /issues`.
    /// - Remark: Generated from `#/paths//issues/get(issues/list)`.
    func issuesList(_ input: Operations.IssuesList.Input) async throws -> Operations.IssuesList.Output
    /// List organization issues assigned to the authenticated user
    ///
    /// List issues in an organization assigned to the authenticated user.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issues`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issues/get(issues/list-for-org)`.
    func issuesListForOrg(_ input: Operations.IssuesListForOrg.Input) async throws -> Operations.IssuesListForOrg.Output
    /// List assignees
    ///
    /// Lists the [available assignees](https://docs.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/get(issues/list-assignees)`.
    func issuesListAssignees(_ input: Operations.IssuesListAssignees.Input) async throws -> Operations.IssuesListAssignees.Output
    /// Check if a user can be assigned
    ///
    /// Checks if a user has permission to be assigned to an issue in this repository.
    ///
    /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
    ///
    /// Otherwise a `404` status code is returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/assignees/{assignee}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/{assignee}/get(issues/check-user-can-be-assigned)`.
    func issuesCheckUserCanBeAssigned(_ input: Operations.IssuesCheckUserCanBeAssigned.Input) async throws -> Operations.IssuesCheckUserCanBeAssigned.Output
    /// List repository issues
    ///
    /// List issues in a repository. Only open issues will be listed.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)`.
    func issuesListForRepo(_ input: Operations.IssuesListForRepo.Input) async throws -> Operations.IssuesListForRepo.Output
    /// Create an issue
    ///
    /// Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://docs.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)`.
    func issuesCreate(_ input: Operations.IssuesCreate.Input) async throws -> Operations.IssuesCreate.Output
    /// List issue comments for a repository
    ///
    /// You can use the REST API to list comments on issues and pull requests for a repository. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// By default, issue comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/get(issues/list-comments-for-repo)`.
    func issuesListCommentsForRepo(_ input: Operations.IssuesListCommentsForRepo.Input) async throws -> Operations.IssuesListCommentsForRepo.Output
    /// Get an issue comment
    ///
    /// You can use the REST API to get comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/get(issues/get-comment)`.
    func issuesGetComment(_ input: Operations.IssuesGetComment.Input) async throws -> Operations.IssuesGetComment.Output
    /// Update an issue comment
    ///
    /// You can use the REST API to update comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/patch(issues/update-comment)`.
    func issuesUpdateComment(_ input: Operations.IssuesUpdateComment.Input) async throws -> Operations.IssuesUpdateComment.Output
    /// Delete an issue comment
    ///
    /// You can use the REST API to delete comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/delete(issues/delete-comment)`.
    func issuesDeleteComment(_ input: Operations.IssuesDeleteComment.Input) async throws -> Operations.IssuesDeleteComment.Output
    /// List issue events for a repository
    ///
    /// Lists events for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/get(issues/list-events-for-repo)`.
    func issuesListEventsForRepo(_ input: Operations.IssuesListEventsForRepo.Input) async throws -> Operations.IssuesListEventsForRepo.Output
    /// Get an issue event
    ///
    /// Gets a single event by the event id.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/events/{event_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)`.
    func issuesGetEvent(_ input: Operations.IssuesGetEvent.Input) async throws -> Operations.IssuesGetEvent.Output
    /// Get an issue
    ///
    /// The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api#follow-redirects) if the issue was
    /// [transferred](https://docs.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
    /// the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
    /// returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
    /// access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
    /// to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)`.
    func issuesGet(_ input: Operations.IssuesGet.Input) async throws -> Operations.IssuesGet.Output
    /// Update an issue
    ///
    /// Issue owners and users with push access or Triage role can edit an issue.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/{issue_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)`.
    func issuesUpdate(_ input: Operations.IssuesUpdate.Input) async throws -> Operations.IssuesUpdate.Output
    /// Add assignees to an issue
    ///
    /// Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/post(issues/add-assignees)`.
    func issuesAddAssignees(_ input: Operations.IssuesAddAssignees.Input) async throws -> Operations.IssuesAddAssignees.Output
    /// Remove assignees from an issue
    ///
    /// Removes one or more assignees from an issue.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/delete(issues/remove-assignees)`.
    func issuesRemoveAssignees(_ input: Operations.IssuesRemoveAssignees.Input) async throws -> Operations.IssuesRemoveAssignees.Output
    /// Check if a user can be assigned to a issue
    ///
    /// Checks if a user has permission to be assigned to a specific issue.
    ///
    /// If the `assignee` can be assigned to this issue, a `204` status code with no content is returned.
    ///
    /// Otherwise a `404` status code is returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/get(issues/check-user-can-be-assigned-to-issue)`.
    func issuesCheckUserCanBeAssignedToIssue(_ input: Operations.IssuesCheckUserCanBeAssignedToIssue.Input) async throws -> Operations.IssuesCheckUserCanBeAssignedToIssue.Output
    /// List issue comments
    ///
    /// You can use the REST API to list comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// Issue comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/get(issues/list-comments)`.
    func issuesListComments(_ input: Operations.IssuesListComments.Input) async throws -> Operations.IssuesListComments.Output
    /// Create an issue comment
    ///
    /// You can use the REST API to create comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    /// Creating content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)`.
    func issuesCreateComment(_ input: Operations.IssuesCreateComment.Input) async throws -> Operations.IssuesCreateComment.Output
    /// List issue events
    ///
    /// Lists all events for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/events/get(issues/list-events)`.
    func issuesListEvents(_ input: Operations.IssuesListEvents.Input) async throws -> Operations.IssuesListEvents.Output
    /// List labels for an issue
    ///
    /// Lists all labels for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)`.
    func issuesListLabelsOnIssue(_ input: Operations.IssuesListLabelsOnIssue.Input) async throws -> Operations.IssuesListLabelsOnIssue.Output
    /// Add labels to an issue
    ///
    /// Adds labels to an issue. If you provide an empty array of labels, all labels are removed from the issue. 
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)`.
    func issuesAddLabels(_ input: Operations.IssuesAddLabels.Input) async throws -> Operations.IssuesAddLabels.Output
    /// Set labels for an issue
    ///
    /// Removes any previous labels and sets the new labels for an issue.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)`.
    func issuesSetLabels(_ input: Operations.IssuesSetLabels.Input) async throws -> Operations.IssuesSetLabels.Output
    /// Remove all labels from an issue
    ///
    /// Removes all labels from an issue.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)`.
    func issuesRemoveAllLabels(_ input: Operations.IssuesRemoveAllLabels.Input) async throws -> Operations.IssuesRemoveAllLabels.Output
    /// Remove a label from an issue
    ///
    /// Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)`.
    func issuesRemoveLabel(_ input: Operations.IssuesRemoveLabel.Input) async throws -> Operations.IssuesRemoveLabel.Output
    /// Lock an issue
    ///
    /// Users with push access can lock an issue or pull request's conversation.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/issues/{issue_number}/lock`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)`.
    func issuesLock(_ input: Operations.IssuesLock.Input) async throws -> Operations.IssuesLock.Output
    /// Unlock an issue
    ///
    /// Users with push access can unlock an issue's conversation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/lock`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)`.
    func issuesUnlock(_ input: Operations.IssuesUnlock.Input) async throws -> Operations.IssuesUnlock.Output
    /// Remove sub-issue
    ///
    /// You can use the REST API to remove a sub-issue from an issue.
    /// Removing content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass a specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/sub_issue`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issue/delete(issues/remove-sub-issue)`.
    func issuesRemoveSubIssue(_ input: Operations.IssuesRemoveSubIssue.Input) async throws -> Operations.IssuesRemoveSubIssue.Output
    /// List sub-issues
    ///
    /// You can use the REST API to list the sub-issues on an issue.
    ///
    /// This endpoint supports the following custom media types. For more information, see [Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types).
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw Markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the Markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's Markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/sub_issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/get(issues/list-sub-issues)`.
    func issuesListSubIssues(_ input: Operations.IssuesListSubIssues.Input) async throws -> Operations.IssuesListSubIssues.Output
    /// Add sub-issue
    ///
    /// You can use the REST API to add sub-issues to issues.
    ///
    /// Creating content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/sub_issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)`.
    func issuesAddSubIssue(_ input: Operations.IssuesAddSubIssue.Input) async throws -> Operations.IssuesAddSubIssue.Output
    /// Reprioritize sub-issue
    ///
    /// You can use the REST API to reprioritize a sub-issue to a different position in the parent list.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)`.
    func issuesReprioritizeSubIssue(_ input: Operations.IssuesReprioritizeSubIssue.Input) async throws -> Operations.IssuesReprioritizeSubIssue.Output
    /// List timeline events for an issue
    ///
    /// List all timeline events for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/timeline`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/timeline/get(issues/list-events-for-timeline)`.
    func issuesListEventsForTimeline(_ input: Operations.IssuesListEventsForTimeline.Input) async throws -> Operations.IssuesListEventsForTimeline.Output
    /// List labels for a repository
    ///
    /// Lists all labels for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/get(issues/list-labels-for-repo)`.
    func issuesListLabelsForRepo(_ input: Operations.IssuesListLabelsForRepo.Input) async throws -> Operations.IssuesListLabelsForRepo.Output
    /// Create a label
    ///
    /// Creates a label for the specified repository with the given name and color. The name and color parameters are required. The color must be a valid [hexadecimal color code](http://www.color-hex.com/).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/post(issues/create-label)`.
    func issuesCreateLabel(_ input: Operations.IssuesCreateLabel.Input) async throws -> Operations.IssuesCreateLabel.Output
    /// Get a label
    ///
    /// Gets a label using the given name.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/get(issues/get-label)`.
    func issuesGetLabel(_ input: Operations.IssuesGetLabel.Input) async throws -> Operations.IssuesGetLabel.Output
    /// Update a label
    ///
    /// Updates a label using the given label name.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/patch(issues/update-label)`.
    func issuesUpdateLabel(_ input: Operations.IssuesUpdateLabel.Input) async throws -> Operations.IssuesUpdateLabel.Output
    /// Delete a label
    ///
    /// Deletes a label using the given label name.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/delete(issues/delete-label)`.
    func issuesDeleteLabel(_ input: Operations.IssuesDeleteLabel.Input) async throws -> Operations.IssuesDeleteLabel.Output
    /// List milestones
    ///
    /// Lists milestones for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/get(issues/list-milestones)`.
    func issuesListMilestones(_ input: Operations.IssuesListMilestones.Input) async throws -> Operations.IssuesListMilestones.Output
    /// Create a milestone
    ///
    /// Creates a milestone.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/milestones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/post(issues/create-milestone)`.
    func issuesCreateMilestone(_ input: Operations.IssuesCreateMilestone.Input) async throws -> Operations.IssuesCreateMilestone.Output
    /// Get a milestone
    ///
    /// Gets a milestone using the given milestone number.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/get(issues/get-milestone)`.
    func issuesGetMilestone(_ input: Operations.IssuesGetMilestone.Input) async throws -> Operations.IssuesGetMilestone.Output
    /// Update a milestone
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/patch(issues/update-milestone)`.
    func issuesUpdateMilestone(_ input: Operations.IssuesUpdateMilestone.Input) async throws -> Operations.IssuesUpdateMilestone.Output
    /// Delete a milestone
    ///
    /// Deletes a milestone using the given milestone number.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/delete(issues/delete-milestone)`.
    func issuesDeleteMilestone(_ input: Operations.IssuesDeleteMilestone.Input) async throws -> Operations.IssuesDeleteMilestone.Output
    /// List labels for issues in a milestone
    ///
    /// Lists labels for issues in a milestone.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones/{milestone_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/labels/get(issues/list-labels-for-milestone)`.
    func issuesListLabelsForMilestone(_ input: Operations.IssuesListLabelsForMilestone.Input) async throws -> Operations.IssuesListLabelsForMilestone.Output
    /// List user account issues assigned to the authenticated user
    ///
    /// List issues across owned and member repositories assigned to the authenticated user.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /user/issues`.
    /// - Remark: Generated from `#/paths//user/issues/get(issues/list-for-authenticated-user)`.
    func issuesListForAuthenticatedUser(_ input: Operations.IssuesListForAuthenticatedUser.Input) async throws -> Operations.IssuesListForAuthenticatedUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List issues assigned to the authenticated user
    ///
    /// List issues assigned to the authenticated user across all visible repositories including owned repositories, member
    /// repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
    /// necessarily assigned to you.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /issues`.
    /// - Remark: Generated from `#/paths//issues/get(issues/list)`.
    public func issuesList(
        query: Operations.IssuesList.Input.Query = .init(),
        headers: Operations.IssuesList.Input.Headers = .init()
    ) async throws -> Operations.IssuesList.Output {
        try await issuesList(Operations.IssuesList.Input(
            query: query,
            headers: headers
        ))
    }
    /// List organization issues assigned to the authenticated user
    ///
    /// List issues in an organization assigned to the authenticated user.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issues`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issues/get(issues/list-for-org)`.
    public func issuesListForOrg(
        path: Operations.IssuesListForOrg.Input.Path,
        query: Operations.IssuesListForOrg.Input.Query = .init(),
        headers: Operations.IssuesListForOrg.Input.Headers = .init()
    ) async throws -> Operations.IssuesListForOrg.Output {
        try await issuesListForOrg(Operations.IssuesListForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List assignees
    ///
    /// Lists the [available assignees](https://docs.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/get(issues/list-assignees)`.
    public func issuesListAssignees(
        path: Operations.IssuesListAssignees.Input.Path,
        query: Operations.IssuesListAssignees.Input.Query = .init(),
        headers: Operations.IssuesListAssignees.Input.Headers = .init()
    ) async throws -> Operations.IssuesListAssignees.Output {
        try await issuesListAssignees(Operations.IssuesListAssignees.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check if a user can be assigned
    ///
    /// Checks if a user has permission to be assigned to an issue in this repository.
    ///
    /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
    ///
    /// Otherwise a `404` status code is returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/assignees/{assignee}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/{assignee}/get(issues/check-user-can-be-assigned)`.
    public func issuesCheckUserCanBeAssigned(
        path: Operations.IssuesCheckUserCanBeAssigned.Input.Path,
        headers: Operations.IssuesCheckUserCanBeAssigned.Input.Headers = .init()
    ) async throws -> Operations.IssuesCheckUserCanBeAssigned.Output {
        try await issuesCheckUserCanBeAssigned(Operations.IssuesCheckUserCanBeAssigned.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repository issues
    ///
    /// List issues in a repository. Only open issues will be listed.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)`.
    public func issuesListForRepo(
        path: Operations.IssuesListForRepo.Input.Path,
        query: Operations.IssuesListForRepo.Input.Query = .init(),
        headers: Operations.IssuesListForRepo.Input.Headers = .init()
    ) async throws -> Operations.IssuesListForRepo.Output {
        try await issuesListForRepo(Operations.IssuesListForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an issue
    ///
    /// Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://docs.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)`.
    public func issuesCreate(
        path: Operations.IssuesCreate.Input.Path,
        headers: Operations.IssuesCreate.Input.Headers = .init(),
        body: Operations.IssuesCreate.Input.Body
    ) async throws -> Operations.IssuesCreate.Output {
        try await issuesCreate(Operations.IssuesCreate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List issue comments for a repository
    ///
    /// You can use the REST API to list comments on issues and pull requests for a repository. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// By default, issue comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/get(issues/list-comments-for-repo)`.
    public func issuesListCommentsForRepo(
        path: Operations.IssuesListCommentsForRepo.Input.Path,
        query: Operations.IssuesListCommentsForRepo.Input.Query = .init(),
        headers: Operations.IssuesListCommentsForRepo.Input.Headers = .init()
    ) async throws -> Operations.IssuesListCommentsForRepo.Output {
        try await issuesListCommentsForRepo(Operations.IssuesListCommentsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an issue comment
    ///
    /// You can use the REST API to get comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/get(issues/get-comment)`.
    public func issuesGetComment(
        path: Operations.IssuesGetComment.Input.Path,
        headers: Operations.IssuesGetComment.Input.Headers = .init()
    ) async throws -> Operations.IssuesGetComment.Output {
        try await issuesGetComment(Operations.IssuesGetComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an issue comment
    ///
    /// You can use the REST API to update comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/patch(issues/update-comment)`.
    public func issuesUpdateComment(
        path: Operations.IssuesUpdateComment.Input.Path,
        headers: Operations.IssuesUpdateComment.Input.Headers = .init(),
        body: Operations.IssuesUpdateComment.Input.Body
    ) async throws -> Operations.IssuesUpdateComment.Output {
        try await issuesUpdateComment(Operations.IssuesUpdateComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an issue comment
    ///
    /// You can use the REST API to delete comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/delete(issues/delete-comment)`.
    public func issuesDeleteComment(path: Operations.IssuesDeleteComment.Input.Path) async throws -> Operations.IssuesDeleteComment.Output {
        try await issuesDeleteComment(Operations.IssuesDeleteComment.Input(path: path))
    }
    /// List issue events for a repository
    ///
    /// Lists events for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/get(issues/list-events-for-repo)`.
    public func issuesListEventsForRepo(
        path: Operations.IssuesListEventsForRepo.Input.Path,
        query: Operations.IssuesListEventsForRepo.Input.Query = .init(),
        headers: Operations.IssuesListEventsForRepo.Input.Headers = .init()
    ) async throws -> Operations.IssuesListEventsForRepo.Output {
        try await issuesListEventsForRepo(Operations.IssuesListEventsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an issue event
    ///
    /// Gets a single event by the event id.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/events/{event_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)`.
    public func issuesGetEvent(
        path: Operations.IssuesGetEvent.Input.Path,
        headers: Operations.IssuesGetEvent.Input.Headers = .init()
    ) async throws -> Operations.IssuesGetEvent.Output {
        try await issuesGetEvent(Operations.IssuesGetEvent.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get an issue
    ///
    /// The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api#follow-redirects) if the issue was
    /// [transferred](https://docs.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
    /// the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
    /// returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
    /// access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
    /// to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)`.
    public func issuesGet(
        path: Operations.IssuesGet.Input.Path,
        headers: Operations.IssuesGet.Input.Headers = .init()
    ) async throws -> Operations.IssuesGet.Output {
        try await issuesGet(Operations.IssuesGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an issue
    ///
    /// Issue owners and users with push access or Triage role can edit an issue.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/{issue_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)`.
    public func issuesUpdate(
        path: Operations.IssuesUpdate.Input.Path,
        headers: Operations.IssuesUpdate.Input.Headers = .init(),
        body: Operations.IssuesUpdate.Input.Body? = nil
    ) async throws -> Operations.IssuesUpdate.Output {
        try await issuesUpdate(Operations.IssuesUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Add assignees to an issue
    ///
    /// Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/post(issues/add-assignees)`.
    public func issuesAddAssignees(
        path: Operations.IssuesAddAssignees.Input.Path,
        headers: Operations.IssuesAddAssignees.Input.Headers = .init(),
        body: Operations.IssuesAddAssignees.Input.Body? = nil
    ) async throws -> Operations.IssuesAddAssignees.Output {
        try await issuesAddAssignees(Operations.IssuesAddAssignees.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove assignees from an issue
    ///
    /// Removes one or more assignees from an issue.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/delete(issues/remove-assignees)`.
    public func issuesRemoveAssignees(
        path: Operations.IssuesRemoveAssignees.Input.Path,
        headers: Operations.IssuesRemoveAssignees.Input.Headers = .init(),
        body: Operations.IssuesRemoveAssignees.Input.Body? = nil
    ) async throws -> Operations.IssuesRemoveAssignees.Output {
        try await issuesRemoveAssignees(Operations.IssuesRemoveAssignees.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Check if a user can be assigned to a issue
    ///
    /// Checks if a user has permission to be assigned to a specific issue.
    ///
    /// If the `assignee` can be assigned to this issue, a `204` status code with no content is returned.
    ///
    /// Otherwise a `404` status code is returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/get(issues/check-user-can-be-assigned-to-issue)`.
    public func issuesCheckUserCanBeAssignedToIssue(
        path: Operations.IssuesCheckUserCanBeAssignedToIssue.Input.Path,
        headers: Operations.IssuesCheckUserCanBeAssignedToIssue.Input.Headers = .init()
    ) async throws -> Operations.IssuesCheckUserCanBeAssignedToIssue.Output {
        try await issuesCheckUserCanBeAssignedToIssue(Operations.IssuesCheckUserCanBeAssignedToIssue.Input(
            path: path,
            headers: headers
        ))
    }
    /// List issue comments
    ///
    /// You can use the REST API to list comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// Issue comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/get(issues/list-comments)`.
    public func issuesListComments(
        path: Operations.IssuesListComments.Input.Path,
        query: Operations.IssuesListComments.Input.Query = .init(),
        headers: Operations.IssuesListComments.Input.Headers = .init()
    ) async throws -> Operations.IssuesListComments.Output {
        try await issuesListComments(Operations.IssuesListComments.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an issue comment
    ///
    /// You can use the REST API to create comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    /// Creating content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)`.
    public func issuesCreateComment(
        path: Operations.IssuesCreateComment.Input.Path,
        headers: Operations.IssuesCreateComment.Input.Headers = .init(),
        body: Operations.IssuesCreateComment.Input.Body
    ) async throws -> Operations.IssuesCreateComment.Output {
        try await issuesCreateComment(Operations.IssuesCreateComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List issue events
    ///
    /// Lists all events for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/events/get(issues/list-events)`.
    public func issuesListEvents(
        path: Operations.IssuesListEvents.Input.Path,
        query: Operations.IssuesListEvents.Input.Query = .init(),
        headers: Operations.IssuesListEvents.Input.Headers = .init()
    ) async throws -> Operations.IssuesListEvents.Output {
        try await issuesListEvents(Operations.IssuesListEvents.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List labels for an issue
    ///
    /// Lists all labels for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)`.
    public func issuesListLabelsOnIssue(
        path: Operations.IssuesListLabelsOnIssue.Input.Path,
        query: Operations.IssuesListLabelsOnIssue.Input.Query = .init(),
        headers: Operations.IssuesListLabelsOnIssue.Input.Headers = .init()
    ) async throws -> Operations.IssuesListLabelsOnIssue.Output {
        try await issuesListLabelsOnIssue(Operations.IssuesListLabelsOnIssue.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Add labels to an issue
    ///
    /// Adds labels to an issue. If you provide an empty array of labels, all labels are removed from the issue. 
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)`.
    public func issuesAddLabels(
        path: Operations.IssuesAddLabels.Input.Path,
        headers: Operations.IssuesAddLabels.Input.Headers = .init(),
        body: Operations.IssuesAddLabels.Input.Body? = nil
    ) async throws -> Operations.IssuesAddLabels.Output {
        try await issuesAddLabels(Operations.IssuesAddLabels.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set labels for an issue
    ///
    /// Removes any previous labels and sets the new labels for an issue.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)`.
    public func issuesSetLabels(
        path: Operations.IssuesSetLabels.Input.Path,
        headers: Operations.IssuesSetLabels.Input.Headers = .init(),
        body: Operations.IssuesSetLabels.Input.Body? = nil
    ) async throws -> Operations.IssuesSetLabels.Output {
        try await issuesSetLabels(Operations.IssuesSetLabels.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove all labels from an issue
    ///
    /// Removes all labels from an issue.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)`.
    public func issuesRemoveAllLabels(
        path: Operations.IssuesRemoveAllLabels.Input.Path,
        headers: Operations.IssuesRemoveAllLabels.Input.Headers = .init()
    ) async throws -> Operations.IssuesRemoveAllLabels.Output {
        try await issuesRemoveAllLabels(Operations.IssuesRemoveAllLabels.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove a label from an issue
    ///
    /// Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)`.
    public func issuesRemoveLabel(
        path: Operations.IssuesRemoveLabel.Input.Path,
        headers: Operations.IssuesRemoveLabel.Input.Headers = .init()
    ) async throws -> Operations.IssuesRemoveLabel.Output {
        try await issuesRemoveLabel(Operations.IssuesRemoveLabel.Input(
            path: path,
            headers: headers
        ))
    }
    /// Lock an issue
    ///
    /// Users with push access can lock an issue or pull request's conversation.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/issues/{issue_number}/lock`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)`.
    public func issuesLock(
        path: Operations.IssuesLock.Input.Path,
        headers: Operations.IssuesLock.Input.Headers = .init(),
        body: Operations.IssuesLock.Input.Body? = nil
    ) async throws -> Operations.IssuesLock.Output {
        try await issuesLock(Operations.IssuesLock.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Unlock an issue
    ///
    /// Users with push access can unlock an issue's conversation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/lock`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)`.
    public func issuesUnlock(
        path: Operations.IssuesUnlock.Input.Path,
        headers: Operations.IssuesUnlock.Input.Headers = .init()
    ) async throws -> Operations.IssuesUnlock.Output {
        try await issuesUnlock(Operations.IssuesUnlock.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove sub-issue
    ///
    /// You can use the REST API to remove a sub-issue from an issue.
    /// Removing content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass a specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/sub_issue`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issue/delete(issues/remove-sub-issue)`.
    public func issuesRemoveSubIssue(
        path: Operations.IssuesRemoveSubIssue.Input.Path,
        headers: Operations.IssuesRemoveSubIssue.Input.Headers = .init(),
        body: Operations.IssuesRemoveSubIssue.Input.Body
    ) async throws -> Operations.IssuesRemoveSubIssue.Output {
        try await issuesRemoveSubIssue(Operations.IssuesRemoveSubIssue.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List sub-issues
    ///
    /// You can use the REST API to list the sub-issues on an issue.
    ///
    /// This endpoint supports the following custom media types. For more information, see [Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types).
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw Markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the Markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's Markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/sub_issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/get(issues/list-sub-issues)`.
    public func issuesListSubIssues(
        path: Operations.IssuesListSubIssues.Input.Path,
        query: Operations.IssuesListSubIssues.Input.Query = .init(),
        headers: Operations.IssuesListSubIssues.Input.Headers = .init()
    ) async throws -> Operations.IssuesListSubIssues.Output {
        try await issuesListSubIssues(Operations.IssuesListSubIssues.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Add sub-issue
    ///
    /// You can use the REST API to add sub-issues to issues.
    ///
    /// Creating content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/sub_issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)`.
    public func issuesAddSubIssue(
        path: Operations.IssuesAddSubIssue.Input.Path,
        headers: Operations.IssuesAddSubIssue.Input.Headers = .init(),
        body: Operations.IssuesAddSubIssue.Input.Body
    ) async throws -> Operations.IssuesAddSubIssue.Output {
        try await issuesAddSubIssue(Operations.IssuesAddSubIssue.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Reprioritize sub-issue
    ///
    /// You can use the REST API to reprioritize a sub-issue to a different position in the parent list.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)`.
    public func issuesReprioritizeSubIssue(
        path: Operations.IssuesReprioritizeSubIssue.Input.Path,
        headers: Operations.IssuesReprioritizeSubIssue.Input.Headers = .init(),
        body: Operations.IssuesReprioritizeSubIssue.Input.Body
    ) async throws -> Operations.IssuesReprioritizeSubIssue.Output {
        try await issuesReprioritizeSubIssue(Operations.IssuesReprioritizeSubIssue.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List timeline events for an issue
    ///
    /// List all timeline events for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/timeline`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/timeline/get(issues/list-events-for-timeline)`.
    public func issuesListEventsForTimeline(
        path: Operations.IssuesListEventsForTimeline.Input.Path,
        query: Operations.IssuesListEventsForTimeline.Input.Query = .init(),
        headers: Operations.IssuesListEventsForTimeline.Input.Headers = .init()
    ) async throws -> Operations.IssuesListEventsForTimeline.Output {
        try await issuesListEventsForTimeline(Operations.IssuesListEventsForTimeline.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List labels for a repository
    ///
    /// Lists all labels for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/get(issues/list-labels-for-repo)`.
    public func issuesListLabelsForRepo(
        path: Operations.IssuesListLabelsForRepo.Input.Path,
        query: Operations.IssuesListLabelsForRepo.Input.Query = .init(),
        headers: Operations.IssuesListLabelsForRepo.Input.Headers = .init()
    ) async throws -> Operations.IssuesListLabelsForRepo.Output {
        try await issuesListLabelsForRepo(Operations.IssuesListLabelsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a label
    ///
    /// Creates a label for the specified repository with the given name and color. The name and color parameters are required. The color must be a valid [hexadecimal color code](http://www.color-hex.com/).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/post(issues/create-label)`.
    public func issuesCreateLabel(
        path: Operations.IssuesCreateLabel.Input.Path,
        headers: Operations.IssuesCreateLabel.Input.Headers = .init(),
        body: Operations.IssuesCreateLabel.Input.Body
    ) async throws -> Operations.IssuesCreateLabel.Output {
        try await issuesCreateLabel(Operations.IssuesCreateLabel.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a label
    ///
    /// Gets a label using the given name.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/get(issues/get-label)`.
    public func issuesGetLabel(
        path: Operations.IssuesGetLabel.Input.Path,
        headers: Operations.IssuesGetLabel.Input.Headers = .init()
    ) async throws -> Operations.IssuesGetLabel.Output {
        try await issuesGetLabel(Operations.IssuesGetLabel.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a label
    ///
    /// Updates a label using the given label name.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/patch(issues/update-label)`.
    public func issuesUpdateLabel(
        path: Operations.IssuesUpdateLabel.Input.Path,
        headers: Operations.IssuesUpdateLabel.Input.Headers = .init(),
        body: Operations.IssuesUpdateLabel.Input.Body? = nil
    ) async throws -> Operations.IssuesUpdateLabel.Output {
        try await issuesUpdateLabel(Operations.IssuesUpdateLabel.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a label
    ///
    /// Deletes a label using the given label name.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/delete(issues/delete-label)`.
    public func issuesDeleteLabel(path: Operations.IssuesDeleteLabel.Input.Path) async throws -> Operations.IssuesDeleteLabel.Output {
        try await issuesDeleteLabel(Operations.IssuesDeleteLabel.Input(path: path))
    }
    /// List milestones
    ///
    /// Lists milestones for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/get(issues/list-milestones)`.
    public func issuesListMilestones(
        path: Operations.IssuesListMilestones.Input.Path,
        query: Operations.IssuesListMilestones.Input.Query = .init(),
        headers: Operations.IssuesListMilestones.Input.Headers = .init()
    ) async throws -> Operations.IssuesListMilestones.Output {
        try await issuesListMilestones(Operations.IssuesListMilestones.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a milestone
    ///
    /// Creates a milestone.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/milestones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/post(issues/create-milestone)`.
    public func issuesCreateMilestone(
        path: Operations.IssuesCreateMilestone.Input.Path,
        headers: Operations.IssuesCreateMilestone.Input.Headers = .init(),
        body: Operations.IssuesCreateMilestone.Input.Body
    ) async throws -> Operations.IssuesCreateMilestone.Output {
        try await issuesCreateMilestone(Operations.IssuesCreateMilestone.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a milestone
    ///
    /// Gets a milestone using the given milestone number.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/get(issues/get-milestone)`.
    public func issuesGetMilestone(
        path: Operations.IssuesGetMilestone.Input.Path,
        headers: Operations.IssuesGetMilestone.Input.Headers = .init()
    ) async throws -> Operations.IssuesGetMilestone.Output {
        try await issuesGetMilestone(Operations.IssuesGetMilestone.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a milestone
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/patch(issues/update-milestone)`.
    public func issuesUpdateMilestone(
        path: Operations.IssuesUpdateMilestone.Input.Path,
        headers: Operations.IssuesUpdateMilestone.Input.Headers = .init(),
        body: Operations.IssuesUpdateMilestone.Input.Body? = nil
    ) async throws -> Operations.IssuesUpdateMilestone.Output {
        try await issuesUpdateMilestone(Operations.IssuesUpdateMilestone.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a milestone
    ///
    /// Deletes a milestone using the given milestone number.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/delete(issues/delete-milestone)`.
    public func issuesDeleteMilestone(
        path: Operations.IssuesDeleteMilestone.Input.Path,
        headers: Operations.IssuesDeleteMilestone.Input.Headers = .init()
    ) async throws -> Operations.IssuesDeleteMilestone.Output {
        try await issuesDeleteMilestone(Operations.IssuesDeleteMilestone.Input(
            path: path,
            headers: headers
        ))
    }
    /// List labels for issues in a milestone
    ///
    /// Lists labels for issues in a milestone.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones/{milestone_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/labels/get(issues/list-labels-for-milestone)`.
    public func issuesListLabelsForMilestone(
        path: Operations.IssuesListLabelsForMilestone.Input.Path,
        query: Operations.IssuesListLabelsForMilestone.Input.Query = .init(),
        headers: Operations.IssuesListLabelsForMilestone.Input.Headers = .init()
    ) async throws -> Operations.IssuesListLabelsForMilestone.Output {
        try await issuesListLabelsForMilestone(Operations.IssuesListLabelsForMilestone.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List user account issues assigned to the authenticated user
    ///
    /// List issues across owned and member repositories assigned to the authenticated user.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /user/issues`.
    /// - Remark: Generated from `#/paths//user/issues/get(issues/list-for-authenticated-user)`.
    public func issuesListForAuthenticatedUser(
        query: Operations.IssuesListForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.IssuesListForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.IssuesListForAuthenticatedUser.Output {
        try await issuesListForAuthenticatedUser(Operations.IssuesListForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/integration`.
        public struct Integration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/integration/owner`.
            public var owner: Components.Schemas.Integration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/permissions`.
            public var permissions: Components.Schemas.Integration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `Integration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.Integration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.Integration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// A collection of related issues and pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-milestone`.
        public struct NullableMilestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/node_id`.
            public var nodeId: Swift.String
            /// The number of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/number`.
            public var number: Swift.Int
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            public var state: Components.Schemas.NullableMilestone.StatePayload
            /// The title of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_issues`.
            public var closedIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/due_on`.
            public var dueOn: Foundation.Date?
            /// Creates a new `NullableMilestone`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - htmlUrl:
            ///   - labelsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number: The number of the milestone.
            ///   - state: The state of the milestone.
            ///   - title: The title of the milestone.
            ///   - description:
            ///   - creator:
            ///   - openIssues:
            ///   - closedIssues:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - dueOn:
            public init(
                url: Swift.String,
                htmlUrl: Swift.String,
                labelsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.NullableMilestone.StatePayload,
                title: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                openIssues: Swift.Int,
                closedIssues: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                dueOn: Foundation.Date? = nil
            ) {
                self.url = url
                self.htmlUrl = htmlUrl
                self.labelsUrl = labelsUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.state = state
                self.title = title
                self.description = description
                self.creator = creator
                self.openIssues = openIssues
                self.closedIssues = closedIssues
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.dueOn = dueOn
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case htmlUrl = "html_url"
                case labelsUrl = "labels_url"
                case id
                case nodeId = "node_id"
                case number
                case state
                case title
                case description
                case creator
                case openIssues = "open_issues"
                case closedIssues = "closed_issues"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case dueOn = "due_on"
            }
        }
        /// The type of issue.
        ///
        /// - Remark: Generated from `#/components/schemas/issue-type`.
        public struct IssueType: Codable, Hashable, Sendable {
            /// The unique identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/id`.
            public var id: Swift.Int
            /// The node identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/node_id`.
            public var nodeId: Swift.String
            /// The name of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/name`.
            public var name: Swift.String
            /// The description of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/description`.
            public var description: Swift.String?
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            @frozen public enum ColorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case gray = "gray"
                case blue = "blue"
                case green = "green"
                case yellow = "yellow"
                case orange = "orange"
                case red = "red"
                case pink = "pink"
                case purple = "purple"
            }
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            public var color: Components.Schemas.IssueType.ColorPayload?
            /// The time the issue type created.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/created_at`.
            public var createdAt: Foundation.Date?
            /// The time the issue type last updated.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The enabled state of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/is_enabled`.
            public var isEnabled: Swift.Bool?
            /// Creates a new `IssueType`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the issue type.
            ///   - nodeId: The node identifier of the issue type.
            ///   - name: The name of the issue type.
            ///   - description: The description of the issue type.
            ///   - color: The color of the issue type.
            ///   - createdAt: The time the issue type created.
            ///   - updatedAt: The time the issue type last updated.
            ///   - isEnabled: The enabled state of the issue type.
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                color: Components.Schemas.IssueType.ColorPayload? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                isEnabled: Swift.Bool? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.description = description
                self.color = color
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.isEnabled = isEnabled
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case description
                case color
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case isEnabled = "is_enabled"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-integration`.
        public struct NullableIntegration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            public var owner: Components.Schemas.NullableIntegration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public var permissions: Components.Schemas.NullableIntegration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `NullableIntegration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.NullableIntegration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.NullableIntegration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// How the author is associated with the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/author-association`.
        @frozen public enum AuthorAssociation: String, Codable, Hashable, Sendable, CaseIterable {
            case collaborator = "COLLABORATOR"
            case contributor = "CONTRIBUTOR"
            case firstTimer = "FIRST_TIMER"
            case firstTimeContributor = "FIRST_TIME_CONTRIBUTOR"
            case mannequin = "MANNEQUIN"
            case member = "MEMBER"
            case none = "NONE"
            case owner = "OWNER"
        }
        /// - Remark: Generated from `#/components/schemas/reaction-rollup`.
        public struct ReactionRollup: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/+1`.
            public var _plus_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/-1`.
            public var _hyphen_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/laugh`.
            public var laugh: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/confused`.
            public var confused: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/heart`.
            public var heart: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/hooray`.
            public var hooray: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/eyes`.
            public var eyes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/rocket`.
            public var rocket: Swift.Int
            /// Creates a new `ReactionRollup`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - totalCount:
            ///   - _plus_1:
            ///   - _hyphen_1:
            ///   - laugh:
            ///   - confused:
            ///   - heart:
            ///   - hooray:
            ///   - eyes:
            ///   - rocket:
            public init(
                url: Swift.String,
                totalCount: Swift.Int,
                _plus_1: Swift.Int,
                _hyphen_1: Swift.Int,
                laugh: Swift.Int,
                confused: Swift.Int,
                heart: Swift.Int,
                hooray: Swift.Int,
                eyes: Swift.Int,
                rocket: Swift.Int
            ) {
                self.url = url
                self.totalCount = totalCount
                self._plus_1 = _plus_1
                self._hyphen_1 = _hyphen_1
                self.laugh = laugh
                self.confused = confused
                self.heart = heart
                self.hooray = hooray
                self.eyes = eyes
                self.rocket = rocket
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case totalCount = "total_count"
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh
                case confused
                case heart
                case hooray
                case eyes
                case rocket
            }
        }
        /// - Remark: Generated from `#/components/schemas/sub-issues-summary`.
        public struct SubIssuesSummary: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/total`.
            public var total: Swift.Int
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/completed`.
            public var completed: Swift.Int
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/percent_completed`.
            public var percentCompleted: Swift.Int
            /// Creates a new `SubIssuesSummary`.
            ///
            /// - Parameters:
            ///   - total:
            ///   - completed:
            ///   - percentCompleted:
            public init(
                total: Swift.Int,
                completed: Swift.Int,
                percentCompleted: Swift.Int
            ) {
                self.total = total
                self.completed = completed
                self.percentCompleted = percentCompleted
            }
            public enum CodingKeys: String, CodingKey {
                case total
                case completed
                case percentCompleted = "percent_completed"
            }
        }
        /// Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
        ///
        /// - Remark: Generated from `#/components/schemas/issue`.
        public struct Issue: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue/node_id`.
            public var nodeId: Swift.String
            /// URL for the issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/repository_url`.
            public var repositoryUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/html_url`.
            public var htmlUrl: Swift.String
            /// Number uniquely identifying the issue within its repository
            ///
            /// - Remark: Generated from `#/components/schemas/issue/number`.
            public var number: Swift.Int
            /// State of the issue; either 'open' or 'closed'
            ///
            /// - Remark: Generated from `#/components/schemas/issue/state`.
            public var state: Swift.String
            /// The reason for the current state
            ///
            /// - Remark: Generated from `#/components/schemas/issue/state_reason`.
            @frozen public enum StateReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case completed = "completed"
                case reopened = "reopened"
                case notPlanned = "not_planned"
                case duplicate = "duplicate"
            }
            /// The reason for the current state
            ///
            /// - Remark: Generated from `#/components/schemas/issue/state_reason`.
            public var stateReason: Components.Schemas.Issue.StateReasonPayload?
            /// Title of the issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/title`.
            public var title: Swift.String
            /// Contents of the issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload`.
            @frozen public enum LabelsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2`.
                public struct Case2Payload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/id`.
                    public var id: Swift.Int64?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/node_id`.
                    public var nodeId: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/url`.
                    public var url: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/name`.
                    public var name: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/description`.
                    public var description: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/color`.
                    public var color: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/default`.
                    public var _default: Swift.Bool?
                    /// Creates a new `Case2Payload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - nodeId:
                    ///   - url:
                    ///   - name:
                    ///   - description:
                    ///   - color:
                    ///   - _default:
                    public init(
                        id: Swift.Int64? = nil,
                        nodeId: Swift.String? = nil,
                        url: Swift.String? = nil,
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        color: Swift.String? = nil,
                        _default: Swift.Bool? = nil
                    ) {
                        self.id = id
                        self.nodeId = nodeId
                        self.url = url
                        self.name = name
                        self.description = description
                        self.color = color
                        self._default = _default
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case nodeId = "node_id"
                        case url
                        case name
                        case description
                        case color
                        case _default = "default"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2`.
                case case2(Components.Schemas.Issue.LabelsPayloadPayload.Case2Payload)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///
            /// - Remark: Generated from `#/components/schemas/issue/labels`.
            public typealias LabelsPayload = [Components.Schemas.Issue.LabelsPayloadPayload]
            /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///
            /// - Remark: Generated from `#/components/schemas/issue/labels`.
            public var labels: Components.Schemas.Issue.LabelsPayload
            /// - Remark: Generated from `#/components/schemas/issue/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/issue/milestone`.
            public var milestone: Components.Schemas.NullableMilestone?
            /// - Remark: Generated from `#/components/schemas/issue/locked`.
            public var locked: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/issue/active_lock_reason`.
            public var activeLockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/comments`.
            public var comments: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue/pull_request`.
            public struct PullRequestPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/merged_at`.
                public var mergedAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/diff_url`.
                public var diffUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/patch_url`.
                public var patchUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/url`.
                public var url: Swift.String?
                /// Creates a new `PullRequestPayload`.
                ///
                /// - Parameters:
                ///   - mergedAt:
                ///   - diffUrl:
                ///   - htmlUrl:
                ///   - patchUrl:
                ///   - url:
                public init(
                    mergedAt: Foundation.Date? = nil,
                    diffUrl: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    patchUrl: Swift.String? = nil,
                    url: Swift.String? = nil
                ) {
                    self.mergedAt = mergedAt
                    self.diffUrl = diffUrl
                    self.htmlUrl = htmlUrl
                    self.patchUrl = patchUrl
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case mergedAt = "merged_at"
                    case diffUrl = "diff_url"
                    case htmlUrl = "html_url"
                    case patchUrl = "patch_url"
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/issue/pull_request`.
            public var pullRequest: Components.Schemas.Issue.PullRequestPayload?
            /// - Remark: Generated from `#/components/schemas/issue/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/issue/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue/draft`.
            public var draft: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/issue/closed_by`.
            public var closedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/timeline_url`.
            public var timelineUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/type`.
            public var _type: Components.Schemas.IssueType?
            /// - Remark: Generated from `#/components/schemas/issue/repository`.
            public var repository: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/issue/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/issue/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/issue/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// - Remark: Generated from `#/components/schemas/issue/sub_issues_summary`.
            public var subIssuesSummary: Components.Schemas.SubIssuesSummary?
            /// Creates a new `Issue`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url: URL for the issue
            ///   - repositoryUrl:
            ///   - labelsUrl:
            ///   - commentsUrl:
            ///   - eventsUrl:
            ///   - htmlUrl:
            ///   - number: Number uniquely identifying the issue within its repository
            ///   - state: State of the issue; either 'open' or 'closed'
            ///   - stateReason: The reason for the current state
            ///   - title: Title of the issue
            ///   - body: Contents of the issue
            ///   - user:
            ///   - labels: Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///   - assignee:
            ///   - assignees:
            ///   - milestone:
            ///   - locked:
            ///   - activeLockReason:
            ///   - comments:
            ///   - pullRequest:
            ///   - closedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - draft:
            ///   - closedBy:
            ///   - bodyHtml:
            ///   - bodyText:
            ///   - timelineUrl:
            ///   - _type:
            ///   - repository:
            ///   - performedViaGithubApp:
            ///   - authorAssociation:
            ///   - reactions:
            ///   - subIssuesSummary:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                repositoryUrl: Swift.String,
                labelsUrl: Swift.String,
                commentsUrl: Swift.String,
                eventsUrl: Swift.String,
                htmlUrl: Swift.String,
                number: Swift.Int,
                state: Swift.String,
                stateReason: Components.Schemas.Issue.StateReasonPayload? = nil,
                title: Swift.String,
                body: Swift.String? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                labels: Components.Schemas.Issue.LabelsPayload,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil,
                milestone: Components.Schemas.NullableMilestone? = nil,
                locked: Swift.Bool,
                activeLockReason: Swift.String? = nil,
                comments: Swift.Int,
                pullRequest: Components.Schemas.Issue.PullRequestPayload? = nil,
                closedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                draft: Swift.Bool? = nil,
                closedBy: Components.Schemas.NullableSimpleUser? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                timelineUrl: Swift.String? = nil,
                _type: Components.Schemas.IssueType? = nil,
                repository: Components.Schemas.Repository? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                authorAssociation: Components.Schemas.AuthorAssociation,
                reactions: Components.Schemas.ReactionRollup? = nil,
                subIssuesSummary: Components.Schemas.SubIssuesSummary? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.repositoryUrl = repositoryUrl
                self.labelsUrl = labelsUrl
                self.commentsUrl = commentsUrl
                self.eventsUrl = eventsUrl
                self.htmlUrl = htmlUrl
                self.number = number
                self.state = state
                self.stateReason = stateReason
                self.title = title
                self.body = body
                self.user = user
                self.labels = labels
                self.assignee = assignee
                self.assignees = assignees
                self.milestone = milestone
                self.locked = locked
                self.activeLockReason = activeLockReason
                self.comments = comments
                self.pullRequest = pullRequest
                self.closedAt = closedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.draft = draft
                self.closedBy = closedBy
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
                self.timelineUrl = timelineUrl
                self._type = _type
                self.repository = repository
                self.performedViaGithubApp = performedViaGithubApp
                self.authorAssociation = authorAssociation
                self.reactions = reactions
                self.subIssuesSummary = subIssuesSummary
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case repositoryUrl = "repository_url"
                case labelsUrl = "labels_url"
                case commentsUrl = "comments_url"
                case eventsUrl = "events_url"
                case htmlUrl = "html_url"
                case number
                case state
                case stateReason = "state_reason"
                case title
                case body
                case user
                case labels
                case assignee
                case assignees
                case milestone
                case locked
                case activeLockReason = "active_lock_reason"
                case comments
                case pullRequest = "pull_request"
                case closedAt = "closed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case draft
                case closedBy = "closed_by"
                case bodyHtml = "body_html"
                case bodyText = "body_text"
                case timelineUrl = "timeline_url"
                case _type = "type"
                case repository
                case performedViaGithubApp = "performed_via_github_app"
                case authorAssociation = "author_association"
                case reactions
                case subIssuesSummary = "sub_issues_summary"
            }
        }
        /// Comments provide a way for people to collaborate on an issue.
        ///
        /// - Remark: Generated from `#/components/schemas/issue-comment`.
        public struct IssueComment: Codable, Hashable, Sendable {
            /// Unique identifier of the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/issue-comment/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue-comment/node_id`.
            public var nodeId: Swift.String
            /// URL for the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/issue-comment/url`.
            public var url: Swift.String
            /// Contents of the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/issue-comment/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-comment/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-comment/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-comment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-comment/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-comment/issue_url`.
            public var issueUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/issue-comment/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/issue-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `IssueComment`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the issue comment
            ///   - nodeId:
            ///   - url: URL for the issue comment
            ///   - body: Contents of the issue comment
            ///   - bodyText:
            ///   - bodyHtml:
            ///   - htmlUrl:
            ///   - user:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - issueUrl:
            ///   - authorAssociation:
            ///   - performedViaGithubApp:
            ///   - reactions:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                bodyHtml: Swift.String? = nil,
                htmlUrl: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                issueUrl: Swift.String,
                authorAssociation: Components.Schemas.AuthorAssociation,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.body = body
                self.bodyText = bodyText
                self.bodyHtml = bodyHtml
                self.htmlUrl = htmlUrl
                self.user = user
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.issueUrl = issueUrl
                self.authorAssociation = authorAssociation
                self.performedViaGithubApp = performedViaGithubApp
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case body
                case bodyText = "body_text"
                case bodyHtml = "body_html"
                case htmlUrl = "html_url"
                case user
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case issueUrl = "issue_url"
                case authorAssociation = "author_association"
                case performedViaGithubApp = "performed_via_github_app"
                case reactions
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// Commit Comment
        ///
        /// - Remark: Generated from `#/components/schemas/commit-comment`.
        public struct CommitComment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/commit-comment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-comment/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-comment/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/commit-comment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-comment/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-comment/path`.
            public var path: Swift.String?
            /// - Remark: Generated from `#/components/schemas/commit-comment/position`.
            public var position: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/commit-comment/line`.
            public var line: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/commit-comment/commit_id`.
            public var commitId: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit-comment/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/commit-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/commit-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/commit-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/commit-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `CommitComment`.
            ///
            /// - Parameters:
            ///   - htmlUrl:
            ///   - url:
            ///   - id:
            ///   - nodeId:
            ///   - body:
            ///   - path:
            ///   - position:
            ///   - line:
            ///   - commitId:
            ///   - user:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - authorAssociation:
            ///   - reactions:
            public init(
                htmlUrl: Swift.String,
                url: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                body: Swift.String,
                path: Swift.String? = nil,
                position: Swift.Int? = nil,
                line: Swift.Int? = nil,
                commitId: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                authorAssociation: Components.Schemas.AuthorAssociation,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.htmlUrl = htmlUrl
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.body = body
                self.path = path
                self.position = position
                self.line = line
                self.commitId = commitId
                self.user = user
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.authorAssociation = authorAssociation
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case htmlUrl = "html_url"
                case url
                case id
                case nodeId = "node_id"
                case body
                case path
                case position
                case line
                case commitId = "commit_id"
                case user
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case authorAssociation = "author_association"
                case reactions
            }
        }
        /// Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-issue`.
        public struct NullableIssue: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-issue/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-issue/node_id`.
            public var nodeId: Swift.String
            /// URL for the issue
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-issue/repository_url`.
            public var repositoryUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-issue/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-issue/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-issue/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-issue/html_url`.
            public var htmlUrl: Swift.String
            /// Number uniquely identifying the issue within its repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/number`.
            public var number: Swift.Int
            /// State of the issue; either 'open' or 'closed'
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/state`.
            public var state: Swift.String
            /// The reason for the current state
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/state_reason`.
            @frozen public enum StateReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case completed = "completed"
                case reopened = "reopened"
                case notPlanned = "not_planned"
                case duplicate = "duplicate"
            }
            /// The reason for the current state
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/state_reason`.
            public var stateReason: Components.Schemas.NullableIssue.StateReasonPayload?
            /// Title of the issue
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/title`.
            public var title: Swift.String
            /// Contents of the issue
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload`.
            @frozen public enum LabelsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2`.
                public struct Case2Payload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/id`.
                    public var id: Swift.Int64?
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/node_id`.
                    public var nodeId: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/url`.
                    public var url: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/name`.
                    public var name: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/description`.
                    public var description: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/color`.
                    public var color: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2/default`.
                    public var _default: Swift.Bool?
                    /// Creates a new `Case2Payload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - nodeId:
                    ///   - url:
                    ///   - name:
                    ///   - description:
                    ///   - color:
                    ///   - _default:
                    public init(
                        id: Swift.Int64? = nil,
                        nodeId: Swift.String? = nil,
                        url: Swift.String? = nil,
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        color: Swift.String? = nil,
                        _default: Swift.Bool? = nil
                    ) {
                        self.id = id
                        self.nodeId = nodeId
                        self.url = url
                        self.name = name
                        self.description = description
                        self.color = color
                        self._default = _default
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case nodeId = "node_id"
                        case url
                        case name
                        case description
                        case color
                        case _default = "default"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/nullable-issue/LabelsPayload/case2`.
                case case2(Components.Schemas.NullableIssue.LabelsPayloadPayload.Case2Payload)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/labels`.
            public typealias LabelsPayload = [Components.Schemas.NullableIssue.LabelsPayloadPayload]
            /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-issue/labels`.
            public var labels: Components.Schemas.NullableIssue.LabelsPayload
            /// - Remark: Generated from `#/components/schemas/nullable-issue/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/milestone`.
            public var milestone: Components.Schemas.NullableMilestone?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/locked`.
            public var locked: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-issue/active_lock_reason`.
            public var activeLockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/comments`.
            public var comments: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request`.
            public struct PullRequestPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request/merged_at`.
                public var mergedAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request/diff_url`.
                public var diffUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request/patch_url`.
                public var patchUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request/url`.
                public var url: Swift.String?
                /// Creates a new `PullRequestPayload`.
                ///
                /// - Parameters:
                ///   - mergedAt:
                ///   - diffUrl:
                ///   - htmlUrl:
                ///   - patchUrl:
                ///   - url:
                public init(
                    mergedAt: Foundation.Date? = nil,
                    diffUrl: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    patchUrl: Swift.String? = nil,
                    url: Swift.String? = nil
                ) {
                    self.mergedAt = mergedAt
                    self.diffUrl = diffUrl
                    self.htmlUrl = htmlUrl
                    self.patchUrl = patchUrl
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case mergedAt = "merged_at"
                    case diffUrl = "diff_url"
                    case htmlUrl = "html_url"
                    case patchUrl = "patch_url"
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-issue/pull_request`.
            public var pullRequest: Components.Schemas.NullableIssue.PullRequestPayload?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-issue/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-issue/draft`.
            public var draft: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/closed_by`.
            public var closedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/timeline_url`.
            public var timelineUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/type`.
            public var _type: Components.Schemas.IssueType?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/repository`.
            public var repository: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/nullable-issue/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// - Remark: Generated from `#/components/schemas/nullable-issue/sub_issues_summary`.
            public var subIssuesSummary: Components.Schemas.SubIssuesSummary?
            /// Creates a new `NullableIssue`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url: URL for the issue
            ///   - repositoryUrl:
            ///   - labelsUrl:
            ///   - commentsUrl:
            ///   - eventsUrl:
            ///   - htmlUrl:
            ///   - number: Number uniquely identifying the issue within its repository
            ///   - state: State of the issue; either 'open' or 'closed'
            ///   - stateReason: The reason for the current state
            ///   - title: Title of the issue
            ///   - body: Contents of the issue
            ///   - user:
            ///   - labels: Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///   - assignee:
            ///   - assignees:
            ///   - milestone:
            ///   - locked:
            ///   - activeLockReason:
            ///   - comments:
            ///   - pullRequest:
            ///   - closedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - draft:
            ///   - closedBy:
            ///   - bodyHtml:
            ///   - bodyText:
            ///   - timelineUrl:
            ///   - _type:
            ///   - repository:
            ///   - performedViaGithubApp:
            ///   - authorAssociation:
            ///   - reactions:
            ///   - subIssuesSummary:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                repositoryUrl: Swift.String,
                labelsUrl: Swift.String,
                commentsUrl: Swift.String,
                eventsUrl: Swift.String,
                htmlUrl: Swift.String,
                number: Swift.Int,
                state: Swift.String,
                stateReason: Components.Schemas.NullableIssue.StateReasonPayload? = nil,
                title: Swift.String,
                body: Swift.String? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                labels: Components.Schemas.NullableIssue.LabelsPayload,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil,
                milestone: Components.Schemas.NullableMilestone? = nil,
                locked: Swift.Bool,
                activeLockReason: Swift.String? = nil,
                comments: Swift.Int,
                pullRequest: Components.Schemas.NullableIssue.PullRequestPayload? = nil,
                closedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                draft: Swift.Bool? = nil,
                closedBy: Components.Schemas.NullableSimpleUser? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                timelineUrl: Swift.String? = nil,
                _type: Components.Schemas.IssueType? = nil,
                repository: Components.Schemas.Repository? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                authorAssociation: Components.Schemas.AuthorAssociation,
                reactions: Components.Schemas.ReactionRollup? = nil,
                subIssuesSummary: Components.Schemas.SubIssuesSummary? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.repositoryUrl = repositoryUrl
                self.labelsUrl = labelsUrl
                self.commentsUrl = commentsUrl
                self.eventsUrl = eventsUrl
                self.htmlUrl = htmlUrl
                self.number = number
                self.state = state
                self.stateReason = stateReason
                self.title = title
                self.body = body
                self.user = user
                self.labels = labels
                self.assignee = assignee
                self.assignees = assignees
                self.milestone = milestone
                self.locked = locked
                self.activeLockReason = activeLockReason
                self.comments = comments
                self.pullRequest = pullRequest
                self.closedAt = closedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.draft = draft
                self.closedBy = closedBy
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
                self.timelineUrl = timelineUrl
                self._type = _type
                self.repository = repository
                self.performedViaGithubApp = performedViaGithubApp
                self.authorAssociation = authorAssociation
                self.reactions = reactions
                self.subIssuesSummary = subIssuesSummary
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case repositoryUrl = "repository_url"
                case labelsUrl = "labels_url"
                case commentsUrl = "comments_url"
                case eventsUrl = "events_url"
                case htmlUrl = "html_url"
                case number
                case state
                case stateReason = "state_reason"
                case title
                case body
                case user
                case labels
                case assignee
                case assignees
                case milestone
                case locked
                case activeLockReason = "active_lock_reason"
                case comments
                case pullRequest = "pull_request"
                case closedAt = "closed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case draft
                case closedBy = "closed_by"
                case bodyHtml = "body_html"
                case bodyText = "body_text"
                case timelineUrl = "timeline_url"
                case _type = "type"
                case repository
                case performedViaGithubApp = "performed_via_github_app"
                case authorAssociation = "author_association"
                case reactions
                case subIssuesSummary = "sub_issues_summary"
            }
        }
        /// Issue Event Label
        ///
        /// - Remark: Generated from `#/components/schemas/issue-event-label`.
        public struct IssueEventLabel: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event-label/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-event-label/color`.
            public var color: Swift.String?
            /// Creates a new `IssueEventLabel`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - color:
            public init(
                name: Swift.String? = nil,
                color: Swift.String? = nil
            ) {
                self.name = name
                self.color = color
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case color
            }
        }
        /// - Remark: Generated from `#/components/schemas/issue-event-dismissed-review`.
        public struct IssueEventDismissedReview: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event-dismissed-review/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event-dismissed-review/review_id`.
            public var reviewId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-event-dismissed-review/dismissal_message`.
            public var dismissalMessage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-event-dismissed-review/dismissal_commit_id`.
            public var dismissalCommitId: Swift.String?
            /// Creates a new `IssueEventDismissedReview`.
            ///
            /// - Parameters:
            ///   - state:
            ///   - reviewId:
            ///   - dismissalMessage:
            ///   - dismissalCommitId:
            public init(
                state: Swift.String,
                reviewId: Swift.Int,
                dismissalMessage: Swift.String? = nil,
                dismissalCommitId: Swift.String? = nil
            ) {
                self.state = state
                self.reviewId = reviewId
                self.dismissalMessage = dismissalMessage
                self.dismissalCommitId = dismissalCommitId
            }
            public enum CodingKeys: String, CodingKey {
                case state
                case reviewId = "review_id"
                case dismissalMessage = "dismissal_message"
                case dismissalCommitId = "dismissal_commit_id"
            }
        }
        /// Issue Event Milestone
        ///
        /// - Remark: Generated from `#/components/schemas/issue-event-milestone`.
        public struct IssueEventMilestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event-milestone/title`.
            public var title: Swift.String
            /// Creates a new `IssueEventMilestone`.
            ///
            /// - Parameters:
            ///   - title:
            public init(title: Swift.String) {
                self.title = title
            }
            public enum CodingKeys: String, CodingKey {
                case title
            }
        }
        /// Issue Event Project Card
        ///
        /// - Remark: Generated from `#/components/schemas/issue-event-project-card`.
        public struct IssueEventProjectCard: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event-project-card/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event-project-card/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-event-project-card/project_url`.
            public var projectUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event-project-card/project_id`.
            public var projectId: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-event-project-card/column_name`.
            public var columnName: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event-project-card/previous_column_name`.
            public var previousColumnName: Swift.String?
            /// Creates a new `IssueEventProjectCard`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id:
            ///   - projectUrl:
            ///   - projectId:
            ///   - columnName:
            ///   - previousColumnName:
            public init(
                url: Swift.String,
                id: Swift.Int,
                projectUrl: Swift.String,
                projectId: Swift.Int,
                columnName: Swift.String,
                previousColumnName: Swift.String? = nil
            ) {
                self.url = url
                self.id = id
                self.projectUrl = projectUrl
                self.projectId = projectId
                self.columnName = columnName
                self.previousColumnName = previousColumnName
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case projectUrl = "project_url"
                case projectId = "project_id"
                case columnName = "column_name"
                case previousColumnName = "previous_column_name"
            }
        }
        /// Issue Event Rename
        ///
        /// - Remark: Generated from `#/components/schemas/issue-event-rename`.
        public struct IssueEventRename: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event-rename/from`.
            public var from: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event-rename/to`.
            public var to: Swift.String
            /// Creates a new `IssueEventRename`.
            ///
            /// - Parameters:
            ///   - from:
            ///   - to:
            public init(
                from: Swift.String,
                to: Swift.String
            ) {
                self.from = from
                self.to = to
            }
            public enum CodingKeys: String, CodingKey {
                case from
                case to
            }
        }
        /// Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/issue-event`.
        public struct IssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event/actor`.
            public var actor: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-event/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-event/issue`.
            public var issue: Components.Schemas.NullableIssue?
            /// - Remark: Generated from `#/components/schemas/issue-event/label`.
            public var label: Components.Schemas.IssueEventLabel?
            /// - Remark: Generated from `#/components/schemas/issue-event/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-event/assigner`.
            public var assigner: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-event/review_requester`.
            public var reviewRequester: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-event/requested_reviewer`.
            public var requestedReviewer: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-event/requested_team`.
            public var requestedTeam: Components.Schemas.Team?
            /// - Remark: Generated from `#/components/schemas/issue-event/dismissed_review`.
            public var dismissedReview: Components.Schemas.IssueEventDismissedReview?
            /// - Remark: Generated from `#/components/schemas/issue-event/milestone`.
            public var milestone: Components.Schemas.IssueEventMilestone?
            /// - Remark: Generated from `#/components/schemas/issue-event/project_card`.
            public var projectCard: Components.Schemas.IssueEventProjectCard?
            /// - Remark: Generated from `#/components/schemas/issue-event/rename`.
            public var rename: Components.Schemas.IssueEventRename?
            /// - Remark: Generated from `#/components/schemas/issue-event/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation?
            /// - Remark: Generated from `#/components/schemas/issue-event/lock_reason`.
            public var lockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// Creates a new `IssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - issue:
            ///   - label:
            ///   - assignee:
            ///   - assigner:
            ///   - reviewRequester:
            ///   - requestedReviewer:
            ///   - requestedTeam:
            ///   - dismissedReview:
            ///   - milestone:
            ///   - projectCard:
            ///   - rename:
            ///   - authorAssociation:
            ///   - lockReason:
            ///   - performedViaGithubApp:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.NullableSimpleUser? = nil,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Foundation.Date,
                issue: Components.Schemas.NullableIssue? = nil,
                label: Components.Schemas.IssueEventLabel? = nil,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                assigner: Components.Schemas.NullableSimpleUser? = nil,
                reviewRequester: Components.Schemas.NullableSimpleUser? = nil,
                requestedReviewer: Components.Schemas.NullableSimpleUser? = nil,
                requestedTeam: Components.Schemas.Team? = nil,
                dismissedReview: Components.Schemas.IssueEventDismissedReview? = nil,
                milestone: Components.Schemas.IssueEventMilestone? = nil,
                projectCard: Components.Schemas.IssueEventProjectCard? = nil,
                rename: Components.Schemas.IssueEventRename? = nil,
                authorAssociation: Components.Schemas.AuthorAssociation? = nil,
                lockReason: Swift.String? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.issue = issue
                self.label = label
                self.assignee = assignee
                self.assigner = assigner
                self.reviewRequester = reviewRequester
                self.requestedReviewer = requestedReviewer
                self.requestedTeam = requestedTeam
                self.dismissedReview = dismissedReview
                self.milestone = milestone
                self.projectCard = projectCard
                self.rename = rename
                self.authorAssociation = authorAssociation
                self.lockReason = lockReason
                self.performedViaGithubApp = performedViaGithubApp
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case issue
                case label
                case assignee
                case assigner
                case reviewRequester = "review_requester"
                case requestedReviewer = "requested_reviewer"
                case requestedTeam = "requested_team"
                case dismissedReview = "dismissed_review"
                case milestone
                case projectCard = "project_card"
                case rename
                case authorAssociation = "author_association"
                case lockReason = "lock_reason"
                case performedViaGithubApp = "performed_via_github_app"
            }
        }
        /// Labeled Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/labeled-issue-event`.
        public struct LabeledIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/label`.
            public struct LabelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/labeled-issue-event/label/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/labeled-issue-event/label/color`.
                public var color: Swift.String
                /// Creates a new `LabelPayload`.
                ///
                /// - Parameters:
                ///   - name:
                ///   - color:
                public init(
                    name: Swift.String,
                    color: Swift.String
                ) {
                    self.name = name
                    self.color = color
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case color
                }
            }
            /// - Remark: Generated from `#/components/schemas/labeled-issue-event/label`.
            public var label: Components.Schemas.LabeledIssueEvent.LabelPayload
            /// Creates a new `LabeledIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - label:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                label: Components.Schemas.LabeledIssueEvent.LabelPayload
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.label = label
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case label
            }
        }
        /// Unlabeled Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event`.
        public struct UnlabeledIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/label`.
            public struct LabelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/label/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/label/color`.
                public var color: Swift.String
                /// Creates a new `LabelPayload`.
                ///
                /// - Parameters:
                ///   - name:
                ///   - color:
                public init(
                    name: Swift.String,
                    color: Swift.String
                ) {
                    self.name = name
                    self.color = color
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case color
                }
            }
            /// - Remark: Generated from `#/components/schemas/unlabeled-issue-event/label`.
            public var label: Components.Schemas.UnlabeledIssueEvent.LabelPayload
            /// Creates a new `UnlabeledIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - label:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                label: Components.Schemas.UnlabeledIssueEvent.LabelPayload
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.label = label
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case label
            }
        }
        /// Assigned Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/assigned-issue-event`.
        public struct AssignedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.Integration?
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/assignee`.
            public var assignee: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/assigned-issue-event/assigner`.
            public var assigner: Components.Schemas.SimpleUser
            /// Creates a new `AssignedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - assignee:
            ///   - assigner:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.Integration? = nil,
                assignee: Components.Schemas.SimpleUser,
                assigner: Components.Schemas.SimpleUser
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.assignee = assignee
                self.assigner = assigner
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case assignee
                case assigner
            }
        }
        /// Unassigned Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/unassigned-issue-event`.
        public struct UnassignedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/assignee`.
            public var assignee: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/unassigned-issue-event/assigner`.
            public var assigner: Components.Schemas.SimpleUser
            /// Creates a new `UnassignedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - assignee:
            ///   - assigner:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                assignee: Components.Schemas.SimpleUser,
                assigner: Components.Schemas.SimpleUser
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.assignee = assignee
                self.assigner = assigner
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case assignee
                case assigner
            }
        }
        /// Milestoned Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/milestoned-issue-event`.
        public struct MilestonedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/milestone`.
            public struct MilestonePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/milestone/title`.
                public var title: Swift.String
                /// Creates a new `MilestonePayload`.
                ///
                /// - Parameters:
                ///   - title:
                public init(title: Swift.String) {
                    self.title = title
                }
                public enum CodingKeys: String, CodingKey {
                    case title
                }
            }
            /// - Remark: Generated from `#/components/schemas/milestoned-issue-event/milestone`.
            public var milestone: Components.Schemas.MilestonedIssueEvent.MilestonePayload
            /// Creates a new `MilestonedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - milestone:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                milestone: Components.Schemas.MilestonedIssueEvent.MilestonePayload
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.milestone = milestone
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case milestone
            }
        }
        /// Demilestoned Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event`.
        public struct DemilestonedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/milestone`.
            public struct MilestonePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/milestone/title`.
                public var title: Swift.String
                /// Creates a new `MilestonePayload`.
                ///
                /// - Parameters:
                ///   - title:
                public init(title: Swift.String) {
                    self.title = title
                }
                public enum CodingKeys: String, CodingKey {
                    case title
                }
            }
            /// - Remark: Generated from `#/components/schemas/demilestoned-issue-event/milestone`.
            public var milestone: Components.Schemas.DemilestonedIssueEvent.MilestonePayload
            /// Creates a new `DemilestonedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - milestone:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                milestone: Components.Schemas.DemilestonedIssueEvent.MilestonePayload
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.milestone = milestone
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case milestone
            }
        }
        /// Renamed Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/renamed-issue-event`.
        public struct RenamedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/rename`.
            public struct RenamePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/renamed-issue-event/rename/from`.
                public var from: Swift.String
                /// - Remark: Generated from `#/components/schemas/renamed-issue-event/rename/to`.
                public var to: Swift.String
                /// Creates a new `RenamePayload`.
                ///
                /// - Parameters:
                ///   - from:
                ///   - to:
                public init(
                    from: Swift.String,
                    to: Swift.String
                ) {
                    self.from = from
                    self.to = to
                }
                public enum CodingKeys: String, CodingKey {
                    case from
                    case to
                }
            }
            /// - Remark: Generated from `#/components/schemas/renamed-issue-event/rename`.
            public var rename: Components.Schemas.RenamedIssueEvent.RenamePayload
            /// Creates a new `RenamedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - rename:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                rename: Components.Schemas.RenamedIssueEvent.RenamePayload
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.rename = rename
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case rename
            }
        }
        /// Review Requested Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/review-requested-issue-event`.
        public struct ReviewRequestedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/review_requester`.
            public var reviewRequester: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/requested_team`.
            public var requestedTeam: Components.Schemas.Team?
            /// - Remark: Generated from `#/components/schemas/review-requested-issue-event/requested_reviewer`.
            public var requestedReviewer: Components.Schemas.SimpleUser?
            /// Creates a new `ReviewRequestedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - reviewRequester:
            ///   - requestedTeam:
            ///   - requestedReviewer:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                reviewRequester: Components.Schemas.SimpleUser,
                requestedTeam: Components.Schemas.Team? = nil,
                requestedReviewer: Components.Schemas.SimpleUser? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.reviewRequester = reviewRequester
                self.requestedTeam = requestedTeam
                self.requestedReviewer = requestedReviewer
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case reviewRequester = "review_requester"
                case requestedTeam = "requested_team"
                case requestedReviewer = "requested_reviewer"
            }
        }
        /// Review Request Removed Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event`.
        public struct ReviewRequestRemovedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/review_requester`.
            public var reviewRequester: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/requested_team`.
            public var requestedTeam: Components.Schemas.Team?
            /// - Remark: Generated from `#/components/schemas/review-request-removed-issue-event/requested_reviewer`.
            public var requestedReviewer: Components.Schemas.SimpleUser?
            /// Creates a new `ReviewRequestRemovedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - reviewRequester:
            ///   - requestedTeam:
            ///   - requestedReviewer:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                reviewRequester: Components.Schemas.SimpleUser,
                requestedTeam: Components.Schemas.Team? = nil,
                requestedReviewer: Components.Schemas.SimpleUser? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.reviewRequester = reviewRequester
                self.requestedTeam = requestedTeam
                self.requestedReviewer = requestedReviewer
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case reviewRequester = "review_requester"
                case requestedTeam = "requested_team"
                case requestedReviewer = "requested_reviewer"
            }
        }
        /// Review Dismissed Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event`.
        public struct ReviewDismissedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/dismissed_review`.
            public struct DismissedReviewPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/dismissed_review/state`.
                public var state: Swift.String
                /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/dismissed_review/review_id`.
                public var reviewId: Swift.Int
                /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/dismissed_review/dismissal_message`.
                public var dismissalMessage: Swift.String?
                /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/dismissed_review/dismissal_commit_id`.
                public var dismissalCommitId: Swift.String?
                /// Creates a new `DismissedReviewPayload`.
                ///
                /// - Parameters:
                ///   - state:
                ///   - reviewId:
                ///   - dismissalMessage:
                ///   - dismissalCommitId:
                public init(
                    state: Swift.String,
                    reviewId: Swift.Int,
                    dismissalMessage: Swift.String? = nil,
                    dismissalCommitId: Swift.String? = nil
                ) {
                    self.state = state
                    self.reviewId = reviewId
                    self.dismissalMessage = dismissalMessage
                    self.dismissalCommitId = dismissalCommitId
                }
                public enum CodingKeys: String, CodingKey {
                    case state
                    case reviewId = "review_id"
                    case dismissalMessage = "dismissal_message"
                    case dismissalCommitId = "dismissal_commit_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/review-dismissed-issue-event/dismissed_review`.
            public var dismissedReview: Components.Schemas.ReviewDismissedIssueEvent.DismissedReviewPayload
            /// Creates a new `ReviewDismissedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - dismissedReview:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                dismissedReview: Components.Schemas.ReviewDismissedIssueEvent.DismissedReviewPayload
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.dismissedReview = dismissedReview
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case dismissedReview = "dismissed_review"
            }
        }
        /// Locked Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/locked-issue-event`.
        public struct LockedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/locked-issue-event/lock_reason`.
            public var lockReason: Swift.String?
            /// Creates a new `LockedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - lockReason:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                lockReason: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.lockReason = lockReason
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case lockReason = "lock_reason"
            }
        }
        /// Added to Project Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event`.
        public struct AddedToProjectIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card`.
            public struct ProjectCardPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card/id`.
                public var id: Swift.Int
                /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card/project_id`.
                public var projectId: Swift.Int
                /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card/project_url`.
                public var projectUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card/column_name`.
                public var columnName: Swift.String
                /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card/previous_column_name`.
                public var previousColumnName: Swift.String?
                /// Creates a new `ProjectCardPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - url:
                ///   - projectId:
                ///   - projectUrl:
                ///   - columnName:
                ///   - previousColumnName:
                public init(
                    id: Swift.Int,
                    url: Swift.String,
                    projectId: Swift.Int,
                    projectUrl: Swift.String,
                    columnName: Swift.String,
                    previousColumnName: Swift.String? = nil
                ) {
                    self.id = id
                    self.url = url
                    self.projectId = projectId
                    self.projectUrl = projectUrl
                    self.columnName = columnName
                    self.previousColumnName = previousColumnName
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case url
                    case projectId = "project_id"
                    case projectUrl = "project_url"
                    case columnName = "column_name"
                    case previousColumnName = "previous_column_name"
                }
            }
            /// - Remark: Generated from `#/components/schemas/added-to-project-issue-event/project_card`.
            public var projectCard: Components.Schemas.AddedToProjectIssueEvent.ProjectCardPayload?
            /// Creates a new `AddedToProjectIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - projectCard:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                projectCard: Components.Schemas.AddedToProjectIssueEvent.ProjectCardPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.projectCard = projectCard
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case projectCard = "project_card"
            }
        }
        /// Moved Column in Project Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event`.
        public struct MovedColumnInProjectIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card`.
            public struct ProjectCardPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card/id`.
                public var id: Swift.Int
                /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card/project_id`.
                public var projectId: Swift.Int
                /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card/project_url`.
                public var projectUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card/column_name`.
                public var columnName: Swift.String
                /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card/previous_column_name`.
                public var previousColumnName: Swift.String?
                /// Creates a new `ProjectCardPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - url:
                ///   - projectId:
                ///   - projectUrl:
                ///   - columnName:
                ///   - previousColumnName:
                public init(
                    id: Swift.Int,
                    url: Swift.String,
                    projectId: Swift.Int,
                    projectUrl: Swift.String,
                    columnName: Swift.String,
                    previousColumnName: Swift.String? = nil
                ) {
                    self.id = id
                    self.url = url
                    self.projectId = projectId
                    self.projectUrl = projectUrl
                    self.columnName = columnName
                    self.previousColumnName = previousColumnName
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case url
                    case projectId = "project_id"
                    case projectUrl = "project_url"
                    case columnName = "column_name"
                    case previousColumnName = "previous_column_name"
                }
            }
            /// - Remark: Generated from `#/components/schemas/moved-column-in-project-issue-event/project_card`.
            public var projectCard: Components.Schemas.MovedColumnInProjectIssueEvent.ProjectCardPayload?
            /// Creates a new `MovedColumnInProjectIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - projectCard:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                projectCard: Components.Schemas.MovedColumnInProjectIssueEvent.ProjectCardPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.projectCard = projectCard
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case projectCard = "project_card"
            }
        }
        /// Removed from Project Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event`.
        public struct RemovedFromProjectIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card`.
            public struct ProjectCardPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card/id`.
                public var id: Swift.Int
                /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card/project_id`.
                public var projectId: Swift.Int
                /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card/project_url`.
                public var projectUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card/column_name`.
                public var columnName: Swift.String
                /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card/previous_column_name`.
                public var previousColumnName: Swift.String?
                /// Creates a new `ProjectCardPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - url:
                ///   - projectId:
                ///   - projectUrl:
                ///   - columnName:
                ///   - previousColumnName:
                public init(
                    id: Swift.Int,
                    url: Swift.String,
                    projectId: Swift.Int,
                    projectUrl: Swift.String,
                    columnName: Swift.String,
                    previousColumnName: Swift.String? = nil
                ) {
                    self.id = id
                    self.url = url
                    self.projectId = projectId
                    self.projectUrl = projectUrl
                    self.columnName = columnName
                    self.previousColumnName = previousColumnName
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case url
                    case projectId = "project_id"
                    case projectUrl = "project_url"
                    case columnName = "column_name"
                    case previousColumnName = "previous_column_name"
                }
            }
            /// - Remark: Generated from `#/components/schemas/removed-from-project-issue-event/project_card`.
            public var projectCard: Components.Schemas.RemovedFromProjectIssueEvent.ProjectCardPayload?
            /// Creates a new `RemovedFromProjectIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - projectCard:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                projectCard: Components.Schemas.RemovedFromProjectIssueEvent.ProjectCardPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.projectCard = projectCard
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case projectCard = "project_card"
            }
        }
        /// Converted Note to Issue Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event`.
        public struct ConvertedNoteToIssueIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.Integration?
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card`.
            public struct ProjectCardPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card/id`.
                public var id: Swift.Int
                /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card/project_id`.
                public var projectId: Swift.Int
                /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card/project_url`.
                public var projectUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card/column_name`.
                public var columnName: Swift.String
                /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card/previous_column_name`.
                public var previousColumnName: Swift.String?
                /// Creates a new `ProjectCardPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - url:
                ///   - projectId:
                ///   - projectUrl:
                ///   - columnName:
                ///   - previousColumnName:
                public init(
                    id: Swift.Int,
                    url: Swift.String,
                    projectId: Swift.Int,
                    projectUrl: Swift.String,
                    columnName: Swift.String,
                    previousColumnName: Swift.String? = nil
                ) {
                    self.id = id
                    self.url = url
                    self.projectId = projectId
                    self.projectUrl = projectUrl
                    self.columnName = columnName
                    self.previousColumnName = previousColumnName
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case url
                    case projectId = "project_id"
                    case projectUrl = "project_url"
                    case columnName = "column_name"
                    case previousColumnName = "previous_column_name"
                }
            }
            /// - Remark: Generated from `#/components/schemas/converted-note-to-issue-issue-event/project_card`.
            public var projectCard: Components.Schemas.ConvertedNoteToIssueIssueEvent.ProjectCardPayload?
            /// Creates a new `ConvertedNoteToIssueIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - projectCard:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.Integration? = nil,
                projectCard: Components.Schemas.ConvertedNoteToIssueIssueEvent.ProjectCardPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.projectCard = projectCard
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case projectCard = "project_card"
            }
        }
        /// Issue Event for Issue
        ///
        /// - Remark: Generated from `#/components/schemas/issue-event-for-issue`.
        public struct IssueEventForIssue: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value1`.
            public var value1: Components.Schemas.LabeledIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value2`.
            public var value2: Components.Schemas.UnlabeledIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value3`.
            public var value3: Components.Schemas.AssignedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value4`.
            public var value4: Components.Schemas.UnassignedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value5`.
            public var value5: Components.Schemas.MilestonedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value6`.
            public var value6: Components.Schemas.DemilestonedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value7`.
            public var value7: Components.Schemas.RenamedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value8`.
            public var value8: Components.Schemas.ReviewRequestedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value9`.
            public var value9: Components.Schemas.ReviewRequestRemovedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value10`.
            public var value10: Components.Schemas.ReviewDismissedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value11`.
            public var value11: Components.Schemas.LockedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value12`.
            public var value12: Components.Schemas.AddedToProjectIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value13`.
            public var value13: Components.Schemas.MovedColumnInProjectIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value14`.
            public var value14: Components.Schemas.RemovedFromProjectIssueEvent?
            /// - Remark: Generated from `#/components/schemas/issue-event-for-issue/value15`.
            public var value15: Components.Schemas.ConvertedNoteToIssueIssueEvent?
            /// Creates a new `IssueEventForIssue`.
            ///
            /// - Parameters:
            ///   - value1:
            ///   - value2:
            ///   - value3:
            ///   - value4:
            ///   - value5:
            ///   - value6:
            ///   - value7:
            ///   - value8:
            ///   - value9:
            ///   - value10:
            ///   - value11:
            ///   - value12:
            ///   - value13:
            ///   - value14:
            ///   - value15:
            public init(
                value1: Components.Schemas.LabeledIssueEvent? = nil,
                value2: Components.Schemas.UnlabeledIssueEvent? = nil,
                value3: Components.Schemas.AssignedIssueEvent? = nil,
                value4: Components.Schemas.UnassignedIssueEvent? = nil,
                value5: Components.Schemas.MilestonedIssueEvent? = nil,
                value6: Components.Schemas.DemilestonedIssueEvent? = nil,
                value7: Components.Schemas.RenamedIssueEvent? = nil,
                value8: Components.Schemas.ReviewRequestedIssueEvent? = nil,
                value9: Components.Schemas.ReviewRequestRemovedIssueEvent? = nil,
                value10: Components.Schemas.ReviewDismissedIssueEvent? = nil,
                value11: Components.Schemas.LockedIssueEvent? = nil,
                value12: Components.Schemas.AddedToProjectIssueEvent? = nil,
                value13: Components.Schemas.MovedColumnInProjectIssueEvent? = nil,
                value14: Components.Schemas.RemovedFromProjectIssueEvent? = nil,
                value15: Components.Schemas.ConvertedNoteToIssueIssueEvent? = nil
            ) {
                self.value1 = value1
                self.value2 = value2
                self.value3 = value3
                self.value4 = value4
                self.value5 = value5
                self.value6 = value6
                self.value7 = value7
                self.value8 = value8
                self.value9 = value9
                self.value10 = value10
                self.value11 = value11
                self.value12 = value12
                self.value13 = value13
                self.value14 = value14
                self.value15 = value15
            }
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self.value1 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value2 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value3 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value4 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value5 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value6 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value7 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value8 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value9 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value10 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value11 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value12 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value13 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value14 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value15 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                    [
                        self.value1,
                        self.value2,
                        self.value3,
                        self.value4,
                        self.value5,
                        self.value6,
                        self.value7,
                        self.value8,
                        self.value9,
                        self.value10,
                        self.value11,
                        self.value12,
                        self.value13,
                        self.value14,
                        self.value15
                    ],
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                try self.value1?.encode(to: encoder)
                try self.value2?.encode(to: encoder)
                try self.value3?.encode(to: encoder)
                try self.value4?.encode(to: encoder)
                try self.value5?.encode(to: encoder)
                try self.value6?.encode(to: encoder)
                try self.value7?.encode(to: encoder)
                try self.value8?.encode(to: encoder)
                try self.value9?.encode(to: encoder)
                try self.value10?.encode(to: encoder)
                try self.value11?.encode(to: encoder)
                try self.value12?.encode(to: encoder)
                try self.value13?.encode(to: encoder)
                try self.value14?.encode(to: encoder)
                try self.value15?.encode(to: encoder)
            }
        }
        /// Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
        ///
        /// - Remark: Generated from `#/components/schemas/label`.
        public struct Label: Codable, Hashable, Sendable {
            /// Unique identifier for the label.
            ///
            /// - Remark: Generated from `#/components/schemas/label/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/label/node_id`.
            public var nodeId: Swift.String
            /// URL for the label
            ///
            /// - Remark: Generated from `#/components/schemas/label/url`.
            public var url: Swift.String
            /// The name of the label.
            ///
            /// - Remark: Generated from `#/components/schemas/label/name`.
            public var name: Swift.String
            /// Optional description of the label, such as its purpose.
            ///
            /// - Remark: Generated from `#/components/schemas/label/description`.
            public var description: Swift.String?
            /// 6-character hex code, without the leading #, identifying the color
            ///
            /// - Remark: Generated from `#/components/schemas/label/color`.
            public var color: Swift.String
            /// Whether this label comes by default in a new repository.
            ///
            /// - Remark: Generated from `#/components/schemas/label/default`.
            public var _default: Swift.Bool
            /// Creates a new `Label`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier for the label.
            ///   - nodeId:
            ///   - url: URL for the label
            ///   - name: The name of the label.
            ///   - description: Optional description of the label, such as its purpose.
            ///   - color: 6-character hex code, without the leading #, identifying the color
            ///   - _default: Whether this label comes by default in a new repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                color: Swift.String,
                _default: Swift.Bool
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.name = name
                self.description = description
                self.color = color
                self._default = _default
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case name
                case description
                case color
                case _default = "default"
            }
        }
        /// Timeline Comment Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-comment-event`.
        public struct TimelineCommentEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// Unique identifier of the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/node_id`.
            public var nodeId: Swift.String
            /// URL for the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/url`.
            public var url: Swift.String
            /// Contents of the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/user`.
            public var user: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/issue_url`.
            public var issueUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/timeline-comment-event/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `TimelineCommentEvent`.
            ///
            /// - Parameters:
            ///   - event:
            ///   - actor:
            ///   - id: Unique identifier of the issue comment
            ///   - nodeId:
            ///   - url: URL for the issue comment
            ///   - body: Contents of the issue comment
            ///   - bodyText:
            ///   - bodyHtml:
            ///   - htmlUrl:
            ///   - user:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - issueUrl:
            ///   - authorAssociation:
            ///   - performedViaGithubApp:
            ///   - reactions:
            public init(
                event: Swift.String,
                actor: Components.Schemas.SimpleUser,
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                bodyHtml: Swift.String? = nil,
                htmlUrl: Swift.String,
                user: Components.Schemas.SimpleUser,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                issueUrl: Swift.String,
                authorAssociation: Components.Schemas.AuthorAssociation,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.event = event
                self.actor = actor
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.body = body
                self.bodyText = bodyText
                self.bodyHtml = bodyHtml
                self.htmlUrl = htmlUrl
                self.user = user
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.issueUrl = issueUrl
                self.authorAssociation = authorAssociation
                self.performedViaGithubApp = performedViaGithubApp
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case event
                case actor
                case id
                case nodeId = "node_id"
                case url
                case body
                case bodyText = "body_text"
                case bodyHtml = "body_html"
                case htmlUrl = "html_url"
                case user
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case issueUrl = "issue_url"
                case authorAssociation = "author_association"
                case performedViaGithubApp = "performed_via_github_app"
                case reactions
            }
        }
        /// Timeline Cross Referenced Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event`.
        public struct TimelineCrossReferencedEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/actor`.
            public var actor: Components.Schemas.SimpleUser?
            /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/source`.
            public struct SourcePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/source/type`.
                public var _type: Swift.String?
                /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/source/issue`.
                public var issue: Components.Schemas.Issue?
                /// Creates a new `SourcePayload`.
                ///
                /// - Parameters:
                ///   - _type:
                ///   - issue:
                public init(
                    _type: Swift.String? = nil,
                    issue: Components.Schemas.Issue? = nil
                ) {
                    self._type = _type
                    self.issue = issue
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case issue
                }
            }
            /// - Remark: Generated from `#/components/schemas/timeline-cross-referenced-event/source`.
            public var source: Components.Schemas.TimelineCrossReferencedEvent.SourcePayload
            /// Creates a new `TimelineCrossReferencedEvent`.
            ///
            /// - Parameters:
            ///   - event:
            ///   - actor:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - source:
            public init(
                event: Swift.String,
                actor: Components.Schemas.SimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                source: Components.Schemas.TimelineCrossReferencedEvent.SourcePayload
            ) {
                self.event = event
                self.actor = actor
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.source = source
            }
            public enum CodingKeys: String, CodingKey {
                case event
                case actor
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case source
            }
        }
        /// Timeline Committed Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-committed-event`.
        public struct TimelineCommittedEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/event`.
            public var event: Swift.String?
            /// SHA for the commit
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/url`.
            public var url: Swift.String
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/author`.
            public struct AuthorPayload: Codable, Hashable, Sendable {
                /// Timestamp of the commit
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/author/date`.
                public var date: Foundation.Date
                /// Git email address of the user
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/author/email`.
                public var email: Swift.String
                /// Name of the git user
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/author/name`.
                public var name: Swift.String
                /// Creates a new `AuthorPayload`.
                ///
                /// - Parameters:
                ///   - date: Timestamp of the commit
                ///   - email: Git email address of the user
                ///   - name: Name of the git user
                public init(
                    date: Foundation.Date,
                    email: Swift.String,
                    name: Swift.String
                ) {
                    self.date = date
                    self.email = email
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case email
                    case name
                }
            }
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/author`.
            public var author: Components.Schemas.TimelineCommittedEvent.AuthorPayload
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/committer`.
            public struct CommitterPayload: Codable, Hashable, Sendable {
                /// Timestamp of the commit
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/committer/date`.
                public var date: Foundation.Date
                /// Git email address of the user
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/committer/email`.
                public var email: Swift.String
                /// Name of the git user
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/committer/name`.
                public var name: Swift.String
                /// Creates a new `CommitterPayload`.
                ///
                /// - Parameters:
                ///   - date: Timestamp of the commit
                ///   - email: Git email address of the user
                ///   - name: Name of the git user
                public init(
                    date: Foundation.Date,
                    email: Swift.String,
                    name: Swift.String
                ) {
                    self.date = date
                    self.email = email
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case email
                    case name
                }
            }
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/committer`.
            public var committer: Components.Schemas.TimelineCommittedEvent.CommitterPayload
            /// Message describing the purpose of the commit
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/tree`.
            public struct TreePayload: Codable, Hashable, Sendable {
                /// SHA for the commit
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/tree/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/tree/url`.
                public var url: Swift.String
                /// Creates a new `TreePayload`.
                ///
                /// - Parameters:
                ///   - sha: SHA for the commit
                ///   - url:
                public init(
                    sha: Swift.String,
                    url: Swift.String
                ) {
                    self.sha = sha
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/tree`.
            public var tree: Components.Schemas.TimelineCommittedEvent.TreePayload
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/ParentsPayload`.
            public struct ParentsPayloadPayload: Codable, Hashable, Sendable {
                /// SHA for the commit
                ///
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/ParentsPayload/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/ParentsPayload/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/ParentsPayload/html_url`.
                public var htmlUrl: Swift.String
                /// Creates a new `ParentsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - sha: SHA for the commit
                ///   - url:
                ///   - htmlUrl:
                public init(
                    sha: Swift.String,
                    url: Swift.String,
                    htmlUrl: Swift.String
                ) {
                    self.sha = sha
                    self.url = url
                    self.htmlUrl = htmlUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                    case htmlUrl = "html_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/parents`.
            public typealias ParentsPayload = [Components.Schemas.TimelineCommittedEvent.ParentsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/parents`.
            public var parents: Components.Schemas.TimelineCommittedEvent.ParentsPayload
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification`.
            public struct VerificationPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification/verified`.
                public var verified: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification/reason`.
                public var reason: Swift.String
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification/signature`.
                public var signature: Swift.String?
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification/payload`.
                public var payload: Swift.String?
                /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification/verified_at`.
                public var verifiedAt: Swift.String?
                /// Creates a new `VerificationPayload`.
                ///
                /// - Parameters:
                ///   - verified:
                ///   - reason:
                ///   - signature:
                ///   - payload:
                ///   - verifiedAt:
                public init(
                    verified: Swift.Bool,
                    reason: Swift.String,
                    signature: Swift.String? = nil,
                    payload: Swift.String? = nil,
                    verifiedAt: Swift.String? = nil
                ) {
                    self.verified = verified
                    self.reason = reason
                    self.signature = signature
                    self.payload = payload
                    self.verifiedAt = verifiedAt
                }
                public enum CodingKeys: String, CodingKey {
                    case verified
                    case reason
                    case signature
                    case payload
                    case verifiedAt = "verified_at"
                }
            }
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/verification`.
            public var verification: Components.Schemas.TimelineCommittedEvent.VerificationPayload
            /// - Remark: Generated from `#/components/schemas/timeline-committed-event/html_url`.
            public var htmlUrl: Swift.String
            /// Creates a new `TimelineCommittedEvent`.
            ///
            /// - Parameters:
            ///   - event:
            ///   - sha: SHA for the commit
            ///   - nodeId:
            ///   - url:
            ///   - author: Identifying information for the git-user
            ///   - committer: Identifying information for the git-user
            ///   - message: Message describing the purpose of the commit
            ///   - tree:
            ///   - parents:
            ///   - verification:
            ///   - htmlUrl:
            public init(
                event: Swift.String? = nil,
                sha: Swift.String,
                nodeId: Swift.String,
                url: Swift.String,
                author: Components.Schemas.TimelineCommittedEvent.AuthorPayload,
                committer: Components.Schemas.TimelineCommittedEvent.CommitterPayload,
                message: Swift.String,
                tree: Components.Schemas.TimelineCommittedEvent.TreePayload,
                parents: Components.Schemas.TimelineCommittedEvent.ParentsPayload,
                verification: Components.Schemas.TimelineCommittedEvent.VerificationPayload,
                htmlUrl: Swift.String
            ) {
                self.event = event
                self.sha = sha
                self.nodeId = nodeId
                self.url = url
                self.author = author
                self.committer = committer
                self.message = message
                self.tree = tree
                self.parents = parents
                self.verification = verification
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case event
                case sha
                case nodeId = "node_id"
                case url
                case author
                case committer
                case message
                case tree
                case parents
                case verification
                case htmlUrl = "html_url"
            }
        }
        /// Timeline Reviewed Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event`.
        public struct TimelineReviewedEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/event`.
            public var event: Swift.String
            /// Unique identifier of the review
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/user`.
            public var user: Components.Schemas.SimpleUser
            /// The text of the review.
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/pull_request_url`.
            public var pullRequestUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links/html`.
                public struct HtmlPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links/html/href`.
                    public var href: Swift.String
                    /// Creates a new `HtmlPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links/html`.
                public var html: Components.Schemas.TimelineReviewedEvent._LinksPayload.HtmlPayload
                /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links/pull_request`.
                public struct PullRequestPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links/pull_request/href`.
                    public var href: Swift.String
                    /// Creates a new `PullRequestPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links/pull_request`.
                public var pullRequest: Components.Schemas.TimelineReviewedEvent._LinksPayload.PullRequestPayload
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - html:
                ///   - pullRequest:
                public init(
                    html: Components.Schemas.TimelineReviewedEvent._LinksPayload.HtmlPayload,
                    pullRequest: Components.Schemas.TimelineReviewedEvent._LinksPayload.PullRequestPayload
                ) {
                    self.html = html
                    self.pullRequest = pullRequest
                }
                public enum CodingKeys: String, CodingKey {
                    case html
                    case pullRequest = "pull_request"
                }
            }
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/_links`.
            public var _links: Components.Schemas.TimelineReviewedEvent._LinksPayload
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/submitted_at`.
            public var submittedAt: Foundation.Date?
            /// A commit SHA for the review.
            ///
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/commit_id`.
            public var commitId: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-reviewed-event/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// Creates a new `TimelineReviewedEvent`.
            ///
            /// - Parameters:
            ///   - event:
            ///   - id: Unique identifier of the review
            ///   - nodeId:
            ///   - user:
            ///   - body: The text of the review.
            ///   - state:
            ///   - htmlUrl:
            ///   - pullRequestUrl:
            ///   - _links:
            ///   - submittedAt:
            ///   - commitId: A commit SHA for the review.
            ///   - bodyHtml:
            ///   - bodyText:
            ///   - authorAssociation:
            public init(
                event: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                user: Components.Schemas.SimpleUser,
                body: Swift.String? = nil,
                state: Swift.String,
                htmlUrl: Swift.String,
                pullRequestUrl: Swift.String,
                _links: Components.Schemas.TimelineReviewedEvent._LinksPayload,
                submittedAt: Foundation.Date? = nil,
                commitId: Swift.String,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                authorAssociation: Components.Schemas.AuthorAssociation
            ) {
                self.event = event
                self.id = id
                self.nodeId = nodeId
                self.user = user
                self.body = body
                self.state = state
                self.htmlUrl = htmlUrl
                self.pullRequestUrl = pullRequestUrl
                self._links = _links
                self.submittedAt = submittedAt
                self.commitId = commitId
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
                self.authorAssociation = authorAssociation
            }
            public enum CodingKeys: String, CodingKey {
                case event
                case id
                case nodeId = "node_id"
                case user
                case body
                case state
                case htmlUrl = "html_url"
                case pullRequestUrl = "pull_request_url"
                case _links
                case submittedAt = "submitted_at"
                case commitId = "commit_id"
                case bodyHtml = "body_html"
                case bodyText = "body_text"
                case authorAssociation = "author_association"
            }
        }
        /// Pull Request Review Comments are comments on a portion of the Pull Request's diff.
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request-review-comment`.
        public struct PullRequestReviewComment: Codable, Hashable, Sendable {
            /// URL for the pull request review comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/url`.
            public var url: Swift.String
            /// The ID of the pull request review to which the comment belongs.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/pull_request_review_id`.
            public var pullRequestReviewId: Swift.Int64?
            /// The ID of the pull request review comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/id`.
            public var id: Swift.Int64
            /// The node ID of the pull request review comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/node_id`.
            public var nodeId: Swift.String
            /// The diff of the line that the comment refers to.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/diff_hunk`.
            public var diffHunk: Swift.String
            /// The relative path of the file to which the comment applies.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/path`.
            public var path: Swift.String
            /// The line index in the diff to which the comment applies. This field is closing down; use `line` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/position`.
            public var position: Swift.Int?
            /// The index of the original line in the diff to which the comment applies. This field is closing down; use `original_line` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_position`.
            public var originalPosition: Swift.Int?
            /// The SHA of the commit to which the comment applies.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/commit_id`.
            public var commitId: Swift.String
            /// The SHA of the original commit to which the comment applies.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_commit_id`.
            public var originalCommitId: Swift.String
            /// The comment ID to reply to.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/in_reply_to_id`.
            public var inReplyToId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/user`.
            public var user: Components.Schemas.SimpleUser
            /// The text of the comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// HTML URL for the pull request review comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/html_url`.
            public var htmlUrl: Swift.String
            /// URL for the pull request that the review comment belongs to.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/pull_request_url`.
            public var pullRequestUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/self`.
                public struct _SelfPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/self/href`.
                    public var href: Swift.String
                    /// Creates a new `_SelfPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/self`.
                public var _self: Components.Schemas.PullRequestReviewComment._LinksPayload._SelfPayload
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/html`.
                public struct HtmlPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/html/href`.
                    public var href: Swift.String
                    /// Creates a new `HtmlPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/html`.
                public var html: Components.Schemas.PullRequestReviewComment._LinksPayload.HtmlPayload
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/pull_request`.
                public struct PullRequestPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/pull_request/href`.
                    public var href: Swift.String
                    /// Creates a new `PullRequestPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/pull_request`.
                public var pullRequest: Components.Schemas.PullRequestReviewComment._LinksPayload.PullRequestPayload
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - _self:
                ///   - html:
                ///   - pullRequest:
                public init(
                    _self: Components.Schemas.PullRequestReviewComment._LinksPayload._SelfPayload,
                    html: Components.Schemas.PullRequestReviewComment._LinksPayload.HtmlPayload,
                    pullRequest: Components.Schemas.PullRequestReviewComment._LinksPayload.PullRequestPayload
                ) {
                    self._self = _self
                    self.html = html
                    self.pullRequest = pullRequest
                }
                public enum CodingKeys: String, CodingKey {
                    case _self = "self"
                    case html
                    case pullRequest = "pull_request"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links`.
            public var _links: Components.Schemas.PullRequestReviewComment._LinksPayload
            /// The first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/start_line`.
            public var startLine: Swift.Int?
            /// The first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_start_line`.
            public var originalStartLine: Swift.Int?
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/start_side`.
            @frozen public enum StartSidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case left = "LEFT"
                case right = "RIGHT"
            }
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/start_side`.
            public var startSide: Components.Schemas.PullRequestReviewComment.StartSidePayload?
            /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/line`.
            public var line: Swift.Int?
            /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_line`.
            public var originalLine: Swift.Int?
            /// The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/side`.
            @frozen public enum SidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case left = "LEFT"
                case right = "RIGHT"
            }
            /// The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/side`.
            public var side: Components.Schemas.PullRequestReviewComment.SidePayload?
            /// The level at which the comment is targeted, can be a diff line or a file.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/subject_type`.
            @frozen public enum SubjectTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case line = "line"
                case file = "file"
            }
            /// The level at which the comment is targeted, can be a diff line or a file.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/subject_type`.
            public var subjectType: Components.Schemas.PullRequestReviewComment.SubjectTypePayload?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/body_text`.
            public var bodyText: Swift.String?
            /// Creates a new `PullRequestReviewComment`.
            ///
            /// - Parameters:
            ///   - url: URL for the pull request review comment
            ///   - pullRequestReviewId: The ID of the pull request review to which the comment belongs.
            ///   - id: The ID of the pull request review comment.
            ///   - nodeId: The node ID of the pull request review comment.
            ///   - diffHunk: The diff of the line that the comment refers to.
            ///   - path: The relative path of the file to which the comment applies.
            ///   - position: The line index in the diff to which the comment applies. This field is closing down; use `line` instead.
            ///   - originalPosition: The index of the original line in the diff to which the comment applies. This field is closing down; use `original_line` instead.
            ///   - commitId: The SHA of the commit to which the comment applies.
            ///   - originalCommitId: The SHA of the original commit to which the comment applies.
            ///   - inReplyToId: The comment ID to reply to.
            ///   - user:
            ///   - body: The text of the comment.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - htmlUrl: HTML URL for the pull request review comment.
            ///   - pullRequestUrl: URL for the pull request that the review comment belongs to.
            ///   - authorAssociation:
            ///   - _links:
            ///   - startLine: The first line of the range for a multi-line comment.
            ///   - originalStartLine: The first line of the range for a multi-line comment.
            ///   - startSide: The side of the first line of the range for a multi-line comment.
            ///   - line: The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///   - originalLine: The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///   - side: The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
            ///   - subjectType: The level at which the comment is targeted, can be a diff line or a file.
            ///   - reactions:
            ///   - bodyHtml:
            ///   - bodyText:
            public init(
                url: Swift.String,
                pullRequestReviewId: Swift.Int64? = nil,
                id: Swift.Int64,
                nodeId: Swift.String,
                diffHunk: Swift.String,
                path: Swift.String,
                position: Swift.Int? = nil,
                originalPosition: Swift.Int? = nil,
                commitId: Swift.String,
                originalCommitId: Swift.String,
                inReplyToId: Swift.Int? = nil,
                user: Components.Schemas.SimpleUser,
                body: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                htmlUrl: Swift.String,
                pullRequestUrl: Swift.String,
                authorAssociation: Components.Schemas.AuthorAssociation,
                _links: Components.Schemas.PullRequestReviewComment._LinksPayload,
                startLine: Swift.Int? = nil,
                originalStartLine: Swift.Int? = nil,
                startSide: Components.Schemas.PullRequestReviewComment.StartSidePayload? = nil,
                line: Swift.Int? = nil,
                originalLine: Swift.Int? = nil,
                side: Components.Schemas.PullRequestReviewComment.SidePayload? = nil,
                subjectType: Components.Schemas.PullRequestReviewComment.SubjectTypePayload? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil
            ) {
                self.url = url
                self.pullRequestReviewId = pullRequestReviewId
                self.id = id
                self.nodeId = nodeId
                self.diffHunk = diffHunk
                self.path = path
                self.position = position
                self.originalPosition = originalPosition
                self.commitId = commitId
                self.originalCommitId = originalCommitId
                self.inReplyToId = inReplyToId
                self.user = user
                self.body = body
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.htmlUrl = htmlUrl
                self.pullRequestUrl = pullRequestUrl
                self.authorAssociation = authorAssociation
                self._links = _links
                self.startLine = startLine
                self.originalStartLine = originalStartLine
                self.startSide = startSide
                self.line = line
                self.originalLine = originalLine
                self.side = side
                self.subjectType = subjectType
                self.reactions = reactions
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case pullRequestReviewId = "pull_request_review_id"
                case id
                case nodeId = "node_id"
                case diffHunk = "diff_hunk"
                case path
                case position
                case originalPosition = "original_position"
                case commitId = "commit_id"
                case originalCommitId = "original_commit_id"
                case inReplyToId = "in_reply_to_id"
                case user
                case body
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case htmlUrl = "html_url"
                case pullRequestUrl = "pull_request_url"
                case authorAssociation = "author_association"
                case _links
                case startLine = "start_line"
                case originalStartLine = "original_start_line"
                case startSide = "start_side"
                case line
                case originalLine = "original_line"
                case side
                case subjectType = "subject_type"
                case reactions
                case bodyHtml = "body_html"
                case bodyText = "body_text"
            }
        }
        /// Timeline Line Commented Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-line-commented-event`.
        public struct TimelineLineCommentedEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-line-commented-event/event`.
            public var event: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-line-commented-event/node_id`.
            public var nodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-line-commented-event/comments`.
            public var comments: [Components.Schemas.PullRequestReviewComment]?
            /// Creates a new `TimelineLineCommentedEvent`.
            ///
            /// - Parameters:
            ///   - event:
            ///   - nodeId:
            ///   - comments:
            public init(
                event: Swift.String? = nil,
                nodeId: Swift.String? = nil,
                comments: [Components.Schemas.PullRequestReviewComment]? = nil
            ) {
                self.event = event
                self.nodeId = nodeId
                self.comments = comments
            }
            public enum CodingKeys: String, CodingKey {
                case event
                case nodeId = "node_id"
                case comments
            }
        }
        /// Timeline Commit Commented Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-commit-commented-event`.
        public struct TimelineCommitCommentedEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-commit-commented-event/event`.
            public var event: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-commit-commented-event/node_id`.
            public var nodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-commit-commented-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-commit-commented-event/comments`.
            public var comments: [Components.Schemas.CommitComment]?
            /// Creates a new `TimelineCommitCommentedEvent`.
            ///
            /// - Parameters:
            ///   - event:
            ///   - nodeId:
            ///   - commitId:
            ///   - comments:
            public init(
                event: Swift.String? = nil,
                nodeId: Swift.String? = nil,
                commitId: Swift.String? = nil,
                comments: [Components.Schemas.CommitComment]? = nil
            ) {
                self.event = event
                self.nodeId = nodeId
                self.commitId = commitId
                self.comments = comments
            }
            public enum CodingKeys: String, CodingKey {
                case event
                case nodeId = "node_id"
                case commitId = "commit_id"
                case comments
            }
        }
        /// Timeline Assigned Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event`.
        public struct TimelineAssignedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/timeline-assigned-issue-event/assignee`.
            public var assignee: Components.Schemas.SimpleUser
            /// Creates a new `TimelineAssignedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - assignee:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                assignee: Components.Schemas.SimpleUser
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.assignee = assignee
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case assignee
            }
        }
        /// Timeline Unassigned Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event`.
        public struct TimelineUnassignedIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/timeline-unassigned-issue-event/assignee`.
            public var assignee: Components.Schemas.SimpleUser
            /// Creates a new `TimelineUnassignedIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - assignee:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                assignee: Components.Schemas.SimpleUser
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.assignee = assignee
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case assignee
            }
        }
        /// State Change Issue Event
        ///
        /// - Remark: Generated from `#/components/schemas/state-change-issue-event`.
        public struct StateChangeIssueEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/event`.
            public var event: Swift.String
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/commit_url`.
            public var commitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/state-change-issue-event/state_reason`.
            public var stateReason: Swift.String?
            /// Creates a new `StateChangeIssueEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - actor:
            ///   - event:
            ///   - commitId:
            ///   - commitUrl:
            ///   - createdAt:
            ///   - performedViaGithubApp:
            ///   - stateReason:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                actor: Components.Schemas.SimpleUser,
                event: Swift.String,
                commitId: Swift.String? = nil,
                commitUrl: Swift.String? = nil,
                createdAt: Swift.String,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                stateReason: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.actor = actor
                self.event = event
                self.commitId = commitId
                self.commitUrl = commitUrl
                self.createdAt = createdAt
                self.performedViaGithubApp = performedViaGithubApp
                self.stateReason = stateReason
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case actor
                case event
                case commitId = "commit_id"
                case commitUrl = "commit_url"
                case createdAt = "created_at"
                case performedViaGithubApp = "performed_via_github_app"
                case stateReason = "state_reason"
            }
        }
        /// Timeline Event
        ///
        /// - Remark: Generated from `#/components/schemas/timeline-issue-events`.
        public struct TimelineIssueEvents: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value1`.
            public var value1: Components.Schemas.LabeledIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value2`.
            public var value2: Components.Schemas.UnlabeledIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value3`.
            public var value3: Components.Schemas.MilestonedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value4`.
            public var value4: Components.Schemas.DemilestonedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value5`.
            public var value5: Components.Schemas.RenamedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value6`.
            public var value6: Components.Schemas.ReviewRequestedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value7`.
            public var value7: Components.Schemas.ReviewRequestRemovedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value8`.
            public var value8: Components.Schemas.ReviewDismissedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value9`.
            public var value9: Components.Schemas.LockedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value10`.
            public var value10: Components.Schemas.AddedToProjectIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value11`.
            public var value11: Components.Schemas.MovedColumnInProjectIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value12`.
            public var value12: Components.Schemas.RemovedFromProjectIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value13`.
            public var value13: Components.Schemas.ConvertedNoteToIssueIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value14`.
            public var value14: Components.Schemas.TimelineCommentEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value15`.
            public var value15: Components.Schemas.TimelineCrossReferencedEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value16`.
            public var value16: Components.Schemas.TimelineCommittedEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value17`.
            public var value17: Components.Schemas.TimelineReviewedEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value18`.
            public var value18: Components.Schemas.TimelineLineCommentedEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value19`.
            public var value19: Components.Schemas.TimelineCommitCommentedEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value20`.
            public var value20: Components.Schemas.TimelineAssignedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value21`.
            public var value21: Components.Schemas.TimelineUnassignedIssueEvent?
            /// - Remark: Generated from `#/components/schemas/timeline-issue-events/value22`.
            public var value22: Components.Schemas.StateChangeIssueEvent?
            /// Creates a new `TimelineIssueEvents`.
            ///
            /// - Parameters:
            ///   - value1:
            ///   - value2:
            ///   - value3:
            ///   - value4:
            ///   - value5:
            ///   - value6:
            ///   - value7:
            ///   - value8:
            ///   - value9:
            ///   - value10:
            ///   - value11:
            ///   - value12:
            ///   - value13:
            ///   - value14:
            ///   - value15:
            ///   - value16:
            ///   - value17:
            ///   - value18:
            ///   - value19:
            ///   - value20:
            ///   - value21:
            ///   - value22:
            public init(
                value1: Components.Schemas.LabeledIssueEvent? = nil,
                value2: Components.Schemas.UnlabeledIssueEvent? = nil,
                value3: Components.Schemas.MilestonedIssueEvent? = nil,
                value4: Components.Schemas.DemilestonedIssueEvent? = nil,
                value5: Components.Schemas.RenamedIssueEvent? = nil,
                value6: Components.Schemas.ReviewRequestedIssueEvent? = nil,
                value7: Components.Schemas.ReviewRequestRemovedIssueEvent? = nil,
                value8: Components.Schemas.ReviewDismissedIssueEvent? = nil,
                value9: Components.Schemas.LockedIssueEvent? = nil,
                value10: Components.Schemas.AddedToProjectIssueEvent? = nil,
                value11: Components.Schemas.MovedColumnInProjectIssueEvent? = nil,
                value12: Components.Schemas.RemovedFromProjectIssueEvent? = nil,
                value13: Components.Schemas.ConvertedNoteToIssueIssueEvent? = nil,
                value14: Components.Schemas.TimelineCommentEvent? = nil,
                value15: Components.Schemas.TimelineCrossReferencedEvent? = nil,
                value16: Components.Schemas.TimelineCommittedEvent? = nil,
                value17: Components.Schemas.TimelineReviewedEvent? = nil,
                value18: Components.Schemas.TimelineLineCommentedEvent? = nil,
                value19: Components.Schemas.TimelineCommitCommentedEvent? = nil,
                value20: Components.Schemas.TimelineAssignedIssueEvent? = nil,
                value21: Components.Schemas.TimelineUnassignedIssueEvent? = nil,
                value22: Components.Schemas.StateChangeIssueEvent? = nil
            ) {
                self.value1 = value1
                self.value2 = value2
                self.value3 = value3
                self.value4 = value4
                self.value5 = value5
                self.value6 = value6
                self.value7 = value7
                self.value8 = value8
                self.value9 = value9
                self.value10 = value10
                self.value11 = value11
                self.value12 = value12
                self.value13 = value13
                self.value14 = value14
                self.value15 = value15
                self.value16 = value16
                self.value17 = value17
                self.value18 = value18
                self.value19 = value19
                self.value20 = value20
                self.value21 = value21
                self.value22 = value22
            }
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self.value1 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value2 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value3 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value4 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value5 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value6 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value7 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value8 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value9 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value10 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value11 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value12 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value13 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value14 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value15 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value16 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value17 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value18 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value19 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value20 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value21 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                do {
                    self.value22 = try .init(from: decoder)
                } catch {
                    errors.append(error)
                }
                try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                    [
                        self.value1,
                        self.value2,
                        self.value3,
                        self.value4,
                        self.value5,
                        self.value6,
                        self.value7,
                        self.value8,
                        self.value9,
                        self.value10,
                        self.value11,
                        self.value12,
                        self.value13,
                        self.value14,
                        self.value15,
                        self.value16,
                        self.value17,
                        self.value18,
                        self.value19,
                        self.value20,
                        self.value21,
                        self.value22
                    ],
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                try self.value1?.encode(to: encoder)
                try self.value2?.encode(to: encoder)
                try self.value3?.encode(to: encoder)
                try self.value4?.encode(to: encoder)
                try self.value5?.encode(to: encoder)
                try self.value6?.encode(to: encoder)
                try self.value7?.encode(to: encoder)
                try self.value8?.encode(to: encoder)
                try self.value9?.encode(to: encoder)
                try self.value10?.encode(to: encoder)
                try self.value11?.encode(to: encoder)
                try self.value12?.encode(to: encoder)
                try self.value13?.encode(to: encoder)
                try self.value14?.encode(to: encoder)
                try self.value15?.encode(to: encoder)
                try self.value16?.encode(to: encoder)
                try self.value17?.encode(to: encoder)
                try self.value18?.encode(to: encoder)
                try self.value19?.encode(to: encoder)
                try self.value20?.encode(to: encoder)
                try self.value21?.encode(to: encoder)
                try self.value22?.encode(to: encoder)
            }
        }
        /// A collection of related issues and pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/milestone`.
        public struct Milestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/milestone/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestone/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestone/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestone/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/milestone/node_id`.
            public var nodeId: Swift.String
            /// The number of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/milestone/number`.
            public var number: Swift.Int
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/milestone/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/milestone/state`.
            public var state: Components.Schemas.Milestone.StatePayload
            /// The title of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/milestone/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/milestone/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/milestone/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/milestone/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/milestone/closed_issues`.
            public var closedIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/milestone/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/milestone/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/milestone/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/milestone/due_on`.
            public var dueOn: Foundation.Date?
            /// Creates a new `Milestone`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - htmlUrl:
            ///   - labelsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number: The number of the milestone.
            ///   - state: The state of the milestone.
            ///   - title: The title of the milestone.
            ///   - description:
            ///   - creator:
            ///   - openIssues:
            ///   - closedIssues:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - dueOn:
            public init(
                url: Swift.String,
                htmlUrl: Swift.String,
                labelsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.Milestone.StatePayload,
                title: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                openIssues: Swift.Int,
                closedIssues: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                dueOn: Foundation.Date? = nil
            ) {
                self.url = url
                self.htmlUrl = htmlUrl
                self.labelsUrl = labelsUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.state = state
                self.title = title
                self.description = description
                self.creator = creator
                self.openIssues = openIssues
                self.closedIssues = closedIssues
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.dueOn = dueOn
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case htmlUrl = "html_url"
                case labelsUrl = "labels_url"
                case id
                case nodeId = "node_id"
                case number
                case state
                case title
                case description
                case creator
                case openIssues = "open_issues"
                case closedIssues = "closed_issues"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case dueOn = "due_on"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/since`.
        public typealias Since = Foundation.Date
        /// The unique identifier of the comment.
        ///
        /// - Remark: Generated from `#/components/parameters/comment-id`.
        public typealias CommentId = Swift.Int64
        /// A list of comma separated label names. Example: `bug,ui,@high`
        ///
        /// - Remark: Generated from `#/components/parameters/labels`.
        public typealias Labels = Swift.String
        /// The property to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/sort`.
        @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
            case created = "created"
            case updated = "updated"
        }
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The number that identifies the issue.
        ///
        /// - Remark: Generated from `#/components/parameters/issue-number`.
        public typealias IssueNumber = Swift.Int
        /// The number that identifies the milestone.
        ///
        /// - Remark: Generated from `#/components/parameters/milestone-number`.
        public typealias MilestoneNumber = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
        public struct MovedPermanently: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/moved_permanently/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/moved_permanently/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.MovedPermanently.Body
            /// Creates a new `MovedPermanently`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.MovedPermanently.Body) {
                self.body = body
            }
        }
        public struct Gone: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/gone/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/gone/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Gone.Body
            /// Creates a new `Gone`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Gone.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List issues assigned to the authenticated user
    ///
    /// List issues assigned to the authenticated user across all visible repositories including owned repositories, member
    /// repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
    /// necessarily assigned to you.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /issues`.
    /// - Remark: Generated from `#/paths//issues/get(issues/list)`.
    public enum IssuesList {
        public static let id: Swift.String = "issues/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/issues/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/issues/GET/query/filter`.
                @frozen public enum FilterPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case assigned = "assigned"
                    case created = "created"
                    case mentioned = "mentioned"
                    case subscribed = "subscribed"
                    case repos = "repos"
                    case all = "all"
                }
                /// Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation.
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/filter`.
                public var filter: Operations.IssuesList.Input.Query.FilterPayload?
                /// - Remark: Generated from `#/paths/issues/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the issues to return.
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/state`.
                public var state: Operations.IssuesList.Input.Query.StatePayload?
                /// A list of comma separated label names. Example: `bug,ui,@high`
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/labels`.
                public var labels: Components.Parameters.Labels?
                /// - Remark: Generated from `#/paths/issues/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case comments = "comments"
                }
                /// What to sort results by.
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/sort`.
                public var sort: Operations.IssuesList.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// - Remark: Generated from `#/paths/issues/GET/query/collab`.
                public var collab: Swift.Bool?
                /// - Remark: Generated from `#/paths/issues/GET/query/orgs`.
                public var orgs: Swift.Bool?
                /// - Remark: Generated from `#/paths/issues/GET/query/owned`.
                public var owned: Swift.Bool?
                /// - Remark: Generated from `#/paths/issues/GET/query/pulls`.
                public var pulls: Swift.Bool?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/issues/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - filter: Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation.
                ///   - state: Indicates the state of the issues to return.
                ///   - labels: A list of comma separated label names. Example: `bug,ui,@high`
                ///   - sort: What to sort results by.
                ///   - direction: The direction to sort the results by.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - collab:
                ///   - orgs:
                ///   - owned:
                ///   - pulls:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    filter: Operations.IssuesList.Input.Query.FilterPayload? = nil,
                    state: Operations.IssuesList.Input.Query.StatePayload? = nil,
                    labels: Components.Parameters.Labels? = nil,
                    sort: Operations.IssuesList.Input.Query.SortPayload? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    since: Components.Parameters.Since? = nil,
                    collab: Swift.Bool? = nil,
                    orgs: Swift.Bool? = nil,
                    owned: Swift.Bool? = nil,
                    pulls: Swift.Bool? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.filter = filter
                    self.state = state
                    self.labels = labels
                    self.sort = sort
                    self.direction = direction
                    self.since = since
                    self.collab = collab
                    self.orgs = orgs
                    self.owned = owned
                    self.pulls = pulls
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesList.Input.Query
            /// - Remark: Generated from `#/paths/issues/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.IssuesList.Input.Query = .init(),
                headers: Operations.IssuesList.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/issues/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/issues/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/issues/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/issues/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Issue])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Issue] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesList.Output.Ok.Headers = .init(),
                    body: Operations.IssuesList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//issues/get(issues/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//issues/get(issues/list)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//issues/get(issues/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//issues/get(issues/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//issues/get(issues/list)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization issues assigned to the authenticated user
    ///
    /// List issues in an organization assigned to the authenticated user.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/issues`.
    /// - Remark: Generated from `#/paths//orgs/{org}/issues/get(issues/list-for-org)`.
    public enum IssuesListForOrg {
        public static let id: Swift.String = "issues/list-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.IssuesListForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/filter`.
                @frozen public enum FilterPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case assigned = "assigned"
                    case created = "created"
                    case mentioned = "mentioned"
                    case subscribed = "subscribed"
                    case repos = "repos"
                    case all = "all"
                }
                /// Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/filter`.
                public var filter: Operations.IssuesListForOrg.Input.Query.FilterPayload?
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the issues to return.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/state`.
                public var state: Operations.IssuesListForOrg.Input.Query.StatePayload?
                /// A list of comma separated label names. Example: `bug,ui,@high`
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/labels`.
                public var labels: Components.Parameters.Labels?
                /// Can be the name of an issue type.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/type`.
                public var _type: Swift.String?
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case comments = "comments"
                }
                /// What to sort results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/sort`.
                public var sort: Operations.IssuesListForOrg.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - filter: Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation.
                ///   - state: Indicates the state of the issues to return.
                ///   - labels: A list of comma separated label names. Example: `bug,ui,@high`
                ///   - _type: Can be the name of an issue type.
                ///   - sort: What to sort results by.
                ///   - direction: The direction to sort the results by.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    filter: Operations.IssuesListForOrg.Input.Query.FilterPayload? = nil,
                    state: Operations.IssuesListForOrg.Input.Query.StatePayload? = nil,
                    labels: Components.Parameters.Labels? = nil,
                    _type: Swift.String? = nil,
                    sort: Operations.IssuesListForOrg.Input.Query.SortPayload? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.filter = filter
                    self.state = state
                    self.labels = labels
                    self._type = _type
                    self.sort = sort
                    self.direction = direction
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListForOrg.Input.Path,
                query: Operations.IssuesListForOrg.Input.Query = .init(),
                headers: Operations.IssuesListForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/issues/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Issue])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Issue] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListForOrg.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issues/get(issues/list-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/issues/get(issues/list-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List assignees
    ///
    /// Lists the [available assignees](https://docs.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/get(issues/list-assignees)`.
    public enum IssuesListAssignees {
        public static let id: Swift.String = "issues/list-assignees"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesListAssignees.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListAssignees.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListAssignees.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListAssignees.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListAssignees.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListAssignees.Input.Path,
                query: Operations.IssuesListAssignees.Input.Query = .init(),
                headers: Operations.IssuesListAssignees.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListAssignees.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListAssignees.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListAssignees.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListAssignees.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/get(issues/list-assignees)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListAssignees.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListAssignees.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/get(issues/list-assignees)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a user can be assigned
    ///
    /// Checks if a user has permission to be assigned to an issue in this repository.
    ///
    /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
    ///
    /// Otherwise a `404` status code is returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/assignees/{assignee}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/{assignee}/get(issues/check-user-can-be-assigned)`.
    public enum IssuesCheckUserCanBeAssigned {
        public static let id: Swift.String = "issues/check-user-can-be-assigned"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/path/assignee`.
                public var assignee: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - assignee:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    assignee: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.assignee = assignee
                }
            }
            public var path: Operations.IssuesCheckUserCanBeAssigned.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCheckUserCanBeAssigned.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCheckUserCanBeAssigned.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesCheckUserCanBeAssigned.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesCheckUserCanBeAssigned.Input.Path,
                headers: Operations.IssuesCheckUserCanBeAssigned.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/{assignee}/get(issues/check-user-can-be-assigned)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesCheckUserCanBeAssigned.Output.NoContent)
            /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/{assignee}/get(issues/check-user-can-be-assigned)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesCheckUserCanBeAssigned.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/assignees/{assignee}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesCheckUserCanBeAssigned.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesCheckUserCanBeAssigned.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// Otherwise a `404` status code is returned.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/assignees/{assignee}/get(issues/check-user-can-be-assigned)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.IssuesCheckUserCanBeAssigned.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.IssuesCheckUserCanBeAssigned.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository issues
    ///
    /// List issues in a repository. Only open issues will be listed.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)`.
    public enum IssuesListForRepo {
        public static let id: Swift.String = "issues/list-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesListForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query`.
            public struct Query: Sendable, Hashable {
                /// If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/milestone`.
                public var milestone: Swift.String?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the issues to return.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/state`.
                public var state: Operations.IssuesListForRepo.Input.Query.StatePayload?
                /// Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/assignee`.
                public var assignee: Swift.String?
                /// Can be the name of an issue type. If the string `*` is passed, issues with any type are accepted. If the string `none` is passed, issues without type are returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/type`.
                public var _type: Swift.String?
                /// The user that created the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/creator`.
                public var creator: Swift.String?
                /// A user that's mentioned in the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/mentioned`.
                public var mentioned: Swift.String?
                /// A list of comma separated label names. Example: `bug,ui,@high`
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/labels`.
                public var labels: Components.Parameters.Labels?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case comments = "comments"
                }
                /// What to sort results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/sort`.
                public var sort: Operations.IssuesListForRepo.Input.Query.SortPayload?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - milestone: If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
                ///   - state: Indicates the state of the issues to return.
                ///   - assignee: Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
                ///   - _type: Can be the name of an issue type. If the string `*` is passed, issues with any type are accepted. If the string `none` is passed, issues without type are returned.
                ///   - creator: The user that created the issue.
                ///   - mentioned: A user that's mentioned in the issue.
                ///   - labels: A list of comma separated label names. Example: `bug,ui,@high`
                ///   - sort: What to sort results by.
                ///   - direction: The direction to sort the results by.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    milestone: Swift.String? = nil,
                    state: Operations.IssuesListForRepo.Input.Query.StatePayload? = nil,
                    assignee: Swift.String? = nil,
                    _type: Swift.String? = nil,
                    creator: Swift.String? = nil,
                    mentioned: Swift.String? = nil,
                    labels: Components.Parameters.Labels? = nil,
                    sort: Operations.IssuesListForRepo.Input.Query.SortPayload? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.milestone = milestone
                    self.state = state
                    self.assignee = assignee
                    self._type = _type
                    self.creator = creator
                    self.mentioned = mentioned
                    self.labels = labels
                    self.sort = sort
                    self.direction = direction
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListForRepo.Input.Path,
                query: Operations.IssuesListForRepo.Input.Query = .init(),
                headers: Operations.IssuesListForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Issue])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Issue] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListForRepo.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/get(issues/list-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an issue
    ///
    /// Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://docs.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)`.
    public enum IssuesCreate {
        public static let id: Swift.String = "issues/create"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesCreate.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesCreate.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The title of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/title`.
                    @frozen public enum TitlePayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/title/case1`.
                        case case1(Swift.String)
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/title/case2`.
                        case case2(Swift.Int)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try encoder.encodeToSingleValueContainer(value)
                            }
                        }
                    }
                    /// The title of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/title`.
                    public var title: Operations.IssuesCreate.Input.Body.JsonPayload.TitlePayload
                    /// The contents of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is closing down.**_
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/assignee`.
                    public var assignee: Swift.String?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/milestone`.
                    @frozen public enum MilestonePayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/milestone/case1`.
                        case case1(Swift.String)
                        /// The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/milestone/case2`.
                        case case2(Swift.Int)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try encoder.encodeToSingleValueContainer(value)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/milestone`.
                    public var milestone: Operations.IssuesCreate.Input.Body.JsonPayload.MilestonePayload?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload`.
                    @frozen public enum LabelsPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case1`.
                        case case1(Swift.String)
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case2`.
                        public struct Case2Payload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case2/id`.
                            public var id: Swift.Int?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case2/name`.
                            public var name: Swift.String?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case2/description`.
                            public var description: Swift.String?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case2/color`.
                            public var color: Swift.String?
                            /// Creates a new `Case2Payload`.
                            ///
                            /// - Parameters:
                            ///   - id:
                            ///   - name:
                            ///   - description:
                            ///   - color:
                            public init(
                                id: Swift.Int? = nil,
                                name: Swift.String? = nil,
                                description: Swift.String? = nil,
                                color: Swift.String? = nil
                            ) {
                                self.id = id
                                self.name = name
                                self.description = description
                                self.color = color
                            }
                            public enum CodingKeys: String, CodingKey {
                                case id
                                case name
                                case description
                                case color
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/LabelsPayload/case2`.
                        case case2(Operations.IssuesCreate.Input.Body.JsonPayload.LabelsPayloadPayload.Case2Payload)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/labels`.
                    public typealias LabelsPayload = [Operations.IssuesCreate.Input.Body.JsonPayload.LabelsPayloadPayload]
                    /// Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/labels`.
                    public var labels: Operations.IssuesCreate.Input.Body.JsonPayload.LabelsPayload?
                    /// Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/assignees`.
                    public var assignees: [Swift.String]?
                    /// The name of the issue type to associate with this issue. _NOTE: Only users with push access can set the type for new issues. The type is silently dropped otherwise._
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/json/type`.
                    public var _type: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The title of the issue.
                    ///   - body: The contents of the issue.
                    ///   - assignee: Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is closing down.**_
                    ///   - milestone:
                    ///   - labels: Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
                    ///   - assignees: Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
                    ///   - _type: The name of the issue type to associate with this issue. _NOTE: Only users with push access can set the type for new issues. The type is silently dropped otherwise._
                    public init(
                        title: Operations.IssuesCreate.Input.Body.JsonPayload.TitlePayload,
                        body: Swift.String? = nil,
                        assignee: Swift.String? = nil,
                        milestone: Operations.IssuesCreate.Input.Body.JsonPayload.MilestonePayload? = nil,
                        labels: Operations.IssuesCreate.Input.Body.JsonPayload.LabelsPayload? = nil,
                        assignees: [Swift.String]? = nil,
                        _type: Swift.String? = nil
                    ) {
                        self.title = title
                        self.body = body
                        self.assignee = assignee
                        self.milestone = milestone
                        self.labels = labels
                        self.assignees = assignees
                        self._type = _type
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                        case assignee
                        case milestone
                        case labels
                        case assignees
                        case _type = "type"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesCreate.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesCreate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesCreate.Input.Path,
                headers: Operations.IssuesCreate.Input.Headers = .init(),
                body: Operations.IssuesCreate.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesCreate.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesCreate.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesCreate.Output.Created.Headers = .init(),
                    body: Operations.IssuesCreate.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.IssuesCreate.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.IssuesCreate.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/post(issues/create)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List issue comments for a repository
    ///
    /// You can use the REST API to list comments on issues and pull requests for a repository. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// By default, issue comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/get(issues/list-comments-for-repo)`.
    public enum IssuesListCommentsForRepo {
        public static let id: Swift.String = "issues/list-comments-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesListCommentsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/sort`.
                @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query/sort`.
                public var sort: Components.Parameters.Sort?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Either `asc` or `desc`. Ignored without the `sort` parameter.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query/direction`.
                public var direction: Operations.IssuesListCommentsForRepo.Input.Query.DirectionPayload?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort: The property to sort the results by.
                ///   - direction: Either `asc` or `desc`. Ignored without the `sort` parameter.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Components.Parameters.Sort? = nil,
                    direction: Operations.IssuesListCommentsForRepo.Input.Query.DirectionPayload? = nil,
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListCommentsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListCommentsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListCommentsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListCommentsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListCommentsForRepo.Input.Path,
                query: Operations.IssuesListCommentsForRepo.Input.Query = .init(),
                headers: Operations.IssuesListCommentsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListCommentsForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.IssueComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.IssueComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListCommentsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListCommentsForRepo.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListCommentsForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/get(issues/list-comments-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListCommentsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListCommentsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/get(issues/list-comments-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/get(issues/list-comments-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an issue comment
    ///
    /// You can use the REST API to get comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/get(issues/get-comment)`.
    public enum IssuesGetComment {
        public static let id: Swift.String = "issues/get-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.IssuesGetComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesGetComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesGetComment.Input.Path,
                headers: Operations.IssuesGetComment.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.IssueComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.IssueComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesGetComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesGetComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/get(issues/get-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesGetComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesGetComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/get(issues/get-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an issue comment
    ///
    /// You can use the REST API to update comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/patch(issues/update-comment)`.
    public enum IssuesUpdateComment {
        public static let id: Swift.String = "issues/update-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.IssuesUpdateComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdateComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdateComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesUpdateComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The contents of the comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The contents of the comment.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.IssuesUpdateComment.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesUpdateComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesUpdateComment.Input.Path,
                headers: Operations.IssuesUpdateComment.Input.Headers = .init(),
                body: Operations.IssuesUpdateComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.IssueComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.IssueComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesUpdateComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesUpdateComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/patch(issues/update-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesUpdateComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesUpdateComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/patch(issues/update-comment)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an issue comment
    ///
    /// You can use the REST API to delete comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/delete(issues/delete-comment)`.
    public enum IssuesDeleteComment {
        public static let id: Swift.String = "issues/delete-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/DELETE/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.IssuesDeleteComment.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.IssuesDeleteComment.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/delete(issues/delete-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesDeleteComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/delete(issues/delete-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesDeleteComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List issue events for a repository
    ///
    /// Lists events for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/get(issues/list-events-for-repo)`.
    public enum IssuesListEventsForRepo {
        public static let id: Swift.String = "issues/list-events-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesListEventsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListEventsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListEventsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListEventsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListEventsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListEventsForRepo.Input.Path,
                query: Operations.IssuesListEventsForRepo.Input.Query = .init(),
                headers: Operations.IssuesListEventsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListEventsForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.IssueEvent])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.IssueEvent] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListEventsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListEventsForRepo.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListEventsForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/get(issues/list-events-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListEventsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListEventsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/get(issues/list-events-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an issue event
    ///
    /// Gets a single event by the event id.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/events/{event_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)`.
    public enum IssuesGetEvent {
        public static let id: Swift.String = "issues/get-event"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/path/event_id`.
                public var eventId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - eventId:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    eventId: Swift.Int
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.eventId = eventId
                }
            }
            public var path: Operations.IssuesGetEvent.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetEvent.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetEvent.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesGetEvent.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesGetEvent.Input.Path,
                headers: Operations.IssuesGetEvent.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/events/{event_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.IssueEvent)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.IssueEvent {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesGetEvent.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesGetEvent.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesGetEvent.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesGetEvent.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/events/{event_id}/get(issues/get-event)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an issue
    ///
    /// The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api#follow-redirects) if the issue was
    /// [transferred](https://docs.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
    /// the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
    /// returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
    /// access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
    /// to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
    ///
    /// > [!NOTE]
    /// > GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/pulls/pulls#list-pull-requests)" endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)`.
    public enum IssuesGet {
        public static let id: Swift.String = "issues/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesGet.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesGet.Input.Path,
                headers: Operations.IssuesGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/get(issues/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an issue
    ///
    /// Issue owners and users with push access or Triage role can edit an issue.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/{issue_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)`.
    public enum IssuesUpdate {
        public static let id: Swift.String = "issues/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesUpdate.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The title of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/title`.
                    @frozen public enum TitlePayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/title/case1`.
                        case case1(Swift.String)
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/title/case2`.
                        case case2(Swift.Int)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try encoder.encodeToSingleValueContainer(value)
                            }
                        }
                    }
                    /// The title of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/title`.
                    public var title: Operations.IssuesUpdate.Input.Body.JsonPayload.TitlePayload?
                    /// The contents of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Username to assign to this issue. **This field is closing down.**
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/assignee`.
                    public var assignee: Swift.String?
                    /// The open or closed state of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/state`.
                    @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case open = "open"
                        case closed = "closed"
                    }
                    /// The open or closed state of the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/state`.
                    public var state: Operations.IssuesUpdate.Input.Body.JsonPayload.StatePayload?
                    /// The reason for the state change. Ignored unless `state` is changed.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/state_reason`.
                    @frozen public enum StateReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case completed = "completed"
                        case notPlanned = "not_planned"
                        case duplicate = "duplicate"
                        case reopened = "reopened"
                    }
                    /// The reason for the state change. Ignored unless `state` is changed.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/state_reason`.
                    public var stateReason: Operations.IssuesUpdate.Input.Body.JsonPayload.StateReasonPayload?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/milestone`.
                    @frozen public enum MilestonePayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/milestone/case1`.
                        case case1(Swift.String)
                        /// The `number` of the milestone to associate this issue with or use `null` to remove the current milestone. Only users with push access can set the milestone for issues. Without push access to the repository, milestone changes are silently dropped.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/milestone/case2`.
                        case case2(Swift.Int)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try encoder.encodeToSingleValueContainer(value)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/milestone`.
                    public var milestone: Operations.IssuesUpdate.Input.Body.JsonPayload.MilestonePayload?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload`.
                    @frozen public enum LabelsPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case1`.
                        case case1(Swift.String)
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case2`.
                        public struct Case2Payload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case2/id`.
                            public var id: Swift.Int?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case2/name`.
                            public var name: Swift.String?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case2/description`.
                            public var description: Swift.String?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case2/color`.
                            public var color: Swift.String?
                            /// Creates a new `Case2Payload`.
                            ///
                            /// - Parameters:
                            ///   - id:
                            ///   - name:
                            ///   - description:
                            ///   - color:
                            public init(
                                id: Swift.Int? = nil,
                                name: Swift.String? = nil,
                                description: Swift.String? = nil,
                                color: Swift.String? = nil
                            ) {
                                self.id = id
                                self.name = name
                                self.description = description
                                self.color = color
                            }
                            public enum CodingKeys: String, CodingKey {
                                case id
                                case name
                                case description
                                case color
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/LabelsPayload/case2`.
                        case case2(Operations.IssuesUpdate.Input.Body.JsonPayload.LabelsPayloadPayload.Case2Payload)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// Labels to associate with this issue. Pass one or more labels to _replace_ the set of labels on this issue. Send an empty array (`[]`) to clear all labels from the issue. Only users with push access can set labels for issues. Without push access to the repository, label changes are silently dropped.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/labels`.
                    public typealias LabelsPayload = [Operations.IssuesUpdate.Input.Body.JsonPayload.LabelsPayloadPayload]
                    /// Labels to associate with this issue. Pass one or more labels to _replace_ the set of labels on this issue. Send an empty array (`[]`) to clear all labels from the issue. Only users with push access can set labels for issues. Without push access to the repository, label changes are silently dropped.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/labels`.
                    public var labels: Operations.IssuesUpdate.Input.Body.JsonPayload.LabelsPayload?
                    /// Usernames to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this issue. Send an empty array (`[]`) to clear all assignees from the issue. Only users with push access can set assignees for new issues. Without push access to the repository, assignee changes are silently dropped.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/assignees`.
                    public var assignees: [Swift.String]?
                    /// The name of the issue type to associate with this issue or use `null` to remove the current issue type. Only users with push access can set the type for issues. Without push access to the repository, type changes are silently dropped.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/json/type`.
                    public var _type: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The title of the issue.
                    ///   - body: The contents of the issue.
                    ///   - assignee: Username to assign to this issue. **This field is closing down.**
                    ///   - state: The open or closed state of the issue.
                    ///   - stateReason: The reason for the state change. Ignored unless `state` is changed.
                    ///   - milestone:
                    ///   - labels: Labels to associate with this issue. Pass one or more labels to _replace_ the set of labels on this issue. Send an empty array (`[]`) to clear all labels from the issue. Only users with push access can set labels for issues. Without push access to the repository, label changes are silently dropped.
                    ///   - assignees: Usernames to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this issue. Send an empty array (`[]`) to clear all assignees from the issue. Only users with push access can set assignees for new issues. Without push access to the repository, assignee changes are silently dropped.
                    ///   - _type: The name of the issue type to associate with this issue or use `null` to remove the current issue type. Only users with push access can set the type for issues. Without push access to the repository, type changes are silently dropped.
                    public init(
                        title: Operations.IssuesUpdate.Input.Body.JsonPayload.TitlePayload? = nil,
                        body: Swift.String? = nil,
                        assignee: Swift.String? = nil,
                        state: Operations.IssuesUpdate.Input.Body.JsonPayload.StatePayload? = nil,
                        stateReason: Operations.IssuesUpdate.Input.Body.JsonPayload.StateReasonPayload? = nil,
                        milestone: Operations.IssuesUpdate.Input.Body.JsonPayload.MilestonePayload? = nil,
                        labels: Operations.IssuesUpdate.Input.Body.JsonPayload.LabelsPayload? = nil,
                        assignees: [Swift.String]? = nil,
                        _type: Swift.String? = nil
                    ) {
                        self.title = title
                        self.body = body
                        self.assignee = assignee
                        self.state = state
                        self.stateReason = stateReason
                        self.milestone = milestone
                        self.labels = labels
                        self.assignees = assignees
                        self._type = _type
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                        case assignee
                        case state
                        case stateReason = "state_reason"
                        case milestone
                        case labels
                        case assignees
                        case _type = "type"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.IssuesUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesUpdate.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesUpdate.Input.Path,
                headers: Operations.IssuesUpdate.Input.Headers = .init(),
                body: Operations.IssuesUpdate.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/patch(issues/update)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add assignees to an issue
    ///
    /// Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/post(issues/add-assignees)`.
    public enum IssuesAddAssignees {
        public static let id: Swift.String = "issues/add-assignees"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesAddAssignees.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesAddAssignees.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesAddAssignees.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesAddAssignees.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/requestBody/json/assignees`.
                    public var assignees: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - assignees: Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
                    public init(assignees: [Swift.String]? = nil) {
                        self.assignees = assignees
                    }
                    public enum CodingKeys: String, CodingKey {
                        case assignees
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesAddAssignees.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesAddAssignees.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesAddAssignees.Input.Path,
                headers: Operations.IssuesAddAssignees.Input.Headers = .init(),
                body: Operations.IssuesAddAssignees.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesAddAssignees.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesAddAssignees.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/post(issues/add-assignees)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.IssuesAddAssignees.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.IssuesAddAssignees.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove assignees from an issue
    ///
    /// Removes one or more assignees from an issue.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/assignees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/delete(issues/remove-assignees)`.
    public enum IssuesRemoveAssignees {
        public static let id: Swift.String = "issues/remove-assignees"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesRemoveAssignees.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveAssignees.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveAssignees.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesRemoveAssignees.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/requestBody/json/assignees`.
                    public var assignees: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - assignees: Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
                    public init(assignees: [Swift.String]? = nil) {
                        self.assignees = assignees
                    }
                    public enum CodingKeys: String, CodingKey {
                        case assignees
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/requestBody/content/application\/json`.
                case json(Operations.IssuesRemoveAssignees.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesRemoveAssignees.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesRemoveAssignees.Input.Path,
                headers: Operations.IssuesRemoveAssignees.Input.Headers = .init(),
                body: Operations.IssuesRemoveAssignees.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesRemoveAssignees.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesRemoveAssignees.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/delete(issues/remove-assignees)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesRemoveAssignees.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesRemoveAssignees.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a user can be assigned to a issue
    ///
    /// Checks if a user has permission to be assigned to a specific issue.
    ///
    /// If the `assignee` can be assigned to this issue, a `204` status code with no content is returned.
    ///
    /// Otherwise a `404` status code is returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/get(issues/check-user-can-be-assigned-to-issue)`.
    public enum IssuesCheckUserCanBeAssignedToIssue {
        public static let id: Swift.String = "issues/check-user-can-be-assigned-to-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/path/assignee`.
                public var assignee: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                ///   - assignee:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber,
                    assignee: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                    self.assignee = assignee
                }
            }
            public var path: Operations.IssuesCheckUserCanBeAssignedToIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCheckUserCanBeAssignedToIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCheckUserCanBeAssignedToIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesCheckUserCanBeAssignedToIssue.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesCheckUserCanBeAssignedToIssue.Input.Path,
                headers: Operations.IssuesCheckUserCanBeAssignedToIssue.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response if `assignee` can be assigned to `issue_number`
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/get(issues/check-user-can-be-assigned-to-issue)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesCheckUserCanBeAssignedToIssue.Output.NoContent)
            /// Response if `assignee` can be assigned to `issue_number`
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/get(issues/check-user-can-be-assigned-to-issue)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesCheckUserCanBeAssignedToIssue.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesCheckUserCanBeAssignedToIssue.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesCheckUserCanBeAssignedToIssue.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// Response if `assignee` can not be assigned to `issue_number`
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}/get(issues/check-user-can-be-assigned-to-issue)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.IssuesCheckUserCanBeAssignedToIssue.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.IssuesCheckUserCanBeAssignedToIssue.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List issue comments
    ///
    /// You can use the REST API to list comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// Issue comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/get(issues/list-comments)`.
    public enum IssuesListComments {
        public static let id: Swift.String = "issues/list-comments"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesListComments.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListComments.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListComments.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListComments.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListComments.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListComments.Input.Path,
                query: Operations.IssuesListComments.Input.Query = .init(),
                headers: Operations.IssuesListComments.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListComments.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.IssueComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.IssueComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListComments.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListComments.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListComments.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/get(issues/list-comments)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListComments.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListComments.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/get(issues/list-comments)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/get(issues/list-comments)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an issue comment
    ///
    /// You can use the REST API to create comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    /// Creating content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)`.
    public enum IssuesCreateComment {
        public static let id: Swift.String = "issues/create-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesCreateComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreateComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreateComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesCreateComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The contents of the comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The contents of the comment.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesCreateComment.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesCreateComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesCreateComment.Input.Path,
                headers: Operations.IssuesCreateComment.Input.Headers = .init(),
                body: Operations.IssuesCreateComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesCreateComment.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/comments/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.IssueComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.IssueComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesCreateComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesCreateComment.Output.Created.Headers = .init(),
                    body: Operations.IssuesCreateComment.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.IssuesCreateComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.IssuesCreateComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/comments/post(issues/create-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List issue events
    ///
    /// Lists all events for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/events/get(issues/list-events)`.
    public enum IssuesListEvents {
        public static let id: Swift.String = "issues/list-events"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesListEvents.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListEvents.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListEvents.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListEvents.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListEvents.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListEvents.Input.Path,
                query: Operations.IssuesListEvents.Input.Query = .init(),
                headers: Operations.IssuesListEvents.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListEvents.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.IssueEventForIssue])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.IssueEventForIssue] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListEvents.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListEvents.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListEvents.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/events/get(issues/list-events)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListEvents.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListEvents.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/events/get(issues/list-events)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List labels for an issue
    ///
    /// Lists all labels for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)`.
    public enum IssuesListLabelsOnIssue {
        public static let id: Swift.String = "issues/list-labels-on-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesListLabelsOnIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListLabelsOnIssue.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListLabelsOnIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListLabelsOnIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListLabelsOnIssue.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListLabelsOnIssue.Input.Path,
                query: Operations.IssuesListLabelsOnIssue.Input.Query = .init(),
                headers: Operations.IssuesListLabelsOnIssue.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListLabelsOnIssue.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Label])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Label] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListLabelsOnIssue.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListLabelsOnIssue.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListLabelsOnIssue.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListLabelsOnIssue.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListLabelsOnIssue.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/get(issues/list-labels-on-issue)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add labels to an issue
    ///
    /// Adds labels to an issue. If you provide an empty array of labels, all labels are removed from the issue. 
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)`.
    public enum IssuesAddLabels {
        public static let id: Swift.String = "issues/add-labels"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesAddLabels.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesAddLabels.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesAddLabels.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesAddLabels.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// The names of the labels to add to the issue's existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also replace all of the labels for an issue. For more information, see "[Set labels for an issue](https://docs.github.com/rest/issues/labels#set-labels-for-an-issue)."
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case1/labels`.
                        public var labels: [Swift.String]?
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - labels: The names of the labels to add to the issue's existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also replace all of the labels for an issue. For more information, see "[Set labels for an issue](https://docs.github.com/rest/issues/labels#set-labels-for-an-issue)."
                        public init(labels: [Swift.String]? = nil) {
                            self.labels = labels
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labels
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case1`.
                    case case1(Operations.IssuesAddLabels.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case2`.
                    case case2([Swift.String])
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case3`.
                    public struct Case3Payload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case3/LabelsPayload`.
                        public struct LabelsPayloadPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case3/LabelsPayload/name`.
                            public var name: Swift.String
                            /// Creates a new `LabelsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - name:
                            public init(name: Swift.String) {
                                self.name = name
                            }
                            public enum CodingKeys: String, CodingKey {
                                case name
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case3/labels`.
                        public typealias LabelsPayload = [Operations.IssuesAddLabels.Input.Body.JsonPayload.Case3Payload.LabelsPayloadPayload]
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case3/labels`.
                        public var labels: Operations.IssuesAddLabels.Input.Body.JsonPayload.Case3Payload.LabelsPayload?
                        /// Creates a new `Case3Payload`.
                        ///
                        /// - Parameters:
                        ///   - labels:
                        public init(labels: Operations.IssuesAddLabels.Input.Body.JsonPayload.Case3Payload.LabelsPayload? = nil) {
                            self.labels = labels
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labels
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case3`.
                    case case3(Operations.IssuesAddLabels.Input.Body.JsonPayload.Case3Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/Case4Payload`.
                    public struct Case4PayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/Case4Payload/name`.
                        public var name: Swift.String
                        /// Creates a new `Case4PayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - name:
                        public init(name: Swift.String) {
                            self.name = name
                        }
                        public enum CodingKeys: String, CodingKey {
                            case name
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case4`.
                    public typealias Case4Payload = [Operations.IssuesAddLabels.Input.Body.JsonPayload.Case4PayloadPayload]
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case4`.
                    case case4(Operations.IssuesAddLabels.Input.Body.JsonPayload.Case4Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/json/case5`.
                    case case5(Swift.String)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case4(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case5(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try value.encode(to: encoder)
                        case let .case4(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case5(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesAddLabels.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesAddLabels.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesAddLabels.Input.Path,
                headers: Operations.IssuesAddLabels.Input.Headers = .init(),
                body: Operations.IssuesAddLabels.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/POST/responses/200/content/application\/json`.
                    case json([Components.Schemas.Label])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Label] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesAddLabels.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesAddLabels.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesAddLabels.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesAddLabels.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/post(issues/add-labels)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set labels for an issue
    ///
    /// Removes any previous labels and sets the new labels for an issue.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)`.
    public enum IssuesSetLabels {
        public static let id: Swift.String = "issues/set-labels"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesSetLabels.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesSetLabels.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesSetLabels.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesSetLabels.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// The names of the labels to set for the issue. The labels you set replace any existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also add labels to the existing labels for an issue. For more information, see "[Add labels to an issue](https://docs.github.com/rest/issues/labels#add-labels-to-an-issue)."
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case1/labels`.
                        public var labels: [Swift.String]?
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - labels: The names of the labels to set for the issue. The labels you set replace any existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also add labels to the existing labels for an issue. For more information, see "[Add labels to an issue](https://docs.github.com/rest/issues/labels#add-labels-to-an-issue)."
                        public init(labels: [Swift.String]? = nil) {
                            self.labels = labels
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labels
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case1`.
                    case case1(Operations.IssuesSetLabels.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case2`.
                    case case2([Swift.String])
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case3`.
                    public struct Case3Payload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case3/LabelsPayload`.
                        public struct LabelsPayloadPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case3/LabelsPayload/name`.
                            public var name: Swift.String
                            /// Creates a new `LabelsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - name:
                            public init(name: Swift.String) {
                                self.name = name
                            }
                            public enum CodingKeys: String, CodingKey {
                                case name
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case3/labels`.
                        public typealias LabelsPayload = [Operations.IssuesSetLabels.Input.Body.JsonPayload.Case3Payload.LabelsPayloadPayload]
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case3/labels`.
                        public var labels: Operations.IssuesSetLabels.Input.Body.JsonPayload.Case3Payload.LabelsPayload?
                        /// Creates a new `Case3Payload`.
                        ///
                        /// - Parameters:
                        ///   - labels:
                        public init(labels: Operations.IssuesSetLabels.Input.Body.JsonPayload.Case3Payload.LabelsPayload? = nil) {
                            self.labels = labels
                        }
                        public enum CodingKeys: String, CodingKey {
                            case labels
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case3`.
                    case case3(Operations.IssuesSetLabels.Input.Body.JsonPayload.Case3Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/Case4Payload`.
                    public struct Case4PayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/Case4Payload/name`.
                        public var name: Swift.String
                        /// Creates a new `Case4PayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - name:
                        public init(name: Swift.String) {
                            self.name = name
                        }
                        public enum CodingKeys: String, CodingKey {
                            case name
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case4`.
                    public typealias Case4Payload = [Operations.IssuesSetLabels.Input.Body.JsonPayload.Case4PayloadPayload]
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case4`.
                    case case4(Operations.IssuesSetLabels.Input.Body.JsonPayload.Case4Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/json/case5`.
                    case case5(Swift.String)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case4(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case5(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try value.encode(to: encoder)
                        case let .case4(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case5(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/requestBody/content/application\/json`.
                case json(Operations.IssuesSetLabels.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesSetLabels.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesSetLabels.Input.Path,
                headers: Operations.IssuesSetLabels.Input.Headers = .init(),
                body: Operations.IssuesSetLabels.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/PUT/responses/200/content/application\/json`.
                    case json([Components.Schemas.Label])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Label] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesSetLabels.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesSetLabels.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesSetLabels.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesSetLabels.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/put(issues/set-labels)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove all labels from an issue
    ///
    /// Removes all labels from an issue.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)`.
    public enum IssuesRemoveAllLabels {
        public static let id: Swift.String = "issues/remove-all-labels"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/DELETE/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesRemoveAllLabels.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveAllLabels.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveAllLabels.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesRemoveAllLabels.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesRemoveAllLabels.Input.Path,
                headers: Operations.IssuesRemoveAllLabels.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesRemoveAllLabels.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesRemoveAllLabels.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/delete(issues/remove-all-labels)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a label from an issue
    ///
    /// Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)`.
    public enum IssuesRemoveLabel {
        public static let id: Swift.String = "issues/remove-label"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/path/name`.
                public var name: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                ///   - name:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber,
                    name: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                    self.name = name
                }
            }
            public var path: Operations.IssuesRemoveLabel.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveLabel.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveLabel.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesRemoveLabel.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesRemoveLabel.Input.Path,
                headers: Operations.IssuesRemoveLabel.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/DELETE/responses/200/content/application\/json`.
                    case json([Components.Schemas.Label])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Label] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesRemoveLabel.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesRemoveLabel.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesRemoveLabel.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesRemoveLabel.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/labels/{name}/delete(issues/remove-label)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Lock an issue
    ///
    /// Users with push access can lock an issue or pull request's conversation.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/issues/{issue_number}/lock`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)`.
    public enum IssuesLock {
        public static let id: Swift.String = "issues/lock"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesLock.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesLock.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesLock.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesLock.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:  
                    ///  * `off-topic`  
                    ///  * `too heated`  
                    ///  * `resolved`  
                    ///  * `spam`
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/requestBody/json/lock_reason`.
                    @frozen public enum LockReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case offTopic = "off-topic"
                        case tooHeated = "too heated"
                        case resolved = "resolved"
                        case spam = "spam"
                    }
                    /// The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:  
                    ///  * `off-topic`  
                    ///  * `too heated`  
                    ///  * `resolved`  
                    ///  * `spam`
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/requestBody/json/lock_reason`.
                    public var lockReason: Operations.IssuesLock.Input.Body.JsonPayload.LockReasonPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - lockReason: The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:  
                    public init(lockReason: Operations.IssuesLock.Input.Body.JsonPayload.LockReasonPayload? = nil) {
                        self.lockReason = lockReason
                    }
                    public enum CodingKeys: String, CodingKey {
                        case lockReason = "lock_reason"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/PUT/requestBody/content/application\/json`.
                case json(Operations.IssuesLock.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesLock.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesLock.Input.Path,
                headers: Operations.IssuesLock.Input.Headers = .init(),
                body: Operations.IssuesLock.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesLock.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesLock.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/put(issues/lock)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unlock an issue
    ///
    /// Users with push access can unlock an issue's conversation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/lock`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)`.
    public enum IssuesUnlock {
        public static let id: Swift.String = "issues/unlock"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/DELETE/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesUnlock.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/lock/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUnlock.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUnlock.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesUnlock.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesUnlock.Input.Path,
                headers: Operations.IssuesUnlock.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesUnlock.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesUnlock.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/lock/delete(issues/unlock)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove sub-issue
    ///
    /// You can use the REST API to remove a sub-issue from an issue.
    /// Removing content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass a specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/sub_issue`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issue/delete(issues/remove-sub-issue)`.
    public enum IssuesRemoveSubIssue {
        public static let id: Swift.String = "issues/remove-sub-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesRemoveSubIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveSubIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesRemoveSubIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesRemoveSubIssue.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The id of the sub-issue to remove
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/requestBody/json/sub_issue_id`.
                    public var subIssueId: Swift.Int
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - subIssueId: The id of the sub-issue to remove
                    public init(subIssueId: Swift.Int) {
                        self.subIssueId = subIssueId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case subIssueId = "sub_issue_id"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/requestBody/content/application\/json`.
                case json(Operations.IssuesRemoveSubIssue.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesRemoveSubIssue.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesRemoveSubIssue.Input.Path,
                headers: Operations.IssuesRemoveSubIssue.Input.Headers = .init(),
                body: Operations.IssuesRemoveSubIssue.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/responses/200/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesRemoveSubIssue.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issue/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesRemoveSubIssue.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesRemoveSubIssue.Output.Ok.Headers = .init(),
                    body: Operations.IssuesRemoveSubIssue.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issue/delete(issues/remove-sub-issue)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesRemoveSubIssue.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesRemoveSubIssue.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issue/delete(issues/remove-sub-issue)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issue/delete(issues/remove-sub-issue)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List sub-issues
    ///
    /// You can use the REST API to list the sub-issues on an issue.
    ///
    /// This endpoint supports the following custom media types. For more information, see [Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types).
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw Markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the Markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's Markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/sub_issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/get(issues/list-sub-issues)`.
    public enum IssuesListSubIssues {
        public static let id: Swift.String = "issues/list-sub-issues"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesListSubIssues.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListSubIssues.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListSubIssues.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListSubIssues.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListSubIssues.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListSubIssues.Input.Path,
                query: Operations.IssuesListSubIssues.Input.Query = .init(),
                headers: Operations.IssuesListSubIssues.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListSubIssues.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Issue])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Issue] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListSubIssues.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListSubIssues.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListSubIssues.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/get(issues/list-sub-issues)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListSubIssues.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListSubIssues.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/get(issues/list-sub-issues)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/get(issues/list-sub-issues)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add sub-issue
    ///
    /// You can use the REST API to add sub-issues to issues.
    ///
    /// Creating content too quickly using this endpoint may result in secondary rate limiting.
    /// For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/sub_issues`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)`.
    public enum IssuesAddSubIssue {
        public static let id: Swift.String = "issues/add-sub-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesAddSubIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesAddSubIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesAddSubIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesAddSubIssue.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The id of the sub-issue to add. The sub-issue must belong to the same repository owner as the parent issue
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/requestBody/json/sub_issue_id`.
                    public var subIssueId: Swift.Int
                    /// Option that, when true, instructs the operation to replace the sub-issues current parent issue
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/requestBody/json/replace_parent`.
                    public var replaceParent: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - subIssueId: The id of the sub-issue to add. The sub-issue must belong to the same repository owner as the parent issue
                    ///   - replaceParent: Option that, when true, instructs the operation to replace the sub-issues current parent issue
                    public init(
                        subIssueId: Swift.Int,
                        replaceParent: Swift.Bool? = nil
                    ) {
                        self.subIssueId = subIssueId
                        self.replaceParent = replaceParent
                    }
                    public enum CodingKeys: String, CodingKey {
                        case subIssueId = "sub_issue_id"
                        case replaceParent = "replace_parent"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesAddSubIssue.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesAddSubIssue.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesAddSubIssue.Input.Path,
                headers: Operations.IssuesAddSubIssue.Input.Headers = .init(),
                body: Operations.IssuesAddSubIssue.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesAddSubIssue.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesAddSubIssue.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesAddSubIssue.Output.Created.Headers = .init(),
                    body: Operations.IssuesAddSubIssue.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.IssuesAddSubIssue.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.IssuesAddSubIssue.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/post(issues/add-sub-issue)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Reprioritize sub-issue
    ///
    /// You can use the REST API to reprioritize a sub-issue to a different position in the parent list.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)`.
    public enum IssuesReprioritizeSubIssue {
        public static let id: Swift.String = "issues/reprioritize-sub-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesReprioritizeSubIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesReprioritizeSubIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesReprioritizeSubIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesReprioritizeSubIssue.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The id of the sub-issue to reprioritize
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/requestBody/json/sub_issue_id`.
                    public var subIssueId: Swift.Int
                    /// The id of the sub-issue to be prioritized after (either positional argument after OR before should be specified).
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/requestBody/json/after_id`.
                    public var afterId: Swift.Int?
                    /// The id of the sub-issue to be prioritized before (either positional argument after OR before should be specified).
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/requestBody/json/before_id`.
                    public var beforeId: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - subIssueId: The id of the sub-issue to reprioritize
                    ///   - afterId: The id of the sub-issue to be prioritized after (either positional argument after OR before should be specified).
                    ///   - beforeId: The id of the sub-issue to be prioritized before (either positional argument after OR before should be specified).
                    public init(
                        subIssueId: Swift.Int,
                        afterId: Swift.Int? = nil,
                        beforeId: Swift.Int? = nil
                    ) {
                        self.subIssueId = subIssueId
                        self.afterId = afterId
                        self.beforeId = beforeId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case subIssueId = "sub_issue_id"
                        case afterId = "after_id"
                        case beforeId = "before_id"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/requestBody/content/application\/json`.
                case json(Operations.IssuesReprioritizeSubIssue.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesReprioritizeSubIssue.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesReprioritizeSubIssue.Input.Path,
                headers: Operations.IssuesReprioritizeSubIssue.Input.Headers = .init(),
                body: Operations.IssuesReprioritizeSubIssue.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Issue)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Issue {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesReprioritizeSubIssue.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesReprioritizeSubIssue.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesReprioritizeSubIssue.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesReprioritizeSubIssue.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority/patch(issues/reprioritize-sub-issue)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List timeline events for an issue
    ///
    /// List all timeline events for an issue.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/timeline`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/timeline/get(issues/list-events-for-timeline)`.
    public enum IssuesListEventsForTimeline {
        public static let id: Swift.String = "issues/list-events-for-timeline"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.IssuesListEventsForTimeline.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListEventsForTimeline.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListEventsForTimeline.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListEventsForTimeline.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListEventsForTimeline.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListEventsForTimeline.Input.Path,
                query: Operations.IssuesListEventsForTimeline.Input.Query = .init(),
                headers: Operations.IssuesListEventsForTimeline.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListEventsForTimeline.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/timeline/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TimelineIssueEvents])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TimelineIssueEvents] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListEventsForTimeline.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListEventsForTimeline.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListEventsForTimeline.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/timeline/get(issues/list-events-for-timeline)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListEventsForTimeline.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListEventsForTimeline.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/timeline/get(issues/list-events-for-timeline)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/timeline/get(issues/list-events-for-timeline)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List labels for a repository
    ///
    /// Lists all labels for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/get(issues/list-labels-for-repo)`.
    public enum IssuesListLabelsForRepo {
        public static let id: Swift.String = "issues/list-labels-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesListLabelsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListLabelsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListLabelsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListLabelsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListLabelsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListLabelsForRepo.Input.Path,
                query: Operations.IssuesListLabelsForRepo.Input.Query = .init(),
                headers: Operations.IssuesListLabelsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListLabelsForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Label])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Label] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListLabelsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListLabelsForRepo.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListLabelsForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/get(issues/list-labels-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListLabelsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListLabelsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/get(issues/list-labels-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a label
    ///
    /// Creates a label for the specified repository with the given name and color. The name and color parameters are required. The color must be a valid [hexadecimal color code](http://www.color-hex.com/).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/post(issues/create-label)`.
    public enum IssuesCreateLabel {
        public static let id: Swift.String = "issues/create-label"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesCreateLabel.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreateLabel.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreateLabel.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesCreateLabel.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see "[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet)."
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/requestBody/json/color`.
                    public var color: Swift.String?
                    /// A short description of the label. Must be 100 characters or fewer.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/requestBody/json/description`.
                    public var description: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see "[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet)."
                    ///   - color: The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
                    ///   - description: A short description of the label. Must be 100 characters or fewer.
                    public init(
                        name: Swift.String,
                        color: Swift.String? = nil,
                        description: Swift.String? = nil
                    ) {
                        self.name = name
                        self.color = color
                        self.description = description
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case color
                        case description
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesCreateLabel.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesCreateLabel.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesCreateLabel.Input.Path,
                headers: Operations.IssuesCreateLabel.Input.Headers = .init(),
                body: Operations.IssuesCreateLabel.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesCreateLabel.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Label)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Label {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesCreateLabel.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesCreateLabel.Output.Created.Headers = .init(),
                    body: Operations.IssuesCreateLabel.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/post(issues/create-label)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.IssuesCreateLabel.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.IssuesCreateLabel.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/post(issues/create-label)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/post(issues/create-label)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a label
    ///
    /// Gets a label using the given name.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/get(issues/get-label)`.
    public enum IssuesGetLabel {
        public static let id: Swift.String = "issues/get-label"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/path/name`.
                public var name: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - name:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    name: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.name = name
                }
            }
            public var path: Operations.IssuesGetLabel.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetLabel.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetLabel.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesGetLabel.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesGetLabel.Input.Path,
                headers: Operations.IssuesGetLabel.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Label)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Label {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesGetLabel.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesGetLabel.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/get(issues/get-label)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesGetLabel.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesGetLabel.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/get(issues/get-label)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a label
    ///
    /// Updates a label using the given label name.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/patch(issues/update-label)`.
    public enum IssuesUpdateLabel {
        public static let id: Swift.String = "issues/update-label"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/path/name`.
                public var name: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - name:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    name: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.name = name
                }
            }
            public var path: Operations.IssuesUpdateLabel.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdateLabel.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdateLabel.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesUpdateLabel.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see "[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet)."
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/requestBody/json/new_name`.
                    public var newName: Swift.String?
                    /// The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/requestBody/json/color`.
                    public var color: Swift.String?
                    /// A short description of the label. Must be 100 characters or fewer.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - newName: The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see "[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet)."
                    ///   - color: The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
                    ///   - description: A short description of the label. Must be 100 characters or fewer.
                    public init(
                        newName: Swift.String? = nil,
                        color: Swift.String? = nil,
                        description: Swift.String? = nil
                    ) {
                        self.newName = newName
                        self.color = color
                        self.description = description
                    }
                    public enum CodingKeys: String, CodingKey {
                        case newName = "new_name"
                        case color
                        case description
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/requestBody/content/application\/json`.
                case json(Operations.IssuesUpdateLabel.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesUpdateLabel.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesUpdateLabel.Input.Path,
                headers: Operations.IssuesUpdateLabel.Input.Headers = .init(),
                body: Operations.IssuesUpdateLabel.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Label)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Label {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesUpdateLabel.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesUpdateLabel.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/patch(issues/update-label)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesUpdateLabel.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesUpdateLabel.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a label
    ///
    /// Deletes a label using the given label name.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/delete(issues/delete-label)`.
    public enum IssuesDeleteLabel {
        public static let id: Swift.String = "issues/delete-label"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/labels/{name}/DELETE/path/name`.
                public var name: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - name:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    name: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.name = name
                }
            }
            public var path: Operations.IssuesDeleteLabel.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.IssuesDeleteLabel.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/delete(issues/delete-label)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesDeleteLabel.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/labels/{name}/delete(issues/delete-label)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesDeleteLabel.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List milestones
    ///
    /// Lists milestones for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/get(issues/list-milestones)`.
    public enum IssuesListMilestones {
        public static let id: Swift.String = "issues/list-milestones"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesListMilestones.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// The state of the milestone. Either `open`, `closed`, or `all`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/state`.
                public var state: Operations.IssuesListMilestones.Input.Query.StatePayload?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case dueOn = "due_on"
                    case completeness = "completeness"
                }
                /// What to sort results by. Either `due_on` or `completeness`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/sort`.
                public var sort: Operations.IssuesListMilestones.Input.Query.SortPayload?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction of the sort. Either `asc` or `desc`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/direction`.
                public var direction: Operations.IssuesListMilestones.Input.Query.DirectionPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: The state of the milestone. Either `open`, `closed`, or `all`.
                ///   - sort: What to sort results by. Either `due_on` or `completeness`.
                ///   - direction: The direction of the sort. Either `asc` or `desc`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.IssuesListMilestones.Input.Query.StatePayload? = nil,
                    sort: Operations.IssuesListMilestones.Input.Query.SortPayload? = nil,
                    direction: Operations.IssuesListMilestones.Input.Query.DirectionPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.IssuesListMilestones.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListMilestones.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesListMilestones.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesListMilestones.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.IssuesListMilestones.Input.Path,
                query: Operations.IssuesListMilestones.Input.Query = .init(),
                headers: Operations.IssuesListMilestones.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesListMilestones.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Milestone])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Milestone] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesListMilestones.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesListMilestones.Output.Ok.Headers = .init(),
                    body: Operations.IssuesListMilestones.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/get(issues/list-milestones)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesListMilestones.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesListMilestones.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/get(issues/list-milestones)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a milestone
    ///
    /// Creates a milestone.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/milestones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/post(issues/create-milestone)`.
    public enum IssuesCreateMilestone {
        public static let id: Swift.String = "issues/create-milestone"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.IssuesCreateMilestone.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreateMilestone.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesCreateMilestone.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesCreateMilestone.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The title of the milestone.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/json/title`.
                    public var title: Swift.String
                    /// The state of the milestone. Either `open` or `closed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/json/state`.
                    @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case open = "open"
                        case closed = "closed"
                    }
                    /// The state of the milestone. Either `open` or `closed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/json/state`.
                    public var state: Operations.IssuesCreateMilestone.Input.Body.JsonPayload.StatePayload?
                    /// A description of the milestone.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/json/due_on`.
                    public var dueOn: Foundation.Date?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The title of the milestone.
                    ///   - state: The state of the milestone. Either `open` or `closed`.
                    ///   - description: A description of the milestone.
                    ///   - dueOn: The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                    public init(
                        title: Swift.String,
                        state: Operations.IssuesCreateMilestone.Input.Body.JsonPayload.StatePayload? = nil,
                        description: Swift.String? = nil,
                        dueOn: Foundation.Date? = nil
                    ) {
                        self.title = title
                        self.state = state
                        self.description = description
                        self.dueOn = dueOn
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case state
                        case description
                        case dueOn = "due_on"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/requestBody/content/application\/json`.
                case json(Operations.IssuesCreateMilestone.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesCreateMilestone.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesCreateMilestone.Input.Path,
                headers: Operations.IssuesCreateMilestone.Input.Headers = .init(),
                body: Operations.IssuesCreateMilestone.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.IssuesCreateMilestone.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Milestone)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Milestone {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesCreateMilestone.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.IssuesCreateMilestone.Output.Created.Headers = .init(),
                    body: Operations.IssuesCreateMilestone.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/post(issues/create-milestone)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.IssuesCreateMilestone.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.IssuesCreateMilestone.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/post(issues/create-milestone)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/post(issues/create-milestone)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a milestone
    ///
    /// Gets a milestone using the given milestone number.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/get(issues/get-milestone)`.
    public enum IssuesGetMilestone {
        public static let id: Swift.String = "issues/get-milestone"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the milestone.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/path/milestone_number`.
                public var milestoneNumber: Components.Parameters.MilestoneNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - milestoneNumber: The number that identifies the milestone.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    milestoneNumber: Components.Parameters.MilestoneNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.milestoneNumber = milestoneNumber
                }
            }
            public var path: Operations.IssuesGetMilestone.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetMilestone.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesGetMilestone.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesGetMilestone.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesGetMilestone.Input.Path,
                headers: Operations.IssuesGetMilestone.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Milestone)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Milestone {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesGetMilestone.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesGetMilestone.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/get(issues/get-milestone)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesGetMilestone.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesGetMilestone.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/get(issues/get-milestone)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a milestone
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/patch(issues/update-milestone)`.
    public enum IssuesUpdateMilestone {
        public static let id: Swift.String = "issues/update-milestone"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the milestone.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/path/milestone_number`.
                public var milestoneNumber: Components.Parameters.MilestoneNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - milestoneNumber: The number that identifies the milestone.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    milestoneNumber: Components.Parameters.MilestoneNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.milestoneNumber = milestoneNumber
                }
            }
            public var path: Operations.IssuesUpdateMilestone.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdateMilestone.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesUpdateMilestone.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesUpdateMilestone.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The title of the milestone.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The state of the milestone. Either `open` or `closed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/json/state`.
                    @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case open = "open"
                        case closed = "closed"
                    }
                    /// The state of the milestone. Either `open` or `closed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/json/state`.
                    public var state: Operations.IssuesUpdateMilestone.Input.Body.JsonPayload.StatePayload?
                    /// A description of the milestone.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/json/due_on`.
                    public var dueOn: Foundation.Date?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The title of the milestone.
                    ///   - state: The state of the milestone. Either `open` or `closed`.
                    ///   - description: A description of the milestone.
                    ///   - dueOn: The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                    public init(
                        title: Swift.String? = nil,
                        state: Operations.IssuesUpdateMilestone.Input.Body.JsonPayload.StatePayload? = nil,
                        description: Swift.String? = nil,
                        dueOn: Foundation.Date? = nil
                    ) {
                        self.title = title
                        self.state = state
                        self.description = description
                        self.dueOn = dueOn
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case state
                        case description
                        case dueOn = "due_on"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.IssuesUpdateMilestone.Input.Body.JsonPayload)
            }
            public var body: Operations.IssuesUpdateMilestone.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.IssuesUpdateMilestone.Input.Path,
                headers: Operations.IssuesUpdateMilestone.Input.Headers = .init(),
                body: Operations.IssuesUpdateMilestone.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Milestone)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Milestone {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.IssuesUpdateMilestone.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.IssuesUpdateMilestone.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/patch(issues/update-milestone)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.IssuesUpdateMilestone.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.IssuesUpdateMilestone.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a milestone
    ///
    /// Deletes a milestone using the given milestone number.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/milestones/{milestone_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/delete(issues/delete-milestone)`.
    public enum IssuesDeleteMilestone {
        public static let id: Swift.String = "issues/delete-milestone"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the milestone.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/DELETE/path/milestone_number`.
                public var milestoneNumber: Components.Parameters.MilestoneNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - milestoneNumber: The number that identifies the milestone.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    milestoneNumber: Components.Parameters.MilestoneNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.milestoneNumber = milestoneNumber
                }
            }
            public var path: Operations.IssuesDeleteMilestone.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/milestones/{milestone_number}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesDeleteMilestone.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.IssuesDeleteMilestone.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.IssuesDeleteMilestone.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.IssuesDeleteMilestone.Input.Path,
                headers: Operations.IssuesDeleteMilestone.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/delete(issues/delete-milestone)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.IssuesDeleteMilestone.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/delete(issues/delete-milestone)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.IssuesDeleteMilestone.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/milestones/{milestone_number}/delete(issues/delete-milestone)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
     