// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List hosted compute network configurations for an organization
    ///
    /// Lists all hosted compute network configurations configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/get(hosted-compute/list-network-configurations-for-org)`.
    func hostedComputeListNetworkConfigurationsForOrg(_ input: Operations.HostedComputeListNetworkConfigurationsForOrg.Input) async throws -> Operations.HostedComputeListNetworkConfigurationsForOrg.Output
    /// Create a hosted compute network configuration for an organization
    ///
    /// Creates a hosted compute network configuration for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/settings/network-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/post(hosted-compute/create-network-configuration-for-org)`.
    func hostedComputeCreateNetworkConfigurationForOrg(_ input: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input) async throws -> Operations.HostedComputeCreateNetworkConfigurationForOrg.Output
    /// Get a hosted compute network configuration for an organization
    ///
    /// Gets a hosted compute network configuration configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/get(hosted-compute/get-network-configuration-for-org)`.
    func hostedComputeGetNetworkConfigurationForOrg(_ input: Operations.HostedComputeGetNetworkConfigurationForOrg.Input) async throws -> Operations.HostedComputeGetNetworkConfigurationForOrg.Output
    /// Update a hosted compute network configuration for an organization
    ///
    /// Updates a hosted compute network configuration for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/patch(hosted-compute/update-network-configuration-for-org)`.
    func hostedComputeUpdateNetworkConfigurationForOrg(_ input: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input) async throws -> Operations.HostedComputeUpdateNetworkConfigurationForOrg.Output
    /// Delete a hosted compute network configuration from an organization
    ///
    /// Deletes a hosted compute network configuration from an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/delete(hosted-compute/delete-network-configuration-from-org)`.
    func hostedComputeDeleteNetworkConfigurationFromOrg(_ input: Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Input) async throws -> Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Output
    /// Get a hosted compute network settings resource for an organization
    ///
    /// Gets a hosted compute network settings resource configured for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-settings/{network_settings_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-settings/{network_settings_id}/get(hosted-compute/get-network-settings-for-org)`.
    func hostedComputeGetNetworkSettingsForOrg(_ input: Operations.HostedComputeGetNetworkSettingsForOrg.Input) async throws -> Operations.HostedComputeGetNetworkSettingsForOrg.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List hosted compute network configurations for an organization
    ///
    /// Lists all hosted compute network configurations configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/get(hosted-compute/list-network-configurations-for-org)`.
    public func hostedComputeListNetworkConfigurationsForOrg(
        path: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Path,
        query: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Query = .init(),
        headers: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Headers = .init()
    ) async throws -> Operations.HostedComputeListNetworkConfigurationsForOrg.Output {
        try await hostedComputeListNetworkConfigurationsForOrg(Operations.HostedComputeListNetworkConfigurationsForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a hosted compute network configuration for an organization
    ///
    /// Creates a hosted compute network configuration for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/settings/network-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/post(hosted-compute/create-network-configuration-for-org)`.
    public func hostedComputeCreateNetworkConfigurationForOrg(
        path: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Path,
        headers: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Headers = .init(),
        body: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Body
    ) async throws -> Operations.HostedComputeCreateNetworkConfigurationForOrg.Output {
        try await hostedComputeCreateNetworkConfigurationForOrg(Operations.HostedComputeCreateNetworkConfigurationForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a hosted compute network configuration for an organization
    ///
    /// Gets a hosted compute network configuration configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/get(hosted-compute/get-network-configuration-for-org)`.
    public func hostedComputeGetNetworkConfigurationForOrg(
        path: Operations.HostedComputeGetNetworkConfigurationForOrg.Input.Path,
        headers: Operations.HostedComputeGetNetworkConfigurationForOrg.Input.Headers = .init()
    ) async throws -> Operations.HostedComputeGetNetworkConfigurationForOrg.Output {
        try await hostedComputeGetNetworkConfigurationForOrg(Operations.HostedComputeGetNetworkConfigurationForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a hosted compute network configuration for an organization
    ///
    /// Updates a hosted compute network configuration for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/patch(hosted-compute/update-network-configuration-for-org)`.
    public func hostedComputeUpdateNetworkConfigurationForOrg(
        path: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Path,
        headers: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Headers = .init(),
        body: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Body
    ) async throws -> Operations.HostedComputeUpdateNetworkConfigurationForOrg.Output {
        try await hostedComputeUpdateNetworkConfigurationForOrg(Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a hosted compute network configuration from an organization
    ///
    /// Deletes a hosted compute network configuration from an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/delete(hosted-compute/delete-network-configuration-from-org)`.
    public func hostedComputeDeleteNetworkConfigurationFromOrg(path: Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Input.Path) async throws -> Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Output {
        try await hostedComputeDeleteNetworkConfigurationFromOrg(Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Input(path: path))
    }
    /// Get a hosted compute network settings resource for an organization
    ///
    /// Gets a hosted compute network settings resource configured for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-settings/{network_settings_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-settings/{network_settings_id}/get(hosted-compute/get-network-settings-for-org)`.
    public func hostedComputeGetNetworkSettingsForOrg(
        path: Operations.HostedComputeGetNetworkSettingsForOrg.Input.Path,
        headers: Operations.HostedComputeGetNetworkSettingsForOrg.Input.Headers = .init()
    ) async throws -> Operations.HostedComputeGetNetworkSettingsForOrg.Output {
        try await hostedComputeGetNetworkSettingsForOrg(Operations.HostedComputeGetNetworkSettingsForOrg.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A hosted compute network configuration.
        ///
        /// - Remark: Generated from `#/components/schemas/network-configuration`.
        public struct NetworkConfiguration: Codable, Hashable, Sendable {
            /// The unique identifier of the network configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/network-configuration/id`.
            public var id: Swift.String
            /// The name of the network configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/network-configuration/name`.
            public var name: Swift.String
            /// The hosted compute service the network configuration supports.
            ///
            /// - Remark: Generated from `#/components/schemas/network-configuration/compute_service`.
            @frozen public enum ComputeServicePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case actions = "actions"
                case codespaces = "codespaces"
            }
            /// The hosted compute service the network configuration supports.
            ///
            /// - Remark: Generated from `#/components/schemas/network-configuration/compute_service`.
            public var computeService: Components.Schemas.NetworkConfiguration.ComputeServicePayload?
            /// The unique identifier of each network settings in the configuration.
            ///
            /// - Remark: Generated from `#/components/schemas/network-configuration/network_settings_ids`.
            public var networkSettingsIds: [Swift.String]?
            /// The time at which the network configuration was created, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/network-configuration/created_on`.
            public var createdOn: Foundation.Date?
            /// Creates a new `NetworkConfiguration`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the network configuration.
            ///   - name: The name of the network configuration.
            ///   - computeService: The hosted compute service the network configuration supports.
            ///   - networkSettingsIds: The unique identifier of each network settings in the configuration.
            ///   - createdOn: The time at which the network configuration was created, in ISO 8601 format.
            public init(
                id: Swift.String,
                name: Swift.String,
                computeService: Components.Schemas.NetworkConfiguration.ComputeServicePayload? = nil,
                networkSettingsIds: [Swift.String]? = nil,
                createdOn: Foundation.Date? = nil
            ) {
                self.id = id
                self.name = name
                self.computeService = computeService
                self.networkSettingsIds = networkSettingsIds
                self.createdOn = createdOn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case computeService = "compute_service"
                case networkSettingsIds = "network_settings_ids"
                case createdOn = "created_on"
            }
        }
        /// A hosted compute network settings resource.
        ///
        /// - Remark: Generated from `#/components/schemas/network-settings`.
        public struct NetworkSettings: Codable, Hashable, Sendable {
            /// The unique identifier of the network settings resource.
            ///
            /// - Remark: Generated from `#/components/schemas/network-settings/id`.
            public var id: Swift.String
            /// The identifier of the network configuration that is using this settings resource.
            ///
            /// - Remark: Generated from `#/components/schemas/network-settings/network_configuration_id`.
            public var networkConfigurationId: Swift.String?
            /// The name of the network settings resource.
            ///
            /// - Remark: Generated from `#/components/schemas/network-settings/name`.
            public var name: Swift.String
            /// The subnet this network settings resource is configured for.
            ///
            /// - Remark: Generated from `#/components/schemas/network-settings/subnet_id`.
            public var subnetId: Swift.String
            /// The location of the subnet this network settings resource is configured for.
            ///
            /// - Remark: Generated from `#/components/schemas/network-settings/region`.
            public var region: Swift.String
            /// Creates a new `NetworkSettings`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the network settings resource.
            ///   - networkConfigurationId: The identifier of the network configuration that is using this settings resource.
            ///   - name: The name of the network settings resource.
            ///   - subnetId: The subnet this network settings resource is configured for.
            ///   - region: The location of the subnet this network settings resource is configured for.
            public init(
                id: Swift.String,
                networkConfigurationId: Swift.String? = nil,
                name: Swift.String,
                subnetId: Swift.String,
                region: Swift.String
            ) {
                self.id = id
                self.networkConfigurationId = networkConfigurationId
                self.name = name
                self.subnetId = subnetId
                self.region = region
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case networkConfigurationId = "network_configuration_id"
                case name
                case subnetId = "subnet_id"
                case region
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// Unique identifier of the hosted compute network configuration.
        ///
        /// - Remark: Generated from `#/components/parameters/network-configuration-id`.
        public typealias NetworkConfigurationId = Swift.String
        /// Unique identifier of the hosted compute network settings.
        ///
        /// - Remark: Generated from `#/components/parameters/network-settings-id`.
        public typealias NetworkSettingsId = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {}
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List hosted compute network configurations for an organization
    ///
    /// Lists all hosted compute network configurations configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/get(hosted-compute/list-network-configurations-for-org)`.
    public enum HostedComputeListNetworkConfigurationsForOrg {
        public static let id: Swift.String = "hosted-compute/list-network-configurations-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeListNetworkConfigurationsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeListNetworkConfigurationsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Path,
                query: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Query = .init(),
                headers: Operations.HostedComputeListNetworkConfigurationsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/content/json/network_configurations`.
                        public var networkConfigurations: [Components.Schemas.NetworkConfiguration]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - networkConfigurations:
                        public init(
                            totalCount: Swift.Int,
                            networkConfigurations: [Components.Schemas.NetworkConfiguration]
                        ) {
                            self.totalCount = totalCount
                            self.networkConfigurations = networkConfigurations
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case networkConfigurations = "network_configurations"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/GET/responses/200/content/application\/json`.
                    case json(Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok.Headers = .init(),
                    body: Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/get(hosted-compute/list-network-configurations-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.HostedComputeListNetworkConfigurationsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a hosted compute network configuration for an organization
    ///
    /// Creates a hosted compute network configuration for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/settings/network-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/post(hosted-compute/create-network-configuration-for-org)`.
    public enum HostedComputeCreateNetworkConfigurationForOrg {
        public static let id: Swift.String = "hosted-compute/create-network-configuration-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeCreateNetworkConfigurationForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeCreateNetworkConfigurationForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the network configuration. Must be between 1 and 100 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The hosted compute service to use for the network configuration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody/json/compute_service`.
                    @frozen public enum ComputeServicePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case none = "none"
                        case actions = "actions"
                    }
                    /// The hosted compute service to use for the network configuration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody/json/compute_service`.
                    public var computeService: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Body.JsonPayload.ComputeServicePayload?
                    /// The identifier of the network settings to use for the network configuration. Exactly one network settings must be specified.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody/json/network_settings_ids`.
                    public var networkSettingsIds: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the network configuration. Must be between 1 and 100 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///   - computeService: The hosted compute service to use for the network configuration.
                    ///   - networkSettingsIds: The identifier of the network settings to use for the network configuration. Exactly one network settings must be specified.
                    public init(
                        name: Swift.String,
                        computeService: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Body.JsonPayload.ComputeServicePayload? = nil,
                        networkSettingsIds: [Swift.String]
                    ) {
                        self.name = name
                        self.computeService = computeService
                        self.networkSettingsIds = networkSettingsIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case computeService = "compute_service"
                        case networkSettingsIds = "network_settings_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/requestBody/content/application\/json`.
                case json(Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Path,
                headers: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Headers = .init(),
                body: Operations.HostedComputeCreateNetworkConfigurationForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.NetworkConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.NetworkConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.HostedComputeCreateNetworkConfigurationForOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.HostedComputeCreateNetworkConfigurationForOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/post(hosted-compute/create-network-configuration-for-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.HostedComputeCreateNetworkConfigurationForOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.HostedComputeCreateNetworkConfigurationForOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a hosted compute network configuration for an organization
    ///
    /// Gets a hosted compute network configuration configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/get(hosted-compute/get-network-configuration-for-org)`.
    public enum HostedComputeGetNetworkConfigurationForOrg {
        public static let id: Swift.String = "hosted-compute/get-network-configuration-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the hosted compute network configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/path/network_configuration_id`.
                public var networkConfigurationId: Components.Parameters.NetworkConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - networkConfigurationId: Unique identifier of the hosted compute network configuration.
                public init(
                    org: Components.Parameters.Org,
                    networkConfigurationId: Components.Parameters.NetworkConfigurationId
                ) {
                    self.org = org
                    self.networkConfigurationId = networkConfigurationId
                }
            }
            public var path: Operations.HostedComputeGetNetworkConfigurationForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeGetNetworkConfigurationForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeGetNetworkConfigurationForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.HostedComputeGetNetworkConfigurationForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.HostedComputeGetNetworkConfigurationForOrg.Input.Path,
                headers: Operations.HostedComputeGetNetworkConfigurationForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.HostedComputeGetNetworkConfigurationForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.NetworkConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.NetworkConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.HostedComputeGetNetworkConfigurationForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.HostedComputeGetNetworkConfigurationForOrg.Output.Ok.Headers = .init(),
                    body: Operations.HostedComputeGetNetworkConfigurationForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/get(hosted-compute/get-network-configuration-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.HostedComputeGetNetworkConfigurationForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.HostedComputeGetNetworkConfigurationForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a hosted compute network configuration for an organization
    ///
    /// Updates a hosted compute network configuration for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/patch(hosted-compute/update-network-configuration-for-org)`.
    public enum HostedComputeUpdateNetworkConfigurationForOrg {
        public static let id: Swift.String = "hosted-compute/update-network-configuration-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the hosted compute network configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/path/network_configuration_id`.
                public var networkConfigurationId: Components.Parameters.NetworkConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - networkConfigurationId: Unique identifier of the hosted compute network configuration.
                public init(
                    org: Components.Parameters.Org,
                    networkConfigurationId: Components.Parameters.NetworkConfigurationId
                ) {
                    self.org = org
                    self.networkConfigurationId = networkConfigurationId
                }
            }
            public var path: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeUpdateNetworkConfigurationForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeUpdateNetworkConfigurationForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the network configuration. Must be between 1 and 100 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// The hosted compute service to use for the network configuration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody/json/compute_service`.
                    @frozen public enum ComputeServicePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case none = "none"
                        case actions = "actions"
                    }
                    /// The hosted compute service to use for the network configuration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody/json/compute_service`.
                    public var computeService: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Body.JsonPayload.ComputeServicePayload?
                    /// The identifier of the network settings to use for the network configuration. Exactly one network settings must be specified.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody/json/network_settings_ids`.
                    public var networkSettingsIds: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the network configuration. Must be between 1 and 100 characters and may only contain upper and lowercase letters a-z, numbers 0-9, '.', '-', and '_'.
                    ///   - computeService: The hosted compute service to use for the network configuration.
                    ///   - networkSettingsIds: The identifier of the network settings to use for the network configuration. Exactly one network settings must be specified.
                    public init(
                        name: Swift.String? = nil,
                        computeService: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Body.JsonPayload.ComputeServicePayload? = nil,
                        networkSettingsIds: [Swift.String]? = nil
                    ) {
                        self.name = name
                        self.computeService = computeService
                        self.networkSettingsIds = networkSettingsIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case computeService = "compute_service"
                        case networkSettingsIds = "network_settings_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Path,
                headers: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Headers = .init(),
                body: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.NetworkConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.NetworkConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/patch(hosted-compute/update-network-configuration-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.HostedComputeUpdateNetworkConfigurationForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.HostedComputeUpdateNetworkConfigurationForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a hosted compute network configuration from an organization
    ///
    /// Deletes a hosted compute network configuration from an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/settings/network-configurations/{network_configuration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/delete(hosted-compute/delete-network-configuration-from-org)`.
    public enum HostedComputeDeleteNetworkConfigurationFromOrg {
        public static let id: Swift.String = "hosted-compute/delete-network-configuration-from-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the hosted compute network configuration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-configurations/{network_configuration_id}/DELETE/path/network_configuration_id`.
                public var networkConfigurationId: Components.Parameters.NetworkConfigurationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - networkConfigurationId: Unique identifier of the hosted compute network configuration.
                public init(
                    org: Components.Parameters.Org,
                    networkConfigurationId: Components.Parameters.NetworkConfigurationId
                ) {
                    self.org = org
                    self.networkConfigurationId = networkConfigurationId
                }
            }
            public var path: Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/delete(hosted-compute/delete-network-configuration-from-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-configurations/{network_configuration_id}/delete(hosted-compute/delete-network-configuration-from-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.HostedComputeDeleteNetworkConfigurationFromOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get a hosted compute network settings resource for an organization
    ///
    /// Gets a hosted compute network settings resource configured for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/settings/network-settings/{network_settings_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-settings/{network_settings_id}/get(hosted-compute/get-network-settings-for-org)`.
    public enum HostedComputeGetNetworkSettingsForOrg {
        public static let id: Swift.String = "hosted-compute/get-network-settings-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Unique identifier of the hosted compute network settings.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/path/network_settings_id`.
                public var networkSettingsId: Components.Parameters.NetworkSettingsId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - networkSettingsId: Unique identifier of the hosted compute network settings.
                public init(
                    org: Components.Parameters.Org,
                    networkSettingsId: Components.Parameters.NetworkSettingsId
                ) {
                    self.org = org
                    self.networkSettingsId = networkSettingsId
                }
            }
            public var path: Operations.HostedComputeGetNetworkSettingsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeGetNetworkSettingsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.HostedComputeGetNetworkSettingsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.HostedComputeGetNetworkSettingsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.HostedComputeGetNetworkSettingsForOrg.Input.Path,
                headers: Operations.HostedComputeGetNetworkSettingsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.HostedComputeGetNetworkSettingsForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/settings/network-settings/{network_settings_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.NetworkSettings)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.NetworkSettings {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.HostedComputeGetNetworkSettingsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.HostedComputeGetNetworkSettingsForOrg.Output.Ok.Headers = .init(),
                    body: Operations.HostedComputeGetNetworkSettingsForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/settings/network-settings/{network_settings_id}/get(hosted-compute/get-network-settings-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.HostedComputeGetNetworkSettingsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.HostedComputeGetNetworkSettingsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
