// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get a diff of the dependencies between commits
    ///
    /// Gets the diff of the dependency changes between two commits of a repository, based on the changes to the dependency manifests made in those commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependency-graph/compare/{basehead}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/compare/{basehead}/get(dependency-graph/diff-range)`.
    func dependencyGraphDiffRange(_ input: Operations.DependencyGraphDiffRange.Input) async throws -> Operations.DependencyGraphDiffRange.Output
    /// Export a software bill of materials (SBOM) for a repository.
    ///
    /// Exports the software bill of materials (SBOM) for a repository in SPDX JSON format.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependency-graph/sbom`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/sbom/get(dependency-graph/export-sbom)`.
    func dependencyGraphExportSbom(_ input: Operations.DependencyGraphExportSbom.Input) async throws -> Operations.DependencyGraphExportSbom.Output
    /// Create a snapshot of dependencies for a repository
    ///
    /// Create a new snapshot of a repository's dependencies.
    ///
    /// The authenticated user must have access to the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/dependency-graph/snapshots`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/snapshots/post(dependency-graph/create-repository-snapshot)`.
    func dependencyGraphCreateRepositorySnapshot(_ input: Operations.DependencyGraphCreateRepositorySnapshot.Input) async throws -> Operations.DependencyGraphCreateRepositorySnapshot.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get a diff of the dependencies between commits
    ///
    /// Gets the diff of the dependency changes between two commits of a repository, based on the changes to the dependency manifests made in those commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependency-graph/compare/{basehead}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/compare/{basehead}/get(dependency-graph/diff-range)`.
    public func dependencyGraphDiffRange(
        path: Operations.DependencyGraphDiffRange.Input.Path,
        query: Operations.DependencyGraphDiffRange.Input.Query = .init(),
        headers: Operations.DependencyGraphDiffRange.Input.Headers = .init()
    ) async throws -> Operations.DependencyGraphDiffRange.Output {
        try await dependencyGraphDiffRange(Operations.DependencyGraphDiffRange.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Export a software bill of materials (SBOM) for a repository.
    ///
    /// Exports the software bill of materials (SBOM) for a repository in SPDX JSON format.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependency-graph/sbom`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/sbom/get(dependency-graph/export-sbom)`.
    public func dependencyGraphExportSbom(
        path: Operations.DependencyGraphExportSbom.Input.Path,
        headers: Operations.DependencyGraphExportSbom.Input.Headers = .init()
    ) async throws -> Operations.DependencyGraphExportSbom.Output {
        try await dependencyGraphExportSbom(Operations.DependencyGraphExportSbom.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a snapshot of dependencies for a repository
    ///
    /// Create a new snapshot of a repository's dependencies.
    ///
    /// The authenticated user must have access to the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/dependency-graph/snapshots`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/snapshots/post(dependency-graph/create-repository-snapshot)`.
    public func dependencyGraphCreateRepositorySnapshot(
        path: Operations.DependencyGraphCreateRepositorySnapshot.Input.Path,
        headers: Operations.DependencyGraphCreateRepositorySnapshot.Input.Headers = .init(),
        body: Operations.DependencyGraphCreateRepositorySnapshot.Input.Body
    ) async throws -> Operations.DependencyGraphCreateRepositorySnapshot.Output {
        try await dependencyGraphCreateRepositorySnapshot(Operations.DependencyGraphCreateRepositorySnapshot.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff`.
        public struct DependencyGraphDiffPayload: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/change_type`.
            @frozen public enum ChangeTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case added = "added"
                case removed = "removed"
            }
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/change_type`.
            public var changeType: Components.Schemas.DependencyGraphDiffPayload.ChangeTypePayload
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/manifest`.
            public var manifest: Swift.String
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/ecosystem`.
            public var ecosystem: Swift.String
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/version`.
            public var version: Swift.String
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/package_url`.
            public var packageUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/license`.
            public var license: Swift.String?
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/source_repository_url`.
            public var sourceRepositoryUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/VulnerabilitiesPayload`.
            public struct VulnerabilitiesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/VulnerabilitiesPayload/severity`.
                public var severity: Swift.String
                /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/VulnerabilitiesPayload/advisory_ghsa_id`.
                public var advisoryGhsaId: Swift.String
                /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/VulnerabilitiesPayload/advisory_summary`.
                public var advisorySummary: Swift.String
                /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/VulnerabilitiesPayload/advisory_url`.
                public var advisoryUrl: Swift.String
                /// Creates a new `VulnerabilitiesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - severity:
                ///   - advisoryGhsaId:
                ///   - advisorySummary:
                ///   - advisoryUrl:
                public init(
                    severity: Swift.String,
                    advisoryGhsaId: Swift.String,
                    advisorySummary: Swift.String,
                    advisoryUrl: Swift.String
                ) {
                    self.severity = severity
                    self.advisoryGhsaId = advisoryGhsaId
                    self.advisorySummary = advisorySummary
                    self.advisoryUrl = advisoryUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case severity
                    case advisoryGhsaId = "advisory_ghsa_id"
                    case advisorySummary = "advisory_summary"
                    case advisoryUrl = "advisory_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/vulnerabilities`.
            public typealias VulnerabilitiesPayload = [Components.Schemas.DependencyGraphDiffPayload.VulnerabilitiesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/vulnerabilities`.
            public var vulnerabilities: Components.Schemas.DependencyGraphDiffPayload.VulnerabilitiesPayload
            /// Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
            ///
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/scope`.
            @frozen public enum ScopePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case unknown = "unknown"
                case runtime = "runtime"
                case development = "development"
            }
            /// Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
            ///
            /// - Remark: Generated from `#/components/schemas/DependencyGraphDiff/scope`.
            public var scope: Components.Schemas.DependencyGraphDiffPayload.ScopePayload
            /// Creates a new `DependencyGraphDiffPayload`.
            ///
            /// - Parameters:
            ///   - changeType:
            ///   - manifest:
            ///   - ecosystem:
            ///   - name:
            ///   - version:
            ///   - packageUrl:
            ///   - license:
            ///   - sourceRepositoryUrl:
            ///   - vulnerabilities:
            ///   - scope: Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
            public init(
                changeType: Components.Schemas.DependencyGraphDiffPayload.ChangeTypePayload,
                manifest: Swift.String,
                ecosystem: Swift.String,
                name: Swift.String,
                version: Swift.String,
                packageUrl: Swift.String? = nil,
                license: Swift.String? = nil,
                sourceRepositoryUrl: Swift.String? = nil,
                vulnerabilities: Components.Schemas.DependencyGraphDiffPayload.VulnerabilitiesPayload,
                scope: Components.Schemas.DependencyGraphDiffPayload.ScopePayload
            ) {
                self.changeType = changeType
                self.manifest = manifest
                self.ecosystem = ecosystem
                self.name = name
                self.version = version
                self.packageUrl = packageUrl
                self.license = license
                self.sourceRepositoryUrl = sourceRepositoryUrl
                self.vulnerabilities = vulnerabilities
                self.scope = scope
            }
            public enum CodingKeys: String, CodingKey {
                case changeType = "change_type"
                case manifest
                case ecosystem
                case name
                case version
                case packageUrl = "package_url"
                case license
                case sourceRepositoryUrl = "source_repository_url"
                case vulnerabilities
                case scope
            }
        }
        /// A diff of the dependencies between two commits.
        ///
        /// - Remark: Generated from `#/components/schemas/dependency-graph-diff`.
        public typealias DependencyGraphDiff = [Components.Schemas.DependencyGraphDiffPayload]
        /// A schema for the SPDX JSON format returned by the Dependency Graph.
        ///
        /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom`.
        public struct DependencyGraphSpdxSbom: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom`.
            public struct SbomPayload: Codable, Hashable, Sendable {
                /// The SPDX identifier for the SPDX document.
                ///
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/SPDXID`.
                public var spdxid: Swift.String
                /// The version of the SPDX specification that this document conforms to.
                ///
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/spdxVersion`.
                public var spdxVersion: Swift.String
                /// An optional comment about the SPDX document.
                ///
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/comment`.
                public var comment: Swift.String?
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/creationInfo`.
                public struct CreationInfoPayload: Codable, Hashable, Sendable {
                    /// The date and time the SPDX document was created.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/creationInfo/created`.
                    public var created: Swift.String
                    /// The tools that were used to generate the SPDX document.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/creationInfo/creators`.
                    public var creators: [Swift.String]
                    /// Creates a new `CreationInfoPayload`.
                    ///
                    /// - Parameters:
                    ///   - created: The date and time the SPDX document was created.
                    ///   - creators: The tools that were used to generate the SPDX document.
                    public init(
                        created: Swift.String,
                        creators: [Swift.String]
                    ) {
                        self.created = created
                        self.creators = creators
                    }
                    public enum CodingKeys: String, CodingKey {
                        case created
                        case creators
                    }
                }
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/creationInfo`.
                public var creationInfo: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.CreationInfoPayload
                /// The name of the SPDX document.
                ///
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/name`.
                public var name: Swift.String
                /// The license under which the SPDX document is licensed.
                ///
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/dataLicense`.
                public var dataLicense: Swift.String
                /// The namespace for the SPDX document.
                ///
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/documentNamespace`.
                public var documentNamespace: Swift.String
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload`.
                public struct PackagesPayloadPayload: Codable, Hashable, Sendable {
                    /// A unique SPDX identifier for the package.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/SPDXID`.
                    public var spdxid: Swift.String?
                    /// The name of the package.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/name`.
                    public var name: Swift.String?
                    /// The version of the package. If the package does not have an exact version specified,
                    /// a version range is given.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/versionInfo`.
                    public var versionInfo: Swift.String?
                    /// The location where the package can be downloaded,
                    /// or NOASSERTION if this has not been determined.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/downloadLocation`.
                    public var downloadLocation: Swift.String?
                    /// Whether the package's file content has been subjected to
                    /// analysis during the creation of the SPDX document.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/filesAnalyzed`.
                    public var filesAnalyzed: Swift.Bool?
                    /// The license of the package as determined while creating the SPDX document.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/licenseConcluded`.
                    public var licenseConcluded: Swift.String?
                    /// The license of the package as declared by its author, or NOASSERTION if this information
                    /// was not available when the SPDX document was created.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/licenseDeclared`.
                    public var licenseDeclared: Swift.String?
                    /// The distribution source of this package, or NOASSERTION if this was not determined.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/supplier`.
                    public var supplier: Swift.String?
                    /// The copyright holders of the package, and any dates present with those notices, if available.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/copyrightText`.
                    public var copyrightText: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/ExternalRefsPayload`.
                    public struct ExternalRefsPayloadPayload: Codable, Hashable, Sendable {
                        /// The category of reference to an external resource this reference refers to.
                        ///
                        /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/ExternalRefsPayload/referenceCategory`.
                        public var referenceCategory: Swift.String
                        /// A locator for the particular external resource this reference refers to.
                        ///
                        /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/ExternalRefsPayload/referenceLocator`.
                        public var referenceLocator: Swift.String
                        /// The category of reference to an external resource this reference refers to.
                        ///
                        /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/ExternalRefsPayload/referenceType`.
                        public var referenceType: Swift.String
                        /// Creates a new `ExternalRefsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - referenceCategory: The category of reference to an external resource this reference refers to.
                        ///   - referenceLocator: A locator for the particular external resource this reference refers to.
                        ///   - referenceType: The category of reference to an external resource this reference refers to.
                        public init(
                            referenceCategory: Swift.String,
                            referenceLocator: Swift.String,
                            referenceType: Swift.String
                        ) {
                            self.referenceCategory = referenceCategory
                            self.referenceLocator = referenceLocator
                            self.referenceType = referenceType
                        }
                        public enum CodingKeys: String, CodingKey {
                            case referenceCategory
                            case referenceLocator
                            case referenceType
                        }
                    }
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/externalRefs`.
                    public typealias ExternalRefsPayload = [Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.PackagesPayloadPayload.ExternalRefsPayloadPayload]
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/PackagesPayload/externalRefs`.
                    public var externalRefs: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.PackagesPayloadPayload.ExternalRefsPayload?
                    /// Creates a new `PackagesPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - spdxid: A unique SPDX identifier for the package.
                    ///   - name: The name of the package.
                    ///   - versionInfo: The version of the package. If the package does not have an exact version specified,
                    ///   - downloadLocation: The location where the package can be downloaded,
                    ///   - filesAnalyzed: Whether the package's file content has been subjected to
                    ///   - licenseConcluded: The license of the package as determined while creating the SPDX document.
                    ///   - licenseDeclared: The license of the package as declared by its author, or NOASSERTION if this information
                    ///   - supplier: The distribution source of this package, or NOASSERTION if this was not determined.
                    ///   - copyrightText: The copyright holders of the package, and any dates present with those notices, if available.
                    ///   - externalRefs:
                    public init(
                        spdxid: Swift.String? = nil,
                        name: Swift.String? = nil,
                        versionInfo: Swift.String? = nil,
                        downloadLocation: Swift.String? = nil,
                        filesAnalyzed: Swift.Bool? = nil,
                        licenseConcluded: Swift.String? = nil,
                        licenseDeclared: Swift.String? = nil,
                        supplier: Swift.String? = nil,
                        copyrightText: Swift.String? = nil,
                        externalRefs: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.PackagesPayloadPayload.ExternalRefsPayload? = nil
                    ) {
                        self.spdxid = spdxid
                        self.name = name
                        self.versionInfo = versionInfo
                        self.downloadLocation = downloadLocation
                        self.filesAnalyzed = filesAnalyzed
                        self.licenseConcluded = licenseConcluded
                        self.licenseDeclared = licenseDeclared
                        self.supplier = supplier
                        self.copyrightText = copyrightText
                        self.externalRefs = externalRefs
                    }
                    public enum CodingKeys: String, CodingKey {
                        case spdxid = "SPDXID"
                        case name
                        case versionInfo
                        case downloadLocation
                        case filesAnalyzed
                        case licenseConcluded
                        case licenseDeclared
                        case supplier
                        case copyrightText
                        case externalRefs
                    }
                }
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/packages`.
                public typealias PackagesPayload = [Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.PackagesPayloadPayload]
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/packages`.
                public var packages: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.PackagesPayload
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/RelationshipsPayload`.
                public struct RelationshipsPayloadPayload: Codable, Hashable, Sendable {
                    /// The type of relationship between the two SPDX elements.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/RelationshipsPayload/relationshipType`.
                    public var relationshipType: Swift.String?
                    /// The SPDX identifier of the package that is the source of the relationship.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/RelationshipsPayload/spdxElementId`.
                    public var spdxElementId: Swift.String?
                    /// The SPDX identifier of the package that is the target of the relationship.
                    ///
                    /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/RelationshipsPayload/relatedSpdxElement`.
                    public var relatedSpdxElement: Swift.String?
                    /// Creates a new `RelationshipsPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - relationshipType: The type of relationship between the two SPDX elements.
                    ///   - spdxElementId: The SPDX identifier of the package that is the source of the relationship.
                    ///   - relatedSpdxElement: The SPDX identifier of the package that is the target of the relationship.
                    public init(
                        relationshipType: Swift.String? = nil,
                        spdxElementId: Swift.String? = nil,
                        relatedSpdxElement: Swift.String? = nil
                    ) {
                        self.relationshipType = relationshipType
                        self.spdxElementId = spdxElementId
                        self.relatedSpdxElement = relatedSpdxElement
                    }
                    public enum CodingKeys: String, CodingKey {
                        case relationshipType
                        case spdxElementId
                        case relatedSpdxElement
                    }
                }
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/relationships`.
                public typealias RelationshipsPayload = [Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.RelationshipsPayloadPayload]
                /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom/relationships`.
                public var relationships: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.RelationshipsPayload?
                /// Creates a new `SbomPayload`.
                ///
                /// - Parameters:
                ///   - spdxid: The SPDX identifier for the SPDX document.
                ///   - spdxVersion: The version of the SPDX specification that this document conforms to.
                ///   - comment: An optional comment about the SPDX document.
                ///   - creationInfo:
                ///   - name: The name of the SPDX document.
                ///   - dataLicense: The license under which the SPDX document is licensed.
                ///   - documentNamespace: The namespace for the SPDX document.
                ///   - packages:
                ///   - relationships:
                public init(
                    spdxid: Swift.String,
                    spdxVersion: Swift.String,
                    comment: Swift.String? = nil,
                    creationInfo: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.CreationInfoPayload,
                    name: Swift.String,
                    dataLicense: Swift.String,
                    documentNamespace: Swift.String,
                    packages: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.PackagesPayload,
                    relationships: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload.RelationshipsPayload? = nil
                ) {
                    self.spdxid = spdxid
                    self.spdxVersion = spdxVersion
                    self.comment = comment
                    self.creationInfo = creationInfo
                    self.name = name
                    self.dataLicense = dataLicense
                    self.documentNamespace = documentNamespace
                    self.packages = packages
                    self.relationships = relationships
                }
                public enum CodingKeys: String, CodingKey {
                    case spdxid = "SPDXID"
                    case spdxVersion
                    case comment
                    case creationInfo
                    case name
                    case dataLicense
                    case documentNamespace
                    case packages
                    case relationships
                }
            }
            /// - Remark: Generated from `#/components/schemas/dependency-graph-spdx-sbom/sbom`.
            public var sbom: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload
            /// Creates a new `DependencyGraphSpdxSbom`.
            ///
            /// - Parameters:
            ///   - sbom:
            public init(sbom: Components.Schemas.DependencyGraphSpdxSbom.SbomPayload) {
                self.sbom = sbom
            }
            public enum CodingKeys: String, CodingKey {
                case sbom
            }
        }
        /// User-defined metadata to store domain-specific information limited to 8 keys with scalar values.
        ///
        /// - Remark: Generated from `#/components/schemas/metadata`.
        public struct Metadata: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/metadata/additionalProperties`.
            public struct AdditionalPropertiesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/metadata/additionalProperties/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/metadata/additionalProperties/value2`.
                public var value2: Swift.Double?
                /// - Remark: Generated from `#/components/schemas/metadata/additionalProperties/value3`.
                public var value3: Swift.Bool?
                /// Creates a new `AdditionalPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                ///   - value3:
                public init(
                    value1: Swift.String? = nil,
                    value2: Swift.Double? = nil,
                    value3: Swift.Bool? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                    self.value3 = value3
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self.value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value3 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            self.value1,
                            self.value2,
                            self.value3
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        self.value1,
                        self.value2,
                        self.value3
                    ])
                }
            }
            /// A container of undocumented properties.
            public var additionalProperties: [String: Components.Schemas.Metadata.AdditionalPropertiesPayload?]
            /// Creates a new `Metadata`.
            ///
            /// - Parameters:
            ///   - additionalProperties: A container of undocumented properties.
            public init(additionalProperties: [String: Components.Schemas.Metadata.AdditionalPropertiesPayload?] = .init()) {
                self.additionalProperties = additionalProperties
            }
            public init(from decoder: any Decoder) throws {
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
            }
            public func encode(to encoder: any Encoder) throws {
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// - Remark: Generated from `#/components/schemas/dependency`.
        public struct Dependency: Codable, Hashable, Sendable {
            /// Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.
            ///
            /// - Remark: Generated from `#/components/schemas/dependency/package_url`.
            public var packageUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/dependency/metadata`.
            public var metadata: Components.Schemas.Metadata?
            /// A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
            ///
            /// - Remark: Generated from `#/components/schemas/dependency/relationship`.
            @frozen public enum RelationshipPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case direct = "direct"
                case indirect = "indirect"
            }
            /// A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
            ///
            /// - Remark: Generated from `#/components/schemas/dependency/relationship`.
            public var relationship: Components.Schemas.Dependency.RelationshipPayload?
            /// A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
            ///
            /// - Remark: Generated from `#/components/schemas/dependency/scope`.
            @frozen public enum ScopePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case runtime = "runtime"
                case development = "development"
            }
            /// A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
            ///
            /// - Remark: Generated from `#/components/schemas/dependency/scope`.
            public var scope: Components.Schemas.Dependency.ScopePayload?
            /// Array of package-url (PURLs) of direct child dependencies.
            ///
            /// - Remark: Generated from `#/components/schemas/dependency/dependencies`.
            public var dependencies: [Swift.String]?
            /// Creates a new `Dependency`.
            ///
            /// - Parameters:
            ///   - packageUrl: Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.
            ///   - metadata:
            ///   - relationship: A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
            ///   - scope: A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
            ///   - dependencies: Array of package-url (PURLs) of direct child dependencies.
            public init(
                packageUrl: Swift.String? = nil,
                metadata: Components.Schemas.Metadata? = nil,
                relationship: Components.Schemas.Dependency.RelationshipPayload? = nil,
                scope: Components.Schemas.Dependency.ScopePayload? = nil,
                dependencies: [Swift.String]? = nil
            ) {
                self.packageUrl = packageUrl
                self.metadata = metadata
                self.relationship = relationship
                self.scope = scope
                self.dependencies = dependencies
            }
            public enum CodingKeys: String, CodingKey {
                case packageUrl = "package_url"
                case metadata
                case relationship
                case scope
                case dependencies
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.packageUrl = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .packageUrl
                )
                self.metadata = try container.decodeIfPresent(
                    Components.Schemas.Metadata.self,
                    forKey: .metadata
                )
                self.relationship = try container.decodeIfPresent(
                    Components.Schemas.Dependency.RelationshipPayload.self,
                    forKey: .relationship
                )
                self.scope = try container.decodeIfPresent(
                    Components.Schemas.Dependency.ScopePayload.self,
                    forKey: .scope
                )
                self.dependencies = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .dependencies
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "package_url",
                    "metadata",
                    "relationship",
                    "scope",
                    "dependencies"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/manifest`.
        public struct Manifest: Codable, Hashable, Sendable {
            /// The name of the manifest.
            ///
            /// - Remark: Generated from `#/components/schemas/manifest/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/manifest/file`.
            public struct FilePayload: Codable, Hashable, Sendable {
                /// The path of the manifest file relative to the root of the Git repository.
                ///
                /// - Remark: Generated from `#/components/schemas/manifest/file/source_location`.
                public var sourceLocation: Swift.String?
                /// Creates a new `FilePayload`.
                ///
                /// - Parameters:
                ///   - sourceLocation: The path of the manifest file relative to the root of the Git repository.
                public init(sourceLocation: Swift.String? = nil) {
                    self.sourceLocation = sourceLocation
                }
                public enum CodingKeys: String, CodingKey {
                    case sourceLocation = "source_location"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.sourceLocation = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .sourceLocation
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "source_location"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/manifest/file`.
            public var file: Components.Schemas.Manifest.FilePayload?
            /// - Remark: Generated from `#/components/schemas/manifest/metadata`.
            public var metadata: Components.Schemas.Metadata?
            /// A collection of resolved package dependencies.
            ///
            /// - Remark: Generated from `#/components/schemas/manifest/resolved`.
            public struct ResolvedPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: [String: Components.Schemas.Dependency]
                /// Creates a new `ResolvedPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: [String: Components.Schemas.Dependency] = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// A collection of resolved package dependencies.
            ///
            /// - Remark: Generated from `#/components/schemas/manifest/resolved`.
            public var resolved: Components.Schemas.Manifest.ResolvedPayload?
            /// Creates a new `Manifest`.
            ///
            /// - Parameters:
            ///   - name: The name of the manifest.
            ///   - file:
            ///   - metadata:
            ///   - resolved: A collection of resolved package dependencies.
            public init(
                name: Swift.String,
                file: Components.Schemas.Manifest.FilePayload? = nil,
                metadata: Components.Schemas.Metadata? = nil,
                resolved: Components.Schemas.Manifest.ResolvedPayload? = nil
            ) {
                self.name = name
                self.file = file
                self.metadata = metadata
                self.resolved = resolved
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case file
                case metadata
                case resolved
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.name = try container.decode(
                    Swift.String.self,
                    forKey: .name
                )
                self.file = try container.decodeIfPresent(
                    Components.Schemas.Manifest.FilePayload.self,
                    forKey: .file
                )
                self.metadata = try container.decodeIfPresent(
                    Components.Schemas.Metadata.self,
                    forKey: .metadata
                )
                self.resolved = try container.decodeIfPresent(
                    Components.Schemas.Manifest.ResolvedPayload.self,
                    forKey: .resolved
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "name",
                    "file",
                    "metadata",
                    "resolved"
                ])
            }
        }
        /// Create a new snapshot of a repository's dependencies.
        ///
        /// - Remark: Generated from `#/components/schemas/snapshot`.
        public struct Snapshot: Codable, Hashable, Sendable {
            /// The version of the repository snapshot submission.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/version`.
            public var version: Swift.Int
            /// - Remark: Generated from `#/components/schemas/snapshot/job`.
            public struct JobPayload: Codable, Hashable, Sendable {
                /// The external ID of the job.
                ///
                /// - Remark: Generated from `#/components/schemas/snapshot/job/id`.
                public var id: Swift.String
                /// Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.
                ///
                /// - Remark: Generated from `#/components/schemas/snapshot/job/correlator`.
                public var correlator: Swift.String
                /// The url for the job.
                ///
                /// - Remark: Generated from `#/components/schemas/snapshot/job/html_url`.
                public var htmlUrl: Swift.String?
                /// Creates a new `JobPayload`.
                ///
                /// - Parameters:
                ///   - id: The external ID of the job.
                ///   - correlator: Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.
                ///   - htmlUrl: The url for the job.
                public init(
                    id: Swift.String,
                    correlator: Swift.String,
                    htmlUrl: Swift.String? = nil
                ) {
                    self.id = id
                    self.correlator = correlator
                    self.htmlUrl = htmlUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case correlator
                    case htmlUrl = "html_url"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.id = try container.decode(
                        Swift.String.self,
                        forKey: .id
                    )
                    self.correlator = try container.decode(
                        Swift.String.self,
                        forKey: .correlator
                    )
                    self.htmlUrl = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .htmlUrl
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "id",
                        "correlator",
                        "html_url"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/snapshot/job`.
            public var job: Components.Schemas.Snapshot.JobPayload
            /// The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/sha`.
            public var sha: Swift.String
            /// The repository branch that triggered this snapshot.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/ref`.
            public var ref: Swift.String
            /// A description of the detector used.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/detector`.
            public struct DetectorPayload: Codable, Hashable, Sendable {
                /// The name of the detector used.
                ///
                /// - Remark: Generated from `#/components/schemas/snapshot/detector/name`.
                public var name: Swift.String
                /// The version of the detector used.
                ///
                /// - Remark: Generated from `#/components/schemas/snapshot/detector/version`.
                public var version: Swift.String
                /// The url of the detector used.
                ///
                /// - Remark: Generated from `#/components/schemas/snapshot/detector/url`.
                public var url: Swift.String
                /// Creates a new `DetectorPayload`.
                ///
                /// - Parameters:
                ///   - name: The name of the detector used.
                ///   - version: The version of the detector used.
                ///   - url: The url of the detector used.
                public init(
                    name: Swift.String,
                    version: Swift.String,
                    url: Swift.String
                ) {
                    self.name = name
                    self.version = version
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case version
                    case url
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.name = try container.decode(
                        Swift.String.self,
                        forKey: .name
                    )
                    self.version = try container.decode(
                        Swift.String.self,
                        forKey: .version
                    )
                    self.url = try container.decode(
                        Swift.String.self,
                        forKey: .url
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "name",
                        "version",
                        "url"
                    ])
                }
            }
            /// A description of the detector used.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/detector`.
            public var detector: Components.Schemas.Snapshot.DetectorPayload
            /// - Remark: Generated from `#/components/schemas/snapshot/metadata`.
            public var metadata: Components.Schemas.Metadata?
            /// A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/manifests`.
            public struct ManifestsPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: [String: Components.Schemas.Manifest]
                /// Creates a new `ManifestsPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: [String: Components.Schemas.Manifest] = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/manifests`.
            public var manifests: Components.Schemas.Snapshot.ManifestsPayload?
            /// The time at which the snapshot was scanned.
            ///
            /// - Remark: Generated from `#/components/schemas/snapshot/scanned`.
            public var scanned: Foundation.Date
            /// Creates a new `Snapshot`.
            ///
            /// - Parameters:
            ///   - version: The version of the repository snapshot submission.
            ///   - job:
            ///   - sha: The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.
            ///   - ref: The repository branch that triggered this snapshot.
            ///   - detector: A description of the detector used.
            ///   - metadata:
            ///   - manifests: A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.
            ///   - scanned: The time at which the snapshot was scanned.
            public init(
                version: Swift.Int,
                job: Components.Schemas.Snapshot.JobPayload,
                sha: Swift.String,
                ref: Swift.String,
                detector: Components.Schemas.Snapshot.DetectorPayload,
                metadata: Components.Schemas.Metadata? = nil,
                manifests: Components.Schemas.Snapshot.ManifestsPayload? = nil,
                scanned: Foundation.Date
            ) {
                self.version = version
                self.job = job
                self.sha = sha
                self.ref = ref
                self.detector = detector
                self.metadata = metadata
                self.manifests = manifests
                self.scanned = scanned
            }
            public enum CodingKeys: String, CodingKey {
                case version
                case job
                case sha
                case ref
                case detector
                case metadata
                case manifests
                case scanned
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.version = try container.decode(
                    Swift.Int.self,
                    forKey: .version
                )
                self.job = try container.decode(
                    Components.Schemas.Snapshot.JobPayload.self,
                    forKey: .job
                )
                self.sha = try container.decode(
                    Swift.String.self,
                    forKey: .sha
                )
                self.ref = try container.decode(
                    Swift.String.self,
                    forKey: .ref
                )
                self.detector = try container.decode(
                    Components.Schemas.Snapshot.DetectorPayload.self,
                    forKey: .detector
                )
                self.metadata = try container.decodeIfPresent(
                    Components.Schemas.Metadata.self,
                    forKey: .metadata
                )
                self.manifests = try container.decodeIfPresent(
                    Components.Schemas.Snapshot.ManifestsPayload.self,
                    forKey: .manifests
                )
                self.scanned = try container.decode(
                    Foundation.Date.self,
                    forKey: .scanned
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "version",
                    "job",
                    "sha",
                    "ref",
                    "detector",
                    "metadata",
                    "manifests",
                    "scanned"
                ])
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The full path, relative to the repository root, of the dependency manifest file.
        ///
        /// - Remark: Generated from `#/components/parameters/manifest-path`.
        public typealias ManifestPath = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct DependencyReviewForbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/dependency_review_forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/dependency_review_forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.DependencyReviewForbidden.Body
            /// Creates a new `DependencyReviewForbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.DependencyReviewForbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get a diff of the dependencies between commits
    ///
    /// Gets the diff of the dependency changes between two commits of a repository, based on the changes to the dependency manifests made in those commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependency-graph/compare/{basehead}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/compare/{basehead}/get(dependency-graph/diff-range)`.
    public enum DependencyGraphDiffRange {
        public static let id: Swift.String = "dependency-graph/diff-range"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The base and head Git revisions to compare. The Git revisions will be resolved to commit SHAs. Named revisions will be resolved to their corresponding HEAD commits, and an appropriate merge base will be determined. This parameter expects the format `{base}...{head}`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/path/basehead`.
                public var basehead: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - basehead: The base and head Git revisions to compare. The Git revisions will be resolved to commit SHAs. Named revisions will be resolved to their corresponding HEAD commits, and an appropriate merge base will be determined. This parameter expects the format `{base}...{head}`.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    basehead: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.basehead = basehead
                }
            }
            public var path: Operations.DependencyGraphDiffRange.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The full path, relative to the repository root, of the dependency manifest file.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/query/name`.
                public var name: Components.Parameters.ManifestPath?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - name: The full path, relative to the repository root, of the dependency manifest file.
                public init(name: Components.Parameters.ManifestPath? = nil) {
                    self.name = name
                }
            }
            public var query: Operations.DependencyGraphDiffRange.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependencyGraphDiffRange.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependencyGraphDiffRange.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependencyGraphDiffRange.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependencyGraphDiffRange.Input.Path,
                query: Operations.DependencyGraphDiffRange.Input.Query = .init(),
                headers: Operations.DependencyGraphDiffRange.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.DependencyGraphDiffRange.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/compare/{basehead}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependencyGraphDiff)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependencyGraphDiff {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependencyGraphDiffRange.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.DependencyGraphDiffRange.Output.Ok.Headers = .init(),
                    body: Operations.DependencyGraphDiffRange.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/compare/{basehead}/get(dependency-graph/diff-range)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependencyGraphDiffRange.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependencyGraphDiffRange.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/compare/{basehead}/get(dependency-graph/diff-range)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Response for a private repository when GitHub Advanced Security is not enabled, or if used against a fork
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/compare/{basehead}/get(dependency-graph/diff-range)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.DependencyReviewForbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.DependencyReviewForbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Export a software bill of materials (SBOM) for a repository.
    ///
    /// Exports the software bill of materials (SBOM) for a repository in SPDX JSON format.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependency-graph/sbom`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/sbom/get(dependency-graph/export-sbom)`.
    public enum DependencyGraphExportSbom {
        public static let id: Swift.String = "dependency-graph/export-sbom"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.DependencyGraphExportSbom.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependencyGraphExportSbom.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependencyGraphExportSbom.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependencyGraphExportSbom.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.DependencyGraphExportSbom.Input.Path,
                headers: Operations.DependencyGraphExportSbom.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.DependencyGraphExportSbom.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/sbom/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependencyGraphSpdxSbom)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependencyGraphSpdxSbom {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependencyGraphExportSbom.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.DependencyGraphExportSbom.Output.Ok.Headers = .init(),
                    body: Operations.DependencyGraphExportSbom.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/sbom/get(dependency-graph/export-sbom)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependencyGraphExportSbom.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependencyGraphExportSbom.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/sbom/get(dependency-graph/export-sbom)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/sbom/get(dependency-graph/export-sbom)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a snapshot of dependencies for a repository
    ///
    /// Create a new snapshot of a repository's dependencies.
    ///
    /// The authenticated user must have access to the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/dependency-graph/snapshots`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/snapshots/post(dependency-graph/create-repository-snapshot)`.
    public enum DependencyGraphCreateRepositorySnapshot {
        public static let id: Swift.String = "dependency-graph/create-repository-snapshot"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.DependencyGraphCreateRepositorySnapshot.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependencyGraphCreateRepositorySnapshot.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependencyGraphCreateRepositorySnapshot.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependencyGraphCreateRepositorySnapshot.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.Snapshot)
            }
            public var body: Operations.DependencyGraphCreateRepositorySnapshot.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.DependencyGraphCreateRepositorySnapshot.Input.Path,
                headers: Operations.DependencyGraphCreateRepositorySnapshot.Input.Headers = .init(),
                body: Operations.DependencyGraphCreateRepositorySnapshot.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// ID of the created snapshot.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content/json/id`.
                        public var id: Swift.Int
                        /// The time at which the snapshot was created.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content/json/created_at`.
                        public var createdAt: Swift.String
                        /// Either "SUCCESS", "ACCEPTED", or "INVALID". "SUCCESS" indicates that the snapshot was successfully created and the repository's dependencies were updated. "ACCEPTED" indicates that the snapshot was successfully created, but the repository's dependencies were not updated. "INVALID" indicates that the snapshot was malformed.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content/json/result`.
                        public var result: Swift.String
                        /// A message providing further details about the result, such as why the dependencies were not updated.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content/json/message`.
                        public var message: Swift.String
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - id: ID of the created snapshot.
                        ///   - createdAt: The time at which the snapshot was created.
                        ///   - result: Either "SUCCESS", "ACCEPTED", or "INVALID". "SUCCESS" indicates that the snapshot was successfully created and the repository's dependencies were updated. "ACCEPTED" indicates that the snapshot was successfully created, but the repository's dependencies were not updated. "INVALID" indicates that the snapshot was malformed.
                        ///   - message: A message providing further details about the result, such as why the dependencies were not updated.
                        public init(
                            id: Swift.Int,
                            createdAt: Swift.String,
                            result: Swift.String,
                            message: Swift.String
                        ) {
                            self.id = id
                            self.createdAt = createdAt
                            self.result = result
                            self.message = message
                        }
                        public enum CodingKeys: String, CodingKey {
                            case id
                            case createdAt = "created_at"
                            case result
                            case message
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependency-graph/snapshots/POST/responses/201/content/application\/json`.
                    case json(Operations.DependencyGraphCreateRepositorySnapshot.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.DependencyGraphCreateRepositorySnapshot.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependencyGraphCreateRepositorySnapshot.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependencyGraphCreateRepositorySnapshot.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependency-graph/snapshots/post(dependency-graph/create-repository-snapshot)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.DependencyGraphCreateRepositorySnapshot.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.DependencyGraphCreateRepositorySnapshot.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
