// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get Copilot seat information and settings for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Gets information about an organization's Copilot subscription, including seat breakdown
    /// and feature policies. To configure these settings, go to your organization's settings on GitHub.com.
    /// For more information, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-policies-for-copilot-business-in-your-organization)."
    ///
    /// Only organization owners can view details about the organization's Copilot Business or Copilot Enterprise subscription.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/billing`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)`.
    func copilotGetCopilotOrganizationDetails(_ input: Operations.CopilotGetCopilotOrganizationDetails.Input) async throws -> Operations.CopilotGetCopilotOrganizationDetails.Output
    /// List all Copilot seat assignments for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Lists all Copilot seats for which an organization with a Copilot Business or Copilot Enterprise subscription is currently being billed.
    /// Only organization owners can view assigned seats.
    ///
    /// Each seat object contains information about the assigned user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
    /// For more information about activity data, see "[Reviewing user activity data for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/reviewing-activity-related-to-github-copilot-in-your-organization/reviewing-user-activity-data-for-copilot-in-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/billing/seats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)`.
    func copilotListCopilotSeats(_ input: Operations.CopilotListCopilotSeats.Input) async throws -> Operations.CopilotListCopilotSeats.Output
    /// Add teams to the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Purchases a GitHub Copilot seat for all users within each specified team.
    /// The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."
    ///
    /// Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
    /// For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
    /// For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."
    ///
    /// The response contains the total number of new seats that were created and existing seats that were refreshed.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/copilot/billing/selected_teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)`.
    func copilotAddCopilotSeatsForTeams(_ input: Operations.CopilotAddCopilotSeatsForTeams.Input) async throws -> Operations.CopilotAddCopilotSeatsForTeams.Output
    /// Remove teams from the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Sets seats for all members of each team specified to "pending cancellation".
    /// This will cause the members of the specified team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another team.
    /// For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."
    ///
    /// Only organization owners can cancel Copilot seats for their organization members.
    ///
    /// The response contains the total number of seats set to "pending cancellation".
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/copilot/billing/selected_teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)`.
    func copilotCancelCopilotSeatAssignmentForTeams(_ input: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input) async throws -> Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output
    /// Add users to the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Purchases a GitHub Copilot seat for each user specified.
    /// The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."
    ///
    /// Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
    /// For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
    /// For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."
    ///
    /// The response contains the total number of new seats that were created and existing seats that were refreshed.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/copilot/billing/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)`.
    func copilotAddCopilotSeatsForUsers(_ input: Operations.CopilotAddCopilotSeatsForUsers.Input) async throws -> Operations.CopilotAddCopilotSeatsForUsers.Output
    /// Remove users from the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Sets seats for all users specified to "pending cancellation".
    /// This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team membership.
    /// For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."
    ///
    /// Only organization owners can cancel Copilot seats for their organization members.
    ///
    /// The response contains the total number of seats set to "pending cancellation".
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/copilot/billing/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)`.
    func copilotCancelCopilotSeatAssignmentForUsers(_ input: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input) async throws -> Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output
    /// Get Copilot metrics for an organization
    ///
    /// Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.
    ///
    /// > [!NOTE]
    /// > This endpoint will only return results for a given day if the organization contained **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.
    ///
    /// The response contains metrics for up to 28 days prior. Metrics are processed once per day for the previous day,
    /// and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
    /// they must have telemetry enabled in their IDE.
    ///
    /// To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization.
    /// Only organization owners and owners and billing managers of the parent enterprise can view Copilot metrics.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/metrics`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)`.
    func copilotCopilotMetricsForOrganization(_ input: Operations.CopilotCopilotMetricsForOrganization.Input) async throws -> Operations.CopilotCopilotMetricsForOrganization.Output
    /// Get Copilot seat assignment details for a user
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Gets the GitHub Copilot seat details for a member of an organization who currently has access to GitHub Copilot.
    ///
    /// The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
    /// For more information about activity data, see "[Reviewing user activity data for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/reviewing-activity-related-to-github-copilot-in-your-organization/reviewing-user-activity-data-for-copilot-in-your-organization)."
    ///
    /// Only organization owners can view Copilot seat assignment details for members of their organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}/copilot`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)`.
    func copilotGetCopilotSeatDetailsForUser(_ input: Operations.CopilotGetCopilotSeatDetailsForUser.Input) async throws -> Operations.CopilotGetCopilotSeatDetailsForUser.Output
    /// Get Copilot metrics for a team
    ///
    /// Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.
    ///
    /// > [!NOTE]
    /// > This endpoint will only return results for a given day if the team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.
    ///
    /// The response contains metrics for up to 28 days prior. Metrics are processed once per day for the previous day,
    /// and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
    /// they must have telemetry enabled in their IDE.
    ///
    /// To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization containing the team within GitHub settings.
    /// Only organization owners for the organization that contains this team and owners and billing managers of the parent enterprise can view Copilot metrics for a team.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/team/{team_slug}/copilot/metrics`.
    /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)`.
    func copilotCopilotMetricsForTeam(_ input: Operations.CopilotCopilotMetricsForTeam.Input) async throws -> Operations.CopilotCopilotMetricsForTeam.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get Copilot seat information and settings for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Gets information about an organization's Copilot subscription, including seat breakdown
    /// and feature policies. To configure these settings, go to your organization's settings on GitHub.com.
    /// For more information, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-policies-for-copilot-business-in-your-organization)."
    ///
    /// Only organization owners can view details about the organization's Copilot Business or Copilot Enterprise subscription.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/billing`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)`.
    public func copilotGetCopilotOrganizationDetails(
        path: Operations.CopilotGetCopilotOrganizationDetails.Input.Path,
        headers: Operations.CopilotGetCopilotOrganizationDetails.Input.Headers = .init()
    ) async throws -> Operations.CopilotGetCopilotOrganizationDetails.Output {
        try await copilotGetCopilotOrganizationDetails(Operations.CopilotGetCopilotOrganizationDetails.Input(
            path: path,
            headers: headers
        ))
    }
    /// List all Copilot seat assignments for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Lists all Copilot seats for which an organization with a Copilot Business or Copilot Enterprise subscription is currently being billed.
    /// Only organization owners can view assigned seats.
    ///
    /// Each seat object contains information about the assigned user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
    /// For more information about activity data, see "[Reviewing user activity data for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/reviewing-activity-related-to-github-copilot-in-your-organization/reviewing-user-activity-data-for-copilot-in-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/billing/seats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)`.
    public func copilotListCopilotSeats(
        path: Operations.CopilotListCopilotSeats.Input.Path,
        query: Operations.CopilotListCopilotSeats.Input.Query = .init(),
        headers: Operations.CopilotListCopilotSeats.Input.Headers = .init()
    ) async throws -> Operations.CopilotListCopilotSeats.Output {
        try await copilotListCopilotSeats(Operations.CopilotListCopilotSeats.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Add teams to the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Purchases a GitHub Copilot seat for all users within each specified team.
    /// The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."
    ///
    /// Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
    /// For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
    /// For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."
    ///
    /// The response contains the total number of new seats that were created and existing seats that were refreshed.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/copilot/billing/selected_teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)`.
    public func copilotAddCopilotSeatsForTeams(
        path: Operations.CopilotAddCopilotSeatsForTeams.Input.Path,
        headers: Operations.CopilotAddCopilotSeatsForTeams.Input.Headers = .init(),
        body: Operations.CopilotAddCopilotSeatsForTeams.Input.Body
    ) async throws -> Operations.CopilotAddCopilotSeatsForTeams.Output {
        try await copilotAddCopilotSeatsForTeams(Operations.CopilotAddCopilotSeatsForTeams.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove teams from the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Sets seats for all members of each team specified to "pending cancellation".
    /// This will cause the members of the specified team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another team.
    /// For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."
    ///
    /// Only organization owners can cancel Copilot seats for their organization members.
    ///
    /// The response contains the total number of seats set to "pending cancellation".
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/copilot/billing/selected_teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)`.
    public func copilotCancelCopilotSeatAssignmentForTeams(
        path: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Path,
        headers: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Headers = .init(),
        body: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Body
    ) async throws -> Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output {
        try await copilotCancelCopilotSeatAssignmentForTeams(Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Add users to the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Purchases a GitHub Copilot seat for each user specified.
    /// The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."
    ///
    /// Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
    /// For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
    /// For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."
    ///
    /// The response contains the total number of new seats that were created and existing seats that were refreshed.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/copilot/billing/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)`.
    public func copilotAddCopilotSeatsForUsers(
        path: Operations.CopilotAddCopilotSeatsForUsers.Input.Path,
        headers: Operations.CopilotAddCopilotSeatsForUsers.Input.Headers = .init(),
        body: Operations.CopilotAddCopilotSeatsForUsers.Input.Body
    ) async throws -> Operations.CopilotAddCopilotSeatsForUsers.Output {
        try await copilotAddCopilotSeatsForUsers(Operations.CopilotAddCopilotSeatsForUsers.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove users from the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Sets seats for all users specified to "pending cancellation".
    /// This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team membership.
    /// For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."
    ///
    /// Only organization owners can cancel Copilot seats for their organization members.
    ///
    /// The response contains the total number of seats set to "pending cancellation".
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/copilot/billing/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)`.
    public func copilotCancelCopilotSeatAssignmentForUsers(
        path: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Path,
        headers: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Headers = .init(),
        body: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Body
    ) async throws -> Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output {
        try await copilotCancelCopilotSeatAssignmentForUsers(Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get Copilot metrics for an organization
    ///
    /// Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.
    ///
    /// > [!NOTE]
    /// > This endpoint will only return results for a given day if the organization contained **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.
    ///
    /// The response contains metrics for up to 28 days prior. Metrics are processed once per day for the previous day,
    /// and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
    /// they must have telemetry enabled in their IDE.
    ///
    /// To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization.
    /// Only organization owners and owners and billing managers of the parent enterprise can view Copilot metrics.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/metrics`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)`.
    public func copilotCopilotMetricsForOrganization(
        path: Operations.CopilotCopilotMetricsForOrganization.Input.Path,
        query: Operations.CopilotCopilotMetricsForOrganization.Input.Query = .init(),
        headers: Operations.CopilotCopilotMetricsForOrganization.Input.Headers = .init()
    ) async throws -> Operations.CopilotCopilotMetricsForOrganization.Output {
        try await copilotCopilotMetricsForOrganization(Operations.CopilotCopilotMetricsForOrganization.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get Copilot seat assignment details for a user
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Gets the GitHub Copilot seat details for a member of an organization who currently has access to GitHub Copilot.
    ///
    /// The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
    /// For more information about activity data, see "[Reviewing user activity data for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/reviewing-activity-related-to-github-copilot-in-your-organization/reviewing-user-activity-data-for-copilot-in-your-organization)."
    ///
    /// Only organization owners can view Copilot seat assignment details for members of their organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}/copilot`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)`.
    public func copilotGetCopilotSeatDetailsForUser(
        path: Operations.CopilotGetCopilotSeatDetailsForUser.Input.Path,
        headers: Operations.CopilotGetCopilotSeatDetailsForUser.Input.Headers = .init()
    ) async throws -> Operations.CopilotGetCopilotSeatDetailsForUser.Output {
        try await copilotGetCopilotSeatDetailsForUser(Operations.CopilotGetCopilotSeatDetailsForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get Copilot metrics for a team
    ///
    /// Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.
    ///
    /// > [!NOTE]
    /// > This endpoint will only return results for a given day if the team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.
    ///
    /// The response contains metrics for up to 28 days prior. Metrics are processed once per day for the previous day,
    /// and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
    /// they must have telemetry enabled in their IDE.
    ///
    /// To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization containing the team within GitHub settings.
    /// Only organization owners for the organization that contains this team and owners and billing managers of the parent enterprise can view Copilot metrics for a team.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/team/{team_slug}/copilot/metrics`.
    /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)`.
    public func copilotCopilotMetricsForTeam(
        path: Operations.CopilotCopilotMetricsForTeam.Input.Path,
        query: Operations.CopilotCopilotMetricsForTeam.Input.Query = .init(),
        headers: Operations.CopilotCopilotMetricsForTeam.Input.Headers = .init()
    ) async throws -> Operations.CopilotCopilotMetricsForTeam.Output {
        try await copilotCopilotMetricsForTeam(Operations.CopilotCopilotMetricsForTeam.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// The breakdown of Copilot Business seats for the organization.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown`.
        public struct CopilotOrganizationSeatBreakdown: Codable, Hashable, Sendable {
            /// The total number of seats being billed for the organization as of the current billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown/total`.
            public var total: Swift.Int?
            /// Seats added during the current billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown/added_this_cycle`.
            public var addedThisCycle: Swift.Int?
            /// The number of seats that are pending cancellation at the end of the current billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown/pending_cancellation`.
            public var pendingCancellation: Swift.Int?
            /// The number of users who have been invited to receive a Copilot seat through this organization.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown/pending_invitation`.
            public var pendingInvitation: Swift.Int?
            /// The number of seats that have used Copilot during the current billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown/active_this_cycle`.
            public var activeThisCycle: Swift.Int?
            /// The number of seats that have not used Copilot during the current billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-seat-breakdown/inactive_this_cycle`.
            public var inactiveThisCycle: Swift.Int?
            /// Creates a new `CopilotOrganizationSeatBreakdown`.
            ///
            /// - Parameters:
            ///   - total: The total number of seats being billed for the organization as of the current billing cycle.
            ///   - addedThisCycle: Seats added during the current billing cycle.
            ///   - pendingCancellation: The number of seats that are pending cancellation at the end of the current billing cycle.
            ///   - pendingInvitation: The number of users who have been invited to receive a Copilot seat through this organization.
            ///   - activeThisCycle: The number of seats that have used Copilot during the current billing cycle.
            ///   - inactiveThisCycle: The number of seats that have not used Copilot during the current billing cycle.
            public init(
                total: Swift.Int? = nil,
                addedThisCycle: Swift.Int? = nil,
                pendingCancellation: Swift.Int? = nil,
                pendingInvitation: Swift.Int? = nil,
                activeThisCycle: Swift.Int? = nil,
                inactiveThisCycle: Swift.Int? = nil
            ) {
                self.total = total
                self.addedThisCycle = addedThisCycle
                self.pendingCancellation = pendingCancellation
                self.pendingInvitation = pendingInvitation
                self.activeThisCycle = activeThisCycle
                self.inactiveThisCycle = inactiveThisCycle
            }
            public enum CodingKeys: String, CodingKey {
                case total
                case addedThisCycle = "added_this_cycle"
                case pendingCancellation = "pending_cancellation"
                case pendingInvitation = "pending_invitation"
                case activeThisCycle = "active_this_cycle"
                case inactiveThisCycle = "inactive_this_cycle"
            }
        }
        /// Information about the seat breakdown and policies set for an organization with a Copilot Business or Copilot Enterprise subscription.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-organization-details`.
        public struct CopilotOrganizationDetails: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/seat_breakdown`.
            public var seatBreakdown: Components.Schemas.CopilotOrganizationSeatBreakdown
            /// The organization policy for allowing or blocking suggestions matching public code (duplication detection filter).
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/public_code_suggestions`.
            @frozen public enum PublicCodeSuggestionsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case allow = "allow"
                case block = "block"
                case unconfigured = "unconfigured"
            }
            /// The organization policy for allowing or blocking suggestions matching public code (duplication detection filter).
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/public_code_suggestions`.
            public var publicCodeSuggestions: Components.Schemas.CopilotOrganizationDetails.PublicCodeSuggestionsPayload
            /// The organization policy for allowing or disallowing Copilot Chat in the IDE.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/ide_chat`.
            @frozen public enum IdeChatPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case unconfigured = "unconfigured"
            }
            /// The organization policy for allowing or disallowing Copilot Chat in the IDE.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/ide_chat`.
            public var ideChat: Components.Schemas.CopilotOrganizationDetails.IdeChatPayload?
            /// The organization policy for allowing or disallowing Copilot features on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/platform_chat`.
            @frozen public enum PlatformChatPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case unconfigured = "unconfigured"
            }
            /// The organization policy for allowing or disallowing Copilot features on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/platform_chat`.
            public var platformChat: Components.Schemas.CopilotOrganizationDetails.PlatformChatPayload?
            /// The organization policy for allowing or disallowing Copilot in the CLI.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/cli`.
            @frozen public enum CliPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enabled = "enabled"
                case disabled = "disabled"
                case unconfigured = "unconfigured"
            }
            /// The organization policy for allowing or disallowing Copilot in the CLI.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/cli`.
            public var cli: Components.Schemas.CopilotOrganizationDetails.CliPayload?
            /// The mode of assigning new seats.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/seat_management_setting`.
            @frozen public enum SeatManagementSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case assignAll = "assign_all"
                case assignSelected = "assign_selected"
                case disabled = "disabled"
                case unconfigured = "unconfigured"
            }
            /// The mode of assigning new seats.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/seat_management_setting`.
            public var seatManagementSetting: Components.Schemas.CopilotOrganizationDetails.SeatManagementSettingPayload
            /// The Copilot plan of the organization, or the parent enterprise, when applicable.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/plan_type`.
            @frozen public enum PlanTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case business = "business"
                case enterprise = "enterprise"
            }
            /// The Copilot plan of the organization, or the parent enterprise, when applicable.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-organization-details/plan_type`.
            public var planType: Components.Schemas.CopilotOrganizationDetails.PlanTypePayload?
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `CopilotOrganizationDetails`.
            ///
            /// - Parameters:
            ///   - seatBreakdown:
            ///   - publicCodeSuggestions: The organization policy for allowing or blocking suggestions matching public code (duplication detection filter).
            ///   - ideChat: The organization policy for allowing or disallowing Copilot Chat in the IDE.
            ///   - platformChat: The organization policy for allowing or disallowing Copilot features on GitHub.com.
            ///   - cli: The organization policy for allowing or disallowing Copilot in the CLI.
            ///   - seatManagementSetting: The mode of assigning new seats.
            ///   - planType: The Copilot plan of the organization, or the parent enterprise, when applicable.
            ///   - additionalProperties: A container of undocumented properties.
            public init(
                seatBreakdown: Components.Schemas.CopilotOrganizationSeatBreakdown,
                publicCodeSuggestions: Components.Schemas.CopilotOrganizationDetails.PublicCodeSuggestionsPayload,
                ideChat: Components.Schemas.CopilotOrganizationDetails.IdeChatPayload? = nil,
                platformChat: Components.Schemas.CopilotOrganizationDetails.PlatformChatPayload? = nil,
                cli: Components.Schemas.CopilotOrganizationDetails.CliPayload? = nil,
                seatManagementSetting: Components.Schemas.CopilotOrganizationDetails.SeatManagementSettingPayload,
                planType: Components.Schemas.CopilotOrganizationDetails.PlanTypePayload? = nil,
                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
            ) {
                self.seatBreakdown = seatBreakdown
                self.publicCodeSuggestions = publicCodeSuggestions
                self.ideChat = ideChat
                self.platformChat = platformChat
                self.cli = cli
                self.seatManagementSetting = seatManagementSetting
                self.planType = planType
                self.additionalProperties = additionalProperties
            }
            public enum CodingKeys: String, CodingKey {
                case seatBreakdown = "seat_breakdown"
                case publicCodeSuggestions = "public_code_suggestions"
                case ideChat = "ide_chat"
                case platformChat = "platform_chat"
                case cli
                case seatManagementSetting = "seat_management_setting"
                case planType = "plan_type"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.seatBreakdown = try container.decode(
                    Components.Schemas.CopilotOrganizationSeatBreakdown.self,
                    forKey: .seatBreakdown
                )
                self.publicCodeSuggestions = try container.decode(
                    Components.Schemas.CopilotOrganizationDetails.PublicCodeSuggestionsPayload.self,
                    forKey: .publicCodeSuggestions
                )
                self.ideChat = try container.decodeIfPresent(
                    Components.Schemas.CopilotOrganizationDetails.IdeChatPayload.self,
                    forKey: .ideChat
                )
                self.platformChat = try container.decodeIfPresent(
                    Components.Schemas.CopilotOrganizationDetails.PlatformChatPayload.self,
                    forKey: .platformChat
                )
                self.cli = try container.decodeIfPresent(
                    Components.Schemas.CopilotOrganizationDetails.CliPayload.self,
                    forKey: .cli
                )
                self.seatManagementSetting = try container.decode(
                    Components.Schemas.CopilotOrganizationDetails.SeatManagementSettingPayload.self,
                    forKey: .seatManagementSetting
                )
                self.planType = try container.decodeIfPresent(
                    Components.Schemas.CopilotOrganizationDetails.PlanTypePayload.self,
                    forKey: .planType
                )
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                    "seat_breakdown",
                    "public_code_suggestions",
                    "ide_chat",
                    "platform_chat",
                    "cli",
                    "seat_management_setting",
                    "plan_type"
                ])
            }
            public func encode(to encoder: any Encoder) throws {
                var container = encoder.container(keyedBy: CodingKeys.self)
                try container.encode(
                    self.seatBreakdown,
                    forKey: .seatBreakdown
                )
                try container.encode(
                    self.publicCodeSuggestions,
                    forKey: .publicCodeSuggestions
                )
                try container.encodeIfPresent(
                    self.ideChat,
                    forKey: .ideChat
                )
                try container.encodeIfPresent(
                    self.platformChat,
                    forKey: .platformChat
                )
                try container.encodeIfPresent(
                    self.cli,
                    forKey: .cli
                )
                try container.encode(
                    self.seatManagementSetting,
                    forKey: .seatManagementSetting
                )
                try container.encodeIfPresent(
                    self.planType,
                    forKey: .planType
                )
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// A GitHub organization.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-organization-simple`.
        public struct NullableOrganizationSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/public_members_url`.
            public var publicMembersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-organization-simple/description`.
            public var description: Swift.String?
            /// Creates a new `NullableOrganizationSimple`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - hooksUrl:
            ///   - issuesUrl:
            ///   - membersUrl:
            ///   - publicMembersUrl:
            ///   - avatarUrl:
            ///   - description:
            public init(
                login: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                hooksUrl: Swift.String,
                issuesUrl: Swift.String,
                membersUrl: Swift.String,
                publicMembersUrl: Swift.String,
                avatarUrl: Swift.String,
                description: Swift.String? = nil
            ) {
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.hooksUrl = hooksUrl
                self.issuesUrl = issuesUrl
                self.membersUrl = membersUrl
                self.publicMembersUrl = publicMembersUrl
                self.avatarUrl = avatarUrl
                self.description = description
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case nodeId = "node_id"
                case url
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case hooksUrl = "hooks_url"
                case issuesUrl = "issues_url"
                case membersUrl = "members_url"
                case publicMembersUrl = "public_members_url"
                case avatarUrl = "avatar_url"
                case description
            }
        }
        /// Group of enterprise owners and/or members
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise-team`.
        public struct EnterpriseTeam: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/enterprise-team/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/enterprise-team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise-team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise-team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise-team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise-team/sync_to_organizations`.
            public var syncToOrganizations: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise-team/organization_selection_type`.
            public var organizationSelectionType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise-team/group_id`.
            public var groupId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise-team/group_name`.
            public var groupName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise-team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise-team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise-team/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/enterprise-team/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `EnterpriseTeam`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - name:
            ///   - description:
            ///   - slug:
            ///   - url:
            ///   - syncToOrganizations:
            ///   - organizationSelectionType:
            ///   - groupId:
            ///   - groupName:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                id: Swift.Int64,
                name: Swift.String,
                description: Swift.String? = nil,
                slug: Swift.String,
                url: Swift.String,
                syncToOrganizations: Swift.String? = nil,
                organizationSelectionType: Swift.String? = nil,
                groupId: Swift.String? = nil,
                groupName: Swift.String? = nil,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.id = id
                self.name = name
                self.description = description
                self.slug = slug
                self.url = url
                self.syncToOrganizations = syncToOrganizations
                self.organizationSelectionType = organizationSelectionType
                self.groupId = groupId
                self.groupName = groupName
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case description
                case slug
                case url
                case syncToOrganizations = "sync_to_organizations"
                case organizationSelectionType = "organization_selection_type"
                case groupId = "group_id"
                case groupName = "group_name"
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Information about a Copilot Business seat assignment for a user, team, or organization.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-seat-details`.
        public struct CopilotSeatDetails: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/organization`.
            public var organization: Components.Schemas.NullableOrganizationSimple?
            /// The team through which the assignee is granted access to GitHub Copilot, if applicable.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/assigning_team`.
            @frozen public enum AssigningTeamPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/copilot-seat-details/assigning_team/case1`.
                case Team(Components.Schemas.Team)
                /// - Remark: Generated from `#/components/schemas/copilot-seat-details/assigning_team/case2`.
                case EnterpriseTeam(Components.Schemas.EnterpriseTeam)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .Team(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .EnterpriseTeam(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .Team(value):
                        try value.encode(to: encoder)
                    case let .EnterpriseTeam(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// The team through which the assignee is granted access to GitHub Copilot, if applicable.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/assigning_team`.
            public var assigningTeam: Components.Schemas.CopilotSeatDetails.AssigningTeamPayload?
            /// The pending cancellation date for the seat, in `YYYY-MM-DD` format. This will be null unless the assignee's Copilot access has been canceled during the current billing cycle. If the seat has been cancelled, this corresponds to the start of the organization's next billing cycle.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/pending_cancellation_date`.
            public var pendingCancellationDate: Swift.String?
            /// Timestamp of user's last GitHub Copilot activity, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/last_activity_at`.
            public var lastActivityAt: Foundation.Date?
            /// Last editor that was used by the user for a GitHub Copilot completion.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/last_activity_editor`.
            public var lastActivityEditor: Swift.String?
            /// Timestamp of when the assignee was last granted access to GitHub Copilot, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/created_at`.
            public var createdAt: Foundation.Date
            /// **Closing down notice:** This field is no longer relevant and is closing down. Use the `created_at` field to determine when the assignee was last granted access to GitHub Copilot. Timestamp of when the assignee's GitHub Copilot access was last updated, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/updated_at`.
            @available(*, deprecated)
            public var updatedAt: Foundation.Date?
            /// The Copilot plan of the organization, or the parent enterprise, when applicable.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/plan_type`.
            @frozen public enum PlanTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case business = "business"
                case enterprise = "enterprise"
                case unknown = "unknown"
            }
            /// The Copilot plan of the organization, or the parent enterprise, when applicable.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-seat-details/plan_type`.
            public var planType: Components.Schemas.CopilotSeatDetails.PlanTypePayload?
            /// Creates a new `CopilotSeatDetails`.
            ///
            /// - Parameters:
            ///   - assignee:
            ///   - organization:
            ///   - assigningTeam: The team through which the assignee is granted access to GitHub Copilot, if applicable.
            ///   - pendingCancellationDate: The pending cancellation date for the seat, in `YYYY-MM-DD` format. This will be null unless the assignee's Copilot access has been canceled during the current billing cycle. If the seat has been cancelled, this corresponds to the start of the organization's next billing cycle.
            ///   - lastActivityAt: Timestamp of user's last GitHub Copilot activity, in ISO 8601 format.
            ///   - lastActivityEditor: Last editor that was used by the user for a GitHub Copilot completion.
            ///   - createdAt: Timestamp of when the assignee was last granted access to GitHub Copilot, in ISO 8601 format.
            ///   - updatedAt: **Closing down notice:** This field is no longer relevant and is closing down. Use the `created_at` field to determine when the assignee was last granted access to GitHub Copilot. Timestamp of when the assignee's GitHub Copilot access was last updated, in ISO 8601 format.
            ///   - planType: The Copilot plan of the organization, or the parent enterprise, when applicable.
            public init(
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                organization: Components.Schemas.NullableOrganizationSimple? = nil,
                assigningTeam: Components.Schemas.CopilotSeatDetails.AssigningTeamPayload? = nil,
                pendingCancellationDate: Swift.String? = nil,
                lastActivityAt: Foundation.Date? = nil,
                lastActivityEditor: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date? = nil,
                planType: Components.Schemas.CopilotSeatDetails.PlanTypePayload? = nil
            ) {
                self.assignee = assignee
                self.organization = organization
                self.assigningTeam = assigningTeam
                self.pendingCancellationDate = pendingCancellationDate
                self.lastActivityAt = lastActivityAt
                self.lastActivityEditor = lastActivityEditor
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.planType = planType
            }
            public enum CodingKeys: String, CodingKey {
                case assignee
                case organization
                case assigningTeam = "assigning_team"
                case pendingCancellationDate = "pending_cancellation_date"
                case lastActivityAt = "last_activity_at"
                case lastActivityEditor = "last_activity_editor"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case planType = "plan_type"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.assignee = try container.decodeIfPresent(
                    Components.Schemas.NullableSimpleUser.self,
                    forKey: .assignee
                )
                self.organization = try container.decodeIfPresent(
                    Components.Schemas.NullableOrganizationSimple.self,
                    forKey: .organization
                )
                self.assigningTeam = try container.decodeIfPresent(
                    Components.Schemas.CopilotSeatDetails.AssigningTeamPayload.self,
                    forKey: .assigningTeam
                )
                self.pendingCancellationDate = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .pendingCancellationDate
                )
                self.lastActivityAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .lastActivityAt
                )
                self.lastActivityEditor = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .lastActivityEditor
                )
                self.createdAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .createdAt
                )
                self.updatedAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .updatedAt
                )
                self.planType = try container.decodeIfPresent(
                    Components.Schemas.CopilotSeatDetails.PlanTypePayload.self,
                    forKey: .planType
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "assignee",
                    "organization",
                    "assigning_team",
                    "pending_cancellation_date",
                    "last_activity_at",
                    "last_activity_editor",
                    "created_at",
                    "updated_at",
                    "plan_type"
                ])
            }
        }
        /// Usage metrics for Copilot editor code completions in the IDE.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions`.
        public struct CopilotIdeCodeCompletions: Codable, Hashable, Sendable {
            /// Number of users who accepted at least one Copilot code suggestion, across all active editors. Includes both full and partial acceptances.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/total_engaged_users`.
            public var totalEngagedUsers: Swift.Int?
            /// Usage metrics for a given language for the given editor for Copilot code completions.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/LanguagesPayload`.
            public struct LanguagesPayloadPayload: Codable, Hashable, Sendable {
                /// Name of the language used for Copilot code completion suggestions.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/LanguagesPayload/name`.
                public var name: Swift.String?
                /// Number of users who accepted at least one Copilot code completion suggestion for the given language. Includes both full and partial acceptances.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/LanguagesPayload/total_engaged_users`.
                public var totalEngagedUsers: Swift.Int?
                /// Creates a new `LanguagesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the language used for Copilot code completion suggestions.
                ///   - totalEngagedUsers: Number of users who accepted at least one Copilot code completion suggestion for the given language. Includes both full and partial acceptances.
                public init(
                    name: Swift.String? = nil,
                    totalEngagedUsers: Swift.Int? = nil
                ) {
                    self.name = name
                    self.totalEngagedUsers = totalEngagedUsers
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case totalEngagedUsers = "total_engaged_users"
                }
            }
            /// Code completion metrics for active languages.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/languages`.
            public typealias LanguagesPayload = [Components.Schemas.CopilotIdeCodeCompletions.LanguagesPayloadPayload]
            /// Code completion metrics for active languages.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/languages`.
            public var languages: Components.Schemas.CopilotIdeCodeCompletions.LanguagesPayload?
            /// Copilot code completion metrics for active editors.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload`.
            public struct EditorsPayloadPayload: Codable, Hashable, Sendable {
                /// Name of the given editor.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/name`.
                public var name: Swift.String?
                /// Number of users who accepted at least one Copilot code completion suggestion for the given editor. Includes both full and partial acceptances.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/total_engaged_users`.
                public var totalEngagedUsers: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload`.
                public struct ModelsPayloadPayload: Codable, Hashable, Sendable {
                    /// Name of the model used for Copilot code completion suggestions. If the default model is used will appear as 'default'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/name`.
                    public var name: Swift.String?
                    /// Indicates whether a model is custom or default.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/is_custom_model`.
                    public var isCustomModel: Swift.Bool?
                    /// The training date for the custom model.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/custom_model_training_date`.
                    public var customModelTrainingDate: Swift.String?
                    /// Number of users who accepted at least one Copilot code completion suggestion for the given editor, for the given language and model. Includes both full and partial acceptances.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/total_engaged_users`.
                    public var totalEngagedUsers: Swift.Int?
                    /// Usage metrics for a given language for the given editor for Copilot code completions.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload`.
                    public struct LanguagesPayloadPayload: Codable, Hashable, Sendable {
                        /// Name of the language used for Copilot code completion suggestions, for the given editor.
                        ///
                        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload/name`.
                        public var name: Swift.String?
                        /// Number of users who accepted at least one Copilot code completion suggestion for the given editor, for the given language. Includes both full and partial acceptances.
                        ///
                        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload/total_engaged_users`.
                        public var totalEngagedUsers: Swift.Int?
                        /// The number of Copilot code suggestions generated for the given editor, for the given language.
                        ///
                        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload/total_code_suggestions`.
                        public var totalCodeSuggestions: Swift.Int?
                        /// The number of Copilot code suggestions accepted for the given editor, for the given language. Includes both full and partial acceptances.
                        ///
                        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload/total_code_acceptances`.
                        public var totalCodeAcceptances: Swift.Int?
                        /// The number of lines of code suggested by Copilot code completions for the given editor, for the given language.
                        ///
                        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload/total_code_lines_suggested`.
                        public var totalCodeLinesSuggested: Swift.Int?
                        /// The number of lines of code accepted from Copilot code suggestions for the given editor, for the given language.
                        ///
                        /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/LanguagesPayload/total_code_lines_accepted`.
                        public var totalCodeLinesAccepted: Swift.Int?
                        /// Creates a new `LanguagesPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - name: Name of the language used for Copilot code completion suggestions, for the given editor.
                        ///   - totalEngagedUsers: Number of users who accepted at least one Copilot code completion suggestion for the given editor, for the given language. Includes both full and partial acceptances.
                        ///   - totalCodeSuggestions: The number of Copilot code suggestions generated for the given editor, for the given language.
                        ///   - totalCodeAcceptances: The number of Copilot code suggestions accepted for the given editor, for the given language. Includes both full and partial acceptances.
                        ///   - totalCodeLinesSuggested: The number of lines of code suggested by Copilot code completions for the given editor, for the given language.
                        ///   - totalCodeLinesAccepted: The number of lines of code accepted from Copilot code suggestions for the given editor, for the given language.
                        public init(
                            name: Swift.String? = nil,
                            totalEngagedUsers: Swift.Int? = nil,
                            totalCodeSuggestions: Swift.Int? = nil,
                            totalCodeAcceptances: Swift.Int? = nil,
                            totalCodeLinesSuggested: Swift.Int? = nil,
                            totalCodeLinesAccepted: Swift.Int? = nil
                        ) {
                            self.name = name
                            self.totalEngagedUsers = totalEngagedUsers
                            self.totalCodeSuggestions = totalCodeSuggestions
                            self.totalCodeAcceptances = totalCodeAcceptances
                            self.totalCodeLinesSuggested = totalCodeLinesSuggested
                            self.totalCodeLinesAccepted = totalCodeLinesAccepted
                        }
                        public enum CodingKeys: String, CodingKey {
                            case name
                            case totalEngagedUsers = "total_engaged_users"
                            case totalCodeSuggestions = "total_code_suggestions"
                            case totalCodeAcceptances = "total_code_acceptances"
                            case totalCodeLinesSuggested = "total_code_lines_suggested"
                            case totalCodeLinesAccepted = "total_code_lines_accepted"
                        }
                    }
                    /// Code completion metrics for active languages, for the given editor.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/languages`.
                    public typealias LanguagesPayload = [Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayloadPayload.LanguagesPayloadPayload]
                    /// Code completion metrics for active languages, for the given editor.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/ModelsPayload/languages`.
                    public var languages: Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayloadPayload.LanguagesPayload?
                    /// Creates a new `ModelsPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the model used for Copilot code completion suggestions. If the default model is used will appear as 'default'.
                    ///   - isCustomModel: Indicates whether a model is custom or default.
                    ///   - customModelTrainingDate: The training date for the custom model.
                    ///   - totalEngagedUsers: Number of users who accepted at least one Copilot code completion suggestion for the given editor, for the given language and model. Includes both full and partial acceptances.
                    ///   - languages: Code completion metrics for active languages, for the given editor.
                    public init(
                        name: Swift.String? = nil,
                        isCustomModel: Swift.Bool? = nil,
                        customModelTrainingDate: Swift.String? = nil,
                        totalEngagedUsers: Swift.Int? = nil,
                        languages: Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayloadPayload.LanguagesPayload? = nil
                    ) {
                        self.name = name
                        self.isCustomModel = isCustomModel
                        self.customModelTrainingDate = customModelTrainingDate
                        self.totalEngagedUsers = totalEngagedUsers
                        self.languages = languages
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case isCustomModel = "is_custom_model"
                        case customModelTrainingDate = "custom_model_training_date"
                        case totalEngagedUsers = "total_engaged_users"
                        case languages
                    }
                }
                /// List of model metrics for custom models and the default model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/models`.
                public typealias ModelsPayload = [Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayloadPayload]
                /// List of model metrics for custom models and the default model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/EditorsPayload/models`.
                public var models: Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayload?
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `EditorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the given editor.
                ///   - totalEngagedUsers: Number of users who accepted at least one Copilot code completion suggestion for the given editor. Includes both full and partial acceptances.
                ///   - models: List of model metrics for custom models and the default model.
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    name: Swift.String? = nil,
                    totalEngagedUsers: Swift.Int? = nil,
                    models: Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayload? = nil,
                    additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
                ) {
                    self.name = name
                    self.totalEngagedUsers = totalEngagedUsers
                    self.models = models
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case totalEngagedUsers = "total_engaged_users"
                    case models
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.name = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .name
                    )
                    self.totalEngagedUsers = try container.decodeIfPresent(
                        Swift.Int.self,
                        forKey: .totalEngagedUsers
                    )
                    self.models = try container.decodeIfPresent(
                        Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload.ModelsPayload.self,
                        forKey: .models
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "name",
                        "total_engaged_users",
                        "models"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.name,
                        forKey: .name
                    )
                    try container.encodeIfPresent(
                        self.totalEngagedUsers,
                        forKey: .totalEngagedUsers
                    )
                    try container.encodeIfPresent(
                        self.models,
                        forKey: .models
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/editors`.
            public typealias EditorsPayload = [Components.Schemas.CopilotIdeCodeCompletions.EditorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/copilot-ide-code-completions/editors`.
            public var editors: Components.Schemas.CopilotIdeCodeCompletions.EditorsPayload?
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `CopilotIdeCodeCompletions`.
            ///
            /// - Parameters:
            ///   - totalEngagedUsers: Number of users who accepted at least one Copilot code suggestion, across all active editors. Includes both full and partial acceptances.
            ///   - languages: Code completion metrics for active languages.
            ///   - editors:
            ///   - additionalProperties: A container of undocumented properties.
            public init(
                totalEngagedUsers: Swift.Int? = nil,
                languages: Components.Schemas.CopilotIdeCodeCompletions.LanguagesPayload? = nil,
                editors: Components.Schemas.CopilotIdeCodeCompletions.EditorsPayload? = nil,
                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
            ) {
                self.totalEngagedUsers = totalEngagedUsers
                self.languages = languages
                self.editors = editors
                self.additionalProperties = additionalProperties
            }
            public enum CodingKeys: String, CodingKey {
                case totalEngagedUsers = "total_engaged_users"
                case languages
                case editors
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.totalEngagedUsers = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalEngagedUsers
                )
                self.languages = try container.decodeIfPresent(
                    Components.Schemas.CopilotIdeCodeCompletions.LanguagesPayload.self,
                    forKey: .languages
                )
                self.editors = try container.decodeIfPresent(
                    Components.Schemas.CopilotIdeCodeCompletions.EditorsPayload.self,
                    forKey: .editors
                )
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                    "total_engaged_users",
                    "languages",
                    "editors"
                ])
            }
            public func encode(to encoder: any Encoder) throws {
                var container = encoder.container(keyedBy: CodingKeys.self)
                try container.encodeIfPresent(
                    self.totalEngagedUsers,
                    forKey: .totalEngagedUsers
                )
                try container.encodeIfPresent(
                    self.languages,
                    forKey: .languages
                )
                try container.encodeIfPresent(
                    self.editors,
                    forKey: .editors
                )
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// Usage metrics for Copilot Chat in the IDE.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-ide-chat`.
        public struct CopilotIdeChat: Codable, Hashable, Sendable {
            /// Total number of users who prompted Copilot Chat in the IDE.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/total_engaged_users`.
            public var totalEngagedUsers: Swift.Int?
            /// Copilot Chat metrics, for active editors.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload`.
            public struct EditorsPayloadPayload: Codable, Hashable, Sendable {
                /// Name of the given editor.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/name`.
                public var name: Swift.String?
                /// The number of users who prompted Copilot Chat in the specified editor.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/total_engaged_users`.
                public var totalEngagedUsers: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload`.
                public struct ModelsPayloadPayload: Codable, Hashable, Sendable {
                    /// Name of the model used for Copilot Chat. If the default model is used will appear as 'default'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/name`.
                    public var name: Swift.String?
                    /// Indicates whether a model is custom or default.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/is_custom_model`.
                    public var isCustomModel: Swift.Bool?
                    /// The training date for the custom model.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/custom_model_training_date`.
                    public var customModelTrainingDate: Swift.String?
                    /// The number of users who prompted Copilot Chat in the given editor and model.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/total_engaged_users`.
                    public var totalEngagedUsers: Swift.Int?
                    /// The total number of chats initiated by users in the given editor and model.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/total_chats`.
                    public var totalChats: Swift.Int?
                    /// The number of times users accepted a code suggestion from Copilot Chat using the 'Insert Code' UI element, for the given editor.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/total_chat_insertion_events`.
                    public var totalChatInsertionEvents: Swift.Int?
                    /// The number of times users copied a code suggestion from Copilot Chat using the keyboard, or the 'Copy' UI element, for the given editor.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/ModelsPayload/total_chat_copy_events`.
                    public var totalChatCopyEvents: Swift.Int?
                    /// Creates a new `ModelsPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the model used for Copilot Chat. If the default model is used will appear as 'default'.
                    ///   - isCustomModel: Indicates whether a model is custom or default.
                    ///   - customModelTrainingDate: The training date for the custom model.
                    ///   - totalEngagedUsers: The number of users who prompted Copilot Chat in the given editor and model.
                    ///   - totalChats: The total number of chats initiated by users in the given editor and model.
                    ///   - totalChatInsertionEvents: The number of times users accepted a code suggestion from Copilot Chat using the 'Insert Code' UI element, for the given editor.
                    ///   - totalChatCopyEvents: The number of times users copied a code suggestion from Copilot Chat using the keyboard, or the 'Copy' UI element, for the given editor.
                    public init(
                        name: Swift.String? = nil,
                        isCustomModel: Swift.Bool? = nil,
                        customModelTrainingDate: Swift.String? = nil,
                        totalEngagedUsers: Swift.Int? = nil,
                        totalChats: Swift.Int? = nil,
                        totalChatInsertionEvents: Swift.Int? = nil,
                        totalChatCopyEvents: Swift.Int? = nil
                    ) {
                        self.name = name
                        self.isCustomModel = isCustomModel
                        self.customModelTrainingDate = customModelTrainingDate
                        self.totalEngagedUsers = totalEngagedUsers
                        self.totalChats = totalChats
                        self.totalChatInsertionEvents = totalChatInsertionEvents
                        self.totalChatCopyEvents = totalChatCopyEvents
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case isCustomModel = "is_custom_model"
                        case customModelTrainingDate = "custom_model_training_date"
                        case totalEngagedUsers = "total_engaged_users"
                        case totalChats = "total_chats"
                        case totalChatInsertionEvents = "total_chat_insertion_events"
                        case totalChatCopyEvents = "total_chat_copy_events"
                    }
                }
                /// List of model metrics for custom models and the default model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/models`.
                public typealias ModelsPayload = [Components.Schemas.CopilotIdeChat.EditorsPayloadPayload.ModelsPayloadPayload]
                /// List of model metrics for custom models and the default model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/EditorsPayload/models`.
                public var models: Components.Schemas.CopilotIdeChat.EditorsPayloadPayload.ModelsPayload?
                /// Creates a new `EditorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the given editor.
                ///   - totalEngagedUsers: The number of users who prompted Copilot Chat in the specified editor.
                ///   - models: List of model metrics for custom models and the default model.
                public init(
                    name: Swift.String? = nil,
                    totalEngagedUsers: Swift.Int? = nil,
                    models: Components.Schemas.CopilotIdeChat.EditorsPayloadPayload.ModelsPayload? = nil
                ) {
                    self.name = name
                    self.totalEngagedUsers = totalEngagedUsers
                    self.models = models
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case totalEngagedUsers = "total_engaged_users"
                    case models
                }
            }
            /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/editors`.
            public typealias EditorsPayload = [Components.Schemas.CopilotIdeChat.EditorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/copilot-ide-chat/editors`.
            public var editors: Components.Schemas.CopilotIdeChat.EditorsPayload?
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `CopilotIdeChat`.
            ///
            /// - Parameters:
            ///   - totalEngagedUsers: Total number of users who prompted Copilot Chat in the IDE.
            ///   - editors:
            ///   - additionalProperties: A container of undocumented properties.
            public init(
                totalEngagedUsers: Swift.Int? = nil,
                editors: Components.Schemas.CopilotIdeChat.EditorsPayload? = nil,
                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
            ) {
                self.totalEngagedUsers = totalEngagedUsers
                self.editors = editors
                self.additionalProperties = additionalProperties
            }
            public enum CodingKeys: String, CodingKey {
                case totalEngagedUsers = "total_engaged_users"
                case editors
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.totalEngagedUsers = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalEngagedUsers
                )
                self.editors = try container.decodeIfPresent(
                    Components.Schemas.CopilotIdeChat.EditorsPayload.self,
                    forKey: .editors
                )
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                    "total_engaged_users",
                    "editors"
                ])
            }
            public func encode(to encoder: any Encoder) throws {
                var container = encoder.container(keyedBy: CodingKeys.self)
                try container.encodeIfPresent(
                    self.totalEngagedUsers,
                    forKey: .totalEngagedUsers
                )
                try container.encodeIfPresent(
                    self.editors,
                    forKey: .editors
                )
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// Usage metrics for Copilot Chat in GitHub.com
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat`.
        public struct CopilotDotcomChat: Codable, Hashable, Sendable {
            /// Total number of users who prompted Copilot Chat on github.com at least once.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/total_engaged_users`.
            public var totalEngagedUsers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/ModelsPayload`.
            public struct ModelsPayloadPayload: Codable, Hashable, Sendable {
                /// Name of the model used for Copilot Chat. If the default model is used will appear as 'default'.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/ModelsPayload/name`.
                public var name: Swift.String?
                /// Indicates whether a model is custom or default.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/ModelsPayload/is_custom_model`.
                public var isCustomModel: Swift.Bool?
                /// The training date for the custom model (if applicable).
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/ModelsPayload/custom_model_training_date`.
                public var customModelTrainingDate: Swift.String?
                /// Total number of users who prompted Copilot Chat on github.com at least once for each model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/ModelsPayload/total_engaged_users`.
                public var totalEngagedUsers: Swift.Int?
                /// Total number of chats initiated by users on github.com.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/ModelsPayload/total_chats`.
                public var totalChats: Swift.Int?
                /// Creates a new `ModelsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the model used for Copilot Chat. If the default model is used will appear as 'default'.
                ///   - isCustomModel: Indicates whether a model is custom or default.
                ///   - customModelTrainingDate: The training date for the custom model (if applicable).
                ///   - totalEngagedUsers: Total number of users who prompted Copilot Chat on github.com at least once for each model.
                ///   - totalChats: Total number of chats initiated by users on github.com.
                public init(
                    name: Swift.String? = nil,
                    isCustomModel: Swift.Bool? = nil,
                    customModelTrainingDate: Swift.String? = nil,
                    totalEngagedUsers: Swift.Int? = nil,
                    totalChats: Swift.Int? = nil
                ) {
                    self.name = name
                    self.isCustomModel = isCustomModel
                    self.customModelTrainingDate = customModelTrainingDate
                    self.totalEngagedUsers = totalEngagedUsers
                    self.totalChats = totalChats
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case isCustomModel = "is_custom_model"
                    case customModelTrainingDate = "custom_model_training_date"
                    case totalEngagedUsers = "total_engaged_users"
                    case totalChats = "total_chats"
                }
            }
            /// List of model metrics for a custom models and the default model.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/models`.
            public typealias ModelsPayload = [Components.Schemas.CopilotDotcomChat.ModelsPayloadPayload]
            /// List of model metrics for a custom models and the default model.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-chat/models`.
            public var models: Components.Schemas.CopilotDotcomChat.ModelsPayload?
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `CopilotDotcomChat`.
            ///
            /// - Parameters:
            ///   - totalEngagedUsers: Total number of users who prompted Copilot Chat on github.com at least once.
            ///   - models: List of model metrics for a custom models and the default model.
            ///   - additionalProperties: A container of undocumented properties.
            public init(
                totalEngagedUsers: Swift.Int? = nil,
                models: Components.Schemas.CopilotDotcomChat.ModelsPayload? = nil,
                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
            ) {
                self.totalEngagedUsers = totalEngagedUsers
                self.models = models
                self.additionalProperties = additionalProperties
            }
            public enum CodingKeys: String, CodingKey {
                case totalEngagedUsers = "total_engaged_users"
                case models
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.totalEngagedUsers = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalEngagedUsers
                )
                self.models = try container.decodeIfPresent(
                    Components.Schemas.CopilotDotcomChat.ModelsPayload.self,
                    forKey: .models
                )
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                    "total_engaged_users",
                    "models"
                ])
            }
            public func encode(to encoder: any Encoder) throws {
                var container = encoder.container(keyedBy: CodingKeys.self)
                try container.encodeIfPresent(
                    self.totalEngagedUsers,
                    forKey: .totalEngagedUsers
                )
                try container.encodeIfPresent(
                    self.models,
                    forKey: .models
                )
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// Usage metrics for Copilot for pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests`.
        public struct CopilotDotcomPullRequests: Codable, Hashable, Sendable {
            /// The number of users who used Copilot for Pull Requests on github.com to generate a pull request summary at least once.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/total_engaged_users`.
            public var totalEngagedUsers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload`.
            public struct RepositoriesPayloadPayload: Codable, Hashable, Sendable {
                /// Repository name
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/name`.
                public var name: Swift.String?
                /// The number of users who generated pull request summaries using Copilot for Pull Requests in the given repository.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/total_engaged_users`.
                public var totalEngagedUsers: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/ModelsPayload`.
                public struct ModelsPayloadPayload: Codable, Hashable, Sendable {
                    /// Name of the model used for Copilot pull request summaries. If the default model is used will appear as 'default'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/ModelsPayload/name`.
                    public var name: Swift.String?
                    /// Indicates whether a model is custom or default.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/ModelsPayload/is_custom_model`.
                    public var isCustomModel: Swift.Bool?
                    /// The training date for the custom model.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/ModelsPayload/custom_model_training_date`.
                    public var customModelTrainingDate: Swift.String?
                    /// The number of pull request summaries generated using Copilot for Pull Requests in the given repository.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/ModelsPayload/total_pr_summaries_created`.
                    public var totalPrSummariesCreated: Swift.Int?
                    /// The number of users who generated pull request summaries using Copilot for Pull Requests in the given repository and model.
                    ///
                    /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/ModelsPayload/total_engaged_users`.
                    public var totalEngagedUsers: Swift.Int?
                    /// Creates a new `ModelsPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the model used for Copilot pull request summaries. If the default model is used will appear as 'default'.
                    ///   - isCustomModel: Indicates whether a model is custom or default.
                    ///   - customModelTrainingDate: The training date for the custom model.
                    ///   - totalPrSummariesCreated: The number of pull request summaries generated using Copilot for Pull Requests in the given repository.
                    ///   - totalEngagedUsers: The number of users who generated pull request summaries using Copilot for Pull Requests in the given repository and model.
                    public init(
                        name: Swift.String? = nil,
                        isCustomModel: Swift.Bool? = nil,
                        customModelTrainingDate: Swift.String? = nil,
                        totalPrSummariesCreated: Swift.Int? = nil,
                        totalEngagedUsers: Swift.Int? = nil
                    ) {
                        self.name = name
                        self.isCustomModel = isCustomModel
                        self.customModelTrainingDate = customModelTrainingDate
                        self.totalPrSummariesCreated = totalPrSummariesCreated
                        self.totalEngagedUsers = totalEngagedUsers
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case isCustomModel = "is_custom_model"
                        case customModelTrainingDate = "custom_model_training_date"
                        case totalPrSummariesCreated = "total_pr_summaries_created"
                        case totalEngagedUsers = "total_engaged_users"
                    }
                }
                /// List of model metrics for custom models and the default model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/models`.
                public typealias ModelsPayload = [Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayloadPayload.ModelsPayloadPayload]
                /// List of model metrics for custom models and the default model.
                ///
                /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/RepositoriesPayload/models`.
                public var models: Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayloadPayload.ModelsPayload?
                /// Creates a new `RepositoriesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - name: Repository name
                ///   - totalEngagedUsers: The number of users who generated pull request summaries using Copilot for Pull Requests in the given repository.
                ///   - models: List of model metrics for custom models and the default model.
                public init(
                    name: Swift.String? = nil,
                    totalEngagedUsers: Swift.Int? = nil,
                    models: Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayloadPayload.ModelsPayload? = nil
                ) {
                    self.name = name
                    self.totalEngagedUsers = totalEngagedUsers
                    self.models = models
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case totalEngagedUsers = "total_engaged_users"
                    case models
                }
            }
            /// Repositories in which users used Copilot for Pull Requests to generate pull request summaries
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/repositories`.
            public typealias RepositoriesPayload = [Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayloadPayload]
            /// Repositories in which users used Copilot for Pull Requests to generate pull request summaries
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-dotcom-pull-requests/repositories`.
            public var repositories: Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayload?
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `CopilotDotcomPullRequests`.
            ///
            /// - Parameters:
            ///   - totalEngagedUsers: The number of users who used Copilot for Pull Requests on github.com to generate a pull request summary at least once.
            ///   - repositories: Repositories in which users used Copilot for Pull Requests to generate pull request summaries
            ///   - additionalProperties: A container of undocumented properties.
            public init(
                totalEngagedUsers: Swift.Int? = nil,
                repositories: Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayload? = nil,
                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
            ) {
                self.totalEngagedUsers = totalEngagedUsers
                self.repositories = repositories
                self.additionalProperties = additionalProperties
            }
            public enum CodingKeys: String, CodingKey {
                case totalEngagedUsers = "total_engaged_users"
                case repositories
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.totalEngagedUsers = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalEngagedUsers
                )
                self.repositories = try container.decodeIfPresent(
                    Components.Schemas.CopilotDotcomPullRequests.RepositoriesPayload.self,
                    forKey: .repositories
                )
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                    "total_engaged_users",
                    "repositories"
                ])
            }
            public func encode(to encoder: any Encoder) throws {
                var container = encoder.container(keyedBy: CodingKeys.self)
                try container.encodeIfPresent(
                    self.totalEngagedUsers,
                    forKey: .totalEngagedUsers
                )
                try container.encodeIfPresent(
                    self.repositories,
                    forKey: .repositories
                )
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// Copilot usage metrics for a given day.
        ///
        /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day`.
        public struct CopilotUsageMetricsDay: Codable, Hashable, Sendable {
            /// The date for which the usage metrics are aggregated, in `YYYY-MM-DD` format.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/date`.
            public var date: Swift.String
            /// The total number of Copilot users with activity belonging to any Copilot feature, globally, for the given day. Includes passive activity such as receiving a code suggestion, as well as engagement activity such as accepting a code suggestion or prompting chat. Does not include authentication events. Is not limited to the individual features detailed on the endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/total_active_users`.
            public var totalActiveUsers: Swift.Int?
            /// The total number of Copilot users who engaged with any Copilot feature, for the given day. Examples include but are not limited to accepting a code suggestion, prompting Copilot chat, or triggering a PR Summary. Does not include authentication events. Is not limited to the individual features detailed on the endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/total_engaged_users`.
            public var totalEngagedUsers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/copilot_ide_code_completions`.
            public var copilotIdeCodeCompletions: Components.Schemas.CopilotIdeCodeCompletions?
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/copilot_ide_chat`.
            public var copilotIdeChat: Components.Schemas.CopilotIdeChat?
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/copilot_dotcom_chat`.
            public var copilotDotcomChat: Components.Schemas.CopilotDotcomChat?
            /// - Remark: Generated from `#/components/schemas/copilot-usage-metrics-day/copilot_dotcom_pull_requests`.
            public var copilotDotcomPullRequests: Components.Schemas.CopilotDotcomPullRequests?
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `CopilotUsageMetricsDay`.
            ///
            /// - Parameters:
            ///   - date: The date for which the usage metrics are aggregated, in `YYYY-MM-DD` format.
            ///   - totalActiveUsers: The total number of Copilot users with activity belonging to any Copilot feature, globally, for the given day. Includes passive activity such as receiving a code suggestion, as well as engagement activity such as accepting a code suggestion or prompting chat. Does not include authentication events. Is not limited to the individual features detailed on the endpoint.
            ///   - totalEngagedUsers: The total number of Copilot users who engaged with any Copilot feature, for the given day. Examples include but are not limited to accepting a code suggestion, prompting Copilot chat, or triggering a PR Summary. Does not include authentication events. Is not limited to the individual features detailed on the endpoint.
            ///   - copilotIdeCodeCompletions:
            ///   - copilotIdeChat:
            ///   - copilotDotcomChat:
            ///   - copilotDotcomPullRequests:
            ///   - additionalProperties: A container of undocumented properties.
            public init(
                date: Swift.String,
                totalActiveUsers: Swift.Int? = nil,
                totalEngagedUsers: Swift.Int? = nil,
                copilotIdeCodeCompletions: Components.Schemas.CopilotIdeCodeCompletions? = nil,
                copilotIdeChat: Components.Schemas.CopilotIdeChat? = nil,
                copilotDotcomChat: Components.Schemas.CopilotDotcomChat? = nil,
                copilotDotcomPullRequests: Components.Schemas.CopilotDotcomPullRequests? = nil,
                additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
            ) {
                self.date = date
                self.totalActiveUsers = totalActiveUsers
                self.totalEngagedUsers = totalEngagedUsers
                self.copilotIdeCodeCompletions = copilotIdeCodeCompletions
                self.copilotIdeChat = copilotIdeChat
                self.copilotDotcomChat = copilotDotcomChat
                self.copilotDotcomPullRequests = copilotDotcomPullRequests
                self.additionalProperties = additionalProperties
            }
            public enum CodingKeys: String, CodingKey {
                case date
                case totalActiveUsers = "total_active_users"
                case totalEngagedUsers = "total_engaged_users"
                case copilotIdeCodeCompletions = "copilot_ide_code_completions"
                case copilotIdeChat = "copilot_ide_chat"
                case copilotDotcomChat = "copilot_dotcom_chat"
                case copilotDotcomPullRequests = "copilot_dotcom_pull_requests"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.date = try container.decode(
                    Swift.String.self,
                    forKey: .date
                )
                self.totalActiveUsers = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalActiveUsers
                )
                self.totalEngagedUsers = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalEngagedUsers
                )
                self.copilotIdeCodeCompletions = try container.decodeIfPresent(
                    Components.Schemas.CopilotIdeCodeCompletions.self,
                    forKey: .copilotIdeCodeCompletions
                )
                self.copilotIdeChat = try container.decodeIfPresent(
                    Components.Schemas.CopilotIdeChat.self,
                    forKey: .copilotIdeChat
                )
                self.copilotDotcomChat = try container.decodeIfPresent(
                    Components.Schemas.CopilotDotcomChat.self,
                    forKey: .copilotDotcomChat
                )
                self.copilotDotcomPullRequests = try container.decodeIfPresent(
                    Components.Schemas.CopilotDotcomPullRequests.self,
                    forKey: .copilotDotcomPullRequests
                )
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                    "date",
                    "total_active_users",
                    "total_engaged_users",
                    "copilot_ide_code_completions",
                    "copilot_ide_chat",
                    "copilot_dotcom_chat",
                    "copilot_dotcom_pull_requests"
                ])
            }
            public func encode(to encoder: any Encoder) throws {
                var container = encoder.container(keyedBy: CodingKeys.self)
                try container.encode(
                    self.date,
                    forKey: .date
                )
                try container.encodeIfPresent(
                    self.totalActiveUsers,
                    forKey: .totalActiveUsers
                )
                try container.encodeIfPresent(
                    self.totalEngagedUsers,
                    forKey: .totalEngagedUsers
                )
                try container.encodeIfPresent(
                    self.copilotIdeCodeCompletions,
                    forKey: .copilotIdeCodeCompletions
                )
                try container.encodeIfPresent(
                    self.copilotIdeChat,
                    forKey: .copilotIdeChat
                )
                try container.encodeIfPresent(
                    self.copilotDotcomChat,
                    forKey: .copilotDotcomChat
                )
                try container.encodeIfPresent(
                    self.copilotDotcomPullRequests,
                    forKey: .copilotDotcomPullRequests
                )
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The slug of the team name.
        ///
        /// - Remark: Generated from `#/components/parameters/team-slug`.
        public typealias TeamSlug = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct InternalError: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/internal_error/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/internal_error/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.InternalError.Body
            /// Creates a new `InternalError`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.InternalError.Body) {
                self.body = body
            }
        }
        public struct UsageMetricsApiDisabled: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/usage_metrics_api_disabled/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/usage_metrics_api_disabled/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.UsageMetricsApiDisabled.Body
            /// Creates a new `UsageMetricsApiDisabled`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.UsageMetricsApiDisabled.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get Copilot seat information and settings for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Gets information about an organization's Copilot subscription, including seat breakdown
    /// and feature policies. To configure these settings, go to your organization's settings on GitHub.com.
    /// For more information, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-policies-for-copilot-business-in-your-organization)."
    ///
    /// Only organization owners can view details about the organization's Copilot Business or Copilot Enterprise subscription.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/billing`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)`.
    public enum CopilotGetCopilotOrganizationDetails {
        public static let id: Swift.String = "copilot/get-copilot-organization-details"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotGetCopilotOrganizationDetails.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotGetCopilotOrganizationDetails.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotGetCopilotOrganizationDetails.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotGetCopilotOrganizationDetails.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CopilotGetCopilotOrganizationDetails.Input.Path,
                headers: Operations.CopilotGetCopilotOrganizationDetails.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CopilotOrganizationDetails)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CopilotOrganizationDetails {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotGetCopilotOrganizationDetails.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotGetCopilotOrganizationDetails.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotGetCopilotOrganizationDetails.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotGetCopilotOrganizationDetails.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// There is a problem with your account's associated payment method.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CopilotGetCopilotOrganizationDetails.Output.UnprocessableContent)
            /// There is a problem with your account's associated payment method.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/get(copilot/get-copilot-organization-details)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CopilotGetCopilotOrganizationDetails.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List all Copilot seat assignments for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Lists all Copilot seats for which an organization with a Copilot Business or Copilot Enterprise subscription is currently being billed.
    /// Only organization owners can view assigned seats.
    ///
    /// Each seat object contains information about the assigned user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
    /// For more information about activity data, see "[Reviewing user activity data for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/reviewing-activity-related-to-github-copilot-in-your-organization/reviewing-user-activity-data-for-copilot-in-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/billing/seats`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)`.
    public enum CopilotListCopilotSeats {
        public static let id: Swift.String = "copilot/list-copilot-seats"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotListCopilotSeats.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Swift.Int? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.CopilotListCopilotSeats.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotListCopilotSeats.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotListCopilotSeats.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotListCopilotSeats.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CopilotListCopilotSeats.Input.Path,
                query: Operations.CopilotListCopilotSeats.Input.Query = .init(),
                headers: Operations.CopilotListCopilotSeats.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CopilotListCopilotSeats.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Total number of Copilot seats for the organization currently being billed.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/content/json/total_seats`.
                        public var totalSeats: Swift.Int?
                        /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/content/json/seats`.
                        public var seats: [Components.Schemas.CopilotSeatDetails]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalSeats: Total number of Copilot seats for the organization currently being billed.
                        ///   - seats:
                        public init(
                            totalSeats: Swift.Int? = nil,
                            seats: [Components.Schemas.CopilotSeatDetails]? = nil
                        ) {
                            self.totalSeats = totalSeats
                            self.seats = seats
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalSeats = "total_seats"
                            case seats
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/seats/GET/responses/200/content/application\/json`.
                    case json(Operations.CopilotListCopilotSeats.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CopilotListCopilotSeats.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotListCopilotSeats.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CopilotListCopilotSeats.Output.Ok.Headers = .init(),
                    body: Operations.CopilotListCopilotSeats.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotListCopilotSeats.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotListCopilotSeats.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/seats/get(copilot/list-copilot-seats)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add teams to the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Purchases a GitHub Copilot seat for all users within each specified team.
    /// The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."
    ///
    /// Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
    /// For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
    /// For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."
    ///
    /// The response contains the total number of new seats that were created and existing seats that were refreshed.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/copilot/billing/selected_teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)`.
    public enum CopilotAddCopilotSeatsForTeams {
        public static let id: Swift.String = "copilot/add-copilot-seats-for-teams"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotAddCopilotSeatsForTeams.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotAddCopilotSeatsForTeams.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotAddCopilotSeatsForTeams.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotAddCopilotSeatsForTeams.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// List of team names within the organization to which to grant access to GitHub Copilot.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/requestBody/json/selected_teams`.
                    public var selectedTeams: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedTeams: List of team names within the organization to which to grant access to GitHub Copilot.
                    public init(selectedTeams: [Swift.String]) {
                        self.selectedTeams = selectedTeams
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedTeams = "selected_teams"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/requestBody/content/application\/json`.
                case json(Operations.CopilotAddCopilotSeatsForTeams.Input.Body.JsonPayload)
            }
            public var body: Operations.CopilotAddCopilotSeatsForTeams.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CopilotAddCopilotSeatsForTeams.Input.Path,
                headers: Operations.CopilotAddCopilotSeatsForTeams.Input.Headers = .init(),
                body: Operations.CopilotAddCopilotSeatsForTeams.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// The total number of seats created for members of the specified team(s).
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/responses/201/content/json/seats_created`.
                        public var seatsCreated: Swift.Int
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - seatsCreated:
                        public init(seatsCreated: Swift.Int) {
                            self.seatsCreated = seatsCreated
                        }
                        public enum CodingKeys: String, CodingKey {
                            case seatsCreated = "seats_created"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/POST/responses/201/content/application\/json`.
                    case json(Operations.CopilotAddCopilotSeatsForTeams.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CopilotAddCopilotSeatsForTeams.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotAddCopilotSeatsForTeams.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotAddCopilotSeatsForTeams.Output.Created.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CopilotAddCopilotSeatsForTeams.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CopilotAddCopilotSeatsForTeams.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, or the organization's Copilot access setting is set to enable Copilot for all users or is unconfigured.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CopilotAddCopilotSeatsForTeams.Output.UnprocessableContent)
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, or the organization's Copilot access setting is set to enable Copilot for all users or is unconfigured.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/post(copilot/add-copilot-seats-for-teams)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CopilotAddCopilotSeatsForTeams.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove teams from the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Sets seats for all members of each team specified to "pending cancellation".
    /// This will cause the members of the specified team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another team.
    /// For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."
    ///
    /// Only organization owners can cancel Copilot seats for their organization members.
    ///
    /// The response contains the total number of seats set to "pending cancellation".
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/copilot/billing/selected_teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)`.
    public enum CopilotCancelCopilotSeatAssignmentForTeams {
        public static let id: Swift.String = "copilot/cancel-copilot-seat-assignment-for-teams"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCancelCopilotSeatAssignmentForTeams.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCancelCopilotSeatAssignmentForTeams.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The names of teams from which to revoke access to GitHub Copilot.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/requestBody/json/selected_teams`.
                    public var selectedTeams: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedTeams: The names of teams from which to revoke access to GitHub Copilot.
                    public init(selectedTeams: [Swift.String]) {
                        self.selectedTeams = selectedTeams
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedTeams = "selected_teams"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/requestBody/content/application\/json`.
                case json(Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Body.JsonPayload)
            }
            public var body: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Path,
                headers: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Headers = .init(),
                body: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// The total number of seats set to "pending cancellation" for members of the specified team(s).
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/responses/200/content/json/seats_cancelled`.
                        public var seatsCancelled: Swift.Int
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - seatsCancelled:
                        public init(seatsCancelled: Swift.Int) {
                            self.seatsCancelled = seatsCancelled
                        }
                        public enum CodingKeys: String, CodingKey {
                            case seatsCancelled = "seats_cancelled"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_teams/DELETE/responses/200/content/application\/json`.
                    case json(Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, or the organization's Copilot access setting is set to enable Copilot for all users or is unconfigured.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.UnprocessableContent)
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, or the organization's Copilot access setting is set to enable Copilot for all users or is unconfigured.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_teams/delete(copilot/cancel-copilot-seat-assignment-for-teams)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CopilotCancelCopilotSeatAssignmentForTeams.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add users to the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Purchases a GitHub Copilot seat for each user specified.
    /// The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."
    ///
    /// Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
    /// For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
    /// For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."
    ///
    /// The response contains the total number of new seats that were created and existing seats that were refreshed.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/copilot/billing/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)`.
    public enum CopilotAddCopilotSeatsForUsers {
        public static let id: Swift.String = "copilot/add-copilot-seats-for-users"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotAddCopilotSeatsForUsers.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotAddCopilotSeatsForUsers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotAddCopilotSeatsForUsers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotAddCopilotSeatsForUsers.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The usernames of the organization members to be granted access to GitHub Copilot.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/requestBody/json/selected_usernames`.
                    public var selectedUsernames: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedUsernames: The usernames of the organization members to be granted access to GitHub Copilot.
                    public init(selectedUsernames: [Swift.String]) {
                        self.selectedUsernames = selectedUsernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedUsernames = "selected_usernames"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/requestBody/content/application\/json`.
                case json(Operations.CopilotAddCopilotSeatsForUsers.Input.Body.JsonPayload)
            }
            public var body: Operations.CopilotAddCopilotSeatsForUsers.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CopilotAddCopilotSeatsForUsers.Input.Path,
                headers: Operations.CopilotAddCopilotSeatsForUsers.Input.Headers = .init(),
                body: Operations.CopilotAddCopilotSeatsForUsers.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// The total number of seats created for the specified user(s).
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/responses/201/content/json/seats_created`.
                        public var seatsCreated: Swift.Int
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - seatsCreated:
                        public init(seatsCreated: Swift.Int) {
                            self.seatsCreated = seatsCreated
                        }
                        public enum CodingKeys: String, CodingKey {
                            case seatsCreated = "seats_created"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/POST/responses/201/content/application\/json`.
                    case json(Operations.CopilotAddCopilotSeatsForUsers.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CopilotAddCopilotSeatsForUsers.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotAddCopilotSeatsForUsers.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotAddCopilotSeatsForUsers.Output.Created.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CopilotAddCopilotSeatsForUsers.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CopilotAddCopilotSeatsForUsers.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, or the organization's Copilot access setting is set to enable Copilot for all users or is unconfigured.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CopilotAddCopilotSeatsForUsers.Output.UnprocessableContent)
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, or the organization's Copilot access setting is set to enable Copilot for all users or is unconfigured.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/post(copilot/add-copilot-seats-for-users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CopilotAddCopilotSeatsForUsers.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove users from the Copilot subscription for an organization
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Sets seats for all users specified to "pending cancellation".
    /// This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team membership.
    /// For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."
    ///
    /// Only organization owners can cancel Copilot seats for their organization members.
    ///
    /// The response contains the total number of seats set to "pending cancellation".
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/copilot/billing/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)`.
    public enum CopilotCancelCopilotSeatAssignmentForUsers {
        public static let id: Swift.String = "copilot/cancel-copilot-seat-assignment-for-users"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCancelCopilotSeatAssignmentForUsers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCancelCopilotSeatAssignmentForUsers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The usernames of the organization members for which to revoke access to GitHub Copilot.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/requestBody/json/selected_usernames`.
                    public var selectedUsernames: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedUsernames: The usernames of the organization members for which to revoke access to GitHub Copilot.
                    public init(selectedUsernames: [Swift.String]) {
                        self.selectedUsernames = selectedUsernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedUsernames = "selected_usernames"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/requestBody/content/application\/json`.
                case json(Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Body.JsonPayload)
            }
            public var body: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Path,
                headers: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Headers = .init(),
                body: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// The total number of seats set to "pending cancellation" for the specified users.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/responses/200/content/json/seats_cancelled`.
                        public var seatsCancelled: Swift.Int
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - seatsCancelled:
                        public init(seatsCancelled: Swift.Int) {
                            self.seatsCancelled = seatsCancelled
                        }
                        public enum CodingKeys: String, CodingKey {
                            case seatsCancelled = "seats_cancelled"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/billing/selected_users/DELETE/responses/200/content/application\/json`.
                    case json(Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, the seat management setting is set to enable Copilot for all users or is unconfigured, or a user's seat cannot be cancelled because it was assigned to them via a team.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.UnprocessableContent)
            /// Copilot Business or Enterprise is not enabled for this organization, billing has not been set up for this organization, a public code suggestions policy has not been set for this organization, the seat management setting is set to enable Copilot for all users or is unconfigured, or a user's seat cannot be cancelled because it was assigned to them via a team.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/billing/selected_users/delete(copilot/cancel-copilot-seat-assignment-for-users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CopilotCancelCopilotSeatAssignmentForUsers.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get Copilot metrics for an organization
    ///
    /// Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.
    ///
    /// > [!NOTE]
    /// > This endpoint will only return results for a given day if the organization contained **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.
    ///
    /// The response contains metrics for up to 28 days prior. Metrics are processed once per day for the previous day,
    /// and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
    /// they must have telemetry enabled in their IDE.
    ///
    /// To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization.
    /// Only organization owners and owners and billing managers of the parent enterprise can view Copilot metrics.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/copilot/metrics`.
    /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)`.
    public enum CopilotCopilotMetricsForOrganization {
        public static let id: Swift.String = "copilot/copilot-metrics-for-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CopilotCopilotMetricsForOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Show usage metrics since this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`). Maximum value is 28 days ago.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/query/since`.
                public var since: Swift.String?
                /// Show usage metrics until this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`) and should not preceed the `since` date if it is passed.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/query/until`.
                public var until: Swift.String?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of days of metrics to display per page (max 28). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Show usage metrics since this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`). Maximum value is 28 days ago.
                ///   - until: Show usage metrics until this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`) and should not preceed the `since` date if it is passed.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of days of metrics to display per page (max 28). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Swift.String? = nil,
                    until: Swift.String? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Swift.Int? = nil
                ) {
                    self.since = since
                    self.until = until
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.CopilotCopilotMetricsForOrganization.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCopilotMetricsForOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCopilotMetricsForOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotCopilotMetricsForOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CopilotCopilotMetricsForOrganization.Input.Path,
                query: Operations.CopilotCopilotMetricsForOrganization.Input.Query = .init(),
                headers: Operations.CopilotCopilotMetricsForOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/copilot/metrics/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CopilotUsageMetricsDay])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CopilotUsageMetricsDay] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotCopilotMetricsForOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotCopilotMetricsForOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotCopilotMetricsForOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotCopilotMetricsForOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Copilot Usage Merics API setting is disabled at the organization or enterprise level.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/copilot/metrics/get(copilot/copilot-metrics-for-organization)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.UsageMetricsApiDisabled)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.UsageMetricsApiDisabled {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get Copilot seat assignment details for a user
    ///
    /// > [!NOTE]
    /// > This endpoint is in public preview and is subject to change.
    ///
    /// Gets the GitHub Copilot seat details for a member of an organization who currently has access to GitHub Copilot.
    ///
    /// The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
    /// For more information about activity data, see "[Reviewing user activity data for Copilot in your organization](https://docs.github.com/copilot/managing-copilot/managing-github-copilot-in-your-organization/reviewing-activity-related-to-github-copilot-in-your-organization/reviewing-user-activity-data-for-copilot-in-your-organization)."
    ///
    /// Only organization owners can view Copilot seat assignment details for members of their organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}/copilot`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)`.
    public enum CopilotGetCopilotSeatDetailsForUser {
        public static let id: Swift.String = "copilot/get-copilot-seat-details-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/copilot/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/copilot/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/copilot/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.username = username
                }
            }
            public var path: Operations.CopilotGetCopilotSeatDetailsForUser.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/copilot/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotGetCopilotSeatDetailsForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotGetCopilotSeatDetailsForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotGetCopilotSeatDetailsForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CopilotGetCopilotSeatDetailsForUser.Input.Path,
                headers: Operations.CopilotGetCopilotSeatDetailsForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/copilot/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/copilot/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CopilotSeatDetails)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CopilotSeatDetails {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotGetCopilotSeatDetailsForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotGetCopilotSeatDetailsForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// The user's GitHub Copilot seat details, including usage.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotGetCopilotSeatDetailsForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotGetCopilotSeatDetailsForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Copilot Business or Enterprise is not enabled for this organization or the user has a pending organization invitation.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CopilotGetCopilotSeatDetailsForUser.Output.UnprocessableContent)
            /// Copilot Business or Enterprise is not enabled for this organization or the user has a pending organization invitation.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/copilot/get(copilot/get-copilot-seat-details-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CopilotGetCopilotSeatDetailsForUser.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get Copilot metrics for a team
    ///
    /// Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.
    ///
    /// > [!NOTE]
    /// > This endpoint will only return results for a given day if the team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.
    ///
    /// The response contains metrics for up to 28 days prior. Metrics are processed once per day for the previous day,
    /// and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
    /// they must have telemetry enabled in their IDE.
    ///
    /// To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization containing the team within GitHub settings.
    /// Only organization owners for the organization that contains this team and owners and billing managers of the parent enterprise can view Copilot metrics for a team.
    ///
    /// OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/team/{team_slug}/copilot/metrics`.
    /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)`.
    public enum CopilotCopilotMetricsForTeam {
        public static let id: Swift.String = "copilot/copilot-metrics-for-team"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.CopilotCopilotMetricsForTeam.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Show usage metrics since this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`). Maximum value is 28 days ago.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/query/since`.
                public var since: Swift.String?
                /// Show usage metrics until this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`) and should not preceed the `since` date if it is passed.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/query/until`.
                public var until: Swift.String?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of days of metrics to display per page (max 28). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Show usage metrics since this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`). Maximum value is 28 days ago.
                ///   - until: Show usage metrics until this date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:MM:SSZ`) and should not preceed the `since` date if it is passed.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of days of metrics to display per page (max 28). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Swift.String? = nil,
                    until: Swift.String? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Swift.Int? = nil
                ) {
                    self.since = since
                    self.until = until
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.CopilotCopilotMetricsForTeam.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCopilotMetricsForTeam.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CopilotCopilotMetricsForTeam.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CopilotCopilotMetricsForTeam.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CopilotCopilotMetricsForTeam.Input.Path,
                query: Operations.CopilotCopilotMetricsForTeam.Input.Query = .init(),
                headers: Operations.CopilotCopilotMetricsForTeam.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/team/{team_slug}/copilot/metrics/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CopilotUsageMetricsDay])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CopilotUsageMetricsDay] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CopilotCopilotMetricsForTeam.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CopilotCopilotMetricsForTeam.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CopilotCopilotMetricsForTeam.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CopilotCopilotMetricsForTeam.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Copilot Usage Merics API setting is disabled at the organization or enterprise level.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/team/{team_slug}/copilot/metrics/get(copilot/copilot-metrics-for-team)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.UsageMetricsApiDisabled)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.UsageMetricsApiDisabled {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
