// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// GitHub's v3 REST API.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// Get GitHub Actions cache usage for an organization
    ///
    /// Gets the total GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage/get(actions/get-actions-cache-usage-for-org)`.
    public func actionsGetActionsCacheUsageForOrg(_ input: Operations.ActionsGetActionsCacheUsageForOrg.Input) async throws -> Operations.ActionsGetActionsCacheUsageForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetActionsCacheUsageForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/cache/usage",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetActionsCacheUsageForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsCacheUsageOrgEnterprise.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repositories with GitHub Actions cache usage for an organization
    ///
    /// Lists repositories and their GitHub Actions cache usage for an organization.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/cache/usage-by-repository`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/cache/usage-by-repository/get(actions/get-actions-cache-usage-by-repo-for-org)`.
    public func actionsGetActionsCacheUsageByRepoForOrg(_ input: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Input) async throws -> Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetActionsCacheUsageByRepoForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/cache/usage-by-repository",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsGetActionsCacheUsageByRepoForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List GitHub-hosted runners for an organization
    ///
    /// Lists all GitHub-hosted runners configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runner:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/get(actions/list-hosted-runners-for-org)`.
    public func actionsListHostedRunnersForOrg(_ input: Operations.ActionsListHostedRunnersForOrg.Input) async throws -> Operations.ActionsListHostedRunnersForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListHostedRunnersForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListHostedRunnersForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListHostedRunnersForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a GitHub-hosted runner for an organization
    ///
    /// Creates a GitHub-hosted runner for an organization.
    /// OAuth tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/post(actions/create-hosted-runner-for-org)`.
    public func actionsCreateHostedRunnerForOrg(_ input: Operations.ActionsCreateHostedRunnerForOrg.Input) async throws -> Operations.ActionsCreateHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateHostedRunnerForOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsHostedRunner.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get GitHub-owned images for GitHub-hosted runners in an organization
    ///
    /// Get the list of GitHub-owned images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/github-owned`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/github-owned/get(actions/get-hosted-runners-github-owned-images-for-org)`.
    public func actionsGetHostedRunnersGithubOwnedImagesForOrg(_ input: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/images/github-owned",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsGetHostedRunnersGithubOwnedImagesForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get partner images for GitHub-hosted runners in an organization
    ///
    /// Get the list of partner images available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/images/partner`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/images/partner/get(actions/get-hosted-runners-partner-images-for-org)`.
    public func actionsGetHostedRunnersPartnerImagesForOrg(_ input: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/images/partner",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsGetHostedRunnersPartnerImagesForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get limits on GitHub-hosted runners for an organization
    ///
    /// Get the GitHub-hosted runners limits for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/limits/get(actions/get-hosted-runners-limits-for-org)`.
    public func actionsGetHostedRunnersLimitsForOrg(_ input: Operations.ActionsGetHostedRunnersLimitsForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersLimitsForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetHostedRunnersLimitsForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/limits",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetHostedRunnersLimitsForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsHostedRunnerLimits.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get GitHub-hosted runners machine specs for an organization
    ///
    /// Get the list of machine specs available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/machine-sizes`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/machine-sizes/get(actions/get-hosted-runners-machine-specs-for-org)`.
    public func actionsGetHostedRunnersMachineSpecsForOrg(_ input: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/machine-sizes",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsGetHostedRunnersMachineSpecsForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get platforms for GitHub-hosted runners in an organization
    ///
    /// Get the list of platforms available for GitHub-hosted runners for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/platforms`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/platforms/get(actions/get-hosted-runners-platforms-for-org)`.
    public func actionsGetHostedRunnersPlatformsForOrg(_ input: Operations.ActionsGetHostedRunnersPlatformsForOrg.Input) async throws -> Operations.ActionsGetHostedRunnersPlatformsForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetHostedRunnersPlatformsForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/platforms",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsGetHostedRunnersPlatformsForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a GitHub-hosted runner for an organization
    ///
    /// Gets a GitHub-hosted runner configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/get(actions/get-hosted-runner-for-org)`.
    public func actionsGetHostedRunnerForOrg(_ input: Operations.ActionsGetHostedRunnerForOrg.Input) async throws -> Operations.ActionsGetHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.hostedRunnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsGetHostedRunnerForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetHostedRunnerForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsHostedRunner.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a GitHub-hosted runner for an organization
    ///
    /// Updates a GitHub-hosted runner for an organization.
    /// OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/patch(actions/update-hosted-runner-for-org)`.
    public func actionsUpdateHostedRunnerForOrg(_ input: Operations.ActionsUpdateHostedRunnerForOrg.Input) async throws -> Operations.ActionsUpdateHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsUpdateHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.hostedRunnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsUpdateHostedRunnerForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsHostedRunner.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a GitHub-hosted runner for an organization
    ///
    /// Deletes a GitHub-hosted runner for an organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/hosted-runners/{hosted_runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/hosted-runners/{hosted_runner_id}/delete(actions/delete-hosted-runner-for-org)`.
    public func actionsDeleteHostedRunnerForOrg(_ input: Operations.ActionsDeleteHostedRunnerForOrg.Input) async throws -> Operations.ActionsDeleteHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/hosted-runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.hostedRunnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsDeleteHostedRunnerForOrg.Output.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsHostedRunner.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get GitHub Actions permissions for an organization
    ///
    /// Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/get(actions/get-github-actions-permissions-organization)`.
    public func actionsGetGithubActionsPermissionsOrganization(_ input: Operations.ActionsGetGithubActionsPermissionsOrganization.Input) async throws -> Operations.ActionsGetGithubActionsPermissionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetGithubActionsPermissionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetGithubActionsPermissionsOrganization.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsOrganizationPermissions.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set GitHub Actions permissions for an organization
    ///
    /// Sets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/put(actions/set-github-actions-permissions-organization)`.
    public func actionsSetGithubActionsPermissionsOrganization(_ input: Operations.ActionsSetGithubActionsPermissionsOrganization.Input) async throws -> Operations.ActionsSetGithubActionsPermissionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetGithubActionsPermissionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List selected repositories enabled for GitHub Actions in an organization
    ///
    /// Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/get(actions/list-selected-repositories-enabled-github-actions-organization)`.
    public func actionsListSelectedRepositoriesEnabledGithubActionsOrganization(_ input: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Input) async throws -> Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/repositories",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelectedRepositoriesEnabledGithubActionsOrganization.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set selected repositories enabled for GitHub Actions in an organization
    ///
    /// Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/put(actions/set-selected-repositories-enabled-github-actions-organization)`.
    public func actionsSetSelectedRepositoriesEnabledGithubActionsOrganization(_ input: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Input) async throws -> Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetSelectedRepositoriesEnabledGithubActionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/repositories",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Enable a selected repository for GitHub Actions in an organization
    ///
    /// Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/put(actions/enable-selected-repository-github-actions-organization)`.
    public func actionsEnableSelectedRepositoryGithubActionsOrganization(_ input: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Input) async throws -> Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsEnableSelectedRepositoryGithubActionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Disable a selected repository for GitHub Actions in an organization
    ///
    /// Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/permissions/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/repositories/{repository_id}/delete(actions/disable-selected-repository-github-actions-organization)`.
    public func actionsDisableSelectedRepositoryGithubActionsOrganization(_ input: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Input) async throws -> Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDisableSelectedRepositoryGithubActionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get allowed actions and reusable workflows for an organization
    ///
    /// Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/get(actions/get-allowed-actions-organization)`.
    public func actionsGetAllowedActionsOrganization(_ input: Operations.ActionsGetAllowedActionsOrganization.Input) async throws -> Operations.ActionsGetAllowedActionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetAllowedActionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/selected-actions",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetAllowedActionsOrganization.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.SelectedActions.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set allowed actions and reusable workflows for an organization
    ///
    /// Sets the actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/selected-actions/put(actions/set-allowed-actions-organization)`.
    public func actionsSetAllowedActionsOrganization(_ input: Operations.ActionsSetAllowedActionsOrganization.Input) async throws -> Operations.ActionsSetAllowedActionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetAllowedActionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/selected-actions",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get default workflow permissions for an organization
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
    /// as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-organization)`.
    public func actionsGetGithubActionsDefaultWorkflowPermissionsOrganization(_ input: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Input) async throws -> Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/workflow",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsOrganization.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsGetDefaultWorkflowPermissions.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set default workflow permissions for an organization
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
    /// can submit approving pull request reviews. For more information, see
    /// "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-organization)`.
    public func actionsSetGithubActionsDefaultWorkflowPermissionsOrganization(_ input: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Input) async throws -> Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsOrganization.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/permissions/workflow",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List self-hosted runner groups for an organization
    ///
    /// Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/get(actions/list-self-hosted-runner-groups-for-org)`.
    public func actionsListSelfHostedRunnerGroupsForOrg(_ input: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Input) async throws -> Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelfHostedRunnerGroupsForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "visible_to_repository",
                    value: input.query.visibleToRepository
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelfHostedRunnerGroupsForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a self-hosted runner group for an organization
    ///
    /// Creates a new self-hosted runner group for an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runner-groups`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/post(actions/create-self-hosted-runner-group-for-org)`.
    public func actionsCreateSelfHostedRunnerGroupForOrg(_ input: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Input) async throws -> Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateSelfHostedRunnerGroupForOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunnerGroupsOrg.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a self-hosted runner group for an organization
    ///
    /// Gets a specific self-hosted runner group for an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/get(actions/get-self-hosted-runner-group-for-org)`.
    public func actionsGetSelfHostedRunnerGroupForOrg(_ input: Operations.ActionsGetSelfHostedRunnerGroupForOrg.Input) async throws -> Operations.ActionsGetSelfHostedRunnerGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetSelfHostedRunnerGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetSelfHostedRunnerGroupForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunnerGroupsOrg.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a self-hosted runner group for an organization
    ///
    /// Updates the `name` and `visibility` of a self-hosted runner group in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/patch(actions/update-self-hosted-runner-group-for-org)`.
    public func actionsUpdateSelfHostedRunnerGroupForOrg(_ input: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Input) async throws -> Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsUpdateSelfHostedRunnerGroupForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunnerGroupsOrg.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a self-hosted runner group from an organization
    ///
    /// Deletes a self-hosted runner group for an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/delete(actions/delete-self-hosted-runner-group-from-org)`.
    public func actionsDeleteSelfHostedRunnerGroupFromOrg(_ input: Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Input) async throws -> Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteSelfHostedRunnerGroupFromOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List GitHub-hosted runners in a group for an organization
    ///
    /// Lists the GitHub-hosted runners in an organization group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners/get(actions/list-github-hosted-runners-in-group-for-org)`.
    public func actionsListGithubHostedRunnersInGroupForOrg(_ input: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Input) async throws -> Operations.ActionsListGithubHostedRunnersInGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListGithubHostedRunnersInGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/hosted-runners",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListGithubHostedRunnersInGroupForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListGithubHostedRunnersInGroupForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repository access to a self-hosted runner group in an organization
    ///
    /// Lists the repositories with access to a self-hosted runner group configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/get(actions/list-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsListRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListRepoAccessToSelfHostedRunnerGroupInOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set repository access for a self-hosted runner group in an organization
    ///
    /// Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/put(actions/set-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsSetRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetRepoAccessToSelfHostedRunnerGroupInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add repository access to a self-hosted runner group in an organization
    ///
    /// Adds a repository to the list of repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}/put(actions/add-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsAddRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsAddRepoAccessToSelfHostedRunnerGroupInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove repository access to a self-hosted runner group in an organization
    ///
    /// Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}/delete(actions/remove-repo-access-to-self-hosted-runner-group-in-org)`.
    public func actionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg(_ input: Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Input) async throws -> Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List self-hosted runners in a group for an organization
    ///
    /// Lists self-hosted runners that are in a specific organization group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runner-groups/{runner_group_id}/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/get(actions/list-self-hosted-runners-in-group-for-org)`.
    public func actionsListSelfHostedRunnersInGroupForOrg(_ input: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Input) async throws -> Operations.ActionsListSelfHostedRunnersInGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelfHostedRunnersInGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/runners",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelfHostedRunnersInGroupForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelfHostedRunnersInGroupForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set self-hosted runners in a group for an organization
    ///
    /// Replaces the list of self-hosted runners that are part of an organization runner group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/put(actions/set-self-hosted-runners-in-group-for-org)`.
    public func actionsSetSelfHostedRunnersInGroupForOrg(_ input: Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Input) async throws -> Operations.ActionsSetSelfHostedRunnersInGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetSelfHostedRunnersInGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/runners",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add a self-hosted runner to a group for an organization
    ///
    /// Adds a self-hosted runner to a runner group configured in an organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}/put(actions/add-self-hosted-runner-to-group-for-org)`.
    public func actionsAddSelfHostedRunnerToGroupForOrg(_ input: Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Input) async throws -> Operations.ActionsAddSelfHostedRunnerToGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsAddSelfHostedRunnerToGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a self-hosted runner from a group for an organization
    ///
    /// Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}/delete(actions/remove-self-hosted-runner-from-group-for-org)`.
    public func actionsRemoveSelfHostedRunnerFromGroupForOrg(_ input: Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Input) async throws -> Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveSelfHostedRunnerFromGroupForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runner-groups/{}/runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerGroupId,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List self-hosted runners for an organization
    ///
    /// Lists all self-hosted runners configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/get(actions/list-self-hosted-runners-for-org)`.
    public func actionsListSelfHostedRunnersForOrg(_ input: Operations.ActionsListSelfHostedRunnersForOrg.Input) async throws -> Operations.ActionsListSelfHostedRunnersForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelfHostedRunnersForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "name",
                    value: input.query.name
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListSelfHostedRunnersForOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelfHostedRunnersForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelfHostedRunnersForOrg.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List runner applications for an organization
    ///
    /// Lists binaries for the runner application that you can download and run.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.  If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/downloads`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/downloads/get(actions/list-runner-applications-for-org)`.
    public func actionsListRunnerApplicationsForOrg(_ input: Operations.ActionsListRunnerApplicationsForOrg.Input) async throws -> Operations.ActionsListRunnerApplicationsForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRunnerApplicationsForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/downloads",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRunnerApplicationsForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.RunnerApplication].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create configuration for a just-in-time runner for an organization
    ///
    /// Generates a configuration that can be passed to the runner application at startup.
    ///
    /// The authenticated user must have admin access to the organization.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/generate-jitconfig`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/generate-jitconfig/post(actions/generate-runner-jitconfig-for-org)`.
    public func actionsGenerateRunnerJitconfigForOrg(_ input: Operations.ActionsGenerateRunnerJitconfigForOrg.Input) async throws -> Operations.ActionsGenerateRunnerJitconfigForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGenerateRunnerJitconfigForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/generate-jitconfig",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerJitconfig.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerJitconfig.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 409:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Conflict.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .conflict(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a registration token for an organization
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
    ///
    /// ```
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/registration-token`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/registration-token/post(actions/create-registration-token-for-org)`.
    public func actionsCreateRegistrationTokenForOrg(_ input: Operations.ActionsCreateRegistrationTokenForOrg.Input) async throws -> Operations.ActionsCreateRegistrationTokenForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateRegistrationTokenForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/registration-token",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateRegistrationTokenForOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AuthenticationToken.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a remove token for an organization
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
    ///
    /// ```
    /// ./config.sh remove --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/remove-token`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/remove-token/post(actions/create-remove-token-for-org)`.
    public func actionsCreateRemoveTokenForOrg(_ input: Operations.ActionsCreateRemoveTokenForOrg.Input) async throws -> Operations.ActionsCreateRemoveTokenForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateRemoveTokenForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/remove-token",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateRemoveTokenForOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AuthenticationToken.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a self-hosted runner for an organization
    ///
    /// Gets a specific self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/get(actions/get-self-hosted-runner-for-org)`.
    public func actionsGetSelfHostedRunnerForOrg(_ input: Operations.ActionsGetSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsGetSelfHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetSelfHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetSelfHostedRunnerForOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Runner.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a self-hosted runner from an organization
    ///
    /// Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/delete(actions/delete-self-hosted-runner-from-org)`.
    public func actionsDeleteSelfHostedRunnerFromOrg(_ input: Operations.ActionsDeleteSelfHostedRunnerFromOrg.Input) async throws -> Operations.ActionsDeleteSelfHostedRunnerFromOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteSelfHostedRunnerFromOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List labels for a self-hosted runner for an organization
    ///
    /// Lists all labels for a self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/get(actions/list-labels-for-self-hosted-runner-for-org)`.
    public func actionsListLabelsForSelfHostedRunnerForOrg(_ input: Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsListLabelsForSelfHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListLabelsForSelfHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.org,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add custom labels to a self-hosted runner for an organization
    ///
    /// Adds custom labels to a self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/post(actions/add-custom-labels-to-self-hosted-runner-for-org)`.
    public func actionsAddCustomLabelsToSelfHostedRunnerForOrg(_ input: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.org,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set custom labels for a self-hosted runner for an organization
    ///
    /// Remove all previous custom labels and set the new custom labels for a specific
    /// self-hosted runner configured in an organization.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/put(actions/set-custom-labels-for-self-hosted-runner-for-org)`.
    public func actionsSetCustomLabelsForSelfHostedRunnerForOrg(_ input: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.org,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove all custom labels from a self-hosted runner for an organization
    ///
    /// Remove all custom labels from a self-hosted runner configured in an
    /// organization. Returns the remaining read-only labels from the runner.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/delete(actions/remove-all-custom-labels-from-self-hosted-runner-for-org)`.
    public func actionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg(_ input: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.org,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabelsReadonly.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabelsReadonly.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a custom label from a self-hosted runner for an organization
    ///
    /// Remove a custom label from a self-hosted runner configured
    /// in an organization. Returns the remaining labels from the runner.
    ///
    /// This endpoint returns a `404 Not Found` status if the custom label is not
    /// present on the runner.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/runners/{runner_id}/labels/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/runners/{runner_id}/labels/{name}/delete(actions/remove-custom-label-from-self-hosted-runner-for-org)`.
    public func actionsRemoveCustomLabelFromSelfHostedRunnerForOrg(_ input: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Input) async throws -> Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/runners/{}/labels/{}",
                    parameters: [
                        input.path.org,
                        input.path.runnerId,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their
    /// encrypted values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/get(actions/list-org-secrets)`.
    public func actionsListOrgSecrets(_ input: Operations.ActionsListOrgSecrets.Input) async throws -> Operations.ActionsListOrgSecrets.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListOrgSecrets.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListOrgSecrets.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListOrgSecrets.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListOrgSecrets.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/public-key/get(actions/get-org-public-key)`.
    public func actionsGetOrgPublicKey(_ input: Operations.ActionsGetOrgPublicKey.Input) async throws -> Operations.ActionsGetOrgPublicKey.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetOrgPublicKey.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/public-key",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetOrgPublicKey.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsPublicKey.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read secrets
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/get(actions/get-org-secret)`.
    public func actionsGetOrgSecret(_ input: Operations.ActionsGetOrgSecret.Input) async throws -> Operations.ActionsGetOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}",
                    parameters: [
                        input.path.org,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetOrgSecret.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrganizationActionsSecret.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/put(actions/create-or-update-org-secret)`.
    public func actionsCreateOrUpdateOrgSecret(_ input: Operations.ActionsCreateOrUpdateOrgSecret.Input) async throws -> Operations.ActionsCreateOrUpdateOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateOrUpdateOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}",
                    parameters: [
                        input.path.org,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateOrUpdateOrgSecret.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/delete(actions/delete-org-secret)`.
    public func actionsDeleteOrgSecret(_ input: Operations.ActionsDeleteOrgSecret.Input) async throws -> Operations.ActionsDeleteOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}",
                    parameters: [
                        input.path.org,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/get(actions/list-selected-repos-for-org-secret)`.
    public func actionsListSelectedReposForOrgSecret(_ input: Operations.ActionsListSelectedReposForOrgSecret.Input) async throws -> Operations.ActionsListSelectedReposForOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelectedReposForOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelectedReposForOrgSecret.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelectedReposForOrgSecret.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/put(actions/set-selected-repos-for-org-secret)`.
    public func actionsSetSelectedReposForOrgSecret(_ input: Operations.ActionsSetSelectedReposForOrgSecret.Input) async throws -> Operations.ActionsSetSelectedReposForOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetSelectedReposForOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for
    /// repository access is set to `selected`. For more information about setting the visibility, see [Create or
    /// update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}/put(actions/add-selected-repo-to-org-secret)`.
    public func actionsAddSelectedRepoToOrgSecret(_ input: Operations.ActionsAddSelectedRepoToOrgSecret.Input) async throws -> Operations.ActionsAddSelectedRepoToOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsAddSelectedRepoToOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.secretName,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/actions/secrets#create-or-update-an-organization-secret).
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}/delete(actions/remove-selected-repo-from-org-secret)`.
    public func actionsRemoveSelectedRepoFromOrgSecret(_ input: Operations.ActionsRemoveSelectedRepoFromOrgSecret.Input) async throws -> Operations.ActionsRemoveSelectedRepoFromOrgSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveSelectedRepoFromOrgSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/secrets/{}/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.secretName,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List organization variables
    ///
    /// Lists all organization variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/get(actions/list-org-variables)`.
    public func actionsListOrgVariables(_ input: Operations.ActionsListOrgVariables.Input) async throws -> Operations.ActionsListOrgVariables.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListOrgVariables.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListOrgVariables.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListOrgVariables.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListOrgVariables.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create an organization variable
    ///
    /// Creates an organization variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/actions/variables`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/post(actions/create-org-variable)`.
    public func actionsCreateOrgVariable(_ input: Operations.ActionsCreateOrgVariable.Input) async throws -> Operations.ActionsCreateOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateOrgVariable.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an organization variable
    ///
    /// Gets a specific variable in an organization.
    ///
    /// The authenticated user must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/get(actions/get-org-variable)`.
    public func actionsGetOrgVariable(_ input: Operations.ActionsGetOrgVariable.Input) async throws -> Operations.ActionsGetOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}",
                    parameters: [
                        input.path.org,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetOrgVariable.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OrganizationActionsVariable.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update an organization variable
    ///
    /// Updates an organization variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/patch(actions/update-org-variable)`.
    public func actionsUpdateOrgVariable(_ input: Operations.ActionsUpdateOrgVariable.Input) async throws -> Operations.ActionsUpdateOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsUpdateOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}",
                    parameters: [
                        input.path.org,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an organization variable
    ///
    /// Deletes an organization variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/delete(actions/delete-org-variable)`.
    public func actionsDeleteOrgVariable(_ input: Operations.ActionsDeleteOrgVariable.Input) async throws -> Operations.ActionsDeleteOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}",
                    parameters: [
                        input.path.org,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List selected repositories for an organization variable
    ///
    /// Lists all repositories that can access an organization variable
    /// that is available to selected repositories.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/variables/{name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/get(actions/list-selected-repos-for-org-variable)`.
    public func actionsListSelectedReposForOrgVariable(_ input: Operations.ActionsListSelectedReposForOrgVariable.Input) async throws -> Operations.ActionsListSelectedReposForOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelectedReposForOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelectedReposForOrgVariable.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelectedReposForOrgVariable.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set selected repositories for an organization variable
    ///
    /// Replaces all repositories for an organization variable that is available
    /// to selected repositories. Organization variables that are available to selected
    /// repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/variables/{name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/put(actions/set-selected-repos-for-org-variable)`.
    public func actionsSetSelectedReposForOrgVariable(_ input: Operations.ActionsSetSelectedReposForOrgVariable.Input) async throws -> Operations.ActionsSetSelectedReposForOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetSelectedReposForOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}/repositories",
                    parameters: [
                        input.path.org,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add selected repository to an organization variable
    ///
    /// Adds a repository to an organization variable that is available to selected repositories.
    /// Organization variables that are available to selected repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/variables/{name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/{repository_id}/put(actions/add-selected-repo-to-org-variable)`.
    public func actionsAddSelectedRepoToOrgVariable(_ input: Operations.ActionsAddSelectedRepoToOrgVariable.Input) async throws -> Operations.ActionsAddSelectedRepoToOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsAddSelectedRepoToOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.name,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove selected repository from an organization variable
    ///
    /// Removes a repository from an organization variable that is
    /// available to selected repositories. Organization variables that are available to
    /// selected repositories have their `visibility` field set to `selected`.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/actions/variables/{name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/variables/{name}/repositories/{repository_id}/delete(actions/remove-selected-repo-from-org-variable)`.
    public func actionsRemoveSelectedRepoFromOrgVariable(_ input: Operations.ActionsRemoveSelectedRepoFromOrgVariable.Input) async throws -> Operations.ActionsRemoveSelectedRepoFromOrgVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveSelectedRepoFromOrgVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/actions/variables/{}/repositories/{}",
                    parameters: [
                        input.path.org,
                        input.path.name,
                        input.path.repositoryId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List artifacts for a repository
    ///
    /// Lists all artifacts for a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/get(actions/list-artifacts-for-repo)`.
    public func actionsListArtifactsForRepo(_ input: Operations.ActionsListArtifactsForRepo.Input) async throws -> Operations.ActionsListArtifactsForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListArtifactsForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/artifacts",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "name",
                    value: input.query.name
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListArtifactsForRepo.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListArtifactsForRepo.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListArtifactsForRepo.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an artifact
    ///
    /// Gets a specific artifact for a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/get(actions/get-artifact)`.
    public func actionsGetArtifact(_ input: Operations.ActionsGetArtifact.Input) async throws -> Operations.ActionsGetArtifact.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetArtifact.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/artifacts/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.artifactId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetArtifact.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Artifact.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an artifact
    ///
    /// Deletes an artifact for a workflow run.
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/artifacts/{artifact_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/delete(actions/delete-artifact)`.
    public func actionsDeleteArtifact(_ input: Operations.ActionsDeleteArtifact.Input) async throws -> Operations.ActionsDeleteArtifact.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteArtifact.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/artifacts/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.artifactId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Download an artifact
    ///
    /// Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
    /// the response header to find the URL for the download. The `:archive_format` must be `zip`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}/get(actions/download-artifact)`.
    public func actionsDownloadArtifact(_ input: Operations.ActionsDownloadArtifact.Input) async throws -> Operations.ActionsDownloadArtifact.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDownloadArtifact.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/artifacts/{}/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.artifactId,
                        input.path.archiveFormat
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 302:
                    let headers: Operations.ActionsDownloadArtifact.Output.Found.Headers = .init(location: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Location",
                        as: Components.Headers.Location.self
                    ))
                    return .found(.init(headers: headers))
                case 410:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Gone.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .gone(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get GitHub Actions cache usage for a repository
    ///
    /// Gets GitHub Actions cache usage for a repository.
    /// The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/cache/usage`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/cache/usage/get(actions/get-actions-cache-usage)`.
    public func actionsGetActionsCacheUsage(_ input: Operations.ActionsGetActionsCacheUsage.Input) async throws -> Operations.ActionsGetActionsCacheUsage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetActionsCacheUsage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/cache/usage",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetActionsCacheUsage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsCacheUsageByRepository.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List GitHub Actions caches for a repository
    ///
    /// Lists the GitHub Actions caches for a repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/caches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/get(actions/get-actions-cache-list)`.
    public func actionsGetActionsCacheList(_ input: Operations.ActionsGetActionsCacheList.Input) async throws -> Operations.ActionsGetActionsCacheList.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetActionsCacheList.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/caches",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "ref",
                    value: input.query.ref
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "key",
                    value: input.query.key
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "sort",
                    value: input.query.sort
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsGetActionsCacheList.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetActionsCacheList.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsCacheList.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete GitHub Actions caches for a repository (using a cache key)
    ///
    /// Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/caches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/delete(actions/delete-actions-cache-by-key)`.
    public func actionsDeleteActionsCacheByKey(_ input: Operations.ActionsDeleteActionsCacheByKey.Input) async throws -> Operations.ActionsDeleteActionsCacheByKey.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteActionsCacheByKey.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/caches",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "key",
                    value: input.query.key
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "ref",
                    value: input.query.ref
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsDeleteActionsCacheByKey.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsCacheList.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a GitHub Actions cache for a repository (using a cache ID)
    ///
    /// Deletes a GitHub Actions cache for a repository, using a cache ID.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/caches/{cache_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/caches/{cache_id}/delete(actions/delete-actions-cache-by-id)`.
    public func actionsDeleteActionsCacheById(_ input: Operations.ActionsDeleteActionsCacheById.Input) async throws -> Operations.ActionsDeleteActionsCacheById.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteActionsCacheById.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/caches/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.cacheId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a job for a workflow run
    ///
    /// Gets a specific job in a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/jobs/{job_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/get(actions/get-job-for-workflow-run)`.
    public func actionsGetJobForWorkflowRun(_ input: Operations.ActionsGetJobForWorkflowRun.Input) async throws -> Operations.ActionsGetJobForWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetJobForWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/jobs/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.jobId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetJobForWorkflowRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Job.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Download job logs for a workflow run
    ///
    /// Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
    /// for `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/jobs/{job_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/logs/get(actions/download-job-logs-for-workflow-run)`.
    public func actionsDownloadJobLogsForWorkflowRun(_ input: Operations.ActionsDownloadJobLogsForWorkflowRun.Input) async throws -> Operations.ActionsDownloadJobLogsForWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDownloadJobLogsForWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/jobs/{}/logs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.jobId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 302:
                    let headers: Operations.ActionsDownloadJobLogsForWorkflowRun.Output.Found.Headers = .init(location: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Location",
                        as: Swift.String.self
                    ))
                    return .found(.init(headers: headers))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Re-run a job from a workflow run
    ///
    /// Re-run a job and its dependent jobs in a workflow run.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/jobs/{job_id}/rerun`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/jobs/{job_id}/rerun/post(actions/re-run-job-for-workflow-run)`.
    public func actionsReRunJobForWorkflowRun(_ input: Operations.ActionsReRunJobForWorkflowRun.Input) async throws -> Operations.ActionsReRunJobForWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsReRunJobForWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/jobs/{}/rerun",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.jobId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsReRunJobForWorkflowRun.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get the customization template for an OIDC subject claim for a repository
    ///
    /// Gets the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/oidc/customization/sub/get(actions/get-custom-oidc-sub-claim-for-repo)`.
    public func actionsGetCustomOidcSubClaimForRepo(_ input: Operations.ActionsGetCustomOidcSubClaimForRepo.Input) async throws -> Operations.ActionsGetCustomOidcSubClaimForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetCustomOidcSubClaimForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/oidc/customization/sub",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetCustomOidcSubClaimForRepo.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OidcCustomSubRepo.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 400:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.BadRequest.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json",
                            "application/scim+json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    case "application/scim+json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ScimError.self,
                            from: responseBody,
                            transforming: { value in
                                .applicationScimJson(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .badRequest(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set the customization template for an OIDC subject claim for a repository
    ///
    /// Sets the customization template and `opt-in` or `opt-out` flag for an OpenID Connect (OIDC) subject claim for a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/oidc/customization/sub/put(actions/set-custom-oidc-sub-claim-for-repo)`.
    public func actionsSetCustomOidcSubClaimForRepo(_ input: Operations.ActionsSetCustomOidcSubClaimForRepo.Input) async throws -> Operations.ActionsSetCustomOidcSubClaimForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetCustomOidcSubClaimForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/oidc/customization/sub",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsSetCustomOidcSubClaimForRepo.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 400:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.BadRequest.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json",
                            "application/scim+json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    case "application/scim+json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ScimError.self,
                            from: responseBody,
                            transforming: { value in
                                .applicationScimJson(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .badRequest(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repository organization secrets
    ///
    /// Lists all organization secrets shared with a repository without revealing their encrypted
    /// values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/organization-secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/organization-secrets/get(actions/list-repo-organization-secrets)`.
    public func actionsListRepoOrganizationSecrets(_ input: Operations.ActionsListRepoOrganizationSecrets.Input) async throws -> Operations.ActionsListRepoOrganizationSecrets.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRepoOrganizationSecrets.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/organization-secrets",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListRepoOrganizationSecrets.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRepoOrganizationSecrets.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListRepoOrganizationSecrets.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repository organization variables
    ///
    /// Lists all organization variables shared with a repository.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/organization-variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/organization-variables/get(actions/list-repo-organization-variables)`.
    public func actionsListRepoOrganizationVariables(_ input: Operations.ActionsListRepoOrganizationVariables.Input) async throws -> Operations.ActionsListRepoOrganizationVariables.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRepoOrganizationVariables.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/organization-variables",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListRepoOrganizationVariables.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRepoOrganizationVariables.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListRepoOrganizationVariables.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get GitHub Actions permissions for a repository
    ///
    /// Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions and reusable workflows allowed to run in the repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/get(actions/get-github-actions-permissions-repository)`.
    public func actionsGetGithubActionsPermissionsRepository(_ input: Operations.ActionsGetGithubActionsPermissionsRepository.Input) async throws -> Operations.ActionsGetGithubActionsPermissionsRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetGithubActionsPermissionsRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetGithubActionsPermissionsRepository.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsRepositoryPermissions.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set GitHub Actions permissions for a repository
    ///
    /// Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions and reusable workflows in the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/put(actions/set-github-actions-permissions-repository)`.
    public func actionsSetGithubActionsPermissionsRepository(_ input: Operations.ActionsSetGithubActionsPermissionsRepository.Input) async throws -> Operations.ActionsSetGithubActionsPermissionsRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetGithubActionsPermissionsRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get the level of access for workflows outside of the repository
    ///
    /// Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
    /// This endpoint only applies to private repositories.
    /// For more information, see "[Allowing access to components in a private repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/access`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/access/get(actions/get-workflow-access-to-repository)`.
    public func actionsGetWorkflowAccessToRepository(_ input: Operations.ActionsGetWorkflowAccessToRepository.Input) async throws -> Operations.ActionsGetWorkflowAccessToRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetWorkflowAccessToRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions/access",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetWorkflowAccessToRepository.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsWorkflowAccessToRepository.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set the level of access for workflows outside of the repository
    ///
    /// Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
    /// This endpoint only applies to private repositories.
    /// For more information, see "[Allowing access to components in a private repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/access`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/access/put(actions/set-workflow-access-to-repository)`.
    public func actionsSetWorkflowAccessToRepository(_ input: Operations.ActionsSetWorkflowAccessToRepository.Input) async throws -> Operations.ActionsSetWorkflowAccessToRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetWorkflowAccessToRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions/access",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get allowed actions and reusable workflows for a repository
    ///
    /// Gets the settings for selected actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/selected-actions/get(actions/get-allowed-actions-repository)`.
    public func actionsGetAllowedActionsRepository(_ input: Operations.ActionsGetAllowedActionsRepository.Input) async throws -> Operations.ActionsGetAllowedActionsRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetAllowedActionsRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions/selected-actions",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetAllowedActionsRepository.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.SelectedActions.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set allowed actions and reusable workflows for a repository
    ///
    /// Sets the actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/selected-actions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/selected-actions/put(actions/set-allowed-actions-repository)`.
    public func actionsSetAllowedActionsRepository(_ input: Operations.ActionsSetAllowedActionsRepository.Input) async throws -> Operations.ActionsSetAllowedActionsRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetAllowedActionsRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions/selected-actions",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get default workflow permissions for a repository
    ///
    /// Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
    /// as well as if GitHub Actions can submit approving pull request reviews.
    /// For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/workflow/get(actions/get-github-actions-default-workflow-permissions-repository)`.
    public func actionsGetGithubActionsDefaultWorkflowPermissionsRepository(_ input: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Input) async throws -> Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions/workflow",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetGithubActionsDefaultWorkflowPermissionsRepository.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsGetDefaultWorkflowPermissions.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set default workflow permissions for a repository
    ///
    /// Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
    /// can submit approving pull request reviews.
    /// For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/permissions/workflow`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/permissions/workflow/put(actions/set-github-actions-default-workflow-permissions-repository)`.
    public func actionsSetGithubActionsDefaultWorkflowPermissionsRepository(_ input: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Input) async throws -> Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetGithubActionsDefaultWorkflowPermissionsRepository.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/permissions/workflow",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 409:
                    return .conflict(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List self-hosted runners for a repository
    ///
    /// Lists all self-hosted runners configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/get(actions/list-self-hosted-runners-for-repo)`.
    public func actionsListSelfHostedRunnersForRepo(_ input: Operations.ActionsListSelfHostedRunnersForRepo.Input) async throws -> Operations.ActionsListSelfHostedRunnersForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListSelfHostedRunnersForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "name",
                    value: input.query.name
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListSelfHostedRunnersForRepo.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListSelfHostedRunnersForRepo.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListSelfHostedRunnersForRepo.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List runner applications for a repository
    ///
    /// Lists binaries for the runner application that you can download and run.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/downloads`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/downloads/get(actions/list-runner-applications-for-repo)`.
    public func actionsListRunnerApplicationsForRepo(_ input: Operations.ActionsListRunnerApplicationsForRepo.Input) async throws -> Operations.ActionsListRunnerApplicationsForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRunnerApplicationsForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/downloads",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRunnerApplicationsForRepo.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.RunnerApplication].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create configuration for a just-in-time runner for a repository
    ///
    /// Generates a configuration that can be passed to the runner application at startup.
    ///
    /// The authenticated user must have admin access to the repository.
    ///
    /// OAuth tokens and personal access tokens (classic) need the`repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/generate-jitconfig`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/generate-jitconfig/post(actions/generate-runner-jitconfig-for-repo)`.
    public func actionsGenerateRunnerJitconfigForRepo(_ input: Operations.ActionsGenerateRunnerJitconfigForRepo.Input) async throws -> Operations.ActionsGenerateRunnerJitconfigForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGenerateRunnerJitconfigForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/generate-jitconfig",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerJitconfig.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerJitconfig.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 409:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Conflict.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .conflict(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a registration token for a repository
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
    ///
    /// ```
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/registration-token`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/registration-token/post(actions/create-registration-token-for-repo)`.
    public func actionsCreateRegistrationTokenForRepo(_ input: Operations.ActionsCreateRegistrationTokenForRepo.Input) async throws -> Operations.ActionsCreateRegistrationTokenForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateRegistrationTokenForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/registration-token",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateRegistrationTokenForRepo.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AuthenticationToken.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a remove token for a repository
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an repository. The token expires after one hour.
    ///
    /// For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
    ///
    /// ```
    /// ./config.sh remove --token TOKEN
    /// ```
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/remove-token`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/remove-token/post(actions/create-remove-token-for-repo)`.
    public func actionsCreateRemoveTokenForRepo(_ input: Operations.ActionsCreateRemoveTokenForRepo.Input) async throws -> Operations.ActionsCreateRemoveTokenForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateRemoveTokenForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/remove-token",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateRemoveTokenForRepo.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AuthenticationToken.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a self-hosted runner for a repository
    ///
    /// Gets a specific self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/get(actions/get-self-hosted-runner-for-repo)`.
    public func actionsGetSelfHostedRunnerForRepo(_ input: Operations.ActionsGetSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsGetSelfHostedRunnerForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetSelfHostedRunnerForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetSelfHostedRunnerForRepo.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Runner.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a self-hosted runner from a repository
    ///
    /// Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/delete(actions/delete-self-hosted-runner-from-repo)`.
    public func actionsDeleteSelfHostedRunnerFromRepo(_ input: Operations.ActionsDeleteSelfHostedRunnerFromRepo.Input) async throws -> Operations.ActionsDeleteSelfHostedRunnerFromRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteSelfHostedRunnerFromRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List labels for a self-hosted runner for a repository
    ///
    /// Lists all labels for a self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/get(actions/list-labels-for-self-hosted-runner-for-repo)`.
    public func actionsListLabelsForSelfHostedRunnerForRepo(_ input: Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsListLabelsForSelfHostedRunnerForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListLabelsForSelfHostedRunnerForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add custom labels to a self-hosted runner for a repository
    ///
    /// Adds custom labels to a self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the organization to use this endpoint.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/post(actions/add-custom-labels-to-self-hosted-runner-for-repo)`.
    public func actionsAddCustomLabelsToSelfHostedRunnerForRepo(_ input: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsAddCustomLabelsToSelfHostedRunnerForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Set custom labels for a self-hosted runner for a repository
    ///
    /// Remove all previous custom labels and set the new custom labels for a specific
    /// self-hosted runner configured in a repository.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/put(actions/set-custom-labels-for-self-hosted-runner-for-repo)`.
    public func actionsSetCustomLabelsForSelfHostedRunnerForRepo(_ input: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsSetCustomLabelsForSelfHostedRunnerForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove all custom labels from a self-hosted runner for a repository
    ///
    /// Remove all custom labels from a self-hosted runner configured in a
    /// repository. Returns the remaining read-only labels from the runner.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/delete(actions/remove-all-custom-labels-from-self-hosted-runner-for-repo)`.
    public func actionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo(_ input: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveAllCustomLabelsFromSelfHostedRunnerForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}/labels",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabelsReadonly.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabelsReadonly.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a custom label from a self-hosted runner for a repository
    ///
    /// Remove a custom label from a self-hosted runner configured
    /// in a repository. Returns the remaining labels from the runner.
    ///
    /// This endpoint returns a `404 Not Found` status if the custom label is not
    /// present on the runner.
    ///
    /// Authenticated users must have admin access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}/delete(actions/remove-custom-label-from-self-hosted-runner-for-repo)`.
    public func actionsRemoveCustomLabelFromSelfHostedRunnerForRepo(_ input: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Input) async throws -> Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsRemoveCustomLabelFromSelfHostedRunnerForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runners/{}/labels/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runnerId,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ActionsRunnerLabels.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Responses.ActionsRunnerLabels.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailedSimple.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationErrorSimple.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List workflow runs for a repository
    ///
    /// Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/get(actions/list-workflow-runs-for-repo)`.
    public func actionsListWorkflowRunsForRepo(_ input: Operations.ActionsListWorkflowRunsForRepo.Input) async throws -> Operations.ActionsListWorkflowRunsForRepo.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListWorkflowRunsForRepo.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "actor",
                    value: input.query.actor
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "branch",
                    value: input.query.branch
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "event",
                    value: input.query.event
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "status",
                    value: input.query.status
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "created",
                    value: input.query.created
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "exclude_pull_requests",
                    value: input.query.excludePullRequests
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "check_suite_id",
                    value: input.query.checkSuiteId
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "head_sha",
                    value: input.query.headSha
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListWorkflowRunsForRepo.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListWorkflowRunsForRepo.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListWorkflowRunsForRepo.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a workflow run
    ///
    /// Gets a specific workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/get(actions/get-workflow-run)`.
    public func actionsGetWorkflowRun(_ input: Operations.ActionsGetWorkflowRun.Input) async throws -> Operations.ActionsGetWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "exclude_pull_requests",
                    value: input.query.excludePullRequests
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetWorkflowRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.WorkflowRun.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a workflow run
    ///
    /// Deletes a specific workflow run.
    ///
    /// Anyone with write access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/delete(actions/delete-workflow-run)`.
    public func actionsDeleteWorkflowRun(_ input: Operations.ActionsDeleteWorkflowRun.Input) async throws -> Operations.ActionsDeleteWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get the review history for a workflow run
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/approvals`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/approvals/get(actions/get-reviews-for-run)`.
    public func actionsGetReviewsForRun(_ input: Operations.ActionsGetReviewsForRun.Input) async throws -> Operations.ActionsGetReviewsForRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetReviewsForRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/approvals",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetReviewsForRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.EnvironmentApprovals].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Approve a workflow run for a fork pull request
    ///
    /// Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/approve`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/approve/post(actions/approve-workflow-run)`.
    public func actionsApproveWorkflowRun(_ input: Operations.ActionsApproveWorkflowRun.Input) async throws -> Operations.ActionsApproveWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsApproveWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/approve",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsApproveWorkflowRun.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List workflow run artifacts
    ///
    /// Lists artifacts for a workflow run.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/artifacts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/artifacts/get(actions/list-workflow-run-artifacts)`.
    public func actionsListWorkflowRunArtifacts(_ input: Operations.ActionsListWorkflowRunArtifacts.Input) async throws -> Operations.ActionsListWorkflowRunArtifacts.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListWorkflowRunArtifacts.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/artifacts",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "name",
                    value: input.query.name
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListWorkflowRunArtifacts.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListWorkflowRunArtifacts.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListWorkflowRunArtifacts.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a workflow run attempt
    ///
    /// Gets a specific workflow run attempt.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/get(actions/get-workflow-run-attempt)`.
    public func actionsGetWorkflowRunAttempt(_ input: Operations.ActionsGetWorkflowRunAttempt.Input) async throws -> Operations.ActionsGetWorkflowRunAttempt.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetWorkflowRunAttempt.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/attempts/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId,
                        input.path.attemptNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "exclude_pull_requests",
                    value: input.query.excludePullRequests
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetWorkflowRunAttempt.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.WorkflowRun.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List jobs for a workflow run attempt
    ///
    /// Lists jobs for a specific workflow run attempt. You can use parameters to narrow the list of results. For more information
    /// about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint  with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs/get(actions/list-jobs-for-workflow-run-attempt)`.
    public func actionsListJobsForWorkflowRunAttempt(_ input: Operations.ActionsListJobsForWorkflowRunAttempt.Input) async throws -> Operations.ActionsListJobsForWorkflowRunAttempt.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListJobsForWorkflowRunAttempt.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/attempts/{}/jobs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId,
                        input.path.attemptNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListJobsForWorkflowRunAttempt.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListJobsForWorkflowRunAttempt.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListJobsForWorkflowRunAttempt.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Download workflow run attempt logs
    ///
    /// Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
    /// 1 minute. Look for `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs/get(actions/download-workflow-run-attempt-logs)`.
    public func actionsDownloadWorkflowRunAttemptLogs(_ input: Operations.ActionsDownloadWorkflowRunAttemptLogs.Input) async throws -> Operations.ActionsDownloadWorkflowRunAttemptLogs.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDownloadWorkflowRunAttemptLogs.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/attempts/{}/logs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId,
                        input.path.attemptNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 302:
                    let headers: Operations.ActionsDownloadWorkflowRunAttemptLogs.Output.Found.Headers = .init(location: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Location",
                        as: Swift.String.self
                    ))
                    return .found(.init(headers: headers))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Cancel a workflow run
    ///
    /// Cancels a workflow run using its `id`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/cancel/post(actions/cancel-workflow-run)`.
    public func actionsCancelWorkflowRun(_ input: Operations.ActionsCancelWorkflowRun.Input) async throws -> Operations.ActionsCancelWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCancelWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/cancel",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCancelWorkflowRun.Output.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                case 409:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Conflict.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .conflict(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Review custom deployment protection rules for a workflow run
    ///
    /// Approve or reject custom deployment protection rules provided by a GitHub App for a workflow run. For more information, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// > [!NOTE]
    /// > GitHub Apps can only review their own custom deployment protection rules. To approve or reject pending deployments that are waiting for review from a specific person or team, see [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`](/rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule/post(actions/review-custom-gates-for-run)`.
    public func actionsReviewCustomGatesForRun(_ input: Operations.ActionsReviewCustomGatesForRun.Input) async throws -> Operations.ActionsReviewCustomGatesForRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsReviewCustomGatesForRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/deployment_protection_rule",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Force cancel a workflow run
    ///
    /// Cancels a workflow run and bypasses conditions that would otherwise cause a workflow execution to continue, such as an `always()` condition on a job.
    /// You should only use this endpoint to cancel a workflow run when the workflow run is not responding to [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`](/rest/actions/workflow-runs#cancel-a-workflow-run).
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel/post(actions/force-cancel-workflow-run)`.
    public func actionsForceCancelWorkflowRun(_ input: Operations.ActionsForceCancelWorkflowRun.Input) async throws -> Operations.ActionsForceCancelWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsForceCancelWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/force-cancel",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 202:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsForceCancelWorkflowRun.Output.Accepted.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .accepted(.init(body: body))
                case 409:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Conflict.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .conflict(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List jobs for a workflow run
    ///
    /// Lists jobs for a workflow run. You can use parameters to narrow the list of results. For more information
    /// about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/jobs/get(actions/list-jobs-for-workflow-run)`.
    public func actionsListJobsForWorkflowRun(_ input: Operations.ActionsListJobsForWorkflowRun.Input) async throws -> Operations.ActionsListJobsForWorkflowRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListJobsForWorkflowRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/jobs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "filter",
                    value: input.query.filter
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListJobsForWorkflowRun.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListJobsForWorkflowRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListJobsForWorkflowRun.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Download workflow run logs
    ///
    /// Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
    /// `Location:` in the response header to find the URL for the download.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/logs/get(actions/download-workflow-run-logs)`.
    public func actionsDownloadWorkflowRunLogs(_ input: Operations.ActionsDownloadWorkflowRunLogs.Input) async throws -> Operations.ActionsDownloadWorkflowRunLogs.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDownloadWorkflowRunLogs.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/logs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 302:
                    let headers: Operations.ActionsDownloadWorkflowRunLogs.Output.Found.Headers = .init(location: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Location",
                        as: Swift.String.self
                    ))
                    return .found(.init(headers: headers))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete workflow run logs
    ///
    /// Deletes all logs for a workflow run.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/runs/{run_id}/logs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/logs/delete(actions/delete-workflow-run-logs)`.
    public func actionsDeleteWorkflowRunLogs(_ input: Operations.ActionsDeleteWorkflowRunLogs.Input) async throws -> Operations.ActionsDeleteWorkflowRunLogs.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteWorkflowRunLogs.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/logs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 500:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.InternalError.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .internalServerError(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get pending deployments for a workflow run
    ///
    /// Get all deployment environments for a workflow run that are waiting for protection rules to pass.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments/get(actions/get-pending-deployments-for-run)`.
    public func actionsGetPendingDeploymentsForRun(_ input: Operations.ActionsGetPendingDeploymentsForRun.Input) async throws -> Operations.ActionsGetPendingDeploymentsForRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetPendingDeploymentsForRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/pending_deployments",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetPendingDeploymentsForRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.PendingDeployment].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Review pending deployments for a workflow run
    ///
    /// Approve or reject pending deployments that are waiting on approval by a required reviewer.
    ///
    /// Required reviewers with read access to the repository contents and deployments can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments/post(actions/review-pending-deployments-for-run)`.
    public func actionsReviewPendingDeploymentsForRun(_ input: Operations.ActionsReviewPendingDeploymentsForRun.Input) async throws -> Operations.ActionsReviewPendingDeploymentsForRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsReviewPendingDeploymentsForRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/pending_deployments",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsReviewPendingDeploymentsForRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Deployment].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Re-run a workflow
    ///
    /// Re-runs your workflow run using its `id`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/rerun/post(actions/re-run-workflow)`.
    public func actionsReRunWorkflow(_ input: Operations.ActionsReRunWorkflow.Input) async throws -> Operations.ActionsReRunWorkflow.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsReRunWorkflow.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/rerun",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsReRunWorkflow.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Re-run failed jobs from a workflow run
    ///
    /// Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs/post(actions/re-run-workflow-failed-jobs)`.
    public func actionsReRunWorkflowFailedJobs(_ input: Operations.ActionsReRunWorkflowFailedJobs.Input) async throws -> Operations.ActionsReRunWorkflowFailedJobs.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsReRunWorkflowFailedJobs.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/rerun-failed-jobs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsReRunWorkflowFailedJobs.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get workflow run usage
    ///
    /// > [!WARNING]  
    /// > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.
    ///
    /// Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/runs/{run_id}/timing`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/runs/{run_id}/timing/get(actions/get-workflow-run-usage)`.
    public func actionsGetWorkflowRunUsage(_ input: Operations.ActionsGetWorkflowRunUsage.Input) async throws -> Operations.ActionsGetWorkflowRunUsage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetWorkflowRunUsage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/runs/{}/timing",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.runId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetWorkflowRunUsage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.WorkflowRunUsage.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/get(actions/list-repo-secrets)`.
    public func actionsListRepoSecrets(_ input: Operations.ActionsListRepoSecrets.Input) async throws -> Operations.ActionsListRepoSecrets.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRepoSecrets.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/secrets",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListRepoSecrets.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRepoSecrets.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListRepoSecrets.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/public-key/get(actions/get-repo-public-key)`.
    public func actionsGetRepoPublicKey(_ input: Operations.ActionsGetRepoPublicKey.Input) async throws -> Operations.ActionsGetRepoPublicKey.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetRepoPublicKey.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/secrets/public-key",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetRepoPublicKey.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsPublicKey.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value.
    ///
    /// The authenticated user must have collaborator access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/get(actions/get-repo-secret)`.
    public func actionsGetRepoSecret(_ input: Operations.ActionsGetRepoSecret.Input) async throws -> Operations.ActionsGetRepoSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetRepoSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/secrets/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetRepoSecret.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsSecret.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/put(actions/create-or-update-repo-secret)`.
    public func actionsCreateOrUpdateRepoSecret(_ input: Operations.ActionsCreateOrUpdateRepoSecret.Input) async throws -> Operations.ActionsCreateOrUpdateRepoSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateOrUpdateRepoSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/secrets/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateOrUpdateRepoSecret.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/secrets/{secret_name}/delete(actions/delete-repo-secret)`.
    public func actionsDeleteRepoSecret(_ input: Operations.ActionsDeleteRepoSecret.Input) async throws -> Operations.ActionsDeleteRepoSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteRepoSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/secrets/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repository variables
    ///
    /// Lists all repository variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/get(actions/list-repo-variables)`.
    public func actionsListRepoVariables(_ input: Operations.ActionsListRepoVariables.Input) async throws -> Operations.ActionsListRepoVariables.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRepoVariables.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/variables",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListRepoVariables.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRepoVariables.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListRepoVariables.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a repository variable
    ///
    /// Creates a repository variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/post(actions/create-repo-variable)`.
    public func actionsCreateRepoVariable(_ input: Operations.ActionsCreateRepoVariable.Input) async throws -> Operations.ActionsCreateRepoVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateRepoVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/variables",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateRepoVariable.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a repository variable
    ///
    /// Gets a specific variable in a repository.
    ///
    /// The authenticated user must have collaborator access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/get(actions/get-repo-variable)`.
    public func actionsGetRepoVariable(_ input: Operations.ActionsGetRepoVariable.Input) async throws -> Operations.ActionsGetRepoVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetRepoVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/variables/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetRepoVariable.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsVariable.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a repository variable
    ///
    /// Updates a repository variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/patch(actions/update-repo-variable)`.
    public func actionsUpdateRepoVariable(_ input: Operations.ActionsUpdateRepoVariable.Input) async throws -> Operations.ActionsUpdateRepoVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsUpdateRepoVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/variables/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a repository variable
    ///
    /// Deletes a repository variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/actions/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/variables/{name}/delete(actions/delete-repo-variable)`.
    public func actionsDeleteRepoVariable(_ input: Operations.ActionsDeleteRepoVariable.Input) async throws -> Operations.ActionsDeleteRepoVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteRepoVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/variables/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List repository workflows
    ///
    /// Lists the workflows in a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/get(actions/list-repo-workflows)`.
    public func actionsListRepoWorkflows(_ input: Operations.ActionsListRepoWorkflows.Input) async throws -> Operations.ActionsListRepoWorkflows.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListRepoWorkflows.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows",
                    parameters: [
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListRepoWorkflows.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListRepoWorkflows.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListRepoWorkflows.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a workflow
    ///
    /// Gets a specific workflow. You can replace `workflow_id` with the workflow
    /// file name. For example, you could use `main.yaml`.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/get(actions/get-workflow)`.
    public func actionsGetWorkflow(_ input: Operations.ActionsGetWorkflow.Input) async throws -> Operations.ActionsGetWorkflow.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetWorkflow.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.workflowId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetWorkflow.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Workflow.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Disable a workflow
    ///
    /// Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable/put(actions/disable-workflow)`.
    public func actionsDisableWorkflow(_ input: Operations.ActionsDisableWorkflow.Input) async throws -> Operations.ActionsDisableWorkflow.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDisableWorkflow.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows/{}/disable",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.workflowId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a workflow dispatch event
    ///
    /// You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches/post(actions/create-workflow-dispatch)`.
    public func actionsCreateWorkflowDispatch(_ input: Operations.ActionsCreateWorkflowDispatch.Input) async throws -> Operations.ActionsCreateWorkflowDispatch.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateWorkflowDispatch.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows/{}/dispatches",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.workflowId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Enable a workflow
    ///
    /// Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable/put(actions/enable-workflow)`.
    public func actionsEnableWorkflow(_ input: Operations.ActionsEnableWorkflow.Input) async throws -> Operations.ActionsEnableWorkflow.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsEnableWorkflow.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows/{}/enable",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.workflowId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List workflow runs for a workflow
    ///
    /// List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#parameters).
    ///
    /// Anyone with read access to the repository can use this endpoint
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs/get(actions/list-workflow-runs)`.
    public func actionsListWorkflowRuns(_ input: Operations.ActionsListWorkflowRuns.Input) async throws -> Operations.ActionsListWorkflowRuns.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListWorkflowRuns.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows/{}/runs",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.workflowId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "actor",
                    value: input.query.actor
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "branch",
                    value: input.query.branch
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "event",
                    value: input.query.event
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "status",
                    value: input.query.status
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "created",
                    value: input.query.created
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "exclude_pull_requests",
                    value: input.query.excludePullRequests
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "check_suite_id",
                    value: input.query.checkSuiteId
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "head_sha",
                    value: input.query.headSha
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListWorkflowRuns.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListWorkflowRuns.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListWorkflowRuns.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get workflow usage
    ///
    /// > [!WARNING]  
    /// > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.
    ///
    /// Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    ///
    /// You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing/get(actions/get-workflow-usage)`.
    public func actionsGetWorkflowUsage(_ input: Operations.ActionsGetWorkflowUsage.Input) async throws -> Operations.ActionsGetWorkflowUsage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetWorkflowUsage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/actions/workflows/{}/timing",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.workflowId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetWorkflowUsage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.WorkflowUsage.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List environment secrets
    ///
    /// Lists all secrets available in an environment without revealing their
    /// encrypted values.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/get(actions/list-environment-secrets)`.
    public func actionsListEnvironmentSecrets(_ input: Operations.ActionsListEnvironmentSecrets.Input) async throws -> Operations.ActionsListEnvironmentSecrets.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListEnvironmentSecrets.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/secrets",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListEnvironmentSecrets.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListEnvironmentSecrets.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListEnvironmentSecrets.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an environment public key
    ///
    /// Get the public key for an environment, which you need to encrypt environment
    /// secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key/get(actions/get-environment-public-key)`.
    public func actionsGetEnvironmentPublicKey(_ input: Operations.ActionsGetEnvironmentPublicKey.Input) async throws -> Operations.ActionsGetEnvironmentPublicKey.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetEnvironmentPublicKey.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/secrets/public-key",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetEnvironmentPublicKey.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsPublicKey.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an environment secret
    ///
    /// Gets a single environment secret without revealing its encrypted value.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/get(actions/get-environment-secret)`.
    public func actionsGetEnvironmentSecret(_ input: Operations.ActionsGetEnvironmentSecret.Input) async throws -> Operations.ActionsGetEnvironmentSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetEnvironmentSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/secrets/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetEnvironmentSecret.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsSecret.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create or update an environment secret
    ///
    /// Creates or updates an environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/put(actions/create-or-update-environment-secret)`.
    public func actionsCreateOrUpdateEnvironmentSecret(_ input: Operations.ActionsCreateOrUpdateEnvironmentSecret.Input) async throws -> Operations.ActionsCreateOrUpdateEnvironmentSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateOrUpdateEnvironmentSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/secrets/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateOrUpdateEnvironmentSecret.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an environment secret
    ///
    /// Deletes a secret in an environment using the secret name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read secrets.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}/delete(actions/delete-environment-secret)`.
    public func actionsDeleteEnvironmentSecret(_ input: Operations.ActionsDeleteEnvironmentSecret.Input) async throws -> Operations.ActionsDeleteEnvironmentSecret.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteEnvironmentSecret.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/secrets/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName,
                        input.path.secretName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List environment variables
    ///
    /// Lists all environment variables.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/get(actions/list-environment-variables)`.
    public func actionsListEnvironmentVariables(_ input: Operations.ActionsListEnvironmentVariables.Input) async throws -> Operations.ActionsListEnvironmentVariables.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsListEnvironmentVariables.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/variables",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ActionsListEnvironmentVariables.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsListEnvironmentVariables.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.ActionsListEnvironmentVariables.Output.Ok.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create an environment variable
    ///
    /// Create an environment variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/variables`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/post(actions/create-environment-variable)`.
    public func actionsCreateEnvironmentVariable(_ input: Operations.ActionsCreateEnvironmentVariable.Input) async throws -> Operations.ActionsCreateEnvironmentVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsCreateEnvironmentVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/variables",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsCreateEnvironmentVariable.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.EmptyObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get an environment variable
    ///
    /// Gets a specific variable in an environment.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/get(actions/get-environment-variable)`.
    public func actionsGetEnvironmentVariable(_ input: Operations.ActionsGetEnvironmentVariable.Input) async throws -> Operations.ActionsGetEnvironmentVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsGetEnvironmentVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/variables/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ActionsGetEnvironmentVariable.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ActionsVariable.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update an environment variable
    ///
    /// Updates an environment variable that you can reference in a GitHub Actions workflow.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/patch(actions/update-environment-variable)`.
    public func actionsUpdateEnvironmentVariable(_ input: Operations.ActionsUpdateEnvironmentVariable.Input) async throws -> Operations.ActionsUpdateEnvironmentVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsUpdateEnvironmentVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/variables/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an environment variable
    ///
    /// Deletes an environment variable using the variable name.
    ///
    /// Authenticated users must have collaborator access to a repository to create, update, or read variables.
    ///
    /// OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/variables/{name}/delete(actions/delete-environment-variable)`.
    public func actionsDeleteEnvironmentVariable(_ input: Operations.ActionsDeleteEnvironmentVariable.Input) async throws -> Operations.ActionsDeleteEnvironmentVariable.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ActionsDeleteEnvironmentVariable.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/environments/{}/variables/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.environmentName,
                        input.path.name
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
