# Contributing to this repository <!-- omit in toc -->

## Getting started <!-- omit in toc -->

Before you begin:
- Have you read the [code of conduct](CODE_OF_CONDUCT.md)?
- Check out the [existing issues](https://github.com/__USERNAME__/vuetify-color-field/issues).

### Don't see your issue? Open one

If you spot something new, open an issue using a [template](https://github.com/__USERNAME__/vuetify-color-field/issues/new/choose). We'll use the issue to have a conversation about the problem you want to fix.

### Ready to make a change? Fork the repo

Fork using the command line:

- [Fork the repo](https://docs.github.com/en/github/getting-started-with-github/fork-a-repo#fork-an-example-repository) so that you can make your changes without affecting the original project until you're ready to merge them.

### Make your update:

Make your changes to the file(s) you'd like to update.
Update the CHANGELOG.md with the updates you made, please include the date and Github username.

### Open a pull request
When you're done making changes and you'd like to propose them for review, open your PR (pull request).

### Submit your PR & get it reviewed
- Once you submit your PR, others from the Vue Unicorn Log community will review it with you.
- After that, we may have questions, check back on your PR to keep up with the conversation.

### Your PR is merged!
Congratulations! The whole GitHub community thanks you. :sparkles:

Once your PR is merged, you will be proudly listed as a contributor in the [contributor chart](https://github.com/__USERNAME__/vuetify-color-field/graphs/contributors).

### Keep contributing as you use Vue Unicorn Log

Now that you're a part of the Vue Unicorn Log community, you can keep participating in many ways.

## Types of contributions
You can contribute to the Vue Unicorn Log content and site in several ways. This repo is a place to discuss and collaborate on Vue Unicorn Log! Our small, but mighty team is maintaining this repo, to preserve our bandwidth, off topic conversations will be closed.

### :mega: Discussions
Discussions are where we have conversations.

If you'd like help troubleshooting a Vue Unicorn Log PR you're working on, have a great new idea, or want to share something amazing you've learned, join us in [discussions](https://github.com/__USERNAME__/vuetify-color-field/discussions).

### :beetle: Issues
[Issues](https://docs.github.com/en/github/managing-your-work-on-github/about-issues) are used to track tasks that contributors can help with.

If you've found something in the content or the website that should be updated, search open issues to see if someone else has reported the same thing. If it's something new, open an issue using a [template](https://github.com/__USERNAME__/vuetify-color-field/issues/new/choose). We'll use the issue to have a conversation about the problem you want to fix.

### :hammer_and_wrench: Pull requests
A [pull request](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests) is a way to suggest changes in our repository.

To learn more about opening a pull request in this repo, see [Opening a pull request](#opening-a-pull-request) below.

### :question: Support
We are a small team working hard to keep up with the documentation demands of a continuously changing product. Unfortunately, we just can't help with support questions in this repository. If you are experiencing a problem with GitHub, unrelated to our documentation, please [contact GitHub Support directly](https://support.github.com/contact). Any issues, discussions, or pull requests opened here requesting support will be given information about how to contact GitHub Support, then closed and locked.

If you're having trouble with your GitHub account, contact [Support](https://support.github.com/contact).

## Starting with an issue
You can browse existing issues to find something that needs help!

### Labels
Labels can help you find an issue you'd like to help with.

- The [`help wanted` label](https://github.com/__USERNAME__/vuetify-color-field/issues?q=is%3Aopen+is%3Aissue+label%3Aenhancement) is for problems or updates that anyone in the community can start working on.
- The [`documentation` label](https://github.com/__USERNAME__/vuetify-color-field/issues?q=is%3Aopen+is%3Aissue+label%3Adocumentation) is for problems or updates relating to the README.MD documentation.
- The [`bug` label](https://github.com/__USERNAME__/vuetify-color-field/issues?q=is%3Aopen+is%3Aissue+label%3Abug) is for problems with the code and bugs.
- The [`enhancement` label](https://github.com/__USERNAME__/vuetify-color-field/issues?q=is%3Aopen+is%3Aissue+label%3Aenhancement) is for 
suggestions to improve the code or adding of additional features.

## Opening a pull request
You can use the GitHub user interface for some small changes, like fixing a typo or updating a readme. You can also fork the repo and then clone it locally, to view changes and run your tests on your machine.

## Working in the Vue Unicorn Log repository
Here's some information that might be helpful while working on a Vue Unicorn Log PR:

<!-- - [Development](/contributing/development.md) - This short guide describes how to get this app running on your local machine. -->

## Reviewing
We (usually the Vue Unicorn Log team) review every single PR. The purpose of reviews is to create the best content we can for people who use GitHub.

- Reviews are always respectful, acknowledging that everyone did the best possible job with the knowledge they had at the time.  
- Reviews discuss content, not the person who created it.  
- Reviews are constructive and start conversation around feedback.  

### Self review
You should always review your own PR first.

<!-- ### Pull request template
When you open a pull request, you must fill out the "Ready for review" template before we can review your PR. This template helps reviewers understand your changes and the purpose of your pull request. -->

### Suggested changes
We may ask for changes to be made before a PR can be merged, either using [suggested changes](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/incorporating-feedback-in-your-pull-request) or pull request comments. You can apply suggested changes directly through the UI. You can make any other changes in your fork, then commit them to your branch.

As you update your PR and apply changes, mark each conversation as [resolved](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request#resolving-conversations).
