//
//  EIP712TestData.swift
//
//  Created by JeneaVranceanu on 19.10.2023.
//

import Foundation

class EIP712TestData {
    static let testTypedDataPayload = """
    {
    "types":{
      "EIP712Domain":[
         {
            "name":"name",
            "type":"string"
         },
         {
            "name":"version",
            "type":"string"
         },
         {
            "name":"chainId",
            "type":"uint256"
         },
         {
            "name":"verifyingContract",
            "type":"address"
         }
      ],
      "Person":[
         {
            "name":"name",
            "type":"string"
         },
         {
            "name":"wallet",
            "type":"address"
         }
      ],
      "Mail":[
         {
            "name":"from",
            "type":"Person"
         },
         {
            "name":"to",
            "type":"Person"
         },
         {
            "name":"contents",
            "type":"string"
         }
      ]
    },
    "primaryType":"Mail",
    "domain":{
      "name":"Ether Mail",
      "version":"1",
      "chainId":1,
      "verifyingContract":"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"
    },
    "message":{
      "from":{
         "name":"Cow",
         "wallet":"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"
      },
      "to":{
         "name":"Bob",
         "wallet":"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"
      },
      "contents":"Hello, Bob!"
    }
    }
"""
}
