# Everything in Eclipse

Everything is in Eclipse. As a Java Devloper, I consider Eclipse as my first IDE.  Eclipse is more powerful than you can think. So I collect the commonly used Eclipse plugins here for you.

### Contact 联系作者:

* Blog: [waylau.com](https://waylau.com)
* Gmail: [waylau521(at)gmail.com](mailto:waylau521@gmail.com)
* Weibo: [waylau521](http://weibo.com/waylau521)
* Twitter: [waylau521](https://twitter.com/waylau521)
* Github : [waylau](https://github.com/waylau)

-----------

## Eclipse

### Eclipse SDK 

Eclipse SDK will be a good start. The latest version of Eclipse : https://www.eclipse.org/downloads/

## Version control system（版本管理）

### EGit

EGit is an Eclipse Team provider for the Git version control system. Git is a distributed SCM, which means every developer has a full copy of all history of every revision of the code, making queries against the history very fast and versatile.

The EGit project is implementing Eclipse tooling on top of the JGit Java implementation of Git.

Git 在 Eclipse 的官方插件，是基于 JGit 的实现。

* Web site:http://www.eclipse.org/egit/
* Update site:http://download.eclipse.org/egit/updates
* Download/国内下载:http://www.eclipse.org/egit/download/
 
## Build tool（构建工具）

### Eclipse Buildship: Eclipse Plug-ins for Gradle 

M2Eclipse provides tight integration for Apache Maven into the Eclipse IDE.

Gradle 在 Eclipse 的官方插件。

* Web site:http://projects.eclipse.org/projects/tools.buildship
* Update site:http://download.eclipse.org/buildship/updates/e46/releases/2.x
* Download/国内下载:https://github.com/eclipse/buildship/releases

### M2Eclipse 

Eclipse Buildship is a collection of Eclipse plug-ins that provide support for building software using Gradle.

Buildship aims to provide a deep integration of Gradle into Eclipse. Buildship also aims to make the Eclipse IDE more powerful by allowing the user to do more from within the IDE.

Maven 在 Eclipse 的官方插件。


* Web site:<http://www.eclipse.org/m2e/>
* Update site:<http://download.eclipse.org/technology/m2e/releases/1.7/1.7.0.20160603-1933/>


## Compiler（编译器）

### Eclipse Class Decompiler 

Eclipse Class Decompiler integrates JD, Jad, FernFlower, CFR, Procyon seamlessly with Eclipse and allows Java developers to debug class files without source code directly .

Gradle 在 Eclipse 的官方插件。

* Web site: http://www.cpupk.com/decompiler
* Update site: http://raw.githubusercontent.com/cnfree/eclipse/master/decompiler/update/
* Download/国内下载: https://github.com/cnfree/Eclipse-Class-Decompiler/releases

 
## Editer（编辑器）

### Eclipse Web Developer Tools
 
Includes the HTML, CSS, and JSON Editors, and JavaScript Developer Tools from the Eclipse Web Tools Platform project, aimed at supporting client-side web development and node.js applications. Also installs the XML, XML Schema, and DTD Editors from the Eclipse Web Tools Platform project.

If you need to edit HTML, CSS, and JavaScript files, whether you're developing web applications or not, whatever the back-end, this one's for you.



Eclipse 官方出品的 Web 开发工具，支持 HTML、CSS、JSON、JavaScript、XML、XML Schema以及DTD 等的编辑与开发。

* Web site:http://marketplace.eclipse.org/content/eclipse-web-developer-tools-0
* Update site: 
 
### Thymeleaf Eclipse Plugin
 
The Thymeleaf plugin for Eclipse IDE adds content assist features that make working in Thymeleaf templates nicer and much more comfortable.

* Code completion of Thymeleaf attribute processors.
* Detailed explanations for each attribute.
* Content assist inside expressions: expression utility objects.

Thymeleaf 出品的用于开发 Thymeleaf 页面时的工具。

* Web site:https://github.com/thymeleaf/thymeleaf-extras-eclipse-plugin
* Update site: http://www.thymeleaf.org/eclipse-plugin-update-site/
* Download/国内下载:https://github.com/thymeleaf/thymeleaf-extras-eclipse-plugin/releases

### Eclipse Markdown Editor
 
Adds Markdown text editing support to Eclipse.Edit `.md` and `.txt` files with syntax highlighting.
Provides Outline and Preview HTML views.


Markdown 编辑器。

* Web site:http://www.winterwell.com/software/markdown-editor.php
* Update site:http://winterwell.com/software/updatesite
* Download/国内下载:https://github.com/winterstein/Eclipse-Markdown-Editor-Plugin/releases
* 中文介绍：https://waylau.com/about-eclipse-markdown-editor-plugin/

### GitHub Flavored Markdown Viewer 
 
An Eclipse plugin providing an accurate view of GitHub Flavored Markdown (.md) files


对 GitHub 友好 Markdown 编辑器。

* Web site:https://github.com/satyagraha/gfm_viewer
* Update site:https://raw.github.com/satyagraha/gfm_viewer/master/p2-composite/
* 中文介绍：https://waylau.com/not-generate-html-file-with-gfm/
* 国内下载: https://pan.baidu.com/s/1cvhiZO
 

## Code quality（代码质量）

### Checkstyle

Checkstyle is a Open Source development tool to help you ensure that your Java code adheres to a set of coding standards. Checkstyle does this by inspecting your Java source code and pointing out items that deviate from a defined set of coding rules.

* Web site:http://eclipse-cs.sourceforge.net/#!/
* Download:https://sourceforge.net/projects/eclipse-cs/files/latest/download
* 中文介绍：https://waylau.com/use-eclipse-checkstyle-plugin/
* 国内下载：https://pan.baidu.com/s/1qXQmonq


### PMD

PMD is a source code analyzer. It finds common programming flaws like unused variables, empty catch blocks, unnecessary object creation, and so forth. It supports Java, JavaScript, Salesforce.com Apex, PLSQL, Apache Velocity, XML, XSL. 

PMD 是一个源代码分析器。 它发现常见的编程缺陷，如未使用的变量、空 catch 块、不必要的对象创建等等。 它支持Java、JavaScript、Salesforce.com Apex、PLSQL、Apache Velocity、XML、XSL 等。

* Web site:http://pmd.sourceforge.net/
* Update site:https://sourceforge.net/projects/pmd/files/pmd-eclipse/update-site/
* 中文介绍：https://waylau.com/use-pmd-for-eclipse/
* 国内下载：https://pan.baidu.com/s/1hsE74Zq


## Design（设计）

### PlantUML

Generate UML diagram from textual description.PlantUML is a component that allows to quickly write UML.

PlantUML 是一个开源项目，通过简单并带指引性语言定义来定义各种 UML 视图。


* Web site:http://plantuml.sourceforge.net/
* Update site:http://plantuml.sourceforge.net/updatesitejuno/
* 中文介绍：https://waylau.com/use-plantuml-in-eclipse/
* 国内下载：https://pan.baidu.com/s/1gfdvTV9

## Analyzer（分析）

### Eclipse Memory Analyzer (MAT)


The Eclipse Memory Analyzer is a fast and feature-rich Java heap analyzer that helps you find memory leaks and reduce memory consumption.

Eclipse Memory Analyzer (MAT)是一个快速且功能丰富的Java堆分析器，可帮助您发现内存泄漏并减少内存消耗。

使用内存分析器分析具有数亿个对象的生产堆转储，快速计算对象的保留大小，查看谁在阻止垃圾收集器收集对象，运行报告以自动提取泄漏嫌疑。

* Web site: https://www.eclipse.org/mat
* Update site:http://download.eclipse.org/mat/1.10.0/update-site/
* 中文介绍：https://waylau.com/installation-and-use-of-eclipse-memory-analyzer/
* 国内下载：https://www.eclipse.org/mat/downloads.php
