# Client
Client-side intialization code.

- **Why?** &mdash; For the same reasons we have the standard
  [server setup](./server.md).

This module exports a single **`Launch(options)`** function that starts the app
at the client side. It renders the app, wraps it with
[`react-router`](https://www.npmjs.com/package/react-router)'s `<BrowserRouter>`,
and Redux store `<Provider>`, if necessary; then injects it into the page HTML
template generated by the server. In the case of use with development server,
it also takes care about HMR (Hot Module Reloading) setup at the clients-side.

**`options`** should be a JS object, with the following fields:
- **`Application`** &mdash; *Function* &mdash; The root ReactJS component of
  the app to be rendered.
- **`storeFactory`** &mdash; *Function* &mdash; Optional. Redux store factory.
  If provided, it will be used to generate Redux store that will be provided to
  the app. Its signature should be:

  **Arguments**
  - **`initialState`** &mdash; *Object* &mdash; Initial Redux state, injected by
    the server (will be `undefined`, if it is not generated by the current
    server setup).

  **Returns**
  - *Promise* that resolves to the created Redux store.
