# Babel Configurations
Standard configurations for [Babel](https://babeljs.io/).

**Why?** &mdash; We use Babel to support latest JavaScript specifications in our
projects, and to allow for some fancy features in our code. The standard Babel
configurations ensure that the same code patterns are supported in all of our apps.

Several Babel configurations are provided by this package:

- [**config/babel/node-ssr**](#node-ssr) &mdash; Babel configuration for NodeJS
compilation of JS and JSX modules (server-side ReactJS rendering);

- [**config/babel/webpack**](#webpack) &mdash; Babel configuration for Webpack
compilation of JS and JSX modules.

Use them as presets in your `.babelrc`, e.g.
```json
{
  "presets": ["topcoder-react-utils/config/babel/node-ssr"]
}
```

To set options provided by a preset:
```json
{
  "presets": [
    ["topcoder-react-utils/config/babel/node-ssr", {
      "someOption": "optionValue"
    }]
  ]
}
```

As the presets are JS modules, you can also wrap them into your own JS code to
create a special preset that customizes Babel configuration in any necessary
way. If you feel that the modification you need is useful for any generic
ReactJS app, feel free to open GitHub issue ticket to discuss an update of our
default configurations.

These presets may behave differently in different Babel environments. You can
set the environment with `BABEL_ENV` environment variable, or with `forceEnv`
option of the Webpack's `babel-loader`.

### Configuration Details

- <a name="node-ssr">**`config/babel/node-ssr.json`**</a> &mdash; Babel
configuration for NodeJS compilation of JS and JSX modules (server-side ReactJS
rendering);

  - Presets: [env](https://www.npmjs.com/package/babel-preset-env),
  [react](https://www.npmjs.com/package/babel-preset-react),
  [stage-2](https://www.npmjs.com/package/babel-preset-stage-2);

  - Uses [`babel-plugin-css-modules-transform`](https://www.npmjs.com/package/babel-plugin-css-modules-transform)
  to convertCSS and SCSS imports into objects with keys and values being the
  original and transformed class names. The transformed class names will match
  the class names generated by the `babel-plugin-react-css-modules` plugin,
  mentioned below;

  - Uses [`babel-plugin-dynamic-import-node`](https://www.npmjs.com/package/babel-plugin-dynamic-import-node)
  to support dynamic `import(..)` statemens;

  - Uses [`babel-plugin-inline-react-svg`](https://www.npmjs.com/package/babel-plugin-inline-react-svg)
  to embed imported SVG files into the complied JS modules;

  - Uses [`babel-plugin-module-resolver`](https://www.npmjs.com/package/babel-plugin-module-resolver)
  to setup the following paths as the roots for resolution of relative imports:
  `./src/shared`, `./src`. It will also apply path resolution to the first
  argument of `resolveWeak(..)` functions encountered in the compiled code;

  - Uses [`babel-plugin-react-css-modules`](https://www.npmjs.com/package/babel-plugin-react-css-modules)
  to transform `styleName` props of ReactJS components into globally unique
  `className` props. Generated class names are verbose in *development* and
  *test* Babel environments, for the ease of debugging; and they are short
  6-symbols hashes in the *production* Babel environment, for compactness of the
  compiled JS and CSS modules;

  - Uses [`babel-plugin-tranform-assets`](https://www.npmjs.com/package/babel-plugin-transform-assets)
  to convert GIF, JPEG, JPG, and PNG imports into
  `/images/[FILE_HASH].[FILE_EXTENSION]` URL strings. Use the
  **`baseAssetsOutputPath`** preset option to prefix generated paths with an
  arbitrary path;

  - Uses [`babel-plugin-transform-runtime`](https://www.npmjs.com/package/babel-plugin-transform-runtime)
  to optimize complied JS modules (it externalizes references to helpers and
  builtins, automatically polyfilling the code without polluting globals).

- <a name="webpack">**`config/babel/webpack`**</a> &mdash; Babel configuration
for Webpack compilation of JS and JSX modules.

  - Presets: [env](https://www.npmjs.com/package/babel-preset-env),
  [react](https://www.npmjs.com/package/babel-preset-react),
  [stage-2](https://www.npmjs.com/package/babel-preset-stage-2);

  - Uses [`babel-plugin-inline-react-svg`](https://www.npmjs.com/package/babel-plugin-inline-react-svg)
  to embed imported SVG files into the complied JS modules;

  - Uses [`babel-plugin-module-resolver`](https://www.npmjs.com/package/babel-plugin-module-resolver)
  to setup the following paths as the roots for resolution of relative imports:
  `./src/shared`, `./src`;

  - Uses [`babel-plugin-react-css-modules`](https://www.npmjs.com/package/babel-plugin-react-css-modules)
  to transform `styleName` props of ReactJS components into globally unique
  `className` props. Generated class names are verbose in *development* and
  *test* Babel environments, for the ease of debugging; and they are short
  6-symbols hashes in the *production* Babel environment, for compactness of the
  compiled JS and CSS modules;

  - Uses [`react-hot-loader/babel`](https://www.npmjs.com/package/react-hot-loader)
  to support hot module reloading in the *development* Babel environment;

  - Uses [`babel-plugin-transform-runtime`](https://www.npmjs.com/package/babel-plugin-transform-runtime)
  to optimize complied JS modules (it externalizes references to helpers and
  builtins, automatically polyfilling the code without polluting globals).
