# Typography

Standard mixins for body text, fonts, headings, labels, and titles.

[Live demo](https://community-app.topcoder-dev.com/examples/typography)

All these mixins use fonts from Roboto family. In majority of cases it is easy
to figure out which mixin you need for a specific element just by its font size
/ line height.

### Body Text Mixins
- 20/25px &mdash; **`tc-body-lg`**;
- 15/25px &mdash; **`tc-body-md`**;
- 13/25px &mdash; **`tc-body-sm`**;
- 11/20px &mdash; **`tc-body-xs`**.

### Heading Mixins
- 36/45px &mdash; **`tc-heading-xl`**;
- 28/35px &mdash; **`tc-heading-lg`**;
- 20/30px &mdash; **`tc-heading-md`**;
- 15/25px &mdash; **`tc-heading-sm`**;
- 13/25px &mdash; **`tc-heading-xs`**.

### Label Mixins
- 20/25px &mdash; **`tc-label-xl`**;
- 15/20px &mdash; **`tc-label-lg`**;
- 13/20px &mdash; **`tc-label-md`**;
- 12/15px &mdash; **`tc-label-sm`**;
- 11/15px &mdash; **`tc-label-xs`**.

### Title Mixins
- 42/50px &mdash; **`tc-title`**.

### Font Mixins
In some cases you may want to only include into a component the font-family
and the correct font weight. Here are some standard mixins for that (the numbers
in the list specify the weight):

##### font-family: Roboto, Helvetica, Arial, sans-serif
- 100 &mdash; **`roboto-thin`**;
- 300 &mdash; **`roboto-light`**;
- 400 &mdash; **`roboto-regular`**;
- 500 &mdash; **`roboto-medium`**;
- 700 &mdash; **`roboto-bold`**;
- 900 &mdash; **`roboto-black`**.

##### font-family: Roboto Mono, monospace
- 400 &mdash; **`roboto-mono-regular`**.