/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD.
    define(['expect.js', '../../src/index'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    factory(require('expect.js'), require('../../src/index'));
  } else {
    // Browser globals (root is window)
    factory(root.expect, root.ApChallengeMicroservice);
  }
}(this, function(expect, ApChallengeMicroservice) {
  'use strict';

  var instance;

  beforeEach(function() {
    instance = new ApChallengeMicroservice.DefaultApi();
  });

  describe('(package)', function() {
    describe('DefaultApi', function() {
      describe('activateChallenge', function() {
        it('should call activateChallenge successfully', function(done) {
          // TODO: uncomment, update parameter values for activateChallenge call and complete the assertions
          /*
          var id = "id_example";

          instance.activateChallenge(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.ChallengeResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.ChallengeResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Challenge);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be(0);
                expect(data.result.content.confidentialityType).to.be.a('string');
                expect(data.result.content.confidentialityType).to.be("");
                {
                  let dataCtr = data.result.content.technologies;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                expect(data.result.content.subTrack).to.be.a('string');
                expect(data.result.content.subTrack).to.be("WEB_DESIGNS");
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");
                expect(data.result.content.reviewType).to.be.a('string');
                expect(data.result.content.reviewType).to.be("COMMUNITY");
                expect(data.result.content.billingAccountId).to.be.a('number');
                expect(data.result.content.billingAccountId).to.be(0);
                expect(data.result.content.milestoneId).to.be.a('number');
                expect(data.result.content.milestoneId).to.be(0);
                expect(data.result.content.detailedRequirements).to.be.a('string');
                expect(data.result.content.detailedRequirements).to.be("");
                expect(data.result.content.submissionGuidelines).to.be.a('string');
                expect(data.result.content.submissionGuidelines).to.be("");
                expect(data.result.content.registrationStartsAt).to.be.a(Date);
                expect(data.result.content.registrationStartsAt).to.be(new Date());
                expect(data.result.content.registrationEndsAt).to.be.a(Date);
                expect(data.result.content.registrationEndsAt).to.be(new Date());
                expect(data.result.content.checkpointSubmissionStartsAt).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionStartsAt).to.be(new Date());
                expect(data.result.content.checkpointSubmissionEndsAt).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionEndsAt).to.be(new Date());
                expect(data.result.content.submissionEndsAt).to.be.a(Date);
                expect(data.result.content.submissionEndsAt).to.be(new Date());
                expect(data.result.content.round1Info).to.be.a('string');
                expect(data.result.content.round1Info).to.be("");
                expect(data.result.content.round2Info).to.be.a('string');
                expect(data.result.content.round2Info).to.be("");
                {
                  let dataCtr = data.result.content.platforms;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                expect(data.result.content.numberOfCheckpointPrizes).to.be.a('number');
                expect(data.result.content.numberOfCheckpointPrizes).to.be(0);
                expect(data.result.content.checkpointPrize).to.be.a('number');
                expect(data.result.content.checkpointPrize).to.be(0);
                {
                  let dataCtr = data.result.content.finalDeliverableTypes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.prizes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('number');
                    expect(data).to.be("0");
                  }
                }
                expect(data.result.content.projectId).to.be.a('number');
                expect(data.result.content.projectId).to.be(0);
                expect(data.result.content.submissionVisibility).to.be.a('boolean');
                expect(data.result.content.submissionVisibility).to.be(false);
                expect(data.result.content.maxNumOfSubmissions).to.be.a('number');
                expect(data.result.content.maxNumOfSubmissions).to.be(0);
                expect(data.result.content.task).to.be.a('boolean');
                expect(data.result.content.task).to.be(false);
                {
                  let dataCtr = data.result.content.assignees;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('string');
                    expect(data).to.be("");
                  }
                }
                expect(data.result.content.copilotId).to.be.a('number');
                expect(data.result.content.copilotId).to.be(0);
                expect(data.result.content.copilotFee).to.be.a('number');
                expect(data.result.content.copilotFee).to.be("0");
                {
                  let dataCtr = data.result.content.failedRegisterUsers;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeFailedRegisterUsers);
                    expect(data.handle).to.be.a('string');
                    expect(data.handle).to.be("");
                    expect(data.reason).to.be.a('string');
                    expect(data.reason).to.be("");
                    {
                      let dataCtr = data.properties;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a(ApChallengeMicroservice.ChallengeProperties);
                        expect(data.id).to.be.a('number');
                        expect(data.id).to.be(0);
                        expect(data.title).to.be.a('string');
                        expect(data.title).to.be("");
                        expect(data.url).to.be.a('string');
                        expect(data.url).to.be("");
                      }
                    }
                  }
                }
                expect(data.result.content.environment).to.be.a('string');
                expect(data.result.content.environment).to.be("");
                expect(data.result.content.codeRepo).to.be.a('string');
                expect(data.result.content.codeRepo).to.be("");
                expect(data.result.content.fixedFee).to.be.a('number');
                expect(data.result.content.fixedFee).to.be(0.0);
                expect(data.result.content.percentageFee).to.be.a('number');
                expect(data.result.content.percentageFee).to.be(0.0);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('cancelPrivateContest', function() {
        it('should call cancelPrivateContest successfully', function(done) {
          // TODO: uncomment, update parameter values for cancelPrivateContest call and complete the assertions
          /*
          var id = 8.14;

          instance.cancelPrivateContest(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.NullResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.NullResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(Object);
              expect(data.result.content).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengeResultsGet', function() {
        it('should call challengeResultsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for challengeResultsGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.challengeResultsGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2002);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2002Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2002ResultContent);
                  expect(data.oldRating).to.be.a('string');
                  expect(data.oldRating).to.be("");
                  expect(data.newRating).to.be.a('string');
                  expect(data.newRating).to.be("");
                  expect(data.finalScore).to.be.a('string');
                  expect(data.finalScore).to.be("");
                  expect(data.placement).to.be.a('string');
                  expect(data.placement).to.be("");
                  expect(data.passedReview).to.be.a('number');
                  expect(data.passedReview).to.be(0);
                  expect(data.challengeId).to.be.a('string');
                  expect(data.challengeId).to.be("");
                  expect(data.userId).to.be.a('string');
                  expect(data.userId).to.be("");
                  expect(data.handle).to.be.a('string');
                  expect(data.handle).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesGet', function() {
        it('should call challengesGet successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.challengesGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse200Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ChallengeResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.allChallengesCount).to.be.a('number');
                expect(data.result.metadata.allChallengesCount).to.be("0");
                expect(data.result.metadata.myChallengesCount).to.be.a('number');
                expect(data.result.metadata.myChallengesCount).to.be("0");
                expect(data.result.metadata.openChallengesCount).to.be.a('number');
                expect(data.result.metadata.openChallengesCount).to.be("0");
                expect(data.result.metadata.ongoingChallengesCount).to.be.a('number');
                expect(data.result.metadata.ongoingChallengesCount).to.be("0");
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultContent);
                  {
                    let dataCtr = data.submissions;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultSubmissions);
                      expect(data.id).to.be.a('number');
                      expect(data.id).to.be(0);
                      expect(data.status).to.be.a('string');
                      expect(data.status).to.be("");
                      expect(data.score).to.be.a('number');
                      expect(data.score).to.be(0.0);
                      expect(data.placement).to.be.a('number');
                      expect(data.placement).to.be(0);
                      expect(data.challengeId).to.be.a('number');
                      expect(data.challengeId).to.be(0);
                      expect(data.submissionImage).to.be.a(Object);
                      expect(data.submissionImage).to.be();
                      expect(data.submittedAt).to.be.a(Date);
                      expect(data.submittedAt).to.be(new Date());
                    }
                  }
                  expect(data.updatedAt).to.be.a(Date);
                  expect(data.updatedAt).to.be(new Date());
                  expect(data.createdAt).to.be.a(Date);
                  expect(data.createdAt).to.be(new Date());
                  expect(data.createdBy).to.be.a('string');
                  expect(data.createdBy).to.be("");
                  expect(data.updatedBy).to.be.a('string');
                  expect(data.updatedBy).to.be("");
                  expect(data.technologies).to.be.a('string');
                  expect(data.technologies).to.be("");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("");
                  expect(data.track).to.be.a('string');
                  expect(data.track).to.be("");
                  expect(data.subTrack).to.be.a('string');
                  expect(data.subTrack).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.reviewType).to.be.a('string');
                  expect(data.reviewType).to.be("");
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be(0);
                  expect(data.forumId).to.be.a('number');
                  expect(data.forumId).to.be(0);
                  expect(data.numSubmissions).to.be.a('number');
                  expect(data.numSubmissions).to.be(0);
                  expect(data.numSubmitters).to.be.a('number');
                  expect(data.numSubmitters).to.be(0);
                  expect(data.numRegistrants).to.be.a('number');
                  expect(data.numRegistrants).to.be(0);
                  expect(data.registrationStartDate).to.be.a(Date);
                  expect(data.registrationStartDate).to.be(new Date());
                  expect(data.registrationEndDate).to.be.a(Date);
                  expect(data.registrationEndDate).to.be(new Date());
                  expect(data.checkpointSubmissionEndDate).to.be.a(Date);
                  expect(data.checkpointSubmissionEndDate).to.be(new Date());
                  expect(data.submissionEndDate).to.be.a(Date);
                  expect(data.submissionEndDate).to.be(new Date());
                  expect(data.platforms).to.be.a('string');
                  expect(data.platforms).to.be("");
                  expect(data.numberOfCheckpointPrizes).to.be.a('number');
                  expect(data.numberOfCheckpointPrizes).to.be(0);
                  expect(data.totalCheckpointPrize).to.be.a('number');
                  expect(data.totalCheckpointPrize).to.be(0.0);
                  expect(data.totalPrize).to.be.a('number');
                  expect(data.totalPrize).to.be(0.0);
                  expect(data.isPrivate).to.be.a('boolean');
                  expect(data.isPrivate).to.be(false);
                  expect(data.upcomingPhase).to.be.a(Object);
                  expect(data.upcomingPhase).to.be();
                  expect(data.projectId).to.be.a('number');
                  expect(data.projectId).to.be(0);
                  expect(data.projectName).to.be.a('string');
                  expect(data.projectName).to.be("");
                  {
                    let dataCtr = data.currentPhases;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.Phases);
                      expect(data.type).to.be.a('string');
                      expect(data.type).to.be("");
                      expect(data.status).to.be.a('string');
                      expect(data.status).to.be("");
                      expect(data.scheduledStartTime).to.be.a(Date);
                      expect(data.scheduledStartTime).to.be(new Date());
                      expect(data.scheduledEndTime).to.be.a(Date);
                      expect(data.scheduledEndTime).to.be(new Date());
                      expect(data.actualStartTime).to.be.a(Date);
                      expect(data.actualStartTime).to.be(new Date());
                    }
                  }
                  expect(data.submissionViewable).to.be.a('boolean');
                  expect(data.submissionViewable).to.be(false);
                  {
                    let dataCtr = data.allPhases;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(Object);
                      expect(data).to.be();
                    }
                  }
                  {
                    let dataCtr = data.prize;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0.0);
                    }
                  }
                  {
                    let dataCtr = data.winners;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultWinners);
                      expect(data.userId).to.be.a('number');
                      expect(data.userId).to.be(0);
                      expect(data.type).to.be.a('string');
                      expect(data.type).to.be("");
                      expect(data.handle).to.be.a('string');
                      expect(data.handle).to.be("");
                      expect(data.placement).to.be.a('number');
                      expect(data.placement).to.be(0);
                    }
                  }
                  {
                    let dataCtr = data.events;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultEvents);
                      expect(data.eventId).to.be.a('number');
                      expect(data.eventId).to.be(0);
                      expect(data.eventName).to.be.a('string');
                      expect(data.eventName).to.be("");
                      expect(data.projectId).to.be.a('number');
                      expect(data.projectId).to.be(0);
                    }
                  }
                  expect(data.drPoints).to.be.a('number');
                  expect(data.drPoints).to.be(0.0);
                  expect(data.reliabilityBonus).to.be.a('number');
                  expect(data.reliabilityBonus).to.be(0.0);
                  expect(data.isTask).to.be.a('boolean');
                  expect(data.isTask).to.be(false);
                  expect(data.environment).to.be.a('string');
                  expect(data.environment).to.be("");
                  expect(data.codeRepo).to.be.a('string');
                  expect(data.codeRepo).to.be("");
                  {
                    let dataCtr = data.groupIds;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0);
                    }
                  }
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesIdGet', function() {
        it('should call challengesIdGet successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesIdGet call and complete the assertions
          /*
          var id = 8.14;
          var opts = {};
          opts.unified = true;

          instance.challengesIdGet(id, opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse20011Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContent);
                    expect(data.result.content.subTrack).to.be.a('string');
                expect(data.result.content.subTrack).to.be("");
                expect(data.result.content.challengeTitle).to.be.a('string');
                expect(data.result.content.challengeTitle).to.be("");
                expect(data.result.content.challengeId).to.be.a('number');
                expect(data.result.content.challengeId).to.be();
                expect(data.result.content.projectId).to.be.a('number');
                expect(data.result.content.projectId).to.be();
                expect(data.result.content.forumId).to.be.a('number');
                expect(data.result.content.forumId).to.be();
                expect(data.result.content.introduction).to.be.a('string');
                expect(data.result.content.introduction).to.be("");
                expect(data.result.content.detailedRequirements).to.be.a('string');
                expect(data.result.content.detailedRequirements).to.be("");
                expect(data.result.content.finalSubmissionGuidelines).to.be.a('string');
                expect(data.result.content.finalSubmissionGuidelines).to.be("");
                expect(data.result.content.screeningScorecardId).to.be.a('number');
                expect(data.result.content.screeningScorecardId).to.be();
                expect(data.result.content.reviewScorecardId).to.be.a('number');
                expect(data.result.content.reviewScorecardId).to.be();
                expect(data.result.content.cmcTaskId).to.be.a('number');
                expect(data.result.content.cmcTaskId).to.be();
                expect(data.result.content.numberOfCheckpointsPrizes).to.be.a('number');
                expect(data.result.content.numberOfCheckpointsPrizes).to.be(0);
                expect(data.result.content.topCheckPointPrize).to.be.a('number');
                expect(data.result.content.topCheckPointPrize).to.be(0.0);
                expect(data.result.content.postingDate).to.be.a(Date);
                expect(data.result.content.postingDate).to.be(new Date());
                expect(data.result.content.registrationEndDate).to.be.a(Date);
                expect(data.result.content.registrationEndDate).to.be(new Date());
                expect(data.result.content.checkpointSubmissionEndDate).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionEndDate).to.be(new Date());
                expect(data.result.content.submissionEndDate).to.be.a(Date);
                expect(data.result.content.submissionEndDate).to.be(new Date());
                expect(data.result.content.submissionsViewable).to.be.a('boolean');
                expect(data.result.content.submissionsViewable).to.be(false);
                expect(data.result.content.reviewType).to.be.a('string');
                expect(data.result.content.reviewType).to.be("");
                expect(data.result.content.environment).to.be.a('string');
                expect(data.result.content.environment).to.be("");
                expect(data.result.content.codeRepo).to.be.a('string');
                expect(data.result.content.codeRepo).to.be("");
                expect(data.result.content.allowStockArt).to.be.a('string');
                expect(data.result.content.allowStockArt).to.be("");
                {
                  let dataCtr = data.result.content.filetypes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('string');
                    expect(data).to.be("");
                  }
                }
                expect(data.result.content.forumLink).to.be.a('string');
                expect(data.result.content.forumLink).to.be("");
                expect(data.result.content.appealsEndDate).to.be.a(Date);
                expect(data.result.content.appealsEndDate).to.be(new Date());
                expect(data.result.content.finalFixEndDate).to.be.a(Date);
                expect(data.result.content.finalFixEndDate).to.be(new Date());
                expect(data.result.content.submissionLimit).to.be.a('number');
                expect(data.result.content.submissionLimit).to.be(0);
                expect(data.result.content.currentStatus).to.be.a('string');
                expect(data.result.content.currentStatus).to.be("");
                expect(data.result.content.drPoints).to.be.a('number');
                expect(data.result.content.drPoints).to.be(0.0);
                expect(data.result.content.reliabilityBonus).to.be.a('number');
                expect(data.result.content.reliabilityBonus).to.be(0.0);
                expect(data.result.content.challengeCommunity).to.be.a('string');
                expect(data.result.content.challengeCommunity).to.be("");
                expect(data.result.content.directUrl).to.be.a('string');
                expect(data.result.content.directUrl).to.be("");
                {
                  let dataCtr = data.result.content.technologies;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('string');
                    expect(data).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.prizes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('number');
                    expect(data).to.be(0.0);
                  }
                }
                {
                  let dataCtr = data.result.content.winners;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentWinners);
                    expect(data.submissionId).to.be.a('number');
                    expect(data.submissionId).to.be();
                    expect(data.submitter).to.be.a('string');
                    expect(data.submitter).to.be("");
                    expect(data.submissionTime).to.be.a(Date);
                    expect(data.submissionTime).to.be(new Date());
                    expect(data.rank).to.be.a('number');
                    expect(data.rank).to.be(0);
                    expect(data.points).to.be.a('number');
                    expect(data.points).to.be(0.0);
                  }
                }
                expect(data.result.content.currentPhaseName).to.be.a('string');
                expect(data.result.content.currentPhaseName).to.be("");
                expect(data.result.content.currentPhaseRemainingTime).to.be.a('number');
                expect(data.result.content.currentPhaseRemainingTime).to.be();
                expect(data.result.content.currentPhaseEndDate).to.be.a(Date);
                expect(data.result.content.currentPhaseEndDate).to.be(new Date());
                {
                  let dataCtr = data.result.content.documents;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentDocuments);
                    expect(data.documentName).to.be.a('string');
                    expect(data.documentName).to.be("");
                    expect(data.url).to.be.a('string');
                    expect(data.url).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.platforms;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('string');
                    expect(data).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.event;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentEvent);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be();
                    expect(data.eventDescription).to.be.a('string');
                    expect(data.eventDescription).to.be("");
                    expect(data.eventShortDesc).to.be.a('string');
                    expect(data.eventShortDesc).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.registrants;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentRegistrants);
                    expect(data.submissionDate).to.be.a(Date);
                    expect(data.submissionDate).to.be(new Date());
                    expect(data.reliability).to.be.a('number');
                    expect(data.reliability).to.be(0.0);
                    expect(data.colorStyle).to.be.a('string');
                    expect(data.colorStyle).to.be("");
                    expect(data.handle).to.be.a('string');
                    expect(data.handle).to.be("");
                    expect(data.rating).to.be.a('number');
                    expect(data.rating).to.be(0);
                    expect(data.registrationDate).to.be.a(Date);
                    expect(data.registrationDate).to.be(new Date());
                  }
                }
                {
                  let dataCtr = data.result.content.phases;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentPhases);
                    expect(data.type).to.be.a('string');
                    expect(data.type).to.be("");
                    expect(data.status).to.be.a('string');
                    expect(data.status).to.be("");
                    expect(data.scheduledStartTime).to.be.a(Date);
                    expect(data.scheduledStartTime).to.be(new Date());
                    expect(data.actualStartTime).to.be.a(Date);
                    expect(data.actualStartTime).to.be(new Date());
                    expect(data.scheduledEndTime).to.be.a(Date);
                    expect(data.scheduledEndTime).to.be(new Date());
                    expect(data.actualEndTime).to.be.a(Date);
                    expect(data.actualEndTime).to.be(new Date());
                  }
                }
                {
                  let dataCtr = data.result.content.terms;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentTerms);
                    expect(data.termsOfUseId).to.be.a('number');
                    expect(data.termsOfUseId).to.be();
                    expect(data.title).to.be.a('string');
                    expect(data.title).to.be("");
                    expect(data.url).to.be.a('string');
                    expect(data.url).to.be("");
                    expect(data.agreeabilityType).to.be.a('string');
                    expect(data.agreeabilityType).to.be("");
                    expect(data.templateId).to.be.a('string');
                    expect(data.templateId).to.be("");
                    expect(data.role).to.be.a('string');
                    expect(data.role).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.submissions;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentSubmissions1);
                    expect(data.submitterId).to.be.a('number');
                    expect(data.submitterId).to.be();
                    expect(data.submitter).to.be.a('string');
                    expect(data.submitter).to.be("");
                    {
                      let dataCtr = data.submissions;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentSubmissions);
                        expect(data.placement).to.be.a('number');
                        expect(data.placement).to.be(0);
                        expect(data.screeningScore).to.be.a('number');
                        expect(data.screeningScore).to.be(0.0);
                        expect(data.initialScore).to.be.a('number');
                        expect(data.initialScore).to.be(0.0);
                        expect(data.finalScore).to.be.a('number');
                        expect(data.finalScore).to.be(0.0);
                        expect(data.points).to.be.a('number');
                        expect(data.points).to.be(0.0);
                        expect(data.submissionStatus).to.be.a('string');
                        expect(data.submissionStatus).to.be("");
                        expect(data.submissionId).to.be.a('number');
                        expect(data.submissionId).to.be();
                        expect(data.submissionTime).to.be.a(Date);
                        expect(data.submissionTime).to.be(new Date());
                      }
                    }
                  }
                }
                {
                  let dataCtr = data.result.content.checkpoints;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20011ResultContentCheckpoints);
                    expect(data.submissionId).to.be.a('number');
                    expect(data.submissionId).to.be();
                    expect(data.submitter).to.be.a('string');
                    expect(data.submitter).to.be("");
                    expect(data.submissionTime).to.be.a(Date);
                    expect(data.submissionTime).to.be(new Date());
                  }
                }
                expect(data.result.content.numberOfRegistrants).to.be.a('number');
                expect(data.result.content.numberOfRegistrants).to.be(0);
                expect(data.result.content.numberOfSubmissions).to.be.a('number');
                expect(data.result.content.numberOfSubmissions).to.be(0);
                expect(data.result.content.numberOfSubmitters).to.be.a('number');
                expect(data.result.content.numberOfSubmitters).to.be(0);
                expect(data.result.content.numberOfCheckpointSubmissions).to.be.a('number');
                expect(data.result.content.numberOfCheckpointSubmissions).to.be(0);
                {
                  let dataCtr = data.result.content.pointPrizes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('number');
                    expect(data).to.be(0.0);
                  }
                }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesIdPut', function() {
        it('should call challengesIdPut successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesIdPut call and complete the assertions
          /*
          var id = 8.14;
          var body = new ApChallengeMicroservice.UpdateChallengeBodyParam();
          body.param = new ApChallengeMicroservice.ChallengeUpdate();
          body.param.id = 0;
          body.param.confidentialityType = "";
          body.param.technologies = [new ApChallengeMicroservice.ChallengeTechnologies()];
          body.param.technologies[0].id = 0;
          body.param.technologies[0].name = "";
          body.param.subTrack = "WEB_DESIGNS";
          body.param.name = "";
          body.param.reviewType = "COMMUNITY";
          body.param.billingAccountId = 0;
          body.param.milestoneId = 0;
          body.param.detailedRequirements = "";
          body.param.submissionGuidelines = "";
          body.param.registrationStartsAt = new Date();
          body.param.registrationEndsAt = new Date();
          body.param.checkpointSubmissionStartsAt = new Date();
          body.param.checkpointSubmissionEndsAt = new Date();
          body.param.submissionEndsAt = new Date();
          body.param.round1Info = "";
          body.param.round2Info = "";
          body.param.platforms = [new ApChallengeMicroservice.ChallengeTechnologies()];
          body.param.platforms[0].id = 0;
          body.param.platforms[0].name = "";
          body.param.numberOfCheckpointPrizes = 0;
          body.param.checkpointPrize = 0;
          body.param.finalDeliverableTypes = [new ApChallengeMicroservice.ChallengeTechnologies()];
          body.param.finalDeliverableTypes[0].id = 0;
          body.param.finalDeliverableTypes[0].name = "";
          body.param.prizes = ["0"];
          body.param.projectId = 0;
          body.param.submissionVisibility = false;
          body.param.maxNumOfSubmissions = 0;
          body.param.task = false;
          body.param.assignees = [""];
          body.param.copilotId = 0;
          body.param.copilotFee = "0";
          body.param.failedRegisterUsers = [new ApChallengeMicroservice.ChallengeFailedRegisterUsers()];
          body.param.failedRegisterUsers[0].handle = "";
          body.param.failedRegisterUsers[0].reason = "";
          body.param.failedRegisterUsers[0].properties = [new ApChallengeMicroservice.ChallengeProperties()];
          body.param.failedRegisterUsers[0].properties[0].id = 0;
          body.param.failedRegisterUsers[0].properties[0].title = "";
          body.param.failedRegisterUsers[0].properties[0].url = "";
          body.param.environment = "";
          body.param.codeRepo = "";
          body.param.fixedFee = 0.0;
          body.param.percentageFee = 0.0;

          instance.challengesIdPut(id, body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.ChallengeResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.ChallengeResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Challenge);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be(0);
                expect(data.result.content.confidentialityType).to.be.a('string');
                expect(data.result.content.confidentialityType).to.be("");
                {
                  let dataCtr = data.result.content.technologies;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                expect(data.result.content.subTrack).to.be.a('string');
                expect(data.result.content.subTrack).to.be("WEB_DESIGNS");
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");
                expect(data.result.content.reviewType).to.be.a('string');
                expect(data.result.content.reviewType).to.be("COMMUNITY");
                expect(data.result.content.billingAccountId).to.be.a('number');
                expect(data.result.content.billingAccountId).to.be(0);
                expect(data.result.content.milestoneId).to.be.a('number');
                expect(data.result.content.milestoneId).to.be(0);
                expect(data.result.content.detailedRequirements).to.be.a('string');
                expect(data.result.content.detailedRequirements).to.be("");
                expect(data.result.content.submissionGuidelines).to.be.a('string');
                expect(data.result.content.submissionGuidelines).to.be("");
                expect(data.result.content.registrationStartsAt).to.be.a(Date);
                expect(data.result.content.registrationStartsAt).to.be(new Date());
                expect(data.result.content.registrationEndsAt).to.be.a(Date);
                expect(data.result.content.registrationEndsAt).to.be(new Date());
                expect(data.result.content.checkpointSubmissionStartsAt).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionStartsAt).to.be(new Date());
                expect(data.result.content.checkpointSubmissionEndsAt).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionEndsAt).to.be(new Date());
                expect(data.result.content.submissionEndsAt).to.be.a(Date);
                expect(data.result.content.submissionEndsAt).to.be(new Date());
                expect(data.result.content.round1Info).to.be.a('string');
                expect(data.result.content.round1Info).to.be("");
                expect(data.result.content.round2Info).to.be.a('string');
                expect(data.result.content.round2Info).to.be("");
                {
                  let dataCtr = data.result.content.platforms;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                expect(data.result.content.numberOfCheckpointPrizes).to.be.a('number');
                expect(data.result.content.numberOfCheckpointPrizes).to.be(0);
                expect(data.result.content.checkpointPrize).to.be.a('number');
                expect(data.result.content.checkpointPrize).to.be(0);
                {
                  let dataCtr = data.result.content.finalDeliverableTypes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.prizes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('number');
                    expect(data).to.be("0");
                  }
                }
                expect(data.result.content.projectId).to.be.a('number');
                expect(data.result.content.projectId).to.be(0);
                expect(data.result.content.submissionVisibility).to.be.a('boolean');
                expect(data.result.content.submissionVisibility).to.be(false);
                expect(data.result.content.maxNumOfSubmissions).to.be.a('number');
                expect(data.result.content.maxNumOfSubmissions).to.be(0);
                expect(data.result.content.task).to.be.a('boolean');
                expect(data.result.content.task).to.be(false);
                {
                  let dataCtr = data.result.content.assignees;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('string');
                    expect(data).to.be("");
                  }
                }
                expect(data.result.content.copilotId).to.be.a('number');
                expect(data.result.content.copilotId).to.be(0);
                expect(data.result.content.copilotFee).to.be.a('number');
                expect(data.result.content.copilotFee).to.be("0");
                {
                  let dataCtr = data.result.content.failedRegisterUsers;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeFailedRegisterUsers);
                    expect(data.handle).to.be.a('string');
                    expect(data.handle).to.be("");
                    expect(data.reason).to.be.a('string');
                    expect(data.reason).to.be("");
                    {
                      let dataCtr = data.properties;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a(ApChallengeMicroservice.ChallengeProperties);
                        expect(data.id).to.be.a('number');
                        expect(data.id).to.be(0);
                        expect(data.title).to.be.a('string');
                        expect(data.title).to.be("");
                        expect(data.url).to.be.a('string');
                        expect(data.url).to.be("");
                      }
                    }
                  }
                }
                expect(data.result.content.environment).to.be.a('string');
                expect(data.result.content.environment).to.be("");
                expect(data.result.content.codeRepo).to.be.a('string');
                expect(data.result.content.codeRepo).to.be("");
                expect(data.result.content.fixedFee).to.be.a('number');
                expect(data.result.content.fixedFee).to.be(0.0);
                expect(data.result.content.percentageFee).to.be.a('number');
                expect(data.result.content.percentageFee).to.be(0.0);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesIdResourcesDelete', function() {
        it('should call challengesIdResourcesDelete successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesIdResourcesDelete call and complete the assertions
          /*
          var id = 8.14;
          var body = new ApChallengeMicroservice.RemoveResourceBody();
          body.roleId = 0;
          body.resourceUserId = 0;
          body.isStudio = false;

          instance.challengesIdResourcesDelete(id, body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.ManageResourceResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.ManageResourceResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              expect(data.result.content).to.be.a('boolean');
              expect(data.result.content).to.be(false);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesIdResourcesGet', function() {
        it('should call challengesIdResourcesGet successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesIdResourcesGet call and complete the assertions
          /*
          var id = 8.14;

          instance.challengesIdResourcesGet(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.GetResourceResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            {
              let dataCtr = data.result;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(ApChallengeMicroservice.GetResourceResult);
                expect(data.id).to.be.a('number');
                expect(data.id).to.be();
                expect(data.projectId).to.be.a('number');
                expect(data.projectId).to.be();
                expect(data.name).to.be.a('string');
                expect(data.name).to.be("");
                expect(data.role).to.be.a('string');
                expect(data.role).to.be("");
                expect(data.phaseId).to.be.a('number');
                expect(data.phaseId).to.be();
                {
                  let dataCtr = data.submissions;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('number');
                    expect(data).to.be();
                  }
                }
                expect(data.properties).to.be.a(Object);
                expect(data.properties).to.be();
                expect(data.createdAt).to.be.a(Date);
                expect(data.createdAt).to.be(new Date());
                expect(data.updatedAt).to.be.a(Date);
                expect(data.updatedAt).to.be(new Date());
                expect(data.createdBy).to.be.a('string');
                expect(data.createdBy).to.be("");
                expect(data.updatedBy).to.be.a('string');
                expect(data.updatedBy).to.be("");
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesIdResourcesPost', function() {
        it('should call challengesIdResourcesPost successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesIdResourcesPost call and complete the assertions
          /*
          var id = 8.14;
          var body = new ApChallengeMicroservice.AddResourceBody();
          body.roleId = 0;
          body.resourceUserId = 0;
          body.phaseId = 0;
          body.addNotification = false;
          body.addForumWatch = false;
          body.isStudio = false;
          body.checkTerm = false;

          instance.challengesIdResourcesPost(id, body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.ManageResourceResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.ManageResourceResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              expect(data.result.content).to.be.a('boolean');
              expect(data.result.content).to.be(false);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesIdResultsGet', function() {
        it('should call challengesIdResultsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesIdResultsGet call and complete the assertions
          /*
          var id = 8.14;

          instance.challengesIdResultsGet(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20012);
            expect(data.challengeCommunity).to.be.a('string');
            expect(data.challengeCommunity).to.be("design");
            expect(data.challengeType).to.be.a('string');
            expect(data.challengeType).to.be("Component Design");
            expect(data.challengeName).to.be.a('string');
            expect(data.challengeName).to.be("");
            expect(data.challengeId).to.be.a('number');
            expect(data.challengeId).to.be();
            expect(data.postingDate).to.be.a(Date);
            expect(data.postingDate).to.be(new Date());
            expect(data.challengeEndDate).to.be.a(Date);
            expect(data.challengeEndDate).to.be(new Date());
            expect(data.registrants).to.be.a('number');
            expect(data.registrants).to.be(0);
            expect(data.submissions).to.be.a('number');
            expect(data.submissions).to.be(0);
            expect(data.submissionsPassedScreening).to.be.a('number');
            expect(data.submissionsPassedScreening).to.be(0);
            expect(data.drPoints).to.be.a('number');
            expect(data.drPoints).to.be(0.0);
            expect(data.submissionsPercentage).to.be.a('number');
            expect(data.submissionsPercentage).to.be(0.0);
            expect(data.averageInitialScore).to.be.a('number');
            expect(data.averageInitialScore).to.be(0.0);
            expect(data.averageFinalScore).to.be.a('number');
            expect(data.averageFinalScore).to.be(0.0);
            {
              let dataCtr = data.results;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20012Results);
                expect(data.handle).to.be.a('string');
                expect(data.handle).to.be("");
                expect(data.placement).to.be.a('number');
                expect(data.placement).to.be(0);
                expect(data.submissionDate).to.be.a(Date);
                expect(data.submissionDate).to.be(new Date());
                expect(data.submissionStatus).to.be.a('string');
                expect(data.submissionStatus).to.be("Active");
                expect(data.registrationDate).to.be.a(Date);
                expect(data.registrationDate).to.be(new Date());
                expect(data.points).to.be.a('number');
                expect(data.points).to.be(0);
                expect(data.finalScore).to.be.a('number');
                expect(data.finalScore).to.be(0.0);
                expect(data.screeningScore).to.be.a('number');
                expect(data.screeningScore).to.be(0.0);
                expect(data.initialScore).to.be.a('number');
                expect(data.initialScore).to.be(0.0);
                expect(data.clientSelection).to.be.a('boolean');
                expect(data.clientSelection).to.be(false);
                expect(data.submissionDownloadLink).to.be.a('string');
                expect(data.submissionDownloadLink).to.be("");
                expect(data.previewDownloadLink).to.be.a('string');
                expect(data.previewDownloadLink).to.be("");
              }
            }
            {
              let dataCtr = data.finalFixes;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a('string');
                expect(data).to.be("");
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('challengesMemberGet', function() {
        it('should call challengesMemberGet successfully', function(done) {
          // TODO: uncomment, update parameter values for challengesMemberGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.orderBy = "orderBy_example";

          instance.challengesMemberGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20015);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse20015Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultContent);
                  {
                    let dataCtr = data.submissions;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultSubmissions);
                      expect(data.id).to.be.a('number');
                      expect(data.id).to.be(0);
                      expect(data.status).to.be.a('string');
                      expect(data.status).to.be("");
                      expect(data.score).to.be.a('number');
                      expect(data.score).to.be(0.0);
                      expect(data.placement).to.be.a('number');
                      expect(data.placement).to.be(0);
                      expect(data.challengeId).to.be.a('number');
                      expect(data.challengeId).to.be(0);
                      expect(data.submissionImage).to.be.a(Object);
                      expect(data.submissionImage).to.be();
                      expect(data.submittedAt).to.be.a(Date);
                      expect(data.submittedAt).to.be(new Date());
                    }
                  }
                  expect(data.updatedAt).to.be.a(Date);
                  expect(data.updatedAt).to.be(new Date());
                  expect(data.createdAt).to.be.a(Date);
                  expect(data.createdAt).to.be(new Date());
                  expect(data.createdBy).to.be.a('string');
                  expect(data.createdBy).to.be("");
                  expect(data.updatedBy).to.be.a('string');
                  expect(data.updatedBy).to.be("");
                  expect(data.technologies).to.be.a('string');
                  expect(data.technologies).to.be("");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("");
                  expect(data.track).to.be.a('string');
                  expect(data.track).to.be("");
                  expect(data.subTrack).to.be.a('string');
                  expect(data.subTrack).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.reviewType).to.be.a('string');
                  expect(data.reviewType).to.be("");
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be(0);
                  expect(data.forumId).to.be.a('number');
                  expect(data.forumId).to.be(0);
                  expect(data.numSubmissions).to.be.a('number');
                  expect(data.numSubmissions).to.be(0);
                  expect(data.numSubmitters).to.be.a('number');
                  expect(data.numSubmitters).to.be(0);
                  expect(data.numRegistrants).to.be.a('number');
                  expect(data.numRegistrants).to.be(0);
                  expect(data.registrationStartDate).to.be.a(Date);
                  expect(data.registrationStartDate).to.be(new Date());
                  expect(data.registrationEndDate).to.be.a(Date);
                  expect(data.registrationEndDate).to.be(new Date());
                  expect(data.checkpointSubmissionEndDate).to.be.a(Date);
                  expect(data.checkpointSubmissionEndDate).to.be(new Date());
                  expect(data.submissionEndDate).to.be.a(Date);
                  expect(data.submissionEndDate).to.be(new Date());
                  expect(data.platforms).to.be.a('string');
                  expect(data.platforms).to.be("");
                  expect(data.numberOfCheckpointPrizes).to.be.a('number');
                  expect(data.numberOfCheckpointPrizes).to.be(0);
                  expect(data.totalCheckpointPrize).to.be.a('number');
                  expect(data.totalCheckpointPrize).to.be(0.0);
                  expect(data.totalPrize).to.be.a('number');
                  expect(data.totalPrize).to.be(0.0);
                  expect(data.isPrivate).to.be.a('boolean');
                  expect(data.isPrivate).to.be(false);
                  expect(data.upcomingPhase).to.be.a(Object);
                  expect(data.upcomingPhase).to.be();
                  expect(data.projectId).to.be.a('number');
                  expect(data.projectId).to.be(0);
                  expect(data.projectName).to.be.a('string');
                  expect(data.projectName).to.be("");
                  {
                    let dataCtr = data.currentPhases;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.Phases);
                      expect(data.type).to.be.a('string');
                      expect(data.type).to.be("");
                      expect(data.status).to.be.a('string');
                      expect(data.status).to.be("");
                      expect(data.scheduledStartTime).to.be.a(Date);
                      expect(data.scheduledStartTime).to.be(new Date());
                      expect(data.scheduledEndTime).to.be.a(Date);
                      expect(data.scheduledEndTime).to.be(new Date());
                      expect(data.actualStartTime).to.be.a(Date);
                      expect(data.actualStartTime).to.be(new Date());
                    }
                  }
                  expect(data.submissionViewable).to.be.a('boolean');
                  expect(data.submissionViewable).to.be(false);
                  {
                    let dataCtr = data.allPhases;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(Object);
                      expect(data).to.be();
                    }
                  }
                  {
                    let dataCtr = data.prize;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0.0);
                    }
                  }
                  {
                    let dataCtr = data.winners;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultWinners);
                      expect(data.userId).to.be.a('number');
                      expect(data.userId).to.be(0);
                      expect(data.type).to.be.a('string');
                      expect(data.type).to.be("");
                      expect(data.handle).to.be.a('string');
                      expect(data.handle).to.be("");
                      expect(data.placement).to.be.a('number');
                      expect(data.placement).to.be(0);
                    }
                  }
                  {
                    let dataCtr = data.events;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultEvents);
                      expect(data.eventId).to.be.a('number');
                      expect(data.eventId).to.be(0);
                      expect(data.eventName).to.be.a('string');
                      expect(data.eventName).to.be("");
                      expect(data.projectId).to.be.a('number');
                      expect(data.projectId).to.be(0);
                    }
                  }
                  expect(data.drPoints).to.be.a('number');
                  expect(data.drPoints).to.be(0.0);
                  expect(data.reliabilityBonus).to.be.a('number');
                  expect(data.reliabilityBonus).to.be(0.0);
                  expect(data.isTask).to.be.a('boolean');
                  expect(data.isTask).to.be(false);
                  expect(data.environment).to.be.a('string');
                  expect(data.environment).to.be("");
                  expect(data.codeRepo).to.be.a('string');
                  expect(data.codeRepo).to.be("");
                  {
                    let dataCtr = data.groupIds;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0);
                    }
                  }
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('closePrivateContest', function() {
        it('should call closePrivateContest successfully', function(done) {
          // TODO: uncomment, update parameter values for closePrivateContest call and complete the assertions
          /*
          var id = 8.14;

          instance.closePrivateContest(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.NullResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.NullResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(Object);
              expect(data.result.content).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('directChallengesGet', function() {
        it('should call directChallengesGet successfully', function(done) {
          // TODO: uncomment, update parameter values for directChallengesGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;
          opts.orderBy = "orderBy_example";

          instance.directChallengesGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2001);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2001Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.InlineResponse2001ResultMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.DirectChallenge);
                  expect(data.id).to.be.a('string');
                  expect(data.id).to.be("");
                  expect(data.challengeName).to.be.a('string');
                  expect(data.challengeName).to.be("");
                  expect(data.challengeType).to.be.a('string');
                  expect(data.challengeType).to.be("");
                  expect(data.clientName).to.be.a('string');
                  expect(data.clientName).to.be("");
                  expect(data.clientId).to.be.a('number');
                  expect(data.clientId).to.be(0);
                  expect(data.billingName).to.be.a('string');
                  expect(data.billingName).to.be("");
                  expect(data.billingId).to.be.a('number');
                  expect(data.billingId).to.be(0);
                  expect(data.directProjectName).to.be.a('string');
                  expect(data.directProjectName).to.be("");
                  expect(data.directProjectId).to.be.a('number');
                  expect(data.directProjectId).to.be(0);
                  {
                    let dataCtr = data.challengeTechnologies;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  {
                    let dataCtr = data.challengePlatforms;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  expect(data.challengeStartDate).to.be.a(Date);
                  expect(data.challengeStartDate).to.be(new Date());
                  expect(data.challengeEndDate).to.be.a(Date);
                  expect(data.challengeEndDate).to.be(new Date());
                  expect(data.challengeStatus).to.be.a('string');
                  expect(data.challengeStatus).to.be("");
                  expect(data.challengeCreator).to.be.a('string');
                  expect(data.challengeCreator).to.be("");
                  {
                    let dataCtr = data.prizes;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.DirectPrize);
                      expect(data.id).to.be.a('string');
                      expect(data.id).to.be("");
                      expect(data.placement).to.be.a('number');
                      expect(data.placement).to.be(0);
                      expect(data.prizeAmount).to.be.a('number');
                      expect(data.prizeAmount).to.be(0);
                      expect(data.prizeType).to.be.a('number');
                      expect(data.prizeType).to.be(0);
                      expect(data.challengeId).to.be.a('number');
                      expect(data.challengeId).to.be(0);
                    }
                  }
                  {
                    let dataCtr = data.checkPointPrizes;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.DirectPrize);
                      expect(data.id).to.be.a('string');
                      expect(data.id).to.be("");
                      expect(data.placement).to.be.a('number');
                      expect(data.placement).to.be(0);
                      expect(data.prizeAmount).to.be.a('number');
                      expect(data.prizeAmount).to.be(0);
                      expect(data.prizeType).to.be.a('number');
                      expect(data.prizeType).to.be(0);
                      expect(data.challengeId).to.be.a('number');
                      expect(data.challengeId).to.be(0);
                    }
                  }
                  expect(data.totalPrize).to.be.a('number');
                  expect(data.totalPrize).to.be(0.0);
                  expect(data.drPoints).to.be.a('number');
                  expect(data.drPoints).to.be(0.0);
                  expect(data.reliabilityBonus).to.be.a('number');
                  expect(data.reliabilityBonus).to.be(0.0);
                  expect(data.challengeFee).to.be.a('number');
                  expect(data.challengeFee).to.be(0.0);
                  expect(data.reviewCost).to.be.a('number');
                  expect(data.reviewCost).to.be(0.0);
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getChallengeLegacyInfo', function() {
        it('should call getChallengeLegacyInfo successfully', function(done) {
          // TODO: uncomment, update parameter values for getChallengeLegacyInfo call and complete the assertions
          /*
          var challengeId = 8.14;

          instance.getChallengeLegacyInfo(challengeId, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20013);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse20013Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.InlineResponse20013ResultContent);
                    expect(data.result.content.contestId).to.be.a('number');
                expect(data.result.content.contestId).to.be();
                expect(data.result.content.componentId).to.be.a('number');
                expect(data.result.content.componentId).to.be();
                expect(data.result.content.roundId).to.be.a('number');
                expect(data.result.content.roundId).to.be();
                expect(data.result.content.isRegistered).to.be.a('boolean');
                expect(data.result.content.isRegistered).to.be(false);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getChallengeMetadata', function() {
        it('should call getChallengeMetadata successfully', function(done) {
          // TODO: uncomment getChallengeMetadata call and complete the assertions
          /*

          instance.getChallengeMetadata(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20014);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse20014Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.InlineResponse20014ResultContent);
                    expect(data.result.content.myChallengesCount).to.be.a('number');
                expect(data.result.content.myChallengesCount).to.be();
                expect(data.result.content.openChallengesCount).to.be.a('number');
                expect(data.result.content.openChallengesCount).to.be();
                expect(data.result.content.ongoingChallengesCount).to.be.a('number');
                expect(data.result.content.ongoingChallengesCount).to.be();
                expect(data.result.content.allChallengesCount).to.be.a('number');
                expect(data.result.content.allChallengesCount).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('getChallengeTypes', function() {
        it('should call getChallengeTypes successfully', function(done) {
          // TODO: uncomment getChallengeTypes call and complete the assertions
          /*

          instance.getChallengeTypes(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.ChallengeTypeResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.ChallengeTypeResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.ChallengeTypeResponseResultContent);
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be(0);
                  expect(data.type).to.be.a('string');
                  expect(data.type).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.subTrack).to.be.a('string');
                  expect(data.subTrack).to.be("");
                  expect(data.description).to.be.a('string');
                  expect(data.description).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('marathonMatcheResultsGet', function() {
        it('should call marathonMatcheResultsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for marathonMatcheResultsGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.marathonMatcheResultsGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2005);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2005Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2005ResultContent);
                  expect(data.placement).to.be.a('string');
                  expect(data.placement).to.be("");
                  expect(data.pointTotal).to.be.a('string');
                  expect(data.pointTotal).to.be("");
                  expect(data.oldRating).to.be.a('string');
                  expect(data.oldRating).to.be("");
                  expect(data.newRating).to.be.a('string');
                  expect(data.newRating).to.be("");
                  expect(data.rated).to.be.a('string');
                  expect(data.rated).to.be("0");
                  expect(data.userId).to.be.a('string');
                  expect(data.userId).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('marathonMatchesGet', function() {
        it('should call marathonMatchesGet successfully', function(done) {
          // TODO: uncomment, update parameter values for marathonMatchesGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.marathonMatchesGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2004);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2004Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2004ResultContent);
                  expect(data.id).to.be.a('string');
                  expect(data.id).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.type).to.be.a('string');
                  expect(data.type).to.be("");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("ACTIVE");
                  expect(data.startDate).to.be.a(Date);
                  expect(data.startDate).to.be(new Date());
                  expect(data.endDate).to.be.a(Date);
                  expect(data.endDate).to.be(new Date());
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('membersHandleChallengesGet', function() {
        it('should call membersHandleChallengesGet successfully', function(done) {
          // TODO: uncomment, update parameter values for membersHandleChallengesGet call and complete the assertions
          /*
          var handle = "handle_example";
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.membersHandleChallengesGet(handle, opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2008);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2008Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ChallengeResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.allChallengesCount).to.be.a('number');
                expect(data.result.metadata.allChallengesCount).to.be("0");
                expect(data.result.metadata.myChallengesCount).to.be.a('number');
                expect(data.result.metadata.myChallengesCount).to.be("0");
                expect(data.result.metadata.openChallengesCount).to.be.a('number');
                expect(data.result.metadata.openChallengesCount).to.be("0");
                expect(data.result.metadata.ongoingChallengesCount).to.be.a('number');
                expect(data.result.metadata.ongoingChallengesCount).to.be("0");
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2008ResultContent);
                  expect(data.updatedAt).to.be.a(Date);
                  expect(data.updatedAt).to.be(new Date());
                  expect(data.createdAt).to.be.a(Date);
                  expect(data.createdAt).to.be(new Date());
                  expect(data.createdBy).to.be.a('string');
                  expect(data.createdBy).to.be("");
                  expect(data.updatedBy).to.be.a('string');
                  expect(data.updatedBy).to.be("");
                  {
                    let dataCtr = data.technologies;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("");
                  expect(data.track).to.be.a('string');
                  expect(data.track).to.be("");
                  expect(data.subTrack).to.be.a('string');
                  expect(data.subTrack).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.reviewType).to.be.a('string');
                  expect(data.reviewType).to.be("");
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be(0);
                  expect(data.forumId).to.be.a('number');
                  expect(data.forumId).to.be(0);
                  expect(data.numSubmissions).to.be.a('number');
                  expect(data.numSubmissions).to.be(0);
                  expect(data.numRegistrants).to.be.a('number');
                  expect(data.numRegistrants).to.be(0);
                  expect(data.registrationStartDate).to.be.a(Date);
                  expect(data.registrationStartDate).to.be(new Date());
                  expect(data.registrationEndDate).to.be.a(Date);
                  expect(data.registrationEndDate).to.be(new Date());
                  expect(data.checkpointSubmissionEndDate).to.be.a(Date);
                  expect(data.checkpointSubmissionEndDate).to.be(new Date());
                  expect(data.submissionEndDate).to.be.a(Date);
                  expect(data.submissionEndDate).to.be(new Date());
                  {
                    let dataCtr = data.platforms;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('string');
                      expect(data).to.be("");
                    }
                  }
                  expect(data.numberOfCheckpointPrizes).to.be.a('number');
                  expect(data.numberOfCheckpointPrizes).to.be(0);
                  expect(data.totalCheckpointPrize).to.be.a('number');
                  expect(data.totalCheckpointPrize).to.be(0);
                  expect(data.totalPrize).to.be.a('number');
                  expect(data.totalPrize).to.be(0);
                  expect(data.isPrivate).to.be.a('boolean');
                  expect(data.isPrivate).to.be(false);
                  expect(data.upcomingPhase).to.be.a(Object);
                  expect(data.upcomingPhase).to.be();
                  expect(data.projectId).to.be.a('number');
                  expect(data.projectId).to.be(0);
                  expect(data.projectName).to.be.a('string');
                  expect(data.projectName).to.be("");
                  expect(data.currentPhases).to.be.a(Object);
                  expect(data.currentPhases).to.be();
                  {
                    let dataCtr = data.allPhases;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(Object);
                      expect(data).to.be();
                    }
                  }
                  {
                    let dataCtr = data.prize;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0);
                    }
                  }
                  {
                    let dataCtr = data.events;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultEvents);
                      expect(data.eventId).to.be.a('number');
                      expect(data.eventId).to.be(0);
                      expect(data.eventName).to.be.a('string');
                      expect(data.eventName).to.be("");
                      expect(data.projectId).to.be.a('number');
                      expect(data.projectId).to.be(0);
                    }
                  }
                  expect(data.drPoints).to.be.a('number');
                  expect(data.drPoints).to.be(0.0);
                  expect(data.reliabilityBonus).to.be.a('number');
                  expect(data.reliabilityBonus).to.be(0.0);
                  expect(data.userId).to.be.a('number');
                  expect(data.userId).to.be(0);
                  expect(data.handle).to.be.a('string');
                  expect(data.handle).to.be("");
                  expect(data.isTask).to.be.a('number');
                  expect(data.isTask).to.be(0);
                  expect(data.environment).to.be.a('string');
                  expect(data.environment).to.be("");
                  expect(data.codeRepo).to.be.a('string');
                  expect(data.codeRepo).to.be("");
                  {
                    let dataCtr = data.groupIds;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0);
                    }
                  }
                  expect(data.userDetails).to.be.a(ApChallengeMicroservice.InlineResponse2008ResultUserDetails);
                        {
                      let dataCtr = data.userDetails.roles;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a('string');
                        expect(data).to.be("");
                      }
                    }
                    expect(data.userDetails.hasUserSubmittedForReview).to.be.a('boolean');
                    expect(data.userDetails.hasUserSubmittedForReview).to.be(false);
                    expect(data.userDetails.submissionReviewScore).to.be.a('number');
                    expect(data.userDetails.submissionReviewScore).to.be(0);
                    expect(data.userDetails.winningPlacements).to.be.a('number');
                    expect(data.userDetails.winningPlacements).to.be(0);
                    {
                      let dataCtr = data.userDetails.submissions;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a(ApChallengeMicroservice.InlineResponse200ResultSubmissions);
                        expect(data.id).to.be.a('number');
                        expect(data.id).to.be(0);
                        expect(data.status).to.be.a('string');
                        expect(data.status).to.be("");
                        expect(data.score).to.be.a('number');
                        expect(data.score).to.be(0.0);
                        expect(data.placement).to.be.a('number');
                        expect(data.placement).to.be(0);
                        expect(data.challengeId).to.be.a('number');
                        expect(data.challengeId).to.be(0);
                        expect(data.submissionImage).to.be.a(Object);
                        expect(data.submissionImage).to.be();
                        expect(data.submittedAt).to.be.a(Date);
                        expect(data.submittedAt).to.be(new Date());
                      }
                    }
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('membersHandleMmsGet', function() {
        it('should call membersHandleMmsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for membersHandleMmsGet call and complete the assertions
          /*
          var handle = "handle_example";
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.membersHandleMmsGet(handle, opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20010);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse20010Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20010ResultContent);
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be(0);
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.type).to.be.a('string');
                  expect(data.type).to.be("");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("");
                  expect(data.startDate).to.be.a(Date);
                  expect(data.startDate).to.be(new Date());
                  expect(data.endDate).to.be.a(Date);
                  expect(data.endDate).to.be(new Date());
                  expect(data.track).to.be.a('string');
                  expect(data.track).to.be("");
                  expect(data.subTrack).to.be.a('string');
                  expect(data.subTrack).to.be("");
                  {
                    let dataCtr = data.numRegistrants;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0);
                    }
                  }
                  {
                    let dataCtr = data.rounds;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse20010ResultRounds);
                      expect(data.id).to.be.a('number');
                      expect(data.id).to.be(0);
                      expect(data.registrationStartAt).to.be.a(Date);
                      expect(data.registrationStartAt).to.be(new Date());
                      expect(data.registrationEndAt).to.be.a(Date);
                      expect(data.registrationEndAt).to.be(new Date());
                      expect(data.codingStartAt).to.be.a(Date);
                      expect(data.codingStartAt).to.be(new Date());
                      expect(data.codingEndAt).to.be.a(Date);
                      expect(data.codingEndAt).to.be(new Date());
                      expect(data.systemTestStartAt).to.be.a(Date);
                      expect(data.systemTestStartAt).to.be(new Date());
                      expect(data.systemTestEndAt).to.be.a(Date);
                      expect(data.systemTestEndAt).to.be(new Date());
                      expect(data.status).to.be.a('string');
                      expect(data.status).to.be("");
                      expect(data.forumId).to.be.a('number');
                      expect(data.forumId).to.be(0);
                      expect(data.userMMDetails).to.be.a(ApChallengeMicroservice.InlineResponse20010ResultUserMMDetails);
                            expect(data.userMMDetails.contestId).to.be.a('number');
                        expect(data.userMMDetails.contestId).to.be(0);
                        expect(data.userMMDetails.roundId).to.be.a('number');
                        expect(data.userMMDetails.roundId).to.be(0);
                        expect(data.userMMDetails.oldRating).to.be.a('number');
                        expect(data.userMMDetails.oldRating).to.be(0);
                        expect(data.userMMDetails.newRating).to.be.a('number');
                        expect(data.userMMDetails.newRating).to.be(0);
                        expect(data.userMMDetails.rated).to.be.a('number');
                        expect(data.userMMDetails.rated).to.be(0);
                        expect(data.userMMDetails.pointTotal).to.be.a('number');
                        expect(data.userMMDetails.pointTotal).to.be(0);
                        expect(data.userMMDetails.ovarallRank).to.be.a('number');
                        expect(data.userMMDetails.ovarallRank).to.be(0);
                        expect(data.userMMDetails.numSubmissions).to.be.a('number');
                        expect(data.userMMDetails.numSubmissions).to.be(0);
                    }
                  }
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('membersHandleSrmsGet', function() {
        it('should call membersHandleSrmsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for membersHandleSrmsGet call and complete the assertions
          /*
          var handle = "handle_example";
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.membersHandleSrmsGet(handle, opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2009);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2009Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2009ResultContent);
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be(0);
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.type).to.be.a('string');
                  expect(data.type).to.be("");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("");
                  expect(data.startDate).to.be.a(Date);
                  expect(data.startDate).to.be(new Date());
                  expect(data.endDate).to.be.a(Date);
                  expect(data.endDate).to.be(new Date());
                  expect(data.track).to.be.a('string');
                  expect(data.track).to.be("");
                  expect(data.subTrack).to.be.a('string');
                  expect(data.subTrack).to.be("");
                  {
                    let dataCtr = data.numRegistrants;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a('number');
                      expect(data).to.be(0);
                    }
                  }
                  {
                    let dataCtr = data.rounds;
                    expect(dataCtr).to.be.an(Array);
                    expect(dataCtr).to.not.be.empty();
                    for (let p in dataCtr) {
                      let data = dataCtr[p];
                      expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2009ResultRounds);
                      expect(data.id).to.be.a('number');
                      expect(data.id).to.be(0);
                      expect(data.registrationStartAt).to.be.a(Date);
                      expect(data.registrationStartAt).to.be(new Date());
                      expect(data.registrationEndAt).to.be.a(Date);
                      expect(data.registrationEndAt).to.be(new Date());
                      expect(data.codingStartAt).to.be.a(Date);
                      expect(data.codingStartAt).to.be(new Date());
                      expect(data.codingEndAt).to.be.a(Date);
                      expect(data.codingEndAt).to.be(new Date());
                      expect(data.systemTestStartAt).to.be.a(Date);
                      expect(data.systemTestStartAt).to.be(new Date());
                      expect(data.systemTestEndAt).to.be.a(Date);
                      expect(data.systemTestEndAt).to.be(new Date());
                      expect(data.status).to.be.a('string');
                      expect(data.status).to.be("");
                      expect(data.forumId).to.be.a('number');
                      expect(data.forumId).to.be(0);
                    }
                  }
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('phasesGet', function() {
        it('should call phasesGet successfully', function(done) {
          // TODO: uncomment, update parameter values for phasesGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.phasesGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2003);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2003Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2003ResultContent);
                  expect(data.phaseType).to.be.a('string');
                  expect(data.phaseType).to.be("Registration");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("Scheduled");
                  expect(data.fixedStarTime).to.be.a(Date);
                  expect(data.fixedStarTime).to.be(new Date());
                  expect(data.scheduledStarTime).to.be.a(Date);
                  expect(data.scheduledStarTime).to.be(new Date());
                  expect(data.scheduledEndTime).to.be.a(Date);
                  expect(data.scheduledEndTime).to.be(new Date());
                  expect(data.actualStartTime).to.be.a(Date);
                  expect(data.actualStartTime).to.be(new Date());
                  expect(data.actualEndTime).to.be.a(Date);
                  expect(data.actualEndTime).to.be(new Date());
                  expect(data.duration).to.be.a('string');
                  expect(data.duration).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('platformsGet', function() {
        it('should call platformsGet successfully', function(done) {
          // TODO: uncomment platformsGet call and complete the assertions
          /*

          instance.platformsGet(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.PlatformArrayResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.PlatformArrayResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.Platform);
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be();
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('platformsIdDelete', function() {
        it('should call platformsIdDelete successfully', function(done) {
          // TODO: uncomment, update parameter values for platformsIdDelete call and complete the assertions
          /*
          var id = 8.14;

          instance.platformsIdDelete(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.NormalResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.NormalResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(Object);
              expect(data.result.content).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('platformsIdPatch', function() {
        it('should call platformsIdPatch successfully', function(done) {
          // TODO: uncomment, update parameter values for platformsIdPatch call and complete the assertions
          /*
          var id = 8.14;
          var body = new ApChallengeMicroservice.NewPlatformBodyParam();
          body.param = new ApChallengeMicroservice.Platform();
          body.param.id = ;
          body.param.name = "";

          instance.platformsIdPatch(id, body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.PlatformResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.PlatformResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Platform);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be();
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('platformsPost', function() {
        it('should call platformsPost successfully', function(done) {
          // TODO: uncomment, update parameter values for platformsPost call and complete the assertions
          /*
          var body = new ApChallengeMicroservice.NewPlatformBodyParam();
          body.param = new ApChallengeMicroservice.Platform();
          body.param.id = ;
          body.param.name = "";

          instance.platformsPost(body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.PlatformResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.PlatformResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Platform);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be();
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('registerChallenge', function() {
        it('should call registerChallenge successfully', function(done) {
          // TODO: uncomment, update parameter values for registerChallenge call and complete the assertions
          /*
          var id = 8.14;

          instance.registerChallenge(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.NormalResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.NormalResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(Object);
              expect(data.result.content).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('saveDraftContest', function() {
        it('should call saveDraftContest successfully', function(done) {
          // TODO: uncomment, update parameter values for saveDraftContest call and complete the assertions
          /*
          var body = new ApChallengeMicroservice.NewChallengeBodyParam();
          body.param = new ApChallengeMicroservice.Challenge();
          body.param.id = 0;
          body.param.confidentialityType = "";
          body.param.technologies = [new ApChallengeMicroservice.ChallengeTechnologies()];
          body.param.technologies[0].id = 0;
          body.param.technologies[0].name = "";
          body.param.subTrack = "WEB_DESIGNS";
          body.param.name = "";
          body.param.reviewType = "COMMUNITY";
          body.param.billingAccountId = 0;
          body.param.milestoneId = 0;
          body.param.detailedRequirements = "";
          body.param.submissionGuidelines = "";
          body.param.registrationStartsAt = new Date();
          body.param.registrationEndsAt = new Date();
          body.param.checkpointSubmissionStartsAt = new Date();
          body.param.checkpointSubmissionEndsAt = new Date();
          body.param.submissionEndsAt = new Date();
          body.param.round1Info = "";
          body.param.round2Info = "";
          body.param.platforms = [new ApChallengeMicroservice.ChallengeTechnologies()];
          body.param.platforms[0].id = 0;
          body.param.platforms[0].name = "";
          body.param.numberOfCheckpointPrizes = 0;
          body.param.checkpointPrize = 0;
          body.param.finalDeliverableTypes = [new ApChallengeMicroservice.ChallengeTechnologies()];
          body.param.finalDeliverableTypes[0].id = 0;
          body.param.finalDeliverableTypes[0].name = "";
          body.param.prizes = ["0"];
          body.param.projectId = 0;
          body.param.submissionVisibility = false;
          body.param.maxNumOfSubmissions = 0;
          body.param.task = false;
          body.param.assignees = [""];
          body.param.copilotId = 0;
          body.param.copilotFee = "0";
          body.param.failedRegisterUsers = [new ApChallengeMicroservice.ChallengeFailedRegisterUsers()];
          body.param.failedRegisterUsers[0].handle = "";
          body.param.failedRegisterUsers[0].reason = "";
          body.param.failedRegisterUsers[0].properties = [new ApChallengeMicroservice.ChallengeProperties()];
          body.param.failedRegisterUsers[0].properties[0].id = 0;
          body.param.failedRegisterUsers[0].properties[0].title = "";
          body.param.failedRegisterUsers[0].properties[0].url = "";
          body.param.environment = "";
          body.param.codeRepo = "";
          body.param.fixedFee = 0.0;
          body.param.percentageFee = 0.0;

          instance.saveDraftContest(body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.ChallengeResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.ChallengeResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Challenge);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be(0);
                expect(data.result.content.confidentialityType).to.be.a('string');
                expect(data.result.content.confidentialityType).to.be("");
                {
                  let dataCtr = data.result.content.technologies;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                expect(data.result.content.subTrack).to.be.a('string');
                expect(data.result.content.subTrack).to.be("WEB_DESIGNS");
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");
                expect(data.result.content.reviewType).to.be.a('string');
                expect(data.result.content.reviewType).to.be("COMMUNITY");
                expect(data.result.content.billingAccountId).to.be.a('number');
                expect(data.result.content.billingAccountId).to.be(0);
                expect(data.result.content.milestoneId).to.be.a('number');
                expect(data.result.content.milestoneId).to.be(0);
                expect(data.result.content.detailedRequirements).to.be.a('string');
                expect(data.result.content.detailedRequirements).to.be("");
                expect(data.result.content.submissionGuidelines).to.be.a('string');
                expect(data.result.content.submissionGuidelines).to.be("");
                expect(data.result.content.registrationStartsAt).to.be.a(Date);
                expect(data.result.content.registrationStartsAt).to.be(new Date());
                expect(data.result.content.registrationEndsAt).to.be.a(Date);
                expect(data.result.content.registrationEndsAt).to.be(new Date());
                expect(data.result.content.checkpointSubmissionStartsAt).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionStartsAt).to.be(new Date());
                expect(data.result.content.checkpointSubmissionEndsAt).to.be.a(Date);
                expect(data.result.content.checkpointSubmissionEndsAt).to.be(new Date());
                expect(data.result.content.submissionEndsAt).to.be.a(Date);
                expect(data.result.content.submissionEndsAt).to.be(new Date());
                expect(data.result.content.round1Info).to.be.a('string');
                expect(data.result.content.round1Info).to.be("");
                expect(data.result.content.round2Info).to.be.a('string');
                expect(data.result.content.round2Info).to.be("");
                {
                  let dataCtr = data.result.content.platforms;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                expect(data.result.content.numberOfCheckpointPrizes).to.be.a('number');
                expect(data.result.content.numberOfCheckpointPrizes).to.be(0);
                expect(data.result.content.checkpointPrize).to.be.a('number');
                expect(data.result.content.checkpointPrize).to.be(0);
                {
                  let dataCtr = data.result.content.finalDeliverableTypes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeTechnologies);
                    expect(data.id).to.be.a('number');
                    expect(data.id).to.be(0);
                    expect(data.name).to.be.a('string');
                    expect(data.name).to.be("");
                  }
                }
                {
                  let dataCtr = data.result.content.prizes;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('number');
                    expect(data).to.be("0");
                  }
                }
                expect(data.result.content.projectId).to.be.a('number');
                expect(data.result.content.projectId).to.be(0);
                expect(data.result.content.submissionVisibility).to.be.a('boolean');
                expect(data.result.content.submissionVisibility).to.be(false);
                expect(data.result.content.maxNumOfSubmissions).to.be.a('number');
                expect(data.result.content.maxNumOfSubmissions).to.be(0);
                expect(data.result.content.task).to.be.a('boolean');
                expect(data.result.content.task).to.be(false);
                {
                  let dataCtr = data.result.content.assignees;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a('string');
                    expect(data).to.be("");
                  }
                }
                expect(data.result.content.copilotId).to.be.a('number');
                expect(data.result.content.copilotId).to.be(0);
                expect(data.result.content.copilotFee).to.be.a('number');
                expect(data.result.content.copilotFee).to.be("0");
                {
                  let dataCtr = data.result.content.failedRegisterUsers;
                  expect(dataCtr).to.be.an(Array);
                  expect(dataCtr).to.not.be.empty();
                  for (let p in dataCtr) {
                    let data = dataCtr[p];
                    expect(data).to.be.a(ApChallengeMicroservice.ChallengeFailedRegisterUsers);
                    expect(data.handle).to.be.a('string');
                    expect(data.handle).to.be("");
                    expect(data.reason).to.be.a('string');
                    expect(data.reason).to.be("");
                    {
                      let dataCtr = data.properties;
                      expect(dataCtr).to.be.an(Array);
                      expect(dataCtr).to.not.be.empty();
                      for (let p in dataCtr) {
                        let data = dataCtr[p];
                        expect(data).to.be.a(ApChallengeMicroservice.ChallengeProperties);
                        expect(data.id).to.be.a('number');
                        expect(data.id).to.be(0);
                        expect(data.title).to.be.a('string');
                        expect(data.title).to.be("");
                        expect(data.url).to.be.a('string');
                        expect(data.url).to.be("");
                      }
                    }
                  }
                }
                expect(data.result.content.environment).to.be.a('string');
                expect(data.result.content.environment).to.be("");
                expect(data.result.content.codeRepo).to.be.a('string');
                expect(data.result.content.codeRepo).to.be("");
                expect(data.result.content.fixedFee).to.be.a('number');
                expect(data.result.content.fixedFee).to.be(0.0);
                expect(data.result.content.percentageFee).to.be.a('number');
                expect(data.result.content.percentageFee).to.be(0.0);

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('srmResultsGet', function() {
        it('should call srmResultsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for srmResultsGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.srmResultsGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2007);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2007Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2007ResultContent);
                  expect(data.userId).to.be.a('string');
                  expect(data.userId).to.be("");
                  expect(data.oldRating).to.be.a('string');
                  expect(data.oldRating).to.be("");
                  expect(data.newRating).to.be.a('string');
                  expect(data.newRating).to.be("");
                  expect(data.rated).to.be.a('string');
                  expect(data.rated).to.be("0");
                  expect(data.roomPlacement).to.be.a('string');
                  expect(data.roomPlacement).to.be("");
                  expect(data.division).to.be.a('string');
                  expect(data.division).to.be("1");
                  expect(data.finalPoints).to.be.a('string');
                  expect(data.finalPoints).to.be("");
                  expect(data.divisionPlacement).to.be.a('string');
                  expect(data.divisionPlacement).to.be("");
                  expect(data.overallRank).to.be.a('string');
                  expect(data.overallRank).to.be("");
                  expect(data.contestId).to.be.a('string');
                  expect(data.contestId).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('srmsGet', function() {
        it('should call srmsGet successfully', function(done) {
          // TODO: uncomment, update parameter values for srmsGet call and complete the assertions
          /*
          var opts = {};
          opts.filter = "filter_example";
          opts.offset = 56;
          opts.limit = 56;

          instance.srmsGet(opts, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2006);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.InlineResponse2006Result);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be(0);
              expect(data.result.metadata).to.be.a(Object);
              expect(data.result.metadata).to.be();
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.InlineResponse2006ResultContent);
                  expect(data.id).to.be.a('string');
                  expect(data.id).to.be("");
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.type).to.be.a('string');
                  expect(data.type).to.be("");
                  expect(data.status).to.be.a('string');
                  expect(data.status).to.be("ACTIVE");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('technologiesGet', function() {
        it('should call technologiesGet successfully', function(done) {
          // TODO: uncomment technologiesGet call and complete the assertions
          /*

          instance.technologiesGet(function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.TechnologyArrayResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.TechnologyArrayResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              {
                let dataCtr = data.result.content;
                expect(dataCtr).to.be.an(Array);
                expect(dataCtr).to.not.be.empty();
                for (let p in dataCtr) {
                  let data = dataCtr[p];
                  expect(data).to.be.a(ApChallengeMicroservice.Technology);
                  expect(data.id).to.be.a('number');
                  expect(data.id).to.be();
                  expect(data.name).to.be.a('string');
                  expect(data.name).to.be("");
                  expect(data.description).to.be.a('string');
                  expect(data.description).to.be("");
                  expect(data.status).to.be.a(ApChallengeMicroservice.Status);
                        expect(data.status.id).to.be.a('number');
                    expect(data.status.id).to.be();
                    expect(data.status.description).to.be.a('string');
                    expect(data.status.description).to.be("");
                }
              }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('technologiesIdDelete', function() {
        it('should call technologiesIdDelete successfully', function(done) {
          // TODO: uncomment, update parameter values for technologiesIdDelete call and complete the assertions
          /*
          var id = 8.14;

          instance.technologiesIdDelete(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.NormalResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.NormalResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(Object);
              expect(data.result.content).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('technologiesIdPatch', function() {
        it('should call technologiesIdPatch successfully', function(done) {
          // TODO: uncomment, update parameter values for technologiesIdPatch call and complete the assertions
          /*
          var id = 8.14;
          var body = new ApChallengeMicroservice.NewTechnologyBodyParam();
          body.param = new ApChallengeMicroservice.Technology();
          body.param.id = ;
          body.param.name = "";
          body.param.description = "";
          body.param.status = new ApChallengeMicroservice.Status();
          body.param.status.id = ;
          body.param.status.description = "";

          instance.technologiesIdPatch(id, body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.TechnologyResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.TechnologyResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Technology);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be();
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");
                expect(data.result.content.description).to.be.a('string');
                expect(data.result.content.description).to.be("");
                expect(data.result.content.status).to.be.a(ApChallengeMicroservice.Status);
                      expect(data.result.content.status.id).to.be.a('number');
                  expect(data.result.content.status.id).to.be();
                  expect(data.result.content.status.description).to.be.a('string');
                  expect(data.result.content.status.description).to.be("");

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('technologiesPost', function() {
        it('should call technologiesPost successfully', function(done) {
          // TODO: uncomment, update parameter values for technologiesPost call and complete the assertions
          /*
          var body = new ApChallengeMicroservice.NewTechnologyBodyParam();
          body.param = new ApChallengeMicroservice.Technology();
          body.param.id = ;
          body.param.name = "";
          body.param.description = "";
          body.param.status = new ApChallengeMicroservice.Status();
          body.param.status.id = ;
          body.param.status.description = "";

          instance.technologiesPost(body, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.TechnologyResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.TechnologyResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(ApChallengeMicroservice.Technology);
                    expect(data.result.content.id).to.be.a('number');
                expect(data.result.content.id).to.be();
                expect(data.result.content.name).to.be.a('string');
                expect(data.result.content.name).to.be("");
                expect(data.result.content.description).to.be.a('string');
                expect(data.result.content.description).to.be("");
                expect(data.result.content.status).to.be.a(ApChallengeMicroservice.Status);
                      expect(data.result.content.status.id).to.be.a('number');
                  expect(data.result.content.status.id).to.be();
                  expect(data.result.content.status.description).to.be.a('string');
                  expect(data.result.content.status.description).to.be("");

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('unregisterChallenge', function() {
        it('should call unregisterChallenge successfully', function(done) {
          // TODO: uncomment, update parameter values for unregisterChallenge call and complete the assertions
          /*
          var id = 8.14;

          instance.unregisterChallenge(id, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(ApChallengeMicroservice.NormalResponse);
            expect(data.id).to.be.a('string');
            expect(data.id).to.be("");
            expect(data.version).to.be.a('string');
            expect(data.version).to.be("");
            expect(data.result).to.be.a(ApChallengeMicroservice.NormalResponseResult);
                  expect(data.result.success).to.be.a('boolean');
              expect(data.result.success).to.be(false);
              expect(data.result.status).to.be.a('number');
              expect(data.result.status).to.be();
              expect(data.result.metadata).to.be.a(ApChallengeMicroservice.ResponseMetadata);
                    expect(data.result.metadata.totalCount).to.be.a('number');
                expect(data.result.metadata.totalCount).to.be(0);
                expect(data.result.metadata.fields).to.be.a(ApChallengeMicroservice.ResponseMetadataFields);
                      expect(data.result.metadata.fields.label).to.be.a('string');
                  expect(data.result.metadata.fields.label).to.be("");
                  expect(data.result.metadata.fields.type).to.be.a('string');
                  expect(data.result.metadata.fields.type).to.be("");
                  expect(data.result.metadata.fields.isDefault).to.be.a('boolean');
                  expect(data.result.metadata.fields.isDefault).to.be(false);
              expect(data.result.content).to.be.a(Object);
              expect(data.result.content).to.be();

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
    });
  });

}));
