/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.Phases = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The Phases model module.
   * @module model/Phases
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>Phases</code>.
   * @alias module:model/Phases
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>Phases</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/Phases} obj Optional instance to populate.
   * @return {module:model/Phases} The populated <code>Phases</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('type'))
        obj.type = ApiClient.convertToType(data['type'], 'String');
      if (data.hasOwnProperty('status'))
        obj.status = ApiClient.convertToType(data['status'], 'String');
      if (data.hasOwnProperty('scheduledStartTime'))
        obj.scheduledStartTime = ApiClient.convertToType(data['scheduledStartTime'], 'Date');
      if (data.hasOwnProperty('scheduledEndTime'))
        obj.scheduledEndTime = ApiClient.convertToType(data['scheduledEndTime'], 'Date');
      if (data.hasOwnProperty('actualStartTime'))
        obj.actualStartTime = ApiClient.convertToType(data['actualStartTime'], 'Date');
    }
    return obj;
  }

  /**
   * @member {String} type
   */
  exports.prototype.type = undefined;

  /**
   * @member {String} status
   */
  exports.prototype.status = undefined;

  /**
   * ISO-8601 formatted date times >-(YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} scheduledStartTime
   */
  exports.prototype.scheduledStartTime = undefined;

  /**
   * ISO-8601 formatted date times >-(YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} scheduledEndTime
   */
  exports.prototype.scheduledEndTime = undefined;

  /**
   * ISO-8601 formatted date times >-(YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} actualStartTime
   */
  exports.prototype.actualStartTime = undefined;

  return exports;

}));
