/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/InlineResponse200ResultSubmissions'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./InlineResponse200ResultSubmissions'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse2008ResultUserDetails = factory(root.ApChallengeMicroservice.ApiClient, root.ApChallengeMicroservice.InlineResponse200ResultSubmissions);
  }
}(this, function(ApiClient, InlineResponse200ResultSubmissions) {
  'use strict';

  /**
   * The InlineResponse2008ResultUserDetails model module.
   * @module model/InlineResponse2008ResultUserDetails
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse2008ResultUserDetails</code>.
   * @alias module:model/InlineResponse2008ResultUserDetails
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse2008ResultUserDetails</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse2008ResultUserDetails} obj Optional instance to populate.
   * @return {module:model/InlineResponse2008ResultUserDetails} The populated <code>InlineResponse2008ResultUserDetails</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('roles'))
        obj.roles = ApiClient.convertToType(data['roles'], ['String']);
      if (data.hasOwnProperty('hasUserSubmittedForReview'))
        obj.hasUserSubmittedForReview = ApiClient.convertToType(data['hasUserSubmittedForReview'], 'Boolean');
      if (data.hasOwnProperty('submissionReviewScore'))
        obj.submissionReviewScore = ApiClient.convertToType(data['submissionReviewScore'], 'Number');
      if (data.hasOwnProperty('winningPlacements'))
        obj.winningPlacements = ApiClient.convertToType(data['winningPlacements'], 'Number');
      if (data.hasOwnProperty('submissions'))
        obj.submissions = ApiClient.convertToType(data['submissions'], [InlineResponse200ResultSubmissions]);
    }
    return obj;
  }

  /**
   * @member {Array.<String>} roles
   */
  exports.prototype.roles = undefined;

  /**
   * @member {Boolean} hasUserSubmittedForReview
   */
  exports.prototype.hasUserSubmittedForReview = undefined;

  /**
   * @member {Number} submissionReviewScore
   */
  exports.prototype.submissionReviewScore = undefined;

  /**
   * @member {Number} winningPlacements
   */
  exports.prototype.winningPlacements = undefined;

  /**
   * @member {Array.<module:model/InlineResponse200ResultSubmissions>} submissions
   */
  exports.prototype.submissions = undefined;

  return exports;

}));
