/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse2007ResultContent = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The InlineResponse2007ResultContent model module.
   * @module model/InlineResponse2007ResultContent
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse2007ResultContent</code>.
   * @alias module:model/InlineResponse2007ResultContent
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse2007ResultContent</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse2007ResultContent} obj Optional instance to populate.
   * @return {module:model/InlineResponse2007ResultContent} The populated <code>InlineResponse2007ResultContent</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('userId'))
        obj.userId = ApiClient.convertToType(data['userId'], 'String');
      if (data.hasOwnProperty('oldRating'))
        obj.oldRating = ApiClient.convertToType(data['oldRating'], 'String');
      if (data.hasOwnProperty('newRating'))
        obj.newRating = ApiClient.convertToType(data['newRating'], 'String');
      if (data.hasOwnProperty('rated'))
        obj.rated = ApiClient.convertToType(data['rated'], 'String');
      if (data.hasOwnProperty('roomPlacement'))
        obj.roomPlacement = ApiClient.convertToType(data['roomPlacement'], 'String');
      if (data.hasOwnProperty('division'))
        obj.division = ApiClient.convertToType(data['division'], 'String');
      if (data.hasOwnProperty('finalPoints'))
        obj.finalPoints = ApiClient.convertToType(data['finalPoints'], 'String');
      if (data.hasOwnProperty('divisionPlacement'))
        obj.divisionPlacement = ApiClient.convertToType(data['divisionPlacement'], 'String');
      if (data.hasOwnProperty('overallRank'))
        obj.overallRank = ApiClient.convertToType(data['overallRank'], 'String');
      if (data.hasOwnProperty('contestId'))
        obj.contestId = ApiClient.convertToType(data['contestId'], 'String');
    }
    return obj;
  }

  /**
   * the user id
   * @member {String} userId
   */
  exports.prototype.userId = undefined;

  /**
   * the old rating
   * @member {String} oldRating
   */
  exports.prototype.oldRating = undefined;

  /**
   * the new rating
   * @member {String} newRating
   */
  exports.prototype.newRating = undefined;

  /**
   * whether this SRM is rated
   * @member {module:model/InlineResponse2007ResultContent.RatedEnum} rated
   */
  exports.prototype.rated = undefined;

  /**
   * the room placement
   * @member {String} roomPlacement
   */
  exports.prototype.roomPlacement = undefined;

  /**
   * the division
   * @member {module:model/InlineResponse2007ResultContent.DivisionEnum} division
   */
  exports.prototype.division = undefined;

  /**
   * the final points
   * @member {String} finalPoints
   */
  exports.prototype.finalPoints = undefined;

  /**
   * the division placement
   * @member {String} divisionPlacement
   */
  exports.prototype.divisionPlacement = undefined;

  /**
   * the overall rank
   * @member {String} overallRank
   */
  exports.prototype.overallRank = undefined;

  /**
   * the contest id
   * @member {String} contestId
   */
  exports.prototype.contestId = undefined;


  /**
   * Allowed values for the <code>rated</code> property.
   * @enum {String}
   * @readonly
   */
  exports.RatedEnum = {
    /**
     * value: "0"
     * @const
     */
    _0: "0",

    /**
     * value: "1"
     * @const
     */
    _1: "1"
  };


  /**
   * Allowed values for the <code>division</code> property.
   * @enum {String}
   * @readonly
   */
  exports.DivisionEnum = {
    /**
     * value: "1"
     * @const
     */
    _1: "1",

    /**
     * value: "2"
     * @const
     */
    _2: "2"
  };

  return exports;

}));
