/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse2005ResultContent = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The InlineResponse2005ResultContent model module.
   * @module model/InlineResponse2005ResultContent
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse2005ResultContent</code>.
   * @alias module:model/InlineResponse2005ResultContent
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse2005ResultContent</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse2005ResultContent} obj Optional instance to populate.
   * @return {module:model/InlineResponse2005ResultContent} The populated <code>InlineResponse2005ResultContent</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('placement'))
        obj.placement = ApiClient.convertToType(data['placement'], 'String');
      if (data.hasOwnProperty('pointTotal'))
        obj.pointTotal = ApiClient.convertToType(data['pointTotal'], 'String');
      if (data.hasOwnProperty('oldRating'))
        obj.oldRating = ApiClient.convertToType(data['oldRating'], 'String');
      if (data.hasOwnProperty('newRating'))
        obj.newRating = ApiClient.convertToType(data['newRating'], 'String');
      if (data.hasOwnProperty('rated'))
        obj.rated = ApiClient.convertToType(data['rated'], 'String');
      if (data.hasOwnProperty('userId'))
        obj.userId = ApiClient.convertToType(data['userId'], 'String');
    }
    return obj;
  }

  /**
   * the placement
   * @member {String} placement
   */
  exports.prototype.placement = undefined;

  /**
   * the pointTotal
   * @member {String} pointTotal
   */
  exports.prototype.pointTotal = undefined;

  /**
   * the old rating
   * @member {String} oldRating
   */
  exports.prototype.oldRating = undefined;

  /**
   * the new rating
   * @member {String} newRating
   */
  exports.prototype.newRating = undefined;

  /**
   * whether this MM is rated
   * @member {module:model/InlineResponse2005ResultContent.RatedEnum} rated
   */
  exports.prototype.rated = undefined;

  /**
   * the user id
   * @member {String} userId
   */
  exports.prototype.userId = undefined;


  /**
   * Allowed values for the <code>rated</code> property.
   * @enum {String}
   * @readonly
   */
  exports.RatedEnum = {
    /**
     * value: "0"
     * @const
     */
    _0: "0",

    /**
     * value: "1"
     * @const
     */
    _1: "1"
  };

  return exports;

}));
