/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse2003ResultContent = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The InlineResponse2003ResultContent model module.
   * @module model/InlineResponse2003ResultContent
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse2003ResultContent</code>.
   * @alias module:model/InlineResponse2003ResultContent
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse2003ResultContent</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse2003ResultContent} obj Optional instance to populate.
   * @return {module:model/InlineResponse2003ResultContent} The populated <code>InlineResponse2003ResultContent</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('phaseType'))
        obj.phaseType = ApiClient.convertToType(data['phaseType'], 'String');
      if (data.hasOwnProperty('status'))
        obj.status = ApiClient.convertToType(data['status'], 'String');
      if (data.hasOwnProperty('fixedStarTime'))
        obj.fixedStarTime = ApiClient.convertToType(data['fixedStarTime'], 'Date');
      if (data.hasOwnProperty('scheduledStarTime'))
        obj.scheduledStarTime = ApiClient.convertToType(data['scheduledStarTime'], 'Date');
      if (data.hasOwnProperty('scheduledEndTime'))
        obj.scheduledEndTime = ApiClient.convertToType(data['scheduledEndTime'], 'Date');
      if (data.hasOwnProperty('actualStartTime'))
        obj.actualStartTime = ApiClient.convertToType(data['actualStartTime'], 'Date');
      if (data.hasOwnProperty('actualEndTime'))
        obj.actualEndTime = ApiClient.convertToType(data['actualEndTime'], 'Date');
      if (data.hasOwnProperty('duration'))
        obj.duration = ApiClient.convertToType(data['duration'], 'String');
    }
    return obj;
  }

  /**
   * the phase type
   * @member {module:model/InlineResponse2003ResultContent.PhaseTypeEnum} phaseType
   */
  exports.prototype.phaseType = undefined;

  /**
   * the status
   * @member {module:model/InlineResponse2003ResultContent.StatusEnum} status
   */
  exports.prototype.status = undefined;

  /**
   * fixed start time ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} fixedStarTime
   */
  exports.prototype.fixedStarTime = undefined;

  /**
   * the scheduled start time ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} scheduledStarTime
   */
  exports.prototype.scheduledStarTime = undefined;

  /**
   * the scheduled end time ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} scheduledEndTime
   */
  exports.prototype.scheduledEndTime = undefined;

  /**
   * the actual start time ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} actualStartTime
   */
  exports.prototype.actualStartTime = undefined;

  /**
   * the actual end time ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} actualEndTime
   */
  exports.prototype.actualEndTime = undefined;

  /**
   * the duration
   * @member {String} duration
   */
  exports.prototype.duration = undefined;


  /**
   * Allowed values for the <code>phaseType</code> property.
   * @enum {String}
   * @readonly
   */
  exports.PhaseTypeEnum = {
    /**
     * value: "Registration"
     * @const
     */
    registration: "Registration",

    /**
     * value: "Submission"
     * @const
     */
    submission: "Submission",

    /**
     * value: "Screening"
     * @const
     */
    screening: "Screening",

    /**
     * value: "Review"
     * @const
     */
    review: "Review",

    /**
     * value: "Appeals"
     * @const
     */
    appeals: "Appeals",

    /**
     * value: "Appeals Response"
     * @const
     */
    appealsResponse: "Appeals Response",

    /**
     * value: "Aggregation"
     * @const
     */
    aggregation: "Aggregation",

    /**
     * value: "Aggregation Review"
     * @const
     */
    aggregationReview: "Aggregation Review",

    /**
     * value: "Final Fix"
     * @const
     */
    finalFix: "Final Fix",

    /**
     * value: "Final Review"
     * @const
     */
    finalReview: "Final Review",

    /**
     * value: "Approval"
     * @const
     */
    approval: "Approval",

    /**
     * value: "Post-Mortem"
     * @const
     */
    postMortem: "Post-Mortem",

    /**
     * value: "Specification Submission"
     * @const
     */
    specificationSubmission: "Specification Submission",

    /**
     * value: "Specification Review"
     * @const
     */
    specificationReview: "Specification Review",

    /**
     * value: "Checkpoint Submission"
     * @const
     */
    checkpointSubmission: "Checkpoint Submission",

    /**
     * value: "Checkpoint Screening"
     * @const
     */
    checkpointScreening: "Checkpoint Screening",

    /**
     * value: "Checkpoint Review"
     * @const
     */
    checkpointReview: "Checkpoint Review",

    /**
     * value: "Iterative Review"
     * @const
     */
    iterativeReview: "Iterative Review"
  };


  /**
   * Allowed values for the <code>status</code> property.
   * @enum {String}
   * @readonly
   */
  exports.StatusEnum = {
    /**
     * value: "Scheduled"
     * @const
     */
    scheduled: "Scheduled",

    /**
     * value: "Open"
     * @const
     */
    open: "Open",

    /**
     * value: "Closed"
     * @const
     */
    closed: "Closed"
  };

  return exports;

}));
