/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse20012Results = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The InlineResponse20012Results model module.
   * @module model/InlineResponse20012Results
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse20012Results</code>.
   * @alias module:model/InlineResponse20012Results
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse20012Results</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse20012Results} obj Optional instance to populate.
   * @return {module:model/InlineResponse20012Results} The populated <code>InlineResponse20012Results</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('handle'))
        obj.handle = ApiClient.convertToType(data['handle'], 'String');
      if (data.hasOwnProperty('placement'))
        obj.placement = ApiClient.convertToType(data['placement'], 'Number');
      if (data.hasOwnProperty('submissionDate'))
        obj.submissionDate = ApiClient.convertToType(data['submissionDate'], 'Date');
      if (data.hasOwnProperty('submissionStatus'))
        obj.submissionStatus = ApiClient.convertToType(data['submissionStatus'], 'String');
      if (data.hasOwnProperty('registrationDate'))
        obj.registrationDate = ApiClient.convertToType(data['registrationDate'], 'Date');
      if (data.hasOwnProperty('points'))
        obj.points = ApiClient.convertToType(data['points'], 'Number');
      if (data.hasOwnProperty('finalScore'))
        obj.finalScore = ApiClient.convertToType(data['finalScore'], 'Number');
      if (data.hasOwnProperty('screeningScore'))
        obj.screeningScore = ApiClient.convertToType(data['screeningScore'], 'Number');
      if (data.hasOwnProperty('initialScore'))
        obj.initialScore = ApiClient.convertToType(data['initialScore'], 'Number');
      if (data.hasOwnProperty('clientSelection'))
        obj.clientSelection = ApiClient.convertToType(data['clientSelection'], 'Boolean');
      if (data.hasOwnProperty('submissionDownloadLink'))
        obj.submissionDownloadLink = ApiClient.convertToType(data['submissionDownloadLink'], 'String');
      if (data.hasOwnProperty('previewDownloadLink'))
        obj.previewDownloadLink = ApiClient.convertToType(data['previewDownloadLink'], 'String');
    }
    return obj;
  }

  /**
   * The handle of the submitter
   * @member {String} handle
   */
  exports.prototype.handle = undefined;

  /**
   * The placement of the submitter, like 1, 2. Could be n/a if not exists.
   * @member {Number} placement
   */
  exports.prototype.placement = undefined;

  /**
   * The submission date, like \"2017-11-01T20:21:00.000-04:00\"
   * @member {Date} submissionDate
   */
  exports.prototype.submissionDate = undefined;

  /**
   * The status of the submission
   * @member {module:model/InlineResponse20012Results.SubmissionStatusEnum} submissionStatus
   */
  exports.prototype.submissionStatus = undefined;

  /**
   * The date of registering this challenge of the submitter, like \"2017-11-01T20:21:00.000-04:00\"
   * @member {Date} registrationDate
   */
  exports.prototype.registrationDate = undefined;

  /**
   * The Digital Run points, could be null if not exists
   * @member {Number} points
   */
  exports.prototype.points = undefined;

  /**
   * Development challenge only, the score after appealing
   * @member {Number} finalScore
   */
  exports.prototype.finalScore = undefined;

  /**
   * Development challenge only, the score of the screening, could be 0 if not applicable.
   * @member {Number} screeningScore
   */
  exports.prototype.screeningScore = undefined;

  /**
   * Development challenge only, the score before appealing
   * @member {Number} initialScore
   */
  exports.prototype.initialScore = undefined;

  /**
   * Studio challenge only, to indicate if the submission is selected by the client
   * @member {Boolean} clientSelection
   */
  exports.prototype.clientSelection = undefined;

  /**
   * the download link (URL) of the submission
   * @member {String} submissionDownloadLink
   */
  exports.prototype.submissionDownloadLink = undefined;

  /**
   * Studio challenge only, the download link (URL) of the submission preview, only exists if \"show_submissions\" is enabled.
   * @member {String} previewDownloadLink
   */
  exports.prototype.previewDownloadLink = undefined;


  /**
   * Allowed values for the <code>submissionStatus</code> property.
   * @enum {String}
   * @readonly
   */
  exports.SubmissionStatusEnum = {
    /**
     * value: "Active"
     * @const
     */
    active: "Active",

    /**
     * value: "Completed Without Win"
     * @const
     */
    completedWithoutWin: "Completed Without Win",

    /**
     * value: "Failed Review"
     * @const
     */
    failedReview: "Failed Review",

    /**
     * value: "Failed Screening"
     * @const
     */
    failedScreening: "Failed Screening"
  };

  return exports;

}));
