/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/InlineResponse20012Results'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./InlineResponse20012Results'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse20012 = factory(root.ApChallengeMicroservice.ApiClient, root.ApChallengeMicroservice.InlineResponse20012Results);
  }
}(this, function(ApiClient, InlineResponse20012Results) {
  'use strict';

  /**
   * The InlineResponse20012 model module.
   * @module model/InlineResponse20012
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse20012</code>.
   * @alias module:model/InlineResponse20012
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse20012</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse20012} obj Optional instance to populate.
   * @return {module:model/InlineResponse20012} The populated <code>InlineResponse20012</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('challengeCommunity'))
        obj.challengeCommunity = ApiClient.convertToType(data['challengeCommunity'], 'String');
      if (data.hasOwnProperty('challengeType'))
        obj.challengeType = ApiClient.convertToType(data['challengeType'], 'String');
      if (data.hasOwnProperty('challengeName'))
        obj.challengeName = ApiClient.convertToType(data['challengeName'], 'String');
      if (data.hasOwnProperty('challengeId'))
        obj.challengeId = ApiClient.convertToType(data['challengeId'], 'Number');
      if (data.hasOwnProperty('postingDate'))
        obj.postingDate = ApiClient.convertToType(data['postingDate'], 'Date');
      if (data.hasOwnProperty('challengeEndDate'))
        obj.challengeEndDate = ApiClient.convertToType(data['challengeEndDate'], 'Date');
      if (data.hasOwnProperty('registrants'))
        obj.registrants = ApiClient.convertToType(data['registrants'], 'Number');
      if (data.hasOwnProperty('submissions'))
        obj.submissions = ApiClient.convertToType(data['submissions'], 'Number');
      if (data.hasOwnProperty('submissionsPassedScreening'))
        obj.submissionsPassedScreening = ApiClient.convertToType(data['submissionsPassedScreening'], 'Number');
      if (data.hasOwnProperty('drPoints'))
        obj.drPoints = ApiClient.convertToType(data['drPoints'], 'Number');
      if (data.hasOwnProperty('submissionsPercentage'))
        obj.submissionsPercentage = ApiClient.convertToType(data['submissionsPercentage'], 'Number');
      if (data.hasOwnProperty('averageInitialScore'))
        obj.averageInitialScore = ApiClient.convertToType(data['averageInitialScore'], 'Number');
      if (data.hasOwnProperty('averageFinalScore'))
        obj.averageFinalScore = ApiClient.convertToType(data['averageFinalScore'], 'Number');
      if (data.hasOwnProperty('results'))
        obj.results = ApiClient.convertToType(data['results'], [InlineResponse20012Results]);
      if (data.hasOwnProperty('finalFixes'))
        obj.finalFixes = ApiClient.convertToType(data['finalFixes'], ['String']);
    }
    return obj;
  }

  /**
   * The challenge community, could be \"design\" or \"develop\"
   * @member {module:model/InlineResponse20012.ChallengeCommunityEnum} challengeCommunity
   */
  exports.prototype.challengeCommunity = undefined;

  /**
   * The type of the challenge, like \"Code\", \"First2Finish\" etc.
   * @member {module:model/InlineResponse20012.ChallengeTypeEnum} challengeType
   */
  exports.prototype.challengeType = undefined;

  /**
   * The name of the challenge
   * @member {String} challengeName
   */
  exports.prototype.challengeName = undefined;

  /**
   * The ID of the challenge, an integer
   * @member {Number} challengeId
   */
  exports.prototype.challengeId = undefined;

  /**
   * The posting date of the challenge, like \"2017-11-01T20:21:00.000-04:00\"
   * @member {Date} postingDate
   */
  exports.prototype.postingDate = undefined;

  /**
   * The end date of the challenge, like \"2017-11-01T20:21:00.000-04:00\"
   * @member {Date} challengeEndDate
   */
  exports.prototype.challengeEndDate = undefined;

  /**
   * Number of registrations
   * @member {Number} registrants
   */
  exports.prototype.registrants = undefined;

  /**
   * Number of submissions
   * @member {Number} submissions
   */
  exports.prototype.submissions = undefined;

  /**
   * Number of valid submissions
   * @member {Number} submissionsPassedScreening
   */
  exports.prototype.submissionsPassedScreening = undefined;

  /**
   * Could be null if not exists
   * @member {Number} drPoints
   */
  exports.prototype.drPoints = undefined;

  /**
   * Development challenge only, equals to the number of submissions / the number of registrants
   * @member {Number} submissionsPercentage
   */
  exports.prototype.submissionsPercentage = undefined;

  /**
   * Development challenge only, the avarage score before appealing
   * @member {Number} averageInitialScore
   */
  exports.prototype.averageInitialScore = undefined;

  /**
   * Development challenge only, the avarage score after appealing
   * @member {Number} averageFinalScore
   */
  exports.prototype.averageFinalScore = undefined;

  /**
   * @member {Array.<module:model/InlineResponse20012Results>} results
   */
  exports.prototype.results = undefined;

  /**
   * An array of all final fix submissions. For Studio challenges, only exists if \"show_submissions\" is enabled.
   * @member {Array.<String>} finalFixes
   */
  exports.prototype.finalFixes = undefined;


  /**
   * Allowed values for the <code>challengeCommunity</code> property.
   * @enum {String}
   * @readonly
   */
  exports.ChallengeCommunityEnum = {
    /**
     * value: "design"
     * @const
     */
    design: "design",

    /**
     * value: "develop"
     * @const
     */
    develop: "develop"
  };


  /**
   * Allowed values for the <code>challengeType</code> property.
   * @enum {String}
   * @readonly
   */
  exports.ChallengeTypeEnum = {
    /**
     * value: "Component Design"
     * @const
     */
    componentDesign: "Component Design",

    /**
     * value: "Component Development"
     * @const
     */
    componentDevelopment: "Component Development",

    /**
     * value: "Component Testing"
     * @const
     */
    componentTesting: "Component Testing",

    /**
     * value: "Application Specification"
     * @const
     */
    applicationSpecification: "Application Specification",

    /**
     * value: "Application Architecture"
     * @const
     */
    applicationArchitecture: "Application Architecture",

    /**
     * value: "Bug Hunt"
     * @const
     */
    bugHunt: "Bug Hunt",

    /**
     * value: "Test Scenarios"
     * @const
     */
    testScenarios: "Test Scenarios",

    /**
     * value: "Test Suites"
     * @const
     */
    testSuites: "Test Suites",

    /**
     * value: "Application Assembly"
     * @const
     */
    applicationAssembly: "Application Assembly",

    /**
     * value: "Application Conceptualization"
     * @const
     */
    applicationConceptualization: "Application Conceptualization",

    /**
     * value: "UI Prototype"
     * @const
     */
    uIPrototype: "UI Prototype",

    /**
     * value: "RIA Build"
     * @const
     */
    rIABuild: "RIA Build",

    /**
     * value: "RIA Component"
     * @const
     */
    rIAComponent: "RIA Component",

    /**
     * value: "Copilot Posting"
     * @const
     */
    copilotPosting: "Copilot Posting",

    /**
     * value: "Content Creation"
     * @const
     */
    contentCreation: "Content Creation",

    /**
     * value: "Reporting"
     * @const
     */
    reporting: "Reporting",

    /**
     * value: "First2Finish"
     * @const
     */
    first2Finish: "First2Finish",

    /**
     * value: "Code"
     * @const
     */
    code: "Code"
  };

  return exports;

}));
