/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.InlineResponse20011ResultContentSubmissions = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The InlineResponse20011ResultContentSubmissions model module.
   * @module model/InlineResponse20011ResultContentSubmissions
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>InlineResponse20011ResultContentSubmissions</code>.
   * @alias module:model/InlineResponse20011ResultContentSubmissions
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>InlineResponse20011ResultContentSubmissions</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/InlineResponse20011ResultContentSubmissions} obj Optional instance to populate.
   * @return {module:model/InlineResponse20011ResultContentSubmissions} The populated <code>InlineResponse20011ResultContentSubmissions</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('placement'))
        obj.placement = ApiClient.convertToType(data['placement'], 'Number');
      if (data.hasOwnProperty('screeningScore'))
        obj.screeningScore = ApiClient.convertToType(data['screeningScore'], 'Number');
      if (data.hasOwnProperty('initialScore'))
        obj.initialScore = ApiClient.convertToType(data['initialScore'], 'Number');
      if (data.hasOwnProperty('finalScore'))
        obj.finalScore = ApiClient.convertToType(data['finalScore'], 'Number');
      if (data.hasOwnProperty('points'))
        obj.points = ApiClient.convertToType(data['points'], 'Number');
      if (data.hasOwnProperty('submissionStatus'))
        obj.submissionStatus = ApiClient.convertToType(data['submissionStatus'], 'String');
      if (data.hasOwnProperty('submissionId'))
        obj.submissionId = ApiClient.convertToType(data['submissionId'], 'Number');
      if (data.hasOwnProperty('submissionTime'))
        obj.submissionTime = ApiClient.convertToType(data['submissionTime'], 'Date');
    }
    return obj;
  }

  /**
   * @member {Number} placement
   */
  exports.prototype.placement = undefined;

  /**
   * @member {Number} screeningScore
   */
  exports.prototype.screeningScore = undefined;

  /**
   * @member {Number} initialScore
   */
  exports.prototype.initialScore = undefined;

  /**
   * @member {Number} finalScore
   */
  exports.prototype.finalScore = undefined;

  /**
   * @member {Number} points
   */
  exports.prototype.points = undefined;

  /**
   * @member {String} submissionStatus
   */
  exports.prototype.submissionStatus = undefined;

  /**
   * @member {Number} submissionId
   */
  exports.prototype.submissionId = undefined;

  /**
   * @member {Date} submissionTime
   */
  exports.prototype.submissionTime = undefined;

  return exports;

}));
