/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.GetResourceResult = factory(root.ApChallengeMicroservice.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The GetResourceResult model module.
   * @module model/GetResourceResult
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>GetResourceResult</code>.
   * @alias module:model/GetResourceResult
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>GetResourceResult</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/GetResourceResult} obj Optional instance to populate.
   * @return {module:model/GetResourceResult} The populated <code>GetResourceResult</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('id'))
        obj.id = ApiClient.convertToType(data['id'], 'Number');
      if (data.hasOwnProperty('projectId'))
        obj.projectId = ApiClient.convertToType(data['projectId'], 'Number');
      if (data.hasOwnProperty('name'))
        obj.name = ApiClient.convertToType(data['name'], 'String');
      if (data.hasOwnProperty('role'))
        obj.role = ApiClient.convertToType(data['role'], 'String');
      if (data.hasOwnProperty('phaseId'))
        obj.phaseId = ApiClient.convertToType(data['phaseId'], 'Number');
      if (data.hasOwnProperty('submissions'))
        obj.submissions = ApiClient.convertToType(data['submissions'], ['Number']);
      if (data.hasOwnProperty('properties'))
        obj.properties = ApiClient.convertToType(data['properties'], Object);
      if (data.hasOwnProperty('createdAt'))
        obj.createdAt = ApiClient.convertToType(data['createdAt'], 'Date');
      if (data.hasOwnProperty('updatedAt'))
        obj.updatedAt = ApiClient.convertToType(data['updatedAt'], 'Date');
      if (data.hasOwnProperty('createdBy'))
        obj.createdBy = ApiClient.convertToType(data['createdBy'], 'String');
      if (data.hasOwnProperty('updatedBy'))
        obj.updatedBy = ApiClient.convertToType(data['updatedBy'], 'String');
    }
    return obj;
  }

  /**
   * @member {Number} id
   */
  exports.prototype.id = undefined;

  /**
   * @member {Number} projectId
   */
  exports.prototype.projectId = undefined;

  /**
   * @member {String} name
   */
  exports.prototype.name = undefined;

  /**
   * @member {String} role
   */
  exports.prototype.role = undefined;

  /**
   * @member {Number} phaseId
   */
  exports.prototype.phaseId = undefined;

  /**
   * @member {Array.<Number>} submissions
   */
  exports.prototype.submissions = undefined;

  /**
   * @member {Object} properties
   */
  exports.prototype.properties = undefined;

  /**
   * ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} createdAt
   */
  exports.prototype.createdAt = undefined;

  /**
   * ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} updatedAt
   */
  exports.prototype.updatedAt = undefined;

  /**
   * @member {String} createdBy
   */
  exports.prototype.createdBy = undefined;

  /**
   * @member {String} updatedBy
   */
  exports.prototype.updatedBy = undefined;

  return exports;

}));
