/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ResponseMetadataFields'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ResponseMetadataFields'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.ChallengeResponseMetadata = factory(root.ApChallengeMicroservice.ApiClient, root.ApChallengeMicroservice.ResponseMetadataFields);
  }
}(this, function(ApiClient, ResponseMetadataFields) {
  'use strict';

  /**
   * The ChallengeResponseMetadata model module.
   * @module model/ChallengeResponseMetadata
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>ChallengeResponseMetadata</code>.
   * @alias module:model/ChallengeResponseMetadata
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>ChallengeResponseMetadata</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ChallengeResponseMetadata} obj Optional instance to populate.
   * @return {module:model/ChallengeResponseMetadata} The populated <code>ChallengeResponseMetadata</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('totalCount'))
        obj.totalCount = ApiClient.convertToType(data['totalCount'], 'Number');
      if (data.hasOwnProperty('allChallengesCount'))
        obj.allChallengesCount = ApiClient.convertToType(data['allChallengesCount'], 'Number');
      if (data.hasOwnProperty('myChallengesCount'))
        obj.myChallengesCount = ApiClient.convertToType(data['myChallengesCount'], 'Number');
      if (data.hasOwnProperty('openChallengesCount'))
        obj.openChallengesCount = ApiClient.convertToType(data['openChallengesCount'], 'Number');
      if (data.hasOwnProperty('ongoingChallengesCount'))
        obj.ongoingChallengesCount = ApiClient.convertToType(data['ongoingChallengesCount'], 'Number');
      if (data.hasOwnProperty('fields'))
        obj.fields = ResponseMetadataFields.constructFromObject(data['fields']);
    }
    return obj;
  }

  /**
   * Total count of the objects
   * @member {Number} totalCount
   */
  exports.prototype.totalCount = undefined;

  /**
   * all active challenges.
   * @member {Number} allChallengesCount
   */
  exports.prototype.allChallengesCount = undefined;

  /**
   * all active challenges of current user.
   * @member {Number} myChallengesCount
   */
  exports.prototype.myChallengesCount = undefined;

  /**
   * all active challenges that open for registration.
   * @member {Number} openChallengesCount
   */
  exports.prototype.openChallengesCount = undefined;

  /**
   * all active challenges that registration was closed.
   * @member {Number} ongoingChallengesCount
   */
  exports.prototype.ongoingChallengesCount = undefined;

  /**
   * @member {module:model/ResponseMetadataFields} fields
   */
  exports.prototype.fields = undefined;

  return exports;

}));
