/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/ChallengeFailedRegisterUsers', 'model/ChallengeTechnologies'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ChallengeFailedRegisterUsers'), require('./ChallengeTechnologies'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.Challenge = factory(root.ApChallengeMicroservice.ApiClient, root.ApChallengeMicroservice.ChallengeFailedRegisterUsers, root.ApChallengeMicroservice.ChallengeTechnologies);
  }
}(this, function(ApiClient, ChallengeFailedRegisterUsers, ChallengeTechnologies) {
  'use strict';

  /**
   * The Challenge model module.
   * @module model/Challenge
   * @version 1.0.5
   */

  /**
   * Constructs a new <code>Challenge</code>.
   * @alias module:model/Challenge
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>Challenge</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/Challenge} obj Optional instance to populate.
   * @return {module:model/Challenge} The populated <code>Challenge</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('id'))
        obj.id = ApiClient.convertToType(data['id'], 'Number');
      if (data.hasOwnProperty('confidentialityType'))
        obj.confidentialityType = ApiClient.convertToType(data['confidentialityType'], 'String');
      if (data.hasOwnProperty('technologies'))
        obj.technologies = ApiClient.convertToType(data['technologies'], [ChallengeTechnologies]);
      if (data.hasOwnProperty('subTrack'))
        obj.subTrack = ApiClient.convertToType(data['subTrack'], 'String');
      if (data.hasOwnProperty('name'))
        obj.name = ApiClient.convertToType(data['name'], 'String');
      if (data.hasOwnProperty('reviewType'))
        obj.reviewType = ApiClient.convertToType(data['reviewType'], 'String');
      if (data.hasOwnProperty('billingAccountId'))
        obj.billingAccountId = ApiClient.convertToType(data['billingAccountId'], 'Number');
      if (data.hasOwnProperty('milestoneId'))
        obj.milestoneId = ApiClient.convertToType(data['milestoneId'], 'Number');
      if (data.hasOwnProperty('detailedRequirements'))
        obj.detailedRequirements = ApiClient.convertToType(data['detailedRequirements'], 'String');
      if (data.hasOwnProperty('submissionGuidelines'))
        obj.submissionGuidelines = ApiClient.convertToType(data['submissionGuidelines'], 'String');
      if (data.hasOwnProperty('registrationStartsAt'))
        obj.registrationStartsAt = ApiClient.convertToType(data['registrationStartsAt'], 'Date');
      if (data.hasOwnProperty('registrationEndsAt'))
        obj.registrationEndsAt = ApiClient.convertToType(data['registrationEndsAt'], 'Date');
      if (data.hasOwnProperty('checkpointSubmissionStartsAt'))
        obj.checkpointSubmissionStartsAt = ApiClient.convertToType(data['checkpointSubmissionStartsAt'], 'Date');
      if (data.hasOwnProperty('checkpointSubmissionEndsAt'))
        obj.checkpointSubmissionEndsAt = ApiClient.convertToType(data['checkpointSubmissionEndsAt'], 'Date');
      if (data.hasOwnProperty('submissionEndsAt'))
        obj.submissionEndsAt = ApiClient.convertToType(data['submissionEndsAt'], 'Date');
      if (data.hasOwnProperty('round1Info'))
        obj.round1Info = ApiClient.convertToType(data['round1Info'], 'String');
      if (data.hasOwnProperty('round2Info'))
        obj.round2Info = ApiClient.convertToType(data['round2Info'], 'String');
      if (data.hasOwnProperty('platforms'))
        obj.platforms = ApiClient.convertToType(data['platforms'], [ChallengeTechnologies]);
      if (data.hasOwnProperty('numberOfCheckpointPrizes'))
        obj.numberOfCheckpointPrizes = ApiClient.convertToType(data['numberOfCheckpointPrizes'], 'Number');
      if (data.hasOwnProperty('checkpointPrize'))
        obj.checkpointPrize = ApiClient.convertToType(data['checkpointPrize'], 'Number');
      if (data.hasOwnProperty('finalDeliverableTypes'))
        obj.finalDeliverableTypes = ApiClient.convertToType(data['finalDeliverableTypes'], [ChallengeTechnologies]);
      if (data.hasOwnProperty('prizes'))
        obj.prizes = ApiClient.convertToType(data['prizes'], ['Number']);
      if (data.hasOwnProperty('projectId'))
        obj.projectId = ApiClient.convertToType(data['projectId'], 'Number');
      if (data.hasOwnProperty('submissionVisibility'))
        obj.submissionVisibility = ApiClient.convertToType(data['submissionVisibility'], 'Boolean');
      if (data.hasOwnProperty('maxNumOfSubmissions'))
        obj.maxNumOfSubmissions = ApiClient.convertToType(data['maxNumOfSubmissions'], 'Number');
      if (data.hasOwnProperty('task'))
        obj.task = ApiClient.convertToType(data['task'], 'Boolean');
      if (data.hasOwnProperty('assignees'))
        obj.assignees = ApiClient.convertToType(data['assignees'], ['String']);
      if (data.hasOwnProperty('copilotId'))
        obj.copilotId = ApiClient.convertToType(data['copilotId'], 'Number');
      if (data.hasOwnProperty('copilotFee'))
        obj.copilotFee = ApiClient.convertToType(data['copilotFee'], 'Number');
      if (data.hasOwnProperty('failedRegisterUsers'))
        obj.failedRegisterUsers = ApiClient.convertToType(data['failedRegisterUsers'], [ChallengeFailedRegisterUsers]);
      if (data.hasOwnProperty('environment'))
        obj.environment = ApiClient.convertToType(data['environment'], 'String');
      if (data.hasOwnProperty('codeRepo'))
        obj.codeRepo = ApiClient.convertToType(data['codeRepo'], 'String');
      if (data.hasOwnProperty('fixedFee'))
        obj.fixedFee = ApiClient.convertToType(data['fixedFee'], 'Number');
      if (data.hasOwnProperty('percentageFee'))
        obj.percentageFee = ApiClient.convertToType(data['percentageFee'], 'Number');
    }
    return obj;
  }

  /**
   * Challenge identifier.  This will be automatically created.
   * @member {Number} id
   */
  exports.prototype.id = undefined;

  /**
   * Confidentiality type. This will set terms on the challenge. Current options are public or standard_cca (NDA).
   * @member {String} confidentialityType
   */
  exports.prototype.confidentialityType = undefined;

  /**
   * Technology ID-Name-pairs. See https://api.topcoder.com/v2/data/technologies for full list.
   * @member {Array.<module:model/ChallengeTechnologies>} technologies
   */
  exports.prototype.technologies = undefined;

  /**
   * the challenge type
   * @member {module:model/Challenge.SubTrackEnum} subTrack
   */
  exports.prototype.subTrack = undefined;

  /**
   * The challenge name.
   * @member {String} name
   */
  exports.prototype.name = undefined;

  /**
   * The review type of the challenge.  Setting to COMMUNITY will setup a standard community review with the review board.  INTERNAL will need to be manually assigned.
   * @member {module:model/Challenge.ReviewTypeEnum} reviewType
   */
  exports.prototype.reviewType = undefined;

  /**
   * Billing account identifier. Optional.
   * @member {Number} billingAccountId
   */
  exports.prototype.billingAccountId = undefined;

  /**
   * Milestone identifier. Optional.
   * @member {Number} milestoneId
   */
  exports.prototype.milestoneId = undefined;

  /**
   * The detail requirements for the challenge
   * @member {String} detailedRequirements
   */
  exports.prototype.detailedRequirements = undefined;

  /**
   * The submission guideline
   * @member {String} submissionGuidelines
   */
  exports.prototype.submissionGuidelines = undefined;

  /**
   * ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} registrationStartsAt
   */
  exports.prototype.registrationStartsAt = undefined;

  /**
   * ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} registrationEndsAt
   */
  exports.prototype.registrationEndsAt = undefined;

  /**
   * The start date for checkpoint.  Set this to the same as registrationStartsAt in most cases. ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} checkpointSubmissionStartsAt
   */
  exports.prototype.checkpointSubmissionStartsAt = undefined;

  /**
   * The end of the checkpoint submission phase. ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} checkpointSubmissionEndsAt
   */
  exports.prototype.checkpointSubmissionEndsAt = undefined;

  /**
   * The end of the submission phase. ISO-8601 formatted date times (YYYY-MM-DDTHH:mm:ss.sssZ)
   * @member {Date} submissionEndsAt
   */
  exports.prototype.submissionEndsAt = undefined;

  /**
   * The info for round one.  Describe what you want submitters to deliver for their checkpoint submissions.
   * @member {String} round1Info
   */
  exports.prototype.round1Info = undefined;

  /**
   * The info for round two. Describe what you want submitters to deliver for their final submissions.
   * @member {String} round2Info
   */
  exports.prototype.round2Info = undefined;

  /**
   * Platform ID-Name-pairs.  See https://api.topcoder.com/v2/data/platforms for full list.
   * @member {Array.<module:model/ChallengeTechnologies>} platforms
   */
  exports.prototype.platforms = undefined;

  /**
   * The number of checkpoint prizes that can be awarded.
   * @member {Number} numberOfCheckpointPrizes
   */
  exports.prototype.numberOfCheckpointPrizes = undefined;

  /**
   * The checkpoint prize. This amount is the prize for EACH checkpoint winner.
   * @member {Number} checkpointPrize
   */
  exports.prototype.checkpointPrize = undefined;

  /**
   * Final deliverable type ID-Name-pairs.  Applies to design challenges.
   * @member {Array.<module:model/ChallengeTechnologies>} finalDeliverableTypes
   */
  exports.prototype.finalDeliverableTypes = undefined;

  /**
   * The prize list. Please follow standard pricing guidelines for the challenge type.
   * @member {Array.<Number>} prizes
   */
  exports.prototype.prizes = undefined;

  /**
   * Direct project identifier.  The challenge will be placed in this Direct project.
   * @member {Number} projectId
   */
  exports.prototype.projectId = undefined;

  /**
   * Will submissions be publically visible when the challenge ends?
   * @member {Boolean} submissionVisibility
   */
  exports.prototype.submissionVisibility = undefined;

  /**
   * How many submissions can each submitter submit?
   * @member {Number} maxNumOfSubmissions
   */
  exports.prototype.maxNumOfSubmissions = undefined;

  /**
   * Set the challenge to be a private task. Only allowed for First2Finish and Design First2Finish
   * @member {Boolean} task
   */
  exports.prototype.task = undefined;

  /**
   * Preregistered users for private task, only valid when task is true
   * @member {Array.<String>} assignees
   */
  exports.prototype.assignees = undefined;

  /**
   * The copilot id to set
   * @member {Number} copilotId
   */
  exports.prototype.copilotId = undefined;

  /**
   * The copilot fee for the copilot
   * @member {Number} copilotFee
   */
  exports.prototype.copilotFee = undefined;

  /**
   * Users that failed preregistering, including the reason. This is used in the response only.
   * @member {Array.<module:model/ChallengeFailedRegisterUsers>} failedRegisterUsers
   */
  exports.prototype.failedRegisterUsers = undefined;

  /**
   * @member {String} environment
   */
  exports.prototype.environment = undefined;

  /**
   * @member {String} codeRepo
   */
  exports.prototype.codeRepo = undefined;

  /**
   * The fixed fee for challenge
   * @member {Number} fixedFee
   */
  exports.prototype.fixedFee = undefined;

  /**
   * The percentage fee for challenge
   * @member {Number} percentageFee
   */
  exports.prototype.percentageFee = undefined;


  /**
   * Allowed values for the <code>subTrack</code> property.
   * @enum {String}
   * @readonly
   */
  exports.SubTrackEnum = {
    /**
     * value: "WEB_DESIGNS"
     * @const
     */
    WEB_DESIGNS: "WEB_DESIGNS",

    /**
     * value: "DESIGN_FIRST_2_FINISH"
     * @const
     */
    dESIGNFIRST2FINISH: "DESIGN_FIRST_2_FINISH",

    /**
     * value: "APPLICATION_FRONT_END_DESIGN"
     * @const
     */
    APPLICATION_FRONT_END_DESIGN: "APPLICATION_FRONT_END_DESIGN",

    /**
     * value: "WIDGET_OR_MOBILE_SCREEN_DESIGN"
     * @const
     */
    WIDGET_OR_MOBILE_SCREEN_DESIGN: "WIDGET_OR_MOBILE_SCREEN_DESIGN",

    /**
     * value: "PRINT_OR_PRESENTATION"
     * @const
     */
    PRINT_OR_PRESENTATION: "PRINT_OR_PRESENTATION",

    /**
     * value: "WIREFRAMES"
     * @const
     */
    WIREFRAMES: "WIREFRAMES",

    /**
     * value: "IDEA_GENERATION"
     * @const
     */
    IDEA_GENERATION: "IDEA_GENERATION",

    /**
     * value: "ARCHITECTURE"
     * @const
     */
    ARCHITECTURE: "ARCHITECTURE",

    /**
     * value: "UI_PROTOTYPE_COMPETITION"
     * @const
     */
    UI_PROTOTYPE_COMPETITION: "UI_PROTOTYPE_COMPETITION",

    /**
     * value: "ASSEMBLY_COMPETITION"
     * @const
     */
    ASSEMBLY_COMPETITION: "ASSEMBLY_COMPETITION",

    /**
     * value: "TEST_SUITES"
     * @const
     */
    TEST_SUITES: "TEST_SUITES",

    /**
     * value: "BUG_HUNT"
     * @const
     */
    BUG_HUNT: "BUG_HUNT",

    /**
     * value: "FIRST_2_FINISH"
     * @const
     */
    fIRST2FINISH: "FIRST_2_FINISH",

    /**
     * value: "CODE"
     * @const
     */
    CODE: "CODE",

    /**
     * value: "MARATHON_MATCH"
     * @const
     */
    MARATHON_MATCH: "MARATHON_MATCH"
  };


  /**
   * Allowed values for the <code>reviewType</code> property.
   * @enum {String}
   * @readonly
   */
  exports.ReviewTypeEnum = {
    /**
     * value: "COMMUNITY"
     * @const
     */
    COMMUNITY: "COMMUNITY",

    /**
     * value: "INTERNAL"
     * @const
     */
    INTERNAL: "INTERNAL"
  };

  return exports;

}));
