/*
 * ap-challenge-microservice
 * Services that provide access and interaction with all sorts of challenges, including design, dev, single round matches, and marathon matches. 
 *
 * OpenAPI spec version: 1.0.5
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9-SNAPSHOT
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/AddResourceBody', 'model/ChallengeResponse', 'model/ChallengeTypeResponse', 'model/ErrorModel', 'model/ErrorResponse', 'model/GetResourceResponse', 'model/InlineResponse200', 'model/InlineResponse2001', 'model/InlineResponse20010', 'model/InlineResponse20011', 'model/InlineResponse20012', 'model/InlineResponse20013', 'model/InlineResponse20014', 'model/InlineResponse20015', 'model/InlineResponse2002', 'model/InlineResponse2003', 'model/InlineResponse2004', 'model/InlineResponse2005', 'model/InlineResponse2006', 'model/InlineResponse2007', 'model/InlineResponse2008', 'model/InlineResponse2009', 'model/ManageResourceResponse', 'model/NewChallengeBodyParam', 'model/NewPlatformBodyParam', 'model/NewTechnologyBodyParam', 'model/NormalResponse', 'model/NullResponse', 'model/PlatformArrayResponse', 'model/PlatformResponse', 'model/RemoveResourceBody', 'model/TechnologyArrayResponse', 'model/TechnologyResponse', 'model/UpdateChallengeBodyParam', 'model/ValidationErrorModel'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/AddResourceBody'), require('../model/ChallengeResponse'), require('../model/ChallengeTypeResponse'), require('../model/ErrorModel'), require('../model/ErrorResponse'), require('../model/GetResourceResponse'), require('../model/InlineResponse200'), require('../model/InlineResponse2001'), require('../model/InlineResponse20010'), require('../model/InlineResponse20011'), require('../model/InlineResponse20012'), require('../model/InlineResponse20013'), require('../model/InlineResponse20014'), require('../model/InlineResponse20015'), require('../model/InlineResponse2002'), require('../model/InlineResponse2003'), require('../model/InlineResponse2004'), require('../model/InlineResponse2005'), require('../model/InlineResponse2006'), require('../model/InlineResponse2007'), require('../model/InlineResponse2008'), require('../model/InlineResponse2009'), require('../model/ManageResourceResponse'), require('../model/NewChallengeBodyParam'), require('../model/NewPlatformBodyParam'), require('../model/NewTechnologyBodyParam'), require('../model/NormalResponse'), require('../model/NullResponse'), require('../model/PlatformArrayResponse'), require('../model/PlatformResponse'), require('../model/RemoveResourceBody'), require('../model/TechnologyArrayResponse'), require('../model/TechnologyResponse'), require('../model/UpdateChallengeBodyParam'), require('../model/ValidationErrorModel'));
  } else {
    // Browser globals (root is window)
    if (!root.ApChallengeMicroservice) {
      root.ApChallengeMicroservice = {};
    }
    root.ApChallengeMicroservice.DefaultApi = factory(root.ApChallengeMicroservice.ApiClient, root.ApChallengeMicroservice.AddResourceBody, root.ApChallengeMicroservice.ChallengeResponse, root.ApChallengeMicroservice.ChallengeTypeResponse, root.ApChallengeMicroservice.ErrorModel, root.ApChallengeMicroservice.ErrorResponse, root.ApChallengeMicroservice.GetResourceResponse, root.ApChallengeMicroservice.InlineResponse200, root.ApChallengeMicroservice.InlineResponse2001, root.ApChallengeMicroservice.InlineResponse20010, root.ApChallengeMicroservice.InlineResponse20011, root.ApChallengeMicroservice.InlineResponse20012, root.ApChallengeMicroservice.InlineResponse20013, root.ApChallengeMicroservice.InlineResponse20014, root.ApChallengeMicroservice.InlineResponse20015, root.ApChallengeMicroservice.InlineResponse2002, root.ApChallengeMicroservice.InlineResponse2003, root.ApChallengeMicroservice.InlineResponse2004, root.ApChallengeMicroservice.InlineResponse2005, root.ApChallengeMicroservice.InlineResponse2006, root.ApChallengeMicroservice.InlineResponse2007, root.ApChallengeMicroservice.InlineResponse2008, root.ApChallengeMicroservice.InlineResponse2009, root.ApChallengeMicroservice.ManageResourceResponse, root.ApChallengeMicroservice.NewChallengeBodyParam, root.ApChallengeMicroservice.NewPlatformBodyParam, root.ApChallengeMicroservice.NewTechnologyBodyParam, root.ApChallengeMicroservice.NormalResponse, root.ApChallengeMicroservice.NullResponse, root.ApChallengeMicroservice.PlatformArrayResponse, root.ApChallengeMicroservice.PlatformResponse, root.ApChallengeMicroservice.RemoveResourceBody, root.ApChallengeMicroservice.TechnologyArrayResponse, root.ApChallengeMicroservice.TechnologyResponse, root.ApChallengeMicroservice.UpdateChallengeBodyParam, root.ApChallengeMicroservice.ValidationErrorModel);
  }
}(this, function(ApiClient, AddResourceBody, ChallengeResponse, ChallengeTypeResponse, ErrorModel, ErrorResponse, GetResourceResponse, InlineResponse200, InlineResponse2001, InlineResponse20010, InlineResponse20011, InlineResponse20012, InlineResponse20013, InlineResponse20014, InlineResponse20015, InlineResponse2002, InlineResponse2003, InlineResponse2004, InlineResponse2005, InlineResponse2006, InlineResponse2007, InlineResponse2008, InlineResponse2009, ManageResourceResponse, NewChallengeBodyParam, NewPlatformBodyParam, NewTechnologyBodyParam, NormalResponse, NullResponse, PlatformArrayResponse, PlatformResponse, RemoveResourceBody, TechnologyArrayResponse, TechnologyResponse, UpdateChallengeBodyParam, ValidationErrorModel) {
  'use strict';

  /**
   * Default service.
   * @module api/DefaultApi
   * @version 1.0.5
   */

  /**
   * Constructs a new DefaultApi. 
   * @alias module:api/DefaultApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the activateChallenge operation.
     * @callback module:api/DefaultApi~activateChallengeCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ChallengeResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Activate a draft challenge
     * @param {String} id the id of the draft challenge
     * @param {module:api/DefaultApi~activateChallengeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ChallengeResponse}
     */
    this.activateChallenge = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling activateChallenge");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = ChallengeResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/activate', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the cancelPrivateContest operation.
     * @callback module:api/DefaultApi~cancelPrivateContestCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NullResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Cancel the private task
     * @param {Number} id the id of the challenge
     * @param {module:api/DefaultApi~cancelPrivateContestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NullResponse}
     */
    this.cancelPrivateContest = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling cancelPrivateContest");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = NullResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/cancel', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengeResultsGet operation.
     * @callback module:api/DefaultApi~challengeResultsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2002} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves results of dev and design challenges. These parameters parameters are optional, if none is provided, returns 10 first phases accessible by the user, ordered by createAt date desc, i.e. recent 10 phases.
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + userId - filter by challenges in which the user has a role + challengeId - id of the challenge for which to return the results. 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~challengeResultsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2002}
     */
    this.challengeResultsGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2002;

      return this.apiClient.callApi(
        '/challengeResults', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesGet operation.
     * @callback module:api/DefaultApi~challengesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse200} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve active/past results for dev/design/data science challenges.  This endpoint serves results based on filter variable list_type ( active/past) and filter variable type ( data_science / develop /design ). 
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + userId - Filter by user_id + track - valid values are DEVELOP, DESIGN, DATA_SCIENCE + subTrack - valid values are  DESIGN, DEVELOPMENT, SECURITY, PROCESS, TESTING_COMPETITION, SPECIFICATION, ARCHITECTURE, COMPONENT_PRODUCTION, BUG_HUNT, DEPLOYMENT, TEST_SUITES, ASSEMBLY_COMPETITION, UI_PROTOTYPE_COMPETITION, CONCEPTUALIZATION, RIA_BUILD_COMPETITION, RIA_COMPONENT_COMPETITION, TEST_SCENARIOS, SPEC_REVIEW, COPILOT_POSTING, CONTENT_CREATION, REPORTING, DEVELOP_MARATHON_MATCH, FIRST_2_FINISH, CODE, BANNERS_OR_ICONS, WEB_DESIGNS, WIREFRAMES, LOGO_DESIGN, PRINT_OR_PRESENTATION, WIDGET_OR_MOBILE_SCREEN_DESIGN, FRONT_END_FLASH, APPLICATION_FRONT_END_DESIGN, STUDIO_OTHER, IDEA_GENERATION, DESIGN_FIRST_2_FINISH, SRM, MARATHON_MATCH + name - Challenge Name + id - challenge id + platforms + technologies + reviewType + updatedAt - date string, format like yyyy-mm-dd + updatedBy + createdAt - date string, format like yyyy-mm-dd + createdBy + isPrivate + status + forumId + checkpointSubmissionEndDate - date string, format like yyyy-mm-dd + registrationEndDate - date string, format like yyyy-mm-dd + registrationStartDate - date string, format like yyyy-mm-dd + submissionEndDate - date string, format like yyyy-mm-dd + projectId - Filter by Direct project id + projectName - Filter by Direct project name, only available for admin + isTask - Filter by isTask field + groupIds - Filter by the group ids, it will only be used and when the API is called with authenticated user. + keywords - Filter by technologies or platforms The value should be ids separated by comma. 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~challengesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse200}
     */
    this.challengesGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse200;

      return this.apiClient.callApi(
        '/challenges', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesIdGet operation.
     * @callback module:api/DefaultApi~challengesIdGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse20011} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get challenge details.
     * @param {Number} id The challenge id to get the challenge details.
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.unified The unified flag indicating to get more fields such as registrants, submissions, checkpoints, phases, etc.
     * @param {module:api/DefaultApi~challengesIdGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse20011}
     */
    this.challengesIdGet = function(id, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling challengesIdGet");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
        'unified': opts['unified'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse20011;

      return this.apiClient.callApi(
        '/challenges/{id}', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesIdPut operation.
     * @callback module:api/DefaultApi~challengesIdPutCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ChallengeResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update the challenge
     * @param {Number} id The id of the challenge.
     * @param {module:model/UpdateChallengeBodyParam} body 
     * @param {module:api/DefaultApi~challengesIdPutCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ChallengeResponse}
     */
    this.challengesIdPut = function(id, body, callback) {
      var postBody = body;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling challengesIdPut");
      }

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling challengesIdPut");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ChallengeResponse;

      return this.apiClient.callApi(
        '/challenges/{id}', 'PUT',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesIdResourcesDelete operation.
     * @callback module:api/DefaultApi~challengesIdResourcesDeleteCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ManageResourceResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Remove Resource from a challenge
     * @param {Number} id The id of the challenge from which to remove the resource
     * @param {module:model/RemoveResourceBody} body 
     * @param {module:api/DefaultApi~challengesIdResourcesDeleteCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ManageResourceResponse}
     */
    this.challengesIdResourcesDelete = function(id, body, callback) {
      var postBody = body;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling challengesIdResourcesDelete");
      }

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling challengesIdResourcesDelete");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ManageResourceResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/resources', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesIdResourcesGet operation.
     * @callback module:api/DefaultApi~challengesIdResourcesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GetResourceResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all resources for a challenge.
     * @param {Number} id The id of the challenge.
     * @param {module:api/DefaultApi~challengesIdResourcesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GetResourceResponse}
     */
    this.challengesIdResourcesGet = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling challengesIdResourcesGet");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = GetResourceResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/resources', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesIdResourcesPost operation.
     * @callback module:api/DefaultApi~challengesIdResourcesPostCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ManageResourceResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Add Resource to a challenge.
     * @param {Number} id The id of the challenge to which to add the resource.
     * @param {module:model/AddResourceBody} body 
     * @param {module:api/DefaultApi~challengesIdResourcesPostCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ManageResourceResponse}
     */
    this.challengesIdResourcesPost = function(id, body, callback) {
      var postBody = body;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling challengesIdResourcesPost");
      }

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling challengesIdResourcesPost");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ManageResourceResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/resources', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesIdResultsGet operation.
     * @callback module:api/DefaultApi~challengesIdResultsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse20012} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get results of a challenge.
     * @param {Number} id The challenge id to get the challenge results.
     * @param {module:api/DefaultApi~challengesIdResultsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse20012}
     */
    this.challengesIdResultsGet = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling challengesIdResultsGet");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse20012;

      return this.apiClient.callApi(
        '/challenges/{id}/results', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the challengesMemberGet operation.
     * @callback module:api/DefaultApi~challengesMemberGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse20015} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve challenges of current user. User will be get from jwt token 
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + userId - Filter by user_id + track - valid values are DEVELOP, DESIGN, DATA_SCIENCE + subTrack - valid values are  DESIGN, DEVELOPMENT, SECURITY, PROCESS, TESTING_COMPETITION, SPECIFICATION, ARCHITECTURE, COMPONENT_PRODUCTION, BUG_HUNT, DEPLOYMENT, TEST_SUITES, ASSEMBLY_COMPETITION, UI_PROTOTYPE_COMPETITION, CONCEPTUALIZATION, RIA_BUILD_COMPETITION, RIA_COMPONENT_COMPETITION, TEST_SCENARIOS, SPEC_REVIEW, COPILOT_POSTING, CONTENT_CREATION, REPORTING, DEVELOP_MARATHON_MATCH, FIRST_2_FINISH, CODE, BANNERS_OR_ICONS, WEB_DESIGNS, WIREFRAMES, LOGO_DESIGN, PRINT_OR_PRESENTATION, WIDGET_OR_MOBILE_SCREEN_DESIGN, FRONT_END_FLASH, APPLICATION_FRONT_END_DESIGN, STUDIO_OTHER, IDEA_GENERATION, DESIGN_FIRST_2_FINISH, SRM, MARATHON_MATCH + name - Challenge Name + id - challenge id + platforms + technologies + reviewType + updatedAt - date string, format like yyyy-mm-dd + updatedBy + createdAt - date string, format like yyyy-mm-dd + createdBy + isPrivate + status + forumId + checkpointSubmissionEndDate - date string, format like yyyy-mm-dd + registrationEndDate - date string, format like yyyy-mm-dd + registrationStartDate - date string, format like yyyy-mm-dd + submissionEndDate - date string, format like yyyy-mm-dd + projectId - Filter by Direct project id + projectName - Filter by Direct project name, only available for admin + isTask - Filter by isTask field + groupIds - Filter by the group ids, it will only be used and when the API is called with authenticated user. + keywords - Filter by technologies or platforms The value should be ids separated by comma. 
     * @param {String} opts.orderBy sort the result by the provided order by clause
     * @param {module:api/DefaultApi~challengesMemberGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse20015}
     */
    this.challengesMemberGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'orderBy': opts['orderBy'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse20015;

      return this.apiClient.callApi(
        '/challenges/member', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the closePrivateContest operation.
     * @callback module:api/DefaultApi~closePrivateContestCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NullResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Close the private task
     * @param {Number} id the id of the challenge
     * @param {module:api/DefaultApi~closePrivateContestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NullResponse}
     */
    this.closePrivateContest = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling closePrivateContest");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = NullResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/close', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the directChallengesGet operation.
     * @callback module:api/DefaultApi~directChallengesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2001} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * get challenges
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec  + type - Filter by challenge status type, it must be active, past, or draft + creator - Only return challenges created by current user + directProjectId - Filter by direct project id + clientId - Filter by client id + billingId - Filter by billing id + startDateFrom - Left range of the challenge start date + startDateTo - Right range of the challenge start date + endDateFrom - Left range of the challenge end date + endDateTo - Right range of the challenge end date + challengeType - Filter by challenge type + challengeStatus - Filter by challenge status + challengeTechnologies - Filter by challenge technologies + challengePlatforms - Filter by challenge platforms + directProjectName - Filter by direct project name 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {String} opts.orderBy sort the result by the provided order by clause
     * @param {module:api/DefaultApi~directChallengesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2001}
     */
    this.directChallengesGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
        'orderBy': opts['orderBy'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2001;

      return this.apiClient.callApi(
        '/direct/challenges', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getChallengeLegacyInfo operation.
     * @callback module:api/DefaultApi~getChallengeLegacyInfoCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse20013} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get challenge legacy info for mmarathon match.
     * @param {Number} challengeId The challenge id to get the marathon match data.
     * @param {module:api/DefaultApi~getChallengeLegacyInfoCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse20013}
     */
    this.getChallengeLegacyInfo = function(challengeId, callback) {
      var postBody = null;

      // verify the required parameter 'challengeId' is set
      if (challengeId === undefined || challengeId === null) {
        throw new Error("Missing the required parameter 'challengeId' when calling getChallengeLegacyInfo");
      }


      var pathParams = {
        'challengeId': challengeId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse20013;

      return this.apiClient.callApi(
        '/challenges/legacyinfo/{challengeId}', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getChallengeMetadata operation.
     * @callback module:api/DefaultApi~getChallengeMetadataCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse20014} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get the challenge metadata.
     * @param {module:api/DefaultApi~getChallengeMetadataCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse20014}
     */
    this.getChallengeMetadata = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse20014;

      return this.apiClient.callApi(
        '/challenges/metadata', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getChallengeTypes operation.
     * @callback module:api/DefaultApi~getChallengeTypesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ChallengeTypeResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get challenge types
     * @param {module:api/DefaultApi~getChallengeTypesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ChallengeTypeResponse}
     */
    this.getChallengeTypes = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = ChallengeTypeResponse;

      return this.apiClient.callApi(
        '/challenge-types', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the marathonMatcheResultsGet operation.
     * @callback module:api/DefaultApi~marathonMatcheResultsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2005} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves results for marathon matches. These parameters parameters are optional, if none is provided, returns 10 first phases accessible by the user, ordered by createAt date desc, i.e. recent 10 phases.
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + contestId - id of the marathon match + userId - filters by user id 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~marathonMatcheResultsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2005}
     */
    this.marathonMatcheResultsGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2005;

      return this.apiClient.callApi(
        '/marathonMatcheResults', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the marathonMatchesGet operation.
     * @callback module:api/DefaultApi~marathonMatchesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2004} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves marathon matches. These parameters parameters are optional, if none is provided, returns 10 first phases accessible by the user, ordered by createAt date desc, i.e. recent 10 phases.
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + listType - active or past + userId - filters by marathon matches in which the user has a role 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~marathonMatchesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2004}
     */
    this.marathonMatchesGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2004;

      return this.apiClient.callApi(
        '/marathonMatches', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the membersHandleChallengesGet operation.
     * @callback module:api/DefaultApi~membersHandleChallengesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2008} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve Challenges of a particular user handle.
     * @param {String} handle the handle of the user
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + id - Filter by challenge id, it supports a single id as in id=123 or an in filter: id=in(123,456) + isPrivate - Filter by private flag, boolean + technologies - Filter by a single technology + platforms - Filter by a single platform + userIds - Filter by a single userId + forumId - Filter by a forum id + reviewType - Filter by review type, values are Internal, peer + status - Active, Completed + subTrack - One of the allowed subTrack Values + track - One of the allowed Track values + hasUserSubmittedForReview - boolean value indicating if user has submitted for review + name - Challenge name + projectId - Filter by Direct project id + projectName - Filter by Direct project name, only available for admin + isTask - Filter type isTask field + groupIds - Filter by the group ids, it will only be used and when the API is called with authenticated user.  The value should be ids separated by comma. + keywords - Filter by technologies or platforms 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~membersHandleChallengesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2008}
     */
    this.membersHandleChallengesGet = function(handle, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'handle' is set
      if (handle === undefined || handle === null) {
        throw new Error("Missing the required parameter 'handle' when calling membersHandleChallengesGet");
      }


      var pathParams = {
        'handle': handle
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2008;

      return this.apiClient.callApi(
        '/members/{handle}/challenges', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the membersHandleMmsGet operation.
     * @callback module:api/DefaultApi~membersHandleMmsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse20010} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve MMs of a particular user handle.
     * @param {String} handle the handle of the user
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + id - Filter by srm id + userIds - Filter by a single userId + forumId - Filter by a forum id + status - Active, Completed + name - MM name + startDate - Start date of particular MM + endDate - End date of particular MM + isRatedForMM - Boolean, indicating is user is rated for this MM 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~membersHandleMmsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse20010}
     */
    this.membersHandleMmsGet = function(handle, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'handle' is set
      if (handle === undefined || handle === null) {
        throw new Error("Missing the required parameter 'handle' when calling membersHandleMmsGet");
      }


      var pathParams = {
        'handle': handle
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse20010;

      return this.apiClient.callApi(
        '/members/{handle}/mms', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the membersHandleSrmsGet operation.
     * @callback module:api/DefaultApi~membersHandleSrmsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2009} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve SRMs of a particular user handle.
     * @param {String} handle the handle of the user
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + id - Filter by srm id + userIds - Filter by a single userId + forumId - Filter by a forum id + status - Active, Completed + name - SRM name + startDate - Start date of particular SRM + endDate - End date of particular SRM + isRatedForSRM - Boolean, indicating is user is rated for this SRM 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~membersHandleSrmsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2009}
     */
    this.membersHandleSrmsGet = function(handle, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'handle' is set
      if (handle === undefined || handle === null) {
        throw new Error("Missing the required parameter 'handle' when calling membersHandleSrmsGet");
      }


      var pathParams = {
        'handle': handle
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2009;

      return this.apiClient.callApi(
        '/members/{handle}/srms', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the phasesGet operation.
     * @callback module:api/DefaultApi~phasesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2003} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves phases for dev and design challenges. These parameters parameters are optional, if none is provided, returns 10 first phases accessible by the user, ordered by createAt date desc, i.e. recent 10 phases.
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + challengeId - The id of the challenge for which to fetch phases. Supports comma separated list of values to fetch phases for multiple challenges. 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~phasesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2003}
     */
    this.phasesGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2003;

      return this.apiClient.callApi(
        '/phases', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the platformsGet operation.
     * @callback module:api/DefaultApi~platformsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PlatformArrayResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * return all platforms
     * @param {module:api/DefaultApi~platformsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PlatformArrayResponse}
     */
    this.platformsGet = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = PlatformArrayResponse;

      return this.apiClient.callApi(
        '/platforms', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the platformsIdDelete operation.
     * @callback module:api/DefaultApi~platformsIdDeleteCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NormalResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * delete a single platform. currently this endpoint is just a mock.
     * @param {Number} id 
     * @param {module:api/DefaultApi~platformsIdDeleteCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NormalResponse}
     */
    this.platformsIdDelete = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling platformsIdDelete");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = NormalResponse;

      return this.apiClient.callApi(
        '/platforms/{id}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the platformsIdPatch operation.
     * @callback module:api/DefaultApi~platformsIdPatchCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PlatformResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * update a single platform
     * @param {Number} id 
     * @param {module:model/NewPlatformBodyParam} body 
     * @param {module:api/DefaultApi~platformsIdPatchCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PlatformResponse}
     */
    this.platformsIdPatch = function(id, body, callback) {
      var postBody = body;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling platformsIdPatch");
      }

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling platformsIdPatch");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = PlatformResponse;

      return this.apiClient.callApi(
        '/platforms/{id}', 'PATCH',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the platformsPost operation.
     * @callback module:api/DefaultApi~platformsPostCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PlatformResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * create a new platform
     * @param {module:model/NewPlatformBodyParam} body 
     * @param {module:api/DefaultApi~platformsPostCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PlatformResponse}
     */
    this.platformsPost = function(body, callback) {
      var postBody = body;

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling platformsPost");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = PlatformResponse;

      return this.apiClient.callApi(
        '/platforms', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the registerChallenge operation.
     * @callback module:api/DefaultApi~registerChallengeCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NormalResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Register for a challenge
     * @param {Number} id the id of the challenge
     * @param {module:api/DefaultApi~registerChallengeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NormalResponse}
     */
    this.registerChallenge = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling registerChallenge");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = NormalResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/register', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the saveDraftContest operation.
     * @callback module:api/DefaultApi~saveDraftContestCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ChallengeResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a draft challenge
     * @param {module:model/NewChallengeBodyParam} body 
     * @param {module:api/DefaultApi~saveDraftContestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ChallengeResponse}
     */
    this.saveDraftContest = function(body, callback) {
      var postBody = body;

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling saveDraftContest");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = ChallengeResponse;

      return this.apiClient.callApi(
        '/challenges', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the srmResultsGet operation.
     * @callback module:api/DefaultApi~srmResultsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2007} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves single round matche results. These parameters parameters are optional, if none is provided, returns 10 first phases accessible by the user, ordered by createAt date desc, i.e. recent 10 phases.
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + userId - filters by srms in which the user has a role + contestId - Id of the srm to return results 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~srmResultsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2007}
     */
    this.srmResultsGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2007;

      return this.apiClient.callApi(
        '/srmResults', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the srmsGet operation.
     * @callback module:api/DefaultApi~srmsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/InlineResponse2006} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves single round matches. These parameters parameters are optional, if none is provided, returns 10 first phases accessible by the user, ordered by createAt date desc, i.e. recent 10 phases.
     * @param {Object} opts Optional parameters
     * @param {String} opts.filter fieldName=fieldValue (enum[string],optional)  - parameter for filtering the fields according to v3 spec + listType - future, active, or past + userId - filters by srms in which the user has a role 
     * @param {Number} opts.offset number of items to skip. Defaults to 0
     * @param {Number} opts.limit max records to return. Defaults to 10
     * @param {module:api/DefaultApi~srmsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/InlineResponse2006}
     */
    this.srmsGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'filter': opts['filter'],
        'offset': opts['offset'],
        'limit': opts['limit'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = InlineResponse2006;

      return this.apiClient.callApi(
        '/srms', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the technologiesGet operation.
     * @callback module:api/DefaultApi~technologiesGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TechnologyArrayResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * return all technologies
     * @param {module:api/DefaultApi~technologiesGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TechnologyArrayResponse}
     */
    this.technologiesGet = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = TechnologyArrayResponse;

      return this.apiClient.callApi(
        '/technologies', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the technologiesIdDelete operation.
     * @callback module:api/DefaultApi~technologiesIdDeleteCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NormalResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * delete a single technology
     * @param {Number} id 
     * @param {module:api/DefaultApi~technologiesIdDeleteCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NormalResponse}
     */
    this.technologiesIdDelete = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling technologiesIdDelete");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = NormalResponse;

      return this.apiClient.callApi(
        '/technologies/{id}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the technologiesIdPatch operation.
     * @callback module:api/DefaultApi~technologiesIdPatchCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TechnologyResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * update a single technology
     * @param {Number} id 
     * @param {module:model/NewTechnologyBodyParam} body 
     * @param {module:api/DefaultApi~technologiesIdPatchCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TechnologyResponse}
     */
    this.technologiesIdPatch = function(id, body, callback) {
      var postBody = body;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling technologiesIdPatch");
      }

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling technologiesIdPatch");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = TechnologyResponse;

      return this.apiClient.callApi(
        '/technologies/{id}', 'PATCH',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the technologiesPost operation.
     * @callback module:api/DefaultApi~technologiesPostCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TechnologyResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * create a new technology
     * @param {module:model/NewTechnologyBodyParam} body 
     * @param {module:api/DefaultApi~technologiesPostCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TechnologyResponse}
     */
    this.technologiesPost = function(body, callback) {
      var postBody = body;

      // verify the required parameter 'body' is set
      if (body === undefined || body === null) {
        throw new Error("Missing the required parameter 'body' when calling technologiesPost");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = TechnologyResponse;

      return this.apiClient.callApi(
        '/technologies', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the unregisterChallenge operation.
     * @callback module:api/DefaultApi~unregisterChallengeCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NormalResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Unregister for a challenge
     * @param {Number} id the id of the challenge
     * @param {module:api/DefaultApi~unregisterChallengeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NormalResponse}
     */
    this.unregisterChallenge = function(id, callback) {
      var postBody = null;

      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling unregisterChallenge");
      }


      var pathParams = {
        'id': id
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['bearer'];
      var contentTypes = [];
      var accepts = [];
      var returnType = NormalResponse;

      return this.apiClient.callApi(
        '/challenges/{id}/unregister', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
