//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

extension Parser {
  @_spi(ExperimentalLanguageFeatures)
  public struct ExperimentalFeatures: OptionSet, Hashable, Sendable {
    public let rawValue: UInt

    public init(rawValue: UInt) {
      self.rawValue = rawValue
    }
  }
}

extension Parser.ExperimentalFeatures {
  /// Whether to enable the parsing of reference bindings.
  public static let referenceBindings = Self (rawValue: 1 << 0)

  /// Whether to enable the parsing of 'then' statements.
  public static let thenStatements = Self (rawValue: 1 << 1)

  /// Whether to enable the parsing of 'do' expressions.
  public static let doExpressions = Self (rawValue: 1 << 2)

  /// Whether to enable the parsing of non-escapable types.
  public static let nonescapableTypes = Self (rawValue: 1 << 3)

  /// Whether to enable the parsing of trailing commas.
  public static let trailingComma = Self (rawValue: 1 << 4)

  /// Whether to enable the parsing of coroutine accessors.
  public static let coroutineAccessors = Self (rawValue: 1 << 5)

  /// Whether to enable the parsing of keypaths with method members.
  public static let keypathWithMethodMembers = Self (rawValue: 1 << 6)

  /// Whether to enable the parsing of `_move` and `_borrow` as ownership operators.
  public static let oldOwnershipOperatorSpellings = Self (rawValue: 1 << 7)

  /// Whether to enable the parsing of set default actor isolation for a file.
  public static let defaultIsolationPerFile = Self (rawValue: 1 << 8)

  /// Whether to enable the parsing of Module selector syntax (`ModName::identifier`).
  public static let moduleSelector = Self (rawValue: 1 << 9)

  /// Whether to enable the parsing of borrow and mutate accessors.
  public static let borrowAndMutateAccessors = Self (rawValue: 1 << 10)

  /// Creates a new value representing the experimental feature with the
  /// given name, or returns nil if the name is not recognized.
  public init?(name: String) {
    switch name {
    case "ReferenceBindings":
      self = .referenceBindings
    case "ThenStatements":
      self = .thenStatements
    case "DoExpressions":
      self = .doExpressions
    case "NonescapableTypes":
      self = .nonescapableTypes
    case "TrailingComma":
      self = .trailingComma
    case "CoroutineAccessors":
      self = .coroutineAccessors
    case "KeypathWithMethodMembers":
      self = .keypathWithMethodMembers
    case "OldOwnershipOperatorSpellings":
      self = .oldOwnershipOperatorSpellings
    case "DefaultIsolationPerFile":
      self = .defaultIsolationPerFile
    case "ModuleSelector":
      self = .moduleSelector
    case "BorrowAndMutateAccessors":
      self = .borrowAndMutateAccessors
    default:
      return nil
    }
  }
}
