//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

#if compiler(>=6)
@_spi(RawSyntax) @_spi(ExperimentalLanguageFeatures) @_spi(Compiler) public import SwiftSyntax
#else
@_spi(RawSyntax) @_spi(ExperimentalLanguageFeatures) @_spi(Compiler) import SwiftSyntax
#endif

extension AccessorDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with accessorSpecifier, parameters argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifier: UnexpectedNodesSyntax? = nil,
    modifier: DeclModifierSyntax? = nil,
    unexpectedBetweenModifierAndAccessorKind: UnexpectedNodesSyntax? = nil,
    accessorKind: TokenSyntax,
    unexpectedBetweenAccessorKindAndParameter: UnexpectedNodesSyntax? = nil,
    parameter: AccessorParametersSyntax? = nil,
    unexpectedBetweenParameterAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
    effectSpecifiers: AccessorEffectSpecifiersSyntax? = nil,
    unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? = nil,
    unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    @CodeBlockItemListBuilder bodyBuilder: () throws -> CodeBlockItemListSyntax?,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifier,
      modifier: modifier,
      unexpectedBetweenModifierAndAccessorKind,
      accessorKind: accessorKind,
      unexpectedBetweenAccessorKindAndParameter,
      parameter: parameter,
      unexpectedBetweenParameterAndEffectSpecifiers,
      effectSpecifiers: effectSpecifiers,
      unexpectedBetweenEffectSpecifiersAndBody,
      body: bodyBuilder().map {
        CodeBlockSyntax(statements: $0)
      },
      unexpectedAfterBody,
      trailingTrivia: trailingTrivia
    )
  }
}

extension ActorDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with name argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndActorKeyword: UnexpectedNodesSyntax? = nil,
    actorKeyword: TokenSyntax = .keyword(.actor),
    unexpectedBetweenActorKeywordAndIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    unexpectedBetweenIdentifierAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    @MemberBlockItemListBuilder memberBlockBuilder: () throws -> MemberBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndActorKeyword,
      actorKeyword: actorKeyword,
      unexpectedBetweenActorKeywordAndIdentifier,
      identifier: identifier,
      unexpectedBetweenIdentifierAndGenericParameterClause,
      genericParameterClause: genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndInheritanceClause,
      inheritanceClause: inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock: MemberBlockSyntax(members: memberBlockBuilder()),
      unexpectedAfterMemberBlock,
      trailingTrivia: trailingTrivia
    )
  }
}

extension ArrayExprSyntax {
  @available(*, deprecated, message: "Use an initializer with leftSquare, rightSquare argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeLeftSquareBracket: UnexpectedNodesSyntax? = nil,
    leftSquareBracket: TokenSyntax = .leftSquareToken(),
    unexpectedBetweenLeftSquareBracketAndElements: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenElementsAndRightSquareBracket: UnexpectedNodesSyntax? = nil,
    rightSquareBracket: TokenSyntax = .rightSquareToken(),
    unexpectedAfterRightSquareBracket: UnexpectedNodesSyntax? = nil,
    @ArrayElementListBuilder elementsBuilder: () throws -> ArrayElementListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeLeftSquareBracket,
      leftSquareBracket: leftSquareBracket,
      unexpectedBetweenLeftSquareBracketAndElements,
      elements: elementsBuilder(),
      unexpectedBetweenElementsAndRightSquareBracket,
      rightSquareBracket: rightSquareBracket,
      unexpectedAfterRightSquareBracket,
      trailingTrivia: trailingTrivia
    )
  }
}

extension ClassDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with name argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndClassKeyword: UnexpectedNodesSyntax? = nil,
    classKeyword: TokenSyntax = .keyword(.class),
    unexpectedBetweenClassKeywordAndIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    unexpectedBetweenIdentifierAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    @MemberBlockItemListBuilder memberBlockBuilder: () throws -> MemberBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndClassKeyword,
      classKeyword: classKeyword,
      unexpectedBetweenClassKeywordAndIdentifier,
      identifier: identifier,
      unexpectedBetweenIdentifierAndGenericParameterClause,
      genericParameterClause: genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndInheritanceClause,
      inheritanceClause: inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock: MemberBlockSyntax(members: memberBlockBuilder()),
      unexpectedAfterMemberBlock,
      trailingTrivia: trailingTrivia
    )
  }
}

extension EnumDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with name, genericParameterClause argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndEnumKeyword: UnexpectedNodesSyntax? = nil,
    enumKeyword: TokenSyntax = .keyword(.enum),
    unexpectedBetweenEnumKeywordAndIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    unexpectedBetweenIdentifierAndGenericParameters: UnexpectedNodesSyntax? = nil,
    genericParameters: GenericParameterClauseSyntax? = nil,
    unexpectedBetweenGenericParametersAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    @MemberBlockItemListBuilder memberBlockBuilder: () throws -> MemberBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndEnumKeyword,
      enumKeyword: enumKeyword,
      unexpectedBetweenEnumKeywordAndIdentifier,
      identifier: identifier,
      unexpectedBetweenIdentifierAndGenericParameters,
      genericParameters: genericParameters,
      unexpectedBetweenGenericParametersAndInheritanceClause,
      inheritanceClause: inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock: MemberBlockSyntax(members: memberBlockBuilder()),
      unexpectedAfterMemberBlock,
      trailingTrivia: trailingTrivia
    )
  }
}

extension ExpressionSegmentSyntax {
  @available(*, deprecated, message: "Use an initializer with pounds argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeBackslash: UnexpectedNodesSyntax? = nil,
    backslash: TokenSyntax = .backslashToken(),
    unexpectedBetweenBackslashAndDelimiter: UnexpectedNodesSyntax? = nil,
    delimiter: TokenSyntax? = nil,
    unexpectedBetweenDelimiterAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    unexpectedBetweenLeftParenAndExpressions: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenExpressionsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder expressionsBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeBackslash,
      backslash: backslash,
      unexpectedBetweenBackslashAndDelimiter,
      delimiter: delimiter,
      unexpectedBetweenDelimiterAndLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndExpressions,
      expressions: expressionsBuilder(),
      unexpectedBetweenExpressionsAndRightParen,
      rightParen: rightParen,
      unexpectedAfterRightParen,
      trailingTrivia: trailingTrivia
    )
  }
}

extension ForStmtSyntax {
  @available(*, deprecated, message: "Use an initializer with sequence argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeForKeyword: UnexpectedNodesSyntax? = nil,
    forKeyword: TokenSyntax = .keyword(.for),
    unexpectedBetweenForKeywordAndTryKeyword: UnexpectedNodesSyntax? = nil,
    tryKeyword: TokenSyntax? = nil,
    unexpectedBetweenTryKeywordAndAwaitKeyword: UnexpectedNodesSyntax? = nil,
    awaitKeyword: TokenSyntax? = nil,
    unexpectedBetweenAwaitKeywordAndUnsafeKeyword: UnexpectedNodesSyntax? = nil,
    unsafeKeyword: TokenSyntax? = nil,
    unexpectedBetweenUnsafeKeywordAndCaseKeyword: UnexpectedNodesSyntax? = nil,
    caseKeyword: TokenSyntax? = nil,
    unexpectedBetweenCaseKeywordAndPattern: UnexpectedNodesSyntax? = nil,
    pattern: PatternSyntaxProtocol,
    unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? = nil,
    typeAnnotation: TypeAnnotationSyntax? = nil,
    unexpectedBetweenTypeAnnotationAndInKeyword: UnexpectedNodesSyntax? = nil,
    inKeyword: TokenSyntax = .keyword(.in),
    unexpectedBetweenInKeywordAndSequenceExpr: UnexpectedNodesSyntax? = nil,
    sequenceExpr: ExprSyntaxProtocol,
    unexpectedBetweenSequenceExprAndWhereClause: UnexpectedNodesSyntax? = nil,
    whereClause: WhereClauseSyntax? = nil,
    unexpectedBetweenWhereClauseAndBody: UnexpectedNodesSyntax? = nil,
    unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    @CodeBlockItemListBuilder bodyBuilder: () throws -> CodeBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeForKeyword,
      forKeyword: forKeyword,
      unexpectedBetweenForKeywordAndTryKeyword,
      tryKeyword: tryKeyword,
      unexpectedBetweenTryKeywordAndAwaitKeyword,
      awaitKeyword: awaitKeyword,
      unexpectedBetweenAwaitKeywordAndUnsafeKeyword,
      unsafeKeyword: unsafeKeyword,
      unexpectedBetweenUnsafeKeywordAndCaseKeyword,
      caseKeyword: caseKeyword,
      unexpectedBetweenCaseKeywordAndPattern,
      pattern: PatternSyntax(fromProtocol: pattern),
      unexpectedBetweenPatternAndTypeAnnotation,
      typeAnnotation: typeAnnotation,
      unexpectedBetweenTypeAnnotationAndInKeyword,
      inKeyword: inKeyword,
      unexpectedBetweenInKeywordAndSequenceExpr,
      sequenceExpr: ExprSyntax(fromProtocol: sequenceExpr),
      unexpectedBetweenSequenceExprAndWhereClause,
      whereClause: whereClause,
      unexpectedBetweenWhereClauseAndBody,
      body: CodeBlockSyntax(statements: bodyBuilder()),
      unexpectedAfterBody,
      trailingTrivia: trailingTrivia
    )
  }
}

extension FunctionCallExprSyntax {
  @available(*, deprecated, message: "Use an initializer with arguments argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeCalledExpression: UnexpectedNodesSyntax? = nil,
    calledExpression: ExprSyntaxProtocol,
    unexpectedBetweenCalledExpressionAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax?,
    unexpectedBetweenLeftParenAndArgumentList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentListAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax?,
    unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentListBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeCalledExpression,
      calledExpression: ExprSyntax(fromProtocol: calledExpression),
      unexpectedBetweenCalledExpressionAndLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndArgumentList,
      argumentList: argumentListBuilder(),
      unexpectedBetweenArgumentListAndRightParen,
      rightParen: rightParen,
      unexpectedBetweenRightParenAndTrailingClosure,
      trailingClosure: trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures: additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures,
      trailingTrivia: trailingTrivia
    )
  }
}

extension FunctionDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with name argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndFuncKeyword: UnexpectedNodesSyntax? = nil,
    funcKeyword: TokenSyntax = .keyword(.func),
    unexpectedBetweenFuncKeywordAndIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    unexpectedBetweenIdentifierAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? = nil,
    signature: FunctionSignatureSyntax,
    unexpectedBetweenSignatureAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndBody: UnexpectedNodesSyntax? = nil,
    unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    @CodeBlockItemListBuilder bodyBuilder: () throws -> CodeBlockItemListSyntax?,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndFuncKeyword,
      funcKeyword: funcKeyword,
      unexpectedBetweenFuncKeywordAndIdentifier,
      identifier: identifier,
      unexpectedBetweenIdentifierAndGenericParameterClause,
      genericParameterClause: genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndSignature,
      signature: signature,
      unexpectedBetweenSignatureAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndBody,
      body: bodyBuilder().map {
        CodeBlockSyntax(statements: $0)
      },
      unexpectedAfterBody,
      trailingTrivia: trailingTrivia
    )
  }
}

extension FunctionParameterClauseSyntax {
  @available(*, deprecated, message: "Use an initializer with parameters argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    unexpectedBetweenLeftParenAndParameterList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenParameterListAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    @FunctionParameterListBuilder parameterListBuilder: () throws -> FunctionParameterListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndParameterList,
      parameterList: parameterListBuilder(),
      unexpectedBetweenParameterListAndRightParen,
      rightParen: rightParen,
      unexpectedAfterRightParen,
      trailingTrivia: trailingTrivia
    )
  }
}

extension GenericArgumentClauseSyntax {
  @available(*, deprecated, message: "Use an initializer with leftAngle, rightAngle argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeLeftAngleBracket: UnexpectedNodesSyntax? = nil,
    leftAngleBracket: TokenSyntax = .leftAngleToken(),
    unexpectedBetweenLeftAngleBracketAndArguments: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentsAndRightAngleBracket: UnexpectedNodesSyntax? = nil,
    rightAngleBracket: TokenSyntax = .rightAngleToken(),
    unexpectedAfterRightAngleBracket: UnexpectedNodesSyntax? = nil,
    @GenericArgumentListBuilder argumentsBuilder: () throws -> GenericArgumentListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeLeftAngleBracket,
      leftAngleBracket: leftAngleBracket,
      unexpectedBetweenLeftAngleBracketAndArguments,
      arguments: argumentsBuilder(),
      unexpectedBetweenArgumentsAndRightAngleBracket,
      rightAngleBracket: rightAngleBracket,
      unexpectedAfterRightAngleBracket,
      trailingTrivia: trailingTrivia
    )
  }
}

extension GenericParameterClauseSyntax {
  @available(*, deprecated, message: "Use an initializer with leftAngle, parameters, rightAngle argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeLeftAngleBracket: UnexpectedNodesSyntax? = nil,
    leftAngleBracket: TokenSyntax = .leftAngleToken(),
    unexpectedBetweenLeftAngleBracketAndGenericParameterList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenGenericParameterListAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndRightAngleBracket: UnexpectedNodesSyntax? = nil,
    rightAngleBracket: TokenSyntax = .rightAngleToken(),
    unexpectedAfterRightAngleBracket: UnexpectedNodesSyntax? = nil,
    @GenericParameterListBuilder genericParameterListBuilder: () throws -> GenericParameterListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeLeftAngleBracket,
      leftAngleBracket: leftAngleBracket,
      unexpectedBetweenLeftAngleBracketAndGenericParameterList,
      genericParameterList: genericParameterListBuilder(),
      unexpectedBetweenGenericParameterListAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndRightAngleBracket,
      rightAngleBracket: rightAngleBracket,
      unexpectedAfterRightAngleBracket,
      trailingTrivia: trailingTrivia
    )
  }
}

extension GenericWhereClauseSyntax {
  @available(*, deprecated, message: "Use an initializer with requirements argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeWhereKeyword: UnexpectedNodesSyntax? = nil,
    whereKeyword: TokenSyntax = .keyword(.where),
    unexpectedBetweenWhereKeywordAndRequirementList: UnexpectedNodesSyntax? = nil,
    unexpectedAfterRequirementList: UnexpectedNodesSyntax? = nil,
    @GenericRequirementListBuilder requirementListBuilder: () throws -> GenericRequirementListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeWhereKeyword,
      whereKeyword: whereKeyword,
      unexpectedBetweenWhereKeywordAndRequirementList,
      requirementList: requirementListBuilder(),
      unexpectedAfterRequirementList,
      trailingTrivia: trailingTrivia
    )
  }
}

extension InheritanceClauseSyntax {
  @available(*, deprecated, message: "Use an initializer with inheritedTypes argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    unexpectedBetweenColonAndInheritedTypeCollection: UnexpectedNodesSyntax? = nil,
    unexpectedAfterInheritedTypeCollection: UnexpectedNodesSyntax? = nil,
    @InheritedTypeListBuilder inheritedTypeCollectionBuilder: () throws -> InheritedTypeListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeColon,
      colon: colon,
      unexpectedBetweenColonAndInheritedTypeCollection,
      inheritedTypeCollection: inheritedTypeCollectionBuilder(),
      unexpectedAfterInheritedTypeCollection,
      trailingTrivia: trailingTrivia
    )
  }
}

extension KeyPathSubscriptComponentSyntax {
  @available(*, deprecated, message: "Use an initializer with leftSquare, arguments, rightSquare argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeLeftBracket: UnexpectedNodesSyntax? = nil,
    leftBracket: TokenSyntax = .leftSquareToken(),
    unexpectedBetweenLeftBracketAndArgumentList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentListAndRightBracket: UnexpectedNodesSyntax? = nil,
    rightBracket: TokenSyntax = .rightSquareToken(),
    unexpectedAfterRightBracket: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentListBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeLeftBracket,
      leftBracket: leftBracket,
      unexpectedBetweenLeftBracketAndArgumentList,
      argumentList: argumentListBuilder(),
      unexpectedBetweenArgumentListAndRightBracket,
      rightBracket: rightBracket,
      unexpectedAfterRightBracket,
      trailingTrivia: trailingTrivia
    )
  }
}

extension MacroExpansionDeclSyntax {
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndPound: UnexpectedNodesSyntax? = nil,
    pound: TokenSyntax = .poundToken(),
    unexpectedBetweenPoundAndMacroName: UnexpectedNodesSyntax? = nil,
    macroName: TokenSyntax,
    unexpectedBetweenMacroNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
    genericArgumentClause: GenericArgumentClauseSyntax? = nil,
    unexpectedBetweenGenericArgumentClauseAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax? = nil,
    unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax? = nil,
    unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentsBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndPound,
      pound: pound,
      unexpectedBetweenPoundAndMacroName,
      macroName: macroName,
      unexpectedBetweenMacroNameAndGenericArgumentClause,
      genericArgumentClause: genericArgumentClause,
      unexpectedBetweenGenericArgumentClauseAndLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments: argumentsBuilder(),
      unexpectedBetweenArgumentsAndRightParen,
      rightParen: rightParen,
      unexpectedBetweenRightParenAndTrailingClosure,
      trailingClosure: trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures: additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures,
      trailingTrivia: trailingTrivia
    )
  }
}

extension MacroExpansionDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with pound, moduleSelector, macroName, genericArgumentClause, arguments argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndPoundToken: UnexpectedNodesSyntax? = nil,
    poundToken: TokenSyntax = .poundToken(),
    unexpectedBetweenPoundTokenAndMacro: UnexpectedNodesSyntax? = nil,
    macro: TokenSyntax,
    unexpectedBetweenMacroAndGenericArguments: UnexpectedNodesSyntax? = nil,
    genericArguments: GenericArgumentClauseSyntax? = nil,
    unexpectedBetweenGenericArgumentsAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax? = nil,
    unexpectedBetweenLeftParenAndArgumentList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentListAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax? = nil,
    unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentListBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndPoundToken,
      poundToken: poundToken,
      unexpectedBetweenPoundTokenAndMacro,
      macro: macro,
      unexpectedBetweenMacroAndGenericArguments,
      genericArguments: genericArguments,
      unexpectedBetweenGenericArgumentsAndLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndArgumentList,
      argumentList: argumentListBuilder(),
      unexpectedBetweenArgumentListAndRightParen,
      rightParen: rightParen,
      unexpectedBetweenRightParenAndTrailingClosure,
      trailingClosure: trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures: additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures,
      trailingTrivia: trailingTrivia
    )
  }
}

extension MacroExpansionExprSyntax {
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforePound: UnexpectedNodesSyntax? = nil,
    pound: TokenSyntax = .poundToken(),
    unexpectedBetweenPoundAndMacroName: UnexpectedNodesSyntax? = nil,
    macroName: TokenSyntax,
    unexpectedBetweenMacroNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
    genericArgumentClause: GenericArgumentClauseSyntax? = nil,
    unexpectedBetweenGenericArgumentClauseAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax? = nil,
    unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax? = nil,
    unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentsBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforePound,
      pound: pound,
      unexpectedBetweenPoundAndMacroName,
      macroName: macroName,
      unexpectedBetweenMacroNameAndGenericArgumentClause,
      genericArgumentClause: genericArgumentClause,
      unexpectedBetweenGenericArgumentClauseAndLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments: argumentsBuilder(),
      unexpectedBetweenArgumentsAndRightParen,
      rightParen: rightParen,
      unexpectedBetweenRightParenAndTrailingClosure,
      trailingClosure: trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures: additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures,
      trailingTrivia: trailingTrivia
    )
  }
}

extension MacroExpansionExprSyntax {
  @available(*, deprecated, message: "Use an initializer with pound, moduleSelector, macroName, genericArgumentClause, arguments argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforePoundToken: UnexpectedNodesSyntax? = nil,
    poundToken: TokenSyntax = .poundToken(),
    unexpectedBetweenPoundTokenAndMacro: UnexpectedNodesSyntax? = nil,
    macro: TokenSyntax,
    unexpectedBetweenMacroAndGenericArguments: UnexpectedNodesSyntax? = nil,
    genericArguments: GenericArgumentClauseSyntax? = nil,
    unexpectedBetweenGenericArgumentsAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax? = nil,
    unexpectedBetweenLeftParenAndArgumentList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentListAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax? = nil,
    unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentListBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforePoundToken,
      poundToken: poundToken,
      unexpectedBetweenPoundTokenAndMacro,
      macro: macro,
      unexpectedBetweenMacroAndGenericArguments,
      genericArguments: genericArguments,
      unexpectedBetweenGenericArgumentsAndLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndArgumentList,
      argumentList: argumentListBuilder(),
      unexpectedBetweenArgumentListAndRightParen,
      rightParen: rightParen,
      unexpectedBetweenRightParenAndTrailingClosure,
      trailingClosure: trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures: additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures,
      trailingTrivia: trailingTrivia
    )
  }
}

extension ProtocolDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with name argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndProtocolKeyword: UnexpectedNodesSyntax? = nil,
    protocolKeyword: TokenSyntax = .keyword(.protocol),
    unexpectedBetweenProtocolKeywordAndIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    unexpectedBetweenIdentifierAndPrimaryAssociatedTypeClause: UnexpectedNodesSyntax? = nil,
    primaryAssociatedTypeClause: PrimaryAssociatedTypeClauseSyntax? = nil,
    unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    @MemberBlockItemListBuilder memberBlockBuilder: () throws -> MemberBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndProtocolKeyword,
      protocolKeyword: protocolKeyword,
      unexpectedBetweenProtocolKeywordAndIdentifier,
      identifier: identifier,
      unexpectedBetweenIdentifierAndPrimaryAssociatedTypeClause,
      primaryAssociatedTypeClause: primaryAssociatedTypeClause,
      unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause,
      inheritanceClause: inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock: MemberBlockSyntax(members: memberBlockBuilder()),
      unexpectedAfterMemberBlock,
      trailingTrivia: trailingTrivia
    )
  }
}

extension SourceFileSyntax {
  @available(*, deprecated, message: "Use an initializer with endOfFileToken argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeShebang: UnexpectedNodesSyntax? = nil,
    shebang: TokenSyntax? = nil,
    unexpectedBetweenShebangAndStatements: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenStatementsAndEofToken: UnexpectedNodesSyntax? = nil,
    eofToken: TokenSyntax = .endOfFileToken(),
    unexpectedAfterEofToken: UnexpectedNodesSyntax? = nil,
    @CodeBlockItemListBuilder statementsBuilder: () throws -> CodeBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeShebang,
      shebang: shebang,
      unexpectedBetweenShebangAndStatements,
      statements: statementsBuilder(),
      unexpectedBetweenStatementsAndEofToken,
      eofToken: eofToken,
      unexpectedAfterEofToken,
      trailingTrivia: trailingTrivia
    )
  }
}

extension StructDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with name argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndStructKeyword: UnexpectedNodesSyntax? = nil,
    structKeyword: TokenSyntax = .keyword(.struct),
    unexpectedBetweenStructKeywordAndIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    unexpectedBetweenIdentifierAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    @MemberBlockItemListBuilder memberBlockBuilder: () throws -> MemberBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndStructKeyword,
      structKeyword: structKeyword,
      unexpectedBetweenStructKeywordAndIdentifier,
      identifier: identifier,
      unexpectedBetweenIdentifierAndGenericParameterClause,
      genericParameterClause: genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndInheritanceClause,
      inheritanceClause: inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause: genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock: MemberBlockSyntax(members: memberBlockBuilder()),
      unexpectedAfterMemberBlock,
      trailingTrivia: trailingTrivia
    )
  }
}

extension SubscriptCallExprSyntax {
  @available(*, deprecated, message: "Use an initializer with leftSquare, arguments, rightSquare argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeCalledExpression: UnexpectedNodesSyntax? = nil,
    calledExpression: ExprSyntaxProtocol,
    unexpectedBetweenCalledExpressionAndLeftBracket: UnexpectedNodesSyntax? = nil,
    leftBracket: TokenSyntax = .leftSquareToken(),
    unexpectedBetweenLeftBracketAndArgumentList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenArgumentListAndRightBracket: UnexpectedNodesSyntax? = nil,
    rightBracket: TokenSyntax = .rightSquareToken(),
    unexpectedBetweenRightBracketAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder argumentListBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeCalledExpression,
      calledExpression: ExprSyntax(fromProtocol: calledExpression),
      unexpectedBetweenCalledExpressionAndLeftBracket,
      leftBracket: leftBracket,
      unexpectedBetweenLeftBracketAndArgumentList,
      argumentList: argumentListBuilder(),
      unexpectedBetweenArgumentListAndRightBracket,
      rightBracket: rightBracket,
      unexpectedBetweenRightBracketAndTrailingClosure,
      trailingClosure: trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures: additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures,
      trailingTrivia: trailingTrivia
    )
  }
}

extension SwitchCaseSyntax {
  @available(*, deprecated, message: "Use an initializer with attribute argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeUnknownAttr: UnexpectedNodesSyntax? = nil,
    unknownAttr: AttributeSyntax? = nil,
    unexpectedBetweenUnknownAttrAndLabel: UnexpectedNodesSyntax? = nil,
    label: Label,
    unexpectedBetweenLabelAndStatements: UnexpectedNodesSyntax? = nil,
    unexpectedAfterStatements: UnexpectedNodesSyntax? = nil,
    @CodeBlockItemListBuilder statementsBuilder: () throws -> CodeBlockItemListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeUnknownAttr,
      unknownAttr: unknownAttr,
      unexpectedBetweenUnknownAttrAndLabel,
      label: label,
      unexpectedBetweenLabelAndStatements,
      statements: statementsBuilder(),
      unexpectedAfterStatements,
      trailingTrivia: trailingTrivia
    )
  }
}

extension SwitchExprSyntax {
  @available(*, deprecated, message: "Use an initializer with subject argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeSwitchKeyword: UnexpectedNodesSyntax? = nil,
    switchKeyword: TokenSyntax = .keyword(.switch),
    unexpectedBetweenSwitchKeywordAndExpression: UnexpectedNodesSyntax? = nil,
    expression: ExprSyntaxProtocol,
    unexpectedBetweenExpressionAndLeftBrace: UnexpectedNodesSyntax? = nil,
    leftBrace: TokenSyntax = .leftBraceToken(),
    unexpectedBetweenLeftBraceAndCases: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenCasesAndRightBrace: UnexpectedNodesSyntax? = nil,
    rightBrace: TokenSyntax = .rightBraceToken(),
    unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
    @SwitchCaseListBuilder casesBuilder: () throws -> SwitchCaseListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeSwitchKeyword,
      switchKeyword: switchKeyword,
      unexpectedBetweenSwitchKeywordAndExpression,
      expression: ExprSyntax(fromProtocol: expression),
      unexpectedBetweenExpressionAndLeftBrace,
      leftBrace: leftBrace,
      unexpectedBetweenLeftBraceAndCases,
      cases: casesBuilder(),
      unexpectedBetweenCasesAndRightBrace,
      rightBrace: rightBrace,
      unexpectedAfterRightBrace,
      trailingTrivia: trailingTrivia
    )
  }
}

extension TupleExprSyntax {
  @available(*, deprecated, message: "Use an initializer with elements argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    unexpectedBetweenLeftParenAndElementList: UnexpectedNodesSyntax? = nil,
    unexpectedBetweenElementListAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    @LabeledExprListBuilder elementListBuilder: () throws -> LabeledExprListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeLeftParen,
      leftParen: leftParen,
      unexpectedBetweenLeftParenAndElementList,
      elementList: elementListBuilder(),
      unexpectedBetweenElementListAndRightParen,
      rightParen: rightParen,
      unexpectedAfterRightParen,
      trailingTrivia: trailingTrivia
    )
  }
}

extension VariableDeclSyntax {
  @available(*, deprecated, message: "Use an initializer with bindingSpecifier argument(s).")
  @_disfavoredOverload
  /// A convenience initializer that allows initializing syntax collections using result builders
  public init(
    leadingTrivia: Trivia? = nil,
    unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    unexpectedBetweenModifiersAndBindingKeyword: UnexpectedNodesSyntax? = nil,
    bindingKeyword: TokenSyntax,
    unexpectedBetweenBindingKeywordAndBindings: UnexpectedNodesSyntax? = nil,
    unexpectedAfterBindings: UnexpectedNodesSyntax? = nil,
    @PatternBindingListBuilder bindingsBuilder: () throws -> PatternBindingListSyntax,
    trailingTrivia: Trivia? = nil
  ) rethrows {
    try self.init(
      leadingTrivia: leadingTrivia,
      unexpectedBeforeAttributes,
      attributes: attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers: modifiers,
      unexpectedBetweenModifiersAndBindingKeyword,
      bindingKeyword: bindingKeyword,
      unexpectedBetweenBindingKeywordAndBindings,
      bindings: bindingsBuilder(),
      unexpectedAfterBindings,
      trailingTrivia: trailingTrivia
    )
  }
}
