//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - ObjCSelectorPieceSyntax

/// A piece of an Objective-C selector. Either consisting of just an identifier for a nullary selector, an identifier and a colon for a labeled argument or just a colon for an unlabeled argument
///
/// ### Children
/// 
///  - `name`: ``TokenSyntax``?
///  - `colon`: `:`?
///
/// ### Contained in
/// 
///  - ``ObjCSelectorPieceListSyntax``
public struct ObjCSelectorPieceSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .objCSelectorPiece else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - name: The identifier name for a nullary selection, if it exists.
  ///   - colon: The colon separating the label and the value or a colon representing an unlabeled argument
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax? = nil,
    _ unexpectedBetweenNameAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax? = nil,
    _ unexpectedAfterColon: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndColon,
      colon,
      unexpectedAfterColon
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name?.raw,
        unexpectedBetweenNameAndColon?.raw,
        colon?.raw,
        unexpectedAfterColon?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.objCSelectorPiece,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ObjCSelectorPieceSyntax.self)
    }
  }

  /// The identifier name for a nullary selection, if it exists.
  public var name: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ObjCSelectorPieceSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ObjCSelectorPieceSyntax.self)
    }
  }

  /// The colon separating the label and the value or a colon representing an unlabeled argument
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ObjCSelectorPieceSyntax.self)
    }
  }

  public var unexpectedAfterColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ObjCSelectorPieceSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndColon,
    \Self.colon,
    \Self.unexpectedAfterColon
  ])
}

// MARK: - OperatorDeclSyntax

/// A Swift `operator` declaration.
///
/// ### Children
/// 
///  - `fixitySpecifier`: (`prefix` | `postfix` | `infix`)
///  - `operatorKeyword`: `operator`
///  - `name`: (`<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
///  - `operatorPrecedenceAndTypes`: ``OperatorPrecedenceAndTypesSyntax``?
public struct OperatorDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .operatorDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - fixitySpecifier: The fixity applied to the 'operator' declaration.
  ///   - operatorPrecedenceAndTypes: Optionally specify a precedence group and designated types.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeFixitySpecifier: UnexpectedNodesSyntax? = nil,
    fixitySpecifier: TokenSyntax,
    _ unexpectedBetweenFixitySpecifierAndOperatorKeyword: UnexpectedNodesSyntax? = nil,
    operatorKeyword: TokenSyntax = .keyword(.operator),
    _ unexpectedBetweenOperatorKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndOperatorPrecedenceAndTypes: UnexpectedNodesSyntax? = nil,
    operatorPrecedenceAndTypes: OperatorPrecedenceAndTypesSyntax? = nil,
    _ unexpectedAfterOperatorPrecedenceAndTypes: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeFixitySpecifier,
      fixitySpecifier,
      unexpectedBetweenFixitySpecifierAndOperatorKeyword,
      operatorKeyword,
      unexpectedBetweenOperatorKeywordAndName,
      name,
      unexpectedBetweenNameAndOperatorPrecedenceAndTypes,
      operatorPrecedenceAndTypes,
      unexpectedAfterOperatorPrecedenceAndTypes
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeFixitySpecifier?.raw,
        fixitySpecifier.raw,
        unexpectedBetweenFixitySpecifierAndOperatorKeyword?.raw,
        operatorKeyword.raw,
        unexpectedBetweenOperatorKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndOperatorPrecedenceAndTypes?.raw,
        operatorPrecedenceAndTypes?.raw,
        unexpectedAfterOperatorPrecedenceAndTypes?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.operatorDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeFixitySpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  /// The fixity applied to the 'operator' declaration.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `prefix`
  ///  - `postfix`
  ///  - `infix`
  public var fixitySpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenFixitySpecifierAndOperatorKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `operator`.
  public var operatorKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenOperatorKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<binaryOperator>`
  ///  - `<prefixOperator>`
  ///  - `<postfixOperator>`
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndOperatorPrecedenceAndTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  /// Optionally specify a precedence group and designated types.
  public var operatorPrecedenceAndTypes: OperatorPrecedenceAndTypesSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(OperatorPrecedenceAndTypesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  public var unexpectedAfterOperatorPrecedenceAndTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeFixitySpecifier,
    \Self.fixitySpecifier,
    \Self.unexpectedBetweenFixitySpecifierAndOperatorKeyword,
    \Self.operatorKeyword,
    \Self.unexpectedBetweenOperatorKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndOperatorPrecedenceAndTypes,
    \Self.operatorPrecedenceAndTypes,
    \Self.unexpectedAfterOperatorPrecedenceAndTypes
  ])
}

// MARK: - OperatorPrecedenceAndTypesSyntax

/// A clause to specify precedence group in infix operator declarations, and designated types in any operator declaration.
///
/// ### Children
/// 
///  - `colon`: `:`
///  - `precedenceGroup`: `<identifier>`
///  - `designatedTypes`: ``DesignatedTypeListSyntax``
///
/// ### Contained in
/// 
///  - ``OperatorDeclSyntax``.``OperatorDeclSyntax/operatorPrecedenceAndTypes``
public struct OperatorPrecedenceAndTypesSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .operatorPrecedenceAndTypes else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - precedenceGroup: The precedence group for this operator
  ///   - designatedTypes: The designated types associated with this operator.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndPrecedenceGroup: UnexpectedNodesSyntax? = nil,
    precedenceGroup: TokenSyntax,
    _ unexpectedBetweenPrecedenceGroupAndDesignatedTypes: UnexpectedNodesSyntax? = nil,
    designatedTypes: DesignatedTypeListSyntax,
    _ unexpectedAfterDesignatedTypes: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeColon,
      colon,
      unexpectedBetweenColonAndPrecedenceGroup,
      precedenceGroup,
      unexpectedBetweenPrecedenceGroupAndDesignatedTypes,
      designatedTypes,
      unexpectedAfterDesignatedTypes
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndPrecedenceGroup?.raw,
        precedenceGroup.raw,
        unexpectedBetweenPrecedenceGroupAndDesignatedTypes?.raw,
        designatedTypes.raw,
        unexpectedAfterDesignatedTypes?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.operatorPrecedenceAndTypes,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndPrecedenceGroup: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  /// The precedence group for this operator
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var precedenceGroup: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  public var unexpectedBetweenPrecedenceGroupAndDesignatedTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  /// The designated types associated with this operator.
  public var designatedTypes: DesignatedTypeListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(DesignatedTypeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `designatedTypes`
  /// collection.
  ///
  /// - param element: The new `DesignatedTypeElement` to add to the node's
  ///                  `designatedTypes` collection.
  /// - returns: A copy of the receiver with the provided `DesignatedTypeElement`
  ///            appended to its `designatedTypes` collection.
  @available(*, deprecated, message: "Use node.designatedTypes.append(newElement) instead")
  public func addDesignatedTypeElement(_ element: DesignatedTypeSyntax) -> OperatorPrecedenceAndTypesSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.designatedTypeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(OperatorPrecedenceAndTypesSyntax.self)
  }

  public var unexpectedAfterDesignatedTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OperatorPrecedenceAndTypesSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndPrecedenceGroup,
    \Self.precedenceGroup,
    \Self.unexpectedBetweenPrecedenceGroupAndDesignatedTypes,
    \Self.designatedTypes,
    \Self.unexpectedAfterDesignatedTypes
  ])
}

// MARK: - OptionalBindingConditionSyntax

/// ### Children
/// 
///  - `bindingSpecifier`: (`let` | `var` | `inout` | `_mutating` | `_borrowing` | `_consuming`)
///  - `pattern`: ``PatternSyntax``
///  - `typeAnnotation`: ``TypeAnnotationSyntax``?
///  - `initializer`: ``InitializerClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
public struct OptionalBindingConditionSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .optionalBindingCondition else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBindingSpecifier: UnexpectedNodesSyntax? = nil,
    bindingSpecifier: TokenSyntax,
    _ unexpectedBetweenBindingSpecifierAndPattern: UnexpectedNodesSyntax? = nil,
    pattern: some PatternSyntaxProtocol,
    _ unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? = nil,
    typeAnnotation: TypeAnnotationSyntax? = nil,
    _ unexpectedBetweenTypeAnnotationAndInitializer: UnexpectedNodesSyntax? = nil,
    initializer: InitializerClauseSyntax? = nil,
    _ unexpectedAfterInitializer: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBindingSpecifier,
      bindingSpecifier,
      unexpectedBetweenBindingSpecifierAndPattern,
      pattern,
      unexpectedBetweenPatternAndTypeAnnotation,
      typeAnnotation,
      unexpectedBetweenTypeAnnotationAndInitializer,
      initializer,
      unexpectedAfterInitializer
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBindingSpecifier?.raw,
        bindingSpecifier.raw,
        unexpectedBetweenBindingSpecifierAndPattern?.raw,
        pattern.raw,
        unexpectedBetweenPatternAndTypeAnnotation?.raw,
        typeAnnotation?.raw,
        unexpectedBetweenTypeAnnotationAndInitializer?.raw,
        initializer?.raw,
        unexpectedAfterInitializer?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.optionalBindingCondition,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBindingSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `let`
  ///  - `var`
  ///  - `inout`
  ///  - `_mutating`
  ///  - `_borrowing`
  ///  - `_consuming`
  public var bindingSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var unexpectedBetweenBindingSpecifierAndPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var typeAnnotation: TypeAnnotationSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TypeAnnotationSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAnnotationAndInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var initializer: InitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public var unexpectedAfterInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalBindingConditionSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBindingSpecifier,
    \Self.bindingSpecifier,
    \Self.unexpectedBetweenBindingSpecifierAndPattern,
    \Self.pattern,
    \Self.unexpectedBetweenPatternAndTypeAnnotation,
    \Self.typeAnnotation,
    \Self.unexpectedBetweenTypeAnnotationAndInitializer,
    \Self.initializer,
    \Self.unexpectedAfterInitializer
  ])
}

// MARK: - OptionalChainingExprSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `questionMark`: `?`
public struct OptionalChainingExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .optionalChainingExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndQuestionMark: UnexpectedNodesSyntax? = nil,
    questionMark: TokenSyntax = .postfixQuestionMarkToken(),
    _ unexpectedAfterQuestionMark: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndQuestionMark,
      questionMark,
      unexpectedAfterQuestionMark
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndQuestionMark?.raw,
        questionMark.raw,
        unexpectedAfterQuestionMark?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.optionalChainingExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalChainingExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalChainingExprSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndQuestionMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalChainingExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `?`.
  public var questionMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalChainingExprSyntax.self)
    }
  }

  public var unexpectedAfterQuestionMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalChainingExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndQuestionMark,
    \Self.questionMark,
    \Self.unexpectedAfterQuestionMark
  ])
}

// MARK: - OptionalTypeSyntax

/// ### Children
/// 
///  - `wrappedType`: ``TypeSyntax``
///  - `questionMark`: `?`
public struct OptionalTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .optionalType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeWrappedType: UnexpectedNodesSyntax? = nil,
    wrappedType: some TypeSyntaxProtocol,
    _ unexpectedBetweenWrappedTypeAndQuestionMark: UnexpectedNodesSyntax? = nil,
    questionMark: TokenSyntax = .postfixQuestionMarkToken(),
    _ unexpectedAfterQuestionMark: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeWrappedType,
      wrappedType,
      unexpectedBetweenWrappedTypeAndQuestionMark,
      questionMark,
      unexpectedAfterQuestionMark
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeWrappedType?.raw,
        wrappedType.raw,
        unexpectedBetweenWrappedTypeAndQuestionMark?.raw,
        questionMark.raw,
        unexpectedAfterQuestionMark?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.optionalType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeWrappedType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalTypeSyntax.self)
    }
  }

  public var wrappedType: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalTypeSyntax.self)
    }
  }

  public var unexpectedBetweenWrappedTypeAndQuestionMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `?`.
  public var questionMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalTypeSyntax.self)
    }
  }

  public var unexpectedAfterQuestionMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OptionalTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeWrappedType,
    \Self.wrappedType,
    \Self.unexpectedBetweenWrappedTypeAndQuestionMark,
    \Self.questionMark,
    \Self.unexpectedAfterQuestionMark
  ])
}

// MARK: - OriginallyDefinedInAttributeArgumentsSyntax

/// The arguments for the '@_originallyDefinedIn' attribute
///
/// ### Children
/// 
///  - `moduleLabel`: `module`
///  - `colon`: `:`
///  - `moduleName`: ``StringLiteralExprSyntax``
///  - `comma`: `,`
///  - `platforms`: ``PlatformVersionItemListSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct OriginallyDefinedInAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .originallyDefinedInAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeModuleLabel: UnexpectedNodesSyntax? = nil,
    moduleLabel: TokenSyntax = .keyword(.module),
    _ unexpectedBetweenModuleLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndModuleName: UnexpectedNodesSyntax? = nil,
    moduleName: StringLiteralExprSyntax,
    _ unexpectedBetweenModuleNameAndComma: UnexpectedNodesSyntax? = nil,
    comma: TokenSyntax = .commaToken(),
    _ unexpectedBetweenCommaAndPlatforms: UnexpectedNodesSyntax? = nil,
    platforms: PlatformVersionItemListSyntax,
    _ unexpectedAfterPlatforms: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeModuleLabel,
      moduleLabel,
      unexpectedBetweenModuleLabelAndColon,
      colon,
      unexpectedBetweenColonAndModuleName,
      moduleName,
      unexpectedBetweenModuleNameAndComma,
      comma,
      unexpectedBetweenCommaAndPlatforms,
      platforms,
      unexpectedAfterPlatforms
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeModuleLabel?.raw,
        moduleLabel.raw,
        unexpectedBetweenModuleLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndModuleName?.raw,
        moduleName.raw,
        unexpectedBetweenModuleNameAndComma?.raw,
        comma.raw,
        unexpectedBetweenCommaAndPlatforms?.raw,
        platforms.raw,
        unexpectedAfterPlatforms?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.originallyDefinedInAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeModuleLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `module`.
  public var moduleLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenModuleLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndModuleName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public var moduleName: StringLiteralExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(StringLiteralExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenModuleNameAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var comma: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenCommaAndPlatforms: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public var platforms: PlatformVersionItemListSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(PlatformVersionItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `platforms`
  /// collection.
  ///
  /// - param element: The new `Platform` to add to the node's
  ///                  `platforms` collection.
  /// - returns: A copy of the receiver with the provided `Platform`
  ///            appended to its `platforms` collection.
  @available(*, deprecated, message: "Use node.platforms.append(newElement) instead")
  public func addPlatform(_ element: PlatformVersionItemSyntax) -> OriginallyDefinedInAttributeArgumentsSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[9] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.platformVersionItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 9,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
  }

  public var unexpectedAfterPlatforms: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(OriginallyDefinedInAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeModuleLabel,
    \Self.moduleLabel,
    \Self.unexpectedBetweenModuleLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndModuleName,
    \Self.moduleName,
    \Self.unexpectedBetweenModuleNameAndComma,
    \Self.comma,
    \Self.unexpectedBetweenCommaAndPlatforms,
    \Self.platforms,
    \Self.unexpectedAfterPlatforms
  ])
}

// MARK: - PackElementExprSyntax

/// A pack element expression spelled with `each`.
///
/// ### Children
/// 
///  - `eachKeyword`: `each`
///  - `pack`: ``ExprSyntax``
public struct PackElementExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .packElementExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeEachKeyword: UnexpectedNodesSyntax? = nil,
    eachKeyword: TokenSyntax = .keyword(.each),
    _ unexpectedBetweenEachKeywordAndPack: UnexpectedNodesSyntax? = nil,
    pack: some ExprSyntaxProtocol,
    _ unexpectedAfterPack: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeEachKeyword,
      eachKeyword,
      unexpectedBetweenEachKeywordAndPack,
      pack,
      unexpectedAfterPack
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeEachKeyword?.raw,
        eachKeyword.raw,
        unexpectedBetweenEachKeywordAndPack?.raw,
        pack.raw,
        unexpectedAfterPack?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.packElementExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeEachKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `each`.
  public var eachKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementExprSyntax.self)
    }
  }

  public var unexpectedBetweenEachKeywordAndPack: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementExprSyntax.self)
    }
  }

  public var pack: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementExprSyntax.self)
    }
  }

  public var unexpectedAfterPack: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeEachKeyword,
    \Self.eachKeyword,
    \Self.unexpectedBetweenEachKeywordAndPack,
    \Self.pack,
    \Self.unexpectedAfterPack
  ])
}

// MARK: - PackElementTypeSyntax

/// ### Children
/// 
///  - `eachKeyword`: `each`
///  - `pack`: ``TypeSyntax``
public struct PackElementTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .packElementType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeEachKeyword: UnexpectedNodesSyntax? = nil,
    eachKeyword: TokenSyntax = .keyword(.each),
    _ unexpectedBetweenEachKeywordAndPack: UnexpectedNodesSyntax? = nil,
    pack: some TypeSyntaxProtocol,
    _ unexpectedAfterPack: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeEachKeyword,
      eachKeyword,
      unexpectedBetweenEachKeywordAndPack,
      pack,
      unexpectedAfterPack
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeEachKeyword?.raw,
        eachKeyword.raw,
        unexpectedBetweenEachKeywordAndPack?.raw,
        pack.raw,
        unexpectedAfterPack?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.packElementType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeEachKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `each`.
  public var eachKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementTypeSyntax.self)
    }
  }

  public var unexpectedBetweenEachKeywordAndPack: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementTypeSyntax.self)
    }
  }

  public var pack: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementTypeSyntax.self)
    }
  }

  public var unexpectedAfterPack: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackElementTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeEachKeyword,
    \Self.eachKeyword,
    \Self.unexpectedBetweenEachKeywordAndPack,
    \Self.pack,
    \Self.unexpectedAfterPack
  ])
}

// MARK: - PackExpansionExprSyntax

/// A pack expansion expression spelled with `repeat`.
///
/// ### Children
/// 
///  - `repeatKeyword`: `repeat`
///  - `repetitionPattern`: ``ExprSyntax``
public struct PackExpansionExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .packExpansionExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeRepeatKeyword: UnexpectedNodesSyntax? = nil,
    repeatKeyword: TokenSyntax = .keyword(.repeat),
    _ unexpectedBetweenRepeatKeywordAndRepetitionPattern: UnexpectedNodesSyntax? = nil,
    repetitionPattern: some ExprSyntaxProtocol,
    _ unexpectedAfterRepetitionPattern: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeRepeatKeyword,
      repeatKeyword,
      unexpectedBetweenRepeatKeywordAndRepetitionPattern,
      repetitionPattern,
      unexpectedAfterRepetitionPattern
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeRepeatKeyword?.raw,
        repeatKeyword.raw,
        unexpectedBetweenRepeatKeywordAndRepetitionPattern?.raw,
        repetitionPattern.raw,
        unexpectedAfterRepetitionPattern?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.packExpansionExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeRepeatKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `repeat`.
  public var repeatKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionExprSyntax.self)
    }
  }

  public var unexpectedBetweenRepeatKeywordAndRepetitionPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionExprSyntax.self)
    }
  }

  public var repetitionPattern: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionExprSyntax.self)
    }
  }

  public var unexpectedAfterRepetitionPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeRepeatKeyword,
    \Self.repeatKeyword,
    \Self.unexpectedBetweenRepeatKeywordAndRepetitionPattern,
    \Self.repetitionPattern,
    \Self.unexpectedAfterRepetitionPattern
  ])
}

// MARK: - PackExpansionTypeSyntax

/// ### Children
/// 
///  - `repeatKeyword`: `repeat`
///  - `repetitionPattern`: ``TypeSyntax``
public struct PackExpansionTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .packExpansionType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeRepeatKeyword: UnexpectedNodesSyntax? = nil,
    repeatKeyword: TokenSyntax = .keyword(.repeat),
    _ unexpectedBetweenRepeatKeywordAndRepetitionPattern: UnexpectedNodesSyntax? = nil,
    repetitionPattern: some TypeSyntaxProtocol,
    _ unexpectedAfterRepetitionPattern: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeRepeatKeyword,
      repeatKeyword,
      unexpectedBetweenRepeatKeywordAndRepetitionPattern,
      repetitionPattern,
      unexpectedAfterRepetitionPattern
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeRepeatKeyword?.raw,
        repeatKeyword.raw,
        unexpectedBetweenRepeatKeywordAndRepetitionPattern?.raw,
        repetitionPattern.raw,
        unexpectedAfterRepetitionPattern?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.packExpansionType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeRepeatKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `repeat`.
  public var repeatKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionTypeSyntax.self)
    }
  }

  public var unexpectedBetweenRepeatKeywordAndRepetitionPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionTypeSyntax.self)
    }
  }

  public var repetitionPattern: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionTypeSyntax.self)
    }
  }

  public var unexpectedAfterRepetitionPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PackExpansionTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeRepeatKeyword,
    \Self.repeatKeyword,
    \Self.unexpectedBetweenRepeatKeywordAndRepetitionPattern,
    \Self.repetitionPattern,
    \Self.unexpectedAfterRepetitionPattern
  ])
}

// MARK: - PatternBindingSyntax

/// Defines variables inside a variable declaration.
///
/// ### Children
/// 
///  - `pattern`: ``PatternSyntax``
///  - `typeAnnotation`: ``TypeAnnotationSyntax``?
///  - `initializer`: ``InitializerClauseSyntax``?
///  - `accessorBlock`: ``AccessorBlockSyntax``?
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``PatternBindingListSyntax``
public struct PatternBindingSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .patternBinding else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - pattern: The pattern that defines the variables.
  ///   - typeAnnotation: The type of the variables defined by the pattern.
  ///   - initializer: If the variables have a default value, the clause that initializes them.
  ///   - accessorBlock: If the variable is computed, the accessors that get (and optionally set) the value.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePattern: UnexpectedNodesSyntax? = nil,
    pattern: some PatternSyntaxProtocol,
    _ unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? = nil,
    typeAnnotation: TypeAnnotationSyntax? = nil,
    _ unexpectedBetweenTypeAnnotationAndInitializer: UnexpectedNodesSyntax? = nil,
    initializer: InitializerClauseSyntax? = nil,
    _ unexpectedBetweenInitializerAndAccessorBlock: UnexpectedNodesSyntax? = nil,
    accessorBlock: AccessorBlockSyntax? = nil,
    _ unexpectedBetweenAccessorBlockAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePattern,
      pattern,
      unexpectedBetweenPatternAndTypeAnnotation,
      typeAnnotation,
      unexpectedBetweenTypeAnnotationAndInitializer,
      initializer,
      unexpectedBetweenInitializerAndAccessorBlock,
      accessorBlock,
      unexpectedBetweenAccessorBlockAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePattern?.raw,
        pattern.raw,
        unexpectedBetweenPatternAndTypeAnnotation?.raw,
        typeAnnotation?.raw,
        unexpectedBetweenTypeAnnotationAndInitializer?.raw,
        initializer?.raw,
        unexpectedBetweenInitializerAndAccessorBlock?.raw,
        accessorBlock?.raw,
        unexpectedBetweenAccessorBlockAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.patternBinding,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  /// The pattern that defines the variables.
  /// 
  /// In simple variable declarations this is an ``IdentifierPatternSyntax``, which defines
  /// the name of a single variable.
  /// 
  /// In more complex variable declaration, this can, for example, be a ``TuplePatternSyntax``
  /// that destructures a tuple.
  /// 
  /// ```swift
  /// let (x, y) = (1, 2)
  /// ```
  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  public var unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  /// The type of the variables defined by the pattern.
  /// 
  /// Can be omitted, in which case the variables’ types are inferred from the initializer.
  public var typeAnnotation: TypeAnnotationSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TypeAnnotationSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAnnotationAndInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  /// If the variables have a default value, the clause that initializes them.
  public var initializer: InitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  public var unexpectedBetweenInitializerAndAccessorBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  /// If the variable is computed, the accessors that get (and optionally set) the value.
  public var accessorBlock: AccessorBlockSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(AccessorBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  public var unexpectedBetweenAccessorBlockAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternBindingSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePattern,
    \Self.pattern,
    \Self.unexpectedBetweenPatternAndTypeAnnotation,
    \Self.typeAnnotation,
    \Self.unexpectedBetweenTypeAnnotationAndInitializer,
    \Self.initializer,
    \Self.unexpectedBetweenInitializerAndAccessorBlock,
    \Self.accessorBlock,
    \Self.unexpectedBetweenAccessorBlockAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - PatternExprSyntax

/// ### Children
/// 
///  - `pattern`: ``PatternSyntax``
public struct PatternExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .patternExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePattern: UnexpectedNodesSyntax? = nil,
    pattern: some PatternSyntaxProtocol,
    _ unexpectedAfterPattern: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforePattern, pattern, unexpectedAfterPattern))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePattern?.raw, pattern.raw, unexpectedAfterPattern?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.patternExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternExprSyntax.self)
    }
  }

  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternExprSyntax.self)
    }
  }

  public var unexpectedAfterPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PatternExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforePattern, \Self.pattern, \Self.unexpectedAfterPattern])
}

// MARK: - PlatformVersionItemSyntax

/// A single platform/version pair in an attribute, e.g. `iOS 10.1`.
///
/// ### Children
/// 
///  - `platformVersion`: ``PlatformVersionSyntax``
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``PlatformVersionItemListSyntax``
public struct PlatformVersionItemSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .platformVersionItem else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - platformVersion: The platform/version pair, e.g. `iOS 10.1`
  ///   - trailingComma: A trailing comma if the argument is followed by another argument
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePlatformVersion: UnexpectedNodesSyntax? = nil,
    platformVersion: PlatformVersionSyntax,
    _ unexpectedBetweenPlatformVersionAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePlatformVersion,
      platformVersion,
      unexpectedBetweenPlatformVersionAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePlatformVersion?.raw,
        platformVersion.raw,
        unexpectedBetweenPlatformVersionAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.platformVersionItem,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePlatformVersion: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionItemSyntax.self)
    }
  }

  /// The platform/version pair, e.g. `iOS 10.1`
  public var platformVersion: PlatformVersionSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(PlatformVersionSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionItemSyntax.self)
    }
  }

  public var unexpectedBetweenPlatformVersionAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionItemSyntax.self)
    }
  }

  /// A trailing comma if the argument is followed by another argument
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionItemSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionItemSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePlatformVersion,
    \Self.platformVersion,
    \Self.unexpectedBetweenPlatformVersionAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - PlatformVersionSyntax

/// An argument to `@available` that restricts the availability on a certain platform to a version, e.g. `iOS 10` or `swift 3.4`.
///
/// ### Children
/// 
///  - `platform`: `<identifier>`
///  - `version`: ``VersionTupleSyntax``?
///
/// ### Contained in
/// 
///  - ``AvailabilityArgumentSyntax``.``AvailabilityArgumentSyntax/argument``
///  - ``PlatformVersionItemSyntax``.``PlatformVersionItemSyntax/platformVersion``
public struct PlatformVersionSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .platformVersion else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - platform: The name of the OS on which the availability should be restricted or 'swift' if the availability should be restricted based on a Swift version.
  ///   - version: The version of this platform.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePlatform: UnexpectedNodesSyntax? = nil,
    platform: TokenSyntax,
    _ unexpectedBetweenPlatformAndVersion: UnexpectedNodesSyntax? = nil,
    version: VersionTupleSyntax? = nil,
    _ unexpectedAfterVersion: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePlatform,
      platform,
      unexpectedBetweenPlatformAndVersion,
      version,
      unexpectedAfterVersion
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePlatform?.raw,
        platform.raw,
        unexpectedBetweenPlatformAndVersion?.raw,
        version?.raw,
        unexpectedAfterVersion?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.platformVersion,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePlatform: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionSyntax.self)
    }
  }

  /// The name of the OS on which the availability should be restricted or 'swift' if the availability should be restricted based on a Swift version.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var platform: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionSyntax.self)
    }
  }

  public var unexpectedBetweenPlatformAndVersion: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionSyntax.self)
    }
  }

  /// The version of this platform.
  /// 
  /// This parameter is optional because a custom platform alias can be specified using the `-define-availability` 
  /// argument to the Swift compiler. For example, when passing `-define-availability "_iOS8Aligned:macOS 10.10, iOS 8.0"`
  /// to the Swift compiler, then `@available(_iOS8Aligned, *)` is interpreted as `@available(macOS 10.10, iOS 8.0, *)`.
  public var version: VersionTupleSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(VersionTupleSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionSyntax.self)
    }
  }

  public var unexpectedAfterVersion: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PlatformVersionSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePlatform,
    \Self.platform,
    \Self.unexpectedBetweenPlatformAndVersion,
    \Self.version,
    \Self.unexpectedAfterVersion
  ])
}

// MARK: - PostfixIfConfigExprSyntax

/// ### Children
/// 
///  - `base`: ``ExprSyntax``?
///  - `config`: ``IfConfigDeclSyntax``
public struct PostfixIfConfigExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .postfixIfConfigExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBase: UnexpectedNodesSyntax? = nil,
    base: (some ExprSyntaxProtocol)? = ExprSyntax?.none,
    _ unexpectedBetweenBaseAndConfig: UnexpectedNodesSyntax? = nil,
    config: IfConfigDeclSyntax,
    _ unexpectedAfterConfig: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBase,
      base,
      unexpectedBetweenBaseAndConfig,
      config,
      unexpectedAfterConfig
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBase?.raw,
        base?.raw,
        unexpectedBetweenBaseAndConfig?.raw,
        config.raw,
        unexpectedAfterConfig?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.postfixIfConfigExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBase: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixIfConfigExprSyntax.self)
    }
  }

  public var base: ExprSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixIfConfigExprSyntax.self)
    }
  }

  public var unexpectedBetweenBaseAndConfig: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixIfConfigExprSyntax.self)
    }
  }

  public var config: IfConfigDeclSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(IfConfigDeclSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixIfConfigExprSyntax.self)
    }
  }

  public var unexpectedAfterConfig: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixIfConfigExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBase,
    \Self.base,
    \Self.unexpectedBetweenBaseAndConfig,
    \Self.config,
    \Self.unexpectedAfterConfig
  ])
}

// MARK: - PostfixOperatorExprSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `operator`: `<postfixOperator>`
public struct PostfixOperatorExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .postfixOperatorExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndOperator: UnexpectedNodesSyntax? = nil,
    operator: TokenSyntax,
    _ unexpectedAfterOperator: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndOperator,
      `operator`,
      unexpectedAfterOperator
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndOperator?.raw,
        `operator`.raw,
        unexpectedAfterOperator?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.postfixOperatorExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixOperatorExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixOperatorExprSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixOperatorExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<postfixOperator>`.
  public var `operator`: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixOperatorExprSyntax.self)
    }
  }

  public var unexpectedAfterOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PostfixOperatorExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndOperator,
    \Self.operator,
    \Self.unexpectedAfterOperator
  ])
}

// MARK: - PoundSourceLocationArgumentsSyntax

/// ### Children
/// 
///  - `fileLabel`: `file`
///  - `fileColon`: `:`
///  - `fileName`: ``SimpleStringLiteralExprSyntax``
///  - `comma`: `,`
///  - `lineLabel`: `line`
///  - `lineColon`: `:`
///  - `lineNumber`: `<integerLiteral>`
///
/// ### Contained in
/// 
///  - ``PoundSourceLocationSyntax``.``PoundSourceLocationSyntax/arguments``
public struct PoundSourceLocationArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .poundSourceLocationArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeFileLabel: UnexpectedNodesSyntax? = nil,
    fileLabel: TokenSyntax = .keyword(.file),
    _ unexpectedBetweenFileLabelAndFileColon: UnexpectedNodesSyntax? = nil,
    fileColon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenFileColonAndFileName: UnexpectedNodesSyntax? = nil,
    fileName: SimpleStringLiteralExprSyntax,
    _ unexpectedBetweenFileNameAndComma: UnexpectedNodesSyntax? = nil,
    comma: TokenSyntax = .commaToken(),
    _ unexpectedBetweenCommaAndLineLabel: UnexpectedNodesSyntax? = nil,
    lineLabel: TokenSyntax = .keyword(.line),
    _ unexpectedBetweenLineLabelAndLineColon: UnexpectedNodesSyntax? = nil,
    lineColon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenLineColonAndLineNumber: UnexpectedNodesSyntax? = nil,
    lineNumber: TokenSyntax,
    _ unexpectedAfterLineNumber: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeFileLabel,
      fileLabel,
      unexpectedBetweenFileLabelAndFileColon,
      fileColon,
      unexpectedBetweenFileColonAndFileName,
      fileName,
      unexpectedBetweenFileNameAndComma,
      comma,
      unexpectedBetweenCommaAndLineLabel,
      lineLabel,
      unexpectedBetweenLineLabelAndLineColon,
      lineColon,
      unexpectedBetweenLineColonAndLineNumber,
      lineNumber,
      unexpectedAfterLineNumber
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeFileLabel?.raw,
        fileLabel.raw,
        unexpectedBetweenFileLabelAndFileColon?.raw,
        fileColon.raw,
        unexpectedBetweenFileColonAndFileName?.raw,
        fileName.raw,
        unexpectedBetweenFileNameAndComma?.raw,
        comma.raw,
        unexpectedBetweenCommaAndLineLabel?.raw,
        lineLabel.raw,
        unexpectedBetweenLineLabelAndLineColon?.raw,
        lineColon.raw,
        unexpectedBetweenLineColonAndLineNumber?.raw,
        lineNumber.raw,
        unexpectedAfterLineNumber?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.poundSourceLocationArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeFileLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `file`.
  public var fileLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenFileLabelAndFileColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var fileColon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenFileColonAndFileName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var fileName: SimpleStringLiteralExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(SimpleStringLiteralExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenFileNameAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var comma: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenCommaAndLineLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `line`.
  public var lineLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenLineLabelAndLineColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var lineColon: TokenSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenLineColonAndLineNumber: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<integerLiteral>`.
  public var lineNumber: TokenSyntax {
    get {
      return Syntax(self).child(at: 13)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterLineNumber: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeFileLabel,
    \Self.fileLabel,
    \Self.unexpectedBetweenFileLabelAndFileColon,
    \Self.fileColon,
    \Self.unexpectedBetweenFileColonAndFileName,
    \Self.fileName,
    \Self.unexpectedBetweenFileNameAndComma,
    \Self.comma,
    \Self.unexpectedBetweenCommaAndLineLabel,
    \Self.lineLabel,
    \Self.unexpectedBetweenLineLabelAndLineColon,
    \Self.lineColon,
    \Self.unexpectedBetweenLineColonAndLineNumber,
    \Self.lineNumber,
    \Self.unexpectedAfterLineNumber
  ])
}

// MARK: - PoundSourceLocationSyntax

/// ### Children
/// 
///  - `poundSourceLocation`: `#sourceLocation`
///  - `leftParen`: `(`
///  - `arguments`: ``PoundSourceLocationArgumentsSyntax``?
///  - `rightParen`: `)`
public struct PoundSourceLocationSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .poundSourceLocation else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePoundSourceLocation: UnexpectedNodesSyntax? = nil,
    poundSourceLocation: TokenSyntax = .poundSourceLocationToken(),
    _ unexpectedBetweenPoundSourceLocationAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: PoundSourceLocationArgumentsSyntax? = nil,
    _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePoundSourceLocation,
      poundSourceLocation,
      unexpectedBetweenPoundSourceLocationAndLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePoundSourceLocation?.raw,
        poundSourceLocation.raw,
        unexpectedBetweenPoundSourceLocationAndLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndArguments?.raw,
        arguments?.raw,
        unexpectedBetweenArgumentsAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.poundSourceLocation,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePoundSourceLocation: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `#sourceLocation`.
  public var poundSourceLocation: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  public var unexpectedBetweenPoundSourceLocationAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  public var arguments: PoundSourceLocationArgumentsSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(PoundSourceLocationArgumentsSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PoundSourceLocationSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePoundSourceLocation,
    \Self.poundSourceLocation,
    \Self.unexpectedBetweenPoundSourceLocationAndLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - PrecedenceGroupAssignmentSyntax

/// Specifies the precedence of an operator when used in an operation that includes optional chaining.
///
/// ### Children
/// 
///  - `assignmentLabel`: `assignment`
///  - `colon`: `:`
///  - `value`: (`true` | `false`)
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupAttributeListSyntax``
public struct PrecedenceGroupAssignmentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupAssignment else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - value: When true, an operator in the corresponding precedence group uses the same grouping rules during optional chaining as the assignment operators from the standard library. Otherwise, operators in the precedence group follows the same optional chaining rules as operators that don't perform assignment.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAssignmentLabel: UnexpectedNodesSyntax? = nil,
    assignmentLabel: TokenSyntax = .keyword(.assignment),
    _ unexpectedBetweenAssignmentLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
    value: TokenSyntax,
    _ unexpectedAfterValue: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAssignmentLabel,
      assignmentLabel,
      unexpectedBetweenAssignmentLabelAndColon,
      colon,
      unexpectedBetweenColonAndValue,
      value,
      unexpectedAfterValue
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAssignmentLabel?.raw,
        assignmentLabel.raw,
        unexpectedBetweenAssignmentLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndValue?.raw,
        value.raw,
        unexpectedAfterValue?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.precedenceGroupAssignment,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAssignmentLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `assignment`.
  public var assignmentLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  public var unexpectedBetweenAssignmentLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  /// When true, an operator in the corresponding precedence group uses the same grouping rules during optional chaining as the assignment operators from the standard library. Otherwise, operators in the precedence group follows the same optional chaining rules as operators that don't perform assignment.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `true`
  ///  - `false`
  public var value: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  public var unexpectedAfterValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssignmentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAssignmentLabel,
    \Self.assignmentLabel,
    \Self.unexpectedBetweenAssignmentLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndValue,
    \Self.value,
    \Self.unexpectedAfterValue
  ])
}

// MARK: - PrecedenceGroupAssociativitySyntax

/// Specifies how a sequence of operators with the same precedence level are grouped together in the absence of grouping parentheses.
///
/// ### Children
/// 
///  - `associativityLabel`: `associativity`
///  - `colon`: `:`
///  - `value`: (`left` | `right` | `none`)
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupAttributeListSyntax``
public struct PrecedenceGroupAssociativitySyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupAssociativity else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - value: Operators that are `left`-associative group left-to-right. Operators that are `right`-associative group right-to-left. Operators that are specified with an associativity of `none` don't associate at all
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAssociativityLabel: UnexpectedNodesSyntax? = nil,
    associativityLabel: TokenSyntax = .keyword(.associativity),
    _ unexpectedBetweenAssociativityLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
    value: TokenSyntax,
    _ unexpectedAfterValue: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAssociativityLabel,
      associativityLabel,
      unexpectedBetweenAssociativityLabelAndColon,
      colon,
      unexpectedBetweenColonAndValue,
      value,
      unexpectedAfterValue
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAssociativityLabel?.raw,
        associativityLabel.raw,
        unexpectedBetweenAssociativityLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndValue?.raw,
        value.raw,
        unexpectedAfterValue?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.precedenceGroupAssociativity,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAssociativityLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `associativity`.
  public var associativityLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  public var unexpectedBetweenAssociativityLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  /// Operators that are `left`-associative group left-to-right. Operators that are `right`-associative group right-to-left. Operators that are specified with an associativity of `none` don't associate at all
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `left`
  ///  - `right`
  ///  - `none`
  public var value: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  public var unexpectedAfterValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupAssociativitySyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAssociativityLabel,
    \Self.associativityLabel,
    \Self.unexpectedBetweenAssociativityLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndValue,
    \Self.value,
    \Self.unexpectedAfterValue
  ])
}

// MARK: - PrecedenceGroupDeclSyntax

/// A Swift `precedencegroup` declaration.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `precedencegroupKeyword`: `precedencegroup`
///  - `name`: `<identifier>`
///  - `leftBrace`: `{`
///  - `groupAttributes`: ``PrecedenceGroupAttributeListSyntax``
///  - `rightBrace`: `}`
public struct PrecedenceGroupDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: The attributes applied to the 'precedencegroup' declaration.
  ///   - modifiers: The declaration modifiers applied to the 'precedencegroup' declaration.
  ///   - name: The name of this precedence group.
  ///   - groupAttributes: The characteristics of this precedence group.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndPrecedencegroupKeyword: UnexpectedNodesSyntax? = nil,
    precedencegroupKeyword: TokenSyntax = .keyword(.precedencegroup),
    _ unexpectedBetweenPrecedencegroupKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndLeftBrace: UnexpectedNodesSyntax? = nil,
    leftBrace: TokenSyntax = .leftBraceToken(),
    _ unexpectedBetweenLeftBraceAndGroupAttributes: UnexpectedNodesSyntax? = nil,
    groupAttributes: PrecedenceGroupAttributeListSyntax,
    _ unexpectedBetweenGroupAttributesAndRightBrace: UnexpectedNodesSyntax? = nil,
    rightBrace: TokenSyntax = .rightBraceToken(),
    _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndPrecedencegroupKeyword,
      precedencegroupKeyword,
      unexpectedBetweenPrecedencegroupKeywordAndName,
      name,
      unexpectedBetweenNameAndLeftBrace,
      leftBrace,
      unexpectedBetweenLeftBraceAndGroupAttributes,
      groupAttributes,
      unexpectedBetweenGroupAttributesAndRightBrace,
      rightBrace,
      unexpectedAfterRightBrace
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndPrecedencegroupKeyword?.raw,
        precedencegroupKeyword.raw,
        unexpectedBetweenPrecedencegroupKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndLeftBrace?.raw,
        leftBrace.raw,
        unexpectedBetweenLeftBraceAndGroupAttributes?.raw,
        groupAttributes.raw,
        unexpectedBetweenGroupAttributesAndRightBrace?.raw,
        rightBrace.raw,
        unexpectedAfterRightBrace?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.precedenceGroupDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// The attributes applied to the 'precedencegroup' declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> PrecedenceGroupDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(PrecedenceGroupDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// The declaration modifiers applied to the 'precedencegroup' declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> PrecedenceGroupDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(PrecedenceGroupDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndPrecedencegroupKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `precedencegroup`.
  public var precedencegroupKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  public var unexpectedBetweenPrecedencegroupKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// The name of this precedence group.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `{`.
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  public var unexpectedBetweenLeftBraceAndGroupAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// The characteristics of this precedence group.
  public var groupAttributes: PrecedenceGroupAttributeListSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(PrecedenceGroupAttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `groupAttributes`
  /// collection.
  ///
  /// - param element: The new `GroupAttribute` to add to the node's
  ///                  `groupAttributes` collection.
  /// - returns: A copy of the receiver with the provided `GroupAttribute`
  ///            appended to its `groupAttributes` collection.
  @available(*, deprecated, message: "Use node.groupAttributes.append(newElement) instead")
  public func addGroupAttribute(_ element: Syntax) -> PrecedenceGroupDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[11] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.precedenceGroupAttributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 11,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(PrecedenceGroupDeclSyntax.self)
  }

  public var unexpectedBetweenGroupAttributesAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `}`.
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 13)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndPrecedencegroupKeyword,
    \Self.precedencegroupKeyword,
    \Self.unexpectedBetweenPrecedencegroupKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndLeftBrace,
    \Self.leftBrace,
    \Self.unexpectedBetweenLeftBraceAndGroupAttributes,
    \Self.groupAttributes,
    \Self.unexpectedBetweenGroupAttributesAndRightBrace,
    \Self.rightBrace,
    \Self.unexpectedAfterRightBrace
  ])
}

// MARK: - PrecedenceGroupNameSyntax

/// ### Children
/// 
///  - `name`: `<identifier>`
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupNameListSyntax``
public struct PrecedenceGroupNameSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupName else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.precedenceGroupName,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupNameSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupNameSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupNameSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupNameSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupNameSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - PrecedenceGroupRelationSyntax

/// Specify the new precedence group's relation to existing precedence groups.
///
/// ### Children
/// 
///  - `higherThanOrLowerThanLabel`: (`higherThan` | `lowerThan`)
///  - `colon`: `:`
///  - `precedenceGroups`: ``PrecedenceGroupNameListSyntax``
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupAttributeListSyntax``
public struct PrecedenceGroupRelationSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupRelation else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - higherThanOrLowerThanLabel: The relation to specified other precedence groups.
  ///   - precedenceGroups: The name of other precedence group to which this precedence group relates.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeHigherThanOrLowerThanLabel: UnexpectedNodesSyntax? = nil,
    higherThanOrLowerThanLabel: TokenSyntax,
    _ unexpectedBetweenHigherThanOrLowerThanLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndPrecedenceGroups: UnexpectedNodesSyntax? = nil,
    precedenceGroups: PrecedenceGroupNameListSyntax,
    _ unexpectedAfterPrecedenceGroups: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeHigherThanOrLowerThanLabel,
      higherThanOrLowerThanLabel,
      unexpectedBetweenHigherThanOrLowerThanLabelAndColon,
      colon,
      unexpectedBetweenColonAndPrecedenceGroups,
      precedenceGroups,
      unexpectedAfterPrecedenceGroups
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeHigherThanOrLowerThanLabel?.raw,
        higherThanOrLowerThanLabel.raw,
        unexpectedBetweenHigherThanOrLowerThanLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndPrecedenceGroups?.raw,
        precedenceGroups.raw,
        unexpectedAfterPrecedenceGroups?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.precedenceGroupRelation,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeHigherThanOrLowerThanLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  /// The relation to specified other precedence groups.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `higherThan`
  ///  - `lowerThan`
  public var higherThanOrLowerThanLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  public var unexpectedBetweenHigherThanOrLowerThanLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndPrecedenceGroups: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  /// The name of other precedence group to which this precedence group relates.
  public var precedenceGroups: PrecedenceGroupNameListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(PrecedenceGroupNameListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `precedenceGroups`
  /// collection.
  ///
  /// - param element: The new `OtherName` to add to the node's
  ///                  `precedenceGroups` collection.
  /// - returns: A copy of the receiver with the provided `OtherName`
  ///            appended to its `precedenceGroups` collection.
  @available(*, deprecated, message: "Use node.precedenceGroups.append(newElement) instead")
  public func addOtherName(_ element: PrecedenceGroupNameSyntax) -> PrecedenceGroupRelationSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.precedenceGroupNameList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(PrecedenceGroupRelationSyntax.self)
  }

  public var unexpectedAfterPrecedenceGroups: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrecedenceGroupRelationSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeHigherThanOrLowerThanLabel,
    \Self.higherThanOrLowerThanLabel,
    \Self.unexpectedBetweenHigherThanOrLowerThanLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndPrecedenceGroups,
    \Self.precedenceGroups,
    \Self.unexpectedAfterPrecedenceGroups
  ])
}

// MARK: - PrefixOperatorExprSyntax

/// A prefix operator applied to a value.
/// 
/// ### Examples
/// 
/// ```swift
/// -x
/// ```
/// 
/// ```swift
/// !true
/// ```
///
/// ### Children
/// 
///  - `operator`: `<prefixOperator>`
///  - `expression`: ``ExprSyntax``
public struct PrefixOperatorExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .prefixOperatorExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeOperator: UnexpectedNodesSyntax? = nil,
    operator: TokenSyntax,
    _ unexpectedBetweenOperatorAndExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeOperator,
      `operator`,
      unexpectedBetweenOperatorAndExpression,
      expression,
      unexpectedAfterExpression
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeOperator?.raw,
        `operator`.raw,
        unexpectedBetweenOperatorAndExpression?.raw,
        expression.raw,
        unexpectedAfterExpression?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.prefixOperatorExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrefixOperatorExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<prefixOperator>`.
  public var `operator`: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrefixOperatorExprSyntax.self)
    }
  }

  public var unexpectedBetweenOperatorAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrefixOperatorExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrefixOperatorExprSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrefixOperatorExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeOperator,
    \Self.operator,
    \Self.unexpectedBetweenOperatorAndExpression,
    \Self.expression,
    \Self.unexpectedAfterExpression
  ])
}

// MARK: - PrimaryAssociatedTypeClauseSyntax

/// ### Children
/// 
///  - `leftAngle`: `<`
///  - `primaryAssociatedTypes`: ``PrimaryAssociatedTypeListSyntax``
///  - `rightAngle`: `>`
///
/// ### Contained in
/// 
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/primaryAssociatedTypeClause``
public struct PrimaryAssociatedTypeClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .primaryAssociatedTypeClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftAngle: UnexpectedNodesSyntax? = nil,
    leftAngle: TokenSyntax = .leftAngleToken(),
    _ unexpectedBetweenLeftAngleAndPrimaryAssociatedTypes: UnexpectedNodesSyntax? = nil,
    primaryAssociatedTypes: PrimaryAssociatedTypeListSyntax,
    _ unexpectedBetweenPrimaryAssociatedTypesAndRightAngle: UnexpectedNodesSyntax? = nil,
    rightAngle: TokenSyntax = .rightAngleToken(),
    _ unexpectedAfterRightAngle: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftAngle,
      leftAngle,
      unexpectedBetweenLeftAngleAndPrimaryAssociatedTypes,
      primaryAssociatedTypes,
      unexpectedBetweenPrimaryAssociatedTypesAndRightAngle,
      rightAngle,
      unexpectedAfterRightAngle
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftAngle?.raw,
        leftAngle.raw,
        unexpectedBetweenLeftAngleAndPrimaryAssociatedTypes?.raw,
        primaryAssociatedTypes.raw,
        unexpectedBetweenPrimaryAssociatedTypesAndRightAngle?.raw,
        rightAngle.raw,
        unexpectedAfterRightAngle?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.primaryAssociatedTypeClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<`.
  public var leftAngle: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  public var unexpectedBetweenLeftAngleAndPrimaryAssociatedTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  public var primaryAssociatedTypes: PrimaryAssociatedTypeListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(PrimaryAssociatedTypeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `primaryAssociatedTypes`
  /// collection.
  ///
  /// - param element: The new `PrimaryAssociatedType` to add to the node's
  ///                  `primaryAssociatedTypes` collection.
  /// - returns: A copy of the receiver with the provided `PrimaryAssociatedType`
  ///            appended to its `primaryAssociatedTypes` collection.
  @available(*, deprecated, message: "Use node.primaryAssociatedTypes.append(newElement) instead")
  public func addPrimaryAssociatedType(_ element: PrimaryAssociatedTypeSyntax) -> PrimaryAssociatedTypeClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.primaryAssociatedTypeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(PrimaryAssociatedTypeClauseSyntax.self)
  }

  public var unexpectedBetweenPrimaryAssociatedTypesAndRightAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `>`.
  public var rightAngle: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  public var unexpectedAfterRightAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftAngle,
    \Self.leftAngle,
    \Self.unexpectedBetweenLeftAngleAndPrimaryAssociatedTypes,
    \Self.primaryAssociatedTypes,
    \Self.unexpectedBetweenPrimaryAssociatedTypesAndRightAngle,
    \Self.rightAngle,
    \Self.unexpectedAfterRightAngle
  ])
}

// MARK: - PrimaryAssociatedTypeSyntax

/// ### Children
/// 
///  - `name`: `<identifier>`
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``PrimaryAssociatedTypeListSyntax``
public struct PrimaryAssociatedTypeSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .primaryAssociatedType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.primaryAssociatedType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(PrimaryAssociatedTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - ProtocolDeclSyntax

/// A `protocol` declaration
/// 
/// An example of a protocol declaration is
/// 
/// ```swift
/// protocol Example {
///   var isValid: Bool { get }
/// }
/// ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `protocolKeyword`: `protocol`
///  - `name`: `<identifier>`
///  - `primaryAssociatedTypeClause`: ``PrimaryAssociatedTypeClauseSyntax``?
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct ProtocolDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .protocolDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes attached to the protocol declaration, such as an `@available` attribute.
  ///   - modifiers: Modifiers attached to the protocol declaration, such as `public`.
  ///   - protocolKeyword: The `protocol` keyword for this declaration.
  ///   - name: The name of the protocol.
  ///   - primaryAssociatedTypeClause: The primary associated type for the protocol.
  ///   - inheritanceClause: The inheritance clause describing one or more conformances for this protocol declaration.
  ///   - genericWhereClause: The `where` clause that applies to the generic parameters of this protocol declaration.
  ///   - memberBlock: The members of the protocol declaration.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndProtocolKeyword: UnexpectedNodesSyntax? = nil,
    protocolKeyword: TokenSyntax = .keyword(.protocol),
    _ unexpectedBetweenProtocolKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndPrimaryAssociatedTypeClause: UnexpectedNodesSyntax? = nil,
    primaryAssociatedTypeClause: PrimaryAssociatedTypeClauseSyntax? = nil,
    _ unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    memberBlock: MemberBlockSyntax,
    _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndProtocolKeyword,
      protocolKeyword,
      unexpectedBetweenProtocolKeywordAndName,
      name,
      unexpectedBetweenNameAndPrimaryAssociatedTypeClause,
      primaryAssociatedTypeClause,
      unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause,
      inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock,
      unexpectedAfterMemberBlock
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndProtocolKeyword?.raw,
        protocolKeyword.raw,
        unexpectedBetweenProtocolKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndPrimaryAssociatedTypeClause?.raw,
        primaryAssociatedTypeClause?.raw,
        unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause?.raw,
        inheritanceClause?.raw,
        unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw,
        memberBlock.raw,
        unexpectedAfterMemberBlock?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.protocolDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// Attributes attached to the protocol declaration, such as an `@available` attribute.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ProtocolDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ProtocolDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// Modifiers attached to the protocol declaration, such as `public`.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ProtocolDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ProtocolDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndProtocolKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// The `protocol` keyword for this declaration.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `protocol`.
  public var protocolKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public var unexpectedBetweenProtocolKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// The name of the protocol.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndPrimaryAssociatedTypeClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// The primary associated type for the protocol.
  public var primaryAssociatedTypeClause: PrimaryAssociatedTypeClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(PrimaryAssociatedTypeClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public var unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// The inheritance clause describing one or more conformances for this protocol declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// The `where` clause that applies to the generic parameters of this protocol declaration.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  /// The members of the protocol declaration.
  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ProtocolDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndProtocolKeyword,
    \Self.protocolKeyword,
    \Self.unexpectedBetweenProtocolKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndPrimaryAssociatedTypeClause,
    \Self.primaryAssociatedTypeClause,
    \Self.unexpectedBetweenPrimaryAssociatedTypeClauseAndInheritanceClause,
    \Self.inheritanceClause,
    \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock,
    \Self.memberBlock,
    \Self.unexpectedAfterMemberBlock
  ])
}
