//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

/// ### Children
/// 
/// ``AccessorDeclSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AccessorBlockSyntax``.``AccessorBlockSyntax/accessors``
public struct AccessorDeclListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = AccessorDeclSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .accessorDeclList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.accessorDeclList
}

/// ### Children
/// 
/// ``ArrayElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ArrayExprSyntax``.``ArrayExprSyntax/elements``
public struct ArrayElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ArrayElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .arrayElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.arrayElementList
}

/// A list of attributes that can be attached to a declaration.
/// 
/// An element in this collection can either be an attribute itself or an ``IfConfigDeclSyntax``
/// that contains attributes. This is because attributes can be added conditional on compilcation
/// conditions, for example.
/// 
/// ```swift
/// #if !DISABLE_DEPRECATIONS
/// @available(*, deprecated)
/// #endif
/// func myFunction() {}
/// ```
///
/// ### Children
/// 
/// (``AttributeSyntax`` | ``IfConfigDeclSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/attributes``
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/attributes``
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/attributes``
///  - ``AttributedTypeSyntax``.``AttributedTypeSyntax/attributes``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/attributes``
///  - ``ClosureParameterSyntax``.``ClosureParameterSyntax/attributes``
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/attributes``
///  - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/attributes``
///  - ``EditorPlaceholderDeclSyntax``.``EditorPlaceholderDeclSyntax/attributes``
///  - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/attributes``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/attributes``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/attributes``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/attributes``
///  - ``FunctionParameterSyntax``.``FunctionParameterSyntax/attributes``
///  - ``GenericParameterSyntax``.``GenericParameterSyntax/attributes``
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``ImportDeclSyntax``.``ImportDeclSyntax/attributes``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/attributes``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/attributes``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/attributes``
///  - ``MissingDeclSyntax``.``MissingDeclSyntax/attributes``
///  - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/attributes``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/attributes``
///  - ``StructDeclSyntax``.``StructDeclSyntax/attributes``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/attributes``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/attributes``
///  - ``VariableDeclSyntax``.``VariableDeclSyntax/attributes``
public struct AttributeListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    /// An `@` attribute.
    case attribute(AttributeSyntax)
    case ifConfigDecl(IfConfigDeclSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .attribute(let node):
        return node._syntaxNode
      case .ifConfigDecl(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: AttributeSyntax) {
      self = .attribute(node)
    }

    public init(_ node: IfConfigDeclSyntax) {
      self = .ifConfigDecl(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(AttributeSyntax.self) {
        self = .attribute(node)
      } else if let node = node.as(IfConfigDeclSyntax.self) {
        self = .ifConfigDecl(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(AttributeSyntax.self), .node(IfConfigDeclSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``AttributeSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: AttributeSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``AttributeSyntax``.
    ///
    /// - Returns: An instance of ``AttributeSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: AttributeSyntax.Type) -> AttributeSyntax? {
      return AttributeSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``AttributeSyntax``.
    ///
    /// - Returns: An instance of ``AttributeSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: AttributeSyntax.Type) -> AttributeSyntax {
      return self.as(AttributeSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``IfConfigDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: IfConfigDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``IfConfigDeclSyntax``.
    ///
    /// - Returns: An instance of ``IfConfigDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: IfConfigDeclSyntax.Type) -> IfConfigDeclSyntax? {
      return IfConfigDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``IfConfigDeclSyntax``.
    ///
    /// - Returns: An instance of ``IfConfigDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: IfConfigDeclSyntax.Type) -> IfConfigDeclSyntax {
      return self.as(IfConfigDeclSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .attributeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.attributeList
}

/// ### Children
/// 
/// ``AvailabilityArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
///  - ``AvailabilityConditionSyntax``.``AvailabilityConditionSyntax/availabilityArguments``
///  - ``SpecializeAvailabilityArgumentSyntax``.``SpecializeAvailabilityArgumentSyntax/availabilityArguments``
public struct AvailabilityArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = AvailabilityArgumentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .availabilityArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.availabilityArgumentList
}

/// ### Children
/// 
/// ``CatchClauseSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DoStmtSyntax``.``DoStmtSyntax/catchClauses``
public struct CatchClauseListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CatchClauseSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .catchClauseList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.catchClauseList
}

/// ### Children
/// 
/// ``CatchItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``CatchClauseSyntax``.``CatchClauseSyntax/catchItems``
public struct CatchItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CatchItemSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .catchItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.catchItemList
}

/// ### Children
/// 
/// ``ClosureCaptureSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ClosureCaptureClauseSyntax``.``ClosureCaptureClauseSyntax/items``
public struct ClosureCaptureListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ClosureCaptureSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureCaptureList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.closureCaptureList
}

/// ### Children
/// 
/// ``ClosureParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ClosureParameterClauseSyntax``.``ClosureParameterClauseSyntax/parameters``
public struct ClosureParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ClosureParameterSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.closureParameterList
}

/// A list of closure parameters that are not parenthesized and don't have type annotations.
/// 
/// If the closure parameters are parenthesized, they can also carry type annotations. 
/// In that case, the closure parameters are represented by ``ClosureParameterListSyntax``.
/// 
/// ### Examples
/// 
/// ```
/// let closure = { a, b in
///   return a + b
/// }
/// ```
///
/// ### Children
/// 
/// ``ClosureShorthandParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/parameterClause``
public struct ClosureShorthandParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ClosureShorthandParameterSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureShorthandParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.closureShorthandParameterList
}

/// ### Children
/// 
/// ``CodeBlockItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AccessorBlockSyntax``.``AccessorBlockSyntax/accessors``
///  - ``ClosureExprSyntax``.``ClosureExprSyntax/statements``
///  - ``CodeBlockSyntax``.``CodeBlockSyntax/statements``
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``SourceFileSyntax``.``SourceFileSyntax/statements``
///  - ``SwitchCaseSyntax``.``SwitchCaseSyntax/statements``
public struct CodeBlockItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CodeBlockItemSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .codeBlockItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.codeBlockItemList
}

/// ### Children
/// 
/// ``CompositionTypeElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``CompositionTypeSyntax``.``CompositionTypeSyntax/elements``
public struct CompositionTypeElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CompositionTypeElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .compositionTypeElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.compositionTypeElementList
}

/// ### Children
/// 
/// ``ConditionElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GuardStmtSyntax``.``GuardStmtSyntax/conditions``
///  - ``IfExprSyntax``.``IfExprSyntax/conditions``
///  - ``WhileStmtSyntax``.``WhileStmtSyntax/conditions``
public struct ConditionElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ConditionElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .conditionElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.conditionElementList
}

/// ### Children
/// 
/// ``DeclModifierSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/modifiers``
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/modifiers``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/modifiers``
///  - ``ClosureParameterSyntax``.``ClosureParameterSyntax/modifiers``
///  - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/modifiers``
///  - ``EditorPlaceholderDeclSyntax``.``EditorPlaceholderDeclSyntax/modifiers``
///  - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/modifiers``
///  - ``EnumCaseParameterSyntax``.``EnumCaseParameterSyntax/modifiers``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/modifiers``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/modifiers``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/modifiers``
///  - ``FunctionParameterSyntax``.``FunctionParameterSyntax/modifiers``
///  - ``ImportDeclSyntax``.``ImportDeclSyntax/modifiers``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/modifiers``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/modifiers``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/modifiers``
///  - ``MissingDeclSyntax``.``MissingDeclSyntax/modifiers``
///  - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/modifiers``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/modifiers``
///  - ``StructDeclSyntax``.``StructDeclSyntax/modifiers``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/modifiers``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/modifiers``
///  - ``VariableDeclSyntax``.``VariableDeclSyntax/modifiers``
public struct DeclModifierListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DeclModifierSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .declModifierList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.declModifierList
}

/// ### Children
/// 
/// ``DeclNameArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DeclNameArgumentsSyntax``.``DeclNameArgumentsSyntax/arguments``
public struct DeclNameArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DeclNameArgumentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .declNameArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.declNameArgumentList
}

/// ### Children
/// 
/// ``DesignatedTypeSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``OperatorPrecedenceAndTypesSyntax``.``OperatorPrecedenceAndTypesSyntax/designatedTypes``
public struct DesignatedTypeListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DesignatedTypeSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .designatedTypeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.designatedTypeList
}

/// ### Children
/// 
/// ``DictionaryElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DictionaryExprSyntax``.``DictionaryExprSyntax/content``
public struct DictionaryElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DictionaryElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .dictionaryElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.dictionaryElementList
}

/// ### Children
/// 
/// ``DifferentiabilityArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DifferentiabilityArgumentsSyntax``.``DifferentiabilityArgumentsSyntax/arguments``
public struct DifferentiabilityArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DifferentiabilityArgumentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .differentiabilityArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.differentiabilityArgumentList
}

/// The arguments of the '@_documentation' attribute
///
/// ### Children
/// 
/// ``DocumentationAttributeArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct DocumentationAttributeArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DocumentationAttributeArgumentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .documentationAttributeArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.documentationAttributeArgumentList
}

/// The arguments of the '@_effects' attribute. These will be parsed during the SIL stage.
///
/// ### Children
/// 
/// ``TokenSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct EffectsAttributeArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = TokenSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .effectsAttributeArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.effectsAttributeArgumentList
}

/// A collection of 0 or more ``EnumCaseElementSyntax``s.
///
/// ### Children
/// 
/// ``EnumCaseElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/elements``
public struct EnumCaseElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = EnumCaseElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.enumCaseElementList
}

/// ### Children
/// 
/// ``EnumCaseParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``EnumCaseParameterClauseSyntax``.``EnumCaseParameterClauseSyntax/parameters``
public struct EnumCaseParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = EnumCaseParameterSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.enumCaseParameterList
}

/// A list of expressions connected by operators. This list is contained by a ``SequenceExprSyntax``.
///
/// ### Children
/// 
/// ``ExprSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``SequenceExprSyntax``.``SequenceExprSyntax/elements``
public struct ExprListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ExprSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .exprList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.exprList
}

/// A list of function parameters that are type annotated and a label.
/// The function parameters are represented by `FunctionParameterListSyntax`.
/// 
/// ### Example
/// 
/// ```swift
/// func foo(bar: Int, baz: Int) {
/// 
/// }
/// ```
///
/// ### Children
/// 
/// ``FunctionParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``FunctionParameterClauseSyntax``.``FunctionParameterClauseSyntax/parameters``
public struct FunctionParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = FunctionParameterSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .functionParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.functionParameterList
}

/// ### Children
/// 
/// ``GenericArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GenericArgumentClauseSyntax``.``GenericArgumentClauseSyntax/arguments``
public struct GenericArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = GenericArgumentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .genericArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.genericArgumentList
}

/// ### Children
/// 
/// ``GenericParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GenericParameterClauseSyntax``.``GenericParameterClauseSyntax/parameters``
public struct GenericParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = GenericParameterSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .genericParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.genericParameterList
}

/// ### Children
/// 
/// ``GenericRequirementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GenericWhereClauseSyntax``.``GenericWhereClauseSyntax/requirements``
public struct GenericRequirementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = GenericRequirementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .genericRequirementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.genericRequirementList
}

/// ### Children
/// 
/// ``IfConfigClauseSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``IfConfigDeclSyntax``.``IfConfigDeclSyntax/clauses``
public struct IfConfigClauseListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = IfConfigClauseSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .ifConfigClauseList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.ifConfigClauseList
}

/// ### Children
/// 
/// ``ImportPathComponentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ImportDeclSyntax``.``ImportDeclSyntax/path``
public struct ImportPathComponentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ImportPathComponentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .importPathComponentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.importPathComponentList
}

/// ### Children
/// 
/// ``InheritedTypeSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``InheritanceClauseSyntax``.``InheritanceClauseSyntax/inheritedTypes``
public struct InheritedTypeListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = InheritedTypeSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .inheritedTypeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.inheritedTypeList
}

/// The components of a key path
///
/// ### Children
/// 
/// ``KeyPathComponentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``KeyPathExprSyntax``.``KeyPathExprSyntax/components``
public struct KeyPathComponentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = KeyPathComponentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathComponentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.keyPathComponentList
}

/// ### Children
/// 
/// ``LabeledExprSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
///  - ``ExpressionSegmentSyntax``.``ExpressionSegmentSyntax/expressions``
///  - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/arguments``
///  - ``KeyPathSubscriptComponentSyntax``.``KeyPathSubscriptComponentSyntax/arguments``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/arguments``
///  - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/arguments``
///  - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/arguments``
///  - ``TupleExprSyntax``.``TupleExprSyntax/elements``
public struct LabeledExprListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = LabeledExprSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .labeledExprList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.labeledExprList
}

/// - Note: Requires experimental feature `nonescapableTypes`.
///
/// ### Children
/// 
/// `LifetimeSpecifierArgumentSyntax` `*`
///
/// ### Contained in
/// 
///  - `LifetimeTypeSpecifierSyntax`.`LifetimeTypeSpecifierSyntax/arguments`
@_spi(ExperimentalLanguageFeatures)
public struct LifetimeSpecifierArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = LifetimeSpecifierArgumentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .lifetimeSpecifierArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.lifetimeSpecifierArgumentList
}

/// ### Children
/// 
/// ``MemberBlockItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``MemberBlockSyntax``.``MemberBlockSyntax/members``
public struct MemberBlockItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = MemberBlockItemSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .memberBlockItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.memberBlockItemList
}

/// ### Children
/// 
/// ``MultipleTrailingClosureElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/additionalTrailingClosures``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/additionalTrailingClosures``
///  - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/additionalTrailingClosures``
///  - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/additionalTrailingClosures``
public struct MultipleTrailingClosureElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = MultipleTrailingClosureElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .multipleTrailingClosureElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.multipleTrailingClosureElementList
}

/// ### Children
/// 
/// ``ObjCSelectorPieceSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct ObjCSelectorPieceListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ObjCSelectorPieceSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .objCSelectorPieceList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.objCSelectorPieceList
}

/// ### Children
/// 
/// ``PatternBindingSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``VariableDeclSyntax``.``VariableDeclSyntax/bindings``
public struct PatternBindingListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PatternBindingSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .patternBindingList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.patternBindingList
}

/// ### Children
/// 
/// ``PlatformVersionItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``BackDeployedAttributeArgumentsSyntax``.``BackDeployedAttributeArgumentsSyntax/platforms``
///  - ``OriginallyDefinedInAttributeArgumentsSyntax``.``OriginallyDefinedInAttributeArgumentsSyntax/platforms``
public struct PlatformVersionItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PlatformVersionItemSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .platformVersionItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.platformVersionItemList
}

/// ### Children
/// 
/// (``PrecedenceGroupRelationSyntax`` | ``PrecedenceGroupAssignmentSyntax`` | ``PrecedenceGroupAssociativitySyntax``) `*`
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/groupAttributes``
public struct PrecedenceGroupAttributeListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    /// Specify the new precedence group's relation to existing precedence groups.
    case precedenceGroupRelation(PrecedenceGroupRelationSyntax)
    /// Specifies the precedence of an operator when used in an operation that includes optional chaining.
    case precedenceGroupAssignment(PrecedenceGroupAssignmentSyntax)
    /// Specifies how a sequence of operators with the same precedence level are grouped together in the absence of grouping parentheses.
    case precedenceGroupAssociativity(PrecedenceGroupAssociativitySyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .precedenceGroupRelation(let node):
        return node._syntaxNode
      case .precedenceGroupAssignment(let node):
        return node._syntaxNode
      case .precedenceGroupAssociativity(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: PrecedenceGroupRelationSyntax) {
      self = .precedenceGroupRelation(node)
    }

    public init(_ node: PrecedenceGroupAssignmentSyntax) {
      self = .precedenceGroupAssignment(node)
    }

    public init(_ node: PrecedenceGroupAssociativitySyntax) {
      self = .precedenceGroupAssociativity(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(PrecedenceGroupRelationSyntax.self) {
        self = .precedenceGroupRelation(node)
      } else if let node = node.as(PrecedenceGroupAssignmentSyntax.self) {
        self = .precedenceGroupAssignment(node)
      } else if let node = node.as(PrecedenceGroupAssociativitySyntax.self) {
        self = .precedenceGroupAssociativity(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(PrecedenceGroupRelationSyntax.self), .node(PrecedenceGroupAssignmentSyntax.self), .node(PrecedenceGroupAssociativitySyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``PrecedenceGroupRelationSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: PrecedenceGroupRelationSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``PrecedenceGroupRelationSyntax``.
    ///
    /// - Returns: An instance of ``PrecedenceGroupRelationSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: PrecedenceGroupRelationSyntax.Type) -> PrecedenceGroupRelationSyntax? {
      return PrecedenceGroupRelationSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``PrecedenceGroupRelationSyntax``.
    ///
    /// - Returns: An instance of ``PrecedenceGroupRelationSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: PrecedenceGroupRelationSyntax.Type) -> PrecedenceGroupRelationSyntax {
      return self.as(PrecedenceGroupRelationSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``PrecedenceGroupAssignmentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: PrecedenceGroupAssignmentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``PrecedenceGroupAssignmentSyntax``.
    ///
    /// - Returns: An instance of ``PrecedenceGroupAssignmentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: PrecedenceGroupAssignmentSyntax.Type) -> PrecedenceGroupAssignmentSyntax? {
      return PrecedenceGroupAssignmentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``PrecedenceGroupAssignmentSyntax``.
    ///
    /// - Returns: An instance of ``PrecedenceGroupAssignmentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: PrecedenceGroupAssignmentSyntax.Type) -> PrecedenceGroupAssignmentSyntax {
      return self.as(PrecedenceGroupAssignmentSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``PrecedenceGroupAssociativitySyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: PrecedenceGroupAssociativitySyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``PrecedenceGroupAssociativitySyntax``.
    ///
    /// - Returns: An instance of ``PrecedenceGroupAssociativitySyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: PrecedenceGroupAssociativitySyntax.Type) -> PrecedenceGroupAssociativitySyntax? {
      return PrecedenceGroupAssociativitySyntax.init(self)
    }

    /// Force-casts the current syntax node to ``PrecedenceGroupAssociativitySyntax``.
    ///
    /// - Returns: An instance of ``PrecedenceGroupAssociativitySyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: PrecedenceGroupAssociativitySyntax.Type) -> PrecedenceGroupAssociativitySyntax {
      return self.as(PrecedenceGroupAssociativitySyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupAttributeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.precedenceGroupAttributeList
}

/// ### Children
/// 
/// ``PrecedenceGroupNameSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupRelationSyntax``.``PrecedenceGroupRelationSyntax/precedenceGroups``
public struct PrecedenceGroupNameListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PrecedenceGroupNameSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupNameList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.precedenceGroupNameList
}

/// ### Children
/// 
/// ``PrimaryAssociatedTypeSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``PrimaryAssociatedTypeClauseSyntax``.``PrimaryAssociatedTypeClauseSyntax/primaryAssociatedTypes``
public struct PrimaryAssociatedTypeListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PrimaryAssociatedTypeSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .primaryAssociatedTypeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.primaryAssociatedTypeList
}

/// String literal segments that only can contain non string interpolated or extended escaped strings
///
/// ### Children
/// 
/// ``StringSegmentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``SimpleStringLiteralExprSyntax``.``SimpleStringLiteralExprSyntax/segments``
public struct SimpleStringLiteralSegmentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = StringSegmentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .simpleStringLiteralSegmentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.simpleStringLiteralSegmentList
}

/// A collection of arguments for the `@_specialize` attribute
///
/// ### Children
/// 
/// (``LabeledSpecializeArgumentSyntax`` | ``SpecializeAvailabilityArgumentSyntax`` | ``SpecializeTargetFunctionArgumentSyntax`` | ``GenericWhereClauseSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct SpecializeAttributeArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    /// A labeled argument for the `@_specialize` attribute like `exported: true`
    case labeledSpecializeArgument(LabeledSpecializeArgumentSyntax)
    /// The availability argument for the _specialize attribute
    case specializeAvailabilityArgument(SpecializeAvailabilityArgumentSyntax)
    /// A labeled argument for the `@_specialize` attribute with a function decl value like `target: myFunc(_:)`
    case specializeTargetFunctionArgument(SpecializeTargetFunctionArgumentSyntax)
    /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
    case genericWhereClause(GenericWhereClauseSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .labeledSpecializeArgument(let node):
        return node._syntaxNode
      case .specializeAvailabilityArgument(let node):
        return node._syntaxNode
      case .specializeTargetFunctionArgument(let node):
        return node._syntaxNode
      case .genericWhereClause(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: LabeledSpecializeArgumentSyntax) {
      self = .labeledSpecializeArgument(node)
    }

    public init(_ node: SpecializeAvailabilityArgumentSyntax) {
      self = .specializeAvailabilityArgument(node)
    }

    public init(_ node: SpecializeTargetFunctionArgumentSyntax) {
      self = .specializeTargetFunctionArgument(node)
    }

    public init(_ node: GenericWhereClauseSyntax) {
      self = .genericWhereClause(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(LabeledSpecializeArgumentSyntax.self) {
        self = .labeledSpecializeArgument(node)
      } else if let node = node.as(SpecializeAvailabilityArgumentSyntax.self) {
        self = .specializeAvailabilityArgument(node)
      } else if let node = node.as(SpecializeTargetFunctionArgumentSyntax.self) {
        self = .specializeTargetFunctionArgument(node)
      } else if let node = node.as(GenericWhereClauseSyntax.self) {
        self = .genericWhereClause(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([
        .node(LabeledSpecializeArgumentSyntax.self),
        .node(SpecializeAvailabilityArgumentSyntax.self),
        .node(SpecializeTargetFunctionArgumentSyntax.self),
        .node(GenericWhereClauseSyntax.self)
      ])
    }

    /// Checks if the current syntax node can be cast to ``LabeledSpecializeArgumentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: LabeledSpecializeArgumentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``LabeledSpecializeArgumentSyntax``.
    ///
    /// - Returns: An instance of ``LabeledSpecializeArgumentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: LabeledSpecializeArgumentSyntax.Type) -> LabeledSpecializeArgumentSyntax? {
      return LabeledSpecializeArgumentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``LabeledSpecializeArgumentSyntax``.
    ///
    /// - Returns: An instance of ``LabeledSpecializeArgumentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: LabeledSpecializeArgumentSyntax.Type) -> LabeledSpecializeArgumentSyntax {
      return self.as(LabeledSpecializeArgumentSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``SpecializeAvailabilityArgumentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SpecializeAvailabilityArgumentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SpecializeAvailabilityArgumentSyntax``.
    ///
    /// - Returns: An instance of ``SpecializeAvailabilityArgumentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SpecializeAvailabilityArgumentSyntax.Type) -> SpecializeAvailabilityArgumentSyntax? {
      return SpecializeAvailabilityArgumentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SpecializeAvailabilityArgumentSyntax``.
    ///
    /// - Returns: An instance of ``SpecializeAvailabilityArgumentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SpecializeAvailabilityArgumentSyntax.Type) -> SpecializeAvailabilityArgumentSyntax {
      return self.as(SpecializeAvailabilityArgumentSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``SpecializeTargetFunctionArgumentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SpecializeTargetFunctionArgumentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SpecializeTargetFunctionArgumentSyntax``.
    ///
    /// - Returns: An instance of ``SpecializeTargetFunctionArgumentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SpecializeTargetFunctionArgumentSyntax.Type) -> SpecializeTargetFunctionArgumentSyntax? {
      return SpecializeTargetFunctionArgumentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SpecializeTargetFunctionArgumentSyntax``.
    ///
    /// - Returns: An instance of ``SpecializeTargetFunctionArgumentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SpecializeTargetFunctionArgumentSyntax.Type) -> SpecializeTargetFunctionArgumentSyntax {
      return self.as(SpecializeTargetFunctionArgumentSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``GenericWhereClauseSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: GenericWhereClauseSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``GenericWhereClauseSyntax``.
    ///
    /// - Returns: An instance of ``GenericWhereClauseSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: GenericWhereClauseSyntax.Type) -> GenericWhereClauseSyntax? {
      return GenericWhereClauseSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``GenericWhereClauseSyntax``.
    ///
    /// - Returns: An instance of ``GenericWhereClauseSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: GenericWhereClauseSyntax.Type) -> GenericWhereClauseSyntax {
      return self.as(GenericWhereClauseSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .specializeAttributeArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.specializeAttributeArgumentList
}

/// ### Children
/// 
/// (``StringSegmentSyntax`` | ``ExpressionSegmentSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``StringLiteralExprSyntax``.``StringLiteralExprSyntax/segments``
public struct StringLiteralSegmentListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    /// A literal segment inside a string segment.
    /// 
    /// - SeeAlso: ``ExpressionSegmentSyntax``
    case stringSegment(StringSegmentSyntax)
    /// An interpolated expression inside a string literal.
    /// 
    /// - SeeAlso: ``StringSegmentSyntax``
    case expressionSegment(ExpressionSegmentSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .stringSegment(let node):
        return node._syntaxNode
      case .expressionSegment(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: StringSegmentSyntax) {
      self = .stringSegment(node)
    }

    public init(_ node: ExpressionSegmentSyntax) {
      self = .expressionSegment(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(StringSegmentSyntax.self) {
        self = .stringSegment(node)
      } else if let node = node.as(ExpressionSegmentSyntax.self) {
        self = .expressionSegment(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(StringSegmentSyntax.self), .node(ExpressionSegmentSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``StringSegmentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: StringSegmentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``StringSegmentSyntax``.
    ///
    /// - Returns: An instance of ``StringSegmentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: StringSegmentSyntax.Type) -> StringSegmentSyntax? {
      return StringSegmentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``StringSegmentSyntax``.
    ///
    /// - Returns: An instance of ``StringSegmentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: StringSegmentSyntax.Type) -> StringSegmentSyntax {
      return self.as(StringSegmentSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``ExpressionSegmentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: ExpressionSegmentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``ExpressionSegmentSyntax``.
    ///
    /// - Returns: An instance of ``ExpressionSegmentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: ExpressionSegmentSyntax.Type) -> ExpressionSegmentSyntax? {
      return ExpressionSegmentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``ExpressionSegmentSyntax``.
    ///
    /// - Returns: An instance of ``ExpressionSegmentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: ExpressionSegmentSyntax.Type) -> ExpressionSegmentSyntax {
      return self.as(ExpressionSegmentSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .stringLiteralSegmentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.stringLiteralSegmentList
}

/// ### Children
/// 
/// ``SwitchCaseItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``SwitchCaseLabelSyntax``.``SwitchCaseLabelSyntax/caseItems``
public struct SwitchCaseItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = SwitchCaseItemSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .switchCaseItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.switchCaseItemList
}

/// ### Children
/// 
/// (``SwitchCaseSyntax`` | ``IfConfigDeclSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``SwitchExprSyntax``.``SwitchExprSyntax/cases``
public struct SwitchCaseListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    case switchCase(SwitchCaseSyntax)
    case ifConfigDecl(IfConfigDeclSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .switchCase(let node):
        return node._syntaxNode
      case .ifConfigDecl(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: SwitchCaseSyntax) {
      self = .switchCase(node)
    }

    public init(_ node: IfConfigDeclSyntax) {
      self = .ifConfigDecl(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(SwitchCaseSyntax.self) {
        self = .switchCase(node)
      } else if let node = node.as(IfConfigDeclSyntax.self) {
        self = .ifConfigDecl(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(SwitchCaseSyntax.self), .node(IfConfigDeclSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``SwitchCaseSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SwitchCaseSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SwitchCaseSyntax``.
    ///
    /// - Returns: An instance of ``SwitchCaseSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SwitchCaseSyntax.Type) -> SwitchCaseSyntax? {
      return SwitchCaseSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SwitchCaseSyntax``.
    ///
    /// - Returns: An instance of ``SwitchCaseSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SwitchCaseSyntax.Type) -> SwitchCaseSyntax {
      return self.as(SwitchCaseSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``IfConfigDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: IfConfigDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``IfConfigDeclSyntax``.
    ///
    /// - Returns: An instance of ``IfConfigDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: IfConfigDeclSyntax.Type) -> IfConfigDeclSyntax? {
      return IfConfigDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``IfConfigDeclSyntax``.
    ///
    /// - Returns: An instance of ``IfConfigDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: IfConfigDeclSyntax.Type) -> IfConfigDeclSyntax {
      return self.as(IfConfigDeclSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .switchCaseList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.switchCaseList
}

/// A list of ``TuplePatternElementSyntax``.
///
/// ### Children
/// 
/// ``TuplePatternElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``TuplePatternSyntax``.``TuplePatternSyntax/elements``
public struct TuplePatternElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = TuplePatternElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tuplePatternElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.tuplePatternElementList
}

/// ### Children
/// 
/// ``TupleTypeElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``FunctionTypeSyntax``.``FunctionTypeSyntax/parameters``
///  - ``TupleTypeSyntax``.``TupleTypeSyntax/elements``
public struct TupleTypeElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = TupleTypeElementSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tupleTypeElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.tupleTypeElementList
}

/// ### Children
/// 
/// (``SimpleTypeSpecifierSyntax`` | `LifetimeTypeSpecifierSyntax` | ``NonisolatedTypeSpecifierSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``AttributedTypeSyntax``.``AttributedTypeSyntax/specifiers``
///  - ``AttributedTypeSyntax``.``AttributedTypeSyntax/lateSpecifiers``
public struct TypeSpecifierListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    /// A specifier that can be attached to a type to eg. mark a parameter as `inout` or `consuming`
    case simpleTypeSpecifier(SimpleTypeSpecifierSyntax)
    /// A specifier that specifies function parameter on whose lifetime a type depends
    /// - Note: Requires experimental feature `nonescapableTypes`.
    @_spi(ExperimentalLanguageFeatures)
    case lifetimeTypeSpecifier(LifetimeTypeSpecifierSyntax)
    case nonisolatedTypeSpecifier(NonisolatedTypeSpecifierSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .simpleTypeSpecifier(let node):
        return node._syntaxNode
      case .lifetimeTypeSpecifier(let node):
        return node._syntaxNode
      case .nonisolatedTypeSpecifier(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: SimpleTypeSpecifierSyntax) {
      self = .simpleTypeSpecifier(node)
    }

    /// - Note: Requires experimental feature `nonescapableTypes`.
    @_spi(ExperimentalLanguageFeatures)
    public init(_ node: LifetimeTypeSpecifierSyntax) {
      self = .lifetimeTypeSpecifier(node)
    }

    public init(_ node: NonisolatedTypeSpecifierSyntax) {
      self = .nonisolatedTypeSpecifier(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(SimpleTypeSpecifierSyntax.self) {
        self = .simpleTypeSpecifier(node)
      } else if let node = node.as(LifetimeTypeSpecifierSyntax.self) {
        self = .lifetimeTypeSpecifier(node)
      } else if let node = node.as(NonisolatedTypeSpecifierSyntax.self) {
        self = .nonisolatedTypeSpecifier(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(SimpleTypeSpecifierSyntax.self), .node(LifetimeTypeSpecifierSyntax.self), .node(NonisolatedTypeSpecifierSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``SimpleTypeSpecifierSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SimpleTypeSpecifierSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SimpleTypeSpecifierSyntax``.
    ///
    /// - Returns: An instance of ``SimpleTypeSpecifierSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SimpleTypeSpecifierSyntax.Type) -> SimpleTypeSpecifierSyntax? {
      return SimpleTypeSpecifierSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SimpleTypeSpecifierSyntax``.
    ///
    /// - Returns: An instance of ``SimpleTypeSpecifierSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SimpleTypeSpecifierSyntax.Type) -> SimpleTypeSpecifierSyntax {
      return self.as(SimpleTypeSpecifierSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to `LifetimeTypeSpecifierSyntax`.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    /// - Note: Requires experimental feature `nonescapableTypes`.
    @_spi(ExperimentalLanguageFeatures)
    public func `is`(_ syntaxType: LifetimeTypeSpecifierSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to `LifetimeTypeSpecifierSyntax`.
    ///
    /// - Returns: An instance of `LifetimeTypeSpecifierSyntax`, or `nil` if the cast fails.
    /// - Note: Requires experimental feature `nonescapableTypes`.
    @_spi(ExperimentalLanguageFeatures)
    public func `as`(_ syntaxType: LifetimeTypeSpecifierSyntax.Type) -> LifetimeTypeSpecifierSyntax? {
      return LifetimeTypeSpecifierSyntax.init(self)
    }

    /// Force-casts the current syntax node to `LifetimeTypeSpecifierSyntax`.
    ///
    /// - Returns: An instance of `LifetimeTypeSpecifierSyntax`.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    /// - Note: Requires experimental feature `nonescapableTypes`.
    @_spi(ExperimentalLanguageFeatures)
    public func cast(_ syntaxType: LifetimeTypeSpecifierSyntax.Type) -> LifetimeTypeSpecifierSyntax {
      return self.as(LifetimeTypeSpecifierSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``NonisolatedTypeSpecifierSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: NonisolatedTypeSpecifierSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``NonisolatedTypeSpecifierSyntax``.
    ///
    /// - Returns: An instance of ``NonisolatedTypeSpecifierSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: NonisolatedTypeSpecifierSyntax.Type) -> NonisolatedTypeSpecifierSyntax? {
      return NonisolatedTypeSpecifierSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``NonisolatedTypeSpecifierSyntax``.
    ///
    /// - Returns: An instance of ``NonisolatedTypeSpecifierSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: NonisolatedTypeSpecifierSyntax.Type) -> NonisolatedTypeSpecifierSyntax {
      return self.as(NonisolatedTypeSpecifierSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .typeSpecifierList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.typeSpecifierList
}

/// A collection of syntax nodes that occurred in the source code but could not be used to form a valid syntax tree.
///
/// ### Children
/// 
/// ``Syntax`` `*`
public struct UnexpectedNodesSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = Syntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .unexpectedNodes else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.unexpectedNodes
}

/// ### Children
/// 
/// ``VersionComponentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``VersionTupleSyntax``.``VersionTupleSyntax/components``
public struct VersionComponentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = VersionComponentSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .versionComponentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.versionComponentList
}

/// ### Children
/// 
/// ``YieldedExpressionSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``YieldedExpressionsClauseSyntax``.``YieldedExpressionsClauseSyntax/elements``
public struct YieldedExpressionListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = YieldedExpressionSyntax

  public let _syntaxNode: Syntax

  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .yieldedExpressionList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  public static let syntaxKind = SyntaxKind.yieldedExpressionList
}
