//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - DeclSyntax

/// Protocol to which all ``DeclSyntax`` nodes conform.
///
/// Extension point to add common methods to all ``DeclSyntax`` nodes.
///
///  - Warning: Do not conform to this protocol yourself.
public protocol DeclSyntaxProtocol: SyntaxProtocol {}

/// Extension of ``DeclSyntaxProtocol`` to provide casting methods.
///
/// These methods enable casting between syntax node types within the same
/// base node protocol hierarchy (e.g., ``DeclSyntaxProtocol``).
///
/// While ``SyntaxProtocol`` offers general casting methods (``SyntaxProtocol.as(_:)``,
/// ``SyntaxProtocol.is(_:)``, and ``SyntaxProtocol.cast(_:)``), these often aren't
/// appropriate for use on types conforming to a specific base node protocol
/// like ``DeclSyntaxProtocol``. That's because at this level,
/// we know that the cast to another base node type (e.g., ``DeclSyntaxProtocol``
/// when working with ``ExprSyntaxProtocol``) is guaranteed to fail.
///
/// To guide developers toward correct usage, this extension provides overloads
/// of these casting methods that are restricted to the same base node type.
/// Furthermore, it marks the inherited casting methods from ``SyntaxProtocol`` as
/// deprecated, indicating that they will always fail when used in this context.
extension DeclSyntaxProtocol {
  /// Checks if the current syntax node can be cast to a given specialized syntax type.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  public func `is`<S: DeclSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  public func `as`<S: DeclSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  public func cast<S: DeclSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }


  /// Checks if the current syntax node can be upcast to its base node type (``DeclSyntax``).
  ///
  /// - Returns: `true` since the node can always be upcast to its base node.
  @available(*, deprecated, message: "This cast will always succeed")
  public func `is`(_ syntaxType: DeclSyntax.Type) -> Bool {
    return true
  }


  /// Attempts to upcast the current syntax node to its base node type (``DeclSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `DeclSyntax.init` for upcasting")
  public func `as`(_ syntaxType: DeclSyntax.Type) -> DeclSyntax? {
    return DeclSyntax(self)
  }


  /// Force-upcast the current syntax node to its base node type (``DeclSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `DeclSyntax.init` for upcasting")
  public func cast(_ syntaxType: DeclSyntax.Type) -> DeclSyntax {
    return DeclSyntax(self)
  }


  /// Checks if the current syntax node can be cast to a given node type from a base node protocol hierarchy other
  /// than ``DeclSyntaxProtocol``.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  ///
  /// - Note: In most cases, this is comparing a ``DeclSyntaxProtocol`` to a node that is not a
  ///   ``DeclSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``DeclSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'DeclSyntaxProtocol' hierarchy")
  public func `is`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given node type from the a base node protocol hierarchy other than
  /// ``DeclSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  ///
  /// - Note: In most cases, this is casting a ``DeclSyntaxProtocol`` to a node that is not a
  ///   ``DeclSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``DeclSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'DeclSyntaxProtocol' hierarchy")
  public func `as`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given node type from a base node protocol hierarchy other than
  /// ``DeclSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  ///
  /// - Note: In most cases, this is casting a ``DeclSyntaxProtocol`` to a node that is not a
  ///   ``DeclSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``DeclSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'DeclSyntaxProtocol' hierarchy")
  public func cast<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }
}

extension Syntax {
  /// Check whether the non-type erased version of this syntax node conforms to
  /// DeclSyntaxProtocol.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func isProtocol(_: DeclSyntaxProtocol.Protocol) -> Bool {
    return self.asProtocol(DeclSyntaxProtocol.self) != nil
  }

  /// Return the non-type erased version of this syntax node if it conforms to
  /// DeclSyntaxProtocol. Otherwise return nil.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: DeclSyntaxProtocol.Protocol) -> DeclSyntaxProtocol? {
    return self.asProtocol(SyntaxProtocol.self) as? DeclSyntaxProtocol
  }
}

/// ### Subtypes
/// 
/// - ``AccessorDeclSyntax``
/// - ``ActorDeclSyntax``
/// - ``AssociatedTypeDeclSyntax``
/// - ``ClassDeclSyntax``
/// - ``DeinitializerDeclSyntax``
/// - ``EditorPlaceholderDeclSyntax``
/// - ``EnumCaseDeclSyntax``
/// - ``EnumDeclSyntax``
/// - ``ExtensionDeclSyntax``
/// - ``FunctionDeclSyntax``
/// - ``IfConfigDeclSyntax``
/// - ``ImportDeclSyntax``
/// - ``InitializerDeclSyntax``
/// - ``MacroDeclSyntax``
/// - ``MacroExpansionDeclSyntax``
/// - ``MissingDeclSyntax``
/// - ``OperatorDeclSyntax``
/// - ``PoundSourceLocationSyntax``
/// - ``PrecedenceGroupDeclSyntax``
/// - ``ProtocolDeclSyntax``
/// - ``StructDeclSyntax``
/// - ``SubscriptDeclSyntax``
/// - ``TypeAliasDeclSyntax``
/// - ``VariableDeclSyntax``
public struct DeclSyntax: DeclSyntaxProtocol, SyntaxHashable {
  public let _syntaxNode: Syntax

  /// Create a ``DeclSyntax`` node from a specialized syntax node.
  public init(_ syntax: __shared some DeclSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``DeclSyntax`` node from a specialized optional syntax node.
  public init?(_ syntax: __shared (some DeclSyntaxProtocol)?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(syntax)
  }

  public init(fromProtocol syntax: __shared DeclSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``DeclSyntax`` node from a specialized optional syntax node.
  public init?(fromProtocol syntax: __shared DeclSyntaxProtocol?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(fromProtocol: syntax)
  }

  public init?(_ node: __shared some SyntaxProtocol) {
    switch node.raw.kind {
    case .accessorDecl, .actorDecl, .associatedTypeDecl, .classDecl, .deinitializerDecl, .editorPlaceholderDecl, .enumCaseDecl, .enumDecl, .extensionDecl, .functionDecl, .ifConfigDecl, .importDecl, .initializerDecl, .macroDecl, .macroExpansionDecl, .missingDecl, .operatorDecl, .poundSourceLocation, .precedenceGroupDecl, .protocolDecl, .structDecl, .subscriptDecl, .typeAliasDecl, .usingDecl, .variableDecl:
      self._syntaxNode = node._syntaxNode
    default:
      return nil
    }
  }

  /// Syntax nodes always conform to `DeclSyntaxProtocol`. This API is just
  /// added for consistency.
  ///
  ///  - Note:  This will incur an existential conversion.
  @available(*, deprecated, message: "Expression always evaluates to true")
  public func isProtocol(_: DeclSyntaxProtocol.Protocol) -> Bool {
    return true
  }

  /// Return the non-type erased version of this syntax node.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: DeclSyntaxProtocol.Protocol) -> DeclSyntaxProtocol {
    return Syntax(self).asProtocol(DeclSyntaxProtocol.self)!
  }

  public static var structure: SyntaxNodeStructure {
    return .choices([
      .node(AccessorDeclSyntax.self),
      .node(ActorDeclSyntax.self),
      .node(AssociatedTypeDeclSyntax.self),
      .node(ClassDeclSyntax.self),
      .node(DeinitializerDeclSyntax.self),
      .node(EditorPlaceholderDeclSyntax.self),
      .node(EnumCaseDeclSyntax.self),
      .node(EnumDeclSyntax.self),
      .node(ExtensionDeclSyntax.self),
      .node(FunctionDeclSyntax.self),
      .node(IfConfigDeclSyntax.self),
      .node(ImportDeclSyntax.self),
      .node(InitializerDeclSyntax.self),
      .node(MacroDeclSyntax.self),
      .node(MacroExpansionDeclSyntax.self),
      .node(MissingDeclSyntax.self),
      .node(OperatorDeclSyntax.self),
      .node(PoundSourceLocationSyntax.self),
      .node(PrecedenceGroupDeclSyntax.self),
      .node(ProtocolDeclSyntax.self),
      .node(StructDeclSyntax.self),
      .node(SubscriptDeclSyntax.self),
      .node(TypeAliasDeclSyntax.self),
      .node(UsingDeclSyntax.self),
      .node(VariableDeclSyntax.self)
    ])
  }
}

/// Protocol that syntax nodes conform to if they don't have any semantic subtypes.
/// These are syntax nodes that are not considered base nodes for other syntax types.
///
/// Syntax nodes conforming to this protocol have their inherited casting methods
/// deprecated to prevent incorrect casting.
public protocol _LeafDeclSyntaxNodeProtocol: DeclSyntaxProtocol {}

extension _LeafDeclSyntaxNodeProtocol {
  /// Checks if the current leaf syntax node can be cast to a different specified type.
  ///
  /// - Returns: `false` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `is` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `is`<S: DeclSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return false
  }


  /// Attempts to cast the current leaf syntax node to a different specified type.
  ///
  /// - Returns: `nil` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `as` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `as`<S: DeclSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return nil
  }


  /// Force-casts the current leaf syntax node to a different specified type.
  ///
  /// - Returns: This method will always trigger a runtime crash and never return.
  ///
  /// - Note: This method overloads the general `cast` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  /// - Warning: Invoking this method will lead to a fatal error.
  @available(*, deprecated, message: "This cast will always fail")
  public func cast<S: DeclSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    fatalError("\(Self.self) cannot be cast to \(S.self)")
  }
}

// MARK: - ExprSyntax

/// Protocol to which all ``ExprSyntax`` nodes conform.
///
/// Extension point to add common methods to all ``ExprSyntax`` nodes.
///
///  - Warning: Do not conform to this protocol yourself.
public protocol ExprSyntaxProtocol: SyntaxProtocol {}

/// Extension of ``ExprSyntaxProtocol`` to provide casting methods.
///
/// These methods enable casting between syntax node types within the same
/// base node protocol hierarchy (e.g., ``DeclSyntaxProtocol``).
///
/// While ``SyntaxProtocol`` offers general casting methods (``SyntaxProtocol.as(_:)``,
/// ``SyntaxProtocol.is(_:)``, and ``SyntaxProtocol.cast(_:)``), these often aren't
/// appropriate for use on types conforming to a specific base node protocol
/// like ``ExprSyntaxProtocol``. That's because at this level,
/// we know that the cast to another base node type (e.g., ``DeclSyntaxProtocol``
/// when working with ``ExprSyntaxProtocol``) is guaranteed to fail.
///
/// To guide developers toward correct usage, this extension provides overloads
/// of these casting methods that are restricted to the same base node type.
/// Furthermore, it marks the inherited casting methods from ``SyntaxProtocol`` as
/// deprecated, indicating that they will always fail when used in this context.
extension ExprSyntaxProtocol {
  /// Checks if the current syntax node can be cast to a given specialized syntax type.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  public func `is`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  public func `as`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  public func cast<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }


  /// Checks if the current syntax node can be upcast to its base node type (``ExprSyntax``).
  ///
  /// - Returns: `true` since the node can always be upcast to its base node.
  @available(*, deprecated, message: "This cast will always succeed")
  public func `is`(_ syntaxType: ExprSyntax.Type) -> Bool {
    return true
  }


  /// Attempts to upcast the current syntax node to its base node type (``ExprSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `ExprSyntax.init` for upcasting")
  public func `as`(_ syntaxType: ExprSyntax.Type) -> ExprSyntax? {
    return ExprSyntax(self)
  }


  /// Force-upcast the current syntax node to its base node type (``ExprSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `ExprSyntax.init` for upcasting")
  public func cast(_ syntaxType: ExprSyntax.Type) -> ExprSyntax {
    return ExprSyntax(self)
  }


  /// Checks if the current syntax node can be cast to a given node type from a base node protocol hierarchy other
  /// than ``ExprSyntaxProtocol``.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  ///
  /// - Note: In most cases, this is comparing a ``ExprSyntaxProtocol`` to a node that is not a
  ///   ``ExprSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``ExprSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'ExprSyntaxProtocol' hierarchy")
  public func `is`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given node type from the a base node protocol hierarchy other than
  /// ``ExprSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  ///
  /// - Note: In most cases, this is casting a ``ExprSyntaxProtocol`` to a node that is not a
  ///   ``ExprSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``ExprSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'ExprSyntaxProtocol' hierarchy")
  public func `as`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given node type from a base node protocol hierarchy other than
  /// ``ExprSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  ///
  /// - Note: In most cases, this is casting a ``ExprSyntaxProtocol`` to a node that is not a
  ///   ``ExprSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``ExprSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'ExprSyntaxProtocol' hierarchy")
  public func cast<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }
}

extension Syntax {
  /// Check whether the non-type erased version of this syntax node conforms to
  /// ExprSyntaxProtocol.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func isProtocol(_: ExprSyntaxProtocol.Protocol) -> Bool {
    return self.asProtocol(ExprSyntaxProtocol.self) != nil
  }

  /// Return the non-type erased version of this syntax node if it conforms to
  /// ExprSyntaxProtocol. Otherwise return nil.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: ExprSyntaxProtocol.Protocol) -> ExprSyntaxProtocol? {
    return self.asProtocol(SyntaxProtocol.self) as? ExprSyntaxProtocol
  }
}

/// ### Subtypes
/// 
/// - ``ArrayExprSyntax``
/// - ``ArrowExprSyntax``
/// - ``AsExprSyntax``
/// - ``AssignmentExprSyntax``
/// - ``AwaitExprSyntax``
/// - ``BinaryOperatorExprSyntax``
/// - ``BooleanLiteralExprSyntax``
/// - ``BorrowExprSyntax``
/// - ``ClosureExprSyntax``
/// - ``ConsumeExprSyntax``
/// - ``CopyExprSyntax``
/// - ``DeclReferenceExprSyntax``
/// - ``DictionaryExprSyntax``
/// - ``DiscardAssignmentExprSyntax``
/// - ``EditorPlaceholderExprSyntax``
/// - ``FloatLiteralExprSyntax``
/// - ``ForceUnwrapExprSyntax``
/// - ``FunctionCallExprSyntax``
/// - ``GenericSpecializationExprSyntax``
/// - ``IfExprSyntax``
/// - ``InOutExprSyntax``
/// - ``InfixOperatorExprSyntax``
/// - ``IntegerLiteralExprSyntax``
/// - ``IsExprSyntax``
/// - ``KeyPathExprSyntax``
/// - ``MacroExpansionExprSyntax``
/// - ``MemberAccessExprSyntax``
/// - ``MissingExprSyntax``
/// - ``NilLiteralExprSyntax``
/// - ``OptionalChainingExprSyntax``
/// - ``PackElementExprSyntax``
/// - ``PackExpansionExprSyntax``
/// - ``PatternExprSyntax``
/// - ``PostfixIfConfigExprSyntax``
/// - ``PostfixOperatorExprSyntax``
/// - ``PrefixOperatorExprSyntax``
/// - ``RegexLiteralExprSyntax``
/// - ``SequenceExprSyntax``
/// - ``SimpleStringLiteralExprSyntax``
/// - ``StringLiteralExprSyntax``
/// - ``SubscriptCallExprSyntax``
/// - ``SuperExprSyntax``
/// - ``SwitchExprSyntax``
/// - ``TernaryExprSyntax``
/// - ``TryExprSyntax``
/// - ``TupleExprSyntax``
/// - ``TypeExprSyntax``
/// - ``UnresolvedAsExprSyntax``
/// - ``UnresolvedIsExprSyntax``
/// - ``UnresolvedTernaryExprSyntax``
/// - ``UnsafeExprSyntax``
public struct ExprSyntax: ExprSyntaxProtocol, SyntaxHashable {
  public let _syntaxNode: Syntax

  /// Create a ``ExprSyntax`` node from a specialized syntax node.
  public init(_ syntax: __shared some ExprSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``ExprSyntax`` node from a specialized optional syntax node.
  public init?(_ syntax: __shared (some ExprSyntaxProtocol)?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(syntax)
  }

  public init(fromProtocol syntax: __shared ExprSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``ExprSyntax`` node from a specialized optional syntax node.
  public init?(fromProtocol syntax: __shared ExprSyntaxProtocol?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(fromProtocol: syntax)
  }

  public init?(_ node: __shared some SyntaxProtocol) {
    switch node.raw.kind {
    case .arrayExpr, .arrowExpr, .asExpr, .assignmentExpr, .awaitExpr, .binaryOperatorExpr, .booleanLiteralExpr, .borrowExpr, ._canImportExpr, ._canImportVersionInfo, .closureExpr, .consumeExpr, .copyExpr, .declReferenceExpr, .dictionaryExpr, .discardAssignmentExpr, .doExpr, .editorPlaceholderExpr, .floatLiteralExpr, .forceUnwrapExpr, .functionCallExpr, .genericSpecializationExpr, .ifExpr, .inOutExpr, .infixOperatorExpr, .integerLiteralExpr, .isExpr, .keyPathExpr, .macroExpansionExpr, .memberAccessExpr, .missingExpr, .nilLiteralExpr, .optionalChainingExpr, .packElementExpr, .packExpansionExpr, .patternExpr, .postfixIfConfigExpr, .postfixOperatorExpr, .prefixOperatorExpr, .regexLiteralExpr, .sequenceExpr, .simpleStringLiteralExpr, .stringLiteralExpr, .subscriptCallExpr, .superExpr, .switchExpr, .ternaryExpr, .tryExpr, .tupleExpr, .typeExpr, .unresolvedAsExpr, .unresolvedIsExpr, .unresolvedTernaryExpr, .unsafeExpr:
      self._syntaxNode = node._syntaxNode
    default:
      return nil
    }
  }

  /// Syntax nodes always conform to `ExprSyntaxProtocol`. This API is just
  /// added for consistency.
  ///
  ///  - Note:  This will incur an existential conversion.
  @available(*, deprecated, message: "Expression always evaluates to true")
  public func isProtocol(_: ExprSyntaxProtocol.Protocol) -> Bool {
    return true
  }

  /// Return the non-type erased version of this syntax node.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: ExprSyntaxProtocol.Protocol) -> ExprSyntaxProtocol {
    return Syntax(self).asProtocol(ExprSyntaxProtocol.self)!
  }

  public static var structure: SyntaxNodeStructure {
    return .choices([
      .node(ArrayExprSyntax.self),
      .node(ArrowExprSyntax.self),
      .node(AsExprSyntax.self),
      .node(AssignmentExprSyntax.self),
      .node(AwaitExprSyntax.self),
      .node(BinaryOperatorExprSyntax.self),
      .node(BooleanLiteralExprSyntax.self),
      .node(BorrowExprSyntax.self),
      .node(_CanImportExprSyntax.self),
      .node(_CanImportVersionInfoSyntax.self),
      .node(ClosureExprSyntax.self),
      .node(ConsumeExprSyntax.self),
      .node(CopyExprSyntax.self),
      .node(DeclReferenceExprSyntax.self),
      .node(DictionaryExprSyntax.self),
      .node(DiscardAssignmentExprSyntax.self),
      .node(DoExprSyntax.self),
      .node(EditorPlaceholderExprSyntax.self),
      .node(FloatLiteralExprSyntax.self),
      .node(ForceUnwrapExprSyntax.self),
      .node(FunctionCallExprSyntax.self),
      .node(GenericSpecializationExprSyntax.self),
      .node(IfExprSyntax.self),
      .node(InOutExprSyntax.self),
      .node(InfixOperatorExprSyntax.self),
      .node(IntegerLiteralExprSyntax.self),
      .node(IsExprSyntax.self),
      .node(KeyPathExprSyntax.self),
      .node(MacroExpansionExprSyntax.self),
      .node(MemberAccessExprSyntax.self),
      .node(MissingExprSyntax.self),
      .node(NilLiteralExprSyntax.self),
      .node(OptionalChainingExprSyntax.self),
      .node(PackElementExprSyntax.self),
      .node(PackExpansionExprSyntax.self),
      .node(PatternExprSyntax.self),
      .node(PostfixIfConfigExprSyntax.self),
      .node(PostfixOperatorExprSyntax.self),
      .node(PrefixOperatorExprSyntax.self),
      .node(RegexLiteralExprSyntax.self),
      .node(SequenceExprSyntax.self),
      .node(SimpleStringLiteralExprSyntax.self),
      .node(StringLiteralExprSyntax.self),
      .node(SubscriptCallExprSyntax.self),
      .node(SuperExprSyntax.self),
      .node(SwitchExprSyntax.self),
      .node(TernaryExprSyntax.self),
      .node(TryExprSyntax.self),
      .node(TupleExprSyntax.self),
      .node(TypeExprSyntax.self),
      .node(UnresolvedAsExprSyntax.self),
      .node(UnresolvedIsExprSyntax.self),
      .node(UnresolvedTernaryExprSyntax.self),
      .node(UnsafeExprSyntax.self)
    ])
  }
}

/// Protocol that syntax nodes conform to if they don't have any semantic subtypes.
/// These are syntax nodes that are not considered base nodes for other syntax types.
///
/// Syntax nodes conforming to this protocol have their inherited casting methods
/// deprecated to prevent incorrect casting.
public protocol _LeafExprSyntaxNodeProtocol: ExprSyntaxProtocol {}

extension _LeafExprSyntaxNodeProtocol {
  /// Checks if the current leaf syntax node can be cast to a different specified type.
  ///
  /// - Returns: `false` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `is` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `is`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return false
  }


  /// Attempts to cast the current leaf syntax node to a different specified type.
  ///
  /// - Returns: `nil` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `as` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `as`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return nil
  }


  /// Force-casts the current leaf syntax node to a different specified type.
  ///
  /// - Returns: This method will always trigger a runtime crash and never return.
  ///
  /// - Note: This method overloads the general `cast` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  /// - Warning: Invoking this method will lead to a fatal error.
  @available(*, deprecated, message: "This cast will always fail")
  public func cast<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    fatalError("\(Self.self) cannot be cast to \(S.self)")
  }
}

// MARK: - PatternSyntax

/// Protocol to which all ``PatternSyntax`` nodes conform.
///
/// Extension point to add common methods to all ``PatternSyntax`` nodes.
///
///  - Warning: Do not conform to this protocol yourself.
public protocol PatternSyntaxProtocol: SyntaxProtocol {}

/// Extension of ``PatternSyntaxProtocol`` to provide casting methods.
///
/// These methods enable casting between syntax node types within the same
/// base node protocol hierarchy (e.g., ``DeclSyntaxProtocol``).
///
/// While ``SyntaxProtocol`` offers general casting methods (``SyntaxProtocol.as(_:)``,
/// ``SyntaxProtocol.is(_:)``, and ``SyntaxProtocol.cast(_:)``), these often aren't
/// appropriate for use on types conforming to a specific base node protocol
/// like ``PatternSyntaxProtocol``. That's because at this level,
/// we know that the cast to another base node type (e.g., ``DeclSyntaxProtocol``
/// when working with ``ExprSyntaxProtocol``) is guaranteed to fail.
///
/// To guide developers toward correct usage, this extension provides overloads
/// of these casting methods that are restricted to the same base node type.
/// Furthermore, it marks the inherited casting methods from ``SyntaxProtocol`` as
/// deprecated, indicating that they will always fail when used in this context.
extension PatternSyntaxProtocol {
  /// Checks if the current syntax node can be cast to a given specialized syntax type.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  public func `is`<S: PatternSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  public func `as`<S: PatternSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  public func cast<S: PatternSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }


  /// Checks if the current syntax node can be upcast to its base node type (``PatternSyntax``).
  ///
  /// - Returns: `true` since the node can always be upcast to its base node.
  @available(*, deprecated, message: "This cast will always succeed")
  public func `is`(_ syntaxType: PatternSyntax.Type) -> Bool {
    return true
  }


  /// Attempts to upcast the current syntax node to its base node type (``PatternSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `PatternSyntax.init` for upcasting")
  public func `as`(_ syntaxType: PatternSyntax.Type) -> PatternSyntax? {
    return PatternSyntax(self)
  }


  /// Force-upcast the current syntax node to its base node type (``PatternSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `PatternSyntax.init` for upcasting")
  public func cast(_ syntaxType: PatternSyntax.Type) -> PatternSyntax {
    return PatternSyntax(self)
  }


  /// Checks if the current syntax node can be cast to a given node type from a base node protocol hierarchy other
  /// than ``PatternSyntaxProtocol``.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  ///
  /// - Note: In most cases, this is comparing a ``PatternSyntaxProtocol`` to a node that is not a
  ///   ``PatternSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``PatternSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'PatternSyntaxProtocol' hierarchy")
  public func `is`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given node type from the a base node protocol hierarchy other than
  /// ``PatternSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  ///
  /// - Note: In most cases, this is casting a ``PatternSyntaxProtocol`` to a node that is not a
  ///   ``PatternSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``PatternSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'PatternSyntaxProtocol' hierarchy")
  public func `as`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given node type from a base node protocol hierarchy other than
  /// ``PatternSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  ///
  /// - Note: In most cases, this is casting a ``PatternSyntaxProtocol`` to a node that is not a
  ///   ``PatternSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``PatternSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'PatternSyntaxProtocol' hierarchy")
  public func cast<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }
}

extension Syntax {
  /// Check whether the non-type erased version of this syntax node conforms to
  /// PatternSyntaxProtocol.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func isProtocol(_: PatternSyntaxProtocol.Protocol) -> Bool {
    return self.asProtocol(PatternSyntaxProtocol.self) != nil
  }

  /// Return the non-type erased version of this syntax node if it conforms to
  /// PatternSyntaxProtocol. Otherwise return nil.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: PatternSyntaxProtocol.Protocol) -> PatternSyntaxProtocol? {
    return self.asProtocol(SyntaxProtocol.self) as? PatternSyntaxProtocol
  }
}

/// ### Subtypes
/// 
/// - ``ExpressionPatternSyntax``
/// - ``IdentifierPatternSyntax``
/// - ``IsTypePatternSyntax``
/// - ``MissingPatternSyntax``
/// - ``TuplePatternSyntax``
/// - ``ValueBindingPatternSyntax``
/// - ``WildcardPatternSyntax``
public struct PatternSyntax: PatternSyntaxProtocol, SyntaxHashable {
  public let _syntaxNode: Syntax

  /// Create a ``PatternSyntax`` node from a specialized syntax node.
  public init(_ syntax: __shared some PatternSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``PatternSyntax`` node from a specialized optional syntax node.
  public init?(_ syntax: __shared (some PatternSyntaxProtocol)?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(syntax)
  }

  public init(fromProtocol syntax: __shared PatternSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``PatternSyntax`` node from a specialized optional syntax node.
  public init?(fromProtocol syntax: __shared PatternSyntaxProtocol?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(fromProtocol: syntax)
  }

  public init?(_ node: __shared some SyntaxProtocol) {
    switch node.raw.kind {
    case .expressionPattern, .identifierPattern, .isTypePattern, .missingPattern, .tuplePattern, .valueBindingPattern, .wildcardPattern:
      self._syntaxNode = node._syntaxNode
    default:
      return nil
    }
  }

  /// Syntax nodes always conform to `PatternSyntaxProtocol`. This API is just
  /// added for consistency.
  ///
  ///  - Note:  This will incur an existential conversion.
  @available(*, deprecated, message: "Expression always evaluates to true")
  public func isProtocol(_: PatternSyntaxProtocol.Protocol) -> Bool {
    return true
  }

  /// Return the non-type erased version of this syntax node.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: PatternSyntaxProtocol.Protocol) -> PatternSyntaxProtocol {
    return Syntax(self).asProtocol(PatternSyntaxProtocol.self)!
  }

  public static var structure: SyntaxNodeStructure {
    return .choices([
      .node(ExpressionPatternSyntax.self),
      .node(IdentifierPatternSyntax.self),
      .node(IsTypePatternSyntax.self),
      .node(MissingPatternSyntax.self),
      .node(TuplePatternSyntax.self),
      .node(ValueBindingPatternSyntax.self),
      .node(WildcardPatternSyntax.self)
    ])
  }
}

/// Protocol that syntax nodes conform to if they don't have any semantic subtypes.
/// These are syntax nodes that are not considered base nodes for other syntax types.
///
/// Syntax nodes conforming to this protocol have their inherited casting methods
/// deprecated to prevent incorrect casting.
public protocol _LeafPatternSyntaxNodeProtocol: PatternSyntaxProtocol {}

extension _LeafPatternSyntaxNodeProtocol {
  /// Checks if the current leaf syntax node can be cast to a different specified type.
  ///
  /// - Returns: `false` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `is` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `is`<S: PatternSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return false
  }


  /// Attempts to cast the current leaf syntax node to a different specified type.
  ///
  /// - Returns: `nil` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `as` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `as`<S: PatternSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return nil
  }


  /// Force-casts the current leaf syntax node to a different specified type.
  ///
  /// - Returns: This method will always trigger a runtime crash and never return.
  ///
  /// - Note: This method overloads the general `cast` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  /// - Warning: Invoking this method will lead to a fatal error.
  @available(*, deprecated, message: "This cast will always fail")
  public func cast<S: PatternSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    fatalError("\(Self.self) cannot be cast to \(S.self)")
  }
}

// MARK: - StmtSyntax

/// Protocol to which all ``StmtSyntax`` nodes conform.
///
/// Extension point to add common methods to all ``StmtSyntax`` nodes.
///
///  - Warning: Do not conform to this protocol yourself.
public protocol StmtSyntaxProtocol: SyntaxProtocol {}

/// Extension of ``StmtSyntaxProtocol`` to provide casting methods.
///
/// These methods enable casting between syntax node types within the same
/// base node protocol hierarchy (e.g., ``DeclSyntaxProtocol``).
///
/// While ``SyntaxProtocol`` offers general casting methods (``SyntaxProtocol.as(_:)``,
/// ``SyntaxProtocol.is(_:)``, and ``SyntaxProtocol.cast(_:)``), these often aren't
/// appropriate for use on types conforming to a specific base node protocol
/// like ``StmtSyntaxProtocol``. That's because at this level,
/// we know that the cast to another base node type (e.g., ``DeclSyntaxProtocol``
/// when working with ``ExprSyntaxProtocol``) is guaranteed to fail.
///
/// To guide developers toward correct usage, this extension provides overloads
/// of these casting methods that are restricted to the same base node type.
/// Furthermore, it marks the inherited casting methods from ``SyntaxProtocol`` as
/// deprecated, indicating that they will always fail when used in this context.
extension StmtSyntaxProtocol {
  /// Checks if the current syntax node can be cast to a given specialized syntax type.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  public func `is`<S: StmtSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  public func `as`<S: StmtSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  public func cast<S: StmtSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }


  /// Checks if the current syntax node can be upcast to its base node type (``StmtSyntax``).
  ///
  /// - Returns: `true` since the node can always be upcast to its base node.
  @available(*, deprecated, message: "This cast will always succeed")
  public func `is`(_ syntaxType: StmtSyntax.Type) -> Bool {
    return true
  }


  /// Attempts to upcast the current syntax node to its base node type (``StmtSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `StmtSyntax.init` for upcasting")
  public func `as`(_ syntaxType: StmtSyntax.Type) -> StmtSyntax? {
    return StmtSyntax(self)
  }


  /// Force-upcast the current syntax node to its base node type (``StmtSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `StmtSyntax.init` for upcasting")
  public func cast(_ syntaxType: StmtSyntax.Type) -> StmtSyntax {
    return StmtSyntax(self)
  }


  /// Checks if the current syntax node can be cast to a given node type from a base node protocol hierarchy other
  /// than ``StmtSyntaxProtocol``.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  ///
  /// - Note: In most cases, this is comparing a ``StmtSyntaxProtocol`` to a node that is not a
  ///   ``StmtSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``StmtSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'StmtSyntaxProtocol' hierarchy")
  public func `is`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given node type from the a base node protocol hierarchy other than
  /// ``StmtSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  ///
  /// - Note: In most cases, this is casting a ``StmtSyntaxProtocol`` to a node that is not a
  ///   ``StmtSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``StmtSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'StmtSyntaxProtocol' hierarchy")
  public func `as`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given node type from a base node protocol hierarchy other than
  /// ``StmtSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  ///
  /// - Note: In most cases, this is casting a ``StmtSyntaxProtocol`` to a node that is not a
  ///   ``StmtSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``StmtSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'StmtSyntaxProtocol' hierarchy")
  public func cast<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }
}

extension Syntax {
  /// Check whether the non-type erased version of this syntax node conforms to
  /// StmtSyntaxProtocol.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func isProtocol(_: StmtSyntaxProtocol.Protocol) -> Bool {
    return self.asProtocol(StmtSyntaxProtocol.self) != nil
  }

  /// Return the non-type erased version of this syntax node if it conforms to
  /// StmtSyntaxProtocol. Otherwise return nil.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: StmtSyntaxProtocol.Protocol) -> StmtSyntaxProtocol? {
    return self.asProtocol(SyntaxProtocol.self) as? StmtSyntaxProtocol
  }
}

/// ### Subtypes
/// 
/// - ``BreakStmtSyntax``
/// - ``ContinueStmtSyntax``
/// - ``DeferStmtSyntax``
/// - ``DiscardStmtSyntax``
/// - ``DoStmtSyntax``
/// - ``ExpressionStmtSyntax``
/// - ``FallThroughStmtSyntax``
/// - ``ForStmtSyntax``
/// - ``GuardStmtSyntax``
/// - ``LabeledStmtSyntax``
/// - ``MissingStmtSyntax``
/// - ``RepeatStmtSyntax``
/// - ``ReturnStmtSyntax``
/// - ``ThrowStmtSyntax``
/// - ``WhileStmtSyntax``
/// - ``YieldStmtSyntax``
public struct StmtSyntax: StmtSyntaxProtocol, SyntaxHashable {
  public let _syntaxNode: Syntax

  /// Create a ``StmtSyntax`` node from a specialized syntax node.
  public init(_ syntax: __shared some StmtSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``StmtSyntax`` node from a specialized optional syntax node.
  public init?(_ syntax: __shared (some StmtSyntaxProtocol)?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(syntax)
  }

  public init(fromProtocol syntax: __shared StmtSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``StmtSyntax`` node from a specialized optional syntax node.
  public init?(fromProtocol syntax: __shared StmtSyntaxProtocol?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(fromProtocol: syntax)
  }

  public init?(_ node: __shared some SyntaxProtocol) {
    switch node.raw.kind {
    case .breakStmt, .continueStmt, .deferStmt, .discardStmt, .doStmt, .expressionStmt, .fallThroughStmt, .forStmt, .guardStmt, .labeledStmt, .missingStmt, .repeatStmt, .returnStmt, .thenStmt, .throwStmt, .whileStmt, .yieldStmt:
      self._syntaxNode = node._syntaxNode
    default:
      return nil
    }
  }

  /// Syntax nodes always conform to `StmtSyntaxProtocol`. This API is just
  /// added for consistency.
  ///
  ///  - Note:  This will incur an existential conversion.
  @available(*, deprecated, message: "Expression always evaluates to true")
  public func isProtocol(_: StmtSyntaxProtocol.Protocol) -> Bool {
    return true
  }

  /// Return the non-type erased version of this syntax node.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: StmtSyntaxProtocol.Protocol) -> StmtSyntaxProtocol {
    return Syntax(self).asProtocol(StmtSyntaxProtocol.self)!
  }

  public static var structure: SyntaxNodeStructure {
    return .choices([
      .node(BreakStmtSyntax.self),
      .node(ContinueStmtSyntax.self),
      .node(DeferStmtSyntax.self),
      .node(DiscardStmtSyntax.self),
      .node(DoStmtSyntax.self),
      .node(ExpressionStmtSyntax.self),
      .node(FallThroughStmtSyntax.self),
      .node(ForStmtSyntax.self),
      .node(GuardStmtSyntax.self),
      .node(LabeledStmtSyntax.self),
      .node(MissingStmtSyntax.self),
      .node(RepeatStmtSyntax.self),
      .node(ReturnStmtSyntax.self),
      .node(ThenStmtSyntax.self),
      .node(ThrowStmtSyntax.self),
      .node(WhileStmtSyntax.self),
      .node(YieldStmtSyntax.self)
    ])
  }
}

/// Protocol that syntax nodes conform to if they don't have any semantic subtypes.
/// These are syntax nodes that are not considered base nodes for other syntax types.
///
/// Syntax nodes conforming to this protocol have their inherited casting methods
/// deprecated to prevent incorrect casting.
public protocol _LeafStmtSyntaxNodeProtocol: StmtSyntaxProtocol {}

extension _LeafStmtSyntaxNodeProtocol {
  /// Checks if the current leaf syntax node can be cast to a different specified type.
  ///
  /// - Returns: `false` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `is` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `is`<S: StmtSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return false
  }


  /// Attempts to cast the current leaf syntax node to a different specified type.
  ///
  /// - Returns: `nil` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `as` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `as`<S: StmtSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return nil
  }


  /// Force-casts the current leaf syntax node to a different specified type.
  ///
  /// - Returns: This method will always trigger a runtime crash and never return.
  ///
  /// - Note: This method overloads the general `cast` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  /// - Warning: Invoking this method will lead to a fatal error.
  @available(*, deprecated, message: "This cast will always fail")
  public func cast<S: StmtSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    fatalError("\(Self.self) cannot be cast to \(S.self)")
  }
}

// MARK: - TypeSyntax

/// Protocol to which all ``TypeSyntax`` nodes conform.
///
/// Extension point to add common methods to all ``TypeSyntax`` nodes.
///
///  - Warning: Do not conform to this protocol yourself.
public protocol TypeSyntaxProtocol: SyntaxProtocol {}

/// Extension of ``TypeSyntaxProtocol`` to provide casting methods.
///
/// These methods enable casting between syntax node types within the same
/// base node protocol hierarchy (e.g., ``DeclSyntaxProtocol``).
///
/// While ``SyntaxProtocol`` offers general casting methods (``SyntaxProtocol.as(_:)``,
/// ``SyntaxProtocol.is(_:)``, and ``SyntaxProtocol.cast(_:)``), these often aren't
/// appropriate for use on types conforming to a specific base node protocol
/// like ``TypeSyntaxProtocol``. That's because at this level,
/// we know that the cast to another base node type (e.g., ``DeclSyntaxProtocol``
/// when working with ``ExprSyntaxProtocol``) is guaranteed to fail.
///
/// To guide developers toward correct usage, this extension provides overloads
/// of these casting methods that are restricted to the same base node type.
/// Furthermore, it marks the inherited casting methods from ``SyntaxProtocol`` as
/// deprecated, indicating that they will always fail when used in this context.
extension TypeSyntaxProtocol {
  /// Checks if the current syntax node can be cast to a given specialized syntax type.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  public func `is`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  public func `as`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given specialized syntax type.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  public func cast<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }


  /// Checks if the current syntax node can be upcast to its base node type (``TypeSyntax``).
  ///
  /// - Returns: `true` since the node can always be upcast to its base node.
  @available(*, deprecated, message: "This cast will always succeed")
  public func `is`(_ syntaxType: TypeSyntax.Type) -> Bool {
    return true
  }


  /// Attempts to upcast the current syntax node to its base node type (``TypeSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `TypeSyntax.init` for upcasting")
  public func `as`(_ syntaxType: TypeSyntax.Type) -> TypeSyntax? {
    return TypeSyntax(self)
  }


  /// Force-upcast the current syntax node to its base node type (``TypeSyntax``).
  ///
  /// - Returns: The base node created from the current syntax node, as the node can always be upcast to its base type.
  @available(*, deprecated, message: "Use `TypeSyntax.init` for upcasting")
  public func cast(_ syntaxType: TypeSyntax.Type) -> TypeSyntax {
    return TypeSyntax(self)
  }


  /// Checks if the current syntax node can be cast to a given node type from a base node protocol hierarchy other
  /// than ``TypeSyntaxProtocol``.
  ///
  /// - Returns: `true` if the node can be cast, `false` otherwise.
  ///
  /// - Note: In most cases, this is comparing a ``TypeSyntaxProtocol`` to a node that is not a
  ///   ``TypeSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``TypeSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'TypeSyntaxProtocol' hierarchy")
  public func `is`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return self.as(syntaxType) != nil
  }


  /// Attempts to cast the current syntax node to a given node type from the a base node protocol hierarchy other than
  /// ``TypeSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
  ///
  /// - Note: In most cases, this is casting a ``TypeSyntaxProtocol`` to a node that is not a
  ///   ``TypeSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``TypeSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'TypeSyntaxProtocol' hierarchy")
  public func `as`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return S.init(self)
  }


  /// Force-casts the current syntax node to a given node type from a base node protocol hierarchy other than
  /// ``TypeSyntaxProtocol``.
  ///
  /// - Returns: An instance of the specialized type.
  ///
  /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
  ///
  /// - Note: In most cases, this is casting a ``TypeSyntaxProtocol`` to a node that is not a
  ///   ``TypeSyntaxProtocol``, which will always fail. If the `syntaxType` argument is a generic type,
  ///   constrain it to ``TypeSyntaxProtocol`` instead of ``SyntaxProtocol``.
  @available(*, deprecated, message: "Type argument should be part of the 'TypeSyntaxProtocol' hierarchy")
  public func cast<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S {
    return self.as(S.self)!
  }
}

extension Syntax {
  /// Check whether the non-type erased version of this syntax node conforms to
  /// TypeSyntaxProtocol.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func isProtocol(_: TypeSyntaxProtocol.Protocol) -> Bool {
    return self.asProtocol(TypeSyntaxProtocol.self) != nil
  }

  /// Return the non-type erased version of this syntax node if it conforms to
  /// TypeSyntaxProtocol. Otherwise return nil.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: TypeSyntaxProtocol.Protocol) -> TypeSyntaxProtocol? {
    return self.asProtocol(SyntaxProtocol.self) as? TypeSyntaxProtocol
  }
}

/// ### Subtypes
/// 
/// - ``ArrayTypeSyntax``
/// - ``AttributedTypeSyntax``
/// - ``ClassRestrictionTypeSyntax``
/// - ``CompositionTypeSyntax``
/// - ``DictionaryTypeSyntax``
/// - ``FunctionTypeSyntax``
/// - ``IdentifierTypeSyntax``
/// - ``ImplicitlyUnwrappedOptionalTypeSyntax``
/// - ``InlineArrayTypeSyntax``
/// - ``MemberTypeSyntax``
/// - ``MetatypeTypeSyntax``
/// - ``MissingTypeSyntax``
/// - ``NamedOpaqueReturnTypeSyntax``
/// - ``OptionalTypeSyntax``
/// - ``PackElementTypeSyntax``
/// - ``PackExpansionTypeSyntax``
/// - ``SomeOrAnyTypeSyntax``
/// - ``SuppressedTypeSyntax``
/// - ``TupleTypeSyntax``
public struct TypeSyntax: TypeSyntaxProtocol, SyntaxHashable {
  public let _syntaxNode: Syntax

  /// Create a ``TypeSyntax`` node from a specialized syntax node.
  public init(_ syntax: __shared some TypeSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``TypeSyntax`` node from a specialized optional syntax node.
  public init?(_ syntax: __shared (some TypeSyntaxProtocol)?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(syntax)
  }

  public init(fromProtocol syntax: __shared TypeSyntaxProtocol) {
    // We know this cast is going to succeed. Go through `init(_: SyntaxData)` just to double-check and
    // verify the kind matches in debug builds and get maximum performance in release builds.
    self = Syntax(syntax).cast(Self.self)
  }

  /// Create a ``TypeSyntax`` node from a specialized optional syntax node.
  public init?(fromProtocol syntax: __shared TypeSyntaxProtocol?) {
    guard let syntax = syntax else {
      return nil
    }
    self.init(fromProtocol: syntax)
  }

  public init?(_ node: __shared some SyntaxProtocol) {
    switch node.raw.kind {
    case .arrayType, .attributedType, .classRestrictionType, .compositionType, .dictionaryType, .functionType, .identifierType, .implicitlyUnwrappedOptionalType, .inlineArrayType, .memberType, .metatypeType, .missingType, .namedOpaqueReturnType, .optionalType, .packElementType, .packExpansionType, .someOrAnyType, .suppressedType, .tupleType:
      self._syntaxNode = node._syntaxNode
    default:
      return nil
    }
  }

  /// Syntax nodes always conform to `TypeSyntaxProtocol`. This API is just
  /// added for consistency.
  ///
  ///  - Note:  This will incur an existential conversion.
  @available(*, deprecated, message: "Expression always evaluates to true")
  public func isProtocol(_: TypeSyntaxProtocol.Protocol) -> Bool {
    return true
  }

  /// Return the non-type erased version of this syntax node.
  ///
  ///  - Note:  This will incur an existential conversion.
  public func asProtocol(_: TypeSyntaxProtocol.Protocol) -> TypeSyntaxProtocol {
    return Syntax(self).asProtocol(TypeSyntaxProtocol.self)!
  }

  public static var structure: SyntaxNodeStructure {
    return .choices([
      .node(ArrayTypeSyntax.self),
      .node(AttributedTypeSyntax.self),
      .node(ClassRestrictionTypeSyntax.self),
      .node(CompositionTypeSyntax.self),
      .node(DictionaryTypeSyntax.self),
      .node(FunctionTypeSyntax.self),
      .node(IdentifierTypeSyntax.self),
      .node(ImplicitlyUnwrappedOptionalTypeSyntax.self),
      .node(InlineArrayTypeSyntax.self),
      .node(MemberTypeSyntax.self),
      .node(MetatypeTypeSyntax.self),
      .node(MissingTypeSyntax.self),
      .node(NamedOpaqueReturnTypeSyntax.self),
      .node(OptionalTypeSyntax.self),
      .node(PackElementTypeSyntax.self),
      .node(PackExpansionTypeSyntax.self),
      .node(SomeOrAnyTypeSyntax.self),
      .node(SuppressedTypeSyntax.self),
      .node(TupleTypeSyntax.self)
    ])
  }
}

/// Protocol that syntax nodes conform to if they don't have any semantic subtypes.
/// These are syntax nodes that are not considered base nodes for other syntax types.
///
/// Syntax nodes conforming to this protocol have their inherited casting methods
/// deprecated to prevent incorrect casting.
public protocol _LeafTypeSyntaxNodeProtocol: TypeSyntaxProtocol {}

extension _LeafTypeSyntaxNodeProtocol {
  /// Checks if the current leaf syntax node can be cast to a different specified type.
  ///
  /// - Returns: `false` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `is` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `is`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return false
  }


  /// Attempts to cast the current leaf syntax node to a different specified type.
  ///
  /// - Returns: `nil` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `as` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `as`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return nil
  }


  /// Force-casts the current leaf syntax node to a different specified type.
  ///
  /// - Returns: This method will always trigger a runtime crash and never return.
  ///
  /// - Note: This method overloads the general `cast` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  /// - Warning: Invoking this method will lead to a fatal error.
  @available(*, deprecated, message: "This cast will always fail")
  public func cast<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S {
    fatalError("\(Self.self) cannot be cast to \(S.self)")
  }
}

// MARK: - Syntax

extension Syntax {
  public static var structure: SyntaxNodeStructure {
    return .choices([
      .node(TokenSyntax.self),
      .node(ABIAttributeArgumentsSyntax.self),
      .node(AccessorBlockFileSyntax.self),
      .node(AccessorBlockSyntax.self),
      .node(AccessorDeclListSyntax.self),
      .node(AccessorDeclSyntax.self),
      .node(AccessorEffectSpecifiersSyntax.self),
      .node(AccessorParametersSyntax.self),
      .node(ActorDeclSyntax.self),
      .node(ArrayElementListSyntax.self),
      .node(ArrayElementSyntax.self),
      .node(ArrayExprSyntax.self),
      .node(ArrayTypeSyntax.self),
      .node(ArrowExprSyntax.self),
      .node(AsExprSyntax.self),
      .node(AssignmentExprSyntax.self),
      .node(AssociatedTypeDeclSyntax.self),
      .node(AttributeClauseFileSyntax.self),
      .node(AttributeListSyntax.self),
      .node(AttributeSyntax.self),
      .node(AttributedTypeSyntax.self),
      .node(AvailabilityArgumentListSyntax.self),
      .node(AvailabilityArgumentSyntax.self),
      .node(AvailabilityConditionSyntax.self),
      .node(AvailabilityLabeledArgumentSyntax.self),
      .node(AvailabilityMacroDefinitionFileSyntax.self),
      .node(AwaitExprSyntax.self),
      .node(BackDeployedAttributeArgumentsSyntax.self),
      .node(BinaryOperatorExprSyntax.self),
      .node(BooleanLiteralExprSyntax.self),
      .node(BorrowExprSyntax.self),
      .node(BreakStmtSyntax.self),
      .node(_CanImportExprSyntax.self),
      .node(_CanImportVersionInfoSyntax.self),
      .node(CatchClauseListSyntax.self),
      .node(CatchClauseSyntax.self),
      .node(CatchItemListSyntax.self),
      .node(CatchItemSyntax.self),
      .node(ClassDeclSyntax.self),
      .node(ClassRestrictionTypeSyntax.self),
      .node(ClosureCaptureClauseSyntax.self),
      .node(ClosureCaptureListSyntax.self),
      .node(ClosureCaptureSpecifierSyntax.self),
      .node(ClosureCaptureSyntax.self),
      .node(ClosureExprSyntax.self),
      .node(ClosureParameterClauseSyntax.self),
      .node(ClosureParameterListSyntax.self),
      .node(ClosureParameterSyntax.self),
      .node(ClosureShorthandParameterListSyntax.self),
      .node(ClosureShorthandParameterSyntax.self),
      .node(ClosureSignatureSyntax.self),
      .node(CodeBlockFileSyntax.self),
      .node(CodeBlockItemListSyntax.self),
      .node(CodeBlockItemSyntax.self),
      .node(CodeBlockSyntax.self),
      .node(CompositionTypeElementListSyntax.self),
      .node(CompositionTypeElementSyntax.self),
      .node(CompositionTypeSyntax.self),
      .node(ConditionElementListSyntax.self),
      .node(ConditionElementSyntax.self),
      .node(ConformanceRequirementSyntax.self),
      .node(ConsumeExprSyntax.self),
      .node(ContinueStmtSyntax.self),
      .node(CopyExprSyntax.self),
      .node(DeclModifierDetailSyntax.self),
      .node(DeclModifierListSyntax.self),
      .node(DeclModifierSyntax.self),
      .node(DeclNameArgumentListSyntax.self),
      .node(DeclNameArgumentSyntax.self),
      .node(DeclNameArgumentsSyntax.self),
      .node(DeclReferenceExprSyntax.self),
      .node(DeferStmtSyntax.self),
      .node(DeinitializerDeclSyntax.self),
      .node(DeinitializerEffectSpecifiersSyntax.self),
      .node(DerivativeAttributeArgumentsSyntax.self),
      .node(DesignatedTypeListSyntax.self),
      .node(DesignatedTypeSyntax.self),
      .node(DictionaryElementListSyntax.self),
      .node(DictionaryElementSyntax.self),
      .node(DictionaryExprSyntax.self),
      .node(DictionaryTypeSyntax.self),
      .node(DifferentiabilityArgumentListSyntax.self),
      .node(DifferentiabilityArgumentSyntax.self),
      .node(DifferentiabilityArgumentsSyntax.self),
      .node(DifferentiabilityWithRespectToArgumentSyntax.self),
      .node(DifferentiableAttributeArgumentsSyntax.self),
      .node(DiscardAssignmentExprSyntax.self),
      .node(DiscardStmtSyntax.self),
      .node(DoExprSyntax.self),
      .node(DoStmtSyntax.self),
      .node(DocumentationAttributeArgumentListSyntax.self),
      .node(DocumentationAttributeArgumentSyntax.self),
      .node(DynamicReplacementAttributeArgumentsSyntax.self),
      .node(EditorPlaceholderDeclSyntax.self),
      .node(EditorPlaceholderExprSyntax.self),
      .node(EffectsAttributeArgumentListSyntax.self),
      .node(EnumCaseDeclSyntax.self),
      .node(EnumCaseElementListSyntax.self),
      .node(EnumCaseElementSyntax.self),
      .node(EnumCaseParameterClauseSyntax.self),
      .node(EnumCaseParameterListSyntax.self),
      .node(EnumCaseParameterSyntax.self),
      .node(EnumDeclSyntax.self),
      .node(ExprListSyntax.self),
      .node(ExpressionPatternSyntax.self),
      .node(ExpressionSegmentSyntax.self),
      .node(ExpressionStmtSyntax.self),
      .node(ExtensionDeclSyntax.self),
      .node(FallThroughStmtSyntax.self),
      .node(FloatLiteralExprSyntax.self),
      .node(ForStmtSyntax.self),
      .node(ForceUnwrapExprSyntax.self),
      .node(FunctionCallExprSyntax.self),
      .node(FunctionDeclSyntax.self),
      .node(FunctionEffectSpecifiersSyntax.self),
      .node(FunctionParameterClauseSyntax.self),
      .node(FunctionParameterListSyntax.self),
      .node(FunctionParameterSyntax.self),
      .node(FunctionSignatureSyntax.self),
      .node(FunctionTypeSyntax.self),
      .node(GenericArgumentClauseSyntax.self),
      .node(GenericArgumentListSyntax.self),
      .node(GenericArgumentSyntax.self),
      .node(GenericParameterClauseSyntax.self),
      .node(GenericParameterListSyntax.self),
      .node(GenericParameterSyntax.self),
      .node(GenericRequirementListSyntax.self),
      .node(GenericRequirementSyntax.self),
      .node(GenericSpecializationExprSyntax.self),
      .node(GenericWhereClauseSyntax.self),
      .node(GuardStmtSyntax.self),
      .node(IdentifierPatternSyntax.self),
      .node(IdentifierTypeSyntax.self),
      .node(IfConfigClauseListSyntax.self),
      .node(IfConfigClauseSyntax.self),
      .node(IfConfigDeclSyntax.self),
      .node(IfExprSyntax.self),
      .node(ImplementsAttributeArgumentsSyntax.self),
      .node(ImplicitlyUnwrappedOptionalTypeSyntax.self),
      .node(ImportDeclSyntax.self),
      .node(ImportPathComponentListSyntax.self),
      .node(ImportPathComponentSyntax.self),
      .node(InOutExprSyntax.self),
      .node(InfixOperatorExprSyntax.self),
      .node(InheritanceClauseSyntax.self),
      .node(InheritedTypeListSyntax.self),
      .node(InheritedTypeSyntax.self),
      .node(InitializerClauseSyntax.self),
      .node(InitializerDeclSyntax.self),
      .node(InlineArrayTypeSyntax.self),
      .node(IntegerLiteralExprSyntax.self),
      .node(IsExprSyntax.self),
      .node(IsTypePatternSyntax.self),
      .node(KeyPathComponentListSyntax.self),
      .node(KeyPathComponentSyntax.self),
      .node(KeyPathExprSyntax.self),
      .node(KeyPathMethodComponentSyntax.self),
      .node(KeyPathOptionalComponentSyntax.self),
      .node(KeyPathPropertyComponentSyntax.self),
      .node(KeyPathSubscriptComponentSyntax.self),
      .node(LabeledExprListSyntax.self),
      .node(LabeledExprSyntax.self),
      .node(LabeledSpecializeArgumentSyntax.self),
      .node(LabeledStmtSyntax.self),
      .node(LayoutRequirementSyntax.self),
      .node(LifetimeSpecifierArgumentListSyntax.self),
      .node(LifetimeSpecifierArgumentSyntax.self),
      .node(LifetimeTypeSpecifierSyntax.self),
      .node(MacroDeclSyntax.self),
      .node(MacroExpansionDeclSyntax.self),
      .node(MacroExpansionExprSyntax.self),
      .node(MatchingPatternConditionSyntax.self),
      .node(MemberAccessExprSyntax.self),
      .node(MemberBlockItemListFileSyntax.self),
      .node(MemberBlockItemListSyntax.self),
      .node(MemberBlockItemSyntax.self),
      .node(MemberBlockSyntax.self),
      .node(MemberTypeSyntax.self),
      .node(MetatypeTypeSyntax.self),
      .node(MissingDeclSyntax.self),
      .node(MissingExprSyntax.self),
      .node(MissingPatternSyntax.self),
      .node(MissingStmtSyntax.self),
      .node(MissingSyntax.self),
      .node(MissingTypeSyntax.self),
      .node(ModuleSelectorSyntax.self),
      .node(MultipleTrailingClosureElementListSyntax.self),
      .node(MultipleTrailingClosureElementSyntax.self),
      .node(NamedOpaqueReturnTypeSyntax.self),
      .node(NilLiteralExprSyntax.self),
      .node(NonisolatedSpecifierArgumentSyntax.self),
      .node(NonisolatedTypeSpecifierSyntax.self),
      .node(ObjCSelectorPieceListSyntax.self),
      .node(ObjCSelectorPieceSyntax.self),
      .node(OperatorDeclSyntax.self),
      .node(OperatorPrecedenceAndTypesSyntax.self),
      .node(OptionalBindingConditionSyntax.self),
      .node(OptionalChainingExprSyntax.self),
      .node(OptionalTypeSyntax.self),
      .node(OriginallyDefinedInAttributeArgumentsSyntax.self),
      .node(PackElementExprSyntax.self),
      .node(PackElementTypeSyntax.self),
      .node(PackExpansionExprSyntax.self),
      .node(PackExpansionTypeSyntax.self),
      .node(PatternBindingListSyntax.self),
      .node(PatternBindingSyntax.self),
      .node(PatternExprSyntax.self),
      .node(PlatformVersionItemListSyntax.self),
      .node(PlatformVersionItemSyntax.self),
      .node(PlatformVersionSyntax.self),
      .node(PostfixIfConfigExprSyntax.self),
      .node(PostfixOperatorExprSyntax.self),
      .node(PoundSourceLocationArgumentsSyntax.self),
      .node(PoundSourceLocationSyntax.self),
      .node(PrecedenceGroupAssignmentSyntax.self),
      .node(PrecedenceGroupAssociativitySyntax.self),
      .node(PrecedenceGroupAttributeListSyntax.self),
      .node(PrecedenceGroupDeclSyntax.self),
      .node(PrecedenceGroupNameListSyntax.self),
      .node(PrecedenceGroupNameSyntax.self),
      .node(PrecedenceGroupRelationSyntax.self),
      .node(PrefixOperatorExprSyntax.self),
      .node(PrimaryAssociatedTypeClauseSyntax.self),
      .node(PrimaryAssociatedTypeListSyntax.self),
      .node(PrimaryAssociatedTypeSyntax.self),
      .node(ProtocolDeclSyntax.self),
      .node(RegexLiteralExprSyntax.self),
      .node(RepeatStmtSyntax.self),
      .node(ReturnClauseSyntax.self),
      .node(ReturnStmtSyntax.self),
      .node(SameTypeRequirementSyntax.self),
      .node(SequenceExprSyntax.self),
      .node(SimpleStringLiteralExprSyntax.self),
      .node(SimpleStringLiteralSegmentListSyntax.self),
      .node(SimpleTypeSpecifierSyntax.self),
      .node(SomeOrAnyTypeSyntax.self),
      .node(SourceFileSyntax.self),
      .node(SpecializeAttributeArgumentListSyntax.self),
      .node(SpecializeAvailabilityArgumentSyntax.self),
      .node(SpecializeTargetFunctionArgumentSyntax.self),
      .node(SpecializedAttributeArgumentSyntax.self),
      .node(StringLiteralExprSyntax.self),
      .node(StringLiteralSegmentListSyntax.self),
      .node(StringSegmentSyntax.self),
      .node(StructDeclSyntax.self),
      .node(SubscriptCallExprSyntax.self),
      .node(SubscriptDeclSyntax.self),
      .node(SuperExprSyntax.self),
      .node(SuppressedTypeSyntax.self),
      .node(SwitchCaseItemListSyntax.self),
      .node(SwitchCaseItemSyntax.self),
      .node(SwitchCaseLabelSyntax.self),
      .node(SwitchCaseListSyntax.self),
      .node(SwitchCaseSyntax.self),
      .node(SwitchDefaultLabelSyntax.self),
      .node(SwitchExprSyntax.self),
      .node(TernaryExprSyntax.self),
      .node(ThenStmtSyntax.self),
      .node(ThrowStmtSyntax.self),
      .node(ThrowsClauseSyntax.self),
      .node(TryExprSyntax.self),
      .node(TupleExprSyntax.self),
      .node(TuplePatternElementListSyntax.self),
      .node(TuplePatternElementSyntax.self),
      .node(TuplePatternSyntax.self),
      .node(TupleTypeElementListSyntax.self),
      .node(TupleTypeElementSyntax.self),
      .node(TupleTypeSyntax.self),
      .node(TypeAliasDeclSyntax.self),
      .node(TypeAnnotationSyntax.self),
      .node(TypeEffectSpecifiersSyntax.self),
      .node(TypeExprSyntax.self),
      .node(TypeInitializerClauseSyntax.self),
      .node(TypeSpecifierListSyntax.self),
      .node(UnexpectedNodesSyntax.self),
      .node(UnresolvedAsExprSyntax.self),
      .node(UnresolvedIsExprSyntax.self),
      .node(UnresolvedTernaryExprSyntax.self),
      .node(UnsafeExprSyntax.self),
      .node(UsingDeclSyntax.self),
      .node(ValueBindingPatternSyntax.self),
      .node(VariableDeclSyntax.self),
      .node(VersionComponentListSyntax.self),
      .node(VersionComponentSyntax.self),
      .node(VersionTupleSyntax.self),
      .node(WhereClauseSyntax.self),
      .node(WhileStmtSyntax.self),
      .node(WildcardPatternSyntax.self),
      .node(YieldStmtSyntax.self),
      .node(YieldedExpressionListSyntax.self),
      .node(YieldedExpressionSyntax.self),
      .node(YieldedExpressionsClauseSyntax.self)
    ])
  }
}

/// Protocol that syntax nodes conform to if they don't have any semantic subtypes.
/// These are syntax nodes that are not considered base nodes for other syntax types.
///
/// Syntax nodes conforming to this protocol have their inherited casting methods
/// deprecated to prevent incorrect casting.
public protocol _LeafSyntaxNodeProtocol: SyntaxProtocol {}

extension _LeafSyntaxNodeProtocol {
  /// Checks if the current leaf syntax node can be cast to a different specified type.
  ///
  /// - Returns: `false` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `is` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `is`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> Bool {
    return false
  }


  /// Attempts to cast the current leaf syntax node to a different specified type.
  ///
  /// - Returns: `nil` since the leaf node cannot be cast to a different specified type.
  ///
  /// - Note: This method overloads the general `as` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  @available(*, deprecated, message: "This cast will always fail")
  public func `as`<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S? {
    return nil
  }


  /// Force-casts the current leaf syntax node to a different specified type.
  ///
  /// - Returns: This method will always trigger a runtime crash and never return.
  ///
  /// - Note: This method overloads the general `cast` method and is marked as deprecated to produce a warning,
  ///         informing the user that the cast will always fail.
  /// - Warning: Invoking this method will lead to a fatal error.
  @available(*, deprecated, message: "This cast will always fail")
  public func cast<S: SyntaxProtocol>(_ syntaxType: S.Type) -> S {
    fatalError("\(Self.self) cannot be cast to \(S.self)")
  }
}
