//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

/// Enum to exhaustively switch over all different syntax nodes.
public enum SyntaxEnum: Sendable {
  case token(TokenSyntax)
  case abiAttributeArguments(ABIAttributeArgumentsSyntax)
  @_spi(Compiler)
  case accessorBlockFile(AccessorBlockFileSyntax)
  case accessorBlock(AccessorBlockSyntax)
  case accessorDeclList(AccessorDeclListSyntax)
  case accessorDecl(AccessorDeclSyntax)
  case accessorEffectSpecifiers(AccessorEffectSpecifiersSyntax)
  case accessorParameters(AccessorParametersSyntax)
  case actorDecl(ActorDeclSyntax)
  case arrayElementList(ArrayElementListSyntax)
  case arrayElement(ArrayElementSyntax)
  case arrayExpr(ArrayExprSyntax)
  case arrayType(ArrayTypeSyntax)
  case arrowExpr(ArrowExprSyntax)
  case asExpr(AsExprSyntax)
  case assignmentExpr(AssignmentExprSyntax)
  case associatedTypeDecl(AssociatedTypeDeclSyntax)
  @_spi(Compiler)
  case attributeClauseFile(AttributeClauseFileSyntax)
  case attributeList(AttributeListSyntax)
  case attribute(AttributeSyntax)
  case attributedType(AttributedTypeSyntax)
  case availabilityArgumentList(AvailabilityArgumentListSyntax)
  case availabilityArgument(AvailabilityArgumentSyntax)
  case availabilityCondition(AvailabilityConditionSyntax)
  case availabilityLabeledArgument(AvailabilityLabeledArgumentSyntax)
  @_spi(Compiler)
  case availabilityMacroDefinitionFile(AvailabilityMacroDefinitionFileSyntax)
  case awaitExpr(AwaitExprSyntax)
  case backDeployedAttributeArguments(BackDeployedAttributeArgumentsSyntax)
  case binaryOperatorExpr(BinaryOperatorExprSyntax)
  case booleanLiteralExpr(BooleanLiteralExprSyntax)
  case borrowExpr(BorrowExprSyntax)
  case breakStmt(BreakStmtSyntax)
  case _canImportExpr(_CanImportExprSyntax)
  case _canImportVersionInfo(_CanImportVersionInfoSyntax)
  case catchClauseList(CatchClauseListSyntax)
  case catchClause(CatchClauseSyntax)
  case catchItemList(CatchItemListSyntax)
  case catchItem(CatchItemSyntax)
  case classDecl(ClassDeclSyntax)
  case classRestrictionType(ClassRestrictionTypeSyntax)
  case closureCaptureClause(ClosureCaptureClauseSyntax)
  case closureCaptureList(ClosureCaptureListSyntax)
  case closureCaptureSpecifier(ClosureCaptureSpecifierSyntax)
  case closureCapture(ClosureCaptureSyntax)
  case closureExpr(ClosureExprSyntax)
  case closureParameterClause(ClosureParameterClauseSyntax)
  case closureParameterList(ClosureParameterListSyntax)
  case closureParameter(ClosureParameterSyntax)
  case closureShorthandParameterList(ClosureShorthandParameterListSyntax)
  case closureShorthandParameter(ClosureShorthandParameterSyntax)
  case closureSignature(ClosureSignatureSyntax)
  @_spi(Compiler)
  case codeBlockFile(CodeBlockFileSyntax)
  case codeBlockItemList(CodeBlockItemListSyntax)
  case codeBlockItem(CodeBlockItemSyntax)
  case codeBlock(CodeBlockSyntax)
  case compositionTypeElementList(CompositionTypeElementListSyntax)
  case compositionTypeElement(CompositionTypeElementSyntax)
  case compositionType(CompositionTypeSyntax)
  case conditionElementList(ConditionElementListSyntax)
  case conditionElement(ConditionElementSyntax)
  case conformanceRequirement(ConformanceRequirementSyntax)
  case consumeExpr(ConsumeExprSyntax)
  case continueStmt(ContinueStmtSyntax)
  case copyExpr(CopyExprSyntax)
  case declModifierDetail(DeclModifierDetailSyntax)
  case declModifierList(DeclModifierListSyntax)
  case declModifier(DeclModifierSyntax)
  case declNameArgumentList(DeclNameArgumentListSyntax)
  case declNameArgument(DeclNameArgumentSyntax)
  case declNameArguments(DeclNameArgumentsSyntax)
  case declReferenceExpr(DeclReferenceExprSyntax)
  case deferStmt(DeferStmtSyntax)
  case deinitializerDecl(DeinitializerDeclSyntax)
  case deinitializerEffectSpecifiers(DeinitializerEffectSpecifiersSyntax)
  case derivativeAttributeArguments(DerivativeAttributeArgumentsSyntax)
  case designatedTypeList(DesignatedTypeListSyntax)
  case designatedType(DesignatedTypeSyntax)
  case dictionaryElementList(DictionaryElementListSyntax)
  case dictionaryElement(DictionaryElementSyntax)
  case dictionaryExpr(DictionaryExprSyntax)
  case dictionaryType(DictionaryTypeSyntax)
  case differentiabilityArgumentList(DifferentiabilityArgumentListSyntax)
  case differentiabilityArgument(DifferentiabilityArgumentSyntax)
  case differentiabilityArguments(DifferentiabilityArgumentsSyntax)
  case differentiabilityWithRespectToArgument(DifferentiabilityWithRespectToArgumentSyntax)
  case differentiableAttributeArguments(DifferentiableAttributeArgumentsSyntax)
  case discardAssignmentExpr(DiscardAssignmentExprSyntax)
  case discardStmt(DiscardStmtSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case doExpr(DoExprSyntax)
  case doStmt(DoStmtSyntax)
  case documentationAttributeArgumentList(DocumentationAttributeArgumentListSyntax)
  case documentationAttributeArgument(DocumentationAttributeArgumentSyntax)
  case dynamicReplacementAttributeArguments(DynamicReplacementAttributeArgumentsSyntax)
  case editorPlaceholderDecl(EditorPlaceholderDeclSyntax)
  case editorPlaceholderExpr(EditorPlaceholderExprSyntax)
  case effectsAttributeArgumentList(EffectsAttributeArgumentListSyntax)
  case enumCaseDecl(EnumCaseDeclSyntax)
  case enumCaseElementList(EnumCaseElementListSyntax)
  case enumCaseElement(EnumCaseElementSyntax)
  case enumCaseParameterClause(EnumCaseParameterClauseSyntax)
  case enumCaseParameterList(EnumCaseParameterListSyntax)
  case enumCaseParameter(EnumCaseParameterSyntax)
  case enumDecl(EnumDeclSyntax)
  case exprList(ExprListSyntax)
  case expressionPattern(ExpressionPatternSyntax)
  case expressionSegment(ExpressionSegmentSyntax)
  case expressionStmt(ExpressionStmtSyntax)
  case extensionDecl(ExtensionDeclSyntax)
  case fallThroughStmt(FallThroughStmtSyntax)
  case floatLiteralExpr(FloatLiteralExprSyntax)
  case forStmt(ForStmtSyntax)
  case forceUnwrapExpr(ForceUnwrapExprSyntax)
  case functionCallExpr(FunctionCallExprSyntax)
  case functionDecl(FunctionDeclSyntax)
  case functionEffectSpecifiers(FunctionEffectSpecifiersSyntax)
  case functionParameterClause(FunctionParameterClauseSyntax)
  case functionParameterList(FunctionParameterListSyntax)
  case functionParameter(FunctionParameterSyntax)
  case functionSignature(FunctionSignatureSyntax)
  case functionType(FunctionTypeSyntax)
  case genericArgumentClause(GenericArgumentClauseSyntax)
  case genericArgumentList(GenericArgumentListSyntax)
  case genericArgument(GenericArgumentSyntax)
  case genericParameterClause(GenericParameterClauseSyntax)
  case genericParameterList(GenericParameterListSyntax)
  case genericParameter(GenericParameterSyntax)
  case genericRequirementList(GenericRequirementListSyntax)
  case genericRequirement(GenericRequirementSyntax)
  case genericSpecializationExpr(GenericSpecializationExprSyntax)
  case genericWhereClause(GenericWhereClauseSyntax)
  case guardStmt(GuardStmtSyntax)
  case identifierPattern(IdentifierPatternSyntax)
  case identifierType(IdentifierTypeSyntax)
  case ifConfigClauseList(IfConfigClauseListSyntax)
  case ifConfigClause(IfConfigClauseSyntax)
  case ifConfigDecl(IfConfigDeclSyntax)
  case ifExpr(IfExprSyntax)
  case implementsAttributeArguments(ImplementsAttributeArgumentsSyntax)
  case implicitlyUnwrappedOptionalType(ImplicitlyUnwrappedOptionalTypeSyntax)
  case importDecl(ImportDeclSyntax)
  case importPathComponentList(ImportPathComponentListSyntax)
  case importPathComponent(ImportPathComponentSyntax)
  case inOutExpr(InOutExprSyntax)
  case infixOperatorExpr(InfixOperatorExprSyntax)
  case inheritanceClause(InheritanceClauseSyntax)
  case inheritedTypeList(InheritedTypeListSyntax)
  case inheritedType(InheritedTypeSyntax)
  case initializerClause(InitializerClauseSyntax)
  case initializerDecl(InitializerDeclSyntax)
  case inlineArrayType(InlineArrayTypeSyntax)
  case integerLiteralExpr(IntegerLiteralExprSyntax)
  case isExpr(IsExprSyntax)
  case isTypePattern(IsTypePatternSyntax)
  case keyPathComponentList(KeyPathComponentListSyntax)
  case keyPathComponent(KeyPathComponentSyntax)
  case keyPathExpr(KeyPathExprSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case keyPathMethodComponent(KeyPathMethodComponentSyntax)
  case keyPathOptionalComponent(KeyPathOptionalComponentSyntax)
  case keyPathPropertyComponent(KeyPathPropertyComponentSyntax)
  case keyPathSubscriptComponent(KeyPathSubscriptComponentSyntax)
  case labeledExprList(LabeledExprListSyntax)
  case labeledExpr(LabeledExprSyntax)
  case labeledSpecializeArgument(LabeledSpecializeArgumentSyntax)
  case labeledStmt(LabeledStmtSyntax)
  case layoutRequirement(LayoutRequirementSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case lifetimeSpecifierArgumentList(LifetimeSpecifierArgumentListSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case lifetimeSpecifierArgument(LifetimeSpecifierArgumentSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case lifetimeTypeSpecifier(LifetimeTypeSpecifierSyntax)
  case macroDecl(MacroDeclSyntax)
  case macroExpansionDecl(MacroExpansionDeclSyntax)
  case macroExpansionExpr(MacroExpansionExprSyntax)
  case matchingPatternCondition(MatchingPatternConditionSyntax)
  case memberAccessExpr(MemberAccessExprSyntax)
  @_spi(Compiler)
  case memberBlockItemListFile(MemberBlockItemListFileSyntax)
  case memberBlockItemList(MemberBlockItemListSyntax)
  case memberBlockItem(MemberBlockItemSyntax)
  case memberBlock(MemberBlockSyntax)
  case memberType(MemberTypeSyntax)
  case metatypeType(MetatypeTypeSyntax)
  case missingDecl(MissingDeclSyntax)
  case missingExpr(MissingExprSyntax)
  case missingPattern(MissingPatternSyntax)
  case missingStmt(MissingStmtSyntax)
  case missing(MissingSyntax)
  case missingType(MissingTypeSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case moduleSelector(ModuleSelectorSyntax)
  case multipleTrailingClosureElementList(MultipleTrailingClosureElementListSyntax)
  case multipleTrailingClosureElement(MultipleTrailingClosureElementSyntax)
  case namedOpaqueReturnType(NamedOpaqueReturnTypeSyntax)
  case nilLiteralExpr(NilLiteralExprSyntax)
  case nonisolatedSpecifierArgument(NonisolatedSpecifierArgumentSyntax)
  case nonisolatedTypeSpecifier(NonisolatedTypeSpecifierSyntax)
  case objCSelectorPieceList(ObjCSelectorPieceListSyntax)
  case objCSelectorPiece(ObjCSelectorPieceSyntax)
  case operatorDecl(OperatorDeclSyntax)
  case operatorPrecedenceAndTypes(OperatorPrecedenceAndTypesSyntax)
  case optionalBindingCondition(OptionalBindingConditionSyntax)
  case optionalChainingExpr(OptionalChainingExprSyntax)
  case optionalType(OptionalTypeSyntax)
  case originallyDefinedInAttributeArguments(OriginallyDefinedInAttributeArgumentsSyntax)
  case packElementExpr(PackElementExprSyntax)
  case packElementType(PackElementTypeSyntax)
  case packExpansionExpr(PackExpansionExprSyntax)
  case packExpansionType(PackExpansionTypeSyntax)
  case patternBindingList(PatternBindingListSyntax)
  case patternBinding(PatternBindingSyntax)
  case patternExpr(PatternExprSyntax)
  case platformVersionItemList(PlatformVersionItemListSyntax)
  case platformVersionItem(PlatformVersionItemSyntax)
  case platformVersion(PlatformVersionSyntax)
  case postfixIfConfigExpr(PostfixIfConfigExprSyntax)
  case postfixOperatorExpr(PostfixOperatorExprSyntax)
  case poundSourceLocationArguments(PoundSourceLocationArgumentsSyntax)
  case poundSourceLocation(PoundSourceLocationSyntax)
  case precedenceGroupAssignment(PrecedenceGroupAssignmentSyntax)
  case precedenceGroupAssociativity(PrecedenceGroupAssociativitySyntax)
  case precedenceGroupAttributeList(PrecedenceGroupAttributeListSyntax)
  case precedenceGroupDecl(PrecedenceGroupDeclSyntax)
  case precedenceGroupNameList(PrecedenceGroupNameListSyntax)
  case precedenceGroupName(PrecedenceGroupNameSyntax)
  case precedenceGroupRelation(PrecedenceGroupRelationSyntax)
  case prefixOperatorExpr(PrefixOperatorExprSyntax)
  case primaryAssociatedTypeClause(PrimaryAssociatedTypeClauseSyntax)
  case primaryAssociatedTypeList(PrimaryAssociatedTypeListSyntax)
  case primaryAssociatedType(PrimaryAssociatedTypeSyntax)
  case protocolDecl(ProtocolDeclSyntax)
  case regexLiteralExpr(RegexLiteralExprSyntax)
  case repeatStmt(RepeatStmtSyntax)
  case returnClause(ReturnClauseSyntax)
  case returnStmt(ReturnStmtSyntax)
  case sameTypeRequirement(SameTypeRequirementSyntax)
  case sequenceExpr(SequenceExprSyntax)
  case simpleStringLiteralExpr(SimpleStringLiteralExprSyntax)
  case simpleStringLiteralSegmentList(SimpleStringLiteralSegmentListSyntax)
  case simpleTypeSpecifier(SimpleTypeSpecifierSyntax)
  case someOrAnyType(SomeOrAnyTypeSyntax)
  case sourceFile(SourceFileSyntax)
  case specializeAttributeArgumentList(SpecializeAttributeArgumentListSyntax)
  case specializeAvailabilityArgument(SpecializeAvailabilityArgumentSyntax)
  case specializeTargetFunctionArgument(SpecializeTargetFunctionArgumentSyntax)
  case specializedAttributeArgument(SpecializedAttributeArgumentSyntax)
  case stringLiteralExpr(StringLiteralExprSyntax)
  case stringLiteralSegmentList(StringLiteralSegmentListSyntax)
  case stringSegment(StringSegmentSyntax)
  case structDecl(StructDeclSyntax)
  case subscriptCallExpr(SubscriptCallExprSyntax)
  case subscriptDecl(SubscriptDeclSyntax)
  case superExpr(SuperExprSyntax)
  case suppressedType(SuppressedTypeSyntax)
  case switchCaseItemList(SwitchCaseItemListSyntax)
  case switchCaseItem(SwitchCaseItemSyntax)
  case switchCaseLabel(SwitchCaseLabelSyntax)
  case switchCaseList(SwitchCaseListSyntax)
  case switchCase(SwitchCaseSyntax)
  case switchDefaultLabel(SwitchDefaultLabelSyntax)
  case switchExpr(SwitchExprSyntax)
  case ternaryExpr(TernaryExprSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case thenStmt(ThenStmtSyntax)
  case throwStmt(ThrowStmtSyntax)
  case throwsClause(ThrowsClauseSyntax)
  case tryExpr(TryExprSyntax)
  case tupleExpr(TupleExprSyntax)
  case tuplePatternElementList(TuplePatternElementListSyntax)
  case tuplePatternElement(TuplePatternElementSyntax)
  case tuplePattern(TuplePatternSyntax)
  case tupleTypeElementList(TupleTypeElementListSyntax)
  case tupleTypeElement(TupleTypeElementSyntax)
  case tupleType(TupleTypeSyntax)
  case typeAliasDecl(TypeAliasDeclSyntax)
  case typeAnnotation(TypeAnnotationSyntax)
  case typeEffectSpecifiers(TypeEffectSpecifiersSyntax)
  case typeExpr(TypeExprSyntax)
  case typeInitializerClause(TypeInitializerClauseSyntax)
  case typeSpecifierList(TypeSpecifierListSyntax)
  case unexpectedNodes(UnexpectedNodesSyntax)
  case unresolvedAsExpr(UnresolvedAsExprSyntax)
  case unresolvedIsExpr(UnresolvedIsExprSyntax)
  case unresolvedTernaryExpr(UnresolvedTernaryExprSyntax)
  case unsafeExpr(UnsafeExprSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case usingDecl(UsingDeclSyntax)
  case valueBindingPattern(ValueBindingPatternSyntax)
  case variableDecl(VariableDeclSyntax)
  case versionComponentList(VersionComponentListSyntax)
  case versionComponent(VersionComponentSyntax)
  case versionTuple(VersionTupleSyntax)
  case whereClause(WhereClauseSyntax)
  case whileStmt(WhileStmtSyntax)
  case wildcardPattern(WildcardPatternSyntax)
  case yieldStmt(YieldStmtSyntax)
  case yieldedExpressionList(YieldedExpressionListSyntax)
  case yieldedExpression(YieldedExpressionSyntax)
  case yieldedExpressionsClause(YieldedExpressionsClauseSyntax)
}

extension Syntax {
  /// Get an enum that can be used to exhaustively switch over all syntax nodes.
  public func `as`(_: SyntaxEnum.Type) -> SyntaxEnum {
    switch raw.kind {
    case .token:
      return .token(TokenSyntax(self)!)
    case .abiAttributeArguments:
      return .abiAttributeArguments(ABIAttributeArgumentsSyntax(self)!)
    case .accessorBlockFile:
      return .accessorBlockFile(AccessorBlockFileSyntax(self)!)
    case .accessorBlock:
      return .accessorBlock(AccessorBlockSyntax(self)!)
    case .accessorDeclList:
      return .accessorDeclList(AccessorDeclListSyntax(self)!)
    case .accessorDecl:
      return .accessorDecl(AccessorDeclSyntax(self)!)
    case .accessorEffectSpecifiers:
      return .accessorEffectSpecifiers(AccessorEffectSpecifiersSyntax(self)!)
    case .accessorParameters:
      return .accessorParameters(AccessorParametersSyntax(self)!)
    case .actorDecl:
      return .actorDecl(ActorDeclSyntax(self)!)
    case .arrayElementList:
      return .arrayElementList(ArrayElementListSyntax(self)!)
    case .arrayElement:
      return .arrayElement(ArrayElementSyntax(self)!)
    case .arrayExpr:
      return .arrayExpr(ArrayExprSyntax(self)!)
    case .arrayType:
      return .arrayType(ArrayTypeSyntax(self)!)
    case .arrowExpr:
      return .arrowExpr(ArrowExprSyntax(self)!)
    case .asExpr:
      return .asExpr(AsExprSyntax(self)!)
    case .assignmentExpr:
      return .assignmentExpr(AssignmentExprSyntax(self)!)
    case .associatedTypeDecl:
      return .associatedTypeDecl(AssociatedTypeDeclSyntax(self)!)
    case .attributeClauseFile:
      return .attributeClauseFile(AttributeClauseFileSyntax(self)!)
    case .attributeList:
      return .attributeList(AttributeListSyntax(self)!)
    case .attribute:
      return .attribute(AttributeSyntax(self)!)
    case .attributedType:
      return .attributedType(AttributedTypeSyntax(self)!)
    case .availabilityArgumentList:
      return .availabilityArgumentList(AvailabilityArgumentListSyntax(self)!)
    case .availabilityArgument:
      return .availabilityArgument(AvailabilityArgumentSyntax(self)!)
    case .availabilityCondition:
      return .availabilityCondition(AvailabilityConditionSyntax(self)!)
    case .availabilityLabeledArgument:
      return .availabilityLabeledArgument(AvailabilityLabeledArgumentSyntax(self)!)
    case .availabilityMacroDefinitionFile:
      return .availabilityMacroDefinitionFile(AvailabilityMacroDefinitionFileSyntax(self)!)
    case .awaitExpr:
      return .awaitExpr(AwaitExprSyntax(self)!)
    case .backDeployedAttributeArguments:
      return .backDeployedAttributeArguments(BackDeployedAttributeArgumentsSyntax(self)!)
    case .binaryOperatorExpr:
      return .binaryOperatorExpr(BinaryOperatorExprSyntax(self)!)
    case .booleanLiteralExpr:
      return .booleanLiteralExpr(BooleanLiteralExprSyntax(self)!)
    case .borrowExpr:
      return .borrowExpr(BorrowExprSyntax(self)!)
    case .breakStmt:
      return .breakStmt(BreakStmtSyntax(self)!)
    case ._canImportExpr:
      return ._canImportExpr(_CanImportExprSyntax(self)!)
    case ._canImportVersionInfo:
      return ._canImportVersionInfo(_CanImportVersionInfoSyntax(self)!)
    case .catchClauseList:
      return .catchClauseList(CatchClauseListSyntax(self)!)
    case .catchClause:
      return .catchClause(CatchClauseSyntax(self)!)
    case .catchItemList:
      return .catchItemList(CatchItemListSyntax(self)!)
    case .catchItem:
      return .catchItem(CatchItemSyntax(self)!)
    case .classDecl:
      return .classDecl(ClassDeclSyntax(self)!)
    case .classRestrictionType:
      return .classRestrictionType(ClassRestrictionTypeSyntax(self)!)
    case .closureCaptureClause:
      return .closureCaptureClause(ClosureCaptureClauseSyntax(self)!)
    case .closureCaptureList:
      return .closureCaptureList(ClosureCaptureListSyntax(self)!)
    case .closureCaptureSpecifier:
      return .closureCaptureSpecifier(ClosureCaptureSpecifierSyntax(self)!)
    case .closureCapture:
      return .closureCapture(ClosureCaptureSyntax(self)!)
    case .closureExpr:
      return .closureExpr(ClosureExprSyntax(self)!)
    case .closureParameterClause:
      return .closureParameterClause(ClosureParameterClauseSyntax(self)!)
    case .closureParameterList:
      return .closureParameterList(ClosureParameterListSyntax(self)!)
    case .closureParameter:
      return .closureParameter(ClosureParameterSyntax(self)!)
    case .closureShorthandParameterList:
      return .closureShorthandParameterList(ClosureShorthandParameterListSyntax(self)!)
    case .closureShorthandParameter:
      return .closureShorthandParameter(ClosureShorthandParameterSyntax(self)!)
    case .closureSignature:
      return .closureSignature(ClosureSignatureSyntax(self)!)
    case .codeBlockFile:
      return .codeBlockFile(CodeBlockFileSyntax(self)!)
    case .codeBlockItemList:
      return .codeBlockItemList(CodeBlockItemListSyntax(self)!)
    case .codeBlockItem:
      return .codeBlockItem(CodeBlockItemSyntax(self)!)
    case .codeBlock:
      return .codeBlock(CodeBlockSyntax(self)!)
    case .compositionTypeElementList:
      return .compositionTypeElementList(CompositionTypeElementListSyntax(self)!)
    case .compositionTypeElement:
      return .compositionTypeElement(CompositionTypeElementSyntax(self)!)
    case .compositionType:
      return .compositionType(CompositionTypeSyntax(self)!)
    case .conditionElementList:
      return .conditionElementList(ConditionElementListSyntax(self)!)
    case .conditionElement:
      return .conditionElement(ConditionElementSyntax(self)!)
    case .conformanceRequirement:
      return .conformanceRequirement(ConformanceRequirementSyntax(self)!)
    case .consumeExpr:
      return .consumeExpr(ConsumeExprSyntax(self)!)
    case .continueStmt:
      return .continueStmt(ContinueStmtSyntax(self)!)
    case .copyExpr:
      return .copyExpr(CopyExprSyntax(self)!)
    case .declModifierDetail:
      return .declModifierDetail(DeclModifierDetailSyntax(self)!)
    case .declModifierList:
      return .declModifierList(DeclModifierListSyntax(self)!)
    case .declModifier:
      return .declModifier(DeclModifierSyntax(self)!)
    case .declNameArgumentList:
      return .declNameArgumentList(DeclNameArgumentListSyntax(self)!)
    case .declNameArgument:
      return .declNameArgument(DeclNameArgumentSyntax(self)!)
    case .declNameArguments:
      return .declNameArguments(DeclNameArgumentsSyntax(self)!)
    case .declReferenceExpr:
      return .declReferenceExpr(DeclReferenceExprSyntax(self)!)
    case .deferStmt:
      return .deferStmt(DeferStmtSyntax(self)!)
    case .deinitializerDecl:
      return .deinitializerDecl(DeinitializerDeclSyntax(self)!)
    case .deinitializerEffectSpecifiers:
      return .deinitializerEffectSpecifiers(DeinitializerEffectSpecifiersSyntax(self)!)
    case .derivativeAttributeArguments:
      return .derivativeAttributeArguments(DerivativeAttributeArgumentsSyntax(self)!)
    case .designatedTypeList:
      return .designatedTypeList(DesignatedTypeListSyntax(self)!)
    case .designatedType:
      return .designatedType(DesignatedTypeSyntax(self)!)
    case .dictionaryElementList:
      return .dictionaryElementList(DictionaryElementListSyntax(self)!)
    case .dictionaryElement:
      return .dictionaryElement(DictionaryElementSyntax(self)!)
    case .dictionaryExpr:
      return .dictionaryExpr(DictionaryExprSyntax(self)!)
    case .dictionaryType:
      return .dictionaryType(DictionaryTypeSyntax(self)!)
    case .differentiabilityArgumentList:
      return .differentiabilityArgumentList(DifferentiabilityArgumentListSyntax(self)!)
    case .differentiabilityArgument:
      return .differentiabilityArgument(DifferentiabilityArgumentSyntax(self)!)
    case .differentiabilityArguments:
      return .differentiabilityArguments(DifferentiabilityArgumentsSyntax(self)!)
    case .differentiabilityWithRespectToArgument:
      return .differentiabilityWithRespectToArgument(DifferentiabilityWithRespectToArgumentSyntax(self)!)
    case .differentiableAttributeArguments:
      return .differentiableAttributeArguments(DifferentiableAttributeArgumentsSyntax(self)!)
    case .discardAssignmentExpr:
      return .discardAssignmentExpr(DiscardAssignmentExprSyntax(self)!)
    case .discardStmt:
      return .discardStmt(DiscardStmtSyntax(self)!)
    case .doExpr:
      return .doExpr(DoExprSyntax(self)!)
    case .doStmt:
      return .doStmt(DoStmtSyntax(self)!)
    case .documentationAttributeArgumentList:
      return .documentationAttributeArgumentList(DocumentationAttributeArgumentListSyntax(self)!)
    case .documentationAttributeArgument:
      return .documentationAttributeArgument(DocumentationAttributeArgumentSyntax(self)!)
    case .dynamicReplacementAttributeArguments:
      return .dynamicReplacementAttributeArguments(DynamicReplacementAttributeArgumentsSyntax(self)!)
    case .editorPlaceholderDecl:
      return .editorPlaceholderDecl(EditorPlaceholderDeclSyntax(self)!)
    case .editorPlaceholderExpr:
      return .editorPlaceholderExpr(EditorPlaceholderExprSyntax(self)!)
    case .effectsAttributeArgumentList:
      return .effectsAttributeArgumentList(EffectsAttributeArgumentListSyntax(self)!)
    case .enumCaseDecl:
      return .enumCaseDecl(EnumCaseDeclSyntax(self)!)
    case .enumCaseElementList:
      return .enumCaseElementList(EnumCaseElementListSyntax(self)!)
    case .enumCaseElement:
      return .enumCaseElement(EnumCaseElementSyntax(self)!)
    case .enumCaseParameterClause:
      return .enumCaseParameterClause(EnumCaseParameterClauseSyntax(self)!)
    case .enumCaseParameterList:
      return .enumCaseParameterList(EnumCaseParameterListSyntax(self)!)
    case .enumCaseParameter:
      return .enumCaseParameter(EnumCaseParameterSyntax(self)!)
    case .enumDecl:
      return .enumDecl(EnumDeclSyntax(self)!)
    case .exprList:
      return .exprList(ExprListSyntax(self)!)
    case .expressionPattern:
      return .expressionPattern(ExpressionPatternSyntax(self)!)
    case .expressionSegment:
      return .expressionSegment(ExpressionSegmentSyntax(self)!)
    case .expressionStmt:
      return .expressionStmt(ExpressionStmtSyntax(self)!)
    case .extensionDecl:
      return .extensionDecl(ExtensionDeclSyntax(self)!)
    case .fallThroughStmt:
      return .fallThroughStmt(FallThroughStmtSyntax(self)!)
    case .floatLiteralExpr:
      return .floatLiteralExpr(FloatLiteralExprSyntax(self)!)
    case .forStmt:
      return .forStmt(ForStmtSyntax(self)!)
    case .forceUnwrapExpr:
      return .forceUnwrapExpr(ForceUnwrapExprSyntax(self)!)
    case .functionCallExpr:
      return .functionCallExpr(FunctionCallExprSyntax(self)!)
    case .functionDecl:
      return .functionDecl(FunctionDeclSyntax(self)!)
    case .functionEffectSpecifiers:
      return .functionEffectSpecifiers(FunctionEffectSpecifiersSyntax(self)!)
    case .functionParameterClause:
      return .functionParameterClause(FunctionParameterClauseSyntax(self)!)
    case .functionParameterList:
      return .functionParameterList(FunctionParameterListSyntax(self)!)
    case .functionParameter:
      return .functionParameter(FunctionParameterSyntax(self)!)
    case .functionSignature:
      return .functionSignature(FunctionSignatureSyntax(self)!)
    case .functionType:
      return .functionType(FunctionTypeSyntax(self)!)
    case .genericArgumentClause:
      return .genericArgumentClause(GenericArgumentClauseSyntax(self)!)
    case .genericArgumentList:
      return .genericArgumentList(GenericArgumentListSyntax(self)!)
    case .genericArgument:
      return .genericArgument(GenericArgumentSyntax(self)!)
    case .genericParameterClause:
      return .genericParameterClause(GenericParameterClauseSyntax(self)!)
    case .genericParameterList:
      return .genericParameterList(GenericParameterListSyntax(self)!)
    case .genericParameter:
      return .genericParameter(GenericParameterSyntax(self)!)
    case .genericRequirementList:
      return .genericRequirementList(GenericRequirementListSyntax(self)!)
    case .genericRequirement:
      return .genericRequirement(GenericRequirementSyntax(self)!)
    case .genericSpecializationExpr:
      return .genericSpecializationExpr(GenericSpecializationExprSyntax(self)!)
    case .genericWhereClause:
      return .genericWhereClause(GenericWhereClauseSyntax(self)!)
    case .guardStmt:
      return .guardStmt(GuardStmtSyntax(self)!)
    case .identifierPattern:
      return .identifierPattern(IdentifierPatternSyntax(self)!)
    case .identifierType:
      return .identifierType(IdentifierTypeSyntax(self)!)
    case .ifConfigClauseList:
      return .ifConfigClauseList(IfConfigClauseListSyntax(self)!)
    case .ifConfigClause:
      return .ifConfigClause(IfConfigClauseSyntax(self)!)
    case .ifConfigDecl:
      return .ifConfigDecl(IfConfigDeclSyntax(self)!)
    case .ifExpr:
      return .ifExpr(IfExprSyntax(self)!)
    case .implementsAttributeArguments:
      return .implementsAttributeArguments(ImplementsAttributeArgumentsSyntax(self)!)
    case .implicitlyUnwrappedOptionalType:
      return .implicitlyUnwrappedOptionalType(ImplicitlyUnwrappedOptionalTypeSyntax(self)!)
    case .importDecl:
      return .importDecl(ImportDeclSyntax(self)!)
    case .importPathComponentList:
      return .importPathComponentList(ImportPathComponentListSyntax(self)!)
    case .importPathComponent:
      return .importPathComponent(ImportPathComponentSyntax(self)!)
    case .inOutExpr:
      return .inOutExpr(InOutExprSyntax(self)!)
    case .infixOperatorExpr:
      return .infixOperatorExpr(InfixOperatorExprSyntax(self)!)
    case .inheritanceClause:
      return .inheritanceClause(InheritanceClauseSyntax(self)!)
    case .inheritedTypeList:
      return .inheritedTypeList(InheritedTypeListSyntax(self)!)
    case .inheritedType:
      return .inheritedType(InheritedTypeSyntax(self)!)
    case .initializerClause:
      return .initializerClause(InitializerClauseSyntax(self)!)
    case .initializerDecl:
      return .initializerDecl(InitializerDeclSyntax(self)!)
    case .inlineArrayType:
      return .inlineArrayType(InlineArrayTypeSyntax(self)!)
    case .integerLiteralExpr:
      return .integerLiteralExpr(IntegerLiteralExprSyntax(self)!)
    case .isExpr:
      return .isExpr(IsExprSyntax(self)!)
    case .isTypePattern:
      return .isTypePattern(IsTypePatternSyntax(self)!)
    case .keyPathComponentList:
      return .keyPathComponentList(KeyPathComponentListSyntax(self)!)
    case .keyPathComponent:
      return .keyPathComponent(KeyPathComponentSyntax(self)!)
    case .keyPathExpr:
      return .keyPathExpr(KeyPathExprSyntax(self)!)
    case .keyPathMethodComponent:
      return .keyPathMethodComponent(KeyPathMethodComponentSyntax(self)!)
    case .keyPathOptionalComponent:
      return .keyPathOptionalComponent(KeyPathOptionalComponentSyntax(self)!)
    case .keyPathPropertyComponent:
      return .keyPathPropertyComponent(KeyPathPropertyComponentSyntax(self)!)
    case .keyPathSubscriptComponent:
      return .keyPathSubscriptComponent(KeyPathSubscriptComponentSyntax(self)!)
    case .labeledExprList:
      return .labeledExprList(LabeledExprListSyntax(self)!)
    case .labeledExpr:
      return .labeledExpr(LabeledExprSyntax(self)!)
    case .labeledSpecializeArgument:
      return .labeledSpecializeArgument(LabeledSpecializeArgumentSyntax(self)!)
    case .labeledStmt:
      return .labeledStmt(LabeledStmtSyntax(self)!)
    case .layoutRequirement:
      return .layoutRequirement(LayoutRequirementSyntax(self)!)
    case .lifetimeSpecifierArgumentList:
      return .lifetimeSpecifierArgumentList(LifetimeSpecifierArgumentListSyntax(self)!)
    case .lifetimeSpecifierArgument:
      return .lifetimeSpecifierArgument(LifetimeSpecifierArgumentSyntax(self)!)
    case .lifetimeTypeSpecifier:
      return .lifetimeTypeSpecifier(LifetimeTypeSpecifierSyntax(self)!)
    case .macroDecl:
      return .macroDecl(MacroDeclSyntax(self)!)
    case .macroExpansionDecl:
      return .macroExpansionDecl(MacroExpansionDeclSyntax(self)!)
    case .macroExpansionExpr:
      return .macroExpansionExpr(MacroExpansionExprSyntax(self)!)
    case .matchingPatternCondition:
      return .matchingPatternCondition(MatchingPatternConditionSyntax(self)!)
    case .memberAccessExpr:
      return .memberAccessExpr(MemberAccessExprSyntax(self)!)
    case .memberBlockItemListFile:
      return .memberBlockItemListFile(MemberBlockItemListFileSyntax(self)!)
    case .memberBlockItemList:
      return .memberBlockItemList(MemberBlockItemListSyntax(self)!)
    case .memberBlockItem:
      return .memberBlockItem(MemberBlockItemSyntax(self)!)
    case .memberBlock:
      return .memberBlock(MemberBlockSyntax(self)!)
    case .memberType:
      return .memberType(MemberTypeSyntax(self)!)
    case .metatypeType:
      return .metatypeType(MetatypeTypeSyntax(self)!)
    case .missingDecl:
      return .missingDecl(MissingDeclSyntax(self)!)
    case .missingExpr:
      return .missingExpr(MissingExprSyntax(self)!)
    case .missingPattern:
      return .missingPattern(MissingPatternSyntax(self)!)
    case .missingStmt:
      return .missingStmt(MissingStmtSyntax(self)!)
    case .missing:
      return .missing(MissingSyntax(self)!)
    case .missingType:
      return .missingType(MissingTypeSyntax(self)!)
    case .moduleSelector:
      return .moduleSelector(ModuleSelectorSyntax(self)!)
    case .multipleTrailingClosureElementList:
      return .multipleTrailingClosureElementList(MultipleTrailingClosureElementListSyntax(self)!)
    case .multipleTrailingClosureElement:
      return .multipleTrailingClosureElement(MultipleTrailingClosureElementSyntax(self)!)
    case .namedOpaqueReturnType:
      return .namedOpaqueReturnType(NamedOpaqueReturnTypeSyntax(self)!)
    case .nilLiteralExpr:
      return .nilLiteralExpr(NilLiteralExprSyntax(self)!)
    case .nonisolatedSpecifierArgument:
      return .nonisolatedSpecifierArgument(NonisolatedSpecifierArgumentSyntax(self)!)
    case .nonisolatedTypeSpecifier:
      return .nonisolatedTypeSpecifier(NonisolatedTypeSpecifierSyntax(self)!)
    case .objCSelectorPieceList:
      return .objCSelectorPieceList(ObjCSelectorPieceListSyntax(self)!)
    case .objCSelectorPiece:
      return .objCSelectorPiece(ObjCSelectorPieceSyntax(self)!)
    case .operatorDecl:
      return .operatorDecl(OperatorDeclSyntax(self)!)
    case .operatorPrecedenceAndTypes:
      return .operatorPrecedenceAndTypes(OperatorPrecedenceAndTypesSyntax(self)!)
    case .optionalBindingCondition:
      return .optionalBindingCondition(OptionalBindingConditionSyntax(self)!)
    case .optionalChainingExpr:
      return .optionalChainingExpr(OptionalChainingExprSyntax(self)!)
    case .optionalType:
      return .optionalType(OptionalTypeSyntax(self)!)
    case .originallyDefinedInAttributeArguments:
      return .originallyDefinedInAttributeArguments(OriginallyDefinedInAttributeArgumentsSyntax(self)!)
    case .packElementExpr:
      return .packElementExpr(PackElementExprSyntax(self)!)
    case .packElementType:
      return .packElementType(PackElementTypeSyntax(self)!)
    case .packExpansionExpr:
      return .packExpansionExpr(PackExpansionExprSyntax(self)!)
    case .packExpansionType:
      return .packExpansionType(PackExpansionTypeSyntax(self)!)
    case .patternBindingList:
      return .patternBindingList(PatternBindingListSyntax(self)!)
    case .patternBinding:
      return .patternBinding(PatternBindingSyntax(self)!)
    case .patternExpr:
      return .patternExpr(PatternExprSyntax(self)!)
    case .platformVersionItemList:
      return .platformVersionItemList(PlatformVersionItemListSyntax(self)!)
    case .platformVersionItem:
      return .platformVersionItem(PlatformVersionItemSyntax(self)!)
    case .platformVersion:
      return .platformVersion(PlatformVersionSyntax(self)!)
    case .postfixIfConfigExpr:
      return .postfixIfConfigExpr(PostfixIfConfigExprSyntax(self)!)
    case .postfixOperatorExpr:
      return .postfixOperatorExpr(PostfixOperatorExprSyntax(self)!)
    case .poundSourceLocationArguments:
      return .poundSourceLocationArguments(PoundSourceLocationArgumentsSyntax(self)!)
    case .poundSourceLocation:
      return .poundSourceLocation(PoundSourceLocationSyntax(self)!)
    case .precedenceGroupAssignment:
      return .precedenceGroupAssignment(PrecedenceGroupAssignmentSyntax(self)!)
    case .precedenceGroupAssociativity:
      return .precedenceGroupAssociativity(PrecedenceGroupAssociativitySyntax(self)!)
    case .precedenceGroupAttributeList:
      return .precedenceGroupAttributeList(PrecedenceGroupAttributeListSyntax(self)!)
    case .precedenceGroupDecl:
      return .precedenceGroupDecl(PrecedenceGroupDeclSyntax(self)!)
    case .precedenceGroupNameList:
      return .precedenceGroupNameList(PrecedenceGroupNameListSyntax(self)!)
    case .precedenceGroupName:
      return .precedenceGroupName(PrecedenceGroupNameSyntax(self)!)
    case .precedenceGroupRelation:
      return .precedenceGroupRelation(PrecedenceGroupRelationSyntax(self)!)
    case .prefixOperatorExpr:
      return .prefixOperatorExpr(PrefixOperatorExprSyntax(self)!)
    case .primaryAssociatedTypeClause:
      return .primaryAssociatedTypeClause(PrimaryAssociatedTypeClauseSyntax(self)!)
    case .primaryAssociatedTypeList:
      return .primaryAssociatedTypeList(PrimaryAssociatedTypeListSyntax(self)!)
    case .primaryAssociatedType:
      return .primaryAssociatedType(PrimaryAssociatedTypeSyntax(self)!)
    case .protocolDecl:
      return .protocolDecl(ProtocolDeclSyntax(self)!)
    case .regexLiteralExpr:
      return .regexLiteralExpr(RegexLiteralExprSyntax(self)!)
    case .repeatStmt:
      return .repeatStmt(RepeatStmtSyntax(self)!)
    case .returnClause:
      return .returnClause(ReturnClauseSyntax(self)!)
    case .returnStmt:
      return .returnStmt(ReturnStmtSyntax(self)!)
    case .sameTypeRequirement:
      return .sameTypeRequirement(SameTypeRequirementSyntax(self)!)
    case .sequenceExpr:
      return .sequenceExpr(SequenceExprSyntax(self)!)
    case .simpleStringLiteralExpr:
      return .simpleStringLiteralExpr(SimpleStringLiteralExprSyntax(self)!)
    case .simpleStringLiteralSegmentList:
      return .simpleStringLiteralSegmentList(SimpleStringLiteralSegmentListSyntax(self)!)
    case .simpleTypeSpecifier:
      return .simpleTypeSpecifier(SimpleTypeSpecifierSyntax(self)!)
    case .someOrAnyType:
      return .someOrAnyType(SomeOrAnyTypeSyntax(self)!)
    case .sourceFile:
      return .sourceFile(SourceFileSyntax(self)!)
    case .specializeAttributeArgumentList:
      return .specializeAttributeArgumentList(SpecializeAttributeArgumentListSyntax(self)!)
    case .specializeAvailabilityArgument:
      return .specializeAvailabilityArgument(SpecializeAvailabilityArgumentSyntax(self)!)
    case .specializeTargetFunctionArgument:
      return .specializeTargetFunctionArgument(SpecializeTargetFunctionArgumentSyntax(self)!)
    case .specializedAttributeArgument:
      return .specializedAttributeArgument(SpecializedAttributeArgumentSyntax(self)!)
    case .stringLiteralExpr:
      return .stringLiteralExpr(StringLiteralExprSyntax(self)!)
    case .stringLiteralSegmentList:
      return .stringLiteralSegmentList(StringLiteralSegmentListSyntax(self)!)
    case .stringSegment:
      return .stringSegment(StringSegmentSyntax(self)!)
    case .structDecl:
      return .structDecl(StructDeclSyntax(self)!)
    case .subscriptCallExpr:
      return .subscriptCallExpr(SubscriptCallExprSyntax(self)!)
    case .subscriptDecl:
      return .subscriptDecl(SubscriptDeclSyntax(self)!)
    case .superExpr:
      return .superExpr(SuperExprSyntax(self)!)
    case .suppressedType:
      return .suppressedType(SuppressedTypeSyntax(self)!)
    case .switchCaseItemList:
      return .switchCaseItemList(SwitchCaseItemListSyntax(self)!)
    case .switchCaseItem:
      return .switchCaseItem(SwitchCaseItemSyntax(self)!)
    case .switchCaseLabel:
      return .switchCaseLabel(SwitchCaseLabelSyntax(self)!)
    case .switchCaseList:
      return .switchCaseList(SwitchCaseListSyntax(self)!)
    case .switchCase:
      return .switchCase(SwitchCaseSyntax(self)!)
    case .switchDefaultLabel:
      return .switchDefaultLabel(SwitchDefaultLabelSyntax(self)!)
    case .switchExpr:
      return .switchExpr(SwitchExprSyntax(self)!)
    case .ternaryExpr:
      return .ternaryExpr(TernaryExprSyntax(self)!)
    case .thenStmt:
      return .thenStmt(ThenStmtSyntax(self)!)
    case .throwStmt:
      return .throwStmt(ThrowStmtSyntax(self)!)
    case .throwsClause:
      return .throwsClause(ThrowsClauseSyntax(self)!)
    case .tryExpr:
      return .tryExpr(TryExprSyntax(self)!)
    case .tupleExpr:
      return .tupleExpr(TupleExprSyntax(self)!)
    case .tuplePatternElementList:
      return .tuplePatternElementList(TuplePatternElementListSyntax(self)!)
    case .tuplePatternElement:
      return .tuplePatternElement(TuplePatternElementSyntax(self)!)
    case .tuplePattern:
      return .tuplePattern(TuplePatternSyntax(self)!)
    case .tupleTypeElementList:
      return .tupleTypeElementList(TupleTypeElementListSyntax(self)!)
    case .tupleTypeElement:
      return .tupleTypeElement(TupleTypeElementSyntax(self)!)
    case .tupleType:
      return .tupleType(TupleTypeSyntax(self)!)
    case .typeAliasDecl:
      return .typeAliasDecl(TypeAliasDeclSyntax(self)!)
    case .typeAnnotation:
      return .typeAnnotation(TypeAnnotationSyntax(self)!)
    case .typeEffectSpecifiers:
      return .typeEffectSpecifiers(TypeEffectSpecifiersSyntax(self)!)
    case .typeExpr:
      return .typeExpr(TypeExprSyntax(self)!)
    case .typeInitializerClause:
      return .typeInitializerClause(TypeInitializerClauseSyntax(self)!)
    case .typeSpecifierList:
      return .typeSpecifierList(TypeSpecifierListSyntax(self)!)
    case .unexpectedNodes:
      return .unexpectedNodes(UnexpectedNodesSyntax(self)!)
    case .unresolvedAsExpr:
      return .unresolvedAsExpr(UnresolvedAsExprSyntax(self)!)
    case .unresolvedIsExpr:
      return .unresolvedIsExpr(UnresolvedIsExprSyntax(self)!)
    case .unresolvedTernaryExpr:
      return .unresolvedTernaryExpr(UnresolvedTernaryExprSyntax(self)!)
    case .unsafeExpr:
      return .unsafeExpr(UnsafeExprSyntax(self)!)
    case .usingDecl:
      return .usingDecl(UsingDeclSyntax(self)!)
    case .valueBindingPattern:
      return .valueBindingPattern(ValueBindingPatternSyntax(self)!)
    case .variableDecl:
      return .variableDecl(VariableDeclSyntax(self)!)
    case .versionComponentList:
      return .versionComponentList(VersionComponentListSyntax(self)!)
    case .versionComponent:
      return .versionComponent(VersionComponentSyntax(self)!)
    case .versionTuple:
      return .versionTuple(VersionTupleSyntax(self)!)
    case .whereClause:
      return .whereClause(WhereClauseSyntax(self)!)
    case .whileStmt:
      return .whileStmt(WhileStmtSyntax(self)!)
    case .wildcardPattern:
      return .wildcardPattern(WildcardPatternSyntax(self)!)
    case .yieldStmt:
      return .yieldStmt(YieldStmtSyntax(self)!)
    case .yieldedExpressionList:
      return .yieldedExpressionList(YieldedExpressionListSyntax(self)!)
    case .yieldedExpression:
      return .yieldedExpression(YieldedExpressionSyntax(self)!)
    case .yieldedExpressionsClause:
      return .yieldedExpressionsClause(YieldedExpressionsClauseSyntax(self)!)
    }
  }
}

/// Enum to exhaustively switch over all different Decl syntax nodes.
public enum DeclSyntaxEnum {
  case accessorDecl(AccessorDeclSyntax)
  case actorDecl(ActorDeclSyntax)
  case associatedTypeDecl(AssociatedTypeDeclSyntax)
  case classDecl(ClassDeclSyntax)
  case deinitializerDecl(DeinitializerDeclSyntax)
  case editorPlaceholderDecl(EditorPlaceholderDeclSyntax)
  case enumCaseDecl(EnumCaseDeclSyntax)
  case enumDecl(EnumDeclSyntax)
  case extensionDecl(ExtensionDeclSyntax)
  case functionDecl(FunctionDeclSyntax)
  case ifConfigDecl(IfConfigDeclSyntax)
  case importDecl(ImportDeclSyntax)
  case initializerDecl(InitializerDeclSyntax)
  case macroDecl(MacroDeclSyntax)
  case macroExpansionDecl(MacroExpansionDeclSyntax)
  case missingDecl(MissingDeclSyntax)
  case operatorDecl(OperatorDeclSyntax)
  case poundSourceLocation(PoundSourceLocationSyntax)
  case precedenceGroupDecl(PrecedenceGroupDeclSyntax)
  case protocolDecl(ProtocolDeclSyntax)
  case structDecl(StructDeclSyntax)
  case subscriptDecl(SubscriptDeclSyntax)
  case typeAliasDecl(TypeAliasDeclSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case usingDecl(UsingDeclSyntax)
  case variableDecl(VariableDeclSyntax)
}

extension DeclSyntax {
  /// Get an enum that can be used to exhaustively switch over all Decl syntax nodes.
  public func `as`(_: DeclSyntaxEnum.Type) -> DeclSyntaxEnum {
    switch raw.kind {
    case .accessorDecl:
      return .accessorDecl(AccessorDeclSyntax(self)!)
    case .actorDecl:
      return .actorDecl(ActorDeclSyntax(self)!)
    case .associatedTypeDecl:
      return .associatedTypeDecl(AssociatedTypeDeclSyntax(self)!)
    case .classDecl:
      return .classDecl(ClassDeclSyntax(self)!)
    case .deinitializerDecl:
      return .deinitializerDecl(DeinitializerDeclSyntax(self)!)
    case .editorPlaceholderDecl:
      return .editorPlaceholderDecl(EditorPlaceholderDeclSyntax(self)!)
    case .enumCaseDecl:
      return .enumCaseDecl(EnumCaseDeclSyntax(self)!)
    case .enumDecl:
      return .enumDecl(EnumDeclSyntax(self)!)
    case .extensionDecl:
      return .extensionDecl(ExtensionDeclSyntax(self)!)
    case .functionDecl:
      return .functionDecl(FunctionDeclSyntax(self)!)
    case .ifConfigDecl:
      return .ifConfigDecl(IfConfigDeclSyntax(self)!)
    case .importDecl:
      return .importDecl(ImportDeclSyntax(self)!)
    case .initializerDecl:
      return .initializerDecl(InitializerDeclSyntax(self)!)
    case .macroDecl:
      return .macroDecl(MacroDeclSyntax(self)!)
    case .macroExpansionDecl:
      return .macroExpansionDecl(MacroExpansionDeclSyntax(self)!)
    case .missingDecl:
      return .missingDecl(MissingDeclSyntax(self)!)
    case .operatorDecl:
      return .operatorDecl(OperatorDeclSyntax(self)!)
    case .poundSourceLocation:
      return .poundSourceLocation(PoundSourceLocationSyntax(self)!)
    case .precedenceGroupDecl:
      return .precedenceGroupDecl(PrecedenceGroupDeclSyntax(self)!)
    case .protocolDecl:
      return .protocolDecl(ProtocolDeclSyntax(self)!)
    case .structDecl:
      return .structDecl(StructDeclSyntax(self)!)
    case .subscriptDecl:
      return .subscriptDecl(SubscriptDeclSyntax(self)!)
    case .typeAliasDecl:
      return .typeAliasDecl(TypeAliasDeclSyntax(self)!)
    case .usingDecl:
      return .usingDecl(UsingDeclSyntax(self)!)
    case .variableDecl:
      return .variableDecl(VariableDeclSyntax(self)!)
    default:
      preconditionFailure("unknown Decl syntax kind")
    }
  }
}

/// Enum to exhaustively switch over all different Expr syntax nodes.
public enum ExprSyntaxEnum {
  case arrayExpr(ArrayExprSyntax)
  case arrowExpr(ArrowExprSyntax)
  case asExpr(AsExprSyntax)
  case assignmentExpr(AssignmentExprSyntax)
  case awaitExpr(AwaitExprSyntax)
  case binaryOperatorExpr(BinaryOperatorExprSyntax)
  case booleanLiteralExpr(BooleanLiteralExprSyntax)
  case borrowExpr(BorrowExprSyntax)
  case _canImportExpr(_CanImportExprSyntax)
  case _canImportVersionInfo(_CanImportVersionInfoSyntax)
  case closureExpr(ClosureExprSyntax)
  case consumeExpr(ConsumeExprSyntax)
  case copyExpr(CopyExprSyntax)
  case declReferenceExpr(DeclReferenceExprSyntax)
  case dictionaryExpr(DictionaryExprSyntax)
  case discardAssignmentExpr(DiscardAssignmentExprSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case doExpr(DoExprSyntax)
  case editorPlaceholderExpr(EditorPlaceholderExprSyntax)
  case floatLiteralExpr(FloatLiteralExprSyntax)
  case forceUnwrapExpr(ForceUnwrapExprSyntax)
  case functionCallExpr(FunctionCallExprSyntax)
  case genericSpecializationExpr(GenericSpecializationExprSyntax)
  case ifExpr(IfExprSyntax)
  case inOutExpr(InOutExprSyntax)
  case infixOperatorExpr(InfixOperatorExprSyntax)
  case integerLiteralExpr(IntegerLiteralExprSyntax)
  case isExpr(IsExprSyntax)
  case keyPathExpr(KeyPathExprSyntax)
  case macroExpansionExpr(MacroExpansionExprSyntax)
  case memberAccessExpr(MemberAccessExprSyntax)
  case missingExpr(MissingExprSyntax)
  case nilLiteralExpr(NilLiteralExprSyntax)
  case optionalChainingExpr(OptionalChainingExprSyntax)
  case packElementExpr(PackElementExprSyntax)
  case packExpansionExpr(PackExpansionExprSyntax)
  case patternExpr(PatternExprSyntax)
  case postfixIfConfigExpr(PostfixIfConfigExprSyntax)
  case postfixOperatorExpr(PostfixOperatorExprSyntax)
  case prefixOperatorExpr(PrefixOperatorExprSyntax)
  case regexLiteralExpr(RegexLiteralExprSyntax)
  case sequenceExpr(SequenceExprSyntax)
  case simpleStringLiteralExpr(SimpleStringLiteralExprSyntax)
  case stringLiteralExpr(StringLiteralExprSyntax)
  case subscriptCallExpr(SubscriptCallExprSyntax)
  case superExpr(SuperExprSyntax)
  case switchExpr(SwitchExprSyntax)
  case ternaryExpr(TernaryExprSyntax)
  case tryExpr(TryExprSyntax)
  case tupleExpr(TupleExprSyntax)
  case typeExpr(TypeExprSyntax)
  case unresolvedAsExpr(UnresolvedAsExprSyntax)
  case unresolvedIsExpr(UnresolvedIsExprSyntax)
  case unresolvedTernaryExpr(UnresolvedTernaryExprSyntax)
  case unsafeExpr(UnsafeExprSyntax)
}

extension ExprSyntax {
  /// Get an enum that can be used to exhaustively switch over all Expr syntax nodes.
  public func `as`(_: ExprSyntaxEnum.Type) -> ExprSyntaxEnum {
    switch raw.kind {
    case .arrayExpr:
      return .arrayExpr(ArrayExprSyntax(self)!)
    case .arrowExpr:
      return .arrowExpr(ArrowExprSyntax(self)!)
    case .asExpr:
      return .asExpr(AsExprSyntax(self)!)
    case .assignmentExpr:
      return .assignmentExpr(AssignmentExprSyntax(self)!)
    case .awaitExpr:
      return .awaitExpr(AwaitExprSyntax(self)!)
    case .binaryOperatorExpr:
      return .binaryOperatorExpr(BinaryOperatorExprSyntax(self)!)
    case .booleanLiteralExpr:
      return .booleanLiteralExpr(BooleanLiteralExprSyntax(self)!)
    case .borrowExpr:
      return .borrowExpr(BorrowExprSyntax(self)!)
    case ._canImportExpr:
      return ._canImportExpr(_CanImportExprSyntax(self)!)
    case ._canImportVersionInfo:
      return ._canImportVersionInfo(_CanImportVersionInfoSyntax(self)!)
    case .closureExpr:
      return .closureExpr(ClosureExprSyntax(self)!)
    case .consumeExpr:
      return .consumeExpr(ConsumeExprSyntax(self)!)
    case .copyExpr:
      return .copyExpr(CopyExprSyntax(self)!)
    case .declReferenceExpr:
      return .declReferenceExpr(DeclReferenceExprSyntax(self)!)
    case .dictionaryExpr:
      return .dictionaryExpr(DictionaryExprSyntax(self)!)
    case .discardAssignmentExpr:
      return .discardAssignmentExpr(DiscardAssignmentExprSyntax(self)!)
    case .doExpr:
      return .doExpr(DoExprSyntax(self)!)
    case .editorPlaceholderExpr:
      return .editorPlaceholderExpr(EditorPlaceholderExprSyntax(self)!)
    case .floatLiteralExpr:
      return .floatLiteralExpr(FloatLiteralExprSyntax(self)!)
    case .forceUnwrapExpr:
      return .forceUnwrapExpr(ForceUnwrapExprSyntax(self)!)
    case .functionCallExpr:
      return .functionCallExpr(FunctionCallExprSyntax(self)!)
    case .genericSpecializationExpr:
      return .genericSpecializationExpr(GenericSpecializationExprSyntax(self)!)
    case .ifExpr:
      return .ifExpr(IfExprSyntax(self)!)
    case .inOutExpr:
      return .inOutExpr(InOutExprSyntax(self)!)
    case .infixOperatorExpr:
      return .infixOperatorExpr(InfixOperatorExprSyntax(self)!)
    case .integerLiteralExpr:
      return .integerLiteralExpr(IntegerLiteralExprSyntax(self)!)
    case .isExpr:
      return .isExpr(IsExprSyntax(self)!)
    case .keyPathExpr:
      return .keyPathExpr(KeyPathExprSyntax(self)!)
    case .macroExpansionExpr:
      return .macroExpansionExpr(MacroExpansionExprSyntax(self)!)
    case .memberAccessExpr:
      return .memberAccessExpr(MemberAccessExprSyntax(self)!)
    case .missingExpr:
      return .missingExpr(MissingExprSyntax(self)!)
    case .nilLiteralExpr:
      return .nilLiteralExpr(NilLiteralExprSyntax(self)!)
    case .optionalChainingExpr:
      return .optionalChainingExpr(OptionalChainingExprSyntax(self)!)
    case .packElementExpr:
      return .packElementExpr(PackElementExprSyntax(self)!)
    case .packExpansionExpr:
      return .packExpansionExpr(PackExpansionExprSyntax(self)!)
    case .patternExpr:
      return .patternExpr(PatternExprSyntax(self)!)
    case .postfixIfConfigExpr:
      return .postfixIfConfigExpr(PostfixIfConfigExprSyntax(self)!)
    case .postfixOperatorExpr:
      return .postfixOperatorExpr(PostfixOperatorExprSyntax(self)!)
    case .prefixOperatorExpr:
      return .prefixOperatorExpr(PrefixOperatorExprSyntax(self)!)
    case .regexLiteralExpr:
      return .regexLiteralExpr(RegexLiteralExprSyntax(self)!)
    case .sequenceExpr:
      return .sequenceExpr(SequenceExprSyntax(self)!)
    case .simpleStringLiteralExpr:
      return .simpleStringLiteralExpr(SimpleStringLiteralExprSyntax(self)!)
    case .stringLiteralExpr:
      return .stringLiteralExpr(StringLiteralExprSyntax(self)!)
    case .subscriptCallExpr:
      return .subscriptCallExpr(SubscriptCallExprSyntax(self)!)
    case .superExpr:
      return .superExpr(SuperExprSyntax(self)!)
    case .switchExpr:
      return .switchExpr(SwitchExprSyntax(self)!)
    case .ternaryExpr:
      return .ternaryExpr(TernaryExprSyntax(self)!)
    case .tryExpr:
      return .tryExpr(TryExprSyntax(self)!)
    case .tupleExpr:
      return .tupleExpr(TupleExprSyntax(self)!)
    case .typeExpr:
      return .typeExpr(TypeExprSyntax(self)!)
    case .unresolvedAsExpr:
      return .unresolvedAsExpr(UnresolvedAsExprSyntax(self)!)
    case .unresolvedIsExpr:
      return .unresolvedIsExpr(UnresolvedIsExprSyntax(self)!)
    case .unresolvedTernaryExpr:
      return .unresolvedTernaryExpr(UnresolvedTernaryExprSyntax(self)!)
    case .unsafeExpr:
      return .unsafeExpr(UnsafeExprSyntax(self)!)
    default:
      preconditionFailure("unknown Expr syntax kind")
    }
  }
}

/// Enum to exhaustively switch over all different Pattern syntax nodes.
public enum PatternSyntaxEnum {
  case expressionPattern(ExpressionPatternSyntax)
  case identifierPattern(IdentifierPatternSyntax)
  case isTypePattern(IsTypePatternSyntax)
  case missingPattern(MissingPatternSyntax)
  case tuplePattern(TuplePatternSyntax)
  case valueBindingPattern(ValueBindingPatternSyntax)
  case wildcardPattern(WildcardPatternSyntax)
}

extension PatternSyntax {
  /// Get an enum that can be used to exhaustively switch over all Pattern syntax nodes.
  public func `as`(_: PatternSyntaxEnum.Type) -> PatternSyntaxEnum {
    switch raw.kind {
    case .expressionPattern:
      return .expressionPattern(ExpressionPatternSyntax(self)!)
    case .identifierPattern:
      return .identifierPattern(IdentifierPatternSyntax(self)!)
    case .isTypePattern:
      return .isTypePattern(IsTypePatternSyntax(self)!)
    case .missingPattern:
      return .missingPattern(MissingPatternSyntax(self)!)
    case .tuplePattern:
      return .tuplePattern(TuplePatternSyntax(self)!)
    case .valueBindingPattern:
      return .valueBindingPattern(ValueBindingPatternSyntax(self)!)
    case .wildcardPattern:
      return .wildcardPattern(WildcardPatternSyntax(self)!)
    default:
      preconditionFailure("unknown Pattern syntax kind")
    }
  }
}

/// Enum to exhaustively switch over all different Stmt syntax nodes.
public enum StmtSyntaxEnum {
  case breakStmt(BreakStmtSyntax)
  case continueStmt(ContinueStmtSyntax)
  case deferStmt(DeferStmtSyntax)
  case discardStmt(DiscardStmtSyntax)
  case doStmt(DoStmtSyntax)
  case expressionStmt(ExpressionStmtSyntax)
  case fallThroughStmt(FallThroughStmtSyntax)
  case forStmt(ForStmtSyntax)
  case guardStmt(GuardStmtSyntax)
  case labeledStmt(LabeledStmtSyntax)
  case missingStmt(MissingStmtSyntax)
  case repeatStmt(RepeatStmtSyntax)
  case returnStmt(ReturnStmtSyntax)
  @_spi(ExperimentalLanguageFeatures)
  case thenStmt(ThenStmtSyntax)
  case throwStmt(ThrowStmtSyntax)
  case whileStmt(WhileStmtSyntax)
  case yieldStmt(YieldStmtSyntax)
}

extension StmtSyntax {
  /// Get an enum that can be used to exhaustively switch over all Stmt syntax nodes.
  public func `as`(_: StmtSyntaxEnum.Type) -> StmtSyntaxEnum {
    switch raw.kind {
    case .breakStmt:
      return .breakStmt(BreakStmtSyntax(self)!)
    case .continueStmt:
      return .continueStmt(ContinueStmtSyntax(self)!)
    case .deferStmt:
      return .deferStmt(DeferStmtSyntax(self)!)
    case .discardStmt:
      return .discardStmt(DiscardStmtSyntax(self)!)
    case .doStmt:
      return .doStmt(DoStmtSyntax(self)!)
    case .expressionStmt:
      return .expressionStmt(ExpressionStmtSyntax(self)!)
    case .fallThroughStmt:
      return .fallThroughStmt(FallThroughStmtSyntax(self)!)
    case .forStmt:
      return .forStmt(ForStmtSyntax(self)!)
    case .guardStmt:
      return .guardStmt(GuardStmtSyntax(self)!)
    case .labeledStmt:
      return .labeledStmt(LabeledStmtSyntax(self)!)
    case .missingStmt:
      return .missingStmt(MissingStmtSyntax(self)!)
    case .repeatStmt:
      return .repeatStmt(RepeatStmtSyntax(self)!)
    case .returnStmt:
      return .returnStmt(ReturnStmtSyntax(self)!)
    case .thenStmt:
      return .thenStmt(ThenStmtSyntax(self)!)
    case .throwStmt:
      return .throwStmt(ThrowStmtSyntax(self)!)
    case .whileStmt:
      return .whileStmt(WhileStmtSyntax(self)!)
    case .yieldStmt:
      return .yieldStmt(YieldStmtSyntax(self)!)
    default:
      preconditionFailure("unknown Stmt syntax kind")
    }
  }
}

/// Enum to exhaustively switch over all different Type syntax nodes.
public enum TypeSyntaxEnum {
  case arrayType(ArrayTypeSyntax)
  case attributedType(AttributedTypeSyntax)
  case classRestrictionType(ClassRestrictionTypeSyntax)
  case compositionType(CompositionTypeSyntax)
  case dictionaryType(DictionaryTypeSyntax)
  case functionType(FunctionTypeSyntax)
  case identifierType(IdentifierTypeSyntax)
  case implicitlyUnwrappedOptionalType(ImplicitlyUnwrappedOptionalTypeSyntax)
  case inlineArrayType(InlineArrayTypeSyntax)
  case memberType(MemberTypeSyntax)
  case metatypeType(MetatypeTypeSyntax)
  case missingType(MissingTypeSyntax)
  case namedOpaqueReturnType(NamedOpaqueReturnTypeSyntax)
  case optionalType(OptionalTypeSyntax)
  case packElementType(PackElementTypeSyntax)
  case packExpansionType(PackExpansionTypeSyntax)
  case someOrAnyType(SomeOrAnyTypeSyntax)
  case suppressedType(SuppressedTypeSyntax)
  case tupleType(TupleTypeSyntax)
}

extension TypeSyntax {
  /// Get an enum that can be used to exhaustively switch over all Type syntax nodes.
  public func `as`(_: TypeSyntaxEnum.Type) -> TypeSyntaxEnum {
    switch raw.kind {
    case .arrayType:
      return .arrayType(ArrayTypeSyntax(self)!)
    case .attributedType:
      return .attributedType(AttributedTypeSyntax(self)!)
    case .classRestrictionType:
      return .classRestrictionType(ClassRestrictionTypeSyntax(self)!)
    case .compositionType:
      return .compositionType(CompositionTypeSyntax(self)!)
    case .dictionaryType:
      return .dictionaryType(DictionaryTypeSyntax(self)!)
    case .functionType:
      return .functionType(FunctionTypeSyntax(self)!)
    case .identifierType:
      return .identifierType(IdentifierTypeSyntax(self)!)
    case .implicitlyUnwrappedOptionalType:
      return .implicitlyUnwrappedOptionalType(ImplicitlyUnwrappedOptionalTypeSyntax(self)!)
    case .inlineArrayType:
      return .inlineArrayType(InlineArrayTypeSyntax(self)!)
    case .memberType:
      return .memberType(MemberTypeSyntax(self)!)
    case .metatypeType:
      return .metatypeType(MetatypeTypeSyntax(self)!)
    case .missingType:
      return .missingType(MissingTypeSyntax(self)!)
    case .namedOpaqueReturnType:
      return .namedOpaqueReturnType(NamedOpaqueReturnTypeSyntax(self)!)
    case .optionalType:
      return .optionalType(OptionalTypeSyntax(self)!)
    case .packElementType:
      return .packElementType(PackElementTypeSyntax(self)!)
    case .packExpansionType:
      return .packExpansionType(PackExpansionTypeSyntax(self)!)
    case .someOrAnyType:
      return .someOrAnyType(SomeOrAnyTypeSyntax(self)!)
    case .suppressedType:
      return .suppressedType(SuppressedTypeSyntax(self)!)
    case .tupleType:
      return .tupleType(TupleTypeSyntax(self)!)
    default:
      preconditionFailure("unknown Type syntax kind")
    }
  }
}
