//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - EditorPlaceholderDeclSyntax

/// An editor placeholder, e.g. `<#declaration#>` that is used in a position that expects a declaration.
/// 
/// - Warning: This ``EditorPlaceholderDeclSyntax`` node is not generated by the parser anymore. Placeholders are represented by a ``MissingDeclSyntax``.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `placeholder`: `<identifier>`
public struct EditorPlaceholderDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .editorPlaceholderDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: If there were attributes before the editor placeholder, the ``EditorPlaceholderDeclSyntax`` will contain these.
  ///   - modifiers: If there were modifiers before the editor placeholder, the `EditorPlaceholderDecl` will contain these.
  ///   - placeholder: The actual editor placeholder that starts with `<#` and ends with `#>`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndPlaceholder: UnexpectedNodesSyntax? = nil,
    placeholder: TokenSyntax,
    _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndPlaceholder,
      placeholder,
      unexpectedAfterPlaceholder
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndPlaceholder?.raw,
        placeholder.raw,
        unexpectedAfterPlaceholder?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.editorPlaceholderDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  /// If there were attributes before the editor placeholder, the ``EditorPlaceholderDeclSyntax`` will contain these.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> EditorPlaceholderDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EditorPlaceholderDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  /// If there were modifiers before the editor placeholder, the `EditorPlaceholderDecl` will contain these.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> EditorPlaceholderDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EditorPlaceholderDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  /// The actual editor placeholder that starts with `<#` and ends with `#>`.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndPlaceholder,
    \Self.placeholder,
    \Self.unexpectedAfterPlaceholder
  ])
}

// MARK: - EditorPlaceholderExprSyntax

/// - Warning: This ``EditorPlaceholderExprSyntax`` node is not generated by the parser anymore. Placeholders are represented by a ``DeclReferenceExprSyntax``.
///
/// ### Children
/// 
///  - `placeholder`: `<identifier>`
public struct EditorPlaceholderExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .editorPlaceholderExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePlaceholder: UnexpectedNodesSyntax? = nil,
    placeholder: TokenSyntax,
    _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforePlaceholder, placeholder, unexpectedAfterPlaceholder))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePlaceholder?.raw, placeholder.raw, unexpectedAfterPlaceholder?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.editorPlaceholderExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderExprSyntax.self)
    }
  }

  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EditorPlaceholderExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforePlaceholder, \Self.placeholder, \Self.unexpectedAfterPlaceholder])
}

// MARK: - EnumCaseDeclSyntax

/// A `case` declaration of a Swift `enum`. It can have 1 or more `EnumCaseElement`s inside, each declaring a different case of the enum.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `caseKeyword`: `case`
///  - `elements`: ``EnumCaseElementListSyntax``
///
/// ### Contained in
/// 
///  - ``ABIAttributeArgumentsSyntax``.``ABIAttributeArgumentsSyntax/provider``
public struct EnumCaseDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: The attributes applied to the case declaration.
  ///   - modifiers: The declaration modifiers applied to the case declaration.
  ///   - caseKeyword: The `case` keyword for this case.
  ///   - elements: The elements this case declares.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndCaseKeyword: UnexpectedNodesSyntax? = nil,
    caseKeyword: TokenSyntax = .keyword(.case),
    _ unexpectedBetweenCaseKeywordAndElements: UnexpectedNodesSyntax? = nil,
    elements: EnumCaseElementListSyntax,
    _ unexpectedAfterElements: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndCaseKeyword,
      caseKeyword,
      unexpectedBetweenCaseKeywordAndElements,
      elements,
      unexpectedAfterElements
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndCaseKeyword?.raw,
        caseKeyword.raw,
        unexpectedBetweenCaseKeywordAndElements?.raw,
        elements.raw,
        unexpectedAfterElements?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.enumCaseDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// The attributes applied to the case declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> EnumCaseDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumCaseDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// The declaration modifiers applied to the case declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> EnumCaseDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumCaseDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndCaseKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// The `case` keyword for this case.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `case`.
  public var caseKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  public var unexpectedBetweenCaseKeywordAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// The elements this case declares.
  public var elements: EnumCaseElementListSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(EnumCaseElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: EnumCaseElementSyntax) -> EnumCaseDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[7] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.enumCaseElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 7,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumCaseDeclSyntax.self)
  }

  public var unexpectedAfterElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndCaseKeyword,
    \Self.caseKeyword,
    \Self.unexpectedBetweenCaseKeywordAndElements,
    \Self.elements,
    \Self.unexpectedAfterElements
  ])
}

// MARK: - EnumCaseElementSyntax

/// An element of an enum case, containing the name of the case and, optionally, either associated values or an assignment to a raw value.
///
/// ### Children
/// 
///  - `name`: `<identifier>`
///  - `parameterClause`: ``EnumCaseParameterClauseSyntax``?
///  - `rawValue`: ``InitializerClauseSyntax``?
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``EnumCaseElementListSyntax``
public struct EnumCaseElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - name: The name of this case.
  ///   - parameterClause: The set of associated values of the case.
  ///   - rawValue: The raw value of this enum element, if present.
  ///   - trailingComma: The trailing comma of this element, if the case has multiple elements.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndParameterClause: UnexpectedNodesSyntax? = nil,
    parameterClause: EnumCaseParameterClauseSyntax? = nil,
    _ unexpectedBetweenParameterClauseAndRawValue: UnexpectedNodesSyntax? = nil,
    rawValue: InitializerClauseSyntax? = nil,
    _ unexpectedBetweenRawValueAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndParameterClause,
      parameterClause,
      unexpectedBetweenParameterClauseAndRawValue,
      rawValue,
      unexpectedBetweenRawValueAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndParameterClause?.raw,
        parameterClause?.raw,
        unexpectedBetweenParameterClauseAndRawValue?.raw,
        rawValue?.raw,
        unexpectedBetweenRawValueAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.enumCaseElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  /// The name of this case.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  /// The set of associated values of the case.
  public var parameterClause: EnumCaseParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(EnumCaseParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  public var unexpectedBetweenParameterClauseAndRawValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  /// The raw value of this enum element, if present.
  public var rawValue: InitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  public var unexpectedBetweenRawValueAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  /// The trailing comma of this element, if the case has multiple elements.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseElementSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndParameterClause,
    \Self.parameterClause,
    \Self.unexpectedBetweenParameterClauseAndRawValue,
    \Self.rawValue,
    \Self.unexpectedBetweenRawValueAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - EnumCaseParameterClauseSyntax

/// ### Children
/// 
///  - `leftParen`: `(`
///  - `parameters`: ``EnumCaseParameterListSyntax``
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``EnumCaseElementSyntax``.``EnumCaseElementSyntax/parameterClause``
public struct EnumCaseParameterClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseParameterClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - leftParen: The '(' to open the parameter clause.
  ///   - parameters: The actual parameters.
  ///   - rightParen: The ')' to close the parameter clause.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? = nil,
    parameters: EnumCaseParameterListSyntax,
    _ unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndParameters,
      parameters,
      unexpectedBetweenParametersAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndParameters?.raw,
        parameters.raw,
        unexpectedBetweenParametersAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.enumCaseParameterClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  /// The '(' to open the parameter clause.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  /// The actual parameters.
  public var parameters: EnumCaseParameterListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(EnumCaseParameterListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `parameters`
  /// collection.
  ///
  /// - param element: The new `Parameter` to add to the node's
  ///                  `parameters` collection.
  /// - returns: A copy of the receiver with the provided `Parameter`
  ///            appended to its `parameters` collection.
  @available(*, deprecated, message: "Use node.parameters.append(newElement) instead")
  public func addParameter(_ element: EnumCaseParameterSyntax) -> EnumCaseParameterClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.enumCaseParameterList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumCaseParameterClauseSyntax.self)
  }

  public var unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  /// The ')' to close the parameter clause.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndParameters,
    \Self.parameters,
    \Self.unexpectedBetweenParametersAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - EnumCaseParameterSyntax

/// ### Children
/// 
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `firstName`: (`<identifier>` | `_`)?
///  - `secondName`: (`<identifier>` | `_`)?
///  - `colon`: `:`?
///  - `type`: ``TypeSyntax``
///  - `defaultValue`: ``InitializerClauseSyntax``?
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``EnumCaseParameterListSyntax``
public struct EnumCaseParameterSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseParameter else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - colon: If the parameter has a label, the colon separating the label from the type.
  ///   - type: The parameter's type.
  ///   - defaultValue: If the parameter has a default value, the initializer clause describing the default value.
  ///   - trailingComma: If the parameter is followed by another parameter, the comma separating them.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndFirstName: UnexpectedNodesSyntax? = nil,
    firstName: TokenSyntax? = nil,
    _ unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? = nil,
    secondName: TokenSyntax? = nil,
    _ unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax? = nil,
    _ unexpectedBetweenColonAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedBetweenTypeAndDefaultValue: UnexpectedNodesSyntax? = nil,
    defaultValue: InitializerClauseSyntax? = nil,
    _ unexpectedBetweenDefaultValueAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeModifiers,
      modifiers,
      unexpectedBetweenModifiersAndFirstName,
      firstName,
      unexpectedBetweenFirstNameAndSecondName,
      secondName,
      unexpectedBetweenSecondNameAndColon,
      colon,
      unexpectedBetweenColonAndType,
      type,
      unexpectedBetweenTypeAndDefaultValue,
      defaultValue,
      unexpectedBetweenDefaultValueAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndFirstName?.raw,
        firstName?.raw,
        unexpectedBetweenFirstNameAndSecondName?.raw,
        secondName?.raw,
        unexpectedBetweenSecondNameAndColon?.raw,
        colon?.raw,
        unexpectedBetweenColonAndType?.raw,
        type.raw,
        unexpectedBetweenTypeAndDefaultValue?.raw,
        defaultValue?.raw,
        unexpectedBetweenDefaultValueAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.enumCaseParameter,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> EnumCaseParameterSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumCaseParameterSyntax.self)
  }

  public var unexpectedBetweenModifiersAndFirstName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `_`
  public var firstName: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `_`
  public var secondName: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// If the parameter has a label, the colon separating the label from the type.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// The parameter's type.
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAndDefaultValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// If the parameter has a default value, the initializer clause describing the default value.
  public var defaultValue: InitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var unexpectedBetweenDefaultValueAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  /// If the parameter is followed by another parameter, the comma separating them.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumCaseParameterSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndFirstName,
    \Self.firstName,
    \Self.unexpectedBetweenFirstNameAndSecondName,
    \Self.secondName,
    \Self.unexpectedBetweenSecondNameAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndType,
    \Self.type,
    \Self.unexpectedBetweenTypeAndDefaultValue,
    \Self.defaultValue,
    \Self.unexpectedBetweenDefaultValueAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - EnumDeclSyntax

/// A Swift `enum` declaration.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `enumKeyword`: `enum`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct EnumDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .enumDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: The attributes applied to the enum declaration.
  ///   - modifiers: The declaration modifiers applied to the enum declaration.
  ///   - enumKeyword: The `enum` keyword for this declaration.
  ///   - name: Declares the name of this enum. If the name matches a reserved keyword use backticks to escape it.
  ///   - genericParameterClause: The generic parameters, if any, for this enum declaration.
  ///   - inheritanceClause: The inheritance clause describing conformances or raw values for this enum declaration.
  ///   - genericWhereClause: The `where` clause that applies to the generic parameters of this enum declaration.
  ///   - memberBlock: The cases and other members associated with this enum declaration. Because enum extension declarations may declare additional members the contents of this member block isn't guaranteed to be a complete list of members for this type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndEnumKeyword: UnexpectedNodesSyntax? = nil,
    enumKeyword: TokenSyntax = .keyword(.enum),
    _ unexpectedBetweenEnumKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    _ unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    memberBlock: MemberBlockSyntax,
    _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndEnumKeyword,
      enumKeyword,
      unexpectedBetweenEnumKeywordAndName,
      name,
      unexpectedBetweenNameAndGenericParameterClause,
      genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndInheritanceClause,
      inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock,
      unexpectedAfterMemberBlock
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndEnumKeyword?.raw,
        enumKeyword.raw,
        unexpectedBetweenEnumKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndGenericParameterClause?.raw,
        genericParameterClause?.raw,
        unexpectedBetweenGenericParameterClauseAndInheritanceClause?.raw,
        inheritanceClause?.raw,
        unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw,
        memberBlock.raw,
        unexpectedAfterMemberBlock?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.enumDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The attributes applied to the enum declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> EnumDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The declaration modifiers applied to the enum declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> EnumDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(EnumDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndEnumKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The `enum` keyword for this declaration.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `enum`.
  public var enumKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public var unexpectedBetweenEnumKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// Declares the name of this enum. If the name matches a reserved keyword use backticks to escape it.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The generic parameters, if any, for this enum declaration.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The inheritance clause describing conformances or raw values for this enum declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The `where` clause that applies to the generic parameters of this enum declaration.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  /// The cases and other members associated with this enum declaration. Because enum extension declarations may declare additional members the contents of this member block isn't guaranteed to be a complete list of members for this type.
  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(EnumDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndEnumKeyword,
    \Self.enumKeyword,
    \Self.unexpectedBetweenEnumKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndGenericParameterClause,
    \Self.genericParameterClause,
    \Self.unexpectedBetweenGenericParameterClauseAndInheritanceClause,
    \Self.inheritanceClause,
    \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock,
    \Self.memberBlock,
    \Self.unexpectedAfterMemberBlock
  ])
}

// MARK: - ExpressionPatternSyntax

/// A pattern that contains an ``ExprSyntaxProtocol``.
/// 
/// ### Examples
/// 
/// Patterns can be used in switch cases like the following example:
/// ```swift
/// switch raw.kind {
///   case .expressionPattern:
///     return true
///   default:
///     return false
/// }
/// ```
///
/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
public struct ExpressionPatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .expressionPattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeExpression, expression, unexpectedAfterExpression))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeExpression?.raw, expression.raw, unexpectedAfterExpression?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.expressionPattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionPatternSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionPatternSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionPatternSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeExpression, \Self.expression, \Self.unexpectedAfterExpression])
}

// MARK: - ExpressionSegmentSyntax

/// An interpolated expression inside a string literal.
/// 
/// - SeeAlso: ``StringSegmentSyntax``
///
/// ### Children
/// 
///  - `backslash`: `\`
///  - `pounds`: `<rawStringPoundDelimiter>`?
///  - `leftParen`: `(`
///  - `expressions`: ``LabeledExprListSyntax``
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``StringLiteralSegmentListSyntax``
public struct ExpressionSegmentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .expressionSegment else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBackslash: UnexpectedNodesSyntax? = nil,
    backslash: TokenSyntax = .backslashToken(),
    _ unexpectedBetweenBackslashAndPounds: UnexpectedNodesSyntax? = nil,
    pounds: TokenSyntax? = nil,
    _ unexpectedBetweenPoundsAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndExpressions: UnexpectedNodesSyntax? = nil,
    expressions: LabeledExprListSyntax,
    _ unexpectedBetweenExpressionsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBackslash,
      backslash,
      unexpectedBetweenBackslashAndPounds,
      pounds,
      unexpectedBetweenPoundsAndLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndExpressions,
      expressions,
      unexpectedBetweenExpressionsAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBackslash?.raw,
        backslash.raw,
        unexpectedBetweenBackslashAndPounds?.raw,
        pounds?.raw,
        unexpectedBetweenPoundsAndLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndExpressions?.raw,
        expressions.raw,
        unexpectedBetweenExpressionsAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.expressionSegment,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBackslash: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `\`.
  public var backslash: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  public var unexpectedBetweenBackslashAndPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<rawStringPoundDelimiter>`.
  public var pounds: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  public var unexpectedBetweenPoundsAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndExpressions: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  public var expressions: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `expressions`
  /// collection.
  ///
  /// - param element: The new `Expression` to add to the node's
  ///                  `expressions` collection.
  /// - returns: A copy of the receiver with the provided `Expression`
  ///            appended to its `expressions` collection.
  @available(*, deprecated, message: "Use node.expressions.append(newElement) instead")
  public func addExpression(_ element: LabeledExprSyntax) -> ExpressionSegmentSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[7] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 7,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ExpressionSegmentSyntax.self)
  }

  public var unexpectedBetweenExpressionsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionSegmentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBackslash,
    \Self.backslash,
    \Self.unexpectedBetweenBackslashAndPounds,
    \Self.pounds,
    \Self.unexpectedBetweenPoundsAndLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndExpressions,
    \Self.expressions,
    \Self.unexpectedBetweenExpressionsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - ExpressionStmtSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
public struct ExpressionStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .expressionStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeExpression, expression, unexpectedAfterExpression))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeExpression?.raw, expression.raw, unexpectedAfterExpression?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.expressionStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionStmtSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionStmtSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExpressionStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeExpression, \Self.expression, \Self.unexpectedAfterExpression])
}

// MARK: - ExtensionDeclSyntax

///   An `extension` declaration.
/// 
///  ### Example
/// 
///   ```swift
///   extension String {
///     var url: URL? {
///       URL(string: self)
///     }
///   }
///   ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `extensionKeyword`: `extension`
///  - `extendedType`: ``TypeSyntax``
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct ExtensionDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .extensionDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes that are attached to the extension declaration.
  ///   - modifiers: Modifiers like `public` that are attached to the extension declaration.
  ///   - extensionKeyword: The `extension` keyword.
  ///   - extendedType: The extended `type` for which the extension is added.
  ///   - inheritanceClause: The inheritance clause describing one or more conformances for this extension declaration.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - memberBlock: The members of the extension declaration. As this is an extension, the contents of this member block isn't guaranteed to be a complete list of members for this type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndExtensionKeyword: UnexpectedNodesSyntax? = nil,
    extensionKeyword: TokenSyntax = .keyword(.extension),
    _ unexpectedBetweenExtensionKeywordAndExtendedType: UnexpectedNodesSyntax? = nil,
    extendedType: some TypeSyntaxProtocol,
    _ unexpectedBetweenExtendedTypeAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    memberBlock: MemberBlockSyntax,
    _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndExtensionKeyword,
      extensionKeyword,
      unexpectedBetweenExtensionKeywordAndExtendedType,
      extendedType,
      unexpectedBetweenExtendedTypeAndInheritanceClause,
      inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock,
      unexpectedAfterMemberBlock
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndExtensionKeyword?.raw,
        extensionKeyword.raw,
        unexpectedBetweenExtensionKeywordAndExtendedType?.raw,
        extendedType.raw,
        unexpectedBetweenExtendedTypeAndInheritanceClause?.raw,
        inheritanceClause?.raw,
        unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw,
        memberBlock.raw,
        unexpectedAfterMemberBlock?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.extensionDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// Attributes that are attached to the extension declaration.
  /// 
  /// ### Example
  /// 
  /// `@MainActor` in
  /// 
  /// ```swift
  /// @MainActor extension SomeType {}
  /// ```
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ExtensionDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ExtensionDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// Modifiers like `public` that are attached to the extension declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ExtensionDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ExtensionDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndExtensionKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// The `extension` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `extension`.
  public var extensionKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenExtensionKeywordAndExtendedType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// The extended `type` for which the extension is added.
  public var extendedType: TypeSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenExtendedTypeAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// The inheritance clause describing one or more conformances for this extension declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  /// The members of the extension declaration. As this is an extension, the contents of this member block isn't guaranteed to be a complete list of members for this type.
  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 13)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ExtensionDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndExtensionKeyword,
    \Self.extensionKeyword,
    \Self.unexpectedBetweenExtensionKeywordAndExtendedType,
    \Self.extendedType,
    \Self.unexpectedBetweenExtendedTypeAndInheritanceClause,
    \Self.inheritanceClause,
    \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock,
    \Self.memberBlock,
    \Self.unexpectedAfterMemberBlock
  ])
}

// MARK: - FallThroughStmtSyntax

/// ### Children
/// 
///  - `fallthroughKeyword`: `fallthrough`
public struct FallThroughStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .fallThroughStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeFallthroughKeyword: UnexpectedNodesSyntax? = nil,
    fallthroughKeyword: TokenSyntax = .keyword(.fallthrough),
    _ unexpectedAfterFallthroughKeyword: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeFallthroughKeyword, fallthroughKeyword, unexpectedAfterFallthroughKeyword))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeFallthroughKeyword?.raw, fallthroughKeyword.raw, unexpectedAfterFallthroughKeyword?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.fallThroughStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeFallthroughKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FallThroughStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `fallthrough`.
  public var fallthroughKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FallThroughStmtSyntax.self)
    }
  }

  public var unexpectedAfterFallthroughKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FallThroughStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeFallthroughKeyword, \Self.fallthroughKeyword, \Self.unexpectedAfterFallthroughKeyword])
}

// MARK: - FloatLiteralExprSyntax

/// ### Children
/// 
///  - `literal`: `<floatLiteral>`
public struct FloatLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .floatLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLiteral: UnexpectedNodesSyntax? = nil,
    literal: TokenSyntax,
    _ unexpectedAfterLiteral: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeLiteral, literal, unexpectedAfterLiteral))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeLiteral?.raw, literal.raw, unexpectedAfterLiteral?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.floatLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FloatLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<floatLiteral>`.
  public var literal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FloatLiteralExprSyntax.self)
    }
  }

  public var unexpectedAfterLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FloatLiteralExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeLiteral, \Self.literal, \Self.unexpectedAfterLiteral])
}

// MARK: - ForStmtSyntax

/// ### Children
/// 
///  - `forKeyword`: `for`
///  - `tryKeyword`: `try`?
///  - `awaitKeyword`: `await`?
///  - `unsafeKeyword`: `unsafe`?
///  - `caseKeyword`: `case`?
///  - `pattern`: ``PatternSyntax``
///  - `typeAnnotation`: ``TypeAnnotationSyntax``?
///  - `inKeyword`: `in`
///  - `sequence`: ``ExprSyntax``
///  - `whereClause`: ``WhereClauseSyntax``?
///  - `body`: ``CodeBlockSyntax``
public struct ForStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .forStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeForKeyword: UnexpectedNodesSyntax? = nil,
    forKeyword: TokenSyntax = .keyword(.for),
    _ unexpectedBetweenForKeywordAndTryKeyword: UnexpectedNodesSyntax? = nil,
    tryKeyword: TokenSyntax? = nil,
    _ unexpectedBetweenTryKeywordAndAwaitKeyword: UnexpectedNodesSyntax? = nil,
    awaitKeyword: TokenSyntax? = nil,
    _ unexpectedBetweenAwaitKeywordAndUnsafeKeyword: UnexpectedNodesSyntax? = nil,
    unsafeKeyword: TokenSyntax? = nil,
    _ unexpectedBetweenUnsafeKeywordAndCaseKeyword: UnexpectedNodesSyntax? = nil,
    caseKeyword: TokenSyntax? = nil,
    _ unexpectedBetweenCaseKeywordAndPattern: UnexpectedNodesSyntax? = nil,
    pattern: some PatternSyntaxProtocol,
    _ unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? = nil,
    typeAnnotation: TypeAnnotationSyntax? = nil,
    _ unexpectedBetweenTypeAnnotationAndInKeyword: UnexpectedNodesSyntax? = nil,
    inKeyword: TokenSyntax = .keyword(.in),
    _ unexpectedBetweenInKeywordAndSequence: UnexpectedNodesSyntax? = nil,
    sequence: some ExprSyntaxProtocol,
    _ unexpectedBetweenSequenceAndWhereClause: UnexpectedNodesSyntax? = nil,
    whereClause: WhereClauseSyntax? = nil,
    _ unexpectedBetweenWhereClauseAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeForKeyword,
      forKeyword,
      unexpectedBetweenForKeywordAndTryKeyword,
      tryKeyword,
      unexpectedBetweenTryKeywordAndAwaitKeyword,
      awaitKeyword,
      unexpectedBetweenAwaitKeywordAndUnsafeKeyword,
      unsafeKeyword,
      unexpectedBetweenUnsafeKeywordAndCaseKeyword,
      caseKeyword,
      unexpectedBetweenCaseKeywordAndPattern,
      pattern,
      unexpectedBetweenPatternAndTypeAnnotation,
      typeAnnotation,
      unexpectedBetweenTypeAnnotationAndInKeyword,
      inKeyword,
      unexpectedBetweenInKeywordAndSequence,
      sequence,
      unexpectedBetweenSequenceAndWhereClause,
      whereClause,
      unexpectedBetweenWhereClauseAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeForKeyword?.raw,
        forKeyword.raw,
        unexpectedBetweenForKeywordAndTryKeyword?.raw,
        tryKeyword?.raw,
        unexpectedBetweenTryKeywordAndAwaitKeyword?.raw,
        awaitKeyword?.raw,
        unexpectedBetweenAwaitKeywordAndUnsafeKeyword?.raw,
        unsafeKeyword?.raw,
        unexpectedBetweenUnsafeKeywordAndCaseKeyword?.raw,
        caseKeyword?.raw,
        unexpectedBetweenCaseKeywordAndPattern?.raw,
        pattern.raw,
        unexpectedBetweenPatternAndTypeAnnotation?.raw,
        typeAnnotation?.raw,
        unexpectedBetweenTypeAnnotationAndInKeyword?.raw,
        inKeyword.raw,
        unexpectedBetweenInKeywordAndSequence?.raw,
        sequence.raw,
        unexpectedBetweenSequenceAndWhereClause?.raw,
        whereClause?.raw,
        unexpectedBetweenWhereClauseAndBody?.raw,
        body.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.forStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeForKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `for`.
  public var forKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenForKeywordAndTryKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `try`.
  public var tryKeyword: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenTryKeywordAndAwaitKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `await`.
  public var awaitKeyword: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenAwaitKeywordAndUnsafeKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `unsafe`.
  public var unsafeKeyword: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenUnsafeKeywordAndCaseKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `case`.
  public var caseKeyword: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenCaseKeywordAndPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var typeAnnotation: TypeAnnotationSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(TypeAnnotationSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAnnotationAndInKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `in`.
  public var inKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenInKeywordAndSequence: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var sequence: ExprSyntax {
    get {
      return Syntax(self).child(at: 17)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 17, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenSequenceAndWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 18)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 18, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var whereClause: WhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 19)?.cast(WhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 19, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedBetweenWhereClauseAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 20)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 20, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 21)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 21, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 22)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 22, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeForKeyword,
    \Self.forKeyword,
    \Self.unexpectedBetweenForKeywordAndTryKeyword,
    \Self.tryKeyword,
    \Self.unexpectedBetweenTryKeywordAndAwaitKeyword,
    \Self.awaitKeyword,
    \Self.unexpectedBetweenAwaitKeywordAndUnsafeKeyword,
    \Self.unsafeKeyword,
    \Self.unexpectedBetweenUnsafeKeywordAndCaseKeyword,
    \Self.caseKeyword,
    \Self.unexpectedBetweenCaseKeywordAndPattern,
    \Self.pattern,
    \Self.unexpectedBetweenPatternAndTypeAnnotation,
    \Self.typeAnnotation,
    \Self.unexpectedBetweenTypeAnnotationAndInKeyword,
    \Self.inKeyword,
    \Self.unexpectedBetweenInKeywordAndSequence,
    \Self.sequence,
    \Self.unexpectedBetweenSequenceAndWhereClause,
    \Self.whereClause,
    \Self.unexpectedBetweenWhereClauseAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - ForceUnwrapExprSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `exclamationMark`: `!`
public struct ForceUnwrapExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .forceUnwrapExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndExclamationMark: UnexpectedNodesSyntax? = nil,
    exclamationMark: TokenSyntax = .exclamationMarkToken(),
    _ unexpectedAfterExclamationMark: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndExclamationMark,
      exclamationMark,
      unexpectedAfterExclamationMark
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndExclamationMark?.raw,
        exclamationMark.raw,
        unexpectedAfterExclamationMark?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.forceUnwrapExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForceUnwrapExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForceUnwrapExprSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForceUnwrapExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `!`.
  public var exclamationMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForceUnwrapExprSyntax.self)
    }
  }

  public var unexpectedAfterExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ForceUnwrapExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndExclamationMark,
    \Self.exclamationMark,
    \Self.unexpectedAfterExclamationMark
  ])
}

// MARK: - FunctionCallExprSyntax

/// ### Children
/// 
///  - `calledExpression`: ``ExprSyntax``
///  - `leftParen`: `(`?
///  - `arguments`: ``LabeledExprListSyntax``
///  - `rightParen`: `)`?
///  - `trailingClosure`: ``ClosureExprSyntax``?
///  - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
public struct FunctionCallExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionCallExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeCalledExpression: UnexpectedNodesSyntax? = nil,
    calledExpression: some ExprSyntaxProtocol,
    _ unexpectedBetweenCalledExpressionAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax?,
    _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: LabeledExprListSyntax,
    _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax?,
    _ unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    _ unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    _ unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeCalledExpression,
      calledExpression,
      unexpectedBetweenCalledExpressionAndLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightParen,
      rightParen,
      unexpectedBetweenRightParenAndTrailingClosure,
      trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeCalledExpression?.raw,
        calledExpression.raw,
        unexpectedBetweenCalledExpressionAndLeftParen?.raw,
        leftParen?.raw,
        unexpectedBetweenLeftParenAndArguments?.raw,
        arguments.raw,
        unexpectedBetweenArgumentsAndRightParen?.raw,
        rightParen?.raw,
        unexpectedBetweenRightParenAndTrailingClosure?.raw,
        trailingClosure?.raw,
        unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures?.raw,
        additionalTrailingClosures.raw,
        unexpectedAfterAdditionalTrailingClosures?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionCallExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeCalledExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var calledExpression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenCalledExpressionAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var arguments: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: LabeledExprSyntax) -> FunctionCallExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionCallExprSyntax.self)
  }

  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var trailingClosure: ClosureExprSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(ClosureExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public var additionalTrailingClosures: MultipleTrailingClosureElementListSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(MultipleTrailingClosureElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `additionalTrailingClosures`
  /// collection.
  ///
  /// - param element: The new `AdditionalTrailingClosure` to add to the node's
  ///                  `additionalTrailingClosures` collection.
  /// - returns: A copy of the receiver with the provided `AdditionalTrailingClosure`
  ///            appended to its `additionalTrailingClosures` collection.
  @available(*, deprecated, message: "Use node.additionalTrailingClosures.append(newElement) instead")
  public func addAdditionalTrailingClosure(_ element: MultipleTrailingClosureElementSyntax) -> FunctionCallExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[11] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.multipleTrailingClosureElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 11,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionCallExprSyntax.self)
  }

  public var unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionCallExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeCalledExpression,
    \Self.calledExpression,
    \Self.unexpectedBetweenCalledExpressionAndLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedBetweenRightParenAndTrailingClosure,
    \Self.trailingClosure,
    \Self.unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
    \Self.additionalTrailingClosures,
    \Self.unexpectedAfterAdditionalTrailingClosures
  ])
}

// MARK: - FunctionDeclSyntax

///   A Swift `func` declaration.
///   
///   ### Example
///   
///   A func declaration may be declared without any parameter.
///   
///   ```swift
///   func foo() {
///   
///   }
///   ```
///   
///   A func declaration with multiple parameters.
///   
///   ```swift
///   func bar(_ arg1: Int, _ arg2: Int) {
///   
///   }
///   ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `funcKeyword`: `func`
///  - `name`: (`<identifier>` | `<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `signature`: ``FunctionSignatureSyntax``
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `body`: ``CodeBlockSyntax``?
///
/// ### Contained in
/// 
///  - ``ABIAttributeArgumentsSyntax``.``ABIAttributeArgumentsSyntax/provider``
public struct FunctionDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes that are attached to the function declaration.
  ///   - modifiers: Modifiers like `public` that are attached to the function declaration.
  ///   - funcKeyword: The `func` keyword.
  ///   - name: The name of the function. If the name matches a reserved keyword use backticks to escape it.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - signature: A function signature that defines the interface of the function.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - body: The function's body.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndFuncKeyword: UnexpectedNodesSyntax? = nil,
    funcKeyword: TokenSyntax = .keyword(.func),
    _ unexpectedBetweenFuncKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    _ unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? = nil,
    signature: FunctionSignatureSyntax,
    _ unexpectedBetweenSignatureAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax? = nil,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndFuncKeyword,
      funcKeyword,
      unexpectedBetweenFuncKeywordAndName,
      name,
      unexpectedBetweenNameAndGenericParameterClause,
      genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndSignature,
      signature,
      unexpectedBetweenSignatureAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndFuncKeyword?.raw,
        funcKeyword.raw,
        unexpectedBetweenFuncKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndGenericParameterClause?.raw,
        genericParameterClause?.raw,
        unexpectedBetweenGenericParameterClauseAndSignature?.raw,
        signature.raw,
        unexpectedBetweenSignatureAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndBody?.raw,
        body?.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// Attributes that are attached to the function declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> FunctionDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// Modifiers like `public` that are attached to the function declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> FunctionDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndFuncKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// The `func` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `func`.
  public var funcKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenFuncKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// The name of the function. If the name matches a reserved keyword use backticks to escape it.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `<binaryOperator>`
  ///  - `<prefixOperator>`
  ///  - `<postfixOperator>`
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// A function signature that defines the interface of the function.
  public var signature: FunctionSignatureSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(FunctionSignatureSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenSignatureAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  /// The function's body.
  public var body: CodeBlockSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndFuncKeyword,
    \Self.funcKeyword,
    \Self.unexpectedBetweenFuncKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndGenericParameterClause,
    \Self.genericParameterClause,
    \Self.unexpectedBetweenGenericParameterClauseAndSignature,
    \Self.signature,
    \Self.unexpectedBetweenSignatureAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - FunctionEffectSpecifiersSyntax

/// ### Children
/// 
///  - `asyncSpecifier`: (`async` | `reasync`)?
///  - `throwsClause`: ``ThrowsClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``FunctionSignatureSyntax``.``FunctionSignatureSyntax/effectSpecifiers``
public struct FunctionEffectSpecifiersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionEffectSpecifiers else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - asyncSpecifier: The `async` or `reasync` keyword.
  ///   - throwsClause: The clause specifying thrown errors
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? = nil,
    asyncSpecifier: TokenSyntax? = nil,
    _ unexpectedBetweenAsyncSpecifierAndThrowsClause: UnexpectedNodesSyntax? = nil,
    throwsClause: ThrowsClauseSyntax? = nil,
    _ unexpectedAfterThrowsClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAsyncSpecifier,
      asyncSpecifier,
      unexpectedBetweenAsyncSpecifierAndThrowsClause,
      throwsClause,
      unexpectedAfterThrowsClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAsyncSpecifier?.raw,
        asyncSpecifier?.raw,
        unexpectedBetweenAsyncSpecifierAndThrowsClause?.raw,
        throwsClause?.raw,
        unexpectedAfterThrowsClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionEffectSpecifiers,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionEffectSpecifiersSyntax.self)
    }
  }

  /// The `async` or `reasync` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `async`
  ///  - `reasync`
  public var asyncSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionEffectSpecifiersSyntax.self)
    }
  }

  public var unexpectedBetweenAsyncSpecifierAndThrowsClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionEffectSpecifiersSyntax.self)
    }
  }

  /// The clause specifying thrown errors
  public var throwsClause: ThrowsClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ThrowsClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionEffectSpecifiersSyntax.self)
    }
  }

  public var unexpectedAfterThrowsClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionEffectSpecifiersSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAsyncSpecifier,
    \Self.asyncSpecifier,
    \Self.unexpectedBetweenAsyncSpecifierAndThrowsClause,
    \Self.throwsClause,
    \Self.unexpectedAfterThrowsClause
  ])
}

// MARK: - FunctionParameterClauseSyntax

/// ### Children
/// 
///  - `leftParen`: `(`
///  - `parameters`: ``FunctionParameterListSyntax``
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``FunctionSignatureSyntax``.``FunctionSignatureSyntax/parameterClause``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/parameterClause``
public struct FunctionParameterClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionParameterClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? = nil,
    parameters: FunctionParameterListSyntax,
    _ unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndParameters,
      parameters,
      unexpectedBetweenParametersAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndParameters?.raw,
        parameters.raw,
        unexpectedBetweenParametersAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionParameterClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  public var parameters: FunctionParameterListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(FunctionParameterListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `parameters`
  /// collection.
  ///
  /// - param element: The new `Parameter` to add to the node's
  ///                  `parameters` collection.
  /// - returns: A copy of the receiver with the provided `Parameter`
  ///            appended to its `parameters` collection.
  @available(*, deprecated, message: "Use node.parameters.append(newElement) instead")
  public func addParameter(_ element: FunctionParameterSyntax) -> FunctionParameterClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.functionParameterList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionParameterClauseSyntax.self)
  }

  public var unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndParameters,
    \Self.parameters,
    \Self.unexpectedBetweenParametersAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - FunctionParameterSyntax

/// A function parameter
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `firstName`: (`<identifier>` | `_`)
///  - `secondName`: (`<identifier>` | `_`)?
///  - `colon`: `:`
///  - `type`: ``TypeSyntax``
///  - `ellipsis`: `...`?
///  - `defaultValue`: ``InitializerClauseSyntax``?
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``FunctionParameterListSyntax``
public struct FunctionParameterSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionParameter else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes that are attached to the parameter.
  ///   - modifiers: Modifiers that are attached to the parameter.
  ///   - firstName: The label of this parameter that will be used when the function is called.
  ///   - secondName: If this is specified, it is the name by which the parameter can be referenced inside the function body.
  ///   - colon: The colon separating the label from the type.
  ///   - type: The parameter's type.
  ///   - ellipsis: If the parameter is variadic, `...` to indicate that.
  ///   - defaultValue: If the parameter has a default value, the expression describing the default value.
  ///   - trailingComma: If the parameter is followed by another parameter, the comma separating them.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndFirstName: UnexpectedNodesSyntax? = nil,
    firstName: TokenSyntax,
    _ unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? = nil,
    secondName: TokenSyntax? = nil,
    _ unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedBetweenTypeAndEllipsis: UnexpectedNodesSyntax? = nil,
    ellipsis: TokenSyntax? = nil,
    _ unexpectedBetweenEllipsisAndDefaultValue: UnexpectedNodesSyntax? = nil,
    defaultValue: InitializerClauseSyntax? = nil,
    _ unexpectedBetweenDefaultValueAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndFirstName,
      firstName,
      unexpectedBetweenFirstNameAndSecondName,
      secondName,
      unexpectedBetweenSecondNameAndColon,
      colon,
      unexpectedBetweenColonAndType,
      type,
      unexpectedBetweenTypeAndEllipsis,
      ellipsis,
      unexpectedBetweenEllipsisAndDefaultValue,
      defaultValue,
      unexpectedBetweenDefaultValueAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndFirstName?.raw,
        firstName.raw,
        unexpectedBetweenFirstNameAndSecondName?.raw,
        secondName?.raw,
        unexpectedBetweenSecondNameAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndType?.raw,
        type.raw,
        unexpectedBetweenTypeAndEllipsis?.raw,
        ellipsis?.raw,
        unexpectedBetweenEllipsisAndDefaultValue?.raw,
        defaultValue?.raw,
        unexpectedBetweenDefaultValueAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionParameter,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// Attributes that are attached to the parameter.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> FunctionParameterSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionParameterSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// Modifiers that are attached to the parameter.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> FunctionParameterSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionParameterSyntax.self)
  }

  public var unexpectedBetweenModifiersAndFirstName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// The label of this parameter that will be used when the function is called.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `_`
  public var firstName: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// If this is specified, it is the name by which the parameter can be referenced inside the function body.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `_`
  public var secondName: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// The colon separating the label from the type.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// The parameter's type.
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAndEllipsis: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// If the parameter is variadic, `...` to indicate that.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `...`.
  public var ellipsis: TokenSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedBetweenEllipsisAndDefaultValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// If the parameter has a default value, the expression describing the default value.
  public var defaultValue: InitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedBetweenDefaultValueAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  /// If the parameter is followed by another parameter, the comma separating them.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 17)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 17, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 18)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 18, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionParameterSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndFirstName,
    \Self.firstName,
    \Self.unexpectedBetweenFirstNameAndSecondName,
    \Self.secondName,
    \Self.unexpectedBetweenSecondNameAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndType,
    \Self.type,
    \Self.unexpectedBetweenTypeAndEllipsis,
    \Self.ellipsis,
    \Self.unexpectedBetweenEllipsisAndDefaultValue,
    \Self.defaultValue,
    \Self.unexpectedBetweenDefaultValueAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - FunctionSignatureSyntax

/// A function signature that defines the interface of the function.
///
/// ### Children
/// 
///  - `parameterClause`: ``FunctionParameterClauseSyntax``
///  - `effectSpecifiers`: ``FunctionEffectSpecifiersSyntax``?
///  - `returnClause`: ``ReturnClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/signature``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/signature``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/signature``
public struct FunctionSignatureSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionSignature else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - parameterClause: The parameters of the function.
  ///   - effectSpecifiers: The effect indicators of the function, like `async` or `throws`
  ///   - returnClause: The return type of the function.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeParameterClause: UnexpectedNodesSyntax? = nil,
    parameterClause: FunctionParameterClauseSyntax,
    _ unexpectedBetweenParameterClauseAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
    effectSpecifiers: FunctionEffectSpecifiersSyntax? = nil,
    _ unexpectedBetweenEffectSpecifiersAndReturnClause: UnexpectedNodesSyntax? = nil,
    returnClause: ReturnClauseSyntax? = nil,
    _ unexpectedAfterReturnClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeParameterClause,
      parameterClause,
      unexpectedBetweenParameterClauseAndEffectSpecifiers,
      effectSpecifiers,
      unexpectedBetweenEffectSpecifiersAndReturnClause,
      returnClause,
      unexpectedAfterReturnClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeParameterClause?.raw,
        parameterClause.raw,
        unexpectedBetweenParameterClauseAndEffectSpecifiers?.raw,
        effectSpecifiers?.raw,
        unexpectedBetweenEffectSpecifiersAndReturnClause?.raw,
        returnClause?.raw,
        unexpectedAfterReturnClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionSignature,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  /// The parameters of the function.
  public var parameterClause: FunctionParameterClauseSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(FunctionParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  public var unexpectedBetweenParameterClauseAndEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  /// The effect indicators of the function, like `async` or `throws`
  public var effectSpecifiers: FunctionEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(FunctionEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  public var unexpectedBetweenEffectSpecifiersAndReturnClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  /// The return type of the function.
  public var returnClause: ReturnClauseSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(ReturnClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  public var unexpectedAfterReturnClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionSignatureSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeParameterClause,
    \Self.parameterClause,
    \Self.unexpectedBetweenParameterClauseAndEffectSpecifiers,
    \Self.effectSpecifiers,
    \Self.unexpectedBetweenEffectSpecifiersAndReturnClause,
    \Self.returnClause,
    \Self.unexpectedAfterReturnClause
  ])
}

// MARK: - FunctionTypeSyntax

/// ### Children
/// 
///  - `leftParen`: `(`
///  - `parameters`: ``TupleTypeElementListSyntax``
///  - `rightParen`: `)`
///  - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
///  - `returnClause`: ``ReturnClauseSyntax``
public struct FunctionTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .functionType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? = nil,
    parameters: TupleTypeElementListSyntax,
    _ unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedBetweenRightParenAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
    effectSpecifiers: TypeEffectSpecifiersSyntax? = nil,
    _ unexpectedBetweenEffectSpecifiersAndReturnClause: UnexpectedNodesSyntax? = nil,
    returnClause: ReturnClauseSyntax,
    _ unexpectedAfterReturnClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndParameters,
      parameters,
      unexpectedBetweenParametersAndRightParen,
      rightParen,
      unexpectedBetweenRightParenAndEffectSpecifiers,
      effectSpecifiers,
      unexpectedBetweenEffectSpecifiersAndReturnClause,
      returnClause,
      unexpectedAfterReturnClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndParameters?.raw,
        parameters.raw,
        unexpectedBetweenParametersAndRightParen?.raw,
        rightParen.raw,
        unexpectedBetweenRightParenAndEffectSpecifiers?.raw,
        effectSpecifiers?.raw,
        unexpectedBetweenEffectSpecifiersAndReturnClause?.raw,
        returnClause.raw,
        unexpectedAfterReturnClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.functionType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var parameters: TupleTypeElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TupleTypeElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `parameters`
  /// collection.
  ///
  /// - param element: The new `Parameter` to add to the node's
  ///                  `parameters` collection.
  /// - returns: A copy of the receiver with the provided `Parameter`
  ///            appended to its `parameters` collection.
  @available(*, deprecated, message: "Use node.parameters.append(newElement) instead")
  public func addParameter(_ element: TupleTypeElementSyntax) -> FunctionTypeSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.tupleTypeElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(FunctionTypeSyntax.self)
  }

  public var unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var unexpectedBetweenRightParenAndEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var effectSpecifiers: TypeEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TypeEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var unexpectedBetweenEffectSpecifiersAndReturnClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var returnClause: ReturnClauseSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(ReturnClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public var unexpectedAfterReturnClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(FunctionTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndParameters,
    \Self.parameters,
    \Self.unexpectedBetweenParametersAndRightParen,
    \Self.rightParen,
    \Self.unexpectedBetweenRightParenAndEffectSpecifiers,
    \Self.effectSpecifiers,
    \Self.unexpectedBetweenEffectSpecifiersAndReturnClause,
    \Self.returnClause,
    \Self.unexpectedAfterReturnClause
  ])
}
