//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

@_spi(RawSyntax)
public protocol RawExprSyntaxNodeProtocol: RawSyntaxNodeProtocol {}

@_spi(RawSyntax)
public struct RawEditorPlaceholderDeclSyntax: RawDeclSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .editorPlaceholderDecl
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? = nil,
    attributes: RawAttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndPlaceholder: RawUnexpectedNodesSyntax? = nil,
    placeholder: RawTokenSyntax,
    _ unexpectedAfterPlaceholder: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .editorPlaceholderDecl, uninitializedCount: 7, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAttributes?.raw
      layout[1] = attributes.raw
      layout[2] = unexpectedBetweenAttributesAndModifiers?.raw
      layout[3] = modifiers.raw
      layout[4] = unexpectedBetweenModifiersAndPlaceholder?.raw
      layout[5] = placeholder.raw
      layout[6] = unexpectedAfterPlaceholder?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var attributes: RawAttributeListSyntax {
    layoutView.children[1].map(RawAttributeListSyntax.init(raw:))!
  }

  public var unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[3].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndPlaceholder: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var placeholder: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterPlaceholder: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawEditorPlaceholderExprSyntax: RawExprSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .editorPlaceholderExpr
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforePlaceholder: RawUnexpectedNodesSyntax? = nil,
    placeholder: RawTokenSyntax,
    _ unexpectedAfterPlaceholder: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .editorPlaceholderExpr, uninitializedCount: 3, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforePlaceholder?.raw
      layout[1] = placeholder.raw
      layout[2] = unexpectedAfterPlaceholder?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforePlaceholder: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var placeholder: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterPlaceholder: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawEffectsAttributeArgumentListSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .effectsAttributeArgumentList
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(elements: [RawTokenSyntax], arena: __shared RawSyntaxArena) {
    let raw = RawSyntax.makeLayout(
      kind: .effectsAttributeArgumentList, uninitializedCount: elements.count, arena: arena) { layout in
        guard var ptr = layout.baseAddress else {
          return
        }
        for elem in elements {
          ptr.initialize(to: elem.raw)
          ptr += 1
        }
    }
    self.init(unchecked: raw)
  }

  public var elements: [RawTokenSyntax] {
    layoutView.children.map {
      RawTokenSyntax(raw: $0!)
    }
  }
}

@_spi(RawSyntax)
public struct RawEnumCaseDeclSyntax: RawDeclSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumCaseDecl
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? = nil,
    attributes: RawAttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndCaseKeyword: RawUnexpectedNodesSyntax? = nil,
    caseKeyword: RawTokenSyntax,
    _ unexpectedBetweenCaseKeywordAndElements: RawUnexpectedNodesSyntax? = nil,
    elements: RawEnumCaseElementListSyntax,
    _ unexpectedAfterElements: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .enumCaseDecl, uninitializedCount: 9, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAttributes?.raw
      layout[1] = attributes.raw
      layout[2] = unexpectedBetweenAttributesAndModifiers?.raw
      layout[3] = modifiers.raw
      layout[4] = unexpectedBetweenModifiersAndCaseKeyword?.raw
      layout[5] = caseKeyword.raw
      layout[6] = unexpectedBetweenCaseKeywordAndElements?.raw
      layout[7] = elements.raw
      layout[8] = unexpectedAfterElements?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var attributes: RawAttributeListSyntax {
    layoutView.children[1].map(RawAttributeListSyntax.init(raw:))!
  }

  public var unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[3].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndCaseKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var caseKeyword: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenCaseKeywordAndElements: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var elements: RawEnumCaseElementListSyntax {
    layoutView.children[7].map(RawEnumCaseElementListSyntax.init(raw:))!
  }

  public var unexpectedAfterElements: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawEnumCaseElementListSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumCaseElementList
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(elements: [RawEnumCaseElementSyntax], arena: __shared RawSyntaxArena) {
    let raw = RawSyntax.makeLayout(
      kind: .enumCaseElementList, uninitializedCount: elements.count, arena: arena) { layout in
        guard var ptr = layout.baseAddress else {
          return
        }
        for elem in elements {
          ptr.initialize(to: elem.raw)
          ptr += 1
        }
    }
    self.init(unchecked: raw)
  }

  public var elements: [RawEnumCaseElementSyntax] {
    layoutView.children.map {
      RawEnumCaseElementSyntax(raw: $0!)
    }
  }
}

@_spi(RawSyntax)
public struct RawEnumCaseElementSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumCaseElement
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeName: RawUnexpectedNodesSyntax? = nil,
    name: RawTokenSyntax,
    _ unexpectedBetweenNameAndParameterClause: RawUnexpectedNodesSyntax? = nil,
    parameterClause: RawEnumCaseParameterClauseSyntax?,
    _ unexpectedBetweenParameterClauseAndRawValue: RawUnexpectedNodesSyntax? = nil,
    rawValue: RawInitializerClauseSyntax?,
    _ unexpectedBetweenRawValueAndTrailingComma: RawUnexpectedNodesSyntax? = nil,
    trailingComma: RawTokenSyntax?,
    _ unexpectedAfterTrailingComma: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .enumCaseElement, uninitializedCount: 9, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeName?.raw
      layout[1] = name.raw
      layout[2] = unexpectedBetweenNameAndParameterClause?.raw
      layout[3] = parameterClause?.raw
      layout[4] = unexpectedBetweenParameterClauseAndRawValue?.raw
      layout[5] = rawValue?.raw
      layout[6] = unexpectedBetweenRawValueAndTrailingComma?.raw
      layout[7] = trailingComma?.raw
      layout[8] = unexpectedAfterTrailingComma?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeName: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var name: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenNameAndParameterClause: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var parameterClause: RawEnumCaseParameterClauseSyntax? {
    layoutView.children[3].map(RawEnumCaseParameterClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenParameterClauseAndRawValue: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var rawValue: RawInitializerClauseSyntax? {
    layoutView.children[5].map(RawInitializerClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenRawValueAndTrailingComma: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var trailingComma: RawTokenSyntax? {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedAfterTrailingComma: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawEnumCaseParameterClauseSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumCaseParameterClause
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeLeftParen: RawUnexpectedNodesSyntax? = nil,
    leftParen: RawTokenSyntax,
    _ unexpectedBetweenLeftParenAndParameters: RawUnexpectedNodesSyntax? = nil,
    parameters: RawEnumCaseParameterListSyntax,
    _ unexpectedBetweenParametersAndRightParen: RawUnexpectedNodesSyntax? = nil,
    rightParen: RawTokenSyntax,
    _ unexpectedAfterRightParen: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .enumCaseParameterClause, uninitializedCount: 7, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeLeftParen?.raw
      layout[1] = leftParen.raw
      layout[2] = unexpectedBetweenLeftParenAndParameters?.raw
      layout[3] = parameters.raw
      layout[4] = unexpectedBetweenParametersAndRightParen?.raw
      layout[5] = rightParen.raw
      layout[6] = unexpectedAfterRightParen?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeLeftParen: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var leftParen: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenLeftParenAndParameters: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var parameters: RawEnumCaseParameterListSyntax {
    layoutView.children[3].map(RawEnumCaseParameterListSyntax.init(raw:))!
  }

  public var unexpectedBetweenParametersAndRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var rightParen: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawEnumCaseParameterListSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumCaseParameterList
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(elements: [RawEnumCaseParameterSyntax], arena: __shared RawSyntaxArena) {
    let raw = RawSyntax.makeLayout(
      kind: .enumCaseParameterList, uninitializedCount: elements.count, arena: arena) { layout in
        guard var ptr = layout.baseAddress else {
          return
        }
        for elem in elements {
          ptr.initialize(to: elem.raw)
          ptr += 1
        }
    }
    self.init(unchecked: raw)
  }

  public var elements: [RawEnumCaseParameterSyntax] {
    layoutView.children.map {
      RawEnumCaseParameterSyntax(raw: $0!)
    }
  }
}

@_spi(RawSyntax)
public struct RawEnumCaseParameterSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumCaseParameter
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndFirstName: RawUnexpectedNodesSyntax? = nil,
    firstName: RawTokenSyntax?,
    _ unexpectedBetweenFirstNameAndSecondName: RawUnexpectedNodesSyntax? = nil,
    secondName: RawTokenSyntax?,
    _ unexpectedBetweenSecondNameAndColon: RawUnexpectedNodesSyntax? = nil,
    colon: RawTokenSyntax?,
    _ unexpectedBetweenColonAndType: RawUnexpectedNodesSyntax? = nil,
    type: some RawTypeSyntaxNodeProtocol,
    _ unexpectedBetweenTypeAndDefaultValue: RawUnexpectedNodesSyntax? = nil,
    defaultValue: RawInitializerClauseSyntax?,
    _ unexpectedBetweenDefaultValueAndTrailingComma: RawUnexpectedNodesSyntax? = nil,
    trailingComma: RawTokenSyntax?,
    _ unexpectedAfterTrailingComma: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .enumCaseParameter, uninitializedCount: 15, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeModifiers?.raw
      layout[1] = modifiers.raw
      layout[2] = unexpectedBetweenModifiersAndFirstName?.raw
      layout[3] = firstName?.raw
      layout[4] = unexpectedBetweenFirstNameAndSecondName?.raw
      layout[5] = secondName?.raw
      layout[6] = unexpectedBetweenSecondNameAndColon?.raw
      layout[7] = colon?.raw
      layout[8] = unexpectedBetweenColonAndType?.raw
      layout[9] = type.raw
      layout[10] = unexpectedBetweenTypeAndDefaultValue?.raw
      layout[11] = defaultValue?.raw
      layout[12] = unexpectedBetweenDefaultValueAndTrailingComma?.raw
      layout[13] = trailingComma?.raw
      layout[14] = unexpectedAfterTrailingComma?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[1].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndFirstName: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var firstName: RawTokenSyntax? {
    layoutView.children[3].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenFirstNameAndSecondName: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var secondName: RawTokenSyntax? {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenSecondNameAndColon: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var colon: RawTokenSyntax? {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenColonAndType: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var type: RawTypeSyntax {
    layoutView.children[9].map(RawTypeSyntax.init(raw:))!
  }

  public var unexpectedBetweenTypeAndDefaultValue: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var defaultValue: RawInitializerClauseSyntax? {
    layoutView.children[11].map(RawInitializerClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenDefaultValueAndTrailingComma: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var trailingComma: RawTokenSyntax? {
    layoutView.children[13].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedAfterTrailingComma: RawUnexpectedNodesSyntax? {
    layoutView.children[14].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawEnumDeclSyntax: RawDeclSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .enumDecl
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? = nil,
    attributes: RawAttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndEnumKeyword: RawUnexpectedNodesSyntax? = nil,
    enumKeyword: RawTokenSyntax,
    _ unexpectedBetweenEnumKeywordAndName: RawUnexpectedNodesSyntax? = nil,
    name: RawTokenSyntax,
    _ unexpectedBetweenNameAndGenericParameterClause: RawUnexpectedNodesSyntax? = nil,
    genericParameterClause: RawGenericParameterClauseSyntax?,
    _ unexpectedBetweenGenericParameterClauseAndInheritanceClause: RawUnexpectedNodesSyntax? = nil,
    inheritanceClause: RawInheritanceClauseSyntax?,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: RawUnexpectedNodesSyntax? = nil,
    genericWhereClause: RawGenericWhereClauseSyntax?,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: RawUnexpectedNodesSyntax? = nil,
    memberBlock: RawMemberBlockSyntax,
    _ unexpectedAfterMemberBlock: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .enumDecl, uninitializedCount: 17, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAttributes?.raw
      layout[1] = attributes.raw
      layout[2] = unexpectedBetweenAttributesAndModifiers?.raw
      layout[3] = modifiers.raw
      layout[4] = unexpectedBetweenModifiersAndEnumKeyword?.raw
      layout[5] = enumKeyword.raw
      layout[6] = unexpectedBetweenEnumKeywordAndName?.raw
      layout[7] = name.raw
      layout[8] = unexpectedBetweenNameAndGenericParameterClause?.raw
      layout[9] = genericParameterClause?.raw
      layout[10] = unexpectedBetweenGenericParameterClauseAndInheritanceClause?.raw
      layout[11] = inheritanceClause?.raw
      layout[12] = unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw
      layout[13] = genericWhereClause?.raw
      layout[14] = unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw
      layout[15] = memberBlock.raw
      layout[16] = unexpectedAfterMemberBlock?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var attributes: RawAttributeListSyntax {
    layoutView.children[1].map(RawAttributeListSyntax.init(raw:))!
  }

  public var unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[3].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndEnumKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var enumKeyword: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenEnumKeywordAndName: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var name: RawTokenSyntax {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenNameAndGenericParameterClause: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var genericParameterClause: RawGenericParameterClauseSyntax? {
    layoutView.children[9].map(RawGenericParameterClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenGenericParameterClauseAndInheritanceClause: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var inheritanceClause: RawInheritanceClauseSyntax? {
    layoutView.children[11].map(RawInheritanceClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var genericWhereClause: RawGenericWhereClauseSyntax? {
    layoutView.children[13].map(RawGenericWhereClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: RawUnexpectedNodesSyntax? {
    layoutView.children[14].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var memberBlock: RawMemberBlockSyntax {
    layoutView.children[15].map(RawMemberBlockSyntax.init(raw:))!
  }

  public var unexpectedAfterMemberBlock: RawUnexpectedNodesSyntax? {
    layoutView.children[16].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawExprListSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .exprList
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(elements: [RawExprSyntax], arena: __shared RawSyntaxArena) {
    let raw = RawSyntax.makeLayout(
      kind: .exprList, uninitializedCount: elements.count, arena: arena) { layout in
        guard var ptr = layout.baseAddress else {
          return
        }
        for elem in elements {
          ptr.initialize(to: elem.raw)
          ptr += 1
        }
    }
    self.init(unchecked: raw)
  }

  public var elements: [RawExprSyntax] {
    layoutView.children.map {
      RawExprSyntax(raw: $0!)
    }
  }
}

@_spi(RawSyntax)
public struct RawExprSyntax: RawExprSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    switch raw.kind {
    case .arrayExpr, .arrowExpr, .asExpr, .assignmentExpr, .awaitExpr, .binaryOperatorExpr, .booleanLiteralExpr, .borrowExpr, ._canImportExpr, ._canImportVersionInfo, .closureExpr, .consumeExpr, .copyExpr, .declReferenceExpr, .dictionaryExpr, .discardAssignmentExpr, .doExpr, .editorPlaceholderExpr, .floatLiteralExpr, .forceUnwrapExpr, .functionCallExpr, .genericSpecializationExpr, .ifExpr, .inOutExpr, .infixOperatorExpr, .integerLiteralExpr, .isExpr, .keyPathExpr, .macroExpansionExpr, .memberAccessExpr, .missingExpr, .nilLiteralExpr, .optionalChainingExpr, .packElementExpr, .packExpansionExpr, .patternExpr, .postfixIfConfigExpr, .postfixOperatorExpr, .prefixOperatorExpr, .regexLiteralExpr, .sequenceExpr, .simpleStringLiteralExpr, .stringLiteralExpr, .subscriptCallExpr, .superExpr, .switchExpr, .ternaryExpr, .tryExpr, .tupleExpr, .typeExpr, .unresolvedAsExpr, .unresolvedIsExpr, .unresolvedTernaryExpr, .unsafeExpr:
      return true
    default:
      return false
    }
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(_ other: some RawExprSyntaxNodeProtocol) {
    self.init(unchecked: other.raw)
  }
}

@_spi(RawSyntax)
public struct RawExpressionPatternSyntax: RawPatternSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .expressionPattern
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeExpression: RawUnexpectedNodesSyntax? = nil,
    expression: some RawExprSyntaxNodeProtocol,
    _ unexpectedAfterExpression: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .expressionPattern, uninitializedCount: 3, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeExpression?.raw
      layout[1] = expression.raw
      layout[2] = unexpectedAfterExpression?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeExpression: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var expression: RawExprSyntax {
    layoutView.children[1].map(RawExprSyntax.init(raw:))!
  }

  public var unexpectedAfterExpression: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawExpressionSegmentSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .expressionSegment
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeBackslash: RawUnexpectedNodesSyntax? = nil,
    backslash: RawTokenSyntax,
    _ unexpectedBetweenBackslashAndPounds: RawUnexpectedNodesSyntax? = nil,
    pounds: RawTokenSyntax?,
    _ unexpectedBetweenPoundsAndLeftParen: RawUnexpectedNodesSyntax? = nil,
    leftParen: RawTokenSyntax,
    _ unexpectedBetweenLeftParenAndExpressions: RawUnexpectedNodesSyntax? = nil,
    expressions: RawLabeledExprListSyntax,
    _ unexpectedBetweenExpressionsAndRightParen: RawUnexpectedNodesSyntax? = nil,
    rightParen: RawTokenSyntax,
    _ unexpectedAfterRightParen: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .expressionSegment, uninitializedCount: 11, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeBackslash?.raw
      layout[1] = backslash.raw
      layout[2] = unexpectedBetweenBackslashAndPounds?.raw
      layout[3] = pounds?.raw
      layout[4] = unexpectedBetweenPoundsAndLeftParen?.raw
      layout[5] = leftParen.raw
      layout[6] = unexpectedBetweenLeftParenAndExpressions?.raw
      layout[7] = expressions.raw
      layout[8] = unexpectedBetweenExpressionsAndRightParen?.raw
      layout[9] = rightParen.raw
      layout[10] = unexpectedAfterRightParen?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeBackslash: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var backslash: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenBackslashAndPounds: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var pounds: RawTokenSyntax? {
    layoutView.children[3].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenPoundsAndLeftParen: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var leftParen: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenLeftParenAndExpressions: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var expressions: RawLabeledExprListSyntax {
    layoutView.children[7].map(RawLabeledExprListSyntax.init(raw:))!
  }

  public var unexpectedBetweenExpressionsAndRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var rightParen: RawTokenSyntax {
    layoutView.children[9].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawExpressionStmtSyntax: RawStmtSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .expressionStmt
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeExpression: RawUnexpectedNodesSyntax? = nil,
    expression: some RawExprSyntaxNodeProtocol,
    _ unexpectedAfterExpression: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .expressionStmt, uninitializedCount: 3, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeExpression?.raw
      layout[1] = expression.raw
      layout[2] = unexpectedAfterExpression?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeExpression: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var expression: RawExprSyntax {
    layoutView.children[1].map(RawExprSyntax.init(raw:))!
  }

  public var unexpectedAfterExpression: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawExtensionDeclSyntax: RawDeclSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .extensionDecl
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? = nil,
    attributes: RawAttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndExtensionKeyword: RawUnexpectedNodesSyntax? = nil,
    extensionKeyword: RawTokenSyntax,
    _ unexpectedBetweenExtensionKeywordAndExtendedType: RawUnexpectedNodesSyntax? = nil,
    extendedType: some RawTypeSyntaxNodeProtocol,
    _ unexpectedBetweenExtendedTypeAndInheritanceClause: RawUnexpectedNodesSyntax? = nil,
    inheritanceClause: RawInheritanceClauseSyntax?,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: RawUnexpectedNodesSyntax? = nil,
    genericWhereClause: RawGenericWhereClauseSyntax?,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: RawUnexpectedNodesSyntax? = nil,
    memberBlock: RawMemberBlockSyntax,
    _ unexpectedAfterMemberBlock: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .extensionDecl, uninitializedCount: 15, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAttributes?.raw
      layout[1] = attributes.raw
      layout[2] = unexpectedBetweenAttributesAndModifiers?.raw
      layout[3] = modifiers.raw
      layout[4] = unexpectedBetweenModifiersAndExtensionKeyword?.raw
      layout[5] = extensionKeyword.raw
      layout[6] = unexpectedBetweenExtensionKeywordAndExtendedType?.raw
      layout[7] = extendedType.raw
      layout[8] = unexpectedBetweenExtendedTypeAndInheritanceClause?.raw
      layout[9] = inheritanceClause?.raw
      layout[10] = unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw
      layout[11] = genericWhereClause?.raw
      layout[12] = unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw
      layout[13] = memberBlock.raw
      layout[14] = unexpectedAfterMemberBlock?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var attributes: RawAttributeListSyntax {
    layoutView.children[1].map(RawAttributeListSyntax.init(raw:))!
  }

  public var unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[3].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndExtensionKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var extensionKeyword: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenExtensionKeywordAndExtendedType: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var extendedType: RawTypeSyntax {
    layoutView.children[7].map(RawTypeSyntax.init(raw:))!
  }

  public var unexpectedBetweenExtendedTypeAndInheritanceClause: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var inheritanceClause: RawInheritanceClauseSyntax? {
    layoutView.children[9].map(RawInheritanceClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var genericWhereClause: RawGenericWhereClauseSyntax? {
    layoutView.children[11].map(RawGenericWhereClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var memberBlock: RawMemberBlockSyntax {
    layoutView.children[13].map(RawMemberBlockSyntax.init(raw:))!
  }

  public var unexpectedAfterMemberBlock: RawUnexpectedNodesSyntax? {
    layoutView.children[14].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFallThroughStmtSyntax: RawStmtSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .fallThroughStmt
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeFallthroughKeyword: RawUnexpectedNodesSyntax? = nil,
    fallthroughKeyword: RawTokenSyntax,
    _ unexpectedAfterFallthroughKeyword: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .fallThroughStmt, uninitializedCount: 3, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeFallthroughKeyword?.raw
      layout[1] = fallthroughKeyword.raw
      layout[2] = unexpectedAfterFallthroughKeyword?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeFallthroughKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var fallthroughKeyword: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterFallthroughKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFloatLiteralExprSyntax: RawExprSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .floatLiteralExpr
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeLiteral: RawUnexpectedNodesSyntax? = nil,
    literal: RawTokenSyntax,
    _ unexpectedAfterLiteral: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .floatLiteralExpr, uninitializedCount: 3, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeLiteral?.raw
      layout[1] = literal.raw
      layout[2] = unexpectedAfterLiteral?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeLiteral: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var literal: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterLiteral: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawForStmtSyntax: RawStmtSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .forStmt
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeForKeyword: RawUnexpectedNodesSyntax? = nil,
    forKeyword: RawTokenSyntax,
    _ unexpectedBetweenForKeywordAndTryKeyword: RawUnexpectedNodesSyntax? = nil,
    tryKeyword: RawTokenSyntax?,
    _ unexpectedBetweenTryKeywordAndAwaitKeyword: RawUnexpectedNodesSyntax? = nil,
    awaitKeyword: RawTokenSyntax?,
    _ unexpectedBetweenAwaitKeywordAndUnsafeKeyword: RawUnexpectedNodesSyntax? = nil,
    unsafeKeyword: RawTokenSyntax?,
    _ unexpectedBetweenUnsafeKeywordAndCaseKeyword: RawUnexpectedNodesSyntax? = nil,
    caseKeyword: RawTokenSyntax?,
    _ unexpectedBetweenCaseKeywordAndPattern: RawUnexpectedNodesSyntax? = nil,
    pattern: some RawPatternSyntaxNodeProtocol,
    _ unexpectedBetweenPatternAndTypeAnnotation: RawUnexpectedNodesSyntax? = nil,
    typeAnnotation: RawTypeAnnotationSyntax?,
    _ unexpectedBetweenTypeAnnotationAndInKeyword: RawUnexpectedNodesSyntax? = nil,
    inKeyword: RawTokenSyntax,
    _ unexpectedBetweenInKeywordAndSequence: RawUnexpectedNodesSyntax? = nil,
    sequence: some RawExprSyntaxNodeProtocol,
    _ unexpectedBetweenSequenceAndWhereClause: RawUnexpectedNodesSyntax? = nil,
    whereClause: RawWhereClauseSyntax?,
    _ unexpectedBetweenWhereClauseAndBody: RawUnexpectedNodesSyntax? = nil,
    body: RawCodeBlockSyntax,
    _ unexpectedAfterBody: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .forStmt, uninitializedCount: 23, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeForKeyword?.raw
      layout[1] = forKeyword.raw
      layout[2] = unexpectedBetweenForKeywordAndTryKeyword?.raw
      layout[3] = tryKeyword?.raw
      layout[4] = unexpectedBetweenTryKeywordAndAwaitKeyword?.raw
      layout[5] = awaitKeyword?.raw
      layout[6] = unexpectedBetweenAwaitKeywordAndUnsafeKeyword?.raw
      layout[7] = unsafeKeyword?.raw
      layout[8] = unexpectedBetweenUnsafeKeywordAndCaseKeyword?.raw
      layout[9] = caseKeyword?.raw
      layout[10] = unexpectedBetweenCaseKeywordAndPattern?.raw
      layout[11] = pattern.raw
      layout[12] = unexpectedBetweenPatternAndTypeAnnotation?.raw
      layout[13] = typeAnnotation?.raw
      layout[14] = unexpectedBetweenTypeAnnotationAndInKeyword?.raw
      layout[15] = inKeyword.raw
      layout[16] = unexpectedBetweenInKeywordAndSequence?.raw
      layout[17] = sequence.raw
      layout[18] = unexpectedBetweenSequenceAndWhereClause?.raw
      layout[19] = whereClause?.raw
      layout[20] = unexpectedBetweenWhereClauseAndBody?.raw
      layout[21] = body.raw
      layout[22] = unexpectedAfterBody?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeForKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var forKeyword: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenForKeywordAndTryKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var tryKeyword: RawTokenSyntax? {
    layoutView.children[3].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenTryKeywordAndAwaitKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var awaitKeyword: RawTokenSyntax? {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenAwaitKeywordAndUnsafeKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var unsafeKeyword: RawTokenSyntax? {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenUnsafeKeywordAndCaseKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var caseKeyword: RawTokenSyntax? {
    layoutView.children[9].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenCaseKeywordAndPattern: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var pattern: RawPatternSyntax {
    layoutView.children[11].map(RawPatternSyntax.init(raw:))!
  }

  public var unexpectedBetweenPatternAndTypeAnnotation: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var typeAnnotation: RawTypeAnnotationSyntax? {
    layoutView.children[13].map(RawTypeAnnotationSyntax.init(raw:))
  }

  public var unexpectedBetweenTypeAnnotationAndInKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[14].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var inKeyword: RawTokenSyntax {
    layoutView.children[15].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenInKeywordAndSequence: RawUnexpectedNodesSyntax? {
    layoutView.children[16].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var sequence: RawExprSyntax {
    layoutView.children[17].map(RawExprSyntax.init(raw:))!
  }

  public var unexpectedBetweenSequenceAndWhereClause: RawUnexpectedNodesSyntax? {
    layoutView.children[18].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var whereClause: RawWhereClauseSyntax? {
    layoutView.children[19].map(RawWhereClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenWhereClauseAndBody: RawUnexpectedNodesSyntax? {
    layoutView.children[20].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var body: RawCodeBlockSyntax {
    layoutView.children[21].map(RawCodeBlockSyntax.init(raw:))!
  }

  public var unexpectedAfterBody: RawUnexpectedNodesSyntax? {
    layoutView.children[22].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawForceUnwrapExprSyntax: RawExprSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .forceUnwrapExpr
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeExpression: RawUnexpectedNodesSyntax? = nil,
    expression: some RawExprSyntaxNodeProtocol,
    _ unexpectedBetweenExpressionAndExclamationMark: RawUnexpectedNodesSyntax? = nil,
    exclamationMark: RawTokenSyntax,
    _ unexpectedAfterExclamationMark: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .forceUnwrapExpr, uninitializedCount: 5, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeExpression?.raw
      layout[1] = expression.raw
      layout[2] = unexpectedBetweenExpressionAndExclamationMark?.raw
      layout[3] = exclamationMark.raw
      layout[4] = unexpectedAfterExclamationMark?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeExpression: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var expression: RawExprSyntax {
    layoutView.children[1].map(RawExprSyntax.init(raw:))!
  }

  public var unexpectedBetweenExpressionAndExclamationMark: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var exclamationMark: RawTokenSyntax {
    layoutView.children[3].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterExclamationMark: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionCallExprSyntax: RawExprSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionCallExpr
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeCalledExpression: RawUnexpectedNodesSyntax? = nil,
    calledExpression: some RawExprSyntaxNodeProtocol,
    _ unexpectedBetweenCalledExpressionAndLeftParen: RawUnexpectedNodesSyntax? = nil,
    leftParen: RawTokenSyntax?,
    _ unexpectedBetweenLeftParenAndArguments: RawUnexpectedNodesSyntax? = nil,
    arguments: RawLabeledExprListSyntax,
    _ unexpectedBetweenArgumentsAndRightParen: RawUnexpectedNodesSyntax? = nil,
    rightParen: RawTokenSyntax?,
    _ unexpectedBetweenRightParenAndTrailingClosure: RawUnexpectedNodesSyntax? = nil,
    trailingClosure: RawClosureExprSyntax?,
    _ unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: RawUnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: RawMultipleTrailingClosureElementListSyntax,
    _ unexpectedAfterAdditionalTrailingClosures: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionCallExpr, uninitializedCount: 13, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeCalledExpression?.raw
      layout[1] = calledExpression.raw
      layout[2] = unexpectedBetweenCalledExpressionAndLeftParen?.raw
      layout[3] = leftParen?.raw
      layout[4] = unexpectedBetweenLeftParenAndArguments?.raw
      layout[5] = arguments.raw
      layout[6] = unexpectedBetweenArgumentsAndRightParen?.raw
      layout[7] = rightParen?.raw
      layout[8] = unexpectedBetweenRightParenAndTrailingClosure?.raw
      layout[9] = trailingClosure?.raw
      layout[10] = unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures?.raw
      layout[11] = additionalTrailingClosures.raw
      layout[12] = unexpectedAfterAdditionalTrailingClosures?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeCalledExpression: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var calledExpression: RawExprSyntax {
    layoutView.children[1].map(RawExprSyntax.init(raw:))!
  }

  public var unexpectedBetweenCalledExpressionAndLeftParen: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var leftParen: RawTokenSyntax? {
    layoutView.children[3].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenLeftParenAndArguments: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var arguments: RawLabeledExprListSyntax {
    layoutView.children[5].map(RawLabeledExprListSyntax.init(raw:))!
  }

  public var unexpectedBetweenArgumentsAndRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var rightParen: RawTokenSyntax? {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenRightParenAndTrailingClosure: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var trailingClosure: RawClosureExprSyntax? {
    layoutView.children[9].map(RawClosureExprSyntax.init(raw:))
  }

  public var unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var additionalTrailingClosures: RawMultipleTrailingClosureElementListSyntax {
    layoutView.children[11].map(RawMultipleTrailingClosureElementListSyntax.init(raw:))!
  }

  public var unexpectedAfterAdditionalTrailingClosures: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionDeclSyntax: RawDeclSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionDecl
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? = nil,
    attributes: RawAttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndFuncKeyword: RawUnexpectedNodesSyntax? = nil,
    funcKeyword: RawTokenSyntax,
    _ unexpectedBetweenFuncKeywordAndName: RawUnexpectedNodesSyntax? = nil,
    name: RawTokenSyntax,
    _ unexpectedBetweenNameAndGenericParameterClause: RawUnexpectedNodesSyntax? = nil,
    genericParameterClause: RawGenericParameterClauseSyntax?,
    _ unexpectedBetweenGenericParameterClauseAndSignature: RawUnexpectedNodesSyntax? = nil,
    signature: RawFunctionSignatureSyntax,
    _ unexpectedBetweenSignatureAndGenericWhereClause: RawUnexpectedNodesSyntax? = nil,
    genericWhereClause: RawGenericWhereClauseSyntax?,
    _ unexpectedBetweenGenericWhereClauseAndBody: RawUnexpectedNodesSyntax? = nil,
    body: RawCodeBlockSyntax?,
    _ unexpectedAfterBody: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionDecl, uninitializedCount: 17, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAttributes?.raw
      layout[1] = attributes.raw
      layout[2] = unexpectedBetweenAttributesAndModifiers?.raw
      layout[3] = modifiers.raw
      layout[4] = unexpectedBetweenModifiersAndFuncKeyword?.raw
      layout[5] = funcKeyword.raw
      layout[6] = unexpectedBetweenFuncKeywordAndName?.raw
      layout[7] = name.raw
      layout[8] = unexpectedBetweenNameAndGenericParameterClause?.raw
      layout[9] = genericParameterClause?.raw
      layout[10] = unexpectedBetweenGenericParameterClauseAndSignature?.raw
      layout[11] = signature.raw
      layout[12] = unexpectedBetweenSignatureAndGenericWhereClause?.raw
      layout[13] = genericWhereClause?.raw
      layout[14] = unexpectedBetweenGenericWhereClauseAndBody?.raw
      layout[15] = body?.raw
      layout[16] = unexpectedAfterBody?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var attributes: RawAttributeListSyntax {
    layoutView.children[1].map(RawAttributeListSyntax.init(raw:))!
  }

  public var unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[3].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndFuncKeyword: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var funcKeyword: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenFuncKeywordAndName: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var name: RawTokenSyntax {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenNameAndGenericParameterClause: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var genericParameterClause: RawGenericParameterClauseSyntax? {
    layoutView.children[9].map(RawGenericParameterClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenGenericParameterClauseAndSignature: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var signature: RawFunctionSignatureSyntax {
    layoutView.children[11].map(RawFunctionSignatureSyntax.init(raw:))!
  }

  public var unexpectedBetweenSignatureAndGenericWhereClause: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var genericWhereClause: RawGenericWhereClauseSyntax? {
    layoutView.children[13].map(RawGenericWhereClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenGenericWhereClauseAndBody: RawUnexpectedNodesSyntax? {
    layoutView.children[14].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var body: RawCodeBlockSyntax? {
    layoutView.children[15].map(RawCodeBlockSyntax.init(raw:))
  }

  public var unexpectedAfterBody: RawUnexpectedNodesSyntax? {
    layoutView.children[16].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionEffectSpecifiersSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionEffectSpecifiers
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAsyncSpecifier: RawUnexpectedNodesSyntax? = nil,
    asyncSpecifier: RawTokenSyntax?,
    _ unexpectedBetweenAsyncSpecifierAndThrowsClause: RawUnexpectedNodesSyntax? = nil,
    throwsClause: RawThrowsClauseSyntax?,
    _ unexpectedAfterThrowsClause: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionEffectSpecifiers, uninitializedCount: 5, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAsyncSpecifier?.raw
      layout[1] = asyncSpecifier?.raw
      layout[2] = unexpectedBetweenAsyncSpecifierAndThrowsClause?.raw
      layout[3] = throwsClause?.raw
      layout[4] = unexpectedAfterThrowsClause?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAsyncSpecifier: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var asyncSpecifier: RawTokenSyntax? {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenAsyncSpecifierAndThrowsClause: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var throwsClause: RawThrowsClauseSyntax? {
    layoutView.children[3].map(RawThrowsClauseSyntax.init(raw:))
  }

  public var unexpectedAfterThrowsClause: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionParameterClauseSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionParameterClause
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeLeftParen: RawUnexpectedNodesSyntax? = nil,
    leftParen: RawTokenSyntax,
    _ unexpectedBetweenLeftParenAndParameters: RawUnexpectedNodesSyntax? = nil,
    parameters: RawFunctionParameterListSyntax,
    _ unexpectedBetweenParametersAndRightParen: RawUnexpectedNodesSyntax? = nil,
    rightParen: RawTokenSyntax,
    _ unexpectedAfterRightParen: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionParameterClause, uninitializedCount: 7, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeLeftParen?.raw
      layout[1] = leftParen.raw
      layout[2] = unexpectedBetweenLeftParenAndParameters?.raw
      layout[3] = parameters.raw
      layout[4] = unexpectedBetweenParametersAndRightParen?.raw
      layout[5] = rightParen.raw
      layout[6] = unexpectedAfterRightParen?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeLeftParen: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var leftParen: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenLeftParenAndParameters: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var parameters: RawFunctionParameterListSyntax {
    layoutView.children[3].map(RawFunctionParameterListSyntax.init(raw:))!
  }

  public var unexpectedBetweenParametersAndRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var rightParen: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedAfterRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionParameterListSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionParameterList
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(elements: [RawFunctionParameterSyntax], arena: __shared RawSyntaxArena) {
    let raw = RawSyntax.makeLayout(
      kind: .functionParameterList, uninitializedCount: elements.count, arena: arena) { layout in
        guard var ptr = layout.baseAddress else {
          return
        }
        for elem in elements {
          ptr.initialize(to: elem.raw)
          ptr += 1
        }
    }
    self.init(unchecked: raw)
  }

  public var elements: [RawFunctionParameterSyntax] {
    layoutView.children.map {
      RawFunctionParameterSyntax(raw: $0!)
    }
  }
}

@_spi(RawSyntax)
public struct RawFunctionParameterSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionParameter
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? = nil,
    attributes: RawAttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? = nil,
    modifiers: RawDeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndFirstName: RawUnexpectedNodesSyntax? = nil,
    firstName: RawTokenSyntax,
    _ unexpectedBetweenFirstNameAndSecondName: RawUnexpectedNodesSyntax? = nil,
    secondName: RawTokenSyntax?,
    _ unexpectedBetweenSecondNameAndColon: RawUnexpectedNodesSyntax? = nil,
    colon: RawTokenSyntax,
    _ unexpectedBetweenColonAndType: RawUnexpectedNodesSyntax? = nil,
    type: some RawTypeSyntaxNodeProtocol,
    _ unexpectedBetweenTypeAndEllipsis: RawUnexpectedNodesSyntax? = nil,
    ellipsis: RawTokenSyntax?,
    _ unexpectedBetweenEllipsisAndDefaultValue: RawUnexpectedNodesSyntax? = nil,
    defaultValue: RawInitializerClauseSyntax?,
    _ unexpectedBetweenDefaultValueAndTrailingComma: RawUnexpectedNodesSyntax? = nil,
    trailingComma: RawTokenSyntax?,
    _ unexpectedAfterTrailingComma: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionParameter, uninitializedCount: 19, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeAttributes?.raw
      layout[1] = attributes.raw
      layout[2] = unexpectedBetweenAttributesAndModifiers?.raw
      layout[3] = modifiers.raw
      layout[4] = unexpectedBetweenModifiersAndFirstName?.raw
      layout[5] = firstName.raw
      layout[6] = unexpectedBetweenFirstNameAndSecondName?.raw
      layout[7] = secondName?.raw
      layout[8] = unexpectedBetweenSecondNameAndColon?.raw
      layout[9] = colon.raw
      layout[10] = unexpectedBetweenColonAndType?.raw
      layout[11] = type.raw
      layout[12] = unexpectedBetweenTypeAndEllipsis?.raw
      layout[13] = ellipsis?.raw
      layout[14] = unexpectedBetweenEllipsisAndDefaultValue?.raw
      layout[15] = defaultValue?.raw
      layout[16] = unexpectedBetweenDefaultValueAndTrailingComma?.raw
      layout[17] = trailingComma?.raw
      layout[18] = unexpectedAfterTrailingComma?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeAttributes: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var attributes: RawAttributeListSyntax {
    layoutView.children[1].map(RawAttributeListSyntax.init(raw:))!
  }

  public var unexpectedBetweenAttributesAndModifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var modifiers: RawDeclModifierListSyntax {
    layoutView.children[3].map(RawDeclModifierListSyntax.init(raw:))!
  }

  public var unexpectedBetweenModifiersAndFirstName: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var firstName: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenFirstNameAndSecondName: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var secondName: RawTokenSyntax? {
    layoutView.children[7].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenSecondNameAndColon: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var colon: RawTokenSyntax {
    layoutView.children[9].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenColonAndType: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var type: RawTypeSyntax {
    layoutView.children[11].map(RawTypeSyntax.init(raw:))!
  }

  public var unexpectedBetweenTypeAndEllipsis: RawUnexpectedNodesSyntax? {
    layoutView.children[12].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var ellipsis: RawTokenSyntax? {
    layoutView.children[13].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedBetweenEllipsisAndDefaultValue: RawUnexpectedNodesSyntax? {
    layoutView.children[14].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var defaultValue: RawInitializerClauseSyntax? {
    layoutView.children[15].map(RawInitializerClauseSyntax.init(raw:))
  }

  public var unexpectedBetweenDefaultValueAndTrailingComma: RawUnexpectedNodesSyntax? {
    layoutView.children[16].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var trailingComma: RawTokenSyntax? {
    layoutView.children[17].map(RawTokenSyntax.init(raw:))
  }

  public var unexpectedAfterTrailingComma: RawUnexpectedNodesSyntax? {
    layoutView.children[18].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionSignatureSyntax: RawSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionSignature
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeParameterClause: RawUnexpectedNodesSyntax? = nil,
    parameterClause: RawFunctionParameterClauseSyntax,
    _ unexpectedBetweenParameterClauseAndEffectSpecifiers: RawUnexpectedNodesSyntax? = nil,
    effectSpecifiers: RawFunctionEffectSpecifiersSyntax?,
    _ unexpectedBetweenEffectSpecifiersAndReturnClause: RawUnexpectedNodesSyntax? = nil,
    returnClause: RawReturnClauseSyntax?,
    _ unexpectedAfterReturnClause: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionSignature, uninitializedCount: 7, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeParameterClause?.raw
      layout[1] = parameterClause.raw
      layout[2] = unexpectedBetweenParameterClauseAndEffectSpecifiers?.raw
      layout[3] = effectSpecifiers?.raw
      layout[4] = unexpectedBetweenEffectSpecifiersAndReturnClause?.raw
      layout[5] = returnClause?.raw
      layout[6] = unexpectedAfterReturnClause?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeParameterClause: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var parameterClause: RawFunctionParameterClauseSyntax {
    layoutView.children[1].map(RawFunctionParameterClauseSyntax.init(raw:))!
  }

  public var unexpectedBetweenParameterClauseAndEffectSpecifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var effectSpecifiers: RawFunctionEffectSpecifiersSyntax? {
    layoutView.children[3].map(RawFunctionEffectSpecifiersSyntax.init(raw:))
  }

  public var unexpectedBetweenEffectSpecifiersAndReturnClause: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var returnClause: RawReturnClauseSyntax? {
    layoutView.children[5].map(RawReturnClauseSyntax.init(raw:))
  }

  public var unexpectedAfterReturnClause: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}

@_spi(RawSyntax)
public struct RawFunctionTypeSyntax: RawTypeSyntaxNodeProtocol {
  @_spi(RawSyntax)
  public var layoutView: RawSyntaxLayoutView {
    return raw.layoutView!
  }

  public static func isKindOf(_ raw: RawSyntax) -> Bool {
    return raw.kind == .functionType
  }

  public var raw: RawSyntax

  init(raw: RawSyntax) {
    precondition(Self.isKindOf(raw))
    self.raw = raw
  }

  private init(unchecked raw: RawSyntax) {
    self.raw = raw
  }

  public init?(_ other: some RawSyntaxNodeProtocol) {
    guard Self.isKindOf(other.raw) else {
      return nil
    }
    self.init(unchecked: other.raw)
  }

  public init(
    _ unexpectedBeforeLeftParen: RawUnexpectedNodesSyntax? = nil,
    leftParen: RawTokenSyntax,
    _ unexpectedBetweenLeftParenAndParameters: RawUnexpectedNodesSyntax? = nil,
    parameters: RawTupleTypeElementListSyntax,
    _ unexpectedBetweenParametersAndRightParen: RawUnexpectedNodesSyntax? = nil,
    rightParen: RawTokenSyntax,
    _ unexpectedBetweenRightParenAndEffectSpecifiers: RawUnexpectedNodesSyntax? = nil,
    effectSpecifiers: RawTypeEffectSpecifiersSyntax?,
    _ unexpectedBetweenEffectSpecifiersAndReturnClause: RawUnexpectedNodesSyntax? = nil,
    returnClause: RawReturnClauseSyntax,
    _ unexpectedAfterReturnClause: RawUnexpectedNodesSyntax? = nil,
    arena: __shared RawSyntaxArena
  ) {
    let raw = RawSyntax.makeLayout(
      kind: .functionType, uninitializedCount: 11, arena: arena) { layout in
      layout.initialize(repeating: nil)
      layout[0] = unexpectedBeforeLeftParen?.raw
      layout[1] = leftParen.raw
      layout[2] = unexpectedBetweenLeftParenAndParameters?.raw
      layout[3] = parameters.raw
      layout[4] = unexpectedBetweenParametersAndRightParen?.raw
      layout[5] = rightParen.raw
      layout[6] = unexpectedBetweenRightParenAndEffectSpecifiers?.raw
      layout[7] = effectSpecifiers?.raw
      layout[8] = unexpectedBetweenEffectSpecifiersAndReturnClause?.raw
      layout[9] = returnClause.raw
      layout[10] = unexpectedAfterReturnClause?.raw
    }
    self.init(unchecked: raw)
  }

  public var unexpectedBeforeLeftParen: RawUnexpectedNodesSyntax? {
    layoutView.children[0].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var leftParen: RawTokenSyntax {
    layoutView.children[1].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenLeftParenAndParameters: RawUnexpectedNodesSyntax? {
    layoutView.children[2].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var parameters: RawTupleTypeElementListSyntax {
    layoutView.children[3].map(RawTupleTypeElementListSyntax.init(raw:))!
  }

  public var unexpectedBetweenParametersAndRightParen: RawUnexpectedNodesSyntax? {
    layoutView.children[4].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var rightParen: RawTokenSyntax {
    layoutView.children[5].map(RawTokenSyntax.init(raw:))!
  }

  public var unexpectedBetweenRightParenAndEffectSpecifiers: RawUnexpectedNodesSyntax? {
    layoutView.children[6].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var effectSpecifiers: RawTypeEffectSpecifiersSyntax? {
    layoutView.children[7].map(RawTypeEffectSpecifiersSyntax.init(raw:))
  }

  public var unexpectedBetweenEffectSpecifiersAndReturnClause: RawUnexpectedNodesSyntax? {
    layoutView.children[8].map(RawUnexpectedNodesSyntax.init(raw:))
  }

  public var returnClause: RawReturnClauseSyntax {
    layoutView.children[9].map(RawReturnClauseSyntax.init(raw:))!
  }

  public var unexpectedAfterReturnClause: RawUnexpectedNodesSyntax? {
    layoutView.children[10].map(RawUnexpectedNodesSyntax.init(raw:))
  }
}
