//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

//
// This file defines the SyntaxRewriter, a class that performs a standard walk
// and tree-rebuilding pattern.
//
// Subclassers of this class can override the walking behavior for any syntax
// node and transform nodes however they like.
//
//===----------------------------------------------------------------------===//

open class SyntaxRewriter {
  public let viewMode: SyntaxTreeViewMode

  /// The raw arena in which the parents of rewritten nodes should be allocated.
  /// 
  /// The `SyntaxRewriter` subclass is responsible for generating the rewritten nodes. To incorporate them into the
  /// tree, all of the rewritten node's parents also need to be re-created. This is the arena in which those 
  /// intermediate raw nodes should be allocated.
  private let rawArena: RawSyntaxArena?

  public init(viewMode: SyntaxTreeViewMode = .sourceAccurate) {
    self.viewMode = viewMode
    self.rawArena = nil
  }

  @_spi(RawSyntax)
  public init(viewMode: SyntaxTreeViewMode = .sourceAccurate, rawAllocationArena: RawSyntaxArena? = nil) {
    self.viewMode = viewMode
    self.rawArena = rawAllocationArena
  }

  /// Rewrite `node`, keeping its parent unless `detach` is `true`.
  public func rewrite(_ node: some SyntaxProtocol, detach: Bool = false) -> Syntax {
    let rewritten = self.visitImpl(Syntax(node))
    if detach {
      return rewritten
    }

    return withExtendedLifetime(rewritten) {
      return Syntax(node).replacingSelf(rewritten.raw, rawNodeArena: rewritten.raw.arenaReference.retained, rawAllocationArena: RawSyntaxArena())
    }
  }

  /// Visit any Syntax node.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @available(*, deprecated, renamed: "rewrite(_:detach:)")
  public func visit(_ node: Syntax) -> Syntax {
    return visitImpl(node)
  }

  public func visit<T: SyntaxChildChoices>(_ node: T) -> T {
    visitImpl(Syntax(node)).cast(T.self)
  }

  /// The function called before visiting the node and its descendants.
  ///   - node: the node we are about to visit.
  open func visitPre(_ node: Syntax) {
  }

  /// Override point to choose custom visitation dispatch instead of the
  /// specialized `visit(_:)` methods. Use this instead of those methods if
  /// you intend to dynamically dispatch rewriting behavior.
  /// - note: If this method returns a non-nil result, the subsequent
  ///         `visitAny(_:)` methods and the specialized `visit(_:)`
  ///         methods will not be called for this node and the
  ///         visited node will be replaced by the returned node in the
  ///         rewritten tree.
  ///         You can call the ``SyntaxRewriter/rewrite(_:detach:)``
  ///         method recursively when returning a non-nil result
  ///         if you want to visit the node's children anyway.
  open func visitAny(_ node: Syntax) -> Syntax? {
    return nil
  }

  /// The function called after visiting the node and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: Syntax) {
  }

  /// Visit a ``TokenSyntax``.
  ///   - Parameter token: the token that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ token: TokenSyntax) -> TokenSyntax {
    return token
  }

  /// Visit a ``ABIAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ABIAttributeArgumentsSyntax) -> ABIAttributeArgumentsSyntax {
    return ABIAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AccessorBlockFileSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(Compiler)
  open func visit(_ node: AccessorBlockFileSyntax) -> AccessorBlockFileSyntax {
    return AccessorBlockFileSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AccessorBlockSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AccessorBlockSyntax) -> AccessorBlockSyntax {
    return AccessorBlockSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AccessorDeclListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AccessorDeclListSyntax) -> AccessorDeclListSyntax {
    return AccessorDeclListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AccessorDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AccessorDeclSyntax) -> DeclSyntax {
    return DeclSyntax(AccessorDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``AccessorEffectSpecifiersSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AccessorEffectSpecifiersSyntax) -> AccessorEffectSpecifiersSyntax {
    return AccessorEffectSpecifiersSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AccessorParametersSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AccessorParametersSyntax) -> AccessorParametersSyntax {
    return AccessorParametersSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ActorDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ActorDeclSyntax) -> DeclSyntax {
    return DeclSyntax(ActorDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ArrayElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ArrayElementListSyntax) -> ArrayElementListSyntax {
    return ArrayElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ArrayElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ArrayElementSyntax) -> ArrayElementSyntax {
    return ArrayElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ArrayExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ArrayExprSyntax) -> ExprSyntax {
    return ExprSyntax(ArrayExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ArrayTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ArrayTypeSyntax) -> TypeSyntax {
    return TypeSyntax(ArrayTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ArrowExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ArrowExprSyntax) -> ExprSyntax {
    return ExprSyntax(ArrowExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``AsExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AsExprSyntax) -> ExprSyntax {
    return ExprSyntax(AsExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``AssignmentExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AssignmentExprSyntax) -> ExprSyntax {
    return ExprSyntax(AssignmentExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``AssociatedTypeDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AssociatedTypeDeclSyntax) -> DeclSyntax {
    return DeclSyntax(AssociatedTypeDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``AttributeClauseFileSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(Compiler)
  open func visit(_ node: AttributeClauseFileSyntax) -> AttributeClauseFileSyntax {
    return AttributeClauseFileSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AttributeListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AttributeListSyntax) -> AttributeListSyntax {
    return AttributeListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AttributeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AttributeSyntax) -> AttributeSyntax {
    return AttributeSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AttributedTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AttributedTypeSyntax) -> TypeSyntax {
    return TypeSyntax(AttributedTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``AvailabilityArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AvailabilityArgumentListSyntax) -> AvailabilityArgumentListSyntax {
    return AvailabilityArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AvailabilityArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AvailabilityArgumentSyntax) -> AvailabilityArgumentSyntax {
    return AvailabilityArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AvailabilityConditionSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AvailabilityConditionSyntax) -> AvailabilityConditionSyntax {
    return AvailabilityConditionSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AvailabilityLabeledArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AvailabilityLabeledArgumentSyntax) -> AvailabilityLabeledArgumentSyntax {
    return AvailabilityLabeledArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AvailabilityMacroDefinitionFileSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(Compiler)
  open func visit(_ node: AvailabilityMacroDefinitionFileSyntax) -> AvailabilityMacroDefinitionFileSyntax {
    return AvailabilityMacroDefinitionFileSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``AwaitExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: AwaitExprSyntax) -> ExprSyntax {
    return ExprSyntax(AwaitExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``BackDeployedAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: BackDeployedAttributeArgumentsSyntax) -> BackDeployedAttributeArgumentsSyntax {
    return BackDeployedAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``BinaryOperatorExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: BinaryOperatorExprSyntax) -> ExprSyntax {
    return ExprSyntax(BinaryOperatorExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``BooleanLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: BooleanLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(BooleanLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``BorrowExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: BorrowExprSyntax) -> ExprSyntax {
    return ExprSyntax(BorrowExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``BreakStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: BreakStmtSyntax) -> StmtSyntax {
    return StmtSyntax(BreakStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a `_CanImportExprSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: _CanImportExprSyntax) -> ExprSyntax {
    return ExprSyntax(_CanImportExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a `_CanImportVersionInfoSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: _CanImportVersionInfoSyntax) -> ExprSyntax {
    return ExprSyntax(_CanImportVersionInfoSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``CatchClauseListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CatchClauseListSyntax) -> CatchClauseListSyntax {
    return CatchClauseListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CatchClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CatchClauseSyntax) -> CatchClauseSyntax {
    return CatchClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CatchItemListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CatchItemListSyntax) -> CatchItemListSyntax {
    return CatchItemListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CatchItemSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CatchItemSyntax) -> CatchItemSyntax {
    return CatchItemSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClassDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClassDeclSyntax) -> DeclSyntax {
    return DeclSyntax(ClassDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ClassRestrictionTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClassRestrictionTypeSyntax) -> TypeSyntax {
    return TypeSyntax(ClassRestrictionTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ClosureCaptureClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureCaptureClauseSyntax) -> ClosureCaptureClauseSyntax {
    return ClosureCaptureClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureCaptureListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureCaptureListSyntax) -> ClosureCaptureListSyntax {
    return ClosureCaptureListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureCaptureSpecifierSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureCaptureSpecifierSyntax) -> ClosureCaptureSpecifierSyntax {
    return ClosureCaptureSpecifierSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureCaptureSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureCaptureSyntax) -> ClosureCaptureSyntax {
    return ClosureCaptureSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureExprSyntax) -> ExprSyntax {
    return ExprSyntax(ClosureExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ClosureParameterClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureParameterClauseSyntax) -> ClosureParameterClauseSyntax {
    return ClosureParameterClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureParameterListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureParameterListSyntax) -> ClosureParameterListSyntax {
    return ClosureParameterListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureParameterSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureParameterSyntax) -> ClosureParameterSyntax {
    return ClosureParameterSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureShorthandParameterListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureShorthandParameterListSyntax) -> ClosureShorthandParameterListSyntax {
    return ClosureShorthandParameterListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureShorthandParameterSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureShorthandParameterSyntax) -> ClosureShorthandParameterSyntax {
    return ClosureShorthandParameterSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ClosureSignatureSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ClosureSignatureSyntax) -> ClosureSignatureSyntax {
    return ClosureSignatureSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CodeBlockFileSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(Compiler)
  open func visit(_ node: CodeBlockFileSyntax) -> CodeBlockFileSyntax {
    return CodeBlockFileSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CodeBlockItemListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CodeBlockItemListSyntax) -> CodeBlockItemListSyntax {
    return CodeBlockItemListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CodeBlockItemSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CodeBlockItemSyntax) -> CodeBlockItemSyntax {
    return CodeBlockItemSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CodeBlockSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CodeBlockSyntax) -> CodeBlockSyntax {
    return CodeBlockSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CompositionTypeElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CompositionTypeElementListSyntax) -> CompositionTypeElementListSyntax {
    return CompositionTypeElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CompositionTypeElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CompositionTypeElementSyntax) -> CompositionTypeElementSyntax {
    return CompositionTypeElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``CompositionTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CompositionTypeSyntax) -> TypeSyntax {
    return TypeSyntax(CompositionTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ConditionElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ConditionElementListSyntax) -> ConditionElementListSyntax {
    return ConditionElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ConditionElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ConditionElementSyntax) -> ConditionElementSyntax {
    return ConditionElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ConformanceRequirementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ConformanceRequirementSyntax) -> ConformanceRequirementSyntax {
    return ConformanceRequirementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ConsumeExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ConsumeExprSyntax) -> ExprSyntax {
    return ExprSyntax(ConsumeExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ContinueStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ContinueStmtSyntax) -> StmtSyntax {
    return StmtSyntax(ContinueStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``CopyExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: CopyExprSyntax) -> ExprSyntax {
    return ExprSyntax(CopyExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DeclModifierDetailSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclModifierDetailSyntax) -> DeclModifierDetailSyntax {
    return DeclModifierDetailSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DeclModifierListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclModifierListSyntax) -> DeclModifierListSyntax {
    return DeclModifierListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DeclModifierSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclModifierSyntax) -> DeclModifierSyntax {
    return DeclModifierSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DeclNameArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclNameArgumentListSyntax) -> DeclNameArgumentListSyntax {
    return DeclNameArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DeclNameArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclNameArgumentSyntax) -> DeclNameArgumentSyntax {
    return DeclNameArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DeclNameArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclNameArgumentsSyntax) -> DeclNameArgumentsSyntax {
    return DeclNameArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DeclReferenceExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeclReferenceExprSyntax) -> ExprSyntax {
    return ExprSyntax(DeclReferenceExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DeferStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeferStmtSyntax) -> StmtSyntax {
    return StmtSyntax(DeferStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DeinitializerDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeinitializerDeclSyntax) -> DeclSyntax {
    return DeclSyntax(DeinitializerDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DeinitializerEffectSpecifiersSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DeinitializerEffectSpecifiersSyntax) -> DeinitializerEffectSpecifiersSyntax {
    return DeinitializerEffectSpecifiersSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DerivativeAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DerivativeAttributeArgumentsSyntax) -> DerivativeAttributeArgumentsSyntax {
    return DerivativeAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DesignatedTypeListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DesignatedTypeListSyntax) -> DesignatedTypeListSyntax {
    return DesignatedTypeListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DesignatedTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DesignatedTypeSyntax) -> DesignatedTypeSyntax {
    return DesignatedTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DictionaryElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DictionaryElementListSyntax) -> DictionaryElementListSyntax {
    return DictionaryElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DictionaryElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DictionaryElementSyntax) -> DictionaryElementSyntax {
    return DictionaryElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DictionaryExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DictionaryExprSyntax) -> ExprSyntax {
    return ExprSyntax(DictionaryExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DictionaryTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DictionaryTypeSyntax) -> TypeSyntax {
    return TypeSyntax(DictionaryTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DifferentiabilityArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DifferentiabilityArgumentListSyntax) -> DifferentiabilityArgumentListSyntax {
    return DifferentiabilityArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DifferentiabilityArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DifferentiabilityArgumentSyntax) -> DifferentiabilityArgumentSyntax {
    return DifferentiabilityArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DifferentiabilityArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DifferentiabilityArgumentsSyntax) -> DifferentiabilityArgumentsSyntax {
    return DifferentiabilityArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DifferentiabilityWithRespectToArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DifferentiabilityWithRespectToArgumentSyntax) -> DifferentiabilityWithRespectToArgumentSyntax {
    return DifferentiabilityWithRespectToArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DifferentiableAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DifferentiableAttributeArgumentsSyntax) -> DifferentiableAttributeArgumentsSyntax {
    return DifferentiableAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DiscardAssignmentExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DiscardAssignmentExprSyntax) -> ExprSyntax {
    return ExprSyntax(DiscardAssignmentExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DiscardStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DiscardStmtSyntax) -> StmtSyntax {
    return StmtSyntax(DiscardStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a `DoExprSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: DoExprSyntax) -> ExprSyntax {
    return ExprSyntax(DoExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DoStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DoStmtSyntax) -> StmtSyntax {
    return StmtSyntax(DoStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``DocumentationAttributeArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DocumentationAttributeArgumentListSyntax) -> DocumentationAttributeArgumentListSyntax {
    return DocumentationAttributeArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DocumentationAttributeArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DocumentationAttributeArgumentSyntax) -> DocumentationAttributeArgumentSyntax {
    return DocumentationAttributeArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``DynamicReplacementAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: DynamicReplacementAttributeArgumentsSyntax) -> DynamicReplacementAttributeArgumentsSyntax {
    return DynamicReplacementAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EditorPlaceholderDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EditorPlaceholderDeclSyntax) -> DeclSyntax {
    return DeclSyntax(EditorPlaceholderDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``EditorPlaceholderExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EditorPlaceholderExprSyntax) -> ExprSyntax {
    return ExprSyntax(EditorPlaceholderExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``EffectsAttributeArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EffectsAttributeArgumentListSyntax) -> EffectsAttributeArgumentListSyntax {
    return EffectsAttributeArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EnumCaseDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumCaseDeclSyntax) -> DeclSyntax {
    return DeclSyntax(EnumCaseDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``EnumCaseElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumCaseElementListSyntax) -> EnumCaseElementListSyntax {
    return EnumCaseElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EnumCaseElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumCaseElementSyntax) -> EnumCaseElementSyntax {
    return EnumCaseElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EnumCaseParameterClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumCaseParameterClauseSyntax) -> EnumCaseParameterClauseSyntax {
    return EnumCaseParameterClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EnumCaseParameterListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumCaseParameterListSyntax) -> EnumCaseParameterListSyntax {
    return EnumCaseParameterListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EnumCaseParameterSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumCaseParameterSyntax) -> EnumCaseParameterSyntax {
    return EnumCaseParameterSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``EnumDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: EnumDeclSyntax) -> DeclSyntax {
    return DeclSyntax(EnumDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ExprListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ExprListSyntax) -> ExprListSyntax {
    return ExprListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ExpressionPatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ExpressionPatternSyntax) -> PatternSyntax {
    return PatternSyntax(ExpressionPatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ExpressionSegmentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ExpressionSegmentSyntax) -> ExpressionSegmentSyntax {
    return ExpressionSegmentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ExpressionStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ExpressionStmtSyntax) -> StmtSyntax {
    return StmtSyntax(ExpressionStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ExtensionDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ExtensionDeclSyntax) -> DeclSyntax {
    return DeclSyntax(ExtensionDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``FallThroughStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FallThroughStmtSyntax) -> StmtSyntax {
    return StmtSyntax(FallThroughStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``FloatLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FloatLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(FloatLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ForStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ForStmtSyntax) -> StmtSyntax {
    return StmtSyntax(ForStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ForceUnwrapExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ForceUnwrapExprSyntax) -> ExprSyntax {
    return ExprSyntax(ForceUnwrapExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``FunctionCallExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionCallExprSyntax) -> ExprSyntax {
    return ExprSyntax(FunctionCallExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``FunctionDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionDeclSyntax) -> DeclSyntax {
    return DeclSyntax(FunctionDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``FunctionEffectSpecifiersSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionEffectSpecifiersSyntax) -> FunctionEffectSpecifiersSyntax {
    return FunctionEffectSpecifiersSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``FunctionParameterClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionParameterClauseSyntax) -> FunctionParameterClauseSyntax {
    return FunctionParameterClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``FunctionParameterListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionParameterListSyntax) -> FunctionParameterListSyntax {
    return FunctionParameterListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``FunctionParameterSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionParameterSyntax) -> FunctionParameterSyntax {
    return FunctionParameterSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``FunctionSignatureSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionSignatureSyntax) -> FunctionSignatureSyntax {
    return FunctionSignatureSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``FunctionTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: FunctionTypeSyntax) -> TypeSyntax {
    return TypeSyntax(FunctionTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``GenericArgumentClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericArgumentClauseSyntax) -> GenericArgumentClauseSyntax {
    return GenericArgumentClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericArgumentListSyntax) -> GenericArgumentListSyntax {
    return GenericArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericArgumentSyntax) -> GenericArgumentSyntax {
    return GenericArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericParameterClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericParameterClauseSyntax) -> GenericParameterClauseSyntax {
    return GenericParameterClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericParameterListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericParameterListSyntax) -> GenericParameterListSyntax {
    return GenericParameterListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericParameterSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericParameterSyntax) -> GenericParameterSyntax {
    return GenericParameterSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericRequirementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericRequirementListSyntax) -> GenericRequirementListSyntax {
    return GenericRequirementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericRequirementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericRequirementSyntax) -> GenericRequirementSyntax {
    return GenericRequirementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GenericSpecializationExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericSpecializationExprSyntax) -> ExprSyntax {
    return ExprSyntax(GenericSpecializationExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``GenericWhereClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GenericWhereClauseSyntax) -> GenericWhereClauseSyntax {
    return GenericWhereClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``GuardStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: GuardStmtSyntax) -> StmtSyntax {
    return StmtSyntax(GuardStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IdentifierPatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IdentifierPatternSyntax) -> PatternSyntax {
    return PatternSyntax(IdentifierPatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IdentifierTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IdentifierTypeSyntax) -> TypeSyntax {
    return TypeSyntax(IdentifierTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IfConfigClauseListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IfConfigClauseListSyntax) -> IfConfigClauseListSyntax {
    return IfConfigClauseListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``IfConfigClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IfConfigClauseSyntax) -> IfConfigClauseSyntax {
    return IfConfigClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``IfConfigDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IfConfigDeclSyntax) -> DeclSyntax {
    return DeclSyntax(IfConfigDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IfExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IfExprSyntax) -> ExprSyntax {
    return ExprSyntax(IfExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ImplementsAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ImplementsAttributeArgumentsSyntax) -> ImplementsAttributeArgumentsSyntax {
    return ImplementsAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ImplicitlyUnwrappedOptionalTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ImplicitlyUnwrappedOptionalTypeSyntax) -> TypeSyntax {
    return TypeSyntax(ImplicitlyUnwrappedOptionalTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ImportDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ImportDeclSyntax) -> DeclSyntax {
    return DeclSyntax(ImportDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ImportPathComponentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ImportPathComponentListSyntax) -> ImportPathComponentListSyntax {
    return ImportPathComponentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ImportPathComponentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ImportPathComponentSyntax) -> ImportPathComponentSyntax {
    return ImportPathComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``InOutExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InOutExprSyntax) -> ExprSyntax {
    return ExprSyntax(InOutExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``InfixOperatorExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InfixOperatorExprSyntax) -> ExprSyntax {
    return ExprSyntax(InfixOperatorExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``InheritanceClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InheritanceClauseSyntax) -> InheritanceClauseSyntax {
    return InheritanceClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``InheritedTypeListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InheritedTypeListSyntax) -> InheritedTypeListSyntax {
    return InheritedTypeListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``InheritedTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InheritedTypeSyntax) -> InheritedTypeSyntax {
    return InheritedTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``InitializerClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InitializerClauseSyntax) -> InitializerClauseSyntax {
    return InitializerClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``InitializerDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InitializerDeclSyntax) -> DeclSyntax {
    return DeclSyntax(InitializerDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``InlineArrayTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: InlineArrayTypeSyntax) -> TypeSyntax {
    return TypeSyntax(InlineArrayTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IntegerLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IntegerLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(IntegerLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IsExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IsExprSyntax) -> ExprSyntax {
    return ExprSyntax(IsExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``IsTypePatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: IsTypePatternSyntax) -> PatternSyntax {
    return PatternSyntax(IsTypePatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``KeyPathComponentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: KeyPathComponentListSyntax) -> KeyPathComponentListSyntax {
    return KeyPathComponentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``KeyPathComponentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: KeyPathComponentSyntax) -> KeyPathComponentSyntax {
    return KeyPathComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``KeyPathExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: KeyPathExprSyntax) -> ExprSyntax {
    return ExprSyntax(KeyPathExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a `KeyPathMethodComponentSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: KeyPathMethodComponentSyntax) -> KeyPathMethodComponentSyntax {
    return KeyPathMethodComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``KeyPathOptionalComponentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: KeyPathOptionalComponentSyntax) -> KeyPathOptionalComponentSyntax {
    return KeyPathOptionalComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``KeyPathPropertyComponentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: KeyPathPropertyComponentSyntax) -> KeyPathPropertyComponentSyntax {
    return KeyPathPropertyComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``KeyPathSubscriptComponentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: KeyPathSubscriptComponentSyntax) -> KeyPathSubscriptComponentSyntax {
    return KeyPathSubscriptComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``LabeledExprListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: LabeledExprListSyntax) -> LabeledExprListSyntax {
    return LabeledExprListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``LabeledExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: LabeledExprSyntax) -> LabeledExprSyntax {
    return LabeledExprSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``LabeledSpecializeArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: LabeledSpecializeArgumentSyntax) -> LabeledSpecializeArgumentSyntax {
    return LabeledSpecializeArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``LabeledStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: LabeledStmtSyntax) -> StmtSyntax {
    return StmtSyntax(LabeledStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``LayoutRequirementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: LayoutRequirementSyntax) -> LayoutRequirementSyntax {
    return LayoutRequirementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a `LifetimeSpecifierArgumentListSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: LifetimeSpecifierArgumentListSyntax) -> LifetimeSpecifierArgumentListSyntax {
    return LifetimeSpecifierArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a `LifetimeSpecifierArgumentSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: LifetimeSpecifierArgumentSyntax) -> LifetimeSpecifierArgumentSyntax {
    return LifetimeSpecifierArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a `LifetimeTypeSpecifierSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: LifetimeTypeSpecifierSyntax) -> LifetimeTypeSpecifierSyntax {
    return LifetimeTypeSpecifierSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MacroDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MacroDeclSyntax) -> DeclSyntax {
    return DeclSyntax(MacroDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MacroExpansionDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MacroExpansionDeclSyntax) -> DeclSyntax {
    return DeclSyntax(MacroExpansionDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MacroExpansionExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MacroExpansionExprSyntax) -> ExprSyntax {
    return ExprSyntax(MacroExpansionExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MatchingPatternConditionSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MatchingPatternConditionSyntax) -> MatchingPatternConditionSyntax {
    return MatchingPatternConditionSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MemberAccessExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MemberAccessExprSyntax) -> ExprSyntax {
    return ExprSyntax(MemberAccessExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MemberBlockItemListFileSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(Compiler)
  open func visit(_ node: MemberBlockItemListFileSyntax) -> MemberBlockItemListFileSyntax {
    return MemberBlockItemListFileSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MemberBlockItemListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MemberBlockItemListSyntax) -> MemberBlockItemListSyntax {
    return MemberBlockItemListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MemberBlockItemSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MemberBlockItemSyntax) -> MemberBlockItemSyntax {
    return MemberBlockItemSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MemberBlockSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MemberBlockSyntax) -> MemberBlockSyntax {
    return MemberBlockSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MemberTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MemberTypeSyntax) -> TypeSyntax {
    return TypeSyntax(MemberTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MetatypeTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MetatypeTypeSyntax) -> TypeSyntax {
    return TypeSyntax(MetatypeTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MissingDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MissingDeclSyntax) -> DeclSyntax {
    return DeclSyntax(MissingDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MissingExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MissingExprSyntax) -> ExprSyntax {
    return ExprSyntax(MissingExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MissingPatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MissingPatternSyntax) -> PatternSyntax {
    return PatternSyntax(MissingPatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MissingStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MissingStmtSyntax) -> StmtSyntax {
    return StmtSyntax(MissingStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MissingSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MissingSyntax) -> Syntax {
    return Syntax(MissingSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MissingTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MissingTypeSyntax) -> TypeSyntax {
    return TypeSyntax(MissingTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``MultipleTrailingClosureElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MultipleTrailingClosureElementListSyntax) -> MultipleTrailingClosureElementListSyntax {
    return MultipleTrailingClosureElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``MultipleTrailingClosureElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: MultipleTrailingClosureElementSyntax) -> MultipleTrailingClosureElementSyntax {
    return MultipleTrailingClosureElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``NamedOpaqueReturnTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: NamedOpaqueReturnTypeSyntax) -> TypeSyntax {
    return TypeSyntax(NamedOpaqueReturnTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``NilLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: NilLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(NilLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``NonisolatedSpecifierArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: NonisolatedSpecifierArgumentSyntax) -> NonisolatedSpecifierArgumentSyntax {
    return NonisolatedSpecifierArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``NonisolatedTypeSpecifierSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: NonisolatedTypeSpecifierSyntax) -> NonisolatedTypeSpecifierSyntax {
    return NonisolatedTypeSpecifierSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ObjCSelectorPieceListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ObjCSelectorPieceListSyntax) -> ObjCSelectorPieceListSyntax {
    return ObjCSelectorPieceListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ObjCSelectorPieceSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ObjCSelectorPieceSyntax) -> ObjCSelectorPieceSyntax {
    return ObjCSelectorPieceSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``OperatorDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: OperatorDeclSyntax) -> DeclSyntax {
    return DeclSyntax(OperatorDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``OperatorPrecedenceAndTypesSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: OperatorPrecedenceAndTypesSyntax) -> OperatorPrecedenceAndTypesSyntax {
    return OperatorPrecedenceAndTypesSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``OptionalBindingConditionSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: OptionalBindingConditionSyntax) -> OptionalBindingConditionSyntax {
    return OptionalBindingConditionSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``OptionalChainingExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: OptionalChainingExprSyntax) -> ExprSyntax {
    return ExprSyntax(OptionalChainingExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``OptionalTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: OptionalTypeSyntax) -> TypeSyntax {
    return TypeSyntax(OptionalTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``OriginallyDefinedInAttributeArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: OriginallyDefinedInAttributeArgumentsSyntax) -> OriginallyDefinedInAttributeArgumentsSyntax {
    return OriginallyDefinedInAttributeArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PackElementExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PackElementExprSyntax) -> ExprSyntax {
    return ExprSyntax(PackElementExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PackElementTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PackElementTypeSyntax) -> TypeSyntax {
    return TypeSyntax(PackElementTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PackExpansionExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PackExpansionExprSyntax) -> ExprSyntax {
    return ExprSyntax(PackExpansionExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PackExpansionTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PackExpansionTypeSyntax) -> TypeSyntax {
    return TypeSyntax(PackExpansionTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PatternBindingListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PatternBindingListSyntax) -> PatternBindingListSyntax {
    return PatternBindingListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PatternBindingSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PatternBindingSyntax) -> PatternBindingSyntax {
    return PatternBindingSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PatternExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PatternExprSyntax) -> ExprSyntax {
    return ExprSyntax(PatternExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PlatformVersionItemListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PlatformVersionItemListSyntax) -> PlatformVersionItemListSyntax {
    return PlatformVersionItemListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PlatformVersionItemSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PlatformVersionItemSyntax) -> PlatformVersionItemSyntax {
    return PlatformVersionItemSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PlatformVersionSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PlatformVersionSyntax) -> PlatformVersionSyntax {
    return PlatformVersionSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PostfixIfConfigExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PostfixIfConfigExprSyntax) -> ExprSyntax {
    return ExprSyntax(PostfixIfConfigExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PostfixOperatorExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PostfixOperatorExprSyntax) -> ExprSyntax {
    return ExprSyntax(PostfixOperatorExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PoundSourceLocationArgumentsSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PoundSourceLocationArgumentsSyntax) -> PoundSourceLocationArgumentsSyntax {
    return PoundSourceLocationArgumentsSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PoundSourceLocationSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PoundSourceLocationSyntax) -> DeclSyntax {
    return DeclSyntax(PoundSourceLocationSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PrecedenceGroupAssignmentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupAssignmentSyntax) -> PrecedenceGroupAssignmentSyntax {
    return PrecedenceGroupAssignmentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrecedenceGroupAssociativitySyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupAssociativitySyntax) -> PrecedenceGroupAssociativitySyntax {
    return PrecedenceGroupAssociativitySyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrecedenceGroupAttributeListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupAttributeListSyntax) -> PrecedenceGroupAttributeListSyntax {
    return PrecedenceGroupAttributeListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrecedenceGroupDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupDeclSyntax) -> DeclSyntax {
    return DeclSyntax(PrecedenceGroupDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PrecedenceGroupNameListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupNameListSyntax) -> PrecedenceGroupNameListSyntax {
    return PrecedenceGroupNameListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrecedenceGroupNameSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupNameSyntax) -> PrecedenceGroupNameSyntax {
    return PrecedenceGroupNameSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrecedenceGroupRelationSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrecedenceGroupRelationSyntax) -> PrecedenceGroupRelationSyntax {
    return PrecedenceGroupRelationSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrefixOperatorExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrefixOperatorExprSyntax) -> ExprSyntax {
    return ExprSyntax(PrefixOperatorExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``PrimaryAssociatedTypeClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrimaryAssociatedTypeClauseSyntax) -> PrimaryAssociatedTypeClauseSyntax {
    return PrimaryAssociatedTypeClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrimaryAssociatedTypeListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrimaryAssociatedTypeListSyntax) -> PrimaryAssociatedTypeListSyntax {
    return PrimaryAssociatedTypeListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``PrimaryAssociatedTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: PrimaryAssociatedTypeSyntax) -> PrimaryAssociatedTypeSyntax {
    return PrimaryAssociatedTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ProtocolDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ProtocolDeclSyntax) -> DeclSyntax {
    return DeclSyntax(ProtocolDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``RegexLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: RegexLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(RegexLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``RepeatStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: RepeatStmtSyntax) -> StmtSyntax {
    return StmtSyntax(RepeatStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ReturnClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ReturnClauseSyntax) -> ReturnClauseSyntax {
    return ReturnClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``ReturnStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ReturnStmtSyntax) -> StmtSyntax {
    return StmtSyntax(ReturnStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SameTypeRequirementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SameTypeRequirementSyntax) -> SameTypeRequirementSyntax {
    return SameTypeRequirementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SequenceExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SequenceExprSyntax) -> ExprSyntax {
    return ExprSyntax(SequenceExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SimpleStringLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SimpleStringLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(SimpleStringLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SimpleStringLiteralSegmentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SimpleStringLiteralSegmentListSyntax) -> SimpleStringLiteralSegmentListSyntax {
    return SimpleStringLiteralSegmentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SimpleTypeSpecifierSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SimpleTypeSpecifierSyntax) -> SimpleTypeSpecifierSyntax {
    return SimpleTypeSpecifierSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SomeOrAnyTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SomeOrAnyTypeSyntax) -> TypeSyntax {
    return TypeSyntax(SomeOrAnyTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SourceFileSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SourceFileSyntax) -> SourceFileSyntax {
    return SourceFileSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SpecializeAttributeArgumentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SpecializeAttributeArgumentListSyntax) -> SpecializeAttributeArgumentListSyntax {
    return SpecializeAttributeArgumentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SpecializeAvailabilityArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SpecializeAvailabilityArgumentSyntax) -> SpecializeAvailabilityArgumentSyntax {
    return SpecializeAvailabilityArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SpecializeTargetFunctionArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SpecializeTargetFunctionArgumentSyntax) -> SpecializeTargetFunctionArgumentSyntax {
    return SpecializeTargetFunctionArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SpecializedAttributeArgumentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SpecializedAttributeArgumentSyntax) -> SpecializedAttributeArgumentSyntax {
    return SpecializedAttributeArgumentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``StringLiteralExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: StringLiteralExprSyntax) -> ExprSyntax {
    return ExprSyntax(StringLiteralExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``StringLiteralSegmentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: StringLiteralSegmentListSyntax) -> StringLiteralSegmentListSyntax {
    return StringLiteralSegmentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``StringSegmentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: StringSegmentSyntax) -> StringSegmentSyntax {
    return StringSegmentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``StructDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: StructDeclSyntax) -> DeclSyntax {
    return DeclSyntax(StructDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SubscriptCallExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SubscriptCallExprSyntax) -> ExprSyntax {
    return ExprSyntax(SubscriptCallExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SubscriptDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SubscriptDeclSyntax) -> DeclSyntax {
    return DeclSyntax(SubscriptDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SuperExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SuperExprSyntax) -> ExprSyntax {
    return ExprSyntax(SuperExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SuppressedTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SuppressedTypeSyntax) -> TypeSyntax {
    return TypeSyntax(SuppressedTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``SwitchCaseItemListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchCaseItemListSyntax) -> SwitchCaseItemListSyntax {
    return SwitchCaseItemListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SwitchCaseItemSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchCaseItemSyntax) -> SwitchCaseItemSyntax {
    return SwitchCaseItemSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SwitchCaseLabelSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchCaseLabelSyntax) -> SwitchCaseLabelSyntax {
    return SwitchCaseLabelSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SwitchCaseListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchCaseListSyntax) -> SwitchCaseListSyntax {
    return SwitchCaseListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SwitchCaseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchCaseSyntax) -> SwitchCaseSyntax {
    return SwitchCaseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SwitchDefaultLabelSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchDefaultLabelSyntax) -> SwitchDefaultLabelSyntax {
    return SwitchDefaultLabelSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``SwitchExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: SwitchExprSyntax) -> ExprSyntax {
    return ExprSyntax(SwitchExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TernaryExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TernaryExprSyntax) -> ExprSyntax {
    return ExprSyntax(TernaryExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a `ThenStmtSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: ThenStmtSyntax) -> StmtSyntax {
    return StmtSyntax(ThenStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ThrowStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ThrowStmtSyntax) -> StmtSyntax {
    return StmtSyntax(ThrowStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ThrowsClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ThrowsClauseSyntax) -> ThrowsClauseSyntax {
    return ThrowsClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TryExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TryExprSyntax) -> ExprSyntax {
    return ExprSyntax(TryExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TupleExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TupleExprSyntax) -> ExprSyntax {
    return ExprSyntax(TupleExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TuplePatternElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TuplePatternElementListSyntax) -> TuplePatternElementListSyntax {
    return TuplePatternElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TuplePatternElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TuplePatternElementSyntax) -> TuplePatternElementSyntax {
    return TuplePatternElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TuplePatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TuplePatternSyntax) -> PatternSyntax {
    return PatternSyntax(TuplePatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TupleTypeElementListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TupleTypeElementListSyntax) -> TupleTypeElementListSyntax {
    return TupleTypeElementListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TupleTypeElementSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TupleTypeElementSyntax) -> TupleTypeElementSyntax {
    return TupleTypeElementSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TupleTypeSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TupleTypeSyntax) -> TypeSyntax {
    return TypeSyntax(TupleTypeSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TypeAliasDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TypeAliasDeclSyntax) -> DeclSyntax {
    return DeclSyntax(TypeAliasDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TypeAnnotationSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TypeAnnotationSyntax) -> TypeAnnotationSyntax {
    return TypeAnnotationSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TypeEffectSpecifiersSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TypeEffectSpecifiersSyntax) -> TypeEffectSpecifiersSyntax {
    return TypeEffectSpecifiersSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TypeExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TypeExprSyntax) -> ExprSyntax {
    return ExprSyntax(TypeExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``TypeInitializerClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TypeInitializerClauseSyntax) -> TypeInitializerClauseSyntax {
    return TypeInitializerClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``TypeSpecifierListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: TypeSpecifierListSyntax) -> TypeSpecifierListSyntax {
    return TypeSpecifierListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``UnexpectedNodesSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: UnexpectedNodesSyntax) -> UnexpectedNodesSyntax {
    return UnexpectedNodesSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``UnresolvedAsExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: UnresolvedAsExprSyntax) -> ExprSyntax {
    return ExprSyntax(UnresolvedAsExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``UnresolvedIsExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: UnresolvedIsExprSyntax) -> ExprSyntax {
    return ExprSyntax(UnresolvedIsExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``UnresolvedTernaryExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: UnresolvedTernaryExprSyntax) -> ExprSyntax {
    return ExprSyntax(UnresolvedTernaryExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``UnsafeExprSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: UnsafeExprSyntax) -> ExprSyntax {
    return ExprSyntax(UnsafeExprSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a `UsingDeclSyntax`.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: UsingDeclSyntax) -> DeclSyntax {
    return DeclSyntax(UsingDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``ValueBindingPatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: ValueBindingPatternSyntax) -> PatternSyntax {
    return PatternSyntax(ValueBindingPatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``VariableDeclSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: VariableDeclSyntax) -> DeclSyntax {
    return DeclSyntax(VariableDeclSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``VersionComponentListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: VersionComponentListSyntax) -> VersionComponentListSyntax {
    return VersionComponentListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``VersionComponentSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: VersionComponentSyntax) -> VersionComponentSyntax {
    return VersionComponentSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``VersionTupleSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: VersionTupleSyntax) -> VersionTupleSyntax {
    return VersionTupleSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``WhereClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: WhereClauseSyntax) -> WhereClauseSyntax {
    return WhereClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``WhileStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: WhileStmtSyntax) -> StmtSyntax {
    return StmtSyntax(WhileStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``WildcardPatternSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: WildcardPatternSyntax) -> PatternSyntax {
    return PatternSyntax(WildcardPatternSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``YieldStmtSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: YieldStmtSyntax) -> StmtSyntax {
    return StmtSyntax(YieldStmtSyntax(unsafeCasting: visitChildren(node._syntaxNode)))
  }

  /// Visit a ``YieldedExpressionListSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: YieldedExpressionListSyntax) -> YieldedExpressionListSyntax {
    return YieldedExpressionListSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``YieldedExpressionSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: YieldedExpressionSyntax) -> YieldedExpressionSyntax {
    return YieldedExpressionSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit a ``YieldedExpressionsClauseSyntax``.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  open func visit(_ node: YieldedExpressionsClauseSyntax) -> YieldedExpressionsClauseSyntax {
    return YieldedExpressionsClauseSyntax(unsafeCasting: visitChildren(node._syntaxNode))
  }

  /// Visit any DeclSyntax node.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  public func visit(_ node: DeclSyntax) -> DeclSyntax {
    visitImpl(Syntax(node)).cast(DeclSyntax.self)
  }

  /// Visit any ExprSyntax node.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  public func visit(_ node: ExprSyntax) -> ExprSyntax {
    visitImpl(Syntax(node)).cast(ExprSyntax.self)
  }

  /// Visit any PatternSyntax node.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  public func visit(_ node: PatternSyntax) -> PatternSyntax {
    visitImpl(Syntax(node)).cast(PatternSyntax.self)
  }

  /// Visit any StmtSyntax node.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  public func visit(_ node: StmtSyntax) -> StmtSyntax {
    visitImpl(Syntax(node)).cast(StmtSyntax.self)
  }

  /// Visit any TypeSyntax node.
  ///   - Parameter node: the node that is being visited
  ///   - Returns: the rewritten node
  public func visit(_ node: TypeSyntax) -> TypeSyntax {
    visitImpl(Syntax(node)).cast(TypeSyntax.self)
  }

  @inline(never)
  private func visitTokenSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TokenSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitABIAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ABIAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAccessorBlockFileSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AccessorBlockFileSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAccessorBlockSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AccessorBlockSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAccessorDeclListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AccessorDeclListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAccessorDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AccessorDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAccessorEffectSpecifiersSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AccessorEffectSpecifiersSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAccessorParametersSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AccessorParametersSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitActorDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ActorDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitArrayElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ArrayElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitArrayElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ArrayElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitArrayExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ArrayExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitArrayTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ArrayTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitArrowExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ArrowExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAsExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AsExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAssignmentExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AssignmentExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAssociatedTypeDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AssociatedTypeDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAttributeClauseFileSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AttributeClauseFileSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAttributeListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AttributeListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAttributeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AttributeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAttributedTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AttributedTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAvailabilityArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AvailabilityArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAvailabilityArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AvailabilityArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAvailabilityConditionSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AvailabilityConditionSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAvailabilityLabeledArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AvailabilityLabeledArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAvailabilityMacroDefinitionFileSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AvailabilityMacroDefinitionFileSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitAwaitExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(AwaitExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitBackDeployedAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(BackDeployedAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitBinaryOperatorExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(BinaryOperatorExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitBooleanLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(BooleanLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitBorrowExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(BorrowExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitBreakStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(BreakStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visit_CanImportExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(_CanImportExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visit_CanImportVersionInfoSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(_CanImportVersionInfoSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCatchClauseListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CatchClauseListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCatchClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CatchClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCatchItemListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CatchItemListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCatchItemSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CatchItemSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClassDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClassDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClassRestrictionTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClassRestrictionTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureCaptureClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureCaptureClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureCaptureListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureCaptureListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureCaptureSpecifierSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureCaptureSpecifierSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureCaptureSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureCaptureSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureParameterClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureParameterClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureParameterListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureParameterListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureParameterSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureParameterSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureShorthandParameterListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureShorthandParameterListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureShorthandParameterSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureShorthandParameterSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitClosureSignatureSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ClosureSignatureSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCodeBlockFileSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CodeBlockFileSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCodeBlockItemListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CodeBlockItemListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCodeBlockItemSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CodeBlockItemSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCodeBlockSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CodeBlockSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCompositionTypeElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CompositionTypeElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCompositionTypeElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CompositionTypeElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCompositionTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CompositionTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitConditionElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ConditionElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitConditionElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ConditionElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitConformanceRequirementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ConformanceRequirementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitConsumeExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ConsumeExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitContinueStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ContinueStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitCopyExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(CopyExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclModifierDetailSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclModifierDetailSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclModifierListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclModifierListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclModifierSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclModifierSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclNameArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclNameArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclNameArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclNameArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclNameArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclNameArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeclReferenceExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeclReferenceExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeferStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeferStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeinitializerDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeinitializerDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDeinitializerEffectSpecifiersSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DeinitializerEffectSpecifiersSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDerivativeAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DerivativeAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDesignatedTypeListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DesignatedTypeListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDesignatedTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DesignatedTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDictionaryElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DictionaryElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDictionaryElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DictionaryElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDictionaryExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DictionaryExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDictionaryTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DictionaryTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDifferentiabilityArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DifferentiabilityArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDifferentiabilityArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DifferentiabilityArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDifferentiabilityArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DifferentiabilityArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDifferentiabilityWithRespectToArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DifferentiabilityWithRespectToArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDifferentiableAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DifferentiableAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDiscardAssignmentExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DiscardAssignmentExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDiscardStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DiscardStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDoExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DoExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDoStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DoStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDocumentationAttributeArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DocumentationAttributeArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDocumentationAttributeArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DocumentationAttributeArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitDynamicReplacementAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(DynamicReplacementAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEditorPlaceholderDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EditorPlaceholderDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEditorPlaceholderExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EditorPlaceholderExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEffectsAttributeArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EffectsAttributeArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumCaseDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumCaseDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumCaseElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumCaseElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumCaseElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumCaseElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumCaseParameterClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumCaseParameterClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumCaseParameterListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumCaseParameterListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumCaseParameterSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumCaseParameterSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitEnumDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(EnumDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitExprListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ExprListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitExpressionPatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ExpressionPatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitExpressionSegmentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ExpressionSegmentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitExpressionStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ExpressionStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitExtensionDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ExtensionDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFallThroughStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FallThroughStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFloatLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FloatLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitForStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ForStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitForceUnwrapExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ForceUnwrapExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionCallExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionCallExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionEffectSpecifiersSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionEffectSpecifiersSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionParameterClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionParameterClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionParameterListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionParameterListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionParameterSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionParameterSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionSignatureSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionSignatureSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitFunctionTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(FunctionTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericArgumentClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericArgumentClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericParameterClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericParameterClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericParameterListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericParameterListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericParameterSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericParameterSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericRequirementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericRequirementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericRequirementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericRequirementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericSpecializationExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericSpecializationExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGenericWhereClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GenericWhereClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitGuardStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(GuardStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIdentifierPatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IdentifierPatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIdentifierTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IdentifierTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIfConfigClauseListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IfConfigClauseListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIfConfigClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IfConfigClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIfConfigDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IfConfigDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIfExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IfExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitImplementsAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ImplementsAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitImplicitlyUnwrappedOptionalTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ImplicitlyUnwrappedOptionalTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitImportDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ImportDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitImportPathComponentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ImportPathComponentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitImportPathComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ImportPathComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInOutExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InOutExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInfixOperatorExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InfixOperatorExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInheritanceClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InheritanceClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInheritedTypeListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InheritedTypeListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInheritedTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InheritedTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInitializerClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InitializerClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInitializerDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InitializerDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitInlineArrayTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(InlineArrayTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIntegerLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IntegerLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIsExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IsExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitIsTypePatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(IsTypePatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathComponentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathComponentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathMethodComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathMethodComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathOptionalComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathOptionalComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathPropertyComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathPropertyComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitKeyPathSubscriptComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(KeyPathSubscriptComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLabeledExprListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LabeledExprListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLabeledExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LabeledExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLabeledSpecializeArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LabeledSpecializeArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLabeledStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LabeledStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLayoutRequirementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LayoutRequirementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLifetimeSpecifierArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LifetimeSpecifierArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLifetimeSpecifierArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LifetimeSpecifierArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitLifetimeTypeSpecifierSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(LifetimeTypeSpecifierSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMacroDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MacroDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMacroExpansionDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MacroExpansionDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMacroExpansionExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MacroExpansionExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMatchingPatternConditionSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MatchingPatternConditionSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMemberAccessExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MemberAccessExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMemberBlockItemListFileSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MemberBlockItemListFileSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMemberBlockItemListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MemberBlockItemListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMemberBlockItemSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MemberBlockItemSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMemberBlockSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MemberBlockSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMemberTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MemberTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMetatypeTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MetatypeTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMissingDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MissingDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMissingExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MissingExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMissingPatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MissingPatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMissingStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MissingStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMissingSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MissingSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMissingTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MissingTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMultipleTrailingClosureElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MultipleTrailingClosureElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitMultipleTrailingClosureElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(MultipleTrailingClosureElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitNamedOpaqueReturnTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(NamedOpaqueReturnTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitNilLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(NilLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitNonisolatedSpecifierArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(NonisolatedSpecifierArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitNonisolatedTypeSpecifierSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(NonisolatedTypeSpecifierSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitObjCSelectorPieceListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ObjCSelectorPieceListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitObjCSelectorPieceSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ObjCSelectorPieceSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitOperatorDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(OperatorDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitOperatorPrecedenceAndTypesSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(OperatorPrecedenceAndTypesSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitOptionalBindingConditionSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(OptionalBindingConditionSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitOptionalChainingExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(OptionalChainingExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitOptionalTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(OptionalTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitOriginallyDefinedInAttributeArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(OriginallyDefinedInAttributeArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPackElementExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PackElementExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPackElementTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PackElementTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPackExpansionExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PackExpansionExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPackExpansionTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PackExpansionTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPatternBindingListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PatternBindingListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPatternBindingSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PatternBindingSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPatternExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PatternExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPlatformVersionItemListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PlatformVersionItemListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPlatformVersionItemSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PlatformVersionItemSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPlatformVersionSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PlatformVersionSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPostfixIfConfigExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PostfixIfConfigExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPostfixOperatorExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PostfixOperatorExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPoundSourceLocationArgumentsSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PoundSourceLocationArgumentsSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPoundSourceLocationSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PoundSourceLocationSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupAssignmentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupAssignmentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupAssociativitySyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupAssociativitySyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupAttributeListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupAttributeListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupNameListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupNameListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupNameSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupNameSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrecedenceGroupRelationSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrecedenceGroupRelationSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrefixOperatorExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrefixOperatorExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrimaryAssociatedTypeClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrimaryAssociatedTypeClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrimaryAssociatedTypeListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrimaryAssociatedTypeListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitPrimaryAssociatedTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(PrimaryAssociatedTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitProtocolDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ProtocolDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitRegexLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(RegexLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitRepeatStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(RepeatStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitReturnClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ReturnClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitReturnStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ReturnStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSameTypeRequirementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SameTypeRequirementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSequenceExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SequenceExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSimpleStringLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SimpleStringLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSimpleStringLiteralSegmentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SimpleStringLiteralSegmentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSimpleTypeSpecifierSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SimpleTypeSpecifierSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSomeOrAnyTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SomeOrAnyTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSourceFileSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SourceFileSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSpecializeAttributeArgumentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SpecializeAttributeArgumentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSpecializeAvailabilityArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SpecializeAvailabilityArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSpecializeTargetFunctionArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SpecializeTargetFunctionArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSpecializedAttributeArgumentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SpecializedAttributeArgumentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitStringLiteralExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(StringLiteralExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitStringLiteralSegmentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(StringLiteralSegmentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitStringSegmentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(StringSegmentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitStructDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(StructDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSubscriptCallExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SubscriptCallExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSubscriptDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SubscriptDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSuperExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SuperExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSuppressedTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SuppressedTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchCaseItemListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchCaseItemListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchCaseItemSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchCaseItemSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchCaseLabelSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchCaseLabelSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchCaseListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchCaseListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchCaseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchCaseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchDefaultLabelSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchDefaultLabelSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitSwitchExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(SwitchExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTernaryExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TernaryExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitThenStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ThenStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitThrowStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ThrowStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitThrowsClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ThrowsClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTryExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TryExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTupleExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TupleExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTuplePatternElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TuplePatternElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTuplePatternElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TuplePatternElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTuplePatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TuplePatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTupleTypeElementListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TupleTypeElementListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTupleTypeElementSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TupleTypeElementSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTupleTypeSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TupleTypeSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTypeAliasDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TypeAliasDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTypeAnnotationSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TypeAnnotationSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTypeEffectSpecifiersSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TypeEffectSpecifiersSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTypeExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TypeExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTypeInitializerClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TypeInitializerClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitTypeSpecifierListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(TypeSpecifierListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitUnexpectedNodesSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(UnexpectedNodesSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitUnresolvedAsExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(UnresolvedAsExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitUnresolvedIsExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(UnresolvedIsExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitUnresolvedTernaryExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(UnresolvedTernaryExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitUnsafeExprSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(UnsafeExprSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitUsingDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(UsingDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitValueBindingPatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(ValueBindingPatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitVariableDeclSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(VariableDeclSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitVersionComponentListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(VersionComponentListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitVersionComponentSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(VersionComponentSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitVersionTupleSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(VersionTupleSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitWhereClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(WhereClauseSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitWhileStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(WhileStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitWildcardPatternSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(WildcardPatternSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitYieldStmtSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(YieldStmtSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitYieldedExpressionListSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(YieldedExpressionListSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitYieldedExpressionSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(YieldedExpressionSyntax(unsafeCasting: node)))
  }

  @inline(never)
  private func visitYieldedExpressionsClauseSyntaxImpl(_ node: Syntax) -> Syntax {
    Syntax(visit(YieldedExpressionsClauseSyntax(unsafeCasting: node)))
  }

  // SwiftSyntax requires a lot of stack space in debug builds for syntax tree
  // rewriting. In scenarios with reduced stack space (in particular dispatch
  // queues), this easily results in a stack overflow. To work around this issue,
  // use a less performant but also less stack-hungry version of SwiftSyntax's
  // SyntaxRewriter in debug builds.
  #if DEBUG
  /// Implementation detail of visit(_:). Do not call directly.
  ///
  /// Returns the function that shall be called to visit a specific syntax node.
  ///
  /// To determine the correct specific visitation function for a syntax node,
  /// we need to switch through a huge switch statement that covers all syntax
  /// types. In debug builds, the cases of this switch statement do not share
  /// stack space (rdar://55929175). Because of this, the switch statement
  /// requires about 15KB of stack space. In scenarios with reduced
  /// stack size (in particular dispatch queues), this often results in a stack
  /// overflow during syntax tree rewriting.
  ///
  /// To circumvent this problem, make calling the specific visitation function
  /// a two-step process: First determine the function to call in this function
  /// and return a reference to it, then call it. This way, the stack frame
  /// that determines the correct visitation function will be popped of the
  /// stack before the function is being called, making the switch's stack
  /// space transient instead of having it linger in the call stack.
  private func visitationFunc(for node: Syntax) -> (Syntax) -> Syntax {
    switch node.raw.kind {
    case .token:
      return self.visitTokenSyntaxImpl(_:)
    case .abiAttributeArguments:
      return self.visitABIAttributeArgumentsSyntaxImpl(_:)
    case .accessorBlockFile:
      return self.visitAccessorBlockFileSyntaxImpl(_:)
    case .accessorBlock:
      return self.visitAccessorBlockSyntaxImpl(_:)
    case .accessorDeclList:
      return self.visitAccessorDeclListSyntaxImpl(_:)
    case .accessorDecl:
      return self.visitAccessorDeclSyntaxImpl(_:)
    case .accessorEffectSpecifiers:
      return self.visitAccessorEffectSpecifiersSyntaxImpl(_:)
    case .accessorParameters:
      return self.visitAccessorParametersSyntaxImpl(_:)
    case .actorDecl:
      return self.visitActorDeclSyntaxImpl(_:)
    case .arrayElementList:
      return self.visitArrayElementListSyntaxImpl(_:)
    case .arrayElement:
      return self.visitArrayElementSyntaxImpl(_:)
    case .arrayExpr:
      return self.visitArrayExprSyntaxImpl(_:)
    case .arrayType:
      return self.visitArrayTypeSyntaxImpl(_:)
    case .arrowExpr:
      return self.visitArrowExprSyntaxImpl(_:)
    case .asExpr:
      return self.visitAsExprSyntaxImpl(_:)
    case .assignmentExpr:
      return self.visitAssignmentExprSyntaxImpl(_:)
    case .associatedTypeDecl:
      return self.visitAssociatedTypeDeclSyntaxImpl(_:)
    case .attributeClauseFile:
      return self.visitAttributeClauseFileSyntaxImpl(_:)
    case .attributeList:
      return self.visitAttributeListSyntaxImpl(_:)
    case .attribute:
      return self.visitAttributeSyntaxImpl(_:)
    case .attributedType:
      return self.visitAttributedTypeSyntaxImpl(_:)
    case .availabilityArgumentList:
      return self.visitAvailabilityArgumentListSyntaxImpl(_:)
    case .availabilityArgument:
      return self.visitAvailabilityArgumentSyntaxImpl(_:)
    case .availabilityCondition:
      return self.visitAvailabilityConditionSyntaxImpl(_:)
    case .availabilityLabeledArgument:
      return self.visitAvailabilityLabeledArgumentSyntaxImpl(_:)
    case .availabilityMacroDefinitionFile:
      return self.visitAvailabilityMacroDefinitionFileSyntaxImpl(_:)
    case .awaitExpr:
      return self.visitAwaitExprSyntaxImpl(_:)
    case .backDeployedAttributeArguments:
      return self.visitBackDeployedAttributeArgumentsSyntaxImpl(_:)
    case .binaryOperatorExpr:
      return self.visitBinaryOperatorExprSyntaxImpl(_:)
    case .booleanLiteralExpr:
      return self.visitBooleanLiteralExprSyntaxImpl(_:)
    case .borrowExpr:
      return self.visitBorrowExprSyntaxImpl(_:)
    case .breakStmt:
      return self.visitBreakStmtSyntaxImpl(_:)
    case ._canImportExpr:
      return self.visit_CanImportExprSyntaxImpl(_:)
    case ._canImportVersionInfo:
      return self.visit_CanImportVersionInfoSyntaxImpl(_:)
    case .catchClauseList:
      return self.visitCatchClauseListSyntaxImpl(_:)
    case .catchClause:
      return self.visitCatchClauseSyntaxImpl(_:)
    case .catchItemList:
      return self.visitCatchItemListSyntaxImpl(_:)
    case .catchItem:
      return self.visitCatchItemSyntaxImpl(_:)
    case .classDecl:
      return self.visitClassDeclSyntaxImpl(_:)
    case .classRestrictionType:
      return self.visitClassRestrictionTypeSyntaxImpl(_:)
    case .closureCaptureClause:
      return self.visitClosureCaptureClauseSyntaxImpl(_:)
    case .closureCaptureList:
      return self.visitClosureCaptureListSyntaxImpl(_:)
    case .closureCaptureSpecifier:
      return self.visitClosureCaptureSpecifierSyntaxImpl(_:)
    case .closureCapture:
      return self.visitClosureCaptureSyntaxImpl(_:)
    case .closureExpr:
      return self.visitClosureExprSyntaxImpl(_:)
    case .closureParameterClause:
      return self.visitClosureParameterClauseSyntaxImpl(_:)
    case .closureParameterList:
      return self.visitClosureParameterListSyntaxImpl(_:)
    case .closureParameter:
      return self.visitClosureParameterSyntaxImpl(_:)
    case .closureShorthandParameterList:
      return self.visitClosureShorthandParameterListSyntaxImpl(_:)
    case .closureShorthandParameter:
      return self.visitClosureShorthandParameterSyntaxImpl(_:)
    case .closureSignature:
      return self.visitClosureSignatureSyntaxImpl(_:)
    case .codeBlockFile:
      return self.visitCodeBlockFileSyntaxImpl(_:)
    case .codeBlockItemList:
      return self.visitCodeBlockItemListSyntaxImpl(_:)
    case .codeBlockItem:
      return self.visitCodeBlockItemSyntaxImpl(_:)
    case .codeBlock:
      return self.visitCodeBlockSyntaxImpl(_:)
    case .compositionTypeElementList:
      return self.visitCompositionTypeElementListSyntaxImpl(_:)
    case .compositionTypeElement:
      return self.visitCompositionTypeElementSyntaxImpl(_:)
    case .compositionType:
      return self.visitCompositionTypeSyntaxImpl(_:)
    case .conditionElementList:
      return self.visitConditionElementListSyntaxImpl(_:)
    case .conditionElement:
      return self.visitConditionElementSyntaxImpl(_:)
    case .conformanceRequirement:
      return self.visitConformanceRequirementSyntaxImpl(_:)
    case .consumeExpr:
      return self.visitConsumeExprSyntaxImpl(_:)
    case .continueStmt:
      return self.visitContinueStmtSyntaxImpl(_:)
    case .copyExpr:
      return self.visitCopyExprSyntaxImpl(_:)
    case .declModifierDetail:
      return self.visitDeclModifierDetailSyntaxImpl(_:)
    case .declModifierList:
      return self.visitDeclModifierListSyntaxImpl(_:)
    case .declModifier:
      return self.visitDeclModifierSyntaxImpl(_:)
    case .declNameArgumentList:
      return self.visitDeclNameArgumentListSyntaxImpl(_:)
    case .declNameArgument:
      return self.visitDeclNameArgumentSyntaxImpl(_:)
    case .declNameArguments:
      return self.visitDeclNameArgumentsSyntaxImpl(_:)
    case .declReferenceExpr:
      return self.visitDeclReferenceExprSyntaxImpl(_:)
    case .deferStmt:
      return self.visitDeferStmtSyntaxImpl(_:)
    case .deinitializerDecl:
      return self.visitDeinitializerDeclSyntaxImpl(_:)
    case .deinitializerEffectSpecifiers:
      return self.visitDeinitializerEffectSpecifiersSyntaxImpl(_:)
    case .derivativeAttributeArguments:
      return self.visitDerivativeAttributeArgumentsSyntaxImpl(_:)
    case .designatedTypeList:
      return self.visitDesignatedTypeListSyntaxImpl(_:)
    case .designatedType:
      return self.visitDesignatedTypeSyntaxImpl(_:)
    case .dictionaryElementList:
      return self.visitDictionaryElementListSyntaxImpl(_:)
    case .dictionaryElement:
      return self.visitDictionaryElementSyntaxImpl(_:)
    case .dictionaryExpr:
      return self.visitDictionaryExprSyntaxImpl(_:)
    case .dictionaryType:
      return self.visitDictionaryTypeSyntaxImpl(_:)
    case .differentiabilityArgumentList:
      return self.visitDifferentiabilityArgumentListSyntaxImpl(_:)
    case .differentiabilityArgument:
      return self.visitDifferentiabilityArgumentSyntaxImpl(_:)
    case .differentiabilityArguments:
      return self.visitDifferentiabilityArgumentsSyntaxImpl(_:)
    case .differentiabilityWithRespectToArgument:
      return self.visitDifferentiabilityWithRespectToArgumentSyntaxImpl(_:)
    case .differentiableAttributeArguments:
      return self.visitDifferentiableAttributeArgumentsSyntaxImpl(_:)
    case .discardAssignmentExpr:
      return self.visitDiscardAssignmentExprSyntaxImpl(_:)
    case .discardStmt:
      return self.visitDiscardStmtSyntaxImpl(_:)
    case .doExpr:
      return self.visitDoExprSyntaxImpl(_:)
    case .doStmt:
      return self.visitDoStmtSyntaxImpl(_:)
    case .documentationAttributeArgumentList:
      return self.visitDocumentationAttributeArgumentListSyntaxImpl(_:)
    case .documentationAttributeArgument:
      return self.visitDocumentationAttributeArgumentSyntaxImpl(_:)
    case .dynamicReplacementAttributeArguments:
      return self.visitDynamicReplacementAttributeArgumentsSyntaxImpl(_:)
    case .editorPlaceholderDecl:
      return self.visitEditorPlaceholderDeclSyntaxImpl(_:)
    case .editorPlaceholderExpr:
      return self.visitEditorPlaceholderExprSyntaxImpl(_:)
    case .effectsAttributeArgumentList:
      return self.visitEffectsAttributeArgumentListSyntaxImpl(_:)
    case .enumCaseDecl:
      return self.visitEnumCaseDeclSyntaxImpl(_:)
    case .enumCaseElementList:
      return self.visitEnumCaseElementListSyntaxImpl(_:)
    case .enumCaseElement:
      return self.visitEnumCaseElementSyntaxImpl(_:)
    case .enumCaseParameterClause:
      return self.visitEnumCaseParameterClauseSyntaxImpl(_:)
    case .enumCaseParameterList:
      return self.visitEnumCaseParameterListSyntaxImpl(_:)
    case .enumCaseParameter:
      return self.visitEnumCaseParameterSyntaxImpl(_:)
    case .enumDecl:
      return self.visitEnumDeclSyntaxImpl(_:)
    case .exprList:
      return self.visitExprListSyntaxImpl(_:)
    case .expressionPattern:
      return self.visitExpressionPatternSyntaxImpl(_:)
    case .expressionSegment:
      return self.visitExpressionSegmentSyntaxImpl(_:)
    case .expressionStmt:
      return self.visitExpressionStmtSyntaxImpl(_:)
    case .extensionDecl:
      return self.visitExtensionDeclSyntaxImpl(_:)
    case .fallThroughStmt:
      return self.visitFallThroughStmtSyntaxImpl(_:)
    case .floatLiteralExpr:
      return self.visitFloatLiteralExprSyntaxImpl(_:)
    case .forStmt:
      return self.visitForStmtSyntaxImpl(_:)
    case .forceUnwrapExpr:
      return self.visitForceUnwrapExprSyntaxImpl(_:)
    case .functionCallExpr:
      return self.visitFunctionCallExprSyntaxImpl(_:)
    case .functionDecl:
      return self.visitFunctionDeclSyntaxImpl(_:)
    case .functionEffectSpecifiers:
      return self.visitFunctionEffectSpecifiersSyntaxImpl(_:)
    case .functionParameterClause:
      return self.visitFunctionParameterClauseSyntaxImpl(_:)
    case .functionParameterList:
      return self.visitFunctionParameterListSyntaxImpl(_:)
    case .functionParameter:
      return self.visitFunctionParameterSyntaxImpl(_:)
    case .functionSignature:
      return self.visitFunctionSignatureSyntaxImpl(_:)
    case .functionType:
      return self.visitFunctionTypeSyntaxImpl(_:)
    case .genericArgumentClause:
      return self.visitGenericArgumentClauseSyntaxImpl(_:)
    case .genericArgumentList:
      return self.visitGenericArgumentListSyntaxImpl(_:)
    case .genericArgument:
      return self.visitGenericArgumentSyntaxImpl(_:)
    case .genericParameterClause:
      return self.visitGenericParameterClauseSyntaxImpl(_:)
    case .genericParameterList:
      return self.visitGenericParameterListSyntaxImpl(_:)
    case .genericParameter:
      return self.visitGenericParameterSyntaxImpl(_:)
    case .genericRequirementList:
      return self.visitGenericRequirementListSyntaxImpl(_:)
    case .genericRequirement:
      return self.visitGenericRequirementSyntaxImpl(_:)
    case .genericSpecializationExpr:
      return self.visitGenericSpecializationExprSyntaxImpl(_:)
    case .genericWhereClause:
      return self.visitGenericWhereClauseSyntaxImpl(_:)
    case .guardStmt:
      return self.visitGuardStmtSyntaxImpl(_:)
    case .identifierPattern:
      return self.visitIdentifierPatternSyntaxImpl(_:)
    case .identifierType:
      return self.visitIdentifierTypeSyntaxImpl(_:)
    case .ifConfigClauseList:
      return self.visitIfConfigClauseListSyntaxImpl(_:)
    case .ifConfigClause:
      return self.visitIfConfigClauseSyntaxImpl(_:)
    case .ifConfigDecl:
      return self.visitIfConfigDeclSyntaxImpl(_:)
    case .ifExpr:
      return self.visitIfExprSyntaxImpl(_:)
    case .implementsAttributeArguments:
      return self.visitImplementsAttributeArgumentsSyntaxImpl(_:)
    case .implicitlyUnwrappedOptionalType:
      return self.visitImplicitlyUnwrappedOptionalTypeSyntaxImpl(_:)
    case .importDecl:
      return self.visitImportDeclSyntaxImpl(_:)
    case .importPathComponentList:
      return self.visitImportPathComponentListSyntaxImpl(_:)
    case .importPathComponent:
      return self.visitImportPathComponentSyntaxImpl(_:)
    case .inOutExpr:
      return self.visitInOutExprSyntaxImpl(_:)
    case .infixOperatorExpr:
      return self.visitInfixOperatorExprSyntaxImpl(_:)
    case .inheritanceClause:
      return self.visitInheritanceClauseSyntaxImpl(_:)
    case .inheritedTypeList:
      return self.visitInheritedTypeListSyntaxImpl(_:)
    case .inheritedType:
      return self.visitInheritedTypeSyntaxImpl(_:)
    case .initializerClause:
      return self.visitInitializerClauseSyntaxImpl(_:)
    case .initializerDecl:
      return self.visitInitializerDeclSyntaxImpl(_:)
    case .inlineArrayType:
      return self.visitInlineArrayTypeSyntaxImpl(_:)
    case .integerLiteralExpr:
      return self.visitIntegerLiteralExprSyntaxImpl(_:)
    case .isExpr:
      return self.visitIsExprSyntaxImpl(_:)
    case .isTypePattern:
      return self.visitIsTypePatternSyntaxImpl(_:)
    case .keyPathComponentList:
      return self.visitKeyPathComponentListSyntaxImpl(_:)
    case .keyPathComponent:
      return self.visitKeyPathComponentSyntaxImpl(_:)
    case .keyPathExpr:
      return self.visitKeyPathExprSyntaxImpl(_:)
    case .keyPathMethodComponent:
      return self.visitKeyPathMethodComponentSyntaxImpl(_:)
    case .keyPathOptionalComponent:
      return self.visitKeyPathOptionalComponentSyntaxImpl(_:)
    case .keyPathPropertyComponent:
      return self.visitKeyPathPropertyComponentSyntaxImpl(_:)
    case .keyPathSubscriptComponent:
      return self.visitKeyPathSubscriptComponentSyntaxImpl(_:)
    case .labeledExprList:
      return self.visitLabeledExprListSyntaxImpl(_:)
    case .labeledExpr:
      return self.visitLabeledExprSyntaxImpl(_:)
    case .labeledSpecializeArgument:
      return self.visitLabeledSpecializeArgumentSyntaxImpl(_:)
    case .labeledStmt:
      return self.visitLabeledStmtSyntaxImpl(_:)
    case .layoutRequirement:
      return self.visitLayoutRequirementSyntaxImpl(_:)
    case .lifetimeSpecifierArgumentList:
      return self.visitLifetimeSpecifierArgumentListSyntaxImpl(_:)
    case .lifetimeSpecifierArgument:
      return self.visitLifetimeSpecifierArgumentSyntaxImpl(_:)
    case .lifetimeTypeSpecifier:
      return self.visitLifetimeTypeSpecifierSyntaxImpl(_:)
    case .macroDecl:
      return self.visitMacroDeclSyntaxImpl(_:)
    case .macroExpansionDecl:
      return self.visitMacroExpansionDeclSyntaxImpl(_:)
    case .macroExpansionExpr:
      return self.visitMacroExpansionExprSyntaxImpl(_:)
    case .matchingPatternCondition:
      return self.visitMatchingPatternConditionSyntaxImpl(_:)
    case .memberAccessExpr:
      return self.visitMemberAccessExprSyntaxImpl(_:)
    case .memberBlockItemListFile:
      return self.visitMemberBlockItemListFileSyntaxImpl(_:)
    case .memberBlockItemList:
      return self.visitMemberBlockItemListSyntaxImpl(_:)
    case .memberBlockItem:
      return self.visitMemberBlockItemSyntaxImpl(_:)
    case .memberBlock:
      return self.visitMemberBlockSyntaxImpl(_:)
    case .memberType:
      return self.visitMemberTypeSyntaxImpl(_:)
    case .metatypeType:
      return self.visitMetatypeTypeSyntaxImpl(_:)
    case .missingDecl:
      return self.visitMissingDeclSyntaxImpl(_:)
    case .missingExpr:
      return self.visitMissingExprSyntaxImpl(_:)
    case .missingPattern:
      return self.visitMissingPatternSyntaxImpl(_:)
    case .missingStmt:
      return self.visitMissingStmtSyntaxImpl(_:)
    case .missing:
      return self.visitMissingSyntaxImpl(_:)
    case .missingType:
      return self.visitMissingTypeSyntaxImpl(_:)
    case .multipleTrailingClosureElementList:
      return self.visitMultipleTrailingClosureElementListSyntaxImpl(_:)
    case .multipleTrailingClosureElement:
      return self.visitMultipleTrailingClosureElementSyntaxImpl(_:)
    case .namedOpaqueReturnType:
      return self.visitNamedOpaqueReturnTypeSyntaxImpl(_:)
    case .nilLiteralExpr:
      return self.visitNilLiteralExprSyntaxImpl(_:)
    case .nonisolatedSpecifierArgument:
      return self.visitNonisolatedSpecifierArgumentSyntaxImpl(_:)
    case .nonisolatedTypeSpecifier:
      return self.visitNonisolatedTypeSpecifierSyntaxImpl(_:)
    case .objCSelectorPieceList:
      return self.visitObjCSelectorPieceListSyntaxImpl(_:)
    case .objCSelectorPiece:
      return self.visitObjCSelectorPieceSyntaxImpl(_:)
    case .operatorDecl:
      return self.visitOperatorDeclSyntaxImpl(_:)
    case .operatorPrecedenceAndTypes:
      return self.visitOperatorPrecedenceAndTypesSyntaxImpl(_:)
    case .optionalBindingCondition:
      return self.visitOptionalBindingConditionSyntaxImpl(_:)
    case .optionalChainingExpr:
      return self.visitOptionalChainingExprSyntaxImpl(_:)
    case .optionalType:
      return self.visitOptionalTypeSyntaxImpl(_:)
    case .originallyDefinedInAttributeArguments:
      return self.visitOriginallyDefinedInAttributeArgumentsSyntaxImpl(_:)
    case .packElementExpr:
      return self.visitPackElementExprSyntaxImpl(_:)
    case .packElementType:
      return self.visitPackElementTypeSyntaxImpl(_:)
    case .packExpansionExpr:
      return self.visitPackExpansionExprSyntaxImpl(_:)
    case .packExpansionType:
      return self.visitPackExpansionTypeSyntaxImpl(_:)
    case .patternBindingList:
      return self.visitPatternBindingListSyntaxImpl(_:)
    case .patternBinding:
      return self.visitPatternBindingSyntaxImpl(_:)
    case .patternExpr:
      return self.visitPatternExprSyntaxImpl(_:)
    case .platformVersionItemList:
      return self.visitPlatformVersionItemListSyntaxImpl(_:)
    case .platformVersionItem:
      return self.visitPlatformVersionItemSyntaxImpl(_:)
    case .platformVersion:
      return self.visitPlatformVersionSyntaxImpl(_:)
    case .postfixIfConfigExpr:
      return self.visitPostfixIfConfigExprSyntaxImpl(_:)
    case .postfixOperatorExpr:
      return self.visitPostfixOperatorExprSyntaxImpl(_:)
    case .poundSourceLocationArguments:
      return self.visitPoundSourceLocationArgumentsSyntaxImpl(_:)
    case .poundSourceLocation:
      return self.visitPoundSourceLocationSyntaxImpl(_:)
    case .precedenceGroupAssignment:
      return self.visitPrecedenceGroupAssignmentSyntaxImpl(_:)
    case .precedenceGroupAssociativity:
      return self.visitPrecedenceGroupAssociativitySyntaxImpl(_:)
    case .precedenceGroupAttributeList:
      return self.visitPrecedenceGroupAttributeListSyntaxImpl(_:)
    case .precedenceGroupDecl:
      return self.visitPrecedenceGroupDeclSyntaxImpl(_:)
    case .precedenceGroupNameList:
      return self.visitPrecedenceGroupNameListSyntaxImpl(_:)
    case .precedenceGroupName:
      return self.visitPrecedenceGroupNameSyntaxImpl(_:)
    case .precedenceGroupRelation:
      return self.visitPrecedenceGroupRelationSyntaxImpl(_:)
    case .prefixOperatorExpr:
      return self.visitPrefixOperatorExprSyntaxImpl(_:)
    case .primaryAssociatedTypeClause:
      return self.visitPrimaryAssociatedTypeClauseSyntaxImpl(_:)
    case .primaryAssociatedTypeList:
      return self.visitPrimaryAssociatedTypeListSyntaxImpl(_:)
    case .primaryAssociatedType:
      return self.visitPrimaryAssociatedTypeSyntaxImpl(_:)
    case .protocolDecl:
      return self.visitProtocolDeclSyntaxImpl(_:)
    case .regexLiteralExpr:
      return self.visitRegexLiteralExprSyntaxImpl(_:)
    case .repeatStmt:
      return self.visitRepeatStmtSyntaxImpl(_:)
    case .returnClause:
      return self.visitReturnClauseSyntaxImpl(_:)
    case .returnStmt:
      return self.visitReturnStmtSyntaxImpl(_:)
    case .sameTypeRequirement:
      return self.visitSameTypeRequirementSyntaxImpl(_:)
    case .sequenceExpr:
      return self.visitSequenceExprSyntaxImpl(_:)
    case .simpleStringLiteralExpr:
      return self.visitSimpleStringLiteralExprSyntaxImpl(_:)
    case .simpleStringLiteralSegmentList:
      return self.visitSimpleStringLiteralSegmentListSyntaxImpl(_:)
    case .simpleTypeSpecifier:
      return self.visitSimpleTypeSpecifierSyntaxImpl(_:)
    case .someOrAnyType:
      return self.visitSomeOrAnyTypeSyntaxImpl(_:)
    case .sourceFile:
      return self.visitSourceFileSyntaxImpl(_:)
    case .specializeAttributeArgumentList:
      return self.visitSpecializeAttributeArgumentListSyntaxImpl(_:)
    case .specializeAvailabilityArgument:
      return self.visitSpecializeAvailabilityArgumentSyntaxImpl(_:)
    case .specializeTargetFunctionArgument:
      return self.visitSpecializeTargetFunctionArgumentSyntaxImpl(_:)
    case .specializedAttributeArgument:
      return self.visitSpecializedAttributeArgumentSyntaxImpl(_:)
    case .stringLiteralExpr:
      return self.visitStringLiteralExprSyntaxImpl(_:)
    case .stringLiteralSegmentList:
      return self.visitStringLiteralSegmentListSyntaxImpl(_:)
    case .stringSegment:
      return self.visitStringSegmentSyntaxImpl(_:)
    case .structDecl:
      return self.visitStructDeclSyntaxImpl(_:)
    case .subscriptCallExpr:
      return self.visitSubscriptCallExprSyntaxImpl(_:)
    case .subscriptDecl:
      return self.visitSubscriptDeclSyntaxImpl(_:)
    case .superExpr:
      return self.visitSuperExprSyntaxImpl(_:)
    case .suppressedType:
      return self.visitSuppressedTypeSyntaxImpl(_:)
    case .switchCaseItemList:
      return self.visitSwitchCaseItemListSyntaxImpl(_:)
    case .switchCaseItem:
      return self.visitSwitchCaseItemSyntaxImpl(_:)
    case .switchCaseLabel:
      return self.visitSwitchCaseLabelSyntaxImpl(_:)
    case .switchCaseList:
      return self.visitSwitchCaseListSyntaxImpl(_:)
    case .switchCase:
      return self.visitSwitchCaseSyntaxImpl(_:)
    case .switchDefaultLabel:
      return self.visitSwitchDefaultLabelSyntaxImpl(_:)
    case .switchExpr:
      return self.visitSwitchExprSyntaxImpl(_:)
    case .ternaryExpr:
      return self.visitTernaryExprSyntaxImpl(_:)
    case .thenStmt:
      return self.visitThenStmtSyntaxImpl(_:)
    case .throwStmt:
      return self.visitThrowStmtSyntaxImpl(_:)
    case .throwsClause:
      return self.visitThrowsClauseSyntaxImpl(_:)
    case .tryExpr:
      return self.visitTryExprSyntaxImpl(_:)
    case .tupleExpr:
      return self.visitTupleExprSyntaxImpl(_:)
    case .tuplePatternElementList:
      return self.visitTuplePatternElementListSyntaxImpl(_:)
    case .tuplePatternElement:
      return self.visitTuplePatternElementSyntaxImpl(_:)
    case .tuplePattern:
      return self.visitTuplePatternSyntaxImpl(_:)
    case .tupleTypeElementList:
      return self.visitTupleTypeElementListSyntaxImpl(_:)
    case .tupleTypeElement:
      return self.visitTupleTypeElementSyntaxImpl(_:)
    case .tupleType:
      return self.visitTupleTypeSyntaxImpl(_:)
    case .typeAliasDecl:
      return self.visitTypeAliasDeclSyntaxImpl(_:)
    case .typeAnnotation:
      return self.visitTypeAnnotationSyntaxImpl(_:)
    case .typeEffectSpecifiers:
      return self.visitTypeEffectSpecifiersSyntaxImpl(_:)
    case .typeExpr:
      return self.visitTypeExprSyntaxImpl(_:)
    case .typeInitializerClause:
      return self.visitTypeInitializerClauseSyntaxImpl(_:)
    case .typeSpecifierList:
      return self.visitTypeSpecifierListSyntaxImpl(_:)
    case .unexpectedNodes:
      return self.visitUnexpectedNodesSyntaxImpl(_:)
    case .unresolvedAsExpr:
      return self.visitUnresolvedAsExprSyntaxImpl(_:)
    case .unresolvedIsExpr:
      return self.visitUnresolvedIsExprSyntaxImpl(_:)
    case .unresolvedTernaryExpr:
      return self.visitUnresolvedTernaryExprSyntaxImpl(_:)
    case .unsafeExpr:
      return self.visitUnsafeExprSyntaxImpl(_:)
    case .usingDecl:
      return self.visitUsingDeclSyntaxImpl(_:)
    case .valueBindingPattern:
      return self.visitValueBindingPatternSyntaxImpl(_:)
    case .variableDecl:
      return self.visitVariableDeclSyntaxImpl(_:)
    case .versionComponentList:
      return self.visitVersionComponentListSyntaxImpl(_:)
    case .versionComponent:
      return self.visitVersionComponentSyntaxImpl(_:)
    case .versionTuple:
      return self.visitVersionTupleSyntaxImpl(_:)
    case .whereClause:
      return self.visitWhereClauseSyntaxImpl(_:)
    case .whileStmt:
      return self.visitWhileStmtSyntaxImpl(_:)
    case .wildcardPattern:
      return self.visitWildcardPatternSyntaxImpl(_:)
    case .yieldStmt:
      return self.visitYieldStmtSyntaxImpl(_:)
    case .yieldedExpressionList:
      return self.visitYieldedExpressionListSyntaxImpl(_:)
    case .yieldedExpression:
      return self.visitYieldedExpressionSyntaxImpl(_:)
    case .yieldedExpressionsClause:
      return self.visitYieldedExpressionsClauseSyntaxImpl(_:)
    }
  }
  private func dispatchVisit(_ node: Syntax) -> Syntax {
    visitationFunc(for: node)(node)
  }
  #else
  private func dispatchVisit(_ node: Syntax) -> Syntax {
    switch node.raw.kind {
    case .token:
      return visitTokenSyntaxImpl(node)
    case .abiAttributeArguments:
      return visitABIAttributeArgumentsSyntaxImpl(node)
    case .accessorBlockFile:
      return visitAccessorBlockFileSyntaxImpl(node)
    case .accessorBlock:
      return visitAccessorBlockSyntaxImpl(node)
    case .accessorDeclList:
      return visitAccessorDeclListSyntaxImpl(node)
    case .accessorDecl:
      return visitAccessorDeclSyntaxImpl(node)
    case .accessorEffectSpecifiers:
      return visitAccessorEffectSpecifiersSyntaxImpl(node)
    case .accessorParameters:
      return visitAccessorParametersSyntaxImpl(node)
    case .actorDecl:
      return visitActorDeclSyntaxImpl(node)
    case .arrayElementList:
      return visitArrayElementListSyntaxImpl(node)
    case .arrayElement:
      return visitArrayElementSyntaxImpl(node)
    case .arrayExpr:
      return visitArrayExprSyntaxImpl(node)
    case .arrayType:
      return visitArrayTypeSyntaxImpl(node)
    case .arrowExpr:
      return visitArrowExprSyntaxImpl(node)
    case .asExpr:
      return visitAsExprSyntaxImpl(node)
    case .assignmentExpr:
      return visitAssignmentExprSyntaxImpl(node)
    case .associatedTypeDecl:
      return visitAssociatedTypeDeclSyntaxImpl(node)
    case .attributeClauseFile:
      return visitAttributeClauseFileSyntaxImpl(node)
    case .attributeList:
      return visitAttributeListSyntaxImpl(node)
    case .attribute:
      return visitAttributeSyntaxImpl(node)
    case .attributedType:
      return visitAttributedTypeSyntaxImpl(node)
    case .availabilityArgumentList:
      return visitAvailabilityArgumentListSyntaxImpl(node)
    case .availabilityArgument:
      return visitAvailabilityArgumentSyntaxImpl(node)
    case .availabilityCondition:
      return visitAvailabilityConditionSyntaxImpl(node)
    case .availabilityLabeledArgument:
      return visitAvailabilityLabeledArgumentSyntaxImpl(node)
    case .availabilityMacroDefinitionFile:
      return visitAvailabilityMacroDefinitionFileSyntaxImpl(node)
    case .awaitExpr:
      return visitAwaitExprSyntaxImpl(node)
    case .backDeployedAttributeArguments:
      return visitBackDeployedAttributeArgumentsSyntaxImpl(node)
    case .binaryOperatorExpr:
      return visitBinaryOperatorExprSyntaxImpl(node)
    case .booleanLiteralExpr:
      return visitBooleanLiteralExprSyntaxImpl(node)
    case .borrowExpr:
      return visitBorrowExprSyntaxImpl(node)
    case .breakStmt:
      return visitBreakStmtSyntaxImpl(node)
    case ._canImportExpr:
      return visit_CanImportExprSyntaxImpl(node)
    case ._canImportVersionInfo:
      return visit_CanImportVersionInfoSyntaxImpl(node)
    case .catchClauseList:
      return visitCatchClauseListSyntaxImpl(node)
    case .catchClause:
      return visitCatchClauseSyntaxImpl(node)
    case .catchItemList:
      return visitCatchItemListSyntaxImpl(node)
    case .catchItem:
      return visitCatchItemSyntaxImpl(node)
    case .classDecl:
      return visitClassDeclSyntaxImpl(node)
    case .classRestrictionType:
      return visitClassRestrictionTypeSyntaxImpl(node)
    case .closureCaptureClause:
      return visitClosureCaptureClauseSyntaxImpl(node)
    case .closureCaptureList:
      return visitClosureCaptureListSyntaxImpl(node)
    case .closureCaptureSpecifier:
      return visitClosureCaptureSpecifierSyntaxImpl(node)
    case .closureCapture:
      return visitClosureCaptureSyntaxImpl(node)
    case .closureExpr:
      return visitClosureExprSyntaxImpl(node)
    case .closureParameterClause:
      return visitClosureParameterClauseSyntaxImpl(node)
    case .closureParameterList:
      return visitClosureParameterListSyntaxImpl(node)
    case .closureParameter:
      return visitClosureParameterSyntaxImpl(node)
    case .closureShorthandParameterList:
      return visitClosureShorthandParameterListSyntaxImpl(node)
    case .closureShorthandParameter:
      return visitClosureShorthandParameterSyntaxImpl(node)
    case .closureSignature:
      return visitClosureSignatureSyntaxImpl(node)
    case .codeBlockFile:
      return visitCodeBlockFileSyntaxImpl(node)
    case .codeBlockItemList:
      return visitCodeBlockItemListSyntaxImpl(node)
    case .codeBlockItem:
      return visitCodeBlockItemSyntaxImpl(node)
    case .codeBlock:
      return visitCodeBlockSyntaxImpl(node)
    case .compositionTypeElementList:
      return visitCompositionTypeElementListSyntaxImpl(node)
    case .compositionTypeElement:
      return visitCompositionTypeElementSyntaxImpl(node)
    case .compositionType:
      return visitCompositionTypeSyntaxImpl(node)
    case .conditionElementList:
      return visitConditionElementListSyntaxImpl(node)
    case .conditionElement:
      return visitConditionElementSyntaxImpl(node)
    case .conformanceRequirement:
      return visitConformanceRequirementSyntaxImpl(node)
    case .consumeExpr:
      return visitConsumeExprSyntaxImpl(node)
    case .continueStmt:
      return visitContinueStmtSyntaxImpl(node)
    case .copyExpr:
      return visitCopyExprSyntaxImpl(node)
    case .declModifierDetail:
      return visitDeclModifierDetailSyntaxImpl(node)
    case .declModifierList:
      return visitDeclModifierListSyntaxImpl(node)
    case .declModifier:
      return visitDeclModifierSyntaxImpl(node)
    case .declNameArgumentList:
      return visitDeclNameArgumentListSyntaxImpl(node)
    case .declNameArgument:
      return visitDeclNameArgumentSyntaxImpl(node)
    case .declNameArguments:
      return visitDeclNameArgumentsSyntaxImpl(node)
    case .declReferenceExpr:
      return visitDeclReferenceExprSyntaxImpl(node)
    case .deferStmt:
      return visitDeferStmtSyntaxImpl(node)
    case .deinitializerDecl:
      return visitDeinitializerDeclSyntaxImpl(node)
    case .deinitializerEffectSpecifiers:
      return visitDeinitializerEffectSpecifiersSyntaxImpl(node)
    case .derivativeAttributeArguments:
      return visitDerivativeAttributeArgumentsSyntaxImpl(node)
    case .designatedTypeList:
      return visitDesignatedTypeListSyntaxImpl(node)
    case .designatedType:
      return visitDesignatedTypeSyntaxImpl(node)
    case .dictionaryElementList:
      return visitDictionaryElementListSyntaxImpl(node)
    case .dictionaryElement:
      return visitDictionaryElementSyntaxImpl(node)
    case .dictionaryExpr:
      return visitDictionaryExprSyntaxImpl(node)
    case .dictionaryType:
      return visitDictionaryTypeSyntaxImpl(node)
    case .differentiabilityArgumentList:
      return visitDifferentiabilityArgumentListSyntaxImpl(node)
    case .differentiabilityArgument:
      return visitDifferentiabilityArgumentSyntaxImpl(node)
    case .differentiabilityArguments:
      return visitDifferentiabilityArgumentsSyntaxImpl(node)
    case .differentiabilityWithRespectToArgument:
      return visitDifferentiabilityWithRespectToArgumentSyntaxImpl(node)
    case .differentiableAttributeArguments:
      return visitDifferentiableAttributeArgumentsSyntaxImpl(node)
    case .discardAssignmentExpr:
      return visitDiscardAssignmentExprSyntaxImpl(node)
    case .discardStmt:
      return visitDiscardStmtSyntaxImpl(node)
    case .doExpr:
      return visitDoExprSyntaxImpl(node)
    case .doStmt:
      return visitDoStmtSyntaxImpl(node)
    case .documentationAttributeArgumentList:
      return visitDocumentationAttributeArgumentListSyntaxImpl(node)
    case .documentationAttributeArgument:
      return visitDocumentationAttributeArgumentSyntaxImpl(node)
    case .dynamicReplacementAttributeArguments:
      return visitDynamicReplacementAttributeArgumentsSyntaxImpl(node)
    case .editorPlaceholderDecl:
      return visitEditorPlaceholderDeclSyntaxImpl(node)
    case .editorPlaceholderExpr:
      return visitEditorPlaceholderExprSyntaxImpl(node)
    case .effectsAttributeArgumentList:
      return visitEffectsAttributeArgumentListSyntaxImpl(node)
    case .enumCaseDecl:
      return visitEnumCaseDeclSyntaxImpl(node)
    case .enumCaseElementList:
      return visitEnumCaseElementListSyntaxImpl(node)
    case .enumCaseElement:
      return visitEnumCaseElementSyntaxImpl(node)
    case .enumCaseParameterClause:
      return visitEnumCaseParameterClauseSyntaxImpl(node)
    case .enumCaseParameterList:
      return visitEnumCaseParameterListSyntaxImpl(node)
    case .enumCaseParameter:
      return visitEnumCaseParameterSyntaxImpl(node)
    case .enumDecl:
      return visitEnumDeclSyntaxImpl(node)
    case .exprList:
      return visitExprListSyntaxImpl(node)
    case .expressionPattern:
      return visitExpressionPatternSyntaxImpl(node)
    case .expressionSegment:
      return visitExpressionSegmentSyntaxImpl(node)
    case .expressionStmt:
      return visitExpressionStmtSyntaxImpl(node)
    case .extensionDecl:
      return visitExtensionDeclSyntaxImpl(node)
    case .fallThroughStmt:
      return visitFallThroughStmtSyntaxImpl(node)
    case .floatLiteralExpr:
      return visitFloatLiteralExprSyntaxImpl(node)
    case .forStmt:
      return visitForStmtSyntaxImpl(node)
    case .forceUnwrapExpr:
      return visitForceUnwrapExprSyntaxImpl(node)
    case .functionCallExpr:
      return visitFunctionCallExprSyntaxImpl(node)
    case .functionDecl:
      return visitFunctionDeclSyntaxImpl(node)
    case .functionEffectSpecifiers:
      return visitFunctionEffectSpecifiersSyntaxImpl(node)
    case .functionParameterClause:
      return visitFunctionParameterClauseSyntaxImpl(node)
    case .functionParameterList:
      return visitFunctionParameterListSyntaxImpl(node)
    case .functionParameter:
      return visitFunctionParameterSyntaxImpl(node)
    case .functionSignature:
      return visitFunctionSignatureSyntaxImpl(node)
    case .functionType:
      return visitFunctionTypeSyntaxImpl(node)
    case .genericArgumentClause:
      return visitGenericArgumentClauseSyntaxImpl(node)
    case .genericArgumentList:
      return visitGenericArgumentListSyntaxImpl(node)
    case .genericArgument:
      return visitGenericArgumentSyntaxImpl(node)
    case .genericParameterClause:
      return visitGenericParameterClauseSyntaxImpl(node)
    case .genericParameterList:
      return visitGenericParameterListSyntaxImpl(node)
    case .genericParameter:
      return visitGenericParameterSyntaxImpl(node)
    case .genericRequirementList:
      return visitGenericRequirementListSyntaxImpl(node)
    case .genericRequirement:
      return visitGenericRequirementSyntaxImpl(node)
    case .genericSpecializationExpr:
      return visitGenericSpecializationExprSyntaxImpl(node)
    case .genericWhereClause:
      return visitGenericWhereClauseSyntaxImpl(node)
    case .guardStmt:
      return visitGuardStmtSyntaxImpl(node)
    case .identifierPattern:
      return visitIdentifierPatternSyntaxImpl(node)
    case .identifierType:
      return visitIdentifierTypeSyntaxImpl(node)
    case .ifConfigClauseList:
      return visitIfConfigClauseListSyntaxImpl(node)
    case .ifConfigClause:
      return visitIfConfigClauseSyntaxImpl(node)
    case .ifConfigDecl:
      return visitIfConfigDeclSyntaxImpl(node)
    case .ifExpr:
      return visitIfExprSyntaxImpl(node)
    case .implementsAttributeArguments:
      return visitImplementsAttributeArgumentsSyntaxImpl(node)
    case .implicitlyUnwrappedOptionalType:
      return visitImplicitlyUnwrappedOptionalTypeSyntaxImpl(node)
    case .importDecl:
      return visitImportDeclSyntaxImpl(node)
    case .importPathComponentList:
      return visitImportPathComponentListSyntaxImpl(node)
    case .importPathComponent:
      return visitImportPathComponentSyntaxImpl(node)
    case .inOutExpr:
      return visitInOutExprSyntaxImpl(node)
    case .infixOperatorExpr:
      return visitInfixOperatorExprSyntaxImpl(node)
    case .inheritanceClause:
      return visitInheritanceClauseSyntaxImpl(node)
    case .inheritedTypeList:
      return visitInheritedTypeListSyntaxImpl(node)
    case .inheritedType:
      return visitInheritedTypeSyntaxImpl(node)
    case .initializerClause:
      return visitInitializerClauseSyntaxImpl(node)
    case .initializerDecl:
      return visitInitializerDeclSyntaxImpl(node)
    case .inlineArrayType:
      return visitInlineArrayTypeSyntaxImpl(node)
    case .integerLiteralExpr:
      return visitIntegerLiteralExprSyntaxImpl(node)
    case .isExpr:
      return visitIsExprSyntaxImpl(node)
    case .isTypePattern:
      return visitIsTypePatternSyntaxImpl(node)
    case .keyPathComponentList:
      return visitKeyPathComponentListSyntaxImpl(node)
    case .keyPathComponent:
      return visitKeyPathComponentSyntaxImpl(node)
    case .keyPathExpr:
      return visitKeyPathExprSyntaxImpl(node)
    case .keyPathMethodComponent:
      return visitKeyPathMethodComponentSyntaxImpl(node)
    case .keyPathOptionalComponent:
      return visitKeyPathOptionalComponentSyntaxImpl(node)
    case .keyPathPropertyComponent:
      return visitKeyPathPropertyComponentSyntaxImpl(node)
    case .keyPathSubscriptComponent:
      return visitKeyPathSubscriptComponentSyntaxImpl(node)
    case .labeledExprList:
      return visitLabeledExprListSyntaxImpl(node)
    case .labeledExpr:
      return visitLabeledExprSyntaxImpl(node)
    case .labeledSpecializeArgument:
      return visitLabeledSpecializeArgumentSyntaxImpl(node)
    case .labeledStmt:
      return visitLabeledStmtSyntaxImpl(node)
    case .layoutRequirement:
      return visitLayoutRequirementSyntaxImpl(node)
    case .lifetimeSpecifierArgumentList:
      return visitLifetimeSpecifierArgumentListSyntaxImpl(node)
    case .lifetimeSpecifierArgument:
      return visitLifetimeSpecifierArgumentSyntaxImpl(node)
    case .lifetimeTypeSpecifier:
      return visitLifetimeTypeSpecifierSyntaxImpl(node)
    case .macroDecl:
      return visitMacroDeclSyntaxImpl(node)
    case .macroExpansionDecl:
      return visitMacroExpansionDeclSyntaxImpl(node)
    case .macroExpansionExpr:
      return visitMacroExpansionExprSyntaxImpl(node)
    case .matchingPatternCondition:
      return visitMatchingPatternConditionSyntaxImpl(node)
    case .memberAccessExpr:
      return visitMemberAccessExprSyntaxImpl(node)
    case .memberBlockItemListFile:
      return visitMemberBlockItemListFileSyntaxImpl(node)
    case .memberBlockItemList:
      return visitMemberBlockItemListSyntaxImpl(node)
    case .memberBlockItem:
      return visitMemberBlockItemSyntaxImpl(node)
    case .memberBlock:
      return visitMemberBlockSyntaxImpl(node)
    case .memberType:
      return visitMemberTypeSyntaxImpl(node)
    case .metatypeType:
      return visitMetatypeTypeSyntaxImpl(node)
    case .missingDecl:
      return visitMissingDeclSyntaxImpl(node)
    case .missingExpr:
      return visitMissingExprSyntaxImpl(node)
    case .missingPattern:
      return visitMissingPatternSyntaxImpl(node)
    case .missingStmt:
      return visitMissingStmtSyntaxImpl(node)
    case .missing:
      return visitMissingSyntaxImpl(node)
    case .missingType:
      return visitMissingTypeSyntaxImpl(node)
    case .multipleTrailingClosureElementList:
      return visitMultipleTrailingClosureElementListSyntaxImpl(node)
    case .multipleTrailingClosureElement:
      return visitMultipleTrailingClosureElementSyntaxImpl(node)
    case .namedOpaqueReturnType:
      return visitNamedOpaqueReturnTypeSyntaxImpl(node)
    case .nilLiteralExpr:
      return visitNilLiteralExprSyntaxImpl(node)
    case .nonisolatedSpecifierArgument:
      return visitNonisolatedSpecifierArgumentSyntaxImpl(node)
    case .nonisolatedTypeSpecifier:
      return visitNonisolatedTypeSpecifierSyntaxImpl(node)
    case .objCSelectorPieceList:
      return visitObjCSelectorPieceListSyntaxImpl(node)
    case .objCSelectorPiece:
      return visitObjCSelectorPieceSyntaxImpl(node)
    case .operatorDecl:
      return visitOperatorDeclSyntaxImpl(node)
    case .operatorPrecedenceAndTypes:
      return visitOperatorPrecedenceAndTypesSyntaxImpl(node)
    case .optionalBindingCondition:
      return visitOptionalBindingConditionSyntaxImpl(node)
    case .optionalChainingExpr:
      return visitOptionalChainingExprSyntaxImpl(node)
    case .optionalType:
      return visitOptionalTypeSyntaxImpl(node)
    case .originallyDefinedInAttributeArguments:
      return visitOriginallyDefinedInAttributeArgumentsSyntaxImpl(node)
    case .packElementExpr:
      return visitPackElementExprSyntaxImpl(node)
    case .packElementType:
      return visitPackElementTypeSyntaxImpl(node)
    case .packExpansionExpr:
      return visitPackExpansionExprSyntaxImpl(node)
    case .packExpansionType:
      return visitPackExpansionTypeSyntaxImpl(node)
    case .patternBindingList:
      return visitPatternBindingListSyntaxImpl(node)
    case .patternBinding:
      return visitPatternBindingSyntaxImpl(node)
    case .patternExpr:
      return visitPatternExprSyntaxImpl(node)
    case .platformVersionItemList:
      return visitPlatformVersionItemListSyntaxImpl(node)
    case .platformVersionItem:
      return visitPlatformVersionItemSyntaxImpl(node)
    case .platformVersion:
      return visitPlatformVersionSyntaxImpl(node)
    case .postfixIfConfigExpr:
      return visitPostfixIfConfigExprSyntaxImpl(node)
    case .postfixOperatorExpr:
      return visitPostfixOperatorExprSyntaxImpl(node)
    case .poundSourceLocationArguments:
      return visitPoundSourceLocationArgumentsSyntaxImpl(node)
    case .poundSourceLocation:
      return visitPoundSourceLocationSyntaxImpl(node)
    case .precedenceGroupAssignment:
      return visitPrecedenceGroupAssignmentSyntaxImpl(node)
    case .precedenceGroupAssociativity:
      return visitPrecedenceGroupAssociativitySyntaxImpl(node)
    case .precedenceGroupAttributeList:
      return visitPrecedenceGroupAttributeListSyntaxImpl(node)
    case .precedenceGroupDecl:
      return visitPrecedenceGroupDeclSyntaxImpl(node)
    case .precedenceGroupNameList:
      return visitPrecedenceGroupNameListSyntaxImpl(node)
    case .precedenceGroupName:
      return visitPrecedenceGroupNameSyntaxImpl(node)
    case .precedenceGroupRelation:
      return visitPrecedenceGroupRelationSyntaxImpl(node)
    case .prefixOperatorExpr:
      return visitPrefixOperatorExprSyntaxImpl(node)
    case .primaryAssociatedTypeClause:
      return visitPrimaryAssociatedTypeClauseSyntaxImpl(node)
    case .primaryAssociatedTypeList:
      return visitPrimaryAssociatedTypeListSyntaxImpl(node)
    case .primaryAssociatedType:
      return visitPrimaryAssociatedTypeSyntaxImpl(node)
    case .protocolDecl:
      return visitProtocolDeclSyntaxImpl(node)
    case .regexLiteralExpr:
      return visitRegexLiteralExprSyntaxImpl(node)
    case .repeatStmt:
      return visitRepeatStmtSyntaxImpl(node)
    case .returnClause:
      return visitReturnClauseSyntaxImpl(node)
    case .returnStmt:
      return visitReturnStmtSyntaxImpl(node)
    case .sameTypeRequirement:
      return visitSameTypeRequirementSyntaxImpl(node)
    case .sequenceExpr:
      return visitSequenceExprSyntaxImpl(node)
    case .simpleStringLiteralExpr:
      return visitSimpleStringLiteralExprSyntaxImpl(node)
    case .simpleStringLiteralSegmentList:
      return visitSimpleStringLiteralSegmentListSyntaxImpl(node)
    case .simpleTypeSpecifier:
      return visitSimpleTypeSpecifierSyntaxImpl(node)
    case .someOrAnyType:
      return visitSomeOrAnyTypeSyntaxImpl(node)
    case .sourceFile:
      return visitSourceFileSyntaxImpl(node)
    case .specializeAttributeArgumentList:
      return visitSpecializeAttributeArgumentListSyntaxImpl(node)
    case .specializeAvailabilityArgument:
      return visitSpecializeAvailabilityArgumentSyntaxImpl(node)
    case .specializeTargetFunctionArgument:
      return visitSpecializeTargetFunctionArgumentSyntaxImpl(node)
    case .specializedAttributeArgument:
      return visitSpecializedAttributeArgumentSyntaxImpl(node)
    case .stringLiteralExpr:
      return visitStringLiteralExprSyntaxImpl(node)
    case .stringLiteralSegmentList:
      return visitStringLiteralSegmentListSyntaxImpl(node)
    case .stringSegment:
      return visitStringSegmentSyntaxImpl(node)
    case .structDecl:
      return visitStructDeclSyntaxImpl(node)
    case .subscriptCallExpr:
      return visitSubscriptCallExprSyntaxImpl(node)
    case .subscriptDecl:
      return visitSubscriptDeclSyntaxImpl(node)
    case .superExpr:
      return visitSuperExprSyntaxImpl(node)
    case .suppressedType:
      return visitSuppressedTypeSyntaxImpl(node)
    case .switchCaseItemList:
      return visitSwitchCaseItemListSyntaxImpl(node)
    case .switchCaseItem:
      return visitSwitchCaseItemSyntaxImpl(node)
    case .switchCaseLabel:
      return visitSwitchCaseLabelSyntaxImpl(node)
    case .switchCaseList:
      return visitSwitchCaseListSyntaxImpl(node)
    case .switchCase:
      return visitSwitchCaseSyntaxImpl(node)
    case .switchDefaultLabel:
      return visitSwitchDefaultLabelSyntaxImpl(node)
    case .switchExpr:
      return visitSwitchExprSyntaxImpl(node)
    case .ternaryExpr:
      return visitTernaryExprSyntaxImpl(node)
    case .thenStmt:
      return visitThenStmtSyntaxImpl(node)
    case .throwStmt:
      return visitThrowStmtSyntaxImpl(node)
    case .throwsClause:
      return visitThrowsClauseSyntaxImpl(node)
    case .tryExpr:
      return visitTryExprSyntaxImpl(node)
    case .tupleExpr:
      return visitTupleExprSyntaxImpl(node)
    case .tuplePatternElementList:
      return visitTuplePatternElementListSyntaxImpl(node)
    case .tuplePatternElement:
      return visitTuplePatternElementSyntaxImpl(node)
    case .tuplePattern:
      return visitTuplePatternSyntaxImpl(node)
    case .tupleTypeElementList:
      return visitTupleTypeElementListSyntaxImpl(node)
    case .tupleTypeElement:
      return visitTupleTypeElementSyntaxImpl(node)
    case .tupleType:
      return visitTupleTypeSyntaxImpl(node)
    case .typeAliasDecl:
      return visitTypeAliasDeclSyntaxImpl(node)
    case .typeAnnotation:
      return visitTypeAnnotationSyntaxImpl(node)
    case .typeEffectSpecifiers:
      return visitTypeEffectSpecifiersSyntaxImpl(node)
    case .typeExpr:
      return visitTypeExprSyntaxImpl(node)
    case .typeInitializerClause:
      return visitTypeInitializerClauseSyntaxImpl(node)
    case .typeSpecifierList:
      return visitTypeSpecifierListSyntaxImpl(node)
    case .unexpectedNodes:
      return visitUnexpectedNodesSyntaxImpl(node)
    case .unresolvedAsExpr:
      return visitUnresolvedAsExprSyntaxImpl(node)
    case .unresolvedIsExpr:
      return visitUnresolvedIsExprSyntaxImpl(node)
    case .unresolvedTernaryExpr:
      return visitUnresolvedTernaryExprSyntaxImpl(node)
    case .unsafeExpr:
      return visitUnsafeExprSyntaxImpl(node)
    case .usingDecl:
      return visitUsingDeclSyntaxImpl(node)
    case .valueBindingPattern:
      return visitValueBindingPatternSyntaxImpl(node)
    case .variableDecl:
      return visitVariableDeclSyntaxImpl(node)
    case .versionComponentList:
      return visitVersionComponentListSyntaxImpl(node)
    case .versionComponent:
      return visitVersionComponentSyntaxImpl(node)
    case .versionTuple:
      return visitVersionTupleSyntaxImpl(node)
    case .whereClause:
      return visitWhereClauseSyntaxImpl(node)
    case .whileStmt:
      return visitWhileStmtSyntaxImpl(node)
    case .wildcardPattern:
      return visitWildcardPatternSyntaxImpl(node)
    case .yieldStmt:
      return visitYieldStmtSyntaxImpl(node)
    case .yieldedExpressionList:
      return visitYieldedExpressionListSyntaxImpl(node)
    case .yieldedExpression:
      return visitYieldedExpressionSyntaxImpl(node)
    case .yieldedExpressionsClause:
      return visitYieldedExpressionsClauseSyntaxImpl(node)
    }
  }
  #endif

  private func visitImpl(_ node: Syntax) -> Syntax {
    visitPre(node)
    defer {
      visitPost(node)
    }
    return visitAny(node) ?? dispatchVisit(node)
  }

  private func visitChildren(_ node: Syntax) -> Syntax {
    // Walk over all children of this node and rewrite them. Don't store any
    // rewritten nodes until the first non-`nil` value is encountered. When this
    // happens, retrieve all previous syntax nodes from the parent node to
    // initialize the new layout. Once we know that we have to rewrite the
    // layout, we need to collect all further children, regardless of whether
    // they are rewritten or not.

    // newLayout is nil until the first child node is rewritten and rewritten
    // nodes are being collected.
    var newLayout: UnsafeMutableBufferPointer<RawSyntax?> = .init(start: nil, count: 0)

    // Keep 'RawSyntaxArena' of rewritten nodes alive until they are wrapped
    // with 'Syntax'
    var rewrittens: ContiguousArray<RetainedRawSyntaxArena> = []

    for case let childDataRef? in node.layoutBuffer where viewMode.shouldTraverse(node: childDataRef.pointee.raw) {

      // Build the Syntax node to rewrite
      let childNode = visitImpl(Syntax(arena: node.arena, dataRef: childDataRef))
      if childNode.raw.id != childDataRef.pointee.raw.id {
        // The node was rewritten, let's handle it

        if newLayout.baseAddress == nil {
          // We have not yet collected any previous rewritten nodes. Initialize
          // the new layout with the previous nodes of the parent.
          newLayout = .allocate(capacity: node.raw.layoutView!.children.count)
          _ = newLayout.initialize(fromContentsOf: node.raw.layoutView!.children)
        }

        // Update the rewritten child.
        newLayout[Int(childDataRef.pointee.absoluteInfo.layoutIndexInParent)] = childNode.raw
        // Retain the syntax arena of the new node until it's wrapped with Syntax node.
        rewrittens.append(childNode.raw.arenaReference.retained)
      }
    }

    if newLayout.baseAddress != nil {
      // A child node was rewritten. Build the updated node.

      let rawArena = self.rawArena ?? RawSyntaxArena()
      let newRaw = node.raw.layoutView!.replacingLayout(with: newLayout, arena: rawArena)
      newLayout.deinitialize()
      newLayout.deallocate()
      // 'withExtendedLifetime' to keep 'RawSyntaxArena's of them alive until here.
      return withExtendedLifetime(rewrittens) {
        Syntax(raw: newRaw, rawNodeArena: rawArena)
      }
    } else {
      // No child node was rewritten. So no need to change this node as well.
      return node
    }
  }
}
