//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

/// The enum describes how the ``SyntaxVisitor`` should continue after visiting
/// the current node.
public enum SyntaxVisitorContinueKind {
  /// The visitor should visit the descendants of the current node.
  case visitChildren
  /// The visitor should avoid visiting the descendants of the current node.
  case skipChildren
}

open class SyntaxVisitor {
  public let viewMode: SyntaxTreeViewMode

  public init(viewMode: SyntaxTreeViewMode) {
    self.viewMode = viewMode
  }

  /// Walk all nodes of the given syntax tree, calling the corresponding `visit`
  /// function for every node that is being visited.
  public func walk(_ node: some SyntaxProtocol) {
    dispatchVisit(Syntax(node))
  }

  /// Visiting ``ABIAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ABIAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ABIAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ABIAttributeArgumentsSyntax) {
  }

  /// Visiting ``AccessorBlockFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(Compiler)
  open func visit(_ node: AccessorBlockFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AccessorBlockFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(Compiler)
  open func visitPost(_ node: AccessorBlockFileSyntax) {
  }

  /// Visiting ``AccessorBlockSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorBlockSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AccessorBlockSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorBlockSyntax) {
  }

  /// Visiting ``AccessorDeclListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorDeclListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AccessorDeclListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorDeclListSyntax) {
  }

  /// Visiting ``AccessorDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AccessorDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorDeclSyntax) {
  }

  /// Visiting ``AccessorEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AccessorEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorEffectSpecifiersSyntax) {
  }

  /// Visiting ``AccessorParametersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorParametersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AccessorParametersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorParametersSyntax) {
  }

  /// Visiting ``ActorDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ActorDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ActorDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ActorDeclSyntax) {
  }

  /// Visiting ``ArrayElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ArrayElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayElementListSyntax) {
  }

  /// Visiting ``ArrayElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ArrayElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayElementSyntax) {
  }

  /// Visiting ``ArrayExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ArrayExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayExprSyntax) {
  }

  /// Visiting ``ArrayTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ArrayTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayTypeSyntax) {
  }

  /// Visiting ``ArrowExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrowExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ArrowExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrowExprSyntax) {
  }

  /// Visiting ``AsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AsExprSyntax) {
  }

  /// Visiting ``AssignmentExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AssignmentExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AssignmentExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AssignmentExprSyntax) {
  }

  /// Visiting ``AssociatedTypeDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AssociatedTypeDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AssociatedTypeDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AssociatedTypeDeclSyntax) {
  }

  /// Visiting ``AttributeClauseFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(Compiler)
  open func visit(_ node: AttributeClauseFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AttributeClauseFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(Compiler)
  open func visitPost(_ node: AttributeClauseFileSyntax) {
  }

  /// Visiting ``AttributeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AttributeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AttributeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AttributeListSyntax) {
  }

  /// Visiting ``AttributeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AttributeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AttributeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AttributeSyntax) {
  }

  /// Visiting ``AttributedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AttributedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AttributedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AttributedTypeSyntax) {
  }

  /// Visiting ``AvailabilityArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AvailabilityArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityArgumentListSyntax) {
  }

  /// Visiting ``AvailabilityArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AvailabilityArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityArgumentSyntax) {
  }

  /// Visiting ``AvailabilityConditionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityConditionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AvailabilityConditionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityConditionSyntax) {
  }

  /// Visiting ``AvailabilityLabeledArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityLabeledArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AvailabilityLabeledArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityLabeledArgumentSyntax) {
  }

  /// Visiting ``AvailabilityMacroDefinitionFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(Compiler)
  open func visit(_ node: AvailabilityMacroDefinitionFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AvailabilityMacroDefinitionFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(Compiler)
  open func visitPost(_ node: AvailabilityMacroDefinitionFileSyntax) {
  }

  /// Visiting ``AwaitExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AwaitExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``AwaitExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AwaitExprSyntax) {
  }

  /// Visiting ``BackDeployedAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BackDeployedAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``BackDeployedAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BackDeployedAttributeArgumentsSyntax) {
  }

  /// Visiting ``BinaryOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BinaryOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``BinaryOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BinaryOperatorExprSyntax) {
  }

  /// Visiting ``BooleanLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BooleanLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``BooleanLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BooleanLiteralExprSyntax) {
  }

  /// Visiting ``BorrowExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BorrowExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``BorrowExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BorrowExprSyntax) {
  }

  /// Visiting ``BreakStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BreakStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``BreakStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BreakStmtSyntax) {
  }

  /// Visiting `_CanImportExprSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: _CanImportExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `_CanImportExprSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: _CanImportExprSyntax) {
  }

  /// Visiting `_CanImportVersionInfoSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: _CanImportVersionInfoSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `_CanImportVersionInfoSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: _CanImportVersionInfoSyntax) {
  }

  /// Visiting ``CatchClauseListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchClauseListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CatchClauseListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchClauseListSyntax) {
  }

  /// Visiting ``CatchClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CatchClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchClauseSyntax) {
  }

  /// Visiting ``CatchItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CatchItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchItemListSyntax) {
  }

  /// Visiting ``CatchItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CatchItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchItemSyntax) {
  }

  /// Visiting ``ClassDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClassDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClassDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClassDeclSyntax) {
  }

  /// Visiting ``ClassRestrictionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClassRestrictionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClassRestrictionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClassRestrictionTypeSyntax) {
  }

  /// Visiting ``ClosureCaptureClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureCaptureClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureClauseSyntax) {
  }

  /// Visiting ``ClosureCaptureListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureCaptureListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureListSyntax) {
  }

  /// Visiting ``ClosureCaptureSpecifierSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureSpecifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureCaptureSpecifierSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureSpecifierSyntax) {
  }

  /// Visiting ``ClosureCaptureSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureCaptureSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureSyntax) {
  }

  /// Visiting ``ClosureExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureExprSyntax) {
  }

  /// Visiting ``ClosureParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureParameterClauseSyntax) {
  }

  /// Visiting ``ClosureParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureParameterListSyntax) {
  }

  /// Visiting ``ClosureParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureParameterSyntax) {
  }

  /// Visiting ``ClosureShorthandParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureShorthandParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureShorthandParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureShorthandParameterListSyntax) {
  }

  /// Visiting ``ClosureShorthandParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureShorthandParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureShorthandParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureShorthandParameterSyntax) {
  }

  /// Visiting ``ClosureSignatureSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureSignatureSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ClosureSignatureSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureSignatureSyntax) {
  }

  /// Visiting ``CodeBlockFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(Compiler)
  open func visit(_ node: CodeBlockFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CodeBlockFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(Compiler)
  open func visitPost(_ node: CodeBlockFileSyntax) {
  }

  /// Visiting ``CodeBlockItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CodeBlockItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CodeBlockItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CodeBlockItemListSyntax) {
  }

  /// Visiting ``CodeBlockItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CodeBlockItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CodeBlockItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CodeBlockItemSyntax) {
  }

  /// Visiting ``CodeBlockSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CodeBlockSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CodeBlockSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CodeBlockSyntax) {
  }

  /// Visiting ``CompositionTypeElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CompositionTypeElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CompositionTypeElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CompositionTypeElementListSyntax) {
  }

  /// Visiting ``CompositionTypeElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CompositionTypeElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CompositionTypeElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CompositionTypeElementSyntax) {
  }

  /// Visiting ``CompositionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CompositionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CompositionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CompositionTypeSyntax) {
  }

  /// Visiting ``ConditionElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConditionElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ConditionElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConditionElementListSyntax) {
  }

  /// Visiting ``ConditionElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConditionElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ConditionElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConditionElementSyntax) {
  }

  /// Visiting ``ConformanceRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConformanceRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ConformanceRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConformanceRequirementSyntax) {
  }

  /// Visiting ``ConsumeExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConsumeExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ConsumeExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConsumeExprSyntax) {
  }

  /// Visiting ``ContinueStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ContinueStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ContinueStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ContinueStmtSyntax) {
  }

  /// Visiting ``CopyExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CopyExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``CopyExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CopyExprSyntax) {
  }

  /// Visiting ``DeclModifierDetailSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclModifierDetailSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclModifierDetailSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclModifierDetailSyntax) {
  }

  /// Visiting ``DeclModifierListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclModifierListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclModifierListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclModifierListSyntax) {
  }

  /// Visiting ``DeclModifierSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclModifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclModifierSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclModifierSyntax) {
  }

  /// Visiting ``DeclNameArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclNameArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclNameArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclNameArgumentListSyntax) {
  }

  /// Visiting ``DeclNameArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclNameArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclNameArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclNameArgumentSyntax) {
  }

  /// Visiting ``DeclNameArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclNameArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclNameArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclNameArgumentsSyntax) {
  }

  /// Visiting ``DeclReferenceExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclReferenceExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeclReferenceExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclReferenceExprSyntax) {
  }

  /// Visiting ``DeferStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeferStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeferStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeferStmtSyntax) {
  }

  /// Visiting ``DeinitializerDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeinitializerDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeinitializerDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeinitializerDeclSyntax) {
  }

  /// Visiting ``DeinitializerEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeinitializerEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DeinitializerEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeinitializerEffectSpecifiersSyntax) {
  }

  /// Visiting ``DerivativeAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DerivativeAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DerivativeAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DerivativeAttributeArgumentsSyntax) {
  }

  /// Visiting ``DesignatedTypeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DesignatedTypeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DesignatedTypeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DesignatedTypeListSyntax) {
  }

  /// Visiting ``DesignatedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DesignatedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DesignatedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DesignatedTypeSyntax) {
  }

  /// Visiting ``DictionaryElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DictionaryElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryElementListSyntax) {
  }

  /// Visiting ``DictionaryElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DictionaryElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryElementSyntax) {
  }

  /// Visiting ``DictionaryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DictionaryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryExprSyntax) {
  }

  /// Visiting ``DictionaryTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DictionaryTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryTypeSyntax) {
  }

  /// Visiting ``DifferentiabilityArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DifferentiabilityArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityArgumentListSyntax) {
  }

  /// Visiting ``DifferentiabilityArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DifferentiabilityArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityArgumentSyntax) {
  }

  /// Visiting ``DifferentiabilityArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DifferentiabilityArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityArgumentsSyntax) {
  }

  /// Visiting ``DifferentiabilityWithRespectToArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityWithRespectToArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DifferentiabilityWithRespectToArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityWithRespectToArgumentSyntax) {
  }

  /// Visiting ``DifferentiableAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiableAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DifferentiableAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiableAttributeArgumentsSyntax) {
  }

  /// Visiting ``DiscardAssignmentExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DiscardAssignmentExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DiscardAssignmentExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DiscardAssignmentExprSyntax) {
  }

  /// Visiting ``DiscardStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DiscardStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DiscardStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DiscardStmtSyntax) {
  }

  /// Visiting `DoExprSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: DoExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `DoExprSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: DoExprSyntax) {
  }

  /// Visiting ``DoStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DoStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DoStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DoStmtSyntax) {
  }

  /// Visiting ``DocumentationAttributeArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DocumentationAttributeArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DocumentationAttributeArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DocumentationAttributeArgumentListSyntax) {
  }

  /// Visiting ``DocumentationAttributeArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DocumentationAttributeArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DocumentationAttributeArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DocumentationAttributeArgumentSyntax) {
  }

  /// Visiting ``DynamicReplacementAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DynamicReplacementAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``DynamicReplacementAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DynamicReplacementAttributeArgumentsSyntax) {
  }

  /// Visiting ``EditorPlaceholderDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EditorPlaceholderDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EditorPlaceholderDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EditorPlaceholderDeclSyntax) {
  }

  /// Visiting ``EditorPlaceholderExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EditorPlaceholderExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EditorPlaceholderExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EditorPlaceholderExprSyntax) {
  }

  /// Visiting ``EffectsAttributeArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EffectsAttributeArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EffectsAttributeArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EffectsAttributeArgumentListSyntax) {
  }

  /// Visiting ``EnumCaseDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumCaseDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseDeclSyntax) {
  }

  /// Visiting ``EnumCaseElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumCaseElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseElementListSyntax) {
  }

  /// Visiting ``EnumCaseElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumCaseElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseElementSyntax) {
  }

  /// Visiting ``EnumCaseParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumCaseParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseParameterClauseSyntax) {
  }

  /// Visiting ``EnumCaseParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumCaseParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseParameterListSyntax) {
  }

  /// Visiting ``EnumCaseParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumCaseParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseParameterSyntax) {
  }

  /// Visiting ``EnumDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``EnumDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumDeclSyntax) {
  }

  /// Visiting ``ExprListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExprListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ExprListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExprListSyntax) {
  }

  /// Visiting ``ExpressionPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExpressionPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ExpressionPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExpressionPatternSyntax) {
  }

  /// Visiting ``ExpressionSegmentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExpressionSegmentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ExpressionSegmentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExpressionSegmentSyntax) {
  }

  /// Visiting ``ExpressionStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExpressionStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ExpressionStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExpressionStmtSyntax) {
  }

  /// Visiting ``ExtensionDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExtensionDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ExtensionDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExtensionDeclSyntax) {
  }

  /// Visiting ``FallThroughStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FallThroughStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FallThroughStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FallThroughStmtSyntax) {
  }

  /// Visiting ``FloatLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FloatLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FloatLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FloatLiteralExprSyntax) {
  }

  /// Visiting ``ForStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ForStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ForStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ForStmtSyntax) {
  }

  /// Visiting ``ForceUnwrapExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ForceUnwrapExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ForceUnwrapExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ForceUnwrapExprSyntax) {
  }

  /// Visiting ``FunctionCallExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionCallExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionCallExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionCallExprSyntax) {
  }

  /// Visiting ``FunctionDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionDeclSyntax) {
  }

  /// Visiting ``FunctionEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionEffectSpecifiersSyntax) {
  }

  /// Visiting ``FunctionParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionParameterClauseSyntax) {
  }

  /// Visiting ``FunctionParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionParameterListSyntax) {
  }

  /// Visiting ``FunctionParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionParameterSyntax) {
  }

  /// Visiting ``FunctionSignatureSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionSignatureSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionSignatureSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionSignatureSyntax) {
  }

  /// Visiting ``FunctionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``FunctionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionTypeSyntax) {
  }

  /// Visiting ``GenericArgumentClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericArgumentClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericArgumentClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericArgumentClauseSyntax) {
  }

  /// Visiting ``GenericArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericArgumentListSyntax) {
  }

  /// Visiting ``GenericArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericArgumentSyntax) {
  }

  /// Visiting ``GenericParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericParameterClauseSyntax) {
  }

  /// Visiting ``GenericParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericParameterListSyntax) {
  }

  /// Visiting ``GenericParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericParameterSyntax) {
  }

  /// Visiting ``GenericRequirementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericRequirementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericRequirementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericRequirementListSyntax) {
  }

  /// Visiting ``GenericRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericRequirementSyntax) {
  }

  /// Visiting ``GenericSpecializationExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericSpecializationExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericSpecializationExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericSpecializationExprSyntax) {
  }

  /// Visiting ``GenericWhereClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericWhereClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GenericWhereClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericWhereClauseSyntax) {
  }

  /// Visiting ``GuardStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GuardStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``GuardStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GuardStmtSyntax) {
  }

  /// Visiting ``IdentifierPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IdentifierPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IdentifierPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IdentifierPatternSyntax) {
  }

  /// Visiting ``IdentifierTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IdentifierTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IdentifierTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IdentifierTypeSyntax) {
  }

  /// Visiting ``IfConfigClauseListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfConfigClauseListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IfConfigClauseListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfConfigClauseListSyntax) {
  }

  /// Visiting ``IfConfigClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfConfigClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IfConfigClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfConfigClauseSyntax) {
  }

  /// Visiting ``IfConfigDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfConfigDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IfConfigDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfConfigDeclSyntax) {
  }

  /// Visiting ``IfExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IfExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfExprSyntax) {
  }

  /// Visiting ``ImplementsAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImplementsAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ImplementsAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImplementsAttributeArgumentsSyntax) {
  }

  /// Visiting ``ImplicitlyUnwrappedOptionalTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImplicitlyUnwrappedOptionalTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ImplicitlyUnwrappedOptionalTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImplicitlyUnwrappedOptionalTypeSyntax) {
  }

  /// Visiting ``ImportDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImportDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ImportDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImportDeclSyntax) {
  }

  /// Visiting ``ImportPathComponentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImportPathComponentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ImportPathComponentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImportPathComponentListSyntax) {
  }

  /// Visiting ``ImportPathComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImportPathComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ImportPathComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImportPathComponentSyntax) {
  }

  /// Visiting ``InOutExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InOutExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InOutExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InOutExprSyntax) {
  }

  /// Visiting ``InfixOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InfixOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InfixOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InfixOperatorExprSyntax) {
  }

  /// Visiting ``InheritanceClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InheritanceClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InheritanceClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InheritanceClauseSyntax) {
  }

  /// Visiting ``InheritedTypeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InheritedTypeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InheritedTypeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InheritedTypeListSyntax) {
  }

  /// Visiting ``InheritedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InheritedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InheritedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InheritedTypeSyntax) {
  }

  /// Visiting ``InitializerClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InitializerClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InitializerClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InitializerClauseSyntax) {
  }

  /// Visiting ``InitializerDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InitializerDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InitializerDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InitializerDeclSyntax) {
  }

  /// Visiting ``InlineArrayTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InlineArrayTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``InlineArrayTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InlineArrayTypeSyntax) {
  }

  /// Visiting ``IntegerLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IntegerLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IntegerLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IntegerLiteralExprSyntax) {
  }

  /// Visiting ``IsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IsExprSyntax) {
  }

  /// Visiting ``IsTypePatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IsTypePatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``IsTypePatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IsTypePatternSyntax) {
  }

  /// Visiting ``KeyPathComponentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathComponentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``KeyPathComponentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathComponentListSyntax) {
  }

  /// Visiting ``KeyPathComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``KeyPathComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathComponentSyntax) {
  }

  /// Visiting ``KeyPathExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``KeyPathExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathExprSyntax) {
  }

  /// Visiting `KeyPathMethodComponentSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: KeyPathMethodComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `KeyPathMethodComponentSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: KeyPathMethodComponentSyntax) {
  }

  /// Visiting ``KeyPathOptionalComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathOptionalComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``KeyPathOptionalComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathOptionalComponentSyntax) {
  }

  /// Visiting ``KeyPathPropertyComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathPropertyComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``KeyPathPropertyComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathPropertyComponentSyntax) {
  }

  /// Visiting ``KeyPathSubscriptComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathSubscriptComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``KeyPathSubscriptComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathSubscriptComponentSyntax) {
  }

  /// Visiting ``LabeledExprListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledExprListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``LabeledExprListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledExprListSyntax) {
  }

  /// Visiting ``LabeledExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``LabeledExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledExprSyntax) {
  }

  /// Visiting ``LabeledSpecializeArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledSpecializeArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``LabeledSpecializeArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledSpecializeArgumentSyntax) {
  }

  /// Visiting ``LabeledStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``LabeledStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledStmtSyntax) {
  }

  /// Visiting ``LayoutRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LayoutRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``LayoutRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LayoutRequirementSyntax) {
  }

  /// Visiting `LifetimeSpecifierArgumentListSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: LifetimeSpecifierArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `LifetimeSpecifierArgumentListSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: LifetimeSpecifierArgumentListSyntax) {
  }

  /// Visiting `LifetimeSpecifierArgumentSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: LifetimeSpecifierArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `LifetimeSpecifierArgumentSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: LifetimeSpecifierArgumentSyntax) {
  }

  /// Visiting `LifetimeTypeSpecifierSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: LifetimeTypeSpecifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `LifetimeTypeSpecifierSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: LifetimeTypeSpecifierSyntax) {
  }

  /// Visiting ``MacroDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MacroDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MacroDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MacroDeclSyntax) {
  }

  /// Visiting ``MacroExpansionDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MacroExpansionDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MacroExpansionDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MacroExpansionDeclSyntax) {
  }

  /// Visiting ``MacroExpansionExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MacroExpansionExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MacroExpansionExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MacroExpansionExprSyntax) {
  }

  /// Visiting ``MatchingPatternConditionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MatchingPatternConditionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MatchingPatternConditionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MatchingPatternConditionSyntax) {
  }

  /// Visiting ``MemberAccessExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberAccessExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MemberAccessExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberAccessExprSyntax) {
  }

  /// Visiting ``MemberBlockItemListFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(Compiler)
  open func visit(_ node: MemberBlockItemListFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MemberBlockItemListFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(Compiler)
  open func visitPost(_ node: MemberBlockItemListFileSyntax) {
  }

  /// Visiting ``MemberBlockItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberBlockItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MemberBlockItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberBlockItemListSyntax) {
  }

  /// Visiting ``MemberBlockItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberBlockItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MemberBlockItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberBlockItemSyntax) {
  }

  /// Visiting ``MemberBlockSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberBlockSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MemberBlockSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberBlockSyntax) {
  }

  /// Visiting ``MemberTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MemberTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberTypeSyntax) {
  }

  /// Visiting ``MetatypeTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MetatypeTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MetatypeTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MetatypeTypeSyntax) {
  }

  /// Visiting ``MissingDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MissingDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingDeclSyntax) {
  }

  /// Visiting ``MissingExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MissingExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingExprSyntax) {
  }

  /// Visiting ``MissingPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MissingPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingPatternSyntax) {
  }

  /// Visiting ``MissingStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MissingStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingStmtSyntax) {
  }

  /// Visiting ``MissingSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MissingSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingSyntax) {
  }

  /// Visiting ``MissingTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MissingTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingTypeSyntax) {
  }

  /// Visiting ``MultipleTrailingClosureElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MultipleTrailingClosureElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MultipleTrailingClosureElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MultipleTrailingClosureElementListSyntax) {
  }

  /// Visiting ``MultipleTrailingClosureElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MultipleTrailingClosureElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``MultipleTrailingClosureElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MultipleTrailingClosureElementSyntax) {
  }

  /// Visiting ``NamedOpaqueReturnTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: NamedOpaqueReturnTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``NamedOpaqueReturnTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: NamedOpaqueReturnTypeSyntax) {
  }

  /// Visiting ``NilLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: NilLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``NilLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: NilLiteralExprSyntax) {
  }

  /// Visiting ``NonisolatedSpecifierArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: NonisolatedSpecifierArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``NonisolatedSpecifierArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: NonisolatedSpecifierArgumentSyntax) {
  }

  /// Visiting ``NonisolatedTypeSpecifierSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: NonisolatedTypeSpecifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``NonisolatedTypeSpecifierSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: NonisolatedTypeSpecifierSyntax) {
  }

  /// Visiting ``ObjCSelectorPieceListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ObjCSelectorPieceListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ObjCSelectorPieceListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ObjCSelectorPieceListSyntax) {
  }

  /// Visiting ``ObjCSelectorPieceSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ObjCSelectorPieceSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ObjCSelectorPieceSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ObjCSelectorPieceSyntax) {
  }

  /// Visiting ``OperatorDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OperatorDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``OperatorDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OperatorDeclSyntax) {
  }

  /// Visiting ``OperatorPrecedenceAndTypesSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OperatorPrecedenceAndTypesSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``OperatorPrecedenceAndTypesSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OperatorPrecedenceAndTypesSyntax) {
  }

  /// Visiting ``OptionalBindingConditionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OptionalBindingConditionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``OptionalBindingConditionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OptionalBindingConditionSyntax) {
  }

  /// Visiting ``OptionalChainingExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OptionalChainingExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``OptionalChainingExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OptionalChainingExprSyntax) {
  }

  /// Visiting ``OptionalTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OptionalTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``OptionalTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OptionalTypeSyntax) {
  }

  /// Visiting ``OriginallyDefinedInAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OriginallyDefinedInAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``OriginallyDefinedInAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OriginallyDefinedInAttributeArgumentsSyntax) {
  }

  /// Visiting ``PackElementExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackElementExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PackElementExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackElementExprSyntax) {
  }

  /// Visiting ``PackElementTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackElementTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PackElementTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackElementTypeSyntax) {
  }

  /// Visiting ``PackExpansionExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackExpansionExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PackExpansionExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackExpansionExprSyntax) {
  }

  /// Visiting ``PackExpansionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackExpansionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PackExpansionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackExpansionTypeSyntax) {
  }

  /// Visiting ``PatternBindingListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PatternBindingListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PatternBindingListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PatternBindingListSyntax) {
  }

  /// Visiting ``PatternBindingSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PatternBindingSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PatternBindingSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PatternBindingSyntax) {
  }

  /// Visiting ``PatternExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PatternExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PatternExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PatternExprSyntax) {
  }

  /// Visiting ``PlatformVersionItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PlatformVersionItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PlatformVersionItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PlatformVersionItemListSyntax) {
  }

  /// Visiting ``PlatformVersionItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PlatformVersionItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PlatformVersionItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PlatformVersionItemSyntax) {
  }

  /// Visiting ``PlatformVersionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PlatformVersionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PlatformVersionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PlatformVersionSyntax) {
  }

  /// Visiting ``PostfixIfConfigExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PostfixIfConfigExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PostfixIfConfigExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PostfixIfConfigExprSyntax) {
  }

  /// Visiting ``PostfixOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PostfixOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PostfixOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PostfixOperatorExprSyntax) {
  }

  /// Visiting ``PoundSourceLocationArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PoundSourceLocationArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PoundSourceLocationArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PoundSourceLocationArgumentsSyntax) {
  }

  /// Visiting ``PoundSourceLocationSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PoundSourceLocationSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PoundSourceLocationSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PoundSourceLocationSyntax) {
  }

  /// Visiting ``PrecedenceGroupAssignmentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupAssignmentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupAssignmentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupAssignmentSyntax) {
  }

  /// Visiting ``PrecedenceGroupAssociativitySyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupAssociativitySyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupAssociativitySyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupAssociativitySyntax) {
  }

  /// Visiting ``PrecedenceGroupAttributeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupAttributeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupAttributeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupAttributeListSyntax) {
  }

  /// Visiting ``PrecedenceGroupDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupDeclSyntax) {
  }

  /// Visiting ``PrecedenceGroupNameListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupNameListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupNameListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupNameListSyntax) {
  }

  /// Visiting ``PrecedenceGroupNameSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupNameSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupNameSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupNameSyntax) {
  }

  /// Visiting ``PrecedenceGroupRelationSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupRelationSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrecedenceGroupRelationSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupRelationSyntax) {
  }

  /// Visiting ``PrefixOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrefixOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrefixOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrefixOperatorExprSyntax) {
  }

  /// Visiting ``PrimaryAssociatedTypeClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrimaryAssociatedTypeClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrimaryAssociatedTypeClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrimaryAssociatedTypeClauseSyntax) {
  }

  /// Visiting ``PrimaryAssociatedTypeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrimaryAssociatedTypeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrimaryAssociatedTypeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrimaryAssociatedTypeListSyntax) {
  }

  /// Visiting ``PrimaryAssociatedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrimaryAssociatedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``PrimaryAssociatedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrimaryAssociatedTypeSyntax) {
  }

  /// Visiting ``ProtocolDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ProtocolDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ProtocolDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ProtocolDeclSyntax) {
  }

  /// Visiting ``RegexLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: RegexLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``RegexLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: RegexLiteralExprSyntax) {
  }

  /// Visiting ``RepeatStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: RepeatStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``RepeatStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: RepeatStmtSyntax) {
  }

  /// Visiting ``ReturnClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ReturnClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ReturnClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ReturnClauseSyntax) {
  }

  /// Visiting ``ReturnStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ReturnStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ReturnStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ReturnStmtSyntax) {
  }

  /// Visiting ``SameTypeRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SameTypeRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SameTypeRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SameTypeRequirementSyntax) {
  }

  /// Visiting ``SequenceExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SequenceExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SequenceExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SequenceExprSyntax) {
  }

  /// Visiting ``SimpleStringLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SimpleStringLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SimpleStringLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SimpleStringLiteralExprSyntax) {
  }

  /// Visiting ``SimpleStringLiteralSegmentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SimpleStringLiteralSegmentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SimpleStringLiteralSegmentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SimpleStringLiteralSegmentListSyntax) {
  }

  /// Visiting ``SimpleTypeSpecifierSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SimpleTypeSpecifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SimpleTypeSpecifierSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SimpleTypeSpecifierSyntax) {
  }

  /// Visiting ``SomeOrAnyTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SomeOrAnyTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SomeOrAnyTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SomeOrAnyTypeSyntax) {
  }

  /// Visiting ``SourceFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SourceFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SourceFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SourceFileSyntax) {
  }

  /// Visiting ``SpecializeAttributeArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializeAttributeArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SpecializeAttributeArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializeAttributeArgumentListSyntax) {
  }

  /// Visiting ``SpecializeAvailabilityArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializeAvailabilityArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SpecializeAvailabilityArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializeAvailabilityArgumentSyntax) {
  }

  /// Visiting ``SpecializeTargetFunctionArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializeTargetFunctionArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SpecializeTargetFunctionArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializeTargetFunctionArgumentSyntax) {
  }

  /// Visiting ``SpecializedAttributeArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializedAttributeArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SpecializedAttributeArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializedAttributeArgumentSyntax) {
  }

  /// Visiting ``StringLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StringLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``StringLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StringLiteralExprSyntax) {
  }

  /// Visiting ``StringLiteralSegmentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StringLiteralSegmentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``StringLiteralSegmentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StringLiteralSegmentListSyntax) {
  }

  /// Visiting ``StringSegmentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StringSegmentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``StringSegmentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StringSegmentSyntax) {
  }

  /// Visiting ``StructDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StructDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``StructDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StructDeclSyntax) {
  }

  /// Visiting ``SubscriptCallExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SubscriptCallExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SubscriptCallExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SubscriptCallExprSyntax) {
  }

  /// Visiting ``SubscriptDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SubscriptDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SubscriptDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SubscriptDeclSyntax) {
  }

  /// Visiting ``SuperExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SuperExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SuperExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SuperExprSyntax) {
  }

  /// Visiting ``SuppressedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SuppressedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SuppressedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SuppressedTypeSyntax) {
  }

  /// Visiting ``SwitchCaseItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchCaseItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseItemListSyntax) {
  }

  /// Visiting ``SwitchCaseItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchCaseItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseItemSyntax) {
  }

  /// Visiting ``SwitchCaseLabelSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseLabelSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchCaseLabelSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseLabelSyntax) {
  }

  /// Visiting ``SwitchCaseListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchCaseListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseListSyntax) {
  }

  /// Visiting ``SwitchCaseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchCaseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseSyntax) {
  }

  /// Visiting ``SwitchDefaultLabelSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchDefaultLabelSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchDefaultLabelSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchDefaultLabelSyntax) {
  }

  /// Visiting ``SwitchExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``SwitchExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchExprSyntax) {
  }

  /// Visiting ``TernaryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TernaryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TernaryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TernaryExprSyntax) {
  }

  /// Visiting `ThenStmtSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: ThenStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `ThenStmtSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: ThenStmtSyntax) {
  }

  /// Visiting ``ThrowStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ThrowStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ThrowStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ThrowStmtSyntax) {
  }

  /// Visiting ``ThrowsClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ThrowsClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ThrowsClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ThrowsClauseSyntax) {
  }

  /// Visiting ``TryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TryExprSyntax) {
  }

  /// Visiting ``TupleExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TupleExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleExprSyntax) {
  }

  /// Visiting ``TuplePatternElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TuplePatternElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TuplePatternElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TuplePatternElementListSyntax) {
  }

  /// Visiting ``TuplePatternElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TuplePatternElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TuplePatternElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TuplePatternElementSyntax) {
  }

  /// Visiting ``TuplePatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TuplePatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TuplePatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TuplePatternSyntax) {
  }

  /// Visiting ``TupleTypeElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleTypeElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TupleTypeElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleTypeElementListSyntax) {
  }

  /// Visiting ``TupleTypeElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleTypeElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TupleTypeElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleTypeElementSyntax) {
  }

  /// Visiting ``TupleTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TupleTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleTypeSyntax) {
  }

  /// Visiting ``TypeAliasDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeAliasDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TypeAliasDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeAliasDeclSyntax) {
  }

  /// Visiting ``TypeAnnotationSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeAnnotationSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TypeAnnotationSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeAnnotationSyntax) {
  }

  /// Visiting ``TypeEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TypeEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeEffectSpecifiersSyntax) {
  }

  /// Visiting ``TypeExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TypeExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeExprSyntax) {
  }

  /// Visiting ``TypeInitializerClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeInitializerClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TypeInitializerClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeInitializerClauseSyntax) {
  }

  /// Visiting ``TypeSpecifierListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeSpecifierListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``TypeSpecifierListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeSpecifierListSyntax) {
  }

  /// Visiting ``UnexpectedNodesSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnexpectedNodesSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``UnexpectedNodesSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnexpectedNodesSyntax) {
  }

  /// Visiting ``UnresolvedAsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnresolvedAsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``UnresolvedAsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnresolvedAsExprSyntax) {
  }

  /// Visiting ``UnresolvedIsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnresolvedIsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``UnresolvedIsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnresolvedIsExprSyntax) {
  }

  /// Visiting ``UnresolvedTernaryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnresolvedTernaryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``UnresolvedTernaryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnresolvedTernaryExprSyntax) {
  }

  /// Visiting ``UnsafeExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnsafeExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``UnsafeExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnsafeExprSyntax) {
  }

  /// Visiting `UsingDeclSyntax` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visit(_ node: UsingDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting `UsingDeclSyntax` and its descendants.
  ///   - node: the node we just finished visiting.
  @_spi(ExperimentalLanguageFeatures)
  open func visitPost(_ node: UsingDeclSyntax) {
  }

  /// Visiting ``ValueBindingPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ValueBindingPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``ValueBindingPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ValueBindingPatternSyntax) {
  }

  /// Visiting ``VariableDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VariableDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``VariableDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VariableDeclSyntax) {
  }

  /// Visiting ``VersionComponentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VersionComponentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``VersionComponentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VersionComponentListSyntax) {
  }

  /// Visiting ``VersionComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VersionComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``VersionComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VersionComponentSyntax) {
  }

  /// Visiting ``VersionTupleSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VersionTupleSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``VersionTupleSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VersionTupleSyntax) {
  }

  /// Visiting ``WhereClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: WhereClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``WhereClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: WhereClauseSyntax) {
  }

  /// Visiting ``WhileStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: WhileStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``WhileStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: WhileStmtSyntax) {
  }

  /// Visiting ``WildcardPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: WildcardPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``WildcardPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: WildcardPatternSyntax) {
  }

  /// Visiting ``YieldStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``YieldStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldStmtSyntax) {
  }

  /// Visiting ``YieldedExpressionListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldedExpressionListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``YieldedExpressionListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldedExpressionListSyntax) {
  }

  /// Visiting ``YieldedExpressionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldedExpressionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``YieldedExpressionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldedExpressionSyntax) {
  }

  /// Visiting ``YieldedExpressionsClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldedExpressionsClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting ``YieldedExpressionsClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldedExpressionsClauseSyntax) {
  }

  /// Visiting ``TokenSyntax`` specifically.
  ///   - Parameter token: the token we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ token: TokenSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }

  /// The function called after visiting the node and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TokenSyntax) {
  }

  @inline(never)
  private func visitTokenSyntaxImpl(_ node: Syntax) {
    _ = visit(TokenSyntax(unsafeCasting: node))
    // No children to visit.
    visitPost(TokenSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitABIAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(ABIAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ABIAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAccessorBlockFileSyntaxImpl(_ node: Syntax) {
    if visit(AccessorBlockFileSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AccessorBlockFileSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAccessorBlockSyntaxImpl(_ node: Syntax) {
    if visit(AccessorBlockSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AccessorBlockSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAccessorDeclListSyntaxImpl(_ node: Syntax) {
    if visit(AccessorDeclListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AccessorDeclListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAccessorDeclSyntaxImpl(_ node: Syntax) {
    if visit(AccessorDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AccessorDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAccessorEffectSpecifiersSyntaxImpl(_ node: Syntax) {
    if visit(AccessorEffectSpecifiersSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AccessorEffectSpecifiersSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAccessorParametersSyntaxImpl(_ node: Syntax) {
    if visit(AccessorParametersSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AccessorParametersSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitActorDeclSyntaxImpl(_ node: Syntax) {
    if visit(ActorDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ActorDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitArrayElementListSyntaxImpl(_ node: Syntax) {
    if visit(ArrayElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ArrayElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitArrayElementSyntaxImpl(_ node: Syntax) {
    if visit(ArrayElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ArrayElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitArrayExprSyntaxImpl(_ node: Syntax) {
    if visit(ArrayExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ArrayExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitArrayTypeSyntaxImpl(_ node: Syntax) {
    if visit(ArrayTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ArrayTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitArrowExprSyntaxImpl(_ node: Syntax) {
    if visit(ArrowExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ArrowExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAsExprSyntaxImpl(_ node: Syntax) {
    if visit(AsExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AsExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAssignmentExprSyntaxImpl(_ node: Syntax) {
    if visit(AssignmentExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AssignmentExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAssociatedTypeDeclSyntaxImpl(_ node: Syntax) {
    if visit(AssociatedTypeDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AssociatedTypeDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAttributeClauseFileSyntaxImpl(_ node: Syntax) {
    if visit(AttributeClauseFileSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AttributeClauseFileSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAttributeListSyntaxImpl(_ node: Syntax) {
    if visit(AttributeListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AttributeListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAttributeSyntaxImpl(_ node: Syntax) {
    if visit(AttributeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AttributeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAttributedTypeSyntaxImpl(_ node: Syntax) {
    if visit(AttributedTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AttributedTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAvailabilityArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(AvailabilityArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AvailabilityArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAvailabilityArgumentSyntaxImpl(_ node: Syntax) {
    if visit(AvailabilityArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AvailabilityArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAvailabilityConditionSyntaxImpl(_ node: Syntax) {
    if visit(AvailabilityConditionSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AvailabilityConditionSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAvailabilityLabeledArgumentSyntaxImpl(_ node: Syntax) {
    if visit(AvailabilityLabeledArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AvailabilityLabeledArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAvailabilityMacroDefinitionFileSyntaxImpl(_ node: Syntax) {
    if visit(AvailabilityMacroDefinitionFileSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AvailabilityMacroDefinitionFileSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitAwaitExprSyntaxImpl(_ node: Syntax) {
    if visit(AwaitExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(AwaitExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitBackDeployedAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(BackDeployedAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(BackDeployedAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitBinaryOperatorExprSyntaxImpl(_ node: Syntax) {
    if visit(BinaryOperatorExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(BinaryOperatorExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitBooleanLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(BooleanLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(BooleanLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitBorrowExprSyntaxImpl(_ node: Syntax) {
    if visit(BorrowExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(BorrowExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitBreakStmtSyntaxImpl(_ node: Syntax) {
    if visit(BreakStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(BreakStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visit_CanImportExprSyntaxImpl(_ node: Syntax) {
    if visit(_CanImportExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(_CanImportExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visit_CanImportVersionInfoSyntaxImpl(_ node: Syntax) {
    if visit(_CanImportVersionInfoSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(_CanImportVersionInfoSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCatchClauseListSyntaxImpl(_ node: Syntax) {
    if visit(CatchClauseListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CatchClauseListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCatchClauseSyntaxImpl(_ node: Syntax) {
    if visit(CatchClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CatchClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCatchItemListSyntaxImpl(_ node: Syntax) {
    if visit(CatchItemListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CatchItemListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCatchItemSyntaxImpl(_ node: Syntax) {
    if visit(CatchItemSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CatchItemSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClassDeclSyntaxImpl(_ node: Syntax) {
    if visit(ClassDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClassDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClassRestrictionTypeSyntaxImpl(_ node: Syntax) {
    if visit(ClassRestrictionTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClassRestrictionTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureCaptureClauseSyntaxImpl(_ node: Syntax) {
    if visit(ClosureCaptureClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureCaptureClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureCaptureListSyntaxImpl(_ node: Syntax) {
    if visit(ClosureCaptureListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureCaptureListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureCaptureSpecifierSyntaxImpl(_ node: Syntax) {
    if visit(ClosureCaptureSpecifierSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureCaptureSpecifierSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureCaptureSyntaxImpl(_ node: Syntax) {
    if visit(ClosureCaptureSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureCaptureSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureExprSyntaxImpl(_ node: Syntax) {
    if visit(ClosureExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureParameterClauseSyntaxImpl(_ node: Syntax) {
    if visit(ClosureParameterClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureParameterClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureParameterListSyntaxImpl(_ node: Syntax) {
    if visit(ClosureParameterListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureParameterListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureParameterSyntaxImpl(_ node: Syntax) {
    if visit(ClosureParameterSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureParameterSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureShorthandParameterListSyntaxImpl(_ node: Syntax) {
    if visit(ClosureShorthandParameterListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureShorthandParameterListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureShorthandParameterSyntaxImpl(_ node: Syntax) {
    if visit(ClosureShorthandParameterSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureShorthandParameterSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitClosureSignatureSyntaxImpl(_ node: Syntax) {
    if visit(ClosureSignatureSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ClosureSignatureSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCodeBlockFileSyntaxImpl(_ node: Syntax) {
    if visit(CodeBlockFileSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CodeBlockFileSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCodeBlockItemListSyntaxImpl(_ node: Syntax) {
    if visit(CodeBlockItemListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CodeBlockItemListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCodeBlockItemSyntaxImpl(_ node: Syntax) {
    if visit(CodeBlockItemSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CodeBlockItemSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCodeBlockSyntaxImpl(_ node: Syntax) {
    if visit(CodeBlockSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CodeBlockSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCompositionTypeElementListSyntaxImpl(_ node: Syntax) {
    if visit(CompositionTypeElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CompositionTypeElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCompositionTypeElementSyntaxImpl(_ node: Syntax) {
    if visit(CompositionTypeElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CompositionTypeElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCompositionTypeSyntaxImpl(_ node: Syntax) {
    if visit(CompositionTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CompositionTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitConditionElementListSyntaxImpl(_ node: Syntax) {
    if visit(ConditionElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ConditionElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitConditionElementSyntaxImpl(_ node: Syntax) {
    if visit(ConditionElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ConditionElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitConformanceRequirementSyntaxImpl(_ node: Syntax) {
    if visit(ConformanceRequirementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ConformanceRequirementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitConsumeExprSyntaxImpl(_ node: Syntax) {
    if visit(ConsumeExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ConsumeExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitContinueStmtSyntaxImpl(_ node: Syntax) {
    if visit(ContinueStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ContinueStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitCopyExprSyntaxImpl(_ node: Syntax) {
    if visit(CopyExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(CopyExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclModifierDetailSyntaxImpl(_ node: Syntax) {
    if visit(DeclModifierDetailSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclModifierDetailSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclModifierListSyntaxImpl(_ node: Syntax) {
    if visit(DeclModifierListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclModifierListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclModifierSyntaxImpl(_ node: Syntax) {
    if visit(DeclModifierSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclModifierSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclNameArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(DeclNameArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclNameArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclNameArgumentSyntaxImpl(_ node: Syntax) {
    if visit(DeclNameArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclNameArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclNameArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(DeclNameArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclNameArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeclReferenceExprSyntaxImpl(_ node: Syntax) {
    if visit(DeclReferenceExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeclReferenceExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeferStmtSyntaxImpl(_ node: Syntax) {
    if visit(DeferStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeferStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeinitializerDeclSyntaxImpl(_ node: Syntax) {
    if visit(DeinitializerDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeinitializerDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDeinitializerEffectSpecifiersSyntaxImpl(_ node: Syntax) {
    if visit(DeinitializerEffectSpecifiersSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DeinitializerEffectSpecifiersSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDerivativeAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(DerivativeAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DerivativeAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDesignatedTypeListSyntaxImpl(_ node: Syntax) {
    if visit(DesignatedTypeListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DesignatedTypeListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDesignatedTypeSyntaxImpl(_ node: Syntax) {
    if visit(DesignatedTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DesignatedTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDictionaryElementListSyntaxImpl(_ node: Syntax) {
    if visit(DictionaryElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DictionaryElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDictionaryElementSyntaxImpl(_ node: Syntax) {
    if visit(DictionaryElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DictionaryElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDictionaryExprSyntaxImpl(_ node: Syntax) {
    if visit(DictionaryExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DictionaryExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDictionaryTypeSyntaxImpl(_ node: Syntax) {
    if visit(DictionaryTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DictionaryTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDifferentiabilityArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(DifferentiabilityArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DifferentiabilityArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDifferentiabilityArgumentSyntaxImpl(_ node: Syntax) {
    if visit(DifferentiabilityArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DifferentiabilityArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDifferentiabilityArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(DifferentiabilityArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DifferentiabilityArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDifferentiabilityWithRespectToArgumentSyntaxImpl(_ node: Syntax) {
    if visit(DifferentiabilityWithRespectToArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DifferentiabilityWithRespectToArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDifferentiableAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(DifferentiableAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DifferentiableAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDiscardAssignmentExprSyntaxImpl(_ node: Syntax) {
    if visit(DiscardAssignmentExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DiscardAssignmentExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDiscardStmtSyntaxImpl(_ node: Syntax) {
    if visit(DiscardStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DiscardStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDoExprSyntaxImpl(_ node: Syntax) {
    if visit(DoExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DoExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDoStmtSyntaxImpl(_ node: Syntax) {
    if visit(DoStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DoStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDocumentationAttributeArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(DocumentationAttributeArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DocumentationAttributeArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDocumentationAttributeArgumentSyntaxImpl(_ node: Syntax) {
    if visit(DocumentationAttributeArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DocumentationAttributeArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitDynamicReplacementAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(DynamicReplacementAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(DynamicReplacementAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEditorPlaceholderDeclSyntaxImpl(_ node: Syntax) {
    if visit(EditorPlaceholderDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EditorPlaceholderDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEditorPlaceholderExprSyntaxImpl(_ node: Syntax) {
    if visit(EditorPlaceholderExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EditorPlaceholderExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEffectsAttributeArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(EffectsAttributeArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EffectsAttributeArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumCaseDeclSyntaxImpl(_ node: Syntax) {
    if visit(EnumCaseDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumCaseDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumCaseElementListSyntaxImpl(_ node: Syntax) {
    if visit(EnumCaseElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumCaseElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumCaseElementSyntaxImpl(_ node: Syntax) {
    if visit(EnumCaseElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumCaseElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumCaseParameterClauseSyntaxImpl(_ node: Syntax) {
    if visit(EnumCaseParameterClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumCaseParameterClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumCaseParameterListSyntaxImpl(_ node: Syntax) {
    if visit(EnumCaseParameterListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumCaseParameterListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumCaseParameterSyntaxImpl(_ node: Syntax) {
    if visit(EnumCaseParameterSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumCaseParameterSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitEnumDeclSyntaxImpl(_ node: Syntax) {
    if visit(EnumDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(EnumDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitExprListSyntaxImpl(_ node: Syntax) {
    if visit(ExprListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ExprListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitExpressionPatternSyntaxImpl(_ node: Syntax) {
    if visit(ExpressionPatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ExpressionPatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitExpressionSegmentSyntaxImpl(_ node: Syntax) {
    if visit(ExpressionSegmentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ExpressionSegmentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitExpressionStmtSyntaxImpl(_ node: Syntax) {
    if visit(ExpressionStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ExpressionStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitExtensionDeclSyntaxImpl(_ node: Syntax) {
    if visit(ExtensionDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ExtensionDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFallThroughStmtSyntaxImpl(_ node: Syntax) {
    if visit(FallThroughStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FallThroughStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFloatLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(FloatLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FloatLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitForStmtSyntaxImpl(_ node: Syntax) {
    if visit(ForStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ForStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitForceUnwrapExprSyntaxImpl(_ node: Syntax) {
    if visit(ForceUnwrapExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ForceUnwrapExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionCallExprSyntaxImpl(_ node: Syntax) {
    if visit(FunctionCallExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionCallExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionDeclSyntaxImpl(_ node: Syntax) {
    if visit(FunctionDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionEffectSpecifiersSyntaxImpl(_ node: Syntax) {
    if visit(FunctionEffectSpecifiersSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionEffectSpecifiersSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionParameterClauseSyntaxImpl(_ node: Syntax) {
    if visit(FunctionParameterClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionParameterClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionParameterListSyntaxImpl(_ node: Syntax) {
    if visit(FunctionParameterListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionParameterListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionParameterSyntaxImpl(_ node: Syntax) {
    if visit(FunctionParameterSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionParameterSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionSignatureSyntaxImpl(_ node: Syntax) {
    if visit(FunctionSignatureSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionSignatureSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitFunctionTypeSyntaxImpl(_ node: Syntax) {
    if visit(FunctionTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(FunctionTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericArgumentClauseSyntaxImpl(_ node: Syntax) {
    if visit(GenericArgumentClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericArgumentClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(GenericArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericArgumentSyntaxImpl(_ node: Syntax) {
    if visit(GenericArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericParameterClauseSyntaxImpl(_ node: Syntax) {
    if visit(GenericParameterClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericParameterClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericParameterListSyntaxImpl(_ node: Syntax) {
    if visit(GenericParameterListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericParameterListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericParameterSyntaxImpl(_ node: Syntax) {
    if visit(GenericParameterSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericParameterSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericRequirementListSyntaxImpl(_ node: Syntax) {
    if visit(GenericRequirementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericRequirementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericRequirementSyntaxImpl(_ node: Syntax) {
    if visit(GenericRequirementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericRequirementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericSpecializationExprSyntaxImpl(_ node: Syntax) {
    if visit(GenericSpecializationExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericSpecializationExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGenericWhereClauseSyntaxImpl(_ node: Syntax) {
    if visit(GenericWhereClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GenericWhereClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitGuardStmtSyntaxImpl(_ node: Syntax) {
    if visit(GuardStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(GuardStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIdentifierPatternSyntaxImpl(_ node: Syntax) {
    if visit(IdentifierPatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IdentifierPatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIdentifierTypeSyntaxImpl(_ node: Syntax) {
    if visit(IdentifierTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IdentifierTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIfConfigClauseListSyntaxImpl(_ node: Syntax) {
    if visit(IfConfigClauseListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IfConfigClauseListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIfConfigClauseSyntaxImpl(_ node: Syntax) {
    if visit(IfConfigClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IfConfigClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIfConfigDeclSyntaxImpl(_ node: Syntax) {
    if visit(IfConfigDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IfConfigDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIfExprSyntaxImpl(_ node: Syntax) {
    if visit(IfExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IfExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitImplementsAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(ImplementsAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ImplementsAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitImplicitlyUnwrappedOptionalTypeSyntaxImpl(_ node: Syntax) {
    if visit(ImplicitlyUnwrappedOptionalTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ImplicitlyUnwrappedOptionalTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitImportDeclSyntaxImpl(_ node: Syntax) {
    if visit(ImportDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ImportDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitImportPathComponentListSyntaxImpl(_ node: Syntax) {
    if visit(ImportPathComponentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ImportPathComponentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitImportPathComponentSyntaxImpl(_ node: Syntax) {
    if visit(ImportPathComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ImportPathComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInOutExprSyntaxImpl(_ node: Syntax) {
    if visit(InOutExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InOutExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInfixOperatorExprSyntaxImpl(_ node: Syntax) {
    if visit(InfixOperatorExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InfixOperatorExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInheritanceClauseSyntaxImpl(_ node: Syntax) {
    if visit(InheritanceClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InheritanceClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInheritedTypeListSyntaxImpl(_ node: Syntax) {
    if visit(InheritedTypeListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InheritedTypeListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInheritedTypeSyntaxImpl(_ node: Syntax) {
    if visit(InheritedTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InheritedTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInitializerClauseSyntaxImpl(_ node: Syntax) {
    if visit(InitializerClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InitializerClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInitializerDeclSyntaxImpl(_ node: Syntax) {
    if visit(InitializerDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InitializerDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitInlineArrayTypeSyntaxImpl(_ node: Syntax) {
    if visit(InlineArrayTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(InlineArrayTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIntegerLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(IntegerLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IntegerLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIsExprSyntaxImpl(_ node: Syntax) {
    if visit(IsExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IsExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitIsTypePatternSyntaxImpl(_ node: Syntax) {
    if visit(IsTypePatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(IsTypePatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathComponentListSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathComponentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathComponentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathComponentSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathExprSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathMethodComponentSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathMethodComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathMethodComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathOptionalComponentSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathOptionalComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathOptionalComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathPropertyComponentSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathPropertyComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathPropertyComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitKeyPathSubscriptComponentSyntaxImpl(_ node: Syntax) {
    if visit(KeyPathSubscriptComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(KeyPathSubscriptComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLabeledExprListSyntaxImpl(_ node: Syntax) {
    if visit(LabeledExprListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LabeledExprListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLabeledExprSyntaxImpl(_ node: Syntax) {
    if visit(LabeledExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LabeledExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLabeledSpecializeArgumentSyntaxImpl(_ node: Syntax) {
    if visit(LabeledSpecializeArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LabeledSpecializeArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLabeledStmtSyntaxImpl(_ node: Syntax) {
    if visit(LabeledStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LabeledStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLayoutRequirementSyntaxImpl(_ node: Syntax) {
    if visit(LayoutRequirementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LayoutRequirementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLifetimeSpecifierArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(LifetimeSpecifierArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LifetimeSpecifierArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLifetimeSpecifierArgumentSyntaxImpl(_ node: Syntax) {
    if visit(LifetimeSpecifierArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LifetimeSpecifierArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitLifetimeTypeSpecifierSyntaxImpl(_ node: Syntax) {
    if visit(LifetimeTypeSpecifierSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(LifetimeTypeSpecifierSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMacroDeclSyntaxImpl(_ node: Syntax) {
    if visit(MacroDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MacroDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMacroExpansionDeclSyntaxImpl(_ node: Syntax) {
    if visit(MacroExpansionDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MacroExpansionDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMacroExpansionExprSyntaxImpl(_ node: Syntax) {
    if visit(MacroExpansionExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MacroExpansionExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMatchingPatternConditionSyntaxImpl(_ node: Syntax) {
    if visit(MatchingPatternConditionSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MatchingPatternConditionSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMemberAccessExprSyntaxImpl(_ node: Syntax) {
    if visit(MemberAccessExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MemberAccessExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMemberBlockItemListFileSyntaxImpl(_ node: Syntax) {
    if visit(MemberBlockItemListFileSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MemberBlockItemListFileSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMemberBlockItemListSyntaxImpl(_ node: Syntax) {
    if visit(MemberBlockItemListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MemberBlockItemListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMemberBlockItemSyntaxImpl(_ node: Syntax) {
    if visit(MemberBlockItemSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MemberBlockItemSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMemberBlockSyntaxImpl(_ node: Syntax) {
    if visit(MemberBlockSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MemberBlockSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMemberTypeSyntaxImpl(_ node: Syntax) {
    if visit(MemberTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MemberTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMetatypeTypeSyntaxImpl(_ node: Syntax) {
    if visit(MetatypeTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MetatypeTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMissingDeclSyntaxImpl(_ node: Syntax) {
    if visit(MissingDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MissingDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMissingExprSyntaxImpl(_ node: Syntax) {
    if visit(MissingExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MissingExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMissingPatternSyntaxImpl(_ node: Syntax) {
    if visit(MissingPatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MissingPatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMissingStmtSyntaxImpl(_ node: Syntax) {
    if visit(MissingStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MissingStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMissingSyntaxImpl(_ node: Syntax) {
    if visit(MissingSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MissingSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMissingTypeSyntaxImpl(_ node: Syntax) {
    if visit(MissingTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MissingTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMultipleTrailingClosureElementListSyntaxImpl(_ node: Syntax) {
    if visit(MultipleTrailingClosureElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MultipleTrailingClosureElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitMultipleTrailingClosureElementSyntaxImpl(_ node: Syntax) {
    if visit(MultipleTrailingClosureElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(MultipleTrailingClosureElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitNamedOpaqueReturnTypeSyntaxImpl(_ node: Syntax) {
    if visit(NamedOpaqueReturnTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(NamedOpaqueReturnTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitNilLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(NilLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(NilLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitNonisolatedSpecifierArgumentSyntaxImpl(_ node: Syntax) {
    if visit(NonisolatedSpecifierArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(NonisolatedSpecifierArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitNonisolatedTypeSpecifierSyntaxImpl(_ node: Syntax) {
    if visit(NonisolatedTypeSpecifierSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(NonisolatedTypeSpecifierSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitObjCSelectorPieceListSyntaxImpl(_ node: Syntax) {
    if visit(ObjCSelectorPieceListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ObjCSelectorPieceListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitObjCSelectorPieceSyntaxImpl(_ node: Syntax) {
    if visit(ObjCSelectorPieceSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ObjCSelectorPieceSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitOperatorDeclSyntaxImpl(_ node: Syntax) {
    if visit(OperatorDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(OperatorDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitOperatorPrecedenceAndTypesSyntaxImpl(_ node: Syntax) {
    if visit(OperatorPrecedenceAndTypesSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(OperatorPrecedenceAndTypesSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitOptionalBindingConditionSyntaxImpl(_ node: Syntax) {
    if visit(OptionalBindingConditionSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(OptionalBindingConditionSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitOptionalChainingExprSyntaxImpl(_ node: Syntax) {
    if visit(OptionalChainingExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(OptionalChainingExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitOptionalTypeSyntaxImpl(_ node: Syntax) {
    if visit(OptionalTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(OptionalTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitOriginallyDefinedInAttributeArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(OriginallyDefinedInAttributeArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(OriginallyDefinedInAttributeArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPackElementExprSyntaxImpl(_ node: Syntax) {
    if visit(PackElementExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PackElementExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPackElementTypeSyntaxImpl(_ node: Syntax) {
    if visit(PackElementTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PackElementTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPackExpansionExprSyntaxImpl(_ node: Syntax) {
    if visit(PackExpansionExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PackExpansionExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPackExpansionTypeSyntaxImpl(_ node: Syntax) {
    if visit(PackExpansionTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PackExpansionTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPatternBindingListSyntaxImpl(_ node: Syntax) {
    if visit(PatternBindingListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PatternBindingListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPatternBindingSyntaxImpl(_ node: Syntax) {
    if visit(PatternBindingSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PatternBindingSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPatternExprSyntaxImpl(_ node: Syntax) {
    if visit(PatternExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PatternExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPlatformVersionItemListSyntaxImpl(_ node: Syntax) {
    if visit(PlatformVersionItemListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PlatformVersionItemListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPlatformVersionItemSyntaxImpl(_ node: Syntax) {
    if visit(PlatformVersionItemSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PlatformVersionItemSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPlatformVersionSyntaxImpl(_ node: Syntax) {
    if visit(PlatformVersionSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PlatformVersionSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPostfixIfConfigExprSyntaxImpl(_ node: Syntax) {
    if visit(PostfixIfConfigExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PostfixIfConfigExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPostfixOperatorExprSyntaxImpl(_ node: Syntax) {
    if visit(PostfixOperatorExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PostfixOperatorExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPoundSourceLocationArgumentsSyntaxImpl(_ node: Syntax) {
    if visit(PoundSourceLocationArgumentsSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PoundSourceLocationArgumentsSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPoundSourceLocationSyntaxImpl(_ node: Syntax) {
    if visit(PoundSourceLocationSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PoundSourceLocationSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupAssignmentSyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupAssignmentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupAssignmentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupAssociativitySyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupAssociativitySyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupAssociativitySyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupAttributeListSyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupAttributeListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupAttributeListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupDeclSyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupNameListSyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupNameListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupNameListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupNameSyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupNameSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupNameSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrecedenceGroupRelationSyntaxImpl(_ node: Syntax) {
    if visit(PrecedenceGroupRelationSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrecedenceGroupRelationSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrefixOperatorExprSyntaxImpl(_ node: Syntax) {
    if visit(PrefixOperatorExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrefixOperatorExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrimaryAssociatedTypeClauseSyntaxImpl(_ node: Syntax) {
    if visit(PrimaryAssociatedTypeClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrimaryAssociatedTypeClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrimaryAssociatedTypeListSyntaxImpl(_ node: Syntax) {
    if visit(PrimaryAssociatedTypeListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrimaryAssociatedTypeListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitPrimaryAssociatedTypeSyntaxImpl(_ node: Syntax) {
    if visit(PrimaryAssociatedTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(PrimaryAssociatedTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitProtocolDeclSyntaxImpl(_ node: Syntax) {
    if visit(ProtocolDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ProtocolDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitRegexLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(RegexLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(RegexLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitRepeatStmtSyntaxImpl(_ node: Syntax) {
    if visit(RepeatStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(RepeatStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitReturnClauseSyntaxImpl(_ node: Syntax) {
    if visit(ReturnClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ReturnClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitReturnStmtSyntaxImpl(_ node: Syntax) {
    if visit(ReturnStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ReturnStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSameTypeRequirementSyntaxImpl(_ node: Syntax) {
    if visit(SameTypeRequirementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SameTypeRequirementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSequenceExprSyntaxImpl(_ node: Syntax) {
    if visit(SequenceExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SequenceExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSimpleStringLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(SimpleStringLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SimpleStringLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSimpleStringLiteralSegmentListSyntaxImpl(_ node: Syntax) {
    if visit(SimpleStringLiteralSegmentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SimpleStringLiteralSegmentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSimpleTypeSpecifierSyntaxImpl(_ node: Syntax) {
    if visit(SimpleTypeSpecifierSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SimpleTypeSpecifierSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSomeOrAnyTypeSyntaxImpl(_ node: Syntax) {
    if visit(SomeOrAnyTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SomeOrAnyTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSourceFileSyntaxImpl(_ node: Syntax) {
    if visit(SourceFileSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SourceFileSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSpecializeAttributeArgumentListSyntaxImpl(_ node: Syntax) {
    if visit(SpecializeAttributeArgumentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SpecializeAttributeArgumentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSpecializeAvailabilityArgumentSyntaxImpl(_ node: Syntax) {
    if visit(SpecializeAvailabilityArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SpecializeAvailabilityArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSpecializeTargetFunctionArgumentSyntaxImpl(_ node: Syntax) {
    if visit(SpecializeTargetFunctionArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SpecializeTargetFunctionArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSpecializedAttributeArgumentSyntaxImpl(_ node: Syntax) {
    if visit(SpecializedAttributeArgumentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SpecializedAttributeArgumentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitStringLiteralExprSyntaxImpl(_ node: Syntax) {
    if visit(StringLiteralExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(StringLiteralExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitStringLiteralSegmentListSyntaxImpl(_ node: Syntax) {
    if visit(StringLiteralSegmentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(StringLiteralSegmentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitStringSegmentSyntaxImpl(_ node: Syntax) {
    if visit(StringSegmentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(StringSegmentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitStructDeclSyntaxImpl(_ node: Syntax) {
    if visit(StructDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(StructDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSubscriptCallExprSyntaxImpl(_ node: Syntax) {
    if visit(SubscriptCallExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SubscriptCallExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSubscriptDeclSyntaxImpl(_ node: Syntax) {
    if visit(SubscriptDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SubscriptDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSuperExprSyntaxImpl(_ node: Syntax) {
    if visit(SuperExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SuperExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSuppressedTypeSyntaxImpl(_ node: Syntax) {
    if visit(SuppressedTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SuppressedTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchCaseItemListSyntaxImpl(_ node: Syntax) {
    if visit(SwitchCaseItemListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchCaseItemListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchCaseItemSyntaxImpl(_ node: Syntax) {
    if visit(SwitchCaseItemSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchCaseItemSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchCaseLabelSyntaxImpl(_ node: Syntax) {
    if visit(SwitchCaseLabelSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchCaseLabelSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchCaseListSyntaxImpl(_ node: Syntax) {
    if visit(SwitchCaseListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchCaseListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchCaseSyntaxImpl(_ node: Syntax) {
    if visit(SwitchCaseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchCaseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchDefaultLabelSyntaxImpl(_ node: Syntax) {
    if visit(SwitchDefaultLabelSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchDefaultLabelSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitSwitchExprSyntaxImpl(_ node: Syntax) {
    if visit(SwitchExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(SwitchExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTernaryExprSyntaxImpl(_ node: Syntax) {
    if visit(TernaryExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TernaryExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitThenStmtSyntaxImpl(_ node: Syntax) {
    if visit(ThenStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ThenStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitThrowStmtSyntaxImpl(_ node: Syntax) {
    if visit(ThrowStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ThrowStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitThrowsClauseSyntaxImpl(_ node: Syntax) {
    if visit(ThrowsClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ThrowsClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTryExprSyntaxImpl(_ node: Syntax) {
    if visit(TryExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TryExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTupleExprSyntaxImpl(_ node: Syntax) {
    if visit(TupleExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TupleExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTuplePatternElementListSyntaxImpl(_ node: Syntax) {
    if visit(TuplePatternElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TuplePatternElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTuplePatternElementSyntaxImpl(_ node: Syntax) {
    if visit(TuplePatternElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TuplePatternElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTuplePatternSyntaxImpl(_ node: Syntax) {
    if visit(TuplePatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TuplePatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTupleTypeElementListSyntaxImpl(_ node: Syntax) {
    if visit(TupleTypeElementListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TupleTypeElementListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTupleTypeElementSyntaxImpl(_ node: Syntax) {
    if visit(TupleTypeElementSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TupleTypeElementSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTupleTypeSyntaxImpl(_ node: Syntax) {
    if visit(TupleTypeSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TupleTypeSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTypeAliasDeclSyntaxImpl(_ node: Syntax) {
    if visit(TypeAliasDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TypeAliasDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTypeAnnotationSyntaxImpl(_ node: Syntax) {
    if visit(TypeAnnotationSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TypeAnnotationSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTypeEffectSpecifiersSyntaxImpl(_ node: Syntax) {
    if visit(TypeEffectSpecifiersSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TypeEffectSpecifiersSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTypeExprSyntaxImpl(_ node: Syntax) {
    if visit(TypeExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TypeExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTypeInitializerClauseSyntaxImpl(_ node: Syntax) {
    if visit(TypeInitializerClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TypeInitializerClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitTypeSpecifierListSyntaxImpl(_ node: Syntax) {
    if visit(TypeSpecifierListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(TypeSpecifierListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitUnexpectedNodesSyntaxImpl(_ node: Syntax) {
    if visit(UnexpectedNodesSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(UnexpectedNodesSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitUnresolvedAsExprSyntaxImpl(_ node: Syntax) {
    if visit(UnresolvedAsExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(UnresolvedAsExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitUnresolvedIsExprSyntaxImpl(_ node: Syntax) {
    if visit(UnresolvedIsExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(UnresolvedIsExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitUnresolvedTernaryExprSyntaxImpl(_ node: Syntax) {
    if visit(UnresolvedTernaryExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(UnresolvedTernaryExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitUnsafeExprSyntaxImpl(_ node: Syntax) {
    if visit(UnsafeExprSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(UnsafeExprSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitUsingDeclSyntaxImpl(_ node: Syntax) {
    if visit(UsingDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(UsingDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitValueBindingPatternSyntaxImpl(_ node: Syntax) {
    if visit(ValueBindingPatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(ValueBindingPatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitVariableDeclSyntaxImpl(_ node: Syntax) {
    if visit(VariableDeclSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(VariableDeclSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitVersionComponentListSyntaxImpl(_ node: Syntax) {
    if visit(VersionComponentListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(VersionComponentListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitVersionComponentSyntaxImpl(_ node: Syntax) {
    if visit(VersionComponentSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(VersionComponentSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitVersionTupleSyntaxImpl(_ node: Syntax) {
    if visit(VersionTupleSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(VersionTupleSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitWhereClauseSyntaxImpl(_ node: Syntax) {
    if visit(WhereClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(WhereClauseSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitWhileStmtSyntaxImpl(_ node: Syntax) {
    if visit(WhileStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(WhileStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitWildcardPatternSyntaxImpl(_ node: Syntax) {
    if visit(WildcardPatternSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(WildcardPatternSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitYieldStmtSyntaxImpl(_ node: Syntax) {
    if visit(YieldStmtSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(YieldStmtSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitYieldedExpressionListSyntaxImpl(_ node: Syntax) {
    if visit(YieldedExpressionListSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(YieldedExpressionListSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitYieldedExpressionSyntaxImpl(_ node: Syntax) {
    if visit(YieldedExpressionSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(YieldedExpressionSyntax(unsafeCasting: node))
  }

  @inline(never)
  private func visitYieldedExpressionsClauseSyntaxImpl(_ node: Syntax) {
    if visit(YieldedExpressionsClauseSyntax(unsafeCasting: node)) == .visitChildren {
      visitChildren(node)
    }
    visitPost(YieldedExpressionsClauseSyntax(unsafeCasting: node))
  }

  // SwiftSyntax requires a lot of stack space in debug builds for syntax tree
  // visitation. In scenarios with reduced stack space (in particular dispatch
  // queues), this easily results in a stack overflow. To work around this issue,
  // use a less performant but also less stack-hungry version of SwiftSyntax's
  // SyntaxVisitor in debug builds.
  #if DEBUG
  /// Implementation detail of visit(_:). Do not call directly.
  ///
  /// Returns the function that shall be called to visit a specific syntax node.
  ///
  /// To determine the correct specific visitation function for a syntax node,
  /// we need to switch through a huge switch statement that covers all syntax
  /// types. In debug builds, the cases of this switch statement do not share
  /// stack space (rdar://55929175). Because of this, the switch statement
  /// requires about 15KB of stack space. In scenarios with reduced
  /// stack size (in particular dispatch queues), this often results in a stack
  /// overflow during syntax tree rewriting.
  ///
  /// To circumvent this problem, make calling the specific visitation function
  /// a two-step process: First determine the function to call in this function
  /// and return a reference to it, then call it. This way, the stack frame
  /// that determines the correct visitation function will be popped of the
  /// stack before the function is being called, making the switch's stack
  /// space transient instead of having it linger in the call stack.
  private func visitationFunc(for node: Syntax) -> (Syntax) -> Void {
    switch node.raw.kind {
    case .token:
      return self.visitTokenSyntaxImpl(_:)
    case .abiAttributeArguments:
      return self.visitABIAttributeArgumentsSyntaxImpl(_:)
    case .accessorBlockFile:
      return self.visitAccessorBlockFileSyntaxImpl(_:)
    case .accessorBlock:
      return self.visitAccessorBlockSyntaxImpl(_:)
    case .accessorDeclList:
      return self.visitAccessorDeclListSyntaxImpl(_:)
    case .accessorDecl:
      return self.visitAccessorDeclSyntaxImpl(_:)
    case .accessorEffectSpecifiers:
      return self.visitAccessorEffectSpecifiersSyntaxImpl(_:)
    case .accessorParameters:
      return self.visitAccessorParametersSyntaxImpl(_:)
    case .actorDecl:
      return self.visitActorDeclSyntaxImpl(_:)
    case .arrayElementList:
      return self.visitArrayElementListSyntaxImpl(_:)
    case .arrayElement:
      return self.visitArrayElementSyntaxImpl(_:)
    case .arrayExpr:
      return self.visitArrayExprSyntaxImpl(_:)
    case .arrayType:
      return self.visitArrayTypeSyntaxImpl(_:)
    case .arrowExpr:
      return self.visitArrowExprSyntaxImpl(_:)
    case .asExpr:
      return self.visitAsExprSyntaxImpl(_:)
    case .assignmentExpr:
      return self.visitAssignmentExprSyntaxImpl(_:)
    case .associatedTypeDecl:
      return self.visitAssociatedTypeDeclSyntaxImpl(_:)
    case .attributeClauseFile:
      return self.visitAttributeClauseFileSyntaxImpl(_:)
    case .attributeList:
      return self.visitAttributeListSyntaxImpl(_:)
    case .attribute:
      return self.visitAttributeSyntaxImpl(_:)
    case .attributedType:
      return self.visitAttributedTypeSyntaxImpl(_:)
    case .availabilityArgumentList:
      return self.visitAvailabilityArgumentListSyntaxImpl(_:)
    case .availabilityArgument:
      return self.visitAvailabilityArgumentSyntaxImpl(_:)
    case .availabilityCondition:
      return self.visitAvailabilityConditionSyntaxImpl(_:)
    case .availabilityLabeledArgument:
      return self.visitAvailabilityLabeledArgumentSyntaxImpl(_:)
    case .availabilityMacroDefinitionFile:
      return self.visitAvailabilityMacroDefinitionFileSyntaxImpl(_:)
    case .awaitExpr:
      return self.visitAwaitExprSyntaxImpl(_:)
    case .backDeployedAttributeArguments:
      return self.visitBackDeployedAttributeArgumentsSyntaxImpl(_:)
    case .binaryOperatorExpr:
      return self.visitBinaryOperatorExprSyntaxImpl(_:)
    case .booleanLiteralExpr:
      return self.visitBooleanLiteralExprSyntaxImpl(_:)
    case .borrowExpr:
      return self.visitBorrowExprSyntaxImpl(_:)
    case .breakStmt:
      return self.visitBreakStmtSyntaxImpl(_:)
    case ._canImportExpr:
      return self.visit_CanImportExprSyntaxImpl(_:)
    case ._canImportVersionInfo:
      return self.visit_CanImportVersionInfoSyntaxImpl(_:)
    case .catchClauseList:
      return self.visitCatchClauseListSyntaxImpl(_:)
    case .catchClause:
      return self.visitCatchClauseSyntaxImpl(_:)
    case .catchItemList:
      return self.visitCatchItemListSyntaxImpl(_:)
    case .catchItem:
      return self.visitCatchItemSyntaxImpl(_:)
    case .classDecl:
      return self.visitClassDeclSyntaxImpl(_:)
    case .classRestrictionType:
      return self.visitClassRestrictionTypeSyntaxImpl(_:)
    case .closureCaptureClause:
      return self.visitClosureCaptureClauseSyntaxImpl(_:)
    case .closureCaptureList:
      return self.visitClosureCaptureListSyntaxImpl(_:)
    case .closureCaptureSpecifier:
      return self.visitClosureCaptureSpecifierSyntaxImpl(_:)
    case .closureCapture:
      return self.visitClosureCaptureSyntaxImpl(_:)
    case .closureExpr:
      return self.visitClosureExprSyntaxImpl(_:)
    case .closureParameterClause:
      return self.visitClosureParameterClauseSyntaxImpl(_:)
    case .closureParameterList:
      return self.visitClosureParameterListSyntaxImpl(_:)
    case .closureParameter:
      return self.visitClosureParameterSyntaxImpl(_:)
    case .closureShorthandParameterList:
      return self.visitClosureShorthandParameterListSyntaxImpl(_:)
    case .closureShorthandParameter:
      return self.visitClosureShorthandParameterSyntaxImpl(_:)
    case .closureSignature:
      return self.visitClosureSignatureSyntaxImpl(_:)
    case .codeBlockFile:
      return self.visitCodeBlockFileSyntaxImpl(_:)
    case .codeBlockItemList:
      return self.visitCodeBlockItemListSyntaxImpl(_:)
    case .codeBlockItem:
      return self.visitCodeBlockItemSyntaxImpl(_:)
    case .codeBlock:
      return self.visitCodeBlockSyntaxImpl(_:)
    case .compositionTypeElementList:
      return self.visitCompositionTypeElementListSyntaxImpl(_:)
    case .compositionTypeElement:
      return self.visitCompositionTypeElementSyntaxImpl(_:)
    case .compositionType:
      return self.visitCompositionTypeSyntaxImpl(_:)
    case .conditionElementList:
      return self.visitConditionElementListSyntaxImpl(_:)
    case .conditionElement:
      return self.visitConditionElementSyntaxImpl(_:)
    case .conformanceRequirement:
      return self.visitConformanceRequirementSyntaxImpl(_:)
    case .consumeExpr:
      return self.visitConsumeExprSyntaxImpl(_:)
    case .continueStmt:
      return self.visitContinueStmtSyntaxImpl(_:)
    case .copyExpr:
      return self.visitCopyExprSyntaxImpl(_:)
    case .declModifierDetail:
      return self.visitDeclModifierDetailSyntaxImpl(_:)
    case .declModifierList:
      return self.visitDeclModifierListSyntaxImpl(_:)
    case .declModifier:
      return self.visitDeclModifierSyntaxImpl(_:)
    case .declNameArgumentList:
      return self.visitDeclNameArgumentListSyntaxImpl(_:)
    case .declNameArgument:
      return self.visitDeclNameArgumentSyntaxImpl(_:)
    case .declNameArguments:
      return self.visitDeclNameArgumentsSyntaxImpl(_:)
    case .declReferenceExpr:
      return self.visitDeclReferenceExprSyntaxImpl(_:)
    case .deferStmt:
      return self.visitDeferStmtSyntaxImpl(_:)
    case .deinitializerDecl:
      return self.visitDeinitializerDeclSyntaxImpl(_:)
    case .deinitializerEffectSpecifiers:
      return self.visitDeinitializerEffectSpecifiersSyntaxImpl(_:)
    case .derivativeAttributeArguments:
      return self.visitDerivativeAttributeArgumentsSyntaxImpl(_:)
    case .designatedTypeList:
      return self.visitDesignatedTypeListSyntaxImpl(_:)
    case .designatedType:
      return self.visitDesignatedTypeSyntaxImpl(_:)
    case .dictionaryElementList:
      return self.visitDictionaryElementListSyntaxImpl(_:)
    case .dictionaryElement:
      return self.visitDictionaryElementSyntaxImpl(_:)
    case .dictionaryExpr:
      return self.visitDictionaryExprSyntaxImpl(_:)
    case .dictionaryType:
      return self.visitDictionaryTypeSyntaxImpl(_:)
    case .differentiabilityArgumentList:
      return self.visitDifferentiabilityArgumentListSyntaxImpl(_:)
    case .differentiabilityArgument:
      return self.visitDifferentiabilityArgumentSyntaxImpl(_:)
    case .differentiabilityArguments:
      return self.visitDifferentiabilityArgumentsSyntaxImpl(_:)
    case .differentiabilityWithRespectToArgument:
      return self.visitDifferentiabilityWithRespectToArgumentSyntaxImpl(_:)
    case .differentiableAttributeArguments:
      return self.visitDifferentiableAttributeArgumentsSyntaxImpl(_:)
    case .discardAssignmentExpr:
      return self.visitDiscardAssignmentExprSyntaxImpl(_:)
    case .discardStmt:
      return self.visitDiscardStmtSyntaxImpl(_:)
    case .doExpr:
      return self.visitDoExprSyntaxImpl(_:)
    case .doStmt:
      return self.visitDoStmtSyntaxImpl(_:)
    case .documentationAttributeArgumentList:
      return self.visitDocumentationAttributeArgumentListSyntaxImpl(_:)
    case .documentationAttributeArgument:
      return self.visitDocumentationAttributeArgumentSyntaxImpl(_:)
    case .dynamicReplacementAttributeArguments:
      return self.visitDynamicReplacementAttributeArgumentsSyntaxImpl(_:)
    case .editorPlaceholderDecl:
      return self.visitEditorPlaceholderDeclSyntaxImpl(_:)
    case .editorPlaceholderExpr:
      return self.visitEditorPlaceholderExprSyntaxImpl(_:)
    case .effectsAttributeArgumentList:
      return self.visitEffectsAttributeArgumentListSyntaxImpl(_:)
    case .enumCaseDecl:
      return self.visitEnumCaseDeclSyntaxImpl(_:)
    case .enumCaseElementList:
      return self.visitEnumCaseElementListSyntaxImpl(_:)
    case .enumCaseElement:
      return self.visitEnumCaseElementSyntaxImpl(_:)
    case .enumCaseParameterClause:
      return self.visitEnumCaseParameterClauseSyntaxImpl(_:)
    case .enumCaseParameterList:
      return self.visitEnumCaseParameterListSyntaxImpl(_:)
    case .enumCaseParameter:
      return self.visitEnumCaseParameterSyntaxImpl(_:)
    case .enumDecl:
      return self.visitEnumDeclSyntaxImpl(_:)
    case .exprList:
      return self.visitExprListSyntaxImpl(_:)
    case .expressionPattern:
      return self.visitExpressionPatternSyntaxImpl(_:)
    case .expressionSegment:
      return self.visitExpressionSegmentSyntaxImpl(_:)
    case .expressionStmt:
      return self.visitExpressionStmtSyntaxImpl(_:)
    case .extensionDecl:
      return self.visitExtensionDeclSyntaxImpl(_:)
    case .fallThroughStmt:
      return self.visitFallThroughStmtSyntaxImpl(_:)
    case .floatLiteralExpr:
      return self.visitFloatLiteralExprSyntaxImpl(_:)
    case .forStmt:
      return self.visitForStmtSyntaxImpl(_:)
    case .forceUnwrapExpr:
      return self.visitForceUnwrapExprSyntaxImpl(_:)
    case .functionCallExpr:
      return self.visitFunctionCallExprSyntaxImpl(_:)
    case .functionDecl:
      return self.visitFunctionDeclSyntaxImpl(_:)
    case .functionEffectSpecifiers:
      return self.visitFunctionEffectSpecifiersSyntaxImpl(_:)
    case .functionParameterClause:
      return self.visitFunctionParameterClauseSyntaxImpl(_:)
    case .functionParameterList:
      return self.visitFunctionParameterListSyntaxImpl(_:)
    case .functionParameter:
      return self.visitFunctionParameterSyntaxImpl(_:)
    case .functionSignature:
      return self.visitFunctionSignatureSyntaxImpl(_:)
    case .functionType:
      return self.visitFunctionTypeSyntaxImpl(_:)
    case .genericArgumentClause:
      return self.visitGenericArgumentClauseSyntaxImpl(_:)
    case .genericArgumentList:
      return self.visitGenericArgumentListSyntaxImpl(_:)
    case .genericArgument:
      return self.visitGenericArgumentSyntaxImpl(_:)
    case .genericParameterClause:
      return self.visitGenericParameterClauseSyntaxImpl(_:)
    case .genericParameterList:
      return self.visitGenericParameterListSyntaxImpl(_:)
    case .genericParameter:
      return self.visitGenericParameterSyntaxImpl(_:)
    case .genericRequirementList:
      return self.visitGenericRequirementListSyntaxImpl(_:)
    case .genericRequirement:
      return self.visitGenericRequirementSyntaxImpl(_:)
    case .genericSpecializationExpr:
      return self.visitGenericSpecializationExprSyntaxImpl(_:)
    case .genericWhereClause:
      return self.visitGenericWhereClauseSyntaxImpl(_:)
    case .guardStmt:
      return self.visitGuardStmtSyntaxImpl(_:)
    case .identifierPattern:
      return self.visitIdentifierPatternSyntaxImpl(_:)
    case .identifierType:
      return self.visitIdentifierTypeSyntaxImpl(_:)
    case .ifConfigClauseList:
      return self.visitIfConfigClauseListSyntaxImpl(_:)
    case .ifConfigClause:
      return self.visitIfConfigClauseSyntaxImpl(_:)
    case .ifConfigDecl:
      return self.visitIfConfigDeclSyntaxImpl(_:)
    case .ifExpr:
      return self.visitIfExprSyntaxImpl(_:)
    case .implementsAttributeArguments:
      return self.visitImplementsAttributeArgumentsSyntaxImpl(_:)
    case .implicitlyUnwrappedOptionalType:
      return self.visitImplicitlyUnwrappedOptionalTypeSyntaxImpl(_:)
    case .importDecl:
      return self.visitImportDeclSyntaxImpl(_:)
    case .importPathComponentList:
      return self.visitImportPathComponentListSyntaxImpl(_:)
    case .importPathComponent:
      return self.visitImportPathComponentSyntaxImpl(_:)
    case .inOutExpr:
      return self.visitInOutExprSyntaxImpl(_:)
    case .infixOperatorExpr:
      return self.visitInfixOperatorExprSyntaxImpl(_:)
    case .inheritanceClause:
      return self.visitInheritanceClauseSyntaxImpl(_:)
    case .inheritedTypeList:
      return self.visitInheritedTypeListSyntaxImpl(_:)
    case .inheritedType:
      return self.visitInheritedTypeSyntaxImpl(_:)
    case .initializerClause:
      return self.visitInitializerClauseSyntaxImpl(_:)
    case .initializerDecl:
      return self.visitInitializerDeclSyntaxImpl(_:)
    case .inlineArrayType:
      return self.visitInlineArrayTypeSyntaxImpl(_:)
    case .integerLiteralExpr:
      return self.visitIntegerLiteralExprSyntaxImpl(_:)
    case .isExpr:
      return self.visitIsExprSyntaxImpl(_:)
    case .isTypePattern:
      return self.visitIsTypePatternSyntaxImpl(_:)
    case .keyPathComponentList:
      return self.visitKeyPathComponentListSyntaxImpl(_:)
    case .keyPathComponent:
      return self.visitKeyPathComponentSyntaxImpl(_:)
    case .keyPathExpr:
      return self.visitKeyPathExprSyntaxImpl(_:)
    case .keyPathMethodComponent:
      return self.visitKeyPathMethodComponentSyntaxImpl(_:)
    case .keyPathOptionalComponent:
      return self.visitKeyPathOptionalComponentSyntaxImpl(_:)
    case .keyPathPropertyComponent:
      return self.visitKeyPathPropertyComponentSyntaxImpl(_:)
    case .keyPathSubscriptComponent:
      return self.visitKeyPathSubscriptComponentSyntaxImpl(_:)
    case .labeledExprList:
      return self.visitLabeledExprListSyntaxImpl(_:)
    case .labeledExpr:
      return self.visitLabeledExprSyntaxImpl(_:)
    case .labeledSpecializeArgument:
      return self.visitLabeledSpecializeArgumentSyntaxImpl(_:)
    case .labeledStmt:
      return self.visitLabeledStmtSyntaxImpl(_:)
    case .layoutRequirement:
      return self.visitLayoutRequirementSyntaxImpl(_:)
    case .lifetimeSpecifierArgumentList:
      return self.visitLifetimeSpecifierArgumentListSyntaxImpl(_:)
    case .lifetimeSpecifierArgument:
      return self.visitLifetimeSpecifierArgumentSyntaxImpl(_:)
    case .lifetimeTypeSpecifier:
      return self.visitLifetimeTypeSpecifierSyntaxImpl(_:)
    case .macroDecl:
      return self.visitMacroDeclSyntaxImpl(_:)
    case .macroExpansionDecl:
      return self.visitMacroExpansionDeclSyntaxImpl(_:)
    case .macroExpansionExpr:
      return self.visitMacroExpansionExprSyntaxImpl(_:)
    case .matchingPatternCondition:
      return self.visitMatchingPatternConditionSyntaxImpl(_:)
    case .memberAccessExpr:
      return self.visitMemberAccessExprSyntaxImpl(_:)
    case .memberBlockItemListFile:
      return self.visitMemberBlockItemListFileSyntaxImpl(_:)
    case .memberBlockItemList:
      return self.visitMemberBlockItemListSyntaxImpl(_:)
    case .memberBlockItem:
      return self.visitMemberBlockItemSyntaxImpl(_:)
    case .memberBlock:
      return self.visitMemberBlockSyntaxImpl(_:)
    case .memberType:
      return self.visitMemberTypeSyntaxImpl(_:)
    case .metatypeType:
      return self.visitMetatypeTypeSyntaxImpl(_:)
    case .missingDecl:
      return self.visitMissingDeclSyntaxImpl(_:)
    case .missingExpr:
      return self.visitMissingExprSyntaxImpl(_:)
    case .missingPattern:
      return self.visitMissingPatternSyntaxImpl(_:)
    case .missingStmt:
      return self.visitMissingStmtSyntaxImpl(_:)
    case .missing:
      return self.visitMissingSyntaxImpl(_:)
    case .missingType:
      return self.visitMissingTypeSyntaxImpl(_:)
    case .multipleTrailingClosureElementList:
      return self.visitMultipleTrailingClosureElementListSyntaxImpl(_:)
    case .multipleTrailingClosureElement:
      return self.visitMultipleTrailingClosureElementSyntaxImpl(_:)
    case .namedOpaqueReturnType:
      return self.visitNamedOpaqueReturnTypeSyntaxImpl(_:)
    case .nilLiteralExpr:
      return self.visitNilLiteralExprSyntaxImpl(_:)
    case .nonisolatedSpecifierArgument:
      return self.visitNonisolatedSpecifierArgumentSyntaxImpl(_:)
    case .nonisolatedTypeSpecifier:
      return self.visitNonisolatedTypeSpecifierSyntaxImpl(_:)
    case .objCSelectorPieceList:
      return self.visitObjCSelectorPieceListSyntaxImpl(_:)
    case .objCSelectorPiece:
      return self.visitObjCSelectorPieceSyntaxImpl(_:)
    case .operatorDecl:
      return self.visitOperatorDeclSyntaxImpl(_:)
    case .operatorPrecedenceAndTypes:
      return self.visitOperatorPrecedenceAndTypesSyntaxImpl(_:)
    case .optionalBindingCondition:
      return self.visitOptionalBindingConditionSyntaxImpl(_:)
    case .optionalChainingExpr:
      return self.visitOptionalChainingExprSyntaxImpl(_:)
    case .optionalType:
      return self.visitOptionalTypeSyntaxImpl(_:)
    case .originallyDefinedInAttributeArguments:
      return self.visitOriginallyDefinedInAttributeArgumentsSyntaxImpl(_:)
    case .packElementExpr:
      return self.visitPackElementExprSyntaxImpl(_:)
    case .packElementType:
      return self.visitPackElementTypeSyntaxImpl(_:)
    case .packExpansionExpr:
      return self.visitPackExpansionExprSyntaxImpl(_:)
    case .packExpansionType:
      return self.visitPackExpansionTypeSyntaxImpl(_:)
    case .patternBindingList:
      return self.visitPatternBindingListSyntaxImpl(_:)
    case .patternBinding:
      return self.visitPatternBindingSyntaxImpl(_:)
    case .patternExpr:
      return self.visitPatternExprSyntaxImpl(_:)
    case .platformVersionItemList:
      return self.visitPlatformVersionItemListSyntaxImpl(_:)
    case .platformVersionItem:
      return self.visitPlatformVersionItemSyntaxImpl(_:)
    case .platformVersion:
      return self.visitPlatformVersionSyntaxImpl(_:)
    case .postfixIfConfigExpr:
      return self.visitPostfixIfConfigExprSyntaxImpl(_:)
    case .postfixOperatorExpr:
      return self.visitPostfixOperatorExprSyntaxImpl(_:)
    case .poundSourceLocationArguments:
      return self.visitPoundSourceLocationArgumentsSyntaxImpl(_:)
    case .poundSourceLocation:
      return self.visitPoundSourceLocationSyntaxImpl(_:)
    case .precedenceGroupAssignment:
      return self.visitPrecedenceGroupAssignmentSyntaxImpl(_:)
    case .precedenceGroupAssociativity:
      return self.visitPrecedenceGroupAssociativitySyntaxImpl(_:)
    case .precedenceGroupAttributeList:
      return self.visitPrecedenceGroupAttributeListSyntaxImpl(_:)
    case .precedenceGroupDecl:
      return self.visitPrecedenceGroupDeclSyntaxImpl(_:)
    case .precedenceGroupNameList:
      return self.visitPrecedenceGroupNameListSyntaxImpl(_:)
    case .precedenceGroupName:
      return self.visitPrecedenceGroupNameSyntaxImpl(_:)
    case .precedenceGroupRelation:
      return self.visitPrecedenceGroupRelationSyntaxImpl(_:)
    case .prefixOperatorExpr:
      return self.visitPrefixOperatorExprSyntaxImpl(_:)
    case .primaryAssociatedTypeClause:
      return self.visitPrimaryAssociatedTypeClauseSyntaxImpl(_:)
    case .primaryAssociatedTypeList:
      return self.visitPrimaryAssociatedTypeListSyntaxImpl(_:)
    case .primaryAssociatedType:
      return self.visitPrimaryAssociatedTypeSyntaxImpl(_:)
    case .protocolDecl:
      return self.visitProtocolDeclSyntaxImpl(_:)
    case .regexLiteralExpr:
      return self.visitRegexLiteralExprSyntaxImpl(_:)
    case .repeatStmt:
      return self.visitRepeatStmtSyntaxImpl(_:)
    case .returnClause:
      return self.visitReturnClauseSyntaxImpl(_:)
    case .returnStmt:
      return self.visitReturnStmtSyntaxImpl(_:)
    case .sameTypeRequirement:
      return self.visitSameTypeRequirementSyntaxImpl(_:)
    case .sequenceExpr:
      return self.visitSequenceExprSyntaxImpl(_:)
    case .simpleStringLiteralExpr:
      return self.visitSimpleStringLiteralExprSyntaxImpl(_:)
    case .simpleStringLiteralSegmentList:
      return self.visitSimpleStringLiteralSegmentListSyntaxImpl(_:)
    case .simpleTypeSpecifier:
      return self.visitSimpleTypeSpecifierSyntaxImpl(_:)
    case .someOrAnyType:
      return self.visitSomeOrAnyTypeSyntaxImpl(_:)
    case .sourceFile:
      return self.visitSourceFileSyntaxImpl(_:)
    case .specializeAttributeArgumentList:
      return self.visitSpecializeAttributeArgumentListSyntaxImpl(_:)
    case .specializeAvailabilityArgument:
      return self.visitSpecializeAvailabilityArgumentSyntaxImpl(_:)
    case .specializeTargetFunctionArgument:
      return self.visitSpecializeTargetFunctionArgumentSyntaxImpl(_:)
    case .specializedAttributeArgument:
      return self.visitSpecializedAttributeArgumentSyntaxImpl(_:)
    case .stringLiteralExpr:
      return self.visitStringLiteralExprSyntaxImpl(_:)
    case .stringLiteralSegmentList:
      return self.visitStringLiteralSegmentListSyntaxImpl(_:)
    case .stringSegment:
      return self.visitStringSegmentSyntaxImpl(_:)
    case .structDecl:
      return self.visitStructDeclSyntaxImpl(_:)
    case .subscriptCallExpr:
      return self.visitSubscriptCallExprSyntaxImpl(_:)
    case .subscriptDecl:
      return self.visitSubscriptDeclSyntaxImpl(_:)
    case .superExpr:
      return self.visitSuperExprSyntaxImpl(_:)
    case .suppressedType:
      return self.visitSuppressedTypeSyntaxImpl(_:)
    case .switchCaseItemList:
      return self.visitSwitchCaseItemListSyntaxImpl(_:)
    case .switchCaseItem:
      return self.visitSwitchCaseItemSyntaxImpl(_:)
    case .switchCaseLabel:
      return self.visitSwitchCaseLabelSyntaxImpl(_:)
    case .switchCaseList:
      return self.visitSwitchCaseListSyntaxImpl(_:)
    case .switchCase:
      return self.visitSwitchCaseSyntaxImpl(_:)
    case .switchDefaultLabel:
      return self.visitSwitchDefaultLabelSyntaxImpl(_:)
    case .switchExpr:
      return self.visitSwitchExprSyntaxImpl(_:)
    case .ternaryExpr:
      return self.visitTernaryExprSyntaxImpl(_:)
    case .thenStmt:
      return self.visitThenStmtSyntaxImpl(_:)
    case .throwStmt:
      return self.visitThrowStmtSyntaxImpl(_:)
    case .throwsClause:
      return self.visitThrowsClauseSyntaxImpl(_:)
    case .tryExpr:
      return self.visitTryExprSyntaxImpl(_:)
    case .tupleExpr:
      return self.visitTupleExprSyntaxImpl(_:)
    case .tuplePatternElementList:
      return self.visitTuplePatternElementListSyntaxImpl(_:)
    case .tuplePatternElement:
      return self.visitTuplePatternElementSyntaxImpl(_:)
    case .tuplePattern:
      return self.visitTuplePatternSyntaxImpl(_:)
    case .tupleTypeElementList:
      return self.visitTupleTypeElementListSyntaxImpl(_:)
    case .tupleTypeElement:
      return self.visitTupleTypeElementSyntaxImpl(_:)
    case .tupleType:
      return self.visitTupleTypeSyntaxImpl(_:)
    case .typeAliasDecl:
      return self.visitTypeAliasDeclSyntaxImpl(_:)
    case .typeAnnotation:
      return self.visitTypeAnnotationSyntaxImpl(_:)
    case .typeEffectSpecifiers:
      return self.visitTypeEffectSpecifiersSyntaxImpl(_:)
    case .typeExpr:
      return self.visitTypeExprSyntaxImpl(_:)
    case .typeInitializerClause:
      return self.visitTypeInitializerClauseSyntaxImpl(_:)
    case .typeSpecifierList:
      return self.visitTypeSpecifierListSyntaxImpl(_:)
    case .unexpectedNodes:
      return self.visitUnexpectedNodesSyntaxImpl(_:)
    case .unresolvedAsExpr:
      return self.visitUnresolvedAsExprSyntaxImpl(_:)
    case .unresolvedIsExpr:
      return self.visitUnresolvedIsExprSyntaxImpl(_:)
    case .unresolvedTernaryExpr:
      return self.visitUnresolvedTernaryExprSyntaxImpl(_:)
    case .unsafeExpr:
      return self.visitUnsafeExprSyntaxImpl(_:)
    case .usingDecl:
      return self.visitUsingDeclSyntaxImpl(_:)
    case .valueBindingPattern:
      return self.visitValueBindingPatternSyntaxImpl(_:)
    case .variableDecl:
      return self.visitVariableDeclSyntaxImpl(_:)
    case .versionComponentList:
      return self.visitVersionComponentListSyntaxImpl(_:)
    case .versionComponent:
      return self.visitVersionComponentSyntaxImpl(_:)
    case .versionTuple:
      return self.visitVersionTupleSyntaxImpl(_:)
    case .whereClause:
      return self.visitWhereClauseSyntaxImpl(_:)
    case .whileStmt:
      return self.visitWhileStmtSyntaxImpl(_:)
    case .wildcardPattern:
      return self.visitWildcardPatternSyntaxImpl(_:)
    case .yieldStmt:
      return self.visitYieldStmtSyntaxImpl(_:)
    case .yieldedExpressionList:
      return self.visitYieldedExpressionListSyntaxImpl(_:)
    case .yieldedExpression:
      return self.visitYieldedExpressionSyntaxImpl(_:)
    case .yieldedExpressionsClause:
      return self.visitYieldedExpressionsClauseSyntaxImpl(_:)
    }
  }
  private func dispatchVisit(_ node: Syntax) {
    return visitationFunc(for: node)(node)
  }
  #else
  private func dispatchVisit(_ node: Syntax) {
    switch node.raw.kind {
    case .token:
      self.visitTokenSyntaxImpl(node)
    case .abiAttributeArguments:
      self.visitABIAttributeArgumentsSyntaxImpl(node)
    case .accessorBlockFile:
      self.visitAccessorBlockFileSyntaxImpl(node)
    case .accessorBlock:
      self.visitAccessorBlockSyntaxImpl(node)
    case .accessorDeclList:
      self.visitAccessorDeclListSyntaxImpl(node)
    case .accessorDecl:
      self.visitAccessorDeclSyntaxImpl(node)
    case .accessorEffectSpecifiers:
      self.visitAccessorEffectSpecifiersSyntaxImpl(node)
    case .accessorParameters:
      self.visitAccessorParametersSyntaxImpl(node)
    case .actorDecl:
      self.visitActorDeclSyntaxImpl(node)
    case .arrayElementList:
      self.visitArrayElementListSyntaxImpl(node)
    case .arrayElement:
      self.visitArrayElementSyntaxImpl(node)
    case .arrayExpr:
      self.visitArrayExprSyntaxImpl(node)
    case .arrayType:
      self.visitArrayTypeSyntaxImpl(node)
    case .arrowExpr:
      self.visitArrowExprSyntaxImpl(node)
    case .asExpr:
      self.visitAsExprSyntaxImpl(node)
    case .assignmentExpr:
      self.visitAssignmentExprSyntaxImpl(node)
    case .associatedTypeDecl:
      self.visitAssociatedTypeDeclSyntaxImpl(node)
    case .attributeClauseFile:
      self.visitAttributeClauseFileSyntaxImpl(node)
    case .attributeList:
      self.visitAttributeListSyntaxImpl(node)
    case .attribute:
      self.visitAttributeSyntaxImpl(node)
    case .attributedType:
      self.visitAttributedTypeSyntaxImpl(node)
    case .availabilityArgumentList:
      self.visitAvailabilityArgumentListSyntaxImpl(node)
    case .availabilityArgument:
      self.visitAvailabilityArgumentSyntaxImpl(node)
    case .availabilityCondition:
      self.visitAvailabilityConditionSyntaxImpl(node)
    case .availabilityLabeledArgument:
      self.visitAvailabilityLabeledArgumentSyntaxImpl(node)
    case .availabilityMacroDefinitionFile:
      self.visitAvailabilityMacroDefinitionFileSyntaxImpl(node)
    case .awaitExpr:
      self.visitAwaitExprSyntaxImpl(node)
    case .backDeployedAttributeArguments:
      self.visitBackDeployedAttributeArgumentsSyntaxImpl(node)
    case .binaryOperatorExpr:
      self.visitBinaryOperatorExprSyntaxImpl(node)
    case .booleanLiteralExpr:
      self.visitBooleanLiteralExprSyntaxImpl(node)
    case .borrowExpr:
      self.visitBorrowExprSyntaxImpl(node)
    case .breakStmt:
      self.visitBreakStmtSyntaxImpl(node)
    case ._canImportExpr:
      self.visit_CanImportExprSyntaxImpl(node)
    case ._canImportVersionInfo:
      self.visit_CanImportVersionInfoSyntaxImpl(node)
    case .catchClauseList:
      self.visitCatchClauseListSyntaxImpl(node)
    case .catchClause:
      self.visitCatchClauseSyntaxImpl(node)
    case .catchItemList:
      self.visitCatchItemListSyntaxImpl(node)
    case .catchItem:
      self.visitCatchItemSyntaxImpl(node)
    case .classDecl:
      self.visitClassDeclSyntaxImpl(node)
    case .classRestrictionType:
      self.visitClassRestrictionTypeSyntaxImpl(node)
    case .closureCaptureClause:
      self.visitClosureCaptureClauseSyntaxImpl(node)
    case .closureCaptureList:
      self.visitClosureCaptureListSyntaxImpl(node)
    case .closureCaptureSpecifier:
      self.visitClosureCaptureSpecifierSyntaxImpl(node)
    case .closureCapture:
      self.visitClosureCaptureSyntaxImpl(node)
    case .closureExpr:
      self.visitClosureExprSyntaxImpl(node)
    case .closureParameterClause:
      self.visitClosureParameterClauseSyntaxImpl(node)
    case .closureParameterList:
      self.visitClosureParameterListSyntaxImpl(node)
    case .closureParameter:
      self.visitClosureParameterSyntaxImpl(node)
    case .closureShorthandParameterList:
      self.visitClosureShorthandParameterListSyntaxImpl(node)
    case .closureShorthandParameter:
      self.visitClosureShorthandParameterSyntaxImpl(node)
    case .closureSignature:
      self.visitClosureSignatureSyntaxImpl(node)
    case .codeBlockFile:
      self.visitCodeBlockFileSyntaxImpl(node)
    case .codeBlockItemList:
      self.visitCodeBlockItemListSyntaxImpl(node)
    case .codeBlockItem:
      self.visitCodeBlockItemSyntaxImpl(node)
    case .codeBlock:
      self.visitCodeBlockSyntaxImpl(node)
    case .compositionTypeElementList:
      self.visitCompositionTypeElementListSyntaxImpl(node)
    case .compositionTypeElement:
      self.visitCompositionTypeElementSyntaxImpl(node)
    case .compositionType:
      self.visitCompositionTypeSyntaxImpl(node)
    case .conditionElementList:
      self.visitConditionElementListSyntaxImpl(node)
    case .conditionElement:
      self.visitConditionElementSyntaxImpl(node)
    case .conformanceRequirement:
      self.visitConformanceRequirementSyntaxImpl(node)
    case .consumeExpr:
      self.visitConsumeExprSyntaxImpl(node)
    case .continueStmt:
      self.visitContinueStmtSyntaxImpl(node)
    case .copyExpr:
      self.visitCopyExprSyntaxImpl(node)
    case .declModifierDetail:
      self.visitDeclModifierDetailSyntaxImpl(node)
    case .declModifierList:
      self.visitDeclModifierListSyntaxImpl(node)
    case .declModifier:
      self.visitDeclModifierSyntaxImpl(node)
    case .declNameArgumentList:
      self.visitDeclNameArgumentListSyntaxImpl(node)
    case .declNameArgument:
      self.visitDeclNameArgumentSyntaxImpl(node)
    case .declNameArguments:
      self.visitDeclNameArgumentsSyntaxImpl(node)
    case .declReferenceExpr:
      self.visitDeclReferenceExprSyntaxImpl(node)
    case .deferStmt:
      self.visitDeferStmtSyntaxImpl(node)
    case .deinitializerDecl:
      self.visitDeinitializerDeclSyntaxImpl(node)
    case .deinitializerEffectSpecifiers:
      self.visitDeinitializerEffectSpecifiersSyntaxImpl(node)
    case .derivativeAttributeArguments:
      self.visitDerivativeAttributeArgumentsSyntaxImpl(node)
    case .designatedTypeList:
      self.visitDesignatedTypeListSyntaxImpl(node)
    case .designatedType:
      self.visitDesignatedTypeSyntaxImpl(node)
    case .dictionaryElementList:
      self.visitDictionaryElementListSyntaxImpl(node)
    case .dictionaryElement:
      self.visitDictionaryElementSyntaxImpl(node)
    case .dictionaryExpr:
      self.visitDictionaryExprSyntaxImpl(node)
    case .dictionaryType:
      self.visitDictionaryTypeSyntaxImpl(node)
    case .differentiabilityArgumentList:
      self.visitDifferentiabilityArgumentListSyntaxImpl(node)
    case .differentiabilityArgument:
      self.visitDifferentiabilityArgumentSyntaxImpl(node)
    case .differentiabilityArguments:
      self.visitDifferentiabilityArgumentsSyntaxImpl(node)
    case .differentiabilityWithRespectToArgument:
      self.visitDifferentiabilityWithRespectToArgumentSyntaxImpl(node)
    case .differentiableAttributeArguments:
      self.visitDifferentiableAttributeArgumentsSyntaxImpl(node)
    case .discardAssignmentExpr:
      self.visitDiscardAssignmentExprSyntaxImpl(node)
    case .discardStmt:
      self.visitDiscardStmtSyntaxImpl(node)
    case .doExpr:
      self.visitDoExprSyntaxImpl(node)
    case .doStmt:
      self.visitDoStmtSyntaxImpl(node)
    case .documentationAttributeArgumentList:
      self.visitDocumentationAttributeArgumentListSyntaxImpl(node)
    case .documentationAttributeArgument:
      self.visitDocumentationAttributeArgumentSyntaxImpl(node)
    case .dynamicReplacementAttributeArguments:
      self.visitDynamicReplacementAttributeArgumentsSyntaxImpl(node)
    case .editorPlaceholderDecl:
      self.visitEditorPlaceholderDeclSyntaxImpl(node)
    case .editorPlaceholderExpr:
      self.visitEditorPlaceholderExprSyntaxImpl(node)
    case .effectsAttributeArgumentList:
      self.visitEffectsAttributeArgumentListSyntaxImpl(node)
    case .enumCaseDecl:
      self.visitEnumCaseDeclSyntaxImpl(node)
    case .enumCaseElementList:
      self.visitEnumCaseElementListSyntaxImpl(node)
    case .enumCaseElement:
      self.visitEnumCaseElementSyntaxImpl(node)
    case .enumCaseParameterClause:
      self.visitEnumCaseParameterClauseSyntaxImpl(node)
    case .enumCaseParameterList:
      self.visitEnumCaseParameterListSyntaxImpl(node)
    case .enumCaseParameter:
      self.visitEnumCaseParameterSyntaxImpl(node)
    case .enumDecl:
      self.visitEnumDeclSyntaxImpl(node)
    case .exprList:
      self.visitExprListSyntaxImpl(node)
    case .expressionPattern:
      self.visitExpressionPatternSyntaxImpl(node)
    case .expressionSegment:
      self.visitExpressionSegmentSyntaxImpl(node)
    case .expressionStmt:
      self.visitExpressionStmtSyntaxImpl(node)
    case .extensionDecl:
      self.visitExtensionDeclSyntaxImpl(node)
    case .fallThroughStmt:
      self.visitFallThroughStmtSyntaxImpl(node)
    case .floatLiteralExpr:
      self.visitFloatLiteralExprSyntaxImpl(node)
    case .forStmt:
      self.visitForStmtSyntaxImpl(node)
    case .forceUnwrapExpr:
      self.visitForceUnwrapExprSyntaxImpl(node)
    case .functionCallExpr:
      self.visitFunctionCallExprSyntaxImpl(node)
    case .functionDecl:
      self.visitFunctionDeclSyntaxImpl(node)
    case .functionEffectSpecifiers:
      self.visitFunctionEffectSpecifiersSyntaxImpl(node)
    case .functionParameterClause:
      self.visitFunctionParameterClauseSyntaxImpl(node)
    case .functionParameterList:
      self.visitFunctionParameterListSyntaxImpl(node)
    case .functionParameter:
      self.visitFunctionParameterSyntaxImpl(node)
    case .functionSignature:
      self.visitFunctionSignatureSyntaxImpl(node)
    case .functionType:
      self.visitFunctionTypeSyntaxImpl(node)
    case .genericArgumentClause:
      self.visitGenericArgumentClauseSyntaxImpl(node)
    case .genericArgumentList:
      self.visitGenericArgumentListSyntaxImpl(node)
    case .genericArgument:
      self.visitGenericArgumentSyntaxImpl(node)
    case .genericParameterClause:
      self.visitGenericParameterClauseSyntaxImpl(node)
    case .genericParameterList:
      self.visitGenericParameterListSyntaxImpl(node)
    case .genericParameter:
      self.visitGenericParameterSyntaxImpl(node)
    case .genericRequirementList:
      self.visitGenericRequirementListSyntaxImpl(node)
    case .genericRequirement:
      self.visitGenericRequirementSyntaxImpl(node)
    case .genericSpecializationExpr:
      self.visitGenericSpecializationExprSyntaxImpl(node)
    case .genericWhereClause:
      self.visitGenericWhereClauseSyntaxImpl(node)
    case .guardStmt:
      self.visitGuardStmtSyntaxImpl(node)
    case .identifierPattern:
      self.visitIdentifierPatternSyntaxImpl(node)
    case .identifierType:
      self.visitIdentifierTypeSyntaxImpl(node)
    case .ifConfigClauseList:
      self.visitIfConfigClauseListSyntaxImpl(node)
    case .ifConfigClause:
      self.visitIfConfigClauseSyntaxImpl(node)
    case .ifConfigDecl:
      self.visitIfConfigDeclSyntaxImpl(node)
    case .ifExpr:
      self.visitIfExprSyntaxImpl(node)
    case .implementsAttributeArguments:
      self.visitImplementsAttributeArgumentsSyntaxImpl(node)
    case .implicitlyUnwrappedOptionalType:
      self.visitImplicitlyUnwrappedOptionalTypeSyntaxImpl(node)
    case .importDecl:
      self.visitImportDeclSyntaxImpl(node)
    case .importPathComponentList:
      self.visitImportPathComponentListSyntaxImpl(node)
    case .importPathComponent:
      self.visitImportPathComponentSyntaxImpl(node)
    case .inOutExpr:
      self.visitInOutExprSyntaxImpl(node)
    case .infixOperatorExpr:
      self.visitInfixOperatorExprSyntaxImpl(node)
    case .inheritanceClause:
      self.visitInheritanceClauseSyntaxImpl(node)
    case .inheritedTypeList:
      self.visitInheritedTypeListSyntaxImpl(node)
    case .inheritedType:
      self.visitInheritedTypeSyntaxImpl(node)
    case .initializerClause:
      self.visitInitializerClauseSyntaxImpl(node)
    case .initializerDecl:
      self.visitInitializerDeclSyntaxImpl(node)
    case .inlineArrayType:
      self.visitInlineArrayTypeSyntaxImpl(node)
    case .integerLiteralExpr:
      self.visitIntegerLiteralExprSyntaxImpl(node)
    case .isExpr:
      self.visitIsExprSyntaxImpl(node)
    case .isTypePattern:
      self.visitIsTypePatternSyntaxImpl(node)
    case .keyPathComponentList:
      self.visitKeyPathComponentListSyntaxImpl(node)
    case .keyPathComponent:
      self.visitKeyPathComponentSyntaxImpl(node)
    case .keyPathExpr:
      self.visitKeyPathExprSyntaxImpl(node)
    case .keyPathMethodComponent:
      self.visitKeyPathMethodComponentSyntaxImpl(node)
    case .keyPathOptionalComponent:
      self.visitKeyPathOptionalComponentSyntaxImpl(node)
    case .keyPathPropertyComponent:
      self.visitKeyPathPropertyComponentSyntaxImpl(node)
    case .keyPathSubscriptComponent:
      self.visitKeyPathSubscriptComponentSyntaxImpl(node)
    case .labeledExprList:
      self.visitLabeledExprListSyntaxImpl(node)
    case .labeledExpr:
      self.visitLabeledExprSyntaxImpl(node)
    case .labeledSpecializeArgument:
      self.visitLabeledSpecializeArgumentSyntaxImpl(node)
    case .labeledStmt:
      self.visitLabeledStmtSyntaxImpl(node)
    case .layoutRequirement:
      self.visitLayoutRequirementSyntaxImpl(node)
    case .lifetimeSpecifierArgumentList:
      self.visitLifetimeSpecifierArgumentListSyntaxImpl(node)
    case .lifetimeSpecifierArgument:
      self.visitLifetimeSpecifierArgumentSyntaxImpl(node)
    case .lifetimeTypeSpecifier:
      self.visitLifetimeTypeSpecifierSyntaxImpl(node)
    case .macroDecl:
      self.visitMacroDeclSyntaxImpl(node)
    case .macroExpansionDecl:
      self.visitMacroExpansionDeclSyntaxImpl(node)
    case .macroExpansionExpr:
      self.visitMacroExpansionExprSyntaxImpl(node)
    case .matchingPatternCondition:
      self.visitMatchingPatternConditionSyntaxImpl(node)
    case .memberAccessExpr:
      self.visitMemberAccessExprSyntaxImpl(node)
    case .memberBlockItemListFile:
      self.visitMemberBlockItemListFileSyntaxImpl(node)
    case .memberBlockItemList:
      self.visitMemberBlockItemListSyntaxImpl(node)
    case .memberBlockItem:
      self.visitMemberBlockItemSyntaxImpl(node)
    case .memberBlock:
      self.visitMemberBlockSyntaxImpl(node)
    case .memberType:
      self.visitMemberTypeSyntaxImpl(node)
    case .metatypeType:
      self.visitMetatypeTypeSyntaxImpl(node)
    case .missingDecl:
      self.visitMissingDeclSyntaxImpl(node)
    case .missingExpr:
      self.visitMissingExprSyntaxImpl(node)
    case .missingPattern:
      self.visitMissingPatternSyntaxImpl(node)
    case .missingStmt:
      self.visitMissingStmtSyntaxImpl(node)
    case .missing:
      self.visitMissingSyntaxImpl(node)
    case .missingType:
      self.visitMissingTypeSyntaxImpl(node)
    case .multipleTrailingClosureElementList:
      self.visitMultipleTrailingClosureElementListSyntaxImpl(node)
    case .multipleTrailingClosureElement:
      self.visitMultipleTrailingClosureElementSyntaxImpl(node)
    case .namedOpaqueReturnType:
      self.visitNamedOpaqueReturnTypeSyntaxImpl(node)
    case .nilLiteralExpr:
      self.visitNilLiteralExprSyntaxImpl(node)
    case .nonisolatedSpecifierArgument:
      self.visitNonisolatedSpecifierArgumentSyntaxImpl(node)
    case .nonisolatedTypeSpecifier:
      self.visitNonisolatedTypeSpecifierSyntaxImpl(node)
    case .objCSelectorPieceList:
      self.visitObjCSelectorPieceListSyntaxImpl(node)
    case .objCSelectorPiece:
      self.visitObjCSelectorPieceSyntaxImpl(node)
    case .operatorDecl:
      self.visitOperatorDeclSyntaxImpl(node)
    case .operatorPrecedenceAndTypes:
      self.visitOperatorPrecedenceAndTypesSyntaxImpl(node)
    case .optionalBindingCondition:
      self.visitOptionalBindingConditionSyntaxImpl(node)
    case .optionalChainingExpr:
      self.visitOptionalChainingExprSyntaxImpl(node)
    case .optionalType:
      self.visitOptionalTypeSyntaxImpl(node)
    case .originallyDefinedInAttributeArguments:
      self.visitOriginallyDefinedInAttributeArgumentsSyntaxImpl(node)
    case .packElementExpr:
      self.visitPackElementExprSyntaxImpl(node)
    case .packElementType:
      self.visitPackElementTypeSyntaxImpl(node)
    case .packExpansionExpr:
      self.visitPackExpansionExprSyntaxImpl(node)
    case .packExpansionType:
      self.visitPackExpansionTypeSyntaxImpl(node)
    case .patternBindingList:
      self.visitPatternBindingListSyntaxImpl(node)
    case .patternBinding:
      self.visitPatternBindingSyntaxImpl(node)
    case .patternExpr:
      self.visitPatternExprSyntaxImpl(node)
    case .platformVersionItemList:
      self.visitPlatformVersionItemListSyntaxImpl(node)
    case .platformVersionItem:
      self.visitPlatformVersionItemSyntaxImpl(node)
    case .platformVersion:
      self.visitPlatformVersionSyntaxImpl(node)
    case .postfixIfConfigExpr:
      self.visitPostfixIfConfigExprSyntaxImpl(node)
    case .postfixOperatorExpr:
      self.visitPostfixOperatorExprSyntaxImpl(node)
    case .poundSourceLocationArguments:
      self.visitPoundSourceLocationArgumentsSyntaxImpl(node)
    case .poundSourceLocation:
      self.visitPoundSourceLocationSyntaxImpl(node)
    case .precedenceGroupAssignment:
      self.visitPrecedenceGroupAssignmentSyntaxImpl(node)
    case .precedenceGroupAssociativity:
      self.visitPrecedenceGroupAssociativitySyntaxImpl(node)
    case .precedenceGroupAttributeList:
      self.visitPrecedenceGroupAttributeListSyntaxImpl(node)
    case .precedenceGroupDecl:
      self.visitPrecedenceGroupDeclSyntaxImpl(node)
    case .precedenceGroupNameList:
      self.visitPrecedenceGroupNameListSyntaxImpl(node)
    case .precedenceGroupName:
      self.visitPrecedenceGroupNameSyntaxImpl(node)
    case .precedenceGroupRelation:
      self.visitPrecedenceGroupRelationSyntaxImpl(node)
    case .prefixOperatorExpr:
      self.visitPrefixOperatorExprSyntaxImpl(node)
    case .primaryAssociatedTypeClause:
      self.visitPrimaryAssociatedTypeClauseSyntaxImpl(node)
    case .primaryAssociatedTypeList:
      self.visitPrimaryAssociatedTypeListSyntaxImpl(node)
    case .primaryAssociatedType:
      self.visitPrimaryAssociatedTypeSyntaxImpl(node)
    case .protocolDecl:
      self.visitProtocolDeclSyntaxImpl(node)
    case .regexLiteralExpr:
      self.visitRegexLiteralExprSyntaxImpl(node)
    case .repeatStmt:
      self.visitRepeatStmtSyntaxImpl(node)
    case .returnClause:
      self.visitReturnClauseSyntaxImpl(node)
    case .returnStmt:
      self.visitReturnStmtSyntaxImpl(node)
    case .sameTypeRequirement:
      self.visitSameTypeRequirementSyntaxImpl(node)
    case .sequenceExpr:
      self.visitSequenceExprSyntaxImpl(node)
    case .simpleStringLiteralExpr:
      self.visitSimpleStringLiteralExprSyntaxImpl(node)
    case .simpleStringLiteralSegmentList:
      self.visitSimpleStringLiteralSegmentListSyntaxImpl(node)
    case .simpleTypeSpecifier:
      self.visitSimpleTypeSpecifierSyntaxImpl(node)
    case .someOrAnyType:
      self.visitSomeOrAnyTypeSyntaxImpl(node)
    case .sourceFile:
      self.visitSourceFileSyntaxImpl(node)
    case .specializeAttributeArgumentList:
      self.visitSpecializeAttributeArgumentListSyntaxImpl(node)
    case .specializeAvailabilityArgument:
      self.visitSpecializeAvailabilityArgumentSyntaxImpl(node)
    case .specializeTargetFunctionArgument:
      self.visitSpecializeTargetFunctionArgumentSyntaxImpl(node)
    case .specializedAttributeArgument:
      self.visitSpecializedAttributeArgumentSyntaxImpl(node)
    case .stringLiteralExpr:
      self.visitStringLiteralExprSyntaxImpl(node)
    case .stringLiteralSegmentList:
      self.visitStringLiteralSegmentListSyntaxImpl(node)
    case .stringSegment:
      self.visitStringSegmentSyntaxImpl(node)
    case .structDecl:
      self.visitStructDeclSyntaxImpl(node)
    case .subscriptCallExpr:
      self.visitSubscriptCallExprSyntaxImpl(node)
    case .subscriptDecl:
      self.visitSubscriptDeclSyntaxImpl(node)
    case .superExpr:
      self.visitSuperExprSyntaxImpl(node)
    case .suppressedType:
      self.visitSuppressedTypeSyntaxImpl(node)
    case .switchCaseItemList:
      self.visitSwitchCaseItemListSyntaxImpl(node)
    case .switchCaseItem:
      self.visitSwitchCaseItemSyntaxImpl(node)
    case .switchCaseLabel:
      self.visitSwitchCaseLabelSyntaxImpl(node)
    case .switchCaseList:
      self.visitSwitchCaseListSyntaxImpl(node)
    case .switchCase:
      self.visitSwitchCaseSyntaxImpl(node)
    case .switchDefaultLabel:
      self.visitSwitchDefaultLabelSyntaxImpl(node)
    case .switchExpr:
      self.visitSwitchExprSyntaxImpl(node)
    case .ternaryExpr:
      self.visitTernaryExprSyntaxImpl(node)
    case .thenStmt:
      self.visitThenStmtSyntaxImpl(node)
    case .throwStmt:
      self.visitThrowStmtSyntaxImpl(node)
    case .throwsClause:
      self.visitThrowsClauseSyntaxImpl(node)
    case .tryExpr:
      self.visitTryExprSyntaxImpl(node)
    case .tupleExpr:
      self.visitTupleExprSyntaxImpl(node)
    case .tuplePatternElementList:
      self.visitTuplePatternElementListSyntaxImpl(node)
    case .tuplePatternElement:
      self.visitTuplePatternElementSyntaxImpl(node)
    case .tuplePattern:
      self.visitTuplePatternSyntaxImpl(node)
    case .tupleTypeElementList:
      self.visitTupleTypeElementListSyntaxImpl(node)
    case .tupleTypeElement:
      self.visitTupleTypeElementSyntaxImpl(node)
    case .tupleType:
      self.visitTupleTypeSyntaxImpl(node)
    case .typeAliasDecl:
      self.visitTypeAliasDeclSyntaxImpl(node)
    case .typeAnnotation:
      self.visitTypeAnnotationSyntaxImpl(node)
    case .typeEffectSpecifiers:
      self.visitTypeEffectSpecifiersSyntaxImpl(node)
    case .typeExpr:
      self.visitTypeExprSyntaxImpl(node)
    case .typeInitializerClause:
      self.visitTypeInitializerClauseSyntaxImpl(node)
    case .typeSpecifierList:
      self.visitTypeSpecifierListSyntaxImpl(node)
    case .unexpectedNodes:
      self.visitUnexpectedNodesSyntaxImpl(node)
    case .unresolvedAsExpr:
      self.visitUnresolvedAsExprSyntaxImpl(node)
    case .unresolvedIsExpr:
      self.visitUnresolvedIsExprSyntaxImpl(node)
    case .unresolvedTernaryExpr:
      self.visitUnresolvedTernaryExprSyntaxImpl(node)
    case .unsafeExpr:
      self.visitUnsafeExprSyntaxImpl(node)
    case .usingDecl:
      self.visitUsingDeclSyntaxImpl(node)
    case .valueBindingPattern:
      self.visitValueBindingPatternSyntaxImpl(node)
    case .variableDecl:
      self.visitVariableDeclSyntaxImpl(node)
    case .versionComponentList:
      self.visitVersionComponentListSyntaxImpl(node)
    case .versionComponent:
      self.visitVersionComponentSyntaxImpl(node)
    case .versionTuple:
      self.visitVersionTupleSyntaxImpl(node)
    case .whereClause:
      self.visitWhereClauseSyntaxImpl(node)
    case .whileStmt:
      self.visitWhileStmtSyntaxImpl(node)
    case .wildcardPattern:
      self.visitWildcardPatternSyntaxImpl(node)
    case .yieldStmt:
      self.visitYieldStmtSyntaxImpl(node)
    case .yieldedExpressionList:
      self.visitYieldedExpressionListSyntaxImpl(node)
    case .yieldedExpression:
      self.visitYieldedExpressionSyntaxImpl(node)
    case .yieldedExpressionsClause:
      self.visitYieldedExpressionsClauseSyntaxImpl(node)
    }
  }
  #endif

  private func visitChildren(_ node: Syntax) {
    for case let childDataRef? in node.layoutBuffer where viewMode.shouldTraverse(node: childDataRef.pointee.raw) {
      dispatchVisit(Syntax(arena: node.arena, dataRef: childDataRef))
    }
  }
}
