//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - DeclModifierDetailSyntax

/// ### Children
/// 
///  - `leftParen`: `(`
///  - `detail`: `<identifier>`
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``DeclModifierSyntax``.``DeclModifierSyntax/detail``
public struct DeclModifierDetailSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .declModifierDetail else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndDetail: UnexpectedNodesSyntax? = nil,
    detail: TokenSyntax,
    _ unexpectedBetweenDetailAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndDetail,
      detail,
      unexpectedBetweenDetailAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndDetail?.raw,
        detail.raw,
        unexpectedBetweenDetailAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.declModifierDetail,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndDetail: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var detail: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  public var unexpectedBetweenDetailAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierDetailSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndDetail,
    \Self.detail,
    \Self.unexpectedBetweenDetailAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - DeclModifierSyntax

/// ### Children
/// 
///  - `name`: (`__consuming` | `__setter_access` | `_const` | `_local` | `actor` | `async` | `borrowing` | `class` | `consuming` | `convenience` | `distributed` | `dynamic` | `fileprivate` | `final` | `indirect` | `infix` | `internal` | `isolated` | `lazy` | `mutating` | `nonisolated` | `nonmutating` | `open` | `optional` | `override` | `package` | `postfix` | `prefix` | `private` | `public` | `reasync` | `required` | `static` | `unowned` | `weak` | `sending`)
///  - `detail`: ``DeclModifierDetailSyntax``?
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/modifier``
///  - ``DeclModifierListSyntax``
public struct DeclModifierSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .declModifier else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndDetail: UnexpectedNodesSyntax? = nil,
    detail: DeclModifierDetailSyntax? = nil,
    _ unexpectedAfterDetail: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndDetail,
      detail,
      unexpectedAfterDetail
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndDetail?.raw,
        detail?.raw,
        unexpectedAfterDetail?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.declModifier,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `__consuming`
  ///  - `__setter_access`
  ///  - `_const`
  ///  - `_local`
  ///  - `actor`
  ///  - `async`
  ///  - `borrowing`
  ///  - `class`
  ///  - `consuming`
  ///  - `convenience`
  ///  - `distributed`
  ///  - `dynamic`
  ///  - `fileprivate`
  ///  - `final`
  ///  - `indirect`
  ///  - `infix`
  ///  - `internal`
  ///  - `isolated`
  ///  - `lazy`
  ///  - `mutating`
  ///  - `nonisolated`
  ///  - `nonmutating`
  ///  - `open`
  ///  - `optional`
  ///  - `override`
  ///  - `package`
  ///  - `postfix`
  ///  - `prefix`
  ///  - `private`
  ///  - `public`
  ///  - `reasync`
  ///  - `required`
  ///  - `static`
  ///  - `unowned`
  ///  - `weak`
  ///  - `sending`
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndDetail: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierSyntax.self)
    }
  }

  public var detail: DeclModifierDetailSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(DeclModifierDetailSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierSyntax.self)
    }
  }

  public var unexpectedAfterDetail: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclModifierSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndDetail,
    \Self.detail,
    \Self.unexpectedAfterDetail
  ])
}

// MARK: - DeclNameArgumentSyntax

/// ### Children
/// 
///  - `name`: ``TokenSyntax``
///  - `colon`: `:`
///
/// ### Contained in
/// 
///  - ``DeclNameArgumentListSyntax``
public struct DeclNameArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .declNameArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedAfterColon: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndColon,
      colon,
      unexpectedAfterColon
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndColon?.raw,
        colon.raw,
        unexpectedAfterColon?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.declNameArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentSyntax.self)
    }
  }

  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentSyntax.self)
    }
  }

  public var unexpectedAfterColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndColon,
    \Self.colon,
    \Self.unexpectedAfterColon
  ])
}

// MARK: - DeclNameArgumentsSyntax

/// ### Children
/// 
///  - `leftParen`: `(`
///  - `arguments`: ``DeclNameArgumentListSyntax``
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``DeclReferenceExprSyntax``.``DeclReferenceExprSyntax/argumentNames``
public struct DeclNameArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .declNameArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: DeclNameArgumentListSyntax,
    _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndArguments?.raw,
        arguments.raw,
        unexpectedBetweenArgumentsAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.declNameArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  public var arguments: DeclNameArgumentListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclNameArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: DeclNameArgumentSyntax) -> DeclNameArgumentsSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declNameArgumentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(DeclNameArgumentsSyntax.self)
  }

  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclNameArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - DeclReferenceExprSyntax

/// ### Children
/// 
///  - `baseName`: (`<identifier>` | `self` | `Self` | `init` | `deinit` | `subscript` | `<dollarIdentifier>` | `<binaryOperator>` | `<integerLiteral>`)
///  - `argumentNames`: ``DeclNameArgumentsSyntax``?
///
/// ### Contained in
/// 
///  - ``DynamicReplacementAttributeArgumentsSyntax``.``DynamicReplacementAttributeArgumentsSyntax/declName``
///  - ``ImplementsAttributeArgumentsSyntax``.``ImplementsAttributeArgumentsSyntax/declName``
///  - ``KeyPathPropertyComponentSyntax``.``KeyPathPropertyComponentSyntax/declName``
///  - ``MemberAccessExprSyntax``.``MemberAccessExprSyntax/declName``
///  - ``SpecializeTargetFunctionArgumentSyntax``.``SpecializeTargetFunctionArgumentSyntax/declName``
public struct DeclReferenceExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .declReferenceExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBaseName: UnexpectedNodesSyntax? = nil,
    baseName: TokenSyntax,
    _ unexpectedBetweenBaseNameAndArgumentNames: UnexpectedNodesSyntax? = nil,
    argumentNames: DeclNameArgumentsSyntax? = nil,
    _ unexpectedAfterArgumentNames: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBaseName,
      baseName,
      unexpectedBetweenBaseNameAndArgumentNames,
      argumentNames,
      unexpectedAfterArgumentNames
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBaseName?.raw,
        baseName.raw,
        unexpectedBetweenBaseNameAndArgumentNames?.raw,
        argumentNames?.raw,
        unexpectedAfterArgumentNames?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.declReferenceExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBaseName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclReferenceExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `self`
  ///  - `Self`
  ///  - `init`
  ///  - `deinit`
  ///  - `subscript`
  ///  - `<dollarIdentifier>`
  ///  - `<binaryOperator>`
  ///  - `<integerLiteral>`
  public var baseName: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclReferenceExprSyntax.self)
    }
  }

  public var unexpectedBetweenBaseNameAndArgumentNames: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclReferenceExprSyntax.self)
    }
  }

  public var argumentNames: DeclNameArgumentsSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(DeclNameArgumentsSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclReferenceExprSyntax.self)
    }
  }

  public var unexpectedAfterArgumentNames: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeclReferenceExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBaseName,
    \Self.baseName,
    \Self.unexpectedBetweenBaseNameAndArgumentNames,
    \Self.argumentNames,
    \Self.unexpectedAfterArgumentNames
  ])
}

// MARK: - DeferStmtSyntax

/// ### Children
/// 
///  - `deferKeyword`: `defer`
///  - `body`: ``CodeBlockSyntax``
public struct DeferStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .deferStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeDeferKeyword: UnexpectedNodesSyntax? = nil,
    deferKeyword: TokenSyntax = .keyword(.defer),
    _ unexpectedBetweenDeferKeywordAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeDeferKeyword,
      deferKeyword,
      unexpectedBetweenDeferKeywordAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeDeferKeyword?.raw,
        deferKeyword.raw,
        unexpectedBetweenDeferKeywordAndBody?.raw,
        body.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.deferStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeDeferKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeferStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `defer`.
  public var deferKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeferStmtSyntax.self)
    }
  }

  public var unexpectedBetweenDeferKeywordAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeferStmtSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeferStmtSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeferStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeDeferKeyword,
    \Self.deferKeyword,
    \Self.unexpectedBetweenDeferKeywordAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - DeinitializerDeclSyntax

/// A `deinit` declaration
/// 
/// An example of a deinitializer is
/// 
/// ```swift
/// deinit {
/// }
/// ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `deinitKeyword`: `deinit`
///  - `effectSpecifiers`: ``DeinitializerEffectSpecifiersSyntax``?
///  - `body`: ``CodeBlockSyntax``?
///
/// ### Contained in
/// 
///  - ``ABIAttributeArgumentsSyntax``.``ABIAttributeArgumentsSyntax/provider``
public struct DeinitializerDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .deinitializerDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes that are attached to the deinitializer.
  ///   - modifiers: Modifiers like `public` that are attached to the deinitializer.
  ///   - deinitKeyword: The `deinit` keyword.
  ///   - body: The deinitializer's body.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndDeinitKeyword: UnexpectedNodesSyntax? = nil,
    deinitKeyword: TokenSyntax = .keyword(.deinit),
    _ unexpectedBetweenDeinitKeywordAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
    effectSpecifiers: DeinitializerEffectSpecifiersSyntax? = nil,
    _ unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax? = nil,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndDeinitKeyword,
      deinitKeyword,
      unexpectedBetweenDeinitKeywordAndEffectSpecifiers,
      effectSpecifiers,
      unexpectedBetweenEffectSpecifiersAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndDeinitKeyword?.raw,
        deinitKeyword.raw,
        unexpectedBetweenDeinitKeywordAndEffectSpecifiers?.raw,
        effectSpecifiers?.raw,
        unexpectedBetweenEffectSpecifiersAndBody?.raw,
        body?.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.deinitializerDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  /// Attributes that are attached to the deinitializer.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> DeinitializerDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(DeinitializerDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  /// Modifiers like `public` that are attached to the deinitializer.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> DeinitializerDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(DeinitializerDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndDeinitKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  /// The `deinit` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `deinit`.
  public var deinitKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenDeinitKeywordAndEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  public var effectSpecifiers: DeinitializerEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(DeinitializerEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  /// The deinitializer's body.
  public var body: CodeBlockSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndDeinitKeyword,
    \Self.deinitKeyword,
    \Self.unexpectedBetweenDeinitKeywordAndEffectSpecifiers,
    \Self.effectSpecifiers,
    \Self.unexpectedBetweenEffectSpecifiersAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - DeinitializerEffectSpecifiersSyntax

/// ### Children
/// 
///  - `asyncSpecifier`: `async`?
///
/// ### Contained in
/// 
///  - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/effectSpecifiers``
public struct DeinitializerEffectSpecifiersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .deinitializerEffectSpecifiers else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - asyncSpecifier: The `async` keyword.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? = nil,
    asyncSpecifier: TokenSyntax? = nil,
    _ unexpectedAfterAsyncSpecifier: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeAsyncSpecifier, asyncSpecifier, unexpectedAfterAsyncSpecifier))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeAsyncSpecifier?.raw, asyncSpecifier?.raw, unexpectedAfterAsyncSpecifier?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.deinitializerEffectSpecifiers,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerEffectSpecifiersSyntax.self)
    }
  }

  /// The `async` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `async`.
  public var asyncSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerEffectSpecifiersSyntax.self)
    }
  }

  public var unexpectedAfterAsyncSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DeinitializerEffectSpecifiersSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeAsyncSpecifier, \Self.asyncSpecifier, \Self.unexpectedAfterAsyncSpecifier])
}

// MARK: - DerivativeAttributeArgumentsSyntax

/// The arguments for the '@derivative(of:)' and '@transpose(of:)' attributes: the 'of:' label, the original declaration name, and an optional differentiability parameter list.
///
/// ### Children
/// 
///  - `ofLabel`: `of`
///  - `colon`: `:`
///  - `originalDeclName`: ``ExprSyntax``
///  - `period`: `.`?
///  - `accessorSpecifier`: (`get` | `set` | `_modify`)?
///  - `comma`: `,`?
///  - `arguments`: ``DifferentiabilityWithRespectToArgumentSyntax``?
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct DerivativeAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .derivativeAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - ofLabel: The "of" label.
  ///   - colon: The colon separating the "of" label and the original declaration name.
  ///   - originalDeclName: The referenced original declaration name.
  ///   - period: The period separating the original declaration name and the accessor name.
  ///   - accessorSpecifier: The accessor name.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeOfLabel: UnexpectedNodesSyntax? = nil,
    ofLabel: TokenSyntax = .keyword(.of),
    _ unexpectedBetweenOfLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndOriginalDeclName: UnexpectedNodesSyntax? = nil,
    originalDeclName: some ExprSyntaxProtocol,
    _ unexpectedBetweenOriginalDeclNameAndPeriod: UnexpectedNodesSyntax? = nil,
    period: TokenSyntax? = nil,
    _ unexpectedBetweenPeriodAndAccessorSpecifier: UnexpectedNodesSyntax? = nil,
    accessorSpecifier: TokenSyntax? = nil,
    _ unexpectedBetweenAccessorSpecifierAndComma: UnexpectedNodesSyntax? = nil,
    comma: TokenSyntax? = nil,
    _ unexpectedBetweenCommaAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: DifferentiabilityWithRespectToArgumentSyntax? = nil,
    _ unexpectedAfterArguments: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeOfLabel,
      ofLabel,
      unexpectedBetweenOfLabelAndColon,
      colon,
      unexpectedBetweenColonAndOriginalDeclName,
      originalDeclName,
      unexpectedBetweenOriginalDeclNameAndPeriod,
      period,
      unexpectedBetweenPeriodAndAccessorSpecifier,
      accessorSpecifier,
      unexpectedBetweenAccessorSpecifierAndComma,
      comma,
      unexpectedBetweenCommaAndArguments,
      arguments,
      unexpectedAfterArguments
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeOfLabel?.raw,
        ofLabel.raw,
        unexpectedBetweenOfLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndOriginalDeclName?.raw,
        originalDeclName.raw,
        unexpectedBetweenOriginalDeclNameAndPeriod?.raw,
        period?.raw,
        unexpectedBetweenPeriodAndAccessorSpecifier?.raw,
        accessorSpecifier?.raw,
        unexpectedBetweenAccessorSpecifierAndComma?.raw,
        comma?.raw,
        unexpectedBetweenCommaAndArguments?.raw,
        arguments?.raw,
        unexpectedAfterArguments?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.derivativeAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeOfLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  /// The "of" label.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `of`.
  public var ofLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenOfLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  /// The colon separating the "of" label and the original declaration name.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndOriginalDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  /// The referenced original declaration name.
  public var originalDeclName: ExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenOriginalDeclNameAndPeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  /// The period separating the original declaration name and the accessor name.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `.`.
  public var period: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenPeriodAndAccessorSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  /// The accessor name.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `get`
  ///  - `set`
  ///  - `_modify`
  public var accessorSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenAccessorSpecifierAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var comma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenCommaAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var arguments: DifferentiabilityWithRespectToArgumentSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DerivativeAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeOfLabel,
    \Self.ofLabel,
    \Self.unexpectedBetweenOfLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndOriginalDeclName,
    \Self.originalDeclName,
    \Self.unexpectedBetweenOriginalDeclNameAndPeriod,
    \Self.period,
    \Self.unexpectedBetweenPeriodAndAccessorSpecifier,
    \Self.accessorSpecifier,
    \Self.unexpectedBetweenAccessorSpecifierAndComma,
    \Self.comma,
    \Self.unexpectedBetweenCommaAndArguments,
    \Self.arguments,
    \Self.unexpectedAfterArguments
  ])
}

// MARK: - DesignatedTypeSyntax

/// ### Children
/// 
///  - `leadingComma`: `,`
///  - `name`: ``TokenSyntax``
///
/// ### Contained in
/// 
///  - ``DesignatedTypeListSyntax``
public struct DesignatedTypeSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .designatedType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeadingComma: UnexpectedNodesSyntax? = nil,
    leadingComma: TokenSyntax = .commaToken(),
    _ unexpectedBetweenLeadingCommaAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedAfterName: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeadingComma,
      leadingComma,
      unexpectedBetweenLeadingCommaAndName,
      name,
      unexpectedAfterName
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeadingComma?.raw,
        leadingComma.raw,
        unexpectedBetweenLeadingCommaAndName?.raw,
        name.raw,
        unexpectedAfterName?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.designatedType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeadingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DesignatedTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var leadingComma: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DesignatedTypeSyntax.self)
    }
  }

  public var unexpectedBetweenLeadingCommaAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DesignatedTypeSyntax.self)
    }
  }

  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DesignatedTypeSyntax.self)
    }
  }

  public var unexpectedAfterName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DesignatedTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeadingComma,
    \Self.leadingComma,
    \Self.unexpectedBetweenLeadingCommaAndName,
    \Self.name,
    \Self.unexpectedAfterName
  ])
}

// MARK: - DictionaryElementSyntax

/// An element inside a dictionary literal.
///
/// ### Children
/// 
///  - `key`: ``ExprSyntax``
///  - `colon`: `:`
///  - `value`: ``ExprSyntax``
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``DictionaryElementListSyntax``
public struct DictionaryElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .dictionaryElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeKey: UnexpectedNodesSyntax? = nil,
    key: some ExprSyntaxProtocol,
    _ unexpectedBetweenKeyAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
    value: some ExprSyntaxProtocol,
    _ unexpectedBetweenValueAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeKey,
      key,
      unexpectedBetweenKeyAndColon,
      colon,
      unexpectedBetweenColonAndValue,
      value,
      unexpectedBetweenValueAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeKey?.raw,
        key.raw,
        unexpectedBetweenKeyAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndValue?.raw,
        value.raw,
        unexpectedBetweenValueAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.dictionaryElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeKey: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public var key: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public var unexpectedBetweenKeyAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public var value: ExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public var unexpectedBetweenValueAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryElementSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeKey,
    \Self.key,
    \Self.unexpectedBetweenKeyAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndValue,
    \Self.value,
    \Self.unexpectedBetweenValueAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - DictionaryExprSyntax

/// A dictionary literal
///
/// ### Children
/// 
///  - `leftSquare`: `[`
///  - `content`: (`:` | ``DictionaryElementListSyntax``)
///  - `rightSquare`: `]`
public struct DictionaryExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public enum Content: SyntaxChildChoices, SyntaxHashable {
    /// ### Tokens
    /// 
    /// For syntax trees generated by the parser, this is guaranteed to be `:`.
    case colon(TokenSyntax)
    case elements(DictionaryElementListSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .colon(let node):
        return node._syntaxNode
      case .elements(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: TokenSyntax) {
      self = .colon(node)
    }

    public init(_ node: DictionaryElementListSyntax) {
      self = .elements(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(TokenSyntax.self) {
        self = .colon(node)
      } else if let node = node.as(DictionaryElementListSyntax.self) {
        self = .elements(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TokenSyntax.self), .node(DictionaryElementListSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``TokenSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: TokenSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``TokenSyntax``.
    ///
    /// - Returns: An instance of ``TokenSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: TokenSyntax.Type) -> TokenSyntax? {
      return TokenSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``TokenSyntax``.
    ///
    /// - Returns: An instance of ``TokenSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: TokenSyntax.Type) -> TokenSyntax {
      return self.as(TokenSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DictionaryElementListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DictionaryElementListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DictionaryElementListSyntax``.
    ///
    /// - Returns: An instance of ``DictionaryElementListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DictionaryElementListSyntax.Type) -> DictionaryElementListSyntax? {
      return DictionaryElementListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DictionaryElementListSyntax``.
    ///
    /// - Returns: An instance of ``DictionaryElementListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DictionaryElementListSyntax.Type) -> DictionaryElementListSyntax {
      return self.as(DictionaryElementListSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .dictionaryExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
    leftSquare: TokenSyntax = .leftSquareToken(),
    _ unexpectedBetweenLeftSquareAndContent: UnexpectedNodesSyntax? = nil,
    content: Content,
    _ unexpectedBetweenContentAndRightSquare: UnexpectedNodesSyntax? = nil,
    rightSquare: TokenSyntax = .rightSquareToken(),
    _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftSquare,
      leftSquare,
      unexpectedBetweenLeftSquareAndContent,
      content,
      unexpectedBetweenContentAndRightSquare,
      rightSquare,
      unexpectedAfterRightSquare
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftSquare?.raw,
        leftSquare.raw,
        unexpectedBetweenLeftSquareAndContent?.raw,
        content.raw,
        unexpectedBetweenContentAndRightSquare?.raw,
        rightSquare.raw,
        unexpectedAfterRightSquare?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.dictionaryExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `[`.
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  public var unexpectedBetweenLeftSquareAndContent: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  public var content: Content {
    get {
      return Syntax(self).child(at: 3)!.cast(Content.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  public var unexpectedBetweenContentAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `]`.
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftSquare,
    \Self.leftSquare,
    \Self.unexpectedBetweenLeftSquareAndContent,
    \Self.content,
    \Self.unexpectedBetweenContentAndRightSquare,
    \Self.rightSquare,
    \Self.unexpectedAfterRightSquare
  ])
}

// MARK: - DictionaryTypeSyntax

/// ### Children
/// 
///  - `leftSquare`: `[`
///  - `key`: ``TypeSyntax``
///  - `colon`: `:`
///  - `value`: ``TypeSyntax``
///  - `rightSquare`: `]`
public struct DictionaryTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .dictionaryType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
    leftSquare: TokenSyntax = .leftSquareToken(),
    _ unexpectedBetweenLeftSquareAndKey: UnexpectedNodesSyntax? = nil,
    key: some TypeSyntaxProtocol,
    _ unexpectedBetweenKeyAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
    value: some TypeSyntaxProtocol,
    _ unexpectedBetweenValueAndRightSquare: UnexpectedNodesSyntax? = nil,
    rightSquare: TokenSyntax = .rightSquareToken(),
    _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftSquare,
      leftSquare,
      unexpectedBetweenLeftSquareAndKey,
      key,
      unexpectedBetweenKeyAndColon,
      colon,
      unexpectedBetweenColonAndValue,
      value,
      unexpectedBetweenValueAndRightSquare,
      rightSquare,
      unexpectedAfterRightSquare
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftSquare?.raw,
        leftSquare.raw,
        unexpectedBetweenLeftSquareAndKey?.raw,
        key.raw,
        unexpectedBetweenKeyAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndValue?.raw,
        value.raw,
        unexpectedBetweenValueAndRightSquare?.raw,
        rightSquare.raw,
        unexpectedAfterRightSquare?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.dictionaryType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `[`.
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var unexpectedBetweenLeftSquareAndKey: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var key: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var unexpectedBetweenKeyAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var value: TypeSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var unexpectedBetweenValueAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `]`.
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DictionaryTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftSquare,
    \Self.leftSquare,
    \Self.unexpectedBetweenLeftSquareAndKey,
    \Self.key,
    \Self.unexpectedBetweenKeyAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndValue,
    \Self.value,
    \Self.unexpectedBetweenValueAndRightSquare,
    \Self.rightSquare,
    \Self.unexpectedAfterRightSquare
  ])
}

// MARK: - DifferentiabilityArgumentSyntax

/// A differentiability argument: either the "self" identifier, a function parameter name, or a function parameter index.
///
/// ### Children
/// 
///  - `argument`: (`<identifier>` | `<integerLiteral>` | `self`)
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``DifferentiabilityArgumentListSyntax``
///  - ``DifferentiabilityWithRespectToArgumentSyntax``.``DifferentiabilityWithRespectToArgumentSyntax/arguments``
public struct DifferentiabilityArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .differentiabilityArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeArgument: UnexpectedNodesSyntax? = nil,
    argument: TokenSyntax,
    _ unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeArgument,
      argument,
      unexpectedBetweenArgumentAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeArgument?.raw,
        argument.raw,
        unexpectedBetweenArgumentAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.differentiabilityArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeArgument: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `<integerLiteral>`
  ///  - `self`
  public var argument: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeArgument,
    \Self.argument,
    \Self.unexpectedBetweenArgumentAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - DifferentiabilityArgumentsSyntax

/// The differentiability arguments.
///
/// ### Children
/// 
///  - `leftParen`: `(`
///  - `arguments`: ``DifferentiabilityArgumentListSyntax``
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``DifferentiabilityWithRespectToArgumentSyntax``.``DifferentiabilityWithRespectToArgumentSyntax/arguments``
public struct DifferentiabilityArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .differentiabilityArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - arguments: The parameters for differentiation.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: DifferentiabilityArgumentListSyntax,
    _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndArguments?.raw,
        arguments.raw,
        unexpectedBetweenArgumentsAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.differentiabilityArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  /// The parameters for differentiation.
  public var arguments: DifferentiabilityArgumentListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DifferentiabilityArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: DifferentiabilityArgumentSyntax) -> DifferentiabilityArgumentsSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.differentiabilityArgumentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(DifferentiabilityArgumentsSyntax.self)
  }

  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - DifferentiabilityWithRespectToArgumentSyntax

/// A clause containing differentiability parameters.
///
/// ### Children
/// 
///  - `wrtLabel`: `wrt`
///  - `colon`: `:`
///  - `arguments`: (``DifferentiabilityArgumentSyntax`` | ``DifferentiabilityArgumentsSyntax``)
///
/// ### Contained in
/// 
///  - ``DerivativeAttributeArgumentsSyntax``.``DerivativeAttributeArgumentsSyntax/arguments``
///  - ``DifferentiableAttributeArgumentsSyntax``.``DifferentiableAttributeArgumentsSyntax/arguments``
public struct DifferentiabilityWithRespectToArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Arguments: SyntaxChildChoices, SyntaxHashable {
    case argument(DifferentiabilityArgumentSyntax)
    case argumentList(DifferentiabilityArgumentsSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .argument(let node):
        return node._syntaxNode
      case .argumentList(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: DifferentiabilityArgumentSyntax) {
      self = .argument(node)
    }

    public init(_ node: DifferentiabilityArgumentsSyntax) {
      self = .argumentList(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(DifferentiabilityArgumentSyntax.self) {
        self = .argument(node)
      } else if let node = node.as(DifferentiabilityArgumentsSyntax.self) {
        self = .argumentList(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(DifferentiabilityArgumentSyntax.self), .node(DifferentiabilityArgumentsSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``DifferentiabilityArgumentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DifferentiabilityArgumentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DifferentiabilityArgumentSyntax``.
    ///
    /// - Returns: An instance of ``DifferentiabilityArgumentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DifferentiabilityArgumentSyntax.Type) -> DifferentiabilityArgumentSyntax? {
      return DifferentiabilityArgumentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DifferentiabilityArgumentSyntax``.
    ///
    /// - Returns: An instance of ``DifferentiabilityArgumentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DifferentiabilityArgumentSyntax.Type) -> DifferentiabilityArgumentSyntax {
      return self.as(DifferentiabilityArgumentSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DifferentiabilityArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DifferentiabilityArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DifferentiabilityArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DifferentiabilityArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DifferentiabilityArgumentsSyntax.Type) -> DifferentiabilityArgumentsSyntax? {
      return DifferentiabilityArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DifferentiabilityArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DifferentiabilityArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DifferentiabilityArgumentsSyntax.Type) -> DifferentiabilityArgumentsSyntax {
      return self.as(DifferentiabilityArgumentsSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .differentiabilityWithRespectToArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - wrtLabel: The "wrt" label.
  ///   - colon: The colon separating "wrt" and the parameter list.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeWrtLabel: UnexpectedNodesSyntax? = nil,
    wrtLabel: TokenSyntax = .keyword(.wrt),
    _ unexpectedBetweenWrtLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: Arguments,
    _ unexpectedAfterArguments: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeWrtLabel,
      wrtLabel,
      unexpectedBetweenWrtLabelAndColon,
      colon,
      unexpectedBetweenColonAndArguments,
      arguments,
      unexpectedAfterArguments
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeWrtLabel?.raw,
        wrtLabel.raw,
        unexpectedBetweenWrtLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndArguments?.raw,
        arguments.raw,
        unexpectedAfterArguments?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.differentiabilityWithRespectToArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeWrtLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  /// The "wrt" label.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `wrt`.
  public var wrtLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenWrtLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  /// The colon separating "wrt" and the parameter list.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  public var arguments: Arguments {
    get {
      return Syntax(self).child(at: 5)!.cast(Arguments.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  public var unexpectedAfterArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeWrtLabel,
    \Self.wrtLabel,
    \Self.unexpectedBetweenWrtLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndArguments,
    \Self.arguments,
    \Self.unexpectedAfterArguments
  ])
}

// MARK: - DifferentiableAttributeArgumentsSyntax

/// The arguments for the `@differentiable` attribute: an optional differentiability kind, an optional differentiability parameter clause, and an optional 'where' clause.
///
/// ### Children
/// 
///  - `kindSpecifier`: (`_forward` | `reverse` | `_linear`)?
///  - `kindSpecifierComma`: `,`?
///  - `arguments`: ``DifferentiabilityWithRespectToArgumentSyntax``?
///  - `argumentsComma`: `,`?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct DifferentiableAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .differentiableAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - kindSpecifier: The differentiability kind, if it exists.
  ///   - kindSpecifierComma: The comma following the differentiability kind, if it exists.
  ///   - arguments: The differentiability arguments, if any exists.
  ///   - argumentsComma: The comma following the differentiability arguments clause, if it exists.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where T: Differentiable`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeKindSpecifier: UnexpectedNodesSyntax? = nil,
    kindSpecifier: TokenSyntax? = nil,
    _ unexpectedBetweenKindSpecifierAndKindSpecifierComma: UnexpectedNodesSyntax? = nil,
    kindSpecifierComma: TokenSyntax? = nil,
    _ unexpectedBetweenKindSpecifierCommaAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: DifferentiabilityWithRespectToArgumentSyntax? = nil,
    _ unexpectedBetweenArgumentsAndArgumentsComma: UnexpectedNodesSyntax? = nil,
    argumentsComma: TokenSyntax? = nil,
    _ unexpectedBetweenArgumentsCommaAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeKindSpecifier,
      kindSpecifier,
      unexpectedBetweenKindSpecifierAndKindSpecifierComma,
      kindSpecifierComma,
      unexpectedBetweenKindSpecifierCommaAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndArgumentsComma,
      argumentsComma,
      unexpectedBetweenArgumentsCommaAndGenericWhereClause,
      genericWhereClause,
      unexpectedAfterGenericWhereClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeKindSpecifier?.raw,
        kindSpecifier?.raw,
        unexpectedBetweenKindSpecifierAndKindSpecifierComma?.raw,
        kindSpecifierComma?.raw,
        unexpectedBetweenKindSpecifierCommaAndArguments?.raw,
        arguments?.raw,
        unexpectedBetweenArgumentsAndArgumentsComma?.raw,
        argumentsComma?.raw,
        unexpectedBetweenArgumentsCommaAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedAfterGenericWhereClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.differentiableAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeKindSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  /// The differentiability kind, if it exists.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `_forward`
  ///  - `reverse`
  ///  - `_linear`
  public var kindSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenKindSpecifierAndKindSpecifierComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  /// The comma following the differentiability kind, if it exists.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var kindSpecifierComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenKindSpecifierCommaAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  /// The differentiability arguments, if any exists.
  public var arguments: DifferentiabilityWithRespectToArgumentSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(DifferentiabilityWithRespectToArgumentSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentsAndArgumentsComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  /// The comma following the differentiability arguments clause, if it exists.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var argumentsComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentsCommaAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  /// A `where` clause that places additional constraints on generic parameters like `where T: Differentiable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DifferentiableAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeKindSpecifier,
    \Self.kindSpecifier,
    \Self.unexpectedBetweenKindSpecifierAndKindSpecifierComma,
    \Self.kindSpecifierComma,
    \Self.unexpectedBetweenKindSpecifierCommaAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndArgumentsComma,
    \Self.argumentsComma,
    \Self.unexpectedBetweenArgumentsCommaAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedAfterGenericWhereClause
  ])
}

// MARK: - DiscardAssignmentExprSyntax

/// A `_` that discards a value inside an assignment.
/// 
/// ### Examples
/// 
/// ```swift
/// _ = 42
/// ``` 
/// 
/// 
/// ```swift
/// if case .foo(_) = myValue
/// ```
///
/// ### Children
/// 
///  - `wildcard`: `_`
public struct DiscardAssignmentExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .discardAssignmentExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeWildcard: UnexpectedNodesSyntax? = nil,
    wildcard: TokenSyntax = .wildcardToken(),
    _ unexpectedAfterWildcard: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeWildcard, wildcard, unexpectedAfterWildcard))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeWildcard?.raw, wildcard.raw, unexpectedAfterWildcard?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.discardAssignmentExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeWildcard: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardAssignmentExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `_`.
  public var wildcard: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardAssignmentExprSyntax.self)
    }
  }

  public var unexpectedAfterWildcard: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardAssignmentExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeWildcard, \Self.wildcard, \Self.unexpectedAfterWildcard])
}

// MARK: - DiscardStmtSyntax

/// ### Children
/// 
///  - `discardKeyword`: `discard`
///  - `expression`: ``ExprSyntax``
public struct DiscardStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .discardStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeDiscardKeyword: UnexpectedNodesSyntax? = nil,
    discardKeyword: TokenSyntax = .keyword(.discard),
    _ unexpectedBetweenDiscardKeywordAndExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeDiscardKeyword,
      discardKeyword,
      unexpectedBetweenDiscardKeywordAndExpression,
      expression,
      unexpectedAfterExpression
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeDiscardKeyword?.raw,
        discardKeyword.raw,
        unexpectedBetweenDiscardKeywordAndExpression?.raw,
        expression.raw,
        unexpectedAfterExpression?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.discardStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeDiscardKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `discard`.
  public var discardKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardStmtSyntax.self)
    }
  }

  public var unexpectedBetweenDiscardKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardStmtSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardStmtSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DiscardStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeDiscardKeyword,
    \Self.discardKeyword,
    \Self.unexpectedBetweenDiscardKeywordAndExpression,
    \Self.expression,
    \Self.unexpectedAfterExpression
  ])
}

// MARK: - DoExprSyntax

/// A `do` block with one of more optional `catch` clauses.
/// 
/// This represents do blocks in both expression and statement postitions
/// (where the latter are wrapped in ExpressionStmtSyntax).
/// 
/// ### Examples
/// 
/// ```swift
/// do {
///   let x = 0
///   print(x)
/// }
/// ```
/// 
/// ```swift
/// let x = do {
///   try someThrowingFn()
/// } catch {
///   defaultValue
/// }
/// ```
///
/// - Note: Requires experimental feature `doExpressions`.
///
/// ### Children
/// 
///  - `doKeyword`: `do`
///  - `body`: ``CodeBlockSyntax``
///  - `catchClauses`: ``CatchClauseListSyntax``
@_spi(ExperimentalLanguageFeatures)
public struct DoExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .doExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeDoKeyword: UnexpectedNodesSyntax? = nil,
    doKeyword: TokenSyntax = .keyword(.do),
    _ unexpectedBetweenDoKeywordAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedBetweenBodyAndCatchClauses: UnexpectedNodesSyntax? = nil,
    catchClauses: CatchClauseListSyntax = [],
    _ unexpectedAfterCatchClauses: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeDoKeyword,
      doKeyword,
      unexpectedBetweenDoKeywordAndBody,
      body,
      unexpectedBetweenBodyAndCatchClauses,
      catchClauses,
      unexpectedAfterCatchClauses
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeDoKeyword?.raw,
        doKeyword.raw,
        unexpectedBetweenDoKeywordAndBody?.raw,
        body.raw,
        unexpectedBetweenBodyAndCatchClauses?.raw,
        catchClauses.raw,
        unexpectedAfterCatchClauses?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.doExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeDoKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `do`.
  public var doKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  public var unexpectedBetweenDoKeywordAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  public var unexpectedBetweenBodyAndCatchClauses: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  public var catchClauses: CatchClauseListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CatchClauseListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `catchClauses`
  /// collection.
  ///
  /// - param element: The new `CatchClause` to add to the node's
  ///                  `catchClauses` collection.
  /// - returns: A copy of the receiver with the provided `CatchClause`
  ///            appended to its `catchClauses` collection.
  @available(*, deprecated, message: "Use node.catchClauses.append(newElement) instead")
  public func addCatchClause(_ element: CatchClauseSyntax) -> DoExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.catchClauseList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(DoExprSyntax.self)
  }

  public var unexpectedAfterCatchClauses: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeDoKeyword,
    \Self.doKeyword,
    \Self.unexpectedBetweenDoKeywordAndBody,
    \Self.body,
    \Self.unexpectedBetweenBodyAndCatchClauses,
    \Self.catchClauses,
    \Self.unexpectedAfterCatchClauses
  ])
}

// MARK: - DoStmtSyntax

/// ### Children
/// 
///  - `doKeyword`: `do`
///  - `throwsClause`: ``ThrowsClauseSyntax``?
///  - `body`: ``CodeBlockSyntax``
///  - `catchClauses`: ``CatchClauseListSyntax``
public struct DoStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .doStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - throwsClause: The clause specifying the type of errors thrown from the 'do' block.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeDoKeyword: UnexpectedNodesSyntax? = nil,
    doKeyword: TokenSyntax = .keyword(.do),
    _ unexpectedBetweenDoKeywordAndThrowsClause: UnexpectedNodesSyntax? = nil,
    throwsClause: ThrowsClauseSyntax? = nil,
    _ unexpectedBetweenThrowsClauseAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedBetweenBodyAndCatchClauses: UnexpectedNodesSyntax? = nil,
    catchClauses: CatchClauseListSyntax = [],
    _ unexpectedAfterCatchClauses: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeDoKeyword,
      doKeyword,
      unexpectedBetweenDoKeywordAndThrowsClause,
      throwsClause,
      unexpectedBetweenThrowsClauseAndBody,
      body,
      unexpectedBetweenBodyAndCatchClauses,
      catchClauses,
      unexpectedAfterCatchClauses
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeDoKeyword?.raw,
        doKeyword.raw,
        unexpectedBetweenDoKeywordAndThrowsClause?.raw,
        throwsClause?.raw,
        unexpectedBetweenThrowsClauseAndBody?.raw,
        body.raw,
        unexpectedBetweenBodyAndCatchClauses?.raw,
        catchClauses.raw,
        unexpectedAfterCatchClauses?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.doStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeDoKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `do`.
  public var doKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  public var unexpectedBetweenDoKeywordAndThrowsClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  /// The clause specifying the type of errors thrown from the 'do' block.
  public var throwsClause: ThrowsClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ThrowsClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  public var unexpectedBetweenThrowsClauseAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  public var unexpectedBetweenBodyAndCatchClauses: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  public var catchClauses: CatchClauseListSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(CatchClauseListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `catchClauses`
  /// collection.
  ///
  /// - param element: The new `CatchClause` to add to the node's
  ///                  `catchClauses` collection.
  /// - returns: A copy of the receiver with the provided `CatchClause`
  ///            appended to its `catchClauses` collection.
  @available(*, deprecated, message: "Use node.catchClauses.append(newElement) instead")
  public func addCatchClause(_ element: CatchClauseSyntax) -> DoStmtSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[7] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.catchClauseList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 7,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(DoStmtSyntax.self)
  }

  public var unexpectedAfterCatchClauses: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DoStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeDoKeyword,
    \Self.doKeyword,
    \Self.unexpectedBetweenDoKeywordAndThrowsClause,
    \Self.throwsClause,
    \Self.unexpectedBetweenThrowsClauseAndBody,
    \Self.body,
    \Self.unexpectedBetweenBodyAndCatchClauses,
    \Self.catchClauses,
    \Self.unexpectedAfterCatchClauses
  ])
}

// MARK: - DocumentationAttributeArgumentSyntax

/// ### Children
/// 
///  - `label`: (`visibility` | `metadata`)
///  - `colon`: `:`
///  - `value`: ((`<identifier>` | `private` | `fileprivate` | `internal` | `public` | `open`) | ``StringLiteralExprSyntax``)
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``DocumentationAttributeArgumentListSyntax``
public struct DocumentationAttributeArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Value: SyntaxChildChoices, SyntaxHashable {
    /// ### Tokens
    /// 
    /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
    ///  - `<identifier>`
    ///  - `private`
    ///  - `fileprivate`
    ///  - `internal`
    ///  - `public`
    ///  - `open`
    case token(TokenSyntax)
    case string(StringLiteralExprSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .token(let node):
        return node._syntaxNode
      case .string(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: TokenSyntax) {
      self = .token(node)
    }

    public init(_ node: StringLiteralExprSyntax) {
      self = .string(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(TokenSyntax.self) {
        self = .token(node)
      } else if let node = node.as(StringLiteralExprSyntax.self) {
        self = .string(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TokenSyntax.self), .node(StringLiteralExprSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``TokenSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: TokenSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``TokenSyntax``.
    ///
    /// - Returns: An instance of ``TokenSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: TokenSyntax.Type) -> TokenSyntax? {
      return TokenSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``TokenSyntax``.
    ///
    /// - Returns: An instance of ``TokenSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: TokenSyntax.Type) -> TokenSyntax {
      return self.as(TokenSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``StringLiteralExprSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: StringLiteralExprSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``StringLiteralExprSyntax``.
    ///
    /// - Returns: An instance of ``StringLiteralExprSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: StringLiteralExprSyntax.Type) -> StringLiteralExprSyntax? {
      return StringLiteralExprSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``StringLiteralExprSyntax``.
    ///
    /// - Returns: An instance of ``StringLiteralExprSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: StringLiteralExprSyntax.Type) -> StringLiteralExprSyntax {
      return self.as(StringLiteralExprSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .documentationAttributeArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingComma: A trailing comma if this argument is followed by another one
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
    label: TokenSyntax,
    _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
    value: Value,
    _ unexpectedBetweenValueAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLabel,
      label,
      unexpectedBetweenLabelAndColon,
      colon,
      unexpectedBetweenColonAndValue,
      value,
      unexpectedBetweenValueAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLabel?.raw,
        label.raw,
        unexpectedBetweenLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndValue?.raw,
        value.raw,
        unexpectedBetweenValueAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.documentationAttributeArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `visibility`
  ///  - `metadata`
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  public var value: Value {
    get {
      return Syntax(self).child(at: 5)!.cast(Value.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenValueAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  /// A trailing comma if this argument is followed by another one
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DocumentationAttributeArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLabel,
    \Self.label,
    \Self.unexpectedBetweenLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndValue,
    \Self.value,
    \Self.unexpectedBetweenValueAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - DynamicReplacementAttributeArgumentsSyntax

/// The arguments for the '@_dynamicReplacement' attribute
///
/// ### Children
/// 
///  - `forLabel`: `for`
///  - `colon`: `:`
///  - `declName`: ``DeclReferenceExprSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct DynamicReplacementAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .dynamicReplacementAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeForLabel: UnexpectedNodesSyntax? = nil,
    forLabel: TokenSyntax = .keyword(.for),
    _ unexpectedBetweenForLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndDeclName: UnexpectedNodesSyntax? = nil,
    declName: DeclReferenceExprSyntax,
    _ unexpectedAfterDeclName: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeForLabel,
      forLabel,
      unexpectedBetweenForLabelAndColon,
      colon,
      unexpectedBetweenColonAndDeclName,
      declName,
      unexpectedAfterDeclName
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeForLabel?.raw,
        forLabel.raw,
        unexpectedBetweenForLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndDeclName?.raw,
        declName.raw,
        unexpectedAfterDeclName?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.dynamicReplacementAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeForLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `for`.
  public var forLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenForLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  public var declName: DeclReferenceExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(DeclReferenceExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(DynamicReplacementAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeForLabel,
    \Self.forLabel,
    \Self.unexpectedBetweenForLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndDeclName,
    \Self.declName,
    \Self.unexpectedAfterDeclName
  ])
}
