//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - RegexLiteralExprSyntax

/// ### Children
/// 
///  - `openingPounds`: `<regexPoundDelimiter>`?
///  - `openingSlash`: `/`
///  - `regex`: `<regexLiteralPattern>`
///  - `closingSlash`: `/`
///  - `closingPounds`: `<regexPoundDelimiter>`?
public struct RegexLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .regexLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeOpeningPounds: UnexpectedNodesSyntax? = nil,
    openingPounds: TokenSyntax? = nil,
    _ unexpectedBetweenOpeningPoundsAndOpeningSlash: UnexpectedNodesSyntax? = nil,
    openingSlash: TokenSyntax = .regexSlashToken(),
    _ unexpectedBetweenOpeningSlashAndRegex: UnexpectedNodesSyntax? = nil,
    regex: TokenSyntax,
    _ unexpectedBetweenRegexAndClosingSlash: UnexpectedNodesSyntax? = nil,
    closingSlash: TokenSyntax = .regexSlashToken(),
    _ unexpectedBetweenClosingSlashAndClosingPounds: UnexpectedNodesSyntax? = nil,
    closingPounds: TokenSyntax? = nil,
    _ unexpectedAfterClosingPounds: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeOpeningPounds,
      openingPounds,
      unexpectedBetweenOpeningPoundsAndOpeningSlash,
      openingSlash,
      unexpectedBetweenOpeningSlashAndRegex,
      regex,
      unexpectedBetweenRegexAndClosingSlash,
      closingSlash,
      unexpectedBetweenClosingSlashAndClosingPounds,
      closingPounds,
      unexpectedAfterClosingPounds
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeOpeningPounds?.raw,
        openingPounds?.raw,
        unexpectedBetweenOpeningPoundsAndOpeningSlash?.raw,
        openingSlash.raw,
        unexpectedBetweenOpeningSlashAndRegex?.raw,
        regex.raw,
        unexpectedBetweenRegexAndClosingSlash?.raw,
        closingSlash.raw,
        unexpectedBetweenClosingSlashAndClosingPounds?.raw,
        closingPounds?.raw,
        unexpectedAfterClosingPounds?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.regexLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeOpeningPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<regexPoundDelimiter>`.
  public var openingPounds: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenOpeningPoundsAndOpeningSlash: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `/`.
  public var openingSlash: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenOpeningSlashAndRegex: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<regexLiteralPattern>`.
  public var regex: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenRegexAndClosingSlash: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `/`.
  public var closingSlash: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenClosingSlashAndClosingPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<regexPoundDelimiter>`.
  public var closingPounds: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  public var unexpectedAfterClosingPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RegexLiteralExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeOpeningPounds,
    \Self.openingPounds,
    \Self.unexpectedBetweenOpeningPoundsAndOpeningSlash,
    \Self.openingSlash,
    \Self.unexpectedBetweenOpeningSlashAndRegex,
    \Self.regex,
    \Self.unexpectedBetweenRegexAndClosingSlash,
    \Self.closingSlash,
    \Self.unexpectedBetweenClosingSlashAndClosingPounds,
    \Self.closingPounds,
    \Self.unexpectedAfterClosingPounds
  ])
}

// MARK: - RepeatStmtSyntax

/// ### Children
/// 
///  - `repeatKeyword`: `repeat`
///  - `body`: ``CodeBlockSyntax``
///  - `whileKeyword`: `while`
///  - `condition`: ``ExprSyntax``
public struct RepeatStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .repeatStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeRepeatKeyword: UnexpectedNodesSyntax? = nil,
    repeatKeyword: TokenSyntax = .keyword(.repeat),
    _ unexpectedBetweenRepeatKeywordAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedBetweenBodyAndWhileKeyword: UnexpectedNodesSyntax? = nil,
    whileKeyword: TokenSyntax = .keyword(.while),
    _ unexpectedBetweenWhileKeywordAndCondition: UnexpectedNodesSyntax? = nil,
    condition: some ExprSyntaxProtocol,
    _ unexpectedAfterCondition: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeRepeatKeyword,
      repeatKeyword,
      unexpectedBetweenRepeatKeywordAndBody,
      body,
      unexpectedBetweenBodyAndWhileKeyword,
      whileKeyword,
      unexpectedBetweenWhileKeywordAndCondition,
      condition,
      unexpectedAfterCondition
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeRepeatKeyword?.raw,
        repeatKeyword.raw,
        unexpectedBetweenRepeatKeywordAndBody?.raw,
        body.raw,
        unexpectedBetweenBodyAndWhileKeyword?.raw,
        whileKeyword.raw,
        unexpectedBetweenWhileKeywordAndCondition?.raw,
        condition.raw,
        unexpectedAfterCondition?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.repeatStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeRepeatKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `repeat`.
  public var repeatKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public var unexpectedBetweenRepeatKeywordAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public var unexpectedBetweenBodyAndWhileKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `while`.
  public var whileKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public var unexpectedBetweenWhileKeywordAndCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public var condition: ExprSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public var unexpectedAfterCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(RepeatStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeRepeatKeyword,
    \Self.repeatKeyword,
    \Self.unexpectedBetweenRepeatKeywordAndBody,
    \Self.body,
    \Self.unexpectedBetweenBodyAndWhileKeyword,
    \Self.whileKeyword,
    \Self.unexpectedBetweenWhileKeywordAndCondition,
    \Self.condition,
    \Self.unexpectedAfterCondition
  ])
}

// MARK: - ReturnClauseSyntax

/// ### Children
/// 
///  - `arrow`: `->`
///  - `type`: ``TypeSyntax``
///
/// ### Contained in
/// 
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/returnClause``
///  - ``FunctionSignatureSyntax``.``FunctionSignatureSyntax/returnClause``
///  - ``FunctionTypeSyntax``.``FunctionTypeSyntax/returnClause``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/returnClause``
public struct ReturnClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .returnClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - arrow: If return type is presented, the arrow introducing the return type.
  ///   - type: The `return` type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeArrow: UnexpectedNodesSyntax? = nil,
    arrow: TokenSyntax = .arrowToken(),
    _ unexpectedBetweenArrowAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeArrow,
      arrow,
      unexpectedBetweenArrowAndType,
      type,
      unexpectedAfterType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeArrow?.raw,
        arrow.raw,
        unexpectedBetweenArrowAndType?.raw,
        type.raw,
        unexpectedAfterType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.returnClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeArrow: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnClauseSyntax.self)
    }
  }

  /// If return type is presented, the arrow introducing the return type.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `->`.
  public var arrow: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnClauseSyntax.self)
    }
  }

  public var unexpectedBetweenArrowAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnClauseSyntax.self)
    }
  }

  /// The `return` type.
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnClauseSyntax.self)
    }
  }

  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeArrow,
    \Self.arrow,
    \Self.unexpectedBetweenArrowAndType,
    \Self.type,
    \Self.unexpectedAfterType
  ])
}

// MARK: - ReturnStmtSyntax

/// ### Children
/// 
///  - `returnKeyword`: `return`
///  - `expression`: ``ExprSyntax``?
public struct ReturnStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .returnStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeReturnKeyword: UnexpectedNodesSyntax? = nil,
    returnKeyword: TokenSyntax = .keyword(.return),
    _ unexpectedBetweenReturnKeywordAndExpression: UnexpectedNodesSyntax? = nil,
    expression: (some ExprSyntaxProtocol)? = ExprSyntax?.none,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeReturnKeyword,
      returnKeyword,
      unexpectedBetweenReturnKeywordAndExpression,
      expression,
      unexpectedAfterExpression
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeReturnKeyword?.raw,
        returnKeyword.raw,
        unexpectedBetweenReturnKeywordAndExpression?.raw,
        expression?.raw,
        unexpectedAfterExpression?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.returnStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeReturnKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `return`.
  public var returnKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnStmtSyntax.self)
    }
  }

  public var unexpectedBetweenReturnKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnStmtSyntax.self)
    }
  }

  public var expression: ExprSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnStmtSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ReturnStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeReturnKeyword,
    \Self.returnKeyword,
    \Self.unexpectedBetweenReturnKeywordAndExpression,
    \Self.expression,
    \Self.unexpectedAfterExpression
  ])
}

// MARK: - SameTypeRequirementSyntax

/// ### Children
/// 
///  - `leftType`: (``TypeSyntax`` | ``ExprSyntax``)
///  - `equal`: (`<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
///  - `rightType`: (``TypeSyntax`` | ``ExprSyntax``)
///
/// ### Contained in
/// 
///  - ``GenericRequirementSyntax``.``GenericRequirementSyntax/requirement``
public struct SameTypeRequirementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum LeftType: SyntaxChildChoices, SyntaxHashable {
    case type(TypeSyntax)
    case expr(ExprSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .type(let node):
        return node._syntaxNode
      case .expr(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: some TypeSyntaxProtocol) {
      self = .type(TypeSyntax(node))
    }

    public init(_ node: some ExprSyntaxProtocol) {
      self = .expr(ExprSyntax(node))
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(TypeSyntax.self) {
        self = .type(node)
      } else if let node = node.as(ExprSyntax.self) {
        self = .expr(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TypeSyntax.self), .node(ExprSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some TypeSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some ExprSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }
  }

  public enum RightType: SyntaxChildChoices, SyntaxHashable {
    case type(TypeSyntax)
    case expr(ExprSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .type(let node):
        return node._syntaxNode
      case .expr(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: some TypeSyntaxProtocol) {
      self = .type(TypeSyntax(node))
    }

    public init(_ node: some ExprSyntaxProtocol) {
      self = .expr(ExprSyntax(node))
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(TypeSyntax.self) {
        self = .type(node)
      } else if let node = node.as(ExprSyntax.self) {
        self = .expr(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TypeSyntax.self), .node(ExprSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some TypeSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some ExprSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .sameTypeRequirement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - leftType: The left hand side type for a same type requirement. This can either be a regular type argument or an expression for value generics.
  ///   - rightType: The right hand side type for a same type requirement. This can either be a regular type argument or an expression for value generics.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftType: UnexpectedNodesSyntax? = nil,
    leftType: LeftType,
    _ unexpectedBetweenLeftTypeAndEqual: UnexpectedNodesSyntax? = nil,
    equal: TokenSyntax,
    _ unexpectedBetweenEqualAndRightType: UnexpectedNodesSyntax? = nil,
    rightType: RightType,
    _ unexpectedAfterRightType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftType,
      leftType,
      unexpectedBetweenLeftTypeAndEqual,
      equal,
      unexpectedBetweenEqualAndRightType,
      rightType,
      unexpectedAfterRightType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftType?.raw,
        leftType.raw,
        unexpectedBetweenLeftTypeAndEqual?.raw,
        equal.raw,
        unexpectedBetweenEqualAndRightType?.raw,
        rightType.raw,
        unexpectedAfterRightType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.sameTypeRequirement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  /// The left hand side type for a same type requirement. This can either be a regular type argument or an expression for value generics.
  public var leftType: LeftType {
    get {
      return Syntax(self).child(at: 1)!.cast(LeftType.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  public var unexpectedBetweenLeftTypeAndEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<binaryOperator>`
  ///  - `<prefixOperator>`
  ///  - `<postfixOperator>`
  public var equal: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  public var unexpectedBetweenEqualAndRightType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  /// The right hand side type for a same type requirement. This can either be a regular type argument or an expression for value generics.
  public var rightType: RightType {
    get {
      return Syntax(self).child(at: 5)!.cast(RightType.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  public var unexpectedAfterRightType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SameTypeRequirementSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftType,
    \Self.leftType,
    \Self.unexpectedBetweenLeftTypeAndEqual,
    \Self.equal,
    \Self.unexpectedBetweenEqualAndRightType,
    \Self.rightType,
    \Self.unexpectedAfterRightType
  ])
}

// MARK: - SequenceExprSyntax

/// A flat list of expressions before operator folding using the `SwiftOperators` library.
/// 
/// ### Examples
/// 
/// ```swift
/// 1 + 2 + 3
/// ```
///
/// ### Children
/// 
///  - `elements`: ``ExprListSyntax``
public struct SequenceExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .sequenceExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeElements: UnexpectedNodesSyntax? = nil,
    elements: ExprListSyntax,
    _ unexpectedAfterElements: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeElements, elements, unexpectedAfterElements))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeElements?.raw, elements.raw, unexpectedAfterElements?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.sequenceExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SequenceExprSyntax.self)
    }
  }

  public var elements: ExprListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SequenceExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: ExprSyntax) -> SequenceExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.exprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SequenceExprSyntax.self)
  }

  public var unexpectedAfterElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SequenceExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeElements, \Self.elements, \Self.unexpectedAfterElements])
}

// MARK: - SimpleStringLiteralExprSyntax

/// A simple string that can’t contain string interpolation and cannot have raw string delimiters.
///
/// ### Children
/// 
///  - `openingQuote`: (`"` | `"""`)
///  - `segments`: ``SimpleStringLiteralSegmentListSyntax``
///  - `closingQuote`: (`"` | `"""`)
///
/// ### Contained in
/// 
///  - ``AvailabilityLabeledArgumentSyntax``.``AvailabilityLabeledArgumentSyntax/value``
///  - ``PoundSourceLocationArgumentsSyntax``.``PoundSourceLocationArgumentsSyntax/fileName``
public struct SimpleStringLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .simpleStringLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - openingQuote: Open quote for the string literal
  ///   - segments: String content
  ///   - closingQuote: Close quote for the string literal
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeOpeningQuote: UnexpectedNodesSyntax? = nil,
    openingQuote: TokenSyntax,
    _ unexpectedBetweenOpeningQuoteAndSegments: UnexpectedNodesSyntax? = nil,
    segments: SimpleStringLiteralSegmentListSyntax,
    _ unexpectedBetweenSegmentsAndClosingQuote: UnexpectedNodesSyntax? = nil,
    closingQuote: TokenSyntax,
    _ unexpectedAfterClosingQuote: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeOpeningQuote,
      openingQuote,
      unexpectedBetweenOpeningQuoteAndSegments,
      segments,
      unexpectedBetweenSegmentsAndClosingQuote,
      closingQuote,
      unexpectedAfterClosingQuote
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeOpeningQuote?.raw,
        openingQuote.raw,
        unexpectedBetweenOpeningQuoteAndSegments?.raw,
        segments.raw,
        unexpectedBetweenSegmentsAndClosingQuote?.raw,
        closingQuote.raw,
        unexpectedAfterClosingQuote?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.simpleStringLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeOpeningQuote: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  /// Open quote for the string literal
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `"`
  ///  - `"""`
  public var openingQuote: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenOpeningQuoteAndSegments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  /// String content
  public var segments: SimpleStringLiteralSegmentListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(SimpleStringLiteralSegmentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `segments`
  /// collection.
  ///
  /// - param element: The new `Segment` to add to the node's
  ///                  `segments` collection.
  /// - returns: A copy of the receiver with the provided `Segment`
  ///            appended to its `segments` collection.
  @available(*, deprecated, message: "Use node.segments.append(newElement) instead")
  public func addSegment(_ element: StringSegmentSyntax) -> SimpleStringLiteralExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.simpleStringLiteralSegmentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SimpleStringLiteralExprSyntax.self)
  }

  public var unexpectedBetweenSegmentsAndClosingQuote: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  /// Close quote for the string literal
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `"`
  ///  - `"""`
  public var closingQuote: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  public var unexpectedAfterClosingQuote: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleStringLiteralExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeOpeningQuote,
    \Self.openingQuote,
    \Self.unexpectedBetweenOpeningQuoteAndSegments,
    \Self.segments,
    \Self.unexpectedBetweenSegmentsAndClosingQuote,
    \Self.closingQuote,
    \Self.unexpectedAfterClosingQuote
  ])
}

// MARK: - SimpleTypeSpecifierSyntax

/// A specifier that can be attached to a type to eg. mark a parameter as `inout` or `consuming`
///
/// ### Children
/// 
///  - `specifier`: (`inout` | `__shared` | `__owned` | `isolated` | `_const` | `borrowing` | `consuming` | `sending`)
///
/// ### Contained in
/// 
///  - ``TypeSpecifierListSyntax``
public struct SimpleTypeSpecifierSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .simpleTypeSpecifier else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - specifier: The specifier token that's attached to the type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeSpecifier: UnexpectedNodesSyntax? = nil,
    specifier: TokenSyntax,
    _ unexpectedAfterSpecifier: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeSpecifier, specifier, unexpectedAfterSpecifier))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeSpecifier?.raw, specifier.raw, unexpectedAfterSpecifier?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.simpleTypeSpecifier,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleTypeSpecifierSyntax.self)
    }
  }

  /// The specifier token that's attached to the type.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `inout`
  ///  - `__shared`
  ///  - `__owned`
  ///  - `isolated`
  ///  - `_const`
  ///  - `borrowing`
  ///  - `consuming`
  ///  - `sending`
  public var specifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleTypeSpecifierSyntax.self)
    }
  }

  public var unexpectedAfterSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SimpleTypeSpecifierSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeSpecifier, \Self.specifier, \Self.unexpectedAfterSpecifier])
}

// MARK: - SomeOrAnyTypeSyntax

/// ### Children
/// 
///  - `someOrAnySpecifier`: (`some` | `any`)
///  - `constraint`: ``TypeSyntax``
public struct SomeOrAnyTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .someOrAnyType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeSomeOrAnySpecifier: UnexpectedNodesSyntax? = nil,
    someOrAnySpecifier: TokenSyntax,
    _ unexpectedBetweenSomeOrAnySpecifierAndConstraint: UnexpectedNodesSyntax? = nil,
    constraint: some TypeSyntaxProtocol,
    _ unexpectedAfterConstraint: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeSomeOrAnySpecifier,
      someOrAnySpecifier,
      unexpectedBetweenSomeOrAnySpecifierAndConstraint,
      constraint,
      unexpectedAfterConstraint
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeSomeOrAnySpecifier?.raw,
        someOrAnySpecifier.raw,
        unexpectedBetweenSomeOrAnySpecifierAndConstraint?.raw,
        constraint.raw,
        unexpectedAfterConstraint?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.someOrAnyType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeSomeOrAnySpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SomeOrAnyTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `some`
  ///  - `any`
  public var someOrAnySpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SomeOrAnyTypeSyntax.self)
    }
  }

  public var unexpectedBetweenSomeOrAnySpecifierAndConstraint: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SomeOrAnyTypeSyntax.self)
    }
  }

  public var constraint: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SomeOrAnyTypeSyntax.self)
    }
  }

  public var unexpectedAfterConstraint: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SomeOrAnyTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeSomeOrAnySpecifier,
    \Self.someOrAnySpecifier,
    \Self.unexpectedBetweenSomeOrAnySpecifierAndConstraint,
    \Self.constraint,
    \Self.unexpectedAfterConstraint
  ])
}

// MARK: - SourceFileSyntax

/// ### Children
/// 
///  - `shebang`: `<shebang>`?
///  - `statements`: ``CodeBlockItemListSyntax``
///  - `endOfFileToken`: ``
public struct SourceFileSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .sourceFile else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - shebang: A shebang can specify the path of the compiler when using Swift source file as a script.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeShebang: UnexpectedNodesSyntax? = nil,
    shebang: TokenSyntax? = nil,
    _ unexpectedBetweenShebangAndStatements: UnexpectedNodesSyntax? = nil,
    statements: CodeBlockItemListSyntax,
    _ unexpectedBetweenStatementsAndEndOfFileToken: UnexpectedNodesSyntax? = nil,
    endOfFileToken: TokenSyntax = .endOfFileToken(),
    _ unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeShebang,
      shebang,
      unexpectedBetweenShebangAndStatements,
      statements,
      unexpectedBetweenStatementsAndEndOfFileToken,
      endOfFileToken,
      unexpectedAfterEndOfFileToken
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeShebang?.raw,
        shebang?.raw,
        unexpectedBetweenShebangAndStatements?.raw,
        statements.raw,
        unexpectedBetweenStatementsAndEndOfFileToken?.raw,
        endOfFileToken.raw,
        unexpectedAfterEndOfFileToken?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.sourceFile,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeShebang: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  /// A shebang can specify the path of the compiler when using Swift source file as a script.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<shebang>`.
  public var shebang: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  public var unexpectedBetweenShebangAndStatements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  public var statements: CodeBlockItemListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(CodeBlockItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `statements`
  /// collection.
  ///
  /// - param element: The new `Statement` to add to the node's
  ///                  `statements` collection.
  /// - returns: A copy of the receiver with the provided `Statement`
  ///            appended to its `statements` collection.
  @available(*, deprecated, message: "Use node.statements.append(newElement) instead")
  public func addStatement(_ element: CodeBlockItemSyntax) -> SourceFileSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.codeBlockItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SourceFileSyntax.self)
  }

  public var unexpectedBetweenStatementsAndEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be ``.
  public var endOfFileToken: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  public var unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SourceFileSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeShebang,
    \Self.shebang,
    \Self.unexpectedBetweenShebangAndStatements,
    \Self.statements,
    \Self.unexpectedBetweenStatementsAndEndOfFileToken,
    \Self.endOfFileToken,
    \Self.unexpectedAfterEndOfFileToken
  ])
}

// MARK: - SpecializeAvailabilityArgumentSyntax

/// The availability argument for the _specialize attribute
///
/// ### Children
/// 
///  - `availabilityLabel`: `availability`
///  - `colon`: `:`
///  - `availabilityArguments`: ``AvailabilityArgumentListSyntax``
///  - `semicolon`: `;`
///
/// ### Contained in
/// 
///  - ``SpecializeAttributeArgumentListSyntax``
public struct SpecializeAvailabilityArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .specializeAvailabilityArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - availabilityLabel: The label of the argument
  ///   - colon: The colon separating the label and the value
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAvailabilityLabel: UnexpectedNodesSyntax? = nil,
    availabilityLabel: TokenSyntax = .keyword(.availability),
    _ unexpectedBetweenAvailabilityLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndAvailabilityArguments: UnexpectedNodesSyntax? = nil,
    availabilityArguments: AvailabilityArgumentListSyntax,
    _ unexpectedBetweenAvailabilityArgumentsAndSemicolon: UnexpectedNodesSyntax? = nil,
    semicolon: TokenSyntax = .semicolonToken(),
    _ unexpectedAfterSemicolon: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAvailabilityLabel,
      availabilityLabel,
      unexpectedBetweenAvailabilityLabelAndColon,
      colon,
      unexpectedBetweenColonAndAvailabilityArguments,
      availabilityArguments,
      unexpectedBetweenAvailabilityArgumentsAndSemicolon,
      semicolon,
      unexpectedAfterSemicolon
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAvailabilityLabel?.raw,
        availabilityLabel.raw,
        unexpectedBetweenAvailabilityLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndAvailabilityArguments?.raw,
        availabilityArguments.raw,
        unexpectedBetweenAvailabilityArgumentsAndSemicolon?.raw,
        semicolon.raw,
        unexpectedAfterSemicolon?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.specializeAvailabilityArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAvailabilityLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  /// The label of the argument
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `availability`.
  public var availabilityLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenAvailabilityLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  /// The colon separating the label and the value
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndAvailabilityArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  public var availabilityArguments: AvailabilityArgumentListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(AvailabilityArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `availabilityArguments`
  /// collection.
  ///
  /// - param element: The new `AvailabilityArgument` to add to the node's
  ///                  `availabilityArguments` collection.
  /// - returns: A copy of the receiver with the provided `AvailabilityArgument`
  ///            appended to its `availabilityArguments` collection.
  @available(*, deprecated, message: "Use node.availabilityArguments.append(newElement) instead")
  public func addAvailabilityArgument(_ element: AvailabilityArgumentSyntax) -> SpecializeAvailabilityArgumentSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.availabilityArgumentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SpecializeAvailabilityArgumentSyntax.self)
  }

  public var unexpectedBetweenAvailabilityArgumentsAndSemicolon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `;`.
  public var semicolon: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  public var unexpectedAfterSemicolon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeAvailabilityArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAvailabilityLabel,
    \Self.availabilityLabel,
    \Self.unexpectedBetweenAvailabilityLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndAvailabilityArguments,
    \Self.availabilityArguments,
    \Self.unexpectedBetweenAvailabilityArgumentsAndSemicolon,
    \Self.semicolon,
    \Self.unexpectedAfterSemicolon
  ])
}

// MARK: - SpecializeTargetFunctionArgumentSyntax

/// A labeled argument for the `@_specialize` attribute with a function decl value like `target: myFunc(_:)`
///
/// ### Children
/// 
///  - `targetLabel`: `target`
///  - `colon`: `:`
///  - `declName`: ``DeclReferenceExprSyntax``
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``SpecializeAttributeArgumentListSyntax``
public struct SpecializeTargetFunctionArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .specializeTargetFunctionArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - targetLabel: The label of the argument
  ///   - colon: The colon separating the label and the value
  ///   - declName: The value for this argument
  ///   - trailingComma: A trailing comma if this argument is followed by another one
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeTargetLabel: UnexpectedNodesSyntax? = nil,
    targetLabel: TokenSyntax = .keyword(.target),
    _ unexpectedBetweenTargetLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndDeclName: UnexpectedNodesSyntax? = nil,
    declName: DeclReferenceExprSyntax,
    _ unexpectedBetweenDeclNameAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeTargetLabel,
      targetLabel,
      unexpectedBetweenTargetLabelAndColon,
      colon,
      unexpectedBetweenColonAndDeclName,
      declName,
      unexpectedBetweenDeclNameAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeTargetLabel?.raw,
        targetLabel.raw,
        unexpectedBetweenTargetLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndDeclName?.raw,
        declName.raw,
        unexpectedBetweenDeclNameAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.specializeTargetFunctionArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeTargetLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  /// The label of the argument
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `target`.
  public var targetLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenTargetLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  /// The colon separating the label and the value
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  /// The value for this argument
  public var declName: DeclReferenceExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(DeclReferenceExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenDeclNameAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  /// A trailing comma if this argument is followed by another one
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SpecializeTargetFunctionArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeTargetLabel,
    \Self.targetLabel,
    \Self.unexpectedBetweenTargetLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndDeclName,
    \Self.declName,
    \Self.unexpectedBetweenDeclNameAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - StringLiteralExprSyntax

/// A string literal.
/// 
/// ### Examples
/// 
/// ```swift
/// "Hello \(userName())!"
/// ```
///
/// ### Children
/// 
///  - `openingPounds`: `<rawStringPoundDelimiter>`?
///  - `openingQuote`: (`"` | `"""` | `'`)
///  - `segments`: ``StringLiteralSegmentListSyntax``
///  - `closingQuote`: (`"` | `"""` | `'`)
///  - `closingPounds`: `<rawStringPoundDelimiter>`?
///
/// ### Contained in
/// 
///  - ``DocumentationAttributeArgumentSyntax``.``DocumentationAttributeArgumentSyntax/value``
///  - ``OriginallyDefinedInAttributeArgumentsSyntax``.``OriginallyDefinedInAttributeArgumentsSyntax/moduleName``
public struct StringLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .stringLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeOpeningPounds: UnexpectedNodesSyntax? = nil,
    openingPounds: TokenSyntax? = nil,
    _ unexpectedBetweenOpeningPoundsAndOpeningQuote: UnexpectedNodesSyntax? = nil,
    openingQuote: TokenSyntax,
    _ unexpectedBetweenOpeningQuoteAndSegments: UnexpectedNodesSyntax? = nil,
    segments: StringLiteralSegmentListSyntax,
    _ unexpectedBetweenSegmentsAndClosingQuote: UnexpectedNodesSyntax? = nil,
    closingQuote: TokenSyntax,
    _ unexpectedBetweenClosingQuoteAndClosingPounds: UnexpectedNodesSyntax? = nil,
    closingPounds: TokenSyntax? = nil,
    _ unexpectedAfterClosingPounds: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeOpeningPounds,
      openingPounds,
      unexpectedBetweenOpeningPoundsAndOpeningQuote,
      openingQuote,
      unexpectedBetweenOpeningQuoteAndSegments,
      segments,
      unexpectedBetweenSegmentsAndClosingQuote,
      closingQuote,
      unexpectedBetweenClosingQuoteAndClosingPounds,
      closingPounds,
      unexpectedAfterClosingPounds
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeOpeningPounds?.raw,
        openingPounds?.raw,
        unexpectedBetweenOpeningPoundsAndOpeningQuote?.raw,
        openingQuote.raw,
        unexpectedBetweenOpeningQuoteAndSegments?.raw,
        segments.raw,
        unexpectedBetweenSegmentsAndClosingQuote?.raw,
        closingQuote.raw,
        unexpectedBetweenClosingQuoteAndClosingPounds?.raw,
        closingPounds?.raw,
        unexpectedAfterClosingPounds?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.stringLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeOpeningPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<rawStringPoundDelimiter>`.
  public var openingPounds: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenOpeningPoundsAndOpeningQuote: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `"`
  ///  - `"""`
  ///  - `'`
  public var openingQuote: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenOpeningQuoteAndSegments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  public var segments: StringLiteralSegmentListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(StringLiteralSegmentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `segments`
  /// collection.
  ///
  /// - param element: The new `Segment` to add to the node's
  ///                  `segments` collection.
  /// - returns: A copy of the receiver with the provided `Segment`
  ///            appended to its `segments` collection.
  @available(*, deprecated, message: "Use node.segments.append(newElement) instead")
  public func addSegment(_ element: Syntax) -> StringLiteralExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.stringLiteralSegmentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(StringLiteralExprSyntax.self)
  }

  public var unexpectedBetweenSegmentsAndClosingQuote: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `"`
  ///  - `"""`
  ///  - `'`
  public var closingQuote: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  public var unexpectedBetweenClosingQuoteAndClosingPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<rawStringPoundDelimiter>`.
  public var closingPounds: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  public var unexpectedAfterClosingPounds: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringLiteralExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeOpeningPounds,
    \Self.openingPounds,
    \Self.unexpectedBetweenOpeningPoundsAndOpeningQuote,
    \Self.openingQuote,
    \Self.unexpectedBetweenOpeningQuoteAndSegments,
    \Self.segments,
    \Self.unexpectedBetweenSegmentsAndClosingQuote,
    \Self.closingQuote,
    \Self.unexpectedBetweenClosingQuoteAndClosingPounds,
    \Self.closingPounds,
    \Self.unexpectedAfterClosingPounds
  ])
}

// MARK: - StringSegmentSyntax

/// A literal segment inside a string segment.
/// 
/// - SeeAlso: ``ExpressionSegmentSyntax``
///
/// ### Children
/// 
///  - `content`: `<stringSegment>`
///
/// ### Contained in
/// 
///  - ``SimpleStringLiteralSegmentListSyntax``
///  - ``StringLiteralSegmentListSyntax``
public struct StringSegmentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .stringSegment else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeContent: UnexpectedNodesSyntax? = nil,
    content: TokenSyntax,
    _ unexpectedAfterContent: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeContent, content, unexpectedAfterContent))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeContent?.raw, content.raw, unexpectedAfterContent?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.stringSegment,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeContent: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringSegmentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<stringSegment>`.
  public var content: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringSegmentSyntax.self)
    }
  }

  public var unexpectedAfterContent: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StringSegmentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeContent, \Self.content, \Self.unexpectedAfterContent])
}

// MARK: - StructDeclSyntax

/// A `struct` declaration
/// 
/// An example of a struct declaration is
/// 
/// ```swift
/// struct SomeStruct {
///   let someMember: String
///   var anotherMember: Int
/// 
///   func foo() {
///     print(someMember)
///   }
/// 
///   mutating func bar() {
///     anotherMember = 42
///   }
/// }
/// ```
/// 
/// A struct declaration may be declared without any members.
/// 
/// ```swift
/// struct EmptyStruct {
/// 
/// }
/// ```
/// 
/// A struct declaration may include a type inheritance clause listing
/// one or more protocols the struct conforms to.
/// 
/// The example below uses Hashable and Equatable protocols whose members
/// are automatically synthesized by the compiler if the struct contains
/// stored members that are themselves `Hashable` and `Equatable`.
/// 
/// ```swift
/// struct AdvancedStruct: Hashable, Equatable {
///   let someMember: String
///   var anotherMember: Int
/// }
/// ```
/// 
/// A struct declaration may include a generic parameter clause as well
/// as a generic where clause.
/// 
/// ```swift
/// struct Stack<Element> {
///   var items: [Element] = []
/// 
///   mutating func push(_ item: Element) {
///     items.append(item)
///   }
/// 
///   mutating func pop() -> Element {
///     return items.removeLast()
///   }
/// }
/// ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `structKeyword`: `struct`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct StructDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .structDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes that are attached to the struct declaration.
  ///   - modifiers: Modifiers like `public` that are attached to the struct declaration.
  ///   - structKeyword: The `struct` keyword for this declaration.
  ///   - name: Declares the name of this struct. If the name matches a reserved keyword use backticks to escape it.
  ///   - genericParameterClause: The generic parameters, if any, of the struct declaration.
  ///   - inheritanceClause: The struct declaration inheritance clause describing one or more conformances for this struct declaration.
  ///   - genericWhereClause: The `where` clause that applies to the generic parameters of this struct declaration.
  ///   - memberBlock: The members of the struct declaration. Because struct extension declarations may declare additional members the contents of this member block isn't guaranteed to be a complete list of members for this type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndStructKeyword: UnexpectedNodesSyntax? = nil,
    structKeyword: TokenSyntax = .keyword(.struct),
    _ unexpectedBetweenStructKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    _ unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    memberBlock: MemberBlockSyntax,
    _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndStructKeyword,
      structKeyword,
      unexpectedBetweenStructKeywordAndName,
      name,
      unexpectedBetweenNameAndGenericParameterClause,
      genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndInheritanceClause,
      inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock,
      unexpectedAfterMemberBlock
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndStructKeyword?.raw,
        structKeyword.raw,
        unexpectedBetweenStructKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndGenericParameterClause?.raw,
        genericParameterClause?.raw,
        unexpectedBetweenGenericParameterClauseAndInheritanceClause?.raw,
        inheritanceClause?.raw,
        unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw,
        memberBlock.raw,
        unexpectedAfterMemberBlock?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.structDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// Attributes that are attached to the struct declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> StructDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(StructDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// Modifiers like `public` that are attached to the struct declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> StructDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(StructDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndStructKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// The `struct` keyword for this declaration.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `struct`.
  public var structKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public var unexpectedBetweenStructKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// Declares the name of this struct. If the name matches a reserved keyword use backticks to escape it.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// The generic parameters, if any, of the struct declaration.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// The struct declaration inheritance clause describing one or more conformances for this struct declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// The `where` clause that applies to the generic parameters of this struct declaration.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  /// The members of the struct declaration. Because struct extension declarations may declare additional members the contents of this member block isn't guaranteed to be a complete list of members for this type.
  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(StructDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndStructKeyword,
    \Self.structKeyword,
    \Self.unexpectedBetweenStructKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndGenericParameterClause,
    \Self.genericParameterClause,
    \Self.unexpectedBetweenGenericParameterClauseAndInheritanceClause,
    \Self.inheritanceClause,
    \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock,
    \Self.memberBlock,
    \Self.unexpectedAfterMemberBlock
  ])
}

// MARK: - SubscriptCallExprSyntax

/// ### Children
/// 
///  - `calledExpression`: ``ExprSyntax``
///  - `leftSquare`: `[`
///  - `arguments`: ``LabeledExprListSyntax``
///  - `rightSquare`: `]`
///  - `trailingClosure`: ``ClosureExprSyntax``?
///  - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
public struct SubscriptCallExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .subscriptCallExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeCalledExpression: UnexpectedNodesSyntax? = nil,
    calledExpression: some ExprSyntaxProtocol,
    _ unexpectedBetweenCalledExpressionAndLeftSquare: UnexpectedNodesSyntax? = nil,
    leftSquare: TokenSyntax = .leftSquareToken(),
    _ unexpectedBetweenLeftSquareAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: LabeledExprListSyntax,
    _ unexpectedBetweenArgumentsAndRightSquare: UnexpectedNodesSyntax? = nil,
    rightSquare: TokenSyntax = .rightSquareToken(),
    _ unexpectedBetweenRightSquareAndTrailingClosure: UnexpectedNodesSyntax? = nil,
    trailingClosure: ClosureExprSyntax? = nil,
    _ unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
    _ unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeCalledExpression,
      calledExpression,
      unexpectedBetweenCalledExpressionAndLeftSquare,
      leftSquare,
      unexpectedBetweenLeftSquareAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightSquare,
      rightSquare,
      unexpectedBetweenRightSquareAndTrailingClosure,
      trailingClosure,
      unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
      additionalTrailingClosures,
      unexpectedAfterAdditionalTrailingClosures
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeCalledExpression?.raw,
        calledExpression.raw,
        unexpectedBetweenCalledExpressionAndLeftSquare?.raw,
        leftSquare.raw,
        unexpectedBetweenLeftSquareAndArguments?.raw,
        arguments.raw,
        unexpectedBetweenArgumentsAndRightSquare?.raw,
        rightSquare.raw,
        unexpectedBetweenRightSquareAndTrailingClosure?.raw,
        trailingClosure?.raw,
        unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures?.raw,
        additionalTrailingClosures.raw,
        unexpectedAfterAdditionalTrailingClosures?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.subscriptCallExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeCalledExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var calledExpression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenCalledExpressionAndLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `[`.
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenLeftSquareAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var arguments: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: LabeledExprSyntax) -> SubscriptCallExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SubscriptCallExprSyntax.self)
  }

  public var unexpectedBetweenArgumentsAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `]`.
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenRightSquareAndTrailingClosure: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var trailingClosure: ClosureExprSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(ClosureExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public var additionalTrailingClosures: MultipleTrailingClosureElementListSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(MultipleTrailingClosureElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `additionalTrailingClosures`
  /// collection.
  ///
  /// - param element: The new `AdditionalTrailingClosure` to add to the node's
  ///                  `additionalTrailingClosures` collection.
  /// - returns: A copy of the receiver with the provided `AdditionalTrailingClosure`
  ///            appended to its `additionalTrailingClosures` collection.
  @available(*, deprecated, message: "Use node.additionalTrailingClosures.append(newElement) instead")
  public func addAdditionalTrailingClosure(_ element: MultipleTrailingClosureElementSyntax) -> SubscriptCallExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[11] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.multipleTrailingClosureElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 11,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SubscriptCallExprSyntax.self)
  }

  public var unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptCallExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeCalledExpression,
    \Self.calledExpression,
    \Self.unexpectedBetweenCalledExpressionAndLeftSquare,
    \Self.leftSquare,
    \Self.unexpectedBetweenLeftSquareAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightSquare,
    \Self.rightSquare,
    \Self.unexpectedBetweenRightSquareAndTrailingClosure,
    \Self.trailingClosure,
    \Self.unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures,
    \Self.additionalTrailingClosures,
    \Self.unexpectedAfterAdditionalTrailingClosures
  ])
}

// MARK: - SubscriptDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `subscriptKeyword`: `subscript`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `parameterClause`: ``FunctionParameterClauseSyntax``
///  - `returnClause`: ``ReturnClauseSyntax``
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `accessorBlock`: ``AccessorBlockSyntax``?
///
/// ### Contained in
/// 
///  - ``ABIAttributeArgumentsSyntax``.``ABIAttributeArgumentsSyntax/provider``
public struct SubscriptDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .subscriptDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndSubscriptKeyword: UnexpectedNodesSyntax? = nil,
    subscriptKeyword: TokenSyntax = .keyword(.subscript),
    _ unexpectedBetweenSubscriptKeywordAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    _ unexpectedBetweenGenericParameterClauseAndParameterClause: UnexpectedNodesSyntax? = nil,
    parameterClause: FunctionParameterClauseSyntax,
    _ unexpectedBetweenParameterClauseAndReturnClause: UnexpectedNodesSyntax? = nil,
    returnClause: ReturnClauseSyntax,
    _ unexpectedBetweenReturnClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndAccessorBlock: UnexpectedNodesSyntax? = nil,
    accessorBlock: AccessorBlockSyntax? = nil,
    _ unexpectedAfterAccessorBlock: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndSubscriptKeyword,
      subscriptKeyword,
      unexpectedBetweenSubscriptKeywordAndGenericParameterClause,
      genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndParameterClause,
      parameterClause,
      unexpectedBetweenParameterClauseAndReturnClause,
      returnClause,
      unexpectedBetweenReturnClauseAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndAccessorBlock,
      accessorBlock,
      unexpectedAfterAccessorBlock
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndSubscriptKeyword?.raw,
        subscriptKeyword.raw,
        unexpectedBetweenSubscriptKeywordAndGenericParameterClause?.raw,
        genericParameterClause?.raw,
        unexpectedBetweenGenericParameterClauseAndParameterClause?.raw,
        parameterClause.raw,
        unexpectedBetweenParameterClauseAndReturnClause?.raw,
        returnClause.raw,
        unexpectedBetweenReturnClauseAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndAccessorBlock?.raw,
        accessorBlock?.raw,
        unexpectedAfterAccessorBlock?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.subscriptDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> SubscriptDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SubscriptDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> SubscriptDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SubscriptDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndSubscriptKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `subscript`.
  public var subscriptKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var unexpectedBetweenSubscriptKeywordAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericParameterClauseAndParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var parameterClause: FunctionParameterClauseSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(FunctionParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var unexpectedBetweenParameterClauseAndReturnClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var returnClause: ReturnClauseSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(ReturnClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var unexpectedBetweenReturnClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndAccessorBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var accessorBlock: AccessorBlockSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(AccessorBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public var unexpectedAfterAccessorBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SubscriptDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndSubscriptKeyword,
    \Self.subscriptKeyword,
    \Self.unexpectedBetweenSubscriptKeywordAndGenericParameterClause,
    \Self.genericParameterClause,
    \Self.unexpectedBetweenGenericParameterClauseAndParameterClause,
    \Self.parameterClause,
    \Self.unexpectedBetweenParameterClauseAndReturnClause,
    \Self.returnClause,
    \Self.unexpectedBetweenReturnClauseAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndAccessorBlock,
    \Self.accessorBlock,
    \Self.unexpectedAfterAccessorBlock
  ])
}

// MARK: - SuperExprSyntax

/// ### Children
/// 
///  - `superKeyword`: `super`
public struct SuperExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .superExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeSuperKeyword: UnexpectedNodesSyntax? = nil,
    superKeyword: TokenSyntax = .keyword(.super),
    _ unexpectedAfterSuperKeyword: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeSuperKeyword, superKeyword, unexpectedAfterSuperKeyword))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeSuperKeyword?.raw, superKeyword.raw, unexpectedAfterSuperKeyword?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.superExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeSuperKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuperExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `super`.
  public var superKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuperExprSyntax.self)
    }
  }

  public var unexpectedAfterSuperKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuperExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeSuperKeyword, \Self.superKeyword, \Self.unexpectedAfterSuperKeyword])
}

// MARK: - SuppressedTypeSyntax

/// ### Children
/// 
///  - `withoutTilde`: `<prefixOperator>`
///  - `type`: ``TypeSyntax``
public struct SuppressedTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .suppressedType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeWithoutTilde: UnexpectedNodesSyntax? = nil,
    withoutTilde: TokenSyntax,
    _ unexpectedBetweenWithoutTildeAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeWithoutTilde,
      withoutTilde,
      unexpectedBetweenWithoutTildeAndType,
      type,
      unexpectedAfterType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeWithoutTilde?.raw,
        withoutTilde.raw,
        unexpectedBetweenWithoutTildeAndType?.raw,
        type.raw,
        unexpectedAfterType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.suppressedType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeWithoutTilde: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuppressedTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<prefixOperator>`.
  public var withoutTilde: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuppressedTypeSyntax.self)
    }
  }

  public var unexpectedBetweenWithoutTildeAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuppressedTypeSyntax.self)
    }
  }

  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuppressedTypeSyntax.self)
    }
  }

  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SuppressedTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeWithoutTilde,
    \Self.withoutTilde,
    \Self.unexpectedBetweenWithoutTildeAndType,
    \Self.type,
    \Self.unexpectedAfterType
  ])
}

// MARK: - SwitchCaseItemSyntax

/// ### Children
/// 
///  - `pattern`: ``PatternSyntax``
///  - `whereClause`: ``WhereClauseSyntax``?
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``SwitchCaseItemListSyntax``
public struct SwitchCaseItemSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .switchCaseItem else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePattern: UnexpectedNodesSyntax? = nil,
    pattern: some PatternSyntaxProtocol,
    _ unexpectedBetweenPatternAndWhereClause: UnexpectedNodesSyntax? = nil,
    whereClause: WhereClauseSyntax? = nil,
    _ unexpectedBetweenWhereClauseAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePattern,
      pattern,
      unexpectedBetweenPatternAndWhereClause,
      whereClause,
      unexpectedBetweenWhereClauseAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePattern?.raw,
        pattern.raw,
        unexpectedBetweenPatternAndWhereClause?.raw,
        whereClause?.raw,
        unexpectedBetweenWhereClauseAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.switchCaseItem,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  public var unexpectedBetweenPatternAndWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  public var whereClause: WhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(WhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  public var unexpectedBetweenWhereClauseAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseItemSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePattern,
    \Self.pattern,
    \Self.unexpectedBetweenPatternAndWhereClause,
    \Self.whereClause,
    \Self.unexpectedBetweenWhereClauseAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - SwitchCaseLabelSyntax

/// ### Children
/// 
///  - `caseKeyword`: `case`
///  - `caseItems`: ``SwitchCaseItemListSyntax``
///  - `colon`: `:`
///
/// ### Contained in
/// 
///  - ``SwitchCaseSyntax``.``SwitchCaseSyntax/label``
public struct SwitchCaseLabelSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .switchCaseLabel else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeCaseKeyword: UnexpectedNodesSyntax? = nil,
    caseKeyword: TokenSyntax = .keyword(.case),
    _ unexpectedBetweenCaseKeywordAndCaseItems: UnexpectedNodesSyntax? = nil,
    caseItems: SwitchCaseItemListSyntax,
    _ unexpectedBetweenCaseItemsAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedAfterColon: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeCaseKeyword,
      caseKeyword,
      unexpectedBetweenCaseKeywordAndCaseItems,
      caseItems,
      unexpectedBetweenCaseItemsAndColon,
      colon,
      unexpectedAfterColon
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeCaseKeyword?.raw,
        caseKeyword.raw,
        unexpectedBetweenCaseKeywordAndCaseItems?.raw,
        caseItems.raw,
        unexpectedBetweenCaseItemsAndColon?.raw,
        colon.raw,
        unexpectedAfterColon?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.switchCaseLabel,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeCaseKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `case`.
  public var caseKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  public var unexpectedBetweenCaseKeywordAndCaseItems: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  public var caseItems: SwitchCaseItemListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(SwitchCaseItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `caseItems`
  /// collection.
  ///
  /// - param element: The new `CaseItem` to add to the node's
  ///                  `caseItems` collection.
  /// - returns: A copy of the receiver with the provided `CaseItem`
  ///            appended to its `caseItems` collection.
  @available(*, deprecated, message: "Use node.caseItems.append(newElement) instead")
  public func addCaseItem(_ element: SwitchCaseItemSyntax) -> SwitchCaseLabelSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.switchCaseItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SwitchCaseLabelSyntax.self)
  }

  public var unexpectedBetweenCaseItemsAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  public var unexpectedAfterColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseLabelSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeCaseKeyword,
    \Self.caseKeyword,
    \Self.unexpectedBetweenCaseKeywordAndCaseItems,
    \Self.caseItems,
    \Self.unexpectedBetweenCaseItemsAndColon,
    \Self.colon,
    \Self.unexpectedAfterColon
  ])
}

// MARK: - SwitchCaseSyntax

/// ### Children
/// 
///  - `attribute`: ``AttributeSyntax``?
///  - `label`: (``SwitchDefaultLabelSyntax`` | ``SwitchCaseLabelSyntax``)
///  - `statements`: ``CodeBlockItemListSyntax``
///
/// ### Contained in
/// 
///  - ``SwitchCaseListSyntax``
public struct SwitchCaseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Label: SyntaxChildChoices, SyntaxHashable {
    case `default`(SwitchDefaultLabelSyntax)
    case `case`(SwitchCaseLabelSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .default(let node):
        return node._syntaxNode
      case .case(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: SwitchDefaultLabelSyntax) {
      self = .default(node)
    }

    public init(_ node: SwitchCaseLabelSyntax) {
      self = .case(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(SwitchDefaultLabelSyntax.self) {
        self = .default(node)
      } else if let node = node.as(SwitchCaseLabelSyntax.self) {
        self = .case(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(SwitchDefaultLabelSyntax.self), .node(SwitchCaseLabelSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``SwitchDefaultLabelSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SwitchDefaultLabelSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SwitchDefaultLabelSyntax``.
    ///
    /// - Returns: An instance of ``SwitchDefaultLabelSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SwitchDefaultLabelSyntax.Type) -> SwitchDefaultLabelSyntax? {
      return SwitchDefaultLabelSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SwitchDefaultLabelSyntax``.
    ///
    /// - Returns: An instance of ``SwitchDefaultLabelSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SwitchDefaultLabelSyntax.Type) -> SwitchDefaultLabelSyntax {
      return self.as(SwitchDefaultLabelSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``SwitchCaseLabelSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SwitchCaseLabelSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SwitchCaseLabelSyntax``.
    ///
    /// - Returns: An instance of ``SwitchCaseLabelSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SwitchCaseLabelSyntax.Type) -> SwitchCaseLabelSyntax? {
      return SwitchCaseLabelSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SwitchCaseLabelSyntax``.
    ///
    /// - Returns: An instance of ``SwitchCaseLabelSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SwitchCaseLabelSyntax.Type) -> SwitchCaseLabelSyntax {
      return self.as(SwitchCaseLabelSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .switchCase else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attribute: The `@unknown` attribute of a default label, if present.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttribute: UnexpectedNodesSyntax? = nil,
    attribute: AttributeSyntax? = nil,
    _ unexpectedBetweenAttributeAndLabel: UnexpectedNodesSyntax? = nil,
    label: Label,
    _ unexpectedBetweenLabelAndStatements: UnexpectedNodesSyntax? = nil,
    statements: CodeBlockItemListSyntax,
    _ unexpectedAfterStatements: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttribute,
      attribute,
      unexpectedBetweenAttributeAndLabel,
      label,
      unexpectedBetweenLabelAndStatements,
      statements,
      unexpectedAfterStatements
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttribute?.raw,
        attribute?.raw,
        unexpectedBetweenAttributeAndLabel?.raw,
        label.raw,
        unexpectedBetweenLabelAndStatements?.raw,
        statements.raw,
        unexpectedAfterStatements?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.switchCase,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttribute: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  /// The `@unknown` attribute of a default label, if present.
  public var attribute: AttributeSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(AttributeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  public var unexpectedBetweenAttributeAndLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  public var label: Label {
    get {
      return Syntax(self).child(at: 3)!.cast(Label.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  public var unexpectedBetweenLabelAndStatements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  public var statements: CodeBlockItemListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CodeBlockItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `statements`
  /// collection.
  ///
  /// - param element: The new `Statement` to add to the node's
  ///                  `statements` collection.
  /// - returns: A copy of the receiver with the provided `Statement`
  ///            appended to its `statements` collection.
  @available(*, deprecated, message: "Use node.statements.append(newElement) instead")
  public func addStatement(_ element: CodeBlockItemSyntax) -> SwitchCaseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.codeBlockItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SwitchCaseSyntax.self)
  }

  public var unexpectedAfterStatements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchCaseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttribute,
    \Self.attribute,
    \Self.unexpectedBetweenAttributeAndLabel,
    \Self.label,
    \Self.unexpectedBetweenLabelAndStatements,
    \Self.statements,
    \Self.unexpectedAfterStatements
  ])
}

// MARK: - SwitchDefaultLabelSyntax

/// ### Children
/// 
///  - `defaultKeyword`: `default`
///  - `colon`: `:`
///
/// ### Contained in
/// 
///  - ``SwitchCaseSyntax``.``SwitchCaseSyntax/label``
public struct SwitchDefaultLabelSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .switchDefaultLabel else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeDefaultKeyword: UnexpectedNodesSyntax? = nil,
    defaultKeyword: TokenSyntax = .keyword(.default),
    _ unexpectedBetweenDefaultKeywordAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedAfterColon: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeDefaultKeyword,
      defaultKeyword,
      unexpectedBetweenDefaultKeywordAndColon,
      colon,
      unexpectedAfterColon
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeDefaultKeyword?.raw,
        defaultKeyword.raw,
        unexpectedBetweenDefaultKeywordAndColon?.raw,
        colon.raw,
        unexpectedAfterColon?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.switchDefaultLabel,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeDefaultKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchDefaultLabelSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `default`.
  public var defaultKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchDefaultLabelSyntax.self)
    }
  }

  public var unexpectedBetweenDefaultKeywordAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchDefaultLabelSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchDefaultLabelSyntax.self)
    }
  }

  public var unexpectedAfterColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchDefaultLabelSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeDefaultKeyword,
    \Self.defaultKeyword,
    \Self.unexpectedBetweenDefaultKeywordAndColon,
    \Self.colon,
    \Self.unexpectedAfterColon
  ])
}

// MARK: - SwitchExprSyntax

/// A `switch` expression.
/// 
/// ### Examples
/// 
/// This represents the switch expression in
/// 
/// ```swift
/// switch self.foo {
/// }
/// ```
/// 
/// A switch ecpression may be declared without any cases.
///
/// ### Children
/// 
///  - `switchKeyword`: `switch`
///  - `subject`: ``ExprSyntax``
///  - `leftBrace`: `{`
///  - `cases`: ``SwitchCaseListSyntax``
///  - `rightBrace`: `}`
public struct SwitchExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .switchExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - switchKeyword: The `switch` keyword.
  ///   - subject: The expression to switch over.
  ///   - leftBrace: The brace introducing the switch body.
  ///   - cases: The switch's body that contains all possible cases.
  ///   - rightBrace: The brace closing the switch body.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeSwitchKeyword: UnexpectedNodesSyntax? = nil,
    switchKeyword: TokenSyntax = .keyword(.switch),
    _ unexpectedBetweenSwitchKeywordAndSubject: UnexpectedNodesSyntax? = nil,
    subject: some ExprSyntaxProtocol,
    _ unexpectedBetweenSubjectAndLeftBrace: UnexpectedNodesSyntax? = nil,
    leftBrace: TokenSyntax = .leftBraceToken(),
    _ unexpectedBetweenLeftBraceAndCases: UnexpectedNodesSyntax? = nil,
    cases: SwitchCaseListSyntax,
    _ unexpectedBetweenCasesAndRightBrace: UnexpectedNodesSyntax? = nil,
    rightBrace: TokenSyntax = .rightBraceToken(),
    _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeSwitchKeyword,
      switchKeyword,
      unexpectedBetweenSwitchKeywordAndSubject,
      subject,
      unexpectedBetweenSubjectAndLeftBrace,
      leftBrace,
      unexpectedBetweenLeftBraceAndCases,
      cases,
      unexpectedBetweenCasesAndRightBrace,
      rightBrace,
      unexpectedAfterRightBrace
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeSwitchKeyword?.raw,
        switchKeyword.raw,
        unexpectedBetweenSwitchKeywordAndSubject?.raw,
        subject.raw,
        unexpectedBetweenSubjectAndLeftBrace?.raw,
        leftBrace.raw,
        unexpectedBetweenLeftBraceAndCases?.raw,
        cases.raw,
        unexpectedBetweenCasesAndRightBrace?.raw,
        rightBrace.raw,
        unexpectedAfterRightBrace?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.switchExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeSwitchKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  /// The `switch` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `switch`.
  public var switchKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  public var unexpectedBetweenSwitchKeywordAndSubject: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  /// The expression to switch over.
  public var subject: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  public var unexpectedBetweenSubjectAndLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  /// The brace introducing the switch body.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `{`.
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  public var unexpectedBetweenLeftBraceAndCases: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  /// The switch's body that contains all possible cases.
  public var cases: SwitchCaseListSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(SwitchCaseListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `cases`
  /// collection.
  ///
  /// - param element: The new `Case` to add to the node's
  ///                  `cases` collection.
  /// - returns: A copy of the receiver with the provided `Case`
  ///            appended to its `cases` collection.
  @available(*, deprecated, message: "Use node.cases.append(newElement) instead")
  public func addCase(_ element: Syntax) -> SwitchExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[7] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.switchCaseList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 7,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(SwitchExprSyntax.self)
  }

  public var unexpectedBetweenCasesAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  /// The brace closing the switch body.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `}`.
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(SwitchExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeSwitchKeyword,
    \Self.switchKeyword,
    \Self.unexpectedBetweenSwitchKeywordAndSubject,
    \Self.subject,
    \Self.unexpectedBetweenSubjectAndLeftBrace,
    \Self.leftBrace,
    \Self.unexpectedBetweenLeftBraceAndCases,
    \Self.cases,
    \Self.unexpectedBetweenCasesAndRightBrace,
    \Self.rightBrace,
    \Self.unexpectedAfterRightBrace
  ])
}
