//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - GenericArgumentClauseSyntax

/// ### Children
/// 
///  - `leftAngle`: `<`
///  - `arguments`: ``GenericArgumentListSyntax``
///  - `rightAngle`: `>`
///
/// ### Contained in
/// 
///  - ``GenericSpecializationExprSyntax``.``GenericSpecializationExprSyntax/genericArgumentClause``
///  - ``IdentifierTypeSyntax``.``IdentifierTypeSyntax/genericArgumentClause``
///  - ``KeyPathPropertyComponentSyntax``.``KeyPathPropertyComponentSyntax/genericArgumentClause``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/genericArgumentClause``
///  - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/genericArgumentClause``
///  - ``MemberTypeSyntax``.``MemberTypeSyntax/genericArgumentClause``
public struct GenericArgumentClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericArgumentClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftAngle: UnexpectedNodesSyntax? = nil,
    leftAngle: TokenSyntax = .leftAngleToken(),
    _ unexpectedBetweenLeftAngleAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: GenericArgumentListSyntax,
    _ unexpectedBetweenArgumentsAndRightAngle: UnexpectedNodesSyntax? = nil,
    rightAngle: TokenSyntax = .rightAngleToken(),
    _ unexpectedAfterRightAngle: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftAngle,
      leftAngle,
      unexpectedBetweenLeftAngleAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightAngle,
      rightAngle,
      unexpectedAfterRightAngle
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftAngle?.raw,
        leftAngle.raw,
        unexpectedBetweenLeftAngleAndArguments?.raw,
        arguments.raw,
        unexpectedBetweenArgumentsAndRightAngle?.raw,
        rightAngle.raw,
        unexpectedAfterRightAngle?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericArgumentClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<`.
  public var leftAngle: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  public var unexpectedBetweenLeftAngleAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  public var arguments: GenericArgumentListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(GenericArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: GenericArgumentSyntax) -> GenericArgumentClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.genericArgumentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(GenericArgumentClauseSyntax.self)
  }

  public var unexpectedBetweenArgumentsAndRightAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `>`.
  public var rightAngle: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  public var unexpectedAfterRightAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftAngle,
    \Self.leftAngle,
    \Self.unexpectedBetweenLeftAngleAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightAngle,
    \Self.rightAngle,
    \Self.unexpectedAfterRightAngle
  ])
}

// MARK: - GenericArgumentSyntax

/// ### Children
/// 
///  - `argument`: (``TypeSyntax`` | ``ExprSyntax``)
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``GenericArgumentListSyntax``
///  - ``InlineArrayTypeSyntax``.``InlineArrayTypeSyntax/count``
///  - ``InlineArrayTypeSyntax``.``InlineArrayTypeSyntax/element``
public struct GenericArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Argument: SyntaxChildChoices, SyntaxHashable {
    case type(TypeSyntax)
    case expr(ExprSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .type(let node):
        return node._syntaxNode
      case .expr(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: some TypeSyntaxProtocol) {
      self = .type(TypeSyntax(node))
    }

    public init(_ node: some ExprSyntaxProtocol) {
      self = .expr(ExprSyntax(node))
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(TypeSyntax.self) {
        self = .type(node)
      } else if let node = node.as(ExprSyntax.self) {
        self = .expr(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TypeSyntax.self), .node(ExprSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some TypeSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``TypeSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: TypeSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some ExprSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - argument: The argument type for a generic argument. This can either be a regular type argument or an expression for value generics.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeArgument: UnexpectedNodesSyntax? = nil,
    argument: Argument,
    _ unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeArgument,
      argument,
      unexpectedBetweenArgumentAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeArgument?.raw,
        argument.raw,
        unexpectedBetweenArgumentAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeArgument: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentSyntax.self)
    }
  }

  /// The argument type for a generic argument. This can either be a regular type argument or an expression for value generics.
  public var argument: Argument {
    get {
      return Syntax(self).child(at: 1)!.cast(Argument.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeArgument,
    \Self.argument,
    \Self.unexpectedBetweenArgumentAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - GenericParameterClauseSyntax

/// The parameter clause that defines the generic parameters.
///
/// ### Children
/// 
///  - `leftAngle`: `<`
///  - `parameters`: ``GenericParameterListSyntax``
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `rightAngle`: `>`
///
/// ### Contained in
/// 
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/genericParameterClause``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/genericParameterClause``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/genericParameterClause``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/genericParameterClause``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/genericParameterClause``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/genericParameterClause``
///  - ``NamedOpaqueReturnTypeSyntax``.``NamedOpaqueReturnTypeSyntax/genericParameterClause``
///  - ``StructDeclSyntax``.``StructDeclSyntax/genericParameterClause``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/genericParameterClause``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/genericParameterClause``
public struct GenericParameterClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericParameterClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - leftAngle: The opening angle bracket (`<`) of the generic parameter clause.
  ///   - parameters: The list of generic parameters in the clause.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - rightAngle: The closing angle bracket (`>`) of the generic parameter clause.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftAngle: UnexpectedNodesSyntax? = nil,
    leftAngle: TokenSyntax = .leftAngleToken(),
    _ unexpectedBetweenLeftAngleAndParameters: UnexpectedNodesSyntax? = nil,
    parameters: GenericParameterListSyntax,
    _ unexpectedBetweenParametersAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndRightAngle: UnexpectedNodesSyntax? = nil,
    rightAngle: TokenSyntax = .rightAngleToken(),
    _ unexpectedAfterRightAngle: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftAngle,
      leftAngle,
      unexpectedBetweenLeftAngleAndParameters,
      parameters,
      unexpectedBetweenParametersAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndRightAngle,
      rightAngle,
      unexpectedAfterRightAngle
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftAngle?.raw,
        leftAngle.raw,
        unexpectedBetweenLeftAngleAndParameters?.raw,
        parameters.raw,
        unexpectedBetweenParametersAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndRightAngle?.raw,
        rightAngle.raw,
        unexpectedAfterRightAngle?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericParameterClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  /// The opening angle bracket (`<`) of the generic parameter clause.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<`.
  public var leftAngle: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  public var unexpectedBetweenLeftAngleAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  /// The list of generic parameters in the clause.
  public var parameters: GenericParameterListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(GenericParameterListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `parameters`
  /// collection.
  ///
  /// - param element: The new `Parameter` to add to the node's
  ///                  `parameters` collection.
  /// - returns: A copy of the receiver with the provided `Parameter`
  ///            appended to its `parameters` collection.
  @available(*, deprecated, message: "Use node.parameters.append(newElement) instead")
  public func addParameter(_ element: GenericParameterSyntax) -> GenericParameterClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.genericParameterList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(GenericParameterClauseSyntax.self)
  }

  public var unexpectedBetweenParametersAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndRightAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  /// The closing angle bracket (`>`) of the generic parameter clause.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `>`.
  public var rightAngle: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  public var unexpectedAfterRightAngle: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftAngle,
    \Self.leftAngle,
    \Self.unexpectedBetweenLeftAngleAndParameters,
    \Self.parameters,
    \Self.unexpectedBetweenParametersAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndRightAngle,
    \Self.rightAngle,
    \Self.unexpectedAfterRightAngle
  ])
}

// MARK: - GenericParameterSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `specifier`: (`each` | `let`)?
///  - `name`: `<identifier>`
///  - `colon`: `:`?
///  - `inheritedType`: ``TypeSyntax``?
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``GenericParameterListSyntax``
public struct GenericParameterSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericParameter else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndSpecifier: UnexpectedNodesSyntax? = nil,
    specifier: TokenSyntax? = nil,
    _ unexpectedBetweenSpecifierAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax? = nil,
    _ unexpectedBetweenColonAndInheritedType: UnexpectedNodesSyntax? = nil,
    inheritedType: (some TypeSyntaxProtocol)? = TypeSyntax?.none,
    _ unexpectedBetweenInheritedTypeAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndSpecifier,
      specifier,
      unexpectedBetweenSpecifierAndName,
      name,
      unexpectedBetweenNameAndColon,
      colon,
      unexpectedBetweenColonAndInheritedType,
      inheritedType,
      unexpectedBetweenInheritedTypeAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndSpecifier?.raw,
        specifier?.raw,
        unexpectedBetweenSpecifierAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndColon?.raw,
        colon?.raw,
        unexpectedBetweenColonAndInheritedType?.raw,
        inheritedType?.raw,
        unexpectedBetweenInheritedTypeAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericParameter,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> GenericParameterSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(GenericParameterSyntax.self)
  }

  public var unexpectedBetweenAttributesAndSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `each`
  ///  - `let`
  public var specifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var unexpectedBetweenSpecifierAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndInheritedType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var inheritedType: TypeSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var unexpectedBetweenInheritedTypeAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericParameterSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndSpecifier,
    \Self.specifier,
    \Self.unexpectedBetweenSpecifierAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndInheritedType,
    \Self.inheritedType,
    \Self.unexpectedBetweenInheritedTypeAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - GenericRequirementSyntax

/// ### Children
/// 
///  - `requirement`: (``SameTypeRequirementSyntax`` | ``ConformanceRequirementSyntax`` | ``LayoutRequirementSyntax``)
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``GenericRequirementListSyntax``
public struct GenericRequirementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Requirement: SyntaxChildChoices, SyntaxHashable {
    case sameTypeRequirement(SameTypeRequirementSyntax)
    case conformanceRequirement(ConformanceRequirementSyntax)
    case layoutRequirement(LayoutRequirementSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .sameTypeRequirement(let node):
        return node._syntaxNode
      case .conformanceRequirement(let node):
        return node._syntaxNode
      case .layoutRequirement(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: SameTypeRequirementSyntax) {
      self = .sameTypeRequirement(node)
    }

    public init(_ node: ConformanceRequirementSyntax) {
      self = .conformanceRequirement(node)
    }

    public init(_ node: LayoutRequirementSyntax) {
      self = .layoutRequirement(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(SameTypeRequirementSyntax.self) {
        self = .sameTypeRequirement(node)
      } else if let node = node.as(ConformanceRequirementSyntax.self) {
        self = .conformanceRequirement(node)
      } else if let node = node.as(LayoutRequirementSyntax.self) {
        self = .layoutRequirement(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(SameTypeRequirementSyntax.self), .node(ConformanceRequirementSyntax.self), .node(LayoutRequirementSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``SameTypeRequirementSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SameTypeRequirementSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SameTypeRequirementSyntax``.
    ///
    /// - Returns: An instance of ``SameTypeRequirementSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SameTypeRequirementSyntax.Type) -> SameTypeRequirementSyntax? {
      return SameTypeRequirementSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SameTypeRequirementSyntax``.
    ///
    /// - Returns: An instance of ``SameTypeRequirementSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SameTypeRequirementSyntax.Type) -> SameTypeRequirementSyntax {
      return self.as(SameTypeRequirementSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``ConformanceRequirementSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: ConformanceRequirementSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``ConformanceRequirementSyntax``.
    ///
    /// - Returns: An instance of ``ConformanceRequirementSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: ConformanceRequirementSyntax.Type) -> ConformanceRequirementSyntax? {
      return ConformanceRequirementSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``ConformanceRequirementSyntax``.
    ///
    /// - Returns: An instance of ``ConformanceRequirementSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: ConformanceRequirementSyntax.Type) -> ConformanceRequirementSyntax {
      return self.as(ConformanceRequirementSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``LayoutRequirementSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: LayoutRequirementSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``LayoutRequirementSyntax``.
    ///
    /// - Returns: An instance of ``LayoutRequirementSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: LayoutRequirementSyntax.Type) -> LayoutRequirementSyntax? {
      return LayoutRequirementSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``LayoutRequirementSyntax``.
    ///
    /// - Returns: An instance of ``LayoutRequirementSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: LayoutRequirementSyntax.Type) -> LayoutRequirementSyntax {
      return self.as(LayoutRequirementSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericRequirement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeRequirement: UnexpectedNodesSyntax? = nil,
    requirement: Requirement,
    _ unexpectedBetweenRequirementAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeRequirement,
      requirement,
      unexpectedBetweenRequirementAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeRequirement?.raw,
        requirement.raw,
        unexpectedBetweenRequirementAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericRequirement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeRequirement: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericRequirementSyntax.self)
    }
  }

  public var requirement: Requirement {
    get {
      return Syntax(self).child(at: 1)!.cast(Requirement.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericRequirementSyntax.self)
    }
  }

  public var unexpectedBetweenRequirementAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericRequirementSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericRequirementSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericRequirementSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeRequirement,
    \Self.requirement,
    \Self.unexpectedBetweenRequirementAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - GenericSpecializationExprSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `genericArgumentClause`: ``GenericArgumentClauseSyntax``
public struct GenericSpecializationExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericSpecializationExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
    genericArgumentClause: GenericArgumentClauseSyntax,
    _ unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndGenericArgumentClause,
      genericArgumentClause,
      unexpectedAfterGenericArgumentClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndGenericArgumentClause?.raw,
        genericArgumentClause.raw,
        unexpectedAfterGenericArgumentClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericSpecializationExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericSpecializationExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericSpecializationExprSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericSpecializationExprSyntax.self)
    }
  }

  public var genericArgumentClause: GenericArgumentClauseSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(GenericArgumentClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericSpecializationExprSyntax.self)
    }
  }

  public var unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericSpecializationExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndGenericArgumentClause,
    \Self.genericArgumentClause,
    \Self.unexpectedAfterGenericArgumentClause
  ])
}

// MARK: - GenericWhereClauseSyntax

/// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
///
/// ### Children
/// 
///  - `whereKeyword`: `where`
///  - `requirements`: ``GenericRequirementListSyntax``
///
/// ### Contained in
/// 
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/genericWhereClause``
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/genericWhereClause``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/genericWhereClause``
///  - ``DifferentiableAttributeArgumentsSyntax``.``DifferentiableAttributeArgumentsSyntax/genericWhereClause``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/genericWhereClause``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/genericWhereClause``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/genericWhereClause``
///  - ``GenericParameterClauseSyntax``.``GenericParameterClauseSyntax/genericWhereClause``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/genericWhereClause``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/genericWhereClause``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/genericWhereClause``
///  - ``SpecializeAttributeArgumentListSyntax``
///  - ``StructDeclSyntax``.``StructDeclSyntax/genericWhereClause``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/genericWhereClause``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/genericWhereClause``
public struct GenericWhereClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .genericWhereClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - whereKeyword: The `where` keyword in the clause.
  ///   - requirements: The list of requirements in the clause.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeWhereKeyword: UnexpectedNodesSyntax? = nil,
    whereKeyword: TokenSyntax = .keyword(.where),
    _ unexpectedBetweenWhereKeywordAndRequirements: UnexpectedNodesSyntax? = nil,
    requirements: GenericRequirementListSyntax,
    _ unexpectedAfterRequirements: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeWhereKeyword,
      whereKeyword,
      unexpectedBetweenWhereKeywordAndRequirements,
      requirements,
      unexpectedAfterRequirements
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeWhereKeyword?.raw,
        whereKeyword.raw,
        unexpectedBetweenWhereKeywordAndRequirements?.raw,
        requirements.raw,
        unexpectedAfterRequirements?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.genericWhereClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeWhereKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericWhereClauseSyntax.self)
    }
  }

  /// The `where` keyword in the clause.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `where`.
  public var whereKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericWhereClauseSyntax.self)
    }
  }

  public var unexpectedBetweenWhereKeywordAndRequirements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericWhereClauseSyntax.self)
    }
  }

  /// The list of requirements in the clause.
  public var requirements: GenericRequirementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(GenericRequirementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericWhereClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `requirements`
  /// collection.
  ///
  /// - param element: The new `Requirement` to add to the node's
  ///                  `requirements` collection.
  /// - returns: A copy of the receiver with the provided `Requirement`
  ///            appended to its `requirements` collection.
  @available(*, deprecated, message: "Use node.requirements.append(newElement) instead")
  public func addRequirement(_ element: GenericRequirementSyntax) -> GenericWhereClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.genericRequirementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(GenericWhereClauseSyntax.self)
  }

  public var unexpectedAfterRequirements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GenericWhereClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeWhereKeyword,
    \Self.whereKeyword,
    \Self.unexpectedBetweenWhereKeywordAndRequirements,
    \Self.requirements,
    \Self.unexpectedAfterRequirements
  ])
}

// MARK: - GuardStmtSyntax

/// ### Children
/// 
///  - `guardKeyword`: `guard`
///  - `conditions`: ``ConditionElementListSyntax``
///  - `elseKeyword`: `else`
///  - `body`: ``CodeBlockSyntax``
public struct GuardStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .guardStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeGuardKeyword: UnexpectedNodesSyntax? = nil,
    guardKeyword: TokenSyntax = .keyword(.guard),
    _ unexpectedBetweenGuardKeywordAndConditions: UnexpectedNodesSyntax? = nil,
    conditions: ConditionElementListSyntax,
    _ unexpectedBetweenConditionsAndElseKeyword: UnexpectedNodesSyntax? = nil,
    elseKeyword: TokenSyntax = .keyword(.else),
    _ unexpectedBetweenElseKeywordAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeGuardKeyword,
      guardKeyword,
      unexpectedBetweenGuardKeywordAndConditions,
      conditions,
      unexpectedBetweenConditionsAndElseKeyword,
      elseKeyword,
      unexpectedBetweenElseKeywordAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeGuardKeyword?.raw,
        guardKeyword.raw,
        unexpectedBetweenGuardKeywordAndConditions?.raw,
        conditions.raw,
        unexpectedBetweenConditionsAndElseKeyword?.raw,
        elseKeyword.raw,
        unexpectedBetweenElseKeywordAndBody?.raw,
        body.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.guardStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeGuardKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `guard`.
  public var guardKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  public var unexpectedBetweenGuardKeywordAndConditions: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  public var conditions: ConditionElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ConditionElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `conditions`
  /// collection.
  ///
  /// - param element: The new `Condition` to add to the node's
  ///                  `conditions` collection.
  /// - returns: A copy of the receiver with the provided `Condition`
  ///            appended to its `conditions` collection.
  @available(*, deprecated, message: "Use node.conditions.append(newElement) instead")
  public func addCondition(_ element: ConditionElementSyntax) -> GuardStmtSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.conditionElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(GuardStmtSyntax.self)
  }

  public var unexpectedBetweenConditionsAndElseKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `else`.
  public var elseKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  public var unexpectedBetweenElseKeywordAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(GuardStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeGuardKeyword,
    \Self.guardKeyword,
    \Self.unexpectedBetweenGuardKeywordAndConditions,
    \Self.conditions,
    \Self.unexpectedBetweenConditionsAndElseKeyword,
    \Self.elseKeyword,
    \Self.unexpectedBetweenElseKeywordAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - IdentifierPatternSyntax

/// A pattern that contains a ``TokenSyntax``.
/// 
/// ### Examples
/// 
/// ``IdentifierPatternSyntax`` can be used in simplple variable declarations.
/// For example `a` in the exmaple:
/// 
/// ```swift
/// let a = 1
/// ```
///
/// ### Children
/// 
///  - `identifier`: (`<identifier>` | `self` | `init` | `deinit` | `subscript`)
public struct IdentifierPatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .identifierPattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeIdentifier: UnexpectedNodesSyntax? = nil,
    identifier: TokenSyntax,
    _ unexpectedAfterIdentifier: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeIdentifier, identifier, unexpectedAfterIdentifier))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeIdentifier?.raw, identifier.raw, unexpectedAfterIdentifier?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.identifierPattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeIdentifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierPatternSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `self`
  ///  - `init`
  ///  - `deinit`
  ///  - `subscript`
  public var identifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierPatternSyntax.self)
    }
  }

  public var unexpectedAfterIdentifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierPatternSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeIdentifier, \Self.identifier, \Self.unexpectedAfterIdentifier])
}

// MARK: - IdentifierTypeSyntax

/// ### Children
/// 
///  - `name`: (`<identifier>` | `Self` | `Any` | `_`)
///  - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
public struct IdentifierTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .identifierType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
    genericArgumentClause: GenericArgumentClauseSyntax? = nil,
    _ unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndGenericArgumentClause,
      genericArgumentClause,
      unexpectedAfterGenericArgumentClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndGenericArgumentClause?.raw,
        genericArgumentClause?.raw,
        unexpectedAfterGenericArgumentClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.identifierType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `Self`
  ///  - `Any`
  ///  - `_`
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierTypeSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierTypeSyntax.self)
    }
  }

  public var genericArgumentClause: GenericArgumentClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(GenericArgumentClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierTypeSyntax.self)
    }
  }

  public var unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IdentifierTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndGenericArgumentClause,
    \Self.genericArgumentClause,
    \Self.unexpectedAfterGenericArgumentClause
  ])
}

// MARK: - IfConfigClauseSyntax

/// ### Children
/// 
///  - `poundKeyword`: (`#if` | `#elseif` | `#else`)
///  - `condition`: ``ExprSyntax``?
///  - `elements`: (``CodeBlockItemListSyntax`` | ``SwitchCaseListSyntax`` | ``MemberBlockItemListSyntax`` | ``ExprSyntax`` | ``AttributeListSyntax``)?
///
/// ### Contained in
/// 
///  - ``IfConfigClauseListSyntax``
public struct IfConfigClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Elements: SyntaxChildChoices, SyntaxHashable {
    case statements(CodeBlockItemListSyntax)
    case switchCases(SwitchCaseListSyntax)
    case decls(MemberBlockItemListSyntax)
    case postfixExpression(ExprSyntax)
    case attributes(AttributeListSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .statements(let node):
        return node._syntaxNode
      case .switchCases(let node):
        return node._syntaxNode
      case .decls(let node):
        return node._syntaxNode
      case .postfixExpression(let node):
        return node._syntaxNode
      case .attributes(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: CodeBlockItemListSyntax) {
      self = .statements(node)
    }

    public init(_ node: SwitchCaseListSyntax) {
      self = .switchCases(node)
    }

    public init(_ node: MemberBlockItemListSyntax) {
      self = .decls(node)
    }

    public init(_ node: some ExprSyntaxProtocol) {
      self = .postfixExpression(ExprSyntax(node))
    }

    public init(_ node: AttributeListSyntax) {
      self = .attributes(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(CodeBlockItemListSyntax.self) {
        self = .statements(node)
      } else if let node = node.as(SwitchCaseListSyntax.self) {
        self = .switchCases(node)
      } else if let node = node.as(MemberBlockItemListSyntax.self) {
        self = .decls(node)
      } else if let node = node.as(ExprSyntax.self) {
        self = .postfixExpression(node)
      } else if let node = node.as(AttributeListSyntax.self) {
        self = .attributes(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([
        .node(CodeBlockItemListSyntax.self),
        .node(SwitchCaseListSyntax.self),
        .node(MemberBlockItemListSyntax.self),
        .node(ExprSyntax.self),
        .node(AttributeListSyntax.self)
      ])
    }

    /// Checks if the current syntax node can be cast to ``CodeBlockItemListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: CodeBlockItemListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``CodeBlockItemListSyntax``.
    ///
    /// - Returns: An instance of ``CodeBlockItemListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: CodeBlockItemListSyntax.Type) -> CodeBlockItemListSyntax? {
      return CodeBlockItemListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``CodeBlockItemListSyntax``.
    ///
    /// - Returns: An instance of ``CodeBlockItemListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: CodeBlockItemListSyntax.Type) -> CodeBlockItemListSyntax {
      return self.as(CodeBlockItemListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``SwitchCaseListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SwitchCaseListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SwitchCaseListSyntax``.
    ///
    /// - Returns: An instance of ``SwitchCaseListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SwitchCaseListSyntax.Type) -> SwitchCaseListSyntax? {
      return SwitchCaseListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SwitchCaseListSyntax``.
    ///
    /// - Returns: An instance of ``SwitchCaseListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SwitchCaseListSyntax.Type) -> SwitchCaseListSyntax {
      return self.as(SwitchCaseListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``MemberBlockItemListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: MemberBlockItemListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``MemberBlockItemListSyntax``.
    ///
    /// - Returns: An instance of ``MemberBlockItemListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: MemberBlockItemListSyntax.Type) -> MemberBlockItemListSyntax? {
      return MemberBlockItemListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``MemberBlockItemListSyntax``.
    ///
    /// - Returns: An instance of ``MemberBlockItemListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: MemberBlockItemListSyntax.Type) -> MemberBlockItemListSyntax {
      return self.as(MemberBlockItemListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: (some ExprSyntaxProtocol).Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type, or `nil` if the cast fails.
    public func `as`<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S? {
      return S.init(self)
    }

    /// Force-casts the current syntax node to the type conforming to the ``ExprSyntaxProtocol`` protocol.
    ///
    /// - Returns: An instance of the specialized type.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast<S: ExprSyntaxProtocol>(_ syntaxType: S.Type) -> S {
      return self.as(S.self)!
    }

    /// Checks if the current syntax node can be cast to ``AttributeListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: AttributeListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``AttributeListSyntax``.
    ///
    /// - Returns: An instance of ``AttributeListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: AttributeListSyntax.Type) -> AttributeListSyntax? {
      return AttributeListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``AttributeListSyntax``.
    ///
    /// - Returns: An instance of ``AttributeListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: AttributeListSyntax.Type) -> AttributeListSyntax {
      return self.as(AttributeListSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .ifConfigClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePoundKeyword: UnexpectedNodesSyntax? = nil,
    poundKeyword: TokenSyntax,
    _ unexpectedBetweenPoundKeywordAndCondition: UnexpectedNodesSyntax? = nil,
    condition: (some ExprSyntaxProtocol)? = ExprSyntax?.none,
    _ unexpectedBetweenConditionAndElements: UnexpectedNodesSyntax? = nil,
    elements: Elements? = nil,
    _ unexpectedAfterElements: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePoundKeyword,
      poundKeyword,
      unexpectedBetweenPoundKeywordAndCondition,
      condition,
      unexpectedBetweenConditionAndElements,
      elements,
      unexpectedAfterElements
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePoundKeyword?.raw,
        poundKeyword.raw,
        unexpectedBetweenPoundKeywordAndCondition?.raw,
        condition?.raw,
        unexpectedBetweenConditionAndElements?.raw,
        elements?.raw,
        unexpectedAfterElements?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.ifConfigClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePoundKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `#if`
  ///  - `#elseif`
  ///  - `#else`
  public var poundKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  public var unexpectedBetweenPoundKeywordAndCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  public var condition: ExprSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  public var unexpectedBetweenConditionAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  public var elements: Elements? {
    get {
      return Syntax(self).child(at: 5)?.cast(Elements.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  public var unexpectedAfterElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePoundKeyword,
    \Self.poundKeyword,
    \Self.unexpectedBetweenPoundKeywordAndCondition,
    \Self.condition,
    \Self.unexpectedBetweenConditionAndElements,
    \Self.elements,
    \Self.unexpectedAfterElements
  ])
}

// MARK: - IfConfigDeclSyntax

/// ### Children
/// 
///  - `clauses`: ``IfConfigClauseListSyntax``
///  - `poundEndif`: `#endif`
///
/// ### Contained in
/// 
///  - ``AttributeListSyntax``
///  - ``PostfixIfConfigExprSyntax``.``PostfixIfConfigExprSyntax/config``
///  - ``SwitchCaseListSyntax``
public struct IfConfigDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .ifConfigDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeClauses: UnexpectedNodesSyntax? = nil,
    clauses: IfConfigClauseListSyntax,
    _ unexpectedBetweenClausesAndPoundEndif: UnexpectedNodesSyntax? = nil,
    poundEndif: TokenSyntax = .poundEndifToken(),
    _ unexpectedAfterPoundEndif: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeClauses,
      clauses,
      unexpectedBetweenClausesAndPoundEndif,
      poundEndif,
      unexpectedAfterPoundEndif
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeClauses?.raw,
        clauses.raw,
        unexpectedBetweenClausesAndPoundEndif?.raw,
        poundEndif.raw,
        unexpectedAfterPoundEndif?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.ifConfigDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeClauses: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigDeclSyntax.self)
    }
  }

  public var clauses: IfConfigClauseListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(IfConfigClauseListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `clauses`
  /// collection.
  ///
  /// - param element: The new `Clause` to add to the node's
  ///                  `clauses` collection.
  /// - returns: A copy of the receiver with the provided `Clause`
  ///            appended to its `clauses` collection.
  @available(*, deprecated, message: "Use node.clauses.append(newElement) instead")
  public func addClause(_ element: IfConfigClauseSyntax) -> IfConfigDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.ifConfigClauseList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(IfConfigDeclSyntax.self)
  }

  public var unexpectedBetweenClausesAndPoundEndif: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `#endif`.
  public var poundEndif: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigDeclSyntax.self)
    }
  }

  public var unexpectedAfterPoundEndif: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfConfigDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeClauses,
    \Self.clauses,
    \Self.unexpectedBetweenClausesAndPoundEndif,
    \Self.poundEndif,
    \Self.unexpectedAfterPoundEndif
  ])
}

// MARK: - IfExprSyntax

/// ### Children
/// 
///  - `ifKeyword`: `if`
///  - `conditions`: ``ConditionElementListSyntax``
///  - `body`: ``CodeBlockSyntax``
///  - `elseKeyword`: `else`?
///  - `elseBody`: (``IfExprSyntax`` | ``CodeBlockSyntax``)?
///
/// ### Contained in
/// 
///  - ``IfExprSyntax``.``IfExprSyntax/elseBody``
public struct IfExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public enum ElseBody: SyntaxChildChoices, SyntaxHashable {
    case ifExpr(IfExprSyntax)
    case codeBlock(CodeBlockSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .ifExpr(let node):
        return node._syntaxNode
      case .codeBlock(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: IfExprSyntax) {
      self = .ifExpr(node)
    }

    public init(_ node: CodeBlockSyntax) {
      self = .codeBlock(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(IfExprSyntax.self) {
        self = .ifExpr(node)
      } else if let node = node.as(CodeBlockSyntax.self) {
        self = .codeBlock(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(IfExprSyntax.self), .node(CodeBlockSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``IfExprSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: IfExprSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``IfExprSyntax``.
    ///
    /// - Returns: An instance of ``IfExprSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: IfExprSyntax.Type) -> IfExprSyntax? {
      return IfExprSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``IfExprSyntax``.
    ///
    /// - Returns: An instance of ``IfExprSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: IfExprSyntax.Type) -> IfExprSyntax {
      return self.as(IfExprSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``CodeBlockSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: CodeBlockSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``CodeBlockSyntax``.
    ///
    /// - Returns: An instance of ``CodeBlockSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: CodeBlockSyntax.Type) -> CodeBlockSyntax? {
      return CodeBlockSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``CodeBlockSyntax``.
    ///
    /// - Returns: An instance of ``CodeBlockSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: CodeBlockSyntax.Type) -> CodeBlockSyntax {
      return self.as(CodeBlockSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .ifExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeIfKeyword: UnexpectedNodesSyntax? = nil,
    ifKeyword: TokenSyntax = .keyword(.if),
    _ unexpectedBetweenIfKeywordAndConditions: UnexpectedNodesSyntax? = nil,
    conditions: ConditionElementListSyntax,
    _ unexpectedBetweenConditionsAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax,
    _ unexpectedBetweenBodyAndElseKeyword: UnexpectedNodesSyntax? = nil,
    elseKeyword: TokenSyntax? = nil,
    _ unexpectedBetweenElseKeywordAndElseBody: UnexpectedNodesSyntax? = nil,
    elseBody: ElseBody? = nil,
    _ unexpectedAfterElseBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeIfKeyword,
      ifKeyword,
      unexpectedBetweenIfKeywordAndConditions,
      conditions,
      unexpectedBetweenConditionsAndBody,
      body,
      unexpectedBetweenBodyAndElseKeyword,
      elseKeyword,
      unexpectedBetweenElseKeywordAndElseBody,
      elseBody,
      unexpectedAfterElseBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeIfKeyword?.raw,
        ifKeyword.raw,
        unexpectedBetweenIfKeywordAndConditions?.raw,
        conditions.raw,
        unexpectedBetweenConditionsAndBody?.raw,
        body.raw,
        unexpectedBetweenBodyAndElseKeyword?.raw,
        elseKeyword?.raw,
        unexpectedBetweenElseKeywordAndElseBody?.raw,
        elseBody?.raw,
        unexpectedAfterElseBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.ifExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeIfKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `if`.
  public var ifKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var unexpectedBetweenIfKeywordAndConditions: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var conditions: ConditionElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ConditionElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `conditions`
  /// collection.
  ///
  /// - param element: The new `Condition` to add to the node's
  ///                  `conditions` collection.
  /// - returns: A copy of the receiver with the provided `Condition`
  ///            appended to its `conditions` collection.
  @available(*, deprecated, message: "Use node.conditions.append(newElement) instead")
  public func addCondition(_ element: ConditionElementSyntax) -> IfExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.conditionElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(IfExprSyntax.self)
  }

  public var unexpectedBetweenConditionsAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var unexpectedBetweenBodyAndElseKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `else`.
  public var elseKeyword: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var unexpectedBetweenElseKeywordAndElseBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var elseBody: ElseBody? {
    get {
      return Syntax(self).child(at: 9)?.cast(ElseBody.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public var unexpectedAfterElseBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IfExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeIfKeyword,
    \Self.ifKeyword,
    \Self.unexpectedBetweenIfKeywordAndConditions,
    \Self.conditions,
    \Self.unexpectedBetweenConditionsAndBody,
    \Self.body,
    \Self.unexpectedBetweenBodyAndElseKeyword,
    \Self.elseKeyword,
    \Self.unexpectedBetweenElseKeywordAndElseBody,
    \Self.elseBody,
    \Self.unexpectedAfterElseBody
  ])
}

// MARK: - ImplementsAttributeArgumentsSyntax

/// The arguments for the `@_implements` attribute of the form `Type, methodName(arg1Label:arg2Label:)`
///
/// ### Children
/// 
///  - `type`: ``TypeSyntax``
///  - `comma`: `,`
///  - `declName`: ``DeclReferenceExprSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct ImplementsAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .implementsAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - type: The type for which the method with this attribute implements a requirement.
  ///   - comma: The comma separating the type and method name
  ///   - declName: The value for this argument
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedBetweenTypeAndComma: UnexpectedNodesSyntax? = nil,
    comma: TokenSyntax = .commaToken(),
    _ unexpectedBetweenCommaAndDeclName: UnexpectedNodesSyntax? = nil,
    declName: DeclReferenceExprSyntax,
    _ unexpectedAfterDeclName: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeType,
      type,
      unexpectedBetweenTypeAndComma,
      comma,
      unexpectedBetweenCommaAndDeclName,
      declName,
      unexpectedAfterDeclName
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeType?.raw,
        type.raw,
        unexpectedBetweenTypeAndComma?.raw,
        comma.raw,
        unexpectedBetweenCommaAndDeclName?.raw,
        declName.raw,
        unexpectedAfterDeclName?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.implementsAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  /// The type for which the method with this attribute implements a requirement.
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  /// The comma separating the type and method name
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var comma: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenCommaAndDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  /// The value for this argument
  public var declName: DeclReferenceExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(DeclReferenceExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplementsAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeType,
    \Self.type,
    \Self.unexpectedBetweenTypeAndComma,
    \Self.comma,
    \Self.unexpectedBetweenCommaAndDeclName,
    \Self.declName,
    \Self.unexpectedAfterDeclName
  ])
}

// MARK: - ImplicitlyUnwrappedOptionalTypeSyntax

/// ### Children
/// 
///  - `wrappedType`: ``TypeSyntax``
///  - `exclamationMark`: `!`
public struct ImplicitlyUnwrappedOptionalTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .implicitlyUnwrappedOptionalType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeWrappedType: UnexpectedNodesSyntax? = nil,
    wrappedType: some TypeSyntaxProtocol,
    _ unexpectedBetweenWrappedTypeAndExclamationMark: UnexpectedNodesSyntax? = nil,
    exclamationMark: TokenSyntax = .exclamationMarkToken(),
    _ unexpectedAfterExclamationMark: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeWrappedType,
      wrappedType,
      unexpectedBetweenWrappedTypeAndExclamationMark,
      exclamationMark,
      unexpectedAfterExclamationMark
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeWrappedType?.raw,
        wrappedType.raw,
        unexpectedBetweenWrappedTypeAndExclamationMark?.raw,
        exclamationMark.raw,
        unexpectedAfterExclamationMark?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.implicitlyUnwrappedOptionalType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeWrappedType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplicitlyUnwrappedOptionalTypeSyntax.self)
    }
  }

  public var wrappedType: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplicitlyUnwrappedOptionalTypeSyntax.self)
    }
  }

  public var unexpectedBetweenWrappedTypeAndExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplicitlyUnwrappedOptionalTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `!`.
  public var exclamationMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplicitlyUnwrappedOptionalTypeSyntax.self)
    }
  }

  public var unexpectedAfterExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImplicitlyUnwrappedOptionalTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeWrappedType,
    \Self.wrappedType,
    \Self.unexpectedBetweenWrappedTypeAndExclamationMark,
    \Self.exclamationMark,
    \Self.unexpectedAfterExclamationMark
  ])
}

// MARK: - ImportDeclSyntax

/// An `import` declaration
/// 
/// An example of an import declaration is
/// 
/// ```swift
/// import Foundation
/// ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `importKeyword`: `import`
///  - `importKindSpecifier`: (`typealias` | `struct` | `class` | `enum` | `protocol` | `var` | `let` | `func` | `inout`)?
///  - `path`: ``ImportPathComponentListSyntax``
public struct ImportDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .importDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes attached to the import declaration, for example `@testable`.
  ///   - modifiers: Modifiers that are attached to the import declaration. Currently, no modifiers are supported by Swift.
  ///   - importKeyword: The `import` keyword for this declaration.
  ///   - importKindSpecifier: The kind of declaration being imported. 
  ///   - path: The path to the module, submodule or symbol being imported.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndImportKeyword: UnexpectedNodesSyntax? = nil,
    importKeyword: TokenSyntax = .keyword(.import),
    _ unexpectedBetweenImportKeywordAndImportKindSpecifier: UnexpectedNodesSyntax? = nil,
    importKindSpecifier: TokenSyntax? = nil,
    _ unexpectedBetweenImportKindSpecifierAndPath: UnexpectedNodesSyntax? = nil,
    path: ImportPathComponentListSyntax,
    _ unexpectedAfterPath: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndImportKeyword,
      importKeyword,
      unexpectedBetweenImportKeywordAndImportKindSpecifier,
      importKindSpecifier,
      unexpectedBetweenImportKindSpecifierAndPath,
      path,
      unexpectedAfterPath
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndImportKeyword?.raw,
        importKeyword.raw,
        unexpectedBetweenImportKeywordAndImportKindSpecifier?.raw,
        importKindSpecifier?.raw,
        unexpectedBetweenImportKindSpecifierAndPath?.raw,
        path.raw,
        unexpectedAfterPath?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.importDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// Attributes attached to the import declaration, for example `@testable`.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ImportDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ImportDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// Modifiers that are attached to the import declaration. Currently, no modifiers are supported by Swift.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ImportDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ImportDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndImportKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// The `import` keyword for this declaration.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `import`.
  public var importKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  public var unexpectedBetweenImportKeywordAndImportKindSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// The kind of declaration being imported. 
  /// 
  /// A struct can be imported from a specific module.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `typealias`
  ///  - `struct`
  ///  - `class`
  ///  - `enum`
  ///  - `protocol`
  ///  - `var`
  ///  - `let`
  ///  - `func`
  ///  - `inout`
  public var importKindSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  public var unexpectedBetweenImportKindSpecifierAndPath: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// The path to the module, submodule or symbol being imported.
  public var path: ImportPathComponentListSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(ImportPathComponentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `path`
  /// collection.
  ///
  /// - param element: The new `PathComponent` to add to the node's
  ///                  `path` collection.
  /// - returns: A copy of the receiver with the provided `PathComponent`
  ///            appended to its `path` collection.
  @available(*, deprecated, message: "Use node.path.append(newElement) instead")
  public func addPathComponent(_ element: ImportPathComponentSyntax) -> ImportDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[9] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.importPathComponentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 9,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ImportDeclSyntax.self)
  }

  public var unexpectedAfterPath: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndImportKeyword,
    \Self.importKeyword,
    \Self.unexpectedBetweenImportKeywordAndImportKindSpecifier,
    \Self.importKindSpecifier,
    \Self.unexpectedBetweenImportKindSpecifierAndPath,
    \Self.path,
    \Self.unexpectedAfterPath
  ])
}

// MARK: - ImportPathComponentSyntax

/// ### Children
/// 
///  - `name`: (`<identifier>` | `<binaryOperator>` | `<prefixOperator>` | `<postfixOperator>`)
///  - `trailingPeriod`: `.`?
///
/// ### Contained in
/// 
///  - ``ImportPathComponentListSyntax``
public struct ImportPathComponentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .importPathComponent else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndTrailingPeriod: UnexpectedNodesSyntax? = nil,
    trailingPeriod: TokenSyntax? = nil,
    _ unexpectedAfterTrailingPeriod: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeName,
      name,
      unexpectedBetweenNameAndTrailingPeriod,
      trailingPeriod,
      unexpectedAfterTrailingPeriod
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeName?.raw,
        name.raw,
        unexpectedBetweenNameAndTrailingPeriod?.raw,
        trailingPeriod?.raw,
        unexpectedAfterTrailingPeriod?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.importPathComponent,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportPathComponentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `<identifier>`
  ///  - `<binaryOperator>`
  ///  - `<prefixOperator>`
  ///  - `<postfixOperator>`
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportPathComponentSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndTrailingPeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportPathComponentSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `.`.
  public var trailingPeriod: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportPathComponentSyntax.self)
    }
  }

  public var unexpectedAfterTrailingPeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ImportPathComponentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeName,
    \Self.name,
    \Self.unexpectedBetweenNameAndTrailingPeriod,
    \Self.trailingPeriod,
    \Self.unexpectedAfterTrailingPeriod
  ])
}

// MARK: - InOutExprSyntax

/// An expression prefixed with `&` to pass an argument to an `inout` parameter.
///
/// ### Children
/// 
///  - `ampersand`: `&`
///  - `expression`: ``ExprSyntax``
public struct InOutExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .inOutExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAmpersand: UnexpectedNodesSyntax? = nil,
    ampersand: TokenSyntax = .prefixAmpersandToken(),
    _ unexpectedBetweenAmpersandAndExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAmpersand,
      ampersand,
      unexpectedBetweenAmpersandAndExpression,
      expression,
      unexpectedAfterExpression
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAmpersand?.raw,
        ampersand.raw,
        unexpectedBetweenAmpersandAndExpression?.raw,
        expression.raw,
        unexpectedAfterExpression?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.inOutExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAmpersand: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InOutExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `&`.
  public var ampersand: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InOutExprSyntax.self)
    }
  }

  public var unexpectedBetweenAmpersandAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InOutExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InOutExprSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InOutExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAmpersand,
    \Self.ampersand,
    \Self.unexpectedBetweenAmpersandAndExpression,
    \Self.expression,
    \Self.unexpectedAfterExpression
  ])
}

// MARK: - InfixOperatorExprSyntax

/// An infix operator call like `1 + 2`.
/// 
/// - Note: This node is only generated after operators are folded using the `SwiftOperators` library. 
///   Beforehand, the parser does not know the precedences of operators and thus the operator is just
///   a ``BinaryOperatorExprSyntax`` in a ``SequenceExprSyntax``.
///
/// ### Children
/// 
///  - `leftOperand`: ``ExprSyntax``
///  - `operator`: ``ExprSyntax``
///  - `rightOperand`: ``ExprSyntax``
public struct InfixOperatorExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .infixOperatorExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftOperand: UnexpectedNodesSyntax? = nil,
    leftOperand: some ExprSyntaxProtocol,
    _ unexpectedBetweenLeftOperandAndOperator: UnexpectedNodesSyntax? = nil,
    operator: some ExprSyntaxProtocol,
    _ unexpectedBetweenOperatorAndRightOperand: UnexpectedNodesSyntax? = nil,
    rightOperand: some ExprSyntaxProtocol,
    _ unexpectedAfterRightOperand: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftOperand,
      leftOperand,
      unexpectedBetweenLeftOperandAndOperator,
      `operator`,
      unexpectedBetweenOperatorAndRightOperand,
      rightOperand,
      unexpectedAfterRightOperand
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftOperand?.raw,
        leftOperand.raw,
        unexpectedBetweenLeftOperandAndOperator?.raw,
        `operator`.raw,
        unexpectedBetweenOperatorAndRightOperand?.raw,
        rightOperand.raw,
        unexpectedAfterRightOperand?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.infixOperatorExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftOperand: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public var leftOperand: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public var unexpectedBetweenLeftOperandAndOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public var `operator`: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public var unexpectedBetweenOperatorAndRightOperand: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public var rightOperand: ExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public var unexpectedAfterRightOperand: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InfixOperatorExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftOperand,
    \Self.leftOperand,
    \Self.unexpectedBetweenLeftOperandAndOperator,
    \Self.operator,
    \Self.unexpectedBetweenOperatorAndRightOperand,
    \Self.rightOperand,
    \Self.unexpectedAfterRightOperand
  ])
}

// MARK: - InheritanceClauseSyntax

/// ### Children
/// 
///  - `colon`: `:`
///  - `inheritedTypes`: ``InheritedTypeListSyntax``
///
/// ### Contained in
/// 
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/inheritanceClause``
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/inheritanceClause``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/inheritanceClause``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/inheritanceClause``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/inheritanceClause``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/inheritanceClause``
///  - ``StructDeclSyntax``.``StructDeclSyntax/inheritanceClause``
public struct InheritanceClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .inheritanceClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndInheritedTypes: UnexpectedNodesSyntax? = nil,
    inheritedTypes: InheritedTypeListSyntax,
    _ unexpectedAfterInheritedTypes: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeColon,
      colon,
      unexpectedBetweenColonAndInheritedTypes,
      inheritedTypes,
      unexpectedAfterInheritedTypes
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndInheritedTypes?.raw,
        inheritedTypes.raw,
        unexpectedAfterInheritedTypes?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.inheritanceClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritanceClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritanceClauseSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndInheritedTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritanceClauseSyntax.self)
    }
  }

  public var inheritedTypes: InheritedTypeListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(InheritedTypeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritanceClauseSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `inheritedTypes`
  /// collection.
  ///
  /// - param element: The new `InheritedType` to add to the node's
  ///                  `inheritedTypes` collection.
  /// - returns: A copy of the receiver with the provided `InheritedType`
  ///            appended to its `inheritedTypes` collection.
  @available(*, deprecated, message: "Use node.inheritedTypes.append(newElement) instead")
  public func addInheritedType(_ element: InheritedTypeSyntax) -> InheritanceClauseSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.inheritedTypeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(InheritanceClauseSyntax.self)
  }

  public var unexpectedAfterInheritedTypes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritanceClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndInheritedTypes,
    \Self.inheritedTypes,
    \Self.unexpectedAfterInheritedTypes
  ])
}

// MARK: - InheritedTypeSyntax

/// ### Children
/// 
///  - `type`: ``TypeSyntax``
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``InheritedTypeListSyntax``
public struct InheritedTypeSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .inheritedType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedBetweenTypeAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeType,
      type,
      unexpectedBetweenTypeAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeType?.raw,
        type.raw,
        unexpectedBetweenTypeAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.inheritedType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritedTypeSyntax.self)
    }
  }

  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritedTypeSyntax.self)
    }
  }

  public var unexpectedBetweenTypeAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritedTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritedTypeSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InheritedTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeType,
    \Self.type,
    \Self.unexpectedBetweenTypeAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - InitializerClauseSyntax

/// ### Children
/// 
///  - `equal`: `=`
///  - `value`: ``ExprSyntax``
///
/// ### Contained in
/// 
///  - ``ClosureCaptureSyntax``.``ClosureCaptureSyntax/initializer``
///  - ``EnumCaseElementSyntax``.``EnumCaseElementSyntax/rawValue``
///  - ``EnumCaseParameterSyntax``.``EnumCaseParameterSyntax/defaultValue``
///  - ``FunctionParameterSyntax``.``FunctionParameterSyntax/defaultValue``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/definition``
///  - ``MatchingPatternConditionSyntax``.``MatchingPatternConditionSyntax/initializer``
///  - ``OptionalBindingConditionSyntax``.``OptionalBindingConditionSyntax/initializer``
///  - ``PatternBindingSyntax``.``PatternBindingSyntax/initializer``
public struct InitializerClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .initializerClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeEqual: UnexpectedNodesSyntax? = nil,
    equal: TokenSyntax = .equalToken(),
    _ unexpectedBetweenEqualAndValue: UnexpectedNodesSyntax? = nil,
    value: some ExprSyntaxProtocol,
    _ unexpectedAfterValue: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeEqual,
      equal,
      unexpectedBetweenEqualAndValue,
      value,
      unexpectedAfterValue
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeEqual?.raw,
        equal.raw,
        unexpectedBetweenEqualAndValue?.raw,
        value.raw,
        unexpectedAfterValue?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.initializerClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerClauseSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `=`.
  public var equal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerClauseSyntax.self)
    }
  }

  public var unexpectedBetweenEqualAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerClauseSyntax.self)
    }
  }

  public var value: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerClauseSyntax.self)
    }
  }

  public var unexpectedAfterValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerClauseSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeEqual,
    \Self.equal,
    \Self.unexpectedBetweenEqualAndValue,
    \Self.value,
    \Self.unexpectedAfterValue
  ])
}

// MARK: - InitializerDeclSyntax

/// An `init` declaration
/// 
/// An example of an initializer is
/// 
/// ```swift
/// init(someParameter: Int) {
/// }
/// ```
/// 
/// The body is optional because this node also represents initializer requirements inside protocols.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `initKeyword`: `init`
///  - `optionalMark`: (`?` | `!`)?
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `signature`: ``FunctionSignatureSyntax``
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `body`: ``CodeBlockSyntax``?
///
/// ### Contained in
/// 
///  - ``ABIAttributeArgumentsSyntax``.``ABIAttributeArgumentsSyntax/provider``
public struct InitializerDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .initializerDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes that are attached to the initializer.
  ///   - modifiers: Modifiers that are attached to the initializer declaration.
  ///   - initKeyword: The init keyword
  ///   - optionalMark: If the initializer is failable, a question mark to indicate that.
  ///   - genericParameterClause: Generic parameters of the initializer.
  ///   - signature: The arguments of the initializer. While the function signature allows specifying a return clause, doing so is not semantically valid.
  ///   - genericWhereClause: If the initializer had generic parameters, a where clause that can restrict those.
  ///   - body: The initializer’s body. Missing if the initializer is a requirement of a protocol declaration.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndInitKeyword: UnexpectedNodesSyntax? = nil,
    initKeyword: TokenSyntax = .keyword(.`init`),
    _ unexpectedBetweenInitKeywordAndOptionalMark: UnexpectedNodesSyntax? = nil,
    optionalMark: TokenSyntax? = nil,
    _ unexpectedBetweenOptionalMarkAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    _ unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? = nil,
    signature: FunctionSignatureSyntax,
    _ unexpectedBetweenSignatureAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax? = nil,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndInitKeyword,
      initKeyword,
      unexpectedBetweenInitKeywordAndOptionalMark,
      optionalMark,
      unexpectedBetweenOptionalMarkAndGenericParameterClause,
      genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndSignature,
      signature,
      unexpectedBetweenSignatureAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndInitKeyword?.raw,
        initKeyword.raw,
        unexpectedBetweenInitKeywordAndOptionalMark?.raw,
        optionalMark?.raw,
        unexpectedBetweenOptionalMarkAndGenericParameterClause?.raw,
        genericParameterClause?.raw,
        unexpectedBetweenGenericParameterClauseAndSignature?.raw,
        signature.raw,
        unexpectedBetweenSignatureAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndBody?.raw,
        body?.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.initializerDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// Attributes that are attached to the initializer.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> InitializerDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(InitializerDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// Modifiers that are attached to the initializer declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> InitializerDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(InitializerDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndInitKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// The init keyword
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `init`.
  public var initKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInitKeywordAndOptionalMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// If the initializer is failable, a question mark to indicate that.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `?`
  ///  - `!`
  public var optionalMark: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenOptionalMarkAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// Generic parameters of the initializer.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// The arguments of the initializer. While the function signature allows specifying a return clause, doing so is not semantically valid.
  public var signature: FunctionSignatureSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(FunctionSignatureSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenSignatureAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// If the initializer had generic parameters, a where clause that can restrict those.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  /// The initializer’s body. Missing if the initializer is a requirement of a protocol declaration.
  public var body: CodeBlockSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InitializerDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndInitKeyword,
    \Self.initKeyword,
    \Self.unexpectedBetweenInitKeywordAndOptionalMark,
    \Self.optionalMark,
    \Self.unexpectedBetweenOptionalMarkAndGenericParameterClause,
    \Self.genericParameterClause,
    \Self.unexpectedBetweenGenericParameterClauseAndSignature,
    \Self.signature,
    \Self.unexpectedBetweenSignatureAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - InlineArrayTypeSyntax

/// An inline array type `[3 of Int]`, sugar for `InlineArray<3, Int>`.
///
/// ### Children
/// 
///  - `leftSquare`: `[`
///  - `count`: ``GenericArgumentSyntax``
///  - `separator`: `of`
///  - `element`: ``GenericArgumentSyntax``
///  - `rightSquare`: `]`
public struct InlineArrayTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .inlineArrayType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - count: The `count` argument for the inline array type.
  ///   - element: The `element` argument for the inline array type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
    leftSquare: TokenSyntax = .leftSquareToken(),
    _ unexpectedBetweenLeftSquareAndCount: UnexpectedNodesSyntax? = nil,
    count: GenericArgumentSyntax,
    _ unexpectedBetweenCountAndSeparator: UnexpectedNodesSyntax? = nil,
    separator: TokenSyntax = .keyword(.of),
    _ unexpectedBetweenSeparatorAndElement: UnexpectedNodesSyntax? = nil,
    element: GenericArgumentSyntax,
    _ unexpectedBetweenElementAndRightSquare: UnexpectedNodesSyntax? = nil,
    rightSquare: TokenSyntax = .rightSquareToken(),
    _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftSquare,
      leftSquare,
      unexpectedBetweenLeftSquareAndCount,
      count,
      unexpectedBetweenCountAndSeparator,
      separator,
      unexpectedBetweenSeparatorAndElement,
      element,
      unexpectedBetweenElementAndRightSquare,
      rightSquare,
      unexpectedAfterRightSquare
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftSquare?.raw,
        leftSquare.raw,
        unexpectedBetweenLeftSquareAndCount?.raw,
        count.raw,
        unexpectedBetweenCountAndSeparator?.raw,
        separator.raw,
        unexpectedBetweenSeparatorAndElement?.raw,
        element.raw,
        unexpectedBetweenElementAndRightSquare?.raw,
        rightSquare.raw,
        unexpectedAfterRightSquare?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.inlineArrayType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `[`.
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  public var unexpectedBetweenLeftSquareAndCount: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  /// The `count` argument for the inline array type.
  /// 
  /// - Note: In semantically valid Swift code, this is always an integer or a wildcard type, e.g `_` in `[_ of Int]`.
  public var count: GenericArgumentSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(GenericArgumentSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  public var unexpectedBetweenCountAndSeparator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `of`.
  public var separator: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  public var unexpectedBetweenSeparatorAndElement: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  /// The `element` argument for the inline array type.
  /// 
  /// - Note: In semantically valid Swift code, this is always a type.
  public var element: GenericArgumentSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(GenericArgumentSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  public var unexpectedBetweenElementAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `]`.
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(InlineArrayTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftSquare,
    \Self.leftSquare,
    \Self.unexpectedBetweenLeftSquareAndCount,
    \Self.count,
    \Self.unexpectedBetweenCountAndSeparator,
    \Self.separator,
    \Self.unexpectedBetweenSeparatorAndElement,
    \Self.element,
    \Self.unexpectedBetweenElementAndRightSquare,
    \Self.rightSquare,
    \Self.unexpectedAfterRightSquare
  ])
}

// MARK: - IntegerLiteralExprSyntax

/// ### Children
/// 
///  - `literal`: `<integerLiteral>`
public struct IntegerLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .integerLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLiteral: UnexpectedNodesSyntax? = nil,
    literal: TokenSyntax,
    _ unexpectedAfterLiteral: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeLiteral, literal, unexpectedAfterLiteral))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeLiteral?.raw, literal.raw, unexpectedAfterLiteral?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.integerLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IntegerLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<integerLiteral>`.
  public var literal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IntegerLiteralExprSyntax.self)
    }
  }

  public var unexpectedAfterLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IntegerLiteralExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeLiteral, \Self.literal, \Self.unexpectedAfterLiteral])
}

// MARK: - IsExprSyntax

/// Checks if an expression is of a given type.
/// 
/// An example of an `is` expression is
/// 
/// ```swift
/// value is Double
/// ```
/// 
/// - Note: This node is only generated after operators are folded using the `SwiftOperators` library. 
///   Beforehand, the parser does not know the precedences of operators and thus represents `is` by an `UnresolvedIsExpr`.
///
/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `isKeyword`: `is`
///  - `type`: ``TypeSyntax``
public struct IsExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .isExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - expression: The expression which will be checked to determine whether it can be cast to a specific type.
  ///   - isKeyword: The `is` keyword for this expression.
  ///   - type: The type against which the expression will be checked to see if the expression can be cast to it.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndIsKeyword: UnexpectedNodesSyntax? = nil,
    isKeyword: TokenSyntax = .keyword(.is),
    _ unexpectedBetweenIsKeywordAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndIsKeyword,
      isKeyword,
      unexpectedBetweenIsKeywordAndType,
      type,
      unexpectedAfterType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndIsKeyword?.raw,
        isKeyword.raw,
        unexpectedBetweenIsKeywordAndType?.raw,
        type.raw,
        unexpectedAfterType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.isExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  /// The expression which will be checked to determine whether it can be cast to a specific type.
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndIsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  /// The `is` keyword for this expression.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `is`.
  public var isKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  public var unexpectedBetweenIsKeywordAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  /// The type against which the expression will be checked to see if the expression can be cast to it.
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndIsKeyword,
    \Self.isKeyword,
    \Self.unexpectedBetweenIsKeywordAndType,
    \Self.type,
    \Self.unexpectedAfterType
  ])
}

// MARK: - IsTypePatternSyntax

/// ### Children
/// 
///  - `isKeyword`: `is`
///  - `type`: ``TypeSyntax``
public struct IsTypePatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .isTypePattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeIsKeyword: UnexpectedNodesSyntax? = nil,
    isKeyword: TokenSyntax = .keyword(.is),
    _ unexpectedBetweenIsKeywordAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeIsKeyword,
      isKeyword,
      unexpectedBetweenIsKeywordAndType,
      type,
      unexpectedAfterType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeIsKeyword?.raw,
        isKeyword.raw,
        unexpectedBetweenIsKeywordAndType?.raw,
        type.raw,
        unexpectedAfterType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.isTypePattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeIsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsTypePatternSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `is`.
  public var isKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsTypePatternSyntax.self)
    }
  }

  public var unexpectedBetweenIsKeywordAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsTypePatternSyntax.self)
    }
  }

  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsTypePatternSyntax.self)
    }
  }

  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(IsTypePatternSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeIsKeyword,
    \Self.isKeyword,
    \Self.unexpectedBetweenIsKeywordAndType,
    \Self.type,
    \Self.unexpectedAfterType
  ])
}
