//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

// MARK: - ABIAttributeArgumentsSyntax

/// The arguments of the '@abi' attribute
///
/// ### Children
/// 
///  - `provider`: (``AssociatedTypeDeclSyntax`` | ``DeinitializerDeclSyntax`` | ``EnumCaseDeclSyntax`` | ``FunctionDeclSyntax`` | ``InitializerDeclSyntax`` | ``MissingDeclSyntax`` | ``SubscriptDeclSyntax`` | ``TypeAliasDeclSyntax`` | ``VariableDeclSyntax``)
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct ABIAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Provider: SyntaxChildChoices, SyntaxHashable {
    case associatedType(AssociatedTypeDeclSyntax)
    case deinitializer(DeinitializerDeclSyntax)
    case enumCase(EnumCaseDeclSyntax)
    case function(FunctionDeclSyntax)
    case initializer(InitializerDeclSyntax)
    case missing(MissingDeclSyntax)
    case `subscript`(SubscriptDeclSyntax)
    case typeAlias(TypeAliasDeclSyntax)
    case variable(VariableDeclSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .associatedType(let node):
        return node._syntaxNode
      case .deinitializer(let node):
        return node._syntaxNode
      case .enumCase(let node):
        return node._syntaxNode
      case .function(let node):
        return node._syntaxNode
      case .initializer(let node):
        return node._syntaxNode
      case .missing(let node):
        return node._syntaxNode
      case .subscript(let node):
        return node._syntaxNode
      case .typeAlias(let node):
        return node._syntaxNode
      case .variable(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: AssociatedTypeDeclSyntax) {
      self = .associatedType(node)
    }

    public init(_ node: DeinitializerDeclSyntax) {
      self = .deinitializer(node)
    }

    public init(_ node: EnumCaseDeclSyntax) {
      self = .enumCase(node)
    }

    public init(_ node: FunctionDeclSyntax) {
      self = .function(node)
    }

    public init(_ node: InitializerDeclSyntax) {
      self = .initializer(node)
    }

    public init(_ node: MissingDeclSyntax) {
      self = .missing(node)
    }

    public init(_ node: SubscriptDeclSyntax) {
      self = .subscript(node)
    }

    public init(_ node: TypeAliasDeclSyntax) {
      self = .typeAlias(node)
    }

    public init(_ node: VariableDeclSyntax) {
      self = .variable(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(AssociatedTypeDeclSyntax.self) {
        self = .associatedType(node)
      } else if let node = node.as(DeinitializerDeclSyntax.self) {
        self = .deinitializer(node)
      } else if let node = node.as(EnumCaseDeclSyntax.self) {
        self = .enumCase(node)
      } else if let node = node.as(FunctionDeclSyntax.self) {
        self = .function(node)
      } else if let node = node.as(InitializerDeclSyntax.self) {
        self = .initializer(node)
      } else if let node = node.as(MissingDeclSyntax.self) {
        self = .missing(node)
      } else if let node = node.as(SubscriptDeclSyntax.self) {
        self = .subscript(node)
      } else if let node = node.as(TypeAliasDeclSyntax.self) {
        self = .typeAlias(node)
      } else if let node = node.as(VariableDeclSyntax.self) {
        self = .variable(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([
        .node(AssociatedTypeDeclSyntax.self),
        .node(DeinitializerDeclSyntax.self),
        .node(EnumCaseDeclSyntax.self),
        .node(FunctionDeclSyntax.self),
        .node(InitializerDeclSyntax.self),
        .node(MissingDeclSyntax.self),
        .node(SubscriptDeclSyntax.self),
        .node(TypeAliasDeclSyntax.self),
        .node(VariableDeclSyntax.self)
      ])
    }

    /// Checks if the current syntax node can be cast to ``AssociatedTypeDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: AssociatedTypeDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``AssociatedTypeDeclSyntax``.
    ///
    /// - Returns: An instance of ``AssociatedTypeDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: AssociatedTypeDeclSyntax.Type) -> AssociatedTypeDeclSyntax? {
      return AssociatedTypeDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``AssociatedTypeDeclSyntax``.
    ///
    /// - Returns: An instance of ``AssociatedTypeDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: AssociatedTypeDeclSyntax.Type) -> AssociatedTypeDeclSyntax {
      return self.as(AssociatedTypeDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DeinitializerDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DeinitializerDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DeinitializerDeclSyntax``.
    ///
    /// - Returns: An instance of ``DeinitializerDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DeinitializerDeclSyntax.Type) -> DeinitializerDeclSyntax? {
      return DeinitializerDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DeinitializerDeclSyntax``.
    ///
    /// - Returns: An instance of ``DeinitializerDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DeinitializerDeclSyntax.Type) -> DeinitializerDeclSyntax {
      return self.as(DeinitializerDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``EnumCaseDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: EnumCaseDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``EnumCaseDeclSyntax``.
    ///
    /// - Returns: An instance of ``EnumCaseDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: EnumCaseDeclSyntax.Type) -> EnumCaseDeclSyntax? {
      return EnumCaseDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``EnumCaseDeclSyntax``.
    ///
    /// - Returns: An instance of ``EnumCaseDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: EnumCaseDeclSyntax.Type) -> EnumCaseDeclSyntax {
      return self.as(EnumCaseDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``FunctionDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: FunctionDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``FunctionDeclSyntax``.
    ///
    /// - Returns: An instance of ``FunctionDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: FunctionDeclSyntax.Type) -> FunctionDeclSyntax? {
      return FunctionDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``FunctionDeclSyntax``.
    ///
    /// - Returns: An instance of ``FunctionDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: FunctionDeclSyntax.Type) -> FunctionDeclSyntax {
      return self.as(FunctionDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``InitializerDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: InitializerDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``InitializerDeclSyntax``.
    ///
    /// - Returns: An instance of ``InitializerDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: InitializerDeclSyntax.Type) -> InitializerDeclSyntax? {
      return InitializerDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``InitializerDeclSyntax``.
    ///
    /// - Returns: An instance of ``InitializerDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: InitializerDeclSyntax.Type) -> InitializerDeclSyntax {
      return self.as(InitializerDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``MissingDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: MissingDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``MissingDeclSyntax``.
    ///
    /// - Returns: An instance of ``MissingDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: MissingDeclSyntax.Type) -> MissingDeclSyntax? {
      return MissingDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``MissingDeclSyntax``.
    ///
    /// - Returns: An instance of ``MissingDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: MissingDeclSyntax.Type) -> MissingDeclSyntax {
      return self.as(MissingDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``SubscriptDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SubscriptDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SubscriptDeclSyntax``.
    ///
    /// - Returns: An instance of ``SubscriptDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SubscriptDeclSyntax.Type) -> SubscriptDeclSyntax? {
      return SubscriptDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SubscriptDeclSyntax``.
    ///
    /// - Returns: An instance of ``SubscriptDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SubscriptDeclSyntax.Type) -> SubscriptDeclSyntax {
      return self.as(SubscriptDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``TypeAliasDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: TypeAliasDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``TypeAliasDeclSyntax``.
    ///
    /// - Returns: An instance of ``TypeAliasDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: TypeAliasDeclSyntax.Type) -> TypeAliasDeclSyntax? {
      return TypeAliasDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``TypeAliasDeclSyntax``.
    ///
    /// - Returns: An instance of ``TypeAliasDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: TypeAliasDeclSyntax.Type) -> TypeAliasDeclSyntax {
      return self.as(TypeAliasDeclSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``VariableDeclSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: VariableDeclSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``VariableDeclSyntax``.
    ///
    /// - Returns: An instance of ``VariableDeclSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: VariableDeclSyntax.Type) -> VariableDeclSyntax? {
      return VariableDeclSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``VariableDeclSyntax``.
    ///
    /// - Returns: An instance of ``VariableDeclSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: VariableDeclSyntax.Type) -> VariableDeclSyntax {
      return self.as(VariableDeclSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .abiAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeProvider: UnexpectedNodesSyntax? = nil,
    provider: Provider,
    _ unexpectedAfterProvider: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeProvider, provider, unexpectedAfterProvider))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeProvider?.raw, provider.raw, unexpectedAfterProvider?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.abiAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeProvider: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ABIAttributeArgumentsSyntax.self)
    }
  }

  public var provider: Provider {
    get {
      return Syntax(self).child(at: 1)!.cast(Provider.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ABIAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedAfterProvider: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ABIAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeProvider, \Self.provider, \Self.unexpectedAfterProvider])
}

// MARK: - AccessorBlockFileSyntax

/// Syntax for 'accessor' macro expansion, never appear in Swift source code.
///
/// ### Children
/// 
///  - `leftBrace`: `{`?
///  - `accessors`: ``AccessorDeclListSyntax``
///  - `rightBrace`: `}`?
///  - `endOfFileToken`: ``
@_spi(Compiler)
public struct AccessorBlockFileSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .accessorBlockFile else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? = nil,
    leftBrace: TokenSyntax? = nil,
    _ unexpectedBetweenLeftBraceAndAccessors: UnexpectedNodesSyntax? = nil,
    accessors: AccessorDeclListSyntax,
    _ unexpectedBetweenAccessorsAndRightBrace: UnexpectedNodesSyntax? = nil,
    rightBrace: TokenSyntax? = nil,
    _ unexpectedBetweenRightBraceAndEndOfFileToken: UnexpectedNodesSyntax? = nil,
    endOfFileToken: TokenSyntax = .endOfFileToken(),
    _ unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftBrace,
      leftBrace,
      unexpectedBetweenLeftBraceAndAccessors,
      accessors,
      unexpectedBetweenAccessorsAndRightBrace,
      rightBrace,
      unexpectedBetweenRightBraceAndEndOfFileToken,
      endOfFileToken,
      unexpectedAfterEndOfFileToken
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftBrace?.raw,
        leftBrace?.raw,
        unexpectedBetweenLeftBraceAndAccessors?.raw,
        accessors.raw,
        unexpectedBetweenAccessorsAndRightBrace?.raw,
        rightBrace?.raw,
        unexpectedBetweenRightBraceAndEndOfFileToken?.raw,
        endOfFileToken.raw,
        unexpectedAfterEndOfFileToken?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorBlockFile,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `{`.
  public var leftBrace: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  public var unexpectedBetweenLeftBraceAndAccessors: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  public var accessors: AccessorDeclListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(AccessorDeclListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  public var unexpectedBetweenAccessorsAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `}`.
  public var rightBrace: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  public var unexpectedBetweenRightBraceAndEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be ``.
  public var endOfFileToken: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  public var unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockFileSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftBrace,
    \Self.leftBrace,
    \Self.unexpectedBetweenLeftBraceAndAccessors,
    \Self.accessors,
    \Self.unexpectedBetweenAccessorsAndRightBrace,
    \Self.rightBrace,
    \Self.unexpectedBetweenRightBraceAndEndOfFileToken,
    \Self.endOfFileToken,
    \Self.unexpectedAfterEndOfFileToken
  ])
}

// MARK: - AccessorBlockSyntax

/// ### Children
/// 
///  - `leftBrace`: `{`
///  - `accessors`: (``AccessorDeclListSyntax`` | ``CodeBlockItemListSyntax``)
///  - `rightBrace`: `}`
///
/// ### Contained in
/// 
///  - ``PatternBindingSyntax``.``PatternBindingSyntax/accessorBlock``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/accessorBlock``
public struct AccessorBlockSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Accessors: SyntaxChildChoices, SyntaxHashable {
    case accessors(AccessorDeclListSyntax)
    case getter(CodeBlockItemListSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .accessors(let node):
        return node._syntaxNode
      case .getter(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: AccessorDeclListSyntax) {
      self = .accessors(node)
    }

    public init(_ node: CodeBlockItemListSyntax) {
      self = .getter(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(AccessorDeclListSyntax.self) {
        self = .accessors(node)
      } else if let node = node.as(CodeBlockItemListSyntax.self) {
        self = .getter(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(AccessorDeclListSyntax.self), .node(CodeBlockItemListSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``AccessorDeclListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: AccessorDeclListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``AccessorDeclListSyntax``.
    ///
    /// - Returns: An instance of ``AccessorDeclListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: AccessorDeclListSyntax.Type) -> AccessorDeclListSyntax? {
      return AccessorDeclListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``AccessorDeclListSyntax``.
    ///
    /// - Returns: An instance of ``AccessorDeclListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: AccessorDeclListSyntax.Type) -> AccessorDeclListSyntax {
      return self.as(AccessorDeclListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``CodeBlockItemListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: CodeBlockItemListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``CodeBlockItemListSyntax``.
    ///
    /// - Returns: An instance of ``CodeBlockItemListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: CodeBlockItemListSyntax.Type) -> CodeBlockItemListSyntax? {
      return CodeBlockItemListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``CodeBlockItemListSyntax``.
    ///
    /// - Returns: An instance of ``CodeBlockItemListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: CodeBlockItemListSyntax.Type) -> CodeBlockItemListSyntax {
      return self.as(CodeBlockItemListSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .accessorBlock else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - leftBrace: The brace introducing the accessor block.
  ///   - rightBrace: The brace closing the accessor block.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? = nil,
    leftBrace: TokenSyntax = .leftBraceToken(),
    _ unexpectedBetweenLeftBraceAndAccessors: UnexpectedNodesSyntax? = nil,
    accessors: Accessors,
    _ unexpectedBetweenAccessorsAndRightBrace: UnexpectedNodesSyntax? = nil,
    rightBrace: TokenSyntax = .rightBraceToken(),
    _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftBrace,
      leftBrace,
      unexpectedBetweenLeftBraceAndAccessors,
      accessors,
      unexpectedBetweenAccessorsAndRightBrace,
      rightBrace,
      unexpectedAfterRightBrace
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftBrace?.raw,
        leftBrace.raw,
        unexpectedBetweenLeftBraceAndAccessors?.raw,
        accessors.raw,
        unexpectedBetweenAccessorsAndRightBrace?.raw,
        rightBrace.raw,
        unexpectedAfterRightBrace?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorBlock,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  /// The brace introducing the accessor block.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `{`.
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  public var unexpectedBetweenLeftBraceAndAccessors: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  public var accessors: Accessors {
    get {
      return Syntax(self).child(at: 3)!.cast(Accessors.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  public var unexpectedBetweenAccessorsAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  /// The brace closing the accessor block.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `}`.
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftBrace,
    \Self.leftBrace,
    \Self.unexpectedBetweenLeftBraceAndAccessors,
    \Self.accessors,
    \Self.unexpectedBetweenAccessorsAndRightBrace,
    \Self.rightBrace,
    \Self.unexpectedAfterRightBrace
  ])
}

// MARK: - AccessorDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifier`: ``DeclModifierSyntax``?
///  - `accessorSpecifier`: (`get` | `set` | `didSet` | `willSet` | `unsafeAddress` | `addressWithOwner` | `addressWithNativeOwner` | `unsafeMutableAddress` | `mutableAddressWithOwner` | `mutableAddressWithNativeOwner` | `_read` | `read` | `_modify` | `modify` | `init`)
///  - `parameters`: ``AccessorParametersSyntax``?
///  - `effectSpecifiers`: ``AccessorEffectSpecifiersSyntax``?
///  - `body`: ``CodeBlockSyntax``?
///
/// ### Contained in
/// 
///  - ``AccessorDeclListSyntax``
public struct AccessorDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .accessorDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifier: UnexpectedNodesSyntax? = nil,
    modifier: DeclModifierSyntax? = nil,
    _ unexpectedBetweenModifierAndAccessorSpecifier: UnexpectedNodesSyntax? = nil,
    accessorSpecifier: TokenSyntax,
    _ unexpectedBetweenAccessorSpecifierAndParameters: UnexpectedNodesSyntax? = nil,
    parameters: AccessorParametersSyntax? = nil,
    _ unexpectedBetweenParametersAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
    effectSpecifiers: AccessorEffectSpecifiersSyntax? = nil,
    _ unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? = nil,
    body: CodeBlockSyntax? = nil,
    _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifier,
      modifier,
      unexpectedBetweenModifierAndAccessorSpecifier,
      accessorSpecifier,
      unexpectedBetweenAccessorSpecifierAndParameters,
      parameters,
      unexpectedBetweenParametersAndEffectSpecifiers,
      effectSpecifiers,
      unexpectedBetweenEffectSpecifiersAndBody,
      body,
      unexpectedAfterBody
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifier?.raw,
        modifier?.raw,
        unexpectedBetweenModifierAndAccessorSpecifier?.raw,
        accessorSpecifier.raw,
        unexpectedBetweenAccessorSpecifierAndParameters?.raw,
        parameters?.raw,
        unexpectedBetweenParametersAndEffectSpecifiers?.raw,
        effectSpecifiers?.raw,
        unexpectedBetweenEffectSpecifiersAndBody?.raw,
        body?.raw,
        unexpectedAfterBody?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AccessorDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AccessorDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var modifier: DeclModifierSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(DeclModifierSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenModifierAndAccessorSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `get`
  ///  - `set`
  ///  - `didSet`
  ///  - `willSet`
  ///  - `unsafeAddress`
  ///  - `addressWithOwner`
  ///  - `addressWithNativeOwner`
  ///  - `unsafeMutableAddress`
  ///  - `mutableAddressWithOwner`
  ///  - `mutableAddressWithNativeOwner`
  ///  - `_read`
  ///  - `read`
  ///  - `_modify`
  ///  - `modify`
  ///  - `init`
  public var accessorSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenAccessorSpecifierAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var parameters: AccessorParametersSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(AccessorParametersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenParametersAndEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var effectSpecifiers: AccessorEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(AccessorEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var body: CodeBlockSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifier,
    \Self.modifier,
    \Self.unexpectedBetweenModifierAndAccessorSpecifier,
    \Self.accessorSpecifier,
    \Self.unexpectedBetweenAccessorSpecifierAndParameters,
    \Self.parameters,
    \Self.unexpectedBetweenParametersAndEffectSpecifiers,
    \Self.effectSpecifiers,
    \Self.unexpectedBetweenEffectSpecifiersAndBody,
    \Self.body,
    \Self.unexpectedAfterBody
  ])
}

// MARK: - AccessorEffectSpecifiersSyntax

/// ### Children
/// 
///  - `asyncSpecifier`: `async`?
///  - `throwsClause`: ``ThrowsClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/effectSpecifiers``
public struct AccessorEffectSpecifiersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .accessorEffectSpecifiers else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - asyncSpecifier: The `async` keyword.
  ///   - throwsClause: The clause specifying thrown errors
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? = nil,
    asyncSpecifier: TokenSyntax? = nil,
    _ unexpectedBetweenAsyncSpecifierAndThrowsClause: UnexpectedNodesSyntax? = nil,
    throwsClause: ThrowsClauseSyntax? = nil,
    _ unexpectedAfterThrowsClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAsyncSpecifier,
      asyncSpecifier,
      unexpectedBetweenAsyncSpecifierAndThrowsClause,
      throwsClause,
      unexpectedAfterThrowsClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAsyncSpecifier?.raw,
        asyncSpecifier?.raw,
        unexpectedBetweenAsyncSpecifierAndThrowsClause?.raw,
        throwsClause?.raw,
        unexpectedAfterThrowsClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorEffectSpecifiers,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }

  /// The `async` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `async`.
  public var asyncSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }

  public var unexpectedBetweenAsyncSpecifierAndThrowsClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }

  /// The clause specifying thrown errors
  public var throwsClause: ThrowsClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ThrowsClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }

  public var unexpectedAfterThrowsClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAsyncSpecifier,
    \Self.asyncSpecifier,
    \Self.unexpectedBetweenAsyncSpecifierAndThrowsClause,
    \Self.throwsClause,
    \Self.unexpectedAfterThrowsClause
  ])
}

// MARK: - AccessorParametersSyntax

/// ### Children
/// 
///  - `leftParen`: `(`
///  - `name`: `<identifier>`
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/parameters``
public struct AccessorParametersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .accessorParameters else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndName,
      name,
      unexpectedBetweenNameAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorParameters,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - ActorDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `actorKeyword`: `actor`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct ActorDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .actorDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - modifiers: Modifiers like `public` that are attached to the actor declaration.
  ///   - actorKeyword: The `actor` keyword.
  ///   - name: The name of the actor. If the name matches a reserved keyword use backticks to escape it.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndActorKeyword: UnexpectedNodesSyntax? = nil,
    actorKeyword: TokenSyntax = .keyword(.actor),
    _ unexpectedBetweenActorKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
    genericParameterClause: GenericParameterClauseSyntax? = nil,
    _ unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
    memberBlock: MemberBlockSyntax,
    _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndActorKeyword,
      actorKeyword,
      unexpectedBetweenActorKeywordAndName,
      name,
      unexpectedBetweenNameAndGenericParameterClause,
      genericParameterClause,
      unexpectedBetweenGenericParameterClauseAndInheritanceClause,
      inheritanceClause,
      unexpectedBetweenInheritanceClauseAndGenericWhereClause,
      genericWhereClause,
      unexpectedBetweenGenericWhereClauseAndMemberBlock,
      memberBlock,
      unexpectedAfterMemberBlock
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndActorKeyword?.raw,
        actorKeyword.raw,
        unexpectedBetweenActorKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndGenericParameterClause?.raw,
        genericParameterClause?.raw,
        unexpectedBetweenGenericParameterClauseAndInheritanceClause?.raw,
        inheritanceClause?.raw,
        unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw,
        memberBlock.raw,
        unexpectedAfterMemberBlock?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.actorDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ActorDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ActorDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// Modifiers like `public` that are attached to the actor declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ActorDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ActorDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndActorKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// The `actor` keyword.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `actor`.
  public var actorKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenActorKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// The name of the actor. If the name matches a reserved keyword use backticks to escape it.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndActorKeyword,
    \Self.actorKeyword,
    \Self.unexpectedBetweenActorKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndGenericParameterClause,
    \Self.genericParameterClause,
    \Self.unexpectedBetweenGenericParameterClauseAndInheritanceClause,
    \Self.inheritanceClause,
    \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock,
    \Self.memberBlock,
    \Self.unexpectedAfterMemberBlock
  ])
}

// MARK: - ArrayElementSyntax

/// An element inside an array literal.
///
/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``ArrayElementListSyntax``
public struct ArrayElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .arrayElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrayElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - ArrayExprSyntax

/// An array literal.
///
/// ### Children
/// 
///  - `leftSquare`: `[`
///  - `elements`: ``ArrayElementListSyntax``
///  - `rightSquare`: `]`
public struct ArrayExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .arrayExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
    leftSquare: TokenSyntax = .leftSquareToken(),
    _ unexpectedBetweenLeftSquareAndElements: UnexpectedNodesSyntax? = nil,
    elements: ArrayElementListSyntax,
    _ unexpectedBetweenElementsAndRightSquare: UnexpectedNodesSyntax? = nil,
    rightSquare: TokenSyntax = .rightSquareToken(),
    _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftSquare,
      leftSquare,
      unexpectedBetweenLeftSquareAndElements,
      elements,
      unexpectedBetweenElementsAndRightSquare,
      rightSquare,
      unexpectedAfterRightSquare
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftSquare?.raw,
        leftSquare.raw,
        unexpectedBetweenLeftSquareAndElements?.raw,
        elements.raw,
        unexpectedBetweenElementsAndRightSquare?.raw,
        rightSquare.raw,
        unexpectedAfterRightSquare?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrayExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `[`.
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  public var unexpectedBetweenLeftSquareAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  public var elements: ArrayElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ArrayElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: ArrayElementSyntax) -> ArrayExprSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.arrayElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(ArrayExprSyntax.self)
  }

  public var unexpectedBetweenElementsAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `]`.
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftSquare,
    \Self.leftSquare,
    \Self.unexpectedBetweenLeftSquareAndElements,
    \Self.elements,
    \Self.unexpectedBetweenElementsAndRightSquare,
    \Self.rightSquare,
    \Self.unexpectedAfterRightSquare
  ])
}

// MARK: - ArrayTypeSyntax

/// ### Children
/// 
///  - `leftSquare`: `[`
///  - `element`: ``TypeSyntax``
///  - `rightSquare`: `]`
public struct ArrayTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .arrayType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
    leftSquare: TokenSyntax = .leftSquareToken(),
    _ unexpectedBetweenLeftSquareAndElement: UnexpectedNodesSyntax? = nil,
    element: some TypeSyntaxProtocol,
    _ unexpectedBetweenElementAndRightSquare: UnexpectedNodesSyntax? = nil,
    rightSquare: TokenSyntax = .rightSquareToken(),
    _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLeftSquare,
      leftSquare,
      unexpectedBetweenLeftSquareAndElement,
      element,
      unexpectedBetweenElementAndRightSquare,
      rightSquare,
      unexpectedAfterRightSquare
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLeftSquare?.raw,
        leftSquare.raw,
        unexpectedBetweenLeftSquareAndElement?.raw,
        element.raw,
        unexpectedBetweenElementAndRightSquare?.raw,
        rightSquare.raw,
        unexpectedAfterRightSquare?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrayType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `[`.
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  public var unexpectedBetweenLeftSquareAndElement: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  public var element: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  public var unexpectedBetweenElementAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `]`.
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLeftSquare,
    \Self.leftSquare,
    \Self.unexpectedBetweenLeftSquareAndElement,
    \Self.element,
    \Self.unexpectedBetweenElementAndRightSquare,
    \Self.rightSquare,
    \Self.unexpectedAfterRightSquare
  ])
}

// MARK: - ArrowExprSyntax

/// The arrow when a type is used at a position that syntactically expectes an expression.
/// 
/// ### Examples
/// 
/// This represents the arrow in
/// 
/// ```swift
/// let array = [(Int) -> Int]()
/// ```
///
/// ### Children
/// 
///  - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
///  - `arrow`: `->`
public struct ArrowExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .arrowExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeEffectSpecifiers: UnexpectedNodesSyntax? = nil,
    effectSpecifiers: TypeEffectSpecifiersSyntax? = nil,
    _ unexpectedBetweenEffectSpecifiersAndArrow: UnexpectedNodesSyntax? = nil,
    arrow: TokenSyntax = .arrowToken(),
    _ unexpectedAfterArrow: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeEffectSpecifiers,
      effectSpecifiers,
      unexpectedBetweenEffectSpecifiersAndArrow,
      arrow,
      unexpectedAfterArrow
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeEffectSpecifiers?.raw,
        effectSpecifiers?.raw,
        unexpectedBetweenEffectSpecifiersAndArrow?.raw,
        arrow.raw,
        unexpectedAfterArrow?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrowExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }

  public var effectSpecifiers: TypeEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TypeEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }

  public var unexpectedBetweenEffectSpecifiersAndArrow: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `->`.
  public var arrow: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }

  public var unexpectedAfterArrow: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeEffectSpecifiers,
    \Self.effectSpecifiers,
    \Self.unexpectedBetweenEffectSpecifiersAndArrow,
    \Self.arrow,
    \Self.unexpectedAfterArrow
  ])
}

// MARK: - AsExprSyntax

/// The cast of an expressison to a different type.
/// 
/// ### Examples
/// 
/// ```swift
/// dog as Animal
/// ``` 
/// 
/// ```swift
/// myPet as? Dog
/// ```
/// 
/// - Note: This node is only generated after operators are folded using the `SwiftOperators` library. 
///   Beforehand, the parser does not know the precedences of operators and thus represents `is` by an ``UnresolvedAsExprSyntax``.
///
/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `asKeyword`: `as`
///  - `questionOrExclamationMark`: (`?` | `!`)?
///  - `type`: ``TypeSyntax``
public struct AsExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .asExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedBetweenExpressionAndAsKeyword: UnexpectedNodesSyntax? = nil,
    asKeyword: TokenSyntax = .keyword(.as),
    _ unexpectedBetweenAsKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
    questionOrExclamationMark: TokenSyntax? = nil,
    _ unexpectedBetweenQuestionOrExclamationMarkAndType: UnexpectedNodesSyntax? = nil,
    type: some TypeSyntaxProtocol,
    _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeExpression,
      expression,
      unexpectedBetweenExpressionAndAsKeyword,
      asKeyword,
      unexpectedBetweenAsKeywordAndQuestionOrExclamationMark,
      questionOrExclamationMark,
      unexpectedBetweenQuestionOrExclamationMarkAndType,
      type,
      unexpectedAfterType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeExpression?.raw,
        expression.raw,
        unexpectedBetweenExpressionAndAsKeyword?.raw,
        asKeyword.raw,
        unexpectedBetweenAsKeywordAndQuestionOrExclamationMark?.raw,
        questionOrExclamationMark?.raw,
        unexpectedBetweenQuestionOrExclamationMarkAndType?.raw,
        type.raw,
        unexpectedAfterType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.asExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public var unexpectedBetweenExpressionAndAsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `as`.
  public var asKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public var unexpectedBetweenAsKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `?`
  ///  - `!`
  public var questionOrExclamationMark: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public var unexpectedBetweenQuestionOrExclamationMarkAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AsExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeExpression,
    \Self.expression,
    \Self.unexpectedBetweenExpressionAndAsKeyword,
    \Self.asKeyword,
    \Self.unexpectedBetweenAsKeywordAndQuestionOrExclamationMark,
    \Self.questionOrExclamationMark,
    \Self.unexpectedBetweenQuestionOrExclamationMarkAndType,
    \Self.type,
    \Self.unexpectedAfterType
  ])
}

// MARK: - AssignmentExprSyntax

/// ### Children
/// 
///  - `equal`: `=`
public struct AssignmentExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .assignmentExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeEqual: UnexpectedNodesSyntax? = nil,
    equal: TokenSyntax = .equalToken(),
    _ unexpectedAfterEqual: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeEqual, equal, unexpectedAfterEqual))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeEqual?.raw, equal.raw, unexpectedAfterEqual?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.assignmentExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssignmentExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `=`.
  public var equal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssignmentExprSyntax.self)
    }
  }

  public var unexpectedAfterEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssignmentExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeEqual, \Self.equal, \Self.unexpectedAfterEqual])
}

// MARK: - AssociatedTypeDeclSyntax

/// An `associatedtype` declaration
/// 
/// An example of an associatedtype declaration is
/// 
/// ```swift
/// associatedtype Item
/// ```
/// 
/// An associated type declaration may contain a type initializer clause which represents a default type assignment for the associated type.
/// 
/// ```swift
/// associatedtype Item = Int
/// ```
/// 
/// An associated type declaration may be declared with an inheritance clause which specifies the required conformances.
/// 
/// ```swift
/// associatedtype Iterator: IteratorProtocol
/// ```
/// 
/// A generic where clause may be present, here is an example which shows an associated type containing an inheritance clauses and a generic where clause.
/// 
/// ```swift
/// associatedtype Iterator: IteratorProtocol where Iterator.Element == Item
/// ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `associatedtypeKeyword`: `associatedtype`
///  - `name`: `<identifier>`
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `initializer`: ``TypeInitializerClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``ABIAttributeArgumentsSyntax``.``ABIAttributeArgumentsSyntax/provider``
public struct AssociatedTypeDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .associatedTypeDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes attached to the associated type declaration.
  ///   - modifiers: Modifiers like `public` that are attached to the associated type declaration.
  ///   - associatedtypeKeyword: The `associatedtype` keyword for this declaration.
  ///   - name: The name of this associated type.
  ///   - inheritanceClause: The inheritance clause describing conformances for this associated type declaration.
  ///   - initializer: The type initializer clause for this associated type declaration which represents a default type assignment for the associated type.
  ///   - genericWhereClause: The `where` clause that applies to the generic parameters of this associated type declaration.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax = [],
    _ unexpectedBetweenModifiersAndAssociatedtypeKeyword: UnexpectedNodesSyntax? = nil,
    associatedtypeKeyword: TokenSyntax = .keyword(.associatedtype),
    _ unexpectedBetweenAssociatedtypeKeywordAndName: UnexpectedNodesSyntax? = nil,
    name: TokenSyntax,
    _ unexpectedBetweenNameAndInheritanceClause: UnexpectedNodesSyntax? = nil,
    inheritanceClause: InheritanceClauseSyntax? = nil,
    _ unexpectedBetweenInheritanceClauseAndInitializer: UnexpectedNodesSyntax? = nil,
    initializer: TypeInitializerClauseSyntax? = nil,
    _ unexpectedBetweenInitializerAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
    genericWhereClause: GenericWhereClauseSyntax? = nil,
    _ unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndAssociatedtypeKeyword,
      associatedtypeKeyword,
      unexpectedBetweenAssociatedtypeKeywordAndName,
      name,
      unexpectedBetweenNameAndInheritanceClause,
      inheritanceClause,
      unexpectedBetweenInheritanceClauseAndInitializer,
      initializer,
      unexpectedBetweenInitializerAndGenericWhereClause,
      genericWhereClause,
      unexpectedAfterGenericWhereClause
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndAssociatedtypeKeyword?.raw,
        associatedtypeKeyword.raw,
        unexpectedBetweenAssociatedtypeKeywordAndName?.raw,
        name.raw,
        unexpectedBetweenNameAndInheritanceClause?.raw,
        inheritanceClause?.raw,
        unexpectedBetweenInheritanceClauseAndInitializer?.raw,
        initializer?.raw,
        unexpectedBetweenInitializerAndGenericWhereClause?.raw,
        genericWhereClause?.raw,
        unexpectedAfterGenericWhereClause?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.associatedTypeDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// Attributes attached to the associated type declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AssociatedTypeDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AssociatedTypeDeclSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// Modifiers like `public` that are attached to the associated type declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> AssociatedTypeDeclSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AssociatedTypeDeclSyntax.self)
  }

  public var unexpectedBetweenModifiersAndAssociatedtypeKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// The `associatedtype` keyword for this declaration.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `associatedtype`.
  public var associatedtypeKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  public var unexpectedBetweenAssociatedtypeKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// The name of this associated type.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  public var unexpectedBetweenNameAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// The inheritance clause describing conformances for this associated type declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInheritanceClauseAndInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// The type initializer clause for this associated type declaration which represents a default type assignment for the associated type.
  public var initializer: TypeInitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TypeInitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  public var unexpectedBetweenInitializerAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  /// The `where` clause that applies to the generic parameters of this associated type declaration.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  public var unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndAssociatedtypeKeyword,
    \Self.associatedtypeKeyword,
    \Self.unexpectedBetweenAssociatedtypeKeywordAndName,
    \Self.name,
    \Self.unexpectedBetweenNameAndInheritanceClause,
    \Self.inheritanceClause,
    \Self.unexpectedBetweenInheritanceClauseAndInitializer,
    \Self.initializer,
    \Self.unexpectedBetweenInitializerAndGenericWhereClause,
    \Self.genericWhereClause,
    \Self.unexpectedAfterGenericWhereClause
  ])
}

// MARK: - AttributeClauseFileSyntax

/// Syntax for 'memberAttribute' macro expansion or 'swift_attr' attribute in Clang, never appear in Swift source code.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `endOfFileToken`: ``
@_spi(Compiler)
public struct AttributeClauseFileSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .attributeClauseFile else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax,
    _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
    modifiers: DeclModifierListSyntax,
    _ unexpectedBetweenModifiersAndEndOfFileToken: UnexpectedNodesSyntax? = nil,
    endOfFileToken: TokenSyntax = .endOfFileToken(),
    _ unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAttributes,
      attributes,
      unexpectedBetweenAttributesAndModifiers,
      modifiers,
      unexpectedBetweenModifiersAndEndOfFileToken,
      endOfFileToken,
      unexpectedAfterEndOfFileToken
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndModifiers?.raw,
        modifiers.raw,
        unexpectedBetweenModifiersAndEndOfFileToken?.raw,
        endOfFileToken.raw,
        unexpectedAfterEndOfFileToken?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.attributeClauseFile,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AttributeClauseFileSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AttributeClauseFileSyntax.self)
  }

  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  public var unexpectedBetweenModifiersAndEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be ``.
  public var endOfFileToken: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  public var unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeClauseFileSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndModifiers,
    \Self.modifiers,
    \Self.unexpectedBetweenModifiersAndEndOfFileToken,
    \Self.endOfFileToken,
    \Self.unexpectedAfterEndOfFileToken
  ])
}

// MARK: - AttributeSyntax

/// An `@` attribute.
///
/// ### Children
/// 
///  - `atSign`: `@`
///  - `attributeName`: ``TypeSyntax``
///  - `leftParen`: `(`?
///  - `arguments`: (``LabeledExprListSyntax`` | ``AvailabilityArgumentListSyntax`` | ``SpecializeAttributeArgumentListSyntax`` | ``ObjCSelectorPieceListSyntax`` | ``ImplementsAttributeArgumentsSyntax`` | ``DifferentiableAttributeArgumentsSyntax`` | ``DerivativeAttributeArgumentsSyntax`` | ``BackDeployedAttributeArgumentsSyntax`` | ``OriginallyDefinedInAttributeArgumentsSyntax`` | ``DynamicReplacementAttributeArgumentsSyntax`` | ``EffectsAttributeArgumentListSyntax`` | ``DocumentationAttributeArgumentListSyntax`` | ``ABIAttributeArgumentsSyntax``)?
///  - `rightParen`: `)`?
///
/// ### Contained in
/// 
///  - ``AttributeListSyntax``
///  - ``SwitchCaseSyntax``.``SwitchCaseSyntax/attribute``
public struct AttributeSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Arguments: SyntaxChildChoices, SyntaxHashable {
    case argumentList(LabeledExprListSyntax)
    case availability(AvailabilityArgumentListSyntax)
    case specializeArguments(SpecializeAttributeArgumentListSyntax)
    case objCName(ObjCSelectorPieceListSyntax)
    case implementsArguments(ImplementsAttributeArgumentsSyntax)
    case differentiableArguments(DifferentiableAttributeArgumentsSyntax)
    case derivativeRegistrationArguments(DerivativeAttributeArgumentsSyntax)
    case backDeployedArguments(BackDeployedAttributeArgumentsSyntax)
    case originallyDefinedInArguments(OriginallyDefinedInAttributeArgumentsSyntax)
    case dynamicReplacementArguments(DynamicReplacementAttributeArgumentsSyntax)
    case effectsArguments(EffectsAttributeArgumentListSyntax)
    case documentationArguments(DocumentationAttributeArgumentListSyntax)
    case abiArguments(ABIAttributeArgumentsSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .argumentList(let node):
        return node._syntaxNode
      case .availability(let node):
        return node._syntaxNode
      case .specializeArguments(let node):
        return node._syntaxNode
      case .objCName(let node):
        return node._syntaxNode
      case .implementsArguments(let node):
        return node._syntaxNode
      case .differentiableArguments(let node):
        return node._syntaxNode
      case .derivativeRegistrationArguments(let node):
        return node._syntaxNode
      case .backDeployedArguments(let node):
        return node._syntaxNode
      case .originallyDefinedInArguments(let node):
        return node._syntaxNode
      case .dynamicReplacementArguments(let node):
        return node._syntaxNode
      case .effectsArguments(let node):
        return node._syntaxNode
      case .documentationArguments(let node):
        return node._syntaxNode
      case .abiArguments(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: LabeledExprListSyntax) {
      self = .argumentList(node)
    }

    public init(_ node: AvailabilityArgumentListSyntax) {
      self = .availability(node)
    }

    public init(_ node: SpecializeAttributeArgumentListSyntax) {
      self = .specializeArguments(node)
    }

    public init(_ node: ObjCSelectorPieceListSyntax) {
      self = .objCName(node)
    }

    public init(_ node: ImplementsAttributeArgumentsSyntax) {
      self = .implementsArguments(node)
    }

    public init(_ node: DifferentiableAttributeArgumentsSyntax) {
      self = .differentiableArguments(node)
    }

    public init(_ node: DerivativeAttributeArgumentsSyntax) {
      self = .derivativeRegistrationArguments(node)
    }

    public init(_ node: BackDeployedAttributeArgumentsSyntax) {
      self = .backDeployedArguments(node)
    }

    public init(_ node: OriginallyDefinedInAttributeArgumentsSyntax) {
      self = .originallyDefinedInArguments(node)
    }

    public init(_ node: DynamicReplacementAttributeArgumentsSyntax) {
      self = .dynamicReplacementArguments(node)
    }

    public init(_ node: EffectsAttributeArgumentListSyntax) {
      self = .effectsArguments(node)
    }

    public init(_ node: DocumentationAttributeArgumentListSyntax) {
      self = .documentationArguments(node)
    }

    public init(_ node: ABIAttributeArgumentsSyntax) {
      self = .abiArguments(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(LabeledExprListSyntax.self) {
        self = .argumentList(node)
      } else if let node = node.as(AvailabilityArgumentListSyntax.self) {
        self = .availability(node)
      } else if let node = node.as(SpecializeAttributeArgumentListSyntax.self) {
        self = .specializeArguments(node)
      } else if let node = node.as(ObjCSelectorPieceListSyntax.self) {
        self = .objCName(node)
      } else if let node = node.as(ImplementsAttributeArgumentsSyntax.self) {
        self = .implementsArguments(node)
      } else if let node = node.as(DifferentiableAttributeArgumentsSyntax.self) {
        self = .differentiableArguments(node)
      } else if let node = node.as(DerivativeAttributeArgumentsSyntax.self) {
        self = .derivativeRegistrationArguments(node)
      } else if let node = node.as(BackDeployedAttributeArgumentsSyntax.self) {
        self = .backDeployedArguments(node)
      } else if let node = node.as(OriginallyDefinedInAttributeArgumentsSyntax.self) {
        self = .originallyDefinedInArguments(node)
      } else if let node = node.as(DynamicReplacementAttributeArgumentsSyntax.self) {
        self = .dynamicReplacementArguments(node)
      } else if let node = node.as(EffectsAttributeArgumentListSyntax.self) {
        self = .effectsArguments(node)
      } else if let node = node.as(DocumentationAttributeArgumentListSyntax.self) {
        self = .documentationArguments(node)
      } else if let node = node.as(ABIAttributeArgumentsSyntax.self) {
        self = .abiArguments(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([
        .node(LabeledExprListSyntax.self),
        .node(AvailabilityArgumentListSyntax.self),
        .node(SpecializeAttributeArgumentListSyntax.self),
        .node(ObjCSelectorPieceListSyntax.self),
        .node(ImplementsAttributeArgumentsSyntax.self),
        .node(DifferentiableAttributeArgumentsSyntax.self),
        .node(DerivativeAttributeArgumentsSyntax.self),
        .node(BackDeployedAttributeArgumentsSyntax.self),
        .node(OriginallyDefinedInAttributeArgumentsSyntax.self),
        .node(DynamicReplacementAttributeArgumentsSyntax.self),
        .node(EffectsAttributeArgumentListSyntax.self),
        .node(DocumentationAttributeArgumentListSyntax.self),
        .node(ABIAttributeArgumentsSyntax.self)
      ])
    }

    /// Checks if the current syntax node can be cast to ``LabeledExprListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: LabeledExprListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``LabeledExprListSyntax``.
    ///
    /// - Returns: An instance of ``LabeledExprListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: LabeledExprListSyntax.Type) -> LabeledExprListSyntax? {
      return LabeledExprListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``LabeledExprListSyntax``.
    ///
    /// - Returns: An instance of ``LabeledExprListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: LabeledExprListSyntax.Type) -> LabeledExprListSyntax {
      return self.as(LabeledExprListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``AvailabilityArgumentListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: AvailabilityArgumentListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``AvailabilityArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``AvailabilityArgumentListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: AvailabilityArgumentListSyntax.Type) -> AvailabilityArgumentListSyntax? {
      return AvailabilityArgumentListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``AvailabilityArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``AvailabilityArgumentListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: AvailabilityArgumentListSyntax.Type) -> AvailabilityArgumentListSyntax {
      return self.as(AvailabilityArgumentListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``SpecializeAttributeArgumentListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SpecializeAttributeArgumentListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SpecializeAttributeArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``SpecializeAttributeArgumentListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SpecializeAttributeArgumentListSyntax.Type) -> SpecializeAttributeArgumentListSyntax? {
      return SpecializeAttributeArgumentListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SpecializeAttributeArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``SpecializeAttributeArgumentListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SpecializeAttributeArgumentListSyntax.Type) -> SpecializeAttributeArgumentListSyntax {
      return self.as(SpecializeAttributeArgumentListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``ObjCSelectorPieceListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: ObjCSelectorPieceListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``ObjCSelectorPieceListSyntax``.
    ///
    /// - Returns: An instance of ``ObjCSelectorPieceListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: ObjCSelectorPieceListSyntax.Type) -> ObjCSelectorPieceListSyntax? {
      return ObjCSelectorPieceListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``ObjCSelectorPieceListSyntax``.
    ///
    /// - Returns: An instance of ``ObjCSelectorPieceListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: ObjCSelectorPieceListSyntax.Type) -> ObjCSelectorPieceListSyntax {
      return self.as(ObjCSelectorPieceListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``ImplementsAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: ImplementsAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``ImplementsAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``ImplementsAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: ImplementsAttributeArgumentsSyntax.Type) -> ImplementsAttributeArgumentsSyntax? {
      return ImplementsAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``ImplementsAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``ImplementsAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: ImplementsAttributeArgumentsSyntax.Type) -> ImplementsAttributeArgumentsSyntax {
      return self.as(ImplementsAttributeArgumentsSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DifferentiableAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DifferentiableAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DifferentiableAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DifferentiableAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DifferentiableAttributeArgumentsSyntax.Type) -> DifferentiableAttributeArgumentsSyntax? {
      return DifferentiableAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DifferentiableAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DifferentiableAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DifferentiableAttributeArgumentsSyntax.Type) -> DifferentiableAttributeArgumentsSyntax {
      return self.as(DifferentiableAttributeArgumentsSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DerivativeAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DerivativeAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DerivativeAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DerivativeAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DerivativeAttributeArgumentsSyntax.Type) -> DerivativeAttributeArgumentsSyntax? {
      return DerivativeAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DerivativeAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DerivativeAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DerivativeAttributeArgumentsSyntax.Type) -> DerivativeAttributeArgumentsSyntax {
      return self.as(DerivativeAttributeArgumentsSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``BackDeployedAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: BackDeployedAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``BackDeployedAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``BackDeployedAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: BackDeployedAttributeArgumentsSyntax.Type) -> BackDeployedAttributeArgumentsSyntax? {
      return BackDeployedAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``BackDeployedAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``BackDeployedAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: BackDeployedAttributeArgumentsSyntax.Type) -> BackDeployedAttributeArgumentsSyntax {
      return self.as(BackDeployedAttributeArgumentsSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``OriginallyDefinedInAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: OriginallyDefinedInAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``OriginallyDefinedInAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``OriginallyDefinedInAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: OriginallyDefinedInAttributeArgumentsSyntax.Type) -> OriginallyDefinedInAttributeArgumentsSyntax? {
      return OriginallyDefinedInAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``OriginallyDefinedInAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``OriginallyDefinedInAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: OriginallyDefinedInAttributeArgumentsSyntax.Type) -> OriginallyDefinedInAttributeArgumentsSyntax {
      return self.as(OriginallyDefinedInAttributeArgumentsSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DynamicReplacementAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DynamicReplacementAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DynamicReplacementAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DynamicReplacementAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DynamicReplacementAttributeArgumentsSyntax.Type) -> DynamicReplacementAttributeArgumentsSyntax? {
      return DynamicReplacementAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DynamicReplacementAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``DynamicReplacementAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DynamicReplacementAttributeArgumentsSyntax.Type) -> DynamicReplacementAttributeArgumentsSyntax {
      return self.as(DynamicReplacementAttributeArgumentsSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``EffectsAttributeArgumentListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: EffectsAttributeArgumentListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``EffectsAttributeArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``EffectsAttributeArgumentListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: EffectsAttributeArgumentListSyntax.Type) -> EffectsAttributeArgumentListSyntax? {
      return EffectsAttributeArgumentListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``EffectsAttributeArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``EffectsAttributeArgumentListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: EffectsAttributeArgumentListSyntax.Type) -> EffectsAttributeArgumentListSyntax {
      return self.as(EffectsAttributeArgumentListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``DocumentationAttributeArgumentListSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: DocumentationAttributeArgumentListSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``DocumentationAttributeArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``DocumentationAttributeArgumentListSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: DocumentationAttributeArgumentListSyntax.Type) -> DocumentationAttributeArgumentListSyntax? {
      return DocumentationAttributeArgumentListSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``DocumentationAttributeArgumentListSyntax``.
    ///
    /// - Returns: An instance of ``DocumentationAttributeArgumentListSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: DocumentationAttributeArgumentListSyntax.Type) -> DocumentationAttributeArgumentListSyntax {
      return self.as(DocumentationAttributeArgumentListSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``ABIAttributeArgumentsSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: ABIAttributeArgumentsSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``ABIAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``ABIAttributeArgumentsSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: ABIAttributeArgumentsSyntax.Type) -> ABIAttributeArgumentsSyntax? {
      return ABIAttributeArgumentsSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``ABIAttributeArgumentsSyntax``.
    ///
    /// - Returns: An instance of ``ABIAttributeArgumentsSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: ABIAttributeArgumentsSyntax.Type) -> ABIAttributeArgumentsSyntax {
      return self.as(ABIAttributeArgumentsSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .attribute else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - atSign: The `@` sign.
  ///   - attributeName: The name of the attribute.
  ///   - leftParen: If the attribute takes arguments, the opening parenthesis.
  ///   - arguments: The arguments of the attribute.
  ///   - rightParen: If the attribute takes arguments, the closing parenthesis.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAtSign: UnexpectedNodesSyntax? = nil,
    atSign: TokenSyntax = .atSignToken(),
    _ unexpectedBetweenAtSignAndAttributeName: UnexpectedNodesSyntax? = nil,
    attributeName: some TypeSyntaxProtocol,
    _ unexpectedBetweenAttributeNameAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax? = nil,
    _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
    arguments: Arguments? = nil,
    _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax? = nil,
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAtSign,
      atSign,
      unexpectedBetweenAtSignAndAttributeName,
      attributeName,
      unexpectedBetweenAttributeNameAndLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndArguments,
      arguments,
      unexpectedBetweenArgumentsAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAtSign?.raw,
        atSign.raw,
        unexpectedBetweenAtSignAndAttributeName?.raw,
        attributeName.raw,
        unexpectedBetweenAttributeNameAndLeftParen?.raw,
        leftParen?.raw,
        unexpectedBetweenLeftParenAndArguments?.raw,
        arguments?.raw,
        unexpectedBetweenArgumentsAndRightParen?.raw,
        rightParen?.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.attribute,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAtSign: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  /// The `@` sign.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `@`.
  public var atSign: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  public var unexpectedBetweenAtSignAndAttributeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  /// The name of the attribute.
  public var attributeName: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  public var unexpectedBetweenAttributeNameAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  /// If the attribute takes arguments, the opening parenthesis.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  /// The arguments of the attribute.
  /// 
  /// In case of user-defined attributes, such as macros, property wrappers or result builders,
  /// this is always either an `argumentList` of type ``LabeledExprListSyntax`` or `nil`.
  public var arguments: Arguments? {
    get {
      return Syntax(self).child(at: 7)?.cast(Arguments.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  /// If the attribute takes arguments, the closing parenthesis.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAtSign,
    \Self.atSign,
    \Self.unexpectedBetweenAtSignAndAttributeName,
    \Self.attributeName,
    \Self.unexpectedBetweenAttributeNameAndLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndArguments,
    \Self.arguments,
    \Self.unexpectedBetweenArgumentsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - AttributedTypeSyntax

/// ### Children
/// 
///  - `specifiers`: ``TypeSpecifierListSyntax``
///  - `attributes`: ``AttributeListSyntax``
///  - `lateSpecifiers`: ``TypeSpecifierListSyntax``
///  - `baseType`: ``TypeSyntax``
public struct AttributedTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .attributedType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - specifiers: A list of specifiers that can be attached to the type, such as `inout`, `isolated`, or `consuming`.
  ///   - attributes: A list of attributes that can be attached to the type, such as `@escaping`.
  ///   - lateSpecifiers: A list of specifiers that can be attached to the type after the attributes, such as 'nonisolated'.
  ///   - baseType: The type to with the specifiers and attributes are applied.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeSpecifiers: UnexpectedNodesSyntax? = nil,
    specifiers: TypeSpecifierListSyntax = [],
    _ unexpectedBetweenSpecifiersAndAttributes: UnexpectedNodesSyntax? = nil,
    attributes: AttributeListSyntax = [],
    _ unexpectedBetweenAttributesAndLateSpecifiers: UnexpectedNodesSyntax? = nil,
    lateSpecifiers: TypeSpecifierListSyntax = [],
    _ unexpectedBetweenLateSpecifiersAndBaseType: UnexpectedNodesSyntax? = nil,
    baseType: some TypeSyntaxProtocol,
    _ unexpectedAfterBaseType: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeSpecifiers,
      specifiers,
      unexpectedBetweenSpecifiersAndAttributes,
      attributes,
      unexpectedBetweenAttributesAndLateSpecifiers,
      lateSpecifiers,
      unexpectedBetweenLateSpecifiersAndBaseType,
      baseType,
      unexpectedAfterBaseType
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeSpecifiers?.raw,
        specifiers.raw,
        unexpectedBetweenSpecifiersAndAttributes?.raw,
        attributes.raw,
        unexpectedBetweenAttributesAndLateSpecifiers?.raw,
        lateSpecifiers.raw,
        unexpectedBetweenLateSpecifiersAndBaseType?.raw,
        baseType.raw,
        unexpectedAfterBaseType?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.attributedType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  /// A list of specifiers that can be attached to the type, such as `inout`, `isolated`, or `consuming`.
  public var specifiers: TypeSpecifierListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSpecifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `specifiers`
  /// collection.
  ///
  /// - param element: The new `Specifier` to add to the node's
  ///                  `specifiers` collection.
  /// - returns: A copy of the receiver with the provided `Specifier`
  ///            appended to its `specifiers` collection.
  @available(*, deprecated, message: "Use node.specifiers.append(newElement) instead")
  public func addSpecifier(_ element: Syntax) -> AttributedTypeSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.typeSpecifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AttributedTypeSyntax.self)
  }

  public var unexpectedBetweenSpecifiersAndAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  /// A list of attributes that can be attached to the type, such as `@escaping`.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AttributedTypeSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AttributedTypeSyntax.self)
  }

  public var unexpectedBetweenAttributesAndLateSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  /// A list of specifiers that can be attached to the type after the attributes, such as 'nonisolated'.
  public var lateSpecifiers: TypeSpecifierListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TypeSpecifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  public var unexpectedBetweenLateSpecifiersAndBaseType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  /// The type to with the specifiers and attributes are applied.
  public var baseType: TypeSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  public var unexpectedAfterBaseType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeSpecifiers,
    \Self.specifiers,
    \Self.unexpectedBetweenSpecifiersAndAttributes,
    \Self.attributes,
    \Self.unexpectedBetweenAttributesAndLateSpecifiers,
    \Self.lateSpecifiers,
    \Self.unexpectedBetweenLateSpecifiersAndBaseType,
    \Self.baseType,
    \Self.unexpectedAfterBaseType
  ])
}

// MARK: - AvailabilityArgumentSyntax

/// A single argument to an `@available` argument like `*`, `iOS 10.1`, or `message: "This has been deprecated"`.
///
/// ### Children
/// 
///  - `argument`: ((`<binaryOperator>` | `<identifier>`) | ``PlatformVersionSyntax`` | ``AvailabilityLabeledArgumentSyntax``)
///  - `trailingComma`: `,`?
///
/// ### Contained in
/// 
///  - ``AvailabilityArgumentListSyntax``
public struct AvailabilityArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Argument: SyntaxChildChoices, SyntaxHashable {
    /// ### Tokens
    /// 
    /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
    ///  - `<binaryOperator>`
    ///  - `<identifier>`
    case token(TokenSyntax)
    case availabilityVersionRestriction(PlatformVersionSyntax)
    case availabilityLabeledArgument(AvailabilityLabeledArgumentSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .token(let node):
        return node._syntaxNode
      case .availabilityVersionRestriction(let node):
        return node._syntaxNode
      case .availabilityLabeledArgument(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: TokenSyntax) {
      self = .token(node)
    }

    public init(_ node: PlatformVersionSyntax) {
      self = .availabilityVersionRestriction(node)
    }

    public init(_ node: AvailabilityLabeledArgumentSyntax) {
      self = .availabilityLabeledArgument(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(TokenSyntax.self) {
        self = .token(node)
      } else if let node = node.as(PlatformVersionSyntax.self) {
        self = .availabilityVersionRestriction(node)
      } else if let node = node.as(AvailabilityLabeledArgumentSyntax.self) {
        self = .availabilityLabeledArgument(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TokenSyntax.self), .node(PlatformVersionSyntax.self), .node(AvailabilityLabeledArgumentSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``TokenSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: TokenSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``TokenSyntax``.
    ///
    /// - Returns: An instance of ``TokenSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: TokenSyntax.Type) -> TokenSyntax? {
      return TokenSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``TokenSyntax``.
    ///
    /// - Returns: An instance of ``TokenSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: TokenSyntax.Type) -> TokenSyntax {
      return self.as(TokenSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``PlatformVersionSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: PlatformVersionSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``PlatformVersionSyntax``.
    ///
    /// - Returns: An instance of ``PlatformVersionSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: PlatformVersionSyntax.Type) -> PlatformVersionSyntax? {
      return PlatformVersionSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``PlatformVersionSyntax``.
    ///
    /// - Returns: An instance of ``PlatformVersionSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: PlatformVersionSyntax.Type) -> PlatformVersionSyntax {
      return self.as(PlatformVersionSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``AvailabilityLabeledArgumentSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: AvailabilityLabeledArgumentSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``AvailabilityLabeledArgumentSyntax``.
    ///
    /// - Returns: An instance of ``AvailabilityLabeledArgumentSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: AvailabilityLabeledArgumentSyntax.Type) -> AvailabilityLabeledArgumentSyntax? {
      return AvailabilityLabeledArgumentSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``AvailabilityLabeledArgumentSyntax``.
    ///
    /// - Returns: An instance of ``AvailabilityLabeledArgumentSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: AvailabilityLabeledArgumentSyntax.Type) -> AvailabilityLabeledArgumentSyntax {
      return self.as(AvailabilityLabeledArgumentSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .availabilityArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - argument: The actual argument.
  ///   - trailingComma: A trailing comma if the argument is followed by another argument.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeArgument: UnexpectedNodesSyntax? = nil,
    argument: Argument,
    _ unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingComma: TokenSyntax? = nil,
    _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeArgument,
      argument,
      unexpectedBetweenArgumentAndTrailingComma,
      trailingComma,
      unexpectedAfterTrailingComma
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeArgument?.raw,
        argument.raw,
        unexpectedBetweenArgumentAndTrailingComma?.raw,
        trailingComma?.raw,
        unexpectedAfterTrailingComma?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeArgument: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }

  /// The actual argument.
  public var argument: Argument {
    get {
      return Syntax(self).child(at: 1)!.cast(Argument.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }

  /// A trailing comma if the argument is followed by another argument.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `,`.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }

  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeArgument,
    \Self.argument,
    \Self.unexpectedBetweenArgumentAndTrailingComma,
    \Self.trailingComma,
    \Self.unexpectedAfterTrailingComma
  ])
}

// MARK: - AvailabilityConditionSyntax

/// ### Children
/// 
///  - `availabilityKeyword`: (`#available` | `#unavailable`)
///  - `leftParen`: `(`
///  - `availabilityArguments`: ``AvailabilityArgumentListSyntax``
///  - `rightParen`: `)`
///
/// ### Contained in
/// 
///  - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
public struct AvailabilityConditionSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .availabilityCondition else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAvailabilityKeyword: UnexpectedNodesSyntax? = nil,
    availabilityKeyword: TokenSyntax,
    _ unexpectedBetweenAvailabilityKeywordAndLeftParen: UnexpectedNodesSyntax? = nil,
    leftParen: TokenSyntax = .leftParenToken(),
    _ unexpectedBetweenLeftParenAndAvailabilityArguments: UnexpectedNodesSyntax? = nil,
    availabilityArguments: AvailabilityArgumentListSyntax,
    _ unexpectedBetweenAvailabilityArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
    rightParen: TokenSyntax = .rightParenToken(),
    _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAvailabilityKeyword,
      availabilityKeyword,
      unexpectedBetweenAvailabilityKeywordAndLeftParen,
      leftParen,
      unexpectedBetweenLeftParenAndAvailabilityArguments,
      availabilityArguments,
      unexpectedBetweenAvailabilityArgumentsAndRightParen,
      rightParen,
      unexpectedAfterRightParen
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAvailabilityKeyword?.raw,
        availabilityKeyword.raw,
        unexpectedBetweenAvailabilityKeywordAndLeftParen?.raw,
        leftParen.raw,
        unexpectedBetweenLeftParenAndAvailabilityArguments?.raw,
        availabilityArguments.raw,
        unexpectedBetweenAvailabilityArgumentsAndRightParen?.raw,
        rightParen.raw,
        unexpectedAfterRightParen?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityCondition,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAvailabilityKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `#available`
  ///  - `#unavailable`
  public var availabilityKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  public var unexpectedBetweenAvailabilityKeywordAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `(`.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  public var unexpectedBetweenLeftParenAndAvailabilityArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  public var availabilityArguments: AvailabilityArgumentListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(AvailabilityArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `availabilityArguments`
  /// collection.
  ///
  /// - param element: The new `AvailabilityArgument` to add to the node's
  ///                  `availabilityArguments` collection.
  /// - returns: A copy of the receiver with the provided `AvailabilityArgument`
  ///            appended to its `availabilityArguments` collection.
  @available(*, deprecated, message: "Use node.availabilityArguments.append(newElement) instead")
  public func addAvailabilityArgument(_ element: AvailabilityArgumentSyntax) -> AvailabilityConditionSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.availabilityArgumentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(AvailabilityConditionSyntax.self)
  }

  public var unexpectedBetweenAvailabilityArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `)`.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAvailabilityKeyword,
    \Self.availabilityKeyword,
    \Self.unexpectedBetweenAvailabilityKeywordAndLeftParen,
    \Self.leftParen,
    \Self.unexpectedBetweenLeftParenAndAvailabilityArguments,
    \Self.availabilityArguments,
    \Self.unexpectedBetweenAvailabilityArgumentsAndRightParen,
    \Self.rightParen,
    \Self.unexpectedAfterRightParen
  ])
}

// MARK: - AvailabilityLabeledArgumentSyntax

/// An argument to an `@available` attribute that consists of a label and a value, e.g. `message: "This has been deprecated"`.
///
/// ### Children
/// 
///  - `label`: (`message` | `renamed` | `introduced` | `obsoleted` | `deprecated`)
///  - `colon`: `:`
///  - `value`: (``SimpleStringLiteralExprSyntax`` | ``VersionTupleSyntax``)
///
/// ### Contained in
/// 
///  - ``AvailabilityArgumentSyntax``.``AvailabilityArgumentSyntax/argument``
public struct AvailabilityLabeledArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Value: SyntaxChildChoices, SyntaxHashable {
    case string(SimpleStringLiteralExprSyntax)
    case version(VersionTupleSyntax)

    public var _syntaxNode: Syntax {
      switch self {
      case .string(let node):
        return node._syntaxNode
      case .version(let node):
        return node._syntaxNode
      }
    }

    public init(_ node: SimpleStringLiteralExprSyntax) {
      self = .string(node)
    }

    public init(_ node: VersionTupleSyntax) {
      self = .version(node)
    }

    public init?(_ node: __shared some SyntaxProtocol) {
      if let node = node.as(SimpleStringLiteralExprSyntax.self) {
        self = .string(node)
      } else if let node = node.as(VersionTupleSyntax.self) {
        self = .version(node)
      } else {
        return nil
      }
    }

    public static var structure: SyntaxNodeStructure {
      return .choices([.node(SimpleStringLiteralExprSyntax.self), .node(VersionTupleSyntax.self)])
    }

    /// Checks if the current syntax node can be cast to ``SimpleStringLiteralExprSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: SimpleStringLiteralExprSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``SimpleStringLiteralExprSyntax``.
    ///
    /// - Returns: An instance of ``SimpleStringLiteralExprSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: SimpleStringLiteralExprSyntax.Type) -> SimpleStringLiteralExprSyntax? {
      return SimpleStringLiteralExprSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``SimpleStringLiteralExprSyntax``.
    ///
    /// - Returns: An instance of ``SimpleStringLiteralExprSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: SimpleStringLiteralExprSyntax.Type) -> SimpleStringLiteralExprSyntax {
      return self.as(SimpleStringLiteralExprSyntax.self)!
    }

    /// Checks if the current syntax node can be cast to ``VersionTupleSyntax``.
    ///
    /// - Returns: `true` if the node can be cast, `false` otherwise.
    public func `is`(_ syntaxType: VersionTupleSyntax.Type) -> Bool {
      return self.as(syntaxType) != nil
    }

    /// Attempts to cast the current syntax node to ``VersionTupleSyntax``.
    ///
    /// - Returns: An instance of ``VersionTupleSyntax``, or `nil` if the cast fails.
    public func `as`(_ syntaxType: VersionTupleSyntax.Type) -> VersionTupleSyntax? {
      return VersionTupleSyntax.init(self)
    }

    /// Force-casts the current syntax node to ``VersionTupleSyntax``.
    ///
    /// - Returns: An instance of ``VersionTupleSyntax``.
    /// - Warning: This function will crash if the cast is not possible. Use `as` to safely attempt a cast.
    public func cast(_ syntaxType: VersionTupleSyntax.Type) -> VersionTupleSyntax {
      return self.as(VersionTupleSyntax.self)!
    }
  }

  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .availabilityLabeledArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - label: The label of the argument.
  ///   - colon: The colon separating label and value.
  ///   - value: The value of this labeled argument.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
    label: TokenSyntax,
    _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
    value: Value,
    _ unexpectedAfterValue: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeLabel,
      label,
      unexpectedBetweenLabelAndColon,
      colon,
      unexpectedBetweenColonAndValue,
      value,
      unexpectedAfterValue
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeLabel?.raw,
        label.raw,
        unexpectedBetweenLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndValue?.raw,
        value.raw,
        unexpectedAfterValue?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityLabeledArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  /// The label of the argument.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `message`
  ///  - `renamed`
  ///  - `introduced`
  ///  - `obsoleted`
  ///  - `deprecated`
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  /// The colon separating label and value.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  /// The value of this labeled argument.
  public var value: Value {
    get {
      return Syntax(self).child(at: 5)!.cast(Value.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  public var unexpectedAfterValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeLabel,
    \Self.label,
    \Self.unexpectedBetweenLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndValue,
    \Self.value,
    \Self.unexpectedAfterValue
  ])
}

// MARK: - AvailabilityMacroDefinitionFileSyntax

/// Syntax for '-define-availability' compiler arguments, never appear in Swift source code.
///
/// ### Children
/// 
///  - `platformVersion`: ``PlatformVersionSyntax``
///  - `colon`: `:`
///  - `specs`: ``AvailabilityArgumentListSyntax``
///  - `endOfFileToken`: ``
@_spi(Compiler)
public struct AvailabilityMacroDefinitionFileSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .availabilityMacroDefinitionFile else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforePlatformVersion: UnexpectedNodesSyntax? = nil,
    platformVersion: PlatformVersionSyntax,
    _ unexpectedBetweenPlatformVersionAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndSpecs: UnexpectedNodesSyntax? = nil,
    specs: AvailabilityArgumentListSyntax,
    _ unexpectedBetweenSpecsAndEndOfFileToken: UnexpectedNodesSyntax? = nil,
    endOfFileToken: TokenSyntax = .endOfFileToken(),
    _ unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforePlatformVersion,
      platformVersion,
      unexpectedBetweenPlatformVersionAndColon,
      colon,
      unexpectedBetweenColonAndSpecs,
      specs,
      unexpectedBetweenSpecsAndEndOfFileToken,
      endOfFileToken,
      unexpectedAfterEndOfFileToken
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforePlatformVersion?.raw,
        platformVersion.raw,
        unexpectedBetweenPlatformVersionAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndSpecs?.raw,
        specs.raw,
        unexpectedBetweenSpecsAndEndOfFileToken?.raw,
        endOfFileToken.raw,
        unexpectedAfterEndOfFileToken?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityMacroDefinitionFile,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforePlatformVersion: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public var platformVersion: PlatformVersionSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(PlatformVersionSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public var unexpectedBetweenPlatformVersionAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndSpecs: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public var specs: AvailabilityArgumentListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(AvailabilityArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public var unexpectedBetweenSpecsAndEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be ``.
  public var endOfFileToken: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public var unexpectedAfterEndOfFileToken: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AvailabilityMacroDefinitionFileSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforePlatformVersion,
    \Self.platformVersion,
    \Self.unexpectedBetweenPlatformVersionAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndSpecs,
    \Self.specs,
    \Self.unexpectedBetweenSpecsAndEndOfFileToken,
    \Self.endOfFileToken,
    \Self.unexpectedAfterEndOfFileToken
  ])
}

// MARK: - AwaitExprSyntax

/// ### Children
/// 
///  - `awaitKeyword`: `await`
///  - `expression`: ``ExprSyntax``
public struct AwaitExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .awaitExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeAwaitKeyword: UnexpectedNodesSyntax? = nil,
    awaitKeyword: TokenSyntax = .keyword(.await),
    _ unexpectedBetweenAwaitKeywordAndExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeAwaitKeyword,
      awaitKeyword,
      unexpectedBetweenAwaitKeywordAndExpression,
      expression,
      unexpectedAfterExpression
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeAwaitKeyword?.raw,
        awaitKeyword.raw,
        unexpectedBetweenAwaitKeywordAndExpression?.raw,
        expression.raw,
        unexpectedAfterExpression?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.awaitExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeAwaitKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `await`.
  public var awaitKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }

  public var unexpectedBetweenAwaitKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeAwaitKeyword,
    \Self.awaitKeyword,
    \Self.unexpectedBetweenAwaitKeywordAndExpression,
    \Self.expression,
    \Self.unexpectedAfterExpression
  ])
}

// MARK: - BackDeployedAttributeArgumentsSyntax

/// A collection of arguments for the `@backDeployed` attribute
///
/// ### Children
/// 
///  - `beforeLabel`: `before`
///  - `colon`: `:`
///  - `platforms`: ``PlatformVersionItemListSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct BackDeployedAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .backDeployedAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - beforeLabel: The "before" label.
  ///   - colon: The colon separating "before" and the parameter list.
  ///   - platforms: The list of OS versions in which the declaration became ABI stable.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBeforeLabel: UnexpectedNodesSyntax? = nil,
    beforeLabel: TokenSyntax = .keyword(.before),
    _ unexpectedBetweenBeforeLabelAndColon: UnexpectedNodesSyntax? = nil,
    colon: TokenSyntax = .colonToken(),
    _ unexpectedBetweenColonAndPlatforms: UnexpectedNodesSyntax? = nil,
    platforms: PlatformVersionItemListSyntax,
    _ unexpectedAfterPlatforms: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBeforeLabel,
      beforeLabel,
      unexpectedBetweenBeforeLabelAndColon,
      colon,
      unexpectedBetweenColonAndPlatforms,
      platforms,
      unexpectedAfterPlatforms
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBeforeLabel?.raw,
        beforeLabel.raw,
        unexpectedBetweenBeforeLabelAndColon?.raw,
        colon.raw,
        unexpectedBetweenColonAndPlatforms?.raw,
        platforms.raw,
        unexpectedAfterPlatforms?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.backDeployedAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  /// The "before" label.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `before`.
  public var beforeLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenBeforeLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  /// The colon separating "before" and the parameter list.
  ///
  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `:`.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  public var unexpectedBetweenColonAndPlatforms: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  /// The list of OS versions in which the declaration became ABI stable.
  public var platforms: PlatformVersionItemListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(PlatformVersionItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  /// Adds the provided `element` to the node's `platforms`
  /// collection.
  ///
  /// - param element: The new `Platform` to add to the node's
  ///                  `platforms` collection.
  /// - returns: A copy of the receiver with the provided `Platform`
  ///            appended to its `platforms` collection.
  @available(*, deprecated, message: "Use node.platforms.append(newElement) instead")
  public func addPlatform(_ element: PlatformVersionItemSyntax) -> BackDeployedAttributeArgumentsSyntax {
    var collection: RawSyntax
    let arena = RawSyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.platformVersionItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5,
        with: collection,
        rawNodeArena: arena,
        rawAllocationArena: arena
      )
      .cast(BackDeployedAttributeArgumentsSyntax.self)
  }

  public var unexpectedAfterPlatforms: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBeforeLabel,
    \Self.beforeLabel,
    \Self.unexpectedBetweenBeforeLabelAndColon,
    \Self.colon,
    \Self.unexpectedBetweenColonAndPlatforms,
    \Self.platforms,
    \Self.unexpectedAfterPlatforms
  ])
}

// MARK: - BinaryOperatorExprSyntax

/// An operator like `+` or `-`.
/// 
/// This node represents the binary operator itself. It can occur inside a ``SequenceExprSyntax`` 
/// after parsing and will be the `operator` child of an ``InfixOperatorExprSyntax`` 
/// after folding operator using the `SwiftOperators` library.
///
/// ### Children
/// 
///  - `operator`: `<binaryOperator>`
public struct BinaryOperatorExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .binaryOperatorExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeOperator: UnexpectedNodesSyntax? = nil,
    operator: TokenSyntax,
    _ unexpectedAfterOperator: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeOperator, `operator`, unexpectedAfterOperator))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeOperator?.raw, `operator`.raw, unexpectedAfterOperator?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.binaryOperatorExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BinaryOperatorExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<binaryOperator>`.
  public var `operator`: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BinaryOperatorExprSyntax.self)
    }
  }

  public var unexpectedAfterOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BinaryOperatorExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeOperator, \Self.operator, \Self.unexpectedAfterOperator])
}

// MARK: - BooleanLiteralExprSyntax

/// ### Children
/// 
///  - `literal`: (`true` | `false`)
public struct BooleanLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .booleanLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeLiteral: UnexpectedNodesSyntax? = nil,
    literal: TokenSyntax,
    _ unexpectedAfterLiteral: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (unexpectedBeforeLiteral, literal, unexpectedAfterLiteral))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeLiteral?.raw, literal.raw, unexpectedAfterLiteral?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.booleanLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BooleanLiteralExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `true`
  ///  - `false`
  public var literal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BooleanLiteralExprSyntax.self)
    }
  }

  public var unexpectedAfterLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BooleanLiteralExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([\Self.unexpectedBeforeLiteral, \Self.literal, \Self.unexpectedAfterLiteral])
}

// MARK: - BorrowExprSyntax

/// ### Children
/// 
///  - `borrowKeyword`: (`_borrow` | `borrow`)
///  - `expression`: ``ExprSyntax``
public struct BorrowExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .borrowExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBorrowKeyword: UnexpectedNodesSyntax? = nil,
    borrowKeyword: TokenSyntax,
    _ unexpectedBetweenBorrowKeywordAndExpression: UnexpectedNodesSyntax? = nil,
    expression: some ExprSyntaxProtocol,
    _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBorrowKeyword,
      borrowKeyword,
      unexpectedBetweenBorrowKeywordAndExpression,
      expression,
      unexpectedAfterExpression
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBorrowKeyword?.raw,
        borrowKeyword.raw,
        unexpectedBetweenBorrowKeywordAndExpression?.raw,
        expression.raw,
        unexpectedAfterExpression?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.borrowExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBorrowKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be one of the following kinds:
  ///  - `_borrow`
  ///  - `borrow`
  public var borrowKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }

  public var unexpectedBetweenBorrowKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }

  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }

  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBorrowKeyword,
    \Self.borrowKeyword,
    \Self.unexpectedBetweenBorrowKeywordAndExpression,
    \Self.expression,
    \Self.unexpectedAfterExpression
  ])
}

// MARK: - BreakStmtSyntax

/// ### Children
/// 
///  - `breakKeyword`: `break`
///  - `label`: `<identifier>`?
public struct BreakStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax

  public init?(_ node: __shared some SyntaxProtocol) {
    guard node.raw.kind == .breakStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }

  @_transparent
  init(unsafeCasting node: Syntax) {
    self._syntaxNode = node
  }

  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
    leadingTrivia: Trivia? = nil,
    _ unexpectedBeforeBreakKeyword: UnexpectedNodesSyntax? = nil,
    breakKeyword: TokenSyntax = .keyword(.break),
    _ unexpectedBetweenBreakKeywordAndLabel: UnexpectedNodesSyntax? = nil,
    label: TokenSyntax? = nil,
    _ unexpectedAfterLabel: UnexpectedNodesSyntax? = nil,
    trailingTrivia: Trivia? = nil
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((RawSyntaxArena(), (
      unexpectedBeforeBreakKeyword,
      breakKeyword,
      unexpectedBetweenBreakKeywordAndLabel,
      label,
      unexpectedAfterLabel
    ))) { (arena, _) in
      let layout: [RawSyntax?] = [
        unexpectedBeforeBreakKeyword?.raw,
        breakKeyword.raw,
        unexpectedBetweenBreakKeywordAndLabel?.raw,
        label?.raw,
        unexpectedAfterLabel?.raw
      ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.breakStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }

  public var unexpectedBeforeBreakKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `break`.
  public var breakKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }

  public var unexpectedBetweenBreakKeywordAndLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }

  /// ### Tokens
  /// 
  /// For syntax trees generated by the parser, this is guaranteed to be `<identifier>`.
  public var label: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }

  public var unexpectedAfterLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), rawAllocationArena: RawSyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }

  public static let structure: SyntaxNodeStructure = .layout([
    \Self.unexpectedBeforeBreakKeyword,
    \Self.breakKeyword,
    \Self.unexpectedBetweenBreakKeywordAndLabel,
    \Self.label,
    \Self.unexpectedAfterLabel
  ])
}
