//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
// Automatically generated by generate-swift-syntax
// Do not edit directly!
// swift-format-ignore-file

/// Check that the `layout` is valid for the given 'SyntaxKind'.
///
/// Note that this only validates the immediate children.
/// Results in an assertion failure if the layout is invalid.
func validateLayout(layout: RawSyntaxBuffer, as kind: SyntaxKind) {
  #if SWIFTSYNTAX_ENABLE_RAWSYNTAX_VALIDATION
  enum TokenChoice: CustomStringConvertible {
    case keyword(StaticString)
    case tokenKind(RawTokenKind)


    var description: String {
      switch self {
      case .keyword(let keyword):
        return "keyword('\(keyword)')"
      case .tokenKind(let kind):
        return "\(kind)"
      }
    }
  }
  enum ValidationError: CustomStringConvertible {
    case expectedNonNil(expectedKind: RawSyntaxNodeProtocol.Type, file: StaticString, line: UInt)
    case kindMismatch(expectedKind: RawSyntaxNodeProtocol.Type, actualKind: SyntaxKind, file: StaticString, line: UInt)
    case tokenMismatch(expectedTokenChoices: [TokenChoice], actualKind: RawTokenKind, actualText: SyntaxText, file: StaticString, line: UInt)


    var description: String {
      switch self {
      case .expectedNonNil(expectedKind: let expectedKind, file: _, line: _):
        return "Expected non-nil node of type \(expectedKind) but received nil"
      case .kindMismatch(
        expectedKind: let expectedKind,
        actualKind: let actualKind,
        file: _,
        line: _
      ):
        return "Expected node of type \(expectedKind) but received \(actualKind)"
      case .tokenMismatch(
        expectedTokenChoices: let tokenChoices,
        actualKind: let actualKind,
        actualText: let actualText,
        file: _,
        line: _
      ):
        return "Expected token with one of \(tokenChoices) but received \(actualKind) with text '\(actualText)'"
      }
    }


    var fileAndLine: (StaticString, UInt) {
      switch self {
      case .expectedNonNil(expectedKind: _, file: let file, line: let line):
        return (file, line)
      case .kindMismatch(
        expectedKind: _,
        actualKind: _,
        file: let file,
        line: let line
      ):
        return (file, line)
      case .tokenMismatch(
        expectedTokenChoices: _,
        actualKind: _,
        actualText: _,
        file: let file,
        line: let line
      ):
        return (file, line)
      }
    }
  }
  func verify<Node: RawSyntaxNodeProtocol>(
    _ raw: RawSyntax?,
    as _: Node.Type,
    file: StaticString = #fileID,
    line: UInt = #line
  ) -> ValidationError? {
    guard let raw = raw else {
      return .expectedNonNil(expectedKind: Node.self, file: file, line: line)
    }
    guard Node.isKindOf(raw) else {
      return .kindMismatch(
        expectedKind: Node.self,
        actualKind: raw.kind,
        file: file,
        line: line
      )
    }
    return nil
  }
  func verify<Node: RawSyntaxNodeProtocol>(
    _ raw: RawSyntax?,
    as _: Node?.Type,
    file: StaticString = #fileID,
    line: UInt = #line
  ) -> ValidationError? {
    if raw != nil {
      return verify(
        raw,
        as: Node.self,
        file: file,
        line: line
      )
    }
    return nil
  }
  func verify(
    _ raw: RawSyntax?,
    as _: RawTokenSyntax?.Type,
    tokenChoices: [TokenChoice],
    file: StaticString = #fileID,
    line: UInt = #line
  ) -> ValidationError? {
    // Validation of token choice is currently causing assertion failures where
    // the list of expected token choices in the syntax tree doesn't match those
    // the parser generates. Disable the verification for now until all issues
    // regarding it are fixed.
    if raw != nil {
      return verify(
        raw,
        as: RawTokenSyntax.self,
        tokenChoices: tokenChoices,
        file: file,
        line: line
      )
    }
    return nil
  }
  func verify(
    _ raw: RawSyntax?,
    as _: RawTokenSyntax.Type,
    tokenChoices: [TokenChoice],
    file: StaticString = #fileID,
    line: UInt = #line
  ) -> ValidationError? {
    // Validation of token choice is currently causing assertion failures where
    // the list of expected token choices in the syntax tree doesn't match those
    // the parser generates. Disable the verification for now until all issues
    // regarding it are fixed.
    guard let raw = raw else {
      return .expectedNonNil(expectedKind: RawTokenSyntax.self, file: file, line: line)
    }
    if let error = verify(raw, as: RawTokenSyntax?.self) {
      return error
    }
    let tokenView = raw.tokenView!
    for tokenChoice in tokenChoices {
      switch tokenChoice {
      case .tokenKind(let tokenKind):
        if raw.tokenView?.rawKind == tokenKind {
          return nil
        }
      case .keyword(let keyword):
        if tokenView.rawKind == .keyword && tokenView.rawText == SyntaxText(keyword) {
          return nil
        }
      }
    }
    return ValidationError.tokenMismatch(
      expectedTokenChoices: tokenChoices,
      actualKind: tokenView.rawKind,
      actualText: tokenView.rawText,
      file: file,
      line: line
    )
  }
  func assertNoError(_ nodeKind: SyntaxKind, _ index: Int, _ error: ValidationError?) {
    if let error {
      let (file, line) = error.fileAndLine
      assertionFailure("""
        Error validating child at index \(index) of \(nodeKind):
        \(error.description)

        See "RawSyntax Validation" in CONTRIBUTING.md to reproduce the failure locally.
        """, file: file, line: line)
    }
  }
  func assertAnyHasNoError(_ nodeKind: SyntaxKind, _ index: Int, _ errors: [ValidationError?]) {
    let nonNilErrors = errors.compactMap({
      $0
    })
    if nonNilErrors.count == errors.count, let firstError = nonNilErrors.first {
      let (file, line) = firstError.fileAndLine
      assertionFailure("""
        Error validating child at index \(index) of \(nodeKind):
        Node did not satisfy any node choice requirement.
        Validation failures:
        \(nonNilErrors.map({ "- \($0.description)" }).joined(separator: "\n"))

        See "RawSyntax Validation" in CONTRIBUTING.md to reproduce the failure locally.
        """, file: file, line: line)
      _ = 1
    }
  }
  func validateABIAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAccessorBlockFileSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawAccessorDeclListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAccessorBlockSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
      verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAccessorDeclListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawAccessorDeclSyntax.self))
    }
  }
  func validateAccessorDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("get"),
      .keyword("set"),
      .keyword("didSet"),
      .keyword("willSet"),
      .keyword("unsafeAddress"),
      .keyword("addressWithOwner"),
      .keyword("addressWithNativeOwner"),
      .keyword("unsafeMutableAddress"),
      .keyword("mutableAddressWithOwner"),
      .keyword("mutableAddressWithNativeOwner"),
      .keyword("_read"),
      .keyword("read"),
      .keyword("_modify"),
      .keyword("modify"),
      .keyword("init")
    ]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawAccessorParametersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawAccessorEffectSpecifiersSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAccessorEffectSpecifiersSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawThrowsClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAccessorParametersSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateActorDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("actor")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateArrayElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawArrayElementSyntax.self))
    }
  }
  func validateArrayElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateArrayExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawArrayElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateArrayTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateArrowExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeEffectSpecifiersSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.arrow)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAsExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("as")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAssignmentExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAssociatedTypeDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("associatedtype")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeInitializerClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAttributeClauseFileSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAttributeListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
        verify(element, as: RawAttributeSyntax.self),
        verify(element, as: RawIfConfigDeclSyntax.self)])
    }
  }
  func validateAttributeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.atSign)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 7, [
      verify(layout[7], as: RawSyntax?.self)])
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAttributedTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSpecifierListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawAttributeListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSpecifierListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAvailabilityArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawAvailabilityArgumentSyntax.self))
    }
  }
  func validateAvailabilityArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAvailabilityConditionSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundAvailable), .tokenKind(.poundUnavailable)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawAvailabilityArgumentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAvailabilityLabeledArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("message"),
      .keyword("renamed"),
      .keyword("introduced"),
      .keyword("obsoleted"),
      .keyword("deprecated")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
      verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAvailabilityMacroDefinitionFileSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPlatformVersionSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawAvailabilityArgumentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateAwaitExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("await")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateBackDeployedAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("before")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPlatformVersionItemListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateBinaryOperatorExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.binaryOperator)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateBooleanLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("true"), .keyword("false")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateBorrowExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("_borrow"), .keyword("borrow")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateBreakStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("break")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validate_CanImportExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("canImport")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: Raw_CanImportVersionInfoSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validate_CanImportVersionInfoSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("_version"), .keyword("_underlyingVersion")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawVersionTupleSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCatchClauseListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCatchClauseSyntax.self))
    }
  }
  func validateCatchClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("catch")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCatchItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCatchItemListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCatchItemSyntax.self))
    }
  }
  func validateCatchItemSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawWhereClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClassDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("class")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClassRestrictionTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("class")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureCaptureClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureCaptureListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureCaptureListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawClosureCaptureSyntax.self))
    }
  }
  func validateClosureCaptureSpecifierSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("weak"), .keyword("unowned")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.keyword("safe"), .keyword("unsafe")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureCaptureSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawClosureCaptureSpecifierSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .keyword("self")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureSignatureSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureParameterClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureParameterListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawClosureParameterSyntax.self))
    }
  }
  func validateClosureParameterSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.ellipsis)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureShorthandParameterListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawClosureShorthandParameterSyntax.self))
    }
  }
  func validateClosureShorthandParameterSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateClosureSignatureSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureCaptureClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
      verify(layout[5], as: RawSyntax?.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeEffectSpecifiersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawReturnClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax.self, tokenChoices: [.keyword("in")]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCodeBlockFileSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCodeBlockItemListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCodeBlockItemSyntax.self))
    }
  }
  func validateCodeBlockItemSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.semicolon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCodeBlockSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCompositionTypeElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCompositionTypeElementSyntax.self))
    }
  }
  func validateCompositionTypeElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCompositionTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawCompositionTypeElementListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateConditionElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawConditionElementSyntax.self))
    }
  }
  func validateConditionElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateConformanceRequirementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateConsumeExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("_move"), .keyword("consume")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateContinueStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("continue")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateCopyExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("copy")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeclModifierDetailSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeclModifierListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDeclModifierSyntax.self))
    }
  }
  func validateDeclModifierSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("__consuming"),
      .keyword("__setter_access"),
      .keyword("_const"),
      .keyword("_local"),
      .keyword("actor"),
      .keyword("async"),
      .keyword("borrowing"),
      .keyword("class"),
      .keyword("consuming"),
      .keyword("convenience"),
      .keyword("distributed"),
      .keyword("dynamic"),
      .keyword("fileprivate"),
      .keyword("final"),
      .keyword("indirect"),
      .keyword("infix"),
      .keyword("internal"),
      .keyword("isolated"),
      .keyword("lazy"),
      .keyword("mutating"),
      .keyword("nonisolated"),
      .keyword("nonmutating"),
      .keyword("open"),
      .keyword("optional"),
      .keyword("override"),
      .keyword("package"),
      .keyword("postfix"),
      .keyword("prefix"),
      .keyword("private"),
      .keyword("public"),
      .keyword("reasync"),
      .keyword("required"),
      .keyword("static"),
      .keyword("unowned"),
      .keyword("weak"),
      .keyword("sending")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierDetailSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeclNameArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDeclNameArgumentSyntax.self))
    }
  }
  func validateDeclNameArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeclNameArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclNameArgumentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeclReferenceExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .tokenKind(.identifier),
      .keyword("self"),
      .keyword("Self"),
      .keyword("init"),
      .keyword("deinit"),
      .keyword("subscript"),
      .tokenKind(.dollarIdentifier),
      .tokenKind(.binaryOperator),
      .tokenKind(.integerLiteral)
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclNameArgumentsSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeferStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("defer")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeinitializerDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("deinit")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawDeinitializerEffectSpecifiersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDeinitializerEffectSpecifiersSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDerivativeAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("of")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.keyword("get"), .keyword("set"), .keyword("_modify")]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawDifferentiabilityWithRespectToArgumentSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDesignatedTypeListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDesignatedTypeSyntax.self))
    }
  }
  func validateDesignatedTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDictionaryElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDictionaryElementSyntax.self))
    }
  }
  func validateDictionaryElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDictionaryExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
      verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDictionaryTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDifferentiabilityArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDifferentiabilityArgumentSyntax.self))
    }
  }
  func validateDifferentiabilityArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.integerLiteral), .keyword("self")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDifferentiabilityArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDifferentiabilityArgumentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDifferentiabilityWithRespectToArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("wrt")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
      verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDifferentiableAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("_forward"), .keyword("reverse"), .keyword("_linear")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDifferentiabilityWithRespectToArgumentSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDiscardAssignmentExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDiscardStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("discard")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDoExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("do")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCatchClauseListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDoStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("do")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawThrowsClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawCatchClauseListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDocumentationAttributeArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDocumentationAttributeArgumentSyntax.self))
    }
  }
  func validateDocumentationAttributeArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("visibility"), .keyword("metadata")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
      verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateDynamicReplacementAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("for")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEditorPlaceholderDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEditorPlaceholderExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEffectsAttributeArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawTokenSyntax.self))
    }
  }
  func validateEnumCaseDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawEnumCaseElementListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEnumCaseElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawEnumCaseElementSyntax.self))
    }
  }
  func validateEnumCaseElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawEnumCaseParameterClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEnumCaseParameterClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawEnumCaseParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEnumCaseParameterListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawEnumCaseParameterSyntax.self))
    }
  }
  func validateEnumCaseParameterSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTypeSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateEnumDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("enum")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateExprListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawExprSyntax.self))
    }
  }
  func validateExpressionPatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateExpressionSegmentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.backslash)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rawStringPoundDelimiter)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateExpressionStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateExtensionDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("extension")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFallThroughStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("fallthrough")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFloatLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.floatLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateForStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 23)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("for")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("try")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.keyword("await")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.keyword("unsafe")]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawPatternSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax.self, tokenChoices: [.keyword("in")]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 17, verify(layout[17], as: RawExprSyntax.self))
    assertNoError(kind, 18, verify(layout[18], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 19, verify(layout[19], as: RawWhereClauseSyntax?.self))
    assertNoError(kind, 20, verify(layout[20], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 21, verify(layout[21], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 22, verify(layout[22], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateForceUnwrapExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionCallExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("func")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [
      .tokenKind(.identifier),
      .tokenKind(.binaryOperator),
      .tokenKind(.prefixOperator),
      .tokenKind(.postfixOperator)
    ]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawFunctionSignatureSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionEffectSpecifiersSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async"), .keyword("reasync")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawThrowsClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionParameterClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawFunctionParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionParameterListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawFunctionParameterSyntax.self))
    }
  }
  func validateFunctionParameterSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 19)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.ellipsis)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 17, verify(layout[17], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 18, verify(layout[18], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionSignatureSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawFunctionParameterClauseSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawFunctionEffectSpecifiersSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawReturnClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateFunctionTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTupleTypeElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeEffectSpecifiersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawReturnClauseSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericArgumentClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftAngle)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightAngle)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawGenericArgumentSyntax.self))
    }
  }
  func validateGenericArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericParameterClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftAngle)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightAngle)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericParameterListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawGenericParameterSyntax.self))
    }
  }
  func validateGenericParameterSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("each"), .keyword("let")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTypeSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericRequirementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawGenericRequirementSyntax.self))
    }
  }
  func validateGenericRequirementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericSpecializationExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentClauseSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGenericWhereClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("where")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericRequirementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateGuardStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("guard")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawConditionElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("else")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIdentifierPatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .tokenKind(.identifier),
      .keyword("self"),
      .keyword("init"),
      .keyword("deinit"),
      .keyword("subscript")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIdentifierTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .tokenKind(.identifier),
      .keyword("Self"),
      .keyword("Any"),
      .tokenKind(.wildcard)
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIfConfigClauseListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawIfConfigClauseSyntax.self))
    }
  }
  func validateIfConfigClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundIf), .tokenKind(.poundElseif), .tokenKind(.poundElse)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
      verify(layout[5], as: RawSyntax?.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIfConfigDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawIfConfigClauseListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundEndif)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIfExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("if")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawConditionElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.keyword("else")]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 9, [
      verify(layout[9], as: RawSyntax?.self)])
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateImplementsAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateImplicitlyUnwrappedOptionalTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateImportDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("import")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [
      .keyword("typealias"),
      .keyword("struct"),
      .keyword("class"),
      .keyword("enum"),
      .keyword("protocol"),
      .keyword("var"),
      .keyword("let"),
      .keyword("func"),
      .keyword("inout")
    ]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawImportPathComponentListSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateImportPathComponentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawImportPathComponentSyntax.self))
    }
  }
  func validateImportPathComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .tokenKind(.identifier),
      .tokenKind(.binaryOperator),
      .tokenKind(.prefixOperator),
      .tokenKind(.postfixOperator)
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInOutExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.prefixAmpersand)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInfixOperatorExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInheritanceClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawInheritedTypeListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInheritedTypeListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawInheritedTypeSyntax.self))
    }
  }
  func validateInheritedTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInitializerClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInitializerDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("init")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawFunctionSignatureSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateInlineArrayTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("of")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawGenericArgumentSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIntegerLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIsExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("is")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateIsTypePatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("is")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateKeyPathComponentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawKeyPathComponentSyntax.self))
    }
  }
  func validateKeyPathComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
      verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateKeyPathExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.backslash)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawKeyPathComponentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateKeyPathMethodComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateKeyPathOptionalComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateKeyPathPropertyComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateKeyPathSubscriptComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateLabeledExprListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawLabeledExprSyntax.self))
    }
  }
  func validateLabeledExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateLabeledSpecializeArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("target"),
      .keyword("availability"),
      .keyword("exported"),
      .keyword("kind"),
      .keyword("spi"),
      .keyword("spiModule")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateLabeledStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStmtSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateLayoutRequirementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("_Trivial"),
      .keyword("_TrivialAtMost"),
      .keyword("_UnknownLayout"),
      .keyword("_RefCountedObject"),
      .keyword("_NativeRefCountedObject"),
      .keyword("_Class"),
      .keyword("_NativeClass"),
      .keyword("_BridgeObject"),
      .keyword("_TrivialStride")
    ]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateLifetimeSpecifierArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawLifetimeSpecifierArgumentSyntax.self))
    }
  }
  func validateLifetimeSpecifierArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .keyword("self"), .tokenKind(.integerLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateLifetimeTypeSpecifierSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("dependsOn")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.keyword("scoped")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawLifetimeSpecifierArgumentListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMacroDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("macro")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawFunctionSignatureSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMacroExpansionDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 21)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.pound)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 17, verify(layout[17], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 18, verify(layout[18], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 19, verify(layout[19], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 20, verify(layout[20], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMacroExpansionExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.pound)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMatchingPatternConditionSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPatternSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawInitializerClauseSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMemberAccessExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMemberBlockItemListFileSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawMemberBlockItemListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMemberBlockItemListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawMemberBlockItemSyntax.self))
    }
  }
  func validateMemberBlockItemSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.semicolon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMemberBlockSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawMemberBlockItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMemberTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .keyword("self")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMetatypeTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("Type"), .keyword("Protocol")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMissingDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMissingExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMissingPatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMissingStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMissingSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMissingTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateMultipleTrailingClosureElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawMultipleTrailingClosureElementSyntax.self))
    }
  }
  func validateMultipleTrailingClosureElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawClosureExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateNamedOpaqueReturnTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawGenericParameterClauseSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateNilLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("nil")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateNonisolatedSpecifierArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("nonsending")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateNonisolatedTypeSpecifierSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("nonisolated")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawNonisolatedSpecifierArgumentSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateObjCSelectorPieceListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawObjCSelectorPieceSyntax.self))
    }
  }
  func validateObjCSelectorPieceSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateOperatorDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("prefix"), .keyword("postfix"), .keyword("infix")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("operator")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.binaryOperator), .tokenKind(.prefixOperator), .tokenKind(.postfixOperator)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawOperatorPrecedenceAndTypesSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateOperatorPrecedenceAndTypesSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDesignatedTypeListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateOptionalBindingConditionSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("let"),
      .keyword("var"),
      .keyword("inout"),
      .keyword("_mutating"),
      .keyword("_borrowing"),
      .keyword("_consuming")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPatternSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateOptionalChainingExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixQuestionMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateOptionalTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixQuestionMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateOriginallyDefinedInAttributeArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("module")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawPlatformVersionItemListSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePackElementExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("each")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePackElementTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("each")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePackExpansionExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("repeat")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePackExpansionTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("repeat")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePatternBindingListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPatternBindingSyntax.self))
    }
  }
  func validatePatternBindingSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawAccessorBlockSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePatternExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePlatformVersionItemListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPlatformVersionItemSyntax.self))
    }
  }
  func validatePlatformVersionItemSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPlatformVersionSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePlatformVersionSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawVersionTupleSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePostfixIfConfigExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawIfConfigDeclSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePostfixOperatorExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixOperator)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePoundSourceLocationArgumentsSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("file")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawSimpleStringLiteralExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.keyword("line")]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePoundSourceLocationSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundSourceLocation)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPoundSourceLocationArgumentsSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrecedenceGroupAssignmentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("assignment")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("true"), .keyword("false")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrecedenceGroupAssociativitySyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("associativity")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("left"), .keyword("right"), .keyword("none")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrecedenceGroupAttributeListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
        verify(element, as: RawPrecedenceGroupRelationSyntax.self),
        verify(element, as: RawPrecedenceGroupAssignmentSyntax.self),
        verify(element, as: RawPrecedenceGroupAssociativitySyntax.self)])
    }
  }
  func validatePrecedenceGroupDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("precedencegroup")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawPrecedenceGroupAttributeListSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrecedenceGroupNameListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPrecedenceGroupNameSyntax.self))
    }
  }
  func validatePrecedenceGroupNameSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrecedenceGroupRelationSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("higherThan"), .keyword("lowerThan")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPrecedenceGroupNameListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrefixOperatorExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.prefixOperator)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrimaryAssociatedTypeClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftAngle)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPrimaryAssociatedTypeListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightAngle)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validatePrimaryAssociatedTypeListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPrimaryAssociatedTypeSyntax.self))
    }
  }
  func validatePrimaryAssociatedTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateProtocolDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("protocol")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawPrimaryAssociatedTypeClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateRegexLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.regexPoundDelimiter)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.regexSlash)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.regexLiteralPattern)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.regexSlash)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.regexPoundDelimiter)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateRepeatStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("repeat")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("while")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawExprSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateReturnClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.arrow)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateReturnStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("return")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSameTypeRequirementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
      verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.binaryOperator), .tokenKind(.prefixOperator), .tokenKind(.postfixOperator)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
      verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSequenceExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSimpleStringLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawSimpleStringLiteralSegmentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSimpleStringLiteralSegmentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawStringSegmentSyntax.self))
    }
  }
  func validateSimpleTypeSpecifierSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("inout"),
      .keyword("__shared"),
      .keyword("__owned"),
      .keyword("isolated"),
      .keyword("_const"),
      .keyword("borrowing"),
      .keyword("consuming"),
      .keyword("sending")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSomeOrAnyTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("some"), .keyword("any")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSourceFileSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.shebang)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSpecializeAttributeArgumentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
        verify(element, as: RawLabeledSpecializeArgumentSyntax.self),
        verify(element, as: RawSpecializeAvailabilityArgumentSyntax.self),
        verify(element, as: RawSpecializeTargetFunctionArgumentSyntax.self),
        verify(element, as: RawGenericWhereClauseSyntax.self)
      ])
    }
  }
  func validateSpecializeAvailabilityArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("availability")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawAvailabilityArgumentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.semicolon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSpecializeTargetFunctionArgumentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("target")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateStringLiteralExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rawStringPoundDelimiter)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote), .tokenKind(.singleQuote)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralSegmentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote), .tokenKind(.singleQuote)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rawStringPoundDelimiter)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateStringLiteralSegmentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
        verify(element, as: RawStringSegmentSyntax.self),
        verify(element, as: RawExpressionSegmentSyntax.self)])
    }
  }
  func validateStringSegmentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringSegment)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateStructDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("struct")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSubscriptCallExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSubscriptDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("subscript")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawFunctionParameterClauseSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawReturnClauseSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawAccessorBlockSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSuperExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("super")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSuppressedTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.prefixOperator)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSwitchCaseItemListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawSwitchCaseItemSyntax.self))
    }
  }
  func validateSwitchCaseItemSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawWhereClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSwitchCaseLabelSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawSwitchCaseItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSwitchCaseListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
        verify(element, as: RawSwitchCaseSyntax.self),
        verify(element, as: RawIfConfigDeclSyntax.self)])
    }
  }
  func validateSwitchCaseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
      verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSwitchDefaultLabelSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("default")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateSwitchExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("switch")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawSwitchCaseListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTernaryExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.infixQuestionMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawExprSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateThenStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("then")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateThrowStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("throw")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateThrowsClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("throws"), .keyword("rethrows")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTryExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("try")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTupleExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTuplePatternElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawTuplePatternElementSyntax.self))
    }
  }
  func validateTuplePatternElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPatternSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTuplePatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTuplePatternElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTupleTypeElementListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawTupleTypeElementSyntax.self))
    }
  }
  func validateTupleTypeElementSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("inout")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTypeSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.ellipsis)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTupleTypeSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTupleTypeElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTypeAliasDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("typealias")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeInitializerClauseSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTypeAnnotationSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTypeEffectSpecifiersSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawThrowsClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTypeExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTypeInitializerClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateTypeSpecifierListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
        verify(element, as: RawSimpleTypeSpecifierSyntax.self),
        verify(element, as: RawLifetimeTypeSpecifierSyntax.self),
        verify(element, as: RawNonisolatedTypeSpecifierSyntax.self)])
    }
  }
  func validateUnexpectedNodesSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawSyntax.self))
    }
  }
  func validateUnresolvedAsExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("as")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateUnresolvedIsExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("is")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateUnresolvedTernaryExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.infixQuestionMark)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateUnsafeExprSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("unsafe")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateUsingDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("using")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
      verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateValueBindingPatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("let"),
      .keyword("var"),
      .keyword("inout"),
      .keyword("_mutating"),
      .keyword("_borrowing"),
      .keyword("_consuming"),
      .keyword("borrowing")
    ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPatternSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateVariableDeclSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [
      .keyword("let"),
      .keyword("var"),
      .keyword("inout"),
      .keyword("_mutating"),
      .keyword("_borrowing"),
      .keyword("_consuming")
    ]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawPatternBindingListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateVersionComponentListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawVersionComponentSyntax.self))
    }
  }
  func validateVersionComponentSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateVersionTupleSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawVersionComponentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateWhereClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("where")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateWhileStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("while")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawConditionElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateWildcardPatternSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateYieldStmtSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("yield")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
      verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateYieldedExpressionListSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawYieldedExpressionSyntax.self))
    }
  }
  func validateYieldedExpressionSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  }
  func validateYieldedExpressionsClauseSyntax(kind: SyntaxKind, layout: RawSyntaxBuffer) {
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawYieldedExpressionListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  switch kind {
  case .token:
    assertionFailure("validateLayout for .token kind is not supported")
  case .abiAttributeArguments:
    validateABIAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .accessorBlockFile:
    validateAccessorBlockFileSyntax(kind: kind, layout: layout)
  case .accessorBlock:
    validateAccessorBlockSyntax(kind: kind, layout: layout)
  case .accessorDeclList:
    validateAccessorDeclListSyntax(kind: kind, layout: layout)
  case .accessorDecl:
    validateAccessorDeclSyntax(kind: kind, layout: layout)
  case .accessorEffectSpecifiers:
    validateAccessorEffectSpecifiersSyntax(kind: kind, layout: layout)
  case .accessorParameters:
    validateAccessorParametersSyntax(kind: kind, layout: layout)
  case .actorDecl:
    validateActorDeclSyntax(kind: kind, layout: layout)
  case .arrayElementList:
    validateArrayElementListSyntax(kind: kind, layout: layout)
  case .arrayElement:
    validateArrayElementSyntax(kind: kind, layout: layout)
  case .arrayExpr:
    validateArrayExprSyntax(kind: kind, layout: layout)
  case .arrayType:
    validateArrayTypeSyntax(kind: kind, layout: layout)
  case .arrowExpr:
    validateArrowExprSyntax(kind: kind, layout: layout)
  case .asExpr:
    validateAsExprSyntax(kind: kind, layout: layout)
  case .assignmentExpr:
    validateAssignmentExprSyntax(kind: kind, layout: layout)
  case .associatedTypeDecl:
    validateAssociatedTypeDeclSyntax(kind: kind, layout: layout)
  case .attributeClauseFile:
    validateAttributeClauseFileSyntax(kind: kind, layout: layout)
  case .attributeList:
    validateAttributeListSyntax(kind: kind, layout: layout)
  case .attribute:
    validateAttributeSyntax(kind: kind, layout: layout)
  case .attributedType:
    validateAttributedTypeSyntax(kind: kind, layout: layout)
  case .availabilityArgumentList:
    validateAvailabilityArgumentListSyntax(kind: kind, layout: layout)
  case .availabilityArgument:
    validateAvailabilityArgumentSyntax(kind: kind, layout: layout)
  case .availabilityCondition:
    validateAvailabilityConditionSyntax(kind: kind, layout: layout)
  case .availabilityLabeledArgument:
    validateAvailabilityLabeledArgumentSyntax(kind: kind, layout: layout)
  case .availabilityMacroDefinitionFile:
    validateAvailabilityMacroDefinitionFileSyntax(kind: kind, layout: layout)
  case .awaitExpr:
    validateAwaitExprSyntax(kind: kind, layout: layout)
  case .backDeployedAttributeArguments:
    validateBackDeployedAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .binaryOperatorExpr:
    validateBinaryOperatorExprSyntax(kind: kind, layout: layout)
  case .booleanLiteralExpr:
    validateBooleanLiteralExprSyntax(kind: kind, layout: layout)
  case .borrowExpr:
    validateBorrowExprSyntax(kind: kind, layout: layout)
  case .breakStmt:
    validateBreakStmtSyntax(kind: kind, layout: layout)
  case ._canImportExpr:
    validate_CanImportExprSyntax(kind: kind, layout: layout)
  case ._canImportVersionInfo:
    validate_CanImportVersionInfoSyntax(kind: kind, layout: layout)
  case .catchClauseList:
    validateCatchClauseListSyntax(kind: kind, layout: layout)
  case .catchClause:
    validateCatchClauseSyntax(kind: kind, layout: layout)
  case .catchItemList:
    validateCatchItemListSyntax(kind: kind, layout: layout)
  case .catchItem:
    validateCatchItemSyntax(kind: kind, layout: layout)
  case .classDecl:
    validateClassDeclSyntax(kind: kind, layout: layout)
  case .classRestrictionType:
    validateClassRestrictionTypeSyntax(kind: kind, layout: layout)
  case .closureCaptureClause:
    validateClosureCaptureClauseSyntax(kind: kind, layout: layout)
  case .closureCaptureList:
    validateClosureCaptureListSyntax(kind: kind, layout: layout)
  case .closureCaptureSpecifier:
    validateClosureCaptureSpecifierSyntax(kind: kind, layout: layout)
  case .closureCapture:
    validateClosureCaptureSyntax(kind: kind, layout: layout)
  case .closureExpr:
    validateClosureExprSyntax(kind: kind, layout: layout)
  case .closureParameterClause:
    validateClosureParameterClauseSyntax(kind: kind, layout: layout)
  case .closureParameterList:
    validateClosureParameterListSyntax(kind: kind, layout: layout)
  case .closureParameter:
    validateClosureParameterSyntax(kind: kind, layout: layout)
  case .closureShorthandParameterList:
    validateClosureShorthandParameterListSyntax(kind: kind, layout: layout)
  case .closureShorthandParameter:
    validateClosureShorthandParameterSyntax(kind: kind, layout: layout)
  case .closureSignature:
    validateClosureSignatureSyntax(kind: kind, layout: layout)
  case .codeBlockFile:
    validateCodeBlockFileSyntax(kind: kind, layout: layout)
  case .codeBlockItemList:
    validateCodeBlockItemListSyntax(kind: kind, layout: layout)
  case .codeBlockItem:
    validateCodeBlockItemSyntax(kind: kind, layout: layout)
  case .codeBlock:
    validateCodeBlockSyntax(kind: kind, layout: layout)
  case .compositionTypeElementList:
    validateCompositionTypeElementListSyntax(kind: kind, layout: layout)
  case .compositionTypeElement:
    validateCompositionTypeElementSyntax(kind: kind, layout: layout)
  case .compositionType:
    validateCompositionTypeSyntax(kind: kind, layout: layout)
  case .conditionElementList:
    validateConditionElementListSyntax(kind: kind, layout: layout)
  case .conditionElement:
    validateConditionElementSyntax(kind: kind, layout: layout)
  case .conformanceRequirement:
    validateConformanceRequirementSyntax(kind: kind, layout: layout)
  case .consumeExpr:
    validateConsumeExprSyntax(kind: kind, layout: layout)
  case .continueStmt:
    validateContinueStmtSyntax(kind: kind, layout: layout)
  case .copyExpr:
    validateCopyExprSyntax(kind: kind, layout: layout)
  case .declModifierDetail:
    validateDeclModifierDetailSyntax(kind: kind, layout: layout)
  case .declModifierList:
    validateDeclModifierListSyntax(kind: kind, layout: layout)
  case .declModifier:
    validateDeclModifierSyntax(kind: kind, layout: layout)
  case .declNameArgumentList:
    validateDeclNameArgumentListSyntax(kind: kind, layout: layout)
  case .declNameArgument:
    validateDeclNameArgumentSyntax(kind: kind, layout: layout)
  case .declNameArguments:
    validateDeclNameArgumentsSyntax(kind: kind, layout: layout)
  case .declReferenceExpr:
    validateDeclReferenceExprSyntax(kind: kind, layout: layout)
  case .deferStmt:
    validateDeferStmtSyntax(kind: kind, layout: layout)
  case .deinitializerDecl:
    validateDeinitializerDeclSyntax(kind: kind, layout: layout)
  case .deinitializerEffectSpecifiers:
    validateDeinitializerEffectSpecifiersSyntax(kind: kind, layout: layout)
  case .derivativeAttributeArguments:
    validateDerivativeAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .designatedTypeList:
    validateDesignatedTypeListSyntax(kind: kind, layout: layout)
  case .designatedType:
    validateDesignatedTypeSyntax(kind: kind, layout: layout)
  case .dictionaryElementList:
    validateDictionaryElementListSyntax(kind: kind, layout: layout)
  case .dictionaryElement:
    validateDictionaryElementSyntax(kind: kind, layout: layout)
  case .dictionaryExpr:
    validateDictionaryExprSyntax(kind: kind, layout: layout)
  case .dictionaryType:
    validateDictionaryTypeSyntax(kind: kind, layout: layout)
  case .differentiabilityArgumentList:
    validateDifferentiabilityArgumentListSyntax(kind: kind, layout: layout)
  case .differentiabilityArgument:
    validateDifferentiabilityArgumentSyntax(kind: kind, layout: layout)
  case .differentiabilityArguments:
    validateDifferentiabilityArgumentsSyntax(kind: kind, layout: layout)
  case .differentiabilityWithRespectToArgument:
    validateDifferentiabilityWithRespectToArgumentSyntax(kind: kind, layout: layout)
  case .differentiableAttributeArguments:
    validateDifferentiableAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .discardAssignmentExpr:
    validateDiscardAssignmentExprSyntax(kind: kind, layout: layout)
  case .discardStmt:
    validateDiscardStmtSyntax(kind: kind, layout: layout)
  case .doExpr:
    validateDoExprSyntax(kind: kind, layout: layout)
  case .doStmt:
    validateDoStmtSyntax(kind: kind, layout: layout)
  case .documentationAttributeArgumentList:
    validateDocumentationAttributeArgumentListSyntax(kind: kind, layout: layout)
  case .documentationAttributeArgument:
    validateDocumentationAttributeArgumentSyntax(kind: kind, layout: layout)
  case .dynamicReplacementAttributeArguments:
    validateDynamicReplacementAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .editorPlaceholderDecl:
    validateEditorPlaceholderDeclSyntax(kind: kind, layout: layout)
  case .editorPlaceholderExpr:
    validateEditorPlaceholderExprSyntax(kind: kind, layout: layout)
  case .effectsAttributeArgumentList:
    validateEffectsAttributeArgumentListSyntax(kind: kind, layout: layout)
  case .enumCaseDecl:
    validateEnumCaseDeclSyntax(kind: kind, layout: layout)
  case .enumCaseElementList:
    validateEnumCaseElementListSyntax(kind: kind, layout: layout)
  case .enumCaseElement:
    validateEnumCaseElementSyntax(kind: kind, layout: layout)
  case .enumCaseParameterClause:
    validateEnumCaseParameterClauseSyntax(kind: kind, layout: layout)
  case .enumCaseParameterList:
    validateEnumCaseParameterListSyntax(kind: kind, layout: layout)
  case .enumCaseParameter:
    validateEnumCaseParameterSyntax(kind: kind, layout: layout)
  case .enumDecl:
    validateEnumDeclSyntax(kind: kind, layout: layout)
  case .exprList:
    validateExprListSyntax(kind: kind, layout: layout)
  case .expressionPattern:
    validateExpressionPatternSyntax(kind: kind, layout: layout)
  case .expressionSegment:
    validateExpressionSegmentSyntax(kind: kind, layout: layout)
  case .expressionStmt:
    validateExpressionStmtSyntax(kind: kind, layout: layout)
  case .extensionDecl:
    validateExtensionDeclSyntax(kind: kind, layout: layout)
  case .fallThroughStmt:
    validateFallThroughStmtSyntax(kind: kind, layout: layout)
  case .floatLiteralExpr:
    validateFloatLiteralExprSyntax(kind: kind, layout: layout)
  case .forStmt:
    validateForStmtSyntax(kind: kind, layout: layout)
  case .forceUnwrapExpr:
    validateForceUnwrapExprSyntax(kind: kind, layout: layout)
  case .functionCallExpr:
    validateFunctionCallExprSyntax(kind: kind, layout: layout)
  case .functionDecl:
    validateFunctionDeclSyntax(kind: kind, layout: layout)
  case .functionEffectSpecifiers:
    validateFunctionEffectSpecifiersSyntax(kind: kind, layout: layout)
  case .functionParameterClause:
    validateFunctionParameterClauseSyntax(kind: kind, layout: layout)
  case .functionParameterList:
    validateFunctionParameterListSyntax(kind: kind, layout: layout)
  case .functionParameter:
    validateFunctionParameterSyntax(kind: kind, layout: layout)
  case .functionSignature:
    validateFunctionSignatureSyntax(kind: kind, layout: layout)
  case .functionType:
    validateFunctionTypeSyntax(kind: kind, layout: layout)
  case .genericArgumentClause:
    validateGenericArgumentClauseSyntax(kind: kind, layout: layout)
  case .genericArgumentList:
    validateGenericArgumentListSyntax(kind: kind, layout: layout)
  case .genericArgument:
    validateGenericArgumentSyntax(kind: kind, layout: layout)
  case .genericParameterClause:
    validateGenericParameterClauseSyntax(kind: kind, layout: layout)
  case .genericParameterList:
    validateGenericParameterListSyntax(kind: kind, layout: layout)
  case .genericParameter:
    validateGenericParameterSyntax(kind: kind, layout: layout)
  case .genericRequirementList:
    validateGenericRequirementListSyntax(kind: kind, layout: layout)
  case .genericRequirement:
    validateGenericRequirementSyntax(kind: kind, layout: layout)
  case .genericSpecializationExpr:
    validateGenericSpecializationExprSyntax(kind: kind, layout: layout)
  case .genericWhereClause:
    validateGenericWhereClauseSyntax(kind: kind, layout: layout)
  case .guardStmt:
    validateGuardStmtSyntax(kind: kind, layout: layout)
  case .identifierPattern:
    validateIdentifierPatternSyntax(kind: kind, layout: layout)
  case .identifierType:
    validateIdentifierTypeSyntax(kind: kind, layout: layout)
  case .ifConfigClauseList:
    validateIfConfigClauseListSyntax(kind: kind, layout: layout)
  case .ifConfigClause:
    validateIfConfigClauseSyntax(kind: kind, layout: layout)
  case .ifConfigDecl:
    validateIfConfigDeclSyntax(kind: kind, layout: layout)
  case .ifExpr:
    validateIfExprSyntax(kind: kind, layout: layout)
  case .implementsAttributeArguments:
    validateImplementsAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .implicitlyUnwrappedOptionalType:
    validateImplicitlyUnwrappedOptionalTypeSyntax(kind: kind, layout: layout)
  case .importDecl:
    validateImportDeclSyntax(kind: kind, layout: layout)
  case .importPathComponentList:
    validateImportPathComponentListSyntax(kind: kind, layout: layout)
  case .importPathComponent:
    validateImportPathComponentSyntax(kind: kind, layout: layout)
  case .inOutExpr:
    validateInOutExprSyntax(kind: kind, layout: layout)
  case .infixOperatorExpr:
    validateInfixOperatorExprSyntax(kind: kind, layout: layout)
  case .inheritanceClause:
    validateInheritanceClauseSyntax(kind: kind, layout: layout)
  case .inheritedTypeList:
    validateInheritedTypeListSyntax(kind: kind, layout: layout)
  case .inheritedType:
    validateInheritedTypeSyntax(kind: kind, layout: layout)
  case .initializerClause:
    validateInitializerClauseSyntax(kind: kind, layout: layout)
  case .initializerDecl:
    validateInitializerDeclSyntax(kind: kind, layout: layout)
  case .inlineArrayType:
    validateInlineArrayTypeSyntax(kind: kind, layout: layout)
  case .integerLiteralExpr:
    validateIntegerLiteralExprSyntax(kind: kind, layout: layout)
  case .isExpr:
    validateIsExprSyntax(kind: kind, layout: layout)
  case .isTypePattern:
    validateIsTypePatternSyntax(kind: kind, layout: layout)
  case .keyPathComponentList:
    validateKeyPathComponentListSyntax(kind: kind, layout: layout)
  case .keyPathComponent:
    validateKeyPathComponentSyntax(kind: kind, layout: layout)
  case .keyPathExpr:
    validateKeyPathExprSyntax(kind: kind, layout: layout)
  case .keyPathMethodComponent:
    validateKeyPathMethodComponentSyntax(kind: kind, layout: layout)
  case .keyPathOptionalComponent:
    validateKeyPathOptionalComponentSyntax(kind: kind, layout: layout)
  case .keyPathPropertyComponent:
    validateKeyPathPropertyComponentSyntax(kind: kind, layout: layout)
  case .keyPathSubscriptComponent:
    validateKeyPathSubscriptComponentSyntax(kind: kind, layout: layout)
  case .labeledExprList:
    validateLabeledExprListSyntax(kind: kind, layout: layout)
  case .labeledExpr:
    validateLabeledExprSyntax(kind: kind, layout: layout)
  case .labeledSpecializeArgument:
    validateLabeledSpecializeArgumentSyntax(kind: kind, layout: layout)
  case .labeledStmt:
    validateLabeledStmtSyntax(kind: kind, layout: layout)
  case .layoutRequirement:
    validateLayoutRequirementSyntax(kind: kind, layout: layout)
  case .lifetimeSpecifierArgumentList:
    validateLifetimeSpecifierArgumentListSyntax(kind: kind, layout: layout)
  case .lifetimeSpecifierArgument:
    validateLifetimeSpecifierArgumentSyntax(kind: kind, layout: layout)
  case .lifetimeTypeSpecifier:
    validateLifetimeTypeSpecifierSyntax(kind: kind, layout: layout)
  case .macroDecl:
    validateMacroDeclSyntax(kind: kind, layout: layout)
  case .macroExpansionDecl:
    validateMacroExpansionDeclSyntax(kind: kind, layout: layout)
  case .macroExpansionExpr:
    validateMacroExpansionExprSyntax(kind: kind, layout: layout)
  case .matchingPatternCondition:
    validateMatchingPatternConditionSyntax(kind: kind, layout: layout)
  case .memberAccessExpr:
    validateMemberAccessExprSyntax(kind: kind, layout: layout)
  case .memberBlockItemListFile:
    validateMemberBlockItemListFileSyntax(kind: kind, layout: layout)
  case .memberBlockItemList:
    validateMemberBlockItemListSyntax(kind: kind, layout: layout)
  case .memberBlockItem:
    validateMemberBlockItemSyntax(kind: kind, layout: layout)
  case .memberBlock:
    validateMemberBlockSyntax(kind: kind, layout: layout)
  case .memberType:
    validateMemberTypeSyntax(kind: kind, layout: layout)
  case .metatypeType:
    validateMetatypeTypeSyntax(kind: kind, layout: layout)
  case .missingDecl:
    validateMissingDeclSyntax(kind: kind, layout: layout)
  case .missingExpr:
    validateMissingExprSyntax(kind: kind, layout: layout)
  case .missingPattern:
    validateMissingPatternSyntax(kind: kind, layout: layout)
  case .missingStmt:
    validateMissingStmtSyntax(kind: kind, layout: layout)
  case .missing:
    validateMissingSyntax(kind: kind, layout: layout)
  case .missingType:
    validateMissingTypeSyntax(kind: kind, layout: layout)
  case .multipleTrailingClosureElementList:
    validateMultipleTrailingClosureElementListSyntax(kind: kind, layout: layout)
  case .multipleTrailingClosureElement:
    validateMultipleTrailingClosureElementSyntax(kind: kind, layout: layout)
  case .namedOpaqueReturnType:
    validateNamedOpaqueReturnTypeSyntax(kind: kind, layout: layout)
  case .nilLiteralExpr:
    validateNilLiteralExprSyntax(kind: kind, layout: layout)
  case .nonisolatedSpecifierArgument:
    validateNonisolatedSpecifierArgumentSyntax(kind: kind, layout: layout)
  case .nonisolatedTypeSpecifier:
    validateNonisolatedTypeSpecifierSyntax(kind: kind, layout: layout)
  case .objCSelectorPieceList:
    validateObjCSelectorPieceListSyntax(kind: kind, layout: layout)
  case .objCSelectorPiece:
    validateObjCSelectorPieceSyntax(kind: kind, layout: layout)
  case .operatorDecl:
    validateOperatorDeclSyntax(kind: kind, layout: layout)
  case .operatorPrecedenceAndTypes:
    validateOperatorPrecedenceAndTypesSyntax(kind: kind, layout: layout)
  case .optionalBindingCondition:
    validateOptionalBindingConditionSyntax(kind: kind, layout: layout)
  case .optionalChainingExpr:
    validateOptionalChainingExprSyntax(kind: kind, layout: layout)
  case .optionalType:
    validateOptionalTypeSyntax(kind: kind, layout: layout)
  case .originallyDefinedInAttributeArguments:
    validateOriginallyDefinedInAttributeArgumentsSyntax(kind: kind, layout: layout)
  case .packElementExpr:
    validatePackElementExprSyntax(kind: kind, layout: layout)
  case .packElementType:
    validatePackElementTypeSyntax(kind: kind, layout: layout)
  case .packExpansionExpr:
    validatePackExpansionExprSyntax(kind: kind, layout: layout)
  case .packExpansionType:
    validatePackExpansionTypeSyntax(kind: kind, layout: layout)
  case .patternBindingList:
    validatePatternBindingListSyntax(kind: kind, layout: layout)
  case .patternBinding:
    validatePatternBindingSyntax(kind: kind, layout: layout)
  case .patternExpr:
    validatePatternExprSyntax(kind: kind, layout: layout)
  case .platformVersionItemList:
    validatePlatformVersionItemListSyntax(kind: kind, layout: layout)
  case .platformVersionItem:
    validatePlatformVersionItemSyntax(kind: kind, layout: layout)
  case .platformVersion:
    validatePlatformVersionSyntax(kind: kind, layout: layout)
  case .postfixIfConfigExpr:
    validatePostfixIfConfigExprSyntax(kind: kind, layout: layout)
  case .postfixOperatorExpr:
    validatePostfixOperatorExprSyntax(kind: kind, layout: layout)
  case .poundSourceLocationArguments:
    validatePoundSourceLocationArgumentsSyntax(kind: kind, layout: layout)
  case .poundSourceLocation:
    validatePoundSourceLocationSyntax(kind: kind, layout: layout)
  case .precedenceGroupAssignment:
    validatePrecedenceGroupAssignmentSyntax(kind: kind, layout: layout)
  case .precedenceGroupAssociativity:
    validatePrecedenceGroupAssociativitySyntax(kind: kind, layout: layout)
  case .precedenceGroupAttributeList:
    validatePrecedenceGroupAttributeListSyntax(kind: kind, layout: layout)
  case .precedenceGroupDecl:
    validatePrecedenceGroupDeclSyntax(kind: kind, layout: layout)
  case .precedenceGroupNameList:
    validatePrecedenceGroupNameListSyntax(kind: kind, layout: layout)
  case .precedenceGroupName:
    validatePrecedenceGroupNameSyntax(kind: kind, layout: layout)
  case .precedenceGroupRelation:
    validatePrecedenceGroupRelationSyntax(kind: kind, layout: layout)
  case .prefixOperatorExpr:
    validatePrefixOperatorExprSyntax(kind: kind, layout: layout)
  case .primaryAssociatedTypeClause:
    validatePrimaryAssociatedTypeClauseSyntax(kind: kind, layout: layout)
  case .primaryAssociatedTypeList:
    validatePrimaryAssociatedTypeListSyntax(kind: kind, layout: layout)
  case .primaryAssociatedType:
    validatePrimaryAssociatedTypeSyntax(kind: kind, layout: layout)
  case .protocolDecl:
    validateProtocolDeclSyntax(kind: kind, layout: layout)
  case .regexLiteralExpr:
    validateRegexLiteralExprSyntax(kind: kind, layout: layout)
  case .repeatStmt:
    validateRepeatStmtSyntax(kind: kind, layout: layout)
  case .returnClause:
    validateReturnClauseSyntax(kind: kind, layout: layout)
  case .returnStmt:
    validateReturnStmtSyntax(kind: kind, layout: layout)
  case .sameTypeRequirement:
    validateSameTypeRequirementSyntax(kind: kind, layout: layout)
  case .sequenceExpr:
    validateSequenceExprSyntax(kind: kind, layout: layout)
  case .simpleStringLiteralExpr:
    validateSimpleStringLiteralExprSyntax(kind: kind, layout: layout)
  case .simpleStringLiteralSegmentList:
    validateSimpleStringLiteralSegmentListSyntax(kind: kind, layout: layout)
  case .simpleTypeSpecifier:
    validateSimpleTypeSpecifierSyntax(kind: kind, layout: layout)
  case .someOrAnyType:
    validateSomeOrAnyTypeSyntax(kind: kind, layout: layout)
  case .sourceFile:
    validateSourceFileSyntax(kind: kind, layout: layout)
  case .specializeAttributeArgumentList:
    validateSpecializeAttributeArgumentListSyntax(kind: kind, layout: layout)
  case .specializeAvailabilityArgument:
    validateSpecializeAvailabilityArgumentSyntax(kind: kind, layout: layout)
  case .specializeTargetFunctionArgument:
    validateSpecializeTargetFunctionArgumentSyntax(kind: kind, layout: layout)
  case .stringLiteralExpr:
    validateStringLiteralExprSyntax(kind: kind, layout: layout)
  case .stringLiteralSegmentList:
    validateStringLiteralSegmentListSyntax(kind: kind, layout: layout)
  case .stringSegment:
    validateStringSegmentSyntax(kind: kind, layout: layout)
  case .structDecl:
    validateStructDeclSyntax(kind: kind, layout: layout)
  case .subscriptCallExpr:
    validateSubscriptCallExprSyntax(kind: kind, layout: layout)
  case .subscriptDecl:
    validateSubscriptDeclSyntax(kind: kind, layout: layout)
  case .superExpr:
    validateSuperExprSyntax(kind: kind, layout: layout)
  case .suppressedType:
    validateSuppressedTypeSyntax(kind: kind, layout: layout)
  case .switchCaseItemList:
    validateSwitchCaseItemListSyntax(kind: kind, layout: layout)
  case .switchCaseItem:
    validateSwitchCaseItemSyntax(kind: kind, layout: layout)
  case .switchCaseLabel:
    validateSwitchCaseLabelSyntax(kind: kind, layout: layout)
  case .switchCaseList:
    validateSwitchCaseListSyntax(kind: kind, layout: layout)
  case .switchCase:
    validateSwitchCaseSyntax(kind: kind, layout: layout)
  case .switchDefaultLabel:
    validateSwitchDefaultLabelSyntax(kind: kind, layout: layout)
  case .switchExpr:
    validateSwitchExprSyntax(kind: kind, layout: layout)
  case .ternaryExpr:
    validateTernaryExprSyntax(kind: kind, layout: layout)
  case .thenStmt:
    validateThenStmtSyntax(kind: kind, layout: layout)
  case .throwStmt:
    validateThrowStmtSyntax(kind: kind, layout: layout)
  case .throwsClause:
    validateThrowsClauseSyntax(kind: kind, layout: layout)
  case .tryExpr:
    validateTryExprSyntax(kind: kind, layout: layout)
  case .tupleExpr:
    validateTupleExprSyntax(kind: kind, layout: layout)
  case .tuplePatternElementList:
    validateTuplePatternElementListSyntax(kind: kind, layout: layout)
  case .tuplePatternElement:
    validateTuplePatternElementSyntax(kind: kind, layout: layout)
  case .tuplePattern:
    validateTuplePatternSyntax(kind: kind, layout: layout)
  case .tupleTypeElementList:
    validateTupleTypeElementListSyntax(kind: kind, layout: layout)
  case .tupleTypeElement:
    validateTupleTypeElementSyntax(kind: kind, layout: layout)
  case .tupleType:
    validateTupleTypeSyntax(kind: kind, layout: layout)
  case .typeAliasDecl:
    validateTypeAliasDeclSyntax(kind: kind, layout: layout)
  case .typeAnnotation:
    validateTypeAnnotationSyntax(kind: kind, layout: layout)
  case .typeEffectSpecifiers:
    validateTypeEffectSpecifiersSyntax(kind: kind, layout: layout)
  case .typeExpr:
    validateTypeExprSyntax(kind: kind, layout: layout)
  case .typeInitializerClause:
    validateTypeInitializerClauseSyntax(kind: kind, layout: layout)
  case .typeSpecifierList:
    validateTypeSpecifierListSyntax(kind: kind, layout: layout)
  case .unexpectedNodes:
    validateUnexpectedNodesSyntax(kind: kind, layout: layout)
  case .unresolvedAsExpr:
    validateUnresolvedAsExprSyntax(kind: kind, layout: layout)
  case .unresolvedIsExpr:
    validateUnresolvedIsExprSyntax(kind: kind, layout: layout)
  case .unresolvedTernaryExpr:
    validateUnresolvedTernaryExprSyntax(kind: kind, layout: layout)
  case .unsafeExpr:
    validateUnsafeExprSyntax(kind: kind, layout: layout)
  case .usingDecl:
    validateUsingDeclSyntax(kind: kind, layout: layout)
  case .valueBindingPattern:
    validateValueBindingPatternSyntax(kind: kind, layout: layout)
  case .variableDecl:
    validateVariableDeclSyntax(kind: kind, layout: layout)
  case .versionComponentList:
    validateVersionComponentListSyntax(kind: kind, layout: layout)
  case .versionComponent:
    validateVersionComponentSyntax(kind: kind, layout: layout)
  case .versionTuple:
    validateVersionTupleSyntax(kind: kind, layout: layout)
  case .whereClause:
    validateWhereClauseSyntax(kind: kind, layout: layout)
  case .whileStmt:
    validateWhileStmtSyntax(kind: kind, layout: layout)
  case .wildcardPattern:
    validateWildcardPatternSyntax(kind: kind, layout: layout)
  case .yieldStmt:
    validateYieldStmtSyntax(kind: kind, layout: layout)
  case .yieldedExpressionList:
    validateYieldedExpressionListSyntax(kind: kind, layout: layout)
  case .yieldedExpression:
    validateYieldedExpressionSyntax(kind: kind, layout: layout)
  case .yieldedExpressionsClause:
    validateYieldedExpressionsClauseSyntax(kind: kind, layout: layout)
  }
  #endif
}
