# ``SwiftSyntax``

@Comment {
  Automatically Generated by CodeGeneration.
  Do Not Edit Directly!
}

A library for working with Swift code.

## Overview

SwiftSyntax is a source accurate tree representation of Swift source code. It 
allows Swift tools to parse, inspect, generate, and transform Swift source code.

## Topics

### Articles

- <doc:Working-with-SwiftSyntax>
- <doc:Macro-Versioning>
- <doc:RawSyntaxValidation>
- <doc:Glossary>

### Tutorials

- <doc:Tutorial-Table-of-Contents>

### Syntax

- <doc:SwiftSyntax/Syntax>
- <doc:SwiftSyntax/SyntaxCollection>

### Trivia

- <doc:SwiftSyntax/Trivia>
- <doc:SwiftSyntax/TriviaPiece>
- <doc:SwiftSyntax/TriviaPosition>

### Tokens

- <doc:SwiftSyntax/TokenSyntax>
- <doc:SwiftSyntax/TokenKind>
- <doc:SwiftSyntax/TokenSequence>
- <doc:SwiftSyntax/SourcePresence>

### Syntax Visitors

- <doc:SwiftSyntax/SyntaxVisitor>
- <doc:SwiftSyntax/SyntaxAnyVisitor>
- <doc:SwiftSyntax/SyntaxRewriter>
- <doc:SwiftSyntax/SyntaxTreeViewMode>
- <doc:SwiftSyntax/SyntaxVisitorContinueKind>
- <doc:SwiftSyntax/ReversedTokenSequence>

### Declarations

- <doc:SwiftSyntax/DeclSyntax>
- <doc:SwiftSyntax/DeclSyntaxProtocol>
- <doc:SwiftSyntax/MissingDeclSyntax>
- <doc:SwiftSyntax/AccessorDeclSyntax>
- <doc:SwiftSyntax/ActorDeclSyntax>
- <doc:SwiftSyntax/AssociatedTypeDeclSyntax>
- <doc:SwiftSyntax/ClassDeclSyntax>
- <doc:SwiftSyntax/DeinitializerDeclSyntax>
- <doc:SwiftSyntax/EditorPlaceholderDeclSyntax>
- <doc:SwiftSyntax/EnumCaseDeclSyntax>
- <doc:SwiftSyntax/EnumDeclSyntax>
- <doc:SwiftSyntax/ExtensionDeclSyntax>
- <doc:SwiftSyntax/FunctionDeclSyntax>
- <doc:SwiftSyntax/IfConfigDeclSyntax>
- <doc:SwiftSyntax/ImportDeclSyntax>
- <doc:SwiftSyntax/InitializerDeclSyntax>
- <doc:SwiftSyntax/MacroDeclSyntax>
- <doc:SwiftSyntax/MacroExpansionDeclSyntax>
- <doc:SwiftSyntax/OperatorDeclSyntax>
- <doc:SwiftSyntax/PoundSourceLocationSyntax>
- <doc:SwiftSyntax/PrecedenceGroupDeclSyntax>
- <doc:SwiftSyntax/ProtocolDeclSyntax>
- <doc:SwiftSyntax/StructDeclSyntax>
- <doc:SwiftSyntax/SubscriptDeclSyntax>
- <doc:SwiftSyntax/TypeAliasDeclSyntax>
- <doc:SwiftSyntax/VariableDeclSyntax>

### Expressions

- <doc:SwiftSyntax/ExprSyntax>
- <doc:SwiftSyntax/ExprSyntaxProtocol>
- <doc:SwiftSyntax/MissingExprSyntax>
- <doc:SwiftSyntax/ArrayExprSyntax>
- <doc:SwiftSyntax/ArrowExprSyntax>
- <doc:SwiftSyntax/AsExprSyntax>
- <doc:SwiftSyntax/AssignmentExprSyntax>
- <doc:SwiftSyntax/AwaitExprSyntax>
- <doc:SwiftSyntax/BinaryOperatorExprSyntax>
- <doc:SwiftSyntax/BooleanLiteralExprSyntax>
- <doc:SwiftSyntax/BorrowExprSyntax>
- <doc:SwiftSyntax/ClosureExprSyntax>
- <doc:SwiftSyntax/ConsumeExprSyntax>
- <doc:SwiftSyntax/CopyExprSyntax>
- <doc:SwiftSyntax/DeclReferenceExprSyntax>
- <doc:SwiftSyntax/DictionaryExprSyntax>
- <doc:SwiftSyntax/DiscardAssignmentExprSyntax>
- <doc:SwiftSyntax/EditorPlaceholderExprSyntax>
- <doc:SwiftSyntax/FloatLiteralExprSyntax>
- <doc:SwiftSyntax/ForceUnwrapExprSyntax>
- <doc:SwiftSyntax/FunctionCallExprSyntax>
- <doc:SwiftSyntax/GenericSpecializationExprSyntax>
- <doc:SwiftSyntax/IfExprSyntax>
- <doc:SwiftSyntax/InOutExprSyntax>
- <doc:SwiftSyntax/InfixOperatorExprSyntax>
- <doc:SwiftSyntax/IntegerLiteralExprSyntax>
- <doc:SwiftSyntax/IsExprSyntax>
- <doc:SwiftSyntax/KeyPathExprSyntax>
- <doc:SwiftSyntax/MacroExpansionExprSyntax>
- <doc:SwiftSyntax/MemberAccessExprSyntax>
- <doc:SwiftSyntax/NilLiteralExprSyntax>
- <doc:SwiftSyntax/OptionalChainingExprSyntax>
- <doc:SwiftSyntax/PackElementExprSyntax>
- <doc:SwiftSyntax/PackExpansionExprSyntax>
- <doc:SwiftSyntax/PatternExprSyntax>
- <doc:SwiftSyntax/PostfixIfConfigExprSyntax>
- <doc:SwiftSyntax/PostfixOperatorExprSyntax>
- <doc:SwiftSyntax/PrefixOperatorExprSyntax>
- <doc:SwiftSyntax/RegexLiteralExprSyntax>
- <doc:SwiftSyntax/SequenceExprSyntax>
- <doc:SwiftSyntax/SimpleStringLiteralExprSyntax>
- <doc:SwiftSyntax/StringLiteralExprSyntax>
- <doc:SwiftSyntax/SubscriptCallExprSyntax>
- <doc:SwiftSyntax/SuperExprSyntax>
- <doc:SwiftSyntax/SwitchExprSyntax>
- <doc:SwiftSyntax/TernaryExprSyntax>
- <doc:SwiftSyntax/TryExprSyntax>
- <doc:SwiftSyntax/TupleExprSyntax>
- <doc:SwiftSyntax/TypeExprSyntax>
- <doc:SwiftSyntax/UnresolvedAsExprSyntax>
- <doc:SwiftSyntax/UnresolvedIsExprSyntax>
- <doc:SwiftSyntax/UnresolvedTernaryExprSyntax>
- <doc:SwiftSyntax/UnsafeExprSyntax>

### Patterns

- <doc:SwiftSyntax/PatternSyntax>
- <doc:SwiftSyntax/PatternSyntaxProtocol>
- <doc:SwiftSyntax/MissingPatternSyntax>
- <doc:SwiftSyntax/ExpressionPatternSyntax>
- <doc:SwiftSyntax/IdentifierPatternSyntax>
- <doc:SwiftSyntax/IsTypePatternSyntax>
- <doc:SwiftSyntax/TuplePatternSyntax>
- <doc:SwiftSyntax/ValueBindingPatternSyntax>
- <doc:SwiftSyntax/WildcardPatternSyntax>

### Statements

- <doc:SwiftSyntax/StmtSyntax>
- <doc:SwiftSyntax/StmtSyntaxProtocol>
- <doc:SwiftSyntax/MissingStmtSyntax>
- <doc:SwiftSyntax/BreakStmtSyntax>
- <doc:SwiftSyntax/ContinueStmtSyntax>
- <doc:SwiftSyntax/DeferStmtSyntax>
- <doc:SwiftSyntax/DiscardStmtSyntax>
- <doc:SwiftSyntax/DoStmtSyntax>
- <doc:SwiftSyntax/ExpressionStmtSyntax>
- <doc:SwiftSyntax/FallThroughStmtSyntax>
- <doc:SwiftSyntax/ForStmtSyntax>
- <doc:SwiftSyntax/GuardStmtSyntax>
- <doc:SwiftSyntax/LabeledStmtSyntax>
- <doc:SwiftSyntax/RepeatStmtSyntax>
- <doc:SwiftSyntax/ReturnStmtSyntax>
- <doc:SwiftSyntax/ThrowStmtSyntax>
- <doc:SwiftSyntax/WhileStmtSyntax>
- <doc:SwiftSyntax/YieldStmtSyntax>

### Types

- <doc:SwiftSyntax/TypeSyntax>
- <doc:SwiftSyntax/TypeSyntaxProtocol>
- <doc:SwiftSyntax/MissingTypeSyntax>
- <doc:SwiftSyntax/ArrayTypeSyntax>
- <doc:SwiftSyntax/AttributedTypeSyntax>
- <doc:SwiftSyntax/ClassRestrictionTypeSyntax>
- <doc:SwiftSyntax/CompositionTypeSyntax>
- <doc:SwiftSyntax/DictionaryTypeSyntax>
- <doc:SwiftSyntax/FunctionTypeSyntax>
- <doc:SwiftSyntax/IdentifierTypeSyntax>
- <doc:SwiftSyntax/ImplicitlyUnwrappedOptionalTypeSyntax>
- <doc:SwiftSyntax/InlineArrayTypeSyntax>
- <doc:SwiftSyntax/MemberTypeSyntax>
- <doc:SwiftSyntax/MetatypeTypeSyntax>
- <doc:SwiftSyntax/NamedOpaqueReturnTypeSyntax>
- <doc:SwiftSyntax/OptionalTypeSyntax>
- <doc:SwiftSyntax/PackElementTypeSyntax>
- <doc:SwiftSyntax/PackExpansionTypeSyntax>
- <doc:SwiftSyntax/SomeOrAnyTypeSyntax>
- <doc:SwiftSyntax/SuppressedTypeSyntax>
- <doc:SwiftSyntax/TupleTypeSyntax>

### Collections

- <doc:SwiftSyntax/SyntaxChildren>
- <doc:SwiftSyntax/SyntaxChildrenIndex>
- <doc:SwiftSyntax/AccessorDeclListSyntax>
- <doc:SwiftSyntax/ArrayElementListSyntax>
- <doc:SwiftSyntax/ArrayElementSyntax>
- <doc:SwiftSyntax/AttributeListSyntax>
- <doc:SwiftSyntax/AttributeSyntax>
- <doc:SwiftSyntax/AvailabilityArgumentListSyntax>
- <doc:SwiftSyntax/AvailabilityArgumentSyntax>
- <doc:SwiftSyntax/CatchClauseListSyntax>
- <doc:SwiftSyntax/CatchClauseSyntax>
- <doc:SwiftSyntax/CatchItemListSyntax>
- <doc:SwiftSyntax/CatchItemSyntax>
- <doc:SwiftSyntax/ClosureCaptureListSyntax>
- <doc:SwiftSyntax/ClosureCaptureSyntax>
- <doc:SwiftSyntax/ClosureParameterListSyntax>
- <doc:SwiftSyntax/ClosureParameterSyntax>
- <doc:SwiftSyntax/ClosureShorthandParameterListSyntax>
- <doc:SwiftSyntax/ClosureShorthandParameterSyntax>
- <doc:SwiftSyntax/CodeBlockItemListSyntax>
- <doc:SwiftSyntax/CodeBlockItemSyntax>
- <doc:SwiftSyntax/CompositionTypeElementListSyntax>
- <doc:SwiftSyntax/CompositionTypeElementSyntax>
- <doc:SwiftSyntax/ConditionElementListSyntax>
- <doc:SwiftSyntax/ConditionElementSyntax>
- <doc:SwiftSyntax/DeclModifierListSyntax>
- <doc:SwiftSyntax/DeclModifierSyntax>
- <doc:SwiftSyntax/DeclNameArgumentListSyntax>
- <doc:SwiftSyntax/DeclNameArgumentSyntax>
- <doc:SwiftSyntax/DesignatedTypeListSyntax>
- <doc:SwiftSyntax/DesignatedTypeSyntax>
- <doc:SwiftSyntax/DictionaryElementListSyntax>
- <doc:SwiftSyntax/DictionaryElementSyntax>
- <doc:SwiftSyntax/DifferentiabilityArgumentListSyntax>
- <doc:SwiftSyntax/DifferentiabilityArgumentSyntax>
- <doc:SwiftSyntax/DocumentationAttributeArgumentListSyntax>
- <doc:SwiftSyntax/DocumentationAttributeArgumentSyntax>
- <doc:SwiftSyntax/EffectsAttributeArgumentListSyntax>
- <doc:SwiftSyntax/EnumCaseElementListSyntax>
- <doc:SwiftSyntax/EnumCaseElementSyntax>
- <doc:SwiftSyntax/EnumCaseParameterListSyntax>
- <doc:SwiftSyntax/EnumCaseParameterSyntax>
- <doc:SwiftSyntax/ExprListSyntax>
- <doc:SwiftSyntax/FunctionParameterListSyntax>
- <doc:SwiftSyntax/FunctionParameterSyntax>
- <doc:SwiftSyntax/GenericArgumentListSyntax>
- <doc:SwiftSyntax/GenericArgumentSyntax>
- <doc:SwiftSyntax/GenericParameterListSyntax>
- <doc:SwiftSyntax/GenericParameterSyntax>
- <doc:SwiftSyntax/GenericRequirementListSyntax>
- <doc:SwiftSyntax/GenericRequirementSyntax>
- <doc:SwiftSyntax/IfConfigClauseListSyntax>
- <doc:SwiftSyntax/IfConfigClauseSyntax>
- <doc:SwiftSyntax/ImportPathComponentListSyntax>
- <doc:SwiftSyntax/ImportPathComponentSyntax>
- <doc:SwiftSyntax/InheritedTypeListSyntax>
- <doc:SwiftSyntax/InheritedTypeSyntax>
- <doc:SwiftSyntax/KeyPathComponentListSyntax>
- <doc:SwiftSyntax/KeyPathComponentSyntax>
- <doc:SwiftSyntax/LabeledExprListSyntax>
- <doc:SwiftSyntax/LabeledExprSyntax>
- <doc:SwiftSyntax/MemberBlockItemListSyntax>
- <doc:SwiftSyntax/MemberBlockItemSyntax>
- <doc:SwiftSyntax/MultipleTrailingClosureElementListSyntax>
- <doc:SwiftSyntax/MultipleTrailingClosureElementSyntax>
- <doc:SwiftSyntax/ObjCSelectorPieceListSyntax>
- <doc:SwiftSyntax/ObjCSelectorPieceSyntax>
- <doc:SwiftSyntax/PatternBindingListSyntax>
- <doc:SwiftSyntax/PatternBindingSyntax>
- <doc:SwiftSyntax/PlatformVersionItemListSyntax>
- <doc:SwiftSyntax/PlatformVersionItemSyntax>
- <doc:SwiftSyntax/PrecedenceGroupAttributeListSyntax>
- <doc:SwiftSyntax/PrecedenceGroupRelationSyntax>
- <doc:SwiftSyntax/PrecedenceGroupAssignmentSyntax>
- <doc:SwiftSyntax/PrecedenceGroupAssociativitySyntax>
- <doc:SwiftSyntax/PrecedenceGroupNameListSyntax>
- <doc:SwiftSyntax/PrecedenceGroupNameSyntax>
- <doc:SwiftSyntax/PrimaryAssociatedTypeListSyntax>
- <doc:SwiftSyntax/PrimaryAssociatedTypeSyntax>
- <doc:SwiftSyntax/SimpleStringLiteralSegmentListSyntax>
- <doc:SwiftSyntax/StringSegmentSyntax>
- <doc:SwiftSyntax/SpecializeAttributeArgumentListSyntax>
- <doc:SwiftSyntax/LabeledSpecializeArgumentSyntax>
- <doc:SwiftSyntax/SpecializeAvailabilityArgumentSyntax>
- <doc:SwiftSyntax/SpecializeTargetFunctionArgumentSyntax>
- <doc:SwiftSyntax/GenericWhereClauseSyntax>
- <doc:SwiftSyntax/StringLiteralSegmentListSyntax>
- <doc:SwiftSyntax/StringSegmentSyntax>
- <doc:SwiftSyntax/ExpressionSegmentSyntax>
- <doc:SwiftSyntax/SwitchCaseItemListSyntax>
- <doc:SwiftSyntax/SwitchCaseItemSyntax>
- <doc:SwiftSyntax/SwitchCaseListSyntax>
- <doc:SwiftSyntax/SwitchCaseSyntax>
- <doc:SwiftSyntax/TuplePatternElementListSyntax>
- <doc:SwiftSyntax/TuplePatternElementSyntax>
- <doc:SwiftSyntax/TupleTypeElementListSyntax>
- <doc:SwiftSyntax/TupleTypeElementSyntax>
- <doc:SwiftSyntax/TypeSpecifierListSyntax>
- <doc:SwiftSyntax/SimpleTypeSpecifierSyntax>
- <doc:SwiftSyntax/NonisolatedTypeSpecifierSyntax>
- <doc:SwiftSyntax/UnexpectedNodesSyntax>
- <doc:SwiftSyntax/VersionComponentListSyntax>
- <doc:SwiftSyntax/VersionComponentSyntax>
- <doc:SwiftSyntax/YieldedExpressionListSyntax>
- <doc:SwiftSyntax/YieldedExpressionSyntax>

### Attributes

- <doc:SwiftSyntax/ABIAttributeArgumentsSyntax>
- <doc:SwiftSyntax/AttributeListSyntax>
- <doc:SwiftSyntax/AttributeSyntax>
- <doc:SwiftSyntax/BackDeployedAttributeArgumentsSyntax>
- <doc:SwiftSyntax/DerivativeAttributeArgumentsSyntax>
- <doc:SwiftSyntax/DifferentiabilityArgumentListSyntax>
- <doc:SwiftSyntax/DifferentiabilityArgumentSyntax>
- <doc:SwiftSyntax/DifferentiabilityArgumentsSyntax>
- <doc:SwiftSyntax/DifferentiabilityWithRespectToArgumentSyntax>
- <doc:SwiftSyntax/DifferentiableAttributeArgumentsSyntax>
- <doc:SwiftSyntax/DocumentationAttributeArgumentListSyntax>
- <doc:SwiftSyntax/DocumentationAttributeArgumentSyntax>
- <doc:SwiftSyntax/DynamicReplacementAttributeArgumentsSyntax>
- <doc:SwiftSyntax/EffectsAttributeArgumentListSyntax>
- <doc:SwiftSyntax/ImplementsAttributeArgumentsSyntax>
- <doc:SwiftSyntax/LabeledSpecializeArgumentSyntax>
- <doc:SwiftSyntax/ObjCSelectorPieceListSyntax>
- <doc:SwiftSyntax/ObjCSelectorPieceSyntax>
- <doc:SwiftSyntax/OriginallyDefinedInAttributeArgumentsSyntax>
- <doc:SwiftSyntax/PlatformVersionItemListSyntax>
- <doc:SwiftSyntax/PlatformVersionItemSyntax>
- <doc:SwiftSyntax/SpecializeAttributeArgumentListSyntax>
- <doc:SwiftSyntax/SpecializeAvailabilityArgumentSyntax>
- <doc:SwiftSyntax/SpecializeTargetFunctionArgumentSyntax>

### Miscellaneous Syntax

- <doc:SwiftSyntax/AccessorBlockSyntax>
- <doc:SwiftSyntax/AccessorEffectSpecifiersSyntax>
- <doc:SwiftSyntax/AccessorParametersSyntax>
- <doc:SwiftSyntax/AvailabilityConditionSyntax>
- <doc:SwiftSyntax/AvailabilityLabeledArgumentSyntax>
- <doc:SwiftSyntax/ClosureCaptureClauseSyntax>
- <doc:SwiftSyntax/ClosureCaptureSpecifierSyntax>
- <doc:SwiftSyntax/ClosureParameterClauseSyntax>
- <doc:SwiftSyntax/ClosureSignatureSyntax>
- <doc:SwiftSyntax/CodeBlockSyntax>
- <doc:SwiftSyntax/ConformanceRequirementSyntax>
- <doc:SwiftSyntax/DeclModifierDetailSyntax>
- <doc:SwiftSyntax/DeclNameArgumentsSyntax>
- <doc:SwiftSyntax/DeinitializerEffectSpecifiersSyntax>
- <doc:SwiftSyntax/EnumCaseParameterClauseSyntax>
- <doc:SwiftSyntax/FunctionEffectSpecifiersSyntax>
- <doc:SwiftSyntax/FunctionParameterClauseSyntax>
- <doc:SwiftSyntax/FunctionSignatureSyntax>
- <doc:SwiftSyntax/GenericArgumentClauseSyntax>
- <doc:SwiftSyntax/GenericParameterClauseSyntax>
- <doc:SwiftSyntax/InheritanceClauseSyntax>
- <doc:SwiftSyntax/InitializerClauseSyntax>
- <doc:SwiftSyntax/KeyPathOptionalComponentSyntax>
- <doc:SwiftSyntax/KeyPathPropertyComponentSyntax>
- <doc:SwiftSyntax/KeyPathSubscriptComponentSyntax>
- <doc:SwiftSyntax/LayoutRequirementSyntax>
- <doc:SwiftSyntax/MatchingPatternConditionSyntax>
- <doc:SwiftSyntax/MemberBlockSyntax>
- <doc:SwiftSyntax/MissingSyntax>
- <doc:SwiftSyntax/NonisolatedSpecifierArgumentSyntax>
- <doc:SwiftSyntax/OperatorPrecedenceAndTypesSyntax>
- <doc:SwiftSyntax/OptionalBindingConditionSyntax>
- <doc:SwiftSyntax/PlatformVersionSyntax>
- <doc:SwiftSyntax/PoundSourceLocationArgumentsSyntax>
- <doc:SwiftSyntax/PrimaryAssociatedTypeClauseSyntax>
- <doc:SwiftSyntax/ReturnClauseSyntax>
- <doc:SwiftSyntax/SameTypeRequirementSyntax>
- <doc:SwiftSyntax/SourceFileSyntax>
- <doc:SwiftSyntax/SwitchCaseLabelSyntax>
- <doc:SwiftSyntax/SwitchDefaultLabelSyntax>
- <doc:SwiftSyntax/ThrowsClauseSyntax>
- <doc:SwiftSyntax/TypeAnnotationSyntax>
- <doc:SwiftSyntax/TypeEffectSpecifiersSyntax>
- <doc:SwiftSyntax/TypeInitializerClauseSyntax>
- <doc:SwiftSyntax/VersionTupleSyntax>
- <doc:SwiftSyntax/WhereClauseSyntax>
- <doc:SwiftSyntax/YieldedExpressionsClauseSyntax>

### Traits

- <doc:SwiftSyntax/BracedSyntax>
- <doc:SwiftSyntax/DeclGroupSyntax>
- <doc:SwiftSyntax/EffectSpecifiersSyntax>
- <doc:SwiftSyntax/FreestandingMacroExpansionSyntax>
- <doc:SwiftSyntax/NamedDeclSyntax>
- <doc:SwiftSyntax/MissingNodeSyntax>
- <doc:SwiftSyntax/ParenthesizedSyntax>
- <doc:SwiftSyntax/WithAttributesSyntax>
- <doc:SwiftSyntax/WithCodeBlockSyntax>
- <doc:SwiftSyntax/WithGenericParametersSyntax>
- <doc:SwiftSyntax/WithModifiersSyntax>
- <doc:SwiftSyntax/WithOptionalCodeBlockSyntax>
- <doc:SwiftSyntax/WithStatementsSyntax>
- <doc:SwiftSyntax/WithTrailingCommaSyntax>



### Syntax Position

- <doc:SwiftSyntax/AbsolutePosition>
- <doc:SwiftSyntax/ByteSourceRange>
- <doc:SwiftSyntax/SourceLocation>
- <doc:SwiftSyntax/SourceLocationConverter>
- <doc:SwiftSyntax/SourceRange>
- <doc:SwiftSyntax/SourceLength>

### Internals

- <doc:SwiftSyntax/SyntaxProtocol>
- <doc:SwiftSyntax/SyntaxEnum>
- <doc:SwiftSyntax/SyntaxHashable>
- <doc:SwiftSyntax/SyntaxIdentifier>
